/*
 * Decompiled with CFR 0.152.
 */
package be.re.css;

import be.re.css.Compiled;
import be.re.css.Constants;
import be.re.css.Rule;
import be.re.css.RuleComparator;
import be.re.css.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.LangCondition;
import org.w3c.css.sac.NegativeCondition;
import org.w3c.css.sac.PositionalCondition;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class Matcher
implements ContentHandler {
    private static final String DEFAULT_LANGUAGE = "en-GB";
    private Stack elements = new Stack();
    private Compiled.DFAState startState;
    private static final boolean trace = System.getProperty("be.re.css.trace") != null;

    public Matcher(Compiled styleSheet) {
        this.startState = styleSheet.startState;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    private static boolean checkAttributeCondition(Element e, AttributeCondition c, TestAttribute test) {
        if (c.getNamespaceURI() != null) {
            int index = "SAC_NO_URI".equals(c.getNamespaceURI()) ? e.attributes.getIndex(c.getLocalName()) : e.attributes.getIndex(c.getNamespaceURI(), c.getLocalName());
            return index != -1 && test.test(e.attributes, index, c);
        }
        for (int i = 0; i < e.attributes.getLength(); ++i) {
            if (!e.attributes.getLocalName(i).equals(c.getLocalName()) || !test.test(e.attributes, i, c)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkAttributeCondition(Element e, AttributeCondition c) {
        return Matcher.checkAttributeCondition(e, c, new TestAttribute(){

            public boolean test(Attributes atts, int i, AttributeCondition c) {
                return c.getValue() == null || c.getValue().equals(atts.getValue(i));
            }
        });
    }

    private static boolean checkBeginHyphenAttributeCondition(Element e, AttributeCondition c) {
        return Matcher.checkAttributeCondition(e, c, new TestAttribute(){

            public boolean test(Attributes atts, int i, AttributeCondition c) {
                return atts.getValue(i).startsWith(c.getValue() + "-") || atts.getValue(i).equals(c.getValue());
            }
        });
    }

    private static boolean checkClassCondition(Element e, AttributeCondition c) {
        String value = e.attributes.getValue("class");
        return value != null && Matcher.hasToken(value, c.getValue());
    }

    private static boolean checkCondition(Element e, Condition c) {
        switch (c.getConditionType()) {
            case 0: {
                return Matcher.checkCondition(e, ((CombinatorCondition)c).getFirstCondition()) && Matcher.checkCondition(e, ((CombinatorCondition)c).getSecondCondition());
            }
            case 4: {
                return Matcher.checkAttributeCondition(e, (AttributeCondition)c);
            }
            case 8: {
                return Matcher.checkBeginHyphenAttributeCondition(e, (AttributeCondition)c);
            }
            case 9: {
                return Matcher.checkClassCondition(e, (AttributeCondition)c);
            }
            case 5: {
                return Matcher.checkIdCondition(e, (AttributeCondition)c);
            }
            case 6: {
                return Matcher.checkLangCondition(e, (LangCondition)c);
            }
            case 2: {
                return !Matcher.checkCondition(e, ((NegativeCondition)c).getCondition());
            }
            case 7: {
                return Matcher.checkOneOfAttributeCondition(e, (AttributeCondition)c);
            }
            case 1: {
                return Matcher.checkCondition(e, ((CombinatorCondition)c).getFirstCondition()) || Matcher.checkCondition(e, ((CombinatorCondition)c).getSecondCondition());
            }
            case 3: {
                return Matcher.checkPositionalCondition(e, ((PositionalCondition)c).getPosition());
            }
            case 10: {
                return Matcher.checkPseudoClassCondition(e, (AttributeCondition)c);
            }
        }
        return false;
    }

    private static boolean checkIdCondition(Element e, AttributeCondition c) {
        for (int i = 0; i < e.attributes.getLength(); ++i) {
            if (!"ID".equals(e.attributes.getType(i)) || !c.getValue().equals(e.attributes.getValue(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean checkLangCondition(Element e, LangCondition c) {
        return e.language.startsWith(c.getLang() + "-") || e.language.equals(c.getLang());
    }

    private static boolean checkOneOfAttributeCondition(Element e, AttributeCondition c) {
        return Matcher.checkAttributeCondition(e, c, new TestAttribute(){

            public boolean test(Attributes atts, int i, AttributeCondition c) {
                return Matcher.hasToken(atts.getValue(i), c.getValue());
            }
        });
    }

    private static boolean checkPositionalCondition(Element e, int position) {
        return e.parent.children.size() == position;
    }

    private static boolean checkPseudoClassCondition(Element e, AttributeCondition c) {
        return "after".equals(c.getValue()) || "before".equals(c.getValue()) || "first-child".equals(c.getValue()) && Matcher.checkPositionalCondition(e, 0);
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        Element element = (Element)this.elements.pop();
        ((Element)this.elements.peek()).children.add(element);
        element.children = null;
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    private String getLanguage(String namespaceURI, Attributes attributes, Element parent) {
        String result = null;
        if (Constants.XHTML == namespaceURI) {
            result = attributes.getValue("lang");
        }
        if (result == null) {
            result = attributes.getValue("xml:lang");
        }
        if (result == null) {
            result = parent.language;
        }
        return result;
    }

    private static Set getSiblingStates(Collection states) {
        HashSet<Object> result = new HashSet<Object>();
        Iterator i = states.iterator();
        while (i.hasNext()) {
            Object nextState = ((Compiled.DFAState)i.next()).events.get(Compiled.SIBLING);
            if (nextState == null) continue;
            result.add(nextState);
        }
        return result;
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    private static boolean hasToken(String s, String token) {
        int i = s.indexOf(token);
        return !(i == -1 || i != 0 && s.charAt(i - 1) != ' ' || i != s.length() - token.length() && s.charAt(i + token.length()) != ' ');
    }

    public Rule[] matchingPseudoRules() {
        TreeSet result = new TreeSet(new RuleComparator());
        Iterator i = ((Element)this.elements.peek()).states.iterator();
        while (i.hasNext()) {
            result.addAll(((Compiled.DFAState)i.next()).pseudoRules);
        }
        return result.toArray(new Rule[0]);
    }

    public Rule[] matchingRules() {
        TreeSet result = new TreeSet(new RuleComparator());
        Iterator i = ((Element)this.elements.peek()).states.iterator();
        while (i.hasNext()) {
            result.addAll(((Compiled.DFAState)i.next()).rules);
        }
        return result.toArray(new Rule[0]);
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
        this.elements.clear();
        Element root = new Element("", "/");
        root.language = DEFAULT_LANGUAGE;
        this.elements.push(root);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        Element parent = (Element)this.elements.peek();
        Set currentStates = parent.states;
        Element element = new Element(namespaceURI, localName);
        element.attributes = atts;
        element.language = this.getLanguage(namespaceURI, atts, parent);
        element.parent = parent;
        this.elements.push(element);
        Matcher.traceElement(namespaceURI + "|" + localName, atts);
        Matcher.stepStates(parent.states, element);
        if (parent.children.size() > 0) {
            Matcher.stepStates(Matcher.getSiblingStates(((Element)parent.children.get(parent.children.size() - 1)).states), element);
        }
        Matcher.step(this.startState, element);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    private static void step(Compiled.DFAState state, Element element) {
        Matcher.stepOneEvent(state, element, ("".equals(element.namespaceURI) ? "*" : element.namespaceURI) + "|" + element.localName);
        if (!"".equals(element.namespaceURI)) {
            Matcher.stepOneEvent(state, element, "*|" + element.localName);
            Matcher.stepOneEvent(state, element, element.namespaceURI + "|*");
        } else {
            Matcher.stepOneEvent(state, element, "SAC_NO_URI|" + element.localName);
        }
        Matcher.stepOneEvent(state, element, Compiled.ANY_ELEMENT);
    }

    private static void stepOneEvent(Compiled.DFAState state, Element element, String name) {
        Compiled.DFAState nextState = (Compiled.DFAState)state.events.get(name);
        if (nextState != null) {
            Matcher.traceTransition(state, nextState, name);
            element.states.add(nextState);
            Matcher.stepThroughConditions(nextState, element);
        }
    }

    private static void stepStates(Collection states, Element element) {
        Iterator i = states.iterator();
        while (i.hasNext()) {
            Matcher.step((Compiled.DFAState)i.next(), element);
        }
    }

    private static void stepThroughConditions(Compiled.DFAState state, Element element) {
        Iterator i = state.candidateConditions.keySet().iterator();
        while (i.hasNext()) {
            Condition c = (Condition)i.next();
            Compiled.DFAState nextState = (Compiled.DFAState)state.candidateConditions.get(c);
            if (nextState == null || !Matcher.checkCondition(element, c)) continue;
            Matcher.traceTransition(state, nextState, c);
            element.states.add(nextState);
        }
    }

    private static void traceElement(String qName, Attributes atts) {
        if (trace) {
            System.out.print(qName + ": ");
            for (int i = 0; i < atts.getLength(); ++i) {
                System.out.print(atts.getQName(i) + "=" + atts.getValue(i) + " ");
            }
            System.out.println();
        }
    }

    private static void traceTransition(Compiled.DFAState from, Compiled.DFAState to, Object event) {
        if (trace) {
            System.out.println(String.valueOf(from.state) + " -> " + String.valueOf(to.state) + ": " + (event instanceof Condition ? Util.conditionText((Condition)event) : event.toString()));
        }
    }

    private static interface TestAttribute {
        public boolean test(Attributes var1, int var2, AttributeCondition var3);
    }

    private static class Element {
        private Attributes attributes;
        private List children = new ArrayList();
        private String language;
        private String localName;
        private String namespaceURI;
        private Element parent;
        private Set states = new HashSet();

        private Element(String namespaceURI, String localName) {
            this.namespaceURI = namespaceURI != null ? namespaceURI : "";
            this.localName = localName;
        }
    }
}

