/*
 * Decompiled with CFR 0.152.
 */
package be.re.css;

import be.re.css.Util;
import java.io.File;
import java.io.PrintWriter;
import java.net.URL;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CharacterDataSelector;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.NegativeSelector;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.ProcessingInstructionSelector;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.css.sac.helpers.ParserFactory;

public class TestSAC {
    private static final Tuple[] tuples = new Tuple[]{new Tuple(0, "SAC_OPERATOR_COMMA"), new Tuple(1, "SAC_OPERATOR_PLUS"), new Tuple(2, "SAC_OPERATOR_MINUS"), new Tuple(3, "SAC_OPERATOR_MULTIPLY"), new Tuple(4, "SAC_OPERATOR_SLASH"), new Tuple(5, "SAC_OPERATOR_MOD"), new Tuple(6, "SAC_OPERATOR_EXP"), new Tuple(7, "SAC_OPERATOR_LT"), new Tuple(8, "SAC_OPERATOR_GT"), new Tuple(9, "SAC_OPERATOR_LE"), new Tuple(10, "SAC_OPERATOR_GE"), new Tuple(11, "SAC_OPERATOR_TILDE"), new Tuple(12, "SAC_INHERIT"), new Tuple(13, "SAC_INTEGER"), new Tuple(14, "SAC_REAL"), new Tuple(15, "SAC_EM"), new Tuple(16, "SAC_EX"), new Tuple(17, "SAC_PIXEL"), new Tuple(18, "SAC_INCH"), new Tuple(19, "SAC_CENTIMETER"), new Tuple(20, "SAC_MILLIMETER"), new Tuple(21, "SAC_POINT"), new Tuple(22, "SAC_PICA"), new Tuple(23, "SAC_PERCENTAGE"), new Tuple(24, "SAC_URI"), new Tuple(25, "SAC_COUNTER_FUNCTION"), new Tuple(26, "SAC_COUNTERS_FUNCTION"), new Tuple(27, "SAC_RGBCOLOR"), new Tuple(28, "SAC_DEGREE"), new Tuple(29, "SAC_GRADIAN"), new Tuple(30, "SAC_RADIAN"), new Tuple(31, "SAC_MILLISECOND"), new Tuple(32, "SAC_SECOND"), new Tuple(33, "SAC_HERTZ"), new Tuple(34, "SAC_KILOHERTZ"), new Tuple(35, "SAC_IDENT"), new Tuple(36, "SAC_STRING_VALUE"), new Tuple(37, "SAC_ATTR"), new Tuple(38, "SAC_RECT_FUNCTION"), new Tuple(39, "SAC_UNICODERANGE"), new Tuple(40, "SAC_SUB_EXPRESSION"), new Tuple(41, "SAC_FUNCTION"), new Tuple(42, "SAC_DIMENSION")};

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: be.re.css.TestSAC url_or_filename");
            return;
        }
        Parser parser = new ParserFactory().makeParser();
        PrintWriter out = new PrintWriter(System.out);
        parser.setDocumentHandler(new SACWriter(out, new File(args[0]).toURL()));
        parser.parseStyleSheet(be.re.net.Util.isUrl(args[0]) ? new URL(args[0]).toString() : be.re.net.Util.fileToUrl(new File(args[0])).toString());
        out.flush();
    }

    private static class Tuple {
        private int id;
        private String name;

        private Tuple(int id, String name) {
            this.id = id;
            this.name = name;
        }
    }

    private static class SACWriter
    implements DocumentHandler {
        private URL baseUrl;
        private PrintWriter out;

        private SACWriter(PrintWriter out, URL baseUrl) {
            this.out = out;
            this.baseUrl = baseUrl;
        }

        public void comment(String text) throws CSSException {
            this.out.println("comment: " + text);
        }

        public void endDocument(InputSource source) throws CSSException {
            this.out.println("end document");
        }

        public void endFontFace() throws CSSException {
            this.out.println("end font face");
        }

        public void endMedia(SACMediaList media) throws CSSException {
            this.out.println("end media");
        }

        public void endPage(String name, String pseudePage) throws CSSException {
            this.out.println("end page");
        }

        public void endSelector(SelectorList selectors) throws CSSException {
            this.out.println("end selector");
        }

        private static String enumerateUnits(LexicalUnit value) {
            return SACWriter.lexicalUnitTypeToString(value) + (value.getNextLexicalUnit() != null ? ", " + SACWriter.enumerateUnits(value.getNextLexicalUnit()) : "");
        }

        public void ignorableAtRule(String atRule) throws CSSException {
            this.out.println("ignorable at-rule: " + atRule);
        }

        public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
            this.out.println("import: " + uri);
            try {
                Parser parser = new ParserFactory().makeParser();
                parser.setDocumentHandler(new SACWriter(this.out, new URL(this.baseUrl, uri)));
                parser.parseStyleSheet(new URL(this.baseUrl, uri).toString());
            }
            catch (Exception e) {
                throw new CSSException(e);
            }
        }

        private static String lexicalUnitTypeToString(LexicalUnit value) {
            for (int i = 0; i < tuples.length; ++i) {
                if (tuples[i].id != value.getLexicalUnitType()) continue;
                return tuples[i].name;
            }
            return "unknown";
        }

        public void namespaceDeclaration(String prefix, String uri) throws CSSException {
            this.out.println("namespace declaration: " + prefix + ", " + uri);
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            this.out.println("property: " + name + ": " + Util.lexicalUnitToString(value, false, null) + "(" + SACWriter.enumerateUnits(value) + "), " + String.valueOf(important));
        }

        private String selectorText(Selector selector) {
            switch (selector.getSelectorType()) {
                case 1: {
                    return "(any)";
                }
                case 6: {
                    return "(cdata: " + ((CharacterDataSelector)selector).getData() + ")";
                }
                case 11: {
                    return "(child: " + this.selectorText(((DescendantSelector)selector).getAncestorSelector()) + " " + this.selectorText(((DescendantSelector)selector).getSimpleSelector()) + ")";
                }
                case 8: {
                    return "(comment: " + ((CharacterDataSelector)selector).getData() + ")";
                }
                case 0: {
                    return "(conditional: " + Util.conditionText(((ConditionalSelector)selector).getCondition()) + " " + this.selectorText(((ConditionalSelector)selector).getSimpleSelector()) + ")";
                }
                case 10: {
                    return "(descendant: " + this.selectorText(((DescendantSelector)selector).getAncestorSelector()) + " " + this.selectorText(((DescendantSelector)selector).getSimpleSelector()) + ")";
                }
                case 12: {
                    return "(sibling: " + this.selectorText(((SiblingSelector)selector).getSelector()) + " " + this.selectorText(((SiblingSelector)selector).getSiblingSelector()) + ")";
                }
                case 4: {
                    return "(element: " + (((ElementSelector)selector).getNamespaceURI() != null ? ((ElementSelector)selector).getNamespaceURI() + "#" : "") + ((ElementSelector)selector).getLocalName() + ")";
                }
                case 3: {
                    return "(negative: " + this.selectorText(((NegativeSelector)selector).getSimpleSelector()) + ")";
                }
                case 7: {
                    return "(pi: (" + ((ProcessingInstructionSelector)selector).getData() + ") (" + ((ProcessingInstructionSelector)selector).getTarget() + "))";
                }
                case 9: {
                    return "(pseudo: " + (((ElementSelector)selector).getNamespaceURI() != null ? ((ElementSelector)selector).getNamespaceURI() + "#" : "") + ((ElementSelector)selector).getLocalName() + ")";
                }
                case 2: {
                    return "(root)";
                }
                case 5: {
                    return "(text: " + ((CharacterDataSelector)selector).getData() + ")";
                }
            }
            return "(unknown)";
        }

        public void startDocument(InputSource source) throws CSSException {
            this.out.println("start document");
        }

        public void startFontFace() throws CSSException {
            this.out.println("start font face");
        }

        public void startMedia(SACMediaList media) throws CSSException {
            this.out.print("start media:");
            for (int i = 0; i < media.getLength(); ++i) {
                this.out.print(" " + media.item(i));
            }
            this.out.println();
        }

        public void startPage(String name, String pseudoPage) throws CSSException {
            this.out.println("start page: " + name + ", " + pseudoPage);
        }

        public void startSelector(SelectorList selectors) throws CSSException {
            this.out.print("start selector:");
            for (int i = 0; i < selectors.getLength(); ++i) {
                this.out.print(" " + this.selectorText(selectors.item(i)));
            }
            this.out.println();
        }
    }
}

