# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class FeatureSupportRequest(Model):
    """Base class for feature request.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureBackupGoalFeatureSupportRequest,
    AzureVMResourceFeatureSupportRequest

    All required parameters must be populated in order to send to Azure.

    :param feature_type: Required. Constant filled by server.
    :type feature_type: str
    """

    _validation = {
        'feature_type': {'required': True},
    }

    _attribute_map = {
        'feature_type': {'key': 'featureType', 'type': 'str'},
    }

    _subtype_map = {
        'feature_type': {'AzureBackupGoals': 'AzureBackupGoalFeatureSupportRequest', 'AzureVMResourceBackup': 'AzureVMResourceFeatureSupportRequest'}
    }

    def __init__(self, **kwargs):
        super(FeatureSupportRequest, self).__init__(**kwargs)
        self.feature_type = None


class AzureBackupGoalFeatureSupportRequest(FeatureSupportRequest):
    """Azure backup goal feature specific request.

    All required parameters must be populated in order to send to Azure.

    :param feature_type: Required. Constant filled by server.
    :type feature_type: str
    """

    _validation = {
        'feature_type': {'required': True},
    }

    _attribute_map = {
        'feature_type': {'key': 'featureType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureBackupGoalFeatureSupportRequest, self).__init__(**kwargs)
        self.feature_type = 'AzureBackupGoals'


class ProtectionContainer(Model):
    """Base class for container with backup items. Containers with specific
    workloads are derived from this class.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureSqlContainer, AzureStorageContainer,
    AzureWorkloadContainer, DpmContainer, GenericContainer, IaaSVMContainer,
    MabContainer

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param registration_status: Status of registration of the container with
     the Recovery Services Vault.
    :type registration_status: str
    :param health_status: Status of health of the container.
    :type health_status: str
    :param container_type: Required. Constant filled by server.
    :type container_type: str
    """

    _validation = {
        'container_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'container_type': {'key': 'containerType', 'type': 'str'},
    }

    _subtype_map = {
        'container_type': {'AzureSqlContainer': 'AzureSqlContainer', 'StorageContainer': 'AzureStorageContainer', 'AzureWorkloadContainer': 'AzureWorkloadContainer', 'DPMContainer': 'DpmContainer', 'GenericContainer': 'GenericContainer', 'IaaSVMContainer': 'IaaSVMContainer', 'Windows': 'MabContainer'}
    }

    def __init__(self, **kwargs):
        super(ProtectionContainer, self).__init__(**kwargs)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.backup_management_type = kwargs.get('backup_management_type', None)
        self.registration_status = kwargs.get('registration_status', None)
        self.health_status = kwargs.get('health_status', None)
        self.container_type = None


class DpmContainer(ProtectionContainer):
    """DPM workload-specific protection container.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureBackupServerContainer

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param registration_status: Status of registration of the container with
     the Recovery Services Vault.
    :type registration_status: str
    :param health_status: Status of health of the container.
    :type health_status: str
    :param container_type: Required. Constant filled by server.
    :type container_type: str
    :param can_re_register: Specifies whether the container is re-registrable.
    :type can_re_register: bool
    :param container_id: ID of container.
    :type container_id: str
    :param protected_item_count: Number of protected items in the BackupEngine
    :type protected_item_count: long
    :param dpm_agent_version: Backup engine Agent version
    :type dpm_agent_version: str
    :param dpm_servers: List of BackupEngines protecting the container
    :type dpm_servers: list[str]
    :param upgrade_available: To check if upgrade available
    :type upgrade_available: bool
    :param protection_status: Protection status of the container.
    :type protection_status: str
    :param extended_info: Extended Info of the container.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.DPMContainerExtendedInfo
    """

    _validation = {
        'container_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'container_type': {'key': 'containerType', 'type': 'str'},
        'can_re_register': {'key': 'canReRegister', 'type': 'bool'},
        'container_id': {'key': 'containerId', 'type': 'str'},
        'protected_item_count': {'key': 'protectedItemCount', 'type': 'long'},
        'dpm_agent_version': {'key': 'dpmAgentVersion', 'type': 'str'},
        'dpm_servers': {'key': 'dpmServers', 'type': '[str]'},
        'upgrade_available': {'key': 'upgradeAvailable', 'type': 'bool'},
        'protection_status': {'key': 'protectionStatus', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'DPMContainerExtendedInfo'},
    }

    _subtype_map = {
        'container_type': {'AzureBackupServerContainer': 'AzureBackupServerContainer'}
    }

    def __init__(self, **kwargs):
        super(DpmContainer, self).__init__(**kwargs)
        self.can_re_register = kwargs.get('can_re_register', None)
        self.container_id = kwargs.get('container_id', None)
        self.protected_item_count = kwargs.get('protected_item_count', None)
        self.dpm_agent_version = kwargs.get('dpm_agent_version', None)
        self.dpm_servers = kwargs.get('dpm_servers', None)
        self.upgrade_available = kwargs.get('upgrade_available', None)
        self.protection_status = kwargs.get('protection_status', None)
        self.extended_info = kwargs.get('extended_info', None)
        self.container_type = 'DPMContainer'


class AzureBackupServerContainer(DpmContainer):
    """AzureBackupServer (DPMVenus) workload-specific protection container.

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param registration_status: Status of registration of the container with
     the Recovery Services Vault.
    :type registration_status: str
    :param health_status: Status of health of the container.
    :type health_status: str
    :param container_type: Required. Constant filled by server.
    :type container_type: str
    :param can_re_register: Specifies whether the container is re-registrable.
    :type can_re_register: bool
    :param container_id: ID of container.
    :type container_id: str
    :param protected_item_count: Number of protected items in the BackupEngine
    :type protected_item_count: long
    :param dpm_agent_version: Backup engine Agent version
    :type dpm_agent_version: str
    :param dpm_servers: List of BackupEngines protecting the container
    :type dpm_servers: list[str]
    :param upgrade_available: To check if upgrade available
    :type upgrade_available: bool
    :param protection_status: Protection status of the container.
    :type protection_status: str
    :param extended_info: Extended Info of the container.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.DPMContainerExtendedInfo
    """

    _validation = {
        'container_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'container_type': {'key': 'containerType', 'type': 'str'},
        'can_re_register': {'key': 'canReRegister', 'type': 'bool'},
        'container_id': {'key': 'containerId', 'type': 'str'},
        'protected_item_count': {'key': 'protectedItemCount', 'type': 'long'},
        'dpm_agent_version': {'key': 'dpmAgentVersion', 'type': 'str'},
        'dpm_servers': {'key': 'dpmServers', 'type': '[str]'},
        'upgrade_available': {'key': 'upgradeAvailable', 'type': 'bool'},
        'protection_status': {'key': 'protectionStatus', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'DPMContainerExtendedInfo'},
    }

    def __init__(self, **kwargs):
        super(AzureBackupServerContainer, self).__init__(**kwargs)
        self.container_type = 'AzureBackupServerContainer'


class BackupEngineBase(Model):
    """The base backup engine class. All workload specific backup engines derive
    from this class.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureBackupServerEngine, DpmBackupEngine

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the backup engine.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the backup
     engine. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param registration_status: Registration status of the backup engine with
     the Recovery Services Vault.
    :type registration_status: str
    :param backup_engine_state: Status of the backup engine with the Recovery
     Services Vault. = {Active/Deleting/DeleteFailed}
    :type backup_engine_state: str
    :param health_status: Backup status of the backup engine.
    :type health_status: str
    :param can_re_register: Flag indicating if the backup engine be
     registered, once already registered.
    :type can_re_register: bool
    :param backup_engine_id: ID of the backup engine.
    :type backup_engine_id: str
    :param dpm_version: Backup engine version
    :type dpm_version: str
    :param azure_backup_agent_version: Backup agent version
    :type azure_backup_agent_version: str
    :param is_azure_backup_agent_upgrade_available: To check if backup agent
     upgrade available
    :type is_azure_backup_agent_upgrade_available: bool
    :param is_dpm_upgrade_available: To check if backup engine upgrade
     available
    :type is_dpm_upgrade_available: bool
    :param extended_info: Extended info of the backupengine
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.BackupEngineExtendedInfo
    :param backup_engine_type: Required. Constant filled by server.
    :type backup_engine_type: str
    """

    _validation = {
        'backup_engine_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
        'backup_engine_state': {'key': 'backupEngineState', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'can_re_register': {'key': 'canReRegister', 'type': 'bool'},
        'backup_engine_id': {'key': 'backupEngineId', 'type': 'str'},
        'dpm_version': {'key': 'dpmVersion', 'type': 'str'},
        'azure_backup_agent_version': {'key': 'azureBackupAgentVersion', 'type': 'str'},
        'is_azure_backup_agent_upgrade_available': {'key': 'isAzureBackupAgentUpgradeAvailable', 'type': 'bool'},
        'is_dpm_upgrade_available': {'key': 'isDpmUpgradeAvailable', 'type': 'bool'},
        'extended_info': {'key': 'extendedInfo', 'type': 'BackupEngineExtendedInfo'},
        'backup_engine_type': {'key': 'backupEngineType', 'type': 'str'},
    }

    _subtype_map = {
        'backup_engine_type': {'AzureBackupServerEngine': 'AzureBackupServerEngine', 'DpmBackupEngine': 'DpmBackupEngine'}
    }

    def __init__(self, **kwargs):
        super(BackupEngineBase, self).__init__(**kwargs)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.backup_management_type = kwargs.get('backup_management_type', None)
        self.registration_status = kwargs.get('registration_status', None)
        self.backup_engine_state = kwargs.get('backup_engine_state', None)
        self.health_status = kwargs.get('health_status', None)
        self.can_re_register = kwargs.get('can_re_register', None)
        self.backup_engine_id = kwargs.get('backup_engine_id', None)
        self.dpm_version = kwargs.get('dpm_version', None)
        self.azure_backup_agent_version = kwargs.get('azure_backup_agent_version', None)
        self.is_azure_backup_agent_upgrade_available = kwargs.get('is_azure_backup_agent_upgrade_available', None)
        self.is_dpm_upgrade_available = kwargs.get('is_dpm_upgrade_available', None)
        self.extended_info = kwargs.get('extended_info', None)
        self.backup_engine_type = None


class AzureBackupServerEngine(BackupEngineBase):
    """Backup engine type when Azure Backup Server is used to manage the backups.

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the backup engine.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the backup
     engine. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param registration_status: Registration status of the backup engine with
     the Recovery Services Vault.
    :type registration_status: str
    :param backup_engine_state: Status of the backup engine with the Recovery
     Services Vault. = {Active/Deleting/DeleteFailed}
    :type backup_engine_state: str
    :param health_status: Backup status of the backup engine.
    :type health_status: str
    :param can_re_register: Flag indicating if the backup engine be
     registered, once already registered.
    :type can_re_register: bool
    :param backup_engine_id: ID of the backup engine.
    :type backup_engine_id: str
    :param dpm_version: Backup engine version
    :type dpm_version: str
    :param azure_backup_agent_version: Backup agent version
    :type azure_backup_agent_version: str
    :param is_azure_backup_agent_upgrade_available: To check if backup agent
     upgrade available
    :type is_azure_backup_agent_upgrade_available: bool
    :param is_dpm_upgrade_available: To check if backup engine upgrade
     available
    :type is_dpm_upgrade_available: bool
    :param extended_info: Extended info of the backupengine
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.BackupEngineExtendedInfo
    :param backup_engine_type: Required. Constant filled by server.
    :type backup_engine_type: str
    """

    _validation = {
        'backup_engine_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
        'backup_engine_state': {'key': 'backupEngineState', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'can_re_register': {'key': 'canReRegister', 'type': 'bool'},
        'backup_engine_id': {'key': 'backupEngineId', 'type': 'str'},
        'dpm_version': {'key': 'dpmVersion', 'type': 'str'},
        'azure_backup_agent_version': {'key': 'azureBackupAgentVersion', 'type': 'str'},
        'is_azure_backup_agent_upgrade_available': {'key': 'isAzureBackupAgentUpgradeAvailable', 'type': 'bool'},
        'is_dpm_upgrade_available': {'key': 'isDpmUpgradeAvailable', 'type': 'bool'},
        'extended_info': {'key': 'extendedInfo', 'type': 'BackupEngineExtendedInfo'},
        'backup_engine_type': {'key': 'backupEngineType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureBackupServerEngine, self).__init__(**kwargs)
        self.backup_engine_type = 'AzureBackupServerEngine'


class BackupRequest(Model):
    """Base class for backup request. Workload-specific backup requests are
    derived from this class.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureFileShareBackupRequest, AzureWorkloadBackupRequest,
    IaasVMBackupRequest

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'AzureFileShareBackupRequest': 'AzureFileShareBackupRequest', 'AzureWorkloadBackupRequest': 'AzureWorkloadBackupRequest', 'IaasVMBackupRequest': 'IaasVMBackupRequest'}
    }

    def __init__(self, **kwargs):
        super(BackupRequest, self).__init__(**kwargs)
        self.object_type = None


class AzureFileShareBackupRequest(BackupRequest):
    """AzureFileShare workload-specific backup request.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param recovery_point_expiry_time_in_utc: Backup copy will expire after
     the time specified (UTC).
    :type recovery_point_expiry_time_in_utc: datetime
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_point_expiry_time_in_utc': {'key': 'recoveryPointExpiryTimeInUTC', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(AzureFileShareBackupRequest, self).__init__(**kwargs)
        self.recovery_point_expiry_time_in_utc = kwargs.get('recovery_point_expiry_time_in_utc', None)
        self.object_type = 'AzureFileShareBackupRequest'


class WorkloadProtectableItem(Model):
    """Base class for backup item. Workload-specific backup items are derived from
    this class.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureFileShareProtectableItem,
    AzureVmWorkloadProtectableItem, IaaSVMProtectableItem

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protectable_item_type: Required. Constant filled by server.
    :type protectable_item_type: str
    """

    _validation = {
        'protectable_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protectable_item_type': {'key': 'protectableItemType', 'type': 'str'},
    }

    _subtype_map = {
        'protectable_item_type': {'AzureFileShare': 'AzureFileShareProtectableItem', 'AzureVmWorkloadProtectableItem': 'AzureVmWorkloadProtectableItem', 'IaaSVMProtectableItem': 'IaaSVMProtectableItem'}
    }

    def __init__(self, **kwargs):
        super(WorkloadProtectableItem, self).__init__(**kwargs)
        self.backup_management_type = kwargs.get('backup_management_type', None)
        self.workload_type = kwargs.get('workload_type', None)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.protection_state = kwargs.get('protection_state', None)
        self.protectable_item_type = None


class AzureFileShareProtectableItem(WorkloadProtectableItem):
    """Protectable item for Azure Fileshare workloads.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protectable_item_type: Required. Constant filled by server.
    :type protectable_item_type: str
    :param parent_container_fabric_id: Full Fabric ID of container to which
     this protectable item belongs. For example, ARM ID.
    :type parent_container_fabric_id: str
    :param parent_container_friendly_name: Friendly name of container to which
     this protectable item belongs.
    :type parent_container_friendly_name: str
    :param azure_file_share_type: File Share type XSync or XSMB. Possible
     values include: 'Invalid', 'XSMB', 'XSync'
    :type azure_file_share_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.AzureFileShareType
    """

    _validation = {
        'protectable_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protectable_item_type': {'key': 'protectableItemType', 'type': 'str'},
        'parent_container_fabric_id': {'key': 'parentContainerFabricId', 'type': 'str'},
        'parent_container_friendly_name': {'key': 'parentContainerFriendlyName', 'type': 'str'},
        'azure_file_share_type': {'key': 'azureFileShareType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureFileShareProtectableItem, self).__init__(**kwargs)
        self.parent_container_fabric_id = kwargs.get('parent_container_fabric_id', None)
        self.parent_container_friendly_name = kwargs.get('parent_container_friendly_name', None)
        self.azure_file_share_type = kwargs.get('azure_file_share_type', None)
        self.protectable_item_type = 'AzureFileShare'


class ProtectedItem(Model):
    """Base class for backup items.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureFileshareProtectedItem, AzureIaaSVMProtectedItem,
    AzureSqlProtectedItem, AzureVmWorkloadProtectedItem, DPMProtectedItem,
    GenericProtectedItem, MabFileFolderProtectedItem

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param workload_type: Type of workload this item represents. Possible
     values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB',
     'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataSourceType
    :param container_name: Unique name of container
    :type container_name: str
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param last_recovery_point: Timestamp when the last (latest) backup copy
     was created for this backup item.
    :type last_recovery_point: datetime
    :param backup_set_name: Name of the backup set the backup item belongs to
    :type backup_set_name: str
    :param create_mode: Create mode to indicate recovery of existing soft
     deleted data source or creation of new data source. Possible values
     include: 'Invalid', 'Default', 'Recover'
    :type create_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.CreateMode
    :param deferred_delete_time_in_utc: Time for deferred deletion in UTC
    :type deferred_delete_time_in_utc: datetime
    :param is_scheduled_for_deferred_delete: Flag to identify whether the DS
     is scheduled for deferred delete
    :type is_scheduled_for_deferred_delete: bool
    :param deferred_delete_time_remaining: Time remaining before the DS marked
     for deferred delete is permanently deleted
    :type deferred_delete_time_remaining: str
    :param is_deferred_delete_schedule_upcoming: Flag to identify whether the
     deferred deleted DS is to be purged soon
    :type is_deferred_delete_schedule_upcoming: bool
    :param is_rehydrate: Flag to identify that deferred deleted DS is to be
     moved into Pause state
    :type is_rehydrate: bool
    :param protected_item_type: Required. Constant filled by server.
    :type protected_item_type: str
    """

    _validation = {
        'protected_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'last_recovery_point': {'key': 'lastRecoveryPoint', 'type': 'iso-8601'},
        'backup_set_name': {'key': 'backupSetName', 'type': 'str'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'deferred_delete_time_in_utc': {'key': 'deferredDeleteTimeInUTC', 'type': 'iso-8601'},
        'is_scheduled_for_deferred_delete': {'key': 'isScheduledForDeferredDelete', 'type': 'bool'},
        'deferred_delete_time_remaining': {'key': 'deferredDeleteTimeRemaining', 'type': 'str'},
        'is_deferred_delete_schedule_upcoming': {'key': 'isDeferredDeleteScheduleUpcoming', 'type': 'bool'},
        'is_rehydrate': {'key': 'isRehydrate', 'type': 'bool'},
        'protected_item_type': {'key': 'protectedItemType', 'type': 'str'},
    }

    _subtype_map = {
        'protected_item_type': {'AzureFileShareProtectedItem': 'AzureFileshareProtectedItem', 'AzureIaaSVMProtectedItem': 'AzureIaaSVMProtectedItem', 'Microsoft.Sql/servers/databases': 'AzureSqlProtectedItem', 'AzureVmWorkloadProtectedItem': 'AzureVmWorkloadProtectedItem', 'DPMProtectedItem': 'DPMProtectedItem', 'GenericProtectedItem': 'GenericProtectedItem', 'MabFileFolderProtectedItem': 'MabFileFolderProtectedItem'}
    }

    def __init__(self, **kwargs):
        super(ProtectedItem, self).__init__(**kwargs)
        self.backup_management_type = kwargs.get('backup_management_type', None)
        self.workload_type = kwargs.get('workload_type', None)
        self.container_name = kwargs.get('container_name', None)
        self.source_resource_id = kwargs.get('source_resource_id', None)
        self.policy_id = kwargs.get('policy_id', None)
        self.last_recovery_point = kwargs.get('last_recovery_point', None)
        self.backup_set_name = kwargs.get('backup_set_name', None)
        self.create_mode = kwargs.get('create_mode', None)
        self.deferred_delete_time_in_utc = kwargs.get('deferred_delete_time_in_utc', None)
        self.is_scheduled_for_deferred_delete = kwargs.get('is_scheduled_for_deferred_delete', None)
        self.deferred_delete_time_remaining = kwargs.get('deferred_delete_time_remaining', None)
        self.is_deferred_delete_schedule_upcoming = kwargs.get('is_deferred_delete_schedule_upcoming', None)
        self.is_rehydrate = kwargs.get('is_rehydrate', None)
        self.protected_item_type = None


class AzureFileshareProtectedItem(ProtectedItem):
    """Azure File Share workload-specific backup item.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param workload_type: Type of workload this item represents. Possible
     values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB',
     'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataSourceType
    :param container_name: Unique name of container
    :type container_name: str
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param last_recovery_point: Timestamp when the last (latest) backup copy
     was created for this backup item.
    :type last_recovery_point: datetime
    :param backup_set_name: Name of the backup set the backup item belongs to
    :type backup_set_name: str
    :param create_mode: Create mode to indicate recovery of existing soft
     deleted data source or creation of new data source. Possible values
     include: 'Invalid', 'Default', 'Recover'
    :type create_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.CreateMode
    :param deferred_delete_time_in_utc: Time for deferred deletion in UTC
    :type deferred_delete_time_in_utc: datetime
    :param is_scheduled_for_deferred_delete: Flag to identify whether the DS
     is scheduled for deferred delete
    :type is_scheduled_for_deferred_delete: bool
    :param deferred_delete_time_remaining: Time remaining before the DS marked
     for deferred delete is permanently deleted
    :type deferred_delete_time_remaining: str
    :param is_deferred_delete_schedule_upcoming: Flag to identify whether the
     deferred deleted DS is to be purged soon
    :type is_deferred_delete_schedule_upcoming: bool
    :param is_rehydrate: Flag to identify that deferred deleted DS is to be
     moved into Pause state
    :type is_rehydrate: bool
    :param protected_item_type: Required. Constant filled by server.
    :type protected_item_type: str
    :param friendly_name: Friendly name of the fileshare represented by this
     backup item.
    :type friendly_name: str
    :param protection_status: Backup status of this backup item.
    :type protection_status: str
    :param protection_state: Backup state of this backup item. Possible values
     include: 'Invalid', 'IRPending', 'Protected', 'ProtectionError',
     'ProtectionStopped', 'ProtectionPaused'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionState
    :param health_status: backups running status for this backup item.
     Possible values include: 'Passed', 'ActionRequired', 'ActionSuggested',
     'Invalid'
    :type health_status: str or
     ~azure.mgmt.recoveryservicesbackup.models.HealthStatus
    :param last_backup_status: Last backup operation status. Possible values:
     Healthy, Unhealthy.
    :type last_backup_status: str
    :param last_backup_time: Timestamp of the last backup operation on this
     backup item.
    :type last_backup_time: datetime
    :param extended_info: Additional information with this backup item.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureFileshareProtectedItemExtendedInfo
    """

    _validation = {
        'protected_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'last_recovery_point': {'key': 'lastRecoveryPoint', 'type': 'iso-8601'},
        'backup_set_name': {'key': 'backupSetName', 'type': 'str'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'deferred_delete_time_in_utc': {'key': 'deferredDeleteTimeInUTC', 'type': 'iso-8601'},
        'is_scheduled_for_deferred_delete': {'key': 'isScheduledForDeferredDelete', 'type': 'bool'},
        'deferred_delete_time_remaining': {'key': 'deferredDeleteTimeRemaining', 'type': 'str'},
        'is_deferred_delete_schedule_upcoming': {'key': 'isDeferredDeleteScheduleUpcoming', 'type': 'bool'},
        'is_rehydrate': {'key': 'isRehydrate', 'type': 'bool'},
        'protected_item_type': {'key': 'protectedItemType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_status': {'key': 'protectionStatus', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'last_backup_status': {'key': 'lastBackupStatus', 'type': 'str'},
        'last_backup_time': {'key': 'lastBackupTime', 'type': 'iso-8601'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureFileshareProtectedItemExtendedInfo'},
    }

    def __init__(self, **kwargs):
        super(AzureFileshareProtectedItem, self).__init__(**kwargs)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.protection_status = kwargs.get('protection_status', None)
        self.protection_state = kwargs.get('protection_state', None)
        self.health_status = kwargs.get('health_status', None)
        self.last_backup_status = kwargs.get('last_backup_status', None)
        self.last_backup_time = kwargs.get('last_backup_time', None)
        self.extended_info = kwargs.get('extended_info', None)
        self.protected_item_type = 'AzureFileShareProtectedItem'


class AzureFileshareProtectedItemExtendedInfo(Model):
    """Additional information about Azure File Share backup item.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param oldest_recovery_point: The oldest backup copy available for this
     item in the service.
    :type oldest_recovery_point: datetime
    :param recovery_point_count: Number of available backup copies associated
     with this backup item.
    :type recovery_point_count: int
    :param policy_state: Indicates consistency of policy object and policy
     applied to this backup item.
    :type policy_state: str
    :ivar resource_state: Indicates the state of this resource. Possible
     values are from enum ResourceState {Invalid, Active, SoftDeleted, Deleted}
    :vartype resource_state: str
    :ivar resource_state_sync_time: The resource state sync time for this
     backup item.
    :vartype resource_state_sync_time: datetime
    """

    _validation = {
        'resource_state': {'readonly': True},
        'resource_state_sync_time': {'readonly': True},
    }

    _attribute_map = {
        'oldest_recovery_point': {'key': 'oldestRecoveryPoint', 'type': 'iso-8601'},
        'recovery_point_count': {'key': 'recoveryPointCount', 'type': 'int'},
        'policy_state': {'key': 'policyState', 'type': 'str'},
        'resource_state': {'key': 'resourceState', 'type': 'str'},
        'resource_state_sync_time': {'key': 'resourceStateSyncTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(AzureFileshareProtectedItemExtendedInfo, self).__init__(**kwargs)
        self.oldest_recovery_point = kwargs.get('oldest_recovery_point', None)
        self.recovery_point_count = kwargs.get('recovery_point_count', None)
        self.policy_state = kwargs.get('policy_state', None)
        self.resource_state = None
        self.resource_state_sync_time = None


class ProtectionPolicy(Model):
    """Base class for backup policy. Workload-specific backup policies are derived
    from this class.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureVmWorkloadProtectionPolicy,
    AzureFileShareProtectionPolicy, AzureIaaSVMProtectionPolicy,
    AzureSqlProtectionPolicy, GenericProtectionPolicy, MabProtectionPolicy

    All required parameters must be populated in order to send to Azure.

    :param protected_items_count: Number of items associated with this policy.
    :type protected_items_count: int
    :param backup_management_type: Required. Constant filled by server.
    :type backup_management_type: str
    """

    _validation = {
        'backup_management_type': {'required': True},
    }

    _attribute_map = {
        'protected_items_count': {'key': 'protectedItemsCount', 'type': 'int'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
    }

    _subtype_map = {
        'backup_management_type': {'AzureWorkload': 'AzureVmWorkloadProtectionPolicy', 'AzureStorage': 'AzureFileShareProtectionPolicy', 'AzureIaasVM': 'AzureIaaSVMProtectionPolicy', 'AzureSql': 'AzureSqlProtectionPolicy', 'GenericProtectionPolicy': 'GenericProtectionPolicy', 'MAB': 'MabProtectionPolicy'}
    }

    def __init__(self, **kwargs):
        super(ProtectionPolicy, self).__init__(**kwargs)
        self.protected_items_count = kwargs.get('protected_items_count', None)
        self.backup_management_type = None


class AzureFileShareProtectionPolicy(ProtectionPolicy):
    """AzureStorage backup policy.

    All required parameters must be populated in order to send to Azure.

    :param protected_items_count: Number of items associated with this policy.
    :type protected_items_count: int
    :param backup_management_type: Required. Constant filled by server.
    :type backup_management_type: str
    :param work_load_type: Type of workload for the backup management.
     Possible values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb',
     'SQLDB', 'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type work_load_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.WorkloadType
    :param schedule_policy: Backup schedule specified as part of backup
     policy.
    :type schedule_policy:
     ~azure.mgmt.recoveryservicesbackup.models.SchedulePolicy
    :param retention_policy: Retention policy with the details on backup copy
     retention ranges.
    :type retention_policy:
     ~azure.mgmt.recoveryservicesbackup.models.RetentionPolicy
    :param time_zone: TimeZone optional input as string. For example: TimeZone
     = "Pacific Standard Time".
    :type time_zone: str
    """

    _validation = {
        'backup_management_type': {'required': True},
    }

    _attribute_map = {
        'protected_items_count': {'key': 'protectedItemsCount', 'type': 'int'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'work_load_type': {'key': 'workLoadType', 'type': 'str'},
        'schedule_policy': {'key': 'schedulePolicy', 'type': 'SchedulePolicy'},
        'retention_policy': {'key': 'retentionPolicy', 'type': 'RetentionPolicy'},
        'time_zone': {'key': 'timeZone', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureFileShareProtectionPolicy, self).__init__(**kwargs)
        self.work_load_type = kwargs.get('work_load_type', None)
        self.schedule_policy = kwargs.get('schedule_policy', None)
        self.retention_policy = kwargs.get('retention_policy', None)
        self.time_zone = kwargs.get('time_zone', None)
        self.backup_management_type = 'AzureStorage'


class ILRRequest(Model):
    """Parameters to Provision ILR API.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureFileShareProvisionILRRequest,
    IaasVMILRRegistrationRequest

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'AzureFileShareProvisionILRRequest': 'AzureFileShareProvisionILRRequest', 'IaasVMILRRegistrationRequest': 'IaasVMILRRegistrationRequest'}
    }

    def __init__(self, **kwargs):
        super(ILRRequest, self).__init__(**kwargs)
        self.object_type = None


class AzureFileShareProvisionILRRequest(ILRRequest):
    """Update snapshot Uri with the correct friendly Name of the source Azure file
    share.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param recovery_point_id: Recovery point ID.
    :type recovery_point_id: str
    :param source_resource_id: Source Storage account ARM Id
    :type source_resource_id: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_point_id': {'key': 'recoveryPointId', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureFileShareProvisionILRRequest, self).__init__(**kwargs)
        self.recovery_point_id = kwargs.get('recovery_point_id', None)
        self.source_resource_id = kwargs.get('source_resource_id', None)
        self.object_type = 'AzureFileShareProvisionILRRequest'


class RecoveryPoint(Model):
    """Base class for backup copies. Workload-specific backup copies are derived
    from this class.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureFileShareRecoveryPoint, AzureWorkloadRecoveryPoint,
    GenericRecoveryPoint, IaasVMRecoveryPoint

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'AzureFileShareRecoveryPoint': 'AzureFileShareRecoveryPoint', 'AzureWorkloadRecoveryPoint': 'AzureWorkloadRecoveryPoint', 'GenericRecoveryPoint': 'GenericRecoveryPoint', 'IaasVMRecoveryPoint': 'IaasVMRecoveryPoint'}
    }

    def __init__(self, **kwargs):
        super(RecoveryPoint, self).__init__(**kwargs)
        self.object_type = None


class AzureFileShareRecoveryPoint(RecoveryPoint):
    """Azure File Share workload specific backup copy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :ivar recovery_point_type: Type of the backup copy. Specifies whether it
     is a crash consistent backup or app consistent.
    :vartype recovery_point_type: str
    :ivar recovery_point_time: Time at which this backup copy was created.
    :vartype recovery_point_time: datetime
    :ivar file_share_snapshot_uri: Contains Url to the snapshot of fileshare,
     if applicable
    :vartype file_share_snapshot_uri: str
    :ivar recovery_point_size_in_gb: Contains recovery point size
    :vartype recovery_point_size_in_gb: int
    """

    _validation = {
        'object_type': {'required': True},
        'recovery_point_type': {'readonly': True},
        'recovery_point_time': {'readonly': True},
        'file_share_snapshot_uri': {'readonly': True},
        'recovery_point_size_in_gb': {'readonly': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_point_type': {'key': 'recoveryPointType', 'type': 'str'},
        'recovery_point_time': {'key': 'recoveryPointTime', 'type': 'iso-8601'},
        'file_share_snapshot_uri': {'key': 'fileShareSnapshotUri', 'type': 'str'},
        'recovery_point_size_in_gb': {'key': 'recoveryPointSizeInGB', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(AzureFileShareRecoveryPoint, self).__init__(**kwargs)
        self.recovery_point_type = None
        self.recovery_point_time = None
        self.file_share_snapshot_uri = None
        self.recovery_point_size_in_gb = None
        self.object_type = 'AzureFileShareRecoveryPoint'


class RestoreRequest(Model):
    """Base class for restore request. Workload-specific restore requests are
    derived from this class.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureFileShareRestoreRequest, AzureWorkloadRestoreRequest,
    IaasVMRestoreRequest

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'AzureFileShareRestoreRequest': 'AzureFileShareRestoreRequest', 'AzureWorkloadRestoreRequest': 'AzureWorkloadRestoreRequest', 'IaasVMRestoreRequest': 'IaasVMRestoreRequest'}
    }

    def __init__(self, **kwargs):
        super(RestoreRequest, self).__init__(**kwargs)
        self.object_type = None


class AzureFileShareRestoreRequest(RestoreRequest):
    """AzureFileShare Restore Request.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param recovery_type: Type of this recovery. Possible values include:
     'Invalid', 'OriginalLocation', 'AlternateLocation', 'RestoreDisks',
     'Offline'
    :type recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryType
    :param source_resource_id: Source storage account ARM Id
    :type source_resource_id: str
    :param copy_options: Options to resolve copy conflicts. Possible values
     include: 'Invalid', 'CreateCopy', 'Skip', 'Overwrite', 'FailOnConflict'
    :type copy_options: str or
     ~azure.mgmt.recoveryservicesbackup.models.CopyOptions
    :param restore_request_type: Restore Type (FullShareRestore or
     ItemLevelRestore). Possible values include: 'Invalid', 'FullShareRestore',
     'ItemLevelRestore'
    :type restore_request_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RestoreRequestType
    :param restore_file_specs: List of Source Files/Folders(which need to
     recover) and TargetFolderPath details
    :type restore_file_specs:
     list[~azure.mgmt.recoveryservicesbackup.models.RestoreFileSpecs]
    :param target_details: Target File Share Details
    :type target_details:
     ~azure.mgmt.recoveryservicesbackup.models.TargetAFSRestoreInfo
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_type': {'key': 'recoveryType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'copy_options': {'key': 'copyOptions', 'type': 'str'},
        'restore_request_type': {'key': 'restoreRequestType', 'type': 'str'},
        'restore_file_specs': {'key': 'restoreFileSpecs', 'type': '[RestoreFileSpecs]'},
        'target_details': {'key': 'targetDetails', 'type': 'TargetAFSRestoreInfo'},
    }

    def __init__(self, **kwargs):
        super(AzureFileShareRestoreRequest, self).__init__(**kwargs)
        self.recovery_type = kwargs.get('recovery_type', None)
        self.source_resource_id = kwargs.get('source_resource_id', None)
        self.copy_options = kwargs.get('copy_options', None)
        self.restore_request_type = kwargs.get('restore_request_type', None)
        self.restore_file_specs = kwargs.get('restore_file_specs', None)
        self.target_details = kwargs.get('target_details', None)
        self.object_type = 'AzureFileShareRestoreRequest'


class IaaSVMContainer(ProtectionContainer):
    """IaaS VM workload-specific container.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureIaaSClassicComputeVMContainer,
    AzureIaaSComputeVMContainer

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param registration_status: Status of registration of the container with
     the Recovery Services Vault.
    :type registration_status: str
    :param health_status: Status of health of the container.
    :type health_status: str
    :param container_type: Required. Constant filled by server.
    :type container_type: str
    :param virtual_machine_id: Fully qualified ARM url of the virtual machine
     represented by this Azure IaaS VM container.
    :type virtual_machine_id: str
    :param virtual_machine_version: Specifies whether the container represents
     a Classic or an Azure Resource Manager VM.
    :type virtual_machine_version: str
    :param resource_group: Resource group name of Recovery Services Vault.
    :type resource_group: str
    """

    _validation = {
        'container_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'container_type': {'key': 'containerType', 'type': 'str'},
        'virtual_machine_id': {'key': 'virtualMachineId', 'type': 'str'},
        'virtual_machine_version': {'key': 'virtualMachineVersion', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
    }

    _subtype_map = {
        'container_type': {'Microsoft.ClassicCompute/virtualMachines': 'AzureIaaSClassicComputeVMContainer', 'Microsoft.Compute/virtualMachines': 'AzureIaaSComputeVMContainer'}
    }

    def __init__(self, **kwargs):
        super(IaaSVMContainer, self).__init__(**kwargs)
        self.virtual_machine_id = kwargs.get('virtual_machine_id', None)
        self.virtual_machine_version = kwargs.get('virtual_machine_version', None)
        self.resource_group = kwargs.get('resource_group', None)
        self.container_type = 'IaaSVMContainer'


class AzureIaaSClassicComputeVMContainer(IaaSVMContainer):
    """IaaS VM workload-specific backup item representing a classic virtual
    machine.

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param registration_status: Status of registration of the container with
     the Recovery Services Vault.
    :type registration_status: str
    :param health_status: Status of health of the container.
    :type health_status: str
    :param container_type: Required. Constant filled by server.
    :type container_type: str
    :param virtual_machine_id: Fully qualified ARM url of the virtual machine
     represented by this Azure IaaS VM container.
    :type virtual_machine_id: str
    :param virtual_machine_version: Specifies whether the container represents
     a Classic or an Azure Resource Manager VM.
    :type virtual_machine_version: str
    :param resource_group: Resource group name of Recovery Services Vault.
    :type resource_group: str
    """

    _validation = {
        'container_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'container_type': {'key': 'containerType', 'type': 'str'},
        'virtual_machine_id': {'key': 'virtualMachineId', 'type': 'str'},
        'virtual_machine_version': {'key': 'virtualMachineVersion', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureIaaSClassicComputeVMContainer, self).__init__(**kwargs)
        self.container_type = 'Microsoft.ClassicCompute/virtualMachines'


class IaaSVMProtectableItem(WorkloadProtectableItem):
    """IaaS VM workload-specific backup item.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureIaaSClassicComputeVMProtectableItem,
    AzureIaaSComputeVMProtectableItem

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protectable_item_type: Required. Constant filled by server.
    :type protectable_item_type: str
    :param virtual_machine_id: Fully qualified ARM ID of the virtual machine.
    :type virtual_machine_id: str
    """

    _validation = {
        'protectable_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protectable_item_type': {'key': 'protectableItemType', 'type': 'str'},
        'virtual_machine_id': {'key': 'virtualMachineId', 'type': 'str'},
    }

    _subtype_map = {
        'protectable_item_type': {'Microsoft.ClassicCompute/virtualMachines': 'AzureIaaSClassicComputeVMProtectableItem', 'Microsoft.Compute/virtualMachines': 'AzureIaaSComputeVMProtectableItem'}
    }

    def __init__(self, **kwargs):
        super(IaaSVMProtectableItem, self).__init__(**kwargs)
        self.virtual_machine_id = kwargs.get('virtual_machine_id', None)
        self.protectable_item_type = 'IaaSVMProtectableItem'


class AzureIaaSClassicComputeVMProtectableItem(IaaSVMProtectableItem):
    """IaaS VM workload-specific backup item representing the Classic Compute VM.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protectable_item_type: Required. Constant filled by server.
    :type protectable_item_type: str
    :param virtual_machine_id: Fully qualified ARM ID of the virtual machine.
    :type virtual_machine_id: str
    """

    _validation = {
        'protectable_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protectable_item_type': {'key': 'protectableItemType', 'type': 'str'},
        'virtual_machine_id': {'key': 'virtualMachineId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureIaaSClassicComputeVMProtectableItem, self).__init__(**kwargs)
        self.protectable_item_type = 'Microsoft.ClassicCompute/virtualMachines'


class AzureIaaSVMProtectedItem(ProtectedItem):
    """IaaS VM workload-specific backup item.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureIaaSClassicComputeVMProtectedItem,
    AzureIaaSComputeVMProtectedItem

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param workload_type: Type of workload this item represents. Possible
     values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB',
     'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataSourceType
    :param container_name: Unique name of container
    :type container_name: str
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param last_recovery_point: Timestamp when the last (latest) backup copy
     was created for this backup item.
    :type last_recovery_point: datetime
    :param backup_set_name: Name of the backup set the backup item belongs to
    :type backup_set_name: str
    :param create_mode: Create mode to indicate recovery of existing soft
     deleted data source or creation of new data source. Possible values
     include: 'Invalid', 'Default', 'Recover'
    :type create_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.CreateMode
    :param deferred_delete_time_in_utc: Time for deferred deletion in UTC
    :type deferred_delete_time_in_utc: datetime
    :param is_scheduled_for_deferred_delete: Flag to identify whether the DS
     is scheduled for deferred delete
    :type is_scheduled_for_deferred_delete: bool
    :param deferred_delete_time_remaining: Time remaining before the DS marked
     for deferred delete is permanently deleted
    :type deferred_delete_time_remaining: str
    :param is_deferred_delete_schedule_upcoming: Flag to identify whether the
     deferred deleted DS is to be purged soon
    :type is_deferred_delete_schedule_upcoming: bool
    :param is_rehydrate: Flag to identify that deferred deleted DS is to be
     moved into Pause state
    :type is_rehydrate: bool
    :param protected_item_type: Required. Constant filled by server.
    :type protected_item_type: str
    :param friendly_name: Friendly name of the VM represented by this backup
     item.
    :type friendly_name: str
    :param virtual_machine_id: Fully qualified ARM ID of the virtual machine
     represented by this item.
    :type virtual_machine_id: str
    :param protection_status: Backup status of this backup item.
    :type protection_status: str
    :param protection_state: Backup state of this backup item. Possible values
     include: 'Invalid', 'IRPending', 'Protected', 'ProtectionError',
     'ProtectionStopped', 'ProtectionPaused'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionState
    :param health_status: Health status of protected item. Possible values
     include: 'Passed', 'ActionRequired', 'ActionSuggested', 'Invalid'
    :type health_status: str or
     ~azure.mgmt.recoveryservicesbackup.models.HealthStatus
    :param health_details: Health details on this backup item.
    :type health_details:
     list[~azure.mgmt.recoveryservicesbackup.models.AzureIaaSVMHealthDetails]
    :param last_backup_status: Last backup operation status.
    :type last_backup_status: str
    :param last_backup_time: Timestamp of the last backup operation on this
     backup item.
    :type last_backup_time: datetime
    :param protected_item_data_id: Data ID of the protected item.
    :type protected_item_data_id: str
    :param extended_info: Additional information for this backup item.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureIaaSVMProtectedItemExtendedInfo
    :param extended_properties:
    :type extended_properties:
     ~azure.mgmt.recoveryservicesbackup.models.ExtendedProperties
    """

    _validation = {
        'protected_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'last_recovery_point': {'key': 'lastRecoveryPoint', 'type': 'iso-8601'},
        'backup_set_name': {'key': 'backupSetName', 'type': 'str'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'deferred_delete_time_in_utc': {'key': 'deferredDeleteTimeInUTC', 'type': 'iso-8601'},
        'is_scheduled_for_deferred_delete': {'key': 'isScheduledForDeferredDelete', 'type': 'bool'},
        'deferred_delete_time_remaining': {'key': 'deferredDeleteTimeRemaining', 'type': 'str'},
        'is_deferred_delete_schedule_upcoming': {'key': 'isDeferredDeleteScheduleUpcoming', 'type': 'bool'},
        'is_rehydrate': {'key': 'isRehydrate', 'type': 'bool'},
        'protected_item_type': {'key': 'protectedItemType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'virtual_machine_id': {'key': 'virtualMachineId', 'type': 'str'},
        'protection_status': {'key': 'protectionStatus', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'health_details': {'key': 'healthDetails', 'type': '[AzureIaaSVMHealthDetails]'},
        'last_backup_status': {'key': 'lastBackupStatus', 'type': 'str'},
        'last_backup_time': {'key': 'lastBackupTime', 'type': 'iso-8601'},
        'protected_item_data_id': {'key': 'protectedItemDataId', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureIaaSVMProtectedItemExtendedInfo'},
        'extended_properties': {'key': 'extendedProperties', 'type': 'ExtendedProperties'},
    }

    _subtype_map = {
        'protected_item_type': {'Microsoft.ClassicCompute/virtualMachines': 'AzureIaaSClassicComputeVMProtectedItem', 'Microsoft.Compute/virtualMachines': 'AzureIaaSComputeVMProtectedItem'}
    }

    def __init__(self, **kwargs):
        super(AzureIaaSVMProtectedItem, self).__init__(**kwargs)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.virtual_machine_id = kwargs.get('virtual_machine_id', None)
        self.protection_status = kwargs.get('protection_status', None)
        self.protection_state = kwargs.get('protection_state', None)
        self.health_status = kwargs.get('health_status', None)
        self.health_details = kwargs.get('health_details', None)
        self.last_backup_status = kwargs.get('last_backup_status', None)
        self.last_backup_time = kwargs.get('last_backup_time', None)
        self.protected_item_data_id = kwargs.get('protected_item_data_id', None)
        self.extended_info = kwargs.get('extended_info', None)
        self.extended_properties = kwargs.get('extended_properties', None)
        self.protected_item_type = 'AzureIaaSVMProtectedItem'


class AzureIaaSClassicComputeVMProtectedItem(AzureIaaSVMProtectedItem):
    """IaaS VM workload-specific backup item representing the Classic Compute VM.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param workload_type: Type of workload this item represents. Possible
     values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB',
     'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataSourceType
    :param container_name: Unique name of container
    :type container_name: str
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param last_recovery_point: Timestamp when the last (latest) backup copy
     was created for this backup item.
    :type last_recovery_point: datetime
    :param backup_set_name: Name of the backup set the backup item belongs to
    :type backup_set_name: str
    :param create_mode: Create mode to indicate recovery of existing soft
     deleted data source or creation of new data source. Possible values
     include: 'Invalid', 'Default', 'Recover'
    :type create_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.CreateMode
    :param deferred_delete_time_in_utc: Time for deferred deletion in UTC
    :type deferred_delete_time_in_utc: datetime
    :param is_scheduled_for_deferred_delete: Flag to identify whether the DS
     is scheduled for deferred delete
    :type is_scheduled_for_deferred_delete: bool
    :param deferred_delete_time_remaining: Time remaining before the DS marked
     for deferred delete is permanently deleted
    :type deferred_delete_time_remaining: str
    :param is_deferred_delete_schedule_upcoming: Flag to identify whether the
     deferred deleted DS is to be purged soon
    :type is_deferred_delete_schedule_upcoming: bool
    :param is_rehydrate: Flag to identify that deferred deleted DS is to be
     moved into Pause state
    :type is_rehydrate: bool
    :param protected_item_type: Required. Constant filled by server.
    :type protected_item_type: str
    :param friendly_name: Friendly name of the VM represented by this backup
     item.
    :type friendly_name: str
    :param virtual_machine_id: Fully qualified ARM ID of the virtual machine
     represented by this item.
    :type virtual_machine_id: str
    :param protection_status: Backup status of this backup item.
    :type protection_status: str
    :param protection_state: Backup state of this backup item. Possible values
     include: 'Invalid', 'IRPending', 'Protected', 'ProtectionError',
     'ProtectionStopped', 'ProtectionPaused'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionState
    :param health_status: Health status of protected item. Possible values
     include: 'Passed', 'ActionRequired', 'ActionSuggested', 'Invalid'
    :type health_status: str or
     ~azure.mgmt.recoveryservicesbackup.models.HealthStatus
    :param health_details: Health details on this backup item.
    :type health_details:
     list[~azure.mgmt.recoveryservicesbackup.models.AzureIaaSVMHealthDetails]
    :param last_backup_status: Last backup operation status.
    :type last_backup_status: str
    :param last_backup_time: Timestamp of the last backup operation on this
     backup item.
    :type last_backup_time: datetime
    :param protected_item_data_id: Data ID of the protected item.
    :type protected_item_data_id: str
    :param extended_info: Additional information for this backup item.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureIaaSVMProtectedItemExtendedInfo
    :param extended_properties:
    :type extended_properties:
     ~azure.mgmt.recoveryservicesbackup.models.ExtendedProperties
    """

    _validation = {
        'protected_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'last_recovery_point': {'key': 'lastRecoveryPoint', 'type': 'iso-8601'},
        'backup_set_name': {'key': 'backupSetName', 'type': 'str'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'deferred_delete_time_in_utc': {'key': 'deferredDeleteTimeInUTC', 'type': 'iso-8601'},
        'is_scheduled_for_deferred_delete': {'key': 'isScheduledForDeferredDelete', 'type': 'bool'},
        'deferred_delete_time_remaining': {'key': 'deferredDeleteTimeRemaining', 'type': 'str'},
        'is_deferred_delete_schedule_upcoming': {'key': 'isDeferredDeleteScheduleUpcoming', 'type': 'bool'},
        'is_rehydrate': {'key': 'isRehydrate', 'type': 'bool'},
        'protected_item_type': {'key': 'protectedItemType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'virtual_machine_id': {'key': 'virtualMachineId', 'type': 'str'},
        'protection_status': {'key': 'protectionStatus', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'health_details': {'key': 'healthDetails', 'type': '[AzureIaaSVMHealthDetails]'},
        'last_backup_status': {'key': 'lastBackupStatus', 'type': 'str'},
        'last_backup_time': {'key': 'lastBackupTime', 'type': 'iso-8601'},
        'protected_item_data_id': {'key': 'protectedItemDataId', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureIaaSVMProtectedItemExtendedInfo'},
        'extended_properties': {'key': 'extendedProperties', 'type': 'ExtendedProperties'},
    }

    def __init__(self, **kwargs):
        super(AzureIaaSClassicComputeVMProtectedItem, self).__init__(**kwargs)
        self.protected_item_type = 'Microsoft.ClassicCompute/virtualMachines'


class AzureIaaSComputeVMContainer(IaaSVMContainer):
    """IaaS VM workload-specific backup item representing an Azure Resource
    Manager virtual machine.

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param registration_status: Status of registration of the container with
     the Recovery Services Vault.
    :type registration_status: str
    :param health_status: Status of health of the container.
    :type health_status: str
    :param container_type: Required. Constant filled by server.
    :type container_type: str
    :param virtual_machine_id: Fully qualified ARM url of the virtual machine
     represented by this Azure IaaS VM container.
    :type virtual_machine_id: str
    :param virtual_machine_version: Specifies whether the container represents
     a Classic or an Azure Resource Manager VM.
    :type virtual_machine_version: str
    :param resource_group: Resource group name of Recovery Services Vault.
    :type resource_group: str
    """

    _validation = {
        'container_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'container_type': {'key': 'containerType', 'type': 'str'},
        'virtual_machine_id': {'key': 'virtualMachineId', 'type': 'str'},
        'virtual_machine_version': {'key': 'virtualMachineVersion', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureIaaSComputeVMContainer, self).__init__(**kwargs)
        self.container_type = 'Microsoft.Compute/virtualMachines'


class AzureIaaSComputeVMProtectableItem(IaaSVMProtectableItem):
    """IaaS VM workload-specific backup item representing the Azure Resource
    Manager VM.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protectable_item_type: Required. Constant filled by server.
    :type protectable_item_type: str
    :param virtual_machine_id: Fully qualified ARM ID of the virtual machine.
    :type virtual_machine_id: str
    """

    _validation = {
        'protectable_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protectable_item_type': {'key': 'protectableItemType', 'type': 'str'},
        'virtual_machine_id': {'key': 'virtualMachineId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureIaaSComputeVMProtectableItem, self).__init__(**kwargs)
        self.protectable_item_type = 'Microsoft.Compute/virtualMachines'


class AzureIaaSComputeVMProtectedItem(AzureIaaSVMProtectedItem):
    """IaaS VM workload-specific backup item representing the Azure Resource
    Manager VM.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param workload_type: Type of workload this item represents. Possible
     values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB',
     'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataSourceType
    :param container_name: Unique name of container
    :type container_name: str
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param last_recovery_point: Timestamp when the last (latest) backup copy
     was created for this backup item.
    :type last_recovery_point: datetime
    :param backup_set_name: Name of the backup set the backup item belongs to
    :type backup_set_name: str
    :param create_mode: Create mode to indicate recovery of existing soft
     deleted data source or creation of new data source. Possible values
     include: 'Invalid', 'Default', 'Recover'
    :type create_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.CreateMode
    :param deferred_delete_time_in_utc: Time for deferred deletion in UTC
    :type deferred_delete_time_in_utc: datetime
    :param is_scheduled_for_deferred_delete: Flag to identify whether the DS
     is scheduled for deferred delete
    :type is_scheduled_for_deferred_delete: bool
    :param deferred_delete_time_remaining: Time remaining before the DS marked
     for deferred delete is permanently deleted
    :type deferred_delete_time_remaining: str
    :param is_deferred_delete_schedule_upcoming: Flag to identify whether the
     deferred deleted DS is to be purged soon
    :type is_deferred_delete_schedule_upcoming: bool
    :param is_rehydrate: Flag to identify that deferred deleted DS is to be
     moved into Pause state
    :type is_rehydrate: bool
    :param protected_item_type: Required. Constant filled by server.
    :type protected_item_type: str
    :param friendly_name: Friendly name of the VM represented by this backup
     item.
    :type friendly_name: str
    :param virtual_machine_id: Fully qualified ARM ID of the virtual machine
     represented by this item.
    :type virtual_machine_id: str
    :param protection_status: Backup status of this backup item.
    :type protection_status: str
    :param protection_state: Backup state of this backup item. Possible values
     include: 'Invalid', 'IRPending', 'Protected', 'ProtectionError',
     'ProtectionStopped', 'ProtectionPaused'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionState
    :param health_status: Health status of protected item. Possible values
     include: 'Passed', 'ActionRequired', 'ActionSuggested', 'Invalid'
    :type health_status: str or
     ~azure.mgmt.recoveryservicesbackup.models.HealthStatus
    :param health_details: Health details on this backup item.
    :type health_details:
     list[~azure.mgmt.recoveryservicesbackup.models.AzureIaaSVMHealthDetails]
    :param last_backup_status: Last backup operation status.
    :type last_backup_status: str
    :param last_backup_time: Timestamp of the last backup operation on this
     backup item.
    :type last_backup_time: datetime
    :param protected_item_data_id: Data ID of the protected item.
    :type protected_item_data_id: str
    :param extended_info: Additional information for this backup item.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureIaaSVMProtectedItemExtendedInfo
    :param extended_properties:
    :type extended_properties:
     ~azure.mgmt.recoveryservicesbackup.models.ExtendedProperties
    """

    _validation = {
        'protected_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'last_recovery_point': {'key': 'lastRecoveryPoint', 'type': 'iso-8601'},
        'backup_set_name': {'key': 'backupSetName', 'type': 'str'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'deferred_delete_time_in_utc': {'key': 'deferredDeleteTimeInUTC', 'type': 'iso-8601'},
        'is_scheduled_for_deferred_delete': {'key': 'isScheduledForDeferredDelete', 'type': 'bool'},
        'deferred_delete_time_remaining': {'key': 'deferredDeleteTimeRemaining', 'type': 'str'},
        'is_deferred_delete_schedule_upcoming': {'key': 'isDeferredDeleteScheduleUpcoming', 'type': 'bool'},
        'is_rehydrate': {'key': 'isRehydrate', 'type': 'bool'},
        'protected_item_type': {'key': 'protectedItemType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'virtual_machine_id': {'key': 'virtualMachineId', 'type': 'str'},
        'protection_status': {'key': 'protectionStatus', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'health_details': {'key': 'healthDetails', 'type': '[AzureIaaSVMHealthDetails]'},
        'last_backup_status': {'key': 'lastBackupStatus', 'type': 'str'},
        'last_backup_time': {'key': 'lastBackupTime', 'type': 'iso-8601'},
        'protected_item_data_id': {'key': 'protectedItemDataId', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureIaaSVMProtectedItemExtendedInfo'},
        'extended_properties': {'key': 'extendedProperties', 'type': 'ExtendedProperties'},
    }

    def __init__(self, **kwargs):
        super(AzureIaaSComputeVMProtectedItem, self).__init__(**kwargs)
        self.protected_item_type = 'Microsoft.Compute/virtualMachines'


class AzureIaaSVMErrorInfo(Model):
    """Azure IaaS VM workload-specific error information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar error_code: Error code.
    :vartype error_code: int
    :ivar error_title: Title: Typically, the entity that the error pertains
     to.
    :vartype error_title: str
    :ivar error_string: Localized error string.
    :vartype error_string: str
    :ivar recommendations: List of localized recommendations for above error
     code.
    :vartype recommendations: list[str]
    """

    _validation = {
        'error_code': {'readonly': True},
        'error_title': {'readonly': True},
        'error_string': {'readonly': True},
        'recommendations': {'readonly': True},
    }

    _attribute_map = {
        'error_code': {'key': 'errorCode', 'type': 'int'},
        'error_title': {'key': 'errorTitle', 'type': 'str'},
        'error_string': {'key': 'errorString', 'type': 'str'},
        'recommendations': {'key': 'recommendations', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(AzureIaaSVMErrorInfo, self).__init__(**kwargs)
        self.error_code = None
        self.error_title = None
        self.error_string = None
        self.recommendations = None


class AzureIaaSVMHealthDetails(Model):
    """Azure IaaS VM workload-specific Health Details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: Health Code
    :vartype code: int
    :ivar title: Health Title
    :vartype title: str
    :ivar message: Health Message
    :vartype message: str
    :ivar recommendations: Health Recommended Actions
    :vartype recommendations: list[str]
    """

    _validation = {
        'code': {'readonly': True},
        'title': {'readonly': True},
        'message': {'readonly': True},
        'recommendations': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'int'},
        'title': {'key': 'title', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'recommendations': {'key': 'recommendations', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(AzureIaaSVMHealthDetails, self).__init__(**kwargs)
        self.code = None
        self.title = None
        self.message = None
        self.recommendations = None


class Job(Model):
    """Defines workload agnostic properties for a job.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureIaaSVMJob, AzureStorageJob, AzureWorkloadJob, DpmJob,
    MabJob

    All required parameters must be populated in order to send to Azure.

    :param entity_friendly_name: Friendly name of the entity on which the
     current job is executing.
    :type entity_friendly_name: str
    :param backup_management_type: Backup management type to execute the
     current job. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param operation: The operation name.
    :type operation: str
    :param status: Job status.
    :type status: str
    :param start_time: The start time.
    :type start_time: datetime
    :param end_time: The end time.
    :type end_time: datetime
    :param activity_id: ActivityId of job.
    :type activity_id: str
    :param job_type: Required. Constant filled by server.
    :type job_type: str
    """

    _validation = {
        'job_type': {'required': True},
    }

    _attribute_map = {
        'entity_friendly_name': {'key': 'entityFriendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'activity_id': {'key': 'activityId', 'type': 'str'},
        'job_type': {'key': 'jobType', 'type': 'str'},
    }

    _subtype_map = {
        'job_type': {'AzureIaaSVMJob': 'AzureIaaSVMJob', 'AzureStorageJob': 'AzureStorageJob', 'AzureWorkloadJob': 'AzureWorkloadJob', 'DpmJob': 'DpmJob', 'MabJob': 'MabJob'}
    }

    def __init__(self, **kwargs):
        super(Job, self).__init__(**kwargs)
        self.entity_friendly_name = kwargs.get('entity_friendly_name', None)
        self.backup_management_type = kwargs.get('backup_management_type', None)
        self.operation = kwargs.get('operation', None)
        self.status = kwargs.get('status', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.activity_id = kwargs.get('activity_id', None)
        self.job_type = None


class AzureIaaSVMJob(Job):
    """Azure IaaS VM workload-specific job object.

    All required parameters must be populated in order to send to Azure.

    :param entity_friendly_name: Friendly name of the entity on which the
     current job is executing.
    :type entity_friendly_name: str
    :param backup_management_type: Backup management type to execute the
     current job. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param operation: The operation name.
    :type operation: str
    :param status: Job status.
    :type status: str
    :param start_time: The start time.
    :type start_time: datetime
    :param end_time: The end time.
    :type end_time: datetime
    :param activity_id: ActivityId of job.
    :type activity_id: str
    :param job_type: Required. Constant filled by server.
    :type job_type: str
    :param duration: Time elapsed during the execution of this job.
    :type duration: timedelta
    :param actions_info: Gets or sets the state/actions applicable on this job
     like cancel/retry.
    :type actions_info: list[str or
     ~azure.mgmt.recoveryservicesbackup.models.JobSupportedAction]
    :param error_details: Error details on execution of this job.
    :type error_details:
     list[~azure.mgmt.recoveryservicesbackup.models.AzureIaaSVMErrorInfo]
    :param virtual_machine_version: Specifies whether the backup item is a
     Classic or an Azure Resource Manager VM.
    :type virtual_machine_version: str
    :param extended_info: Additional information for this job.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureIaaSVMJobExtendedInfo
    """

    _validation = {
        'job_type': {'required': True},
    }

    _attribute_map = {
        'entity_friendly_name': {'key': 'entityFriendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'activity_id': {'key': 'activityId', 'type': 'str'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'duration': {'key': 'duration', 'type': 'duration'},
        'actions_info': {'key': 'actionsInfo', 'type': '[JobSupportedAction]'},
        'error_details': {'key': 'errorDetails', 'type': '[AzureIaaSVMErrorInfo]'},
        'virtual_machine_version': {'key': 'virtualMachineVersion', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureIaaSVMJobExtendedInfo'},
    }

    def __init__(self, **kwargs):
        super(AzureIaaSVMJob, self).__init__(**kwargs)
        self.duration = kwargs.get('duration', None)
        self.actions_info = kwargs.get('actions_info', None)
        self.error_details = kwargs.get('error_details', None)
        self.virtual_machine_version = kwargs.get('virtual_machine_version', None)
        self.extended_info = kwargs.get('extended_info', None)
        self.job_type = 'AzureIaaSVMJob'


class AzureIaaSVMJobExtendedInfo(Model):
    """Azure IaaS VM workload-specific additional information for job.

    :param tasks_list: List of tasks associated with this job.
    :type tasks_list:
     list[~azure.mgmt.recoveryservicesbackup.models.AzureIaaSVMJobTaskDetails]
    :param property_bag: Job properties.
    :type property_bag: dict[str, str]
    :param internal_property_bag: Job internal properties.
    :type internal_property_bag: dict[str, str]
    :param progress_percentage: Indicates progress of the job. Null if it has
     not started or completed.
    :type progress_percentage: float
    :param estimated_remaining_duration: Time remaining for execution of this
     job.
    :type estimated_remaining_duration: str
    :param dynamic_error_message: Non localized error message on job
     execution.
    :type dynamic_error_message: str
    """

    _attribute_map = {
        'tasks_list': {'key': 'tasksList', 'type': '[AzureIaaSVMJobTaskDetails]'},
        'property_bag': {'key': 'propertyBag', 'type': '{str}'},
        'internal_property_bag': {'key': 'internalPropertyBag', 'type': '{str}'},
        'progress_percentage': {'key': 'progressPercentage', 'type': 'float'},
        'estimated_remaining_duration': {'key': 'estimatedRemainingDuration', 'type': 'str'},
        'dynamic_error_message': {'key': 'dynamicErrorMessage', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureIaaSVMJobExtendedInfo, self).__init__(**kwargs)
        self.tasks_list = kwargs.get('tasks_list', None)
        self.property_bag = kwargs.get('property_bag', None)
        self.internal_property_bag = kwargs.get('internal_property_bag', None)
        self.progress_percentage = kwargs.get('progress_percentage', None)
        self.estimated_remaining_duration = kwargs.get('estimated_remaining_duration', None)
        self.dynamic_error_message = kwargs.get('dynamic_error_message', None)


class AzureIaaSVMJobTaskDetails(Model):
    """Azure IaaS VM workload-specific job task details.

    :param task_id: The task display name.
    :type task_id: str
    :param start_time: The start time.
    :type start_time: datetime
    :param end_time: The end time.
    :type end_time: datetime
    :param instance_id: The instanceId.
    :type instance_id: str
    :param duration: Time elapsed for task.
    :type duration: timedelta
    :param status: The status.
    :type status: str
    :param progress_percentage: Progress of the task.
    :type progress_percentage: float
    :param task_execution_details: Details about execution of the task.
     eg: number of bytes transferred etc
    :type task_execution_details: str
    """

    _attribute_map = {
        'task_id': {'key': 'taskId', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'instance_id': {'key': 'instanceId', 'type': 'str'},
        'duration': {'key': 'duration', 'type': 'duration'},
        'status': {'key': 'status', 'type': 'str'},
        'progress_percentage': {'key': 'progressPercentage', 'type': 'float'},
        'task_execution_details': {'key': 'taskExecutionDetails', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureIaaSVMJobTaskDetails, self).__init__(**kwargs)
        self.task_id = kwargs.get('task_id', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.instance_id = kwargs.get('instance_id', None)
        self.duration = kwargs.get('duration', None)
        self.status = kwargs.get('status', None)
        self.progress_percentage = kwargs.get('progress_percentage', None)
        self.task_execution_details = kwargs.get('task_execution_details', None)


class AzureIaaSVMProtectedItemExtendedInfo(Model):
    """Additional information on Azure IaaS VM specific backup item.

    :param oldest_recovery_point: The oldest backup copy available for this
     backup item.
    :type oldest_recovery_point: datetime
    :param recovery_point_count: Number of backup copies available for this
     backup item.
    :type recovery_point_count: int
    :param policy_inconsistent: Specifies if backup policy associated with the
     backup item is inconsistent.
    :type policy_inconsistent: bool
    """

    _attribute_map = {
        'oldest_recovery_point': {'key': 'oldestRecoveryPoint', 'type': 'iso-8601'},
        'recovery_point_count': {'key': 'recoveryPointCount', 'type': 'int'},
        'policy_inconsistent': {'key': 'policyInconsistent', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(AzureIaaSVMProtectedItemExtendedInfo, self).__init__(**kwargs)
        self.oldest_recovery_point = kwargs.get('oldest_recovery_point', None)
        self.recovery_point_count = kwargs.get('recovery_point_count', None)
        self.policy_inconsistent = kwargs.get('policy_inconsistent', None)


class AzureIaaSVMProtectionPolicy(ProtectionPolicy):
    """IaaS VM workload-specific backup policy.

    All required parameters must be populated in order to send to Azure.

    :param protected_items_count: Number of items associated with this policy.
    :type protected_items_count: int
    :param backup_management_type: Required. Constant filled by server.
    :type backup_management_type: str
    :param schedule_policy: Backup schedule specified as part of backup
     policy.
    :type schedule_policy:
     ~azure.mgmt.recoveryservicesbackup.models.SchedulePolicy
    :param retention_policy: Retention policy with the details on backup copy
     retention ranges.
    :type retention_policy:
     ~azure.mgmt.recoveryservicesbackup.models.RetentionPolicy
    :param instant_rp_retention_range_in_days: Instant RP retention policy
     range in days
    :type instant_rp_retention_range_in_days: int
    :param time_zone: TimeZone optional input as string. For example: TimeZone
     = "Pacific Standard Time".
    :type time_zone: str
    """

    _validation = {
        'backup_management_type': {'required': True},
    }

    _attribute_map = {
        'protected_items_count': {'key': 'protectedItemsCount', 'type': 'int'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'schedule_policy': {'key': 'schedulePolicy', 'type': 'SchedulePolicy'},
        'retention_policy': {'key': 'retentionPolicy', 'type': 'RetentionPolicy'},
        'instant_rp_retention_range_in_days': {'key': 'instantRpRetentionRangeInDays', 'type': 'int'},
        'time_zone': {'key': 'timeZone', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureIaaSVMProtectionPolicy, self).__init__(**kwargs)
        self.schedule_policy = kwargs.get('schedule_policy', None)
        self.retention_policy = kwargs.get('retention_policy', None)
        self.instant_rp_retention_range_in_days = kwargs.get('instant_rp_retention_range_in_days', None)
        self.time_zone = kwargs.get('time_zone', None)
        self.backup_management_type = 'AzureIaasVM'


class ProtectionIntent(Model):
    """Base class for backup ProtectionIntent.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureRecoveryServiceVaultProtectionIntent,
    AzureResourceProtectionIntent

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param item_id: ID of the item which is getting protected, In case of
     Azure Vm , it is ProtectedItemId
    :type item_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param protection_state: Backup state of this backup item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protection_intent_item_type: Required. Constant filled by server.
    :type protection_intent_item_type: str
    """

    _validation = {
        'protection_intent_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'item_id': {'key': 'itemId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protection_intent_item_type': {'key': 'protectionIntentItemType', 'type': 'str'},
    }

    _subtype_map = {
        'protection_intent_item_type': {'RecoveryServiceVaultItem': 'AzureRecoveryServiceVaultProtectionIntent', 'AzureResourceItem': 'AzureResourceProtectionIntent'}
    }

    def __init__(self, **kwargs):
        super(ProtectionIntent, self).__init__(**kwargs)
        self.backup_management_type = kwargs.get('backup_management_type', None)
        self.source_resource_id = kwargs.get('source_resource_id', None)
        self.item_id = kwargs.get('item_id', None)
        self.policy_id = kwargs.get('policy_id', None)
        self.protection_state = kwargs.get('protection_state', None)
        self.protection_intent_item_type = None


class AzureRecoveryServiceVaultProtectionIntent(ProtectionIntent):
    """Azure Recovery Services Vault specific protection intent item.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureWorkloadAutoProtectionIntent

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param item_id: ID of the item which is getting protected, In case of
     Azure Vm , it is ProtectedItemId
    :type item_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param protection_state: Backup state of this backup item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protection_intent_item_type: Required. Constant filled by server.
    :type protection_intent_item_type: str
    """

    _validation = {
        'protection_intent_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'item_id': {'key': 'itemId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protection_intent_item_type': {'key': 'protectionIntentItemType', 'type': 'str'},
    }

    _subtype_map = {
        'protection_intent_item_type': {'AzureWorkloadAutoProtectionIntent': 'AzureWorkloadAutoProtectionIntent'}
    }

    def __init__(self, **kwargs):
        super(AzureRecoveryServiceVaultProtectionIntent, self).__init__(**kwargs)
        self.protection_intent_item_type = 'RecoveryServiceVaultItem'


class AzureResourceProtectionIntent(ProtectionIntent):
    """IaaS VM specific backup protection intent item.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param item_id: ID of the item which is getting protected, In case of
     Azure Vm , it is ProtectedItemId
    :type item_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param protection_state: Backup state of this backup item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protection_intent_item_type: Required. Constant filled by server.
    :type protection_intent_item_type: str
    :param friendly_name: Friendly name of the VM represented by this backup
     item.
    :type friendly_name: str
    """

    _validation = {
        'protection_intent_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'item_id': {'key': 'itemId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protection_intent_item_type': {'key': 'protectionIntentItemType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureResourceProtectionIntent, self).__init__(**kwargs)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.protection_intent_item_type = 'AzureResourceItem'


class AzureWorkloadContainer(ProtectionContainer):
    """Container for the workloads running inside Azure Compute or Classic
    Compute.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureSQLAGWorkloadContainerProtectionContainer,
    AzureVMAppContainerProtectionContainer

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param registration_status: Status of registration of the container with
     the Recovery Services Vault.
    :type registration_status: str
    :param health_status: Status of health of the container.
    :type health_status: str
    :param container_type: Required. Constant filled by server.
    :type container_type: str
    :param source_resource_id: ARM ID of the virtual machine represented by
     this Azure Workload Container
    :type source_resource_id: str
    :param last_updated_time: Time stamp when this container was updated.
    :type last_updated_time: datetime
    :param extended_info: Additional details of a workload container.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureWorkloadContainerExtendedInfo
    :param workload_type: Workload type for which registration was sent.
     Possible values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb',
     'SQLDB', 'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.WorkloadType
    :param operation_type: Re-Do Operation. Possible values include:
     'Invalid', 'Register', 'Reregister'
    :type operation_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.OperationType
    """

    _validation = {
        'container_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'container_type': {'key': 'containerType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'last_updated_time': {'key': 'lastUpdatedTime', 'type': 'iso-8601'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureWorkloadContainerExtendedInfo'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'operation_type': {'key': 'operationType', 'type': 'str'},
    }

    _subtype_map = {
        'container_type': {'SQLAGWorkLoadContainer': 'AzureSQLAGWorkloadContainerProtectionContainer', 'VMAppContainer': 'AzureVMAppContainerProtectionContainer'}
    }

    def __init__(self, **kwargs):
        super(AzureWorkloadContainer, self).__init__(**kwargs)
        self.source_resource_id = kwargs.get('source_resource_id', None)
        self.last_updated_time = kwargs.get('last_updated_time', None)
        self.extended_info = kwargs.get('extended_info', None)
        self.workload_type = kwargs.get('workload_type', None)
        self.operation_type = kwargs.get('operation_type', None)
        self.container_type = 'AzureWorkloadContainer'


class AzureSQLAGWorkloadContainerProtectionContainer(AzureWorkloadContainer):
    """Container for SQL workloads under SQL Availability Group.

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param registration_status: Status of registration of the container with
     the Recovery Services Vault.
    :type registration_status: str
    :param health_status: Status of health of the container.
    :type health_status: str
    :param container_type: Required. Constant filled by server.
    :type container_type: str
    :param source_resource_id: ARM ID of the virtual machine represented by
     this Azure Workload Container
    :type source_resource_id: str
    :param last_updated_time: Time stamp when this container was updated.
    :type last_updated_time: datetime
    :param extended_info: Additional details of a workload container.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureWorkloadContainerExtendedInfo
    :param workload_type: Workload type for which registration was sent.
     Possible values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb',
     'SQLDB', 'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.WorkloadType
    :param operation_type: Re-Do Operation. Possible values include:
     'Invalid', 'Register', 'Reregister'
    :type operation_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.OperationType
    """

    _validation = {
        'container_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'container_type': {'key': 'containerType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'last_updated_time': {'key': 'lastUpdatedTime', 'type': 'iso-8601'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureWorkloadContainerExtendedInfo'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'operation_type': {'key': 'operationType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureSQLAGWorkloadContainerProtectionContainer, self).__init__(**kwargs)
        self.container_type = 'SQLAGWorkLoadContainer'


class AzureSqlContainer(ProtectionContainer):
    """Azure Sql workload-specific container.

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param registration_status: Status of registration of the container with
     the Recovery Services Vault.
    :type registration_status: str
    :param health_status: Status of health of the container.
    :type health_status: str
    :param container_type: Required. Constant filled by server.
    :type container_type: str
    """

    _validation = {
        'container_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'container_type': {'key': 'containerType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureSqlContainer, self).__init__(**kwargs)
        self.container_type = 'AzureSqlContainer'


class AzureSqlProtectedItem(ProtectedItem):
    """Azure SQL workload-specific backup item.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param workload_type: Type of workload this item represents. Possible
     values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB',
     'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataSourceType
    :param container_name: Unique name of container
    :type container_name: str
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param last_recovery_point: Timestamp when the last (latest) backup copy
     was created for this backup item.
    :type last_recovery_point: datetime
    :param backup_set_name: Name of the backup set the backup item belongs to
    :type backup_set_name: str
    :param create_mode: Create mode to indicate recovery of existing soft
     deleted data source or creation of new data source. Possible values
     include: 'Invalid', 'Default', 'Recover'
    :type create_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.CreateMode
    :param deferred_delete_time_in_utc: Time for deferred deletion in UTC
    :type deferred_delete_time_in_utc: datetime
    :param is_scheduled_for_deferred_delete: Flag to identify whether the DS
     is scheduled for deferred delete
    :type is_scheduled_for_deferred_delete: bool
    :param deferred_delete_time_remaining: Time remaining before the DS marked
     for deferred delete is permanently deleted
    :type deferred_delete_time_remaining: str
    :param is_deferred_delete_schedule_upcoming: Flag to identify whether the
     deferred deleted DS is to be purged soon
    :type is_deferred_delete_schedule_upcoming: bool
    :param is_rehydrate: Flag to identify that deferred deleted DS is to be
     moved into Pause state
    :type is_rehydrate: bool
    :param protected_item_type: Required. Constant filled by server.
    :type protected_item_type: str
    :param protected_item_data_id: Internal ID of a backup item. Used by Azure
     SQL Backup engine to contact Recovery Services.
    :type protected_item_data_id: str
    :param protection_state: Backup state of the backed up item. Possible
     values include: 'Invalid', 'IRPending', 'Protected', 'ProtectionError',
     'ProtectionStopped', 'ProtectionPaused'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectedItemState
    :param extended_info: Additional information for this backup item.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureSqlProtectedItemExtendedInfo
    """

    _validation = {
        'protected_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'last_recovery_point': {'key': 'lastRecoveryPoint', 'type': 'iso-8601'},
        'backup_set_name': {'key': 'backupSetName', 'type': 'str'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'deferred_delete_time_in_utc': {'key': 'deferredDeleteTimeInUTC', 'type': 'iso-8601'},
        'is_scheduled_for_deferred_delete': {'key': 'isScheduledForDeferredDelete', 'type': 'bool'},
        'deferred_delete_time_remaining': {'key': 'deferredDeleteTimeRemaining', 'type': 'str'},
        'is_deferred_delete_schedule_upcoming': {'key': 'isDeferredDeleteScheduleUpcoming', 'type': 'bool'},
        'is_rehydrate': {'key': 'isRehydrate', 'type': 'bool'},
        'protected_item_type': {'key': 'protectedItemType', 'type': 'str'},
        'protected_item_data_id': {'key': 'protectedItemDataId', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureSqlProtectedItemExtendedInfo'},
    }

    def __init__(self, **kwargs):
        super(AzureSqlProtectedItem, self).__init__(**kwargs)
        self.protected_item_data_id = kwargs.get('protected_item_data_id', None)
        self.protection_state = kwargs.get('protection_state', None)
        self.extended_info = kwargs.get('extended_info', None)
        self.protected_item_type = 'Microsoft.Sql/servers/databases'


class AzureSqlProtectedItemExtendedInfo(Model):
    """Additional information on Azure Sql specific protected item.

    :param oldest_recovery_point: The oldest backup copy available for this
     item in the service.
    :type oldest_recovery_point: datetime
    :param recovery_point_count: Number of available backup copies associated
     with this backup item.
    :type recovery_point_count: int
    :param policy_state: State of the backup policy associated with this
     backup item.
    :type policy_state: str
    """

    _attribute_map = {
        'oldest_recovery_point': {'key': 'oldestRecoveryPoint', 'type': 'iso-8601'},
        'recovery_point_count': {'key': 'recoveryPointCount', 'type': 'int'},
        'policy_state': {'key': 'policyState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureSqlProtectedItemExtendedInfo, self).__init__(**kwargs)
        self.oldest_recovery_point = kwargs.get('oldest_recovery_point', None)
        self.recovery_point_count = kwargs.get('recovery_point_count', None)
        self.policy_state = kwargs.get('policy_state', None)


class AzureSqlProtectionPolicy(ProtectionPolicy):
    """Azure SQL workload-specific backup policy.

    All required parameters must be populated in order to send to Azure.

    :param protected_items_count: Number of items associated with this policy.
    :type protected_items_count: int
    :param backup_management_type: Required. Constant filled by server.
    :type backup_management_type: str
    :param retention_policy: Retention policy details.
    :type retention_policy:
     ~azure.mgmt.recoveryservicesbackup.models.RetentionPolicy
    """

    _validation = {
        'backup_management_type': {'required': True},
    }

    _attribute_map = {
        'protected_items_count': {'key': 'protectedItemsCount', 'type': 'int'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'retention_policy': {'key': 'retentionPolicy', 'type': 'RetentionPolicy'},
    }

    def __init__(self, **kwargs):
        super(AzureSqlProtectionPolicy, self).__init__(**kwargs)
        self.retention_policy = kwargs.get('retention_policy', None)
        self.backup_management_type = 'AzureSql'


class AzureStorageContainer(ProtectionContainer):
    """Azure Storage Account workload-specific container.

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param registration_status: Status of registration of the container with
     the Recovery Services Vault.
    :type registration_status: str
    :param health_status: Status of health of the container.
    :type health_status: str
    :param container_type: Required. Constant filled by server.
    :type container_type: str
    :param source_resource_id: Fully qualified ARM url.
    :type source_resource_id: str
    :param storage_account_version: Storage account version.
    :type storage_account_version: str
    :param resource_group: Resource group name of Recovery Services Vault.
    :type resource_group: str
    :param protected_item_count: Number of items backed up in this container.
    :type protected_item_count: long
    """

    _validation = {
        'container_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'container_type': {'key': 'containerType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'storage_account_version': {'key': 'storageAccountVersion', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'protected_item_count': {'key': 'protectedItemCount', 'type': 'long'},
    }

    def __init__(self, **kwargs):
        super(AzureStorageContainer, self).__init__(**kwargs)
        self.source_resource_id = kwargs.get('source_resource_id', None)
        self.storage_account_version = kwargs.get('storage_account_version', None)
        self.resource_group = kwargs.get('resource_group', None)
        self.protected_item_count = kwargs.get('protected_item_count', None)
        self.container_type = 'StorageContainer'


class AzureStorageErrorInfo(Model):
    """Azure storage specific error information.

    :param error_code: Error code.
    :type error_code: int
    :param error_string: Localized error string.
    :type error_string: str
    :param recommendations: List of localized recommendations for above error
     code.
    :type recommendations: list[str]
    """

    _attribute_map = {
        'error_code': {'key': 'errorCode', 'type': 'int'},
        'error_string': {'key': 'errorString', 'type': 'str'},
        'recommendations': {'key': 'recommendations', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(AzureStorageErrorInfo, self).__init__(**kwargs)
        self.error_code = kwargs.get('error_code', None)
        self.error_string = kwargs.get('error_string', None)
        self.recommendations = kwargs.get('recommendations', None)


class AzureStorageJob(Job):
    """Azure storage specific job.

    All required parameters must be populated in order to send to Azure.

    :param entity_friendly_name: Friendly name of the entity on which the
     current job is executing.
    :type entity_friendly_name: str
    :param backup_management_type: Backup management type to execute the
     current job. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param operation: The operation name.
    :type operation: str
    :param status: Job status.
    :type status: str
    :param start_time: The start time.
    :type start_time: datetime
    :param end_time: The end time.
    :type end_time: datetime
    :param activity_id: ActivityId of job.
    :type activity_id: str
    :param job_type: Required. Constant filled by server.
    :type job_type: str
    :param duration: Time elapsed during the execution of this job.
    :type duration: timedelta
    :param actions_info: Gets or sets the state/actions applicable on this job
     like cancel/retry.
    :type actions_info: list[str or
     ~azure.mgmt.recoveryservicesbackup.models.JobSupportedAction]
    :param error_details: Error details on execution of this job.
    :type error_details:
     list[~azure.mgmt.recoveryservicesbackup.models.AzureStorageErrorInfo]
    :param storage_account_name: Specifies friendly name of the storage
     account.
    :type storage_account_name: str
    :param storage_account_version: Specifies whether the Storage account is a
     Classic or an Azure Resource Manager Storage account.
    :type storage_account_version: str
    :param extended_info: Additional information about the job.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureStorageJobExtendedInfo
    """

    _validation = {
        'job_type': {'required': True},
    }

    _attribute_map = {
        'entity_friendly_name': {'key': 'entityFriendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'activity_id': {'key': 'activityId', 'type': 'str'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'duration': {'key': 'duration', 'type': 'duration'},
        'actions_info': {'key': 'actionsInfo', 'type': '[JobSupportedAction]'},
        'error_details': {'key': 'errorDetails', 'type': '[AzureStorageErrorInfo]'},
        'storage_account_name': {'key': 'storageAccountName', 'type': 'str'},
        'storage_account_version': {'key': 'storageAccountVersion', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureStorageJobExtendedInfo'},
    }

    def __init__(self, **kwargs):
        super(AzureStorageJob, self).__init__(**kwargs)
        self.duration = kwargs.get('duration', None)
        self.actions_info = kwargs.get('actions_info', None)
        self.error_details = kwargs.get('error_details', None)
        self.storage_account_name = kwargs.get('storage_account_name', None)
        self.storage_account_version = kwargs.get('storage_account_version', None)
        self.extended_info = kwargs.get('extended_info', None)
        self.job_type = 'AzureStorageJob'


class AzureStorageJobExtendedInfo(Model):
    """Azure Storage workload-specific additional information for job.

    :param tasks_list: List of tasks for this job
    :type tasks_list:
     list[~azure.mgmt.recoveryservicesbackup.models.AzureStorageJobTaskDetails]
    :param property_bag: Job properties.
    :type property_bag: dict[str, str]
    :param dynamic_error_message: Non localized error message on job
     execution.
    :type dynamic_error_message: str
    """

    _attribute_map = {
        'tasks_list': {'key': 'tasksList', 'type': '[AzureStorageJobTaskDetails]'},
        'property_bag': {'key': 'propertyBag', 'type': '{str}'},
        'dynamic_error_message': {'key': 'dynamicErrorMessage', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureStorageJobExtendedInfo, self).__init__(**kwargs)
        self.tasks_list = kwargs.get('tasks_list', None)
        self.property_bag = kwargs.get('property_bag', None)
        self.dynamic_error_message = kwargs.get('dynamic_error_message', None)


class AzureStorageJobTaskDetails(Model):
    """Azure storage workload specific job task details.

    :param task_id: The task display name.
    :type task_id: str
    :param status: The status.
    :type status: str
    """

    _attribute_map = {
        'task_id': {'key': 'taskId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureStorageJobTaskDetails, self).__init__(**kwargs)
        self.task_id = kwargs.get('task_id', None)
        self.status = kwargs.get('status', None)


class ProtectableContainer(Model):
    """Protectable Container Class.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureStorageProtectableContainer,
    AzureVMAppContainerProtectableContainer

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param health_status: Status of health of the container.
    :type health_status: str
    :param container_id: Fabric Id of the container such as ARM Id.
    :type container_id: str
    :param protectable_container_type: Required. Constant filled by server.
    :type protectable_container_type: str
    """

    _validation = {
        'protectable_container_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'container_id': {'key': 'containerId', 'type': 'str'},
        'protectable_container_type': {'key': 'protectableContainerType', 'type': 'str'},
    }

    _subtype_map = {
        'protectable_container_type': {'StorageContainer': 'AzureStorageProtectableContainer', 'VMAppContainer': 'AzureVMAppContainerProtectableContainer'}
    }

    def __init__(self, **kwargs):
        super(ProtectableContainer, self).__init__(**kwargs)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.backup_management_type = kwargs.get('backup_management_type', None)
        self.health_status = kwargs.get('health_status', None)
        self.container_id = kwargs.get('container_id', None)
        self.protectable_container_type = None


class AzureStorageProtectableContainer(ProtectableContainer):
    """Azure Storage-specific protectable containers.

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param health_status: Status of health of the container.
    :type health_status: str
    :param container_id: Fabric Id of the container such as ARM Id.
    :type container_id: str
    :param protectable_container_type: Required. Constant filled by server.
    :type protectable_container_type: str
    """

    _validation = {
        'protectable_container_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'container_id': {'key': 'containerId', 'type': 'str'},
        'protectable_container_type': {'key': 'protectableContainerType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureStorageProtectableContainer, self).__init__(**kwargs)
        self.protectable_container_type = 'StorageContainer'


class AzureVMAppContainerProtectableContainer(ProtectableContainer):
    """Azure workload-specific container.

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param health_status: Status of health of the container.
    :type health_status: str
    :param container_id: Fabric Id of the container such as ARM Id.
    :type container_id: str
    :param protectable_container_type: Required. Constant filled by server.
    :type protectable_container_type: str
    """

    _validation = {
        'protectable_container_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'container_id': {'key': 'containerId', 'type': 'str'},
        'protectable_container_type': {'key': 'protectableContainerType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureVMAppContainerProtectableContainer, self).__init__(**kwargs)
        self.protectable_container_type = 'VMAppContainer'


class AzureVMAppContainerProtectionContainer(AzureWorkloadContainer):
    """Container for SQL workloads under Azure Virtual Machines.

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param registration_status: Status of registration of the container with
     the Recovery Services Vault.
    :type registration_status: str
    :param health_status: Status of health of the container.
    :type health_status: str
    :param container_type: Required. Constant filled by server.
    :type container_type: str
    :param source_resource_id: ARM ID of the virtual machine represented by
     this Azure Workload Container
    :type source_resource_id: str
    :param last_updated_time: Time stamp when this container was updated.
    :type last_updated_time: datetime
    :param extended_info: Additional details of a workload container.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureWorkloadContainerExtendedInfo
    :param workload_type: Workload type for which registration was sent.
     Possible values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb',
     'SQLDB', 'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.WorkloadType
    :param operation_type: Re-Do Operation. Possible values include:
     'Invalid', 'Register', 'Reregister'
    :type operation_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.OperationType
    """

    _validation = {
        'container_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'container_type': {'key': 'containerType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'last_updated_time': {'key': 'lastUpdatedTime', 'type': 'iso-8601'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureWorkloadContainerExtendedInfo'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'operation_type': {'key': 'operationType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureVMAppContainerProtectionContainer, self).__init__(**kwargs)
        self.container_type = 'VMAppContainer'


class AzureVMResourceFeatureSupportRequest(FeatureSupportRequest):
    """AzureResource(IaaS VM) Specific feature support request.

    All required parameters must be populated in order to send to Azure.

    :param feature_type: Required. Constant filled by server.
    :type feature_type: str
    :param vm_size: Size of the resource: VM size(A/D series etc) in case of
     IaasVM
    :type vm_size: str
    :param vm_sku: SKUs (Premium/Managed etc) in case of IaasVM
    :type vm_sku: str
    """

    _validation = {
        'feature_type': {'required': True},
    }

    _attribute_map = {
        'feature_type': {'key': 'featureType', 'type': 'str'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'vm_sku': {'key': 'vmSku', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureVMResourceFeatureSupportRequest, self).__init__(**kwargs)
        self.vm_size = kwargs.get('vm_size', None)
        self.vm_sku = kwargs.get('vm_sku', None)
        self.feature_type = 'AzureVMResourceBackup'


class AzureVMResourceFeatureSupportResponse(Model):
    """Response for feature support requests for Azure IaasVm.

    :param support_status: Support status of feature. Possible values include:
     'Invalid', 'Supported', 'DefaultOFF', 'DefaultON', 'NotSupported'
    :type support_status: str or
     ~azure.mgmt.recoveryservicesbackup.models.SupportStatus
    """

    _attribute_map = {
        'support_status': {'key': 'supportStatus', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureVMResourceFeatureSupportResponse, self).__init__(**kwargs)
        self.support_status = kwargs.get('support_status', None)


class WorkloadItem(Model):
    """Base class for backup item. Workload-specific backup items are derived from
    this class.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureVmWorkloadItem

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param workload_item_type: Required. Constant filled by server.
    :type workload_item_type: str
    """

    _validation = {
        'workload_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'workload_item_type': {'key': 'workloadItemType', 'type': 'str'},
    }

    _subtype_map = {
        'workload_item_type': {'AzureVmWorkloadItem': 'AzureVmWorkloadItem'}
    }

    def __init__(self, **kwargs):
        super(WorkloadItem, self).__init__(**kwargs)
        self.backup_management_type = kwargs.get('backup_management_type', None)
        self.workload_type = kwargs.get('workload_type', None)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.protection_state = kwargs.get('protection_state', None)
        self.workload_item_type = None


class AzureVmWorkloadItem(WorkloadItem):
    """Azure VM workload-specific workload item.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureVmWorkloadSAPAseDatabaseWorkloadItem,
    AzureVmWorkloadSAPAseSystemWorkloadItem,
    AzureVmWorkloadSAPHanaDatabaseWorkloadItem,
    AzureVmWorkloadSAPHanaSystemWorkloadItem,
    AzureVmWorkloadSQLDatabaseWorkloadItem,
    AzureVmWorkloadSQLInstanceWorkloadItem

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param workload_item_type: Required. Constant filled by server.
    :type workload_item_type: str
    :param parent_name: Name for instance or AG
    :type parent_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param is_auto_protectable: Indicates if workload item is auto-protectable
    :type is_auto_protectable: bool
    :param subinquireditemcount: For instance or AG, indicates number of DB's
     present
    :type subinquireditemcount: int
    :param sub_workload_item_count: For instance or AG, indicates number of
     DB's to be protected
    :type sub_workload_item_count: int
    """

    _validation = {
        'workload_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'workload_item_type': {'key': 'workloadItemType', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'is_auto_protectable': {'key': 'isAutoProtectable', 'type': 'bool'},
        'subinquireditemcount': {'key': 'subinquireditemcount', 'type': 'int'},
        'sub_workload_item_count': {'key': 'subWorkloadItemCount', 'type': 'int'},
    }

    _subtype_map = {
        'workload_item_type': {'SAPAseDatabase': 'AzureVmWorkloadSAPAseDatabaseWorkloadItem', 'SAPAseSystem': 'AzureVmWorkloadSAPAseSystemWorkloadItem', 'SAPHanaDatabase': 'AzureVmWorkloadSAPHanaDatabaseWorkloadItem', 'SAPHanaSystem': 'AzureVmWorkloadSAPHanaSystemWorkloadItem', 'SQLDataBase': 'AzureVmWorkloadSQLDatabaseWorkloadItem', 'SQLInstance': 'AzureVmWorkloadSQLInstanceWorkloadItem'}
    }

    def __init__(self, **kwargs):
        super(AzureVmWorkloadItem, self).__init__(**kwargs)
        self.parent_name = kwargs.get('parent_name', None)
        self.server_name = kwargs.get('server_name', None)
        self.is_auto_protectable = kwargs.get('is_auto_protectable', None)
        self.subinquireditemcount = kwargs.get('subinquireditemcount', None)
        self.sub_workload_item_count = kwargs.get('sub_workload_item_count', None)
        self.workload_item_type = 'AzureVmWorkloadItem'


class AzureVmWorkloadProtectableItem(WorkloadProtectableItem):
    """Azure VM workload-specific protectable item.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureVmWorkloadSAPAseSystemProtectableItem,
    AzureVmWorkloadSAPHanaDatabaseProtectableItem,
    AzureVmWorkloadSAPHanaSystemProtectableItem,
    AzureVmWorkloadSQLAvailabilityGroupProtectableItem,
    AzureVmWorkloadSQLDatabaseProtectableItem,
    AzureVmWorkloadSQLInstanceProtectableItem

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protectable_item_type: Required. Constant filled by server.
    :type protectable_item_type: str
    :param parent_name: Name for instance or AG
    :type parent_name: str
    :param parent_unique_name: Parent Unique Name is added to provide the
     service formatted URI Name of the Parent
     Only Applicable for data bases where the parent would be either Instance
     or a SQL AG.
    :type parent_unique_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param is_auto_protectable: Indicates if protectable item is
     auto-protectable
    :type is_auto_protectable: bool
    :param is_auto_protected: Indicates if protectable item is auto-protected
    :type is_auto_protected: bool
    :param subinquireditemcount: For instance or AG, indicates number of DB's
     present
    :type subinquireditemcount: int
    :param subprotectableitemcount: For instance or AG, indicates number of
     DB's to be protected
    :type subprotectableitemcount: int
    :param prebackupvalidation: Pre-backup validation for protectable objects
    :type prebackupvalidation:
     ~azure.mgmt.recoveryservicesbackup.models.PreBackupValidation
    """

    _validation = {
        'protectable_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protectable_item_type': {'key': 'protectableItemType', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'parent_unique_name': {'key': 'parentUniqueName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'is_auto_protectable': {'key': 'isAutoProtectable', 'type': 'bool'},
        'is_auto_protected': {'key': 'isAutoProtected', 'type': 'bool'},
        'subinquireditemcount': {'key': 'subinquireditemcount', 'type': 'int'},
        'subprotectableitemcount': {'key': 'subprotectableitemcount', 'type': 'int'},
        'prebackupvalidation': {'key': 'prebackupvalidation', 'type': 'PreBackupValidation'},
    }

    _subtype_map = {
        'protectable_item_type': {'SAPAseSystem': 'AzureVmWorkloadSAPAseSystemProtectableItem', 'SAPHanaDatabase': 'AzureVmWorkloadSAPHanaDatabaseProtectableItem', 'SAPHanaSystem': 'AzureVmWorkloadSAPHanaSystemProtectableItem', 'SQLAvailabilityGroupContainer': 'AzureVmWorkloadSQLAvailabilityGroupProtectableItem', 'SQLDataBase': 'AzureVmWorkloadSQLDatabaseProtectableItem', 'SQLInstance': 'AzureVmWorkloadSQLInstanceProtectableItem'}
    }

    def __init__(self, **kwargs):
        super(AzureVmWorkloadProtectableItem, self).__init__(**kwargs)
        self.parent_name = kwargs.get('parent_name', None)
        self.parent_unique_name = kwargs.get('parent_unique_name', None)
        self.server_name = kwargs.get('server_name', None)
        self.is_auto_protectable = kwargs.get('is_auto_protectable', None)
        self.is_auto_protected = kwargs.get('is_auto_protected', None)
        self.subinquireditemcount = kwargs.get('subinquireditemcount', None)
        self.subprotectableitemcount = kwargs.get('subprotectableitemcount', None)
        self.prebackupvalidation = kwargs.get('prebackupvalidation', None)
        self.protectable_item_type = 'AzureVmWorkloadProtectableItem'


class AzureVmWorkloadProtectedItem(ProtectedItem):
    """Azure VM workload-specific protected item.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureVmWorkloadSAPAseDatabaseProtectedItem,
    AzureVmWorkloadSAPHanaDatabaseProtectedItem,
    AzureVmWorkloadSQLDatabaseProtectedItem

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param workload_type: Type of workload this item represents. Possible
     values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB',
     'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataSourceType
    :param container_name: Unique name of container
    :type container_name: str
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param last_recovery_point: Timestamp when the last (latest) backup copy
     was created for this backup item.
    :type last_recovery_point: datetime
    :param backup_set_name: Name of the backup set the backup item belongs to
    :type backup_set_name: str
    :param create_mode: Create mode to indicate recovery of existing soft
     deleted data source or creation of new data source. Possible values
     include: 'Invalid', 'Default', 'Recover'
    :type create_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.CreateMode
    :param deferred_delete_time_in_utc: Time for deferred deletion in UTC
    :type deferred_delete_time_in_utc: datetime
    :param is_scheduled_for_deferred_delete: Flag to identify whether the DS
     is scheduled for deferred delete
    :type is_scheduled_for_deferred_delete: bool
    :param deferred_delete_time_remaining: Time remaining before the DS marked
     for deferred delete is permanently deleted
    :type deferred_delete_time_remaining: str
    :param is_deferred_delete_schedule_upcoming: Flag to identify whether the
     deferred deleted DS is to be purged soon
    :type is_deferred_delete_schedule_upcoming: bool
    :param is_rehydrate: Flag to identify that deferred deleted DS is to be
     moved into Pause state
    :type is_rehydrate: bool
    :param protected_item_type: Required. Constant filled by server.
    :type protected_item_type: str
    :param friendly_name: Friendly name of the DB represented by this backup
     item.
    :type friendly_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param parent_name: Parent name of the DB such as Instance or Availability
     Group.
    :type parent_name: str
    :param parent_type: Parent type of protected item, example: for a DB,
     standalone server or distributed
    :type parent_type: str
    :param protection_status: Backup status of this backup item.
    :type protection_status: str
    :param protection_state: Backup state of this backup item. Possible values
     include: 'Invalid', 'IRPending', 'Protected', 'ProtectionError',
     'ProtectionStopped', 'ProtectionPaused'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionState
    :param last_backup_status: Last backup operation status. Possible values:
     Healthy, Unhealthy. Possible values include: 'Invalid', 'Healthy',
     'Unhealthy', 'IRPending'
    :type last_backup_status: str or
     ~azure.mgmt.recoveryservicesbackup.models.LastBackupStatus
    :param last_backup_time: Timestamp of the last backup operation on this
     backup item.
    :type last_backup_time: datetime
    :param last_backup_error_detail: Error details in last backup
    :type last_backup_error_detail:
     ~azure.mgmt.recoveryservicesbackup.models.ErrorDetail
    :param protected_item_data_source_id: Data ID of the protected item.
    :type protected_item_data_source_id: str
    :param protected_item_health_status: Health status of the backup item,
     evaluated based on last heartbeat received. Possible values include:
     'Invalid', 'Healthy', 'Unhealthy', 'NotReachable', 'IRPending'
    :type protected_item_health_status: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectedItemHealthStatus
    :param extended_info: Additional information for this backup item.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureVmWorkloadProtectedItemExtendedInfo
    """

    _validation = {
        'protected_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'last_recovery_point': {'key': 'lastRecoveryPoint', 'type': 'iso-8601'},
        'backup_set_name': {'key': 'backupSetName', 'type': 'str'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'deferred_delete_time_in_utc': {'key': 'deferredDeleteTimeInUTC', 'type': 'iso-8601'},
        'is_scheduled_for_deferred_delete': {'key': 'isScheduledForDeferredDelete', 'type': 'bool'},
        'deferred_delete_time_remaining': {'key': 'deferredDeleteTimeRemaining', 'type': 'str'},
        'is_deferred_delete_schedule_upcoming': {'key': 'isDeferredDeleteScheduleUpcoming', 'type': 'bool'},
        'is_rehydrate': {'key': 'isRehydrate', 'type': 'bool'},
        'protected_item_type': {'key': 'protectedItemType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'parent_type': {'key': 'parentType', 'type': 'str'},
        'protection_status': {'key': 'protectionStatus', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'last_backup_status': {'key': 'lastBackupStatus', 'type': 'str'},
        'last_backup_time': {'key': 'lastBackupTime', 'type': 'iso-8601'},
        'last_backup_error_detail': {'key': 'lastBackupErrorDetail', 'type': 'ErrorDetail'},
        'protected_item_data_source_id': {'key': 'protectedItemDataSourceId', 'type': 'str'},
        'protected_item_health_status': {'key': 'protectedItemHealthStatus', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureVmWorkloadProtectedItemExtendedInfo'},
    }

    _subtype_map = {
        'protected_item_type': {'AzureVmWorkloadSAPAseDatabase': 'AzureVmWorkloadSAPAseDatabaseProtectedItem', 'AzureVmWorkloadSAPHanaDatabase': 'AzureVmWorkloadSAPHanaDatabaseProtectedItem', 'AzureVmWorkloadSQLDatabase': 'AzureVmWorkloadSQLDatabaseProtectedItem'}
    }

    def __init__(self, **kwargs):
        super(AzureVmWorkloadProtectedItem, self).__init__(**kwargs)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.server_name = kwargs.get('server_name', None)
        self.parent_name = kwargs.get('parent_name', None)
        self.parent_type = kwargs.get('parent_type', None)
        self.protection_status = kwargs.get('protection_status', None)
        self.protection_state = kwargs.get('protection_state', None)
        self.last_backup_status = kwargs.get('last_backup_status', None)
        self.last_backup_time = kwargs.get('last_backup_time', None)
        self.last_backup_error_detail = kwargs.get('last_backup_error_detail', None)
        self.protected_item_data_source_id = kwargs.get('protected_item_data_source_id', None)
        self.protected_item_health_status = kwargs.get('protected_item_health_status', None)
        self.extended_info = kwargs.get('extended_info', None)
        self.protected_item_type = 'AzureVmWorkloadProtectedItem'


class AzureVmWorkloadProtectedItemExtendedInfo(Model):
    """Additional information on Azure Workload for SQL specific backup item.

    :param oldest_recovery_point: The oldest backup copy available for this
     backup item.
    :type oldest_recovery_point: datetime
    :param recovery_point_count: Number of backup copies available for this
     backup item.
    :type recovery_point_count: int
    :param policy_state: Indicates consistency of policy object and policy
     applied to this backup item.
    :type policy_state: str
    """

    _attribute_map = {
        'oldest_recovery_point': {'key': 'oldestRecoveryPoint', 'type': 'iso-8601'},
        'recovery_point_count': {'key': 'recoveryPointCount', 'type': 'int'},
        'policy_state': {'key': 'policyState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureVmWorkloadProtectedItemExtendedInfo, self).__init__(**kwargs)
        self.oldest_recovery_point = kwargs.get('oldest_recovery_point', None)
        self.recovery_point_count = kwargs.get('recovery_point_count', None)
        self.policy_state = kwargs.get('policy_state', None)


class AzureVmWorkloadProtectionPolicy(ProtectionPolicy):
    """Azure VM (Mercury) workload-specific backup policy.

    All required parameters must be populated in order to send to Azure.

    :param protected_items_count: Number of items associated with this policy.
    :type protected_items_count: int
    :param backup_management_type: Required. Constant filled by server.
    :type backup_management_type: str
    :param work_load_type: Type of workload for the backup management.
     Possible values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb',
     'SQLDB', 'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type work_load_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.WorkloadType
    :param settings: Common settings for the backup management
    :type settings: ~azure.mgmt.recoveryservicesbackup.models.Settings
    :param sub_protection_policy: List of sub-protection policies which
     includes schedule and retention
    :type sub_protection_policy:
     list[~azure.mgmt.recoveryservicesbackup.models.SubProtectionPolicy]
    :param make_policy_consistent: Fix the policy inconsistency
    :type make_policy_consistent: bool
    """

    _validation = {
        'backup_management_type': {'required': True},
    }

    _attribute_map = {
        'protected_items_count': {'key': 'protectedItemsCount', 'type': 'int'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'work_load_type': {'key': 'workLoadType', 'type': 'str'},
        'settings': {'key': 'settings', 'type': 'Settings'},
        'sub_protection_policy': {'key': 'subProtectionPolicy', 'type': '[SubProtectionPolicy]'},
        'make_policy_consistent': {'key': 'makePolicyConsistent', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(AzureVmWorkloadProtectionPolicy, self).__init__(**kwargs)
        self.work_load_type = kwargs.get('work_load_type', None)
        self.settings = kwargs.get('settings', None)
        self.sub_protection_policy = kwargs.get('sub_protection_policy', None)
        self.make_policy_consistent = kwargs.get('make_policy_consistent', None)
        self.backup_management_type = 'AzureWorkload'


class AzureVmWorkloadSAPAseDatabaseProtectedItem(AzureVmWorkloadProtectedItem):
    """Azure VM workload-specific protected item representing SAP ASE Database.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param workload_type: Type of workload this item represents. Possible
     values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB',
     'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataSourceType
    :param container_name: Unique name of container
    :type container_name: str
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param last_recovery_point: Timestamp when the last (latest) backup copy
     was created for this backup item.
    :type last_recovery_point: datetime
    :param backup_set_name: Name of the backup set the backup item belongs to
    :type backup_set_name: str
    :param create_mode: Create mode to indicate recovery of existing soft
     deleted data source or creation of new data source. Possible values
     include: 'Invalid', 'Default', 'Recover'
    :type create_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.CreateMode
    :param deferred_delete_time_in_utc: Time for deferred deletion in UTC
    :type deferred_delete_time_in_utc: datetime
    :param is_scheduled_for_deferred_delete: Flag to identify whether the DS
     is scheduled for deferred delete
    :type is_scheduled_for_deferred_delete: bool
    :param deferred_delete_time_remaining: Time remaining before the DS marked
     for deferred delete is permanently deleted
    :type deferred_delete_time_remaining: str
    :param is_deferred_delete_schedule_upcoming: Flag to identify whether the
     deferred deleted DS is to be purged soon
    :type is_deferred_delete_schedule_upcoming: bool
    :param is_rehydrate: Flag to identify that deferred deleted DS is to be
     moved into Pause state
    :type is_rehydrate: bool
    :param protected_item_type: Required. Constant filled by server.
    :type protected_item_type: str
    :param friendly_name: Friendly name of the DB represented by this backup
     item.
    :type friendly_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param parent_name: Parent name of the DB such as Instance or Availability
     Group.
    :type parent_name: str
    :param parent_type: Parent type of protected item, example: for a DB,
     standalone server or distributed
    :type parent_type: str
    :param protection_status: Backup status of this backup item.
    :type protection_status: str
    :param protection_state: Backup state of this backup item. Possible values
     include: 'Invalid', 'IRPending', 'Protected', 'ProtectionError',
     'ProtectionStopped', 'ProtectionPaused'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionState
    :param last_backup_status: Last backup operation status. Possible values:
     Healthy, Unhealthy. Possible values include: 'Invalid', 'Healthy',
     'Unhealthy', 'IRPending'
    :type last_backup_status: str or
     ~azure.mgmt.recoveryservicesbackup.models.LastBackupStatus
    :param last_backup_time: Timestamp of the last backup operation on this
     backup item.
    :type last_backup_time: datetime
    :param last_backup_error_detail: Error details in last backup
    :type last_backup_error_detail:
     ~azure.mgmt.recoveryservicesbackup.models.ErrorDetail
    :param protected_item_data_source_id: Data ID of the protected item.
    :type protected_item_data_source_id: str
    :param protected_item_health_status: Health status of the backup item,
     evaluated based on last heartbeat received. Possible values include:
     'Invalid', 'Healthy', 'Unhealthy', 'NotReachable', 'IRPending'
    :type protected_item_health_status: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectedItemHealthStatus
    :param extended_info: Additional information for this backup item.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureVmWorkloadProtectedItemExtendedInfo
    """

    _validation = {
        'protected_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'last_recovery_point': {'key': 'lastRecoveryPoint', 'type': 'iso-8601'},
        'backup_set_name': {'key': 'backupSetName', 'type': 'str'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'deferred_delete_time_in_utc': {'key': 'deferredDeleteTimeInUTC', 'type': 'iso-8601'},
        'is_scheduled_for_deferred_delete': {'key': 'isScheduledForDeferredDelete', 'type': 'bool'},
        'deferred_delete_time_remaining': {'key': 'deferredDeleteTimeRemaining', 'type': 'str'},
        'is_deferred_delete_schedule_upcoming': {'key': 'isDeferredDeleteScheduleUpcoming', 'type': 'bool'},
        'is_rehydrate': {'key': 'isRehydrate', 'type': 'bool'},
        'protected_item_type': {'key': 'protectedItemType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'parent_type': {'key': 'parentType', 'type': 'str'},
        'protection_status': {'key': 'protectionStatus', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'last_backup_status': {'key': 'lastBackupStatus', 'type': 'str'},
        'last_backup_time': {'key': 'lastBackupTime', 'type': 'iso-8601'},
        'last_backup_error_detail': {'key': 'lastBackupErrorDetail', 'type': 'ErrorDetail'},
        'protected_item_data_source_id': {'key': 'protectedItemDataSourceId', 'type': 'str'},
        'protected_item_health_status': {'key': 'protectedItemHealthStatus', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureVmWorkloadProtectedItemExtendedInfo'},
    }

    def __init__(self, **kwargs):
        super(AzureVmWorkloadSAPAseDatabaseProtectedItem, self).__init__(**kwargs)
        self.protected_item_type = 'AzureVmWorkloadSAPAseDatabase'


class AzureVmWorkloadSAPAseDatabaseWorkloadItem(AzureVmWorkloadItem):
    """Azure VM workload-specific workload item representing SAP ASE Database.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param workload_item_type: Required. Constant filled by server.
    :type workload_item_type: str
    :param parent_name: Name for instance or AG
    :type parent_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param is_auto_protectable: Indicates if workload item is auto-protectable
    :type is_auto_protectable: bool
    :param subinquireditemcount: For instance or AG, indicates number of DB's
     present
    :type subinquireditemcount: int
    :param sub_workload_item_count: For instance or AG, indicates number of
     DB's to be protected
    :type sub_workload_item_count: int
    """

    _validation = {
        'workload_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'workload_item_type': {'key': 'workloadItemType', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'is_auto_protectable': {'key': 'isAutoProtectable', 'type': 'bool'},
        'subinquireditemcount': {'key': 'subinquireditemcount', 'type': 'int'},
        'sub_workload_item_count': {'key': 'subWorkloadItemCount', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(AzureVmWorkloadSAPAseDatabaseWorkloadItem, self).__init__(**kwargs)
        self.workload_item_type = 'SAPAseDatabase'


class AzureVmWorkloadSAPAseSystemProtectableItem(AzureVmWorkloadProtectableItem):
    """Azure VM workload-specific protectable item representing SAP ASE System.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protectable_item_type: Required. Constant filled by server.
    :type protectable_item_type: str
    :param parent_name: Name for instance or AG
    :type parent_name: str
    :param parent_unique_name: Parent Unique Name is added to provide the
     service formatted URI Name of the Parent
     Only Applicable for data bases where the parent would be either Instance
     or a SQL AG.
    :type parent_unique_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param is_auto_protectable: Indicates if protectable item is
     auto-protectable
    :type is_auto_protectable: bool
    :param is_auto_protected: Indicates if protectable item is auto-protected
    :type is_auto_protected: bool
    :param subinquireditemcount: For instance or AG, indicates number of DB's
     present
    :type subinquireditemcount: int
    :param subprotectableitemcount: For instance or AG, indicates number of
     DB's to be protected
    :type subprotectableitemcount: int
    :param prebackupvalidation: Pre-backup validation for protectable objects
    :type prebackupvalidation:
     ~azure.mgmt.recoveryservicesbackup.models.PreBackupValidation
    """

    _validation = {
        'protectable_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protectable_item_type': {'key': 'protectableItemType', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'parent_unique_name': {'key': 'parentUniqueName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'is_auto_protectable': {'key': 'isAutoProtectable', 'type': 'bool'},
        'is_auto_protected': {'key': 'isAutoProtected', 'type': 'bool'},
        'subinquireditemcount': {'key': 'subinquireditemcount', 'type': 'int'},
        'subprotectableitemcount': {'key': 'subprotectableitemcount', 'type': 'int'},
        'prebackupvalidation': {'key': 'prebackupvalidation', 'type': 'PreBackupValidation'},
    }

    def __init__(self, **kwargs):
        super(AzureVmWorkloadSAPAseSystemProtectableItem, self).__init__(**kwargs)
        self.protectable_item_type = 'SAPAseSystem'


class AzureVmWorkloadSAPAseSystemWorkloadItem(AzureVmWorkloadItem):
    """Azure VM workload-specific workload item representing SAP ASE System.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param workload_item_type: Required. Constant filled by server.
    :type workload_item_type: str
    :param parent_name: Name for instance or AG
    :type parent_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param is_auto_protectable: Indicates if workload item is auto-protectable
    :type is_auto_protectable: bool
    :param subinquireditemcount: For instance or AG, indicates number of DB's
     present
    :type subinquireditemcount: int
    :param sub_workload_item_count: For instance or AG, indicates number of
     DB's to be protected
    :type sub_workload_item_count: int
    """

    _validation = {
        'workload_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'workload_item_type': {'key': 'workloadItemType', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'is_auto_protectable': {'key': 'isAutoProtectable', 'type': 'bool'},
        'subinquireditemcount': {'key': 'subinquireditemcount', 'type': 'int'},
        'sub_workload_item_count': {'key': 'subWorkloadItemCount', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(AzureVmWorkloadSAPAseSystemWorkloadItem, self).__init__(**kwargs)
        self.workload_item_type = 'SAPAseSystem'


class AzureVmWorkloadSAPHanaDatabaseProtectableItem(AzureVmWorkloadProtectableItem):
    """Azure VM workload-specific protectable item representing SAP HANA Database.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protectable_item_type: Required. Constant filled by server.
    :type protectable_item_type: str
    :param parent_name: Name for instance or AG
    :type parent_name: str
    :param parent_unique_name: Parent Unique Name is added to provide the
     service formatted URI Name of the Parent
     Only Applicable for data bases where the parent would be either Instance
     or a SQL AG.
    :type parent_unique_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param is_auto_protectable: Indicates if protectable item is
     auto-protectable
    :type is_auto_protectable: bool
    :param is_auto_protected: Indicates if protectable item is auto-protected
    :type is_auto_protected: bool
    :param subinquireditemcount: For instance or AG, indicates number of DB's
     present
    :type subinquireditemcount: int
    :param subprotectableitemcount: For instance or AG, indicates number of
     DB's to be protected
    :type subprotectableitemcount: int
    :param prebackupvalidation: Pre-backup validation for protectable objects
    :type prebackupvalidation:
     ~azure.mgmt.recoveryservicesbackup.models.PreBackupValidation
    """

    _validation = {
        'protectable_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protectable_item_type': {'key': 'protectableItemType', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'parent_unique_name': {'key': 'parentUniqueName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'is_auto_protectable': {'key': 'isAutoProtectable', 'type': 'bool'},
        'is_auto_protected': {'key': 'isAutoProtected', 'type': 'bool'},
        'subinquireditemcount': {'key': 'subinquireditemcount', 'type': 'int'},
        'subprotectableitemcount': {'key': 'subprotectableitemcount', 'type': 'int'},
        'prebackupvalidation': {'key': 'prebackupvalidation', 'type': 'PreBackupValidation'},
    }

    def __init__(self, **kwargs):
        super(AzureVmWorkloadSAPHanaDatabaseProtectableItem, self).__init__(**kwargs)
        self.protectable_item_type = 'SAPHanaDatabase'


class AzureVmWorkloadSAPHanaDatabaseProtectedItem(AzureVmWorkloadProtectedItem):
    """Azure VM workload-specific protected item representing SAP HANA Database.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param workload_type: Type of workload this item represents. Possible
     values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB',
     'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataSourceType
    :param container_name: Unique name of container
    :type container_name: str
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param last_recovery_point: Timestamp when the last (latest) backup copy
     was created for this backup item.
    :type last_recovery_point: datetime
    :param backup_set_name: Name of the backup set the backup item belongs to
    :type backup_set_name: str
    :param create_mode: Create mode to indicate recovery of existing soft
     deleted data source or creation of new data source. Possible values
     include: 'Invalid', 'Default', 'Recover'
    :type create_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.CreateMode
    :param deferred_delete_time_in_utc: Time for deferred deletion in UTC
    :type deferred_delete_time_in_utc: datetime
    :param is_scheduled_for_deferred_delete: Flag to identify whether the DS
     is scheduled for deferred delete
    :type is_scheduled_for_deferred_delete: bool
    :param deferred_delete_time_remaining: Time remaining before the DS marked
     for deferred delete is permanently deleted
    :type deferred_delete_time_remaining: str
    :param is_deferred_delete_schedule_upcoming: Flag to identify whether the
     deferred deleted DS is to be purged soon
    :type is_deferred_delete_schedule_upcoming: bool
    :param is_rehydrate: Flag to identify that deferred deleted DS is to be
     moved into Pause state
    :type is_rehydrate: bool
    :param protected_item_type: Required. Constant filled by server.
    :type protected_item_type: str
    :param friendly_name: Friendly name of the DB represented by this backup
     item.
    :type friendly_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param parent_name: Parent name of the DB such as Instance or Availability
     Group.
    :type parent_name: str
    :param parent_type: Parent type of protected item, example: for a DB,
     standalone server or distributed
    :type parent_type: str
    :param protection_status: Backup status of this backup item.
    :type protection_status: str
    :param protection_state: Backup state of this backup item. Possible values
     include: 'Invalid', 'IRPending', 'Protected', 'ProtectionError',
     'ProtectionStopped', 'ProtectionPaused'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionState
    :param last_backup_status: Last backup operation status. Possible values:
     Healthy, Unhealthy. Possible values include: 'Invalid', 'Healthy',
     'Unhealthy', 'IRPending'
    :type last_backup_status: str or
     ~azure.mgmt.recoveryservicesbackup.models.LastBackupStatus
    :param last_backup_time: Timestamp of the last backup operation on this
     backup item.
    :type last_backup_time: datetime
    :param last_backup_error_detail: Error details in last backup
    :type last_backup_error_detail:
     ~azure.mgmt.recoveryservicesbackup.models.ErrorDetail
    :param protected_item_data_source_id: Data ID of the protected item.
    :type protected_item_data_source_id: str
    :param protected_item_health_status: Health status of the backup item,
     evaluated based on last heartbeat received. Possible values include:
     'Invalid', 'Healthy', 'Unhealthy', 'NotReachable', 'IRPending'
    :type protected_item_health_status: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectedItemHealthStatus
    :param extended_info: Additional information for this backup item.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureVmWorkloadProtectedItemExtendedInfo
    """

    _validation = {
        'protected_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'last_recovery_point': {'key': 'lastRecoveryPoint', 'type': 'iso-8601'},
        'backup_set_name': {'key': 'backupSetName', 'type': 'str'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'deferred_delete_time_in_utc': {'key': 'deferredDeleteTimeInUTC', 'type': 'iso-8601'},
        'is_scheduled_for_deferred_delete': {'key': 'isScheduledForDeferredDelete', 'type': 'bool'},
        'deferred_delete_time_remaining': {'key': 'deferredDeleteTimeRemaining', 'type': 'str'},
        'is_deferred_delete_schedule_upcoming': {'key': 'isDeferredDeleteScheduleUpcoming', 'type': 'bool'},
        'is_rehydrate': {'key': 'isRehydrate', 'type': 'bool'},
        'protected_item_type': {'key': 'protectedItemType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'parent_type': {'key': 'parentType', 'type': 'str'},
        'protection_status': {'key': 'protectionStatus', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'last_backup_status': {'key': 'lastBackupStatus', 'type': 'str'},
        'last_backup_time': {'key': 'lastBackupTime', 'type': 'iso-8601'},
        'last_backup_error_detail': {'key': 'lastBackupErrorDetail', 'type': 'ErrorDetail'},
        'protected_item_data_source_id': {'key': 'protectedItemDataSourceId', 'type': 'str'},
        'protected_item_health_status': {'key': 'protectedItemHealthStatus', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureVmWorkloadProtectedItemExtendedInfo'},
    }

    def __init__(self, **kwargs):
        super(AzureVmWorkloadSAPHanaDatabaseProtectedItem, self).__init__(**kwargs)
        self.protected_item_type = 'AzureVmWorkloadSAPHanaDatabase'


class AzureVmWorkloadSAPHanaDatabaseWorkloadItem(AzureVmWorkloadItem):
    """Azure VM workload-specific workload item representing SAP HANA Database.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param workload_item_type: Required. Constant filled by server.
    :type workload_item_type: str
    :param parent_name: Name for instance or AG
    :type parent_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param is_auto_protectable: Indicates if workload item is auto-protectable
    :type is_auto_protectable: bool
    :param subinquireditemcount: For instance or AG, indicates number of DB's
     present
    :type subinquireditemcount: int
    :param sub_workload_item_count: For instance or AG, indicates number of
     DB's to be protected
    :type sub_workload_item_count: int
    """

    _validation = {
        'workload_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'workload_item_type': {'key': 'workloadItemType', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'is_auto_protectable': {'key': 'isAutoProtectable', 'type': 'bool'},
        'subinquireditemcount': {'key': 'subinquireditemcount', 'type': 'int'},
        'sub_workload_item_count': {'key': 'subWorkloadItemCount', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(AzureVmWorkloadSAPHanaDatabaseWorkloadItem, self).__init__(**kwargs)
        self.workload_item_type = 'SAPHanaDatabase'


class AzureVmWorkloadSAPHanaSystemProtectableItem(AzureVmWorkloadProtectableItem):
    """Azure VM workload-specific protectable item representing SAP HANA System.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protectable_item_type: Required. Constant filled by server.
    :type protectable_item_type: str
    :param parent_name: Name for instance or AG
    :type parent_name: str
    :param parent_unique_name: Parent Unique Name is added to provide the
     service formatted URI Name of the Parent
     Only Applicable for data bases where the parent would be either Instance
     or a SQL AG.
    :type parent_unique_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param is_auto_protectable: Indicates if protectable item is
     auto-protectable
    :type is_auto_protectable: bool
    :param is_auto_protected: Indicates if protectable item is auto-protected
    :type is_auto_protected: bool
    :param subinquireditemcount: For instance or AG, indicates number of DB's
     present
    :type subinquireditemcount: int
    :param subprotectableitemcount: For instance or AG, indicates number of
     DB's to be protected
    :type subprotectableitemcount: int
    :param prebackupvalidation: Pre-backup validation for protectable objects
    :type prebackupvalidation:
     ~azure.mgmt.recoveryservicesbackup.models.PreBackupValidation
    """

    _validation = {
        'protectable_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protectable_item_type': {'key': 'protectableItemType', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'parent_unique_name': {'key': 'parentUniqueName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'is_auto_protectable': {'key': 'isAutoProtectable', 'type': 'bool'},
        'is_auto_protected': {'key': 'isAutoProtected', 'type': 'bool'},
        'subinquireditemcount': {'key': 'subinquireditemcount', 'type': 'int'},
        'subprotectableitemcount': {'key': 'subprotectableitemcount', 'type': 'int'},
        'prebackupvalidation': {'key': 'prebackupvalidation', 'type': 'PreBackupValidation'},
    }

    def __init__(self, **kwargs):
        super(AzureVmWorkloadSAPHanaSystemProtectableItem, self).__init__(**kwargs)
        self.protectable_item_type = 'SAPHanaSystem'


class AzureVmWorkloadSAPHanaSystemWorkloadItem(AzureVmWorkloadItem):
    """Azure VM workload-specific workload item representing SAP HANA System.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param workload_item_type: Required. Constant filled by server.
    :type workload_item_type: str
    :param parent_name: Name for instance or AG
    :type parent_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param is_auto_protectable: Indicates if workload item is auto-protectable
    :type is_auto_protectable: bool
    :param subinquireditemcount: For instance or AG, indicates number of DB's
     present
    :type subinquireditemcount: int
    :param sub_workload_item_count: For instance or AG, indicates number of
     DB's to be protected
    :type sub_workload_item_count: int
    """

    _validation = {
        'workload_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'workload_item_type': {'key': 'workloadItemType', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'is_auto_protectable': {'key': 'isAutoProtectable', 'type': 'bool'},
        'subinquireditemcount': {'key': 'subinquireditemcount', 'type': 'int'},
        'sub_workload_item_count': {'key': 'subWorkloadItemCount', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(AzureVmWorkloadSAPHanaSystemWorkloadItem, self).__init__(**kwargs)
        self.workload_item_type = 'SAPHanaSystem'


class AzureVmWorkloadSQLAvailabilityGroupProtectableItem(AzureVmWorkloadProtectableItem):
    """Azure VM workload-specific protectable item representing SQL Availability
    Group.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protectable_item_type: Required. Constant filled by server.
    :type protectable_item_type: str
    :param parent_name: Name for instance or AG
    :type parent_name: str
    :param parent_unique_name: Parent Unique Name is added to provide the
     service formatted URI Name of the Parent
     Only Applicable for data bases where the parent would be either Instance
     or a SQL AG.
    :type parent_unique_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param is_auto_protectable: Indicates if protectable item is
     auto-protectable
    :type is_auto_protectable: bool
    :param is_auto_protected: Indicates if protectable item is auto-protected
    :type is_auto_protected: bool
    :param subinquireditemcount: For instance or AG, indicates number of DB's
     present
    :type subinquireditemcount: int
    :param subprotectableitemcount: For instance or AG, indicates number of
     DB's to be protected
    :type subprotectableitemcount: int
    :param prebackupvalidation: Pre-backup validation for protectable objects
    :type prebackupvalidation:
     ~azure.mgmt.recoveryservicesbackup.models.PreBackupValidation
    """

    _validation = {
        'protectable_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protectable_item_type': {'key': 'protectableItemType', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'parent_unique_name': {'key': 'parentUniqueName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'is_auto_protectable': {'key': 'isAutoProtectable', 'type': 'bool'},
        'is_auto_protected': {'key': 'isAutoProtected', 'type': 'bool'},
        'subinquireditemcount': {'key': 'subinquireditemcount', 'type': 'int'},
        'subprotectableitemcount': {'key': 'subprotectableitemcount', 'type': 'int'},
        'prebackupvalidation': {'key': 'prebackupvalidation', 'type': 'PreBackupValidation'},
    }

    def __init__(self, **kwargs):
        super(AzureVmWorkloadSQLAvailabilityGroupProtectableItem, self).__init__(**kwargs)
        self.protectable_item_type = 'SQLAvailabilityGroupContainer'


class AzureVmWorkloadSQLDatabaseProtectableItem(AzureVmWorkloadProtectableItem):
    """Azure VM workload-specific protectable item representing SQL Database.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protectable_item_type: Required. Constant filled by server.
    :type protectable_item_type: str
    :param parent_name: Name for instance or AG
    :type parent_name: str
    :param parent_unique_name: Parent Unique Name is added to provide the
     service formatted URI Name of the Parent
     Only Applicable for data bases where the parent would be either Instance
     or a SQL AG.
    :type parent_unique_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param is_auto_protectable: Indicates if protectable item is
     auto-protectable
    :type is_auto_protectable: bool
    :param is_auto_protected: Indicates if protectable item is auto-protected
    :type is_auto_protected: bool
    :param subinquireditemcount: For instance or AG, indicates number of DB's
     present
    :type subinquireditemcount: int
    :param subprotectableitemcount: For instance or AG, indicates number of
     DB's to be protected
    :type subprotectableitemcount: int
    :param prebackupvalidation: Pre-backup validation for protectable objects
    :type prebackupvalidation:
     ~azure.mgmt.recoveryservicesbackup.models.PreBackupValidation
    """

    _validation = {
        'protectable_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protectable_item_type': {'key': 'protectableItemType', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'parent_unique_name': {'key': 'parentUniqueName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'is_auto_protectable': {'key': 'isAutoProtectable', 'type': 'bool'},
        'is_auto_protected': {'key': 'isAutoProtected', 'type': 'bool'},
        'subinquireditemcount': {'key': 'subinquireditemcount', 'type': 'int'},
        'subprotectableitemcount': {'key': 'subprotectableitemcount', 'type': 'int'},
        'prebackupvalidation': {'key': 'prebackupvalidation', 'type': 'PreBackupValidation'},
    }

    def __init__(self, **kwargs):
        super(AzureVmWorkloadSQLDatabaseProtectableItem, self).__init__(**kwargs)
        self.protectable_item_type = 'SQLDataBase'


class AzureVmWorkloadSQLDatabaseProtectedItem(AzureVmWorkloadProtectedItem):
    """Azure VM workload-specific protected item representing SQL Database.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param workload_type: Type of workload this item represents. Possible
     values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB',
     'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataSourceType
    :param container_name: Unique name of container
    :type container_name: str
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param last_recovery_point: Timestamp when the last (latest) backup copy
     was created for this backup item.
    :type last_recovery_point: datetime
    :param backup_set_name: Name of the backup set the backup item belongs to
    :type backup_set_name: str
    :param create_mode: Create mode to indicate recovery of existing soft
     deleted data source or creation of new data source. Possible values
     include: 'Invalid', 'Default', 'Recover'
    :type create_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.CreateMode
    :param deferred_delete_time_in_utc: Time for deferred deletion in UTC
    :type deferred_delete_time_in_utc: datetime
    :param is_scheduled_for_deferred_delete: Flag to identify whether the DS
     is scheduled for deferred delete
    :type is_scheduled_for_deferred_delete: bool
    :param deferred_delete_time_remaining: Time remaining before the DS marked
     for deferred delete is permanently deleted
    :type deferred_delete_time_remaining: str
    :param is_deferred_delete_schedule_upcoming: Flag to identify whether the
     deferred deleted DS is to be purged soon
    :type is_deferred_delete_schedule_upcoming: bool
    :param is_rehydrate: Flag to identify that deferred deleted DS is to be
     moved into Pause state
    :type is_rehydrate: bool
    :param protected_item_type: Required. Constant filled by server.
    :type protected_item_type: str
    :param friendly_name: Friendly name of the DB represented by this backup
     item.
    :type friendly_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param parent_name: Parent name of the DB such as Instance or Availability
     Group.
    :type parent_name: str
    :param parent_type: Parent type of protected item, example: for a DB,
     standalone server or distributed
    :type parent_type: str
    :param protection_status: Backup status of this backup item.
    :type protection_status: str
    :param protection_state: Backup state of this backup item. Possible values
     include: 'Invalid', 'IRPending', 'Protected', 'ProtectionError',
     'ProtectionStopped', 'ProtectionPaused'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionState
    :param last_backup_status: Last backup operation status. Possible values:
     Healthy, Unhealthy. Possible values include: 'Invalid', 'Healthy',
     'Unhealthy', 'IRPending'
    :type last_backup_status: str or
     ~azure.mgmt.recoveryservicesbackup.models.LastBackupStatus
    :param last_backup_time: Timestamp of the last backup operation on this
     backup item.
    :type last_backup_time: datetime
    :param last_backup_error_detail: Error details in last backup
    :type last_backup_error_detail:
     ~azure.mgmt.recoveryservicesbackup.models.ErrorDetail
    :param protected_item_data_source_id: Data ID of the protected item.
    :type protected_item_data_source_id: str
    :param protected_item_health_status: Health status of the backup item,
     evaluated based on last heartbeat received. Possible values include:
     'Invalid', 'Healthy', 'Unhealthy', 'NotReachable', 'IRPending'
    :type protected_item_health_status: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectedItemHealthStatus
    :param extended_info: Additional information for this backup item.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureVmWorkloadProtectedItemExtendedInfo
    """

    _validation = {
        'protected_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'last_recovery_point': {'key': 'lastRecoveryPoint', 'type': 'iso-8601'},
        'backup_set_name': {'key': 'backupSetName', 'type': 'str'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'deferred_delete_time_in_utc': {'key': 'deferredDeleteTimeInUTC', 'type': 'iso-8601'},
        'is_scheduled_for_deferred_delete': {'key': 'isScheduledForDeferredDelete', 'type': 'bool'},
        'deferred_delete_time_remaining': {'key': 'deferredDeleteTimeRemaining', 'type': 'str'},
        'is_deferred_delete_schedule_upcoming': {'key': 'isDeferredDeleteScheduleUpcoming', 'type': 'bool'},
        'is_rehydrate': {'key': 'isRehydrate', 'type': 'bool'},
        'protected_item_type': {'key': 'protectedItemType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'parent_type': {'key': 'parentType', 'type': 'str'},
        'protection_status': {'key': 'protectionStatus', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'last_backup_status': {'key': 'lastBackupStatus', 'type': 'str'},
        'last_backup_time': {'key': 'lastBackupTime', 'type': 'iso-8601'},
        'last_backup_error_detail': {'key': 'lastBackupErrorDetail', 'type': 'ErrorDetail'},
        'protected_item_data_source_id': {'key': 'protectedItemDataSourceId', 'type': 'str'},
        'protected_item_health_status': {'key': 'protectedItemHealthStatus', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureVmWorkloadProtectedItemExtendedInfo'},
    }

    def __init__(self, **kwargs):
        super(AzureVmWorkloadSQLDatabaseProtectedItem, self).__init__(**kwargs)
        self.protected_item_type = 'AzureVmWorkloadSQLDatabase'


class AzureVmWorkloadSQLDatabaseWorkloadItem(AzureVmWorkloadItem):
    """Azure VM workload-specific workload item representing SQL Database.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param workload_item_type: Required. Constant filled by server.
    :type workload_item_type: str
    :param parent_name: Name for instance or AG
    :type parent_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param is_auto_protectable: Indicates if workload item is auto-protectable
    :type is_auto_protectable: bool
    :param subinquireditemcount: For instance or AG, indicates number of DB's
     present
    :type subinquireditemcount: int
    :param sub_workload_item_count: For instance or AG, indicates number of
     DB's to be protected
    :type sub_workload_item_count: int
    """

    _validation = {
        'workload_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'workload_item_type': {'key': 'workloadItemType', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'is_auto_protectable': {'key': 'isAutoProtectable', 'type': 'bool'},
        'subinquireditemcount': {'key': 'subinquireditemcount', 'type': 'int'},
        'sub_workload_item_count': {'key': 'subWorkloadItemCount', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(AzureVmWorkloadSQLDatabaseWorkloadItem, self).__init__(**kwargs)
        self.workload_item_type = 'SQLDataBase'


class AzureVmWorkloadSQLInstanceProtectableItem(AzureVmWorkloadProtectableItem):
    """Azure VM workload-specific protectable item representing SQL Instance.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protectable_item_type: Required. Constant filled by server.
    :type protectable_item_type: str
    :param parent_name: Name for instance or AG
    :type parent_name: str
    :param parent_unique_name: Parent Unique Name is added to provide the
     service formatted URI Name of the Parent
     Only Applicable for data bases where the parent would be either Instance
     or a SQL AG.
    :type parent_unique_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param is_auto_protectable: Indicates if protectable item is
     auto-protectable
    :type is_auto_protectable: bool
    :param is_auto_protected: Indicates if protectable item is auto-protected
    :type is_auto_protected: bool
    :param subinquireditemcount: For instance or AG, indicates number of DB's
     present
    :type subinquireditemcount: int
    :param subprotectableitemcount: For instance or AG, indicates number of
     DB's to be protected
    :type subprotectableitemcount: int
    :param prebackupvalidation: Pre-backup validation for protectable objects
    :type prebackupvalidation:
     ~azure.mgmt.recoveryservicesbackup.models.PreBackupValidation
    """

    _validation = {
        'protectable_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protectable_item_type': {'key': 'protectableItemType', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'parent_unique_name': {'key': 'parentUniqueName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'is_auto_protectable': {'key': 'isAutoProtectable', 'type': 'bool'},
        'is_auto_protected': {'key': 'isAutoProtected', 'type': 'bool'},
        'subinquireditemcount': {'key': 'subinquireditemcount', 'type': 'int'},
        'subprotectableitemcount': {'key': 'subprotectableitemcount', 'type': 'int'},
        'prebackupvalidation': {'key': 'prebackupvalidation', 'type': 'PreBackupValidation'},
    }

    def __init__(self, **kwargs):
        super(AzureVmWorkloadSQLInstanceProtectableItem, self).__init__(**kwargs)
        self.protectable_item_type = 'SQLInstance'


class AzureVmWorkloadSQLInstanceWorkloadItem(AzureVmWorkloadItem):
    """Azure VM workload-specific workload item representing SQL Instance.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management to backup an
     item.
    :type backup_management_type: str
    :param workload_type: Type of workload for the backup management
    :type workload_type: str
    :param friendly_name: Friendly name of the backup item.
    :type friendly_name: str
    :param protection_state: State of the back up item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param workload_item_type: Required. Constant filled by server.
    :type workload_item_type: str
    :param parent_name: Name for instance or AG
    :type parent_name: str
    :param server_name: Host/Cluster Name for instance or AG
    :type server_name: str
    :param is_auto_protectable: Indicates if workload item is auto-protectable
    :type is_auto_protectable: bool
    :param subinquireditemcount: For instance or AG, indicates number of DB's
     present
    :type subinquireditemcount: int
    :param sub_workload_item_count: For instance or AG, indicates number of
     DB's to be protected
    :type sub_workload_item_count: int
    :param data_directory_paths: Data Directory Paths for default directories
    :type data_directory_paths:
     list[~azure.mgmt.recoveryservicesbackup.models.SQLDataDirectory]
    """

    _validation = {
        'workload_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'workload_item_type': {'key': 'workloadItemType', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'is_auto_protectable': {'key': 'isAutoProtectable', 'type': 'bool'},
        'subinquireditemcount': {'key': 'subinquireditemcount', 'type': 'int'},
        'sub_workload_item_count': {'key': 'subWorkloadItemCount', 'type': 'int'},
        'data_directory_paths': {'key': 'dataDirectoryPaths', 'type': '[SQLDataDirectory]'},
    }

    def __init__(self, **kwargs):
        super(AzureVmWorkloadSQLInstanceWorkloadItem, self).__init__(**kwargs)
        self.data_directory_paths = kwargs.get('data_directory_paths', None)
        self.workload_item_type = 'SQLInstance'


class AzureWorkloadAutoProtectionIntent(AzureRecoveryServiceVaultProtectionIntent):
    """Azure Recovery Services Vault specific protection intent item.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureWorkloadSQLAutoProtectionIntent

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param item_id: ID of the item which is getting protected, In case of
     Azure Vm , it is ProtectedItemId
    :type item_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param protection_state: Backup state of this backup item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protection_intent_item_type: Required. Constant filled by server.
    :type protection_intent_item_type: str
    """

    _validation = {
        'protection_intent_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'item_id': {'key': 'itemId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protection_intent_item_type': {'key': 'protectionIntentItemType', 'type': 'str'},
    }

    _subtype_map = {
        'protection_intent_item_type': {'AzureWorkloadSQLAutoProtectionIntent': 'AzureWorkloadSQLAutoProtectionIntent'}
    }

    def __init__(self, **kwargs):
        super(AzureWorkloadAutoProtectionIntent, self).__init__(**kwargs)
        self.protection_intent_item_type = 'AzureWorkloadAutoProtectionIntent'


class AzureWorkloadBackupRequest(BackupRequest):
    """AzureWorkload workload-specific backup request.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param backup_type: Type of backup, viz. Full, Differential, Log or
     CopyOnlyFull. Possible values include: 'Invalid', 'Full', 'Differential',
     'Log', 'CopyOnlyFull'
    :type backup_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupType
    :param enable_compression: Bool for Compression setting
    :type enable_compression: bool
    :param recovery_point_expiry_time_in_utc: Backup copy will expire after
     the time specified (UTC).
    :type recovery_point_expiry_time_in_utc: datetime
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'backup_type': {'key': 'backupType', 'type': 'str'},
        'enable_compression': {'key': 'enableCompression', 'type': 'bool'},
        'recovery_point_expiry_time_in_utc': {'key': 'recoveryPointExpiryTimeInUTC', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(AzureWorkloadBackupRequest, self).__init__(**kwargs)
        self.backup_type = kwargs.get('backup_type', None)
        self.enable_compression = kwargs.get('enable_compression', None)
        self.recovery_point_expiry_time_in_utc = kwargs.get('recovery_point_expiry_time_in_utc', None)
        self.object_type = 'AzureWorkloadBackupRequest'


class AzureWorkloadContainerExtendedInfo(Model):
    """Extended information of the container.

    :param host_server_name: Host Os Name in case of Stand Alone and Cluster
     Name in case of distributed container.
    :type host_server_name: str
    :param inquiry_info: Inquiry Status for the container.
    :type inquiry_info: ~azure.mgmt.recoveryservicesbackup.models.InquiryInfo
    :param nodes_list: List of the nodes in case of distributed container.
    :type nodes_list:
     list[~azure.mgmt.recoveryservicesbackup.models.DistributedNodesInfo]
    """

    _attribute_map = {
        'host_server_name': {'key': 'hostServerName', 'type': 'str'},
        'inquiry_info': {'key': 'inquiryInfo', 'type': 'InquiryInfo'},
        'nodes_list': {'key': 'nodesList', 'type': '[DistributedNodesInfo]'},
    }

    def __init__(self, **kwargs):
        super(AzureWorkloadContainerExtendedInfo, self).__init__(**kwargs)
        self.host_server_name = kwargs.get('host_server_name', None)
        self.inquiry_info = kwargs.get('inquiry_info', None)
        self.nodes_list = kwargs.get('nodes_list', None)


class AzureWorkloadErrorInfo(Model):
    """Azure storage specific error information.

    :param error_code: Error code.
    :type error_code: int
    :param error_string: Localized error string.
    :type error_string: str
    :param error_title: Title: Typically, the entity that the error pertains
     to.
    :type error_title: str
    :param recommendations: List of localized recommendations for above error
     code.
    :type recommendations: list[str]
    :param additional_details: Additional details for above error code.
    :type additional_details: str
    """

    _attribute_map = {
        'error_code': {'key': 'errorCode', 'type': 'int'},
        'error_string': {'key': 'errorString', 'type': 'str'},
        'error_title': {'key': 'errorTitle', 'type': 'str'},
        'recommendations': {'key': 'recommendations', 'type': '[str]'},
        'additional_details': {'key': 'additionalDetails', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureWorkloadErrorInfo, self).__init__(**kwargs)
        self.error_code = kwargs.get('error_code', None)
        self.error_string = kwargs.get('error_string', None)
        self.error_title = kwargs.get('error_title', None)
        self.recommendations = kwargs.get('recommendations', None)
        self.additional_details = kwargs.get('additional_details', None)


class AzureWorkloadJob(Job):
    """Azure storage specific job.

    All required parameters must be populated in order to send to Azure.

    :param entity_friendly_name: Friendly name of the entity on which the
     current job is executing.
    :type entity_friendly_name: str
    :param backup_management_type: Backup management type to execute the
     current job. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param operation: The operation name.
    :type operation: str
    :param status: Job status.
    :type status: str
    :param start_time: The start time.
    :type start_time: datetime
    :param end_time: The end time.
    :type end_time: datetime
    :param activity_id: ActivityId of job.
    :type activity_id: str
    :param job_type: Required. Constant filled by server.
    :type job_type: str
    :param workload_type: Workload type of the job
    :type workload_type: str
    :param duration: Time elapsed during the execution of this job.
    :type duration: timedelta
    :param actions_info: Gets or sets the state/actions applicable on this job
     like cancel/retry.
    :type actions_info: list[str or
     ~azure.mgmt.recoveryservicesbackup.models.JobSupportedAction]
    :param error_details: Error details on execution of this job.
    :type error_details:
     list[~azure.mgmt.recoveryservicesbackup.models.AzureWorkloadErrorInfo]
    :param extended_info: Additional information about the job.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureWorkloadJobExtendedInfo
    """

    _validation = {
        'job_type': {'required': True},
    }

    _attribute_map = {
        'entity_friendly_name': {'key': 'entityFriendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'activity_id': {'key': 'activityId', 'type': 'str'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'duration': {'key': 'duration', 'type': 'duration'},
        'actions_info': {'key': 'actionsInfo', 'type': '[JobSupportedAction]'},
        'error_details': {'key': 'errorDetails', 'type': '[AzureWorkloadErrorInfo]'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureWorkloadJobExtendedInfo'},
    }

    def __init__(self, **kwargs):
        super(AzureWorkloadJob, self).__init__(**kwargs)
        self.workload_type = kwargs.get('workload_type', None)
        self.duration = kwargs.get('duration', None)
        self.actions_info = kwargs.get('actions_info', None)
        self.error_details = kwargs.get('error_details', None)
        self.extended_info = kwargs.get('extended_info', None)
        self.job_type = 'AzureWorkloadJob'


class AzureWorkloadJobExtendedInfo(Model):
    """Azure VM workload-specific additional information for job.

    :param tasks_list: List of tasks for this job
    :type tasks_list:
     list[~azure.mgmt.recoveryservicesbackup.models.AzureWorkloadJobTaskDetails]
    :param property_bag: Job properties.
    :type property_bag: dict[str, str]
    :param dynamic_error_message: Non localized error message on job
     execution.
    :type dynamic_error_message: str
    """

    _attribute_map = {
        'tasks_list': {'key': 'tasksList', 'type': '[AzureWorkloadJobTaskDetails]'},
        'property_bag': {'key': 'propertyBag', 'type': '{str}'},
        'dynamic_error_message': {'key': 'dynamicErrorMessage', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureWorkloadJobExtendedInfo, self).__init__(**kwargs)
        self.tasks_list = kwargs.get('tasks_list', None)
        self.property_bag = kwargs.get('property_bag', None)
        self.dynamic_error_message = kwargs.get('dynamic_error_message', None)


class AzureWorkloadJobTaskDetails(Model):
    """Azure VM workload specific job task details.

    :param task_id: The task display name.
    :type task_id: str
    :param status: The status.
    :type status: str
    """

    _attribute_map = {
        'task_id': {'key': 'taskId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureWorkloadJobTaskDetails, self).__init__(**kwargs)
        self.task_id = kwargs.get('task_id', None)
        self.status = kwargs.get('status', None)


class AzureWorkloadRecoveryPoint(RecoveryPoint):
    """Workload specific recovery point, specifically encapsulates full/diff
    recovery point.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureWorkloadPointInTimeRecoveryPoint,
    AzureWorkloadSAPHanaRecoveryPoint, AzureWorkloadSQLRecoveryPoint

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :ivar recovery_point_time_in_utc: UTC time at which recovery point was
     created
    :vartype recovery_point_time_in_utc: datetime
    :ivar type: Type of restore point. Possible values include: 'Invalid',
     'Full', 'Log', 'Differential'
    :vartype type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RestorePointType
    """

    _validation = {
        'object_type': {'required': True},
        'recovery_point_time_in_utc': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_point_time_in_utc': {'key': 'recoveryPointTimeInUTC', 'type': 'iso-8601'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'AzureWorkloadPointInTimeRecoveryPoint': 'AzureWorkloadPointInTimeRecoveryPoint', 'AzureWorkloadSAPHanaRecoveryPoint': 'AzureWorkloadSAPHanaRecoveryPoint', 'AzureWorkloadSQLRecoveryPoint': 'AzureWorkloadSQLRecoveryPoint'}
    }

    def __init__(self, **kwargs):
        super(AzureWorkloadRecoveryPoint, self).__init__(**kwargs)
        self.recovery_point_time_in_utc = None
        self.type = None
        self.object_type = 'AzureWorkloadRecoveryPoint'


class AzureWorkloadPointInTimeRecoveryPoint(AzureWorkloadRecoveryPoint):
    """Recovery point specific to PointInTime.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureWorkloadSAPHanaPointInTimeRecoveryPoint

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :ivar recovery_point_time_in_utc: UTC time at which recovery point was
     created
    :vartype recovery_point_time_in_utc: datetime
    :ivar type: Type of restore point. Possible values include: 'Invalid',
     'Full', 'Log', 'Differential'
    :vartype type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RestorePointType
    :param time_ranges: List of log ranges
    :type time_ranges:
     list[~azure.mgmt.recoveryservicesbackup.models.PointInTimeRange]
    """

    _validation = {
        'object_type': {'required': True},
        'recovery_point_time_in_utc': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_point_time_in_utc': {'key': 'recoveryPointTimeInUTC', 'type': 'iso-8601'},
        'type': {'key': 'type', 'type': 'str'},
        'time_ranges': {'key': 'timeRanges', 'type': '[PointInTimeRange]'},
    }

    _subtype_map = {
        'object_type': {'AzureWorkloadSAPHanaPointInTimeRecoveryPoint': 'AzureWorkloadSAPHanaPointInTimeRecoveryPoint'}
    }

    def __init__(self, **kwargs):
        super(AzureWorkloadPointInTimeRecoveryPoint, self).__init__(**kwargs)
        self.time_ranges = kwargs.get('time_ranges', None)
        self.object_type = 'AzureWorkloadPointInTimeRecoveryPoint'


class AzureWorkloadRestoreRequest(RestoreRequest):
    """AzureWorkload-specific restore.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureWorkloadPointInTimeRestoreRequest,
    AzureWorkloadSAPHanaRestoreRequest, AzureWorkloadSQLRestoreRequest

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param recovery_type: Type of this recovery. Possible values include:
     'Invalid', 'OriginalLocation', 'AlternateLocation', 'RestoreDisks',
     'Offline'
    :type recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryType
    :param source_resource_id: Fully qualified ARM ID of the VM on which
     workload that was running is being recovered.
    :type source_resource_id: str
    :param property_bag: Workload specific property bag.
    :type property_bag: dict[str, str]
    :param target_info: Details of target database
    :type target_info:
     ~azure.mgmt.recoveryservicesbackup.models.TargetRestoreInfo
    :param recovery_mode: Defines whether the current recovery mode is file
     restore or database restore. Possible values include: 'Invalid',
     'FileRecovery', 'WorkloadRecovery'
    :type recovery_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryMode
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_type': {'key': 'recoveryType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'property_bag': {'key': 'propertyBag', 'type': '{str}'},
        'target_info': {'key': 'targetInfo', 'type': 'TargetRestoreInfo'},
        'recovery_mode': {'key': 'recoveryMode', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'AzureWorkloadPointInTimeRestoreRequest': 'AzureWorkloadPointInTimeRestoreRequest', 'AzureWorkloadSAPHanaRestoreRequest': 'AzureWorkloadSAPHanaRestoreRequest', 'AzureWorkloadSQLRestoreRequest': 'AzureWorkloadSQLRestoreRequest'}
    }

    def __init__(self, **kwargs):
        super(AzureWorkloadRestoreRequest, self).__init__(**kwargs)
        self.recovery_type = kwargs.get('recovery_type', None)
        self.source_resource_id = kwargs.get('source_resource_id', None)
        self.property_bag = kwargs.get('property_bag', None)
        self.target_info = kwargs.get('target_info', None)
        self.recovery_mode = kwargs.get('recovery_mode', None)
        self.object_type = 'AzureWorkloadRestoreRequest'


class AzureWorkloadPointInTimeRestoreRequest(AzureWorkloadRestoreRequest):
    """AzureWorkload SAP Hana -specific restore. Specifically for PointInTime/Log
    restore.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param recovery_type: Type of this recovery. Possible values include:
     'Invalid', 'OriginalLocation', 'AlternateLocation', 'RestoreDisks',
     'Offline'
    :type recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryType
    :param source_resource_id: Fully qualified ARM ID of the VM on which
     workload that was running is being recovered.
    :type source_resource_id: str
    :param property_bag: Workload specific property bag.
    :type property_bag: dict[str, str]
    :param target_info: Details of target database
    :type target_info:
     ~azure.mgmt.recoveryservicesbackup.models.TargetRestoreInfo
    :param recovery_mode: Defines whether the current recovery mode is file
     restore or database restore. Possible values include: 'Invalid',
     'FileRecovery', 'WorkloadRecovery'
    :type recovery_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryMode
    :param point_in_time: PointInTime value
    :type point_in_time: datetime
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_type': {'key': 'recoveryType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'property_bag': {'key': 'propertyBag', 'type': '{str}'},
        'target_info': {'key': 'targetInfo', 'type': 'TargetRestoreInfo'},
        'recovery_mode': {'key': 'recoveryMode', 'type': 'str'},
        'point_in_time': {'key': 'pointInTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(AzureWorkloadPointInTimeRestoreRequest, self).__init__(**kwargs)
        self.point_in_time = kwargs.get('point_in_time', None)
        self.object_type = 'AzureWorkloadPointInTimeRestoreRequest'


class AzureWorkloadSAPHanaPointInTimeRecoveryPoint(AzureWorkloadPointInTimeRecoveryPoint):
    """Recovery point specific to PointInTime in SAPHana.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :ivar recovery_point_time_in_utc: UTC time at which recovery point was
     created
    :vartype recovery_point_time_in_utc: datetime
    :ivar type: Type of restore point. Possible values include: 'Invalid',
     'Full', 'Log', 'Differential'
    :vartype type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RestorePointType
    :param time_ranges: List of log ranges
    :type time_ranges:
     list[~azure.mgmt.recoveryservicesbackup.models.PointInTimeRange]
    """

    _validation = {
        'object_type': {'required': True},
        'recovery_point_time_in_utc': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_point_time_in_utc': {'key': 'recoveryPointTimeInUTC', 'type': 'iso-8601'},
        'type': {'key': 'type', 'type': 'str'},
        'time_ranges': {'key': 'timeRanges', 'type': '[PointInTimeRange]'},
    }

    def __init__(self, **kwargs):
        super(AzureWorkloadSAPHanaPointInTimeRecoveryPoint, self).__init__(**kwargs)
        self.object_type = 'AzureWorkloadSAPHanaPointInTimeRecoveryPoint'


class AzureWorkloadSAPHanaRestoreRequest(AzureWorkloadRestoreRequest):
    """AzureWorkload SAP Hana-specific restore.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureWorkloadSAPHanaPointInTimeRestoreRequest

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param recovery_type: Type of this recovery. Possible values include:
     'Invalid', 'OriginalLocation', 'AlternateLocation', 'RestoreDisks',
     'Offline'
    :type recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryType
    :param source_resource_id: Fully qualified ARM ID of the VM on which
     workload that was running is being recovered.
    :type source_resource_id: str
    :param property_bag: Workload specific property bag.
    :type property_bag: dict[str, str]
    :param target_info: Details of target database
    :type target_info:
     ~azure.mgmt.recoveryservicesbackup.models.TargetRestoreInfo
    :param recovery_mode: Defines whether the current recovery mode is file
     restore or database restore. Possible values include: 'Invalid',
     'FileRecovery', 'WorkloadRecovery'
    :type recovery_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryMode
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_type': {'key': 'recoveryType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'property_bag': {'key': 'propertyBag', 'type': '{str}'},
        'target_info': {'key': 'targetInfo', 'type': 'TargetRestoreInfo'},
        'recovery_mode': {'key': 'recoveryMode', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'AzureWorkloadSAPHanaPointInTimeRestoreRequest': 'AzureWorkloadSAPHanaPointInTimeRestoreRequest'}
    }

    def __init__(self, **kwargs):
        super(AzureWorkloadSAPHanaRestoreRequest, self).__init__(**kwargs)
        self.object_type = 'AzureWorkloadSAPHanaRestoreRequest'


class AzureWorkloadSAPHanaPointInTimeRestoreRequest(AzureWorkloadSAPHanaRestoreRequest):
    """AzureWorkload SAP Hana -specific restore. Specifically for PointInTime/Log
    restore.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param recovery_type: Type of this recovery. Possible values include:
     'Invalid', 'OriginalLocation', 'AlternateLocation', 'RestoreDisks',
     'Offline'
    :type recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryType
    :param source_resource_id: Fully qualified ARM ID of the VM on which
     workload that was running is being recovered.
    :type source_resource_id: str
    :param property_bag: Workload specific property bag.
    :type property_bag: dict[str, str]
    :param target_info: Details of target database
    :type target_info:
     ~azure.mgmt.recoveryservicesbackup.models.TargetRestoreInfo
    :param recovery_mode: Defines whether the current recovery mode is file
     restore or database restore. Possible values include: 'Invalid',
     'FileRecovery', 'WorkloadRecovery'
    :type recovery_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryMode
    :param point_in_time: PointInTime value
    :type point_in_time: datetime
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_type': {'key': 'recoveryType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'property_bag': {'key': 'propertyBag', 'type': '{str}'},
        'target_info': {'key': 'targetInfo', 'type': 'TargetRestoreInfo'},
        'recovery_mode': {'key': 'recoveryMode', 'type': 'str'},
        'point_in_time': {'key': 'pointInTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(AzureWorkloadSAPHanaPointInTimeRestoreRequest, self).__init__(**kwargs)
        self.point_in_time = kwargs.get('point_in_time', None)
        self.object_type = 'AzureWorkloadSAPHanaPointInTimeRestoreRequest'


class AzureWorkloadSAPHanaRecoveryPoint(AzureWorkloadRecoveryPoint):
    """SAPHana specific recoverypoint, specifically encapsulates full/diff
    recoverypoints.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :ivar recovery_point_time_in_utc: UTC time at which recovery point was
     created
    :vartype recovery_point_time_in_utc: datetime
    :ivar type: Type of restore point. Possible values include: 'Invalid',
     'Full', 'Log', 'Differential'
    :vartype type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RestorePointType
    """

    _validation = {
        'object_type': {'required': True},
        'recovery_point_time_in_utc': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_point_time_in_utc': {'key': 'recoveryPointTimeInUTC', 'type': 'iso-8601'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureWorkloadSAPHanaRecoveryPoint, self).__init__(**kwargs)
        self.object_type = 'AzureWorkloadSAPHanaRecoveryPoint'


class AzureWorkloadSQLAutoProtectionIntent(AzureWorkloadAutoProtectionIntent):
    """Azure Workload SQL Auto Protection intent item.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param item_id: ID of the item which is getting protected, In case of
     Azure Vm , it is ProtectedItemId
    :type item_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param protection_state: Backup state of this backup item. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param protection_intent_item_type: Required. Constant filled by server.
    :type protection_intent_item_type: str
    :param workload_item_type: Workload item type of the item for which intent
     is to be set. Possible values include: 'Invalid', 'SQLInstance',
     'SQLDataBase', 'SAPHanaSystem', 'SAPHanaDatabase', 'SAPAseSystem',
     'SAPAseDatabase'
    :type workload_item_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.WorkloadItemType
    """

    _validation = {
        'protection_intent_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'item_id': {'key': 'itemId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protection_intent_item_type': {'key': 'protectionIntentItemType', 'type': 'str'},
        'workload_item_type': {'key': 'workloadItemType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureWorkloadSQLAutoProtectionIntent, self).__init__(**kwargs)
        self.workload_item_type = kwargs.get('workload_item_type', None)
        self.protection_intent_item_type = 'AzureWorkloadSQLAutoProtectionIntent'


class AzureWorkloadSQLRecoveryPoint(AzureWorkloadRecoveryPoint):
    """SQL specific recoverypoint, specifically encapsulates full/diff
    recoverypoint along with extended info.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureWorkloadSQLPointInTimeRecoveryPoint

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :ivar recovery_point_time_in_utc: UTC time at which recovery point was
     created
    :vartype recovery_point_time_in_utc: datetime
    :ivar type: Type of restore point. Possible values include: 'Invalid',
     'Full', 'Log', 'Differential'
    :vartype type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RestorePointType
    :param extended_info: Extended Info that provides data directory details.
     Will be populated in two cases:
     When a specific recovery point is accessed using GetRecoveryPoint
     Or when ListRecoveryPoints is called for Log RP only with ExtendedInfo
     query filter
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureWorkloadSQLRecoveryPointExtendedInfo
    """

    _validation = {
        'object_type': {'required': True},
        'recovery_point_time_in_utc': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_point_time_in_utc': {'key': 'recoveryPointTimeInUTC', 'type': 'iso-8601'},
        'type': {'key': 'type', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureWorkloadSQLRecoveryPointExtendedInfo'},
    }

    _subtype_map = {
        'object_type': {'AzureWorkloadSQLPointInTimeRecoveryPoint': 'AzureWorkloadSQLPointInTimeRecoveryPoint'}
    }

    def __init__(self, **kwargs):
        super(AzureWorkloadSQLRecoveryPoint, self).__init__(**kwargs)
        self.extended_info = kwargs.get('extended_info', None)
        self.object_type = 'AzureWorkloadSQLRecoveryPoint'


class AzureWorkloadSQLPointInTimeRecoveryPoint(AzureWorkloadSQLRecoveryPoint):
    """Recovery point specific to PointInTime.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :ivar recovery_point_time_in_utc: UTC time at which recovery point was
     created
    :vartype recovery_point_time_in_utc: datetime
    :ivar type: Type of restore point. Possible values include: 'Invalid',
     'Full', 'Log', 'Differential'
    :vartype type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RestorePointType
    :param extended_info: Extended Info that provides data directory details.
     Will be populated in two cases:
     When a specific recovery point is accessed using GetRecoveryPoint
     Or when ListRecoveryPoints is called for Log RP only with ExtendedInfo
     query filter
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.AzureWorkloadSQLRecoveryPointExtendedInfo
    :param time_ranges: List of log ranges
    :type time_ranges:
     list[~azure.mgmt.recoveryservicesbackup.models.PointInTimeRange]
    """

    _validation = {
        'object_type': {'required': True},
        'recovery_point_time_in_utc': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_point_time_in_utc': {'key': 'recoveryPointTimeInUTC', 'type': 'iso-8601'},
        'type': {'key': 'type', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'AzureWorkloadSQLRecoveryPointExtendedInfo'},
        'time_ranges': {'key': 'timeRanges', 'type': '[PointInTimeRange]'},
    }

    def __init__(self, **kwargs):
        super(AzureWorkloadSQLPointInTimeRecoveryPoint, self).__init__(**kwargs)
        self.time_ranges = kwargs.get('time_ranges', None)
        self.object_type = 'AzureWorkloadSQLPointInTimeRecoveryPoint'


class AzureWorkloadSQLRestoreRequest(AzureWorkloadRestoreRequest):
    """AzureWorkload SQL -specific restore. Specifically for full/diff restore.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureWorkloadSQLPointInTimeRestoreRequest

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param recovery_type: Type of this recovery. Possible values include:
     'Invalid', 'OriginalLocation', 'AlternateLocation', 'RestoreDisks',
     'Offline'
    :type recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryType
    :param source_resource_id: Fully qualified ARM ID of the VM on which
     workload that was running is being recovered.
    :type source_resource_id: str
    :param property_bag: Workload specific property bag.
    :type property_bag: dict[str, str]
    :param target_info: Details of target database
    :type target_info:
     ~azure.mgmt.recoveryservicesbackup.models.TargetRestoreInfo
    :param recovery_mode: Defines whether the current recovery mode is file
     restore or database restore. Possible values include: 'Invalid',
     'FileRecovery', 'WorkloadRecovery'
    :type recovery_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryMode
    :param should_use_alternate_target_location: Default option set to true.
     If this is set to false, alternate data directory must be provided
    :type should_use_alternate_target_location: bool
    :param is_non_recoverable: SQL specific property where user can chose to
     set no-recovery when restore operation is tried
    :type is_non_recoverable: bool
    :param alternate_directory_paths: Data directory details
    :type alternate_directory_paths:
     list[~azure.mgmt.recoveryservicesbackup.models.SQLDataDirectoryMapping]
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_type': {'key': 'recoveryType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'property_bag': {'key': 'propertyBag', 'type': '{str}'},
        'target_info': {'key': 'targetInfo', 'type': 'TargetRestoreInfo'},
        'recovery_mode': {'key': 'recoveryMode', 'type': 'str'},
        'should_use_alternate_target_location': {'key': 'shouldUseAlternateTargetLocation', 'type': 'bool'},
        'is_non_recoverable': {'key': 'isNonRecoverable', 'type': 'bool'},
        'alternate_directory_paths': {'key': 'alternateDirectoryPaths', 'type': '[SQLDataDirectoryMapping]'},
    }

    _subtype_map = {
        'object_type': {'AzureWorkloadSQLPointInTimeRestoreRequest': 'AzureWorkloadSQLPointInTimeRestoreRequest'}
    }

    def __init__(self, **kwargs):
        super(AzureWorkloadSQLRestoreRequest, self).__init__(**kwargs)
        self.should_use_alternate_target_location = kwargs.get('should_use_alternate_target_location', None)
        self.is_non_recoverable = kwargs.get('is_non_recoverable', None)
        self.alternate_directory_paths = kwargs.get('alternate_directory_paths', None)
        self.object_type = 'AzureWorkloadSQLRestoreRequest'


class AzureWorkloadSQLPointInTimeRestoreRequest(AzureWorkloadSQLRestoreRequest):
    """AzureWorkload SQL -specific restore. Specifically for PointInTime/Log
    restore.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param recovery_type: Type of this recovery. Possible values include:
     'Invalid', 'OriginalLocation', 'AlternateLocation', 'RestoreDisks',
     'Offline'
    :type recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryType
    :param source_resource_id: Fully qualified ARM ID of the VM on which
     workload that was running is being recovered.
    :type source_resource_id: str
    :param property_bag: Workload specific property bag.
    :type property_bag: dict[str, str]
    :param target_info: Details of target database
    :type target_info:
     ~azure.mgmt.recoveryservicesbackup.models.TargetRestoreInfo
    :param recovery_mode: Defines whether the current recovery mode is file
     restore or database restore. Possible values include: 'Invalid',
     'FileRecovery', 'WorkloadRecovery'
    :type recovery_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryMode
    :param should_use_alternate_target_location: Default option set to true.
     If this is set to false, alternate data directory must be provided
    :type should_use_alternate_target_location: bool
    :param is_non_recoverable: SQL specific property where user can chose to
     set no-recovery when restore operation is tried
    :type is_non_recoverable: bool
    :param alternate_directory_paths: Data directory details
    :type alternate_directory_paths:
     list[~azure.mgmt.recoveryservicesbackup.models.SQLDataDirectoryMapping]
    :param point_in_time: PointInTime value
    :type point_in_time: datetime
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_type': {'key': 'recoveryType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'property_bag': {'key': 'propertyBag', 'type': '{str}'},
        'target_info': {'key': 'targetInfo', 'type': 'TargetRestoreInfo'},
        'recovery_mode': {'key': 'recoveryMode', 'type': 'str'},
        'should_use_alternate_target_location': {'key': 'shouldUseAlternateTargetLocation', 'type': 'bool'},
        'is_non_recoverable': {'key': 'isNonRecoverable', 'type': 'bool'},
        'alternate_directory_paths': {'key': 'alternateDirectoryPaths', 'type': '[SQLDataDirectoryMapping]'},
        'point_in_time': {'key': 'pointInTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(AzureWorkloadSQLPointInTimeRestoreRequest, self).__init__(**kwargs)
        self.point_in_time = kwargs.get('point_in_time', None)
        self.object_type = 'AzureWorkloadSQLPointInTimeRestoreRequest'


class AzureWorkloadSQLRecoveryPointExtendedInfo(Model):
    """Extended info class details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar data_directory_time_in_utc: UTC time at which data directory info
     was captured
    :vartype data_directory_time_in_utc: datetime
    :ivar data_directory_paths: List of data directory paths during restore
     operation.
    :vartype data_directory_paths:
     list[~azure.mgmt.recoveryservicesbackup.models.SQLDataDirectory]
    """

    _validation = {
        'data_directory_time_in_utc': {'readonly': True},
        'data_directory_paths': {'readonly': True},
    }

    _attribute_map = {
        'data_directory_time_in_utc': {'key': 'dataDirectoryTimeInUTC', 'type': 'iso-8601'},
        'data_directory_paths': {'key': 'dataDirectoryPaths', 'type': '[SQLDataDirectory]'},
    }

    def __init__(self, **kwargs):
        super(AzureWorkloadSQLRecoveryPointExtendedInfo, self).__init__(**kwargs)
        self.data_directory_time_in_utc = None
        self.data_directory_paths = None


class Resource(Model):
    """ARM Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)
        self.e_tag = kwargs.get('e_tag', None)


class BackupEngineBaseResource(Resource):
    """The base backup engine class. All workload specific backup engines derive
    from this class.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: BackupEngineBaseResource properties
    :type properties:
     ~azure.mgmt.recoveryservicesbackup.models.BackupEngineBase
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'BackupEngineBase'},
    }

    def __init__(self, **kwargs):
        super(BackupEngineBaseResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class BackupEngineExtendedInfo(Model):
    """Additional information on backup engine.

    :param database_name: Database name of backup engine.
    :type database_name: str
    :param protected_items_count: Number of protected items in the backup
     engine.
    :type protected_items_count: int
    :param protected_servers_count: Number of protected servers in the backup
     engine.
    :type protected_servers_count: int
    :param disk_count: Number of disks in the backup engine.
    :type disk_count: int
    :param used_disk_space: Disk space used in the backup engine.
    :type used_disk_space: float
    :param available_disk_space: Disk space currently available in the backup
     engine.
    :type available_disk_space: float
    :param refreshed_at: Last refresh time in the backup engine.
    :type refreshed_at: datetime
    :param azure_protected_instances: Protected instances in the backup
     engine.
    :type azure_protected_instances: int
    """

    _attribute_map = {
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'protected_items_count': {'key': 'protectedItemsCount', 'type': 'int'},
        'protected_servers_count': {'key': 'protectedServersCount', 'type': 'int'},
        'disk_count': {'key': 'diskCount', 'type': 'int'},
        'used_disk_space': {'key': 'usedDiskSpace', 'type': 'float'},
        'available_disk_space': {'key': 'availableDiskSpace', 'type': 'float'},
        'refreshed_at': {'key': 'refreshedAt', 'type': 'iso-8601'},
        'azure_protected_instances': {'key': 'azureProtectedInstances', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(BackupEngineExtendedInfo, self).__init__(**kwargs)
        self.database_name = kwargs.get('database_name', None)
        self.protected_items_count = kwargs.get('protected_items_count', None)
        self.protected_servers_count = kwargs.get('protected_servers_count', None)
        self.disk_count = kwargs.get('disk_count', None)
        self.used_disk_space = kwargs.get('used_disk_space', None)
        self.available_disk_space = kwargs.get('available_disk_space', None)
        self.refreshed_at = kwargs.get('refreshed_at', None)
        self.azure_protected_instances = kwargs.get('azure_protected_instances', None)


class BackupManagementUsage(Model):
    """Backup management usages of a vault.

    :param unit: Unit of the usage. Possible values include: 'Count', 'Bytes',
     'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond'
    :type unit: str or ~azure.mgmt.recoveryservicesbackup.models.UsagesUnit
    :param quota_period: Quota period of usage.
    :type quota_period: str
    :param next_reset_time: Next reset time of usage.
    :type next_reset_time: datetime
    :param current_value: Current value of usage.
    :type current_value: long
    :param limit: Limit of usage.
    :type limit: long
    :param name: Name of usage.
    :type name: ~azure.mgmt.recoveryservicesbackup.models.NameInfo
    """

    _attribute_map = {
        'unit': {'key': 'unit', 'type': 'str'},
        'quota_period': {'key': 'quotaPeriod', 'type': 'str'},
        'next_reset_time': {'key': 'nextResetTime', 'type': 'iso-8601'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'limit': {'key': 'limit', 'type': 'long'},
        'name': {'key': 'name', 'type': 'NameInfo'},
    }

    def __init__(self, **kwargs):
        super(BackupManagementUsage, self).__init__(**kwargs)
        self.unit = kwargs.get('unit', None)
        self.quota_period = kwargs.get('quota_period', None)
        self.next_reset_time = kwargs.get('next_reset_time', None)
        self.current_value = kwargs.get('current_value', None)
        self.limit = kwargs.get('limit', None)
        self.name = kwargs.get('name', None)


class BackupRequestResource(Resource):
    """Base class for backup request. Workload-specific backup requests are
    derived from this class.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: BackupRequestResource properties
    :type properties: ~azure.mgmt.recoveryservicesbackup.models.BackupRequest
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'BackupRequest'},
    }

    def __init__(self, **kwargs):
        super(BackupRequestResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class BackupResourceConfig(Model):
    """The resource storage details.

    :param storage_model_type: Storage type. Possible values include:
     'Invalid', 'GeoRedundant', 'LocallyRedundant'
    :type storage_model_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.StorageType
    :param storage_type: Storage type. Possible values include: 'Invalid',
     'GeoRedundant', 'LocallyRedundant'
    :type storage_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.StorageType
    :param storage_type_state: Locked or Unlocked. Once a machine is
     registered against a resource, the storageTypeState is always Locked.
     Possible values include: 'Invalid', 'Locked', 'Unlocked'
    :type storage_type_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.StorageTypeState
    """

    _attribute_map = {
        'storage_model_type': {'key': 'storageModelType', 'type': 'str'},
        'storage_type': {'key': 'storageType', 'type': 'str'},
        'storage_type_state': {'key': 'storageTypeState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(BackupResourceConfig, self).__init__(**kwargs)
        self.storage_model_type = kwargs.get('storage_model_type', None)
        self.storage_type = kwargs.get('storage_type', None)
        self.storage_type_state = kwargs.get('storage_type_state', None)


class BackupResourceConfigResource(Resource):
    """The resource storage details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: BackupResourceConfigResource properties
    :type properties:
     ~azure.mgmt.recoveryservicesbackup.models.BackupResourceConfig
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'BackupResourceConfig'},
    }

    def __init__(self, **kwargs):
        super(BackupResourceConfigResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class BackupResourceVaultConfig(Model):
    """Backup resource vault config details.

    :param storage_model_type: Storage type. Possible values include:
     'Invalid', 'GeoRedundant', 'LocallyRedundant'
    :type storage_model_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.StorageType
    :param storage_type: Storage type. Possible values include: 'Invalid',
     'GeoRedundant', 'LocallyRedundant'
    :type storage_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.StorageType
    :param storage_type_state: Locked or Unlocked. Once a machine is
     registered against a resource, the storageTypeState is always Locked.
     Possible values include: 'Invalid', 'Locked', 'Unlocked'
    :type storage_type_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.StorageTypeState
    :param enhanced_security_state: Enabled or Disabled. Possible values
     include: 'Invalid', 'Enabled', 'Disabled'
    :type enhanced_security_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.EnhancedSecurityState
    :param soft_delete_feature_state: Soft Delete feature state. Possible
     values include: 'Invalid', 'Enabled', 'Disabled'
    :type soft_delete_feature_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.SoftDeleteFeatureState
    """

    _attribute_map = {
        'storage_model_type': {'key': 'storageModelType', 'type': 'str'},
        'storage_type': {'key': 'storageType', 'type': 'str'},
        'storage_type_state': {'key': 'storageTypeState', 'type': 'str'},
        'enhanced_security_state': {'key': 'enhancedSecurityState', 'type': 'str'},
        'soft_delete_feature_state': {'key': 'softDeleteFeatureState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(BackupResourceVaultConfig, self).__init__(**kwargs)
        self.storage_model_type = kwargs.get('storage_model_type', None)
        self.storage_type = kwargs.get('storage_type', None)
        self.storage_type_state = kwargs.get('storage_type_state', None)
        self.enhanced_security_state = kwargs.get('enhanced_security_state', None)
        self.soft_delete_feature_state = kwargs.get('soft_delete_feature_state', None)


class BackupResourceVaultConfigResource(Resource):
    """Backup resource vault config details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: BackupResourceVaultConfigResource properties
    :type properties:
     ~azure.mgmt.recoveryservicesbackup.models.BackupResourceVaultConfig
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'BackupResourceVaultConfig'},
    }

    def __init__(self, **kwargs):
        super(BackupResourceVaultConfigResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class BackupStatusRequest(Model):
    """BackupStatus request.

    :param resource_type: Container Type - VM, SQLPaaS, DPM, AzureFileShare.
     Possible values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb',
     'SQLDB', 'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type resource_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataSourceType
    :param resource_id: Entire ARM resource id of the resource
    :type resource_id: str
    :param po_logical_name: Protectable Item Logical Name
    :type po_logical_name: str
    """

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'po_logical_name': {'key': 'poLogicalName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(BackupStatusRequest, self).__init__(**kwargs)
        self.resource_type = kwargs.get('resource_type', None)
        self.resource_id = kwargs.get('resource_id', None)
        self.po_logical_name = kwargs.get('po_logical_name', None)


class BackupStatusResponse(Model):
    """BackupStatus response.

    :param protection_status: Specifies whether the container is registered or
     not. Possible values include: 'Invalid', 'NotProtected', 'Protecting',
     'Protected', 'ProtectionFailed'
    :type protection_status: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    :param vault_id: Specifies the arm resource id of the vault
    :type vault_id: str
    :param fabric_name: Specifies the fabric name - Azure or AD. Possible
     values include: 'Invalid', 'Azure'
    :type fabric_name: str or
     ~azure.mgmt.recoveryservicesbackup.models.FabricName
    :param container_name: Specifies the product specific container name. E.g.
     iaasvmcontainer;iaasvmcontainer;csname;vmname.
    :type container_name: str
    :param protected_item_name: Specifies the product specific ds name. E.g.
     vm;iaasvmcontainer;csname;vmname.
    :type protected_item_name: str
    :param error_code: ErrorCode in case of intent failed
    :type error_code: str
    :param error_message: ErrorMessage in case of intent failed.
    :type error_message: str
    :param policy_name: Specifies the policy name which is used for protection
    :type policy_name: str
    :param registration_status: Container registration status
    :type registration_status: str
    """

    _attribute_map = {
        'protection_status': {'key': 'protectionStatus', 'type': 'str'},
        'vault_id': {'key': 'vaultId', 'type': 'str'},
        'fabric_name': {'key': 'fabricName', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'protected_item_name': {'key': 'protectedItemName', 'type': 'str'},
        'error_code': {'key': 'errorCode', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'policy_name': {'key': 'policyName', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(BackupStatusResponse, self).__init__(**kwargs)
        self.protection_status = kwargs.get('protection_status', None)
        self.vault_id = kwargs.get('vault_id', None)
        self.fabric_name = kwargs.get('fabric_name', None)
        self.container_name = kwargs.get('container_name', None)
        self.protected_item_name = kwargs.get('protected_item_name', None)
        self.error_code = kwargs.get('error_code', None)
        self.error_message = kwargs.get('error_message', None)
        self.policy_name = kwargs.get('policy_name', None)
        self.registration_status = kwargs.get('registration_status', None)


class BEKDetails(Model):
    """BEK is bitlocker encryption key.

    :param secret_url: Secret is BEK.
    :type secret_url: str
    :param secret_vault_id: ID of the Key Vault where this Secret is stored.
    :type secret_vault_id: str
    :param secret_data: BEK data.
    :type secret_data: str
    """

    _attribute_map = {
        'secret_url': {'key': 'secretUrl', 'type': 'str'},
        'secret_vault_id': {'key': 'secretVaultId', 'type': 'str'},
        'secret_data': {'key': 'secretData', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(BEKDetails, self).__init__(**kwargs)
        self.secret_url = kwargs.get('secret_url', None)
        self.secret_vault_id = kwargs.get('secret_vault_id', None)
        self.secret_data = kwargs.get('secret_data', None)


class BMSBackupEngineQueryObject(Model):
    """Query parameters to fetch list of backup engines.

    :param expand: attribute to add extended info
    :type expand: str
    """

    _attribute_map = {
        'expand': {'key': 'expand', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(BMSBackupEngineQueryObject, self).__init__(**kwargs)
        self.expand = kwargs.get('expand', None)


class BMSBackupEnginesQueryObject(Model):
    """Query parameters to fetch list of backup engines.

    :param backup_management_type: Backup management type for the backup
     engine. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param friendly_name: Friendly name of the backup engine.
    :type friendly_name: str
    :param expand: Attribute to add extended info.
    :type expand: str
    """

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'expand': {'key': 'expand', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(BMSBackupEnginesQueryObject, self).__init__(**kwargs)
        self.backup_management_type = kwargs.get('backup_management_type', None)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.expand = kwargs.get('expand', None)


class BMSBackupSummariesQueryObject(Model):
    """Query parameters to fetch backup summaries.

    :param type: Backup management type for this container. Possible values
     include: 'Invalid', 'BackupProtectedItemCountSummary',
     'BackupProtectionContainerCountSummary'
    :type type: str or ~azure.mgmt.recoveryservicesbackup.models.Type
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(BMSBackupSummariesQueryObject, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)


class BMSContainerQueryObject(Model):
    """The query filters that can be used with the list containers API.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Required. Backup management type for this
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param container_type: Type of container for filter. Possible values
     include: 'Invalid', 'Unknown', 'IaasVMContainer',
     'IaasVMServiceContainer', 'DPMContainer', 'AzureBackupServerContainer',
     'MABContainer', 'Cluster', 'AzureSqlContainer', 'Windows', 'VCenter',
     'VMAppContainer', 'SQLAGWorkLoadContainer', 'StorageContainer',
     'GenericContainer'
    :type container_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.ContainerType
    :param backup_engine_name: Backup engine name
    :type backup_engine_name: str
    :param fabric_name: Fabric name for filter
    :type fabric_name: str
    :param status: Status of registration of this container with the Recovery
     Services Vault.
    :type status: str
    :param friendly_name: Friendly name of this container.
    :type friendly_name: str
    """

    _validation = {
        'backup_management_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'container_type': {'key': 'containerType', 'type': 'str'},
        'backup_engine_name': {'key': 'backupEngineName', 'type': 'str'},
        'fabric_name': {'key': 'fabricName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(BMSContainerQueryObject, self).__init__(**kwargs)
        self.backup_management_type = kwargs.get('backup_management_type', None)
        self.container_type = kwargs.get('container_type', None)
        self.backup_engine_name = kwargs.get('backup_engine_name', None)
        self.fabric_name = kwargs.get('fabric_name', None)
        self.status = kwargs.get('status', None)
        self.friendly_name = kwargs.get('friendly_name', None)


class BMSContainersInquiryQueryObject(Model):
    """The query filters that can be used with the inquire container API.

    :param backup_management_type: Backup management type for this container.
     Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param workload_type: Workload type for this container. Possible values
     include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB', 'Exchange',
     'Sharepoint', 'VMwareVM', 'SystemState', 'Client', 'GenericDataSource',
     'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase', 'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.WorkloadType
    """

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(BMSContainersInquiryQueryObject, self).__init__(**kwargs)
        self.backup_management_type = kwargs.get('backup_management_type', None)
        self.workload_type = kwargs.get('workload_type', None)


class BMSPOQueryObject(Model):
    """Filters to list items that can be backed up.

    :param backup_management_type: Backup management type. Possible values
     include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM', 'AzureBackupServer',
     'AzureSql', 'AzureStorage', 'AzureWorkload', 'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param workload_type: Workload type. Possible values include: 'Invalid',
     'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB', 'Exchange', 'Sharepoint',
     'VMwareVM', 'SystemState', 'Client', 'GenericDataSource', 'SQLDataBase',
     'AzureFileShare', 'SAPHanaDatabase', 'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.WorkloadType
    :param container_name: Full name of the container whose Protectable
     Objects should be returned.
    :type container_name: str
    :param status: Backup status query parameter.
    :type status: str
    :param friendly_name: Friendly name.
    :type friendly_name: str
    """

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(BMSPOQueryObject, self).__init__(**kwargs)
        self.backup_management_type = kwargs.get('backup_management_type', None)
        self.workload_type = kwargs.get('workload_type', None)
        self.container_name = kwargs.get('container_name', None)
        self.status = kwargs.get('status', None)
        self.friendly_name = kwargs.get('friendly_name', None)


class BMSRefreshContainersQueryObject(Model):
    """The query filters that can be used with the refresh container API.

    :param backup_management_type: Backup management type for this container.
     Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    """

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(BMSRefreshContainersQueryObject, self).__init__(**kwargs)
        self.backup_management_type = kwargs.get('backup_management_type', None)


class BMSRPQueryObject(Model):
    """Filters to list backup copies.

    :param start_date: Backup copies created after this time.
    :type start_date: datetime
    :param end_date: Backup copies created before this time.
    :type end_date: datetime
    :param restore_point_query_type: RestorePoint type. Possible values
     include: 'Invalid', 'Full', 'Log', 'Differential', 'FullAndDifferential',
     'All'
    :type restore_point_query_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RestorePointQueryType
    :param extended_info: In Get Recovery Point, it tells whether extended
     information about recovery point is asked.
    :type extended_info: bool
    """

    _attribute_map = {
        'start_date': {'key': 'startDate', 'type': 'iso-8601'},
        'end_date': {'key': 'endDate', 'type': 'iso-8601'},
        'restore_point_query_type': {'key': 'restorePointQueryType', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(BMSRPQueryObject, self).__init__(**kwargs)
        self.start_date = kwargs.get('start_date', None)
        self.end_date = kwargs.get('end_date', None)
        self.restore_point_query_type = kwargs.get('restore_point_query_type', None)
        self.extended_info = kwargs.get('extended_info', None)


class BMSWorkloadItemQueryObject(Model):
    """Filters to list items that can be backed up.

    :param backup_management_type: Backup management type. Possible values
     include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM', 'AzureBackupServer',
     'AzureSql', 'AzureStorage', 'AzureWorkload', 'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param workload_item_type: Workload Item type. Possible values include:
     'Invalid', 'SQLInstance', 'SQLDataBase', 'SAPHanaSystem',
     'SAPHanaDatabase', 'SAPAseSystem', 'SAPAseDatabase'
    :type workload_item_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.WorkloadItemType
    :param workload_type: Workload type. Possible values include: 'Invalid',
     'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB', 'Exchange', 'Sharepoint',
     'VMwareVM', 'SystemState', 'Client', 'GenericDataSource', 'SQLDataBase',
     'AzureFileShare', 'SAPHanaDatabase', 'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.WorkloadType
    :param protection_status: Backup status query parameter. Possible values
     include: 'Invalid', 'NotProtected', 'Protecting', 'Protected',
     'ProtectionFailed'
    :type protection_status: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionStatus
    """

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_item_type': {'key': 'workloadItemType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'protection_status': {'key': 'protectionStatus', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(BMSWorkloadItemQueryObject, self).__init__(**kwargs)
        self.backup_management_type = kwargs.get('backup_management_type', None)
        self.workload_item_type = kwargs.get('workload_item_type', None)
        self.workload_type = kwargs.get('workload_type', None)
        self.protection_status = kwargs.get('protection_status', None)


class ClientDiscoveryDisplay(Model):
    """Localized display information of an operation.

    :param provider: Name of the provider for display purposes
    :type provider: str
    :param resource: ResourceType for which this Operation can be performed.
    :type resource: str
    :param operation: Operations Name itself.
    :type operation: str
    :param description: Description of the operation having details of what
     operation is about.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ClientDiscoveryDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class ClientDiscoveryForLogSpecification(Model):
    """Class to represent shoebox log specification in json client discovery.

    :param name: Name for shoebox log specification.
    :type name: str
    :param display_name: Localized display name
    :type display_name: str
    :param blob_duration: blob duration of shoebox log specification
    :type blob_duration: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ClientDiscoveryForLogSpecification, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.blob_duration = kwargs.get('blob_duration', None)


class ClientDiscoveryForProperties(Model):
    """Class to represent shoebox properties in json client discovery.

    :param service_specification: Operation properties.
    :type service_specification:
     ~azure.mgmt.recoveryservicesbackup.models.ClientDiscoveryForServiceSpecification
    """

    _attribute_map = {
        'service_specification': {'key': 'serviceSpecification', 'type': 'ClientDiscoveryForServiceSpecification'},
    }

    def __init__(self, **kwargs):
        super(ClientDiscoveryForProperties, self).__init__(**kwargs)
        self.service_specification = kwargs.get('service_specification', None)


class ClientDiscoveryForServiceSpecification(Model):
    """Class to represent shoebox service specification in json client discovery.

    :param log_specifications: List of log specifications of this operation.
    :type log_specifications:
     list[~azure.mgmt.recoveryservicesbackup.models.ClientDiscoveryForLogSpecification]
    """

    _attribute_map = {
        'log_specifications': {'key': 'logSpecifications', 'type': '[ClientDiscoveryForLogSpecification]'},
    }

    def __init__(self, **kwargs):
        super(ClientDiscoveryForServiceSpecification, self).__init__(**kwargs)
        self.log_specifications = kwargs.get('log_specifications', None)


class ClientDiscoveryValueForSingleApi(Model):
    """Available operation details.

    :param name: Name of the Operation.
    :type name: str
    :param display: Contains the localized display information for this
     particular operation
    :type display:
     ~azure.mgmt.recoveryservicesbackup.models.ClientDiscoveryDisplay
    :param origin: The intended executor of the operation;governs the display
     of the operation in the RBAC UX and the audit logs UX
    :type origin: str
    :param properties: ShoeBox properties for the given operation.
    :type properties:
     ~azure.mgmt.recoveryservicesbackup.models.ClientDiscoveryForProperties
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'ClientDiscoveryDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ClientDiscoveryForProperties'},
    }

    def __init__(self, **kwargs):
        super(ClientDiscoveryValueForSingleApi, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)
        self.origin = kwargs.get('origin', None)
        self.properties = kwargs.get('properties', None)


class ClientScriptForConnect(Model):
    """Client script details for file / folder restore.

    :param script_content: File content of the client script for file / folder
     restore.
    :type script_content: str
    :param script_extension: File extension of the client script for file /
     folder restore - .ps1 , .sh , etc.
    :type script_extension: str
    :param os_type: OS type - Windows, Linux etc. for which this file / folder
     restore client script works.
    :type os_type: str
    :param url: URL of Executable from where to source the content. If this is
     not null then ScriptContent should not be used
    :type url: str
    :param script_name_suffix: Mandatory suffix that should be added to the
     name of script that is given for download to user.
     If its null or empty then , ignore it.
    :type script_name_suffix: str
    """

    _attribute_map = {
        'script_content': {'key': 'scriptContent', 'type': 'str'},
        'script_extension': {'key': 'scriptExtension', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'script_name_suffix': {'key': 'scriptNameSuffix', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ClientScriptForConnect, self).__init__(**kwargs)
        self.script_content = kwargs.get('script_content', None)
        self.script_extension = kwargs.get('script_extension', None)
        self.os_type = kwargs.get('os_type', None)
        self.url = kwargs.get('url', None)
        self.script_name_suffix = kwargs.get('script_name_suffix', None)


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class ContainerIdentityInfo(Model):
    """Container identity information.

    :param unique_name: Unique name of the container
    :type unique_name: str
    :param aad_tenant_id: Protection container identity - AAD Tenant
    :type aad_tenant_id: str
    :param service_principal_client_id: Protection container identity - AAD
     Service Principal
    :type service_principal_client_id: str
    :param audience: Protection container identity - Audience
    :type audience: str
    """

    _attribute_map = {
        'unique_name': {'key': 'uniqueName', 'type': 'str'},
        'aad_tenant_id': {'key': 'aadTenantId', 'type': 'str'},
        'service_principal_client_id': {'key': 'servicePrincipalClientId', 'type': 'str'},
        'audience': {'key': 'audience', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ContainerIdentityInfo, self).__init__(**kwargs)
        self.unique_name = kwargs.get('unique_name', None)
        self.aad_tenant_id = kwargs.get('aad_tenant_id', None)
        self.service_principal_client_id = kwargs.get('service_principal_client_id', None)
        self.audience = kwargs.get('audience', None)


class DailyRetentionFormat(Model):
    """Daily retention format.

    :param days_of_the_month: List of days of the month.
    :type days_of_the_month:
     list[~azure.mgmt.recoveryservicesbackup.models.Day]
    """

    _attribute_map = {
        'days_of_the_month': {'key': 'daysOfTheMonth', 'type': '[Day]'},
    }

    def __init__(self, **kwargs):
        super(DailyRetentionFormat, self).__init__(**kwargs)
        self.days_of_the_month = kwargs.get('days_of_the_month', None)


class DailyRetentionSchedule(Model):
    """Daily retention schedule.

    :param retention_times: Retention times of retention policy.
    :type retention_times: list[datetime]
    :param retention_duration: Retention duration of retention Policy.
    :type retention_duration:
     ~azure.mgmt.recoveryservicesbackup.models.RetentionDuration
    """

    _attribute_map = {
        'retention_times': {'key': 'retentionTimes', 'type': '[iso-8601]'},
        'retention_duration': {'key': 'retentionDuration', 'type': 'RetentionDuration'},
    }

    def __init__(self, **kwargs):
        super(DailyRetentionSchedule, self).__init__(**kwargs)
        self.retention_times = kwargs.get('retention_times', None)
        self.retention_duration = kwargs.get('retention_duration', None)


class Day(Model):
    """Day of the week.

    :param date_property: Date of the month
    :type date_property: int
    :param is_last: Whether Date is last date of month
    :type is_last: bool
    """

    _attribute_map = {
        'date_property': {'key': 'date', 'type': 'int'},
        'is_last': {'key': 'isLast', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(Day, self).__init__(**kwargs)
        self.date_property = kwargs.get('date_property', None)
        self.is_last = kwargs.get('is_last', None)


class DiskExclusionProperties(Model):
    """DiskExclusionProperties.

    :param disk_lun_list: List of Disks' Logical Unit Numbers (LUN) to be used
     for VM Protection.
    :type disk_lun_list: list[int]
    :param is_inclusion_list: Flag to indicate whether DiskLunList is to be
     included/ excluded from backup.
    :type is_inclusion_list: bool
    """

    _attribute_map = {
        'disk_lun_list': {'key': 'diskLunList', 'type': '[int]'},
        'is_inclusion_list': {'key': 'isInclusionList', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(DiskExclusionProperties, self).__init__(**kwargs)
        self.disk_lun_list = kwargs.get('disk_lun_list', None)
        self.is_inclusion_list = kwargs.get('is_inclusion_list', None)


class DiskInformation(Model):
    """Disk information.

    :param lun:
    :type lun: int
    :param name:
    :type name: str
    """

    _attribute_map = {
        'lun': {'key': 'lun', 'type': 'int'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DiskInformation, self).__init__(**kwargs)
        self.lun = kwargs.get('lun', None)
        self.name = kwargs.get('name', None)


class DistributedNodesInfo(Model):
    """This is used to represent the various nodes of the distributed container.

    :param node_name: Name of the node under a distributed container.
    :type node_name: str
    :param status: Status of this Node.
     Failed | Succeeded
    :type status: str
    :param error_detail: Error Details if the Status is non-success.
    :type error_detail: ~azure.mgmt.recoveryservicesbackup.models.ErrorDetail
    """

    _attribute_map = {
        'node_name': {'key': 'nodeName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'error_detail': {'key': 'errorDetail', 'type': 'ErrorDetail'},
    }

    def __init__(self, **kwargs):
        super(DistributedNodesInfo, self).__init__(**kwargs)
        self.node_name = kwargs.get('node_name', None)
        self.status = kwargs.get('status', None)
        self.error_detail = kwargs.get('error_detail', None)


class DpmBackupEngine(BackupEngineBase):
    """Data Protection Manager (DPM) specific backup engine.

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the backup engine.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the backup
     engine. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param registration_status: Registration status of the backup engine with
     the Recovery Services Vault.
    :type registration_status: str
    :param backup_engine_state: Status of the backup engine with the Recovery
     Services Vault. = {Active/Deleting/DeleteFailed}
    :type backup_engine_state: str
    :param health_status: Backup status of the backup engine.
    :type health_status: str
    :param can_re_register: Flag indicating if the backup engine be
     registered, once already registered.
    :type can_re_register: bool
    :param backup_engine_id: ID of the backup engine.
    :type backup_engine_id: str
    :param dpm_version: Backup engine version
    :type dpm_version: str
    :param azure_backup_agent_version: Backup agent version
    :type azure_backup_agent_version: str
    :param is_azure_backup_agent_upgrade_available: To check if backup agent
     upgrade available
    :type is_azure_backup_agent_upgrade_available: bool
    :param is_dpm_upgrade_available: To check if backup engine upgrade
     available
    :type is_dpm_upgrade_available: bool
    :param extended_info: Extended info of the backupengine
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.BackupEngineExtendedInfo
    :param backup_engine_type: Required. Constant filled by server.
    :type backup_engine_type: str
    """

    _validation = {
        'backup_engine_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
        'backup_engine_state': {'key': 'backupEngineState', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'can_re_register': {'key': 'canReRegister', 'type': 'bool'},
        'backup_engine_id': {'key': 'backupEngineId', 'type': 'str'},
        'dpm_version': {'key': 'dpmVersion', 'type': 'str'},
        'azure_backup_agent_version': {'key': 'azureBackupAgentVersion', 'type': 'str'},
        'is_azure_backup_agent_upgrade_available': {'key': 'isAzureBackupAgentUpgradeAvailable', 'type': 'bool'},
        'is_dpm_upgrade_available': {'key': 'isDpmUpgradeAvailable', 'type': 'bool'},
        'extended_info': {'key': 'extendedInfo', 'type': 'BackupEngineExtendedInfo'},
        'backup_engine_type': {'key': 'backupEngineType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DpmBackupEngine, self).__init__(**kwargs)
        self.backup_engine_type = 'DpmBackupEngine'


class DPMContainerExtendedInfo(Model):
    """Additional information of the DPMContainer.

    :param last_refreshed_at: Last refresh time of the DPMContainer.
    :type last_refreshed_at: datetime
    """

    _attribute_map = {
        'last_refreshed_at': {'key': 'lastRefreshedAt', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(DPMContainerExtendedInfo, self).__init__(**kwargs)
        self.last_refreshed_at = kwargs.get('last_refreshed_at', None)


class DpmErrorInfo(Model):
    """DPM workload-specific error information.

    :param error_string: Localized error string.
    :type error_string: str
    :param recommendations: List of localized recommendations for above error
     code.
    :type recommendations: list[str]
    """

    _attribute_map = {
        'error_string': {'key': 'errorString', 'type': 'str'},
        'recommendations': {'key': 'recommendations', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(DpmErrorInfo, self).__init__(**kwargs)
        self.error_string = kwargs.get('error_string', None)
        self.recommendations = kwargs.get('recommendations', None)


class DpmJob(Job):
    """DPM workload-specific job object.

    All required parameters must be populated in order to send to Azure.

    :param entity_friendly_name: Friendly name of the entity on which the
     current job is executing.
    :type entity_friendly_name: str
    :param backup_management_type: Backup management type to execute the
     current job. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param operation: The operation name.
    :type operation: str
    :param status: Job status.
    :type status: str
    :param start_time: The start time.
    :type start_time: datetime
    :param end_time: The end time.
    :type end_time: datetime
    :param activity_id: ActivityId of job.
    :type activity_id: str
    :param job_type: Required. Constant filled by server.
    :type job_type: str
    :param duration: Time elapsed for job.
    :type duration: timedelta
    :param dpm_server_name: DPM server name managing the backup item or backup
     job.
    :type dpm_server_name: str
    :param container_name: Name of cluster/server protecting current backup
     item, if any.
    :type container_name: str
    :param container_type: Type of container.
    :type container_type: str
    :param workload_type: Type of backup item.
    :type workload_type: str
    :param actions_info: The state/actions applicable on this job like
     cancel/retry.
    :type actions_info: list[str or
     ~azure.mgmt.recoveryservicesbackup.models.JobSupportedAction]
    :param error_details: The errors.
    :type error_details:
     list[~azure.mgmt.recoveryservicesbackup.models.DpmErrorInfo]
    :param extended_info: Additional information for this job.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.DpmJobExtendedInfo
    """

    _validation = {
        'job_type': {'required': True},
    }

    _attribute_map = {
        'entity_friendly_name': {'key': 'entityFriendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'activity_id': {'key': 'activityId', 'type': 'str'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'duration': {'key': 'duration', 'type': 'duration'},
        'dpm_server_name': {'key': 'dpmServerName', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'container_type': {'key': 'containerType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'actions_info': {'key': 'actionsInfo', 'type': '[JobSupportedAction]'},
        'error_details': {'key': 'errorDetails', 'type': '[DpmErrorInfo]'},
        'extended_info': {'key': 'extendedInfo', 'type': 'DpmJobExtendedInfo'},
    }

    def __init__(self, **kwargs):
        super(DpmJob, self).__init__(**kwargs)
        self.duration = kwargs.get('duration', None)
        self.dpm_server_name = kwargs.get('dpm_server_name', None)
        self.container_name = kwargs.get('container_name', None)
        self.container_type = kwargs.get('container_type', None)
        self.workload_type = kwargs.get('workload_type', None)
        self.actions_info = kwargs.get('actions_info', None)
        self.error_details = kwargs.get('error_details', None)
        self.extended_info = kwargs.get('extended_info', None)
        self.job_type = 'DpmJob'


class DpmJobExtendedInfo(Model):
    """Additional information on the DPM workload-specific job.

    :param tasks_list: List of tasks associated with this job.
    :type tasks_list:
     list[~azure.mgmt.recoveryservicesbackup.models.DpmJobTaskDetails]
    :param property_bag: The job properties.
    :type property_bag: dict[str, str]
    :param dynamic_error_message: Non localized error message on job
     execution.
    :type dynamic_error_message: str
    """

    _attribute_map = {
        'tasks_list': {'key': 'tasksList', 'type': '[DpmJobTaskDetails]'},
        'property_bag': {'key': 'propertyBag', 'type': '{str}'},
        'dynamic_error_message': {'key': 'dynamicErrorMessage', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DpmJobExtendedInfo, self).__init__(**kwargs)
        self.tasks_list = kwargs.get('tasks_list', None)
        self.property_bag = kwargs.get('property_bag', None)
        self.dynamic_error_message = kwargs.get('dynamic_error_message', None)


class DpmJobTaskDetails(Model):
    """DPM workload-specific job task details.

    :param task_id: The task display name.
    :type task_id: str
    :param start_time: The start time.
    :type start_time: datetime
    :param end_time: The end time.
    :type end_time: datetime
    :param duration: Time elapsed for task.
    :type duration: timedelta
    :param status: The status.
    :type status: str
    """

    _attribute_map = {
        'task_id': {'key': 'taskId', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'duration': {'key': 'duration', 'type': 'duration'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DpmJobTaskDetails, self).__init__(**kwargs)
        self.task_id = kwargs.get('task_id', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.duration = kwargs.get('duration', None)
        self.status = kwargs.get('status', None)


class DPMProtectedItem(ProtectedItem):
    """Additional information on Backup engine specific backup item.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param workload_type: Type of workload this item represents. Possible
     values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB',
     'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataSourceType
    :param container_name: Unique name of container
    :type container_name: str
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param last_recovery_point: Timestamp when the last (latest) backup copy
     was created for this backup item.
    :type last_recovery_point: datetime
    :param backup_set_name: Name of the backup set the backup item belongs to
    :type backup_set_name: str
    :param create_mode: Create mode to indicate recovery of existing soft
     deleted data source or creation of new data source. Possible values
     include: 'Invalid', 'Default', 'Recover'
    :type create_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.CreateMode
    :param deferred_delete_time_in_utc: Time for deferred deletion in UTC
    :type deferred_delete_time_in_utc: datetime
    :param is_scheduled_for_deferred_delete: Flag to identify whether the DS
     is scheduled for deferred delete
    :type is_scheduled_for_deferred_delete: bool
    :param deferred_delete_time_remaining: Time remaining before the DS marked
     for deferred delete is permanently deleted
    :type deferred_delete_time_remaining: str
    :param is_deferred_delete_schedule_upcoming: Flag to identify whether the
     deferred deleted DS is to be purged soon
    :type is_deferred_delete_schedule_upcoming: bool
    :param is_rehydrate: Flag to identify that deferred deleted DS is to be
     moved into Pause state
    :type is_rehydrate: bool
    :param protected_item_type: Required. Constant filled by server.
    :type protected_item_type: str
    :param friendly_name: Friendly name of the managed item
    :type friendly_name: str
    :param backup_engine_name: Backup Management server protecting this backup
     item
    :type backup_engine_name: str
    :param protection_state: Protection state of the backup engine. Possible
     values include: 'Invalid', 'IRPending', 'Protected', 'ProtectionError',
     'ProtectionStopped', 'ProtectionPaused'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectedItemState
    :param extended_info: Extended info of the backup item.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.DPMProtectedItemExtendedInfo
    """

    _validation = {
        'protected_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'last_recovery_point': {'key': 'lastRecoveryPoint', 'type': 'iso-8601'},
        'backup_set_name': {'key': 'backupSetName', 'type': 'str'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'deferred_delete_time_in_utc': {'key': 'deferredDeleteTimeInUTC', 'type': 'iso-8601'},
        'is_scheduled_for_deferred_delete': {'key': 'isScheduledForDeferredDelete', 'type': 'bool'},
        'deferred_delete_time_remaining': {'key': 'deferredDeleteTimeRemaining', 'type': 'str'},
        'is_deferred_delete_schedule_upcoming': {'key': 'isDeferredDeleteScheduleUpcoming', 'type': 'bool'},
        'is_rehydrate': {'key': 'isRehydrate', 'type': 'bool'},
        'protected_item_type': {'key': 'protectedItemType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_engine_name': {'key': 'backupEngineName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'DPMProtectedItemExtendedInfo'},
    }

    def __init__(self, **kwargs):
        super(DPMProtectedItem, self).__init__(**kwargs)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.backup_engine_name = kwargs.get('backup_engine_name', None)
        self.protection_state = kwargs.get('protection_state', None)
        self.extended_info = kwargs.get('extended_info', None)
        self.protected_item_type = 'DPMProtectedItem'


class DPMProtectedItemExtendedInfo(Model):
    """Additional information of DPM Protected item.

    :param protectable_object_load_path: Attribute to provide information on
     various DBs.
    :type protectable_object_load_path: dict[str, str]
    :param protected: To check if backup item is disk protected.
    :type protected: bool
    :param is_present_on_cloud: To check if backup item is cloud protected.
    :type is_present_on_cloud: bool
    :param last_backup_status: Last backup status information on backup item.
    :type last_backup_status: str
    :param last_refreshed_at: Last refresh time on backup item.
    :type last_refreshed_at: datetime
    :param oldest_recovery_point: Oldest cloud recovery point time.
    :type oldest_recovery_point: datetime
    :param recovery_point_count: cloud recovery point count.
    :type recovery_point_count: int
    :param on_premise_oldest_recovery_point: Oldest disk recovery point time.
    :type on_premise_oldest_recovery_point: datetime
    :param on_premise_latest_recovery_point: latest disk recovery point time.
    :type on_premise_latest_recovery_point: datetime
    :param on_premise_recovery_point_count: disk recovery point count.
    :type on_premise_recovery_point_count: int
    :param is_collocated: To check if backup item is collocated.
    :type is_collocated: bool
    :param protection_group_name: Protection group name of the backup item.
    :type protection_group_name: str
    :param disk_storage_used_in_bytes: Used Disk storage in bytes.
    :type disk_storage_used_in_bytes: str
    :param total_disk_storage_size_in_bytes: total Disk storage in bytes.
    :type total_disk_storage_size_in_bytes: str
    """

    _attribute_map = {
        'protectable_object_load_path': {'key': 'protectableObjectLoadPath', 'type': '{str}'},
        'protected': {'key': 'protected', 'type': 'bool'},
        'is_present_on_cloud': {'key': 'isPresentOnCloud', 'type': 'bool'},
        'last_backup_status': {'key': 'lastBackupStatus', 'type': 'str'},
        'last_refreshed_at': {'key': 'lastRefreshedAt', 'type': 'iso-8601'},
        'oldest_recovery_point': {'key': 'oldestRecoveryPoint', 'type': 'iso-8601'},
        'recovery_point_count': {'key': 'recoveryPointCount', 'type': 'int'},
        'on_premise_oldest_recovery_point': {'key': 'onPremiseOldestRecoveryPoint', 'type': 'iso-8601'},
        'on_premise_latest_recovery_point': {'key': 'onPremiseLatestRecoveryPoint', 'type': 'iso-8601'},
        'on_premise_recovery_point_count': {'key': 'onPremiseRecoveryPointCount', 'type': 'int'},
        'is_collocated': {'key': 'isCollocated', 'type': 'bool'},
        'protection_group_name': {'key': 'protectionGroupName', 'type': 'str'},
        'disk_storage_used_in_bytes': {'key': 'diskStorageUsedInBytes', 'type': 'str'},
        'total_disk_storage_size_in_bytes': {'key': 'totalDiskStorageSizeInBytes', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DPMProtectedItemExtendedInfo, self).__init__(**kwargs)
        self.protectable_object_load_path = kwargs.get('protectable_object_load_path', None)
        self.protected = kwargs.get('protected', None)
        self.is_present_on_cloud = kwargs.get('is_present_on_cloud', None)
        self.last_backup_status = kwargs.get('last_backup_status', None)
        self.last_refreshed_at = kwargs.get('last_refreshed_at', None)
        self.oldest_recovery_point = kwargs.get('oldest_recovery_point', None)
        self.recovery_point_count = kwargs.get('recovery_point_count', None)
        self.on_premise_oldest_recovery_point = kwargs.get('on_premise_oldest_recovery_point', None)
        self.on_premise_latest_recovery_point = kwargs.get('on_premise_latest_recovery_point', None)
        self.on_premise_recovery_point_count = kwargs.get('on_premise_recovery_point_count', None)
        self.is_collocated = kwargs.get('is_collocated', None)
        self.protection_group_name = kwargs.get('protection_group_name', None)
        self.disk_storage_used_in_bytes = kwargs.get('disk_storage_used_in_bytes', None)
        self.total_disk_storage_size_in_bytes = kwargs.get('total_disk_storage_size_in_bytes', None)


class EncryptionDetails(Model):
    """Details needed if the VM was encrypted at the time of backup.

    :param encryption_enabled: Identifies whether this backup copy represents
     an encrypted VM at the time of backup.
    :type encryption_enabled: bool
    :param kek_url: Key Url.
    :type kek_url: str
    :param secret_key_url: Secret Url.
    :type secret_key_url: str
    :param kek_vault_id: ID of Key Vault where KEK is stored.
    :type kek_vault_id: str
    :param secret_key_vault_id: ID of Key Vault where Secret is stored.
    :type secret_key_vault_id: str
    """

    _attribute_map = {
        'encryption_enabled': {'key': 'encryptionEnabled', 'type': 'bool'},
        'kek_url': {'key': 'kekUrl', 'type': 'str'},
        'secret_key_url': {'key': 'secretKeyUrl', 'type': 'str'},
        'kek_vault_id': {'key': 'kekVaultId', 'type': 'str'},
        'secret_key_vault_id': {'key': 'secretKeyVaultId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EncryptionDetails, self).__init__(**kwargs)
        self.encryption_enabled = kwargs.get('encryption_enabled', None)
        self.kek_url = kwargs.get('kek_url', None)
        self.secret_key_url = kwargs.get('secret_key_url', None)
        self.kek_vault_id = kwargs.get('kek_vault_id', None)
        self.secret_key_vault_id = kwargs.get('secret_key_vault_id', None)


class ErrorDetail(Model):
    """Error Detail class which encapsulates Code, Message and Recommendations.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error Message related to the Code.
    :vartype message: str
    :ivar recommendations: List of recommendation strings.
    :vartype recommendations: list[str]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'recommendations': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'recommendations': {'key': 'recommendations', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.recommendations = None


class OperationResultInfoBase(Model):
    """Base class for operation result info.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ExportJobsOperationResultInfo, OperationResultInfo

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'ExportJobsOperationResultInfo': 'ExportJobsOperationResultInfo', 'OperationResultInfo': 'OperationResultInfo'}
    }

    def __init__(self, **kwargs):
        super(OperationResultInfoBase, self).__init__(**kwargs)
        self.object_type = None


class ExportJobsOperationResultInfo(OperationResultInfoBase):
    """This class is used to send blob details after exporting jobs.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param blob_url: URL of the blob into which the serialized string of list
     of jobs is exported.
    :type blob_url: str
    :param blob_sas_key: SAS key to access the blob. It expires in 15 mins.
    :type blob_sas_key: str
    :param excel_file_blob_url: URL of the blob into which the ExcelFile is
     uploaded.
    :type excel_file_blob_url: str
    :param excel_file_blob_sas_key: SAS key to access the blob. It expires in
     15 mins.
    :type excel_file_blob_sas_key: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'blob_url': {'key': 'blobUrl', 'type': 'str'},
        'blob_sas_key': {'key': 'blobSasKey', 'type': 'str'},
        'excel_file_blob_url': {'key': 'excelFileBlobUrl', 'type': 'str'},
        'excel_file_blob_sas_key': {'key': 'excelFileBlobSasKey', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ExportJobsOperationResultInfo, self).__init__(**kwargs)
        self.blob_url = kwargs.get('blob_url', None)
        self.blob_sas_key = kwargs.get('blob_sas_key', None)
        self.excel_file_blob_url = kwargs.get('excel_file_blob_url', None)
        self.excel_file_blob_sas_key = kwargs.get('excel_file_blob_sas_key', None)
        self.object_type = 'ExportJobsOperationResultInfo'


class ExtendedProperties(Model):
    """Extended Properties for Azure IaasVM Backup.

    :param disk_exclusion_properties: Extended Properties for Disk Exclusion.
    :type disk_exclusion_properties:
     ~azure.mgmt.recoveryservicesbackup.models.DiskExclusionProperties
    """

    _attribute_map = {
        'disk_exclusion_properties': {'key': 'diskExclusionProperties', 'type': 'DiskExclusionProperties'},
    }

    def __init__(self, **kwargs):
        super(ExtendedProperties, self).__init__(**kwargs)
        self.disk_exclusion_properties = kwargs.get('disk_exclusion_properties', None)


class GenericContainer(ProtectionContainer):
    """Base class for generic container of backup items.

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param registration_status: Status of registration of the container with
     the Recovery Services Vault.
    :type registration_status: str
    :param health_status: Status of health of the container.
    :type health_status: str
    :param container_type: Required. Constant filled by server.
    :type container_type: str
    :param fabric_name: Name of the container's fabric
    :type fabric_name: str
    :param extended_information: Extended information (not returned in List
     container API calls)
    :type extended_information:
     ~azure.mgmt.recoveryservicesbackup.models.GenericContainerExtendedInfo
    """

    _validation = {
        'container_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'container_type': {'key': 'containerType', 'type': 'str'},
        'fabric_name': {'key': 'fabricName', 'type': 'str'},
        'extended_information': {'key': 'extendedInformation', 'type': 'GenericContainerExtendedInfo'},
    }

    def __init__(self, **kwargs):
        super(GenericContainer, self).__init__(**kwargs)
        self.fabric_name = kwargs.get('fabric_name', None)
        self.extended_information = kwargs.get('extended_information', None)
        self.container_type = 'GenericContainer'


class GenericContainerExtendedInfo(Model):
    """Container extended information.

    :param raw_cert_data: Public key of container cert
    :type raw_cert_data: str
    :param container_identity_info: Container identity information
    :type container_identity_info:
     ~azure.mgmt.recoveryservicesbackup.models.ContainerIdentityInfo
    :param service_endpoints: Azure Backup Service Endpoints for the container
    :type service_endpoints: dict[str, str]
    """

    _attribute_map = {
        'raw_cert_data': {'key': 'rawCertData', 'type': 'str'},
        'container_identity_info': {'key': 'containerIdentityInfo', 'type': 'ContainerIdentityInfo'},
        'service_endpoints': {'key': 'serviceEndpoints', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(GenericContainerExtendedInfo, self).__init__(**kwargs)
        self.raw_cert_data = kwargs.get('raw_cert_data', None)
        self.container_identity_info = kwargs.get('container_identity_info', None)
        self.service_endpoints = kwargs.get('service_endpoints', None)


class GenericProtectedItem(ProtectedItem):
    """Base class for backup items.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param workload_type: Type of workload this item represents. Possible
     values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB',
     'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataSourceType
    :param container_name: Unique name of container
    :type container_name: str
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param last_recovery_point: Timestamp when the last (latest) backup copy
     was created for this backup item.
    :type last_recovery_point: datetime
    :param backup_set_name: Name of the backup set the backup item belongs to
    :type backup_set_name: str
    :param create_mode: Create mode to indicate recovery of existing soft
     deleted data source or creation of new data source. Possible values
     include: 'Invalid', 'Default', 'Recover'
    :type create_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.CreateMode
    :param deferred_delete_time_in_utc: Time for deferred deletion in UTC
    :type deferred_delete_time_in_utc: datetime
    :param is_scheduled_for_deferred_delete: Flag to identify whether the DS
     is scheduled for deferred delete
    :type is_scheduled_for_deferred_delete: bool
    :param deferred_delete_time_remaining: Time remaining before the DS marked
     for deferred delete is permanently deleted
    :type deferred_delete_time_remaining: str
    :param is_deferred_delete_schedule_upcoming: Flag to identify whether the
     deferred deleted DS is to be purged soon
    :type is_deferred_delete_schedule_upcoming: bool
    :param is_rehydrate: Flag to identify that deferred deleted DS is to be
     moved into Pause state
    :type is_rehydrate: bool
    :param protected_item_type: Required. Constant filled by server.
    :type protected_item_type: str
    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param policy_state: Indicates consistency of policy object and policy
     applied to this backup item.
    :type policy_state: str
    :param protection_state: Backup state of this backup item. Possible values
     include: 'Invalid', 'IRPending', 'Protected', 'ProtectionError',
     'ProtectionStopped', 'ProtectionPaused'
    :type protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionState
    :param protected_item_id: Data Plane Service ID of the protected item.
    :type protected_item_id: long
    :param source_associations: Loosely coupled (type, value) associations
     (example - parent of a protected item)
    :type source_associations: dict[str, str]
    :param fabric_name: Name of this backup item's fabric.
    :type fabric_name: str
    """

    _validation = {
        'protected_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'last_recovery_point': {'key': 'lastRecoveryPoint', 'type': 'iso-8601'},
        'backup_set_name': {'key': 'backupSetName', 'type': 'str'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'deferred_delete_time_in_utc': {'key': 'deferredDeleteTimeInUTC', 'type': 'iso-8601'},
        'is_scheduled_for_deferred_delete': {'key': 'isScheduledForDeferredDelete', 'type': 'bool'},
        'deferred_delete_time_remaining': {'key': 'deferredDeleteTimeRemaining', 'type': 'str'},
        'is_deferred_delete_schedule_upcoming': {'key': 'isDeferredDeleteScheduleUpcoming', 'type': 'bool'},
        'is_rehydrate': {'key': 'isRehydrate', 'type': 'bool'},
        'protected_item_type': {'key': 'protectedItemType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'policy_state': {'key': 'policyState', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protected_item_id': {'key': 'protectedItemId', 'type': 'long'},
        'source_associations': {'key': 'sourceAssociations', 'type': '{str}'},
        'fabric_name': {'key': 'fabricName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(GenericProtectedItem, self).__init__(**kwargs)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.policy_state = kwargs.get('policy_state', None)
        self.protection_state = kwargs.get('protection_state', None)
        self.protected_item_id = kwargs.get('protected_item_id', None)
        self.source_associations = kwargs.get('source_associations', None)
        self.fabric_name = kwargs.get('fabric_name', None)
        self.protected_item_type = 'GenericProtectedItem'


class GenericProtectionPolicy(ProtectionPolicy):
    """Azure VM (Mercury) workload-specific backup policy.

    All required parameters must be populated in order to send to Azure.

    :param protected_items_count: Number of items associated with this policy.
    :type protected_items_count: int
    :param backup_management_type: Required. Constant filled by server.
    :type backup_management_type: str
    :param sub_protection_policy: List of sub-protection policies which
     includes schedule and retention
    :type sub_protection_policy:
     list[~azure.mgmt.recoveryservicesbackup.models.SubProtectionPolicy]
    :param time_zone: TimeZone optional input as string. For example: TimeZone
     = "Pacific Standard Time".
    :type time_zone: str
    :param fabric_name: Name of this policy's fabric.
    :type fabric_name: str
    """

    _validation = {
        'backup_management_type': {'required': True},
    }

    _attribute_map = {
        'protected_items_count': {'key': 'protectedItemsCount', 'type': 'int'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'sub_protection_policy': {'key': 'subProtectionPolicy', 'type': '[SubProtectionPolicy]'},
        'time_zone': {'key': 'timeZone', 'type': 'str'},
        'fabric_name': {'key': 'fabricName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(GenericProtectionPolicy, self).__init__(**kwargs)
        self.sub_protection_policy = kwargs.get('sub_protection_policy', None)
        self.time_zone = kwargs.get('time_zone', None)
        self.fabric_name = kwargs.get('fabric_name', None)
        self.backup_management_type = 'GenericProtectionPolicy'


class GenericRecoveryPoint(RecoveryPoint):
    """Generic backup copy.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param friendly_name: Friendly name of the backup copy.
    :type friendly_name: str
    :param recovery_point_type: Type of the backup copy.
    :type recovery_point_type: str
    :param recovery_point_time: Time at which this backup copy was created.
    :type recovery_point_time: datetime
    :param recovery_point_additional_info: Additional information associated
     with this backup copy.
    :type recovery_point_additional_info: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'recovery_point_type': {'key': 'recoveryPointType', 'type': 'str'},
        'recovery_point_time': {'key': 'recoveryPointTime', 'type': 'iso-8601'},
        'recovery_point_additional_info': {'key': 'recoveryPointAdditionalInfo', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(GenericRecoveryPoint, self).__init__(**kwargs)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.recovery_point_type = kwargs.get('recovery_point_type', None)
        self.recovery_point_time = kwargs.get('recovery_point_time', None)
        self.recovery_point_additional_info = kwargs.get('recovery_point_additional_info', None)
        self.object_type = 'GenericRecoveryPoint'


class GetProtectedItemQueryObject(Model):
    """Filters to list backup items.

    :param expand: Specifies if the additional information should be provided
     for this item.
    :type expand: str
    """

    _attribute_map = {
        'expand': {'key': 'expand', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(GetProtectedItemQueryObject, self).__init__(**kwargs)
        self.expand = kwargs.get('expand', None)


class IaasVMBackupRequest(BackupRequest):
    """IaaS VM workload-specific backup request.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param recovery_point_expiry_time_in_utc: Backup copy will expire after
     the time specified (UTC).
    :type recovery_point_expiry_time_in_utc: datetime
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_point_expiry_time_in_utc': {'key': 'recoveryPointExpiryTimeInUTC', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(IaasVMBackupRequest, self).__init__(**kwargs)
        self.recovery_point_expiry_time_in_utc = kwargs.get('recovery_point_expiry_time_in_utc', None)
        self.object_type = 'IaasVMBackupRequest'


class IaasVMILRRegistrationRequest(ILRRequest):
    """Restore files/folders from a backup copy of IaaS VM.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param recovery_point_id: ID of the IaaS VM backup copy from where the
     files/folders have to be restored.
    :type recovery_point_id: str
    :param virtual_machine_id: Fully qualified ARM ID of the virtual machine
     whose the files / folders have to be restored.
    :type virtual_machine_id: str
    :param initiator_name: iSCSI initiator name.
    :type initiator_name: str
    :param renew_existing_registration: Whether to renew existing registration
     with the iSCSI server.
    :type renew_existing_registration: bool
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_point_id': {'key': 'recoveryPointId', 'type': 'str'},
        'virtual_machine_id': {'key': 'virtualMachineId', 'type': 'str'},
        'initiator_name': {'key': 'initiatorName', 'type': 'str'},
        'renew_existing_registration': {'key': 'renewExistingRegistration', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(IaasVMILRRegistrationRequest, self).__init__(**kwargs)
        self.recovery_point_id = kwargs.get('recovery_point_id', None)
        self.virtual_machine_id = kwargs.get('virtual_machine_id', None)
        self.initiator_name = kwargs.get('initiator_name', None)
        self.renew_existing_registration = kwargs.get('renew_existing_registration', None)
        self.object_type = 'IaasVMILRRegistrationRequest'


class IaasVMRecoveryPoint(RecoveryPoint):
    """IaaS VM workload specific backup copy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :ivar recovery_point_type: Type of the backup copy.
    :vartype recovery_point_type: str
    :ivar recovery_point_time: Time at which this backup copy was created.
    :vartype recovery_point_time: datetime
    :ivar recovery_point_additional_info: Additional information associated
     with this backup copy.
    :vartype recovery_point_additional_info: str
    :ivar source_vm_storage_type: Storage type of the VM whose backup copy is
     created.
    :vartype source_vm_storage_type: str
    :ivar is_source_vm_encrypted: Identifies whether the VM was encrypted when
     the backup copy is created.
    :vartype is_source_vm_encrypted: bool
    :param key_and_secret: Required details for recovering an encrypted VM.
     Applicable only when IsSourceVMEncrypted is true.
    :type key_and_secret:
     ~azure.mgmt.recoveryservicesbackup.models.KeyAndSecretDetails
    :param is_instant_ilr_session_active: Is the session to recover items from
     this backup copy still active.
    :type is_instant_ilr_session_active: bool
    :param recovery_point_tier_details: Recovery point tier information.
    :type recovery_point_tier_details:
     list[~azure.mgmt.recoveryservicesbackup.models.RecoveryPointTierInformation]
    :param is_managed_virtual_machine: Whether VM is with Managed Disks
    :type is_managed_virtual_machine: bool
    :param virtual_machine_size: Virtual Machine Size
    :type virtual_machine_size: str
    :param original_storage_account_option: Original Storage Account Option
    :type original_storage_account_option: bool
    :param os_type: OS type
    :type os_type: str
    :param recovery_point_disk_configuration: Disk configuration
    :type recovery_point_disk_configuration:
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryPointDiskConfiguration
    """

    _validation = {
        'object_type': {'required': True},
        'recovery_point_type': {'readonly': True},
        'recovery_point_time': {'readonly': True},
        'recovery_point_additional_info': {'readonly': True},
        'source_vm_storage_type': {'readonly': True},
        'is_source_vm_encrypted': {'readonly': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_point_type': {'key': 'recoveryPointType', 'type': 'str'},
        'recovery_point_time': {'key': 'recoveryPointTime', 'type': 'iso-8601'},
        'recovery_point_additional_info': {'key': 'recoveryPointAdditionalInfo', 'type': 'str'},
        'source_vm_storage_type': {'key': 'sourceVMStorageType', 'type': 'str'},
        'is_source_vm_encrypted': {'key': 'isSourceVMEncrypted', 'type': 'bool'},
        'key_and_secret': {'key': 'keyAndSecret', 'type': 'KeyAndSecretDetails'},
        'is_instant_ilr_session_active': {'key': 'isInstantIlrSessionActive', 'type': 'bool'},
        'recovery_point_tier_details': {'key': 'recoveryPointTierDetails', 'type': '[RecoveryPointTierInformation]'},
        'is_managed_virtual_machine': {'key': 'isManagedVirtualMachine', 'type': 'bool'},
        'virtual_machine_size': {'key': 'virtualMachineSize', 'type': 'str'},
        'original_storage_account_option': {'key': 'originalStorageAccountOption', 'type': 'bool'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'recovery_point_disk_configuration': {'key': 'recoveryPointDiskConfiguration', 'type': 'RecoveryPointDiskConfiguration'},
    }

    def __init__(self, **kwargs):
        super(IaasVMRecoveryPoint, self).__init__(**kwargs)
        self.recovery_point_type = None
        self.recovery_point_time = None
        self.recovery_point_additional_info = None
        self.source_vm_storage_type = None
        self.is_source_vm_encrypted = None
        self.key_and_secret = kwargs.get('key_and_secret', None)
        self.is_instant_ilr_session_active = kwargs.get('is_instant_ilr_session_active', None)
        self.recovery_point_tier_details = kwargs.get('recovery_point_tier_details', None)
        self.is_managed_virtual_machine = kwargs.get('is_managed_virtual_machine', None)
        self.virtual_machine_size = kwargs.get('virtual_machine_size', None)
        self.original_storage_account_option = kwargs.get('original_storage_account_option', None)
        self.os_type = kwargs.get('os_type', None)
        self.recovery_point_disk_configuration = kwargs.get('recovery_point_disk_configuration', None)
        self.object_type = 'IaasVMRecoveryPoint'


class IaasVMRestoreRequest(RestoreRequest):
    """IaaS VM workload-specific restore.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param recovery_point_id: ID of the backup copy to be recovered.
    :type recovery_point_id: str
    :param recovery_type: Type of this recovery. Possible values include:
     'Invalid', 'OriginalLocation', 'AlternateLocation', 'RestoreDisks',
     'Offline'
    :type recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryType
    :param source_resource_id: Fully qualified ARM ID of the VM which is being
     recovered.
    :type source_resource_id: str
    :param target_virtual_machine_id: This is the complete ARM Id of the VM
     that will be created.
     For e.g.
     /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
    :type target_virtual_machine_id: str
    :param target_resource_group_id: This is the ARM Id of the resource group
     that you want to create for this Virtual machine and other artifacts.
     For e.g. /subscriptions/{subId}/resourcegroups/{rg}
    :type target_resource_group_id: str
    :param storage_account_id: Fully qualified ARM ID of the storage account
     to which the VM has to be restored.
    :type storage_account_id: str
    :param virtual_network_id: This is the virtual network Id of the vnet that
     will be attached to the virtual machine.
     User will be validated for join action permissions in the linked access.
    :type virtual_network_id: str
    :param subnet_id: Subnet ID, is the subnet ID associated with the to be
     restored VM. For Classic VMs it would be
     {VnetID}/Subnet/{SubnetName} and, for the Azure Resource Manager VMs it
     would be ARM resource ID used to represent
     the subnet.
    :type subnet_id: str
    :param target_domain_name_id: Fully qualified ARM ID of the domain name to
     be associated to the VM being restored. This applies only to Classic
     Virtual Machines.
    :type target_domain_name_id: str
    :param region: Region in which the virtual machine is restored.
    :type region: str
    :param affinity_group: Affinity group associated to VM to be restored.
     Used only for Classic Compute Virtual Machines.
    :type affinity_group: str
    :param create_new_cloud_service: Should a new cloud service be created
     while restoring the VM. If this is false, VM will be restored to the same
     cloud service as it was at the time of backup.
    :type create_new_cloud_service: bool
    :param original_storage_account_option: Original Storage Account Option
    :type original_storage_account_option: bool
    :param encryption_details: Details needed if the VM was encrypted at the
     time of backup.
    :type encryption_details:
     ~azure.mgmt.recoveryservicesbackup.models.EncryptionDetails
    :param restore_disk_lun_list: List of Disk LUNs for partial restore
    :type restore_disk_lun_list: list[int]
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_point_id': {'key': 'recoveryPointId', 'type': 'str'},
        'recovery_type': {'key': 'recoveryType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'target_virtual_machine_id': {'key': 'targetVirtualMachineId', 'type': 'str'},
        'target_resource_group_id': {'key': 'targetResourceGroupId', 'type': 'str'},
        'storage_account_id': {'key': 'storageAccountId', 'type': 'str'},
        'virtual_network_id': {'key': 'virtualNetworkId', 'type': 'str'},
        'subnet_id': {'key': 'subnetId', 'type': 'str'},
        'target_domain_name_id': {'key': 'targetDomainNameId', 'type': 'str'},
        'region': {'key': 'region', 'type': 'str'},
        'affinity_group': {'key': 'affinityGroup', 'type': 'str'},
        'create_new_cloud_service': {'key': 'createNewCloudService', 'type': 'bool'},
        'original_storage_account_option': {'key': 'originalStorageAccountOption', 'type': 'bool'},
        'encryption_details': {'key': 'encryptionDetails', 'type': 'EncryptionDetails'},
        'restore_disk_lun_list': {'key': 'restoreDiskLunList', 'type': '[int]'},
    }

    def __init__(self, **kwargs):
        super(IaasVMRestoreRequest, self).__init__(**kwargs)
        self.recovery_point_id = kwargs.get('recovery_point_id', None)
        self.recovery_type = kwargs.get('recovery_type', None)
        self.source_resource_id = kwargs.get('source_resource_id', None)
        self.target_virtual_machine_id = kwargs.get('target_virtual_machine_id', None)
        self.target_resource_group_id = kwargs.get('target_resource_group_id', None)
        self.storage_account_id = kwargs.get('storage_account_id', None)
        self.virtual_network_id = kwargs.get('virtual_network_id', None)
        self.subnet_id = kwargs.get('subnet_id', None)
        self.target_domain_name_id = kwargs.get('target_domain_name_id', None)
        self.region = kwargs.get('region', None)
        self.affinity_group = kwargs.get('affinity_group', None)
        self.create_new_cloud_service = kwargs.get('create_new_cloud_service', None)
        self.original_storage_account_option = kwargs.get('original_storage_account_option', None)
        self.encryption_details = kwargs.get('encryption_details', None)
        self.restore_disk_lun_list = kwargs.get('restore_disk_lun_list', None)
        self.object_type = 'IaasVMRestoreRequest'


class ILRRequestResource(Resource):
    """Parameters to Provision ILR API.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: ILRRequestResource properties
    :type properties: ~azure.mgmt.recoveryservicesbackup.models.ILRRequest
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ILRRequest'},
    }

    def __init__(self, **kwargs):
        super(ILRRequestResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class InquiryInfo(Model):
    """Details about inquired protectable items under a given container.

    :param status: Inquiry Status for this container such as
     InProgress | Failed | Succeeded
    :type status: str
    :param error_detail: Error Details if the Status is non-success.
    :type error_detail: ~azure.mgmt.recoveryservicesbackup.models.ErrorDetail
    :param inquiry_details: Inquiry Details which will have workload specific
     details.
     For e.g. - For SQL and oracle this will contain different details.
    :type inquiry_details:
     list[~azure.mgmt.recoveryservicesbackup.models.WorkloadInquiryDetails]
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'error_detail': {'key': 'errorDetail', 'type': 'ErrorDetail'},
        'inquiry_details': {'key': 'inquiryDetails', 'type': '[WorkloadInquiryDetails]'},
    }

    def __init__(self, **kwargs):
        super(InquiryInfo, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.error_detail = kwargs.get('error_detail', None)
        self.inquiry_details = kwargs.get('inquiry_details', None)


class InquiryValidation(Model):
    """Validation for inquired protectable items under a given container.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param status: Status for the Inquiry Validation.
    :type status: str
    :param error_detail: Error Detail in case the status is non-success.
    :type error_detail: ~azure.mgmt.recoveryservicesbackup.models.ErrorDetail
    :ivar additional_detail: Error Additional Detail in case the status is
     non-success.
    :vartype additional_detail: str
    """

    _validation = {
        'additional_detail': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'error_detail': {'key': 'errorDetail', 'type': 'ErrorDetail'},
        'additional_detail': {'key': 'additionalDetail', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(InquiryValidation, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.error_detail = kwargs.get('error_detail', None)
        self.additional_detail = None


class InstantItemRecoveryTarget(Model):
    """Target details for file / folder restore.

    :param client_scripts: List of client scripts.
    :type client_scripts:
     list[~azure.mgmt.recoveryservicesbackup.models.ClientScriptForConnect]
    """

    _attribute_map = {
        'client_scripts': {'key': 'clientScripts', 'type': '[ClientScriptForConnect]'},
    }

    def __init__(self, **kwargs):
        super(InstantItemRecoveryTarget, self).__init__(**kwargs)
        self.client_scripts = kwargs.get('client_scripts', None)


class InstantRPAdditionalDetails(Model):
    """InstantRPAdditionalDetails.

    :param azure_backup_rg_name_prefix:
    :type azure_backup_rg_name_prefix: str
    :param azure_backup_rg_name_suffix:
    :type azure_backup_rg_name_suffix: str
    """

    _attribute_map = {
        'azure_backup_rg_name_prefix': {'key': 'azureBackupRGNamePrefix', 'type': 'str'},
        'azure_backup_rg_name_suffix': {'key': 'azureBackupRGNameSuffix', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(InstantRPAdditionalDetails, self).__init__(**kwargs)
        self.azure_backup_rg_name_prefix = kwargs.get('azure_backup_rg_name_prefix', None)
        self.azure_backup_rg_name_suffix = kwargs.get('azure_backup_rg_name_suffix', None)


class JobQueryObject(Model):
    """Filters to list the jobs.

    :param status: Status of the job. Possible values include: 'Invalid',
     'InProgress', 'Completed', 'Failed', 'CompletedWithWarnings', 'Cancelled',
     'Cancelling'
    :type status: str or ~azure.mgmt.recoveryservicesbackup.models.JobStatus
    :param backup_management_type: Type of backup management for the job.
     Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param operation: Type of operation. Possible values include: 'Invalid',
     'Register', 'UnRegister', 'ConfigureBackup', 'Backup', 'Restore',
     'DisableBackup', 'DeleteBackupData', 'CrossRegionRestore', 'Undelete'
    :type operation: str or
     ~azure.mgmt.recoveryservicesbackup.models.JobOperationType
    :param job_id: JobID represents the job uniquely.
    :type job_id: str
    :param start_time: Job has started at this time. Value is in UTC.
    :type start_time: datetime
    :param end_time: Job has ended at this time. Value is in UTC.
    :type end_time: datetime
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'job_id': {'key': 'jobId', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(JobQueryObject, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.backup_management_type = kwargs.get('backup_management_type', None)
        self.operation = kwargs.get('operation', None)
        self.job_id = kwargs.get('job_id', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)


class JobResource(Resource):
    """Defines workload agnostic properties for a job.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: JobResource properties
    :type properties: ~azure.mgmt.recoveryservicesbackup.models.Job
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'Job'},
    }

    def __init__(self, **kwargs):
        super(JobResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class KEKDetails(Model):
    """KEK is encryption key for BEK.

    :param key_url: Key is KEK.
    :type key_url: str
    :param key_vault_id: Key Vault ID where this Key is stored.
    :type key_vault_id: str
    :param key_backup_data: KEK data.
    :type key_backup_data: str
    """

    _attribute_map = {
        'key_url': {'key': 'keyUrl', 'type': 'str'},
        'key_vault_id': {'key': 'keyVaultId', 'type': 'str'},
        'key_backup_data': {'key': 'keyBackupData', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(KEKDetails, self).__init__(**kwargs)
        self.key_url = kwargs.get('key_url', None)
        self.key_vault_id = kwargs.get('key_vault_id', None)
        self.key_backup_data = kwargs.get('key_backup_data', None)


class KeyAndSecretDetails(Model):
    """BEK is bitlocker key.
    KEK is encryption key for BEK
    If the VM was encrypted then we will store following details :
    1. Secret(BEK) - Url + Backup Data + vaultId.
    2. Key(KEK) - Url + Backup Data + vaultId.
    3. EncryptionMechanism
    BEK and KEK can potentially have different vault ids.

    :param kek_details: KEK is encryption key for BEK.
    :type kek_details: ~azure.mgmt.recoveryservicesbackup.models.KEKDetails
    :param bek_details: BEK is bitlocker encryption key.
    :type bek_details: ~azure.mgmt.recoveryservicesbackup.models.BEKDetails
    :param encryption_mechanism: Encryption mechanism: None/ SinglePass/
     DoublePass
    :type encryption_mechanism: str
    """

    _attribute_map = {
        'kek_details': {'key': 'kekDetails', 'type': 'KEKDetails'},
        'bek_details': {'key': 'bekDetails', 'type': 'BEKDetails'},
        'encryption_mechanism': {'key': 'encryptionMechanism', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(KeyAndSecretDetails, self).__init__(**kwargs)
        self.kek_details = kwargs.get('kek_details', None)
        self.bek_details = kwargs.get('bek_details', None)
        self.encryption_mechanism = kwargs.get('encryption_mechanism', None)


class SchedulePolicy(Model):
    """Base class for backup schedule.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: LogSchedulePolicy, LongTermSchedulePolicy,
    SimpleSchedulePolicy

    All required parameters must be populated in order to send to Azure.

    :param schedule_policy_type: Required. Constant filled by server.
    :type schedule_policy_type: str
    """

    _validation = {
        'schedule_policy_type': {'required': True},
    }

    _attribute_map = {
        'schedule_policy_type': {'key': 'schedulePolicyType', 'type': 'str'},
    }

    _subtype_map = {
        'schedule_policy_type': {'LogSchedulePolicy': 'LogSchedulePolicy', 'LongTermSchedulePolicy': 'LongTermSchedulePolicy', 'SimpleSchedulePolicy': 'SimpleSchedulePolicy'}
    }

    def __init__(self, **kwargs):
        super(SchedulePolicy, self).__init__(**kwargs)
        self.schedule_policy_type = None


class LogSchedulePolicy(SchedulePolicy):
    """Log policy schedule.

    All required parameters must be populated in order to send to Azure.

    :param schedule_policy_type: Required. Constant filled by server.
    :type schedule_policy_type: str
    :param schedule_frequency_in_mins: Frequency of the log schedule operation
     of this policy in minutes.
    :type schedule_frequency_in_mins: int
    """

    _validation = {
        'schedule_policy_type': {'required': True},
    }

    _attribute_map = {
        'schedule_policy_type': {'key': 'schedulePolicyType', 'type': 'str'},
        'schedule_frequency_in_mins': {'key': 'scheduleFrequencyInMins', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(LogSchedulePolicy, self).__init__(**kwargs)
        self.schedule_frequency_in_mins = kwargs.get('schedule_frequency_in_mins', None)
        self.schedule_policy_type = 'LogSchedulePolicy'


class RetentionPolicy(Model):
    """Base class for retention policy.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: LongTermRetentionPolicy, SimpleRetentionPolicy

    All required parameters must be populated in order to send to Azure.

    :param retention_policy_type: Required. Constant filled by server.
    :type retention_policy_type: str
    """

    _validation = {
        'retention_policy_type': {'required': True},
    }

    _attribute_map = {
        'retention_policy_type': {'key': 'retentionPolicyType', 'type': 'str'},
    }

    _subtype_map = {
        'retention_policy_type': {'LongTermRetentionPolicy': 'LongTermRetentionPolicy', 'SimpleRetentionPolicy': 'SimpleRetentionPolicy'}
    }

    def __init__(self, **kwargs):
        super(RetentionPolicy, self).__init__(**kwargs)
        self.retention_policy_type = None


class LongTermRetentionPolicy(RetentionPolicy):
    """Long term retention policy.

    All required parameters must be populated in order to send to Azure.

    :param retention_policy_type: Required. Constant filled by server.
    :type retention_policy_type: str
    :param daily_schedule: Daily retention schedule of the protection policy.
    :type daily_schedule:
     ~azure.mgmt.recoveryservicesbackup.models.DailyRetentionSchedule
    :param weekly_schedule: Weekly retention schedule of the protection
     policy.
    :type weekly_schedule:
     ~azure.mgmt.recoveryservicesbackup.models.WeeklyRetentionSchedule
    :param monthly_schedule: Monthly retention schedule of the protection
     policy.
    :type monthly_schedule:
     ~azure.mgmt.recoveryservicesbackup.models.MonthlyRetentionSchedule
    :param yearly_schedule: Yearly retention schedule of the protection
     policy.
    :type yearly_schedule:
     ~azure.mgmt.recoveryservicesbackup.models.YearlyRetentionSchedule
    """

    _validation = {
        'retention_policy_type': {'required': True},
    }

    _attribute_map = {
        'retention_policy_type': {'key': 'retentionPolicyType', 'type': 'str'},
        'daily_schedule': {'key': 'dailySchedule', 'type': 'DailyRetentionSchedule'},
        'weekly_schedule': {'key': 'weeklySchedule', 'type': 'WeeklyRetentionSchedule'},
        'monthly_schedule': {'key': 'monthlySchedule', 'type': 'MonthlyRetentionSchedule'},
        'yearly_schedule': {'key': 'yearlySchedule', 'type': 'YearlyRetentionSchedule'},
    }

    def __init__(self, **kwargs):
        super(LongTermRetentionPolicy, self).__init__(**kwargs)
        self.daily_schedule = kwargs.get('daily_schedule', None)
        self.weekly_schedule = kwargs.get('weekly_schedule', None)
        self.monthly_schedule = kwargs.get('monthly_schedule', None)
        self.yearly_schedule = kwargs.get('yearly_schedule', None)
        self.retention_policy_type = 'LongTermRetentionPolicy'


class LongTermSchedulePolicy(SchedulePolicy):
    """Long term policy schedule.

    All required parameters must be populated in order to send to Azure.

    :param schedule_policy_type: Required. Constant filled by server.
    :type schedule_policy_type: str
    """

    _validation = {
        'schedule_policy_type': {'required': True},
    }

    _attribute_map = {
        'schedule_policy_type': {'key': 'schedulePolicyType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LongTermSchedulePolicy, self).__init__(**kwargs)
        self.schedule_policy_type = 'LongTermSchedulePolicy'


class MabContainer(ProtectionContainer):
    """Container with items backed up using MAB backup engine.

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name of the container.
    :type friendly_name: str
    :param backup_management_type: Type of backup management for the
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param registration_status: Status of registration of the container with
     the Recovery Services Vault.
    :type registration_status: str
    :param health_status: Status of health of the container.
    :type health_status: str
    :param container_type: Required. Constant filled by server.
    :type container_type: str
    :param can_re_register: Can the container be registered one more time.
    :type can_re_register: bool
    :param container_id: ContainerID represents the container.
    :type container_id: long
    :param protected_item_count: Number of items backed up in this container.
    :type protected_item_count: long
    :param agent_version: Agent version of this container.
    :type agent_version: str
    :param extended_info: Additional information for this container
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.MabContainerExtendedInfo
    :param mab_container_health_details: Health details on this mab container.
    :type mab_container_health_details:
     list[~azure.mgmt.recoveryservicesbackup.models.MABContainerHealthDetails]
    :param container_health_state: Health state of mab container.
    :type container_health_state: str
    """

    _validation = {
        'container_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'registration_status': {'key': 'registrationStatus', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'container_type': {'key': 'containerType', 'type': 'str'},
        'can_re_register': {'key': 'canReRegister', 'type': 'bool'},
        'container_id': {'key': 'containerId', 'type': 'long'},
        'protected_item_count': {'key': 'protectedItemCount', 'type': 'long'},
        'agent_version': {'key': 'agentVersion', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'MabContainerExtendedInfo'},
        'mab_container_health_details': {'key': 'mabContainerHealthDetails', 'type': '[MABContainerHealthDetails]'},
        'container_health_state': {'key': 'containerHealthState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(MabContainer, self).__init__(**kwargs)
        self.can_re_register = kwargs.get('can_re_register', None)
        self.container_id = kwargs.get('container_id', None)
        self.protected_item_count = kwargs.get('protected_item_count', None)
        self.agent_version = kwargs.get('agent_version', None)
        self.extended_info = kwargs.get('extended_info', None)
        self.mab_container_health_details = kwargs.get('mab_container_health_details', None)
        self.container_health_state = kwargs.get('container_health_state', None)
        self.container_type = 'Windows'


class MabContainerExtendedInfo(Model):
    """Additional information of the container.

    :param last_refreshed_at: Time stamp when this container was refreshed.
    :type last_refreshed_at: datetime
    :param backup_item_type: Type of backup items associated with this
     container. Possible values include: 'Invalid', 'VM', 'FileFolder',
     'AzureSqlDb', 'SQLDB', 'Exchange', 'Sharepoint', 'VMwareVM',
     'SystemState', 'Client', 'GenericDataSource', 'SQLDataBase',
     'AzureFileShare', 'SAPHanaDatabase', 'SAPAseDatabase'
    :type backup_item_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupItemType
    :param backup_items: List of backup items associated with this container.
    :type backup_items: list[str]
    :param policy_name: Backup policy associated with this container.
    :type policy_name: str
    :param last_backup_status: Latest backup status of this container.
    :type last_backup_status: str
    """

    _attribute_map = {
        'last_refreshed_at': {'key': 'lastRefreshedAt', 'type': 'iso-8601'},
        'backup_item_type': {'key': 'backupItemType', 'type': 'str'},
        'backup_items': {'key': 'backupItems', 'type': '[str]'},
        'policy_name': {'key': 'policyName', 'type': 'str'},
        'last_backup_status': {'key': 'lastBackupStatus', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(MabContainerExtendedInfo, self).__init__(**kwargs)
        self.last_refreshed_at = kwargs.get('last_refreshed_at', None)
        self.backup_item_type = kwargs.get('backup_item_type', None)
        self.backup_items = kwargs.get('backup_items', None)
        self.policy_name = kwargs.get('policy_name', None)
        self.last_backup_status = kwargs.get('last_backup_status', None)


class MABContainerHealthDetails(Model):
    """MAB workload-specific Health Details.

    :param code: Health Code
    :type code: int
    :param title: Health Title
    :type title: str
    :param message: Health Message
    :type message: str
    :param recommendations: Health Recommended Actions
    :type recommendations: list[str]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'int'},
        'title': {'key': 'title', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'recommendations': {'key': 'recommendations', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(MABContainerHealthDetails, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.title = kwargs.get('title', None)
        self.message = kwargs.get('message', None)
        self.recommendations = kwargs.get('recommendations', None)


class MabErrorInfo(Model):
    """MAB workload-specific error information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar error_string: Localized error string.
    :vartype error_string: str
    :ivar recommendations: List of localized recommendations.
    :vartype recommendations: list[str]
    """

    _validation = {
        'error_string': {'readonly': True},
        'recommendations': {'readonly': True},
    }

    _attribute_map = {
        'error_string': {'key': 'errorString', 'type': 'str'},
        'recommendations': {'key': 'recommendations', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(MabErrorInfo, self).__init__(**kwargs)
        self.error_string = None
        self.recommendations = None


class MabFileFolderProtectedItem(ProtectedItem):
    """MAB workload-specific backup item.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Type of backup management for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param workload_type: Type of workload this item represents. Possible
     values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB',
     'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataSourceType
    :param container_name: Unique name of container
    :type container_name: str
    :param source_resource_id: ARM ID of the resource to be backed up.
    :type source_resource_id: str
    :param policy_id: ID of the backup policy with which this item is backed
     up.
    :type policy_id: str
    :param last_recovery_point: Timestamp when the last (latest) backup copy
     was created for this backup item.
    :type last_recovery_point: datetime
    :param backup_set_name: Name of the backup set the backup item belongs to
    :type backup_set_name: str
    :param create_mode: Create mode to indicate recovery of existing soft
     deleted data source or creation of new data source. Possible values
     include: 'Invalid', 'Default', 'Recover'
    :type create_mode: str or
     ~azure.mgmt.recoveryservicesbackup.models.CreateMode
    :param deferred_delete_time_in_utc: Time for deferred deletion in UTC
    :type deferred_delete_time_in_utc: datetime
    :param is_scheduled_for_deferred_delete: Flag to identify whether the DS
     is scheduled for deferred delete
    :type is_scheduled_for_deferred_delete: bool
    :param deferred_delete_time_remaining: Time remaining before the DS marked
     for deferred delete is permanently deleted
    :type deferred_delete_time_remaining: str
    :param is_deferred_delete_schedule_upcoming: Flag to identify whether the
     deferred deleted DS is to be purged soon
    :type is_deferred_delete_schedule_upcoming: bool
    :param is_rehydrate: Flag to identify that deferred deleted DS is to be
     moved into Pause state
    :type is_rehydrate: bool
    :param protected_item_type: Required. Constant filled by server.
    :type protected_item_type: str
    :param friendly_name: Friendly name of this backup item.
    :type friendly_name: str
    :param computer_name: Name of the computer associated with this backup
     item.
    :type computer_name: str
    :param last_backup_status: Status of last backup operation.
    :type last_backup_status: str
    :param last_backup_time: Timestamp of the last backup operation on this
     backup item.
    :type last_backup_time: datetime
    :param protection_state: Protected, ProtectionStopped, IRPending or
     ProtectionError
    :type protection_state: str
    :param deferred_delete_sync_time_in_utc: Sync time for deferred deletion
     in UTC
    :type deferred_delete_sync_time_in_utc: long
    :param extended_info: Additional information with this backup item.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.MabFileFolderProtectedItemExtendedInfo
    """

    _validation = {
        'protected_item_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'last_recovery_point': {'key': 'lastRecoveryPoint', 'type': 'iso-8601'},
        'backup_set_name': {'key': 'backupSetName', 'type': 'str'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'deferred_delete_time_in_utc': {'key': 'deferredDeleteTimeInUTC', 'type': 'iso-8601'},
        'is_scheduled_for_deferred_delete': {'key': 'isScheduledForDeferredDelete', 'type': 'bool'},
        'deferred_delete_time_remaining': {'key': 'deferredDeleteTimeRemaining', 'type': 'str'},
        'is_deferred_delete_schedule_upcoming': {'key': 'isDeferredDeleteScheduleUpcoming', 'type': 'bool'},
        'is_rehydrate': {'key': 'isRehydrate', 'type': 'bool'},
        'protected_item_type': {'key': 'protectedItemType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'computer_name': {'key': 'computerName', 'type': 'str'},
        'last_backup_status': {'key': 'lastBackupStatus', 'type': 'str'},
        'last_backup_time': {'key': 'lastBackupTime', 'type': 'iso-8601'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'deferred_delete_sync_time_in_utc': {'key': 'deferredDeleteSyncTimeInUTC', 'type': 'long'},
        'extended_info': {'key': 'extendedInfo', 'type': 'MabFileFolderProtectedItemExtendedInfo'},
    }

    def __init__(self, **kwargs):
        super(MabFileFolderProtectedItem, self).__init__(**kwargs)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.computer_name = kwargs.get('computer_name', None)
        self.last_backup_status = kwargs.get('last_backup_status', None)
        self.last_backup_time = kwargs.get('last_backup_time', None)
        self.protection_state = kwargs.get('protection_state', None)
        self.deferred_delete_sync_time_in_utc = kwargs.get('deferred_delete_sync_time_in_utc', None)
        self.extended_info = kwargs.get('extended_info', None)
        self.protected_item_type = 'MabFileFolderProtectedItem'


class MabFileFolderProtectedItemExtendedInfo(Model):
    """Additional information on the backed up item.

    :param last_refreshed_at: Last time when the agent data synced to service.
    :type last_refreshed_at: datetime
    :param oldest_recovery_point: The oldest backup copy available.
    :type oldest_recovery_point: datetime
    :param recovery_point_count: Number of backup copies associated with the
     backup item.
    :type recovery_point_count: int
    """

    _attribute_map = {
        'last_refreshed_at': {'key': 'lastRefreshedAt', 'type': 'iso-8601'},
        'oldest_recovery_point': {'key': 'oldestRecoveryPoint', 'type': 'iso-8601'},
        'recovery_point_count': {'key': 'recoveryPointCount', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(MabFileFolderProtectedItemExtendedInfo, self).__init__(**kwargs)
        self.last_refreshed_at = kwargs.get('last_refreshed_at', None)
        self.oldest_recovery_point = kwargs.get('oldest_recovery_point', None)
        self.recovery_point_count = kwargs.get('recovery_point_count', None)


class MabJob(Job):
    """MAB workload-specific job.

    All required parameters must be populated in order to send to Azure.

    :param entity_friendly_name: Friendly name of the entity on which the
     current job is executing.
    :type entity_friendly_name: str
    :param backup_management_type: Backup management type to execute the
     current job. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param operation: The operation name.
    :type operation: str
    :param status: Job status.
    :type status: str
    :param start_time: The start time.
    :type start_time: datetime
    :param end_time: The end time.
    :type end_time: datetime
    :param activity_id: ActivityId of job.
    :type activity_id: str
    :param job_type: Required. Constant filled by server.
    :type job_type: str
    :param duration: Time taken by job to run.
    :type duration: timedelta
    :param actions_info: The state/actions applicable on jobs like
     cancel/retry.
    :type actions_info: list[str or
     ~azure.mgmt.recoveryservicesbackup.models.JobSupportedAction]
    :param mab_server_name: Name of server protecting the DS.
    :type mab_server_name: str
    :param mab_server_type: Server type of MAB container. Possible values
     include: 'Invalid', 'Unknown', 'IaasVMContainer',
     'IaasVMServiceContainer', 'DPMContainer', 'AzureBackupServerContainer',
     'MABContainer', 'Cluster', 'AzureSqlContainer', 'Windows', 'VCenter',
     'VMAppContainer', 'SQLAGWorkLoadContainer', 'StorageContainer',
     'GenericContainer'
    :type mab_server_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.MabServerType
    :param workload_type: Workload type of backup item. Possible values
     include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB', 'Exchange',
     'Sharepoint', 'VMwareVM', 'SystemState', 'Client', 'GenericDataSource',
     'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase', 'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.WorkloadType
    :param error_details: The errors.
    :type error_details:
     list[~azure.mgmt.recoveryservicesbackup.models.MabErrorInfo]
    :param extended_info: Additional information on the job.
    :type extended_info:
     ~azure.mgmt.recoveryservicesbackup.models.MabJobExtendedInfo
    """

    _validation = {
        'job_type': {'required': True},
    }

    _attribute_map = {
        'entity_friendly_name': {'key': 'entityFriendlyName', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'activity_id': {'key': 'activityId', 'type': 'str'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'duration': {'key': 'duration', 'type': 'duration'},
        'actions_info': {'key': 'actionsInfo', 'type': '[JobSupportedAction]'},
        'mab_server_name': {'key': 'mabServerName', 'type': 'str'},
        'mab_server_type': {'key': 'mabServerType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'error_details': {'key': 'errorDetails', 'type': '[MabErrorInfo]'},
        'extended_info': {'key': 'extendedInfo', 'type': 'MabJobExtendedInfo'},
    }

    def __init__(self, **kwargs):
        super(MabJob, self).__init__(**kwargs)
        self.duration = kwargs.get('duration', None)
        self.actions_info = kwargs.get('actions_info', None)
        self.mab_server_name = kwargs.get('mab_server_name', None)
        self.mab_server_type = kwargs.get('mab_server_type', None)
        self.workload_type = kwargs.get('workload_type', None)
        self.error_details = kwargs.get('error_details', None)
        self.extended_info = kwargs.get('extended_info', None)
        self.job_type = 'MabJob'


class MabJobExtendedInfo(Model):
    """Additional information for the MAB workload-specific job.

    :param tasks_list: List of tasks for this job.
    :type tasks_list:
     list[~azure.mgmt.recoveryservicesbackup.models.MabJobTaskDetails]
    :param property_bag: The job properties.
    :type property_bag: dict[str, str]
    :param dynamic_error_message: Non localized error message specific to this
     job.
    :type dynamic_error_message: str
    """

    _attribute_map = {
        'tasks_list': {'key': 'tasksList', 'type': '[MabJobTaskDetails]'},
        'property_bag': {'key': 'propertyBag', 'type': '{str}'},
        'dynamic_error_message': {'key': 'dynamicErrorMessage', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(MabJobExtendedInfo, self).__init__(**kwargs)
        self.tasks_list = kwargs.get('tasks_list', None)
        self.property_bag = kwargs.get('property_bag', None)
        self.dynamic_error_message = kwargs.get('dynamic_error_message', None)


class MabJobTaskDetails(Model):
    """MAB workload-specific job task details.

    :param task_id: The task display name.
    :type task_id: str
    :param start_time: The start time.
    :type start_time: datetime
    :param end_time: The end time.
    :type end_time: datetime
    :param duration: Time elapsed for task.
    :type duration: timedelta
    :param status: The status.
    :type status: str
    """

    _attribute_map = {
        'task_id': {'key': 'taskId', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'duration': {'key': 'duration', 'type': 'duration'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(MabJobTaskDetails, self).__init__(**kwargs)
        self.task_id = kwargs.get('task_id', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.duration = kwargs.get('duration', None)
        self.status = kwargs.get('status', None)


class MabProtectionPolicy(ProtectionPolicy):
    """Mab container-specific backup policy.

    All required parameters must be populated in order to send to Azure.

    :param protected_items_count: Number of items associated with this policy.
    :type protected_items_count: int
    :param backup_management_type: Required. Constant filled by server.
    :type backup_management_type: str
    :param schedule_policy: Backup schedule of backup policy.
    :type schedule_policy:
     ~azure.mgmt.recoveryservicesbackup.models.SchedulePolicy
    :param retention_policy: Retention policy details.
    :type retention_policy:
     ~azure.mgmt.recoveryservicesbackup.models.RetentionPolicy
    """

    _validation = {
        'backup_management_type': {'required': True},
    }

    _attribute_map = {
        'protected_items_count': {'key': 'protectedItemsCount', 'type': 'int'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'schedule_policy': {'key': 'schedulePolicy', 'type': 'SchedulePolicy'},
        'retention_policy': {'key': 'retentionPolicy', 'type': 'RetentionPolicy'},
    }

    def __init__(self, **kwargs):
        super(MabProtectionPolicy, self).__init__(**kwargs)
        self.schedule_policy = kwargs.get('schedule_policy', None)
        self.retention_policy = kwargs.get('retention_policy', None)
        self.backup_management_type = 'MAB'


class MonthlyRetentionSchedule(Model):
    """Monthly retention schedule.

    :param retention_schedule_format_type: Retention schedule format type for
     monthly retention policy. Possible values include: 'Invalid', 'Daily',
     'Weekly'
    :type retention_schedule_format_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RetentionScheduleFormat
    :param retention_schedule_daily: Daily retention format for monthly
     retention policy.
    :type retention_schedule_daily:
     ~azure.mgmt.recoveryservicesbackup.models.DailyRetentionFormat
    :param retention_schedule_weekly: Weekly retention format for monthly
     retention policy.
    :type retention_schedule_weekly:
     ~azure.mgmt.recoveryservicesbackup.models.WeeklyRetentionFormat
    :param retention_times: Retention times of retention policy.
    :type retention_times: list[datetime]
    :param retention_duration: Retention duration of retention Policy.
    :type retention_duration:
     ~azure.mgmt.recoveryservicesbackup.models.RetentionDuration
    """

    _attribute_map = {
        'retention_schedule_format_type': {'key': 'retentionScheduleFormatType', 'type': 'str'},
        'retention_schedule_daily': {'key': 'retentionScheduleDaily', 'type': 'DailyRetentionFormat'},
        'retention_schedule_weekly': {'key': 'retentionScheduleWeekly', 'type': 'WeeklyRetentionFormat'},
        'retention_times': {'key': 'retentionTimes', 'type': '[iso-8601]'},
        'retention_duration': {'key': 'retentionDuration', 'type': 'RetentionDuration'},
    }

    def __init__(self, **kwargs):
        super(MonthlyRetentionSchedule, self).__init__(**kwargs)
        self.retention_schedule_format_type = kwargs.get('retention_schedule_format_type', None)
        self.retention_schedule_daily = kwargs.get('retention_schedule_daily', None)
        self.retention_schedule_weekly = kwargs.get('retention_schedule_weekly', None)
        self.retention_times = kwargs.get('retention_times', None)
        self.retention_duration = kwargs.get('retention_duration', None)


class NameInfo(Model):
    """The name of usage.

    :param value: Value of usage.
    :type value: str
    :param localized_value: Localized value of usage.
    :type localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NameInfo, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.localized_value = kwargs.get('localized_value', None)


class OperationResultInfo(OperationResultInfoBase):
    """Operation result info.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param job_list: List of jobs created by this operation.
    :type job_list: list[str]
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'job_list': {'key': 'jobList', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(OperationResultInfo, self).__init__(**kwargs)
        self.job_list = kwargs.get('job_list', None)
        self.object_type = 'OperationResultInfo'


class OperationWorkerResponse(Model):
    """This is the base class for operation result responses.

    :param status_code: HTTP Status Code of the operation. Possible values
     include: 'Continue', 'SwitchingProtocols', 'OK', 'Created', 'Accepted',
     'NonAuthoritativeInformation', 'NoContent', 'ResetContent',
     'PartialContent', 'MultipleChoices', 'Ambiguous', 'MovedPermanently',
     'Moved', 'Found', 'Redirect', 'SeeOther', 'RedirectMethod', 'NotModified',
     'UseProxy', 'Unused', 'TemporaryRedirect', 'RedirectKeepVerb',
     'BadRequest', 'Unauthorized', 'PaymentRequired', 'Forbidden', 'NotFound',
     'MethodNotAllowed', 'NotAcceptable', 'ProxyAuthenticationRequired',
     'RequestTimeout', 'Conflict', 'Gone', 'LengthRequired',
     'PreconditionFailed', 'RequestEntityTooLarge', 'RequestUriTooLong',
     'UnsupportedMediaType', 'RequestedRangeNotSatisfiable',
     'ExpectationFailed', 'UpgradeRequired', 'InternalServerError',
     'NotImplemented', 'BadGateway', 'ServiceUnavailable', 'GatewayTimeout',
     'HttpVersionNotSupported'
    :type status_code: str or
     ~azure.mgmt.recoveryservicesbackup.models.HttpStatusCode
    :param headers: HTTP headers associated with this operation.
    :type headers: dict[str, list[str]]
    """

    _attribute_map = {
        'status_code': {'key': 'statusCode', 'type': 'HttpStatusCode'},
        'headers': {'key': 'headers', 'type': '{[str]}'},
    }

    def __init__(self, **kwargs):
        super(OperationWorkerResponse, self).__init__(**kwargs)
        self.status_code = kwargs.get('status_code', None)
        self.headers = kwargs.get('headers', None)


class OperationResultInfoBaseResource(OperationWorkerResponse):
    """Base class for operation result info.

    :param status_code: HTTP Status Code of the operation. Possible values
     include: 'Continue', 'SwitchingProtocols', 'OK', 'Created', 'Accepted',
     'NonAuthoritativeInformation', 'NoContent', 'ResetContent',
     'PartialContent', 'MultipleChoices', 'Ambiguous', 'MovedPermanently',
     'Moved', 'Found', 'Redirect', 'SeeOther', 'RedirectMethod', 'NotModified',
     'UseProxy', 'Unused', 'TemporaryRedirect', 'RedirectKeepVerb',
     'BadRequest', 'Unauthorized', 'PaymentRequired', 'Forbidden', 'NotFound',
     'MethodNotAllowed', 'NotAcceptable', 'ProxyAuthenticationRequired',
     'RequestTimeout', 'Conflict', 'Gone', 'LengthRequired',
     'PreconditionFailed', 'RequestEntityTooLarge', 'RequestUriTooLong',
     'UnsupportedMediaType', 'RequestedRangeNotSatisfiable',
     'ExpectationFailed', 'UpgradeRequired', 'InternalServerError',
     'NotImplemented', 'BadGateway', 'ServiceUnavailable', 'GatewayTimeout',
     'HttpVersionNotSupported'
    :type status_code: str or
     ~azure.mgmt.recoveryservicesbackup.models.HttpStatusCode
    :param headers: HTTP headers associated with this operation.
    :type headers: dict[str, list[str]]
    :param operation: OperationResultInfoBaseResource operation
    :type operation:
     ~azure.mgmt.recoveryservicesbackup.models.OperationResultInfoBase
    """

    _attribute_map = {
        'status_code': {'key': 'statusCode', 'type': 'HttpStatusCode'},
        'headers': {'key': 'headers', 'type': '{[str]}'},
        'operation': {'key': 'operation', 'type': 'OperationResultInfoBase'},
    }

    def __init__(self, **kwargs):
        super(OperationResultInfoBaseResource, self).__init__(**kwargs)
        self.operation = kwargs.get('operation', None)


class OperationStatus(Model):
    """Operation status.

    :param id: ID of the operation.
    :type id: str
    :param name: Name of the operation.
    :type name: str
    :param status: Operation status. Possible values include: 'Invalid',
     'InProgress', 'Succeeded', 'Failed', 'Canceled'
    :type status: str or
     ~azure.mgmt.recoveryservicesbackup.models.OperationStatusValues
    :param start_time: Operation start time. Format: ISO-8601.
    :type start_time: datetime
    :param end_time: Operation end time. Format: ISO-8601.
    :type end_time: datetime
    :param error: Error information related to this operation.
    :type error:
     ~azure.mgmt.recoveryservicesbackup.models.OperationStatusError
    :param properties: Additional information associated with this operation.
    :type properties:
     ~azure.mgmt.recoveryservicesbackup.models.OperationStatusExtendedInfo
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'error': {'key': 'error', 'type': 'OperationStatusError'},
        'properties': {'key': 'properties', 'type': 'OperationStatusExtendedInfo'},
    }

    def __init__(self, **kwargs):
        super(OperationStatus, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.status = kwargs.get('status', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.error = kwargs.get('error', None)
        self.properties = kwargs.get('properties', None)


class OperationStatusError(Model):
    """Error information associated with operation status call.

    :param code: Error code of the operation failure.
    :type code: str
    :param message: Error message displayed if the operation failure.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationStatusError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class OperationStatusExtendedInfo(Model):
    """Base class for additional information of operation status.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: OperationStatusJobExtendedInfo,
    OperationStatusJobsExtendedInfo, OperationStatusProvisionILRExtendedInfo

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'OperationStatusJobExtendedInfo': 'OperationStatusJobExtendedInfo', 'OperationStatusJobsExtendedInfo': 'OperationStatusJobsExtendedInfo', 'OperationStatusProvisionILRExtendedInfo': 'OperationStatusProvisionILRExtendedInfo'}
    }

    def __init__(self, **kwargs):
        super(OperationStatusExtendedInfo, self).__init__(**kwargs)
        self.object_type = None


class OperationStatusJobExtendedInfo(OperationStatusExtendedInfo):
    """Operation status job extended info.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param job_id: ID of the job created for this protected item.
    :type job_id: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'job_id': {'key': 'jobId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationStatusJobExtendedInfo, self).__init__(**kwargs)
        self.job_id = kwargs.get('job_id', None)
        self.object_type = 'OperationStatusJobExtendedInfo'


class OperationStatusJobsExtendedInfo(OperationStatusExtendedInfo):
    """Operation status extended info for list of jobs.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param job_ids: IDs of the jobs created for the protected item.
    :type job_ids: list[str]
    :param failed_jobs_error: Stores all the failed jobs along with the
     corresponding error codes.
    :type failed_jobs_error: dict[str, str]
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'job_ids': {'key': 'jobIds', 'type': '[str]'},
        'failed_jobs_error': {'key': 'failedJobsError', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(OperationStatusJobsExtendedInfo, self).__init__(**kwargs)
        self.job_ids = kwargs.get('job_ids', None)
        self.failed_jobs_error = kwargs.get('failed_jobs_error', None)
        self.object_type = 'OperationStatusJobsExtendedInfo'


class OperationStatusProvisionILRExtendedInfo(OperationStatusExtendedInfo):
    """Operation status extended info for ILR provision action.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param recovery_target: Target details for file / folder restore.
    :type recovery_target:
     ~azure.mgmt.recoveryservicesbackup.models.InstantItemRecoveryTarget
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_target': {'key': 'recoveryTarget', 'type': 'InstantItemRecoveryTarget'},
    }

    def __init__(self, **kwargs):
        super(OperationStatusProvisionILRExtendedInfo, self).__init__(**kwargs)
        self.recovery_target = kwargs.get('recovery_target', None)
        self.object_type = 'OperationStatusProvisionILRExtendedInfo'


class PointInTimeRange(Model):
    """Provides details for log ranges.

    :param start_time: Start time of the time range for log recovery.
    :type start_time: datetime
    :param end_time: End time of the time range for log recovery.
    :type end_time: datetime
    """

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(PointInTimeRange, self).__init__(**kwargs)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)


class PreBackupValidation(Model):
    """Pre-backup validation for Azure VM Workload provider.

    :param status: Status of protectable item, i.e.
     InProgress,Succeeded,Failed. Possible values include: 'Invalid',
     'Success', 'Failed'
    :type status: str or
     ~azure.mgmt.recoveryservicesbackup.models.InquiryStatus
    :param code: Error code of protectable item
    :type code: str
    :param message: Message corresponding to the error code for the
     protectable item
    :type message: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PreBackupValidation, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class PreValidateEnableBackupRequest(Model):
    """Contract to validate if backup can be enabled on the given resource in a
    given vault and given configuration.
    It will validate followings
    1. Vault capacity
    2. VM is already protected
    3. Any VM related configuration passed in properties.

    :param resource_type: ProtectedItem Type- VM, SqlDataBase, AzureFileShare
     etc. Possible values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb',
     'SQLDB', 'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase',
     'SAPAseDatabase'
    :type resource_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataSourceType
    :param resource_id: ARM Virtual Machine Id
    :type resource_id: str
    :param vault_id: ARM id of the Recovery Services Vault
    :type vault_id: str
    :param properties: Configuration of VM if any needs to be validated like
     OS type etc
    :type properties: str
    """

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'vault_id': {'key': 'vaultId', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PreValidateEnableBackupRequest, self).__init__(**kwargs)
        self.resource_type = kwargs.get('resource_type', None)
        self.resource_id = kwargs.get('resource_id', None)
        self.vault_id = kwargs.get('vault_id', None)
        self.properties = kwargs.get('properties', None)


class PreValidateEnableBackupResponse(Model):
    """Response contract for enable backup validation request.

    :param status: Validation Status. Possible values include: 'Invalid',
     'Succeeded', 'Failed'
    :type status: str or
     ~azure.mgmt.recoveryservicesbackup.models.ValidationStatus
    :param error_code: Response error code
    :type error_code: str
    :param error_message: Response error message
    :type error_message: str
    :param recommendation: Recommended action for user
    :type recommendation: str
    :param container_name: Specifies the product specific container name. E.g.
     iaasvmcontainer;iaasvmcontainer;rgname;vmname. This is required
     for portal
    :type container_name: str
    :param protected_item_name: Specifies the product specific ds name. E.g.
     vm;iaasvmcontainer;rgname;vmname. This is required for portal
    :type protected_item_name: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'error_code': {'key': 'errorCode', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'recommendation': {'key': 'recommendation', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'protected_item_name': {'key': 'protectedItemName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PreValidateEnableBackupResponse, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.error_code = kwargs.get('error_code', None)
        self.error_message = kwargs.get('error_message', None)
        self.recommendation = kwargs.get('recommendation', None)
        self.container_name = kwargs.get('container_name', None)
        self.protected_item_name = kwargs.get('protected_item_name', None)


class ProtectableContainerResource(Resource):
    """Protectable Container Class.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: ProtectableContainerResource properties
    :type properties:
     ~azure.mgmt.recoveryservicesbackup.models.ProtectableContainer
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ProtectableContainer'},
    }

    def __init__(self, **kwargs):
        super(ProtectableContainerResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class ProtectedItemQueryObject(Model):
    """Filters to list backup items.

    :param health_state: Health State for the backed up item. Possible values
     include: 'Passed', 'ActionRequired', 'ActionSuggested', 'Invalid'
    :type health_state: str or
     ~azure.mgmt.recoveryservicesbackup.models.HealthState
    :param backup_management_type: Backup management type for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param item_type: Type of workload this item represents. Possible values
     include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB', 'Exchange',
     'Sharepoint', 'VMwareVM', 'SystemState', 'Client', 'GenericDataSource',
     'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase', 'SAPAseDatabase'
    :type item_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataSourceType
    :param policy_name: Backup policy name associated with the backup item.
    :type policy_name: str
    :param container_name: Name of the container.
    :type container_name: str
    :param backup_engine_name: Backup Engine name
    :type backup_engine_name: str
    :param friendly_name: Friendly name of protected item
    :type friendly_name: str
    :param fabric_name: Name of the fabric.
    :type fabric_name: str
    :param backup_set_name: Name of the backup set.
    :type backup_set_name: str
    """

    _attribute_map = {
        'health_state': {'key': 'healthState', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'item_type': {'key': 'itemType', 'type': 'str'},
        'policy_name': {'key': 'policyName', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'backup_engine_name': {'key': 'backupEngineName', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'fabric_name': {'key': 'fabricName', 'type': 'str'},
        'backup_set_name': {'key': 'backupSetName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ProtectedItemQueryObject, self).__init__(**kwargs)
        self.health_state = kwargs.get('health_state', None)
        self.backup_management_type = kwargs.get('backup_management_type', None)
        self.item_type = kwargs.get('item_type', None)
        self.policy_name = kwargs.get('policy_name', None)
        self.container_name = kwargs.get('container_name', None)
        self.backup_engine_name = kwargs.get('backup_engine_name', None)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.fabric_name = kwargs.get('fabric_name', None)
        self.backup_set_name = kwargs.get('backup_set_name', None)


class ProtectedItemResource(Resource):
    """Base class for backup items.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: ProtectedItemResource properties
    :type properties: ~azure.mgmt.recoveryservicesbackup.models.ProtectedItem
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ProtectedItem'},
    }

    def __init__(self, **kwargs):
        super(ProtectedItemResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class ProtectionContainerResource(Resource):
    """Base class for container with backup items. Containers with specific
    workloads are derived from this class.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: ProtectionContainerResource properties
    :type properties:
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionContainer
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ProtectionContainer'},
    }

    def __init__(self, **kwargs):
        super(ProtectionContainerResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class ProtectionIntentQueryObject(Model):
    """Filters to list protection intent.

    :param backup_management_type: Backup management type for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param item_type: Type of workload this item represents. Possible values
     include: 'Invalid', 'SQLInstance', 'SQLAvailabilityGroupContainer'
    :type item_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.IntentItemType
    :param parent_name: Parent name of the intent
    :type parent_name: str
    :param item_name: Item name of the intent
    :type item_name: str
    """

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'item_type': {'key': 'itemType', 'type': 'str'},
        'parent_name': {'key': 'parentName', 'type': 'str'},
        'item_name': {'key': 'itemName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ProtectionIntentQueryObject, self).__init__(**kwargs)
        self.backup_management_type = kwargs.get('backup_management_type', None)
        self.item_type = kwargs.get('item_type', None)
        self.parent_name = kwargs.get('parent_name', None)
        self.item_name = kwargs.get('item_name', None)


class ProtectionIntentResource(Resource):
    """Base class for backup ProtectionIntent.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: ProtectionIntentResource properties
    :type properties:
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionIntent
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ProtectionIntent'},
    }

    def __init__(self, **kwargs):
        super(ProtectionIntentResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class ProtectionPolicyQueryObject(Model):
    """Filters the list backup policies API.

    :param backup_management_type: Backup management type for the backup
     policy. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param fabric_name: Fabric name for filter
    :type fabric_name: str
    :param workload_type: Workload type for the backup policy. Possible values
     include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB', 'Exchange',
     'Sharepoint', 'VMwareVM', 'SystemState', 'Client', 'GenericDataSource',
     'SQLDataBase', 'AzureFileShare', 'SAPHanaDatabase', 'SAPAseDatabase'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.WorkloadType
    """

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'fabric_name': {'key': 'fabricName', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ProtectionPolicyQueryObject, self).__init__(**kwargs)
        self.backup_management_type = kwargs.get('backup_management_type', None)
        self.fabric_name = kwargs.get('fabric_name', None)
        self.workload_type = kwargs.get('workload_type', None)


class ProtectionPolicyResource(Resource):
    """Base class for backup policy. Workload-specific backup policies are derived
    from this class.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: ProtectionPolicyResource properties
    :type properties:
     ~azure.mgmt.recoveryservicesbackup.models.ProtectionPolicy
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ProtectionPolicy'},
    }

    def __init__(self, **kwargs):
        super(ProtectionPolicyResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class RecoveryPointDiskConfiguration(Model):
    """Disk configuration.

    :param number_of_disks_included_in_backup: Number of disks included in
     backup
    :type number_of_disks_included_in_backup: int
    :param number_of_disks_attached_to_vm: Number of disks attached to the VM
    :type number_of_disks_attached_to_vm: int
    :param included_disk_list: Information of disks included in backup
    :type included_disk_list:
     list[~azure.mgmt.recoveryservicesbackup.models.DiskInformation]
    :param excluded_disk_list: Information of disks excluded from backup
    :type excluded_disk_list:
     list[~azure.mgmt.recoveryservicesbackup.models.DiskInformation]
    """

    _attribute_map = {
        'number_of_disks_included_in_backup': {'key': 'numberOfDisksIncludedInBackup', 'type': 'int'},
        'number_of_disks_attached_to_vm': {'key': 'numberOfDisksAttachedToVm', 'type': 'int'},
        'included_disk_list': {'key': 'includedDiskList', 'type': '[DiskInformation]'},
        'excluded_disk_list': {'key': 'excludedDiskList', 'type': '[DiskInformation]'},
    }

    def __init__(self, **kwargs):
        super(RecoveryPointDiskConfiguration, self).__init__(**kwargs)
        self.number_of_disks_included_in_backup = kwargs.get('number_of_disks_included_in_backup', None)
        self.number_of_disks_attached_to_vm = kwargs.get('number_of_disks_attached_to_vm', None)
        self.included_disk_list = kwargs.get('included_disk_list', None)
        self.excluded_disk_list = kwargs.get('excluded_disk_list', None)


class RecoveryPointResource(Resource):
    """Base class for backup copies. Workload-specific backup copies are derived
    from this class.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: RecoveryPointResource properties
    :type properties: ~azure.mgmt.recoveryservicesbackup.models.RecoveryPoint
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'RecoveryPoint'},
    }

    def __init__(self, **kwargs):
        super(RecoveryPointResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class RecoveryPointTierInformation(Model):
    """Recovery point tier information.

    :param type: Recovery point tier type. Possible values include: 'Invalid',
     'InstantRP', 'HardenedRP'
    :type type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryPointTierType
    :param status: Recovery point tier status. Possible values include:
     'Invalid', 'Valid', 'Disabled', 'Deleted'
    :type status: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryPointTierStatus
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'RecoveryPointTierType'},
        'status': {'key': 'status', 'type': 'RecoveryPointTierStatus'},
    }

    def __init__(self, **kwargs):
        super(RecoveryPointTierInformation, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.status = kwargs.get('status', None)


class ResourceList(Model):
    """Base for all lists of resources.

    :param next_link: The uri to fetch the next page of resources. Call
     ListNext() fetches next page of resources.
    :type next_link: str
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ResourceList, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)


class RestoreFileSpecs(Model):
    """Restore file specs like file path, type and target folder path info.

    :param path: Source File/Folder path
    :type path: str
    :param file_spec_type: Indicates what the Path variable stands for
    :type file_spec_type: str
    :param target_folder_path: Destination folder path in target FileShare
    :type target_folder_path: str
    """

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
        'file_spec_type': {'key': 'fileSpecType', 'type': 'str'},
        'target_folder_path': {'key': 'targetFolderPath', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RestoreFileSpecs, self).__init__(**kwargs)
        self.path = kwargs.get('path', None)
        self.file_spec_type = kwargs.get('file_spec_type', None)
        self.target_folder_path = kwargs.get('target_folder_path', None)


class RestoreRequestResource(Resource):
    """Base class for restore request. Workload-specific restore requests are
    derived from this class.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: RestoreRequestResource properties
    :type properties: ~azure.mgmt.recoveryservicesbackup.models.RestoreRequest
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'RestoreRequest'},
    }

    def __init__(self, **kwargs):
        super(RestoreRequestResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class RetentionDuration(Model):
    """Retention duration.

    :param count: Count of duration types. Retention duration is obtained by
     the counting the duration type Count times.
     For example, when Count = 3 and DurationType = Weeks, retention duration
     will be three weeks.
    :type count: int
    :param duration_type: Retention duration type of retention policy.
     Possible values include: 'Invalid', 'Days', 'Weeks', 'Months', 'Years'
    :type duration_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RetentionDurationType
    """

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'duration_type': {'key': 'durationType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RetentionDuration, self).__init__(**kwargs)
        self.count = kwargs.get('count', None)
        self.duration_type = kwargs.get('duration_type', None)


class Settings(Model):
    """Common settings field for backup management.

    :param time_zone: TimeZone optional input as string. For example: TimeZone
     = "Pacific Standard Time".
    :type time_zone: str
    :param issqlcompression: SQL compression flag
    :type issqlcompression: bool
    :param is_compression: Workload compression flag. This has been added so
     that 'isSqlCompression'
     will be deprecated once clients upgrade to consider this flag.
    :type is_compression: bool
    """

    _attribute_map = {
        'time_zone': {'key': 'timeZone', 'type': 'str'},
        'issqlcompression': {'key': 'issqlcompression', 'type': 'bool'},
        'is_compression': {'key': 'isCompression', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(Settings, self).__init__(**kwargs)
        self.time_zone = kwargs.get('time_zone', None)
        self.issqlcompression = kwargs.get('issqlcompression', None)
        self.is_compression = kwargs.get('is_compression', None)


class SimpleRetentionPolicy(RetentionPolicy):
    """Simple policy retention.

    All required parameters must be populated in order to send to Azure.

    :param retention_policy_type: Required. Constant filled by server.
    :type retention_policy_type: str
    :param retention_duration: Retention duration of the protection policy.
    :type retention_duration:
     ~azure.mgmt.recoveryservicesbackup.models.RetentionDuration
    """

    _validation = {
        'retention_policy_type': {'required': True},
    }

    _attribute_map = {
        'retention_policy_type': {'key': 'retentionPolicyType', 'type': 'str'},
        'retention_duration': {'key': 'retentionDuration', 'type': 'RetentionDuration'},
    }

    def __init__(self, **kwargs):
        super(SimpleRetentionPolicy, self).__init__(**kwargs)
        self.retention_duration = kwargs.get('retention_duration', None)
        self.retention_policy_type = 'SimpleRetentionPolicy'


class SimpleSchedulePolicy(SchedulePolicy):
    """Simple policy schedule.

    All required parameters must be populated in order to send to Azure.

    :param schedule_policy_type: Required. Constant filled by server.
    :type schedule_policy_type: str
    :param schedule_run_frequency: Frequency of the schedule operation of this
     policy. Possible values include: 'Invalid', 'Daily', 'Weekly'
    :type schedule_run_frequency: str or
     ~azure.mgmt.recoveryservicesbackup.models.ScheduleRunType
    :param schedule_run_days: List of days of week this schedule has to be
     run.
    :type schedule_run_days: list[str or
     ~azure.mgmt.recoveryservicesbackup.models.DayOfWeek]
    :param schedule_run_times: List of times of day this schedule has to be
     run.
    :type schedule_run_times: list[datetime]
    :param schedule_weekly_frequency: At every number weeks this schedule has
     to be run.
    :type schedule_weekly_frequency: int
    """

    _validation = {
        'schedule_policy_type': {'required': True},
    }

    _attribute_map = {
        'schedule_policy_type': {'key': 'schedulePolicyType', 'type': 'str'},
        'schedule_run_frequency': {'key': 'scheduleRunFrequency', 'type': 'str'},
        'schedule_run_days': {'key': 'scheduleRunDays', 'type': '[DayOfWeek]'},
        'schedule_run_times': {'key': 'scheduleRunTimes', 'type': '[iso-8601]'},
        'schedule_weekly_frequency': {'key': 'scheduleWeeklyFrequency', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(SimpleSchedulePolicy, self).__init__(**kwargs)
        self.schedule_run_frequency = kwargs.get('schedule_run_frequency', None)
        self.schedule_run_days = kwargs.get('schedule_run_days', None)
        self.schedule_run_times = kwargs.get('schedule_run_times', None)
        self.schedule_weekly_frequency = kwargs.get('schedule_weekly_frequency', None)
        self.schedule_policy_type = 'SimpleSchedulePolicy'


class SQLDataDirectory(Model):
    """SQLDataDirectory info.

    :param type: Type of data directory mapping. Possible values include:
     'Invalid', 'Data', 'Log'
    :type type: str or
     ~azure.mgmt.recoveryservicesbackup.models.SQLDataDirectoryType
    :param path: File path
    :type path: str
    :param logical_name: Logical name of the file
    :type logical_name: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
        'logical_name': {'key': 'logicalName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SQLDataDirectory, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.path = kwargs.get('path', None)
        self.logical_name = kwargs.get('logical_name', None)


class SQLDataDirectoryMapping(Model):
    """Encapsulates information regarding data directory.

    :param mapping_type: Type of data directory mapping. Possible values
     include: 'Invalid', 'Data', 'Log'
    :type mapping_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.SQLDataDirectoryType
    :param source_logical_name: Restore source logical name path
    :type source_logical_name: str
    :param source_path: Restore source path
    :type source_path: str
    :param target_path: Target path
    :type target_path: str
    """

    _attribute_map = {
        'mapping_type': {'key': 'mappingType', 'type': 'str'},
        'source_logical_name': {'key': 'sourceLogicalName', 'type': 'str'},
        'source_path': {'key': 'sourcePath', 'type': 'str'},
        'target_path': {'key': 'targetPath', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SQLDataDirectoryMapping, self).__init__(**kwargs)
        self.mapping_type = kwargs.get('mapping_type', None)
        self.source_logical_name = kwargs.get('source_logical_name', None)
        self.source_path = kwargs.get('source_path', None)
        self.target_path = kwargs.get('target_path', None)


class SubProtectionPolicy(Model):
    """Sub-protection policy which includes schedule and retention.

    :param policy_type: Type of backup policy type. Possible values include:
     'Invalid', 'Full', 'Differential', 'Log', 'CopyOnlyFull'
    :type policy_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.PolicyType
    :param schedule_policy: Backup schedule specified as part of backup
     policy.
    :type schedule_policy:
     ~azure.mgmt.recoveryservicesbackup.models.SchedulePolicy
    :param retention_policy: Retention policy with the details on backup copy
     retention ranges.
    :type retention_policy:
     ~azure.mgmt.recoveryservicesbackup.models.RetentionPolicy
    """

    _attribute_map = {
        'policy_type': {'key': 'policyType', 'type': 'str'},
        'schedule_policy': {'key': 'schedulePolicy', 'type': 'SchedulePolicy'},
        'retention_policy': {'key': 'retentionPolicy', 'type': 'RetentionPolicy'},
    }

    def __init__(self, **kwargs):
        super(SubProtectionPolicy, self).__init__(**kwargs)
        self.policy_type = kwargs.get('policy_type', None)
        self.schedule_policy = kwargs.get('schedule_policy', None)
        self.retention_policy = kwargs.get('retention_policy', None)


class TargetAFSRestoreInfo(Model):
    """Target Azure File Share Info.

    :param name: File share name
    :type name: str
    :param target_resource_id: Target file share resource ARM ID
    :type target_resource_id: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TargetAFSRestoreInfo, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.target_resource_id = kwargs.get('target_resource_id', None)


class TargetRestoreInfo(Model):
    """Details about target workload during restore operation.

    :param overwrite_option: Can Overwrite if Target DataBase already exists.
     Possible values include: 'Invalid', 'FailOnConflict', 'Overwrite'
    :type overwrite_option: str or
     ~azure.mgmt.recoveryservicesbackup.models.OverwriteOptions
    :param container_id: Resource Id name of the container in which Target
     DataBase resides
    :type container_id: str
    :param database_name: Database name InstanceName/DataBaseName for SQL or
     System/DbName for SAP Hana
    :type database_name: str
    """

    _attribute_map = {
        'overwrite_option': {'key': 'overwriteOption', 'type': 'str'},
        'container_id': {'key': 'containerId', 'type': 'str'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TargetRestoreInfo, self).__init__(**kwargs)
        self.overwrite_option = kwargs.get('overwrite_option', None)
        self.container_id = kwargs.get('container_id', None)
        self.database_name = kwargs.get('database_name', None)


class TokenInformation(Model):
    """The token information details.

    :param token: Token value.
    :type token: str
    :param expiry_time_in_utc_ticks: Expiry time of token.
    :type expiry_time_in_utc_ticks: long
    :param security_pin: Security PIN
    :type security_pin: str
    """

    _attribute_map = {
        'token': {'key': 'token', 'type': 'str'},
        'expiry_time_in_utc_ticks': {'key': 'expiryTimeInUtcTicks', 'type': 'long'},
        'security_pin': {'key': 'securityPIN', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TokenInformation, self).__init__(**kwargs)
        self.token = kwargs.get('token', None)
        self.expiry_time_in_utc_ticks = kwargs.get('expiry_time_in_utc_ticks', None)
        self.security_pin = kwargs.get('security_pin', None)


class ValidateOperationRequest(Model):
    """Base class for validate operation request.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ValidateRestoreOperationRequest

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'ValidateRestoreOperationRequest': 'ValidateRestoreOperationRequest'}
    }

    def __init__(self, **kwargs):
        super(ValidateOperationRequest, self).__init__(**kwargs)
        self.object_type = None


class ValidateRestoreOperationRequest(ValidateOperationRequest):
    """AzureRestoreValidation request.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ValidateIaasVMRestoreOperationRequest

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param restore_request: Sets restore request to be validated
    :type restore_request:
     ~azure.mgmt.recoveryservicesbackup.models.RestoreRequest
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'restore_request': {'key': 'restoreRequest', 'type': 'RestoreRequest'},
    }

    _subtype_map = {
        'object_type': {'ValidateIaasVMRestoreOperationRequest': 'ValidateIaasVMRestoreOperationRequest'}
    }

    def __init__(self, **kwargs):
        super(ValidateRestoreOperationRequest, self).__init__(**kwargs)
        self.restore_request = kwargs.get('restore_request', None)
        self.object_type = 'ValidateRestoreOperationRequest'


class ValidateIaasVMRestoreOperationRequest(ValidateRestoreOperationRequest):
    """AzureRestoreValidation request.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param restore_request: Sets restore request to be validated
    :type restore_request:
     ~azure.mgmt.recoveryservicesbackup.models.RestoreRequest
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'restore_request': {'key': 'restoreRequest', 'type': 'RestoreRequest'},
    }

    def __init__(self, **kwargs):
        super(ValidateIaasVMRestoreOperationRequest, self).__init__(**kwargs)
        self.object_type = 'ValidateIaasVMRestoreOperationRequest'


class ValidateOperationResponse(Model):
    """Base class for validate operation response.

    :param validation_results: Gets the validation result
    :type validation_results:
     list[~azure.mgmt.recoveryservicesbackup.models.ErrorDetail]
    """

    _attribute_map = {
        'validation_results': {'key': 'validationResults', 'type': '[ErrorDetail]'},
    }

    def __init__(self, **kwargs):
        super(ValidateOperationResponse, self).__init__(**kwargs)
        self.validation_results = kwargs.get('validation_results', None)


class ValidateOperationsResponse(Model):
    """ValidateOperationsResponse.

    :param validate_operation_response:
    :type validate_operation_response:
     ~azure.mgmt.recoveryservicesbackup.models.ValidateOperationResponse
    """

    _attribute_map = {
        'validate_operation_response': {'key': 'validateOperationResponse', 'type': 'ValidateOperationResponse'},
    }

    def __init__(self, **kwargs):
        super(ValidateOperationsResponse, self).__init__(**kwargs)
        self.validate_operation_response = kwargs.get('validate_operation_response', None)


class WeeklyRetentionFormat(Model):
    """Weekly retention format.

    :param days_of_the_week: List of days of the week.
    :type days_of_the_week: list[str or
     ~azure.mgmt.recoveryservicesbackup.models.DayOfWeek]
    :param weeks_of_the_month: List of weeks of month.
    :type weeks_of_the_month: list[str or
     ~azure.mgmt.recoveryservicesbackup.models.WeekOfMonth]
    """

    _attribute_map = {
        'days_of_the_week': {'key': 'daysOfTheWeek', 'type': '[DayOfWeek]'},
        'weeks_of_the_month': {'key': 'weeksOfTheMonth', 'type': '[WeekOfMonth]'},
    }

    def __init__(self, **kwargs):
        super(WeeklyRetentionFormat, self).__init__(**kwargs)
        self.days_of_the_week = kwargs.get('days_of_the_week', None)
        self.weeks_of_the_month = kwargs.get('weeks_of_the_month', None)


class WeeklyRetentionSchedule(Model):
    """Weekly retention schedule.

    :param days_of_the_week: List of days of week for weekly retention policy.
    :type days_of_the_week: list[str or
     ~azure.mgmt.recoveryservicesbackup.models.DayOfWeek]
    :param retention_times: Retention times of retention policy.
    :type retention_times: list[datetime]
    :param retention_duration: Retention duration of retention Policy.
    :type retention_duration:
     ~azure.mgmt.recoveryservicesbackup.models.RetentionDuration
    """

    _attribute_map = {
        'days_of_the_week': {'key': 'daysOfTheWeek', 'type': '[DayOfWeek]'},
        'retention_times': {'key': 'retentionTimes', 'type': '[iso-8601]'},
        'retention_duration': {'key': 'retentionDuration', 'type': 'RetentionDuration'},
    }

    def __init__(self, **kwargs):
        super(WeeklyRetentionSchedule, self).__init__(**kwargs)
        self.days_of_the_week = kwargs.get('days_of_the_week', None)
        self.retention_times = kwargs.get('retention_times', None)
        self.retention_duration = kwargs.get('retention_duration', None)


class WorkloadInquiryDetails(Model):
    """Details of an inquired protectable item.

    :param type: Type of the Workload such as SQL, Oracle etc.
    :type type: str
    :param item_count: Contains the protectable item Count inside this
     Container.
    :type item_count: long
    :param inquiry_validation: Inquiry validation such as permissions and
     other backup validations.
    :type inquiry_validation:
     ~azure.mgmt.recoveryservicesbackup.models.InquiryValidation
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'item_count': {'key': 'itemCount', 'type': 'long'},
        'inquiry_validation': {'key': 'inquiryValidation', 'type': 'InquiryValidation'},
    }

    def __init__(self, **kwargs):
        super(WorkloadInquiryDetails, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.item_count = kwargs.get('item_count', None)
        self.inquiry_validation = kwargs.get('inquiry_validation', None)


class WorkloadItemResource(Resource):
    """Base class for backup item. Workload-specific backup items are derived from
    this class.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: WorkloadItemResource properties
    :type properties: ~azure.mgmt.recoveryservicesbackup.models.WorkloadItem
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'WorkloadItem'},
    }

    def __init__(self, **kwargs):
        super(WorkloadItemResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class WorkloadProtectableItemResource(Resource):
    """Base class for backup item. Workload-specific backup items are derived from
    this class.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param properties: WorkloadProtectableItemResource properties
    :type properties:
     ~azure.mgmt.recoveryservicesbackup.models.WorkloadProtectableItem
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'WorkloadProtectableItem'},
    }

    def __init__(self, **kwargs):
        super(WorkloadProtectableItemResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class YearlyRetentionSchedule(Model):
    """Yearly retention schedule.

    :param retention_schedule_format_type: Retention schedule format for
     yearly retention policy. Possible values include: 'Invalid', 'Daily',
     'Weekly'
    :type retention_schedule_format_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RetentionScheduleFormat
    :param months_of_year: List of months of year of yearly retention policy.
    :type months_of_year: list[str or
     ~azure.mgmt.recoveryservicesbackup.models.MonthOfYear]
    :param retention_schedule_daily: Daily retention format for yearly
     retention policy.
    :type retention_schedule_daily:
     ~azure.mgmt.recoveryservicesbackup.models.DailyRetentionFormat
    :param retention_schedule_weekly: Weekly retention format for yearly
     retention policy.
    :type retention_schedule_weekly:
     ~azure.mgmt.recoveryservicesbackup.models.WeeklyRetentionFormat
    :param retention_times: Retention times of retention policy.
    :type retention_times: list[datetime]
    :param retention_duration: Retention duration of retention Policy.
    :type retention_duration:
     ~azure.mgmt.recoveryservicesbackup.models.RetentionDuration
    """

    _attribute_map = {
        'retention_schedule_format_type': {'key': 'retentionScheduleFormatType', 'type': 'str'},
        'months_of_year': {'key': 'monthsOfYear', 'type': '[MonthOfYear]'},
        'retention_schedule_daily': {'key': 'retentionScheduleDaily', 'type': 'DailyRetentionFormat'},
        'retention_schedule_weekly': {'key': 'retentionScheduleWeekly', 'type': 'WeeklyRetentionFormat'},
        'retention_times': {'key': 'retentionTimes', 'type': '[iso-8601]'},
        'retention_duration': {'key': 'retentionDuration', 'type': 'RetentionDuration'},
    }

    def __init__(self, **kwargs):
        super(YearlyRetentionSchedule, self).__init__(**kwargs)
        self.retention_schedule_format_type = kwargs.get('retention_schedule_format_type', None)
        self.months_of_year = kwargs.get('months_of_year', None)
        self.retention_schedule_daily = kwargs.get('retention_schedule_daily', None)
        self.retention_schedule_weekly = kwargs.get('retention_schedule_weekly', None)
        self.retention_times = kwargs.get('retention_times', None)
        self.retention_duration = kwargs.get('retention_duration', None)
