from typing import Any, TypeVar, Set, Dict, List, TextIO, Union, Tuple, Generic, Callable, Generator, Iterable, Awaitable, overload

__all__ = ... # type: str

from .events import AbstractEventLoop
from .futures import Future

FIRST_EXCEPTION = 'FIRST_EXCEPTION'
FIRST_COMPLETED = 'FIRST_COMPLETED'
ALL_COMPLETED = 'ALL_COMPLETED'
_T = TypeVar('_T')
def sleep(delay: float, result: _T = ..., loop: AbstractEventLoop = ...) -> Future[_T]: ...
def wait(fs: List[Task[_T]], *, loop: AbstractEventLoop = ...,
    timeout: float = ..., return_when: str = ...) -> Future[Tuple[Set[Future[_T]], Set[Future[_T]]]]: ...
def wait_for(fut: Union[Future[_T], Generator[Any, None, _T]], timeout: float, *, loop: AbstractEventLoop = ...) -> Future[_T]: ...


class Task(Future[_T], Generic[_T]):
    _all_tasks = ...  # type: Set[Task]
    _current_tasks = ...  # type: Dict[AbstractEventLoop, Task]
    @classmethod
    def current_task(cls, loop: AbstractEventLoop = ...) -> Task: ...
    @classmethod
    def all_tasks(cls, loop: AbstractEventLoop = ...) -> Set[Task]: ...

    # Can't use a union, see mypy issue #1873.
    @overload
    def __init__(self, coro: Generator[Any, None, _T], *, loop: AbstractEventLoop = ...) -> None: ...
    @overload
    def __init__(self, coro: Awaitable[_T], *, loop: AbstractEventLoop = ...) -> None: ...

    def __repr__(self) -> str: ...
    def get_stack(self, *, limit: int = ...) -> List[Any]: ...  # return List[stackframe]
    def print_stack(self, *, limit: int = ..., file: TextIO = ...) -> None: ...
    def cancel(self) -> bool: ...
    def _step(self, value: Any = ..., exc: Exception = ...) -> None: ...
    def _wakeup(self, future: Future[Any]) -> None: ...

