from . import common

class PropertiesTestCase(common.JPypeTestCase):

    def setUp(self):
        super(PropertiesTestCase, self).setUp()
        self._bean = self.jpype.properties.TestBean()

    def testPropertyPublicMethodOverlap(self):
        self._bean.setProperty1("val")
        self.assertEqual("getsetval", self._bean.getProperty1())

    def testPublicMethodPropertyOverlap(self):
        self.assertEqual("method", self._bean.property1())

    def testPropertyProtectedMethodOverlapInvisibleAttribute(self):
        self._bean.property2 = "val"
        self.assertEqual("getsetval", self._bean.property2)

    def testProtectedMethodPropertyOverlapInvisibleAttribute(self):
        self.assertFalse(hasattr(self._bean.property2, '__call__'))

    def testPropertyProtectedMethodOverlapAttribute(self):
        self._bean.property3 = "val"
        self.assertEqual("getsetval", self._bean.property3)

    def testProtectedMethodPropertyOverlapAttribute(self):
        self.assertFalse(hasattr(self._bean.property3, '__call__'))

    def testPropertyProtectedMethodOverlapAttributeSet(self):
        self._bean.setProperty3("val")
        self.assertEqual("getsetval", self._bean.property3)

    def testPropertyProtectedMethodOverlapAttributeGet(self):
        self._bean.property3 = "val"
        self.assertEqual("getsetval", self._bean.getProperty3())

    def testPrivateAttributeNoThreeCharacterMethodMatchCollision(self):
        self._bean.property4 ="val"
        self.assertEqual("abcval", self._bean.abcProperty4())

    def testPropertyOnlySetter(self):
        self._bean.property5 = "val"
        self.assertEqual("returnsetval", self._bean.returnProperty5())

    def testPropertyOnlySetterSet(self):
        self._bean.setProperty5("val")
        # <AK> JPype error: attribute 'property5' is private so is not directly available
        #self.assertEqual("setval", self._bean.property5)               # <AK> commented
        self.assertEqual("returnsetval", self._bean.returnProperty5())  # <AK> added

    def testPropertyDifferentAttribute(self):
        self._bean.property6 = "val"
        self.assertEqual("getsetval", self._bean.property6)
        self.assertEqual("setval", self._bean.property7)

    def testProertyDifferentAttributeSet(self):
        self._bean.setProperty6("val")
        self.assertEqual("getsetval", self._bean.property6)
        self.assertEqual("setval", self._bean.property7)
