# Copyright 2020 StrongDM Inc
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#     http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# 
# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from . import policies_pb2 as policies__pb2


class PoliciesStub(object):
    """Policies are the collection of one or more statements that enforce fine-grained access
    control for the users of an organization.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.Create = channel.unary_unary(
                '/v1.Policies/Create',
                request_serializer=policies__pb2.PolicyCreateRequest.SerializeToString,
                response_deserializer=policies__pb2.PolicyCreateResponse.FromString,
                )
        self.Delete = channel.unary_unary(
                '/v1.Policies/Delete',
                request_serializer=policies__pb2.PolicyDeleteRequest.SerializeToString,
                response_deserializer=policies__pb2.PolicyDeleteResponse.FromString,
                )
        self.Update = channel.unary_unary(
                '/v1.Policies/Update',
                request_serializer=policies__pb2.PolicyUpdateRequest.SerializeToString,
                response_deserializer=policies__pb2.PolicyUpdateResponse.FromString,
                )
        self.Get = channel.unary_unary(
                '/v1.Policies/Get',
                request_serializer=policies__pb2.PolicyGetRequest.SerializeToString,
                response_deserializer=policies__pb2.PolicyGetResponse.FromString,
                )
        self.List = channel.unary_unary(
                '/v1.Policies/List',
                request_serializer=policies__pb2.PolicyListRequest.SerializeToString,
                response_deserializer=policies__pb2.PolicyListResponse.FromString,
                )


class PoliciesServicer(object):
    """Policies are the collection of one or more statements that enforce fine-grained access
    control for the users of an organization.
    """

    def Create(self, request, context):
        """Create creates a new Policy.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Delete(self, request, context):
        """Delete removes a Policy by ID.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Update(self, request, context):
        """Update replaces all the fields of a Policy by ID.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Get(self, request, context):
        """Get reads one Policy by ID.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def List(self, request, context):
        """List gets a list of Policy matching a given set of criteria
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_PoliciesServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'Create': grpc.unary_unary_rpc_method_handler(
                    servicer.Create,
                    request_deserializer=policies__pb2.PolicyCreateRequest.FromString,
                    response_serializer=policies__pb2.PolicyCreateResponse.SerializeToString,
            ),
            'Delete': grpc.unary_unary_rpc_method_handler(
                    servicer.Delete,
                    request_deserializer=policies__pb2.PolicyDeleteRequest.FromString,
                    response_serializer=policies__pb2.PolicyDeleteResponse.SerializeToString,
            ),
            'Update': grpc.unary_unary_rpc_method_handler(
                    servicer.Update,
                    request_deserializer=policies__pb2.PolicyUpdateRequest.FromString,
                    response_serializer=policies__pb2.PolicyUpdateResponse.SerializeToString,
            ),
            'Get': grpc.unary_unary_rpc_method_handler(
                    servicer.Get,
                    request_deserializer=policies__pb2.PolicyGetRequest.FromString,
                    response_serializer=policies__pb2.PolicyGetResponse.SerializeToString,
            ),
            'List': grpc.unary_unary_rpc_method_handler(
                    servicer.List,
                    request_deserializer=policies__pb2.PolicyListRequest.FromString,
                    response_serializer=policies__pb2.PolicyListResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'v1.Policies', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class Policies(object):
    """Policies are the collection of one or more statements that enforce fine-grained access
    control for the users of an organization.
    """

    @staticmethod
    def Create(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.Policies/Create',
            policies__pb2.PolicyCreateRequest.SerializeToString,
            policies__pb2.PolicyCreateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Delete(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.Policies/Delete',
            policies__pb2.PolicyDeleteRequest.SerializeToString,
            policies__pb2.PolicyDeleteResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Update(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.Policies/Update',
            policies__pb2.PolicyUpdateRequest.SerializeToString,
            policies__pb2.PolicyUpdateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Get(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.Policies/Get',
            policies__pb2.PolicyGetRequest.SerializeToString,
            policies__pb2.PolicyGetResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def List(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.Policies/List',
            policies__pb2.PolicyListRequest.SerializeToString,
            policies__pb2.PolicyListResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
