# Copyright 2020 StrongDM Inc
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#     http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# 
# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from . import secret_engines_pb2 as secret__engines__pb2
from . import secret_stores_pb2 as secret__stores__pb2


class SecretEnginesStub(object):
    """Missing associated documentation comment in .proto file."""

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.List = channel.unary_unary(
                '/v1.SecretEngines/List',
                request_serializer=secret__engines__pb2.SecretEngineListRequest.SerializeToString,
                response_deserializer=secret__engines__pb2.SecretEngineListResponse.FromString,
                )
        self.Get = channel.unary_unary(
                '/v1.SecretEngines/Get',
                request_serializer=secret__engines__pb2.SecretEngineGetRequest.SerializeToString,
                response_deserializer=secret__engines__pb2.SecretEngineGetResponse.FromString,
                )
        self.Create = channel.unary_unary(
                '/v1.SecretEngines/Create',
                request_serializer=secret__engines__pb2.SecretEngineCreateRequest.SerializeToString,
                response_deserializer=secret__engines__pb2.SecretEngineCreateResponse.FromString,
                )
        self.Update = channel.unary_unary(
                '/v1.SecretEngines/Update',
                request_serializer=secret__engines__pb2.SecretEngineUpdateRequest.SerializeToString,
                response_deserializer=secret__engines__pb2.SecretEngineUpdateResponse.FromString,
                )
        self.Delete = channel.unary_unary(
                '/v1.SecretEngines/Delete',
                request_serializer=secret__engines__pb2.SecretEngineDeleteRequest.SerializeToString,
                response_deserializer=secret__engines__pb2.SecretEngineDeleteResponse.FromString,
                )
        self.ListSecretStores = channel.unary_unary(
                '/v1.SecretEngines/ListSecretStores',
                request_serializer=secret__stores__pb2.SecretStoreListRequest.SerializeToString,
                response_deserializer=secret__stores__pb2.SecretStoreListResponse.FromString,
                )
        self.GenerateKeys = channel.unary_unary(
                '/v1.SecretEngines/GenerateKeys',
                request_serializer=secret__engines__pb2.GenerateKeysRequest.SerializeToString,
                response_deserializer=secret__engines__pb2.GenerateKeysResponse.FromString,
                )
        self.Healthcheck = channel.unary_unary(
                '/v1.SecretEngines/Healthcheck',
                request_serializer=secret__engines__pb2.HealthcheckRequest.SerializeToString,
                response_deserializer=secret__engines__pb2.HealthcheckResponse.FromString,
                )
        self.Rotate = channel.unary_unary(
                '/v1.SecretEngines/Rotate',
                request_serializer=secret__engines__pb2.SecretEngineRotateRequest.SerializeToString,
                response_deserializer=secret__engines__pb2.SecretEngineRotateResponse.FromString,
                )


class SecretEnginesServicer(object):
    """Missing associated documentation comment in .proto file."""

    def List(self, request, context):
        """List returns a list of Secret Engines
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Get(self, request, context):
        """Get returns a secret engine details
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Create(self, request, context):
        """Create creates a secret engine
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Update(self, request, context):
        """Update updates a secret engine
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Delete(self, request, context):
        """Delete deletes a secret engine
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListSecretStores(self, request, context):
        """ListSecretStores returns a list of Secret Stores that can be used as a backing store
        for Secret Engine
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GenerateKeys(self, request, context):
        """GenerateKeys generates a private key, stores it in a secret store and stores a public key in a secret engine
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Healthcheck(self, request, context):
        """Healthcheck triggers a healthcheck for all nodes serving a secret engine
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Rotate(self, request, context):
        """Rotate rotates secret engine's credentials
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_SecretEnginesServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'List': grpc.unary_unary_rpc_method_handler(
                    servicer.List,
                    request_deserializer=secret__engines__pb2.SecretEngineListRequest.FromString,
                    response_serializer=secret__engines__pb2.SecretEngineListResponse.SerializeToString,
            ),
            'Get': grpc.unary_unary_rpc_method_handler(
                    servicer.Get,
                    request_deserializer=secret__engines__pb2.SecretEngineGetRequest.FromString,
                    response_serializer=secret__engines__pb2.SecretEngineGetResponse.SerializeToString,
            ),
            'Create': grpc.unary_unary_rpc_method_handler(
                    servicer.Create,
                    request_deserializer=secret__engines__pb2.SecretEngineCreateRequest.FromString,
                    response_serializer=secret__engines__pb2.SecretEngineCreateResponse.SerializeToString,
            ),
            'Update': grpc.unary_unary_rpc_method_handler(
                    servicer.Update,
                    request_deserializer=secret__engines__pb2.SecretEngineUpdateRequest.FromString,
                    response_serializer=secret__engines__pb2.SecretEngineUpdateResponse.SerializeToString,
            ),
            'Delete': grpc.unary_unary_rpc_method_handler(
                    servicer.Delete,
                    request_deserializer=secret__engines__pb2.SecretEngineDeleteRequest.FromString,
                    response_serializer=secret__engines__pb2.SecretEngineDeleteResponse.SerializeToString,
            ),
            'ListSecretStores': grpc.unary_unary_rpc_method_handler(
                    servicer.ListSecretStores,
                    request_deserializer=secret__stores__pb2.SecretStoreListRequest.FromString,
                    response_serializer=secret__stores__pb2.SecretStoreListResponse.SerializeToString,
            ),
            'GenerateKeys': grpc.unary_unary_rpc_method_handler(
                    servicer.GenerateKeys,
                    request_deserializer=secret__engines__pb2.GenerateKeysRequest.FromString,
                    response_serializer=secret__engines__pb2.GenerateKeysResponse.SerializeToString,
            ),
            'Healthcheck': grpc.unary_unary_rpc_method_handler(
                    servicer.Healthcheck,
                    request_deserializer=secret__engines__pb2.HealthcheckRequest.FromString,
                    response_serializer=secret__engines__pb2.HealthcheckResponse.SerializeToString,
            ),
            'Rotate': grpc.unary_unary_rpc_method_handler(
                    servicer.Rotate,
                    request_deserializer=secret__engines__pb2.SecretEngineRotateRequest.FromString,
                    response_serializer=secret__engines__pb2.SecretEngineRotateResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'v1.SecretEngines', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class SecretEngines(object):
    """Missing associated documentation comment in .proto file."""

    @staticmethod
    def List(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.SecretEngines/List',
            secret__engines__pb2.SecretEngineListRequest.SerializeToString,
            secret__engines__pb2.SecretEngineListResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Get(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.SecretEngines/Get',
            secret__engines__pb2.SecretEngineGetRequest.SerializeToString,
            secret__engines__pb2.SecretEngineGetResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Create(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.SecretEngines/Create',
            secret__engines__pb2.SecretEngineCreateRequest.SerializeToString,
            secret__engines__pb2.SecretEngineCreateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Update(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.SecretEngines/Update',
            secret__engines__pb2.SecretEngineUpdateRequest.SerializeToString,
            secret__engines__pb2.SecretEngineUpdateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Delete(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.SecretEngines/Delete',
            secret__engines__pb2.SecretEngineDeleteRequest.SerializeToString,
            secret__engines__pb2.SecretEngineDeleteResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListSecretStores(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.SecretEngines/ListSecretStores',
            secret__stores__pb2.SecretStoreListRequest.SerializeToString,
            secret__stores__pb2.SecretStoreListResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GenerateKeys(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.SecretEngines/GenerateKeys',
            secret__engines__pb2.GenerateKeysRequest.SerializeToString,
            secret__engines__pb2.GenerateKeysResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Healthcheck(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.SecretEngines/Healthcheck',
            secret__engines__pb2.HealthcheckRequest.SerializeToString,
            secret__engines__pb2.HealthcheckResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Rotate(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.SecretEngines/Rotate',
            secret__engines__pb2.SecretEngineRotateRequest.SerializeToString,
            secret__engines__pb2.SecretEngineRotateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
