/**
*    The Nomensa accessible media player is a flexible multimedia solution for websites and intranets.  
*    The core player consists of JavaScript wrapper responsible for generating an accessible HTML toolbar 
*    for interacting with a media player of your choice. We currently provide support for YouTube (default),
*    Vimeo and JWPlayer although it should be possible to integrate the player with almost any media player on
*    the web (provided a JavaScript api for the player in question is available).
*    
*    Copyright (C) 2012  Nomensa Ltd
*
*    This program is free software: you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation, either version 3 of the License, or
*    (at your option) any later version.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program.  If not, see <http://www.gnu.org/licenses/>.
**/

// Main config for vimeo support in the media player
var vimeoconfig={init:function(player){var self=this;this.player=player;if(this.config.repeat){this.player.api_setLoop(true);}this.player.api_addEventListener('loadProgress','vimeo_player_loadProgress');this.player.api_addEventListener('play','vimeo_player_play');this.player.api_addEventListener('pause','vimeo_player_pause');},getFlashParams:function(){return{allowScriptAccess:"always",wmode:'transparent','flashvars':'api=1'};},getURL:function(){return this.config.url+this.config.media+'&player_id='+this.config.id;},play:function(){this.player.api_play();this.setSliderTimeout();if(this.config.captionsOn&&this.captions){this.setCaptionTimeout();}},pause:function(){this.player.api_pause();this.clearSliderTimeout();if(this.config.captionsOn&&this.captions){this.clearCaptionTimeout();}},mute:function(){var $button=this.$html.find('button.mute');if($button.hasClass('muted')){$button.removeClass('muted');this.player.api_setVolume(1);}else{$button.addClass('muted');this.player.api_setVolume(0);}},getDuration:function(){return this.player.api_getDuration();},getCurrentTime:function(){return this.player.api_getCurrentTime();},getBytesLoaded:function(){if(this.bytesLoaded){return this.bytesLoaded;}else{return 0;}},getBytesTotal:function(){if(this.bytesTotal){return this.bytesTotal;}else{return 0;}},seek:function(time){this.player.api_seekTo(time);if(this.config.captionsOn&&this.captions){this.$html.find('.caption').remove();this.clearCaptionTimeout();this.getPreviousCaption(time);this.setCaptionTimeout();}},volup:function(){var vol=parseInt((this.player.api_getVolume()*100),10);if(vol<(100-this.config.volume_step)){vol+=this.config.volume_step;}else{vol=100;}this.updateVolume(vol);vol=vol/100;this.player.api_setVolume(vol);},voldwn:function(){var vol=parseInt((this.player.api_getVolume()*100),10);if(vol>(this.config.volume_step)){vol-=this.config.volume_step;}else{vol=0;}this.updateVolume(vol);vol=vol/100;this.player.api_setVolume(vol);},cue:function(){return;}};
// Callback function for vimeo player loaded state
function vimeo_player_loaded(player_id){var player=PlayerDaemon.getPlayer(player_id);var myplayer=document.getElementById(player_id);player.init(myplayer);}
// Callback function for when the load progress of the player is updated
function vimeo_player_loadProgress(args,player_id){var player=PlayerDaemon.getPlayer(player_id);player.bytesLoaded=args.bytesLoaded;player.bytesTotal=args.bytesTotal;}
// Callback function for when the play button in the default (flash) interface is activated
function vimeo_player_play(player_id){var player=PlayerDaemon.getPlayer(player_id);player.setSliderTimeout();if(player.config.buttons.toggle){player.$html.find('.play').removeClass('play').addClass('pause').text('Pause');}if(player.config.captionsOn&&player.captions){player.setCaptionTimeout();}}
//Callback function for when the pause button in the default (flash) interface is activated
function vimeo_player_pause(player_id){var player=PlayerDaemon.getPlayer(player_id);player.clearSliderTimeout();if(player.config.buttons.toggle){player.$html.find('.pause').removeClass('pause').addClass('play').text('Play');}if(player.config.captionsOn&&player.captions){player.clearCaptionTimeout();}}