# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Schedule(Model):
    """
    The schedule according to which jobs will be created

    :param do_not_run_until: Gets or sets the earliest time at which any job
     may be created under this job schedule. If you do not specify a
     doNotRunUntil time, the schedule becomes ready to create jobs
     immediately.
    :type do_not_run_until: datetime
    :param do_not_run_after: Gets or sets a time after which no job will be
     created under this job schedule.  The schedule will move to the
     completed state as soon as this deadline is past and there is no active
     job under this job schedule.
    :type do_not_run_after: datetime
    :param start_window: Gets or sets the time interval, starting from the
     time at which the schedule indicates a job should be created, within
     which a job must be created.  If a job is not created within the
     startWindow interval, then the 'opportunity' is lost; no job will be
     created until the next recurrence of the schedule.
    :type start_window: timedelta
    :param recurrence_interval: Gets or sets the time interval between the
     start times of two successive jobs under the job schedule. A job
     schedule can have at most one active job under it at any given time.
    :type recurrence_interval: timedelta
    """ 

    _attribute_map = {
        'do_not_run_until': {'key': 'doNotRunUntil', 'type': 'iso-8601'},
        'do_not_run_after': {'key': 'doNotRunAfter', 'type': 'iso-8601'},
        'start_window': {'key': 'startWindow', 'type': 'duration'},
        'recurrence_interval': {'key': 'recurrenceInterval', 'type': 'duration'},
    }

    def __init__(self, do_not_run_until=None, do_not_run_after=None, start_window=None, recurrence_interval=None, **kwargs):
        self.do_not_run_until = do_not_run_until
        self.do_not_run_after = do_not_run_after
        self.start_window = start_window
        self.recurrence_interval = recurrence_interval
