# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class StartTaskInformation(Model):
    """
    Information about a start task running on a compute node.

    :param state: Gets or sets the state of the start task on the compute
     node. Possible values include: 'running', 'completed'
    :type state: str
    :param start_time: Gets or sets the time at which the start task started
     running.
    :type start_time: datetime
    :param end_time: Gets or sets the time at which the start task stopped
     running.
    :type end_time: datetime
    :param exit_code: Gets or sets the exit code of the start task.
    :type exit_code: int
    :param scheduling_error: Gets or sets any error encountered scheduling
     the start task.
    :type scheduling_error: :class:`TaskSchedulingError
     <azure.batch.models.TaskSchedulingError>`
    :param retry_count: Gets or sets the number of times the task has been
     retried by the Batch service.
    :type retry_count: int
    :param last_retry_time: Gets or sets the most recent time at which a
     retry of the task started running.
    :type last_retry_time: datetime
    """ 

    _validation = {
        'state': {'required': True},
        'start_time': {'required': True},
        'retry_count': {'required': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'StartTaskState'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'exit_code': {'key': 'exitCode', 'type': 'int'},
        'scheduling_error': {'key': 'schedulingError', 'type': 'TaskSchedulingError'},
        'retry_count': {'key': 'retryCount', 'type': 'int'},
        'last_retry_time': {'key': 'lastRetryTime', 'type': 'iso-8601'},
    }

    def __init__(self, state, start_time, retry_count, end_time=None, exit_code=None, scheduling_error=None, last_retry_time=None, **kwargs):
        self.state = state
        self.start_time = start_time
        self.end_time = end_time
        self.exit_code = exit_code
        self.scheduling_error = scheduling_error
        self.retry_count = retry_count
        self.last_retry_time = last_retry_time
