/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.task;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.scheduler.common.exception.ExecutableCreationException;
import org.ow2.proactive.scripting.InvalidScriptException;
import org.ow2.proactive.scripting.Script;
import org.ow2.proactive.scripting.SimpleScript;

@PublicAPI
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ForkEnvironment
implements Serializable {
    public static final String DOCKER_FORK_WINDOWS2LINUX = "pa.scheduler.task.docker.windows2linux";
    private String javaHome;
    private String workingDir;
    private Map<String, String> systemEnvironment;
    private List<String> jvmArguments;
    private List<String> additionalClasspath = new ArrayList<String>();
    private Script<?> script;
    private List<String> preJavaCommand;
    private boolean isDockerWindowsToLinux = false;
    private static final long serialVersionUID = 102L;

    public ForkEnvironment() {
        this.jvmArguments = new ArrayList<String>();
        this.systemEnvironment = new HashMap<String, String>();
        this.preJavaCommand = new ArrayList<String>();
    }

    public ForkEnvironment(ForkEnvironment forkEnvironment) throws ExecutableCreationException {
        this();
        if (forkEnvironment.javaHome != null) {
            this.javaHome = forkEnvironment.javaHome;
        }
        if (forkEnvironment.workingDir != null) {
            this.workingDir = forkEnvironment.workingDir;
        }
        if (forkEnvironment.systemEnvironment != null) {
            this.systemEnvironment.putAll(forkEnvironment.systemEnvironment);
        }
        if (forkEnvironment.jvmArguments != null) {
            for (String entry : forkEnvironment.jvmArguments) {
                this.addJVMArgument(entry);
            }
        }
        if (forkEnvironment.additionalClasspath != null) {
            for (String entry : forkEnvironment.additionalClasspath) {
                this.addAdditionalClasspath(entry);
            }
        }
        if (forkEnvironment.preJavaCommand != null) {
            this.setPreJavaCommand(forkEnvironment.preJavaCommand);
        }
        if (forkEnvironment.script != null) {
            try {
                this.script = new SimpleScript(forkEnvironment.script);
            }
            catch (InvalidScriptException e) {
                throw new ExecutableCreationException("Failed to copy ForkEnvironment script", e);
            }
        }
    }

    public ForkEnvironment(String workingDir) {
        this();
        this.workingDir = workingDir;
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public Map<String, String> getSystemEnvironment() {
        if (this.systemEnvironment == null) {
            return new HashMap<String, String>(0);
        }
        return new HashMap<String, String>(this.systemEnvironment);
    }

    public String getSystemEnvironmentVariable(String name) {
        if (this.systemEnvironment == null) {
            return null;
        }
        return this.systemEnvironment.get(name);
    }

    public String addSystemEnvironmentVariable(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        return this.systemEnvironment.put(name, value);
    }

    public List<String> getJVMArguments() {
        if (this.jvmArguments == null) {
            return new ArrayList<String>(0);
        }
        return new ArrayList<String>(this.jvmArguments);
    }

    public void addJVMArgument(String value) {
        Preconditions.checkNotNull((Object)value);
        this.jvmArguments.add(value);
    }

    public List<String> getAdditionalClasspath() {
        if (this.additionalClasspath == null) {
            return new ArrayList<String>(0);
        }
        return new ArrayList<String>(this.additionalClasspath);
    }

    public void addAdditionalClasspath(String ... values) {
        for (String value : values) {
            this.addAdditionalClasspath(value);
        }
    }

    public void addAdditionalClasspath(String value) {
        Preconditions.checkNotNull((Object)value);
        this.additionalClasspath.add(value);
    }

    public List<String> getPreJavaCommand() {
        return this.preJavaCommand;
    }

    public void setPreJavaCommand(List<String> preJavaCommand) {
        this.preJavaCommand = preJavaCommand;
    }

    public void addPreJavaCommand(String commandOrParameter) {
        this.preJavaCommand.add(commandOrParameter);
    }

    public Script<?> getEnvScript() {
        return this.script;
    }

    public void setEnvScript(Script<?> script) {
        this.script = script;
    }

    public boolean isDockerWindowsToLinux() {
        return this.isDockerWindowsToLinux;
    }

    public void setDockerWindowsToLinux(boolean dockerWindowsToLinux) {
        this.isDockerWindowsToLinux = dockerWindowsToLinux;
    }

    public static String convertToLinuxPath(String windowsPath) {
        if (windowsPath.matches("[a-zA-Z]:.*")) {
            return "/" + windowsPath.charAt(0) + windowsPath.substring(2).replace("\\", "/");
        }
        return windowsPath.replace("\\", "/");
    }

    public static String convertToLinuxPathInJVMArgument(String jvmArgument) {
        if (jvmArgument.startsWith("-D") && jvmArgument.contains("=")) {
            int equalSignPos = jvmArgument.indexOf("=");
            return jvmArgument.substring(0, equalSignPos + 1) + ForkEnvironment.convertToLinuxClassPath(jvmArgument.substring(equalSignPos + 1));
        }
        return jvmArgument;
    }

    public static String convertToLinuxClassPath(String windowsClassPath) {
        LinkedList<String> linuxClassPathEntries = new LinkedList<String>();
        for (String windowsPath : windowsClassPath.split(";")) {
            if (windowsPath.matches("[a-zA-Z]:.*")) {
                linuxClassPathEntries.add("/" + windowsPath.charAt(0) + windowsPath.substring(2).replace("\\", "/"));
                continue;
            }
            linuxClassPathEntries.add(windowsPath.replace("\\", "/"));
        }
        return linuxClassPathEntries.stream().collect(Collectors.joining(":"));
    }

    public String toString() {
        String nl = System.lineSeparator();
        return "ForkEnvironment {" + nl + "\tjavaHome = '" + this.javaHome + '\'' + nl + "\tisDockerWindowsToLinux = '" + this.isDockerWindowsToLinux + '\'' + nl + "\tworkingDir = '" + this.workingDir + '\'' + nl + "\tsystemEnvironment = " + this.systemEnvironment + nl + "\tjvmArguments = " + this.jvmArguments + nl + "\tadditionalClasspath = " + this.additionalClasspath + nl + "\tscript = " + (this.script != null ? this.script.display() : null) + nl + '}';
    }
}

