/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive_grid_cloud_portal.rm.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContexts;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.ow2.proactive_grid_cloud_portal.common.RMRestInterface;
import org.ow2.proactive_grid_cloud_portal.common.exceptionmapper.ExceptionToJson;

public class RMRestClient {
    private RMRestInterface rm;
    private String restEndpointURL;
    private ResteasyProviderFactory providerFactory;
    private static ClientHttpEngine httpEngine;
    private static SSLContext sslContext;

    public RMRestClient(String restEndpointURL, ClientHttpEngine httpEngine) {
        if (httpEngine == null) {
            this.setBlindTrustSSLContext();
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            CloseableHttpClient httpClient = HttpClientBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).build();
            httpEngine = new ApacheHttpClient4Engine((HttpClient)httpClient);
        }
        RMRestClient.httpEngine = httpEngine;
        this.restEndpointURL = restEndpointURL;
        this.providerFactory = ResteasyProviderFactory.getInstance();
        if (!this.providerFactory.isRegistered(JacksonContextResolver.class)) {
            this.providerFactory.registerProvider(JacksonContextResolver.class);
        }
        this.rm = RMRestClient.createRestProxy(this.providerFactory, restEndpointURL, httpEngine);
    }

    public RMRestInterface getRm() {
        return this.rm;
    }

    private void setBlindTrustSSLContext() {
        try {
            TrustStrategy acceptingTrustStrategy = (cert, authType) -> true;
            sslContext = SSLContexts.custom().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)acceptingTrustStrategy).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static RMRestInterface createRestProxy(ResteasyProviderFactory provider, String restEndpointURL, ClientHttpEngine httpEngine) {
        ResteasyClient client = RMRestClient.buildResteasyClient(provider);
        ResteasyWebTarget target = client.target(restEndpointURL);
        RMRestInterface rmRestInterface = (RMRestInterface)target.proxy(RMRestInterface.class);
        return RMRestClient.createExceptionProxy(rmRestInterface);
    }

    private static ResteasyClient buildResteasyClient(ResteasyProviderFactory provider) {
        return new ResteasyClientBuilder().providerFactory(provider).httpEngine(httpEngine).build();
    }

    private static RMRestInterface createExceptionProxy(RMRestInterface rmRestInterface) {
        return (RMRestInterface)Proxy.newProxyInstance(RMRestInterface.class.getClassLoader(), new Class[]{RMRestInterface.class}, (InvocationHandler)new RestClientExceptionHandler(rmRestInterface));
    }

    private static class RestClientExceptionHandler
    implements InvocationHandler {
        private final RMRestInterface rm;

        public RestClientExceptionHandler(RMRestInterface rm) {
            this.rm = rm;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke((Object)this.rm, args);
            }
            catch (InvocationTargetException targetException) {
                if (targetException.getTargetException() instanceof WebApplicationException) {
                    WebApplicationException clientException = (WebApplicationException)targetException.getTargetException();
                    try {
                        ExceptionToJson exceptionToJson = (ExceptionToJson)clientException.getResponse().readEntity(ExceptionToJson.class);
                    }
                    catch (ProcessingException couldNotReadJsonException) {
                        throw clientException;
                    }
                    catch (IllegalStateException couldNotReadJsonException) {
                        throw clientException;
                    }
                }
                throw new RuntimeException(targetException.getTargetException());
            }
        }
    }

    @Provider
    @Consumes(value={"application/json", "text/json"})
    @Produces(value={"application/json", "text/json"})
    public static class JacksonContextResolver
    implements ContextResolver<ObjectMapper> {
        public ObjectMapper getContext(Class<?> objectType) {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return objectMapper;
        }
    }
}

