/* jslint:disable */
﻿

/* timeline-view.js */
Exhibit.TimelineView=function(C,B){this._div=C;
this._uiContext=B;
this._settings={};
this._accessors={getEventLabel:function(F,E,D){D(E.getObject(F,"label"));
},getProxy:function(F,E,D){D(F);
},getColorKey:null,getIconKey:null};
this._selectListener=null;
this._largestSize=0;
var A=this;
this._listener={onItemsChanged:function(){A._reconstruct();
}};
B.getCollection().addListener(this._listener);
};
Exhibit.TimelineView._intervalChoices=["millisecond","second","minute","hour","day","week","month","year","decade","century","millennium"];
Exhibit.TimelineView._settingSpecs={"topBandHeight":{type:"int",defaultValue:75},"topBandUnit":{type:"enum",choices:Exhibit.TimelineView._intervalChoices},"topBandPixelsPerUnit":{type:"int",defaultValue:200},"bottomBandHeight":{type:"int",defaultValue:25},"bottomBandUnit":{type:"enum",choices:Exhibit.TimelineView._intervalChoices},"bottomBandPixelsPerUnit":{type:"int",defaultValue:200},"timelineHeight":{type:"int",defaultValue:400},"timelineConstructor":{type:"function",defaultValue:null},"colorCoder":{type:"text",defaultValue:null},"iconCoder":{type:"text",defaultValue:null},"selectCoordinator":{type:"text",defaultValue:null},"showHeader":{type:"boolean",defaultValue:true},"showSummary":{type:"boolean",defaultValue:true},"showFooter":{type:"boolean",defaultValue:true}};
Exhibit.TimelineView._accessorSpecs=[{accessorName:"getProxy",attributeName:"proxy"},{accessorName:"getDuration",bindings:[{attributeName:"start",type:"date",bindingName:"start"},{attributeName:"end",type:"date",bindingName:"end",optional:true}]},{accessorName:"getColorKey",attributeName:"marker",type:"text"},{accessorName:"getColorKey",attributeName:"colorKey",type:"text"},{accessorName:"getIconKey",attributeName:"iconKey",type:"text"},{accessorName:"getEventLabel",attributeName:"eventLabel",type:"text"},{accessorName:"getHoverText",attributeName:"hoverText",type:"text"}];
Exhibit.TimelineView.create=function(D,C,B){var A=new Exhibit.TimelineView(C,Exhibit.UIContext.create(D,B));
Exhibit.TimelineView._configure(A,D);
A._internalValidate();
A._initializeUI();
return A;
};
Exhibit.TimelineView.createFromDOM=function(D,C,B){var E=Exhibit.getConfigurationFromDOM(D);
var A=new Exhibit.TimelineView(C!=null?C:D,Exhibit.UIContext.createFromDOM(D,B));
Exhibit.SettingsUtilities.createAccessorsFromDOM(D,Exhibit.TimelineView._accessorSpecs,A._accessors);
Exhibit.SettingsUtilities.collectSettingsFromDOM(D,Exhibit.TimelineView._settingSpecs,A._settings);
Exhibit.TimelineView._configure(A,E);
A._internalValidate();
A._initializeUI();
return A;
};
Exhibit.TimelineView._configure=function(A,C){Exhibit.SettingsUtilities.createAccessors(C,Exhibit.TimelineView._accessorSpecs,A._accessors);
Exhibit.SettingsUtilities.collectSettings(C,Exhibit.TimelineView._settingSpecs,A._settings);
var B=A._accessors;
A._getDuration=function(F,E,D){B.getProxy(F,E,function(G){B.getDuration(G,E,D);
});
};
};
Exhibit.TimelineView.prototype.dispose=function(){this._uiContext.getCollection().removeListener(this._listener);
this._timeline=null;
if(this._selectListener!=null){this._selectListener.dispose();
this._selectListener=null;
}this._toolboxWidget.dispose();
this._toolboxWidget=null;
this._dom.dispose();
this._dom=null;
this._div.innerHTML="";
this._div=null;
this._uiContext.dispose();
this._uiContext=null;
};
Exhibit.TimelineView.prototype._internalValidate=function(){if("getColorKey" in this._accessors){if("colorCoder" in this._settings){this._colorCoder=this._uiContext.getExhibit().getComponent(this._settings.colorCoder);
}if(this._colorCoder==null){this._colorCoder=new Exhibit.DefaultColorCoder(this._uiContext);
}}if("getIconKey" in this._accessors){this._iconCoder=null;
if("iconCoder" in this._settings){this._iconCoder=this._uiContext.getExhibit().getComponent(this._settings.iconCoder);
}}if("selectCoordinator" in this._settings){var B=exhibit.getComponent(this._settings.selectCoordinator);
if(B!=null){var A=this;
this._selectListener=B.addListener(function(C){A._select(C);
});
}}};
Exhibit.TimelineView.prototype._initializeUI=function(){var A=this;
var B={};
B.colorGradient=(this._colorCoder!=null&&"_gradientPoints" in this._colorCoder);
B.iconMarkerGenerator=function(C){elmt=document.createElement("img");
elmt.src=C;
elmt.style.verticalAlign="middle";
return elmt;
};
this._div.innerHTML="";
this._dom=Exhibit.ViewUtilities.constructPlottingViewDom(this._div,this._uiContext,this._settings.showSummary&&this._settings.showHeader,{onResize:function(){A._timeline.layout();
}},B);
this._toolboxWidget=Exhibit.ToolboxWidget.createFromDOM(this._div,this._div,this._uiContext);
this._eventSource=new Timeline.DefaultEventSource();
this._reconstruct();
};
Exhibit.TimelineView.prototype._reconstructTimeline=function(A){var E=this._settings;
if(this._timeline!=null){this._timeline.dispose();
}if(A){this._eventSource.addMany(A);
}var N=this._dom.plotContainer;
if(E.timelineConstructor!=null){this._timeline=E.timelineConstructor(N,this._eventSource);
}else{N.style.height=E.timelineHeight+"px";
N.className="exhibit-timelineView-timeline";
var K=Timeline.ClassicTheme.create();
K.event.bubble.width=this._uiContext.getSetting("bubbleWidth");
K.event.bubble.height=this._uiContext.getSetting("bubbleHeight");
var G,M;
if(E.topBandUnit!=null||E.bottomBandUnit!=null){if(Exhibit.TimelineView._intervalLabelMap==null){Exhibit.TimelineView._intervalLabelMap={"millisecond":Timeline.DateTime.MILLISECOND,"second":Timeline.DateTime.SECOND,"minute":Timeline.DateTime.MINUTE,"hour":Timeline.DateTime.HOUR,"day":Timeline.DateTime.DAY,"week":Timeline.DateTime.WEEK,"month":Timeline.DateTime.MONTH,"year":Timeline.DateTime.YEAR,"decade":Timeline.DateTime.DECADE,"century":Timeline.DateTime.CENTURY,"millennium":Timeline.DateTime.MILLENNIUM};
}if(E.topBandUnit==null){M=Exhibit.TimelineView._intervalLabelMap[E.bottomBandUnit];
G=M-1;
}else{if(E.bottomBandUnit==null){G=Exhibit.TimelineView._intervalLabelMap[E.topBandUnit];
M=G+1;
}else{G=Exhibit.TimelineView._intervalLabelMap[E.topBandUnit];
M=Exhibit.TimelineView._intervalLabelMap[E.bottomBandUnit];
}}}else{var L=this._eventSource.getEarliestDate();
var H=this._eventSource.getLatestDate();
var O=H.getTime()-L.getTime();
var F=this._eventSource.getCount();
if(O>0&&F>1){var C=F/O;
var G=Timeline.DateTime.MILLENNIUM;
while(G>0){var I=Timeline.DateTime.gregorianUnitLengths[G];
var D=C*I/E.topBandPixelsPerUnit;
if(D<0.01){break;
}G--;
}}else{G=Timeline.DateTime.YEAR;
}M=G+1;
}var Q=[Timeline.createBandInfo({width:E.topBandHeight+"%",intervalUnit:G,intervalPixels:E.topBandPixelsPerUnit,eventSource:this._eventSource,theme:K}),Timeline.createBandInfo({width:E.bottomBandHeight+"%",intervalUnit:M,intervalPixels:E.bottomBandPixelsPerUnit,eventSource:this._eventSource,overview:true,theme:K})];
Q[1].syncWith=0;
Q[1].highlight=true;
this._timeline=Timeline.create(N,Q,Timeline.HORIZONTAL);
}var P=this;
var B=function(R){if(P._selectListener!=null){P._selectListener.fire({itemIDs:[R]});
}};
for(var J=0;
J<this._timeline.getBandCount();
J++){this._timeline.getBand(J).getEventPainter().addOnSelectListener(B);
}};
Exhibit.TimelineView.prototype._reconstruct=function(){var P=this;
var O=this._uiContext.getCollection();
var M=this._uiContext.getDatabase();
var Y=this._settings;
var Z=this._accessors;
var B=O.countRestrictedItems();
var Q=[];
this._dom.legendWidget.clear();
this._eventSource.clear();
if(B>0){var C=O.getRestrictedItems();
var E=(this._accessors.getColorKey!=null);
var D=(this._accessors.getIconKey!=null&&this._iconCoder!=null);
var K=(this._accessors.getHoverText!=null);
var H={mixed:false,missing:false,others:false,keys:new Exhibit.Set()};
var R={mixed:false,missing:false,others:false,keys:new Exhibit.Set()};
var A=[];
var S=function(i,h,d,f,g){var e;
Z.getEventLabel(i,M,function(j){e=j;
return true;
});
var c=new Timeline.DefaultEventSource.Event({id:i,eventID:i,start:h.start,end:h.end,instant:h.end==null,text:e,description:"",icon:f,color:d,textColor:d,hoverText:g});
c._itemID=i;
c.getProperty=function(j){return M.getObject(this._itemID,j);
};
c.fillInfoBubble=function(j,k,l){P._fillInfoBubble(this,j,k,l);
};
A.push(c);
};
C.visit(function(c){var d=[];
P._getDuration(c,M,function(i){if("start" in i){d.push(i);
}});
if(d.length>0){var f=null;
var k=null;
var e=null;
if(E){var l=new Exhibit.Set();
Z.getColorKey(c,M,function(i){l.add(i);
});
f=P._colorCoder.translateSet(l,H);
}var k=null;
if(D){var j=new Exhibit.Set();
Z.getIconKey(c,M,function(i){j.add(i);
});
k=P._iconCoder.translateSet(j,R);
}if(K){var g=new Exhibit.Set();
Z.getHoverText(c,M,function(i){g.add(i);
});
for(var h in g._hash){e=h;
}}for(var h=0;
h<d.length;
h++){S(c,d[h],f,k,e);
}}else{Q.push(c);
}});
if(E){var W=this._dom.legendWidget;
var V=this._colorCoder;
var L=H.keys.toArray().sort();
if(this._colorCoder._gradientPoints!=null){W.addGradient(this._colorCoder._gradientPoints);
}else{for(var U=0;
U<L.length;
U++){var b=L[U];
var T=V.translate(b);
W.addEntry(T,b);
}}if(H.others){W.addEntry(V.getOthersColor(),V.getOthersLabel());
}if(H.mixed){W.addEntry(V.getMixedColor(),V.getMixedLabel());
}if(H.missing){W.addEntry(V.getMissingColor(),V.getMissingLabel());
}}if(D){var W=this._dom.legendWidget;
var G=this._iconCoder;
var L=R.keys.toArray().sort();
if(Y.iconLegendLabel!=null){W.addLegendLabel(Y.iconLegendLabel,"icon");
}for(var U=0;
U<L.length;
U++){var b=L[U];
var X=G.translate(b);
W.addEntry(X,b,"icon");
}if(R.others){W.addEntry(G.getOthersIcon(),G.getOthersLabel(),"icon");
}if(R.mixed){W.addEntry(G.getMixedIcon(),G.getMixedLabel(),"icon");
}if(R.missing){W.addEntry(G.getMissingIcon(),G.getMissingLabel(),"icon");
}}var I=B-Q.length;
if(I>this._largestSize){this._largestSize=I;
this._reconstructTimeline(A);
}else{this._eventSource.addMany(A);
}var N=this._timeline.getBand(0);
var F=N.getCenterVisibleDate();
var J=this._eventSource.getEarliestDate();
var a=this._eventSource.getLatestDate();
if(J!=null&&F<J){N.scrollToCenter(J);
}else{if(a!=null&&F>a){N.scrollToCenter(a);
}}}this._dom.setUnplottableMessage(B,Q);
};
Exhibit.TimelineView.prototype._select=function(C){var D=C.itemIDs[0];
var F=this._timeline.getBandCount();
for(var B=0;
B<F;
B++){var E=this._timeline.getBand(B);
var A=E.getEventSource().getEvent(D);
if(A){E.showBubbleForEvent(D);
break;
}}};
Exhibit.TimelineView.prototype._fillInfoBubble=function(A,B,C,D){this._uiContext.getLensRegistry().createLens(A._itemID,B,this._uiContext);
};
