# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Error(_serialization.Model):
    """Azure App Configuration error object.

    :ivar type: The type of the error.
    :vartype type: str
    :ivar title: A brief summary of the error.
    :vartype title: str
    :ivar name: The name of the parameter that resulted in the error.
    :vartype name: str
    :ivar detail: A detailed description of the error.
    :vartype detail: str
    :ivar status: The HTTP status code that the error maps to.
    :vartype status: int
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "title": {"key": "title", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "detail": {"key": "detail", "type": "str"},
        "status": {"key": "status", "type": "int"},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        title: Optional[str] = None,
        name: Optional[str] = None,
        detail: Optional[str] = None,
        status: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of the error.
        :paramtype type: str
        :keyword title: A brief summary of the error.
        :paramtype title: str
        :keyword name: The name of the parameter that resulted in the error.
        :paramtype name: str
        :keyword detail: A detailed description of the error.
        :paramtype detail: str
        :keyword status: The HTTP status code that the error maps to.
        :paramtype status: int
        """
        super().__init__(**kwargs)
        self.type = type
        self.title = title
        self.name = name
        self.detail = detail
        self.status = status


class ErrorDetail(_serialization.Model):
    """The details of an error.

    All required parameters must be populated in order to send to Azure.

    :ivar code: One of a server-defined set of error codes. Required.
    :vartype code: str
    :ivar message: A human-readable representation of the error. Required.
    :vartype message: str
    :ivar details: An array of details about specific errors that led to this reported error.
    :vartype details: list[~azure.appconfiguration.models.ErrorDetail]
    :ivar innererror: An object containing more specific information than the current object about
     the error.
    :vartype innererror: ~azure.appconfiguration.models.InnerError
    """

    _validation = {
        "code": {"required": True},
        "message": {"required": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "innererror": {"key": "innererror", "type": "InnerError"},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        details: Optional[List["_models.ErrorDetail"]] = None,
        innererror: Optional["_models.InnerError"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: One of a server-defined set of error codes. Required.
        :paramtype code: str
        :keyword message: A human-readable representation of the error. Required.
        :paramtype message: str
        :keyword details: An array of details about specific errors that led to this reported error.
        :paramtype details: list[~azure.appconfiguration.models.ErrorDetail]
        :keyword innererror: An object containing more specific information than the current object
         about the error.
        :paramtype innererror: ~azure.appconfiguration.models.InnerError
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = details
        self.innererror = innererror


class InnerError(_serialization.Model):
    """An object containing specific information about an error.

    :ivar code: One of a server-defined set of error codes.
    :vartype code: str
    :ivar innererror: An object containing more specific information than the current object about
     the error.
    :vartype innererror: ~azure.appconfiguration.models.InnerError
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "innererror": {"key": "innererror", "type": "InnerError"},
    }

    def __init__(
        self, *, code: Optional[str] = None, innererror: Optional["_models.InnerError"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword code: One of a server-defined set of error codes.
        :paramtype code: str
        :keyword innererror: An object containing more specific information than the current object
         about the error.
        :paramtype innererror: ~azure.appconfiguration.models.InnerError
        """
        super().__init__(**kwargs)
        self.code = code
        self.innererror = innererror


class Key(_serialization.Model):
    """Key.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the key.
    :vartype name: str
    """

    _validation = {
        "name": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None


class KeyListResult(_serialization.Model):
    """The result of a list request.

    :ivar items: The collection value.
    :vartype items: list[~azure.appconfiguration.models.Key]
    :ivar next_link: The URI that can be used to request the next set of paged results.
    :vartype next_link: str
    """

    _attribute_map = {
        "items": {"key": "items", "type": "[Key]"},
        "next_link": {"key": "@nextLink", "type": "str"},
    }

    def __init__(
        self, *, items: Optional[List["_models.Key"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword items: The collection value.
        :paramtype items: list[~azure.appconfiguration.models.Key]
        :keyword next_link: The URI that can be used to request the next set of paged results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.items = items
        self.next_link = next_link


class KeyValue(_serialization.Model):
    """KeyValue.

    :ivar key: The key of the key-value.
    :vartype key: str
    :ivar label: The label the key-value belongs to.
    :vartype label: str
    :ivar content_type: The content type of the value stored within the key-value.
    :vartype content_type: str
    :ivar value: The value of the key-value.
    :vartype value: str
    :ivar last_modified: A date representing the last time the key-value was modified.
    :vartype last_modified: ~datetime.datetime
    :ivar tags: The tags of the key-value.
    :vartype tags: dict[str, str]
    :ivar locked: Indicates whether the key-value is locked.
    :vartype locked: bool
    :ivar etag: A value representing the current state of the resource.
    :vartype etag: str
    """

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "content_type": {"key": "content_type", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "last_modified": {"key": "last_modified", "type": "iso-8601"},
        "tags": {"key": "tags", "type": "{str}"},
        "locked": {"key": "locked", "type": "bool"},
        "etag": {"key": "etag", "type": "str"},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        label: Optional[str] = None,
        content_type: Optional[str] = None,
        value: Optional[str] = None,
        last_modified: Optional[datetime.datetime] = None,
        tags: Optional[Dict[str, str]] = None,
        locked: Optional[bool] = None,
        etag: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key: The key of the key-value.
        :paramtype key: str
        :keyword label: The label the key-value belongs to.
        :paramtype label: str
        :keyword content_type: The content type of the value stored within the key-value.
        :paramtype content_type: str
        :keyword value: The value of the key-value.
        :paramtype value: str
        :keyword last_modified: A date representing the last time the key-value was modified.
        :paramtype last_modified: ~datetime.datetime
        :keyword tags: The tags of the key-value.
        :paramtype tags: dict[str, str]
        :keyword locked: Indicates whether the key-value is locked.
        :paramtype locked: bool
        :keyword etag: A value representing the current state of the resource.
        :paramtype etag: str
        """
        super().__init__(**kwargs)
        self.key = key
        self.label = label
        self.content_type = content_type
        self.value = value
        self.last_modified = last_modified
        self.tags = tags
        self.locked = locked
        self.etag = etag


class KeyValueFilter(_serialization.Model):
    """Enables filtering of key-values.

    All required parameters must be populated in order to send to Azure.

    :ivar key: Filters key-values by their key field. Required.
    :vartype key: str
    :ivar label: Filters key-values by their label field.
    :vartype label: str
    """

    _validation = {
        "key": {"required": True},
    }

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "label": {"key": "label", "type": "str"},
    }

    def __init__(self, *, key: str, label: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key: Filters key-values by their key field. Required.
        :paramtype key: str
        :keyword label: Filters key-values by their label field.
        :paramtype label: str
        """
        super().__init__(**kwargs)
        self.key = key
        self.label = label


class KeyValueListResult(_serialization.Model):
    """The result of a list request.

    :ivar items: The collection value.
    :vartype items: list[~azure.appconfiguration.models.KeyValue]
    :ivar next_link: The URI that can be used to request the next set of paged results.
    :vartype next_link: str
    """

    _attribute_map = {
        "items": {"key": "items", "type": "[KeyValue]"},
        "next_link": {"key": "@nextLink", "type": "str"},
    }

    def __init__(
        self, *, items: Optional[List["_models.KeyValue"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword items: The collection value.
        :paramtype items: list[~azure.appconfiguration.models.KeyValue]
        :keyword next_link: The URI that can be used to request the next set of paged results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.items = items
        self.next_link = next_link


class Label(_serialization.Model):
    """Label.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the label.
    :vartype name: str
    """

    _validation = {
        "name": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None


class LabelListResult(_serialization.Model):
    """The result of a list request.

    :ivar items: The collection value.
    :vartype items: list[~azure.appconfiguration.models.Label]
    :ivar next_link: The URI that can be used to request the next set of paged results.
    :vartype next_link: str
    """

    _attribute_map = {
        "items": {"key": "items", "type": "[Label]"},
        "next_link": {"key": "@nextLink", "type": "str"},
    }

    def __init__(
        self, *, items: Optional[List["_models.Label"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword items: The collection value.
        :paramtype items: list[~azure.appconfiguration.models.Label]
        :keyword next_link: The URI that can be used to request the next set of paged results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.items = items
        self.next_link = next_link


class OperationDetails(_serialization.Model):
    """Details of a long running operation.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The unique id of the operation. Required.
    :vartype id: str
    :ivar status: The current status of the operation. Required. Known values are: "NotStarted",
     "Running", "Succeeded", "Failed", and "Canceled".
    :vartype status: str or ~azure.appconfiguration.models.State
    :ivar error: An error, available when the status is ``Failed``\ , describing why the operation
     failed.
    :vartype error: ~azure.appconfiguration.models.ErrorDetail
    """

    _validation = {
        "id": {"required": True},
        "status": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        status: Union[str, "_models.State"],
        error: Optional["_models.ErrorDetail"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The unique id of the operation. Required.
        :paramtype id: str
        :keyword status: The current status of the operation. Required. Known values are: "NotStarted",
         "Running", "Succeeded", "Failed", and "Canceled".
        :paramtype status: str or ~azure.appconfiguration.models.State
        :keyword error: An error, available when the status is ``Failed``\ , describing why the
         operation failed.
        :paramtype error: ~azure.appconfiguration.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.id = id
        self.status = status
        self.error = error


class Snapshot(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Snapshot.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the snapshot.
    :vartype name: str
    :ivar status: The current status of the snapshot. Known values are: "provisioning", "ready",
     "archived", and "failed".
    :vartype status: str or ~azure.appconfiguration.models.SnapshotStatus
    :ivar filters: A list of filters used to filter the key-values included in the snapshot.
     Required.
    :vartype filters: list[~azure.appconfiguration.models.KeyValueFilter]
    :ivar composition_type: The composition type describes how the key-values within the snapshot
     are composed. The 'key' composition type ensures there are no two key-values containing the
     same key. The 'key_label' composition type ensures there are no two key-values containing the
     same key and label. Known values are: "key" and "key_label".
    :vartype composition_type: str or ~azure.appconfiguration.models.CompositionType
    :ivar created: The time that the snapshot was created.
    :vartype created: ~datetime.datetime
    :ivar expires: The time that the snapshot will expire.
    :vartype expires: ~datetime.datetime
    :ivar retention_period: The amount of time, in seconds, that a snapshot will remain in the
     archived state before expiring. This property is only writable during the creation of a
     snapshot. If not specified, the default lifetime of key-value revisions will be used.
    :vartype retention_period: int
    :ivar size: The size in bytes of the snapshot.
    :vartype size: int
    :ivar items_count: The amount of key-values in the snapshot.
    :vartype items_count: int
    :ivar tags: The tags of the snapshot.
    :vartype tags: dict[str, str]
    :ivar etag: A value representing the current state of the snapshot.
    :vartype etag: str
    """

    _validation = {
        "name": {"readonly": True},
        "status": {"readonly": True},
        "filters": {"required": True, "max_items": 3, "min_items": 1},
        "created": {"readonly": True},
        "expires": {"readonly": True},
        "retention_period": {"maximum": 7776000, "minimum": 3600},
        "size": {"readonly": True},
        "items_count": {"readonly": True},
        "etag": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "filters": {"key": "filters", "type": "[KeyValueFilter]"},
        "composition_type": {"key": "composition_type", "type": "str"},
        "created": {"key": "created", "type": "iso-8601"},
        "expires": {"key": "expires", "type": "iso-8601"},
        "retention_period": {"key": "retention_period", "type": "int"},
        "size": {"key": "size", "type": "int"},
        "items_count": {"key": "items_count", "type": "int"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
    }

    def __init__(
        self,
        *,
        filters: List["_models.KeyValueFilter"],
        composition_type: Optional[Union[str, "_models.CompositionType"]] = None,
        retention_period: Optional[int] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword filters: A list of filters used to filter the key-values included in the snapshot.
         Required.
        :paramtype filters: list[~azure.appconfiguration.models.KeyValueFilter]
        :keyword composition_type: The composition type describes how the key-values within the
         snapshot are composed. The 'key' composition type ensures there are no two key-values
         containing the same key. The 'key_label' composition type ensures there are no two key-values
         containing the same key and label. Known values are: "key" and "key_label".
        :paramtype composition_type: str or ~azure.appconfiguration.models.CompositionType
        :keyword retention_period: The amount of time, in seconds, that a snapshot will remain in the
         archived state before expiring. This property is only writable during the creation of a
         snapshot. If not specified, the default lifetime of key-value revisions will be used.
        :paramtype retention_period: int
        :keyword tags: The tags of the snapshot.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.name = None
        self.status = None
        self.filters = filters
        self.composition_type = composition_type
        self.created = None
        self.expires = None
        self.retention_period = retention_period
        self.size = None
        self.items_count = None
        self.tags = tags
        self.etag = None


class SnapshotListResult(_serialization.Model):
    """The result of a snapshot list request.

    :ivar items: The collection value.
    :vartype items: list[~azure.appconfiguration.models.Snapshot]
    :ivar next_link: The URI that can be used to request the next set of paged results.
    :vartype next_link: str
    """

    _attribute_map = {
        "items": {"key": "items", "type": "[Snapshot]"},
        "next_link": {"key": "@nextLink", "type": "str"},
    }

    def __init__(
        self, *, items: Optional[List["_models.Snapshot"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword items: The collection value.
        :paramtype items: list[~azure.appconfiguration.models.Snapshot]
        :keyword next_link: The URI that can be used to request the next set of paged results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.items = items
        self.next_link = next_link


class SnapshotUpdateParameters(_serialization.Model):
    """Parameters used to update a snapshot.

    :ivar status: The desired status of the snapshot. Known values are: "provisioning", "ready",
     "archived", and "failed".
    :vartype status: str or ~azure.appconfiguration.models.SnapshotStatus
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, *, status: Optional[Union[str, "_models.SnapshotStatus"]] = None, **kwargs: Any) -> None:
        """
        :keyword status: The desired status of the snapshot. Known values are: "provisioning", "ready",
         "archived", and "failed".
        :paramtype status: str or ~azure.appconfiguration.models.SnapshotStatus
        """
        super().__init__(**kwargs)
        self.status = status
