import numpy as np
from numpy.testing import assert_almost_equal
#import statsmodels.api as sm
from statsmodels.nonparametric.lowess import lowess


class  TestLowess(object):
     
    def test_simple(self):
        
        x = np.arange(20, dtype='float32')
        #standard normal noise
        noise = np.array([-0.76741118, -0.30754369,  
                            0.39950921, -0.46352422, -1.67081778,
                            0.6595567 ,  0.66367639, -2.04388585,  
                            0.8123281 ,  1.45977518,
                            1.21428038,  1.29296866,  0.78028477, 
                            -0.2402853 , -0.21721302,
                            0.24549405,  0.25987014, -0.90709034, 
                            -1.45688216, -0.31780505])        
        y = x + noise
        
        expected_lowess = np.array([[  0.        ,  -0.58337912],
                                   [  1.        ,   0.61951246],
                                   [  2.        ,   1.82221628],
                                   [  3.        ,   3.02536876],
                                   [  4.        ,   4.22667951],
                                   [  5.        ,   5.42387723],
                                   [  6.        ,   6.60834945],
                                   [  7.        ,   7.7797691 ],
                                   [  8.        ,   8.91824348],
                                   [  9.        ,   9.94997506],
                                   [ 10.        ,  10.89697569],
                                   [ 11.        ,  11.78746276],
                                   [ 12.        ,  12.62356492],
                                   [ 13.        ,  13.41538492],
                                   [ 14.        ,  14.15745254],
                                   [ 15.        ,  14.92343948],
                                   [ 16.        ,  15.70019862],
                                   [ 17.        ,  16.48167846],
                                   [ 18.        ,  17.26380699],
                                   [ 19.        ,  18.0466769 ]])

        actual_lowess = lowess(y,x)

        assert_almost_equal(expected_lowess, actual_lowess)

    def test_iter(self):

        x = np.arange(20, dtype='float32')
        #cauchy noise
        noise = np.array([ 1.86299605, -0.10816866,  1.87761229, 
                        -3.63442237,  0.30249022,
                        1.03560416,  0.21163349,  1.14167809, 
                        -0.00368175, -2.08808987,
                        0.13065417, -1.8052207 ,  0.60404596, 
                        -2.30908204,  1.7081412 ,
                        -0.54633243, -0.93107948,  1.79023999,  
                        1.05822445, -1.04530564])
        
        y = x + noise

        expected_lowess_no_iter = np.array([[  0.        ,   0.62644797],
                                           [  1.        ,   1.5008396 ],
                                           [  2.        ,   2.38617613],
                                           [  3.        ,   3.27163904],
                                           [  4.        ,   4.13972663],
                                           [  5.        ,   4.99266138],
                                           [  6.        ,   5.90622252],
                                           [  7.        ,   6.85414657],
                                           [  8.        ,   7.81633577],
                                           [  9.        ,   8.6684662 ],
                                           [ 10.        ,   9.53212147],
                                           [ 11.        ,  10.46553757],
                                           [ 12.        ,  11.46969179],
                                           [ 13.        ,  12.6126706 ],
                                           [ 14.        ,  13.80804573],
                                           [ 15.        ,  14.93552186],
                                           [ 16.        ,  16.04911835],
                                           [ 17.        ,  17.16049993],
                                           [ 18.        ,  18.27391721],
                                           [ 19.        ,  19.38342689]])


        expected_lowess_3_iter = np.array([[  0.        ,   1.3607733 ],
                                           [  1.        ,   2.2062049 ],
                                           [  2.        ,   3.04629498],
                                           [  3.        ,   3.88158084],
                                           [  4.        ,   4.71163579],
                                           [  5.        ,   5.54050304],
                                           [  6.        ,   6.38645423],
                                           [  7.        ,   7.14643561],
                                           [  8.        ,   7.94245588],
                                           [  9.        ,   8.75675711],
                                           [ 10.        ,   9.62619136],
                                           [ 11.        ,  10.55389747],
                                           [ 12.        ,  11.52718043],
                                           [ 13.        ,  12.62840261],
                                           [ 14.        ,  13.80423591],
                                           [ 15.        ,  14.91812397],
                                           [ 16.        ,  16.01752637],
                                           [ 17.        ,  17.11513329],
                                           [ 18.        ,  18.21651218],
                                           [ 19.        ,  19.31714769]])
                                            
        
        actual_lowess_no_iter = lowess(y,x,it=0)
        actual_lowess_3_iter = lowess(y,x,it=3)

        assert_almost_equal(expected_lowess_no_iter, actual_lowess_no_iter)
        assert_almost_equal(expected_lowess_3_iter, actual_lowess_3_iter)

    def test_frac(self):
        
        #linspace from -2*pi to 2*pi with 30 points
        x = np.array([-6.28318531, -5.84986218, 
                        -5.41653906, -4.98321593, -4.54989281,
                        -4.11656968, -3.68324656, -3.24992343, 
                        -2.81660031, -2.38327719,
                        -1.94995406, -1.51663094, -1.08330781, 
                        -0.64998469, -0.21666156,
                        0.21666156,  0.64998469,  1.08330781,  
                        1.51663094,  1.94995406,
                        2.38327719,  2.81660031,  3.24992343,  
                        3.68324656,  4.11656968,
                        4.54989281,  4.98321593,  5.41653906,  
                        5.84986218,  6.28318531],
                        dtype='float32')
        
        #normal noise
        noise = np.array([ 1.62379338, -1.11849371,  1.60085673,  
                            0.41996348,  0.70896754,
                            0.19271408,  0.04972776, -0.22411356,  
                            0.18154882, -0.63651971,
                            0.64942414, -2.26509826,  0.80018964,  
                            0.89826857, -0.09136105,
                            0.80482898,  1.54504686, -1.23734643, 
                            -1.16572754,  0.28027691,
                            -0.85191583,  0.20417445,  0.61034806, 
                            0.68297375,  1.45707167,
                            0.45157072, -1.13669622, -0.08552254, 
                            -0.28368514, -0.17326155])
        
        y = np.sin(x) + noise

        expected_lowess_23 = np.array([[ -6.28318548e+00,   1.85879646e+00],
                                       [ -5.84986210e+00,   1.66545513e+00],
                                       [ -5.41653919e+00,   1.47654627e+00],
                                       [ -4.98321581e+00,   1.29359535e+00],
                                       [ -4.54989290e+00,   1.11753312e+00],
                                       [ -4.11656952e+00,   9.48760031e-01],
                                       [ -3.68324661e+00,   7.86602333e-01],
                                       [ -3.24992347e+00,   6.29003517e-01],
                                       [ -2.81660032e+00,   4.72212611e-01],
                                       [ -2.38327718e+00,   3.12269779e-01],
                                       [ -1.94995403e+00,   2.10972652e-01],
                                       [ -1.51663089e+00,   1.30637140e-01],
                                       [ -1.08330786e+00,   7.40090948e-02],
                                       [ -6.49984717e-01,   4.52736083e-02],
                                       [ -2.16661558e-01,   4.75763268e-02],
                                       [  2.16661558e-01,   7.63986832e-02],
                                       [  6.49984717e-01,   1.19888748e-01],
                                       [  1.08330786e+00,   1.58644711e-01],
                                       [  1.51663089e+00,   1.79693123e-01],
                                       [  1.94995403e+00,   1.74680415e-01],
                                       [  2.38327718e+00,   1.44171836e-01],
                                       [  2.81660032e+00,   7.04760114e-02],
                                       [  3.24992347e+00,   2.44342733e-03],
                                       [  3.68324661e+00,  -6.24431808e-02],
                                       [  4.11656952e+00,  -1.27504921e-01],
                                       [  4.54989290e+00,  -1.94864501e-01],
                                       [  4.98321581e+00,  -2.66005721e-01],
                                       [  5.41653919e+00,  -3.41494321e-01],
                                       [  5.84986210e+00,  -4.21172959e-01],
                                       [  6.28318548e+00,  -5.04237292e-01]])
                                        
        expected_lowess_15 = np.array([[ -6.28318548e+00,   1.65774825e+00],
                                       [ -5.84986210e+00,   1.63964795e+00],
                                       [ -5.41653919e+00,   1.62809791e+00],
                                       [ -4.98321581e+00,   1.64839187e+00],
                                       [ -4.54989290e+00,   1.35052489e+00],
                                       [ -4.11656952e+00,   9.93959944e-01],
                                       [ -3.68324661e+00,   5.46400659e-01],
                                       [ -3.24992347e+00,   1.04275107e-01],
                                       [ -2.81660032e+00,  -1.38801715e-01],
                                       [ -2.38327718e+00,  -2.50771029e-01],
                                       [ -1.94995403e+00,  -2.46649407e-01],
                                       [ -1.51663089e+00,  -1.70098614e-01],
                                       [ -1.08330786e+00,   5.71349520e-03],
                                       [ -6.49984717e-01,   2.22985781e-01],
                                       [ -2.16661558e-01,   5.64203458e-01],
                                       [  2.16661558e-01,   4.33321361e-01],
                                       [  6.49984717e-01,   3.52990770e-01],
                                       [  1.08330786e+00,   2.24004384e-02],
                                       [  1.51663089e+00,  -2.14066736e-01],
                                       [  1.94995403e+00,  -6.12592369e-02],
                                       [  2.38327718e+00,   1.28970397e-01],
                                       [  2.81660032e+00,   2.87401733e-01],
                                       [  3.24992347e+00,   3.64551907e-01],
                                       [  3.68324661e+00,   2.11244778e-01],
                                       [  4.11656952e+00,  -9.71116261e-02],
                                       [  4.54989290e+00,  -3.64730683e-01],
                                       [  4.98321581e+00,  -6.05243177e-01],
                                       [  5.41653919e+00,  -6.91780300e-01],
                                       [  5.84986210e+00,  -5.42520396e-01],
                                       [  6.28318548e+00,  -3.23807686e-01]])

        actual_lowess_23 = lowess(y,x,frac=2./3)
        actual_lowess_15 = lowess(y,x,frac=1./5)

        assert_almost_equal(expected_lowess_23, actual_lowess_23)
        assert_almost_equal(expected_lowess_15, actual_lowess_15)


if __name__ == "__main__":
    import nose
    nose.runmodule(argv=[__file__, '-vvs', '-x', '--pdb'], exit=False)

