/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.authentication.crypto;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.proactive.annotation.PublicAPI;

@PublicAPI
public class CredData
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SSH_PRIVATE_KEY = "SSH_PRIVATE_KEY";
    private String login = null;
    private String pass = null;
    private String domain = null;
    private byte[] key = null;
    private Map<String, String> thirdPartyCredentials = new HashMap<String, String>();

    public static String parseDomain(String fullLogin) {
        if (fullLogin.contains("\\")) {
            String domain = fullLogin.substring(0, fullLogin.indexOf("\\"));
            return "".equals(domain.trim()) ? null : domain;
        }
        return null;
    }

    public static String parseLogin(String fullLogin) {
        if (fullLogin.contains("\\")) {
            return fullLogin.substring(fullLogin.indexOf("\\") + 1, fullLogin.length());
        }
        return fullLogin;
    }

    public CredData() {
    }

    public CredData(String login, String pass) {
        this.login = login;
        this.pass = pass;
    }

    public CredData(String login, String password, Map<String, String> thirdPartyCredentials) {
        this(login, password);
        this.thirdPartyCredentials = thirdPartyCredentials;
    }

    public CredData(String login, String domain, String pass) {
        this.login = login;
        this.pass = pass;
        this.domain = domain;
    }

    public CredData(String login, String pass, byte[] key) {
        this.login = login;
        this.pass = pass;
        this.key = key;
    }

    public CredData(String login, String domain, String pass, byte[] key) {
        this.login = login;
        this.pass = pass;
        this.key = key;
        this.domain = domain;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.pass;
    }

    public void setPassword(String pass) {
        this.pass = pass;
    }

    public byte[] getKey() {
        if (this.key == null && this.thirdPartyCredentials != null && this.thirdPartyCredentials.containsKey(SSH_PRIVATE_KEY)) {
            return this.thirdPartyCredentials.get(SSH_PRIVATE_KEY).getBytes();
        }
        return this.key;
    }

    public void setKey(byte[] key) {
        this.key = key;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String[] getLoginPassword() {
        return new String[]{this.login, this.pass};
    }

    public Map<String, String> getThirdPartyCredentials() {
        return this.thirdPartyCredentials;
    }

    public void addThirdPartyCredential(String key, String decryptedValue) {
        this.thirdPartyCredentials.put(key, decryptedValue);
    }
}

