/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.objectweb.proactive.annotation.PublicAPI;

@PublicAPI
public class FileToBytesConverter {
    public static byte[] convertFileToByteArray(File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            long length = file.length();
            if (length > 0L) {
                byte[] byArray = FileToBytesConverter.fastConversion(fis, length);
                return byArray;
            }
            byte[] byArray = FileToBytesConverter.slowConversion(fis);
            return byArray;
        }
    }

    private static byte[] fastConversion(FileInputStream fis, long length) throws IOException {
        int r;
        if (length > Integer.MAX_VALUE) {
            throw new IOException("File too large to fit in a byte array");
        }
        byte[] buf = new byte[(int)length];
        for (int offset = 0; offset < buf.length; offset += r) {
            r = fis.read(buf, offset, buf.length - offset);
            if (r >= 0) {
                continue;
            }
            throw new IOException("EOF encountered but fewer bits than expected has been read");
        }
        return buf;
    }

    private static byte[] slowConversion(FileInputStream fis) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        long count = 0L;
        int n = 0;
        while (-1 != (n = fis.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return output.toByteArray();
    }

    public static void convertByteArrayToFile(byte[] array, File file) throws IOException {
        try (FileOutputStream outStream = new FileOutputStream(file);){
            outStream.write(array);
        }
    }
}

