/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.cron4j;

import it.sauronsoftware.cron4j.GUIDGenerator;
import it.sauronsoftware.cron4j.Scheduler;
import it.sauronsoftware.cron4j.SchedulingPattern;
import it.sauronsoftware.cron4j.Task;
import it.sauronsoftware.cron4j.TaskCollector;
import it.sauronsoftware.cron4j.TaskTable;

class LauncherThread
extends Thread {
    private String guid = GUIDGenerator.generate();
    private Scheduler scheduler;
    private TaskCollector[] collectors;
    private long referenceTimeInMillis;

    public LauncherThread(Scheduler scheduler, TaskCollector[] taskCollectorArray, long l) {
        this.scheduler = scheduler;
        this.collectors = taskCollectorArray;
        this.referenceTimeInMillis = l;
        String string = "cron4j::scheduler[" + scheduler.getGuid() + "]::launcher[" + this.guid + "]";
        this.setName(string);
    }

    public Object getGuid() {
        return this.guid;
    }

    public void run() {
        block0: for (int i = 0; i < this.collectors.length; ++i) {
            TaskTable taskTable = this.collectors[i].getTasks();
            int n = taskTable.size();
            for (int j = 0; j < n; ++j) {
                if (this.isInterrupted()) break block0;
                SchedulingPattern schedulingPattern = taskTable.getSchedulingPattern(j);
                if (!schedulingPattern.match(this.scheduler.getTimeZone(), this.referenceTimeInMillis)) continue;
                Task task = taskTable.getTask(j);
                this.scheduler.spawnExecutor(task);
            }
        }
        this.scheduler.notifyLauncherCompleted(this);
    }
}

