/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.io.File;
import junit.framework.TestCase;
import org.mortbay.http.HttpContext;
import org.mortbay.util.Resource;
import org.openqa.selenium.server.FsResourceLocator;

public class FsResourceLocatorUnitTest
extends TestCase {
    private File tempFile;
    private FsResourceLocator resourceLocator;
    private HttpContext context;

    public void setUp() throws Exception {
        super.setUp();
        this.tempFile = File.createTempFile("selenium-test-", "");
        this.tempFile.deleteOnExit();
        this.resourceLocator = new FsResourceLocator(this.tempFile.getParentFile());
        this.context = new HttpContext();
    }

    public void testShouldGetResourceFromRootDir() throws Exception {
        Resource resource = this.resourceLocator.getResource(this.context, this.tempFile.getName());
        FsResourceLocatorUnitTest.assertTrue((boolean)resource.exists());
        FsResourceLocatorUnitTest.assertNotNull((Object)resource.getInputStream());
        FsResourceLocatorUnitTest.assertEquals((String)this.tempFile.getAbsolutePath(), (String)resource.getFile().getAbsolutePath());
    }

    public void testShouldReturnMissingResourceIfResourceNotFound() throws Exception {
        FsResourceLocatorUnitTest.assertFalse((boolean)this.resourceLocator.getResource(this.context, "not_exists").exists());
    }

    public void testShouldReturnFilePathFromToString() throws Exception {
        Resource resource = this.resourceLocator.getResource(this.context, this.tempFile.getName());
        FsResourceLocatorUnitTest.assertTrue((String)"toString() must end with filename, because Jetty used this method to determine file type", (boolean)resource.toString().endsWith(this.tempFile.getName()));
    }

    public void testHackForJsUserExtensionsLocating() throws Exception {
        File extension = new File("user-extensions.js").getAbsoluteFile();
        extension.createNewFile();
        extension.deleteOnExit();
        FsResourceLocator extensionLocator = new FsResourceLocator(extension.getParentFile());
        Resource resource = extensionLocator.getResource(this.context, "some/path/user-extensions.js");
        FsResourceLocatorUnitTest.assertTrue((boolean)resource.exists());
        FsResourceLocatorUnitTest.assertEquals((String)extension.getAbsolutePath(), (String)resource.getFile().getAbsolutePath());
    }
}

