/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import junit.framework.TestCase;
import org.openqa.selenium.server.CommandQueue;
import org.openqa.selenium.server.FrameGroupCommandQueueSet;
import org.openqa.selenium.server.RemoteCommandException;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.SeleniumDriverResourceHandler;
import org.openqa.selenium.server.SeleniumServer;

public class SeleniumDriverResourceHandlerUnitTest
extends TestCase {
    private static String firstSessionId = "session 1";
    private static int defaultSpeed = CommandQueue.getSpeed();
    private static int newSpeed = defaultSpeed + 42;
    private static String defaultSpeedString = "OK," + defaultSpeed;
    private static String newSpeedString = "OK," + newSpeed;

    public void testGetDefaultSpeedNullSession() {
        SeleniumDriverResourceHandlerUnitTest.assertEquals((int)defaultSpeed, (int)CommandQueue.getSpeed());
        String speed = SeleniumDriverResourceHandler.getSpeedForSession(null);
        SeleniumDriverResourceHandlerUnitTest.assertEquals((String)defaultSpeedString, (String)speed);
    }

    public void testGetPresetSpeedNullSession() {
        SeleniumDriverResourceHandlerUnitTest.assertEquals((int)defaultSpeed, (int)CommandQueue.getSpeed());
        CommandQueue.setSpeed((int)newSpeed);
        String speed = SeleniumDriverResourceHandler.getSpeedForSession(null);
        SeleniumDriverResourceHandlerUnitTest.assertEquals((String)newSpeedString, (String)speed);
        CommandQueue.setSpeed((int)defaultSpeed);
    }

    public void testGetPresetSpeedValidSession() {
        SeleniumDriverResourceHandlerUnitTest.assertEquals((int)defaultSpeed, (int)CommandQueue.getSpeed());
        FrameGroupCommandQueueSet session1 = FrameGroupCommandQueueSet.makeQueueSet((String)firstSessionId, (int)4444, (RemoteControlConfiguration)new RemoteControlConfiguration());
        SeleniumDriverResourceHandlerUnitTest.assertNotNull((Object)session1);
        SeleniumDriverResourceHandler.setSpeedForSession((String)firstSessionId, (int)newSpeed);
        String speed = SeleniumDriverResourceHandler.getSpeedForSession((String)firstSessionId);
        SeleniumDriverResourceHandlerUnitTest.assertEquals((String)newSpeedString, (String)speed);
        FrameGroupCommandQueueSet.clearQueueSet((String)firstSessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testThrowsExceptionOnFailedBrowserLaunch() throws Exception {
        RemoteControlConfiguration configuration = new RemoteControlConfiguration();
        configuration.setTimeoutInSeconds(3);
        SeleniumServer server = new SeleniumServer(false, configuration);
        server.start();
        SeleniumDriverResourceHandler sdrh = new SeleniumDriverResourceHandler(server);
        try {
            sdrh.getNewBrowserSession("*mock", null, "", null);
            SeleniumDriverResourceHandlerUnitTest.fail((String)"Launch should have failed");
        }
        catch (RemoteCommandException rce) {
        }
        finally {
            if (server != null) {
                server.stop();
            }
        }
    }
}

