/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import junit.framework.TestCase;
import org.openqa.selenium.server.browserlaunchers.BrowserInstallation;
import org.openqa.selenium.server.browserlaunchers.BrowserInstallationCache;
import org.openqa.selenium.server.browserlaunchers.locators.BrowserLocator;

public class BrowserLocationCacheUnitTest
extends TestCase {
    public void tesCacheKeyIsTheBrowserStringWhenNoCustomPathIsProvided() {
        BrowserLocationCacheUnitTest.assertEquals((String)"*aBrowser", (String)new BrowserInstallationCache().cacheKey("*aBrowser", null));
    }

    public void testCacaheIsTheBrowserStringConcatenatedWithCustomPathWhenCustomPathIsProvided() {
        BrowserLocationCacheUnitTest.assertEquals((String)"*aBrowseraCustomPath", (String)new BrowserInstallationCache().cacheKey("*aBrowser", "aCustomPath"));
    }

    public void testLocateBrowserInstallationUseLocatorWhenCacheIsEmpty() {
        final BrowserInstallation expectedInstallation = new BrowserInstallation(null, null);
        BrowserLocator locator = new BrowserLocator(){

            public BrowserInstallation findBrowserLocationOrFail() {
                return expectedInstallation;
            }

            public BrowserInstallation retrieveValidInstallationPath(String customLauncherPath) {
                throw new UnsupportedOperationException();
            }
        };
        BrowserLocationCacheUnitTest.assertEquals((Object)expectedInstallation, (Object)new BrowserInstallationCache().locateBrowserInstallation("aBrowser", null, locator));
    }

    public void testLocateBrowserInstallationUseCacheOnSecondAccess() {
        final BrowserInstallation expectedInstallation = new BrowserInstallation(null, null);
        BrowserLocator locator = new BrowserLocator(){

            public BrowserInstallation findBrowserLocationOrFail() {
                return expectedInstallation;
            }

            public BrowserInstallation retrieveValidInstallationPath(String customLauncherPath) {
                throw new UnsupportedOperationException();
            }
        };
        BrowserInstallationCache cache = new BrowserInstallationCache();
        cache.locateBrowserInstallation("aBrowser", null, locator);
        BrowserLocationCacheUnitTest.assertEquals((Object)expectedInstallation, (Object)cache.locateBrowserInstallation("aBrowser", null, null));
    }

    public void testLocateBrowserInstallationUseLocatorWhenCacheIsEmptyAndACustomPathIsProvided() {
        final BrowserInstallation expectedInstallation = new BrowserInstallation(null, null);
        BrowserLocator locator = new BrowserLocator(){

            public BrowserInstallation findBrowserLocationOrFail() {
                throw new UnsupportedOperationException();
            }

            public BrowserInstallation retrieveValidInstallationPath(String customLauncherPath) {
                if ("aCustomLauncher".equals(customLauncherPath)) {
                    return expectedInstallation;
                }
                throw new UnsupportedOperationException(customLauncherPath);
            }
        };
        BrowserLocationCacheUnitTest.assertEquals((Object)expectedInstallation, (Object)new BrowserInstallationCache().locateBrowserInstallation("aBrowser", "aCustomLauncher", locator));
    }

    public void testLocateBrowserInstallationUseCacheOnSecondAccessWhenCustomLauncherIsProvided() {
        final BrowserInstallation expectedInstallation = new BrowserInstallation(null, null);
        BrowserLocator locator = new BrowserLocator(){

            public BrowserInstallation findBrowserLocationOrFail() {
                throw new UnsupportedOperationException();
            }

            public BrowserInstallation retrieveValidInstallationPath(String customLauncherPath) {
                if ("aCustomLauncher".equals(customLauncherPath)) {
                    return expectedInstallation;
                }
                throw new UnsupportedOperationException(customLauncherPath);
            }
        };
        BrowserInstallationCache cache = new BrowserInstallationCache();
        cache.locateBrowserInstallation("aBrowser", "aCustomLauncher", locator);
        BrowserLocationCacheUnitTest.assertEquals((Object)expectedInstallation, (Object)cache.locateBrowserInstallation("aBrowser", "aCustomLauncher", null));
    }
}

