/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.commands;

import java.io.ByteArrayInputStream;
import java.lang.reflect.Method;
import javax.imageio.ImageIO;
import javax.imageio.stream.MemoryCacheImageInputStream;
import junit.framework.TestCase;
import org.bouncycastle.util.encoders.Base64;
import org.easymock.classextension.EasyMock;
import org.openqa.selenium.server.commands.CaptureScreenshotToStringCommand;

public class CaptureScreenshotToStringCommandUnitTest
extends TestCase {
    private CaptureScreenshotToStringCommand command;

    public void testDumbJUnit() {
    }

    public void disabled_testExecuteReturnsOkAndCommaWhenEmptyCaptureAndEncodeSystemScreenshotSucceeds() throws Exception {
        this.command = (CaptureScreenshotToStringCommand)EasyMock.createMock(CaptureScreenshotToStringCommand.class, (Method[])new Method[]{CaptureScreenshotToStringCommand.class.getDeclaredMethod("captureAndEncodeSystemScreenshot", new Class[0])});
        this.command.captureAndEncodeSystemScreenshot();
        EasyMock.expectLastCall().andReturn((Object)"");
        EasyMock.replay((Object[])new Object[]{this.command});
        CaptureScreenshotToStringCommandUnitTest.assertEquals((String)"OK,", (String)this.command.execute());
        EasyMock.verify((Object[])new Object[]{this.command});
    }

    public void disabled_testExecuteReturnsErrorWhenEmptyCaptureAndEncodeSystemScreenshotThrowsException() throws Exception {
        this.command = (CaptureScreenshotToStringCommand)EasyMock.createMock(CaptureScreenshotToStringCommand.class, (Method[])new Method[]{CaptureScreenshotToStringCommand.class.getDeclaredMethod("captureAndEncodeSystemScreenshot", new Class[0])});
        this.command.captureAndEncodeSystemScreenshot();
        EasyMock.expectLastCall().andThrow((Throwable)new RuntimeException("an error message"));
        EasyMock.replay((Object[])new Object[]{this.command});
        CaptureScreenshotToStringCommandUnitTest.assertEquals((String)"ERROR: Problem capturing a screenshot to string: an error message", (String)this.command.execute());
        EasyMock.verify((Object[])new Object[]{this.command});
    }

    public void disabled_testCapturedScreenshotIsReturnedAsBase64EncodedString() throws Exception {
        this.command = new CaptureScreenshotToStringCommand();
        String returnValue = this.command.execute();
        String result = returnValue.split(",")[0];
        String image = returnValue.split(",")[1];
        CaptureScreenshotToStringCommandUnitTest.assertEquals((String)"OK", (String)result);
        CaptureScreenshotToStringCommandUnitTest.assertNotNull((Object)ImageIO.read(new MemoryCacheImageInputStream(new ByteArrayInputStream(Base64.decode((String)image)))));
    }
}

