# Release Notes for mwlib 0.17.0

We're thrilled to announce the release of mwlib version 0.17.0, a significant step forward in our journey, primarily focused on transitioning from Python 2 to Python 3. This release brings enhanced code quality, improved scalability, and performance optimizations.

## What's New in 0.17.0

### Python 3 Migration
- **Complete Shift to Python 3:** Embracing the future with full Python 3 support.
- **End of Python 2 Support:** Aligning with modern standards for better performance and security.

### Features and Improvements
- **Ploticus Dependency Removed:** Transitioned to using PNG images from HTML for a more streamlined experience.
- **Docker Compose Examples Added:** Easy-to-follow Docker Compose examples for quick setup and integration.
- **Local MediaWiki Instance Setup:** Instructions on setting up mwlib with a local MediaWiki instance for seamless integration.
- **Integrated Dependencies:** The [qserve](https://github.com/pediapress/qserve) and [mwlib.rl](https://github.com/pediapress/mwlib.rl) libraries are now integrated into core mwlib for a more straightforward development process and easier setup.   


### Code Quality and Security
- **Code Linters Integration:** Used Ruff, Bandit, Pylint and flake8 for robust code quality.
- **Bug Fixes and Optimizations:** Comprehensive code clean-up for enhanced stability and performance.
- **Scalability Enhancements:** Code refactoring for better maintainability and scalability.


### Project Structure Refactoring
- **Refactored Project Structure:** The project structure has been overhauled, with a focus on better organization and maintainability.
- **Creation of Classes and Modules:** Introduction of new classes and the grouping of code into well-defined modules and files for improved clarity and efficiency.


### Performance Enhancements
- **Efficiency Boost:** Leverage the speed and efficiency of Python 3 for faster processing.

## Docker Compose Setup

- **Easy Setup with Docker Compose:** Check out the newly added Docker Compose examples for a straightforward setup process.
- **Local MediaWiki Integration:** Detailed guidelines for integrating mwlib with your local MediaWiki instance using Docker Compose.


## Upgrading to 0.17.0

To benefit from the latest improvements, users are encouraged to upgrade to version 0.17.0. Ensure you have Python 3.8 or later for this version. Follow your standard environment's upgrade procedure to update to the latest mwlib.


## Stay Tuned

We're committed to continual improvement and value your feedback. Stay connected for more updates and enhancements in future releases.

---

Stay tuned for more updates, and happy coding!
