/* Generated by re2c 3.0 */
#line 1 "src/mwlib/_uscan.re"
// -*- mode: c++ -*-
// Copyright (c) 2007-2009 PediaPress GmbH
// See README.rst for additional licensing information.

#include <Python.h>

#include <iostream>
#include <assert.h>
#include <vector>

using namespace std;

#define RET(x) {found(x); return x;}

typedef enum {
    t_end,
    t_text,
    t_entity,
    t_special,
    t_magicword,
    t_comment,
    t_2box_open,   // [[
    t_2box_close,  // ]]
    t_http_url,
    t_break,
    t_begin_table,
    t_end_table,
    t_html_tag,
    t_singlequote,
    t_pre,
    t_section,
    t_section_end,
    t_item,
    t_colon,
    t_semicolon,
    t_hrule,
    t_newline,
    t_column,
    t_row,
    t_tablecaption,
    t_urllink,
    t_uniq,

    t_ebad,
} mwtok;

struct Token {
    int type;
    int start;
    int len;
};

class Scanner {
public:

    Scanner(Py_UCS4 *_start, Py_UCS4 *_end) {
        source = start = _start;
        end = _end;
        cursor = start;
        line_startswith_section = -1;
        tablemode = 0;
        last_ebad = false;
    }

    int found(mwtok val) {
        if (val == t_ebad) {
            last_ebad = true;
            return tokens.size() - 1;
        }

        if (val == t_text && tokens.size() && !last_ebad) {
            Token &previous_token(tokens[tokens.size() - 1]);
            if (previous_token.type == val) {
                previous_token.len += cursor - start;
                return tokens.size() - 1;
            }
        }

        last_ebad = false;

        Token t;
        t.type = val;
        t.start = (start - source);
        t.len = cursor - start;
        tokens.push_back(t);
        return tokens.size() - 1;
    }

    bool bol() {
        if ((start == source) || (start[-1] == '\n')) {
            memset(&lineflags, 0, sizeof(lineflags));
            return true;
        } else {
            return false;
        }
    }

    bool eol() const {
        return *cursor == '\n' || *cursor == 0;
    }

    void newline() {
        if (line_startswith_section >= 0) {
            tokens[line_startswith_section].type = t_text;
        }
        line_startswith_section = -1;
    }

    inline int scan();

    Py_UCS4 *source;

    Py_UCS4 *start;
    Py_UCS4 *cursor;
    Py_UCS4 *end;
    vector <Token> tokens;

    bool last_ebad;
    int line_startswith_section;
    int tablemode;
    struct {
        Py_UCS4 rowchar;
    } lineflags;
};


int Scanner::scan() {
    start = cursor;

    Py_UCS4 *marker = cursor;

    Py_UCS4 *save_cursor = cursor;


#define YYCTYPE         Py_UCS4
#define YYCURSOR        cursor
#define YYMARKER    marker
#define YYLIMIT   (end)
// #define YYFILL(n) return 0;

#line 143 "src/mwlib/_uscan.re"


/*
  the re2c manpage says:
  "The user must arrange for a sentinel token to appear at the end of input"
  \000 is our sentinel token.
*/

#line 184 "src/mwlib/_uscan.re"

    if (!bol()) {
        goto not_bol;
    }

#line 159 "src/mwlib/_uscan.cc"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	yych = *YYCURSOR;
	if (yych <= ',') {
		if (yych <= '!') {
			if (yych <= '\t') {
				if (yych >= '\t') goto yy3;
			} else {
				if (yych <= 0x001F) goto yy1;
				if (yych <= ' ') goto yy4;
				goto yy6;
			}
		} else {
			if (yych <= '#') {
				if (yych >= '#') goto yy8;
			} else {
				if (yych == '*') goto yy8;
			}
		}
	} else {
		if (yych <= '<') {
			if (yych <= '9') {
				if (yych <= '-') goto yy10;
			} else {
				if (yych <= ':') goto yy11;
				if (yych <= ';') goto yy8;
			}
		} else {
			if (yych <= 'z') {
				if (yych <= '=') goto yy12;
			} else {
				if (yych <= '{') goto yy14;
				if (yych <= '|') goto yy15;
			}
		}
	}
yy1:
	++YYCURSOR;
yy2:
#line 236 "src/mwlib/_uscan.re"
	{goto not_bol;}
#line 202 "src/mwlib/_uscan.cc"
yy3:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '!') {
		if (yych == '\t') goto yy17;
		if (yych <= 0x001F) goto yy2;
		goto yy17;
	} else {
		if (yych <= ':') {
			if (yych <= '9') goto yy2;
			goto yy17;
		} else {
			if (yych <= 'z') goto yy2;
			if (yych <= '|') goto yy17;
			goto yy2;
		}
	}
yy4:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '!') {
		if (yych == '\t') goto yy17;
		if (yych >= ' ') goto yy17;
	} else {
		if (yych <= ':') {
			if (yych >= ':') goto yy17;
		} else {
			if (yych <= 'z') goto yy5;
			if (yych <= '|') goto yy17;
		}
	}
yy5:
#line 228 "src/mwlib/_uscan.re"
	{RET(t_pre);}
#line 237 "src/mwlib/_uscan.cc"
yy6:
	++YYCURSOR;
yy7:
#line 204 "src/mwlib/_uscan.re"
	{
                    if (tablemode) {
                            lineflags.rowchar=cursor[-1];
                        RET(t_column);
                    }

                    if (*start==' ') {
                        cursor = start+1;
                        RET(t_pre);
                    }
                    RET(t_text);
                }
#line 254 "src/mwlib/_uscan.cc"
yy8:
	yych = *++YYCURSOR;
	if (yych <= ')') {
		if (yych == '#') goto yy8;
	} else {
		if (yych <= '*') goto yy8;
		if (yych <= '9') goto yy9;
		if (yych <= ';') goto yy8;
	}
yy9:
#line 233 "src/mwlib/_uscan.re"
	{RET(t_item);}
#line 267 "src/mwlib/_uscan.cc"
yy10:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy21;
	goto yy2;
yy11:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '#') {
			if (yych <= '"') goto yy9;
			goto yy8;
		} else {
			if (yych == '*') goto yy8;
			goto yy9;
		}
	} else {
		if (yych <= ';') {
			if (yych <= ':') goto yy11;
			goto yy8;
		} else {
			if (yych == '{') goto yy20;
			goto yy9;
		}
	}
yy12:
	yych = *++YYCURSOR;
	if (yych <= 0x001F) {
		if (yych == '\t') goto yy22;
	} else {
		if (yych <= ' ') goto yy22;
		if (yych == '=') goto yy12;
	}
yy13:
#line 229 "src/mwlib/_uscan.re"
	{
			        line_startswith_section = found(t_section);
			        return t_section;
		        }
#line 307 "src/mwlib/_uscan.cc"
yy14:
	yych = *++YYCURSOR;
	if (yych == '|') goto yy23;
	goto yy2;
yy15:
	yych = *++YYCURSOR;
	if (yych <= ',') {
		if (yych == '+') goto yy24;
		goto yy7;
	} else {
		if (yych <= '-') goto yy25;
		if (yych == '}') goto yy26;
		goto yy7;
	}
yy16:
	yych = *++YYCURSOR;
yy17:
	if (yych <= '!') {
		if (yych <= '\t') {
			if (yych >= '\t') goto yy16;
		} else {
			if (yych <= 0x001F) goto yy18;
			if (yych <= ' ') goto yy16;
			goto yy6;
		}
	} else {
		if (yych <= 'z') {
			if (yych == ':') goto yy19;
		} else {
			if (yych <= '{') goto yy20;
			if (yych <= '|') goto yy15;
		}
	}
yy18:
	YYCURSOR = YYMARKER;
	if (yyaccept <= 1) {
		if (yyaccept == 0) {
			goto yy2;
		} else {
			goto yy5;
		}
	} else {
		goto yy9;
	}
yy19:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy19;
	if (yych != '{') goto yy18;
yy20:
	yych = *++YYCURSOR;
	if (yych == '|') goto yy23;
	goto yy18;
yy21:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy27;
	goto yy18;
yy22:
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy22;
	if (yych == ' ') goto yy22;
	goto yy13;
yy23:
	++YYCURSOR;
#line 190 "src/mwlib/_uscan.re"
	{++tablemode; RET(t_begin_table);}
#line 373 "src/mwlib/_uscan.cc"
yy24:
	yych = *++YYCURSOR;
	if (yych == '+') goto yy24;
#line 218 "src/mwlib/_uscan.re"
	{
                    if (tablemode)
                        RET(t_tablecaption);
                    if (*start==' ') {
                        cursor = start+1;
                        RET(t_pre);
                    }
                    RET(t_text);
                }
#line 387 "src/mwlib/_uscan.cc"
yy25:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy25;
#line 193 "src/mwlib/_uscan.re"
	{
                    if (tablemode)
                        RET(t_row);
                    if (*start==' ') {
                        cursor = start+1;
                        RET(t_pre);
                    }
                    RET(t_text);
                }
#line 401 "src/mwlib/_uscan.cc"
yy26:
	++YYCURSOR;
#line 191 "src/mwlib/_uscan.re"
	{if (--tablemode<0) tablemode=0; RET(t_end_table);}
#line 406 "src/mwlib/_uscan.cc"
yy27:
	yych = *++YYCURSOR;
	if (yych != '-') goto yy18;
yy28:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy28;
#line 234 "src/mwlib/_uscan.re"
	{RET(t_hrule);}
#line 415 "src/mwlib/_uscan.cc"
}
#line 237 "src/mwlib/_uscan.re"



    not_bol:
    cursor = save_cursor;
    marker = cursor;


#line 426 "src/mwlib/_uscan.cc"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	yych = *YYCURSOR;
	if (yych <= ']') {
		if (yych <= '/') {
			if (yych <= ' ') {
				if (yych <= 0x0000) goto yy30;
				if (yych == '\n') goto yy33;
				goto yy31;
			} else {
				if (yych <= '%') {
					if (yych <= '!') goto yy35;
					goto yy31;
				} else {
					if (yych <= '&') goto yy36;
					if (yych <= '\'') goto yy37;
					goto yy31;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= '9') goto yy38;
					goto yy41;
				} else {
					if (yych <= ';') goto yy31;
					if (yych <= '<') goto yy43;
					goto yy44;
				}
			} else {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy31;
					goto yy38;
				} else {
					if (yych <= '[') goto yy46;
					if (yych <= '\\') goto yy31;
					goto yy47;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'e') {
				if (yych == '_') goto yy48;
				if (yych <= '`') goto yy31;
				goto yy38;
			} else {
				if (yych <= 'g') {
					if (yych <= 'f') goto yy50;
					goto yy38;
				} else {
					if (yych <= 'h') goto yy51;
					if (yych <= 'i') goto yy52;
					goto yy38;
				}
			}
		} else {
			if (yych <= '|') {
				if (yych <= 'n') {
					if (yych <= 'm') goto yy53;
					goto yy54;
				} else {
					if (yych <= 'z') goto yy38;
					if (yych <= '{') goto yy31;
					goto yy55;
				}
			} else {
				if (yych <= 0x007F) {
					if (yych <= '~') goto yy31;
					goto yy56;
				} else {
					if (yych == 0xEBAD) goto yy57;
					goto yy31;
				}
			}
		}
	}
yy30:
	++YYCURSOR;
#line 315 "src/mwlib/_uscan.re"
	{newline(); return t_end;}
#line 509 "src/mwlib/_uscan.cc"
yy31:
	++YYCURSOR;
yy32:
#line 316 "src/mwlib/_uscan.re"
	{RET(t_text);}
#line 515 "src/mwlib/_uscan.cc"
yy33:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '\n') goto yy58;
	if (yych == ' ') goto yy60;
yy34:
#line 288 "src/mwlib/_uscan.re"
	{newline(); RET(t_newline);}
#line 524 "src/mwlib/_uscan.cc"
yy35:
	yych = *++YYCURSOR;
	if (yych == '!') goto yy62;
	goto yy32;
yy36:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych == '#') goto yy63;
		if (yych <= '/') goto yy32;
		goto yy64;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy32;
			goto yy64;
		} else {
			if (yych <= '`') goto yy32;
			if (yych <= 'z') goto yy64;
			goto yy32;
		}
	}
yy37:
	yych = *++YYCURSOR;
	if (yych == '\'') goto yy65;
	goto yy32;
yy38:
	yych = *++YYCURSOR;
yy39:
	if (yych <= '@') {
		if (yych <= '/') goto yy40;
		if (yych <= '9') goto yy38;
	} else {
		if (yych <= 'Z') goto yy38;
		if (yych <= '`') goto yy40;
		if (yych <= 'z') goto yy38;
	}
yy40:
#line 261 "src/mwlib/_uscan.re"
	{RET(t_text);}
#line 564 "src/mwlib/_uscan.cc"
yy41:
	++YYCURSOR;
yy42:
#line 306 "src/mwlib/_uscan.re"
	{RET(t_special);}
#line 570 "src/mwlib/_uscan.cc"
yy43:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '!') goto yy66;
		if (yych <= '.') goto yy32;
		goto yy67;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy32;
			goto yy68;
		} else {
			if (yych <= '`') goto yy32;
			if (yych <= 'z') goto yy68;
			goto yy32;
		}
	}
yy44:
	yych = *++YYCURSOR;
	if (yych <= 0x001F) {
		if (yych == '\t') goto yy69;
	} else {
		if (yych <= ' ') goto yy69;
		if (yych == '=') goto yy44;
	}
yy45:
#line 265 "src/mwlib/_uscan.re"
	{
                    if (eol()) {
                        if (line_startswith_section>=0) {
                             line_startswith_section=-1;
                             RET(t_section_end);
                        } else {
                             RET(t_text);
                        }
                    } else {
                        RET(t_text);
                    }
    		    }
#line 610 "src/mwlib/_uscan.cc"
yy46:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'f') {
		if (yych <= 'Z') {
			if (yych == '/') goto yy70;
			goto yy42;
		} else {
			if (yych <= '[') goto yy71;
			if (yych <= 'e') goto yy42;
			goto yy72;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'g') goto yy42;
			if (yych <= 'h') goto yy73;
			goto yy74;
		} else {
			if (yych <= 'l') goto yy42;
			if (yych <= 'm') goto yy75;
			if (yych <= 'n') goto yy76;
			goto yy42;
		}
	}
yy47:
	yych = *++YYCURSOR;
	if (yych == ']') goto yy77;
	goto yy42;
yy48:
	yych = *++YYCURSOR;
	if (yych == '_') goto yy78;
yy49:
#line 262 "src/mwlib/_uscan.re"
	{RET(t_text);}
#line 645 "src/mwlib/_uscan.cc"
yy50:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy79;
	goto yy39;
yy51:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy80;
	goto yy39;
yy52:
	yych = *++YYCURSOR;
	if (yych == 'r') goto yy81;
	goto yy39;
yy53:
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy82;
	goto yy39;
yy54:
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy83;
	goto yy39;
yy55:
	yych = *++YYCURSOR;
	if (yych <= '*') {
		if (yych == '!') goto yy62;
		goto yy42;
	} else {
		if (yych <= '+') goto yy84;
		if (yych == '|') goto yy62;
		goto yy42;
	}
yy56:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy85;
	goto yy32;
yy57:
	++YYCURSOR;
#line 245 "src/mwlib/_uscan.re"
	{RET(t_ebad);}
#line 685 "src/mwlib/_uscan.cc"
yy58:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '\n') goto yy58;
	if (yych == ' ') goto yy60;
yy59:
#line 278 "src/mwlib/_uscan.re"
	{
                    newline();
                    Py_UCS4 *tmp = cursor;

                    cursor = start+1;
                    found(t_newline);
                    start += 1;
                    cursor = tmp;
                    RET(t_break);
                }
#line 703 "src/mwlib/_uscan.cc"
yy60:
	yych = *++YYCURSOR;
	if (yych == '\n') goto yy58;
	if (yych == ' ') goto yy60;
yy61:
	YYCURSOR = YYMARKER;
	if (yyaccept <= 2) {
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy34;
			} else {
				goto yy32;
			}
		} else {
			goto yy42;
		}
	} else {
		if (yyaccept <= 4) {
			if (yyaccept == 3) {
				goto yy59;
			} else {
				goto yy49;
			}
		} else {
			goto yy40;
		}
	}
yy62:
	++YYCURSOR;
#line 290 "src/mwlib/_uscan.re"
	{
		            if (tablemode) {
		                if (cursor[-2]!='!' || cursor[-2]==lineflags.rowchar) {
			                RET(t_column);
			            }
		            }
		            cursor = start+1;
		            RET(t_special);
	            }
#line 743 "src/mwlib/_uscan.cc"
yy63:
	yych = *++YYCURSOR;
	if (yych <= 'W') {
		if (yych <= '/') goto yy61;
		if (yych <= '9') goto yy86;
		goto yy61;
	} else {
		if (yych <= 'X') goto yy87;
		if (yych == 'x') goto yy87;
		goto yy61;
	}
yy64:
	yych = *++YYCURSOR;
	if (yych <= ';') {
		if (yych <= '/') goto yy61;
		if (yych <= '9') goto yy64;
		if (yych <= ':') goto yy61;
		goto yy88;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy61;
			goto yy64;
		} else {
			if (yych <= '`') goto yy61;
			if (yych <= 'z') goto yy64;
			goto yy61;
		}
	}
yy65:
	yych = *++YYCURSOR;
	if (yych == '\'') goto yy65;
#line 307 "src/mwlib/_uscan.re"
	{RET(t_singlequote);}
#line 777 "src/mwlib/_uscan.cc"
yy66:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy89;
	goto yy61;
yy67:
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy61;
	if (yych <= 'Z') goto yy68;
	if (yych <= '`') goto yy61;
	if (yych >= '{') goto yy61;
yy68:
	yych = *++YYCURSOR;
	if (yych <= '<') {
		if (yych <= 0x0000) goto yy61;
		if (yych <= ';') goto yy68;
		goto yy61;
	} else {
		if (yych == '>') goto yy90;
		goto yy68;
	}
yy69:
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy69;
	if (yych == ' ') goto yy69;
	goto yy45;
yy70:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy91;
	goto yy61;
yy71:
	++YYCURSOR;
#line 263 "src/mwlib/_uscan.re"
	{RET(t_2box_open);}
#line 811 "src/mwlib/_uscan.cc"
yy72:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy92;
	goto yy61;
yy73:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy93;
	goto yy61;
yy74:
	yych = *++YYCURSOR;
	if (yych == 'r') goto yy94;
	goto yy61;
yy75:
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy95;
	goto yy61;
yy76:
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy96;
	goto yy61;
yy77:
	++YYCURSOR;
#line 264 "src/mwlib/_uscan.re"
	{RET(t_2box_close);}
#line 836 "src/mwlib/_uscan.cc"
yy78:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case 'E': goto yy97;
		case 'F': goto yy98;
		case 'N': goto yy99;
		case 'S': goto yy100;
		case 'T': goto yy101;
		default: goto yy103;
	}
yy79:
	yych = *++YYCURSOR;
	if (yych == 'p') goto yy104;
	goto yy39;
yy80:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy105;
	goto yy39;
yy81:
	yych = *++YYCURSOR;
	if (yych == 'c') goto yy106;
	goto yy39;
yy82:
	yych = *++YYCURSOR;
	if (yych == 'i') goto yy107;
	goto yy39;
yy83:
	yych = *++YYCURSOR;
	if (yych == 'w') goto yy108;
	goto yy39;
yy84:
	++YYCURSOR;
#line 300 "src/mwlib/_uscan.re"
	{
                    if (tablemode)
                        RET(t_tablecaption);
                    cursor = start+1;
                    RET(t_special);
	            }
#line 877 "src/mwlib/_uscan.cc"
yy85:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy109;
	goto yy61;
yy86:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy61;
	if (yych <= '9') goto yy86;
	if (yych == ';') goto yy88;
	goto yy61;
yy87:
	yych = *++YYCURSOR;
	if (yych == ';') goto yy61;
	goto yy111;
yy88:
	++YYCURSOR;
#line 313 "src/mwlib/_uscan.re"
	{RET(t_entity);}
#line 896 "src/mwlib/_uscan.cc"
yy89:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy112;
	goto yy61;
yy90:
	++YYCURSOR;
#line 309 "src/mwlib/_uscan.re"
	{RET(t_html_tag);}
#line 905 "src/mwlib/_uscan.cc"
yy91:
	yych = *++YYCURSOR;
	if (yych <= '>') {
		if (yych <= '"') {
			if (yych == '!') goto yy113;
			goto yy61;
		} else {
			if (yych == '<') goto yy61;
			if (yych <= '=') goto yy113;
			goto yy61;
		}
	} else {
		if (yych <= '\\') {
			if (yych == '[') goto yy61;
			goto yy113;
		} else {
			if (yych <= ']') goto yy61;
			if (yych == 0x007F) goto yy61;
			goto yy113;
		}
	}
yy92:
	yych = *++YYCURSOR;
	if (yych == 'p') goto yy115;
	goto yy61;
yy93:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy116;
	goto yy61;
yy94:
	yych = *++YYCURSOR;
	if (yych == 'c') goto yy117;
	goto yy61;
yy95:
	yych = *++YYCURSOR;
	if (yych == 'i') goto yy118;
	goto yy61;
yy96:
	yych = *++YYCURSOR;
	if (yych == 'w') goto yy119;
	goto yy61;
yy97:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy120;
	goto yy61;
yy98:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy121;
	goto yy61;
yy99:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'E') goto yy122;
		goto yy61;
	} else {
		if (yych <= 'O') goto yy123;
		if (yych == 'U') goto yy124;
		goto yy61;
	}
yy100:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy125;
	goto yy61;
yy101:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy126;
	goto yy61;
yy102:
	yych = *++YYCURSOR;
yy103:
	if (yych == '_') goto yy102;
	goto yy49;
yy104:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == ':') goto yy127;
	goto yy39;
yy105:
	yych = *++YYCURSOR;
	if (yych == 'p') goto yy128;
	goto yy39;
yy106:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == ':') goto yy129;
	goto yy39;
yy107:
	yych = *++YYCURSOR;
	if (yych == 'l') goto yy130;
	goto yy39;
yy108:
	yych = *++YYCURSOR;
	if (yych == 's') goto yy131;
	goto yy39;
yy109:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy132;
	goto yy61;
yy110:
	yych = *++YYCURSOR;
yy111:
	if (yych <= ';') {
		if (yych <= '/') goto yy61;
		if (yych <= '9') goto yy110;
		if (yych <= ':') goto yy61;
		goto yy88;
	} else {
		if (yych <= 'F') {
			if (yych <= '@') goto yy61;
			goto yy110;
		} else {
			if (yych <= '`') goto yy61;
			if (yych <= 'f') goto yy110;
			goto yy61;
		}
	}
yy112:
	yych = *++YYCURSOR;
	if (yych <= ';') {
		if (yych <= 0x0000) goto yy61;
		if (yych == '-') goto yy133;
		goto yy112;
	} else {
		if (yych == '=') goto yy112;
		if (yych <= '>') goto yy61;
		goto yy112;
	}
yy113:
	yych = *++YYCURSOR;
	if (yych <= '>') {
		if (yych <= '"') {
			if (yych == '!') goto yy113;
		} else {
			if (yych == '<') goto yy114;
			if (yych <= '=') goto yy113;
		}
	} else {
		if (yych <= '\\') {
			if (yych != '[') goto yy113;
		} else {
			if (yych <= ']') goto yy114;
			if (yych != 0x007F) goto yy113;
		}
	}
yy114:
#line 255 "src/mwlib/_uscan.re"
	{RET(t_urllink);}
#line 1053 "src/mwlib/_uscan.cc"
yy115:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy134;
	goto yy61;
yy116:
	yych = *++YYCURSOR;
	if (yych == 'p') goto yy135;
	goto yy61;
yy117:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy136;
	goto yy61;
yy118:
	yych = *++YYCURSOR;
	if (yych == 'l') goto yy137;
	goto yy61;
yy119:
	yych = *++YYCURSOR;
	if (yych == 's') goto yy138;
	goto yy61;
yy120:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy139;
	goto yy61;
yy121:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy140;
	goto yy61;
yy122:
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy141;
	goto yy61;
yy123:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'C': goto yy142;
		case 'E': goto yy143;
		case 'G': goto yy144;
		case 'I': goto yy145;
		case 'N': goto yy146;
		case 'T': goto yy147;
		default: goto yy61;
	}
yy124:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy148;
	goto yy61;
yy125:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy149;
	goto yy61;
yy126:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy139;
	goto yy61;
yy127:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy150;
	goto yy61;
yy128:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == ':') goto yy151;
	if (yych == 's') goto yy152;
	goto yy39;
yy129:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy153;
	goto yy61;
yy130:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy154;
	goto yy39;
yy131:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == ':') goto yy155;
	goto yy39;
yy132:
	yych = *++YYCURSOR;
	if (yych == 'Q') goto yy156;
	goto yy61;
yy133:
	yych = *++YYCURSOR;
	if (yych <= ';') {
		if (yych <= 0x0000) goto yy61;
		if (yych == '-') goto yy157;
		goto yy112;
	} else {
		if (yych == '=') goto yy112;
		if (yych <= '>') goto yy61;
		goto yy112;
	}
yy134:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy158;
	goto yy61;
yy135:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy159;
	if (yych == 's') goto yy160;
	goto yy61;
yy136:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy161;
	goto yy61;
yy137:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy162;
	goto yy61;
yy138:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy163;
	goto yy61;
yy139:
	yych = *++YYCURSOR;
	if (yych == '_') goto yy164;
	goto yy61;
yy140:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy165;
	goto yy61;
yy141:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy166;
	goto yy61;
yy142:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy139;
	if (yych == 'O') goto yy167;
	goto yy61;
yy143:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy168;
	goto yy61;
yy144:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy169;
	if (yych == 'L') goto yy170;
	goto yy61;
yy145:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy171;
	goto yy61;
yy146:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy124;
	goto yy61;
yy147:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych == 'C') goto yy139;
		goto yy61;
	} else {
		if (yych <= 'I') goto yy172;
		if (yych == 'O') goto yy173;
		goto yy61;
	}
yy148:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy174;
	goto yy61;
yy149:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy175;
	goto yy61;
yy150:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy176;
	goto yy61;
yy151:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy177;
	goto yy61;
yy152:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == ':') goto yy151;
	goto yy39;
yy153:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy178;
	goto yy61;
yy154:
	yych = *++YYCURSOR;
	if (yych == 'o') goto yy179;
	goto yy39;
yy155:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy180;
		goto yy61;
	} else {
		if (yych <= '9') goto yy180;
		if (yych <= '@') goto yy61;
		if (yych <= 'a') goto yy180;
		goto yy61;
	}
yy156:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy182;
	goto yy61;
yy157:
	yych = *++YYCURSOR;
	if (yych <= ';') {
		if (yych <= 0x0000) goto yy61;
		if (yych == '-') goto yy157;
		goto yy112;
	} else {
		if (yych <= '<') goto yy61;
		if (yych == '>') goto yy183;
		goto yy112;
	}
yy158:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy184;
	goto yy61;
yy159:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy185;
	goto yy61;
yy160:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy159;
	goto yy61;
yy161:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy186;
	goto yy61;
yy162:
	yych = *++YYCURSOR;
	if (yych == 'o') goto yy187;
	goto yy61;
yy163:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy188;
		goto yy61;
	} else {
		if (yych <= '9') goto yy188;
		if (yych <= '@') goto yy61;
		if (yych <= 'a') goto yy188;
		goto yy61;
	}
yy164:
	yych = *++YYCURSOR;
	if (yych == '_') goto yy190;
	goto yy61;
yy165:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy191;
	goto yy61;
yy166:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy192;
	goto yy61;
yy167:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy193;
	goto yy61;
yy168:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy194;
	goto yy61;
yy169:
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy195;
	goto yy61;
yy170:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy196;
	goto yy61;
yy171:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy197;
	goto yy61;
yy172:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy198;
	goto yy61;
yy173:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy199;
	goto yy61;
yy174:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy200;
	goto yy61;
yy175:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy139;
	goto yy61;
yy176:
	yych = *++YYCURSOR;
	if (yych <= '>') {
		if (yych <= '%') {
			if (yych <= '"') goto yy61;
			if (yych <= '$') goto yy201;
			goto yy61;
		} else {
			if (yych <= ':') goto yy201;
			if (yych == '=') goto yy201;
			goto yy61;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy201;
			if (yych == '_') goto yy201;
			goto yy61;
		} else {
			if (yych == '|') goto yy61;
			if (yych <= '~') goto yy201;
			goto yy61;
		}
	}
yy177:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy203;
	goto yy61;
yy178:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '-') goto yy61;
		if (yych <= '9') goto yy204;
		goto yy61;
	} else {
		if (yych <= 'Z') goto yy204;
		if (yych <= '`') goto yy61;
		if (yych <= 'z') goto yy204;
		goto yy61;
	}
yy179:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == ':') goto yy206;
	goto yy39;
yy180:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy180;
	} else {
		if (yych <= '9') goto yy180;
		if (yych <= '@') goto yy181;
		if (yych <= 'a') goto yy180;
	}
yy181:
#line 251 "src/mwlib/_uscan.re"
	{RET(t_http_url);}
#line 1402 "src/mwlib/_uscan.cc"
yy182:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy61;
	goto yy208;
yy183:
	++YYCURSOR;
#line 312 "src/mwlib/_uscan.re"
	{RET(t_comment);}
#line 1411 "src/mwlib/_uscan.cc"
yy184:
	yych = *++YYCURSOR;
	if (yych <= '>') {
		if (yych <= '%') {
			if (yych <= '"') goto yy61;
			if (yych <= '$') goto yy209;
			goto yy61;
		} else {
			if (yych <= ':') goto yy209;
			if (yych == '=') goto yy209;
			goto yy61;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy209;
			if (yych == '_') goto yy209;
			goto yy61;
		} else {
			if (yych == '|') goto yy61;
			if (yych <= '~') goto yy209;
			goto yy61;
		}
	}
yy185:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy211;
	goto yy61;
yy186:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '-') goto yy61;
		if (yych <= '9') goto yy212;
		goto yy61;
	} else {
		if (yych <= 'Z') goto yy212;
		if (yych <= '`') goto yy61;
		if (yych <= 'z') goto yy212;
		goto yy61;
	}
yy187:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy214;
	goto yy61;
yy188:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy188;
	} else {
		if (yych <= '9') goto yy188;
		if (yych <= '@') goto yy189;
		if (yych <= 'a') goto yy188;
	}
yy189:
#line 250 "src/mwlib/_uscan.re"
	{RET(t_urllink);}
#line 1467 "src/mwlib/_uscan.cc"
yy190:
	++YYCURSOR;
#line 257 "src/mwlib/_uscan.re"
	{RET(t_magicword);}
#line 1472 "src/mwlib/_uscan.cc"
yy191:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy101;
	goto yy61;
yy192:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy215;
	goto yy61;
yy193:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy216;
	goto yy61;
yy194:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy217;
	goto yy61;
yy195:
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy218;
	goto yy61;
yy196:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy219;
	goto yy61;
yy197:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy220;
	goto yy61;
yy198:
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy221;
	goto yy61;
yy199:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy222;
	if (yych == '_') goto yy164;
	goto yy61;
yy200:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy223;
	goto yy61;
yy201:
	yych = *++YYCURSOR;
	if (yych <= '>') {
		if (yych <= '%') {
			if (yych <= '"') goto yy202;
			if (yych <= '$') goto yy201;
		} else {
			if (yych <= ':') goto yy201;
			if (yych == '=') goto yy201;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy201;
			if (yych == '_') goto yy201;
		} else {
			if (yych == '|') goto yy202;
			if (yych <= '~') goto yy201;
		}
	}
yy202:
#line 253 "src/mwlib/_uscan.re"
	{RET(t_http_url);}
#line 1536 "src/mwlib/_uscan.cc"
yy203:
	yych = *++YYCURSOR;
	if (yych <= '>') {
		if (yych <= '"') {
			if (yych == '!') goto yy224;
			goto yy61;
		} else {
			if (yych == '<') goto yy61;
			if (yych <= '=') goto yy224;
			goto yy61;
		}
	} else {
		if (yych <= '\\') {
			if (yych == '[') goto yy61;
			goto yy224;
		} else {
			if (yych <= ']') goto yy61;
			if (yych == 0x007F) goto yy61;
			goto yy224;
		}
	}
yy204:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '-') goto yy205;
		if (yych <= '9') goto yy204;
	} else {
		if (yych <= 'Z') goto yy204;
		if (yych <= '`') goto yy205;
		if (yych <= 'z') goto yy204;
	}
yy205:
#line 249 "src/mwlib/_uscan.re"
	{RET(t_http_url);}
#line 1571 "src/mwlib/_uscan.cc"
yy206:
	yych = *++YYCURSOR;
	if (yych == '@') goto yy61;
	goto yy227;
yy207:
	yych = *++YYCURSOR;
yy208:
	if (yych <= '/') {
		if (yych == '-') goto yy228;
		goto yy61;
	} else {
		if (yych <= '9') goto yy207;
		if (yych <= '`') goto yy61;
		if (yych <= 'z') goto yy207;
		goto yy61;
	}
yy209:
	yych = *++YYCURSOR;
	if (yych <= '>') {
		if (yych <= '%') {
			if (yych <= '"') goto yy210;
			if (yych <= '$') goto yy209;
		} else {
			if (yych <= ':') goto yy209;
			if (yych == '=') goto yy209;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy209;
			if (yych == '_') goto yy209;
		} else {
			if (yych == '|') goto yy210;
			if (yych <= '~') goto yy209;
		}
	}
yy210:
#line 252 "src/mwlib/_uscan.re"
	{RET(t_urllink);}
#line 1610 "src/mwlib/_uscan.cc"
yy211:
	yych = *++YYCURSOR;
	if (yych <= '>') {
		if (yych <= '"') {
			if (yych == '!') goto yy229;
			goto yy61;
		} else {
			if (yych == '<') goto yy61;
			if (yych <= '=') goto yy229;
			goto yy61;
		}
	} else {
		if (yych <= '\\') {
			if (yych == '[') goto yy61;
			goto yy229;
		} else {
			if (yych <= ']') goto yy61;
			if (yych == 0x007F) goto yy61;
			goto yy229;
		}
	}
yy212:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '-') goto yy213;
		if (yych <= '9') goto yy212;
	} else {
		if (yych <= 'Z') goto yy212;
		if (yych <= '`') goto yy213;
		if (yych <= 'z') goto yy212;
	}
yy213:
#line 248 "src/mwlib/_uscan.re"
	{RET(t_urllink);}
#line 1645 "src/mwlib/_uscan.cc"
yy214:
	yych = *++YYCURSOR;
	if (yych == '@') goto yy61;
	goto yy232;
yy215:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy233;
	goto yy61;
yy216:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy234;
	goto yy61;
yy217:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy235;
	goto yy61;
yy218:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy236;
	goto yy61;
yy219:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy237;
	goto yy61;
yy220:
	yych = *++YYCURSOR;
	if (yych == 'X') goto yy139;
	goto yy61;
yy221:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy238;
	goto yy61;
yy222:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy239;
	goto yy61;
yy223:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy240;
	goto yy61;
yy224:
	yych = *++YYCURSOR;
	if (yych <= '>') {
		if (yych <= '"') {
			if (yych == '!') goto yy224;
		} else {
			if (yych == '<') goto yy225;
			if (yych <= '=') goto yy224;
		}
	} else {
		if (yych <= '\\') {
			if (yych != '[') goto yy224;
		} else {
			if (yych <= ']') goto yy225;
			if (yych != 0x007F) goto yy224;
		}
	}
yy225:
#line 256 "src/mwlib/_uscan.re"
	{RET(t_http_url);}
#line 1706 "src/mwlib/_uscan.cc"
yy226:
	yych = *++YYCURSOR;
yy227:
	if (yych <= '9') {
		if (yych <= '\'') {
			if (yych == '!') goto yy226;
			if (yych <= '"') goto yy61;
			goto yy226;
		} else {
			if (yych <= ')') goto yy61;
			if (yych == ',') goto yy61;
			goto yy226;
		}
	} else {
		if (yych <= '?') {
			if (yych == '=') goto yy226;
			if (yych <= '>') goto yy61;
			goto yy226;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy241;
				goto yy226;
			} else {
				if (yych <= ']') goto yy61;
				if (yych <= '~') goto yy226;
				goto yy61;
			}
		}
	}
yy228:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy61;
	if (yych <= '9') goto yy242;
	goto yy61;
yy229:
	yych = *++YYCURSOR;
	if (yych <= '>') {
		if (yych <= '"') {
			if (yych == '!') goto yy229;
		} else {
			if (yych == '<') goto yy230;
			if (yych <= '=') goto yy229;
		}
	} else {
		if (yych <= '\\') {
			if (yych != '[') goto yy229;
		} else {
			if (yych <= ']') goto yy230;
			if (yych != 0x007F) goto yy229;
		}
	}
yy230:
#line 254 "src/mwlib/_uscan.re"
	{RET(t_urllink);}
#line 1761 "src/mwlib/_uscan.cc"
yy231:
	yych = *++YYCURSOR;
yy232:
	if (yych <= '9') {
		if (yych <= '\'') {
			if (yych == '!') goto yy231;
			if (yych <= '"') goto yy61;
			goto yy231;
		} else {
			if (yych <= ')') goto yy61;
			if (yych == ',') goto yy61;
			goto yy231;
		}
	} else {
		if (yych <= '?') {
			if (yych == '=') goto yy231;
			if (yych <= '>') goto yy61;
			goto yy231;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy243;
				goto yy231;
			} else {
				if (yych <= ']') goto yy61;
				if (yych <= '~') goto yy231;
				goto yy61;
			}
		}
	}
yy233:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy244;
	goto yy61;
yy234:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy245;
	goto yy61;
yy235:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy246;
	goto yy61;
yy236:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy247;
	goto yy61;
yy237:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy236;
	goto yy61;
yy238:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy248;
	goto yy61;
yy239:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy139;
	goto yy61;
yy240:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy249;
	goto yy61;
yy241:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '.') {
			if (yych <= ',') goto yy61;
			goto yy250;
		} else {
			if (yych <= '/') goto yy61;
			if (yych <= '9') goto yy250;
			goto yy61;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy250;
			if (yych <= '^') goto yy61;
			goto yy250;
		} else {
			if (yych <= '`') goto yy61;
			if (yych <= 'z') goto yy250;
			goto yy61;
		}
	}
yy242:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy252;
	if (yych <= '/') goto yy61;
	if (yych <= '9') goto yy242;
	goto yy61;
yy243:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '.') {
			if (yych <= ',') goto yy61;
			goto yy253;
		} else {
			if (yych <= '/') goto yy61;
			if (yych <= '9') goto yy253;
			goto yy61;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy253;
			if (yych <= '^') goto yy61;
			goto yy253;
		} else {
			if (yych <= '`') goto yy61;
			if (yych <= 'z') goto yy253;
			goto yy61;
		}
	}
yy244:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy255;
	goto yy61;
yy245:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy238;
	goto yy61;
yy246:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy256;
	goto yy61;
yy247:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy139;
	goto yy61;
yy248:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy257;
	goto yy61;
yy249:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy258;
	goto yy61;
yy250:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '.') {
			if (yych >= '-') goto yy250;
		} else {
			if (yych <= '/') goto yy251;
			if (yych <= '9') goto yy250;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy250;
			if (yych >= '_') goto yy250;
		} else {
			if (yych <= '`') goto yy251;
			if (yych <= 'z') goto yy250;
		}
	}
yy251:
#line 247 "src/mwlib/_uscan.re"
	{RET(t_http_url);}
#line 1918 "src/mwlib/_uscan.cc"
yy252:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy61;
	goto yy260;
yy253:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '.') {
			if (yych >= '-') goto yy253;
		} else {
			if (yych <= '/') goto yy254;
			if (yych <= '9') goto yy253;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy253;
			if (yych >= '_') goto yy253;
		} else {
			if (yych <= '`') goto yy254;
			if (yych <= 'z') goto yy253;
		}
	}
yy254:
#line 246 "src/mwlib/_uscan.re"
	{RET(t_urllink);}
#line 1944 "src/mwlib/_uscan.cc"
yy255:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy261;
	goto yy61;
yy256:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy262;
	goto yy61;
yy257:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy263;
	goto yy61;
yy258:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy264;
	goto yy61;
yy259:
	yych = *++YYCURSOR;
yy260:
	if (yych <= '/') {
		if (yych == '-') goto yy265;
		goto yy61;
	} else {
		if (yych <= '9') goto yy259;
		if (yych <= '`') goto yy61;
		if (yych <= 'f') goto yy259;
		goto yy61;
	}
yy261:
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy266;
	goto yy61;
yy262:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy267;
	goto yy61;
yy263:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy268;
	goto yy61;
yy264:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy269;
	goto yy61;
yy265:
	yych = *++YYCURSOR;
	if (yych == 'Q') goto yy270;
	goto yy61;
yy266:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy271;
	goto yy61;
yy267:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy272;
	goto yy61;
yy268:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy149;
	goto yy61;
yy269:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy273;
	goto yy61;
yy270:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy274;
	goto yy61;
yy271:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy275;
	goto yy61;
yy272:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy139;
	goto yy61;
yy273:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy276;
	goto yy61;
yy274:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy277;
	goto yy61;
yy275:
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy139;
	goto yy61;
yy276:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy278;
	goto yy61;
yy277:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy279;
	goto yy61;
yy278:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy280;
	goto yy61;
yy279:
	yych = *++YYCURSOR;
	if (yych == 0x007F) goto yy281;
	goto yy61;
yy280:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy139;
	goto yy61;
yy281:
	++YYCURSOR;
#line 259 "src/mwlib/_uscan.re"
	{RET(t_uniq);}
#line 2057 "src/mwlib/_uscan.cc"
}
#line 317 "src/mwlib/_uscan.re"

}


PyObject *py_scan(PyObject *self, PyObject *args) {
    PyObject *arg1;
    if (!PyArg_ParseTuple(args, "U:mwlib._uscan.scan", &arg1)) {
        return 0;
    }
    Py_UCS4 *start = PyUnicode_AsUCS4Copy(arg1);
    if (start == NULL) {
        return NULL;
    }
    Py_UCS4 *end = start + PyUnicode_GetLength(arg1);

    Scanner scanner(start, end);
    Py_BEGIN_ALLOW_THREADS
    while (scanner.scan()) {
    }
    Py_END_ALLOW_THREADS
            PyMem_Free(start);
    // return PyList_New(0); // uncomment to see timings for scanning

    int size = scanner.tokens.size();
    PyObject *result = PyList_New(size);
    if (!result) {
        return 0;
    }

    for (int i = 0; i < size; i++) {
        Token t = scanner.tokens[i];
        PyList_SET_ITEM(result, i, Py_BuildValue("iii", t.type, t.start, t.len));
    }

    return result;
}

static PyMethodDef module_functions[] = {
        {"scan", (PyCFunction) py_scan, METH_VARARGS, "scan(text)"},
        {0,      0},
};

static struct PyModuleDef uscanmodule = {
        PyModuleDef_HEAD_INIT,
        "_uscan", /* name of module */
        NULL,     /* module documentation, may be NULL */
        -1,       /* size of per-interpreter state of the module,
                 or -1 if the module keeps state in global variables. */
        module_functions,
};

PyMODINIT_FUNC
PyInit__uscan() {
    return PyModule_Create(&uscanmodule);
}
