# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class RampUpRule(Model):
    """
    Routing rules for ramp up testing. This rule allows to redirect static
    traffic % to a slot or to gradually change routing % based on performance

    :param action_host_name: Hostname of a slot to which the traffic will be
     redirected if decided to. E.g. mysite-stage.azurewebsites.net
    :type action_host_name: str
    :param reroute_percentage: Percentage of the traffic which will be
     redirected to
     {Microsoft.Web.Hosting.Administration.RampUpRule.ActionHostName}
    :type reroute_percentage: float
    :param change_step: [Optional] In auto ramp up scenario this is the step
     to to add/remove from
     {Microsoft.Web.Hosting.Administration.RampUpRule.ReroutePercentage}
     until it reaches
     {Microsoft.Web.Hosting.Administration.RampUpRule.MinReroutePercentage}
     or
     {Microsoft.Web.Hosting.Administration.RampUpRule.MaxReroutePercentage}.
     Site metrics are checked every N minutes specificed in
     {Microsoft.Web.Hosting.Administration.RampUpRule.ChangeIntervalInMinutes}.
     Custom decision algorithm can be provided in TiPCallback site
     extension which Url can be specified in
     {Microsoft.Web.Hosting.Administration.RampUpRule.ChangeDecisionCallbackUrl}
    :type change_step: float
    :param change_interval_in_minutes: [Optional] Specifies interval in
     mimuntes to reevaluate ReroutePercentage
    :type change_interval_in_minutes: int
    :param min_reroute_percentage: [Optional] Specifies lower boundary above
     which ReroutePercentage will stay.
    :type min_reroute_percentage: float
    :param max_reroute_percentage: [Optional] Specifies upper boundary below
     which ReroutePercentage will stay.
    :type max_reroute_percentage: float
    :param change_decision_callback_url: Custom decision algorithm can be
     provided in TiPCallback site extension which Url can be specified. See
     TiPCallback site extension for the scaffold and contracts.
     https://www.siteextensions.net/packages/TiPCallback/
    :type change_decision_callback_url: str
    :param name: Name of the routing rule. The recommended name would be to
     point to the slot which will receive the traffic in the experiment.
    :type name: str
    """ 

    _attribute_map = {
        'action_host_name': {'key': 'actionHostName', 'type': 'str'},
        'reroute_percentage': {'key': 'reroutePercentage', 'type': 'float'},
        'change_step': {'key': 'changeStep', 'type': 'float'},
        'change_interval_in_minutes': {'key': 'changeIntervalInMinutes', 'type': 'int'},
        'min_reroute_percentage': {'key': 'minReroutePercentage', 'type': 'float'},
        'max_reroute_percentage': {'key': 'maxReroutePercentage', 'type': 'float'},
        'change_decision_callback_url': {'key': 'changeDecisionCallbackUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, action_host_name=None, reroute_percentage=None, change_step=None, change_interval_in_minutes=None, min_reroute_percentage=None, max_reroute_percentage=None, change_decision_callback_url=None, name=None, **kwargs):
        self.action_host_name = action_host_name
        self.reroute_percentage = reroute_percentage
        self.change_step = change_step
        self.change_interval_in_minutes = change_interval_in_minutes
        self.min_reroute_percentage = min_reroute_percentage
        self.max_reroute_percentage = max_reroute_percentage
        self.change_decision_callback_url = change_decision_callback_url
        self.name = name
