# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ResourceMetric(Model):
    """
    Object representing a metric for any resource

    :param name: Name of metric
    :type name: :class:`ResourceMetricName
     <azure.mgmt.web.models.ResourceMetricName>`
    :param unit: Metric unit
    :type unit: str
    :param time_grain: Metric granularity. E.g PT1H, PT5M, P1D
    :type time_grain: str
    :param start_time: Metric start time
    :type start_time: datetime
    :param end_time: Metric end time
    :type end_time: datetime
    :param resource_id: Metric resource Id
    :type resource_id: str
    :param metric_values: Metric values
    :type metric_values: list of :class:`ResourceMetricValue
     <azure.mgmt.web.models.ResourceMetricValue>`
    :param properties: Properties
    :type properties: list of :class:`KeyValuePairStringString
     <azure.mgmt.web.models.KeyValuePairStringString>`
    """ 

    _attribute_map = {
        'name': {'key': 'name', 'type': 'ResourceMetricName'},
        'unit': {'key': 'unit', 'type': 'str'},
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'metric_values': {'key': 'metricValues', 'type': '[ResourceMetricValue]'},
        'properties': {'key': 'properties', 'type': '[KeyValuePairStringString]'},
    }

    def __init__(self, name=None, unit=None, time_grain=None, start_time=None, end_time=None, resource_id=None, metric_values=None, properties=None, **kwargs):
        self.name = name
        self.unit = unit
        self.time_grain = time_grain
        self.start_time = start_time
        self.end_time = end_time
        self.resource_id = resource_id
        self.metric_values = metric_values
        self.properties = properties
