# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class VirtualIPMapping(Model):
    """
    Class that represents a VIP mapping

    :param virtual_ip: Virtual IP address
    :type virtual_ip: str
    :param internal_http_port: Internal HTTP port
    :type internal_http_port: int
    :param internal_https_port: Internal HTTPS port
    :type internal_https_port: int
    :param in_use: Is VIP mapping in use
    :type in_use: bool
    """ 

    _attribute_map = {
        'virtual_ip': {'key': 'virtualIP', 'type': 'str'},
        'internal_http_port': {'key': 'internalHttpPort', 'type': 'int'},
        'internal_https_port': {'key': 'internalHttpsPort', 'type': 'int'},
        'in_use': {'key': 'inUse', 'type': 'bool'},
    }

    def __init__(self, virtual_ip=None, internal_http_port=None, internal_https_port=None, in_use=None, **kwargs):
        self.virtual_ip = virtual_ip
        self.internal_http_port = internal_http_port
        self.internal_https_port = internal_https_port
        self.in_use = in_use
