/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive_grid_cloud_portal.studio;

import java.io.IOException;
import java.security.KeyException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.LoginException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.providers.multipart.MultipartForm;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;
import org.ow2.proactive.authentication.UserData;
import org.ow2.proactive_grid_cloud_portal.common.dto.LoginForm;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobIdData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobValidationData;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.JobCreationRestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.NotConnectedRestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.PermissionRestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.RestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.SchedulerRestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.SubmissionClosedRestException;
import org.ow2.proactive_grid_cloud_portal.studio.Script;
import org.ow2.proactive_grid_cloud_portal.studio.Workflow;

@Path(value="/studio")
@Produces(value={"application/json"})
public interface StudioInterface {
    @POST
    @Path(value="login")
    public String login(@FormParam(value="username") String var1, @FormParam(value="password") String var2) throws KeyException, LoginException, SchedulerRestException;

    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="login")
    public String loginWithCredential(@MultipartForm LoginForm var1) throws IOException, KeyException, LoginException, SchedulerRestException;

    @PUT
    @Path(value="logout")
    public void logout(@HeaderParam(value="sessionid") String var1) throws RestException;

    @GET
    @Path(value="connected")
    public boolean isConnected(@HeaderParam(value="sessionid") String var1);

    @GET
    @Path(value="currentuser")
    public String currentUser(@HeaderParam(value="sessionid") String var1);

    @GET
    @Path(value="currentuserdata")
    public UserData currentUserData(@HeaderParam(value="sessionid") String var1);

    @GET
    @Path(value="domains")
    @Produces(value={"application/json"})
    public List<String> getDomains();

    @GET
    @Path(value="workflows")
    public List<Workflow> getWorkflows(@HeaderParam(value="sessionid") String var1) throws NotConnectedRestException, IOException;

    @POST
    @Path(value="workflows")
    @Consumes(value={"application/json"})
    public Workflow createWorkflow(@HeaderParam(value="sessionid") String var1, Workflow var2) throws NotConnectedRestException, IOException;

    @GET
    @Path(value="workflows/{id}")
    @Produces(value={"application/json"})
    public Workflow getWorkflow(@HeaderParam(value="sessionid") String var1, @PathParam(value="id") String var2) throws NotConnectedRestException, IOException;

    @GET
    @Path(value="workflows/{id}/xml")
    @Produces(value={"application/xml"})
    public String getWorkflowXmlContent(@HeaderParam(value="sessionid") String var1, @PathParam(value="id") String var2) throws NotConnectedRestException, IOException;

    @PUT
    @Path(value="workflows/{id}")
    @Consumes(value={"application/json"})
    public Workflow updateWorkflow(@HeaderParam(value="sessionid") String var1, @PathParam(value="id") String var2, Workflow var3) throws NotConnectedRestException, IOException;

    @DELETE
    @Path(value="workflows/{id}")
    public void deleteWorkflow(@HeaderParam(value="sessionid") String var1, @PathParam(value="id") String var2) throws NotConnectedRestException, IOException;

    @DELETE
    @Path(value="workflows")
    public void deleteAllWorkflows(@HeaderParam(value="sessionid") String var1, @QueryParam(value="workflowName") @DefaultValue(value="") String var2) throws NotConnectedRestException, IOException;

    @GET
    @Path(value="scripts")
    public List<Script> getScripts(@HeaderParam(value="sessionid") String var1) throws NotConnectedRestException, IOException;

    @POST
    @Path(value="scripts")
    public String createScript(@HeaderParam(value="sessionid") String var1, @FormParam(value="name") String var2, @FormParam(value="content") String var3) throws NotConnectedRestException, IOException;

    @POST
    @Path(value="scripts/{name}")
    public String updateScript(@HeaderParam(value="sessionid") String var1, @PathParam(value="name") String var2, @FormParam(value="content") String var3) throws NotConnectedRestException, IOException;

    @GET
    @Path(value="classes")
    public ArrayList<String> getClasses(@HeaderParam(value="sessionid") String var1) throws NotConnectedRestException;

    @POST
    @Path(value="classes")
    @Consumes(value={"multipart/form-data"})
    public String createClass(@HeaderParam(value="sessionid") String var1, MultipartFormDataInput var2) throws NotConnectedRestException, IOException;

    @POST
    @Path(value="{path:validate}")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public JobValidationData validate(@HeaderParam(value="sessionid") String var1, @PathParam(value="path") PathSegment var2, MultipartFormDataInput var3) throws NotConnectedRestException;

    @POST
    @Path(value="{path:submit}")
    @Consumes(value={"multipart/form-data"})
    public JobIdData submit(@HeaderParam(value="sessionid") String var1, @PathParam(value="path") PathSegment var2, MultipartFormDataInput var3, @Context UriInfo var4) throws JobCreationRestException, NotConnectedRestException, PermissionRestException, SubmissionClosedRestException, IOException;

    @POST
    @Path(value="{path:plannings}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String submitPlannings(@HeaderParam(value="sessionid") String var1, @PathParam(value="path") PathSegment var2, Map<String, String> var3) throws JobCreationRestException, NotConnectedRestException, PermissionRestException, SubmissionClosedRestException, IOException;

    @GET
    @Path(value="visualizations/{id}")
    public String getVisualization(@HeaderParam(value="sessionid") String var1, @PathParam(value="id") String var2) throws NotConnectedRestException, IOException;

    @POST
    @Path(value="visualizations/{id}")
    public boolean updateVisualization(@HeaderParam(value="sessionid") String var1, @PathParam(value="id") String var2, @FormParam(value="visualization") String var3) throws NotConnectedRestException, IOException;
}

