/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job;

import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.joda.time.format.ISODateTimeFormat;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.scheduler.common.job.JobDeadline;
import org.ow2.proactive.scheduler.common.job.JobId;
import org.ow2.proactive.scheduler.common.job.JobPriority;
import org.ow2.proactive.scheduler.common.job.JobType;
import org.ow2.proactive.scheduler.common.job.JobVariable;
import org.ow2.proactive.scheduler.common.task.CommonAttribute;
import org.ow2.proactive.scheduler.common.task.util.IntegerWrapper;
import org.ow2.proactive.scheduler.common.util.LogFormatter;

@PublicAPI
public abstract class Job
extends CommonAttribute {
    private static final Logger LOGGER = Logger.getLogger(Job.class);
    public static final String JOB_DDL = "JOB_DDL";
    public static final String JOB_EXEC_TIME = "JOB_EXEC_TIME";
    protected String name = "NOT SET";
    protected String description = "";
    protected String projectName = "";
    protected String bucketName = "";
    protected String label = "";
    protected Set<String> workflowTags = new HashSet<String>();
    protected JobPriority priority = JobPriority.NORMAL;
    protected String inputSpace = null;
    protected String outputSpace = null;
    protected String globalSpace = null;
    protected String userSpace = null;
    protected String visualization = null;
    protected Map<String, JobVariable> variables = Collections.synchronizedMap(new LinkedHashMap());
    protected Map<String, JobVariable> unresolvedVariables = Collections.synchronizedMap(new LinkedHashMap());
    protected Map<String, JobVariable> globalVariables = Collections.synchronizedMap(new LinkedHashMap());
    protected Map<String, String> globalGenericInformation = new LinkedHashMap<String, String>();
    private String jobContent = null;
    private Long parentId = null;
    protected String submissionMode = "";
    protected Long startAt = null;
    private static final long serialVersionUID = 142L;

    public abstract JobType getType();

    public abstract JobId getId();

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JobPriority getPriority() {
        return this.priority;
    }

    public void setPriority(JobPriority priority) {
        this.priority = priority;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getLabel() {
        return this.label;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Set<String> getWorkflowTags() {
        return this.workflowTags;
    }

    public void setWorkflowTags(Set<String> workflowTags) {
        this.workflowTags = workflowTags;
    }

    public String getInputSpace() {
        return this.inputSpace;
    }

    public void setInputSpace(String inputSpace) {
        this.inputSpace = inputSpace;
    }

    public String getOutputSpace() {
        return this.outputSpace;
    }

    public void setOutputSpace(String outputSpace) {
        this.outputSpace = outputSpace;
    }

    public String getGlobalSpace() {
        return this.globalSpace;
    }

    public void setGlobalSpace(String globalSpace) {
        this.globalSpace = globalSpace;
    }

    public String getUserSpace() {
        return this.userSpace;
    }

    public void setUserSpace(String userSpace) {
        this.userSpace = userSpace;
    }

    public String getVisualization() {
        return this.visualization;
    }

    public void setVisualization(String visualization) {
        this.visualization = visualization;
    }

    public void setVariables(Map<String, JobVariable> variables) {
        Job.verifyVariableMap(variables);
        this.variables = Collections.synchronizedMap(new LinkedHashMap<String, JobVariable>(variables));
    }

    public void setUnresolvedVariables(Map<String, JobVariable> unresolvedVariables) {
        Job.verifyVariableMap(unresolvedVariables);
        this.unresolvedVariables = Collections.synchronizedMap(new LinkedHashMap<String, JobVariable>(unresolvedVariables));
    }

    public static void verifyVariableMap(Map<String, ? extends JobVariable> variables) {
        for (Map.Entry<String, ? extends JobVariable> entry : variables.entrySet()) {
            if (entry.getKey().equals(entry.getValue().getName())) continue;
            throw new IllegalArgumentException("Variables map entry key (" + entry.getKey() + ") is different from variable name (" + entry.getValue().getName() + ")");
        }
    }

    public Map<String, JobVariable> getVariables() {
        return this.variables;
    }

    public Map<String, JobVariable> getUnresolvedVariables() {
        return this.unresolvedVariables;
    }

    public Map<String, JobVariable> getGlobalVariables() {
        return this.globalVariables;
    }

    public void setGlobalVariables(Map<String, JobVariable> globalVariables) {
        this.globalVariables = Collections.synchronizedMap(globalVariables);
    }

    public Map<String, String> getGlobalGenericInformation() {
        return this.globalGenericInformation;
    }

    public void setGlobalGenericInformation(Map<String, String> globalGenericInformation) {
        this.globalGenericInformation = globalGenericInformation;
    }

    public Map<String, String> getVariablesAsReplacementMap() {
        LinkedHashMap<String, String> replacementVariables = new LinkedHashMap<String, String>(this.variables.size());
        for (JobVariable variable : this.variables.values()) {
            replacementVariables.put(variable.getName(), variable.getValue());
        }
        return replacementVariables;
    }

    public Long getStartAt() {
        return this.startAt;
    }

    public void setStartAt(Long startAt) {
        this.startAt = startAt;
    }

    public String toString() {
        return this.name;
    }

    public String display() {
        return "Job '" + this.name + "' : " + System.lineSeparator() + LogFormatter.addIndent(Stream.of(LogFormatter.lineWithQuotes("Description", this.description), LogFormatter.lineWithQuotes("ProjectName", this.projectName), LogFormatter.lineWithQuotes("workflowTags", this.workflowTags), LogFormatter.line("onTaskError", this.onTaskError), LogFormatter.line("restartTaskOnError", this.restartTaskOnError), LogFormatter.line("taskRetryDelay", this.taskRetryDelay), LogFormatter.line("maxNumberOfExecution", this.maxNumberOfExecution, () -> ((IntegerWrapper)this.maxNumberOfExecution.getValue()).getIntegerValue()), LogFormatter.line("genericInformation", this.genericInformation), LogFormatter.line("Priority", this.priority), LogFormatter.lineWithQuotes("InputSpace", this.inputSpace), LogFormatter.lineWithQuotes("OutputSpace", this.outputSpace), LogFormatter.lineWithQuotes("GlobalSpace", this.globalSpace), LogFormatter.lineWithQuotes("UserSpace", this.userSpace), LogFormatter.line("Variables", this.variables)).filter(s -> !s.isEmpty()).collect(Collectors.joining(System.lineSeparator())));
    }

    public Optional<JobDeadline> getJobDeadline() {
        if (this.genericInformation.containsKey(JOB_DDL)) {
            String strJobDeadline = (String)this.genericInformation.get(JOB_DDL);
            try {
                if (strJobDeadline.startsWith("+")) {
                    return Optional.of(new JobDeadline(JobDeadline.parseDuration(strJobDeadline.substring(1)).get()));
                }
                return Optional.of(new JobDeadline(ISODateTimeFormat.dateTimeNoMillis().parseDateTime(strJobDeadline).toDate()));
            }
            catch (Exception e) {
                LOGGER.warn((Object)("Imposible to parse JOB_DDL GI variable as deadline: " + strJobDeadline));
            }
        }
        return Optional.empty();
    }

    public Optional<Duration> getJobExpectedExecutionTime() {
        if (this.genericInformation.containsKey(JOB_EXEC_TIME)) {
            String strJobExecTime = (String)this.genericInformation.get(JOB_EXEC_TIME);
            try {
                return Optional.of(JobDeadline.parseDuration(strJobExecTime).get());
            }
            catch (Exception e) {
                LOGGER.warn((Object)("Imposible to parse JOB_EXEC_TIME GI variable as `HH:MM:SS`: " + strJobExecTime));
            }
        }
        return Optional.empty();
    }

    public String getJobContent() {
        return this.jobContent;
    }

    public void setJobContent(String jobContent) {
        this.jobContent = jobContent;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getSubmissionMode() {
        return this.submissionMode;
    }

    public void setSubmissionMode(String submissionMode) {
        this.submissionMode = submissionMode;
    }
}

