# -*- coding: utf-8 -*-
#
# BigBrotherBot(B3) (www.bigbrotherbot.net)
# Copyright (C) 2010 BigBrotherBot
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
#
# CHANGELOG:
# 2010/02/20 - 1.1 - Courgette
#    * fix convertion from level to group name for unexpected level numbers
#    * cosmetics to the html export
#    * add maxlevel setting to hide commands reserved to high levels
# 2010/02/23 - 1.2 - Courgette
#    * make the html export validate the W3C test
#    * hide the maxLevel column on the html export
# 2010/02/25 - 1.2.1 - Courgette
#    * fix Internet Explorer issues with logo in html export
#    * remove any use the sets module
# 2010/02/26 - 1.2.2 - Courgette
#    * fix bug making commands with alias appear twice in the results
# 2010/03/07 - 1.2.3 - Courgette
#   * make the html export pass the W3C tests
# 2010/08/25 - 1.2.4 - Courgette
#   * do not fail if 'destination' is found in config but empty
# 2011/05/11 - 1.2.5 - Courgette
#   * update B3 website URL

""" 
This module will generate a user documentation depending
on current config
"""

__author__    = 'Courgette'
__version__ = '1.2.5'

import time, os, StringIO, string, re
from xml.dom.minidom import Document
from ftplib import FTP
from cgi import escape
from b3 import getConfPath
from b3.functions import splitDSN

class DocBuilder:
    _supportedExportType = ['xml','html', 'htmltable']
    _console = None
    _adminPlugin = None
    _outputType = 'html'
    _outputUrl = 'file://' + getConfPath() + '/b3doc.html'
    _maxlevel = None
    
    def __init__(self, console):
        self._console = console
        self._outputDir = getConfPath()
        self._adminPlugin = self._console.getPlugin('admin')
        if self._adminPlugin is None:
            raise Exception('AUTODOC: cannot generate documentation without the admin plugin')
                
        if self._console.config.has_section('autodoc'):
            if self._console.config.has_option('autodoc','destination'):
                dest = self._console.config.get('autodoc','destination')
                if dest is None:
                    self._console.warning('AUTODOC: destination found but empty. using default')
                else:
                    if dest.startswith('ftp://') or dest.startswith('file://'):
                        self._outputUrl = dest
                    else:
                        # assume file
                        self._outputUrl = 'file://' + self._console.config.getpath('autodoc', 'destination')
        
            if self._console.config.has_option('autodoc','type'):
                self._outputType = self._console.config.get('autodoc','type')
    
            if self._console.config.has_option('autodoc','maxlevel'):
                self._maxlevel = self._console.config.getint('autodoc','maxlevel')
    
    
    def save(self):
        if self._outputType not in self._supportedExportType:
            self._console.error('AUTODOC: %s type of doc unsupported' % self._outputType)
            self._console.info('AUTODOC: supported doc types are : %s' % ", ".join(self._supportedExportType))
        else:
            self._console.debug('AUTODOC: saving %s documentation' % self._outputType)
            if self._outputType == 'xml':
                self._write(self.getXml())
            elif self._outputType == 'html':
                self._write(self.getHtml())
            elif self._outputType == 'htmltable':
                self._write(self.getHtmlTable())
        
    
    def getXml(self):
        xml = Document()
        xDoc = xml.createElement("b3doc")
        xDoc.setAttribute("time", time.asctime())
        xDoc.setAttribute("game", self._console.game.gameName)
        xDoc.setAttribute("address", self._console._publicIp +':'+ str(self._console._port))
        
        xCommands = xml.createElement("b3commands")
        for cmd in self._getCommandsDict():
            xCommand = xml.createElement("b3command")
            xCommand.setAttribute("name", cmd['name'])
            if 'alias' in cmd and cmd['alias'] != '' :
                xCommand.setAttribute("alias", cmd['alias'])
            xCommand.setAttribute("plugin", cmd['plugin'])
            xCommand.setAttribute("help", cmd['description'])
            xCommand.setAttribute("minlevel", cmd['minlevel'])
            xCommand.setAttribute("maxlevel", cmd['maxlevel'])
            xCommands.appendChild(xCommand)
        xDoc.appendChild(xCommands)
        xml.appendChild(xDoc)
        return xml.toprettyxml(indent="\t")

    def getHtml(self):
        cssstyle = """
            #b3commands {
                border-collapse: collapse;
            }
            
            #b3commands th, #b3commands td {
                font-family: arial;
                border: 2px solid black;
                padding: 5px;
            }
            
            #b3commands th {
                font-weight: bold;
                background-color: lightgray;
                text-transform: capitalize;
            }
            #b3commands td {
                font-size: 12px;
            }
            #b3commands .b3MaxLevel {
                display: none;
            }
            body {
                font-family: tahoma,sans-serif;
                color: #3F3B3B;
                font-size: 12px;
                margin: 0;
            }
            
            #header {
                background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAACWCAYAAAAfduJyAAAAAXNSR0IArs4c6QAAAAZiS0dEAIcAiACHZn+LRgAAAAlwSFlzAAALEgAACxIB0t1+/AAAAAd0SU1FB9oCGRQCLt1vun0AAAAZdEVYdENvbW1lbnQAQ3JlYXRlZCB3aXRoIEdJTVBXgQ4XAAAAqklEQVQoz3WSwRXDMAhDv7RKZ8jIXagL0QMxNo5zgycBQsDv+wmu6woLMBKWhIEWUYBGypJyKBOWRirAgbDFjd7TRoM5PMkSdgEUIAmHAhs3IMnViiZo15cyahmPikXLIXKSaZ3ZRrbNI3lP8muDxWcJE8Iyj41CDIdoFRKYcM09eT+HTzfqAIqesq5FGKPAThnly3buecHXcy8bPT8nI1e0K32rULT242P/N0QVV4uoqV8AAAAASUVORK5CYII=) repeat-x;
                height: 150px;
            }
            #logo {
                margin: 0 auto;
                width: 950px;
                height: 150px;
                cursor: pointer;
            }
            #logo img {
                border: 0;
            }
            #bodyarea {
                background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAAZCAIAAACUxWgrAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAADlJREFUeNpi/P//PwMDAxMDGLC8fv4cRDEyMoIoBgjFiJViAulhYULhESHHhKoSG4ViLdRlUAogwADulwZZy1%2BP%2BAAAAABJRU5ErkJggg%3D%3D) repeat-x scroll 0 0 #FFFFFF;
                padding: 10px 0 20px 20px;
            }
            #bodyarea h1 {
                color: #C1930B;
            }
            #bodyarea table th.header {
                background-image: url(data:image/gif;base64,R0lGODlhFQAJAIAAACMtMP///yH5BAEAAAEALAAAAAAVAAkAAAIXjI+AywnaYnhUMoqt3gZXPmVg94yJVQAAOw==);
                background-position: right center;
                background-repeat: no-repeat;
                padding-right: 16px;
                padding-left: 2px;
            }
            #bodyarea table th.headerSortDown {
                background-color: #C1930B;
                background-image: url(data:image/gif;base64,R0lGODlhFQAEAIAAACMtMP///yH5BAEAAAEALAAAAAAVAAQAAAINjI8Bya2wnINUMopZAQA7);
            }
            #bodyarea table th.headerSortUp {
                background-color: #C1930B;
                background-image: url(data:image/gif;base64,R0lGODlhFQAEAIAAACMtMP///yH5BAEAAAEALAAAAAAVAAQAAAINjB+gC+jP2ptn0WskLQA7);
            }
                """
        
        javascript = """
        //<![CDATA[
/*!
 * jQuery JavaScript Library v1.4.2
 * http://jquery.com/
 *
 * Copyright 2010, John Resig
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * http://jquery.org/license
 *
 * Includes Sizzle.js
 * http://sizzlejs.com/
 * Copyright 2010, The Dojo Foundation
 * Released under the MIT, BSD, and GPL Licenses.
 *
 * Date: Sat Feb 13 22:33:48 2010 -0500
 */
(function(A,w){function ma(){if(!c.isReady){try{s.documentElement.doScroll("left")}catch(a){setTimeout(ma,1);return}c.ready()}}function Qa(a,b){b.src?c.ajax({url:b.src,async:false,dataType:"script"}):c.globalEval(b.text||b.textContent||b.innerHTML||"");b.parentNode&&b.parentNode.removeChild(b)}function X(a,b,d,f,e,j){var i=a.length;if(typeof b==="object"){for(var o in b)X(a,o,b[o],f,e,d);return a}if(d!==w){f=!j&&f&&c.isFunction(d);for(o=0;o<i;o++)e(a[o],b,f?d.call(a[o],o,e(a[o],b)):d,j);return a}return i?
e(a[0],b):w}function J(){return(new Date).getTime()}function Y(){return false}function Z(){return true}function na(a,b,d){d[0].type=a;return c.event.handle.apply(b,d)}function oa(a){var b,d=[],f=[],e=arguments,j,i,o,k,n,r;i=c.data(this,"events");if(!(a.liveFired===this||!i||!i.live||a.button&&a.type==="click")){a.liveFired=this;var u=i.live.slice(0);for(k=0;k<u.length;k++){i=u[k];i.origType.replace(O,"")===a.type?f.push(i.selector):u.splice(k--,1)}j=c(a.target).closest(f,a.currentTarget);n=0;for(r=
j.length;n<r;n++)for(k=0;k<u.length;k++){i=u[k];if(j[n].selector===i.selector){o=j[n].elem;f=null;if(i.preType==="mouseenter"||i.preType==="mouseleave")f=c(a.relatedTarget).closest(i.selector)[0];if(!f||f!==o)d.push({elem:o,handleObj:i})}}n=0;for(r=d.length;n<r;n++){j=d[n];a.currentTarget=j.elem;a.data=j.handleObj.data;a.handleObj=j.handleObj;if(j.handleObj.origHandler.apply(j.elem,e)===false){b=false;break}}return b}}function pa(a,b){return"live."+(a&&a!=="*"?a+".":"")+b.replace(/\\./g,"`").replace(/ /g,
"&")}function qa(a){return!a||!a.parentNode||a.parentNode.nodeType===11}function ra(a,b){var d=0;b.each(function(){if(this.nodeName===(a[d]&&a[d].nodeName)){var f=c.data(a[d++]),e=c.data(this,f);if(f=f&&f.events){delete e.handle;e.events={};for(var j in f)for(var i in f[j])c.event.add(this,j,f[j][i],f[j][i].data)}}})}function sa(a,b,d){var f,e,j;b=b&&b[0]?b[0].ownerDocument||b[0]:s;if(a.length===1&&typeof a[0]==="string"&&a[0].length<512&&b===s&&!ta.test(a[0])&&(c.support.checkClone||!ua.test(a[0]))){e=
true;if(j=c.fragments[a[0]])if(j!==1)f=j}if(!f){f=b.createDocumentFragment();c.clean(a,b,f,d)}if(e)c.fragments[a[0]]=j?f:1;return{fragment:f,cacheable:e}}function K(a,b){var d={};c.each(va.concat.apply([],va.slice(0,b)),function(){d[this]=a});return d}function wa(a){return"scrollTo"in a&&a.document?a:a.nodeType===9?a.defaultView||a.parentWindow:false}var c=function(a,b){return new c.fn.init(a,b)},Ra=A.jQuery,Sa=A.$,s=A.document,T,Ta=/^[^<]*(<[\\w\\W]+>)[^>]*$|^#([\\w-]+)$/,Ua=/^.[^:#\\[\\.,]*$/,Va=/\\S/,
Wa=/^(\\s|\\u00A0)+|(\\s|\\u00A0)+$/g,Xa=/^<(\\w+)\\s*\\/?>(?:<\\/\\1>)?$/,P=navigator.userAgent,xa=false,Q=[],L,$=Object.prototype.toString,aa=Object.prototype.hasOwnProperty,ba=Array.prototype.push,R=Array.prototype.slice,ya=Array.prototype.indexOf;c.fn=c.prototype={init:function(a,b){var d,f;if(!a)return this;if(a.nodeType){this.context=this[0]=a;this.length=1;return this}if(a==="body"&&!b){this.context=s;this[0]=s.body;this.selector="body";this.length=1;return this}if(typeof a==="string")if((d=Ta.exec(a))&&
(d[1]||!b))if(d[1]){f=b?b.ownerDocument||b:s;if(a=Xa.exec(a))if(c.isPlainObject(b)){a=[s.createElement(a[1])];c.fn.attr.call(a,b,true)}else a=[f.createElement(a[1])];else{a=sa([d[1]],[f]);a=(a.cacheable?a.fragment.cloneNode(true):a.fragment).childNodes}return c.merge(this,a)}else{if(b=s.getElementById(d[2])){if(b.id!==d[2])return T.find(a);this.length=1;this[0]=b}this.context=s;this.selector=a;return this}else if(!b&&/^\\w+$/.test(a)){this.selector=a;this.context=s;a=s.getElementsByTagName(a);return c.merge(this,
a)}else return!b||b.jquery?(b||T).find(a):c(b).find(a);else if(c.isFunction(a))return T.ready(a);if(a.selector!==w){this.selector=a.selector;this.context=a.context}return c.makeArray(a,this)},selector:"",jquery:"1.4.2",length:0,size:function(){return this.length},toArray:function(){return R.call(this,0)},get:function(a){return a==null?this.toArray():a<0?this.slice(a)[0]:this[a]},pushStack:function(a,b,d){var f=c();c.isArray(a)?ba.apply(f,a):c.merge(f,a);f.prevObject=this;f.context=this.context;if(b===
"find")f.selector=this.selector+(this.selector?" ":"")+d;else if(b)f.selector=this.selector+"."+b+"("+d+")";return f},each:function(a,b){return c.each(this,a,b)},ready:function(a){c.bindReady();if(c.isReady)a.call(s,c);else Q&&Q.push(a);return this},eq:function(a){return a===-1?this.slice(a):this.slice(a,+a+1)},first:function(){return this.eq(0)},last:function(){return this.eq(-1)},slice:function(){return this.pushStack(R.apply(this,arguments),"slice",R.call(arguments).join(","))},map:function(a){return this.pushStack(c.map(this,
function(b,d){return a.call(b,d,b)}))},end:function(){return this.prevObject||c(null)},push:ba,sort:[].sort,splice:[].splice};c.fn.init.prototype=c.fn;c.extend=c.fn.extend=function(){var a=arguments[0]||{},b=1,d=arguments.length,f=false,e,j,i,o;if(typeof a==="boolean"){f=a;a=arguments[1]||{};b=2}if(typeof a!=="object"&&!c.isFunction(a))a={};if(d===b){a=this;--b}for(;b<d;b++)if((e=arguments[b])!=null)for(j in e){i=a[j];o=e[j];if(a!==o)if(f&&o&&(c.isPlainObject(o)||c.isArray(o))){i=i&&(c.isPlainObject(i)||
c.isArray(i))?i:c.isArray(o)?[]:{};a[j]=c.extend(f,i,o)}else if(o!==w)a[j]=o}return a};c.extend({noConflict:function(a){A.$=Sa;if(a)A.jQuery=Ra;return c},isReady:false,ready:function(){if(!c.isReady){if(!s.body)return setTimeout(c.ready,13);c.isReady=true;if(Q){for(var a,b=0;a=Q[b++];)a.call(s,c);Q=null}c.fn.triggerHandler&&c(s).triggerHandler("ready")}},bindReady:function(){if(!xa){xa=true;if(s.readyState==="complete")return c.ready();if(s.addEventListener){s.addEventListener("DOMContentLoaded",
L,false);A.addEventListener("load",c.ready,false)}else if(s.attachEvent){s.attachEvent("onreadystatechange",L);A.attachEvent("onload",c.ready);var a=false;try{a=A.frameElement==null}catch(b){}s.documentElement.doScroll&&a&&ma()}}},isFunction:function(a){return $.call(a)==="[object Function]"},isArray:function(a){return $.call(a)==="[object Array]"},isPlainObject:function(a){if(!a||$.call(a)!=="[object Object]"||a.nodeType||a.setInterval)return false;if(a.constructor&&!aa.call(a,"constructor")&&!aa.call(a.constructor.prototype,
"isPrototypeOf"))return false;var b;for(b in a);return b===w||aa.call(a,b)},isEmptyObject:function(a){for(var b in a)return false;return true},error:function(a){throw a;},parseJSON:function(a){if(typeof a!=="string"||!a)return null;a=c.trim(a);if(/^[\\],:{}\\s]*$/.test(a.replace(/\\\\(?:["\\\\\\/bfnrt]|u[0-9a-fA-F]{4})/g,"@").replace(/"[^"\\\\\\n\\r]*"|true|false|null|-?\\d+(?:\\.\\d*)?(?:[eE][+\\-]?\\d+)?/g,"]").replace(/(?:^|:|,)(?:\\s*\\[)+/g,"")))return A.JSON&&A.JSON.parse?A.JSON.parse(a):(new Function("return "+
a))();else c.error("Invalid JSON: "+a)},noop:function(){},globalEval:function(a){if(a&&Va.test(a)){var b=s.getElementsByTagName("head")[0]||s.documentElement,d=s.createElement("script");d.type="text/javascript";if(c.support.scriptEval)d.appendChild(s.createTextNode(a));else d.text=a;b.insertBefore(d,b.firstChild);b.removeChild(d)}},nodeName:function(a,b){return a.nodeName&&a.nodeName.toUpperCase()===b.toUpperCase()},each:function(a,b,d){var f,e=0,j=a.length,i=j===w||c.isFunction(a);if(d)if(i)for(f in a){if(b.apply(a[f],
d)===false)break}else for(;e<j;){if(b.apply(a[e++],d)===false)break}else if(i)for(f in a){if(b.call(a[f],f,a[f])===false)break}else for(d=a[0];e<j&&b.call(d,e,d)!==false;d=a[++e]);return a},trim:function(a){return(a||"").replace(Wa,"")},makeArray:function(a,b){b=b||[];if(a!=null)a.length==null||typeof a==="string"||c.isFunction(a)||typeof a!=="function"&&a.setInterval?ba.call(b,a):c.merge(b,a);return b},inArray:function(a,b){if(b.indexOf)return b.indexOf(a);for(var d=0,f=b.length;d<f;d++)if(b[d]===
a)return d;return-1},merge:function(a,b){var d=a.length,f=0;if(typeof b.length==="number")for(var e=b.length;f<e;f++)a[d++]=b[f];else for(;b[f]!==w;)a[d++]=b[f++];a.length=d;return a},grep:function(a,b,d){for(var f=[],e=0,j=a.length;e<j;e++)!d!==!b(a[e],e)&&f.push(a[e]);return f},map:function(a,b,d){for(var f=[],e,j=0,i=a.length;j<i;j++){e=b(a[j],j,d);if(e!=null)f[f.length]=e}return f.concat.apply([],f)},guid:1,proxy:function(a,b,d){if(arguments.length===2)if(typeof b==="string"){d=a;a=d[b];b=w}else if(b&&
!c.isFunction(b)){d=b;b=w}if(!b&&a)b=function(){return a.apply(d||this,arguments)};if(a)b.guid=a.guid=a.guid||b.guid||c.guid++;return b},uaMatch:function(a){a=a.toLowerCase();a=/(webkit)[ \\/]([\\w.]+)/.exec(a)||/(opera)(?:.*version)?[ \\/]([\\w.]+)/.exec(a)||/(msie) ([\\w.]+)/.exec(a)||!/compatible/.test(a)&&/(mozilla)(?:.*? rv:([\\w.]+))?/.exec(a)||[];return{browser:a[1]||"",version:a[2]||"0"}},browser:{}});P=c.uaMatch(P);if(P.browser){c.browser[P.browser]=true;c.browser.version=P.version}if(c.browser.webkit)c.browser.safari=
true;if(ya)c.inArray=function(a,b){return ya.call(b,a)};T=c(s);if(s.addEventListener)L=function(){s.removeEventListener("DOMContentLoaded",L,false);c.ready()};else if(s.attachEvent)L=function(){if(s.readyState==="complete"){s.detachEvent("onreadystatechange",L);c.ready()}};(function(){c.support={};var a=s.documentElement,b=s.createElement("script"),d=s.createElement("div"),f="script"+J();d.style.display="none";d.innerHTML="   <link/><table></table><a href='/a' style='color:red;float:left;opacity:.55;'>a</a><input type='checkbox'/>";
var e=d.getElementsByTagName("*"),j=d.getElementsByTagName("a")[0];if(!(!e||!e.length||!j)){c.support={leadingWhitespace:d.firstChild.nodeType===3,tbody:!d.getElementsByTagName("tbody").length,htmlSerialize:!!d.getElementsByTagName("link").length,style:/red/.test(j.getAttribute("style")),hrefNormalized:j.getAttribute("href")==="/a",opacity:/^0.55$/.test(j.style.opacity),cssFloat:!!j.style.cssFloat,checkOn:d.getElementsByTagName("input")[0].value==="on",optSelected:s.createElement("select").appendChild(s.createElement("option")).selected,
parentNode:d.removeChild(d.appendChild(s.createElement("div"))).parentNode===null,deleteExpando:true,checkClone:false,scriptEval:false,noCloneEvent:true,boxModel:null};b.type="text/javascript";try{b.appendChild(s.createTextNode("window."+f+"=1;"))}catch(i){}a.insertBefore(b,a.firstChild);if(A[f]){c.support.scriptEval=true;delete A[f]}try{delete b.test}catch(o){c.support.deleteExpando=false}a.removeChild(b);if(d.attachEvent&&d.fireEvent){d.attachEvent("onclick",function k(){c.support.noCloneEvent=
false;d.detachEvent("onclick",k)});d.cloneNode(true).fireEvent("onclick")}d=s.createElement("div");d.innerHTML="<input type='radio' name='radiotest' checked='checked'/>";a=s.createDocumentFragment();a.appendChild(d.firstChild);c.support.checkClone=a.cloneNode(true).cloneNode(true).lastChild.checked;c(function(){var k=s.createElement("div");k.style.width=k.style.paddingLeft="1px";s.body.appendChild(k);c.boxModel=c.support.boxModel=k.offsetWidth===2;s.body.removeChild(k).style.display="none"});a=function(k){var n=
s.createElement("div");k="on"+k;var r=k in n;if(!r){n.setAttribute(k,"return;");r=typeof n[k]==="function"}return r};c.support.submitBubbles=a("submit");c.support.changeBubbles=a("change");a=b=d=e=j=null}})();c.props={"for":"htmlFor","class":"className",readonly:"readOnly",maxlength:"maxLength",cellspacing:"cellSpacing",rowspan:"rowSpan",colspan:"colSpan",tabindex:"tabIndex",usemap:"useMap",frameborder:"frameBorder"};var G="jQuery"+J(),Ya=0,za={};c.extend({cache:{},expando:G,noData:{embed:true,object:true,
applet:true},data:function(a,b,d){if(!(a.nodeName&&c.noData[a.nodeName.toLowerCase()])){a=a==A?za:a;var f=a[G],e=c.cache;if(!f&&typeof b==="string"&&d===w)return null;f||(f=++Ya);if(typeof b==="object"){a[G]=f;e[f]=c.extend(true,{},b)}else if(!e[f]){a[G]=f;e[f]={}}a=e[f];if(d!==w)a[b]=d;return typeof b==="string"?a[b]:a}},removeData:function(a,b){if(!(a.nodeName&&c.noData[a.nodeName.toLowerCase()])){a=a==A?za:a;var d=a[G],f=c.cache,e=f[d];if(b){if(e){delete e[b];c.isEmptyObject(e)&&c.removeData(a)}}else{if(c.support.deleteExpando)delete a[c.expando];
else a.removeAttribute&&a.removeAttribute(c.expando);delete f[d]}}}});c.fn.extend({data:function(a,b){if(typeof a==="undefined"&&this.length)return c.data(this[0]);else if(typeof a==="object")return this.each(function(){c.data(this,a)});var d=a.split(".");d[1]=d[1]?"."+d[1]:"";if(b===w){var f=this.triggerHandler("getData"+d[1]+"!",[d[0]]);if(f===w&&this.length)f=c.data(this[0],a);return f===w&&d[1]?this.data(d[0]):f}else return this.trigger("setData"+d[1]+"!",[d[0],b]).each(function(){c.data(this,
a,b)})},removeData:function(a){return this.each(function(){c.removeData(this,a)})}});c.extend({queue:function(a,b,d){if(a){b=(b||"fx")+"queue";var f=c.data(a,b);if(!d)return f||[];if(!f||c.isArray(d))f=c.data(a,b,c.makeArray(d));else f.push(d);return f}},dequeue:function(a,b){b=b||"fx";var d=c.queue(a,b),f=d.shift();if(f==="inprogress")f=d.shift();if(f){b==="fx"&&d.unshift("inprogress");f.call(a,function(){c.dequeue(a,b)})}}});c.fn.extend({queue:function(a,b){if(typeof a!=="string"){b=a;a="fx"}if(b===
w)return c.queue(this[0],a);return this.each(function(){var d=c.queue(this,a,b);a==="fx"&&d[0]!=="inprogress"&&c.dequeue(this,a)})},dequeue:function(a){return this.each(function(){c.dequeue(this,a)})},delay:function(a,b){a=c.fx?c.fx.speeds[a]||a:a;b=b||"fx";return this.queue(b,function(){var d=this;setTimeout(function(){c.dequeue(d,b)},a)})},clearQueue:function(a){return this.queue(a||"fx",[])}});var Aa=/[\\n\\t]/g,ca=/\\s+/,Za=/\\r/g,$a=/href|src|style/,ab=/(button|input)/i,bb=/(button|input|object|select|textarea)/i,
cb=/^(a|area)$/i,Ba=/radio|checkbox/;c.fn.extend({attr:function(a,b){return X(this,a,b,true,c.attr)},removeAttr:function(a){return this.each(function(){c.attr(this,a,"");this.nodeType===1&&this.removeAttribute(a)})},addClass:function(a){if(c.isFunction(a))return this.each(function(n){var r=c(this);r.addClass(a.call(this,n,r.attr("class")))});if(a&&typeof a==="string")for(var b=(a||"").split(ca),d=0,f=this.length;d<f;d++){var e=this[d];if(e.nodeType===1)if(e.className){for(var j=" "+e.className+" ",
i=e.className,o=0,k=b.length;o<k;o++)if(j.indexOf(" "+b[o]+" ")<0)i+=" "+b[o];e.className=c.trim(i)}else e.className=a}return this},removeClass:function(a){if(c.isFunction(a))return this.each(function(k){var n=c(this);n.removeClass(a.call(this,k,n.attr("class")))});if(a&&typeof a==="string"||a===w)for(var b=(a||"").split(ca),d=0,f=this.length;d<f;d++){var e=this[d];if(e.nodeType===1&&e.className)if(a){for(var j=(" "+e.className+" ").replace(Aa," "),i=0,o=b.length;i<o;i++)j=j.replace(" "+b[i]+" ",
" ");e.className=c.trim(j)}else e.className=""}return this},toggleClass:function(a,b){var d=typeof a,f=typeof b==="boolean";if(c.isFunction(a))return this.each(function(e){var j=c(this);j.toggleClass(a.call(this,e,j.attr("class"),b),b)});return this.each(function(){if(d==="string")for(var e,j=0,i=c(this),o=b,k=a.split(ca);e=k[j++];){o=f?o:!i.hasClass(e);i[o?"addClass":"removeClass"](e)}else if(d==="undefined"||d==="boolean"){this.className&&c.data(this,"__className__",this.className);this.className=
this.className||a===false?"":c.data(this,"__className__")||""}})},hasClass:function(a){a=" "+a+" ";for(var b=0,d=this.length;b<d;b++)if((" "+this[b].className+" ").replace(Aa," ").indexOf(a)>-1)return true;return false},val:function(a){if(a===w){var b=this[0];if(b){if(c.nodeName(b,"option"))return(b.attributes.value||{}).specified?b.value:b.text;if(c.nodeName(b,"select")){var d=b.selectedIndex,f=[],e=b.options;b=b.type==="select-one";if(d<0)return null;var j=b?d:0;for(d=b?d+1:e.length;j<d;j++){var i=
e[j];if(i.selected){a=c(i).val();if(b)return a;f.push(a)}}return f}if(Ba.test(b.type)&&!c.support.checkOn)return b.getAttribute("value")===null?"on":b.value;return(b.value||"").replace(Za,"")}return w}var o=c.isFunction(a);return this.each(function(k){var n=c(this),r=a;if(this.nodeType===1){if(o)r=a.call(this,k,n.val());if(typeof r==="number")r+="";if(c.isArray(r)&&Ba.test(this.type))this.checked=c.inArray(n.val(),r)>=0;else if(c.nodeName(this,"select")){var u=c.makeArray(r);c("option",this).each(function(){this.selected=
c.inArray(c(this).val(),u)>=0});if(!u.length)this.selectedIndex=-1}else this.value=r}})}});c.extend({attrFn:{val:true,css:true,html:true,text:true,data:true,width:true,height:true,offset:true},attr:function(a,b,d,f){if(!a||a.nodeType===3||a.nodeType===8)return w;if(f&&b in c.attrFn)return c(a)[b](d);f=a.nodeType!==1||!c.isXMLDoc(a);var e=d!==w;b=f&&c.props[b]||b;if(a.nodeType===1){var j=$a.test(b);if(b in a&&f&&!j){if(e){b==="type"&&ab.test(a.nodeName)&&a.parentNode&&c.error("type property can't be changed");
a[b]=d}if(c.nodeName(a,"form")&&a.getAttributeNode(b))return a.getAttributeNode(b).nodeValue;if(b==="tabIndex")return(b=a.getAttributeNode("tabIndex"))&&b.specified?b.value:bb.test(a.nodeName)||cb.test(a.nodeName)&&a.href?0:w;return a[b]}if(!c.support.style&&f&&b==="style"){if(e)a.style.cssText=""+d;return a.style.cssText}e&&a.setAttribute(b,""+d);a=!c.support.hrefNormalized&&f&&j?a.getAttribute(b,2):a.getAttribute(b);return a===null?w:a}return c.style(a,b,d)}});var O=/\\.(.*)$/,db=function(a){return a.replace(/[^\\w\\s\\.\\|`]/g,
function(b){return"\\\\"+b})};c.event={add:function(a,b,d,f){if(!(a.nodeType===3||a.nodeType===8)){if(a.setInterval&&a!==A&&!a.frameElement)a=A;var e,j;if(d.handler){e=d;d=e.handler}if(!d.guid)d.guid=c.guid++;if(j=c.data(a)){var i=j.events=j.events||{},o=j.handle;if(!o)j.handle=o=function(){return typeof c!=="undefined"&&!c.event.triggered?c.event.handle.apply(o.elem,arguments):w};o.elem=a;b=b.split(" ");for(var k,n=0,r;k=b[n++];){j=e?c.extend({},e):{handler:d,data:f};if(k.indexOf(".")>-1){r=k.split(".");
k=r.shift();j.namespace=r.slice(0).sort().join(".")}else{r=[];j.namespace=""}j.type=k;j.guid=d.guid;var u=i[k],z=c.event.special[k]||{};if(!u){u=i[k]=[];if(!z.setup||z.setup.call(a,f,r,o)===false)if(a.addEventListener)a.addEventListener(k,o,false);else a.attachEvent&&a.attachEvent("on"+k,o)}if(z.add){z.add.call(a,j);if(!j.handler.guid)j.handler.guid=d.guid}u.push(j);c.event.global[k]=true}a=null}}},global:{},remove:function(a,b,d,f){if(!(a.nodeType===3||a.nodeType===8)){var e,j=0,i,o,k,n,r,u,z=c.data(a),
C=z&&z.events;if(z&&C){if(b&&b.type){d=b.handler;b=b.type}if(!b||typeof b==="string"&&b.charAt(0)==="."){b=b||"";for(e in C)c.event.remove(a,e+b)}else{for(b=b.split(" ");e=b[j++];){n=e;i=e.indexOf(".")<0;o=[];if(!i){o=e.split(".");e=o.shift();k=new RegExp("(^|\\\\.)"+c.map(o.slice(0).sort(),db).join("\\\\.(?:.*\\\\.)?")+"(\\\\.|$)")}if(r=C[e])if(d){n=c.event.special[e]||{};for(B=f||0;B<r.length;B++){u=r[B];if(d.guid===u.guid){if(i||k.test(u.namespace)){f==null&&r.splice(B--,1);n.remove&&n.remove.call(a,u)}if(f!=
null)break}}if(r.length===0||f!=null&&r.length===1){if(!n.teardown||n.teardown.call(a,o)===false)Ca(a,e,z.handle);delete C[e]}}else for(var B=0;B<r.length;B++){u=r[B];if(i||k.test(u.namespace)){c.event.remove(a,n,u.handler,B);r.splice(B--,1)}}}if(c.isEmptyObject(C)){if(b=z.handle)b.elem=null;delete z.events;delete z.handle;c.isEmptyObject(z)&&c.removeData(a)}}}}},trigger:function(a,b,d,f){var e=a.type||a;if(!f){a=typeof a==="object"?a[G]?a:c.extend(c.Event(e),a):c.Event(e);if(e.indexOf("!")>=0){a.type=
e=e.slice(0,-1);a.exclusive=true}if(!d){a.stopPropagation();c.event.global[e]&&c.each(c.cache,function(){this.events&&this.events[e]&&c.event.trigger(a,b,this.handle.elem)})}if(!d||d.nodeType===3||d.nodeType===8)return w;a.result=w;a.target=d;b=c.makeArray(b);b.unshift(a)}a.currentTarget=d;(f=c.data(d,"handle"))&&f.apply(d,b);f=d.parentNode||d.ownerDocument;try{if(!(d&&d.nodeName&&c.noData[d.nodeName.toLowerCase()]))if(d["on"+e]&&d["on"+e].apply(d,b)===false)a.result=false}catch(j){}if(!a.isPropagationStopped()&&
f)c.event.trigger(a,b,f,true);else if(!a.isDefaultPrevented()){f=a.target;var i,o=c.nodeName(f,"a")&&e==="click",k=c.event.special[e]||{};if((!k._default||k._default.call(d,a)===false)&&!o&&!(f&&f.nodeName&&c.noData[f.nodeName.toLowerCase()])){try{if(f[e]){if(i=f["on"+e])f["on"+e]=null;c.event.triggered=true;f[e]()}}catch(n){}if(i)f["on"+e]=i;c.event.triggered=false}}},handle:function(a){var b,d,f,e;a=arguments[0]=c.event.fix(a||A.event);a.currentTarget=this;b=a.type.indexOf(".")<0&&!a.exclusive;
if(!b){d=a.type.split(".");a.type=d.shift();f=new RegExp("(^|\\\\.)"+d.slice(0).sort().join("\\\\.(?:.*\\\\.)?")+"(\\\\.|$)")}e=c.data(this,"events");d=e[a.type];if(e&&d){d=d.slice(0);e=0;for(var j=d.length;e<j;e++){var i=d[e];if(b||f.test(i.namespace)){a.handler=i.handler;a.data=i.data;a.handleObj=i;i=i.handler.apply(this,arguments);if(i!==w){a.result=i;if(i===false){a.preventDefault();a.stopPropagation()}}if(a.isImmediatePropagationStopped())break}}}return a.result},props:"altKey attrChange attrName bubbles button cancelable charCode clientX clientY ctrlKey currentTarget data detail eventPhase fromElement handler keyCode layerX layerY metaKey newValue offsetX offsetY originalTarget pageX pageY prevValue relatedNode relatedTarget screenX screenY shiftKey srcElement target toElement view wheelDelta which".split(" "),
fix:function(a){if(a[G])return a;var b=a;a=c.Event(b);for(var d=this.props.length,f;d;){f=this.props[--d];a[f]=b[f]}if(!a.target)a.target=a.srcElement||s;if(a.target.nodeType===3)a.target=a.target.parentNode;if(!a.relatedTarget&&a.fromElement)a.relatedTarget=a.fromElement===a.target?a.toElement:a.fromElement;if(a.pageX==null&&a.clientX!=null){b=s.documentElement;d=s.body;a.pageX=a.clientX+(b&&b.scrollLeft||d&&d.scrollLeft||0)-(b&&b.clientLeft||d&&d.clientLeft||0);a.pageY=a.clientY+(b&&b.scrollTop||
d&&d.scrollTop||0)-(b&&b.clientTop||d&&d.clientTop||0)}if(!a.which&&(a.charCode||a.charCode===0?a.charCode:a.keyCode))a.which=a.charCode||a.keyCode;if(!a.metaKey&&a.ctrlKey)a.metaKey=a.ctrlKey;if(!a.which&&a.button!==w)a.which=a.button&1?1:a.button&2?3:a.button&4?2:0;return a},guid:1E8,proxy:c.proxy,special:{ready:{setup:c.bindReady,teardown:c.noop},live:{add:function(a){c.event.add(this,a.origType,c.extend({},a,{handler:oa}))},remove:function(a){var b=true,d=a.origType.replace(O,"");c.each(c.data(this,
"events").live||[],function(){if(d===this.origType.replace(O,""))return b=false});b&&c.event.remove(this,a.origType,oa)}},beforeunload:{setup:function(a,b,d){if(this.setInterval)this.onbeforeunload=d;return false},teardown:function(a,b){if(this.onbeforeunload===b)this.onbeforeunload=null}}}};var Ca=s.removeEventListener?function(a,b,d){a.removeEventListener(b,d,false)}:function(a,b,d){a.detachEvent("on"+b,d)};c.Event=function(a){if(!this.preventDefault)return new c.Event(a);if(a&&a.type){this.originalEvent=
a;this.type=a.type}else this.type=a;this.timeStamp=J();this[G]=true};c.Event.prototype={preventDefault:function(){this.isDefaultPrevented=Z;var a=this.originalEvent;if(a){a.preventDefault&&a.preventDefault();a.returnValue=false}},stopPropagation:function(){this.isPropagationStopped=Z;var a=this.originalEvent;if(a){a.stopPropagation&&a.stopPropagation();a.cancelBubble=true}},stopImmediatePropagation:function(){this.isImmediatePropagationStopped=Z;this.stopPropagation()},isDefaultPrevented:Y,isPropagationStopped:Y,
isImmediatePropagationStopped:Y};var Da=function(a){var b=a.relatedTarget;try{for(;b&&b!==this;)b=b.parentNode;if(b!==this){a.type=a.data;c.event.handle.apply(this,arguments)}}catch(d){}},Ea=function(a){a.type=a.data;c.event.handle.apply(this,arguments)};c.each({mouseenter:"mouseover",mouseleave:"mouseout"},function(a,b){c.event.special[a]={setup:function(d){c.event.add(this,b,d&&d.selector?Ea:Da,a)},teardown:function(d){c.event.remove(this,b,d&&d.selector?Ea:Da)}}});if(!c.support.submitBubbles)c.event.special.submit=
{setup:function(){if(this.nodeName.toLowerCase()!=="form"){c.event.add(this,"click.specialSubmit",function(a){var b=a.target,d=b.type;if((d==="submit"||d==="image")&&c(b).closest("form").length)return na("submit",this,arguments)});c.event.add(this,"keypress.specialSubmit",function(a){var b=a.target,d=b.type;if((d==="text"||d==="password")&&c(b).closest("form").length&&a.keyCode===13)return na("submit",this,arguments)})}else return false},teardown:function(){c.event.remove(this,".specialSubmit")}};
if(!c.support.changeBubbles){var da=/textarea|input|select/i,ea,Fa=function(a){var b=a.type,d=a.value;if(b==="radio"||b==="checkbox")d=a.checked;else if(b==="select-multiple")d=a.selectedIndex>-1?c.map(a.options,function(f){return f.selected}).join("-"):"";else if(a.nodeName.toLowerCase()==="select")d=a.selectedIndex;return d},fa=function(a,b){var d=a.target,f,e;if(!(!da.test(d.nodeName)||d.readOnly)){f=c.data(d,"_change_data");e=Fa(d);if(a.type!=="focusout"||d.type!=="radio")c.data(d,"_change_data",
e);if(!(f===w||e===f))if(f!=null||e){a.type="change";return c.event.trigger(a,b,d)}}};c.event.special.change={filters:{focusout:fa,click:function(a){var b=a.target,d=b.type;if(d==="radio"||d==="checkbox"||b.nodeName.toLowerCase()==="select")return fa.call(this,a)},keydown:function(a){var b=a.target,d=b.type;if(a.keyCode===13&&b.nodeName.toLowerCase()!=="textarea"||a.keyCode===32&&(d==="checkbox"||d==="radio")||d==="select-multiple")return fa.call(this,a)},beforeactivate:function(a){a=a.target;c.data(a,
"_change_data",Fa(a))}},setup:function(){if(this.type==="file")return false;for(var a in ea)c.event.add(this,a+".specialChange",ea[a]);return da.test(this.nodeName)},teardown:function(){c.event.remove(this,".specialChange");return da.test(this.nodeName)}};ea=c.event.special.change.filters}s.addEventListener&&c.each({focus:"focusin",blur:"focusout"},function(a,b){function d(f){f=c.event.fix(f);f.type=b;return c.event.handle.call(this,f)}c.event.special[b]={setup:function(){this.addEventListener(a,
d,true)},teardown:function(){this.removeEventListener(a,d,true)}}});c.each(["bind","one"],function(a,b){c.fn[b]=function(d,f,e){if(typeof d==="object"){for(var j in d)this[b](j,f,d[j],e);return this}if(c.isFunction(f)){e=f;f=w}var i=b==="one"?c.proxy(e,function(k){c(this).unbind(k,i);return e.apply(this,arguments)}):e;if(d==="unload"&&b!=="one")this.one(d,f,e);else{j=0;for(var o=this.length;j<o;j++)c.event.add(this[j],d,i,f)}return this}});c.fn.extend({unbind:function(a,b){if(typeof a==="object"&&
!a.preventDefault)for(var d in a)this.unbind(d,a[d]);else{d=0;for(var f=this.length;d<f;d++)c.event.remove(this[d],a,b)}return this},delegate:function(a,b,d,f){return this.live(b,d,f,a)},undelegate:function(a,b,d){return arguments.length===0?this.unbind("live"):this.die(b,null,d,a)},trigger:function(a,b){return this.each(function(){c.event.trigger(a,b,this)})},triggerHandler:function(a,b){if(this[0]){a=c.Event(a);a.preventDefault();a.stopPropagation();c.event.trigger(a,b,this[0]);return a.result}},
toggle:function(a){for(var b=arguments,d=1;d<b.length;)c.proxy(a,b[d++]);return this.click(c.proxy(a,function(f){var e=(c.data(this,"lastToggle"+a.guid)||0)%d;c.data(this,"lastToggle"+a.guid,e+1);f.preventDefault();return b[e].apply(this,arguments)||false}))},hover:function(a,b){return this.mouseenter(a).mouseleave(b||a)}});var Ga={focus:"focusin",blur:"focusout",mouseenter:"mouseover",mouseleave:"mouseout"};c.each(["live","die"],function(a,b){c.fn[b]=function(d,f,e,j){var i,o=0,k,n,r=j||this.selector,
u=j?this:c(this.context);if(c.isFunction(f)){e=f;f=w}for(d=(d||"").split(" ");(i=d[o++])!=null;){j=O.exec(i);k="";if(j){k=j[0];i=i.replace(O,"")}if(i==="hover")d.push("mouseenter"+k,"mouseleave"+k);else{n=i;if(i==="focus"||i==="blur"){d.push(Ga[i]+k);i+=k}else i=(Ga[i]||i)+k;b==="live"?u.each(function(){c.event.add(this,pa(i,r),{data:f,selector:r,handler:e,origType:i,origHandler:e,preType:n})}):u.unbind(pa(i,r),e)}}return this}});c.each("blur focus focusin focusout load resize scroll unload click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave change select submit keydown keypress keyup error".split(" "),
function(a,b){c.fn[b]=function(d){return d?this.bind(b,d):this.trigger(b)};if(c.attrFn)c.attrFn[b]=true});A.attachEvent&&!A.addEventListener&&A.attachEvent("onunload",function(){for(var a in c.cache)if(c.cache[a].handle)try{c.event.remove(c.cache[a].handle.elem)}catch(b){}});(function(){function a(g){for(var h="",l,m=0;g[m];m++){l=g[m];if(l.nodeType===3||l.nodeType===4)h+=l.nodeValue;else if(l.nodeType!==8)h+=a(l.childNodes)}return h}function b(g,h,l,m,q,p){q=0;for(var v=m.length;q<v;q++){var t=m[q];
if(t){t=t[g];for(var y=false;t;){if(t.sizcache===l){y=m[t.sizset];break}if(t.nodeType===1&&!p){t.sizcache=l;t.sizset=q}if(t.nodeName.toLowerCase()===h){y=t;break}t=t[g]}m[q]=y}}}function d(g,h,l,m,q,p){q=0;for(var v=m.length;q<v;q++){var t=m[q];if(t){t=t[g];for(var y=false;t;){if(t.sizcache===l){y=m[t.sizset];break}if(t.nodeType===1){if(!p){t.sizcache=l;t.sizset=q}if(typeof h!=="string"){if(t===h){y=true;break}}else if(k.filter(h,[t]).length>0){y=t;break}}t=t[g]}m[q]=y}}}var f=/((?:\\((?:\\([^()]+\\)|[^()]+)+\\)|\\[(?:\\[[^[\\]]*\\]|['"][^'"]*['"]|[^[\\]'"]+)+\\]|\\\\.|[^ >+~,(\\[\\\\]+)+|[>+~])(\\s*,\\s*)?((?:.|\\r|\\n)*)/g,
e=0,j=Object.prototype.toString,i=false,o=true;[0,0].sort(function(){o=false;return 0});var k=function(g,h,l,m){l=l||[];var q=h=h||s;if(h.nodeType!==1&&h.nodeType!==9)return[];if(!g||typeof g!=="string")return l;for(var p=[],v,t,y,S,H=true,M=x(h),I=g;(f.exec(""),v=f.exec(I))!==null;){I=v[3];p.push(v[1]);if(v[2]){S=v[3];break}}if(p.length>1&&r.exec(g))if(p.length===2&&n.relative[p[0]])t=ga(p[0]+p[1],h);else for(t=n.relative[p[0]]?[h]:k(p.shift(),h);p.length;){g=p.shift();if(n.relative[g])g+=p.shift();
t=ga(g,t)}else{if(!m&&p.length>1&&h.nodeType===9&&!M&&n.match.ID.test(p[0])&&!n.match.ID.test(p[p.length-1])){v=k.find(p.shift(),h,M);h=v.expr?k.filter(v.expr,v.set)[0]:v.set[0]}if(h){v=m?{expr:p.pop(),set:z(m)}:k.find(p.pop(),p.length===1&&(p[0]==="~"||p[0]==="+")&&h.parentNode?h.parentNode:h,M);t=v.expr?k.filter(v.expr,v.set):v.set;if(p.length>0)y=z(t);else H=false;for(;p.length;){var D=p.pop();v=D;if(n.relative[D])v=p.pop();else D="";if(v==null)v=h;n.relative[D](y,v,M)}}else y=[]}y||(y=t);y||k.error(D||
g);if(j.call(y)==="[object Array]")if(H)if(h&&h.nodeType===1)for(g=0;y[g]!=null;g++){if(y[g]&&(y[g]===true||y[g].nodeType===1&&E(h,y[g])))l.push(t[g])}else for(g=0;y[g]!=null;g++)y[g]&&y[g].nodeType===1&&l.push(t[g]);else l.push.apply(l,y);else z(y,l);if(S){k(S,q,l,m);k.uniqueSort(l)}return l};k.uniqueSort=function(g){if(B){i=o;g.sort(B);if(i)for(var h=1;h<g.length;h++)g[h]===g[h-1]&&g.splice(h--,1)}return g};k.matches=function(g,h){return k(g,null,null,h)};k.find=function(g,h,l){var m,q;if(!g)return[];
for(var p=0,v=n.order.length;p<v;p++){var t=n.order[p];if(q=n.leftMatch[t].exec(g)){var y=q[1];q.splice(1,1);if(y.substr(y.length-1)!=="\\\\"){q[1]=(q[1]||"").replace(/\\\\/g,"");m=n.find[t](q,h,l);if(m!=null){g=g.replace(n.match[t],"");break}}}}m||(m=h.getElementsByTagName("*"));return{set:m,expr:g}};k.filter=function(g,h,l,m){for(var q=g,p=[],v=h,t,y,S=h&&h[0]&&x(h[0]);g&&h.length;){for(var H in n.filter)if((t=n.leftMatch[H].exec(g))!=null&&t[2]){var M=n.filter[H],I,D;D=t[1];y=false;t.splice(1,1);if(D.substr(D.length-
1)!=="\\\\"){if(v===p)p=[];if(n.preFilter[H])if(t=n.preFilter[H](t,v,l,p,m,S)){if(t===true)continue}else y=I=true;if(t)for(var U=0;(D=v[U])!=null;U++)if(D){I=M(D,t,U,v);var Ha=m^!!I;if(l&&I!=null)if(Ha)y=true;else v[U]=false;else if(Ha){p.push(D);y=true}}if(I!==w){l||(v=p);g=g.replace(n.match[H],"");if(!y)return[];break}}}if(g===q)if(y==null)k.error(g);else break;q=g}return v};k.error=function(g){throw"Syntax error, unrecognized expression: "+g;};var n=k.selectors={order:["ID","NAME","TAG"],match:{ID:/#((?:[\\w\\u00c0-\\uFFFF-]|\\\\.)+)/,
CLASS:/\\.((?:[\\w\\u00c0-\\uFFFF-]|\\\\.)+)/,NAME:/\\[name=['"]*((?:[\\w\\u00c0-\\uFFFF-]|\\\\.)+)['"]*\\]/,ATTR:/\\[\\s*((?:[\\w\\u00c0-\\uFFFF-]|\\\\.)+)\\s*(?:(\\S?=)\\s*(['"]*)(.*?)\\3|)\\s*\\]/,TAG:/^((?:[\\w\\u00c0-\\uFFFF\\*-]|\\\\.)+)/,CHILD:/:(only|nth|last|first)-child(?:\\((even|odd|[\\dn+-]*)\\))?/,POS:/:(nth|eq|gt|lt|first|last|even|odd)(?:\\((\\d*)\\))?(?=[^-]|$)/,PSEUDO:/:((?:[\\w\\u00c0-\\uFFFF-]|\\\\.)+)(?:\\((['"]?)((?:\\([^\\)]+\\)|[^\\(\\)]*)+)\\2\\))?/},leftMatch:{},attrMap:{"class":"className","for":"htmlFor"},attrHandle:{href:function(g){return g.getAttribute("href")}},
relative:{"+":function(g,h){var l=typeof h==="string",m=l&&!/\\W/.test(h);l=l&&!m;if(m)h=h.toLowerCase();m=0;for(var q=g.length,p;m<q;m++)if(p=g[m]){for(;(p=p.previousSibling)&&p.nodeType!==1;);g[m]=l||p&&p.nodeName.toLowerCase()===h?p||false:p===h}l&&k.filter(h,g,true)},">":function(g,h){var l=typeof h==="string";if(l&&!/\\W/.test(h)){h=h.toLowerCase();for(var m=0,q=g.length;m<q;m++){var p=g[m];if(p){l=p.parentNode;g[m]=l.nodeName.toLowerCase()===h?l:false}}}else{m=0;for(q=g.length;m<q;m++)if(p=g[m])g[m]=
l?p.parentNode:p.parentNode===h;l&&k.filter(h,g,true)}},"":function(g,h,l){var m=e++,q=d;if(typeof h==="string"&&!/\\W/.test(h)){var p=h=h.toLowerCase();q=b}q("parentNode",h,m,g,p,l)},"~":function(g,h,l){var m=e++,q=d;if(typeof h==="string"&&!/\\W/.test(h)){var p=h=h.toLowerCase();q=b}q("previousSibling",h,m,g,p,l)}},find:{ID:function(g,h,l){if(typeof h.getElementById!=="undefined"&&!l)return(g=h.getElementById(g[1]))?[g]:[]},NAME:function(g,h){if(typeof h.getElementsByName!=="undefined"){var l=[];
h=h.getElementsByName(g[1]);for(var m=0,q=h.length;m<q;m++)h[m].getAttribute("name")===g[1]&&l.push(h[m]);return l.length===0?null:l}},TAG:function(g,h){return h.getElementsByTagName(g[1])}},preFilter:{CLASS:function(g,h,l,m,q,p){g=" "+g[1].replace(/\\\\/g,"")+" ";if(p)return g;p=0;for(var v;(v=h[p])!=null;p++)if(v)if(q^(v.className&&(" "+v.className+" ").replace(/[\\t\\n]/g," ").indexOf(g)>=0))l||m.push(v);else if(l)h[p]=false;return false},ID:function(g){return g[1].replace(/\\\\/g,"")},TAG:function(g){return g[1].toLowerCase()},
CHILD:function(g){if(g[1]==="nth"){var h=/(-?)(\\d*)n((?:\\+|-)?\\d*)/.exec(g[2]==="even"&&"2n"||g[2]==="odd"&&"2n+1"||!/\\D/.test(g[2])&&"0n+"+g[2]||g[2]);g[2]=h[1]+(h[2]||1)-0;g[3]=h[3]-0}g[0]=e++;return g},ATTR:function(g,h,l,m,q,p){h=g[1].replace(/\\\\/g,"");if(!p&&n.attrMap[h])g[1]=n.attrMap[h];if(g[2]==="~=")g[4]=" "+g[4]+" ";return g},PSEUDO:function(g,h,l,m,q){if(g[1]==="not")if((f.exec(g[3])||"").length>1||/^\\w/.test(g[3]))g[3]=k(g[3],null,null,h);else{g=k.filter(g[3],h,l,true^q);l||m.push.apply(m,
g);return false}else if(n.match.POS.test(g[0])||n.match.CHILD.test(g[0]))return true;return g},POS:function(g){g.unshift(true);return g}},filters:{enabled:function(g){return g.disabled===false&&g.type!=="hidden"},disabled:function(g){return g.disabled===true},checked:function(g){return g.checked===true},selected:function(g){return g.selected===true},parent:function(g){return!!g.firstChild},empty:function(g){return!g.firstChild},has:function(g,h,l){return!!k(l[3],g).length},header:function(g){return/h\\d/i.test(g.nodeName)},
text:function(g){return"text"===g.type},radio:function(g){return"radio"===g.type},checkbox:function(g){return"checkbox"===g.type},file:function(g){return"file"===g.type},password:function(g){return"password"===g.type},submit:function(g){return"submit"===g.type},image:function(g){return"image"===g.type},reset:function(g){return"reset"===g.type},button:function(g){return"button"===g.type||g.nodeName.toLowerCase()==="button"},input:function(g){return/input|select|textarea|button/i.test(g.nodeName)}},
setFilters:{first:function(g,h){return h===0},last:function(g,h,l,m){return h===m.length-1},even:function(g,h){return h%2===0},odd:function(g,h){return h%2===1},lt:function(g,h,l){return h<l[3]-0},gt:function(g,h,l){return h>l[3]-0},nth:function(g,h,l){return l[3]-0===h},eq:function(g,h,l){return l[3]-0===h}},filter:{PSEUDO:function(g,h,l,m){var q=h[1],p=n.filters[q];if(p)return p(g,l,h,m);else if(q==="contains")return(g.textContent||g.innerText||a([g])||"").indexOf(h[3])>=0;else if(q==="not"){h=
h[3];l=0;for(m=h.length;l<m;l++)if(h[l]===g)return false;return true}else k.error("Syntax error, unrecognized expression: "+q)},CHILD:function(g,h){var l=h[1],m=g;switch(l){case "only":case "first":for(;m=m.previousSibling;)if(m.nodeType===1)return false;if(l==="first")return true;m=g;case "last":for(;m=m.nextSibling;)if(m.nodeType===1)return false;return true;case "nth":l=h[2];var q=h[3];if(l===1&&q===0)return true;h=h[0];var p=g.parentNode;if(p&&(p.sizcache!==h||!g.nodeIndex)){var v=0;for(m=p.firstChild;m;m=
m.nextSibling)if(m.nodeType===1)m.nodeIndex=++v;p.sizcache=h}g=g.nodeIndex-q;return l===0?g===0:g%l===0&&g/l>=0}},ID:function(g,h){return g.nodeType===1&&g.getAttribute("id")===h},TAG:function(g,h){return h==="*"&&g.nodeType===1||g.nodeName.toLowerCase()===h},CLASS:function(g,h){return(" "+(g.className||g.getAttribute("class"))+" ").indexOf(h)>-1},ATTR:function(g,h){var l=h[1];g=n.attrHandle[l]?n.attrHandle[l](g):g[l]!=null?g[l]:g.getAttribute(l);l=g+"";var m=h[2];h=h[4];return g==null?m==="!=":m===
"="?l===h:m==="*="?l.indexOf(h)>=0:m==="~="?(" "+l+" ").indexOf(h)>=0:!h?l&&g!==false:m==="!="?l!==h:m==="^="?l.indexOf(h)===0:m==="$="?l.substr(l.length-h.length)===h:m==="|="?l===h||l.substr(0,h.length+1)===h+"-":false},POS:function(g,h,l,m){var q=n.setFilters[h[2]];if(q)return q(g,l,h,m)}}},r=n.match.POS;for(var u in n.match){n.match[u]=new RegExp(n.match[u].source+/(?![^\\[]*\\])(?![^\\(]*\\))/.source);n.leftMatch[u]=new RegExp(/(^(?:.|\\r|\\n)*?)/.source+n.match[u].source.replace(/\\\\(\\d+)/g,function(g,
h){return"\\\\"+(h-0+1)}))}var z=function(g,h){g=Array.prototype.slice.call(g,0);if(h){h.push.apply(h,g);return h}return g};try{Array.prototype.slice.call(s.documentElement.childNodes,0)}catch(C){z=function(g,h){h=h||[];if(j.call(g)==="[object Array]")Array.prototype.push.apply(h,g);else if(typeof g.length==="number")for(var l=0,m=g.length;l<m;l++)h.push(g[l]);else for(l=0;g[l];l++)h.push(g[l]);return h}}var B;if(s.documentElement.compareDocumentPosition)B=function(g,h){if(!g.compareDocumentPosition||
!h.compareDocumentPosition){if(g==h)i=true;return g.compareDocumentPosition?-1:1}g=g.compareDocumentPosition(h)&4?-1:g===h?0:1;if(g===0)i=true;return g};else if("sourceIndex"in s.documentElement)B=function(g,h){if(!g.sourceIndex||!h.sourceIndex){if(g==h)i=true;return g.sourceIndex?-1:1}g=g.sourceIndex-h.sourceIndex;if(g===0)i=true;return g};else if(s.createRange)B=function(g,h){if(!g.ownerDocument||!h.ownerDocument){if(g==h)i=true;return g.ownerDocument?-1:1}var l=g.ownerDocument.createRange(),m=
h.ownerDocument.createRange();l.setStart(g,0);l.setEnd(g,0);m.setStart(h,0);m.setEnd(h,0);g=l.compareBoundaryPoints(Range.START_TO_END,m);if(g===0)i=true;return g};(function(){var g=s.createElement("div"),h="script"+(new Date).getTime();g.innerHTML="<a name='"+h+"'/>";var l=s.documentElement;l.insertBefore(g,l.firstChild);if(s.getElementById(h)){n.find.ID=function(m,q,p){if(typeof q.getElementById!=="undefined"&&!p)return(q=q.getElementById(m[1]))?q.id===m[1]||typeof q.getAttributeNode!=="undefined"&&
q.getAttributeNode("id").nodeValue===m[1]?[q]:w:[]};n.filter.ID=function(m,q){var p=typeof m.getAttributeNode!=="undefined"&&m.getAttributeNode("id");return m.nodeType===1&&p&&p.nodeValue===q}}l.removeChild(g);l=g=null})();(function(){var g=s.createElement("div");g.appendChild(s.createComment(""));if(g.getElementsByTagName("*").length>0)n.find.TAG=function(h,l){l=l.getElementsByTagName(h[1]);if(h[1]==="*"){h=[];for(var m=0;l[m];m++)l[m].nodeType===1&&h.push(l[m]);l=h}return l};g.innerHTML="<a href='#'></a>";
if(g.firstChild&&typeof g.firstChild.getAttribute!=="undefined"&&g.firstChild.getAttribute("href")!=="#")n.attrHandle.href=function(h){return h.getAttribute("href",2)};g=null})();s.querySelectorAll&&function(){var g=k,h=s.createElement("div");h.innerHTML="<p class='TEST'></p>";if(!(h.querySelectorAll&&h.querySelectorAll(".TEST").length===0)){k=function(m,q,p,v){q=q||s;if(!v&&q.nodeType===9&&!x(q))try{return z(q.querySelectorAll(m),p)}catch(t){}return g(m,q,p,v)};for(var l in g)k[l]=g[l];h=null}}();
(function(){var g=s.createElement("div");g.innerHTML="<div class='test e'></div><div class='test'></div>";if(!(!g.getElementsByClassName||g.getElementsByClassName("e").length===0)){g.lastChild.className="e";if(g.getElementsByClassName("e").length!==1){n.order.splice(1,0,"CLASS");n.find.CLASS=function(h,l,m){if(typeof l.getElementsByClassName!=="undefined"&&!m)return l.getElementsByClassName(h[1])};g=null}}})();var E=s.compareDocumentPosition?function(g,h){return!!(g.compareDocumentPosition(h)&16)}:
function(g,h){return g!==h&&(g.contains?g.contains(h):true)},x=function(g){return(g=(g?g.ownerDocument||g:0).documentElement)?g.nodeName!=="HTML":false},ga=function(g,h){var l=[],m="",q;for(h=h.nodeType?[h]:h;q=n.match.PSEUDO.exec(g);){m+=q[0];g=g.replace(n.match.PSEUDO,"")}g=n.relative[g]?g+"*":g;q=0;for(var p=h.length;q<p;q++)k(g,h[q],l);return k.filter(m,l)};c.find=k;c.expr=k.selectors;c.expr[":"]=c.expr.filters;c.unique=k.uniqueSort;c.text=a;c.isXMLDoc=x;c.contains=E})();var eb=/Until$/,fb=/^(?:parents|prevUntil|prevAll)/,
gb=/,/;R=Array.prototype.slice;var Ia=function(a,b,d){if(c.isFunction(b))return c.grep(a,function(e,j){return!!b.call(e,j,e)===d});else if(b.nodeType)return c.grep(a,function(e){return e===b===d});else if(typeof b==="string"){var f=c.grep(a,function(e){return e.nodeType===1});if(Ua.test(b))return c.filter(b,f,!d);else b=c.filter(b,f)}return c.grep(a,function(e){return c.inArray(e,b)>=0===d})};c.fn.extend({find:function(a){for(var b=this.pushStack("","find",a),d=0,f=0,e=this.length;f<e;f++){d=b.length;
c.find(a,this[f],b);if(f>0)for(var j=d;j<b.length;j++)for(var i=0;i<d;i++)if(b[i]===b[j]){b.splice(j--,1);break}}return b},has:function(a){var b=c(a);return this.filter(function(){for(var d=0,f=b.length;d<f;d++)if(c.contains(this,b[d]))return true})},not:function(a){return this.pushStack(Ia(this,a,false),"not",a)},filter:function(a){return this.pushStack(Ia(this,a,true),"filter",a)},is:function(a){return!!a&&c.filter(a,this).length>0},closest:function(a,b){if(c.isArray(a)){var d=[],f=this[0],e,j=
{},i;if(f&&a.length){e=0;for(var o=a.length;e<o;e++){i=a[e];j[i]||(j[i]=c.expr.match.POS.test(i)?c(i,b||this.context):i)}for(;f&&f.ownerDocument&&f!==b;){for(i in j){e=j[i];if(e.jquery?e.index(f)>-1:c(f).is(e)){d.push({selector:i,elem:f});delete j[i]}}f=f.parentNode}}return d}var k=c.expr.match.POS.test(a)?c(a,b||this.context):null;return this.map(function(n,r){for(;r&&r.ownerDocument&&r!==b;){if(k?k.index(r)>-1:c(r).is(a))return r;r=r.parentNode}return null})},index:function(a){if(!a||typeof a===
"string")return c.inArray(this[0],a?c(a):this.parent().children());return c.inArray(a.jquery?a[0]:a,this)},add:function(a,b){a=typeof a==="string"?c(a,b||this.context):c.makeArray(a);b=c.merge(this.get(),a);return this.pushStack(qa(a[0])||qa(b[0])?b:c.unique(b))},andSelf:function(){return this.add(this.prevObject)}});c.each({parent:function(a){return(a=a.parentNode)&&a.nodeType!==11?a:null},parents:function(a){return c.dir(a,"parentNode")},parentsUntil:function(a,b,d){return c.dir(a,"parentNode",
d)},next:function(a){return c.nth(a,2,"nextSibling")},prev:function(a){return c.nth(a,2,"previousSibling")},nextAll:function(a){return c.dir(a,"nextSibling")},prevAll:function(a){return c.dir(a,"previousSibling")},nextUntil:function(a,b,d){return c.dir(a,"nextSibling",d)},prevUntil:function(a,b,d){return c.dir(a,"previousSibling",d)},siblings:function(a){return c.sibling(a.parentNode.firstChild,a)},children:function(a){return c.sibling(a.firstChild)},contents:function(a){return c.nodeName(a,"iframe")?
a.contentDocument||a.contentWindow.document:c.makeArray(a.childNodes)}},function(a,b){c.fn[a]=function(d,f){var e=c.map(this,b,d);eb.test(a)||(f=d);if(f&&typeof f==="string")e=c.filter(f,e);e=this.length>1?c.unique(e):e;if((this.length>1||gb.test(f))&&fb.test(a))e=e.reverse();return this.pushStack(e,a,R.call(arguments).join(","))}});c.extend({filter:function(a,b,d){if(d)a=":not("+a+")";return c.find.matches(a,b)},dir:function(a,b,d){var f=[];for(a=a[b];a&&a.nodeType!==9&&(d===w||a.nodeType!==1||!c(a).is(d));){a.nodeType===
1&&f.push(a);a=a[b]}return f},nth:function(a,b,d){b=b||1;for(var f=0;a;a=a[d])if(a.nodeType===1&&++f===b)break;return a},sibling:function(a,b){for(var d=[];a;a=a.nextSibling)a.nodeType===1&&a!==b&&d.push(a);return d}});var Ja=/ jQuery\\d+="(?:\\d+|null)"/g,V=/^\\s+/,Ka=/(<([\\w:]+)[^>]*?)\\/>/g,hb=/^(?:area|br|col|embed|hr|img|input|link|meta|param)$/i,La=/<([\\w:]+)/,ib=/<tbody/i,jb=/<|&#?\\w+;/,ta=/<script|<object|<embed|<option|<style/i,ua=/checked\\s*(?:[^=]|=\\s*.checked.)/i,Ma=function(a,b,d){return hb.test(d)?
a:b+"></"+d+">"},F={option:[1,"<select multiple='multiple'>","</select>"],legend:[1,"<fieldset>","</fieldset>"],thead:[1,"<table>","</table>"],tr:[2,"<table><tbody>","</tbody></table>"],td:[3,"<table><tbody><tr>","</tr></tbody></table>"],col:[2,"<table><tbody></tbody><colgroup>","</colgroup></table>"],area:[1,"<map>","</map>"],_default:[0,"",""]};F.optgroup=F.option;F.tbody=F.tfoot=F.colgroup=F.caption=F.thead;F.th=F.td;if(!c.support.htmlSerialize)F._default=[1,"div<div>","</div>"];c.fn.extend({text:function(a){if(c.isFunction(a))return this.each(function(b){var d=
c(this);d.text(a.call(this,b,d.text()))});if(typeof a!=="object"&&a!==w)return this.empty().append((this[0]&&this[0].ownerDocument||s).createTextNode(a));return c.text(this)},wrapAll:function(a){if(c.isFunction(a))return this.each(function(d){c(this).wrapAll(a.call(this,d))});if(this[0]){var b=c(a,this[0].ownerDocument).eq(0).clone(true);this[0].parentNode&&b.insertBefore(this[0]);b.map(function(){for(var d=this;d.firstChild&&d.firstChild.nodeType===1;)d=d.firstChild;return d}).append(this)}return this},
wrapInner:function(a){if(c.isFunction(a))return this.each(function(b){c(this).wrapInner(a.call(this,b))});return this.each(function(){var b=c(this),d=b.contents();d.length?d.wrapAll(a):b.append(a)})},wrap:function(a){return this.each(function(){c(this).wrapAll(a)})},unwrap:function(){return this.parent().each(function(){c.nodeName(this,"body")||c(this).replaceWith(this.childNodes)}).end()},append:function(){return this.domManip(arguments,true,function(a){this.nodeType===1&&this.appendChild(a)})},
prepend:function(){return this.domManip(arguments,true,function(a){this.nodeType===1&&this.insertBefore(a,this.firstChild)})},before:function(){if(this[0]&&this[0].parentNode)return this.domManip(arguments,false,function(b){this.parentNode.insertBefore(b,this)});else if(arguments.length){var a=c(arguments[0]);a.push.apply(a,this.toArray());return this.pushStack(a,"before",arguments)}},after:function(){if(this[0]&&this[0].parentNode)return this.domManip(arguments,false,function(b){this.parentNode.insertBefore(b,
this.nextSibling)});else if(arguments.length){var a=this.pushStack(this,"after",arguments);a.push.apply(a,c(arguments[0]).toArray());return a}},remove:function(a,b){for(var d=0,f;(f=this[d])!=null;d++)if(!a||c.filter(a,[f]).length){if(!b&&f.nodeType===1){c.cleanData(f.getElementsByTagName("*"));c.cleanData([f])}f.parentNode&&f.parentNode.removeChild(f)}return this},empty:function(){for(var a=0,b;(b=this[a])!=null;a++)for(b.nodeType===1&&c.cleanData(b.getElementsByTagName("*"));b.firstChild;)b.removeChild(b.firstChild);
return this},clone:function(a){var b=this.map(function(){if(!c.support.noCloneEvent&&!c.isXMLDoc(this)){var d=this.outerHTML,f=this.ownerDocument;if(!d){d=f.createElement("div");d.appendChild(this.cloneNode(true));d=d.innerHTML}return c.clean([d.replace(Ja,"").replace(/=([^="'>\\s]+\\/)>/g,'="$1">').replace(V,"")],f)[0]}else return this.cloneNode(true)});if(a===true){ra(this,b);ra(this.find("*"),b.find("*"))}return b},html:function(a){if(a===w)return this[0]&&this[0].nodeType===1?this[0].innerHTML.replace(Ja,
""):null;else if(typeof a==="string"&&!ta.test(a)&&(c.support.leadingWhitespace||!V.test(a))&&!F[(La.exec(a)||["",""])[1].toLowerCase()]){a=a.replace(Ka,Ma);try{for(var b=0,d=this.length;b<d;b++)if(this[b].nodeType===1){c.cleanData(this[b].getElementsByTagName("*"));this[b].innerHTML=a}}catch(f){this.empty().append(a)}}else c.isFunction(a)?this.each(function(e){var j=c(this),i=j.html();j.empty().append(function(){return a.call(this,e,i)})}):this.empty().append(a);return this},replaceWith:function(a){if(this[0]&&
this[0].parentNode){if(c.isFunction(a))return this.each(function(b){var d=c(this),f=d.html();d.replaceWith(a.call(this,b,f))});if(typeof a!=="string")a=c(a).detach();return this.each(function(){var b=this.nextSibling,d=this.parentNode;c(this).remove();b?c(b).before(a):c(d).append(a)})}else return this.pushStack(c(c.isFunction(a)?a():a),"replaceWith",a)},detach:function(a){return this.remove(a,true)},domManip:function(a,b,d){function f(u){return c.nodeName(u,"table")?u.getElementsByTagName("tbody")[0]||
u.appendChild(u.ownerDocument.createElement("tbody")):u}var e,j,i=a[0],o=[],k;if(!c.support.checkClone&&arguments.length===3&&typeof i==="string"&&ua.test(i))return this.each(function(){c(this).domManip(a,b,d,true)});if(c.isFunction(i))return this.each(function(u){var z=c(this);a[0]=i.call(this,u,b?z.html():w);z.domManip(a,b,d)});if(this[0]){e=i&&i.parentNode;e=c.support.parentNode&&e&&e.nodeType===11&&e.childNodes.length===this.length?{fragment:e}:sa(a,this,o);k=e.fragment;if(j=k.childNodes.length===
1?(k=k.firstChild):k.firstChild){b=b&&c.nodeName(j,"tr");for(var n=0,r=this.length;n<r;n++)d.call(b?f(this[n],j):this[n],n>0||e.cacheable||this.length>1?k.cloneNode(true):k)}o.length&&c.each(o,Qa)}return this}});c.fragments={};c.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},function(a,b){c.fn[a]=function(d){var f=[];d=c(d);var e=this.length===1&&this[0].parentNode;if(e&&e.nodeType===11&&e.childNodes.length===1&&d.length===1){d[b](this[0]);
return this}else{e=0;for(var j=d.length;e<j;e++){var i=(e>0?this.clone(true):this).get();c.fn[b].apply(c(d[e]),i);f=f.concat(i)}return this.pushStack(f,a,d.selector)}}});c.extend({clean:function(a,b,d,f){b=b||s;if(typeof b.createElement==="undefined")b=b.ownerDocument||b[0]&&b[0].ownerDocument||s;for(var e=[],j=0,i;(i=a[j])!=null;j++){if(typeof i==="number")i+="";if(i){if(typeof i==="string"&&!jb.test(i))i=b.createTextNode(i);else if(typeof i==="string"){i=i.replace(Ka,Ma);var o=(La.exec(i)||["",
""])[1].toLowerCase(),k=F[o]||F._default,n=k[0],r=b.createElement("div");for(r.innerHTML=k[1]+i+k[2];n--;)r=r.lastChild;if(!c.support.tbody){n=ib.test(i);o=o==="table"&&!n?r.firstChild&&r.firstChild.childNodes:k[1]==="<table>"&&!n?r.childNodes:[];for(k=o.length-1;k>=0;--k)c.nodeName(o[k],"tbody")&&!o[k].childNodes.length&&o[k].parentNode.removeChild(o[k])}!c.support.leadingWhitespace&&V.test(i)&&r.insertBefore(b.createTextNode(V.exec(i)[0]),r.firstChild);i=r.childNodes}if(i.nodeType)e.push(i);else e=
c.merge(e,i)}}if(d)for(j=0;e[j];j++)if(f&&c.nodeName(e[j],"script")&&(!e[j].type||e[j].type.toLowerCase()==="text/javascript"))f.push(e[j].parentNode?e[j].parentNode.removeChild(e[j]):e[j]);else{e[j].nodeType===1&&e.splice.apply(e,[j+1,0].concat(c.makeArray(e[j].getElementsByTagName("script"))));d.appendChild(e[j])}return e},cleanData:function(a){for(var b,d,f=c.cache,e=c.event.special,j=c.support.deleteExpando,i=0,o;(o=a[i])!=null;i++)if(d=o[c.expando]){b=f[d];if(b.events)for(var k in b.events)e[k]?
c.event.remove(o,k):Ca(o,k,b.handle);if(j)delete o[c.expando];else o.removeAttribute&&o.removeAttribute(c.expando);delete f[d]}}});var kb=/z-?index|font-?weight|opacity|zoom|line-?height/i,Na=/alpha\\([^)]*\\)/,Oa=/opacity=([^)]*)/,ha=/float/i,ia=/-([a-z])/ig,lb=/([A-Z])/g,mb=/^-?\\d+(?:px)?$/i,nb=/^-?\\d/,ob={position:"absolute",visibility:"hidden",display:"block"},pb=["Left","Right"],qb=["Top","Bottom"],rb=s.defaultView&&s.defaultView.getComputedStyle,Pa=c.support.cssFloat?"cssFloat":"styleFloat",ja=
function(a,b){return b.toUpperCase()};c.fn.css=function(a,b){return X(this,a,b,true,function(d,f,e){if(e===w)return c.curCSS(d,f);if(typeof e==="number"&&!kb.test(f))e+="px";c.style(d,f,e)})};c.extend({style:function(a,b,d){if(!a||a.nodeType===3||a.nodeType===8)return w;if((b==="width"||b==="height")&&parseFloat(d)<0)d=w;var f=a.style||a,e=d!==w;if(!c.support.opacity&&b==="opacity"){if(e){f.zoom=1;b=parseInt(d,10)+""==="NaN"?"":"alpha(opacity="+d*100+")";a=f.filter||c.curCSS(a,"filter")||"";f.filter=
Na.test(a)?a.replace(Na,b):b}return f.filter&&f.filter.indexOf("opacity=")>=0?parseFloat(Oa.exec(f.filter)[1])/100+"":""}if(ha.test(b))b=Pa;b=b.replace(ia,ja);if(e)f[b]=d;return f[b]},css:function(a,b,d,f){if(b==="width"||b==="height"){var e,j=b==="width"?pb:qb;function i(){e=b==="width"?a.offsetWidth:a.offsetHeight;f!=="border"&&c.each(j,function(){f||(e-=parseFloat(c.curCSS(a,"padding"+this,true))||0);if(f==="margin")e+=parseFloat(c.curCSS(a,"margin"+this,true))||0;else e-=parseFloat(c.curCSS(a,
"border"+this+"Width",true))||0})}a.offsetWidth!==0?i():c.swap(a,ob,i);return Math.max(0,Math.round(e))}return c.curCSS(a,b,d)},curCSS:function(a,b,d){var f,e=a.style;if(!c.support.opacity&&b==="opacity"&&a.currentStyle){f=Oa.test(a.currentStyle.filter||"")?parseFloat(RegExp.$1)/100+"":"";return f===""?"1":f}if(ha.test(b))b=Pa;if(!d&&e&&e[b])f=e[b];else if(rb){if(ha.test(b))b="float";b=b.replace(lb,"-$1").toLowerCase();e=a.ownerDocument.defaultView;if(!e)return null;if(a=e.getComputedStyle(a,null))f=
a.getPropertyValue(b);if(b==="opacity"&&f==="")f="1"}else if(a.currentStyle){d=b.replace(ia,ja);f=a.currentStyle[b]||a.currentStyle[d];if(!mb.test(f)&&nb.test(f)){b=e.left;var j=a.runtimeStyle.left;a.runtimeStyle.left=a.currentStyle.left;e.left=d==="fontSize"?"1em":f||0;f=e.pixelLeft+"px";e.left=b;a.runtimeStyle.left=j}}return f},swap:function(a,b,d){var f={};for(var e in b){f[e]=a.style[e];a.style[e]=b[e]}d.call(a);for(e in b)a.style[e]=f[e]}});if(c.expr&&c.expr.filters){c.expr.filters.hidden=function(a){var b=
a.offsetWidth,d=a.offsetHeight,f=a.nodeName.toLowerCase()==="tr";return b===0&&d===0&&!f?true:b>0&&d>0&&!f?false:c.curCSS(a,"display")==="none"};c.expr.filters.visible=function(a){return!c.expr.filters.hidden(a)}}var sb=J(),tb=/<script(.|\\s)*?\\/script>/gi,ub=/select|textarea/i,vb=/color|date|datetime|email|hidden|month|number|password|range|search|tel|text|time|url|week/i,N=/=\\?(&|$)/,ka=/\\?/,wb=/(\\?|&)_=.*?(&|$)/,xb=/^(\\w+:)?\\/\\/([^\\/?#]+)/,yb=/%20/g,zb=c.fn.load;c.fn.extend({load:function(a,b,d){if(typeof a!==
"string")return zb.call(this,a);else if(!this.length)return this;var f=a.indexOf(" ");if(f>=0){var e=a.slice(f,a.length);a=a.slice(0,f)}f="GET";if(b)if(c.isFunction(b)){d=b;b=null}else if(typeof b==="object"){b=c.param(b,c.ajaxSettings.traditional);f="POST"}var j=this;c.ajax({url:a,type:f,dataType:"html",data:b,complete:function(i,o){if(o==="success"||o==="notmodified")j.html(e?c("<div />").append(i.responseText.replace(tb,"")).find(e):i.responseText);d&&j.each(d,[i.responseText,o,i])}});return this},
serialize:function(){return c.param(this.serializeArray())},serializeArray:function(){return this.map(function(){return this.elements?c.makeArray(this.elements):this}).filter(function(){return this.name&&!this.disabled&&(this.checked||ub.test(this.nodeName)||vb.test(this.type))}).map(function(a,b){a=c(this).val();return a==null?null:c.isArray(a)?c.map(a,function(d){return{name:b.name,value:d}}):{name:b.name,value:a}}).get()}});c.each("ajaxStart ajaxStop ajaxComplete ajaxError ajaxSuccess ajaxSend".split(" "),
function(a,b){c.fn[b]=function(d){return this.bind(b,d)}});c.extend({get:function(a,b,d,f){if(c.isFunction(b)){f=f||d;d=b;b=null}return c.ajax({type:"GET",url:a,data:b,success:d,dataType:f})},getScript:function(a,b){return c.get(a,null,b,"script")},getJSON:function(a,b,d){return c.get(a,b,d,"json")},post:function(a,b,d,f){if(c.isFunction(b)){f=f||d;d=b;b={}}return c.ajax({type:"POST",url:a,data:b,success:d,dataType:f})},ajaxSetup:function(a){c.extend(c.ajaxSettings,a)},ajaxSettings:{url:location.href,
global:true,type:"GET",contentType:"application/x-www-form-urlencoded",processData:true,async:true,xhr:A.XMLHttpRequest&&(A.location.protocol!=="file:"||!A.ActiveXObject)?function(){return new A.XMLHttpRequest}:function(){try{return new A.ActiveXObject("Microsoft.XMLHTTP")}catch(a){}},accepts:{xml:"application/xml, text/xml",html:"text/html",script:"text/javascript, application/javascript",json:"application/json, text/javascript",text:"text/plain",_default:"*/*"}},lastModified:{},etag:{},ajax:function(a){function b(){e.success&&
e.success.call(k,o,i,x);e.global&&f("ajaxSuccess",[x,e])}function d(){e.complete&&e.complete.call(k,x,i);e.global&&f("ajaxComplete",[x,e]);e.global&&!--c.active&&c.event.trigger("ajaxStop")}function f(q,p){(e.context?c(e.context):c.event).trigger(q,p)}var e=c.extend(true,{},c.ajaxSettings,a),j,i,o,k=a&&a.context||e,n=e.type.toUpperCase();if(e.data&&e.processData&&typeof e.data!=="string")e.data=c.param(e.data,e.traditional);if(e.dataType==="jsonp"){if(n==="GET")N.test(e.url)||(e.url+=(ka.test(e.url)?
"&":"?")+(e.jsonp||"callback")+"=?");else if(!e.data||!N.test(e.data))e.data=(e.data?e.data+"&":"")+(e.jsonp||"callback")+"=?";e.dataType="json"}if(e.dataType==="json"&&(e.data&&N.test(e.data)||N.test(e.url))){j=e.jsonpCallback||"jsonp"+sb++;if(e.data)e.data=(e.data+"").replace(N,"="+j+"$1");e.url=e.url.replace(N,"="+j+"$1");e.dataType="script";A[j]=A[j]||function(q){o=q;b();d();A[j]=w;try{delete A[j]}catch(p){}z&&z.removeChild(C)}}if(e.dataType==="script"&&e.cache===null)e.cache=false;if(e.cache===
false&&n==="GET"){var r=J(),u=e.url.replace(wb,"$1_="+r+"$2");e.url=u+(u===e.url?(ka.test(e.url)?"&":"?")+"_="+r:"")}if(e.data&&n==="GET")e.url+=(ka.test(e.url)?"&":"?")+e.data;e.global&&!c.active++&&c.event.trigger("ajaxStart");r=(r=xb.exec(e.url))&&(r[1]&&r[1]!==location.protocol||r[2]!==location.host);if(e.dataType==="script"&&n==="GET"&&r){var z=s.getElementsByTagName("head")[0]||s.documentElement,C=s.createElement("script");C.src=e.url;if(e.scriptCharset)C.charset=e.scriptCharset;if(!j){var B=
false;C.onload=C.onreadystatechange=function(){if(!B&&(!this.readyState||this.readyState==="loaded"||this.readyState==="complete")){B=true;b();d();C.onload=C.onreadystatechange=null;z&&C.parentNode&&z.removeChild(C)}}}z.insertBefore(C,z.firstChild);return w}var E=false,x=e.xhr();if(x){e.username?x.open(n,e.url,e.async,e.username,e.password):x.open(n,e.url,e.async);try{if(e.data||a&&a.contentType)x.setRequestHeader("Content-Type",e.contentType);if(e.ifModified){c.lastModified[e.url]&&x.setRequestHeader("If-Modified-Since",
c.lastModified[e.url]);c.etag[e.url]&&x.setRequestHeader("If-None-Match",c.etag[e.url])}r||x.setRequestHeader("X-Requested-With","XMLHttpRequest");x.setRequestHeader("Accept",e.dataType&&e.accepts[e.dataType]?e.accepts[e.dataType]+", */*":e.accepts._default)}catch(ga){}if(e.beforeSend&&e.beforeSend.call(k,x,e)===false){e.global&&!--c.active&&c.event.trigger("ajaxStop");x.abort();return false}e.global&&f("ajaxSend",[x,e]);var g=x.onreadystatechange=function(q){if(!x||x.readyState===0||q==="abort"){E||
d();E=true;if(x)x.onreadystatechange=c.noop}else if(!E&&x&&(x.readyState===4||q==="timeout")){E=true;x.onreadystatechange=c.noop;i=q==="timeout"?"timeout":!c.httpSuccess(x)?"error":e.ifModified&&c.httpNotModified(x,e.url)?"notmodified":"success";var p;if(i==="success")try{o=c.httpData(x,e.dataType,e)}catch(v){i="parsererror";p=v}if(i==="success"||i==="notmodified")j||b();else c.handleError(e,x,i,p);d();q==="timeout"&&x.abort();if(e.async)x=null}};try{var h=x.abort;x.abort=function(){x&&h.call(x);
g("abort")}}catch(l){}e.async&&e.timeout>0&&setTimeout(function(){x&&!E&&g("timeout")},e.timeout);try{x.send(n==="POST"||n==="PUT"||n==="DELETE"?e.data:null)}catch(m){c.handleError(e,x,null,m);d()}e.async||g();return x}},handleError:function(a,b,d,f){if(a.error)a.error.call(a.context||a,b,d,f);if(a.global)(a.context?c(a.context):c.event).trigger("ajaxError",[b,a,f])},active:0,httpSuccess:function(a){try{return!a.status&&location.protocol==="file:"||a.status>=200&&a.status<300||a.status===304||a.status===
1223||a.status===0}catch(b){}return false},httpNotModified:function(a,b){var d=a.getResponseHeader("Last-Modified"),f=a.getResponseHeader("Etag");if(d)c.lastModified[b]=d;if(f)c.etag[b]=f;return a.status===304||a.status===0},httpData:function(a,b,d){var f=a.getResponseHeader("content-type")||"",e=b==="xml"||!b&&f.indexOf("xml")>=0;a=e?a.responseXML:a.responseText;e&&a.documentElement.nodeName==="parsererror"&&c.error("parsererror");if(d&&d.dataFilter)a=d.dataFilter(a,b);if(typeof a==="string")if(b===
"json"||!b&&f.indexOf("json")>=0)a=c.parseJSON(a);else if(b==="script"||!b&&f.indexOf("javascript")>=0)c.globalEval(a);return a},param:function(a,b){function d(i,o){if(c.isArray(o))c.each(o,function(k,n){b||/\\[\\]$/.test(i)?f(i,n):d(i+"["+(typeof n==="object"||c.isArray(n)?k:"")+"]",n)});else!b&&o!=null&&typeof o==="object"?c.each(o,function(k,n){d(i+"["+k+"]",n)}):f(i,o)}function f(i,o){o=c.isFunction(o)?o():o;e[e.length]=encodeURIComponent(i)+"="+encodeURIComponent(o)}var e=[];if(b===w)b=c.ajaxSettings.traditional;
if(c.isArray(a)||a.jquery)c.each(a,function(){f(this.name,this.value)});else for(var j in a)d(j,a[j]);return e.join("&").replace(yb,"+")}});var la={},Ab=/toggle|show|hide/,Bb=/^([+-]=)?([\\d+-.]+)(.*)$/,W,va=[["height","marginTop","marginBottom","paddingTop","paddingBottom"],["width","marginLeft","marginRight","paddingLeft","paddingRight"],["opacity"]];c.fn.extend({show:function(a,b){if(a||a===0)return this.animate(K("show",3),a,b);else{a=0;for(b=this.length;a<b;a++){var d=c.data(this[a],"olddisplay");
this[a].style.display=d||"";if(c.css(this[a],"display")==="none"){d=this[a].nodeName;var f;if(la[d])f=la[d];else{var e=c("<"+d+" />").appendTo("body");f=e.css("display");if(f==="none")f="block";e.remove();la[d]=f}c.data(this[a],"olddisplay",f)}}a=0;for(b=this.length;a<b;a++)this[a].style.display=c.data(this[a],"olddisplay")||"";return this}},hide:function(a,b){if(a||a===0)return this.animate(K("hide",3),a,b);else{a=0;for(b=this.length;a<b;a++){var d=c.data(this[a],"olddisplay");!d&&d!=="none"&&c.data(this[a],
"olddisplay",c.css(this[a],"display"))}a=0;for(b=this.length;a<b;a++)this[a].style.display="none";return this}},_toggle:c.fn.toggle,toggle:function(a,b){var d=typeof a==="boolean";if(c.isFunction(a)&&c.isFunction(b))this._toggle.apply(this,arguments);else a==null||d?this.each(function(){var f=d?a:c(this).is(":hidden");c(this)[f?"show":"hide"]()}):this.animate(K("toggle",3),a,b);return this},fadeTo:function(a,b,d){return this.filter(":hidden").css("opacity",0).show().end().animate({opacity:b},a,d)},
animate:function(a,b,d,f){var e=c.speed(b,d,f);if(c.isEmptyObject(a))return this.each(e.complete);return this[e.queue===false?"each":"queue"](function(){var j=c.extend({},e),i,o=this.nodeType===1&&c(this).is(":hidden"),k=this;for(i in a){var n=i.replace(ia,ja);if(i!==n){a[n]=a[i];delete a[i];i=n}if(a[i]==="hide"&&o||a[i]==="show"&&!o)return j.complete.call(this);if((i==="height"||i==="width")&&this.style){j.display=c.css(this,"display");j.overflow=this.style.overflow}if(c.isArray(a[i])){(j.specialEasing=
j.specialEasing||{})[i]=a[i][1];a[i]=a[i][0]}}if(j.overflow!=null)this.style.overflow="hidden";j.curAnim=c.extend({},a);c.each(a,function(r,u){var z=new c.fx(k,j,r);if(Ab.test(u))z[u==="toggle"?o?"show":"hide":u](a);else{var C=Bb.exec(u),B=z.cur(true)||0;if(C){u=parseFloat(C[2]);var E=C[3]||"px";if(E!=="px"){k.style[r]=(u||1)+E;B=(u||1)/z.cur(true)*B;k.style[r]=B+E}if(C[1])u=(C[1]==="-="?-1:1)*u+B;z.custom(B,u,E)}else z.custom(B,u,"")}});return true})},stop:function(a,b){var d=c.timers;a&&this.queue([]);
this.each(function(){for(var f=d.length-1;f>=0;f--)if(d[f].elem===this){b&&d[f](true);d.splice(f,1)}});b||this.dequeue();return this}});c.each({slideDown:K("show",1),slideUp:K("hide",1),slideToggle:K("toggle",1),fadeIn:{opacity:"show"},fadeOut:{opacity:"hide"}},function(a,b){c.fn[a]=function(d,f){return this.animate(b,d,f)}});c.extend({speed:function(a,b,d){var f=a&&typeof a==="object"?a:{complete:d||!d&&b||c.isFunction(a)&&a,duration:a,easing:d&&b||b&&!c.isFunction(b)&&b};f.duration=c.fx.off?0:typeof f.duration===
"number"?f.duration:c.fx.speeds[f.duration]||c.fx.speeds._default;f.old=f.complete;f.complete=function(){f.queue!==false&&c(this).dequeue();c.isFunction(f.old)&&f.old.call(this)};return f},easing:{linear:function(a,b,d,f){return d+f*a},swing:function(a,b,d,f){return(-Math.cos(a*Math.PI)/2+0.5)*f+d}},timers:[],fx:function(a,b,d){this.options=b;this.elem=a;this.prop=d;if(!b.orig)b.orig={}}});c.fx.prototype={update:function(){this.options.step&&this.options.step.call(this.elem,this.now,this);(c.fx.step[this.prop]||
c.fx.step._default)(this);if((this.prop==="height"||this.prop==="width")&&this.elem.style)this.elem.style.display="block"},cur:function(a){if(this.elem[this.prop]!=null&&(!this.elem.style||this.elem.style[this.prop]==null))return this.elem[this.prop];return(a=parseFloat(c.css(this.elem,this.prop,a)))&&a>-10000?a:parseFloat(c.curCSS(this.elem,this.prop))||0},custom:function(a,b,d){function f(j){return e.step(j)}this.startTime=J();this.start=a;this.end=b;this.unit=d||this.unit||"px";this.now=this.start;
this.pos=this.state=0;var e=this;f.elem=this.elem;if(f()&&c.timers.push(f)&&!W)W=setInterval(c.fx.tick,13)},show:function(){this.options.orig[this.prop]=c.style(this.elem,this.prop);this.options.show=true;this.custom(this.prop==="width"||this.prop==="height"?1:0,this.cur());c(this.elem).show()},hide:function(){this.options.orig[this.prop]=c.style(this.elem,this.prop);this.options.hide=true;this.custom(this.cur(),0)},step:function(a){var b=J(),d=true;if(a||b>=this.options.duration+this.startTime){this.now=
this.end;this.pos=this.state=1;this.update();this.options.curAnim[this.prop]=true;for(var f in this.options.curAnim)if(this.options.curAnim[f]!==true)d=false;if(d){if(this.options.display!=null){this.elem.style.overflow=this.options.overflow;a=c.data(this.elem,"olddisplay");this.elem.style.display=a?a:this.options.display;if(c.css(this.elem,"display")==="none")this.elem.style.display="block"}this.options.hide&&c(this.elem).hide();if(this.options.hide||this.options.show)for(var e in this.options.curAnim)c.style(this.elem,
e,this.options.orig[e]);this.options.complete.call(this.elem)}return false}else{e=b-this.startTime;this.state=e/this.options.duration;a=this.options.easing||(c.easing.swing?"swing":"linear");this.pos=c.easing[this.options.specialEasing&&this.options.specialEasing[this.prop]||a](this.state,e,0,1,this.options.duration);this.now=this.start+(this.end-this.start)*this.pos;this.update()}return true}};c.extend(c.fx,{tick:function(){for(var a=c.timers,b=0;b<a.length;b++)a[b]()||a.splice(b--,1);a.length||
c.fx.stop()},stop:function(){clearInterval(W);W=null},speeds:{slow:600,fast:200,_default:400},step:{opacity:function(a){c.style(a.elem,"opacity",a.now)},_default:function(a){if(a.elem.style&&a.elem.style[a.prop]!=null)a.elem.style[a.prop]=(a.prop==="width"||a.prop==="height"?Math.max(0,a.now):a.now)+a.unit;else a.elem[a.prop]=a.now}}});if(c.expr&&c.expr.filters)c.expr.filters.animated=function(a){return c.grep(c.timers,function(b){return a===b.elem}).length};c.fn.offset="getBoundingClientRect"in s.documentElement?
function(a){var b=this[0];if(a)return this.each(function(e){c.offset.setOffset(this,a,e)});if(!b||!b.ownerDocument)return null;if(b===b.ownerDocument.body)return c.offset.bodyOffset(b);var d=b.getBoundingClientRect(),f=b.ownerDocument;b=f.body;f=f.documentElement;return{top:d.top+(self.pageYOffset||c.support.boxModel&&f.scrollTop||b.scrollTop)-(f.clientTop||b.clientTop||0),left:d.left+(self.pageXOffset||c.support.boxModel&&f.scrollLeft||b.scrollLeft)-(f.clientLeft||b.clientLeft||0)}}:function(a){var b=
this[0];if(a)return this.each(function(r){c.offset.setOffset(this,a,r)});if(!b||!b.ownerDocument)return null;if(b===b.ownerDocument.body)return c.offset.bodyOffset(b);c.offset.initialize();var d=b.offsetParent,f=b,e=b.ownerDocument,j,i=e.documentElement,o=e.body;f=(e=e.defaultView)?e.getComputedStyle(b,null):b.currentStyle;for(var k=b.offsetTop,n=b.offsetLeft;(b=b.parentNode)&&b!==o&&b!==i;){if(c.offset.supportsFixedPosition&&f.position==="fixed")break;j=e?e.getComputedStyle(b,null):b.currentStyle;
k-=b.scrollTop;n-=b.scrollLeft;if(b===d){k+=b.offsetTop;n+=b.offsetLeft;if(c.offset.doesNotAddBorder&&!(c.offset.doesAddBorderForTableAndCells&&/^t(able|d|h)$/i.test(b.nodeName))){k+=parseFloat(j.borderTopWidth)||0;n+=parseFloat(j.borderLeftWidth)||0}f=d;d=b.offsetParent}if(c.offset.subtractsBorderForOverflowNotVisible&&j.overflow!=="visible"){k+=parseFloat(j.borderTopWidth)||0;n+=parseFloat(j.borderLeftWidth)||0}f=j}if(f.position==="relative"||f.position==="static"){k+=o.offsetTop;n+=o.offsetLeft}if(c.offset.supportsFixedPosition&&
f.position==="fixed"){k+=Math.max(i.scrollTop,o.scrollTop);n+=Math.max(i.scrollLeft,o.scrollLeft)}return{top:k,left:n}};c.offset={initialize:function(){var a=s.body,b=s.createElement("div"),d,f,e,j=parseFloat(c.curCSS(a,"marginTop",true))||0;c.extend(b.style,{position:"absolute",top:0,left:0,margin:0,border:0,width:"1px",height:"1px",visibility:"hidden"});b.innerHTML="<div style='position:absolute;top:0;left:0;margin:0;border:5px solid #000;padding:0;width:1px;height:1px;'><div></div></div><table style='position:absolute;top:0;left:0;margin:0;border:5px solid #000;padding:0;width:1px;height:1px;' cellpadding='0' cellspacing='0'><tr><td></td></tr></table>";
a.insertBefore(b,a.firstChild);d=b.firstChild;f=d.firstChild;e=d.nextSibling.firstChild.firstChild;this.doesNotAddBorder=f.offsetTop!==5;this.doesAddBorderForTableAndCells=e.offsetTop===5;f.style.position="fixed";f.style.top="20px";this.supportsFixedPosition=f.offsetTop===20||f.offsetTop===15;f.style.position=f.style.top="";d.style.overflow="hidden";d.style.position="relative";this.subtractsBorderForOverflowNotVisible=f.offsetTop===-5;this.doesNotIncludeMarginInBodyOffset=a.offsetTop!==j;a.removeChild(b);
c.offset.initialize=c.noop},bodyOffset:function(a){var b=a.offsetTop,d=a.offsetLeft;c.offset.initialize();if(c.offset.doesNotIncludeMarginInBodyOffset){b+=parseFloat(c.curCSS(a,"marginTop",true))||0;d+=parseFloat(c.curCSS(a,"marginLeft",true))||0}return{top:b,left:d}},setOffset:function(a,b,d){if(/static/.test(c.curCSS(a,"position")))a.style.position="relative";var f=c(a),e=f.offset(),j=parseInt(c.curCSS(a,"top",true),10)||0,i=parseInt(c.curCSS(a,"left",true),10)||0;if(c.isFunction(b))b=b.call(a,
d,e);d={top:b.top-e.top+j,left:b.left-e.left+i};"using"in b?b.using.call(a,d):f.css(d)}};c.fn.extend({position:function(){if(!this[0])return null;var a=this[0],b=this.offsetParent(),d=this.offset(),f=/^body|html$/i.test(b[0].nodeName)?{top:0,left:0}:b.offset();d.top-=parseFloat(c.curCSS(a,"marginTop",true))||0;d.left-=parseFloat(c.curCSS(a,"marginLeft",true))||0;f.top+=parseFloat(c.curCSS(b[0],"borderTopWidth",true))||0;f.left+=parseFloat(c.curCSS(b[0],"borderLeftWidth",true))||0;return{top:d.top-
f.top,left:d.left-f.left}},offsetParent:function(){return this.map(function(){for(var a=this.offsetParent||s.body;a&&!/^body|html$/i.test(a.nodeName)&&c.css(a,"position")==="static";)a=a.offsetParent;return a})}});c.each(["Left","Top"],function(a,b){var d="scroll"+b;c.fn[d]=function(f){var e=this[0],j;if(!e)return null;if(f!==w)return this.each(function(){if(j=wa(this))j.scrollTo(!a?f:c(j).scrollLeft(),a?f:c(j).scrollTop());else this[d]=f});else return(j=wa(e))?"pageXOffset"in j?j[a?"pageYOffset":
"pageXOffset"]:c.support.boxModel&&j.document.documentElement[d]||j.document.body[d]:e[d]}});c.each(["Height","Width"],function(a,b){var d=b.toLowerCase();c.fn["inner"+b]=function(){return this[0]?c.css(this[0],d,false,"padding"):null};c.fn["outer"+b]=function(f){return this[0]?c.css(this[0],d,false,f?"margin":"border"):null};c.fn[d]=function(f){var e=this[0];if(!e)return f==null?null:this;if(c.isFunction(f))return this.each(function(j){var i=c(this);i[d](f.call(this,j,i[d]()))});return"scrollTo"in
e&&e.document?e.document.compatMode==="CSS1Compat"&&e.document.documentElement["client"+b]||e.document.body["client"+b]:e.nodeType===9?Math.max(e.documentElement["client"+b],e.body["scroll"+b],e.documentElement["scroll"+b],e.body["offset"+b],e.documentElement["offset"+b]):f===w?c.css(e,d):this.css(d,typeof f==="string"?f:f+"px")}});A.jQuery=A.$=c})(window);

/*
 * 
 * TableSorter 2.0 - Client-side table sorting with ease!
 * Version 2.0.3
 * @requires jQuery v1.2.3
 * 
 * Copyright (c) 2007 Christian Bach
 * Examples and docs at: http://tablesorter.com
 * Dual licensed under the MIT and GPL licenses:
 * http://www.opensource.org/licenses/mit-license.php
 * http://www.gnu.org/licenses/gpl.html
 * 
 */
(function($){$.extend({tablesorter:new function(){var parsers=[],widgets=[];this.defaults={cssHeader:"header",cssAsc:"headerSortUp",cssDesc:"headerSortDown",sortInitialOrder:"asc",sortMultiSortKey:"shiftKey",sortForce:null,sortAppend:null,textExtraction:"simple",parsers:{},widgets:[],widgetZebra:{css:["even","odd"]},headers:{},widthFixed:false,cancelSelection:true,sortList:[],headerList:[],dateFormat:"us",decimal:'.',debug:false};function benchmark(s,d){log(s+","+(new Date().getTime()-d.getTime())+"ms");}this.benchmark=benchmark;function log(s){if(typeof console!="undefined"&&typeof console.debug!="undefined"){console.log(s);}else{alert(s);}}function buildParserCache(table,$headers){if(table.config.debug){var parsersDebug="";}var rows=table.tBodies[0].rows;if(table.tBodies[0].rows[0]){var list=[],cells=rows[0].cells,l=cells.length;for(var i=0;i<l;i++){var p=false;if($.metadata&&($($headers[i]).metadata()&&$($headers[i]).metadata().sorter)){p=getParserById($($headers[i]).metadata().sorter);}else if((table.config.headers[i]&&table.config.headers[i].sorter)){p=getParserById(table.config.headers[i].sorter);}if(!p){p=detectParserForColumn(table,cells[i]);}if(table.config.debug){parsersDebug+="column:"+i+" parser:"+p.id+"\\n";}list.push(p);}}if(table.config.debug){log(parsersDebug);}return list;};function detectParserForColumn(table,node){var l=parsers.length;for(var i=1;i<l;i++){if(parsers[i].is($.trim(getElementText(table.config,node)),table,node)){return parsers[i];}}return parsers[0];}function getParserById(name){var l=parsers.length;for(var i=0;i<l;i++){if(parsers[i].id.toLowerCase()==name.toLowerCase()){return parsers[i];}}return false;}function buildCache(table){if(table.config.debug){var cacheTime=new Date();}var totalRows=(table.tBodies[0]&&table.tBodies[0].rows.length)||0,totalCells=(table.tBodies[0].rows[0]&&table.tBodies[0].rows[0].cells.length)||0,parsers=table.config.parsers,cache={row:[],normalized:[]};for(var i=0;i<totalRows;++i){var c=table.tBodies[0].rows[i],cols=[];cache.row.push($(c));for(var j=0;j<totalCells;++j){cols.push(parsers[j].format(getElementText(table.config,c.cells[j]),table,c.cells[j]));}cols.push(i);cache.normalized.push(cols);cols=null;};if(table.config.debug){benchmark("Building cache for "+totalRows+" rows:",cacheTime);}return cache;};function getElementText(config,node){if(!node)return"";var t="";if(config.textExtraction=="simple"){if(node.childNodes[0]&&node.childNodes[0].hasChildNodes()){t=node.childNodes[0].innerHTML;}else{t=node.innerHTML;}}else{if(typeof(config.textExtraction)=="function"){t=config.textExtraction(node);}else{t=$(node).text();}}return t;}function appendToTable(table,cache){if(table.config.debug){var appendTime=new Date()}var c=cache,r=c.row,n=c.normalized,totalRows=n.length,checkCell=(n[0].length-1),tableBody=$(table.tBodies[0]),rows=[];for(var i=0;i<totalRows;i++){rows.push(r[n[i][checkCell]]);if(!table.config.appender){var o=r[n[i][checkCell]];var l=o.length;for(var j=0;j<l;j++){tableBody[0].appendChild(o[j]);}}}if(table.config.appender){table.config.appender(table,rows);}rows=null;if(table.config.debug){benchmark("Rebuilt table:",appendTime);}applyWidget(table);setTimeout(function(){$(table).trigger("sortEnd");},0);};function buildHeaders(table){if(table.config.debug){var time=new Date();}var meta=($.metadata)?true:false,tableHeadersRows=[];for(var i=0;i<table.tHead.rows.length;i++){tableHeadersRows[i]=0;};$tableHeaders=$("thead th",table);$tableHeaders.each(function(index){this.count=0;this.column=index;this.order=formatSortingOrder(table.config.sortInitialOrder);if(checkHeaderMetadata(this)||checkHeaderOptions(table,index))this.sortDisabled=true;if(!this.sortDisabled){$(this).addClass(table.config.cssHeader);}table.config.headerList[index]=this;});if(table.config.debug){benchmark("Built headers:",time);log($tableHeaders);}return $tableHeaders;};function checkCellColSpan(table,rows,row){var arr=[],r=table.tHead.rows,c=r[row].cells;for(var i=0;i<c.length;i++){var cell=c[i];if(cell.colSpan>1){arr=arr.concat(checkCellColSpan(table,headerArr,row++));}else{if(table.tHead.length==1||(cell.rowSpan>1||!r[row+1])){arr.push(cell);}}}return arr;};function checkHeaderMetadata(cell){if(($.metadata)&&($(cell).metadata().sorter===false)){return true;};return false;}function checkHeaderOptions(table,i){if((table.config.headers[i])&&(table.config.headers[i].sorter===false)){return true;};return false;}function applyWidget(table){var c=table.config.widgets;var l=c.length;for(var i=0;i<l;i++){getWidgetById(c[i]).format(table);}}function getWidgetById(name){var l=widgets.length;for(var i=0;i<l;i++){if(widgets[i].id.toLowerCase()==name.toLowerCase()){return widgets[i];}}};function formatSortingOrder(v){if(typeof(v)!="Number"){i=(v.toLowerCase()=="desc")?1:0;}else{i=(v==(0||1))?v:0;}return i;}function isValueInArray(v,a){var l=a.length;for(var i=0;i<l;i++){if(a[i][0]==v){return true;}}return false;}function setHeadersCss(table,$headers,list,css){$headers.removeClass(css[0]).removeClass(css[1]);var h=[];$headers.each(function(offset){if(!this.sortDisabled){h[this.column]=$(this);}});var l=list.length;for(var i=0;i<l;i++){h[list[i][0]].addClass(css[list[i][1]]);}}function fixColumnWidth(table,$headers){var c=table.config;if(c.widthFixed){var colgroup=$('<colgroup>');$("tr:first td",table.tBodies[0]).each(function(){colgroup.append($('<col>').css('width',$(this).width()));});$(table).prepend(colgroup);};}function updateHeaderSortCount(table,sortList){var c=table.config,l=sortList.length;for(var i=0;i<l;i++){var s=sortList[i],o=c.headerList[s[0]];o.count=s[1];o.count++;}}function multisort(table,sortList,cache){if(table.config.debug){var sortTime=new Date();}var dynamicExp="var sortWrapper = function(a,b) {",l=sortList.length;for(var i=0;i<l;i++){var c=sortList[i][0];var order=sortList[i][1];var s=(getCachedSortType(table.config.parsers,c)=="text")?((order==0)?"sortText":"sortTextDesc"):((order==0)?"sortNumeric":"sortNumericDesc");var e="e"+i;dynamicExp+="var "+e+" = "+s+"(a["+c+"],b["+c+"]); ";dynamicExp+="if("+e+") { return "+e+"; } ";dynamicExp+="else { ";}var orgOrderCol=cache.normalized[0].length-1;dynamicExp+="return a["+orgOrderCol+"]-b["+orgOrderCol+"];";for(var i=0;i<l;i++){dynamicExp+="}; ";}dynamicExp+="return 0; ";dynamicExp+="}; ";eval(dynamicExp);cache.normalized.sort(sortWrapper);if(table.config.debug){benchmark("Sorting on "+sortList.toString()+" and dir "+order+" time:",sortTime);}return cache;};function sortText(a,b){return((a<b)?-1:((a>b)?1:0));};function sortTextDesc(a,b){return((b<a)?-1:((b>a)?1:0));};function sortNumeric(a,b){return a-b;};function sortNumericDesc(a,b){return b-a;};function getCachedSortType(parsers,i){return parsers[i].type;};this.construct=function(settings){return this.each(function(){if(!this.tHead||!this.tBodies)return;var $this,$document,$headers,cache,config,shiftDown=0,sortOrder;this.config={};config=$.extend(this.config,$.tablesorter.defaults,settings);$this=$(this);$headers=buildHeaders(this);this.config.parsers=buildParserCache(this,$headers);cache=buildCache(this);var sortCSS=[config.cssDesc,config.cssAsc];fixColumnWidth(this);$headers.click(function(e){$this.trigger("sortStart");var totalRows=($this[0].tBodies[0]&&$this[0].tBodies[0].rows.length)||0;if(!this.sortDisabled&&totalRows>0){var $cell=$(this);var i=this.column;this.order=this.count++%2;if(!e[config.sortMultiSortKey]){config.sortList=[];if(config.sortForce!=null){var a=config.sortForce;for(var j=0;j<a.length;j++){if(a[j][0]!=i){config.sortList.push(a[j]);}}}config.sortList.push([i,this.order]);}else{if(isValueInArray(i,config.sortList)){for(var j=0;j<config.sortList.length;j++){var s=config.sortList[j],o=config.headerList[s[0]];if(s[0]==i){o.count=s[1];o.count++;s[1]=o.count%2;}}}else{config.sortList.push([i,this.order]);}};setTimeout(function(){setHeadersCss($this[0],$headers,config.sortList,sortCSS);appendToTable($this[0],multisort($this[0],config.sortList,cache));},1);return false;}}).mousedown(function(){if(config.cancelSelection){this.onselectstart=function(){return false};return false;}});$this.bind("update",function(){this.config.parsers=buildParserCache(this,$headers);cache=buildCache(this);}).bind("sorton",function(e,list){$(this).trigger("sortStart");config.sortList=list;var sortList=config.sortList;updateHeaderSortCount(this,sortList);setHeadersCss(this,$headers,sortList,sortCSS);appendToTable(this,multisort(this,sortList,cache));}).bind("appendCache",function(){appendToTable(this,cache);}).bind("applyWidgetId",function(e,id){getWidgetById(id).format(this);}).bind("applyWidgets",function(){applyWidget(this);});if($.metadata&&($(this).metadata()&&$(this).metadata().sortlist)){config.sortList=$(this).metadata().sortlist;}if(config.sortList.length>0){$this.trigger("sorton",[config.sortList]);}applyWidget(this);});};this.addParser=function(parser){var l=parsers.length,a=true;for(var i=0;i<l;i++){if(parsers[i].id.toLowerCase()==parser.id.toLowerCase()){a=false;}}if(a){parsers.push(parser);};};this.addWidget=function(widget){widgets.push(widget);};this.formatFloat=function(s){var i=parseFloat(s);return(isNaN(i))?0:i;};this.formatInt=function(s){var i=parseInt(s);return(isNaN(i))?0:i;};this.isDigit=function(s,config){var DECIMAL='\\\\'+config.decimal;var exp='/(^[+]?0('+DECIMAL+'0+)?$)|(^([-+]?[1-9][0-9]*)$)|(^([-+]?((0?|[1-9][0-9]*)'+DECIMAL+'(0*[1-9][0-9]*)))$)|(^[-+]?[1-9]+[0-9]*'+DECIMAL+'0+$)/';return RegExp(exp).test($.trim(s));};this.clearTableBody=function(table){if($.browser.msie){function empty(){while(this.firstChild)this.removeChild(this.firstChild);}empty.apply(table.tBodies[0]);}else{table.tBodies[0].innerHTML="";}};}});$.fn.extend({tablesorter:$.tablesorter.construct});var ts=$.tablesorter;ts.addParser({id:"text",is:function(s){return true;},format:function(s){return $.trim(s.toLowerCase());},type:"text"});ts.addParser({id:"digit",is:function(s,table){var c=table.config;return $.tablesorter.isDigit(s,c);},format:function(s){return $.tablesorter.formatFloat(s);},type:"numeric"});ts.addParser({id:"currency",is:function(s){return/^[£$€?.]/.test(s);},format:function(s){return $.tablesorter.formatFloat(s.replace(new RegExp(/[^0-9.]/g),""));},type:"numeric"});ts.addParser({id:"ipAddress",is:function(s){return/^\\d{2,3}[\\.]\\d{2,3}[\\.]\\d{2,3}[\\.]\\d{2,3}$/.test(s);},format:function(s){var a=s.split("."),r="",l=a.length;for(var i=0;i<l;i++){var item=a[i];if(item.length==2){r+="0"+item;}else{r+=item;}}return $.tablesorter.formatFloat(r);},type:"numeric"});ts.addParser({id:"url",is:function(s){return/^(https?|ftp|file):\\/\\/$/.test(s);},format:function(s){return jQuery.trim(s.replace(new RegExp(/(https?|ftp|file):\\/\\//),''));},type:"text"});ts.addParser({id:"isoDate",is:function(s){return/^\\d{4}[\\/-]\\d{1,2}[\\/-]\\d{1,2}$/.test(s);},format:function(s){return $.tablesorter.formatFloat((s!="")?new Date(s.replace(new RegExp(/-/g),"/")).getTime():"0");},type:"numeric"});ts.addParser({id:"percent",is:function(s){return/\\%$/.test($.trim(s));},format:function(s){return $.tablesorter.formatFloat(s.replace(new RegExp(/%/g),""));},type:"numeric"});ts.addParser({id:"usLongDate",is:function(s){return s.match(new RegExp(/^[A-Za-z]{3,10}\\.? [0-9]{1,2}, ([0-9]{4}|'?[0-9]{2}) (([0-2]?[0-9]:[0-5][0-9])|([0-1]?[0-9]:[0-5][0-9]\\s(AM|PM)))$/));},format:function(s){return $.tablesorter.formatFloat(new Date(s).getTime());},type:"numeric"});ts.addParser({id:"shortDate",is:function(s){return/\\d{1,2}[\\/\\-]\\d{1,2}[\\/\\-]\\d{2,4}/.test(s);},format:function(s,table){var c=table.config;s=s.replace(/\\-/g,"/");if(c.dateFormat=="us"){s=s.replace(/(\\d{1,2})[\\/\\-](\\d{1,2})[\\/\\-](\\d{4})/,"$3/$1/$2");}else if(c.dateFormat=="uk"){s=s.replace(/(\\d{1,2})[\\/\\-](\\d{1,2})[\\/\\-](\\d{4})/,"$3/$2/$1");}else if(c.dateFormat=="dd/mm/yy"||c.dateFormat=="dd-mm-yy"){s=s.replace(/(\\d{1,2})[\\/\\-](\\d{1,2})[\\/\\-](\\d{2})/,"$1/$2/$3");}return $.tablesorter.formatFloat(new Date(s).getTime());},type:"numeric"});ts.addParser({id:"time",is:function(s){return/^(([0-2]?[0-9]:[0-5][0-9])|([0-1]?[0-9]:[0-5][0-9]\\s(am|pm)))$/.test(s);},format:function(s){return $.tablesorter.formatFloat(new Date("2000/01/01 "+s).getTime());},type:"numeric"});ts.addParser({id:"metadata",is:function(s){return false;},format:function(s,table,cell){var c=table.config,p=(!c.parserMetadataName)?'sortValue':c.parserMetadataName;return $(cell).metadata()[p];},type:"numeric"});ts.addWidget({id:"zebra",format:function(table){if(table.config.debug){var time=new Date();}$("tr:visible",table.tBodies[0]).filter(':even').removeClass(table.config.widgetZebra.css[1]).addClass(table.config.widgetZebra.css[0]).end().filter(':odd').removeClass(table.config.widgetZebra.css[0]).addClass(table.config.widgetZebra.css[1]);if(table.config.debug){$.tablesorter.benchmark("Applying Zebra widget",time);}}});})(jQuery);

$(document).ready(function(){ 
    $.tablesorter.addParser({ 
        // set a unique id 
        id: 'b3level', 
        is: function(s) { 
            // return false so this parser is not auto detected 
            return false; 
        }, 
        format: function(cellcontent, domtable, domcell) { 
            // format your data for normalization 
            //console.log(domcell, $("span", domcell).attr('title').split(' - ')[0]);
            var val = -1;
            var title = $("span", domcell).attr('title');
            if (typeof title != "undefined" && title.length > 0) {
                val =  parseInt(title.split(' - ')[0], 0);
            } else {
                val = parseInt(cellcontent, 0);
            }
            return val;
        }, 
        // set type, either numeric or text 
        type: 'numeric' 
    }); 
    $("#bodyarea table").tablesorter({
        sortList: [[0,0],[1,0],[2,0]],
        headers: { 
            1: { sorter:'b3level' } ,
            2: { sorter:'b3level' },
            5: { sorter: false }
        } 
    });
    $("#bodyarea table thead th:lt(5)").css('cursor', 'pointer');
}); 
        //]]>
        """
        
        html = """<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
        <html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
        <head>
            <meta http-equiv="content-type" content="text/html; charset=utf-8" />
            <title>B3 user documentation for %(server)s</title>
            <style type="text/css">%(cssstyle)s</style>
        </head>
        <body>
            <div id="header">
                <div id="head-wrap">
                    <div id="logo">
                        <a title="go to BigBrotherBot website" href="http://www.bigbrotherbot.net/">
                            <img alt="BigBrotherBot" src='data:image/jpeg;base64,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'/>

                        </a>
                    </div>
                </div>
            </div>
            <div id="bodyarea">
                <h1>BigBrotherBot commands documentation for %(server)s</h1>
                <p>updated on %(dateUpdated)s</p>
                %(commandsTable)s
            </div>
            <p style="border: 10px; float: right;">
                <a href="http://validator.w3.org/check?uri=referer"><img
                src="http://www.w3.org/Icons/valid-xhtml10"
                alt="Valid XHTML 1.0 Transitional" height="31" width="88" style="border: 0;"/></a>
            </p>
            <script type="text/javascript">%(javascript)s</script>
        </body>
        </html>
        """ 
        
        return html % {
            'server': self._console._publicIp +':'+ str(self._console._port),
            'cssstyle': cssstyle,
            'javascript': javascript,
            'dateUpdated': time.asctime(),
            'commandsTable': self.getHtmlTable()
        } 
    
    
    def getHtmlTable(self):
        text = """
            <table id="b3commands">
                <thead>
                    <tr>
                        <th class="b3Plugin">plugin</th>
                        <th class="b3MinLevel">min level</th>
                        <th class="b3MaxLevel">max level</th>
                        <th class="b3Name">command</th>
                        <th class="b3Alias">alias</th>
                        <th class="b3Desc">description</th>
                    </tr>
                </thead>
                <tbody>
                %(commandsTablerow)s
                </tbody>
            </table>
        """
        
        def friendlyLevel(level):
            try:
                intlevel = int(level)
                if intlevel <= 0:
                    return '<span title="%s - Everyone">All</span>' % level
                elif intlevel == 1:
                    return '<span title="%s - Registered players">user</span>' % level
                elif intlevel < 20:
                    return '<span title="%s - Regular players">reg</span>' % level
                elif intlevel < 40:
                    return '<span title="%s - Moderators">mod</span>' % level
                elif intlevel < 60:
                    return '<span title="%s - Admins">admin</span>' % level
                elif intlevel < 80:
                    return '<span title="%s - Full admins">fulladmin</span>' % level
                elif intlevel < 100:
                    return '<span title="%s - Senior admins">senioradmin</span>' % level
                elif intlevel >= 100:
                    return '<span title="%s - Super admins">superadmin</span>' % level
                else:
                    return level
            except:
                return level
        
        htmlCommands = ""
        for cmd in self._getCommandsDict():
            html = """<tr class="b3command">
                <td class="b3Plugin">%(plugin)s</td>
                <td class="b3MinLevel">%(minlevel)s</td>
                <td class="b3MaxLevel">%(maxlevel)s</td>
                <td class="b3Name">%(name)s</td>
                <td class="b3Alias">%(alias)s</td>
                <td class="b3Desc">%(description)s</td>
                </tr>
                """
            cmd['minlevel'] = friendlyLevel(cmd['minlevel'])
            cmd['maxlevel'] = friendlyLevel(cmd['maxlevel'])
            htmlCommands += html % cmd
        return text % {'commandsTablerow': htmlCommands}
    
    def _getCommandsDict(self):
        if self._maxlevel is not None:
            self._console.debug('AUTODOC: get commands with level <= %s' % self._maxlevel)
        commands = {}
        for cmd in self._adminPlugin._commands.values():
            if cmd in commands or \
                cmd.level is None:
                continue
            if self._maxlevel is not None and cmd.level[0] > self._maxlevel:
                continue
            
            #self._console.debug('AUTODOC: making command doc for %s'%cmd.command)
            tmp = {}
            tmp['name'] = cmd.prefix + cmd.command
            tmp['alias'] = ""
            if cmd.alias is not None and cmd.alias != '' :
                tmp['alias'] = cmd.prefix + cmd.alias
            tmp['plugin'] = re.sub('Plugin$', '', cmd.plugin.__class__.__name__) 
            tmp['description'] = escape(cmd.help)
            tmp['minlevel'] = str(cmd.level[0])
            tmp['maxlevel'] = str(cmd.level[1])
            commands[cmd] = tmp
            
        def commands_compare(x, y):
            if x['plugin'] < y['plugin']: return -1
            elif x['plugin'] > y['plugin']: return 1

            elif int(x['minlevel']) < int(y['minlevel']): return -1
            elif int(x['minlevel']) > int(y['minlevel']): return 1

            elif x['name'] < y['name']: return -1
            elif x['name'] > y['name']: return 1

            else:
                return 0

        listCommands = commands.values()
        listCommands.sort(commands_compare)
        return listCommands
    
    def _write(self, text):
        
        if text.strip() == '':
            self._console.warning('AUTODOC: nothing to write')
            
        dsn = splitDSN(self._outputUrl)
        
        if dsn['protocol'] == 'ftp':
            self._console.debug('Uploading to FTP server %s' % dsn['host'])
            ftp=FTP(dsn['host'],dsn['user'],passwd=dsn['password'])
            ftp.cwd(os.path.dirname(dsn['path']))
            ftpfile = StringIO.StringIO()
            ftpfile.write(text)
            ftpfile.seek(0)
            ftp.storbinary('STOR '+os.path.basename(dsn['path']), ftpfile)
        elif dsn['protocol'] == 'file':
            self._console.debug('Writing to %s', dsn['path'])
            f = file(dsn['path'], 'w')
            f.write(text)
            f.close()
        else:
            self._console.error('AUTODOC: protocol [%s] is not supported' % dsn['protocol'])
            