from Products.LinguaPlone.browser.menu import TranslateMenu
from Products.LinguaPlone.tests.base import LinguaPloneTestCase
from Products.LinguaPlone.tests.utils import makeContent


class TranslateMenuTests(LinguaPloneTestCase):

    def afterSetUp(self):
        self.addLanguage('de')
        self.setLanguage('en')

    def testLanguageSpecificContentCanBeTranslatedIntoOtherLanguages(self):
        doc = makeContent(self.folder, 'SimpleType', 'doc')
        self.assertEqual(doc.getLanguage(), 'en')
        menu = TranslateMenu('translations')
        self.assertEqual([i['title'] for i in menu.getMenuItems(doc, None)],
            [u'German', u'label_manage_translations'])
        self.addLanguage('no')
        self.assertEqual([i['title'] for i in menu.getMenuItems(doc, None)],
            [u'German', u'Norwegian', u'label_manage_translations'])

    def testNeutralContentCannotBeTranslatedDirectly(self):
        self.folder.setLanguage('')
        doc = makeContent(self.folder, 'SimpleType', 'doc')
        self.assertEqual(doc.getLanguage(), '')
        menu = TranslateMenu('translations')
        items = menu.getMenuItems(doc, None)
        self.assertEqual([i['title'] for i in items],
            [u'label_manage_translations'])
