#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Thu Mar 02 12:23:26 2017 by generateDS.py version 2.23a.
#
# Command line options:
#   ('-a', 'bc:')
#   ('-o', 'snapp_email\\datacontract\\classes.py')
#   ('-s', 'snapp_email\\datacontract\\subclasses.py')
#   ('--export', '')
#   ('--member-specs', 'dict')
#
# Command line arguments:
#   snapp_email\generate\SdkWebServiceDataContract.xsd
#
# Command line:
#   C:\Users\uroshe\AppData\Local\Programs\Python\Python35-32\Scripts\generateDS.py -a "bc:" -o "snapp_email\datacontract\classes.py" -s "snapp_email\datacontract\subclasses.py" --export --member-specs="dict" snapp_email\generate\SdkWebServiceDataContract.xsd
#
# Current working directory (os.getcwd()):
#   4thOfficeClient.py
#

import sys
import re as re_
import base64
import datetime as datetime_
import warnings as warnings_
try:
    from lxml import etree as etree_
except ImportError:
    from xml.etree import ElementTree as etree_


Validate_simpletypes_ = True
if sys.version_info.major == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError as exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integers')
            return values
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_validate_float(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of floats')
            return values
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of doubles')
            return values
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(
                        node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return values
        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (time_parts[0], micro_seconds, )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(
                                hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.  We should:
            # - AND the outer elements
            # - OR the inner elements
            found1 = True
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    if re_.search(patterns2, target) is not None:
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.iteritems()))
        @staticmethod
        def gds_encode(instring):
            if sys.version_info.major == 2:
                return instring.encode(ExternalEncoding)
            else:
                return instring

    def getSubclassFromModule_(module, class_):
        '''Get the subclass of a class from a specific module.'''
        name = class_.__name__ + 'Sub'
        if hasattr(module, name):
            return getattr(module, name)
        else:
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ''
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s2 = ''
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos:mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start():mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class ApiIndex_1(GeneratedsSuper):
    member_data_items_ = {
        'ProductName': MemberSpec_('ProductName', 'string', 0),
        'HttpHeaderList': MemberSpec_('HttpHeaderList', 'ListOfHttpHeaders_12', 0),
        'UrlParameterList': MemberSpec_('UrlParameterList', 'ListOfApiIndexParameters_1', 0),
        'ApiIndexLinkList': MemberSpec_('ApiIndexLinkList', 'ListOfApiIndexLinks_1', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, ProductName=None, HttpHeaderList=None, UrlParameterList=None, ApiIndexLinkList=None):
        self.original_tagname_ = None
        self.ProductName = ProductName
        self.HttpHeaderList = HttpHeaderList
        self.UrlParameterList = UrlParameterList
        self.ApiIndexLinkList = ApiIndexLinkList
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ApiIndex_1)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ApiIndex_1.subclass:
            return ApiIndex_1.subclass(*args_, **kwargs_)
        else:
            return ApiIndex_1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ProductName(self): return self.ProductName
    def set_ProductName(self, ProductName): self.ProductName = ProductName
    def get_HttpHeaderList(self): return self.HttpHeaderList
    def set_HttpHeaderList(self, HttpHeaderList): self.HttpHeaderList = HttpHeaderList
    def get_UrlParameterList(self): return self.UrlParameterList
    def set_UrlParameterList(self, UrlParameterList): self.UrlParameterList = UrlParameterList
    def get_ApiIndexLinkList(self): return self.ApiIndexLinkList
    def set_ApiIndexLinkList(self, ApiIndexLinkList): self.ApiIndexLinkList = ApiIndexLinkList
    def hasContent_(self):
        if (
            self.ProductName is not None or
            self.HttpHeaderList is not None or
            self.UrlParameterList is not None or
            self.ApiIndexLinkList is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ProductName':
            ProductName_ = child_.text
            ProductName_ = self.gds_validate_string(ProductName_, node, 'ProductName')
            self.ProductName = ProductName_
        elif nodeName_ == 'HttpHeaderList':
            obj_ = ListOfHttpHeaders_12.factory()
            obj_.build(child_)
            self.HttpHeaderList = obj_
            obj_.original_tagname_ = 'HttpHeaderList'
        elif nodeName_ == 'UrlParameterList':
            obj_ = ListOfApiIndexParameters_1.factory()
            obj_.build(child_)
            self.UrlParameterList = obj_
            obj_.original_tagname_ = 'UrlParameterList'
        elif nodeName_ == 'ApiIndexLinkList':
            obj_ = ListOfApiIndexLinks_1.factory()
            obj_.build(child_)
            self.ApiIndexLinkList = obj_
            obj_.original_tagname_ = 'ApiIndexLinkList'
# end class ApiIndex_1


class ListOfHttpHeaders_12(GeneratedsSuper):
    member_data_items_ = {
        'HttpHeader': MemberSpec_('HttpHeader', 'HttpHeader_12', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, HttpHeader=None):
        self.original_tagname_ = None
        if HttpHeader is None:
            self.HttpHeader = []
        else:
            self.HttpHeader = HttpHeader
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfHttpHeaders_12)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfHttpHeaders_12.subclass:
            return ListOfHttpHeaders_12.subclass(*args_, **kwargs_)
        else:
            return ListOfHttpHeaders_12(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_HttpHeader(self): return self.HttpHeader
    def set_HttpHeader(self, HttpHeader): self.HttpHeader = HttpHeader
    def add_HttpHeader(self, value): self.HttpHeader.append(value)
    def insert_HttpHeader_at(self, index, value): self.HttpHeader.insert(index, value)
    def replace_HttpHeader_at(self, index, value): self.HttpHeader[index] = value
    def hasContent_(self):
        if (
            self.HttpHeader
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'HttpHeader':
            obj_ = HttpHeader_12.factory()
            obj_.build(child_)
            self.HttpHeader.append(obj_)
            obj_.original_tagname_ = 'HttpHeader'
# end class ListOfHttpHeaders_12


class HttpHeader_12(GeneratedsSuper):
    member_data_items_ = {
        'Name': MemberSpec_('Name', 'string', 0),
        'Description': MemberSpec_('Description', 'string', 0),
        'Required': MemberSpec_('Required', 'boolean', 0),
        'SupportedValues': MemberSpec_('SupportedValues', 'ListOfHttpValueDescriptions', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Name=None, Description=None, Required=None, SupportedValues=None):
        self.original_tagname_ = None
        self.Name = Name
        self.Description = Description
        self.Required = Required
        self.SupportedValues = SupportedValues
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, HttpHeader_12)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if HttpHeader_12.subclass:
            return HttpHeader_12.subclass(*args_, **kwargs_)
        else:
            return HttpHeader_12(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Required(self): return self.Required
    def set_Required(self, Required): self.Required = Required
    def get_SupportedValues(self): return self.SupportedValues
    def set_SupportedValues(self, SupportedValues): self.SupportedValues = SupportedValues
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Description is not None or
            self.Required is not None or
            self.SupportedValues is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Description':
            Description_ = child_.text
            Description_ = self.gds_validate_string(Description_, node, 'Description')
            self.Description = Description_
        elif nodeName_ == 'Required':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'Required')
            self.Required = ival_
        elif nodeName_ == 'SupportedValues':
            obj_ = ListOfHttpValueDescriptions.factory()
            obj_.build(child_)
            self.SupportedValues = obj_
            obj_.original_tagname_ = 'SupportedValues'
# end class HttpHeader_12


class HttpValueDescription(GeneratedsSuper):
    member_data_items_ = {
        'Value': MemberSpec_('Value', 'string', 0),
        'Description': MemberSpec_('Description', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Value=None, Description=None):
        self.original_tagname_ = None
        self.Value = Value
        self.Description = Description
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, HttpValueDescription)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if HttpValueDescription.subclass:
            return HttpValueDescription.subclass(*args_, **kwargs_)
        else:
            return HttpValueDescription(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def hasContent_(self):
        if (
            self.Value is not None or
            self.Description is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Value':
            Value_ = child_.text
            Value_ = self.gds_validate_string(Value_, node, 'Value')
            self.Value = Value_
        elif nodeName_ == 'Description':
            Description_ = child_.text
            Description_ = self.gds_validate_string(Description_, node, 'Description')
            self.Description = Description_
# end class HttpValueDescription


class ListOfHttpValueDescriptions(GeneratedsSuper):
    member_data_items_ = {
        'ValueDescription': MemberSpec_('ValueDescription', 'HttpValueDescription', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, ValueDescription=None):
        self.original_tagname_ = None
        if ValueDescription is None:
            self.ValueDescription = []
        else:
            self.ValueDescription = ValueDescription
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfHttpValueDescriptions)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfHttpValueDescriptions.subclass:
            return ListOfHttpValueDescriptions.subclass(*args_, **kwargs_)
        else:
            return ListOfHttpValueDescriptions(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ValueDescription(self): return self.ValueDescription
    def set_ValueDescription(self, ValueDescription): self.ValueDescription = ValueDescription
    def add_ValueDescription(self, value): self.ValueDescription.append(value)
    def insert_ValueDescription_at(self, index, value): self.ValueDescription.insert(index, value)
    def replace_ValueDescription_at(self, index, value): self.ValueDescription[index] = value
    def hasContent_(self):
        if (
            self.ValueDescription
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ValueDescription':
            obj_ = HttpValueDescription.factory()
            obj_.build(child_)
            self.ValueDescription.append(obj_)
            obj_.original_tagname_ = 'ValueDescription'
# end class ListOfHttpValueDescriptions


class ListOfApiIndexLinks_1(GeneratedsSuper):
    member_data_items_ = {
        'ApiIndexLink': MemberSpec_('ApiIndexLink', 'ApiIndexLink_1', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, ApiIndexLink=None):
        self.original_tagname_ = None
        if ApiIndexLink is None:
            self.ApiIndexLink = []
        else:
            self.ApiIndexLink = ApiIndexLink
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfApiIndexLinks_1)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfApiIndexLinks_1.subclass:
            return ListOfApiIndexLinks_1.subclass(*args_, **kwargs_)
        else:
            return ListOfApiIndexLinks_1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ApiIndexLink(self): return self.ApiIndexLink
    def set_ApiIndexLink(self, ApiIndexLink): self.ApiIndexLink = ApiIndexLink
    def add_ApiIndexLink(self, value): self.ApiIndexLink.append(value)
    def insert_ApiIndexLink_at(self, index, value): self.ApiIndexLink.insert(index, value)
    def replace_ApiIndexLink_at(self, index, value): self.ApiIndexLink[index] = value
    def hasContent_(self):
        if (
            self.ApiIndexLink
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ApiIndexLink':
            obj_ = ApiIndexLink_1.factory()
            obj_.build(child_)
            self.ApiIndexLink.append(obj_)
            obj_.original_tagname_ = 'ApiIndexLink'
# end class ListOfApiIndexLinks_1


class ApiIndexLink_1(GeneratedsSuper):
    member_data_items_ = {
        'Name': MemberSpec_('Name', 'string', 0),
        'Description': MemberSpec_('Description', 'string', 0),
        'Href': MemberSpec_('Href', 'string', 0),
        'ContentTypes': MemberSpec_('ContentTypes', 'ListOfContentTypes', 0),
        'Methods': MemberSpec_('Methods', 'ListOfApiIndexMethods_1', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Name=None, Description=None, Href=None, ContentTypes=None, Methods=None):
        self.original_tagname_ = None
        self.Name = Name
        self.Description = Description
        self.Href = Href
        self.ContentTypes = ContentTypes
        self.Methods = Methods
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ApiIndexLink_1)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ApiIndexLink_1.subclass:
            return ApiIndexLink_1.subclass(*args_, **kwargs_)
        else:
            return ApiIndexLink_1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Href(self): return self.Href
    def set_Href(self, Href): self.Href = Href
    def get_ContentTypes(self): return self.ContentTypes
    def set_ContentTypes(self, ContentTypes): self.ContentTypes = ContentTypes
    def get_Methods(self): return self.Methods
    def set_Methods(self, Methods): self.Methods = Methods
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Description is not None or
            self.Href is not None or
            self.ContentTypes is not None or
            self.Methods is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Description':
            Description_ = child_.text
            Description_ = self.gds_validate_string(Description_, node, 'Description')
            self.Description = Description_
        elif nodeName_ == 'Href':
            Href_ = child_.text
            Href_ = self.gds_validate_string(Href_, node, 'Href')
            self.Href = Href_
        elif nodeName_ == 'ContentTypes':
            obj_ = ListOfContentTypes.factory()
            obj_.build(child_)
            self.ContentTypes = obj_
            obj_.original_tagname_ = 'ContentTypes'
        elif nodeName_ == 'Methods':
            obj_ = ListOfApiIndexMethods_1.factory()
            obj_.build(child_)
            self.Methods = obj_
            obj_.original_tagname_ = 'Methods'
# end class ApiIndexLink_1


class ListOfContentTypes(GeneratedsSuper):
    member_data_items_ = {
        'ContentType': MemberSpec_('ContentType', 'string', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, ContentType=None):
        self.original_tagname_ = None
        if ContentType is None:
            self.ContentType = []
        else:
            self.ContentType = ContentType
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfContentTypes)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfContentTypes.subclass:
            return ListOfContentTypes.subclass(*args_, **kwargs_)
        else:
            return ListOfContentTypes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ContentType(self): return self.ContentType
    def set_ContentType(self, ContentType): self.ContentType = ContentType
    def add_ContentType(self, value): self.ContentType.append(value)
    def insert_ContentType_at(self, index, value): self.ContentType.insert(index, value)
    def replace_ContentType_at(self, index, value): self.ContentType[index] = value
    def hasContent_(self):
        if (
            self.ContentType
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ContentType':
            ContentType_ = child_.text
            ContentType_ = self.gds_validate_string(ContentType_, node, 'ContentType')
            self.ContentType.append(ContentType_)
# end class ListOfContentTypes


class ListOfApiIndexOptions_4(GeneratedsSuper):
    member_data_items_ = {
        'Options': MemberSpec_('Options', 'ApiIndexOptions_1', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Options=None):
        self.original_tagname_ = None
        if Options is None:
            self.Options = []
        else:
            self.Options = Options
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfApiIndexOptions_4)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfApiIndexOptions_4.subclass:
            return ListOfApiIndexOptions_4.subclass(*args_, **kwargs_)
        else:
            return ListOfApiIndexOptions_4(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Options(self): return self.Options
    def set_Options(self, Options): self.Options = Options
    def add_Options(self, value): self.Options.append(value)
    def insert_Options_at(self, index, value): self.Options.insert(index, value)
    def replace_Options_at(self, index, value): self.Options[index] = value
    def hasContent_(self):
        if (
            self.Options
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Options':
            obj_ = ApiIndexOptions_1.factory()
            obj_.build(child_)
            self.Options.append(obj_)
            obj_.original_tagname_ = 'Options'
# end class ListOfApiIndexOptions_4


class ApiIndexOptions_1(GeneratedsSuper):
    member_data_items_ = {
        'Name': MemberSpec_('Name', 'string', 0),
        'Methods': MemberSpec_('Methods', 'ListOfApiIndexMethods_1', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Name=None, Methods=None):
        self.original_tagname_ = None
        self.Name = Name
        self.Methods = Methods
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ApiIndexOptions_1)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ApiIndexOptions_1.subclass:
            return ApiIndexOptions_1.subclass(*args_, **kwargs_)
        else:
            return ApiIndexOptions_1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Methods(self): return self.Methods
    def set_Methods(self, Methods): self.Methods = Methods
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Methods is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Methods':
            obj_ = ListOfApiIndexMethods_1.factory()
            obj_.build(child_)
            self.Methods = obj_
            obj_.original_tagname_ = 'Methods'
# end class ApiIndexOptions_1


class ApiIndexMethod_1(GeneratedsSuper):
    member_data_items_ = {
        'Type': MemberSpec_('Type', 'string', 0),
        'Description': MemberSpec_('Description', 'string', 0),
        'Parameters': MemberSpec_('Parameters', 'ListOfApiIndexParameters_1', 0),
        'HttpHeaderList': MemberSpec_('HttpHeaderList', 'ListOfHttpHeaders_12', 0),
        'HttpErrorList': MemberSpec_('HttpErrorList', 'ListOfApiIndexErrors_1', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Type=None, Description=None, Parameters=None, HttpHeaderList=None, HttpErrorList=None):
        self.original_tagname_ = None
        self.Type = Type
        self.Description = Description
        self.Parameters = Parameters
        self.HttpHeaderList = HttpHeaderList
        self.HttpErrorList = HttpErrorList
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ApiIndexMethod_1)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ApiIndexMethod_1.subclass:
            return ApiIndexMethod_1.subclass(*args_, **kwargs_)
        else:
            return ApiIndexMethod_1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Type(self): return self.Type
    def set_Type(self, Type): self.Type = Type
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Parameters(self): return self.Parameters
    def set_Parameters(self, Parameters): self.Parameters = Parameters
    def get_HttpHeaderList(self): return self.HttpHeaderList
    def set_HttpHeaderList(self, HttpHeaderList): self.HttpHeaderList = HttpHeaderList
    def get_HttpErrorList(self): return self.HttpErrorList
    def set_HttpErrorList(self, HttpErrorList): self.HttpErrorList = HttpErrorList
    def hasContent_(self):
        if (
            self.Type is not None or
            self.Description is not None or
            self.Parameters is not None or
            self.HttpHeaderList is not None or
            self.HttpErrorList is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Type':
            Type_ = child_.text
            Type_ = self.gds_validate_string(Type_, node, 'Type')
            self.Type = Type_
        elif nodeName_ == 'Description':
            Description_ = child_.text
            Description_ = self.gds_validate_string(Description_, node, 'Description')
            self.Description = Description_
        elif nodeName_ == 'Parameters':
            obj_ = ListOfApiIndexParameters_1.factory()
            obj_.build(child_)
            self.Parameters = obj_
            obj_.original_tagname_ = 'Parameters'
        elif nodeName_ == 'HttpHeaderList':
            obj_ = ListOfHttpHeaders_12.factory()
            obj_.build(child_)
            self.HttpHeaderList = obj_
            obj_.original_tagname_ = 'HttpHeaderList'
        elif nodeName_ == 'HttpErrorList':
            obj_ = ListOfApiIndexErrors_1.factory()
            obj_.build(child_)
            self.HttpErrorList = obj_
            obj_.original_tagname_ = 'HttpErrorList'
# end class ApiIndexMethod_1


class ListOfApiIndexMethods_1(GeneratedsSuper):
    member_data_items_ = {
        'ApiIndexMethod': MemberSpec_('ApiIndexMethod', 'ApiIndexMethod_1', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, ApiIndexMethod=None):
        self.original_tagname_ = None
        if ApiIndexMethod is None:
            self.ApiIndexMethod = []
        else:
            self.ApiIndexMethod = ApiIndexMethod
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfApiIndexMethods_1)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfApiIndexMethods_1.subclass:
            return ListOfApiIndexMethods_1.subclass(*args_, **kwargs_)
        else:
            return ListOfApiIndexMethods_1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ApiIndexMethod(self): return self.ApiIndexMethod
    def set_ApiIndexMethod(self, ApiIndexMethod): self.ApiIndexMethod = ApiIndexMethod
    def add_ApiIndexMethod(self, value): self.ApiIndexMethod.append(value)
    def insert_ApiIndexMethod_at(self, index, value): self.ApiIndexMethod.insert(index, value)
    def replace_ApiIndexMethod_at(self, index, value): self.ApiIndexMethod[index] = value
    def hasContent_(self):
        if (
            self.ApiIndexMethod
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ApiIndexMethod':
            obj_ = ApiIndexMethod_1.factory()
            obj_.build(child_)
            self.ApiIndexMethod.append(obj_)
            obj_.original_tagname_ = 'ApiIndexMethod'
# end class ListOfApiIndexMethods_1


class ApiIndexParameter_1(GeneratedsSuper):
    member_data_items_ = {
        'Type': MemberSpec_('Type', 'string', 0),
        'Name': MemberSpec_('Name', 'string', 0),
        'Description': MemberSpec_('Description', 'string', 0),
        'AvailableValues': MemberSpec_('AvailableValues', 'ListOfStrings', 0),
        'Required': MemberSpec_('Required', 'boolean', 0),
        'IsList': MemberSpec_('IsList', 'boolean', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Type=None, Name=None, Description=None, AvailableValues=None, Required=None, IsList=None):
        self.original_tagname_ = None
        self.Type = Type
        self.Name = Name
        self.Description = Description
        self.AvailableValues = AvailableValues
        self.Required = Required
        self.IsList = IsList
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ApiIndexParameter_1)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ApiIndexParameter_1.subclass:
            return ApiIndexParameter_1.subclass(*args_, **kwargs_)
        else:
            return ApiIndexParameter_1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Type(self): return self.Type
    def set_Type(self, Type): self.Type = Type
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_AvailableValues(self): return self.AvailableValues
    def set_AvailableValues(self, AvailableValues): self.AvailableValues = AvailableValues
    def get_Required(self): return self.Required
    def set_Required(self, Required): self.Required = Required
    def get_IsList(self): return self.IsList
    def set_IsList(self, IsList): self.IsList = IsList
    def hasContent_(self):
        if (
            self.Type is not None or
            self.Name is not None or
            self.Description is not None or
            self.AvailableValues is not None or
            self.Required is not None or
            self.IsList is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Type':
            Type_ = child_.text
            Type_ = self.gds_validate_string(Type_, node, 'Type')
            self.Type = Type_
        elif nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Description':
            Description_ = child_.text
            Description_ = self.gds_validate_string(Description_, node, 'Description')
            self.Description = Description_
        elif nodeName_ == 'AvailableValues':
            obj_ = ListOfStrings.factory()
            obj_.build(child_)
            self.AvailableValues = obj_
            obj_.original_tagname_ = 'AvailableValues'
        elif nodeName_ == 'Required':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'Required')
            self.Required = ival_
        elif nodeName_ == 'IsList':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsList')
            self.IsList = ival_
# end class ApiIndexParameter_1


class ListOfApiIndexParameters_1(GeneratedsSuper):
    member_data_items_ = {
        'ApiIndexParameter': MemberSpec_('ApiIndexParameter', 'ApiIndexParameter_1', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, ApiIndexParameter=None):
        self.original_tagname_ = None
        if ApiIndexParameter is None:
            self.ApiIndexParameter = []
        else:
            self.ApiIndexParameter = ApiIndexParameter
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfApiIndexParameters_1)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfApiIndexParameters_1.subclass:
            return ListOfApiIndexParameters_1.subclass(*args_, **kwargs_)
        else:
            return ListOfApiIndexParameters_1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ApiIndexParameter(self): return self.ApiIndexParameter
    def set_ApiIndexParameter(self, ApiIndexParameter): self.ApiIndexParameter = ApiIndexParameter
    def add_ApiIndexParameter(self, value): self.ApiIndexParameter.append(value)
    def insert_ApiIndexParameter_at(self, index, value): self.ApiIndexParameter.insert(index, value)
    def replace_ApiIndexParameter_at(self, index, value): self.ApiIndexParameter[index] = value
    def hasContent_(self):
        if (
            self.ApiIndexParameter
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ApiIndexParameter':
            obj_ = ApiIndexParameter_1.factory()
            obj_.build(child_)
            self.ApiIndexParameter.append(obj_)
            obj_.original_tagname_ = 'ApiIndexParameter'
# end class ListOfApiIndexParameters_1


class ApiIndexError_1(GeneratedsSuper):
    member_data_items_ = {
        'Description': MemberSpec_('Description', 'string', 0),
        'HttpStatusCode': MemberSpec_('HttpStatusCode', 'string', 0),
        'ErrorCode': MemberSpec_('ErrorCode', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Description=None, HttpStatusCode=None, ErrorCode=None):
        self.original_tagname_ = None
        self.Description = Description
        self.HttpStatusCode = HttpStatusCode
        self.ErrorCode = ErrorCode
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ApiIndexError_1)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ApiIndexError_1.subclass:
            return ApiIndexError_1.subclass(*args_, **kwargs_)
        else:
            return ApiIndexError_1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_HttpStatusCode(self): return self.HttpStatusCode
    def set_HttpStatusCode(self, HttpStatusCode): self.HttpStatusCode = HttpStatusCode
    def get_ErrorCode(self): return self.ErrorCode
    def set_ErrorCode(self, ErrorCode): self.ErrorCode = ErrorCode
    def hasContent_(self):
        if (
            self.Description is not None or
            self.HttpStatusCode is not None or
            self.ErrorCode is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Description':
            Description_ = child_.text
            Description_ = self.gds_validate_string(Description_, node, 'Description')
            self.Description = Description_
        elif nodeName_ == 'HttpStatusCode':
            HttpStatusCode_ = child_.text
            HttpStatusCode_ = self.gds_validate_string(HttpStatusCode_, node, 'HttpStatusCode')
            self.HttpStatusCode = HttpStatusCode_
        elif nodeName_ == 'ErrorCode':
            ErrorCode_ = child_.text
            ErrorCode_ = self.gds_validate_string(ErrorCode_, node, 'ErrorCode')
            self.ErrorCode = ErrorCode_
# end class ApiIndexError_1


class ListOfApiIndexErrors_1(GeneratedsSuper):
    member_data_items_ = {
        'Error': MemberSpec_('Error', 'ApiIndexError_1', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Error=None):
        self.original_tagname_ = None
        if Error is None:
            self.Error = []
        else:
            self.Error = Error
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfApiIndexErrors_1)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfApiIndexErrors_1.subclass:
            return ListOfApiIndexErrors_1.subclass(*args_, **kwargs_)
        else:
            return ListOfApiIndexErrors_1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Error(self): return self.Error
    def set_Error(self, Error): self.Error = Error
    def add_Error(self, value): self.Error.append(value)
    def insert_Error_at(self, index, value): self.Error.insert(index, value)
    def replace_Error_at(self, index, value): self.Error[index] = value
    def hasContent_(self):
        if (
            self.Error
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Error':
            obj_ = ApiIndexError_1.factory()
            obj_.build(child_)
            self.Error.append(obj_)
            obj_.original_tagname_ = 'Error'
# end class ListOfApiIndexErrors_1


class LogOn(GeneratedsSuper):
    member_data_items_ = {
        'ServiceId': MemberSpec_('ServiceId', 'string', 0),
        'KeepMeLoggedIn': MemberSpec_('KeepMeLoggedIn', 'boolean', 0),
        'Token': MemberSpec_('Token', 'AccessToken_14', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, ServiceId=None, KeepMeLoggedIn=None, Token=None):
        self.original_tagname_ = None
        self.ServiceId = ServiceId
        self.KeepMeLoggedIn = KeepMeLoggedIn
        self.Token = Token
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, LogOn)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if LogOn.subclass:
            return LogOn.subclass(*args_, **kwargs_)
        else:
            return LogOn(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ServiceId(self): return self.ServiceId
    def set_ServiceId(self, ServiceId): self.ServiceId = ServiceId
    def get_KeepMeLoggedIn(self): return self.KeepMeLoggedIn
    def set_KeepMeLoggedIn(self, KeepMeLoggedIn): self.KeepMeLoggedIn = KeepMeLoggedIn
    def get_Token(self): return self.Token
    def set_Token(self, Token): self.Token = Token
    def hasContent_(self):
        if (
            self.ServiceId is not None or
            self.KeepMeLoggedIn is not None or
            self.Token is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ServiceId':
            ServiceId_ = child_.text
            ServiceId_ = self.gds_validate_string(ServiceId_, node, 'ServiceId')
            self.ServiceId = ServiceId_
        elif nodeName_ == 'KeepMeLoggedIn':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'KeepMeLoggedIn')
            self.KeepMeLoggedIn = ival_
        elif nodeName_ == 'Token':
            obj_ = AccessToken_14.factory()
            obj_.build(child_)
            self.Token = obj_
            obj_.original_tagname_ = 'Token'
# end class LogOn


class LogOnUserMobile_4(LogOn):
    member_data_items_ = {
        'Identity': MemberSpec_('Identity', 'string', 0),
        'AuthenticationType': MemberSpec_('AuthenticationType', ['AuthenticationType', 'string'], 0),
        'AuthenticationToken': MemberSpec_('AuthenticationToken', 'string', 0),
        'ApplicationVersion': MemberSpec_('ApplicationVersion', 'string', 0),
        'Device': MemberSpec_('Device', 'MobileDevice_4', 0),
    }
    subclass = None
    superclass = LogOn
    def __init__(self, Identity=None, AuthenticationType=None, AuthenticationToken=None, ApplicationVersion=None, Device=None):
        self.original_tagname_ = None
        super(LogOnUserMobile_4, self).__init__()
        self.Identity = Identity
        self.AuthenticationType = AuthenticationType
        self.validate_AuthenticationType(self.AuthenticationType)
        self.AuthenticationToken = AuthenticationToken
        self.ApplicationVersion = ApplicationVersion
        self.Device = Device
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, LogOnUserMobile_4)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if LogOnUserMobile_4.subclass:
            return LogOnUserMobile_4.subclass(*args_, **kwargs_)
        else:
            return LogOnUserMobile_4(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Identity(self): return self.Identity
    def set_Identity(self, Identity): self.Identity = Identity
    def get_AuthenticationType(self): return self.AuthenticationType
    def set_AuthenticationType(self, AuthenticationType): self.AuthenticationType = AuthenticationType
    def get_AuthenticationToken(self): return self.AuthenticationToken
    def set_AuthenticationToken(self, AuthenticationToken): self.AuthenticationToken = AuthenticationToken
    def get_ApplicationVersion(self): return self.ApplicationVersion
    def set_ApplicationVersion(self, ApplicationVersion): self.ApplicationVersion = ApplicationVersion
    def get_Device(self): return self.Device
    def set_Device(self, Device): self.Device = Device
    def validate_AuthenticationType(self, value):
        # Validate type AuthenticationType, a restriction on string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['Test', 'Facebook', 'Google', 'SdkServiceApiAccess', 'LinkedIn', 'EmailPassword', 'MicrosoftOnline', 'Integration', 'MicrosoftExchange']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on AuthenticationType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.Identity is not None or
            self.AuthenticationType is not None or
            self.AuthenticationToken is not None or
            self.ApplicationVersion is not None or
            self.Device is not None or
            super(LogOnUserMobile_4, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(LogOnUserMobile_4, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Identity':
            Identity_ = child_.text
            Identity_ = self.gds_validate_string(Identity_, node, 'Identity')
            self.Identity = Identity_
        elif nodeName_ == 'AuthenticationType':
            AuthenticationType_ = child_.text
            AuthenticationType_ = self.gds_validate_string(AuthenticationType_, node, 'AuthenticationType')
            self.AuthenticationType = AuthenticationType_
            # validate type AuthenticationType
            self.validate_AuthenticationType(self.AuthenticationType)
        elif nodeName_ == 'AuthenticationToken':
            AuthenticationToken_ = child_.text
            AuthenticationToken_ = self.gds_validate_string(AuthenticationToken_, node, 'AuthenticationToken')
            self.AuthenticationToken = AuthenticationToken_
        elif nodeName_ == 'ApplicationVersion':
            ApplicationVersion_ = child_.text
            ApplicationVersion_ = self.gds_validate_string(ApplicationVersion_, node, 'ApplicationVersion')
            self.ApplicationVersion = ApplicationVersion_
        elif nodeName_ == 'Device':
            obj_ = MobileDevice_4.factory()
            obj_.build(child_)
            self.Device = obj_
            obj_.original_tagname_ = 'Device'
        super(LogOnUserMobile_4, self).buildChildren(child_, node, nodeName_, True)
# end class LogOnUserMobile_4


class LogOnBase_14(GeneratedsSuper):
    member_data_items_ = {
        'Token': MemberSpec_('Token', 'AccessToken_14', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Token=None):
        self.original_tagname_ = None
        self.Token = Token
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, LogOnBase_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if LogOnBase_14.subclass:
            return LogOnBase_14.subclass(*args_, **kwargs_)
        else:
            return LogOnBase_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Token(self): return self.Token
    def set_Token(self, Token): self.Token = Token
    def hasContent_(self):
        if (
            self.Token is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Token':
            obj_ = AccessToken_14.factory()
            obj_.build(child_)
            self.Token = obj_
            obj_.original_tagname_ = 'Token'
# end class LogOnBase_14


class LogOnUser_14(LogOnBase_14):
    member_data_items_ = {
        'Authentication': MemberSpec_('Authentication', 'Authentication_13', 0),
        'ClientApplication': MemberSpec_('ClientApplication', 'ClientApplication_14', 0),
    }
    subclass = None
    superclass = LogOnBase_14
    def __init__(self, Authentication=None, ClientApplication=None):
        self.original_tagname_ = None
        super(LogOnUser_14, self).__init__()
        self.Authentication = Authentication
        self.ClientApplication = ClientApplication
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, LogOnUser_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if LogOnUser_14.subclass:
            return LogOnUser_14.subclass(*args_, **kwargs_)
        else:
            return LogOnUser_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Authentication(self): return self.Authentication
    def set_Authentication(self, Authentication): self.Authentication = Authentication
    def get_ClientApplication(self): return self.ClientApplication
    def set_ClientApplication(self, ClientApplication): self.ClientApplication = ClientApplication
    def hasContent_(self):
        if (
            self.Authentication is not None or
            self.ClientApplication is not None or
            super(LogOnUser_14, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(LogOnUser_14, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Authentication':
            obj_ = Authentication_13.factory()
            obj_.build(child_)
            self.Authentication = obj_
            obj_.original_tagname_ = 'Authentication'
        elif nodeName_ == 'ClientApplication':
            obj_ = ClientApplication_14.factory()
            obj_.build(child_)
            self.ClientApplication = obj_
            obj_.original_tagname_ = 'ClientApplication'
        super(LogOnUser_14, self).buildChildren(child_, node, nodeName_, True)
# end class LogOnUser_14


class ClientApplication_14(GeneratedsSuper):
    member_data_items_ = {
        'Type': MemberSpec_('Type', ['ClientApplicationType', 'string'], 0),
        'Version': MemberSpec_('Version', 'string', 0),
        'CodeName': MemberSpec_('CodeName', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Type=None, Version=None, CodeName=None):
        self.original_tagname_ = None
        self.Type = Type
        self.validate_ClientApplicationType(self.Type)
        self.Version = Version
        self.CodeName = CodeName
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ClientApplication_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ClientApplication_14.subclass:
            return ClientApplication_14.subclass(*args_, **kwargs_)
        else:
            return ClientApplication_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Type(self): return self.Type
    def set_Type(self, Type): self.Type = Type
    def get_Version(self): return self.Version
    def set_Version(self, Version): self.Version = Version
    def get_CodeName(self): return self.CodeName
    def set_CodeName(self, CodeName): self.CodeName = CodeName
    def validate_ClientApplicationType(self, value):
        # Validate type ClientApplicationType, a restriction on string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['Unknown', 'Ios', 'Android', 'WindowsPhone', 'Web']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ClientApplicationType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.Type is not None or
            self.Version is not None or
            self.CodeName is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Type':
            Type_ = child_.text
            Type_ = self.gds_validate_string(Type_, node, 'Type')
            self.Type = Type_
            # validate type ClientApplicationType
            self.validate_ClientApplicationType(self.Type)
        elif nodeName_ == 'Version':
            Version_ = child_.text
            Version_ = self.gds_validate_string(Version_, node, 'Version')
            self.Version = Version_
        elif nodeName_ == 'CodeName':
            CodeName_ = child_.text
            CodeName_ = self.gds_validate_string(CodeName_, node, 'CodeName')
            self.CodeName = CodeName_
# end class ClientApplication_14


class Authentication_13(GeneratedsSuper):
    member_data_items_ = {
        'AuthenticationType': MemberSpec_('AuthenticationType', ['AuthenticationType', 'string'], 0),
        'AuthenticationId': MemberSpec_('AuthenticationId', 'string', 0),
        'AuthenticationToken': MemberSpec_('AuthenticationToken', 'string', 0),
        'AuthenticationProviderUri': MemberSpec_('AuthenticationProviderUri', 'string', 0),
        'AuthenticationProviderDomain': MemberSpec_('AuthenticationProviderDomain', 'string', 0),
        'AuthenticationProviderUsername': MemberSpec_('AuthenticationProviderUsername', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, AuthenticationType=None, AuthenticationId=None, AuthenticationToken=None, AuthenticationProviderUri=None, AuthenticationProviderDomain=None, AuthenticationProviderUsername=None):
        self.original_tagname_ = None
        self.AuthenticationType = AuthenticationType
        self.validate_AuthenticationType(self.AuthenticationType)
        self.AuthenticationId = AuthenticationId
        self.AuthenticationToken = AuthenticationToken
        self.AuthenticationProviderUri = AuthenticationProviderUri
        self.AuthenticationProviderDomain = AuthenticationProviderDomain
        self.AuthenticationProviderUsername = AuthenticationProviderUsername
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Authentication_13)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Authentication_13.subclass:
            return Authentication_13.subclass(*args_, **kwargs_)
        else:
            return Authentication_13(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_AuthenticationType(self): return self.AuthenticationType
    def set_AuthenticationType(self, AuthenticationType): self.AuthenticationType = AuthenticationType
    def get_AuthenticationId(self): return self.AuthenticationId
    def set_AuthenticationId(self, AuthenticationId): self.AuthenticationId = AuthenticationId
    def get_AuthenticationToken(self): return self.AuthenticationToken
    def set_AuthenticationToken(self, AuthenticationToken): self.AuthenticationToken = AuthenticationToken
    def get_AuthenticationProviderUri(self): return self.AuthenticationProviderUri
    def set_AuthenticationProviderUri(self, AuthenticationProviderUri): self.AuthenticationProviderUri = AuthenticationProviderUri
    def get_AuthenticationProviderDomain(self): return self.AuthenticationProviderDomain
    def set_AuthenticationProviderDomain(self, AuthenticationProviderDomain): self.AuthenticationProviderDomain = AuthenticationProviderDomain
    def get_AuthenticationProviderUsername(self): return self.AuthenticationProviderUsername
    def set_AuthenticationProviderUsername(self, AuthenticationProviderUsername): self.AuthenticationProviderUsername = AuthenticationProviderUsername
    def validate_AuthenticationType(self, value):
        # Validate type AuthenticationType, a restriction on string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['Test', 'Facebook', 'Google', 'SdkServiceApiAccess', 'LinkedIn', 'EmailPassword', 'MicrosoftOnline', 'Integration', 'MicrosoftExchange']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on AuthenticationType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.AuthenticationType is not None or
            self.AuthenticationId is not None or
            self.AuthenticationToken is not None or
            self.AuthenticationProviderUri is not None or
            self.AuthenticationProviderDomain is not None or
            self.AuthenticationProviderUsername is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'AuthenticationType':
            AuthenticationType_ = child_.text
            AuthenticationType_ = self.gds_validate_string(AuthenticationType_, node, 'AuthenticationType')
            self.AuthenticationType = AuthenticationType_
            # validate type AuthenticationType
            self.validate_AuthenticationType(self.AuthenticationType)
        elif nodeName_ == 'AuthenticationId':
            AuthenticationId_ = child_.text
            AuthenticationId_ = self.gds_validate_string(AuthenticationId_, node, 'AuthenticationId')
            self.AuthenticationId = AuthenticationId_
        elif nodeName_ == 'AuthenticationToken':
            AuthenticationToken_ = child_.text
            AuthenticationToken_ = self.gds_validate_string(AuthenticationToken_, node, 'AuthenticationToken')
            self.AuthenticationToken = AuthenticationToken_
        elif nodeName_ == 'AuthenticationProviderUri':
            AuthenticationProviderUri_ = child_.text
            AuthenticationProviderUri_ = self.gds_validate_string(AuthenticationProviderUri_, node, 'AuthenticationProviderUri')
            self.AuthenticationProviderUri = AuthenticationProviderUri_
        elif nodeName_ == 'AuthenticationProviderDomain':
            AuthenticationProviderDomain_ = child_.text
            AuthenticationProviderDomain_ = self.gds_validate_string(AuthenticationProviderDomain_, node, 'AuthenticationProviderDomain')
            self.AuthenticationProviderDomain = AuthenticationProviderDomain_
        elif nodeName_ == 'AuthenticationProviderUsername':
            AuthenticationProviderUsername_ = child_.text
            AuthenticationProviderUsername_ = self.gds_validate_string(AuthenticationProviderUsername_, node, 'AuthenticationProviderUsername')
            self.AuthenticationProviderUsername = AuthenticationProviderUsername_
# end class Authentication_13


class ListOfAuthentications_13(GeneratedsSuper):
    member_data_items_ = {
        'Authentication': MemberSpec_('Authentication', 'Authentication_13', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Authentication=None):
        self.original_tagname_ = None
        if Authentication is None:
            self.Authentication = []
        else:
            self.Authentication = Authentication
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfAuthentications_13)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfAuthentications_13.subclass:
            return ListOfAuthentications_13.subclass(*args_, **kwargs_)
        else:
            return ListOfAuthentications_13(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Authentication(self): return self.Authentication
    def set_Authentication(self, Authentication): self.Authentication = Authentication
    def add_Authentication(self, value): self.Authentication.append(value)
    def insert_Authentication_at(self, index, value): self.Authentication.insert(index, value)
    def replace_Authentication_at(self, index, value): self.Authentication[index] = value
    def hasContent_(self):
        if (
            self.Authentication
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Authentication':
            obj_ = Authentication_13.factory()
            obj_.build(child_)
            self.Authentication.append(obj_)
            obj_.original_tagname_ = 'Authentication'
# end class ListOfAuthentications_13


class AccountBase_14(GeneratedsSuper):
    member_data_items_ = {
        'Id': MemberSpec_('Id', 'string', 0),
        'Authentication': MemberSpec_('Authentication', 'Authentication_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Id=None, Authentication=None):
        self.original_tagname_ = None
        self.Id = Id
        self.Authentication = Authentication
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AccountBase_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AccountBase_14.subclass:
            return AccountBase_14.subclass(*args_, **kwargs_)
        else:
            return AccountBase_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Id(self): return self.Id
    def set_Id(self, Id): self.Id = Id
    def get_Authentication(self): return self.Authentication
    def set_Authentication(self, Authentication): self.Authentication = Authentication
    def hasContent_(self):
        if (
            self.Id is not None or
            self.Authentication is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Id':
            Id_ = child_.text
            Id_ = self.gds_validate_string(Id_, node, 'Id')
            self.Id = Id_
        elif nodeName_ == 'Authentication':
            obj_ = Authentication_13.factory()
            obj_.build(child_)
            self.Authentication = obj_
            obj_.original_tagname_ = 'Authentication'
# end class AccountBase_14


class AccountEmail_14(AccountBase_14):
    member_data_items_ = {
        'Email': MemberSpec_('Email', 'string', 0),
    }
    subclass = None
    superclass = AccountBase_14
    def __init__(self, Email=None):
        self.original_tagname_ = None
        super(AccountEmail_14, self).__init__()
        self.Email = Email
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AccountEmail_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AccountEmail_14.subclass:
            return AccountEmail_14.subclass(*args_, **kwargs_)
        else:
            return AccountEmail_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Email(self): return self.Email
    def set_Email(self, Email): self.Email = Email
    def hasContent_(self):
        if (
            self.Email is not None or
            super(AccountEmail_14, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(AccountEmail_14, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Email':
            Email_ = child_.text
            Email_ = self.gds_validate_string(Email_, node, 'Email')
            self.Email = Email_
        super(AccountEmail_14, self).buildChildren(child_, node, nodeName_, True)
# end class AccountEmail_14


class ListOfAccounts_14(GeneratedsSuper):
    member_data_items_ = {
        'Account': MemberSpec_('Account', 'AccountBase_14', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Account=None):
        self.original_tagname_ = None
        if Account is None:
            self.Account = []
        else:
            self.Account = Account
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfAccounts_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfAccounts_14.subclass:
            return ListOfAccounts_14.subclass(*args_, **kwargs_)
        else:
            return ListOfAccounts_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Account(self): return self.Account
    def set_Account(self, Account): self.Account = Account
    def add_Account(self, value): self.Account.append(value)
    def insert_Account_at(self, index, value): self.Account.insert(index, value)
    def replace_Account_at(self, index, value): self.Account[index] = value
    def hasContent_(self):
        if (
            self.Account
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Account':
            class_obj_ = self.get_class_obj_(child_, AccountBase_14)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Account.append(obj_)
            obj_.original_tagname_ = 'Account'
# end class ListOfAccounts_14


class Attachment_4(GeneratedsSuper):
    member_data_items_ = {
        'Id': MemberSpec_('Id', 'long', 0),
        'IdString': MemberSpec_('IdString', 'string', 0),
        'Version': MemberSpec_('Version', 'long', 0),
        'File': MemberSpec_('File', 'File_4', 0),
        'Hidden': MemberSpec_('Hidden', 'boolean', 0),
        'ServiceId': MemberSpec_('ServiceId', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Id=None, IdString=None, Version=None, File=None, Hidden=None, ServiceId=None):
        self.original_tagname_ = None
        self.Id = Id
        self.IdString = IdString
        self.Version = Version
        self.File = File
        self.Hidden = Hidden
        self.ServiceId = ServiceId
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Attachment_4)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Attachment_4.subclass:
            return Attachment_4.subclass(*args_, **kwargs_)
        else:
            return Attachment_4(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Id(self): return self.Id
    def set_Id(self, Id): self.Id = Id
    def get_IdString(self): return self.IdString
    def set_IdString(self, IdString): self.IdString = IdString
    def get_Version(self): return self.Version
    def set_Version(self, Version): self.Version = Version
    def get_File(self): return self.File
    def set_File(self, File): self.File = File
    def get_Hidden(self): return self.Hidden
    def set_Hidden(self, Hidden): self.Hidden = Hidden
    def get_ServiceId(self): return self.ServiceId
    def set_ServiceId(self, ServiceId): self.ServiceId = ServiceId
    def hasContent_(self):
        if (
            self.Id is not None or
            self.IdString is not None or
            self.Version is not None or
            self.File is not None or
            self.Hidden is not None or
            self.ServiceId is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Id':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Id')
            self.Id = ival_
        elif nodeName_ == 'IdString':
            IdString_ = child_.text
            IdString_ = self.gds_validate_string(IdString_, node, 'IdString')
            self.IdString = IdString_
        elif nodeName_ == 'Version':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Version')
            self.Version = ival_
        elif nodeName_ == 'File':
            obj_ = File_4.factory()
            obj_.build(child_)
            self.File = obj_
            obj_.original_tagname_ = 'File'
        elif nodeName_ == 'Hidden':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'Hidden')
            self.Hidden = ival_
        elif nodeName_ == 'ServiceId':
            ServiceId_ = child_.text
            ServiceId_ = self.gds_validate_string(ServiceId_, node, 'ServiceId')
            self.ServiceId = ServiceId_
# end class Attachment_4


class ListOfAttachments_4(GeneratedsSuper):
    member_data_items_ = {
        'Attachment': MemberSpec_('Attachment', 'Attachment_4', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Attachment=None):
        self.original_tagname_ = None
        if Attachment is None:
            self.Attachment = []
        else:
            self.Attachment = Attachment
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfAttachments_4)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfAttachments_4.subclass:
            return ListOfAttachments_4.subclass(*args_, **kwargs_)
        else:
            return ListOfAttachments_4(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Attachment(self): return self.Attachment
    def set_Attachment(self, Attachment): self.Attachment = Attachment
    def add_Attachment(self, value): self.Attachment.append(value)
    def insert_Attachment_at(self, index, value): self.Attachment.insert(index, value)
    def replace_Attachment_at(self, index, value): self.Attachment[index] = value
    def hasContent_(self):
        if (
            self.Attachment
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Attachment':
            obj_ = Attachment_4.factory()
            obj_.build(child_)
            self.Attachment.append(obj_)
            obj_.original_tagname_ = 'Attachment'
# end class ListOfAttachments_4


class File_1(GeneratedsSuper):
    member_data_items_ = {
        'Content': MemberSpec_('Content', 'base64Binary', 0),
        'Name': MemberSpec_('Name', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Content=None, Name=None):
        self.original_tagname_ = None
        self.Content = Content
        self.Name = Name
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, File_1)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if File_1.subclass:
            return File_1.subclass(*args_, **kwargs_)
        else:
            return File_1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Content(self): return self.Content
    def set_Content(self, Content): self.Content = Content
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def hasContent_(self):
        if (
            self.Content is not None or
            self.Name is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Content':
            sval_ = child_.text
            if sval_ is not None:
                try:
                    bval_ = base64.b64decode(sval_)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(child_, 'requires base64 encoded string: %s' % exp)
                bval_ = self.gds_validate_base64(bval_, node, 'Content')
            else:
                bval_ = None
            self.Content = bval_
        elif nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
# end class File_1


class ListOfFiles_1(GeneratedsSuper):
    member_data_items_ = {
        'File': MemberSpec_('File', 'File_1', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, File=None):
        self.original_tagname_ = None
        if File is None:
            self.File = []
        else:
            self.File = File
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfFiles_1)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfFiles_1.subclass:
            return ListOfFiles_1.subclass(*args_, **kwargs_)
        else:
            return ListOfFiles_1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_File(self): return self.File
    def set_File(self, File): self.File = File
    def add_File(self, value): self.File.append(value)
    def insert_File_at(self, index, value): self.File.insert(index, value)
    def replace_File_at(self, index, value): self.File[index] = value
    def hasContent_(self):
        if (
            self.File
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'File':
            obj_ = File_1.factory()
            obj_.build(child_)
            self.File.append(obj_)
            obj_.original_tagname_ = 'File'
# end class ListOfFiles_1


class File_4(GeneratedsSuper):
    member_data_items_ = {
        'Name': MemberSpec_('Name', 'string', 0),
        'Content': MemberSpec_('Content', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Name=None, Content=None):
        self.original_tagname_ = None
        self.Name = Name
        self.Content = Content
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, File_4)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if File_4.subclass:
            return File_4.subclass(*args_, **kwargs_)
        else:
            return File_4(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Content(self): return self.Content
    def set_Content(self, Content): self.Content = Content
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Content is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Content':
            Content_ = child_.text
            Content_ = self.gds_validate_string(Content_, node, 'Content')
            self.Content = Content_
# end class File_4


class ListOfFiles_4(GeneratedsSuper):
    member_data_items_ = {
        'File': MemberSpec_('File', 'File_4', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, File=None):
        self.original_tagname_ = None
        if File is None:
            self.File = []
        else:
            self.File = File
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfFiles_4)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfFiles_4.subclass:
            return ListOfFiles_4.subclass(*args_, **kwargs_)
        else:
            return ListOfFiles_4(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_File(self): return self.File
    def set_File(self, File): self.File = File
    def add_File(self, value): self.File.append(value)
    def insert_File_at(self, index, value): self.File.insert(index, value)
    def replace_File_at(self, index, value): self.File[index] = value
    def hasContent_(self):
        if (
            self.File
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'File':
            obj_ = File_4.factory()
            obj_.build(child_)
            self.File.append(obj_)
            obj_.original_tagname_ = 'File'
# end class ListOfFiles_4


class ListOfFiles_14(GeneratedsSuper):
    member_data_items_ = {
        'File': MemberSpec_('File', 'File_14', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, File=None):
        self.original_tagname_ = None
        if File is None:
            self.File = []
        else:
            self.File = File
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfFiles_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfFiles_14.subclass:
            return ListOfFiles_14.subclass(*args_, **kwargs_)
        else:
            return ListOfFiles_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_File(self): return self.File
    def set_File(self, File): self.File = File
    def add_File(self, value): self.File.append(value)
    def insert_File_at(self, index, value): self.File.insert(index, value)
    def replace_File_at(self, index, value): self.File[index] = value
    def hasContent_(self):
        if (
            self.File
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'File':
            obj_ = File_14.factory()
            obj_.build(child_)
            self.File.append(obj_)
            obj_.original_tagname_ = 'File'
# end class ListOfFiles_14


class ListOfDocuments_14(GeneratedsSuper):
    member_data_items_ = {
        'Document': MemberSpec_('Document', 'Document_14', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Document=None):
        self.original_tagname_ = None
        if Document is None:
            self.Document = []
        else:
            self.Document = Document
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfDocuments_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfDocuments_14.subclass:
            return ListOfDocuments_14.subclass(*args_, **kwargs_)
        else:
            return ListOfDocuments_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Document(self): return self.Document
    def set_Document(self, Document): self.Document = Document
    def add_Document(self, value): self.Document.append(value)
    def insert_Document_at(self, index, value): self.Document.insert(index, value)
    def replace_Document_at(self, index, value): self.Document[index] = value
    def hasContent_(self):
        if (
            self.Document
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Document':
            obj_ = Document_14.factory()
            obj_.build(child_)
            self.Document.append(obj_)
            obj_.original_tagname_ = 'Document'
# end class ListOfDocuments_14


class ListOfDocumentsPage_14(GeneratedsSuper):
    member_data_items_ = {
        'Documents': MemberSpec_('Documents', 'ListOfDocuments_14', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Documents=None, Paging=None):
        self.original_tagname_ = None
        self.Documents = Documents
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfDocumentsPage_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfDocumentsPage_14.subclass:
            return ListOfDocumentsPage_14.subclass(*args_, **kwargs_)
        else:
            return ListOfDocumentsPage_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Documents(self): return self.Documents
    def set_Documents(self, Documents): self.Documents = Documents
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.Documents is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Documents':
            obj_ = ListOfDocuments_14.factory()
            obj_.build(child_)
            self.Documents = obj_
            obj_.original_tagname_ = 'Documents'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class ListOfDocumentsPage_14


class DocumentShareList_14(GeneratedsSuper):
    member_data_items_ = {
        'ShareList': MemberSpec_('ShareList', 'ListOfResources_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, ShareList=None):
        self.original_tagname_ = None
        self.ShareList = ShareList
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DocumentShareList_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DocumentShareList_14.subclass:
            return DocumentShareList_14.subclass(*args_, **kwargs_)
        else:
            return DocumentShareList_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ShareList(self): return self.ShareList
    def set_ShareList(self, ShareList): self.ShareList = ShareList
    def hasContent_(self):
        if (
            self.ShareList is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ShareList':
            obj_ = ListOfResources_13.factory()
            obj_.build(child_)
            self.ShareList = obj_
            obj_.original_tagname_ = 'ShareList'
# end class DocumentShareList_14


class DocumentPinnedToList_15(GeneratedsSuper):
    member_data_items_ = {
        'BoardList': MemberSpec_('BoardList', 'ListOfBoards_15', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, BoardList=None):
        self.original_tagname_ = None
        self.BoardList = BoardList
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DocumentPinnedToList_15)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DocumentPinnedToList_15.subclass:
            return DocumentPinnedToList_15.subclass(*args_, **kwargs_)
        else:
            return DocumentPinnedToList_15(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_BoardList(self): return self.BoardList
    def set_BoardList(self, BoardList): self.BoardList = BoardList
    def hasContent_(self):
        if (
            self.BoardList is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'BoardList':
            obj_ = ListOfBoards_15.factory()
            obj_.build(child_)
            self.BoardList = obj_
            obj_.original_tagname_ = 'BoardList'
# end class DocumentPinnedToList_15


class DocumentThumbnail_4(GeneratedsSuper):
    member_data_items_ = {
        'DocumentId': MemberSpec_('DocumentId', 'long', 0),
        'Size': MemberSpec_('Size', ['ThumbnailSize', 'string'], 0),
        'File': MemberSpec_('File', 'File_4', 0),
        'NumberOfPages': MemberSpec_('NumberOfPages', 'int', 0),
        'CurrentPage': MemberSpec_('CurrentPage', 'int', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, DocumentId=None, Size=None, File=None, NumberOfPages=None, CurrentPage=None):
        self.original_tagname_ = None
        self.DocumentId = DocumentId
        self.Size = Size
        self.validate_ThumbnailSize(self.Size)
        self.File = File
        self.NumberOfPages = NumberOfPages
        self.CurrentPage = CurrentPage
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DocumentThumbnail_4)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DocumentThumbnail_4.subclass:
            return DocumentThumbnail_4.subclass(*args_, **kwargs_)
        else:
            return DocumentThumbnail_4(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_DocumentId(self): return self.DocumentId
    def set_DocumentId(self, DocumentId): self.DocumentId = DocumentId
    def get_Size(self): return self.Size
    def set_Size(self, Size): self.Size = Size
    def get_File(self): return self.File
    def set_File(self, File): self.File = File
    def get_NumberOfPages(self): return self.NumberOfPages
    def set_NumberOfPages(self, NumberOfPages): self.NumberOfPages = NumberOfPages
    def get_CurrentPage(self): return self.CurrentPage
    def set_CurrentPage(self, CurrentPage): self.CurrentPage = CurrentPage
    def validate_ThumbnailSize(self, value):
        # Validate type ThumbnailSize, a restriction on string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['Small', 'Large', 'Medium']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ThumbnailSize' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.DocumentId is not None or
            self.Size is not None or
            self.File is not None or
            self.NumberOfPages is not None or
            self.CurrentPage is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'DocumentId':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'DocumentId')
            self.DocumentId = ival_
        elif nodeName_ == 'Size':
            Size_ = child_.text
            Size_ = self.gds_validate_string(Size_, node, 'Size')
            self.Size = Size_
            # validate type ThumbnailSize
            self.validate_ThumbnailSize(self.Size)
        elif nodeName_ == 'File':
            obj_ = File_4.factory()
            obj_.build(child_)
            self.File = obj_
            obj_.original_tagname_ = 'File'
        elif nodeName_ == 'NumberOfPages':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'NumberOfPages')
            self.NumberOfPages = ival_
        elif nodeName_ == 'CurrentPage':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'CurrentPage')
            self.CurrentPage = ival_
# end class DocumentThumbnail_4


class ThumbnailPageInfo_13(GeneratedsSuper):
    member_data_items_ = {
        'Width': MemberSpec_('Width', 'int', 0),
        'Height': MemberSpec_('Height', 'int', 0),
        'HasTextMap': MemberSpec_('HasTextMap', 'boolean', 0),
        'HasPdf': MemberSpec_('HasPdf', 'boolean', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Width=None, Height=None, HasTextMap=None, HasPdf=None):
        self.original_tagname_ = None
        self.Width = Width
        self.Height = Height
        self.HasTextMap = HasTextMap
        self.HasPdf = HasPdf
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ThumbnailPageInfo_13)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ThumbnailPageInfo_13.subclass:
            return ThumbnailPageInfo_13.subclass(*args_, **kwargs_)
        else:
            return ThumbnailPageInfo_13(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Width(self): return self.Width
    def set_Width(self, Width): self.Width = Width
    def get_Height(self): return self.Height
    def set_Height(self, Height): self.Height = Height
    def get_HasTextMap(self): return self.HasTextMap
    def set_HasTextMap(self, HasTextMap): self.HasTextMap = HasTextMap
    def get_HasPdf(self): return self.HasPdf
    def set_HasPdf(self, HasPdf): self.HasPdf = HasPdf
    def hasContent_(self):
        if (
            self.Width is not None or
            self.Height is not None or
            self.HasTextMap is not None or
            self.HasPdf is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Width':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Width')
            self.Width = ival_
        elif nodeName_ == 'Height':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Height')
            self.Height = ival_
        elif nodeName_ == 'HasTextMap':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'HasTextMap')
            self.HasTextMap = ival_
        elif nodeName_ == 'HasPdf':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'HasPdf')
            self.HasPdf = ival_
# end class ThumbnailPageInfo_13


class ListOfThumbnailPageInfo_13(GeneratedsSuper):
    member_data_items_ = {
        'ThumbnailPageInfo': MemberSpec_('ThumbnailPageInfo', 'ThumbnailPageInfo_13', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, ThumbnailPageInfo=None):
        self.original_tagname_ = None
        if ThumbnailPageInfo is None:
            self.ThumbnailPageInfo = []
        else:
            self.ThumbnailPageInfo = ThumbnailPageInfo
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfThumbnailPageInfo_13)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfThumbnailPageInfo_13.subclass:
            return ListOfThumbnailPageInfo_13.subclass(*args_, **kwargs_)
        else:
            return ListOfThumbnailPageInfo_13(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ThumbnailPageInfo(self): return self.ThumbnailPageInfo
    def set_ThumbnailPageInfo(self, ThumbnailPageInfo): self.ThumbnailPageInfo = ThumbnailPageInfo
    def add_ThumbnailPageInfo(self, value): self.ThumbnailPageInfo.append(value)
    def insert_ThumbnailPageInfo_at(self, index, value): self.ThumbnailPageInfo.insert(index, value)
    def replace_ThumbnailPageInfo_at(self, index, value): self.ThumbnailPageInfo[index] = value
    def hasContent_(self):
        if (
            self.ThumbnailPageInfo
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ThumbnailPageInfo':
            class_obj_ = self.get_class_obj_(child_, ThumbnailPageInfo_13)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.ThumbnailPageInfo.append(obj_)
            obj_.original_tagname_ = 'ThumbnailPageInfo'
# end class ListOfThumbnailPageInfo_13


class DocumentThumbnailPageInfo_13(ThumbnailPageInfo_13):
    member_data_items_ = {
        'DocumentId': MemberSpec_('DocumentId', 'long', 0),
        'NumberOfPages': MemberSpec_('NumberOfPages', 'int', 0),
        'PageNumber': MemberSpec_('PageNumber', 'int', 0),
    }
    subclass = None
    superclass = ThumbnailPageInfo_13
    def __init__(self, DocumentId=None, NumberOfPages=None, PageNumber=None):
        self.original_tagname_ = None
        super(DocumentThumbnailPageInfo_13, self).__init__()
        self.DocumentId = DocumentId
        self.NumberOfPages = NumberOfPages
        self.PageNumber = PageNumber
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DocumentThumbnailPageInfo_13)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DocumentThumbnailPageInfo_13.subclass:
            return DocumentThumbnailPageInfo_13.subclass(*args_, **kwargs_)
        else:
            return DocumentThumbnailPageInfo_13(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_DocumentId(self): return self.DocumentId
    def set_DocumentId(self, DocumentId): self.DocumentId = DocumentId
    def get_NumberOfPages(self): return self.NumberOfPages
    def set_NumberOfPages(self, NumberOfPages): self.NumberOfPages = NumberOfPages
    def get_PageNumber(self): return self.PageNumber
    def set_PageNumber(self, PageNumber): self.PageNumber = PageNumber
    def hasContent_(self):
        if (
            self.DocumentId is not None or
            self.NumberOfPages is not None or
            self.PageNumber is not None or
            super(DocumentThumbnailPageInfo_13, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(DocumentThumbnailPageInfo_13, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'DocumentId':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'DocumentId')
            self.DocumentId = ival_
        elif nodeName_ == 'NumberOfPages':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'NumberOfPages')
            self.NumberOfPages = ival_
        elif nodeName_ == 'PageNumber':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'PageNumber')
            self.PageNumber = ival_
        super(DocumentThumbnailPageInfo_13, self).buildChildren(child_, node, nodeName_, True)
# end class DocumentThumbnailPageInfo_13


class DocumentThumbnailInfo_13(GeneratedsSuper):
    member_data_items_ = {
        'DocumentId': MemberSpec_('DocumentId', 'long', 0),
        'NumberOfPages': MemberSpec_('NumberOfPages', 'int', 0),
        'PageInfoList': MemberSpec_('PageInfoList', 'ListOfThumbnailPageInfo_13', 0),
        'PreviewNotSupported': MemberSpec_('PreviewNotSupported', 'boolean', 0),
        'GeneratedFromHtml': MemberSpec_('GeneratedFromHtml', 'boolean', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, DocumentId=None, NumberOfPages=None, PageInfoList=None, PreviewNotSupported=None, GeneratedFromHtml=None):
        self.original_tagname_ = None
        self.DocumentId = DocumentId
        self.NumberOfPages = NumberOfPages
        self.PageInfoList = PageInfoList
        self.PreviewNotSupported = PreviewNotSupported
        self.GeneratedFromHtml = GeneratedFromHtml
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DocumentThumbnailInfo_13)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DocumentThumbnailInfo_13.subclass:
            return DocumentThumbnailInfo_13.subclass(*args_, **kwargs_)
        else:
            return DocumentThumbnailInfo_13(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_DocumentId(self): return self.DocumentId
    def set_DocumentId(self, DocumentId): self.DocumentId = DocumentId
    def get_NumberOfPages(self): return self.NumberOfPages
    def set_NumberOfPages(self, NumberOfPages): self.NumberOfPages = NumberOfPages
    def get_PageInfoList(self): return self.PageInfoList
    def set_PageInfoList(self, PageInfoList): self.PageInfoList = PageInfoList
    def get_PreviewNotSupported(self): return self.PreviewNotSupported
    def set_PreviewNotSupported(self, PreviewNotSupported): self.PreviewNotSupported = PreviewNotSupported
    def get_GeneratedFromHtml(self): return self.GeneratedFromHtml
    def set_GeneratedFromHtml(self, GeneratedFromHtml): self.GeneratedFromHtml = GeneratedFromHtml
    def hasContent_(self):
        if (
            self.DocumentId is not None or
            self.NumberOfPages is not None or
            self.PageInfoList is not None or
            self.PreviewNotSupported is not None or
            self.GeneratedFromHtml is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'DocumentId':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'DocumentId')
            self.DocumentId = ival_
        elif nodeName_ == 'NumberOfPages':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'NumberOfPages')
            self.NumberOfPages = ival_
        elif nodeName_ == 'PageInfoList':
            obj_ = ListOfThumbnailPageInfo_13.factory()
            obj_.build(child_)
            self.PageInfoList = obj_
            obj_.original_tagname_ = 'PageInfoList'
        elif nodeName_ == 'PreviewNotSupported':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'PreviewNotSupported')
            self.PreviewNotSupported = ival_
        elif nodeName_ == 'GeneratedFromHtml':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'GeneratedFromHtml')
            self.GeneratedFromHtml = ival_
# end class DocumentThumbnailInfo_13


class ThumbnailPreview_15(GeneratedsSuper):
    member_data_items_ = {
        'ThumbnailPageList': MemberSpec_('ThumbnailPageList', 'ListOfThumbnailPageInfo_13', 0),
        'Ready': MemberSpec_('Ready', 'boolean', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, ThumbnailPageList=None, Ready=None):
        self.original_tagname_ = None
        self.ThumbnailPageList = ThumbnailPageList
        self.Ready = Ready
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ThumbnailPreview_15)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ThumbnailPreview_15.subclass:
            return ThumbnailPreview_15.subclass(*args_, **kwargs_)
        else:
            return ThumbnailPreview_15(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ThumbnailPageList(self): return self.ThumbnailPageList
    def set_ThumbnailPageList(self, ThumbnailPageList): self.ThumbnailPageList = ThumbnailPageList
    def get_Ready(self): return self.Ready
    def set_Ready(self, Ready): self.Ready = Ready
    def hasContent_(self):
        if (
            self.ThumbnailPageList is not None or
            self.Ready is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ThumbnailPageList':
            obj_ = ListOfThumbnailPageInfo_13.factory()
            obj_.build(child_)
            self.ThumbnailPageList = obj_
            obj_.original_tagname_ = 'ThumbnailPageList'
        elif nodeName_ == 'Ready':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'Ready')
            self.Ready = ival_
# end class ThumbnailPreview_15


class ThumbnailTextMapPage_19(GeneratedsSuper):
    member_data_items_ = {
        'TextMapListPage': MemberSpec_('TextMapListPage', 'ListOfTextMaps_19', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, TextMapListPage=None, Paging=None):
        self.original_tagname_ = None
        self.TextMapListPage = TextMapListPage
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ThumbnailTextMapPage_19)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ThumbnailTextMapPage_19.subclass:
            return ThumbnailTextMapPage_19.subclass(*args_, **kwargs_)
        else:
            return ThumbnailTextMapPage_19(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_TextMapListPage(self): return self.TextMapListPage
    def set_TextMapListPage(self, TextMapListPage): self.TextMapListPage = TextMapListPage
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.TextMapListPage is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'TextMapListPage':
            obj_ = ListOfTextMaps_19.factory()
            obj_.build(child_)
            self.TextMapListPage = obj_
            obj_.original_tagname_ = 'TextMapListPage'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class ThumbnailTextMapPage_19


class ListOfTextMaps_19(GeneratedsSuper):
    member_data_items_ = {
        'ListItem': MemberSpec_('ListItem', 'TextMap_19', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, ListItem=None):
        self.original_tagname_ = None
        if ListItem is None:
            self.ListItem = []
        else:
            self.ListItem = ListItem
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfTextMaps_19)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfTextMaps_19.subclass:
            return ListOfTextMaps_19.subclass(*args_, **kwargs_)
        else:
            return ListOfTextMaps_19(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ListItem(self): return self.ListItem
    def set_ListItem(self, ListItem): self.ListItem = ListItem
    def add_ListItem(self, value): self.ListItem.append(value)
    def insert_ListItem_at(self, index, value): self.ListItem.insert(index, value)
    def replace_ListItem_at(self, index, value): self.ListItem[index] = value
    def hasContent_(self):
        if (
            self.ListItem
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ListItem':
            obj_ = TextMap_19.factory()
            obj_.build(child_)
            self.ListItem.append(obj_)
            obj_.original_tagname_ = 'ListItem'
# end class ListOfTextMaps_19


class TextMap_19(GeneratedsSuper):
    member_data_items_ = {
        'Text': MemberSpec_('Text', 'string', 0),
        'Position': MemberSpec_('Position', 'Rectangle_19', 0),
        'Spacing': MemberSpec_('Spacing', 'Spacing_19', 0),
        'Font': MemberSpec_('Font', 'Font_19', 0),
        'HorizontalScaling': MemberSpec_('HorizontalScaling', 'int', 0),
        'PageInfo': MemberSpec_('PageInfo', 'PageInfo_19', 0),
        'Link': MemberSpec_('Link', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Text=None, Position=None, Spacing=None, Font=None, HorizontalScaling=None, PageInfo=None, Link=None):
        self.original_tagname_ = None
        self.Text = Text
        self.Position = Position
        self.Spacing = Spacing
        self.Font = Font
        self.HorizontalScaling = HorizontalScaling
        self.PageInfo = PageInfo
        self.Link = Link
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TextMap_19)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TextMap_19.subclass:
            return TextMap_19.subclass(*args_, **kwargs_)
        else:
            return TextMap_19(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Text(self): return self.Text
    def set_Text(self, Text): self.Text = Text
    def get_Position(self): return self.Position
    def set_Position(self, Position): self.Position = Position
    def get_Spacing(self): return self.Spacing
    def set_Spacing(self, Spacing): self.Spacing = Spacing
    def get_Font(self): return self.Font
    def set_Font(self, Font): self.Font = Font
    def get_HorizontalScaling(self): return self.HorizontalScaling
    def set_HorizontalScaling(self, HorizontalScaling): self.HorizontalScaling = HorizontalScaling
    def get_PageInfo(self): return self.PageInfo
    def set_PageInfo(self, PageInfo): self.PageInfo = PageInfo
    def get_Link(self): return self.Link
    def set_Link(self, Link): self.Link = Link
    def hasContent_(self):
        if (
            self.Text is not None or
            self.Position is not None or
            self.Spacing is not None or
            self.Font is not None or
            self.HorizontalScaling is not None or
            self.PageInfo is not None or
            self.Link is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Text':
            Text_ = child_.text
            Text_ = self.gds_validate_string(Text_, node, 'Text')
            self.Text = Text_
        elif nodeName_ == 'Position':
            obj_ = Rectangle_19.factory()
            obj_.build(child_)
            self.Position = obj_
            obj_.original_tagname_ = 'Position'
        elif nodeName_ == 'Spacing':
            obj_ = Spacing_19.factory()
            obj_.build(child_)
            self.Spacing = obj_
            obj_.original_tagname_ = 'Spacing'
        elif nodeName_ == 'Font':
            obj_ = Font_19.factory()
            obj_.build(child_)
            self.Font = obj_
            obj_.original_tagname_ = 'Font'
        elif nodeName_ == 'HorizontalScaling':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'HorizontalScaling')
            self.HorizontalScaling = ival_
        elif nodeName_ == 'PageInfo':
            obj_ = PageInfo_19.factory()
            obj_.build(child_)
            self.PageInfo = obj_
            obj_.original_tagname_ = 'PageInfo'
        elif nodeName_ == 'Link':
            Link_ = child_.text
            Link_ = self.gds_validate_string(Link_, node, 'Link')
            self.Link = Link_
# end class TextMap_19


class Rectangle_19(GeneratedsSuper):
    member_data_items_ = {
        'StartX': MemberSpec_('StartX', 'float', 0),
        'StartY': MemberSpec_('StartY', 'float', 0),
        'StopX': MemberSpec_('StopX', 'float', 0),
        'StopY': MemberSpec_('StopY', 'float', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, StartX=None, StartY=None, StopX=None, StopY=None):
        self.original_tagname_ = None
        self.StartX = StartX
        self.StartY = StartY
        self.StopX = StopX
        self.StopY = StopY
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Rectangle_19)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Rectangle_19.subclass:
            return Rectangle_19.subclass(*args_, **kwargs_)
        else:
            return Rectangle_19(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_StartX(self): return self.StartX
    def set_StartX(self, StartX): self.StartX = StartX
    def get_StartY(self): return self.StartY
    def set_StartY(self, StartY): self.StartY = StartY
    def get_StopX(self): return self.StopX
    def set_StopX(self, StopX): self.StopX = StopX
    def get_StopY(self): return self.StopY
    def set_StopY(self, StopY): self.StopY = StopY
    def hasContent_(self):
        if (
            self.StartX is not None or
            self.StartY is not None or
            self.StopX is not None or
            self.StopY is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'StartX':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'StartX')
            self.StartX = fval_
        elif nodeName_ == 'StartY':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'StartY')
            self.StartY = fval_
        elif nodeName_ == 'StopX':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'StopX')
            self.StopX = fval_
        elif nodeName_ == 'StopY':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'StopY')
            self.StopY = fval_
# end class Rectangle_19


class PageInfo_19(GeneratedsSuper):
    member_data_items_ = {
        'PageNumber': MemberSpec_('PageNumber', 'int', 0),
        'PageWidth': MemberSpec_('PageWidth', 'int', 0),
        'PageHeight': MemberSpec_('PageHeight', 'int', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, PageNumber=None, PageWidth=None, PageHeight=None):
        self.original_tagname_ = None
        self.PageNumber = PageNumber
        self.PageWidth = PageWidth
        self.PageHeight = PageHeight
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PageInfo_19)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PageInfo_19.subclass:
            return PageInfo_19.subclass(*args_, **kwargs_)
        else:
            return PageInfo_19(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_PageNumber(self): return self.PageNumber
    def set_PageNumber(self, PageNumber): self.PageNumber = PageNumber
    def get_PageWidth(self): return self.PageWidth
    def set_PageWidth(self, PageWidth): self.PageWidth = PageWidth
    def get_PageHeight(self): return self.PageHeight
    def set_PageHeight(self, PageHeight): self.PageHeight = PageHeight
    def hasContent_(self):
        if (
            self.PageNumber is not None or
            self.PageWidth is not None or
            self.PageHeight is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'PageNumber':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'PageNumber')
            self.PageNumber = ival_
        elif nodeName_ == 'PageWidth':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'PageWidth')
            self.PageWidth = ival_
        elif nodeName_ == 'PageHeight':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'PageHeight')
            self.PageHeight = ival_
# end class PageInfo_19


class Font_19(GeneratedsSuper):
    member_data_items_ = {
        'Name': MemberSpec_('Name', 'string', 0),
        'Size': MemberSpec_('Size', 'int', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Name=None, Size=None):
        self.original_tagname_ = None
        self.Name = Name
        self.Size = Size
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Font_19)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Font_19.subclass:
            return Font_19.subclass(*args_, **kwargs_)
        else:
            return Font_19(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Size(self): return self.Size
    def set_Size(self, Size): self.Size = Size
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Size is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Size':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Size')
            self.Size = ival_
# end class Font_19


class Spacing_19(GeneratedsSuper):
    member_data_items_ = {
        'Line': MemberSpec_('Line', 'float', 0),
        'Word': MemberSpec_('Word', 'float', 0),
        'Char': MemberSpec_('Char', 'float', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Line=None, Word=None, Char=None):
        self.original_tagname_ = None
        self.Line = Line
        self.Word = Word
        self.Char = Char
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Spacing_19)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Spacing_19.subclass:
            return Spacing_19.subclass(*args_, **kwargs_)
        else:
            return Spacing_19(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Line(self): return self.Line
    def set_Line(self, Line): self.Line = Line
    def get_Word(self): return self.Word
    def set_Word(self, Word): self.Word = Word
    def get_Char(self): return self.Char
    def set_Char(self, Char): self.Char = Char
    def hasContent_(self):
        if (
            self.Line is not None or
            self.Word is not None or
            self.Char is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Line':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'Line')
            self.Line = fval_
        elif nodeName_ == 'Word':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'Word')
            self.Word = fval_
        elif nodeName_ == 'Char':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'Char')
            self.Char = fval_
# end class Spacing_19


class ValueName(GeneratedsSuper):
    member_data_items_ = {
        'Name': MemberSpec_('Name', 'string', 0),
        'Value': MemberSpec_('Value', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Name=None, Value=None):
        self.original_tagname_ = None
        self.Name = Name
        self.Value = Value
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ValueName)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ValueName.subclass:
            return ValueName.subclass(*args_, **kwargs_)
        else:
            return ValueName(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Value is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Value':
            Value_ = child_.text
            Value_ = self.gds_validate_string(Value_, node, 'Value')
            self.Value = Value_
# end class ValueName


class ListOfValueNames(GeneratedsSuper):
    member_data_items_ = {
        'ListItem': MemberSpec_('ListItem', 'ValueName', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, ListItem=None):
        self.original_tagname_ = None
        if ListItem is None:
            self.ListItem = []
        else:
            self.ListItem = ListItem
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfValueNames)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfValueNames.subclass:
            return ListOfValueNames.subclass(*args_, **kwargs_)
        else:
            return ListOfValueNames(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ListItem(self): return self.ListItem
    def set_ListItem(self, ListItem): self.ListItem = ListItem
    def add_ListItem(self, value): self.ListItem.append(value)
    def insert_ListItem_at(self, index, value): self.ListItem.insert(index, value)
    def replace_ListItem_at(self, index, value): self.ListItem[index] = value
    def hasContent_(self):
        if (
            self.ListItem
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ListItem':
            class_obj_ = self.get_class_obj_(child_, ValueName)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.ListItem.append(obj_)
            obj_.original_tagname_ = 'ListItem'
# end class ListOfValueNames


class TypedValueName_4(ValueName):
    member_data_items_ = {
        'Type': MemberSpec_('Type', ['ItemType', 'string'], 0),
    }
    subclass = None
    superclass = ValueName
    def __init__(self, Type=None):
        self.original_tagname_ = None
        super(TypedValueName_4, self).__init__()
        self.Type = Type
        self.validate_ItemType(self.Type)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TypedValueName_4)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TypedValueName_4.subclass:
            return TypedValueName_4.subclass(*args_, **kwargs_)
        else:
            return TypedValueName_4(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Type(self): return self.Type
    def set_Type(self, Type): self.Type = Type
    def validate_ItemType(self, value):
        # Validate type ItemType, a restriction on string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['Subject', 'User', 'Group', 'Community', 'Document', 'Folder', 'Comment', 'Tag', 'Task', 'Workflow', 'Email', 'Drawer', 'Customer', 'Invited', 'All']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ItemType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.Type is not None or
            super(TypedValueName_4, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(TypedValueName_4, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Type':
            Type_ = child_.text
            Type_ = self.gds_validate_string(Type_, node, 'Type')
            self.Type = Type_
            # validate type ItemType
            self.validate_ItemType(self.Type)
        super(TypedValueName_4, self).buildChildren(child_, node, nodeName_, True)
# end class TypedValueName_4


class ListOfTypedValueNames_4(GeneratedsSuper):
    member_data_items_ = {
        'ListItem': MemberSpec_('ListItem', 'TypedValueName_4', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, ListItem=None):
        self.original_tagname_ = None
        if ListItem is None:
            self.ListItem = []
        else:
            self.ListItem = ListItem
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfTypedValueNames_4)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfTypedValueNames_4.subclass:
            return ListOfTypedValueNames_4.subclass(*args_, **kwargs_)
        else:
            return ListOfTypedValueNames_4(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ListItem(self): return self.ListItem
    def set_ListItem(self, ListItem): self.ListItem = ListItem
    def add_ListItem(self, value): self.ListItem.append(value)
    def insert_ListItem_at(self, index, value): self.ListItem.insert(index, value)
    def replace_ListItem_at(self, index, value): self.ListItem[index] = value
    def hasContent_(self):
        if (
            self.ListItem
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ListItem':
            obj_ = TypedValueName_4.factory()
            obj_.build(child_)
            self.ListItem.append(obj_)
            obj_.original_tagname_ = 'ListItem'
# end class ListOfTypedValueNames_4


class SearchResults_22(GeneratedsSuper):
    member_data_items_ = {
        'ResultGroups': MemberSpec_('ResultGroups', 'ListOfSearchGroups_22', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, ResultGroups=None):
        self.original_tagname_ = None
        self.ResultGroups = ResultGroups
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchResults_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchResults_22.subclass:
            return SearchResults_22.subclass(*args_, **kwargs_)
        else:
            return SearchResults_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ResultGroups(self): return self.ResultGroups
    def set_ResultGroups(self, ResultGroups): self.ResultGroups = ResultGroups
    def hasContent_(self):
        if (
            self.ResultGroups is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ResultGroups':
            obj_ = ListOfSearchGroups_22.factory()
            obj_.build(child_)
            self.ResultGroups = obj_
            obj_.original_tagname_ = 'ResultGroups'
# end class SearchResults_22


class ListOfSearchGroups_22(GeneratedsSuper):
    member_data_items_ = {
        'Group': MemberSpec_('Group', 'SearchGroup_22', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Group=None):
        self.original_tagname_ = None
        if Group is None:
            self.Group = []
        else:
            self.Group = Group
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfSearchGroups_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfSearchGroups_22.subclass:
            return ListOfSearchGroups_22.subclass(*args_, **kwargs_)
        else:
            return ListOfSearchGroups_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Group(self): return self.Group
    def set_Group(self, Group): self.Group = Group
    def add_Group(self, value): self.Group.append(value)
    def insert_Group_at(self, index, value): self.Group.insert(index, value)
    def replace_Group_at(self, index, value): self.Group[index] = value
    def hasContent_(self):
        if (
            self.Group
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Group':
            obj_ = SearchGroup_22.factory()
            obj_.build(child_)
            self.Group.append(obj_)
            obj_.original_tagname_ = 'Group'
# end class ListOfSearchGroups_22


class SearchGroup_22(GeneratedsSuper):
    member_data_items_ = {
        'Id': MemberSpec_('Id', 'string', 0),
        'Name': MemberSpec_('Name', 'string', 0),
        'ResultPage': MemberSpec_('ResultPage', 'ListOfSearchResourcesPage_22', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Id=None, Name=None, ResultPage=None):
        self.original_tagname_ = None
        self.Id = Id
        self.Name = Name
        self.ResultPage = ResultPage
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchGroup_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchGroup_22.subclass:
            return SearchGroup_22.subclass(*args_, **kwargs_)
        else:
            return SearchGroup_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Id(self): return self.Id
    def set_Id(self, Id): self.Id = Id
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_ResultPage(self): return self.ResultPage
    def set_ResultPage(self, ResultPage): self.ResultPage = ResultPage
    def hasContent_(self):
        if (
            self.Id is not None or
            self.Name is not None or
            self.ResultPage is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Id':
            Id_ = child_.text
            Id_ = self.gds_validate_string(Id_, node, 'Id')
            self.Id = Id_
        elif nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'ResultPage':
            obj_ = ListOfSearchResourcesPage_22.factory()
            obj_.build(child_)
            self.ResultPage = obj_
            obj_.original_tagname_ = 'ResultPage'
# end class SearchGroup_22


class ListOfSearchResourcesPage_22(GeneratedsSuper):
    member_data_items_ = {
        'SearchResourceList': MemberSpec_('SearchResourceList', 'ListOfSearchResources_22', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, SearchResourceList=None, Paging=None):
        self.original_tagname_ = None
        self.SearchResourceList = SearchResourceList
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfSearchResourcesPage_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfSearchResourcesPage_22.subclass:
            return ListOfSearchResourcesPage_22.subclass(*args_, **kwargs_)
        else:
            return ListOfSearchResourcesPage_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_SearchResourceList(self): return self.SearchResourceList
    def set_SearchResourceList(self, SearchResourceList): self.SearchResourceList = SearchResourceList
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.SearchResourceList is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'SearchResourceList':
            obj_ = ListOfSearchResources_22.factory()
            obj_.build(child_)
            self.SearchResourceList = obj_
            obj_.original_tagname_ = 'SearchResourceList'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class ListOfSearchResourcesPage_22


class ListOfSearchResources_22(GeneratedsSuper):
    member_data_items_ = {
        'SearchResource': MemberSpec_('SearchResource', 'SearchResource_22', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, SearchResource=None):
        self.original_tagname_ = None
        if SearchResource is None:
            self.SearchResource = []
        else:
            self.SearchResource = SearchResource
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfSearchResources_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfSearchResources_22.subclass:
            return ListOfSearchResources_22.subclass(*args_, **kwargs_)
        else:
            return ListOfSearchResources_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_SearchResource(self): return self.SearchResource
    def set_SearchResource(self, SearchResource): self.SearchResource = SearchResource
    def add_SearchResource(self, value): self.SearchResource.append(value)
    def insert_SearchResource_at(self, index, value): self.SearchResource.insert(index, value)
    def replace_SearchResource_at(self, index, value): self.SearchResource[index] = value
    def hasContent_(self):
        if (
            self.SearchResource
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'SearchResource':
            obj_ = SearchResource_22.factory()
            obj_.build(child_)
            self.SearchResource.append(obj_)
            obj_.original_tagname_ = 'SearchResource'
# end class ListOfSearchResources_22


class SearchResource_22(GeneratedsSuper):
    member_data_items_ = {
        'Resource': MemberSpec_('Resource', 'ResourceBase_13', 0),
        'Highlights': MemberSpec_('Highlights', 'ListOfStrings', 0),
        'HintResourceIds': MemberSpec_('HintResourceIds', 'ListOfStrings', 0),
        'SearchHit': MemberSpec_('SearchHit', 'string', 0),
        'BadgeCount': MemberSpec_('BadgeCount', 'integer', 0),
        'Weight': MemberSpec_('Weight', 'decimal', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Resource=None, Highlights=None, HintResourceIds=None, SearchHit=None, BadgeCount=None, Weight=None):
        self.original_tagname_ = None
        self.Resource = Resource
        self.Highlights = Highlights
        self.HintResourceIds = HintResourceIds
        self.SearchHit = SearchHit
        self.BadgeCount = BadgeCount
        self.Weight = Weight
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchResource_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchResource_22.subclass:
            return SearchResource_22.subclass(*args_, **kwargs_)
        else:
            return SearchResource_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Resource(self): return self.Resource
    def set_Resource(self, Resource): self.Resource = Resource
    def get_Highlights(self): return self.Highlights
    def set_Highlights(self, Highlights): self.Highlights = Highlights
    def get_HintResourceIds(self): return self.HintResourceIds
    def set_HintResourceIds(self, HintResourceIds): self.HintResourceIds = HintResourceIds
    def get_SearchHit(self): return self.SearchHit
    def set_SearchHit(self, SearchHit): self.SearchHit = SearchHit
    def get_BadgeCount(self): return self.BadgeCount
    def set_BadgeCount(self, BadgeCount): self.BadgeCount = BadgeCount
    def get_Weight(self): return self.Weight
    def set_Weight(self, Weight): self.Weight = Weight
    def hasContent_(self):
        if (
            self.Resource is not None or
            self.Highlights is not None or
            self.HintResourceIds is not None or
            self.SearchHit is not None or
            self.BadgeCount is not None or
            self.Weight is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Resource':
            class_obj_ = self.get_class_obj_(child_, ResourceBase_13)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Resource = obj_
            obj_.original_tagname_ = 'Resource'
        elif nodeName_ == 'Highlights':
            obj_ = ListOfStrings.factory()
            obj_.build(child_)
            self.Highlights = obj_
            obj_.original_tagname_ = 'Highlights'
        elif nodeName_ == 'HintResourceIds':
            obj_ = ListOfStrings.factory()
            obj_.build(child_)
            self.HintResourceIds = obj_
            obj_.original_tagname_ = 'HintResourceIds'
        elif nodeName_ == 'SearchHit':
            SearchHit_ = child_.text
            SearchHit_ = self.gds_validate_string(SearchHit_, node, 'SearchHit')
            self.SearchHit = SearchHit_
        elif nodeName_ == 'BadgeCount':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'BadgeCount')
            self.BadgeCount = ival_
        elif nodeName_ == 'Weight':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'Weight')
            self.Weight = fval_
# end class SearchResource_22


class SearchResults_20(GeneratedsSuper):
    member_data_items_ = {
        'ResultGroups': MemberSpec_('ResultGroups', 'ListOfSearchGroups_20', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, ResultGroups=None):
        self.original_tagname_ = None
        self.ResultGroups = ResultGroups
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchResults_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchResults_20.subclass:
            return SearchResults_20.subclass(*args_, **kwargs_)
        else:
            return SearchResults_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ResultGroups(self): return self.ResultGroups
    def set_ResultGroups(self, ResultGroups): self.ResultGroups = ResultGroups
    def hasContent_(self):
        if (
            self.ResultGroups is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ResultGroups':
            obj_ = ListOfSearchGroups_20.factory()
            obj_.build(child_)
            self.ResultGroups = obj_
            obj_.original_tagname_ = 'ResultGroups'
# end class SearchResults_20


class ListOfSearchGroups_20(GeneratedsSuper):
    member_data_items_ = {
        'Group': MemberSpec_('Group', 'SearchGroup_20', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Group=None):
        self.original_tagname_ = None
        if Group is None:
            self.Group = []
        else:
            self.Group = Group
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfSearchGroups_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfSearchGroups_20.subclass:
            return ListOfSearchGroups_20.subclass(*args_, **kwargs_)
        else:
            return ListOfSearchGroups_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Group(self): return self.Group
    def set_Group(self, Group): self.Group = Group
    def add_Group(self, value): self.Group.append(value)
    def insert_Group_at(self, index, value): self.Group.insert(index, value)
    def replace_Group_at(self, index, value): self.Group[index] = value
    def hasContent_(self):
        if (
            self.Group
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Group':
            obj_ = SearchGroup_20.factory()
            obj_.build(child_)
            self.Group.append(obj_)
            obj_.original_tagname_ = 'Group'
# end class ListOfSearchGroups_20


class SearchGroup_20(GeneratedsSuper):
    member_data_items_ = {
        'Id': MemberSpec_('Id', 'string', 0),
        'Name': MemberSpec_('Name', 'string', 0),
        'ResultPage': MemberSpec_('ResultPage', 'ListOfSearchResourcesPage_20', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Id=None, Name=None, ResultPage=None):
        self.original_tagname_ = None
        self.Id = Id
        self.Name = Name
        self.ResultPage = ResultPage
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchGroup_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchGroup_20.subclass:
            return SearchGroup_20.subclass(*args_, **kwargs_)
        else:
            return SearchGroup_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Id(self): return self.Id
    def set_Id(self, Id): self.Id = Id
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_ResultPage(self): return self.ResultPage
    def set_ResultPage(self, ResultPage): self.ResultPage = ResultPage
    def hasContent_(self):
        if (
            self.Id is not None or
            self.Name is not None or
            self.ResultPage is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Id':
            Id_ = child_.text
            Id_ = self.gds_validate_string(Id_, node, 'Id')
            self.Id = Id_
        elif nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'ResultPage':
            obj_ = ListOfSearchResourcesPage_20.factory()
            obj_.build(child_)
            self.ResultPage = obj_
            obj_.original_tagname_ = 'ResultPage'
# end class SearchGroup_20


class ListOfSearchResourcesPage_20(GeneratedsSuper):
    member_data_items_ = {
        'SearchResourceList': MemberSpec_('SearchResourceList', 'ListOfSearchResources_20', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, SearchResourceList=None, Paging=None):
        self.original_tagname_ = None
        self.SearchResourceList = SearchResourceList
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfSearchResourcesPage_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfSearchResourcesPage_20.subclass:
            return ListOfSearchResourcesPage_20.subclass(*args_, **kwargs_)
        else:
            return ListOfSearchResourcesPage_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_SearchResourceList(self): return self.SearchResourceList
    def set_SearchResourceList(self, SearchResourceList): self.SearchResourceList = SearchResourceList
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.SearchResourceList is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'SearchResourceList':
            obj_ = ListOfSearchResources_20.factory()
            obj_.build(child_)
            self.SearchResourceList = obj_
            obj_.original_tagname_ = 'SearchResourceList'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class ListOfSearchResourcesPage_20


class ListOfSearchResources_20(GeneratedsSuper):
    member_data_items_ = {
        'SearchResource': MemberSpec_('SearchResource', 'SearchResource_20', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, SearchResource=None):
        self.original_tagname_ = None
        if SearchResource is None:
            self.SearchResource = []
        else:
            self.SearchResource = SearchResource
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfSearchResources_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfSearchResources_20.subclass:
            return ListOfSearchResources_20.subclass(*args_, **kwargs_)
        else:
            return ListOfSearchResources_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_SearchResource(self): return self.SearchResource
    def set_SearchResource(self, SearchResource): self.SearchResource = SearchResource
    def add_SearchResource(self, value): self.SearchResource.append(value)
    def insert_SearchResource_at(self, index, value): self.SearchResource.insert(index, value)
    def replace_SearchResource_at(self, index, value): self.SearchResource[index] = value
    def hasContent_(self):
        if (
            self.SearchResource
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'SearchResource':
            obj_ = SearchResource_20.factory()
            obj_.build(child_)
            self.SearchResource.append(obj_)
            obj_.original_tagname_ = 'SearchResource'
# end class ListOfSearchResources_20


class SearchResource_20(GeneratedsSuper):
    member_data_items_ = {
        'Resource': MemberSpec_('Resource', 'ResourceBase_13', 0),
        'Highlights': MemberSpec_('Highlights', 'ListOfStrings', 0),
        'SearchHit': MemberSpec_('SearchHit', 'string', 0),
        'BadgeCount': MemberSpec_('BadgeCount', 'integer', 0),
        'Weight': MemberSpec_('Weight', 'decimal', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Resource=None, Highlights=None, SearchHit=None, BadgeCount=None, Weight=None):
        self.original_tagname_ = None
        self.Resource = Resource
        self.Highlights = Highlights
        self.SearchHit = SearchHit
        self.BadgeCount = BadgeCount
        self.Weight = Weight
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchResource_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchResource_20.subclass:
            return SearchResource_20.subclass(*args_, **kwargs_)
        else:
            return SearchResource_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Resource(self): return self.Resource
    def set_Resource(self, Resource): self.Resource = Resource
    def get_Highlights(self): return self.Highlights
    def set_Highlights(self, Highlights): self.Highlights = Highlights
    def get_SearchHit(self): return self.SearchHit
    def set_SearchHit(self, SearchHit): self.SearchHit = SearchHit
    def get_BadgeCount(self): return self.BadgeCount
    def set_BadgeCount(self, BadgeCount): self.BadgeCount = BadgeCount
    def get_Weight(self): return self.Weight
    def set_Weight(self, Weight): self.Weight = Weight
    def hasContent_(self):
        if (
            self.Resource is not None or
            self.Highlights is not None or
            self.SearchHit is not None or
            self.BadgeCount is not None or
            self.Weight is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Resource':
            class_obj_ = self.get_class_obj_(child_, ResourceBase_13)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Resource = obj_
            obj_.original_tagname_ = 'Resource'
        elif nodeName_ == 'Highlights':
            obj_ = ListOfStrings.factory()
            obj_.build(child_)
            self.Highlights = obj_
            obj_.original_tagname_ = 'Highlights'
        elif nodeName_ == 'SearchHit':
            SearchHit_ = child_.text
            SearchHit_ = self.gds_validate_string(SearchHit_, node, 'SearchHit')
            self.SearchHit = SearchHit_
        elif nodeName_ == 'BadgeCount':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'BadgeCount')
            self.BadgeCount = ival_
        elif nodeName_ == 'Weight':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'Weight')
            self.Weight = fval_
# end class SearchResource_20


class SearchResultsGroupedPage_18(GeneratedsSuper):
    member_data_items_ = {
        'Groups': MemberSpec_('Groups', 'ListOfSearchGroups_18', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Groups=None, Paging=None):
        self.original_tagname_ = None
        self.Groups = Groups
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchResultsGroupedPage_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchResultsGroupedPage_18.subclass:
            return SearchResultsGroupedPage_18.subclass(*args_, **kwargs_)
        else:
            return SearchResultsGroupedPage_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Groups(self): return self.Groups
    def set_Groups(self, Groups): self.Groups = Groups
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.Groups is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Groups':
            obj_ = ListOfSearchGroups_18.factory()
            obj_.build(child_)
            self.Groups = obj_
            obj_.original_tagname_ = 'Groups'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class SearchResultsGroupedPage_18


class ListOfSearchGroups_18(GeneratedsSuper):
    member_data_items_ = {
        'Group': MemberSpec_('Group', 'SearchGroup_18', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Group=None):
        self.original_tagname_ = None
        if Group is None:
            self.Group = []
        else:
            self.Group = Group
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfSearchGroups_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfSearchGroups_18.subclass:
            return ListOfSearchGroups_18.subclass(*args_, **kwargs_)
        else:
            return ListOfSearchGroups_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Group(self): return self.Group
    def set_Group(self, Group): self.Group = Group
    def add_Group(self, value): self.Group.append(value)
    def insert_Group_at(self, index, value): self.Group.insert(index, value)
    def replace_Group_at(self, index, value): self.Group[index] = value
    def hasContent_(self):
        if (
            self.Group
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Group':
            obj_ = SearchGroup_18.factory()
            obj_.build(child_)
            self.Group.append(obj_)
            obj_.original_tagname_ = 'Group'
# end class ListOfSearchGroups_18


class SearchGroup_18(GeneratedsSuper):
    member_data_items_ = {
        'Id': MemberSpec_('Id', 'string', 0),
        'Name': MemberSpec_('Name', 'string', 0),
        'ResultPage': MemberSpec_('ResultPage', 'ListOfSearchResourcesPage_18', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Id=None, Name=None, ResultPage=None):
        self.original_tagname_ = None
        self.Id = Id
        self.Name = Name
        self.ResultPage = ResultPage
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchGroup_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchGroup_18.subclass:
            return SearchGroup_18.subclass(*args_, **kwargs_)
        else:
            return SearchGroup_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Id(self): return self.Id
    def set_Id(self, Id): self.Id = Id
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_ResultPage(self): return self.ResultPage
    def set_ResultPage(self, ResultPage): self.ResultPage = ResultPage
    def hasContent_(self):
        if (
            self.Id is not None or
            self.Name is not None or
            self.ResultPage is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Id':
            Id_ = child_.text
            Id_ = self.gds_validate_string(Id_, node, 'Id')
            self.Id = Id_
        elif nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'ResultPage':
            obj_ = ListOfSearchResourcesPage_18.factory()
            obj_.build(child_)
            self.ResultPage = obj_
            obj_.original_tagname_ = 'ResultPage'
# end class SearchGroup_18


class ListOfSearchResourcesPage_18(GeneratedsSuper):
    member_data_items_ = {
        'SearchResourceList': MemberSpec_('SearchResourceList', 'ListOfSearchResources_18', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, SearchResourceList=None, Paging=None):
        self.original_tagname_ = None
        self.SearchResourceList = SearchResourceList
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfSearchResourcesPage_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfSearchResourcesPage_18.subclass:
            return ListOfSearchResourcesPage_18.subclass(*args_, **kwargs_)
        else:
            return ListOfSearchResourcesPage_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_SearchResourceList(self): return self.SearchResourceList
    def set_SearchResourceList(self, SearchResourceList): self.SearchResourceList = SearchResourceList
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.SearchResourceList is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'SearchResourceList':
            obj_ = ListOfSearchResources_18.factory()
            obj_.build(child_)
            self.SearchResourceList = obj_
            obj_.original_tagname_ = 'SearchResourceList'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class ListOfSearchResourcesPage_18


class ListOfSearchResources_18(GeneratedsSuper):
    member_data_items_ = {
        'SearchResource': MemberSpec_('SearchResource', 'SearchResource_18', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, SearchResource=None):
        self.original_tagname_ = None
        if SearchResource is None:
            self.SearchResource = []
        else:
            self.SearchResource = SearchResource
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfSearchResources_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfSearchResources_18.subclass:
            return ListOfSearchResources_18.subclass(*args_, **kwargs_)
        else:
            return ListOfSearchResources_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_SearchResource(self): return self.SearchResource
    def set_SearchResource(self, SearchResource): self.SearchResource = SearchResource
    def add_SearchResource(self, value): self.SearchResource.append(value)
    def insert_SearchResource_at(self, index, value): self.SearchResource.insert(index, value)
    def replace_SearchResource_at(self, index, value): self.SearchResource[index] = value
    def hasContent_(self):
        if (
            self.SearchResource
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'SearchResource':
            obj_ = SearchResource_18.factory()
            obj_.build(child_)
            self.SearchResource.append(obj_)
            obj_.original_tagname_ = 'SearchResource'
# end class ListOfSearchResources_18


class SearchResource_18(GeneratedsSuper):
    member_data_items_ = {
        'Resource': MemberSpec_('Resource', 'ResourceBase_13', 0),
        'Highlights': MemberSpec_('Highlights', 'ListOfStrings', 0),
        'SearchHit': MemberSpec_('SearchHit', 'string', 0),
        'BadgeCount': MemberSpec_('BadgeCount', 'integer', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Resource=None, Highlights=None, SearchHit=None, BadgeCount=None):
        self.original_tagname_ = None
        self.Resource = Resource
        self.Highlights = Highlights
        self.SearchHit = SearchHit
        self.BadgeCount = BadgeCount
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchResource_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchResource_18.subclass:
            return SearchResource_18.subclass(*args_, **kwargs_)
        else:
            return SearchResource_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Resource(self): return self.Resource
    def set_Resource(self, Resource): self.Resource = Resource
    def get_Highlights(self): return self.Highlights
    def set_Highlights(self, Highlights): self.Highlights = Highlights
    def get_SearchHit(self): return self.SearchHit
    def set_SearchHit(self, SearchHit): self.SearchHit = SearchHit
    def get_BadgeCount(self): return self.BadgeCount
    def set_BadgeCount(self, BadgeCount): self.BadgeCount = BadgeCount
    def hasContent_(self):
        if (
            self.Resource is not None or
            self.Highlights is not None or
            self.SearchHit is not None or
            self.BadgeCount is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Resource':
            class_obj_ = self.get_class_obj_(child_, ResourceBase_13)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Resource = obj_
            obj_.original_tagname_ = 'Resource'
        elif nodeName_ == 'Highlights':
            obj_ = ListOfStrings.factory()
            obj_.build(child_)
            self.Highlights = obj_
            obj_.original_tagname_ = 'Highlights'
        elif nodeName_ == 'SearchHit':
            SearchHit_ = child_.text
            SearchHit_ = self.gds_validate_string(SearchHit_, node, 'SearchHit')
            self.SearchHit = SearchHit_
        elif nodeName_ == 'BadgeCount':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'BadgeCount')
            self.BadgeCount = ival_
# end class SearchResource_18


class Device_4(GeneratedsSuper):
    member_data_items_ = {
        'Id': MemberSpec_('Id', 'string', 0),
        'Name': MemberSpec_('Name', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Id=None, Name=None):
        self.original_tagname_ = None
        self.Id = Id
        self.Name = Name
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Device_4)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Device_4.subclass:
            return Device_4.subclass(*args_, **kwargs_)
        else:
            return Device_4(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Id(self): return self.Id
    def set_Id(self, Id): self.Id = Id
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def hasContent_(self):
        if (
            self.Id is not None or
            self.Name is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Id':
            Id_ = child_.text
            Id_ = self.gds_validate_string(Id_, node, 'Id')
            self.Id = Id_
        elif nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
# end class Device_4


class ListOfActors_13(GeneratedsSuper):
    member_data_items_ = {
        'Actor': MemberSpec_('Actor', 'ActorBase_13', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Actor=None):
        self.original_tagname_ = None
        if Actor is None:
            self.Actor = []
        else:
            self.Actor = Actor
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfActors_13)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfActors_13.subclass:
            return ListOfActors_13.subclass(*args_, **kwargs_)
        else:
            return ListOfActors_13(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Actor(self): return self.Actor
    def set_Actor(self, Actor): self.Actor = Actor
    def add_Actor(self, value): self.Actor.append(value)
    def insert_Actor_at(self, index, value): self.Actor.insert(index, value)
    def replace_Actor_at(self, index, value): self.Actor[index] = value
    def hasContent_(self):
        if (
            self.Actor
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Actor':
            obj_ = ActorBase_13.factory()
            obj_.build(child_)
            self.Actor.append(obj_)
            obj_.original_tagname_ = 'Actor'
# end class ListOfActors_13


class ListOfActors_14(GeneratedsSuper):
    member_data_items_ = {
        'Actor': MemberSpec_('Actor', 'ActorBase_14', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Actor=None):
        self.original_tagname_ = None
        if Actor is None:
            self.Actor = []
        else:
            self.Actor = Actor
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfActors_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfActors_14.subclass:
            return ListOfActors_14.subclass(*args_, **kwargs_)
        else:
            return ListOfActors_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Actor(self): return self.Actor
    def set_Actor(self, Actor): self.Actor = Actor
    def add_Actor(self, value): self.Actor.append(value)
    def insert_Actor_at(self, index, value): self.Actor.insert(index, value)
    def replace_Actor_at(self, index, value): self.Actor[index] = value
    def hasContent_(self):
        if (
            self.Actor
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Actor':
            class_obj_ = self.get_class_obj_(child_, ActorBase_14)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Actor.append(obj_)
            obj_.original_tagname_ = 'Actor'
# end class ListOfActors_14


class ListOfUsers_14(GeneratedsSuper):
    member_data_items_ = {
        'User': MemberSpec_('User', 'User_14', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, User=None):
        self.original_tagname_ = None
        if User is None:
            self.User = []
        else:
            self.User = User
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfUsers_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfUsers_14.subclass:
            return ListOfUsers_14.subclass(*args_, **kwargs_)
        else:
            return ListOfUsers_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_User(self): return self.User
    def set_User(self, User): self.User = User
    def add_User(self, value): self.User.append(value)
    def insert_User_at(self, index, value): self.User.insert(index, value)
    def replace_User_at(self, index, value): self.User[index] = value
    def hasContent_(self):
        if (
            self.User
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'User':
            class_obj_ = self.get_class_obj_(child_, User_14)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.User.append(obj_)
            obj_.original_tagname_ = 'User'
# end class ListOfUsers_14


class ListOfUsersPage_14(GeneratedsSuper):
    member_data_items_ = {
        'Users': MemberSpec_('Users', 'ListOfUsers_14', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Users=None, Paging=None):
        self.original_tagname_ = None
        self.Users = Users
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfUsersPage_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfUsersPage_14.subclass:
            return ListOfUsersPage_14.subclass(*args_, **kwargs_)
        else:
            return ListOfUsersPage_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Users(self): return self.Users
    def set_Users(self, Users): self.Users = Users
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.Users is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Users':
            obj_ = ListOfUsers_14.factory()
            obj_.build(child_)
            self.Users = obj_
            obj_.original_tagname_ = 'Users'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class ListOfUsersPage_14


class UserAvatar_17(GeneratedsSuper):
    member_data_items_ = {
        'UserId': MemberSpec_('UserId', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, UserId=None):
        self.original_tagname_ = None
        self.UserId = UserId
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, UserAvatar_17)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if UserAvatar_17.subclass:
            return UserAvatar_17.subclass(*args_, **kwargs_)
        else:
            return UserAvatar_17(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_UserId(self): return self.UserId
    def set_UserId(self, UserId): self.UserId = UserId
    def hasContent_(self):
        if (
            self.UserId is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'UserId':
            UserId_ = child_.text
            UserId_ = self.gds_validate_string(UserId_, node, 'UserId')
            self.UserId = UserId_
# end class UserAvatar_17


class UserSettingsBase_14(GeneratedsSuper):
    member_data_items_ = {
        'Id': MemberSpec_('Id', 'string', 0),
        'Name': MemberSpec_('Name', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Id=None, Name=None):
        self.original_tagname_ = None
        self.Id = Id
        self.Name = Name
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, UserSettingsBase_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if UserSettingsBase_14.subclass:
            return UserSettingsBase_14.subclass(*args_, **kwargs_)
        else:
            return UserSettingsBase_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Id(self): return self.Id
    def set_Id(self, Id): self.Id = Id
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def hasContent_(self):
        if (
            self.Id is not None or
            self.Name is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Id':
            Id_ = child_.text
            Id_ = self.gds_validate_string(Id_, node, 'Id')
            self.Id = Id_
        elif nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
# end class UserSettingsBase_14


class ListOfUserSettings_14(GeneratedsSuper):
    member_data_items_ = {
        'UserSettings': MemberSpec_('UserSettings', 'UserSettingsBase_14', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, UserSettings=None):
        self.original_tagname_ = None
        if UserSettings is None:
            self.UserSettings = []
        else:
            self.UserSettings = UserSettings
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfUserSettings_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfUserSettings_14.subclass:
            return ListOfUserSettings_14.subclass(*args_, **kwargs_)
        else:
            return ListOfUserSettings_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_UserSettings(self): return self.UserSettings
    def set_UserSettings(self, UserSettings): self.UserSettings = UserSettings
    def add_UserSettings(self, value): self.UserSettings.append(value)
    def insert_UserSettings_at(self, index, value): self.UserSettings.insert(index, value)
    def replace_UserSettings_at(self, index, value): self.UserSettings[index] = value
    def hasContent_(self):
        if (
            self.UserSettings
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'UserSettings':
            class_obj_ = self.get_class_obj_(child_, UserSettingsBase_14)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.UserSettings.append(obj_)
            obj_.original_tagname_ = 'UserSettings'
# end class ListOfUserSettings_14


class ListOfUserSettingsPage_14(GeneratedsSuper):
    member_data_items_ = {
        'UserSettingsList': MemberSpec_('UserSettingsList', 'ListOfUserSettings_14', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, UserSettingsList=None, Paging=None):
        self.original_tagname_ = None
        self.UserSettingsList = UserSettingsList
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfUserSettingsPage_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfUserSettingsPage_14.subclass:
            return ListOfUserSettingsPage_14.subclass(*args_, **kwargs_)
        else:
            return ListOfUserSettingsPage_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_UserSettingsList(self): return self.UserSettingsList
    def set_UserSettingsList(self, UserSettingsList): self.UserSettingsList = UserSettingsList
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.UserSettingsList is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'UserSettingsList':
            obj_ = ListOfUserSettings_14.factory()
            obj_.build(child_)
            self.UserSettingsList = obj_
            obj_.original_tagname_ = 'UserSettingsList'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class ListOfUserSettingsPage_14


class UserSettings_14(UserSettingsBase_14):
    member_data_items_ = {
        'FirstName': MemberSpec_('FirstName', 'string', 0),
        'LastName': MemberSpec_('LastName', 'string', 0),
        'CultureCode': MemberSpec_('CultureCode', 'string', 0),
        'RegionCode': MemberSpec_('RegionCode', 'string', 0),
        'TimeZoneId': MemberSpec_('TimeZoneId', 'string', 0),
    }
    subclass = None
    superclass = UserSettingsBase_14
    def __init__(self, FirstName=None, LastName=None, CultureCode=None, RegionCode=None, TimeZoneId=None):
        self.original_tagname_ = None
        super(UserSettings_14, self).__init__()
        self.FirstName = FirstName
        self.LastName = LastName
        self.CultureCode = CultureCode
        self.RegionCode = RegionCode
        self.TimeZoneId = TimeZoneId
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, UserSettings_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if UserSettings_14.subclass:
            return UserSettings_14.subclass(*args_, **kwargs_)
        else:
            return UserSettings_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_FirstName(self): return self.FirstName
    def set_FirstName(self, FirstName): self.FirstName = FirstName
    def get_LastName(self): return self.LastName
    def set_LastName(self, LastName): self.LastName = LastName
    def get_CultureCode(self): return self.CultureCode
    def set_CultureCode(self, CultureCode): self.CultureCode = CultureCode
    def get_RegionCode(self): return self.RegionCode
    def set_RegionCode(self, RegionCode): self.RegionCode = RegionCode
    def get_TimeZoneId(self): return self.TimeZoneId
    def set_TimeZoneId(self, TimeZoneId): self.TimeZoneId = TimeZoneId
    def hasContent_(self):
        if (
            self.FirstName is not None or
            self.LastName is not None or
            self.CultureCode is not None or
            self.RegionCode is not None or
            self.TimeZoneId is not None or
            super(UserSettings_14, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(UserSettings_14, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'FirstName':
            FirstName_ = child_.text
            FirstName_ = self.gds_validate_string(FirstName_, node, 'FirstName')
            self.FirstName = FirstName_
        elif nodeName_ == 'LastName':
            LastName_ = child_.text
            LastName_ = self.gds_validate_string(LastName_, node, 'LastName')
            self.LastName = LastName_
        elif nodeName_ == 'CultureCode':
            CultureCode_ = child_.text
            CultureCode_ = self.gds_validate_string(CultureCode_, node, 'CultureCode')
            self.CultureCode = CultureCode_
        elif nodeName_ == 'RegionCode':
            RegionCode_ = child_.text
            RegionCode_ = self.gds_validate_string(RegionCode_, node, 'RegionCode')
            self.RegionCode = RegionCode_
        elif nodeName_ == 'TimeZoneId':
            TimeZoneId_ = child_.text
            TimeZoneId_ = self.gds_validate_string(TimeZoneId_, node, 'TimeZoneId')
            self.TimeZoneId = TimeZoneId_
        super(UserSettings_14, self).buildChildren(child_, node, nodeName_, True)
# end class UserSettings_14


class UserSettingsNotification_20(UserSettingsBase_14):
    member_data_items_ = {
        'GroupNotification': MemberSpec_('GroupNotification', 'boolean', 0),
        'AssistantNotification': MemberSpec_('AssistantNotification', 'boolean', 0),
        'DiscussionNotification': MemberSpec_('DiscussionNotification', 'boolean', 0),
        'ChatNotification': MemberSpec_('ChatNotification', 'boolean', 0),
    }
    subclass = None
    superclass = UserSettingsBase_14
    def __init__(self, GroupNotification=None, AssistantNotification=None, DiscussionNotification=None, ChatNotification=None):
        self.original_tagname_ = None
        super(UserSettingsNotification_20, self).__init__()
        self.GroupNotification = GroupNotification
        self.AssistantNotification = AssistantNotification
        self.DiscussionNotification = DiscussionNotification
        self.ChatNotification = ChatNotification
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, UserSettingsNotification_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if UserSettingsNotification_20.subclass:
            return UserSettingsNotification_20.subclass(*args_, **kwargs_)
        else:
            return UserSettingsNotification_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_GroupNotification(self): return self.GroupNotification
    def set_GroupNotification(self, GroupNotification): self.GroupNotification = GroupNotification
    def get_AssistantNotification(self): return self.AssistantNotification
    def set_AssistantNotification(self, AssistantNotification): self.AssistantNotification = AssistantNotification
    def get_DiscussionNotification(self): return self.DiscussionNotification
    def set_DiscussionNotification(self, DiscussionNotification): self.DiscussionNotification = DiscussionNotification
    def get_ChatNotification(self): return self.ChatNotification
    def set_ChatNotification(self, ChatNotification): self.ChatNotification = ChatNotification
    def hasContent_(self):
        if (
            self.GroupNotification is not None or
            self.AssistantNotification is not None or
            self.DiscussionNotification is not None or
            self.ChatNotification is not None or
            super(UserSettingsNotification_20, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(UserSettingsNotification_20, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'GroupNotification':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'GroupNotification')
            self.GroupNotification = ival_
        elif nodeName_ == 'AssistantNotification':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'AssistantNotification')
            self.AssistantNotification = ival_
        elif nodeName_ == 'DiscussionNotification':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'DiscussionNotification')
            self.DiscussionNotification = ival_
        elif nodeName_ == 'ChatNotification':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'ChatNotification')
            self.ChatNotification = ival_
        super(UserSettingsNotification_20, self).buildChildren(child_, node, nodeName_, True)
# end class UserSettingsNotification_20


class UserSettingsLocationTracking_20(UserSettingsBase_14):
    member_data_items_ = {
        'Enabled': MemberSpec_('Enabled', 'boolean', 0),
    }
    subclass = None
    superclass = UserSettingsBase_14
    def __init__(self, Enabled=None):
        self.original_tagname_ = None
        super(UserSettingsLocationTracking_20, self).__init__()
        self.Enabled = Enabled
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, UserSettingsLocationTracking_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if UserSettingsLocationTracking_20.subclass:
            return UserSettingsLocationTracking_20.subclass(*args_, **kwargs_)
        else:
            return UserSettingsLocationTracking_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Enabled(self): return self.Enabled
    def set_Enabled(self, Enabled): self.Enabled = Enabled
    def hasContent_(self):
        if (
            self.Enabled is not None or
            super(UserSettingsLocationTracking_20, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(UserSettingsLocationTracking_20, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Enabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'Enabled')
            self.Enabled = ival_
        super(UserSettingsLocationTracking_20, self).buildChildren(child_, node, nodeName_, True)
# end class UserSettingsLocationTracking_20


class UserSettingsGMailSync_14(UserSettingsBase_14):
    member_data_items_ = {
        'SyncApplicationId': MemberSpec_('SyncApplicationId', 'string', 0),
        'IsEnabled': MemberSpec_('IsEnabled', 'boolean', 0),
        'AuthorizationCode': MemberSpec_('AuthorizationCode', 'string', 0),
        'RefreshToken': MemberSpec_('RefreshToken', 'string', 0),
        'TopContactsList': MemberSpec_('TopContactsList', 'ListOfTopContacts_14', 0),
        'Account': MemberSpec_('Account', 'GmailAccountInfo_14', 0),
    }
    subclass = None
    superclass = UserSettingsBase_14
    def __init__(self, SyncApplicationId=None, IsEnabled=None, AuthorizationCode=None, RefreshToken=None, TopContactsList=None, Account=None):
        self.original_tagname_ = None
        super(UserSettingsGMailSync_14, self).__init__()
        self.SyncApplicationId = SyncApplicationId
        self.IsEnabled = IsEnabled
        self.AuthorizationCode = AuthorizationCode
        self.RefreshToken = RefreshToken
        self.TopContactsList = TopContactsList
        self.Account = Account
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, UserSettingsGMailSync_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if UserSettingsGMailSync_14.subclass:
            return UserSettingsGMailSync_14.subclass(*args_, **kwargs_)
        else:
            return UserSettingsGMailSync_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_SyncApplicationId(self): return self.SyncApplicationId
    def set_SyncApplicationId(self, SyncApplicationId): self.SyncApplicationId = SyncApplicationId
    def get_IsEnabled(self): return self.IsEnabled
    def set_IsEnabled(self, IsEnabled): self.IsEnabled = IsEnabled
    def get_AuthorizationCode(self): return self.AuthorizationCode
    def set_AuthorizationCode(self, AuthorizationCode): self.AuthorizationCode = AuthorizationCode
    def get_RefreshToken(self): return self.RefreshToken
    def set_RefreshToken(self, RefreshToken): self.RefreshToken = RefreshToken
    def get_TopContactsList(self): return self.TopContactsList
    def set_TopContactsList(self, TopContactsList): self.TopContactsList = TopContactsList
    def get_Account(self): return self.Account
    def set_Account(self, Account): self.Account = Account
    def hasContent_(self):
        if (
            self.SyncApplicationId is not None or
            self.IsEnabled is not None or
            self.AuthorizationCode is not None or
            self.RefreshToken is not None or
            self.TopContactsList is not None or
            self.Account is not None or
            super(UserSettingsGMailSync_14, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(UserSettingsGMailSync_14, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'SyncApplicationId':
            SyncApplicationId_ = child_.text
            SyncApplicationId_ = self.gds_validate_string(SyncApplicationId_, node, 'SyncApplicationId')
            self.SyncApplicationId = SyncApplicationId_
        elif nodeName_ == 'IsEnabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsEnabled')
            self.IsEnabled = ival_
        elif nodeName_ == 'AuthorizationCode':
            AuthorizationCode_ = child_.text
            AuthorizationCode_ = self.gds_validate_string(AuthorizationCode_, node, 'AuthorizationCode')
            self.AuthorizationCode = AuthorizationCode_
        elif nodeName_ == 'RefreshToken':
            RefreshToken_ = child_.text
            RefreshToken_ = self.gds_validate_string(RefreshToken_, node, 'RefreshToken')
            self.RefreshToken = RefreshToken_
        elif nodeName_ == 'TopContactsList':
            obj_ = ListOfTopContacts_14.factory()
            obj_.build(child_)
            self.TopContactsList = obj_
            obj_.original_tagname_ = 'TopContactsList'
        elif nodeName_ == 'Account':
            obj_ = GmailAccountInfo_14.factory()
            obj_.build(child_)
            self.Account = obj_
            obj_.original_tagname_ = 'Account'
        super(UserSettingsGMailSync_14, self).buildChildren(child_, node, nodeName_, True)
# end class UserSettingsGMailSync_14


class GmailAccountInfo_14(GeneratedsSuper):
    member_data_items_ = {
        'UserId': MemberSpec_('UserId', 'string', 0),
        'Name': MemberSpec_('Name', 'string', 0),
        'Email': MemberSpec_('Email', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, UserId=None, Name=None, Email=None):
        self.original_tagname_ = None
        self.UserId = UserId
        self.Name = Name
        self.Email = Email
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GmailAccountInfo_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GmailAccountInfo_14.subclass:
            return GmailAccountInfo_14.subclass(*args_, **kwargs_)
        else:
            return GmailAccountInfo_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_UserId(self): return self.UserId
    def set_UserId(self, UserId): self.UserId = UserId
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Email(self): return self.Email
    def set_Email(self, Email): self.Email = Email
    def hasContent_(self):
        if (
            self.UserId is not None or
            self.Name is not None or
            self.Email is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'UserId':
            UserId_ = child_.text
            UserId_ = self.gds_validate_string(UserId_, node, 'UserId')
            self.UserId = UserId_
        elif nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Email':
            Email_ = child_.text
            Email_ = self.gds_validate_string(Email_, node, 'Email')
            self.Email = Email_
# end class GmailAccountInfo_14


class ListOfTopContacts_14(GeneratedsSuper):
    member_data_items_ = {
        'Contact': MemberSpec_('Contact', 'string', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Contact=None):
        self.original_tagname_ = None
        if Contact is None:
            self.Contact = []
        else:
            self.Contact = Contact
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfTopContacts_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfTopContacts_14.subclass:
            return ListOfTopContacts_14.subclass(*args_, **kwargs_)
        else:
            return ListOfTopContacts_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Contact(self): return self.Contact
    def set_Contact(self, Contact): self.Contact = Contact
    def add_Contact(self, value): self.Contact.append(value)
    def insert_Contact_at(self, index, value): self.Contact.insert(index, value)
    def replace_Contact_at(self, index, value): self.Contact[index] = value
    def hasContent_(self):
        if (
            self.Contact
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Contact':
            Contact_ = child_.text
            Contact_ = self.gds_validate_string(Contact_, node, 'Contact')
            self.Contact.append(Contact_)
# end class ListOfTopContacts_14


class UserSettingsGMailSync_16(UserSettingsBase_14):
    member_data_items_ = {
        'SyncApplicationId': MemberSpec_('SyncApplicationId', 'string', 0),
        'IsEnabled': MemberSpec_('IsEnabled', 'boolean', 0),
        'AuthorizationCode': MemberSpec_('AuthorizationCode', 'string', 0),
        'RefreshToken': MemberSpec_('RefreshToken', 'string', 0),
        'Account': MemberSpec_('Account', 'GmailAccountInfo_14', 0),
        'MarkAsRead': MemberSpec_('MarkAsRead', 'boolean', 0),
        'ImportDayRange': MemberSpec_('ImportDayRange', 'int', 0),
    }
    subclass = None
    superclass = UserSettingsBase_14
    def __init__(self, SyncApplicationId=None, IsEnabled=None, AuthorizationCode=None, RefreshToken=None, Account=None, MarkAsRead=None, ImportDayRange=None):
        self.original_tagname_ = None
        super(UserSettingsGMailSync_16, self).__init__()
        self.SyncApplicationId = SyncApplicationId
        self.IsEnabled = IsEnabled
        self.AuthorizationCode = AuthorizationCode
        self.RefreshToken = RefreshToken
        self.Account = Account
        self.MarkAsRead = MarkAsRead
        self.ImportDayRange = ImportDayRange
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, UserSettingsGMailSync_16)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if UserSettingsGMailSync_16.subclass:
            return UserSettingsGMailSync_16.subclass(*args_, **kwargs_)
        else:
            return UserSettingsGMailSync_16(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_SyncApplicationId(self): return self.SyncApplicationId
    def set_SyncApplicationId(self, SyncApplicationId): self.SyncApplicationId = SyncApplicationId
    def get_IsEnabled(self): return self.IsEnabled
    def set_IsEnabled(self, IsEnabled): self.IsEnabled = IsEnabled
    def get_AuthorizationCode(self): return self.AuthorizationCode
    def set_AuthorizationCode(self, AuthorizationCode): self.AuthorizationCode = AuthorizationCode
    def get_RefreshToken(self): return self.RefreshToken
    def set_RefreshToken(self, RefreshToken): self.RefreshToken = RefreshToken
    def get_Account(self): return self.Account
    def set_Account(self, Account): self.Account = Account
    def get_MarkAsRead(self): return self.MarkAsRead
    def set_MarkAsRead(self, MarkAsRead): self.MarkAsRead = MarkAsRead
    def get_ImportDayRange(self): return self.ImportDayRange
    def set_ImportDayRange(self, ImportDayRange): self.ImportDayRange = ImportDayRange
    def hasContent_(self):
        if (
            self.SyncApplicationId is not None or
            self.IsEnabled is not None or
            self.AuthorizationCode is not None or
            self.RefreshToken is not None or
            self.Account is not None or
            self.MarkAsRead is not None or
            self.ImportDayRange is not None or
            super(UserSettingsGMailSync_16, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(UserSettingsGMailSync_16, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'SyncApplicationId':
            SyncApplicationId_ = child_.text
            SyncApplicationId_ = self.gds_validate_string(SyncApplicationId_, node, 'SyncApplicationId')
            self.SyncApplicationId = SyncApplicationId_
        elif nodeName_ == 'IsEnabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsEnabled')
            self.IsEnabled = ival_
        elif nodeName_ == 'AuthorizationCode':
            AuthorizationCode_ = child_.text
            AuthorizationCode_ = self.gds_validate_string(AuthorizationCode_, node, 'AuthorizationCode')
            self.AuthorizationCode = AuthorizationCode_
        elif nodeName_ == 'RefreshToken':
            RefreshToken_ = child_.text
            RefreshToken_ = self.gds_validate_string(RefreshToken_, node, 'RefreshToken')
            self.RefreshToken = RefreshToken_
        elif nodeName_ == 'Account':
            obj_ = GmailAccountInfo_14.factory()
            obj_.build(child_)
            self.Account = obj_
            obj_.original_tagname_ = 'Account'
        elif nodeName_ == 'MarkAsRead':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'MarkAsRead')
            self.MarkAsRead = ival_
        elif nodeName_ == 'ImportDayRange':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'ImportDayRange')
            self.ImportDayRange = ival_
        super(UserSettingsGMailSync_16, self).buildChildren(child_, node, nodeName_, True)
# end class UserSettingsGMailSync_16


class UserSettingsMicrosoftExchangeSync_16(UserSettingsBase_14):
    member_data_items_ = {
        'SyncApplicationId': MemberSpec_('SyncApplicationId', 'string', 0),
        'IsEnabled': MemberSpec_('IsEnabled', 'boolean', 0),
        'Email': MemberSpec_('Email', 'string', 0),
        'Secret': MemberSpec_('Secret', 'string', 0),
        'Domain': MemberSpec_('Domain', 'string', 0),
        'MarkAsRead': MemberSpec_('MarkAsRead', 'boolean', 0),
        'ImportDayRange': MemberSpec_('ImportDayRange', 'int', 0),
    }
    subclass = None
    superclass = UserSettingsBase_14
    def __init__(self, SyncApplicationId=None, IsEnabled=None, Email=None, Secret=None, Domain=None, MarkAsRead=None, ImportDayRange=None):
        self.original_tagname_ = None
        super(UserSettingsMicrosoftExchangeSync_16, self).__init__()
        self.SyncApplicationId = SyncApplicationId
        self.IsEnabled = IsEnabled
        self.Email = Email
        self.Secret = Secret
        self.Domain = Domain
        self.MarkAsRead = MarkAsRead
        self.ImportDayRange = ImportDayRange
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, UserSettingsMicrosoftExchangeSync_16)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if UserSettingsMicrosoftExchangeSync_16.subclass:
            return UserSettingsMicrosoftExchangeSync_16.subclass(*args_, **kwargs_)
        else:
            return UserSettingsMicrosoftExchangeSync_16(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_SyncApplicationId(self): return self.SyncApplicationId
    def set_SyncApplicationId(self, SyncApplicationId): self.SyncApplicationId = SyncApplicationId
    def get_IsEnabled(self): return self.IsEnabled
    def set_IsEnabled(self, IsEnabled): self.IsEnabled = IsEnabled
    def get_Email(self): return self.Email
    def set_Email(self, Email): self.Email = Email
    def get_Secret(self): return self.Secret
    def set_Secret(self, Secret): self.Secret = Secret
    def get_Domain(self): return self.Domain
    def set_Domain(self, Domain): self.Domain = Domain
    def get_MarkAsRead(self): return self.MarkAsRead
    def set_MarkAsRead(self, MarkAsRead): self.MarkAsRead = MarkAsRead
    def get_ImportDayRange(self): return self.ImportDayRange
    def set_ImportDayRange(self, ImportDayRange): self.ImportDayRange = ImportDayRange
    def hasContent_(self):
        if (
            self.SyncApplicationId is not None or
            self.IsEnabled is not None or
            self.Email is not None or
            self.Secret is not None or
            self.Domain is not None or
            self.MarkAsRead is not None or
            self.ImportDayRange is not None or
            super(UserSettingsMicrosoftExchangeSync_16, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(UserSettingsMicrosoftExchangeSync_16, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'SyncApplicationId':
            SyncApplicationId_ = child_.text
            SyncApplicationId_ = self.gds_validate_string(SyncApplicationId_, node, 'SyncApplicationId')
            self.SyncApplicationId = SyncApplicationId_
        elif nodeName_ == 'IsEnabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsEnabled')
            self.IsEnabled = ival_
        elif nodeName_ == 'Email':
            Email_ = child_.text
            Email_ = self.gds_validate_string(Email_, node, 'Email')
            self.Email = Email_
        elif nodeName_ == 'Secret':
            Secret_ = child_.text
            Secret_ = self.gds_validate_string(Secret_, node, 'Secret')
            self.Secret = Secret_
        elif nodeName_ == 'Domain':
            Domain_ = child_.text
            Domain_ = self.gds_validate_string(Domain_, node, 'Domain')
            self.Domain = Domain_
        elif nodeName_ == 'MarkAsRead':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'MarkAsRead')
            self.MarkAsRead = ival_
        elif nodeName_ == 'ImportDayRange':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'ImportDayRange')
            self.ImportDayRange = ival_
        super(UserSettingsMicrosoftExchangeSync_16, self).buildChildren(child_, node, nodeName_, True)
# end class UserSettingsMicrosoftExchangeSync_16


class GroupEmail_17(GeneratedsSuper):
    member_data_items_ = {
        'Address': MemberSpec_('Address', 'string', 0),
        'NameSuffix': MemberSpec_('NameSuffix', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Address=None, NameSuffix=None):
        self.original_tagname_ = None
        self.Address = Address
        self.NameSuffix = NameSuffix
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GroupEmail_17)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GroupEmail_17.subclass:
            return GroupEmail_17.subclass(*args_, **kwargs_)
        else:
            return GroupEmail_17(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Address(self): return self.Address
    def set_Address(self, Address): self.Address = Address
    def get_NameSuffix(self): return self.NameSuffix
    def set_NameSuffix(self, NameSuffix): self.NameSuffix = NameSuffix
    def hasContent_(self):
        if (
            self.Address is not None or
            self.NameSuffix is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Address':
            Address_ = child_.text
            Address_ = self.gds_validate_string(Address_, node, 'Address')
            self.Address = Address_
        elif nodeName_ == 'NameSuffix':
            NameSuffix_ = child_.text
            NameSuffix_ = self.gds_validate_string(NameSuffix_, node, 'NameSuffix')
            self.NameSuffix = NameSuffix_
# end class GroupEmail_17


class GroupAvatar_17(GeneratedsSuper):
    member_data_items_ = {
        'GroupId': MemberSpec_('GroupId', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, GroupId=None):
        self.original_tagname_ = None
        self.GroupId = GroupId
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GroupAvatar_17)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GroupAvatar_17.subclass:
            return GroupAvatar_17.subclass(*args_, **kwargs_)
        else:
            return GroupAvatar_17(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_GroupId(self): return self.GroupId
    def set_GroupId(self, GroupId): self.GroupId = GroupId
    def hasContent_(self):
        if (
            self.GroupId is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'GroupId':
            GroupId_ = child_.text
            GroupId_ = self.gds_validate_string(GroupId_, node, 'GroupId')
            self.GroupId = GroupId_
# end class GroupAvatar_17


class BoardAvatar_22(GeneratedsSuper):
    member_data_items_ = {
        'BoardId': MemberSpec_('BoardId', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, BoardId=None):
        self.original_tagname_ = None
        self.BoardId = BoardId
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BoardAvatar_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BoardAvatar_22.subclass:
            return BoardAvatar_22.subclass(*args_, **kwargs_)
        else:
            return BoardAvatar_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_BoardId(self): return self.BoardId
    def set_BoardId(self, BoardId): self.BoardId = BoardId
    def hasContent_(self):
        if (
            self.BoardId is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'BoardId':
            BoardId_ = child_.text
            BoardId_ = self.gds_validate_string(BoardId_, node, 'BoardId')
            self.BoardId = BoardId_
# end class BoardAvatar_22


class GroupNotificationSettings_17(GeneratedsSuper):
    member_data_items_ = {
        'GroupId': MemberSpec_('GroupId', 'string', 0),
        'Disabled': MemberSpec_('Disabled', 'boolean', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, GroupId=None, Disabled=None):
        self.original_tagname_ = None
        self.GroupId = GroupId
        self.Disabled = Disabled
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GroupNotificationSettings_17)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GroupNotificationSettings_17.subclass:
            return GroupNotificationSettings_17.subclass(*args_, **kwargs_)
        else:
            return GroupNotificationSettings_17(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_GroupId(self): return self.GroupId
    def set_GroupId(self, GroupId): self.GroupId = GroupId
    def get_Disabled(self): return self.Disabled
    def set_Disabled(self, Disabled): self.Disabled = Disabled
    def hasContent_(self):
        if (
            self.GroupId is not None or
            self.Disabled is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'GroupId':
            GroupId_ = child_.text
            GroupId_ = self.gds_validate_string(GroupId_, node, 'GroupId')
            self.GroupId = GroupId_
        elif nodeName_ == 'Disabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'Disabled')
            self.Disabled = ival_
# end class GroupNotificationSettings_17


class Campaign_12(GeneratedsSuper):
    member_data_items_ = {
        'UtmSource': MemberSpec_('UtmSource', 'string', 0),
        'UtmMedium': MemberSpec_('UtmMedium', 'string', 0),
        'UtmCampaign': MemberSpec_('UtmCampaign', 'string', 0),
        'LandingPage': MemberSpec_('LandingPage', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, UtmSource=None, UtmMedium=None, UtmCampaign=None, LandingPage=None):
        self.original_tagname_ = None
        self.UtmSource = UtmSource
        self.UtmMedium = UtmMedium
        self.UtmCampaign = UtmCampaign
        self.LandingPage = LandingPage
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Campaign_12)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Campaign_12.subclass:
            return Campaign_12.subclass(*args_, **kwargs_)
        else:
            return Campaign_12(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_UtmSource(self): return self.UtmSource
    def set_UtmSource(self, UtmSource): self.UtmSource = UtmSource
    def get_UtmMedium(self): return self.UtmMedium
    def set_UtmMedium(self, UtmMedium): self.UtmMedium = UtmMedium
    def get_UtmCampaign(self): return self.UtmCampaign
    def set_UtmCampaign(self, UtmCampaign): self.UtmCampaign = UtmCampaign
    def get_LandingPage(self): return self.LandingPage
    def set_LandingPage(self, LandingPage): self.LandingPage = LandingPage
    def hasContent_(self):
        if (
            self.UtmSource is not None or
            self.UtmMedium is not None or
            self.UtmCampaign is not None or
            self.LandingPage is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'UtmSource':
            UtmSource_ = child_.text
            UtmSource_ = self.gds_validate_string(UtmSource_, node, 'UtmSource')
            self.UtmSource = UtmSource_
        elif nodeName_ == 'UtmMedium':
            UtmMedium_ = child_.text
            UtmMedium_ = self.gds_validate_string(UtmMedium_, node, 'UtmMedium')
            self.UtmMedium = UtmMedium_
        elif nodeName_ == 'UtmCampaign':
            UtmCampaign_ = child_.text
            UtmCampaign_ = self.gds_validate_string(UtmCampaign_, node, 'UtmCampaign')
            self.UtmCampaign = UtmCampaign_
        elif nodeName_ == 'LandingPage':
            LandingPage_ = child_.text
            LandingPage_ = self.gds_validate_string(LandingPage_, node, 'LandingPage')
            self.LandingPage = LandingPage_
# end class Campaign_12


class Referral_13(GeneratedsSuper):
    member_data_items_ = {
        'CommunityReferralId': MemberSpec_('CommunityReferralId', 'string', 0),
        'ForeignReferralId': MemberSpec_('ForeignReferralId', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, CommunityReferralId=None, ForeignReferralId=None):
        self.original_tagname_ = None
        self.CommunityReferralId = CommunityReferralId
        self.ForeignReferralId = ForeignReferralId
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Referral_13)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Referral_13.subclass:
            return Referral_13.subclass(*args_, **kwargs_)
        else:
            return Referral_13(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_CommunityReferralId(self): return self.CommunityReferralId
    def set_CommunityReferralId(self, CommunityReferralId): self.CommunityReferralId = CommunityReferralId
    def get_ForeignReferralId(self): return self.ForeignReferralId
    def set_ForeignReferralId(self, ForeignReferralId): self.ForeignReferralId = ForeignReferralId
    def hasContent_(self):
        if (
            self.CommunityReferralId is not None or
            self.ForeignReferralId is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'CommunityReferralId':
            CommunityReferralId_ = child_.text
            CommunityReferralId_ = self.gds_validate_string(CommunityReferralId_, node, 'CommunityReferralId')
            self.CommunityReferralId = CommunityReferralId_
        elif nodeName_ == 'ForeignReferralId':
            ForeignReferralId_ = child_.text
            ForeignReferralId_ = self.gds_validate_string(ForeignReferralId_, node, 'ForeignReferralId')
            self.ForeignReferralId = ForeignReferralId_
# end class Referral_13


class Language_12(GeneratedsSuper):
    member_data_items_ = {
        'CultureCode': MemberSpec_('CultureCode', 'string', 0),
        'Name': MemberSpec_('Name', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, CultureCode=None, Name=None):
        self.original_tagname_ = None
        self.CultureCode = CultureCode
        self.Name = Name
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Language_12)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Language_12.subclass:
            return Language_12.subclass(*args_, **kwargs_)
        else:
            return Language_12(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_CultureCode(self): return self.CultureCode
    def set_CultureCode(self, CultureCode): self.CultureCode = CultureCode
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def hasContent_(self):
        if (
            self.CultureCode is not None or
            self.Name is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'CultureCode':
            CultureCode_ = child_.text
            CultureCode_ = self.gds_validate_string(CultureCode_, node, 'CultureCode')
            self.CultureCode = CultureCode_
        elif nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
# end class Language_12


class ListOfLanguages_12(GeneratedsSuper):
    member_data_items_ = {
        'Language': MemberSpec_('Language', 'Language_12', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Language=None):
        self.original_tagname_ = None
        if Language is None:
            self.Language = []
        else:
            self.Language = Language
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfLanguages_12)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfLanguages_12.subclass:
            return ListOfLanguages_12.subclass(*args_, **kwargs_)
        else:
            return ListOfLanguages_12(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Language(self): return self.Language
    def set_Language(self, Language): self.Language = Language
    def add_Language(self, value): self.Language.append(value)
    def insert_Language_at(self, index, value): self.Language.insert(index, value)
    def replace_Language_at(self, index, value): self.Language[index] = value
    def hasContent_(self):
        if (
            self.Language
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Language':
            obj_ = Language_12.factory()
            obj_.build(child_)
            self.Language.append(obj_)
            obj_.original_tagname_ = 'Language'
# end class ListOfLanguages_12


class Language_14(GeneratedsSuper):
    member_data_items_ = {
        'CultureCode': MemberSpec_('CultureCode', 'string', 0),
        'Name': MemberSpec_('Name', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, CultureCode=None, Name=None):
        self.original_tagname_ = None
        self.CultureCode = CultureCode
        self.Name = Name
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Language_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Language_14.subclass:
            return Language_14.subclass(*args_, **kwargs_)
        else:
            return Language_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_CultureCode(self): return self.CultureCode
    def set_CultureCode(self, CultureCode): self.CultureCode = CultureCode
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def hasContent_(self):
        if (
            self.CultureCode is not None or
            self.Name is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'CultureCode':
            CultureCode_ = child_.text
            CultureCode_ = self.gds_validate_string(CultureCode_, node, 'CultureCode')
            self.CultureCode = CultureCode_
        elif nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
# end class Language_14


class ListOfLanguages_14(GeneratedsSuper):
    member_data_items_ = {
        'Language': MemberSpec_('Language', 'Language_14', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Language=None):
        self.original_tagname_ = None
        if Language is None:
            self.Language = []
        else:
            self.Language = Language
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfLanguages_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfLanguages_14.subclass:
            return ListOfLanguages_14.subclass(*args_, **kwargs_)
        else:
            return ListOfLanguages_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Language(self): return self.Language
    def set_Language(self, Language): self.Language = Language
    def add_Language(self, value): self.Language.append(value)
    def insert_Language_at(self, index, value): self.Language.insert(index, value)
    def replace_Language_at(self, index, value): self.Language[index] = value
    def hasContent_(self):
        if (
            self.Language
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Language':
            obj_ = Language_14.factory()
            obj_.build(child_)
            self.Language.append(obj_)
            obj_.original_tagname_ = 'Language'
# end class ListOfLanguages_14


class ListOfLanguagesPage_14(GeneratedsSuper):
    member_data_items_ = {
        'ListOfLanguages': MemberSpec_('ListOfLanguages', 'ListOfLanguages_14', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, ListOfLanguages=None, Paging=None):
        self.original_tagname_ = None
        self.ListOfLanguages = ListOfLanguages
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfLanguagesPage_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfLanguagesPage_14.subclass:
            return ListOfLanguagesPage_14.subclass(*args_, **kwargs_)
        else:
            return ListOfLanguagesPage_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ListOfLanguages(self): return self.ListOfLanguages
    def set_ListOfLanguages(self, ListOfLanguages): self.ListOfLanguages = ListOfLanguages
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.ListOfLanguages is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ListOfLanguages':
            obj_ = ListOfLanguages_14.factory()
            obj_.build(child_)
            self.ListOfLanguages = obj_
            obj_.original_tagname_ = 'ListOfLanguages'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class ListOfLanguagesPage_14


class Region_14(GeneratedsSuper):
    member_data_items_ = {
        'RegionCode': MemberSpec_('RegionCode', 'string', 0),
        'Name': MemberSpec_('Name', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, RegionCode=None, Name=None):
        self.original_tagname_ = None
        self.RegionCode = RegionCode
        self.Name = Name
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Region_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Region_14.subclass:
            return Region_14.subclass(*args_, **kwargs_)
        else:
            return Region_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_RegionCode(self): return self.RegionCode
    def set_RegionCode(self, RegionCode): self.RegionCode = RegionCode
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def hasContent_(self):
        if (
            self.RegionCode is not None or
            self.Name is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'RegionCode':
            RegionCode_ = child_.text
            RegionCode_ = self.gds_validate_string(RegionCode_, node, 'RegionCode')
            self.RegionCode = RegionCode_
        elif nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
# end class Region_14


class ListOfRegions_14(GeneratedsSuper):
    member_data_items_ = {
        'Region': MemberSpec_('Region', 'Region_14', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Region=None):
        self.original_tagname_ = None
        if Region is None:
            self.Region = []
        else:
            self.Region = Region
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfRegions_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfRegions_14.subclass:
            return ListOfRegions_14.subclass(*args_, **kwargs_)
        else:
            return ListOfRegions_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Region(self): return self.Region
    def set_Region(self, Region): self.Region = Region
    def add_Region(self, value): self.Region.append(value)
    def insert_Region_at(self, index, value): self.Region.insert(index, value)
    def replace_Region_at(self, index, value): self.Region[index] = value
    def hasContent_(self):
        if (
            self.Region
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Region':
            obj_ = Region_14.factory()
            obj_.build(child_)
            self.Region.append(obj_)
            obj_.original_tagname_ = 'Region'
# end class ListOfRegions_14


class ListOfRegionsPage_14(GeneratedsSuper):
    member_data_items_ = {
        'ListOfRegions': MemberSpec_('ListOfRegions', 'ListOfRegions_14', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, ListOfRegions=None, Paging=None):
        self.original_tagname_ = None
        self.ListOfRegions = ListOfRegions
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfRegionsPage_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfRegionsPage_14.subclass:
            return ListOfRegionsPage_14.subclass(*args_, **kwargs_)
        else:
            return ListOfRegionsPage_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ListOfRegions(self): return self.ListOfRegions
    def set_ListOfRegions(self, ListOfRegions): self.ListOfRegions = ListOfRegions
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.ListOfRegions is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ListOfRegions':
            obj_ = ListOfRegions_14.factory()
            obj_.build(child_)
            self.ListOfRegions = obj_
            obj_.original_tagname_ = 'ListOfRegions'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class ListOfRegionsPage_14


class TimeZone_14(GeneratedsSuper):
    member_data_items_ = {
        'Id': MemberSpec_('Id', 'string', 0),
        'Name': MemberSpec_('Name', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Id=None, Name=None):
        self.original_tagname_ = None
        self.Id = Id
        self.Name = Name
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TimeZone_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TimeZone_14.subclass:
            return TimeZone_14.subclass(*args_, **kwargs_)
        else:
            return TimeZone_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Id(self): return self.Id
    def set_Id(self, Id): self.Id = Id
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def hasContent_(self):
        if (
            self.Id is not None or
            self.Name is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Id':
            Id_ = child_.text
            Id_ = self.gds_validate_string(Id_, node, 'Id')
            self.Id = Id_
        elif nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
# end class TimeZone_14


class ListOfTimeZones_14(GeneratedsSuper):
    member_data_items_ = {
        'TimeZone': MemberSpec_('TimeZone', 'TimeZone_14', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, TimeZone=None):
        self.original_tagname_ = None
        if TimeZone is None:
            self.TimeZone = []
        else:
            self.TimeZone = TimeZone
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfTimeZones_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfTimeZones_14.subclass:
            return ListOfTimeZones_14.subclass(*args_, **kwargs_)
        else:
            return ListOfTimeZones_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_TimeZone(self): return self.TimeZone
    def set_TimeZone(self, TimeZone): self.TimeZone = TimeZone
    def add_TimeZone(self, value): self.TimeZone.append(value)
    def insert_TimeZone_at(self, index, value): self.TimeZone.insert(index, value)
    def replace_TimeZone_at(self, index, value): self.TimeZone[index] = value
    def hasContent_(self):
        if (
            self.TimeZone
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'TimeZone':
            obj_ = TimeZone_14.factory()
            obj_.build(child_)
            self.TimeZone.append(obj_)
            obj_.original_tagname_ = 'TimeZone'
# end class ListOfTimeZones_14


class ListOfTimeZonesPage_14(GeneratedsSuper):
    member_data_items_ = {
        'ListOfTimeZones': MemberSpec_('ListOfTimeZones', 'ListOfTimeZones_14', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, ListOfTimeZones=None, Paging=None):
        self.original_tagname_ = None
        self.ListOfTimeZones = ListOfTimeZones
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfTimeZonesPage_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfTimeZonesPage_14.subclass:
            return ListOfTimeZonesPage_14.subclass(*args_, **kwargs_)
        else:
            return ListOfTimeZonesPage_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ListOfTimeZones(self): return self.ListOfTimeZones
    def set_ListOfTimeZones(self, ListOfTimeZones): self.ListOfTimeZones = ListOfTimeZones
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.ListOfTimeZones is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ListOfTimeZones':
            obj_ = ListOfTimeZones_14.factory()
            obj_.build(child_)
            self.ListOfTimeZones = obj_
            obj_.original_tagname_ = 'ListOfTimeZones'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class ListOfTimeZonesPage_14


class Feed_22(GeneratedsSuper):
    member_data_items_ = {
        'DiscussionListPage': MemberSpec_('DiscussionListPage', 'ListOfDiscussionsPage_22', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, DiscussionListPage=None):
        self.original_tagname_ = None
        self.DiscussionListPage = DiscussionListPage
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Feed_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Feed_22.subclass:
            return Feed_22.subclass(*args_, **kwargs_)
        else:
            return Feed_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_DiscussionListPage(self): return self.DiscussionListPage
    def set_DiscussionListPage(self, DiscussionListPage): self.DiscussionListPage = DiscussionListPage
    def hasContent_(self):
        if (
            self.DiscussionListPage is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'DiscussionListPage':
            obj_ = ListOfDiscussionsPage_22.factory()
            obj_.build(child_)
            self.DiscussionListPage = obj_
            obj_.original_tagname_ = 'DiscussionListPage'
# end class Feed_22


class Feed_20(GeneratedsSuper):
    member_data_items_ = {
        'DiscussionListPage': MemberSpec_('DiscussionListPage', 'ListOfDiscussionsPage_20', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, DiscussionListPage=None):
        self.original_tagname_ = None
        self.DiscussionListPage = DiscussionListPage
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Feed_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Feed_20.subclass:
            return Feed_20.subclass(*args_, **kwargs_)
        else:
            return Feed_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_DiscussionListPage(self): return self.DiscussionListPage
    def set_DiscussionListPage(self, DiscussionListPage): self.DiscussionListPage = DiscussionListPage
    def hasContent_(self):
        if (
            self.DiscussionListPage is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'DiscussionListPage':
            obj_ = ListOfDiscussionsPage_20.factory()
            obj_.build(child_)
            self.DiscussionListPage = obj_
            obj_.original_tagname_ = 'DiscussionListPage'
# end class Feed_20


class Feed_19(GeneratedsSuper):
    member_data_items_ = {
        'DiscussionListPage': MemberSpec_('DiscussionListPage', 'ListOfDiscussionsPage_18', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, DiscussionListPage=None):
        self.original_tagname_ = None
        self.DiscussionListPage = DiscussionListPage
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Feed_19)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Feed_19.subclass:
            return Feed_19.subclass(*args_, **kwargs_)
        else:
            return Feed_19(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_DiscussionListPage(self): return self.DiscussionListPage
    def set_DiscussionListPage(self, DiscussionListPage): self.DiscussionListPage = DiscussionListPage
    def hasContent_(self):
        if (
            self.DiscussionListPage is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'DiscussionListPage':
            obj_ = ListOfDiscussionsPage_18.factory()
            obj_.build(child_)
            self.DiscussionListPage = obj_
            obj_.original_tagname_ = 'DiscussionListPage'
# end class Feed_19


class ListOfDiscussionsPage_22(GeneratedsSuper):
    member_data_items_ = {
        'DiscussionList': MemberSpec_('DiscussionList', 'ListOfDiscussions_22', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, DiscussionList=None, Paging=None):
        self.original_tagname_ = None
        self.DiscussionList = DiscussionList
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfDiscussionsPage_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfDiscussionsPage_22.subclass:
            return ListOfDiscussionsPage_22.subclass(*args_, **kwargs_)
        else:
            return ListOfDiscussionsPage_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_DiscussionList(self): return self.DiscussionList
    def set_DiscussionList(self, DiscussionList): self.DiscussionList = DiscussionList
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.DiscussionList is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'DiscussionList':
            obj_ = ListOfDiscussions_22.factory()
            obj_.build(child_)
            self.DiscussionList = obj_
            obj_.original_tagname_ = 'DiscussionList'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class ListOfDiscussionsPage_22


class ListOfDiscussions_22(GeneratedsSuper):
    member_data_items_ = {
        'Discussion': MemberSpec_('Discussion', 'DiscussionBase_22', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Discussion=None):
        self.original_tagname_ = None
        if Discussion is None:
            self.Discussion = []
        else:
            self.Discussion = Discussion
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfDiscussions_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfDiscussions_22.subclass:
            return ListOfDiscussions_22.subclass(*args_, **kwargs_)
        else:
            return ListOfDiscussions_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Discussion(self): return self.Discussion
    def set_Discussion(self, Discussion): self.Discussion = Discussion
    def add_Discussion(self, value): self.Discussion.append(value)
    def insert_Discussion_at(self, index, value): self.Discussion.insert(index, value)
    def replace_Discussion_at(self, index, value): self.Discussion[index] = value
    def hasContent_(self):
        if (
            self.Discussion
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Discussion':
            class_obj_ = self.get_class_obj_(child_, DiscussionBase_22)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Discussion.append(obj_)
            obj_.original_tagname_ = 'Discussion'
# end class ListOfDiscussions_22


class ListOfDiscussionCardsPage_22(GeneratedsSuper):
    member_data_items_ = {
        'CardList': MemberSpec_('CardList', 'ListOfDiscussionCards_22', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, CardList=None, Paging=None):
        self.original_tagname_ = None
        self.CardList = CardList
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfDiscussionCardsPage_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfDiscussionCardsPage_22.subclass:
            return ListOfDiscussionCardsPage_22.subclass(*args_, **kwargs_)
        else:
            return ListOfDiscussionCardsPage_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_CardList(self): return self.CardList
    def set_CardList(self, CardList): self.CardList = CardList
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.CardList is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'CardList':
            obj_ = ListOfDiscussionCards_22.factory()
            obj_.build(child_)
            self.CardList = obj_
            obj_.original_tagname_ = 'CardList'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class ListOfDiscussionCardsPage_22


class ListOfDiscussionCards_22(GeneratedsSuper):
    member_data_items_ = {
        'Discussion': MemberSpec_('Discussion', 'DiscussionCard_22', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Discussion=None):
        self.original_tagname_ = None
        if Discussion is None:
            self.Discussion = []
        else:
            self.Discussion = Discussion
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfDiscussionCards_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfDiscussionCards_22.subclass:
            return ListOfDiscussionCards_22.subclass(*args_, **kwargs_)
        else:
            return ListOfDiscussionCards_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Discussion(self): return self.Discussion
    def set_Discussion(self, Discussion): self.Discussion = Discussion
    def add_Discussion(self, value): self.Discussion.append(value)
    def insert_Discussion_at(self, index, value): self.Discussion.insert(index, value)
    def replace_Discussion_at(self, index, value): self.Discussion[index] = value
    def hasContent_(self):
        if (
            self.Discussion
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Discussion':
            obj_ = DiscussionCard_22.factory()
            obj_.build(child_)
            self.Discussion.append(obj_)
            obj_.original_tagname_ = 'Discussion'
# end class ListOfDiscussionCards_22


class ListOfDiscussionsPage_20(GeneratedsSuper):
    member_data_items_ = {
        'DiscussionList': MemberSpec_('DiscussionList', 'ListOfDiscussions_20', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, DiscussionList=None, Paging=None):
        self.original_tagname_ = None
        self.DiscussionList = DiscussionList
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfDiscussionsPage_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfDiscussionsPage_20.subclass:
            return ListOfDiscussionsPage_20.subclass(*args_, **kwargs_)
        else:
            return ListOfDiscussionsPage_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_DiscussionList(self): return self.DiscussionList
    def set_DiscussionList(self, DiscussionList): self.DiscussionList = DiscussionList
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.DiscussionList is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'DiscussionList':
            obj_ = ListOfDiscussions_20.factory()
            obj_.build(child_)
            self.DiscussionList = obj_
            obj_.original_tagname_ = 'DiscussionList'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class ListOfDiscussionsPage_20


class ListOfDiscussions_20(GeneratedsSuper):
    member_data_items_ = {
        'Discussion': MemberSpec_('Discussion', 'DiscussionBase_20', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Discussion=None):
        self.original_tagname_ = None
        if Discussion is None:
            self.Discussion = []
        else:
            self.Discussion = Discussion
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfDiscussions_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfDiscussions_20.subclass:
            return ListOfDiscussions_20.subclass(*args_, **kwargs_)
        else:
            return ListOfDiscussions_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Discussion(self): return self.Discussion
    def set_Discussion(self, Discussion): self.Discussion = Discussion
    def add_Discussion(self, value): self.Discussion.append(value)
    def insert_Discussion_at(self, index, value): self.Discussion.insert(index, value)
    def replace_Discussion_at(self, index, value): self.Discussion[index] = value
    def hasContent_(self):
        if (
            self.Discussion
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Discussion':
            class_obj_ = self.get_class_obj_(child_, DiscussionBase_20)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Discussion.append(obj_)
            obj_.original_tagname_ = 'Discussion'
# end class ListOfDiscussions_20


class ListOfDiscussionsPage_18(GeneratedsSuper):
    member_data_items_ = {
        'DiscussionList': MemberSpec_('DiscussionList', 'ListOfDiscussions_18', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, DiscussionList=None, Paging=None):
        self.original_tagname_ = None
        self.DiscussionList = DiscussionList
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfDiscussionsPage_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfDiscussionsPage_18.subclass:
            return ListOfDiscussionsPage_18.subclass(*args_, **kwargs_)
        else:
            return ListOfDiscussionsPage_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_DiscussionList(self): return self.DiscussionList
    def set_DiscussionList(self, DiscussionList): self.DiscussionList = DiscussionList
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.DiscussionList is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'DiscussionList':
            obj_ = ListOfDiscussions_18.factory()
            obj_.build(child_)
            self.DiscussionList = obj_
            obj_.original_tagname_ = 'DiscussionList'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class ListOfDiscussionsPage_18


class ListOfDiscussions_18(GeneratedsSuper):
    member_data_items_ = {
        'Discussion': MemberSpec_('Discussion', 'DiscussionBase_18', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Discussion=None):
        self.original_tagname_ = None
        if Discussion is None:
            self.Discussion = []
        else:
            self.Discussion = Discussion
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfDiscussions_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfDiscussions_18.subclass:
            return ListOfDiscussions_18.subclass(*args_, **kwargs_)
        else:
            return ListOfDiscussions_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Discussion(self): return self.Discussion
    def set_Discussion(self, Discussion): self.Discussion = Discussion
    def add_Discussion(self, value): self.Discussion.append(value)
    def insert_Discussion_at(self, index, value): self.Discussion.insert(index, value)
    def replace_Discussion_at(self, index, value): self.Discussion[index] = value
    def hasContent_(self):
        if (
            self.Discussion
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Discussion':
            class_obj_ = self.get_class_obj_(child_, DiscussionBase_18)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Discussion.append(obj_)
            obj_.original_tagname_ = 'Discussion'
# end class ListOfDiscussions_18


class ListOfDiscussionActivityItemsPage_18(GeneratedsSuper):
    member_data_items_ = {
        'DiscussionActivityItemList': MemberSpec_('DiscussionActivityItemList', 'ListOfDiscussionActivityItems_18', 0),
        'MoreUnreadCount': MemberSpec_('MoreUnreadCount', 'int', 0),
        'TotalUnreadCount': MemberSpec_('TotalUnreadCount', 'int', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, DiscussionActivityItemList=None, MoreUnreadCount=None, TotalUnreadCount=None, Paging=None):
        self.original_tagname_ = None
        self.DiscussionActivityItemList = DiscussionActivityItemList
        self.MoreUnreadCount = MoreUnreadCount
        self.TotalUnreadCount = TotalUnreadCount
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfDiscussionActivityItemsPage_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfDiscussionActivityItemsPage_18.subclass:
            return ListOfDiscussionActivityItemsPage_18.subclass(*args_, **kwargs_)
        else:
            return ListOfDiscussionActivityItemsPage_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_DiscussionActivityItemList(self): return self.DiscussionActivityItemList
    def set_DiscussionActivityItemList(self, DiscussionActivityItemList): self.DiscussionActivityItemList = DiscussionActivityItemList
    def get_MoreUnreadCount(self): return self.MoreUnreadCount
    def set_MoreUnreadCount(self, MoreUnreadCount): self.MoreUnreadCount = MoreUnreadCount
    def get_TotalUnreadCount(self): return self.TotalUnreadCount
    def set_TotalUnreadCount(self, TotalUnreadCount): self.TotalUnreadCount = TotalUnreadCount
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.DiscussionActivityItemList is not None or
            self.MoreUnreadCount is not None or
            self.TotalUnreadCount is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'DiscussionActivityItemList':
            obj_ = ListOfDiscussionActivityItems_18.factory()
            obj_.build(child_)
            self.DiscussionActivityItemList = obj_
            obj_.original_tagname_ = 'DiscussionActivityItemList'
        elif nodeName_ == 'MoreUnreadCount':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'MoreUnreadCount')
            self.MoreUnreadCount = ival_
        elif nodeName_ == 'TotalUnreadCount':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'TotalUnreadCount')
            self.TotalUnreadCount = ival_
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class ListOfDiscussionActivityItemsPage_18


class ListOfDiscussionActivityItems_18(GeneratedsSuper):
    member_data_items_ = {
        'DiscussionActivityItem': MemberSpec_('DiscussionActivityItem', 'DiscussionActivityItemPost_18', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, DiscussionActivityItem=None):
        self.original_tagname_ = None
        if DiscussionActivityItem is None:
            self.DiscussionActivityItem = []
        else:
            self.DiscussionActivityItem = DiscussionActivityItem
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfDiscussionActivityItems_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfDiscussionActivityItems_18.subclass:
            return ListOfDiscussionActivityItems_18.subclass(*args_, **kwargs_)
        else:
            return ListOfDiscussionActivityItems_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_DiscussionActivityItem(self): return self.DiscussionActivityItem
    def set_DiscussionActivityItem(self, DiscussionActivityItem): self.DiscussionActivityItem = DiscussionActivityItem
    def add_DiscussionActivityItem(self, value): self.DiscussionActivityItem.append(value)
    def insert_DiscussionActivityItem_at(self, index, value): self.DiscussionActivityItem.insert(index, value)
    def replace_DiscussionActivityItem_at(self, index, value): self.DiscussionActivityItem[index] = value
    def hasContent_(self):
        if (
            self.DiscussionActivityItem
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'DiscussionActivityItem':
            obj_ = DiscussionActivityItemPost_18.factory()
            obj_.build(child_)
            self.DiscussionActivityItem.append(obj_)
            obj_.original_tagname_ = 'DiscussionActivityItem'
# end class ListOfDiscussionActivityItems_18


class DiscussionActivityItemPost_18(GeneratedsSuper):
    member_data_items_ = {
        'Post': MemberSpec_('Post', 'Post_18', 0),
        'Unread': MemberSpec_('Unread', 'boolean', 0),
        'ErrorSending': MemberSpec_('ErrorSending', 'boolean', 0),
        'ImportedViaEmail': MemberSpec_('ImportedViaEmail', 'boolean', 0),
        'ForwardedCopy': MemberSpec_('ForwardedCopy', 'boolean', 0),
        'BodyFormat': MemberSpec_('BodyFormat', 'BodyFormat_18', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Post=None, Unread=None, ErrorSending=None, ImportedViaEmail=None, ForwardedCopy=None, BodyFormat=None):
        self.original_tagname_ = None
        self.Post = Post
        self.Unread = Unread
        self.ErrorSending = ErrorSending
        self.ImportedViaEmail = ImportedViaEmail
        self.ForwardedCopy = ForwardedCopy
        self.BodyFormat = BodyFormat
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DiscussionActivityItemPost_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DiscussionActivityItemPost_18.subclass:
            return DiscussionActivityItemPost_18.subclass(*args_, **kwargs_)
        else:
            return DiscussionActivityItemPost_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Post(self): return self.Post
    def set_Post(self, Post): self.Post = Post
    def get_Unread(self): return self.Unread
    def set_Unread(self, Unread): self.Unread = Unread
    def get_ErrorSending(self): return self.ErrorSending
    def set_ErrorSending(self, ErrorSending): self.ErrorSending = ErrorSending
    def get_ImportedViaEmail(self): return self.ImportedViaEmail
    def set_ImportedViaEmail(self, ImportedViaEmail): self.ImportedViaEmail = ImportedViaEmail
    def get_ForwardedCopy(self): return self.ForwardedCopy
    def set_ForwardedCopy(self, ForwardedCopy): self.ForwardedCopy = ForwardedCopy
    def get_BodyFormat(self): return self.BodyFormat
    def set_BodyFormat(self, BodyFormat): self.BodyFormat = BodyFormat
    def hasContent_(self):
        if (
            self.Post is not None or
            self.Unread is not None or
            self.ErrorSending is not None or
            self.ImportedViaEmail is not None or
            self.ForwardedCopy is not None or
            self.BodyFormat is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Post':
            obj_ = Post_18.factory()
            obj_.build(child_)
            self.Post = obj_
            obj_.original_tagname_ = 'Post'
        elif nodeName_ == 'Unread':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'Unread')
            self.Unread = ival_
        elif nodeName_ == 'ErrorSending':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'ErrorSending')
            self.ErrorSending = ival_
        elif nodeName_ == 'ImportedViaEmail':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'ImportedViaEmail')
            self.ImportedViaEmail = ival_
        elif nodeName_ == 'ForwardedCopy':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'ForwardedCopy')
            self.ForwardedCopy = ival_
        elif nodeName_ == 'BodyFormat':
            obj_ = BodyFormat_18.factory()
            obj_.build(child_)
            self.BodyFormat = obj_
            obj_.original_tagname_ = 'BodyFormat'
# end class DiscussionActivityItemPost_18


class BodyFormat_18(GeneratedsSuper):
    member_data_items_ = {
        'MimeTypeList': MemberSpec_('MimeTypeList', 'ListOfStrings', 0),
        'DefaultMimeType': MemberSpec_('DefaultMimeType', 'string', 0),
        'DefaultThumbnailPreview': MemberSpec_('DefaultThumbnailPreview', 'ThumbnailPreview_15', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, MimeTypeList=None, DefaultMimeType=None, DefaultThumbnailPreview=None):
        self.original_tagname_ = None
        self.MimeTypeList = MimeTypeList
        self.DefaultMimeType = DefaultMimeType
        self.DefaultThumbnailPreview = DefaultThumbnailPreview
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BodyFormat_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BodyFormat_18.subclass:
            return BodyFormat_18.subclass(*args_, **kwargs_)
        else:
            return BodyFormat_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_MimeTypeList(self): return self.MimeTypeList
    def set_MimeTypeList(self, MimeTypeList): self.MimeTypeList = MimeTypeList
    def get_DefaultMimeType(self): return self.DefaultMimeType
    def set_DefaultMimeType(self, DefaultMimeType): self.DefaultMimeType = DefaultMimeType
    def get_DefaultThumbnailPreview(self): return self.DefaultThumbnailPreview
    def set_DefaultThumbnailPreview(self, DefaultThumbnailPreview): self.DefaultThumbnailPreview = DefaultThumbnailPreview
    def hasContent_(self):
        if (
            self.MimeTypeList is not None or
            self.DefaultMimeType is not None or
            self.DefaultThumbnailPreview is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'MimeTypeList':
            obj_ = ListOfStrings.factory()
            obj_.build(child_)
            self.MimeTypeList = obj_
            obj_.original_tagname_ = 'MimeTypeList'
        elif nodeName_ == 'DefaultMimeType':
            DefaultMimeType_ = child_.text
            DefaultMimeType_ = self.gds_validate_string(DefaultMimeType_, node, 'DefaultMimeType')
            self.DefaultMimeType = DefaultMimeType_
        elif nodeName_ == 'DefaultThumbnailPreview':
            obj_ = ThumbnailPreview_15.factory()
            obj_.build(child_)
            self.DefaultThumbnailPreview = obj_
            obj_.original_tagname_ = 'DefaultThumbnailPreview'
# end class BodyFormat_18


class ListOfPostsPage_22(GeneratedsSuper):
    member_data_items_ = {
        'Posts': MemberSpec_('Posts', 'ListOfPosts_22', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Posts=None, Paging=None):
        self.original_tagname_ = None
        self.Posts = Posts
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfPostsPage_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfPostsPage_22.subclass:
            return ListOfPostsPage_22.subclass(*args_, **kwargs_)
        else:
            return ListOfPostsPage_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Posts(self): return self.Posts
    def set_Posts(self, Posts): self.Posts = Posts
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.Posts is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Posts':
            obj_ = ListOfPosts_22.factory()
            obj_.build(child_)
            self.Posts = obj_
            obj_.original_tagname_ = 'Posts'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class ListOfPostsPage_22


class ListOfPosts_22(GeneratedsSuper):
    member_data_items_ = {
        'Post': MemberSpec_('Post', 'Post_22', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Post=None):
        self.original_tagname_ = None
        if Post is None:
            self.Post = []
        else:
            self.Post = Post
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfPosts_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfPosts_22.subclass:
            return ListOfPosts_22.subclass(*args_, **kwargs_)
        else:
            return ListOfPosts_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Post(self): return self.Post
    def set_Post(self, Post): self.Post = Post
    def add_Post(self, value): self.Post.append(value)
    def insert_Post_at(self, index, value): self.Post.insert(index, value)
    def replace_Post_at(self, index, value): self.Post[index] = value
    def hasContent_(self):
        if (
            self.Post
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Post':
            class_obj_ = self.get_class_obj_(child_, Post_22)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Post.append(obj_)
            obj_.original_tagname_ = 'Post'
# end class ListOfPosts_22


class ListOfPostsPage_20(GeneratedsSuper):
    member_data_items_ = {
        'Posts': MemberSpec_('Posts', 'ListOfPosts_20', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Posts=None, Paging=None):
        self.original_tagname_ = None
        self.Posts = Posts
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfPostsPage_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfPostsPage_20.subclass:
            return ListOfPostsPage_20.subclass(*args_, **kwargs_)
        else:
            return ListOfPostsPage_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Posts(self): return self.Posts
    def set_Posts(self, Posts): self.Posts = Posts
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.Posts is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Posts':
            obj_ = ListOfPosts_20.factory()
            obj_.build(child_)
            self.Posts = obj_
            obj_.original_tagname_ = 'Posts'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class ListOfPostsPage_20


class ListOfPosts_20(GeneratedsSuper):
    member_data_items_ = {
        'Post': MemberSpec_('Post', 'Post_20', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Post=None):
        self.original_tagname_ = None
        if Post is None:
            self.Post = []
        else:
            self.Post = Post
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfPosts_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfPosts_20.subclass:
            return ListOfPosts_20.subclass(*args_, **kwargs_)
        else:
            return ListOfPosts_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Post(self): return self.Post
    def set_Post(self, Post): self.Post = Post
    def add_Post(self, value): self.Post.append(value)
    def insert_Post_at(self, index, value): self.Post.insert(index, value)
    def replace_Post_at(self, index, value): self.Post[index] = value
    def hasContent_(self):
        if (
            self.Post
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Post':
            class_obj_ = self.get_class_obj_(child_, Post_20)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Post.append(obj_)
            obj_.original_tagname_ = 'Post'
# end class ListOfPosts_20


class PostPreview_20(GeneratedsSuper):
    member_data_items_ = {
        'Files': MemberSpec_('Files', 'ListOfFiles_14', 0),
        'BodyHtml': MemberSpec_('BodyHtml', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Files=None, BodyHtml=None):
        self.original_tagname_ = None
        self.Files = Files
        self.BodyHtml = BodyHtml
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PostPreview_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PostPreview_20.subclass:
            return PostPreview_20.subclass(*args_, **kwargs_)
        else:
            return PostPreview_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Files(self): return self.Files
    def set_Files(self, Files): self.Files = Files
    def get_BodyHtml(self): return self.BodyHtml
    def set_BodyHtml(self, BodyHtml): self.BodyHtml = BodyHtml
    def hasContent_(self):
        if (
            self.Files is not None or
            self.BodyHtml is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Files':
            obj_ = ListOfFiles_14.factory()
            obj_.build(child_)
            self.Files = obj_
            obj_.original_tagname_ = 'Files'
        elif nodeName_ == 'BodyHtml':
            BodyHtml_ = child_.text
            BodyHtml_ = self.gds_validate_string(BodyHtml_, node, 'BodyHtml')
            self.BodyHtml = BodyHtml_
# end class PostPreview_20


class PostPinnedToList_22(GeneratedsSuper):
    member_data_items_ = {
        'BoardList': MemberSpec_('BoardList', 'ListOfBoards_22', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, BoardList=None):
        self.original_tagname_ = None
        self.BoardList = BoardList
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PostPinnedToList_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PostPinnedToList_22.subclass:
            return PostPinnedToList_22.subclass(*args_, **kwargs_)
        else:
            return PostPinnedToList_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_BoardList(self): return self.BoardList
    def set_BoardList(self, BoardList): self.BoardList = BoardList
    def hasContent_(self):
        if (
            self.BoardList is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'BoardList':
            obj_ = ListOfBoards_22.factory()
            obj_.build(child_)
            self.BoardList = obj_
            obj_.original_tagname_ = 'BoardList'
# end class PostPinnedToList_22


class PostPinnedToList_21(GeneratedsSuper):
    member_data_items_ = {
        'BoardList': MemberSpec_('BoardList', 'ListOfBoards_21', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, BoardList=None):
        self.original_tagname_ = None
        self.BoardList = BoardList
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PostPinnedToList_21)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PostPinnedToList_21.subclass:
            return PostPinnedToList_21.subclass(*args_, **kwargs_)
        else:
            return PostPinnedToList_21(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_BoardList(self): return self.BoardList
    def set_BoardList(self, BoardList): self.BoardList = BoardList
    def hasContent_(self):
        if (
            self.BoardList is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'BoardList':
            obj_ = ListOfBoards_21.factory()
            obj_.build(child_)
            self.BoardList = obj_
            obj_.original_tagname_ = 'BoardList'
# end class PostPinnedToList_21


class PostPinnedToList_20(GeneratedsSuper):
    member_data_items_ = {
        'BoardList': MemberSpec_('BoardList', 'ListOfBoards_20', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, BoardList=None):
        self.original_tagname_ = None
        self.BoardList = BoardList
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PostPinnedToList_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PostPinnedToList_20.subclass:
            return PostPinnedToList_20.subclass(*args_, **kwargs_)
        else:
            return PostPinnedToList_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_BoardList(self): return self.BoardList
    def set_BoardList(self, BoardList): self.BoardList = BoardList
    def hasContent_(self):
        if (
            self.BoardList is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'BoardList':
            obj_ = ListOfBoards_20.factory()
            obj_.build(child_)
            self.BoardList = obj_
            obj_.original_tagname_ = 'BoardList'
# end class PostPinnedToList_20


class PostBoardLink_22(GeneratedsSuper):
    member_data_items_ = {
        'BoardId': MemberSpec_('BoardId', 'string', 0),
        'Action': MemberSpec_('Action', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, BoardId=None, Action=None):
        self.original_tagname_ = None
        self.BoardId = BoardId
        self.Action = Action
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PostBoardLink_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PostBoardLink_22.subclass:
            return PostBoardLink_22.subclass(*args_, **kwargs_)
        else:
            return PostBoardLink_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_BoardId(self): return self.BoardId
    def set_BoardId(self, BoardId): self.BoardId = BoardId
    def get_Action(self): return self.Action
    def set_Action(self, Action): self.Action = Action
    def hasContent_(self):
        if (
            self.BoardId is not None or
            self.Action is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'BoardId':
            BoardId_ = child_.text
            BoardId_ = self.gds_validate_string(BoardId_, node, 'BoardId')
            self.BoardId = BoardId_
        elif nodeName_ == 'Action':
            Action_ = child_.text
            Action_ = self.gds_validate_string(Action_, node, 'Action')
            self.Action = Action_
# end class PostBoardLink_22


class Invite_20(GeneratedsSuper):
    member_data_items_ = {
        'InviteUrl': MemberSpec_('InviteUrl', 'string', 0),
        'InviteBody': MemberSpec_('InviteBody', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, InviteUrl=None, InviteBody=None):
        self.original_tagname_ = None
        self.InviteUrl = InviteUrl
        self.InviteBody = InviteBody
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Invite_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Invite_20.subclass:
            return Invite_20.subclass(*args_, **kwargs_)
        else:
            return Invite_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_InviteUrl(self): return self.InviteUrl
    def set_InviteUrl(self, InviteUrl): self.InviteUrl = InviteUrl
    def get_InviteBody(self): return self.InviteBody
    def set_InviteBody(self, InviteBody): self.InviteBody = InviteBody
    def hasContent_(self):
        if (
            self.InviteUrl is not None or
            self.InviteBody is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'InviteUrl':
            InviteUrl_ = child_.text
            InviteUrl_ = self.gds_validate_string(InviteUrl_, node, 'InviteUrl')
            self.InviteUrl = InviteUrl_
        elif nodeName_ == 'InviteBody':
            InviteBody_ = child_.text
            InviteBody_ = self.gds_validate_string(InviteBody_, node, 'InviteBody')
            self.InviteBody = InviteBody_
# end class Invite_20


class ListOfSignatures_20(GeneratedsSuper):
    member_data_items_ = {
        'Signature': MemberSpec_('Signature', 'Signature_20', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Signature=None):
        self.original_tagname_ = None
        if Signature is None:
            self.Signature = []
        else:
            self.Signature = Signature
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfSignatures_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfSignatures_20.subclass:
            return ListOfSignatures_20.subclass(*args_, **kwargs_)
        else:
            return ListOfSignatures_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Signature(self): return self.Signature
    def set_Signature(self, Signature): self.Signature = Signature
    def add_Signature(self, value): self.Signature.append(value)
    def insert_Signature_at(self, index, value): self.Signature.insert(index, value)
    def replace_Signature_at(self, index, value): self.Signature[index] = value
    def hasContent_(self):
        if (
            self.Signature
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Signature':
            obj_ = Signature_20.factory()
            obj_.build(child_)
            self.Signature.append(obj_)
            obj_.original_tagname_ = 'Signature'
# end class ListOfSignatures_20


class ListOfSignaturesPage_20(GeneratedsSuper):
    member_data_items_ = {
        'Default': MemberSpec_('Default', 'Signature_20', 0),
        'ListOfSignatures': MemberSpec_('ListOfSignatures', 'ListOfSignatures_20', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Default=None, ListOfSignatures=None, Paging=None):
        self.original_tagname_ = None
        self.Default = Default
        self.ListOfSignatures = ListOfSignatures
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfSignaturesPage_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfSignaturesPage_20.subclass:
            return ListOfSignaturesPage_20.subclass(*args_, **kwargs_)
        else:
            return ListOfSignaturesPage_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Default(self): return self.Default
    def set_Default(self, Default): self.Default = Default
    def get_ListOfSignatures(self): return self.ListOfSignatures
    def set_ListOfSignatures(self, ListOfSignatures): self.ListOfSignatures = ListOfSignatures
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.Default is not None or
            self.ListOfSignatures is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Default':
            obj_ = Signature_20.factory()
            obj_.build(child_)
            self.Default = obj_
            obj_.original_tagname_ = 'Default'
        elif nodeName_ == 'ListOfSignatures':
            obj_ = ListOfSignatures_20.factory()
            obj_.build(child_)
            self.ListOfSignatures = obj_
            obj_.original_tagname_ = 'ListOfSignatures'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class ListOfSignaturesPage_20


class AssistantInsight_22(GeneratedsSuper):
    member_data_items_ = {
        'Insight': MemberSpec_('Insight', 'string', 0),
        'Snippet': MemberSpec_('Snippet', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Insight=None, Snippet=None):
        self.original_tagname_ = None
        self.Insight = Insight
        self.Snippet = Snippet
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AssistantInsight_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AssistantInsight_22.subclass:
            return AssistantInsight_22.subclass(*args_, **kwargs_)
        else:
            return AssistantInsight_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Insight(self): return self.Insight
    def set_Insight(self, Insight): self.Insight = Insight
    def get_Snippet(self): return self.Snippet
    def set_Snippet(self, Snippet): self.Snippet = Snippet
    def hasContent_(self):
        if (
            self.Insight is not None or
            self.Snippet is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Insight':
            Insight_ = child_.text
            Insight_ = self.gds_validate_string(Insight_, node, 'Insight')
            self.Insight = Insight_
        elif nodeName_ == 'Snippet':
            Snippet_ = child_.text
            Snippet_ = self.gds_validate_string(Snippet_, node, 'Snippet')
            self.Snippet = Snippet_
# end class AssistantInsight_22


class ListOfAgendaPage_22(GeneratedsSuper):
    member_data_items_ = {
        'AgendaList': MemberSpec_('AgendaList', 'ListOfAgendaItems_22', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, AgendaList=None, Paging=None):
        self.original_tagname_ = None
        self.AgendaList = AgendaList
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfAgendaPage_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfAgendaPage_22.subclass:
            return ListOfAgendaPage_22.subclass(*args_, **kwargs_)
        else:
            return ListOfAgendaPage_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_AgendaList(self): return self.AgendaList
    def set_AgendaList(self, AgendaList): self.AgendaList = AgendaList
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.AgendaList is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'AgendaList':
            obj_ = ListOfAgendaItems_22.factory()
            obj_.build(child_)
            self.AgendaList = obj_
            obj_.original_tagname_ = 'AgendaList'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class ListOfAgendaPage_22


class AgendaItem_22(GeneratedsSuper):
    member_data_items_ = {
        'DueDate': MemberSpec_('DueDate', 'dateTime', 0),
        'AgendaItem': MemberSpec_('AgendaItem', 'ResourceBase_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, DueDate=None, AgendaItem=None):
        self.original_tagname_ = None
        if isinstance(DueDate, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(DueDate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = DueDate
        self.DueDate = initvalue_
        self.AgendaItem = AgendaItem
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AgendaItem_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AgendaItem_22.subclass:
            return AgendaItem_22.subclass(*args_, **kwargs_)
        else:
            return AgendaItem_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_DueDate(self): return self.DueDate
    def set_DueDate(self, DueDate): self.DueDate = DueDate
    def get_AgendaItem(self): return self.AgendaItem
    def set_AgendaItem(self, AgendaItem): self.AgendaItem = AgendaItem
    def hasContent_(self):
        if (
            self.DueDate is not None or
            self.AgendaItem is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'DueDate':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.DueDate = dval_
        elif nodeName_ == 'AgendaItem':
            class_obj_ = self.get_class_obj_(child_, ResourceBase_13)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.AgendaItem = obj_
            obj_.original_tagname_ = 'AgendaItem'
# end class AgendaItem_22


class ListOfAgendaItems_22(GeneratedsSuper):
    member_data_items_ = {
        'Resource': MemberSpec_('Resource', 'AgendaItem_22', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Resource=None):
        self.original_tagname_ = None
        if Resource is None:
            self.Resource = []
        else:
            self.Resource = Resource
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfAgendaItems_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfAgendaItems_22.subclass:
            return ListOfAgendaItems_22.subclass(*args_, **kwargs_)
        else:
            return ListOfAgendaItems_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Resource(self): return self.Resource
    def set_Resource(self, Resource): self.Resource = Resource
    def add_Resource(self, value): self.Resource.append(value)
    def insert_Resource_at(self, index, value): self.Resource.insert(index, value)
    def replace_Resource_at(self, index, value): self.Resource[index] = value
    def hasContent_(self):
        if (
            self.Resource
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Resource':
            obj_ = AgendaItem_22.factory()
            obj_.build(child_)
            self.Resource.append(obj_)
            obj_.original_tagname_ = 'Resource'
# end class ListOfAgendaItems_22


class AgendaSummary_22(GeneratedsSuper):
    member_data_items_ = {
        'ListOfFirstItems': MemberSpec_('ListOfFirstItems', 'ListOfAgendaItems_22', 0),
        'ListOfUpcomingItems': MemberSpec_('ListOfUpcomingItems', 'ListOfAgendaItems_22', 0),
        'PreviousItem': MemberSpec_('PreviousItem', 'AgendaItem_22', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, ListOfFirstItems=None, ListOfUpcomingItems=None, PreviousItem=None):
        self.original_tagname_ = None
        self.ListOfFirstItems = ListOfFirstItems
        self.ListOfUpcomingItems = ListOfUpcomingItems
        self.PreviousItem = PreviousItem
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AgendaSummary_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AgendaSummary_22.subclass:
            return AgendaSummary_22.subclass(*args_, **kwargs_)
        else:
            return AgendaSummary_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ListOfFirstItems(self): return self.ListOfFirstItems
    def set_ListOfFirstItems(self, ListOfFirstItems): self.ListOfFirstItems = ListOfFirstItems
    def get_ListOfUpcomingItems(self): return self.ListOfUpcomingItems
    def set_ListOfUpcomingItems(self, ListOfUpcomingItems): self.ListOfUpcomingItems = ListOfUpcomingItems
    def get_PreviousItem(self): return self.PreviousItem
    def set_PreviousItem(self, PreviousItem): self.PreviousItem = PreviousItem
    def hasContent_(self):
        if (
            self.ListOfFirstItems is not None or
            self.ListOfUpcomingItems is not None or
            self.PreviousItem is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ListOfFirstItems':
            obj_ = ListOfAgendaItems_22.factory()
            obj_.build(child_)
            self.ListOfFirstItems = obj_
            obj_.original_tagname_ = 'ListOfFirstItems'
        elif nodeName_ == 'ListOfUpcomingItems':
            obj_ = ListOfAgendaItems_22.factory()
            obj_.build(child_)
            self.ListOfUpcomingItems = obj_
            obj_.original_tagname_ = 'ListOfUpcomingItems'
        elif nodeName_ == 'PreviousItem':
            obj_ = AgendaItem_22.factory()
            obj_.build(child_)
            self.PreviousItem = obj_
            obj_.original_tagname_ = 'PreviousItem'
# end class AgendaSummary_22


class AppointmentListPage_20(GeneratedsSuper):
    member_data_items_ = {
        'AppointmentList': MemberSpec_('AppointmentList', 'ListOfAppointment_20', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, AppointmentList=None, Paging=None):
        self.original_tagname_ = None
        self.AppointmentList = AppointmentList
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AppointmentListPage_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AppointmentListPage_20.subclass:
            return AppointmentListPage_20.subclass(*args_, **kwargs_)
        else:
            return AppointmentListPage_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_AppointmentList(self): return self.AppointmentList
    def set_AppointmentList(self, AppointmentList): self.AppointmentList = AppointmentList
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.AppointmentList is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'AppointmentList':
            obj_ = ListOfAppointment_20.factory()
            obj_.build(child_)
            self.AppointmentList = obj_
            obj_.original_tagname_ = 'AppointmentList'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class AppointmentListPage_20


class ListOfAppointment_20(GeneratedsSuper):
    member_data_items_ = {
        'Appointment': MemberSpec_('Appointment', 'Appointment_20', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Appointment=None):
        self.original_tagname_ = None
        if Appointment is None:
            self.Appointment = []
        else:
            self.Appointment = Appointment
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfAppointment_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfAppointment_20.subclass:
            return ListOfAppointment_20.subclass(*args_, **kwargs_)
        else:
            return ListOfAppointment_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Appointment(self): return self.Appointment
    def set_Appointment(self, Appointment): self.Appointment = Appointment
    def add_Appointment(self, value): self.Appointment.append(value)
    def insert_Appointment_at(self, index, value): self.Appointment.insert(index, value)
    def replace_Appointment_at(self, index, value): self.Appointment[index] = value
    def hasContent_(self):
        if (
            self.Appointment
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Appointment':
            obj_ = Appointment_20.factory()
            obj_.build(child_)
            self.Appointment.append(obj_)
            obj_.original_tagname_ = 'Appointment'
# end class ListOfAppointment_20


class AppointmentResponse_20(GeneratedsSuper):
    member_data_items_ = {
        'CalendarUId': MemberSpec_('CalendarUId', 'string', 0),
        'PostId': MemberSpec_('PostId', 'string', 0),
        'Status': MemberSpec_('Status', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, CalendarUId=None, PostId=None, Status=None):
        self.original_tagname_ = None
        self.CalendarUId = CalendarUId
        self.PostId = PostId
        self.Status = Status
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AppointmentResponse_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AppointmentResponse_20.subclass:
            return AppointmentResponse_20.subclass(*args_, **kwargs_)
        else:
            return AppointmentResponse_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_CalendarUId(self): return self.CalendarUId
    def set_CalendarUId(self, CalendarUId): self.CalendarUId = CalendarUId
    def get_PostId(self): return self.PostId
    def set_PostId(self, PostId): self.PostId = PostId
    def get_Status(self): return self.Status
    def set_Status(self, Status): self.Status = Status
    def hasContent_(self):
        if (
            self.CalendarUId is not None or
            self.PostId is not None or
            self.Status is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'CalendarUId':
            CalendarUId_ = child_.text
            CalendarUId_ = self.gds_validate_string(CalendarUId_, node, 'CalendarUId')
            self.CalendarUId = CalendarUId_
        elif nodeName_ == 'PostId':
            PostId_ = child_.text
            PostId_ = self.gds_validate_string(PostId_, node, 'PostId')
            self.PostId = PostId_
        elif nodeName_ == 'Status':
            Status_ = child_.text
            Status_ = self.gds_validate_string(Status_, node, 'Status')
            self.Status = Status_
# end class AppointmentResponse_20


class ListOfAttendees_20(GeneratedsSuper):
    member_data_items_ = {
        'Resource': MemberSpec_('Resource', 'Attendee_20', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Resource=None):
        self.original_tagname_ = None
        if Resource is None:
            self.Resource = []
        else:
            self.Resource = Resource
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfAttendees_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfAttendees_20.subclass:
            return ListOfAttendees_20.subclass(*args_, **kwargs_)
        else:
            return ListOfAttendees_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Resource(self): return self.Resource
    def set_Resource(self, Resource): self.Resource = Resource
    def add_Resource(self, value): self.Resource.append(value)
    def insert_Resource_at(self, index, value): self.Resource.insert(index, value)
    def replace_Resource_at(self, index, value): self.Resource[index] = value
    def hasContent_(self):
        if (
            self.Resource
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Resource':
            obj_ = Attendee_20.factory()
            obj_.build(child_)
            self.Resource.append(obj_)
            obj_.original_tagname_ = 'Resource'
# end class ListOfAttendees_20


class AppointmentTime_20(GeneratedsSuper):
    member_data_items_ = {
        'StartTime': MemberSpec_('StartTime', 'dateTime', 0),
        'EndTime': MemberSpec_('EndTime', 'dateTime', 0),
        'IsAllDay': MemberSpec_('IsAllDay', 'boolean', 0),
        'Timezone': MemberSpec_('Timezone', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, StartTime=None, EndTime=None, IsAllDay=None, Timezone=None):
        self.original_tagname_ = None
        if isinstance(StartTime, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(StartTime, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = StartTime
        self.StartTime = initvalue_
        if isinstance(EndTime, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(EndTime, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = EndTime
        self.EndTime = initvalue_
        self.IsAllDay = IsAllDay
        self.Timezone = Timezone
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AppointmentTime_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AppointmentTime_20.subclass:
            return AppointmentTime_20.subclass(*args_, **kwargs_)
        else:
            return AppointmentTime_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_StartTime(self): return self.StartTime
    def set_StartTime(self, StartTime): self.StartTime = StartTime
    def get_EndTime(self): return self.EndTime
    def set_EndTime(self, EndTime): self.EndTime = EndTime
    def get_IsAllDay(self): return self.IsAllDay
    def set_IsAllDay(self, IsAllDay): self.IsAllDay = IsAllDay
    def get_Timezone(self): return self.Timezone
    def set_Timezone(self, Timezone): self.Timezone = Timezone
    def hasContent_(self):
        if (
            self.StartTime is not None or
            self.EndTime is not None or
            self.IsAllDay is not None or
            self.Timezone is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'StartTime':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.StartTime = dval_
        elif nodeName_ == 'EndTime':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.EndTime = dval_
        elif nodeName_ == 'IsAllDay':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsAllDay')
            self.IsAllDay = ival_
        elif nodeName_ == 'Timezone':
            Timezone_ = child_.text
            Timezone_ = self.gds_validate_string(Timezone_, node, 'Timezone')
            self.Timezone = Timezone_
# end class AppointmentTime_20


class ListOfAppointmentReminders_20(GeneratedsSuper):
    member_data_items_ = {
        'AppointmentReminder': MemberSpec_('AppointmentReminder', 'AppointmentReminder_20', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, AppointmentReminder=None):
        self.original_tagname_ = None
        if AppointmentReminder is None:
            self.AppointmentReminder = []
        else:
            self.AppointmentReminder = AppointmentReminder
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfAppointmentReminders_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfAppointmentReminders_20.subclass:
            return ListOfAppointmentReminders_20.subclass(*args_, **kwargs_)
        else:
            return ListOfAppointmentReminders_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_AppointmentReminder(self): return self.AppointmentReminder
    def set_AppointmentReminder(self, AppointmentReminder): self.AppointmentReminder = AppointmentReminder
    def add_AppointmentReminder(self, value): self.AppointmentReminder.append(value)
    def insert_AppointmentReminder_at(self, index, value): self.AppointmentReminder.insert(index, value)
    def replace_AppointmentReminder_at(self, index, value): self.AppointmentReminder[index] = value
    def hasContent_(self):
        if (
            self.AppointmentReminder
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'AppointmentReminder':
            obj_ = AppointmentReminder_20.factory()
            obj_.build(child_)
            self.AppointmentReminder.append(obj_)
            obj_.original_tagname_ = 'AppointmentReminder'
# end class ListOfAppointmentReminders_20


class AppointmentReminder_20(GeneratedsSuper):
    member_data_items_ = {
        'MinutesReminder': MemberSpec_('MinutesReminder', 'int', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, MinutesReminder=None):
        self.original_tagname_ = None
        self.MinutesReminder = MinutesReminder
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AppointmentReminder_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AppointmentReminder_20.subclass:
            return AppointmentReminder_20.subclass(*args_, **kwargs_)
        else:
            return AppointmentReminder_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_MinutesReminder(self): return self.MinutesReminder
    def set_MinutesReminder(self, MinutesReminder): self.MinutesReminder = MinutesReminder
    def hasContent_(self):
        if (
            self.MinutesReminder is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'MinutesReminder':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'MinutesReminder')
            self.MinutesReminder = ival_
# end class AppointmentReminder_20


class ListOfAppointmentRecurrence_20(GeneratedsSuper):
    member_data_items_ = {
        'AppointmentRecurrence': MemberSpec_('AppointmentRecurrence', 'AppointmentRecurrence_20', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, AppointmentRecurrence=None):
        self.original_tagname_ = None
        if AppointmentRecurrence is None:
            self.AppointmentRecurrence = []
        else:
            self.AppointmentRecurrence = AppointmentRecurrence
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfAppointmentRecurrence_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfAppointmentRecurrence_20.subclass:
            return ListOfAppointmentRecurrence_20.subclass(*args_, **kwargs_)
        else:
            return ListOfAppointmentRecurrence_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_AppointmentRecurrence(self): return self.AppointmentRecurrence
    def set_AppointmentRecurrence(self, AppointmentRecurrence): self.AppointmentRecurrence = AppointmentRecurrence
    def add_AppointmentRecurrence(self, value): self.AppointmentRecurrence.append(value)
    def insert_AppointmentRecurrence_at(self, index, value): self.AppointmentRecurrence.insert(index, value)
    def replace_AppointmentRecurrence_at(self, index, value): self.AppointmentRecurrence[index] = value
    def hasContent_(self):
        if (
            self.AppointmentRecurrence
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'AppointmentRecurrence':
            obj_ = AppointmentRecurrence_20.factory()
            obj_.build(child_)
            self.AppointmentRecurrence.append(obj_)
            obj_.original_tagname_ = 'AppointmentRecurrence'
# end class ListOfAppointmentRecurrence_20


class AppointmentRecurrence_20(GeneratedsSuper):
    member_data_items_ = {
        'RecurrenceInterval': MemberSpec_('RecurrenceInterval', 'int', 0),
        'RecurrenceType': MemberSpec_('RecurrenceType', 'string', 0),
        'RecurrenceStopTime': MemberSpec_('RecurrenceStopTime', 'dateTime', 0),
        'RecurrenceDayOfWeek': MemberSpec_('RecurrenceDayOfWeek', 'string', 0),
        'RecurrenceDayOfMonth': MemberSpec_('RecurrenceDayOfMonth', 'int', 0),
        'RecurrenceMonth': MemberSpec_('RecurrenceMonth', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, RecurrenceInterval=None, RecurrenceType=None, RecurrenceStopTime=None, RecurrenceDayOfWeek=None, RecurrenceDayOfMonth=None, RecurrenceMonth=None):
        self.original_tagname_ = None
        self.RecurrenceInterval = RecurrenceInterval
        self.RecurrenceType = RecurrenceType
        if isinstance(RecurrenceStopTime, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(RecurrenceStopTime, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = RecurrenceStopTime
        self.RecurrenceStopTime = initvalue_
        self.RecurrenceDayOfWeek = RecurrenceDayOfWeek
        self.RecurrenceDayOfMonth = RecurrenceDayOfMonth
        self.RecurrenceMonth = RecurrenceMonth
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AppointmentRecurrence_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AppointmentRecurrence_20.subclass:
            return AppointmentRecurrence_20.subclass(*args_, **kwargs_)
        else:
            return AppointmentRecurrence_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_RecurrenceInterval(self): return self.RecurrenceInterval
    def set_RecurrenceInterval(self, RecurrenceInterval): self.RecurrenceInterval = RecurrenceInterval
    def get_RecurrenceType(self): return self.RecurrenceType
    def set_RecurrenceType(self, RecurrenceType): self.RecurrenceType = RecurrenceType
    def get_RecurrenceStopTime(self): return self.RecurrenceStopTime
    def set_RecurrenceStopTime(self, RecurrenceStopTime): self.RecurrenceStopTime = RecurrenceStopTime
    def get_RecurrenceDayOfWeek(self): return self.RecurrenceDayOfWeek
    def set_RecurrenceDayOfWeek(self, RecurrenceDayOfWeek): self.RecurrenceDayOfWeek = RecurrenceDayOfWeek
    def get_RecurrenceDayOfMonth(self): return self.RecurrenceDayOfMonth
    def set_RecurrenceDayOfMonth(self, RecurrenceDayOfMonth): self.RecurrenceDayOfMonth = RecurrenceDayOfMonth
    def get_RecurrenceMonth(self): return self.RecurrenceMonth
    def set_RecurrenceMonth(self, RecurrenceMonth): self.RecurrenceMonth = RecurrenceMonth
    def hasContent_(self):
        if (
            self.RecurrenceInterval is not None or
            self.RecurrenceType is not None or
            self.RecurrenceStopTime is not None or
            self.RecurrenceDayOfWeek is not None or
            self.RecurrenceDayOfMonth is not None or
            self.RecurrenceMonth is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'RecurrenceInterval':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'RecurrenceInterval')
            self.RecurrenceInterval = ival_
        elif nodeName_ == 'RecurrenceType':
            RecurrenceType_ = child_.text
            RecurrenceType_ = self.gds_validate_string(RecurrenceType_, node, 'RecurrenceType')
            self.RecurrenceType = RecurrenceType_
        elif nodeName_ == 'RecurrenceStopTime':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.RecurrenceStopTime = dval_
        elif nodeName_ == 'RecurrenceDayOfWeek':
            RecurrenceDayOfWeek_ = child_.text
            RecurrenceDayOfWeek_ = self.gds_validate_string(RecurrenceDayOfWeek_, node, 'RecurrenceDayOfWeek')
            self.RecurrenceDayOfWeek = RecurrenceDayOfWeek_
        elif nodeName_ == 'RecurrenceDayOfMonth':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'RecurrenceDayOfMonth')
            self.RecurrenceDayOfMonth = ival_
        elif nodeName_ == 'RecurrenceMonth':
            RecurrenceMonth_ = child_.text
            RecurrenceMonth_ = self.gds_validate_string(RecurrenceMonth_, node, 'RecurrenceMonth')
            self.RecurrenceMonth = RecurrenceMonth_
# end class AppointmentRecurrence_20


class ListOfContactCardItem_22(GeneratedsSuper):
    member_data_items_ = {
        'ContactCardItem': MemberSpec_('ContactCardItem', 'ContactCardItem_22', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, ContactCardItem=None):
        self.original_tagname_ = None
        if ContactCardItem is None:
            self.ContactCardItem = []
        else:
            self.ContactCardItem = ContactCardItem
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfContactCardItem_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfContactCardItem_22.subclass:
            return ListOfContactCardItem_22.subclass(*args_, **kwargs_)
        else:
            return ListOfContactCardItem_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ContactCardItem(self): return self.ContactCardItem
    def set_ContactCardItem(self, ContactCardItem): self.ContactCardItem = ContactCardItem
    def add_ContactCardItem(self, value): self.ContactCardItem.append(value)
    def insert_ContactCardItem_at(self, index, value): self.ContactCardItem.insert(index, value)
    def replace_ContactCardItem_at(self, index, value): self.ContactCardItem[index] = value
    def hasContent_(self):
        if (
            self.ContactCardItem
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ContactCardItem':
            obj_ = ContactCardItem_22.factory()
            obj_.build(child_)
            self.ContactCardItem.append(obj_)
            obj_.original_tagname_ = 'ContactCardItem'
# end class ListOfContactCardItem_22


class ContactCardItem_22(GeneratedsSuper):
    member_data_items_ = {
        'Value': MemberSpec_('Value', 'string', 0),
        'Type': MemberSpec_('Type', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Value=None, Type=None):
        self.original_tagname_ = None
        self.Value = Value
        self.Type = Type
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ContactCardItem_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ContactCardItem_22.subclass:
            return ContactCardItem_22.subclass(*args_, **kwargs_)
        else:
            return ContactCardItem_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def get_Type(self): return self.Type
    def set_Type(self, Type): self.Type = Type
    def hasContent_(self):
        if (
            self.Value is not None or
            self.Type is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Value':
            Value_ = child_.text
            Value_ = self.gds_validate_string(Value_, node, 'Value')
            self.Value = Value_
        elif nodeName_ == 'Type':
            Type_ = child_.text
            Type_ = self.gds_validate_string(Type_, node, 'Type')
            self.Type = Type_
# end class ContactCardItem_22


class BadgeBase_15(GeneratedsSuper):
    member_data_items_ = {
        'Count': MemberSpec_('Count', 'integer', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Count=None):
        self.original_tagname_ = None
        self.Count = Count
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BadgeBase_15)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BadgeBase_15.subclass:
            return BadgeBase_15.subclass(*args_, **kwargs_)
        else:
            return BadgeBase_15(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Count(self): return self.Count
    def set_Count(self, Count): self.Count = Count
    def hasContent_(self):
        if (
            self.Count is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Count':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Count')
            self.Count = ival_
# end class BadgeBase_15


class ActivityChart_13(GeneratedsSuper):
    member_data_items_ = {
        'Start': MemberSpec_('Start', 'dateTime', 0),
        'End': MemberSpec_('End', 'dateTime', 0),
        'ActivityList': MemberSpec_('ActivityList', 'ListOfActivities_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Start=None, End=None, ActivityList=None):
        self.original_tagname_ = None
        if isinstance(Start, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(Start, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = Start
        self.Start = initvalue_
        if isinstance(End, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(End, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = End
        self.End = initvalue_
        self.ActivityList = ActivityList
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ActivityChart_13)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ActivityChart_13.subclass:
            return ActivityChart_13.subclass(*args_, **kwargs_)
        else:
            return ActivityChart_13(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Start(self): return self.Start
    def set_Start(self, Start): self.Start = Start
    def get_End(self): return self.End
    def set_End(self, End): self.End = End
    def get_ActivityList(self): return self.ActivityList
    def set_ActivityList(self, ActivityList): self.ActivityList = ActivityList
    def hasContent_(self):
        if (
            self.Start is not None or
            self.End is not None or
            self.ActivityList is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Start':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.Start = dval_
        elif nodeName_ == 'End':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.End = dval_
        elif nodeName_ == 'ActivityList':
            obj_ = ListOfActivities_13.factory()
            obj_.build(child_)
            self.ActivityList = obj_
            obj_.original_tagname_ = 'ActivityList'
# end class ActivityChart_13


class ListOfActivities_13(GeneratedsSuper):
    member_data_items_ = {
        'Activity': MemberSpec_('Activity', 'ActivityItem_13', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Activity=None):
        self.original_tagname_ = None
        if Activity is None:
            self.Activity = []
        else:
            self.Activity = Activity
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfActivities_13)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfActivities_13.subclass:
            return ListOfActivities_13.subclass(*args_, **kwargs_)
        else:
            return ListOfActivities_13(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Activity(self): return self.Activity
    def set_Activity(self, Activity): self.Activity = Activity
    def add_Activity(self, value): self.Activity.append(value)
    def insert_Activity_at(self, index, value): self.Activity.insert(index, value)
    def replace_Activity_at(self, index, value): self.Activity[index] = value
    def hasContent_(self):
        if (
            self.Activity
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Activity':
            obj_ = ActivityItem_13.factory()
            obj_.build(child_)
            self.Activity.append(obj_)
            obj_.original_tagname_ = 'Activity'
# end class ListOfActivities_13


class ActivityItem_13(GeneratedsSuper):
    member_data_items_ = {
        'Day': MemberSpec_('Day', 'dateTime', 0),
        'Index': MemberSpec_('Index', 'long', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Day=None, Index=None):
        self.original_tagname_ = None
        if isinstance(Day, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(Day, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = Day
        self.Day = initvalue_
        self.Index = Index
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ActivityItem_13)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ActivityItem_13.subclass:
            return ActivityItem_13.subclass(*args_, **kwargs_)
        else:
            return ActivityItem_13(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Day(self): return self.Day
    def set_Day(self, Day): self.Day = Day
    def get_Index(self): return self.Index
    def set_Index(self, Index): self.Index = Index
    def hasContent_(self):
        if (
            self.Day is not None or
            self.Index is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Day':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.Day = dval_
        elif nodeName_ == 'Index':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Index')
            self.Index = ival_
# end class ActivityItem_13


class SelectedSortAction_13(GeneratedsSuper):
    member_data_items_ = {
        'Direction': MemberSpec_('Direction', ['SortDirection', 'string'], 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Direction=None):
        self.original_tagname_ = None
        self.Direction = Direction
        self.validate_SortDirection(self.Direction)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SelectedSortAction_13)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SelectedSortAction_13.subclass:
            return SelectedSortAction_13.subclass(*args_, **kwargs_)
        else:
            return SelectedSortAction_13(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Direction(self): return self.Direction
    def set_Direction(self, Direction): self.Direction = Direction
    def validate_SortDirection(self, value):
        # Validate type SortDirection, a restriction on string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['Ascending', 'Descending']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on SortDirection' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.Direction is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Direction':
            Direction_ = child_.text
            Direction_ = self.gds_validate_string(Direction_, node, 'Direction')
            self.Direction = Direction_
            # validate type SortDirection
            self.validate_SortDirection(self.Direction)
# end class SelectedSortAction_13


class ListOfSortActions_13(GeneratedsSuper):
    member_data_items_ = {
        'SortAction': MemberSpec_('SortAction', 'SortActionBase_13', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, SortAction=None):
        self.original_tagname_ = None
        if SortAction is None:
            self.SortAction = []
        else:
            self.SortAction = SortAction
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfSortActions_13)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfSortActions_13.subclass:
            return ListOfSortActions_13.subclass(*args_, **kwargs_)
        else:
            return ListOfSortActions_13(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_SortAction(self): return self.SortAction
    def set_SortAction(self, SortAction): self.SortAction = SortAction
    def add_SortAction(self, value): self.SortAction.append(value)
    def insert_SortAction_at(self, index, value): self.SortAction.insert(index, value)
    def replace_SortAction_at(self, index, value): self.SortAction[index] = value
    def hasContent_(self):
        if (
            self.SortAction
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'SortAction':
            class_obj_ = self.get_class_obj_(child_, SortActionBase_13)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.SortAction.append(obj_)
            obj_.original_tagname_ = 'SortAction'
# end class ListOfSortActions_13


class SortDirectionHint_13(GeneratedsSuper):
    member_data_items_ = {
        'Ascending': MemberSpec_('Ascending', 'string', 0),
        'Descending': MemberSpec_('Descending', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Ascending=None, Descending=None):
        self.original_tagname_ = None
        self.Ascending = Ascending
        self.Descending = Descending
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SortDirectionHint_13)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SortDirectionHint_13.subclass:
            return SortDirectionHint_13.subclass(*args_, **kwargs_)
        else:
            return SortDirectionHint_13(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Ascending(self): return self.Ascending
    def set_Ascending(self, Ascending): self.Ascending = Ascending
    def get_Descending(self): return self.Descending
    def set_Descending(self, Descending): self.Descending = Descending
    def hasContent_(self):
        if (
            self.Ascending is not None or
            self.Descending is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Ascending':
            Ascending_ = child_.text
            Ascending_ = self.gds_validate_string(Ascending_, node, 'Ascending')
            self.Ascending = Ascending_
        elif nodeName_ == 'Descending':
            Descending_ = child_.text
            Descending_ = self.gds_validate_string(Descending_, node, 'Descending')
            self.Descending = Descending_
# end class SortDirectionHint_13


class Drive_14(GeneratedsSuper):
    member_data_items_ = {
        'DriveItemGroupList': MemberSpec_('DriveItemGroupList', 'ListOfDriveItemGroups_14', 0),
        'AvailableSortActionList': MemberSpec_('AvailableSortActionList', 'ListOfSortActions_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, DriveItemGroupList=None, AvailableSortActionList=None):
        self.original_tagname_ = None
        self.DriveItemGroupList = DriveItemGroupList
        self.AvailableSortActionList = AvailableSortActionList
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Drive_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Drive_14.subclass:
            return Drive_14.subclass(*args_, **kwargs_)
        else:
            return Drive_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_DriveItemGroupList(self): return self.DriveItemGroupList
    def set_DriveItemGroupList(self, DriveItemGroupList): self.DriveItemGroupList = DriveItemGroupList
    def get_AvailableSortActionList(self): return self.AvailableSortActionList
    def set_AvailableSortActionList(self, AvailableSortActionList): self.AvailableSortActionList = AvailableSortActionList
    def hasContent_(self):
        if (
            self.DriveItemGroupList is not None or
            self.AvailableSortActionList is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'DriveItemGroupList':
            obj_ = ListOfDriveItemGroups_14.factory()
            obj_.build(child_)
            self.DriveItemGroupList = obj_
            obj_.original_tagname_ = 'DriveItemGroupList'
        elif nodeName_ == 'AvailableSortActionList':
            obj_ = ListOfSortActions_13.factory()
            obj_.build(child_)
            self.AvailableSortActionList = obj_
            obj_.original_tagname_ = 'AvailableSortActionList'
# end class Drive_14


class DriveItemGroupBase_14(GeneratedsSuper):
    member_data_items_ = {
        'Id': MemberSpec_('Id', 'string', 0),
        'Name': MemberSpec_('Name', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Id=None, Name=None):
        self.original_tagname_ = None
        self.Id = Id
        self.Name = Name
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DriveItemGroupBase_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DriveItemGroupBase_14.subclass:
            return DriveItemGroupBase_14.subclass(*args_, **kwargs_)
        else:
            return DriveItemGroupBase_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Id(self): return self.Id
    def set_Id(self, Id): self.Id = Id
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def hasContent_(self):
        if (
            self.Id is not None or
            self.Name is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Id':
            Id_ = child_.text
            Id_ = self.gds_validate_string(Id_, node, 'Id')
            self.Id = Id_
        elif nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
# end class DriveItemGroupBase_14


class ListOfDriveItemGroups_14(GeneratedsSuper):
    member_data_items_ = {
        'DriveItemGroup': MemberSpec_('DriveItemGroup', 'DriveItemGroupBase_14', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, DriveItemGroup=None):
        self.original_tagname_ = None
        if DriveItemGroup is None:
            self.DriveItemGroup = []
        else:
            self.DriveItemGroup = DriveItemGroup
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfDriveItemGroups_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfDriveItemGroups_14.subclass:
            return ListOfDriveItemGroups_14.subclass(*args_, **kwargs_)
        else:
            return ListOfDriveItemGroups_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_DriveItemGroup(self): return self.DriveItemGroup
    def set_DriveItemGroup(self, DriveItemGroup): self.DriveItemGroup = DriveItemGroup
    def add_DriveItemGroup(self, value): self.DriveItemGroup.append(value)
    def insert_DriveItemGroup_at(self, index, value): self.DriveItemGroup.insert(index, value)
    def replace_DriveItemGroup_at(self, index, value): self.DriveItemGroup[index] = value
    def hasContent_(self):
        if (
            self.DriveItemGroup
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'DriveItemGroup':
            class_obj_ = self.get_class_obj_(child_, DriveItemGroupBase_14)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.DriveItemGroup.append(obj_)
            obj_.original_tagname_ = 'DriveItemGroup'
# end class ListOfDriveItemGroups_14


class DriveItemGroupDocuments_14(DriveItemGroupBase_14):
    member_data_items_ = {
        'DocumentListPage': MemberSpec_('DocumentListPage', 'ListOfDocumentsPage_14', 0),
    }
    subclass = None
    superclass = DriveItemGroupBase_14
    def __init__(self, DocumentListPage=None):
        self.original_tagname_ = None
        super(DriveItemGroupDocuments_14, self).__init__()
        self.DocumentListPage = DocumentListPage
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DriveItemGroupDocuments_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DriveItemGroupDocuments_14.subclass:
            return DriveItemGroupDocuments_14.subclass(*args_, **kwargs_)
        else:
            return DriveItemGroupDocuments_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_DocumentListPage(self): return self.DocumentListPage
    def set_DocumentListPage(self, DocumentListPage): self.DocumentListPage = DocumentListPage
    def hasContent_(self):
        if (
            self.DocumentListPage is not None or
            super(DriveItemGroupDocuments_14, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(DriveItemGroupDocuments_14, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'DocumentListPage':
            obj_ = ListOfDocumentsPage_14.factory()
            obj_.build(child_)
            self.DocumentListPage = obj_
            obj_.original_tagname_ = 'DocumentListPage'
        super(DriveItemGroupDocuments_14, self).buildChildren(child_, node, nodeName_, True)
# end class DriveItemGroupDocuments_14


class ClientEventLog_15(GeneratedsSuper):
    member_data_items_ = {
        'Application': MemberSpec_('Application', 'string', 0),
        'Action': MemberSpec_('Action', 'string', 0),
        'Created': MemberSpec_('Created', 'dateTime', 0),
        'ParameterList': MemberSpec_('ParameterList', 'ListOfParameters_15', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Application=None, Action=None, Created=None, ParameterList=None):
        self.original_tagname_ = None
        self.Application = Application
        self.Action = Action
        if isinstance(Created, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(Created, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = Created
        self.Created = initvalue_
        self.ParameterList = ParameterList
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ClientEventLog_15)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ClientEventLog_15.subclass:
            return ClientEventLog_15.subclass(*args_, **kwargs_)
        else:
            return ClientEventLog_15(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Application(self): return self.Application
    def set_Application(self, Application): self.Application = Application
    def get_Action(self): return self.Action
    def set_Action(self, Action): self.Action = Action
    def get_Created(self): return self.Created
    def set_Created(self, Created): self.Created = Created
    def get_ParameterList(self): return self.ParameterList
    def set_ParameterList(self, ParameterList): self.ParameterList = ParameterList
    def hasContent_(self):
        if (
            self.Application is not None or
            self.Action is not None or
            self.Created is not None or
            self.ParameterList is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Application':
            Application_ = child_.text
            Application_ = self.gds_validate_string(Application_, node, 'Application')
            self.Application = Application_
        elif nodeName_ == 'Action':
            Action_ = child_.text
            Action_ = self.gds_validate_string(Action_, node, 'Action')
            self.Action = Action_
        elif nodeName_ == 'Created':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.Created = dval_
        elif nodeName_ == 'ParameterList':
            obj_ = ListOfParameters_15.factory()
            obj_.build(child_)
            self.ParameterList = obj_
            obj_.original_tagname_ = 'ParameterList'
# end class ClientEventLog_15


class ClientOnboardingEventLog_15(ClientEventLog_15):
    member_data_items_ = {
    }
    subclass = None
    superclass = ClientEventLog_15
    def __init__(self):
        self.original_tagname_ = None
        super(ClientOnboardingEventLog_15, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ClientOnboardingEventLog_15)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ClientOnboardingEventLog_15.subclass:
            return ClientOnboardingEventLog_15.subclass(*args_, **kwargs_)
        else:
            return ClientOnboardingEventLog_15(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(ClientOnboardingEventLog_15, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ClientOnboardingEventLog_15, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ClientOnboardingEventLog_15, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ClientOnboardingEventLog_15


class ClientStatisticEventLog_15(ClientEventLog_15):
    member_data_items_ = {
    }
    subclass = None
    superclass = ClientEventLog_15
    def __init__(self):
        self.original_tagname_ = None
        super(ClientStatisticEventLog_15, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ClientStatisticEventLog_15)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ClientStatisticEventLog_15.subclass:
            return ClientStatisticEventLog_15.subclass(*args_, **kwargs_)
        else:
            return ClientStatisticEventLog_15(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(ClientStatisticEventLog_15, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ClientStatisticEventLog_15, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ClientStatisticEventLog_15, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ClientStatisticEventLog_15


class Parameter_15(GeneratedsSuper):
    member_data_items_ = {
        'Name': MemberSpec_('Name', 'string', 0),
        'Value': MemberSpec_('Value', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Name=None, Value=None):
        self.original_tagname_ = None
        self.Name = Name
        self.Value = Value
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Parameter_15)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Parameter_15.subclass:
            return Parameter_15.subclass(*args_, **kwargs_)
        else:
            return Parameter_15(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Value is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Value':
            Value_ = child_.text
            Value_ = self.gds_validate_string(Value_, node, 'Value')
            self.Value = Value_
# end class Parameter_15


class ListOfParameters_15(GeneratedsSuper):
    member_data_items_ = {
        'Parameter': MemberSpec_('Parameter', 'Parameter_15', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Parameter=None):
        self.original_tagname_ = None
        if Parameter is None:
            self.Parameter = []
        else:
            self.Parameter = Parameter
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfParameters_15)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfParameters_15.subclass:
            return ListOfParameters_15.subclass(*args_, **kwargs_)
        else:
            return ListOfParameters_15(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Parameter(self): return self.Parameter
    def set_Parameter(self, Parameter): self.Parameter = Parameter
    def add_Parameter(self, value): self.Parameter.append(value)
    def insert_Parameter_at(self, index, value): self.Parameter.insert(index, value)
    def replace_Parameter_at(self, index, value): self.Parameter[index] = value
    def hasContent_(self):
        if (
            self.Parameter
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Parameter':
            obj_ = Parameter_15.factory()
            obj_.build(child_)
            self.Parameter.append(obj_)
            obj_.original_tagname_ = 'Parameter'
# end class ListOfParameters_15


class ListOfClientEventLogs_15(GeneratedsSuper):
    member_data_items_ = {
        'ClientEventLog': MemberSpec_('ClientEventLog', 'ClientEventLog_15', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, ClientEventLog=None):
        self.original_tagname_ = None
        if ClientEventLog is None:
            self.ClientEventLog = []
        else:
            self.ClientEventLog = ClientEventLog
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfClientEventLogs_15)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfClientEventLogs_15.subclass:
            return ListOfClientEventLogs_15.subclass(*args_, **kwargs_)
        else:
            return ListOfClientEventLogs_15(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ClientEventLog(self): return self.ClientEventLog
    def set_ClientEventLog(self, ClientEventLog): self.ClientEventLog = ClientEventLog
    def add_ClientEventLog(self, value): self.ClientEventLog.append(value)
    def insert_ClientEventLog_at(self, index, value): self.ClientEventLog.insert(index, value)
    def replace_ClientEventLog_at(self, index, value): self.ClientEventLog[index] = value
    def hasContent_(self):
        if (
            self.ClientEventLog
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ClientEventLog':
            class_obj_ = self.get_class_obj_(child_, ClientEventLog_15)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.ClientEventLog.append(obj_)
            obj_.original_tagname_ = 'ClientEventLog'
# end class ListOfClientEventLogs_15


class ListOfClientEventLogsPage_15(GeneratedsSuper):
    member_data_items_ = {
        'ClientEventLogList': MemberSpec_('ClientEventLogList', 'ListOfClientEventLogs_15', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, ClientEventLogList=None, Paging=None):
        self.original_tagname_ = None
        self.ClientEventLogList = ClientEventLogList
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfClientEventLogsPage_15)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfClientEventLogsPage_15.subclass:
            return ListOfClientEventLogsPage_15.subclass(*args_, **kwargs_)
        else:
            return ListOfClientEventLogsPage_15(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ClientEventLogList(self): return self.ClientEventLogList
    def set_ClientEventLogList(self, ClientEventLogList): self.ClientEventLogList = ClientEventLogList
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.ClientEventLogList is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ClientEventLogList':
            obj_ = ListOfClientEventLogs_15.factory()
            obj_.build(child_)
            self.ClientEventLogList = obj_
            obj_.original_tagname_ = 'ClientEventLogList'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class ListOfClientEventLogsPage_15


class ClientErrorLog_4(GeneratedsSuper):
    member_data_items_ = {
        'Message': MemberSpec_('Message', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Message=None):
        self.original_tagname_ = None
        self.Message = Message
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ClientErrorLog_4)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ClientErrorLog_4.subclass:
            return ClientErrorLog_4.subclass(*args_, **kwargs_)
        else:
            return ClientErrorLog_4(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Message(self): return self.Message
    def set_Message(self, Message): self.Message = Message
    def hasContent_(self):
        if (
            self.Message is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Message':
            Message_ = child_.text
            Message_ = self.gds_validate_string(Message_, node, 'Message')
            self.Message = Message_
# end class ClientErrorLog_4


class Paging_1(GeneratedsSuper):
    member_data_items_ = {
        'Offset': MemberSpec_('Offset', 'int', 0),
        'Size': MemberSpec_('Size', 'int', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Offset=None, Size=None):
        self.original_tagname_ = None
        self.Offset = Offset
        self.Size = Size
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Paging_1)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Paging_1.subclass:
            return Paging_1.subclass(*args_, **kwargs_)
        else:
            return Paging_1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Offset(self): return self.Offset
    def set_Offset(self, Offset): self.Offset = Offset
    def get_Size(self): return self.Size
    def set_Size(self, Size): self.Size = Size
    def hasContent_(self):
        if (
            self.Offset is not None or
            self.Size is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Offset':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Offset')
            self.Offset = ival_
        elif nodeName_ == 'Size':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Size')
            self.Size = ival_
# end class Paging_1


class Paging_13(Paging_1):
    member_data_items_ = {
        'TotalSize': MemberSpec_('TotalSize', 'int', 0),
    }
    subclass = None
    superclass = Paging_1
    def __init__(self, TotalSize=None):
        self.original_tagname_ = None
        super(Paging_13, self).__init__()
        self.TotalSize = TotalSize
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Paging_13)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Paging_13.subclass:
            return Paging_13.subclass(*args_, **kwargs_)
        else:
            return Paging_13(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_TotalSize(self): return self.TotalSize
    def set_TotalSize(self, TotalSize): self.TotalSize = TotalSize
    def hasContent_(self):
        if (
            self.TotalSize is not None or
            super(Paging_13, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Paging_13, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'TotalSize':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'TotalSize')
            self.TotalSize = ival_
        super(Paging_13, self).buildChildren(child_, node, nodeName_, True)
# end class Paging_13


class AccessTokenInfo_13(GeneratedsSuper):
    member_data_items_ = {
        'Id': MemberSpec_('Id', 'string', 0),
        'UserId': MemberSpec_('UserId', 'long', 0),
        'CommunityId': MemberSpec_('CommunityId', 'long', 0),
        'CultureCode': MemberSpec_('CultureCode', 'string', 0),
        'Created': MemberSpec_('Created', 'dateTime', 0),
        'ValidTill': MemberSpec_('ValidTill', 'dateTime', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Id=None, UserId=None, CommunityId=None, CultureCode=None, Created=None, ValidTill=None):
        self.original_tagname_ = None
        self.Id = Id
        self.UserId = UserId
        self.CommunityId = CommunityId
        self.CultureCode = CultureCode
        if isinstance(Created, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(Created, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = Created
        self.Created = initvalue_
        if isinstance(ValidTill, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(ValidTill, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = ValidTill
        self.ValidTill = initvalue_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AccessTokenInfo_13)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AccessTokenInfo_13.subclass:
            return AccessTokenInfo_13.subclass(*args_, **kwargs_)
        else:
            return AccessTokenInfo_13(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Id(self): return self.Id
    def set_Id(self, Id): self.Id = Id
    def get_UserId(self): return self.UserId
    def set_UserId(self, UserId): self.UserId = UserId
    def get_CommunityId(self): return self.CommunityId
    def set_CommunityId(self, CommunityId): self.CommunityId = CommunityId
    def get_CultureCode(self): return self.CultureCode
    def set_CultureCode(self, CultureCode): self.CultureCode = CultureCode
    def get_Created(self): return self.Created
    def set_Created(self, Created): self.Created = Created
    def get_ValidTill(self): return self.ValidTill
    def set_ValidTill(self, ValidTill): self.ValidTill = ValidTill
    def hasContent_(self):
        if (
            self.Id is not None or
            self.UserId is not None or
            self.CommunityId is not None or
            self.CultureCode is not None or
            self.Created is not None or
            self.ValidTill is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Id':
            Id_ = child_.text
            Id_ = self.gds_validate_string(Id_, node, 'Id')
            self.Id = Id_
        elif nodeName_ == 'UserId':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'UserId')
            self.UserId = ival_
        elif nodeName_ == 'CommunityId':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'CommunityId')
            self.CommunityId = ival_
        elif nodeName_ == 'CultureCode':
            CultureCode_ = child_.text
            CultureCode_ = self.gds_validate_string(CultureCode_, node, 'CultureCode')
            self.CultureCode = CultureCode_
        elif nodeName_ == 'Created':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.Created = dval_
        elif nodeName_ == 'ValidTill':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.ValidTill = dval_
# end class AccessTokenInfo_13


class AccessTokenInfoUser_13(AccessTokenInfo_13):
    member_data_items_ = {
    }
    subclass = None
    superclass = AccessTokenInfo_13
    def __init__(self):
        self.original_tagname_ = None
        super(AccessTokenInfoUser_13, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AccessTokenInfoUser_13)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AccessTokenInfoUser_13.subclass:
            return AccessTokenInfoUser_13.subclass(*args_, **kwargs_)
        else:
            return AccessTokenInfoUser_13(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(AccessTokenInfoUser_13, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(AccessTokenInfoUser_13, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(AccessTokenInfoUser_13, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class AccessTokenInfoUser_13


class AccessTokenInfo_17(GeneratedsSuper):
    member_data_items_ = {
        'Id': MemberSpec_('Id', 'string', 0),
        'UserId': MemberSpec_('UserId', 'string', 0),
        'Created': MemberSpec_('Created', 'dateTime', 0),
        'ValidTill': MemberSpec_('ValidTill', 'dateTime', 0),
        'AccessScopeList': MemberSpec_('AccessScopeList', 'ListOfAccessScopes_17', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Id=None, UserId=None, Created=None, ValidTill=None, AccessScopeList=None):
        self.original_tagname_ = None
        self.Id = Id
        self.UserId = UserId
        if isinstance(Created, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(Created, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = Created
        self.Created = initvalue_
        if isinstance(ValidTill, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(ValidTill, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = ValidTill
        self.ValidTill = initvalue_
        self.AccessScopeList = AccessScopeList
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AccessTokenInfo_17)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AccessTokenInfo_17.subclass:
            return AccessTokenInfo_17.subclass(*args_, **kwargs_)
        else:
            return AccessTokenInfo_17(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Id(self): return self.Id
    def set_Id(self, Id): self.Id = Id
    def get_UserId(self): return self.UserId
    def set_UserId(self, UserId): self.UserId = UserId
    def get_Created(self): return self.Created
    def set_Created(self, Created): self.Created = Created
    def get_ValidTill(self): return self.ValidTill
    def set_ValidTill(self, ValidTill): self.ValidTill = ValidTill
    def get_AccessScopeList(self): return self.AccessScopeList
    def set_AccessScopeList(self, AccessScopeList): self.AccessScopeList = AccessScopeList
    def hasContent_(self):
        if (
            self.Id is not None or
            self.UserId is not None or
            self.Created is not None or
            self.ValidTill is not None or
            self.AccessScopeList is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Id':
            Id_ = child_.text
            Id_ = self.gds_validate_string(Id_, node, 'Id')
            self.Id = Id_
        elif nodeName_ == 'UserId':
            UserId_ = child_.text
            UserId_ = self.gds_validate_string(UserId_, node, 'UserId')
            self.UserId = UserId_
        elif nodeName_ == 'Created':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.Created = dval_
        elif nodeName_ == 'ValidTill':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.ValidTill = dval_
        elif nodeName_ == 'AccessScopeList':
            obj_ = ListOfAccessScopes_17.factory()
            obj_.build(child_)
            self.AccessScopeList = obj_
            obj_.original_tagname_ = 'AccessScopeList'
# end class AccessTokenInfo_17


class AccessScope_17(GeneratedsSuper):
    member_data_items_ = {
        'Id': MemberSpec_('Id', 'string', 0),
        'Type': MemberSpec_('Type', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Id=None, Type=None):
        self.original_tagname_ = None
        self.Id = Id
        self.Type = Type
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AccessScope_17)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AccessScope_17.subclass:
            return AccessScope_17.subclass(*args_, **kwargs_)
        else:
            return AccessScope_17(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Id(self): return self.Id
    def set_Id(self, Id): self.Id = Id
    def get_Type(self): return self.Type
    def set_Type(self, Type): self.Type = Type
    def hasContent_(self):
        if (
            self.Id is not None or
            self.Type is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Id':
            Id_ = child_.text
            Id_ = self.gds_validate_string(Id_, node, 'Id')
            self.Id = Id_
        elif nodeName_ == 'Type':
            Type_ = child_.text
            Type_ = self.gds_validate_string(Type_, node, 'Type')
            self.Type = Type_
# end class AccessScope_17


class ListOfAccessScopes_17(GeneratedsSuper):
    member_data_items_ = {
        'AccessScope': MemberSpec_('AccessScope', 'AccessScope_17', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, AccessScope=None):
        self.original_tagname_ = None
        if AccessScope is None:
            self.AccessScope = []
        else:
            self.AccessScope = AccessScope
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfAccessScopes_17)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfAccessScopes_17.subclass:
            return ListOfAccessScopes_17.subclass(*args_, **kwargs_)
        else:
            return ListOfAccessScopes_17(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_AccessScope(self): return self.AccessScope
    def set_AccessScope(self, AccessScope): self.AccessScope = AccessScope
    def add_AccessScope(self, value): self.AccessScope.append(value)
    def insert_AccessScope_at(self, index, value): self.AccessScope.insert(index, value)
    def replace_AccessScope_at(self, index, value): self.AccessScope[index] = value
    def hasContent_(self):
        if (
            self.AccessScope
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'AccessScope':
            obj_ = AccessScope_17.factory()
            obj_.build(child_)
            self.AccessScope.append(obj_)
            obj_.original_tagname_ = 'AccessScope'
# end class ListOfAccessScopes_17


class AccessToken_14(GeneratedsSuper):
    member_data_items_ = {
        'AccessToken': MemberSpec_('AccessToken', 'string', 0),
        'RefreshToken': MemberSpec_('RefreshToken', 'string', 0),
        'TokenType': MemberSpec_('TokenType', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, AccessToken=None, RefreshToken=None, TokenType=None):
        self.original_tagname_ = None
        self.AccessToken = AccessToken
        self.RefreshToken = RefreshToken
        self.TokenType = TokenType
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AccessToken_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AccessToken_14.subclass:
            return AccessToken_14.subclass(*args_, **kwargs_)
        else:
            return AccessToken_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_AccessToken(self): return self.AccessToken
    def set_AccessToken(self, AccessToken): self.AccessToken = AccessToken
    def get_RefreshToken(self): return self.RefreshToken
    def set_RefreshToken(self, RefreshToken): self.RefreshToken = RefreshToken
    def get_TokenType(self): return self.TokenType
    def set_TokenType(self, TokenType): self.TokenType = TokenType
    def hasContent_(self):
        if (
            self.AccessToken is not None or
            self.RefreshToken is not None or
            self.TokenType is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'AccessToken':
            AccessToken_ = child_.text
            AccessToken_ = self.gds_validate_string(AccessToken_, node, 'AccessToken')
            self.AccessToken = AccessToken_
        elif nodeName_ == 'RefreshToken':
            RefreshToken_ = child_.text
            RefreshToken_ = self.gds_validate_string(RefreshToken_, node, 'RefreshToken')
            self.RefreshToken = RefreshToken_
        elif nodeName_ == 'TokenType':
            TokenType_ = child_.text
            TokenType_ = self.gds_validate_string(TokenType_, node, 'TokenType')
            self.TokenType = TokenType_
# end class AccessToken_14


class GoogleToken(GeneratedsSuper):
    member_data_items_ = {
        'AccessToken': MemberSpec_('AccessToken', 'string', 0),
        'RefreshToken': MemberSpec_('RefreshToken', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, AccessToken=None, RefreshToken=None):
        self.original_tagname_ = None
        self.AccessToken = AccessToken
        self.RefreshToken = RefreshToken
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GoogleToken)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GoogleToken.subclass:
            return GoogleToken.subclass(*args_, **kwargs_)
        else:
            return GoogleToken(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_AccessToken(self): return self.AccessToken
    def set_AccessToken(self, AccessToken): self.AccessToken = AccessToken
    def get_RefreshToken(self): return self.RefreshToken
    def set_RefreshToken(self, RefreshToken): self.RefreshToken = RefreshToken
    def hasContent_(self):
        if (
            self.AccessToken is not None or
            self.RefreshToken is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'AccessToken':
            AccessToken_ = child_.text
            AccessToken_ = self.gds_validate_string(AccessToken_, node, 'AccessToken')
            self.AccessToken = AccessToken_
        elif nodeName_ == 'RefreshToken':
            RefreshToken_ = child_.text
            RefreshToken_ = self.gds_validate_string(RefreshToken_, node, 'RefreshToken')
            self.RefreshToken = RefreshToken_
# end class GoogleToken


class ListOfBoardsPage_22(GeneratedsSuper):
    member_data_items_ = {
        'BoardList': MemberSpec_('BoardList', 'ListOfBoards_22', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, BoardList=None, Paging=None):
        self.original_tagname_ = None
        self.BoardList = BoardList
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfBoardsPage_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfBoardsPage_22.subclass:
            return ListOfBoardsPage_22.subclass(*args_, **kwargs_)
        else:
            return ListOfBoardsPage_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_BoardList(self): return self.BoardList
    def set_BoardList(self, BoardList): self.BoardList = BoardList
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.BoardList is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'BoardList':
            obj_ = ListOfBoards_22.factory()
            obj_.build(child_)
            self.BoardList = obj_
            obj_.original_tagname_ = 'BoardList'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class ListOfBoardsPage_22


class ListOfBoards_22(GeneratedsSuper):
    member_data_items_ = {
        'Board': MemberSpec_('Board', 'BoardBase_22', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Board=None):
        self.original_tagname_ = None
        if Board is None:
            self.Board = []
        else:
            self.Board = Board
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfBoards_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfBoards_22.subclass:
            return ListOfBoards_22.subclass(*args_, **kwargs_)
        else:
            return ListOfBoards_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Board(self): return self.Board
    def set_Board(self, Board): self.Board = Board
    def add_Board(self, value): self.Board.append(value)
    def insert_Board_at(self, index, value): self.Board.insert(index, value)
    def replace_Board_at(self, index, value): self.Board[index] = value
    def hasContent_(self):
        if (
            self.Board
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Board':
            class_obj_ = self.get_class_obj_(child_, BoardBase_22)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Board.append(obj_)
            obj_.original_tagname_ = 'Board'
# end class ListOfBoards_22


class ListOfPinnedItems_22(GeneratedsSuper):
    member_data_items_ = {
        'PinnedItem': MemberSpec_('PinnedItem', 'PinnedItem_22', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, PinnedItem=None):
        self.original_tagname_ = None
        if PinnedItem is None:
            self.PinnedItem = []
        else:
            self.PinnedItem = PinnedItem
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfPinnedItems_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfPinnedItems_22.subclass:
            return ListOfPinnedItems_22.subclass(*args_, **kwargs_)
        else:
            return ListOfPinnedItems_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_PinnedItem(self): return self.PinnedItem
    def set_PinnedItem(self, PinnedItem): self.PinnedItem = PinnedItem
    def add_PinnedItem(self, value): self.PinnedItem.append(value)
    def insert_PinnedItem_at(self, index, value): self.PinnedItem.insert(index, value)
    def replace_PinnedItem_at(self, index, value): self.PinnedItem[index] = value
    def hasContent_(self):
        if (
            self.PinnedItem
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'PinnedItem':
            obj_ = PinnedItem_22.factory()
            obj_.build(child_)
            self.PinnedItem.append(obj_)
            obj_.original_tagname_ = 'PinnedItem'
# end class ListOfPinnedItems_22


class PinnedItem_22(GeneratedsSuper):
    member_data_items_ = {
        'Resource': MemberSpec_('Resource', 'ResourceBase_13', 0),
        'SortOrder': MemberSpec_('SortOrder', 'decimal', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Resource=None, SortOrder=None):
        self.original_tagname_ = None
        self.Resource = Resource
        self.SortOrder = SortOrder
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PinnedItem_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PinnedItem_22.subclass:
            return PinnedItem_22.subclass(*args_, **kwargs_)
        else:
            return PinnedItem_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Resource(self): return self.Resource
    def set_Resource(self, Resource): self.Resource = Resource
    def get_SortOrder(self): return self.SortOrder
    def set_SortOrder(self, SortOrder): self.SortOrder = SortOrder
    def hasContent_(self):
        if (
            self.Resource is not None or
            self.SortOrder is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Resource':
            class_obj_ = self.get_class_obj_(child_, ResourceBase_13)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Resource = obj_
            obj_.original_tagname_ = 'Resource'
        elif nodeName_ == 'SortOrder':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'SortOrder')
            self.SortOrder = fval_
# end class PinnedItem_22


class BoardName_22(GeneratedsSuper):
    member_data_items_ = {
        'BoardName': MemberSpec_('BoardName', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, BoardName=None):
        self.original_tagname_ = None
        self.BoardName = BoardName
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BoardName_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BoardName_22.subclass:
            return BoardName_22.subclass(*args_, **kwargs_)
        else:
            return BoardName_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_BoardName(self): return self.BoardName
    def set_BoardName(self, BoardName): self.BoardName = BoardName
    def hasContent_(self):
        if (
            self.BoardName is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'BoardName':
            BoardName_ = child_.text
            BoardName_ = self.gds_validate_string(BoardName_, node, 'BoardName')
            self.BoardName = BoardName_
# end class BoardName_22


class ListOfBoardsPage_21(GeneratedsSuper):
    member_data_items_ = {
        'BoardList': MemberSpec_('BoardList', 'ListOfBoards_21', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, BoardList=None, Paging=None):
        self.original_tagname_ = None
        self.BoardList = BoardList
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfBoardsPage_21)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfBoardsPage_21.subclass:
            return ListOfBoardsPage_21.subclass(*args_, **kwargs_)
        else:
            return ListOfBoardsPage_21(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_BoardList(self): return self.BoardList
    def set_BoardList(self, BoardList): self.BoardList = BoardList
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.BoardList is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'BoardList':
            obj_ = ListOfBoards_21.factory()
            obj_.build(child_)
            self.BoardList = obj_
            obj_.original_tagname_ = 'BoardList'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class ListOfBoardsPage_21


class ListOfBoards_21(GeneratedsSuper):
    member_data_items_ = {
        'Board': MemberSpec_('Board', 'BoardPersonal_21', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Board=None):
        self.original_tagname_ = None
        if Board is None:
            self.Board = []
        else:
            self.Board = Board
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfBoards_21)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfBoards_21.subclass:
            return ListOfBoards_21.subclass(*args_, **kwargs_)
        else:
            return ListOfBoards_21(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Board(self): return self.Board
    def set_Board(self, Board): self.Board = Board
    def add_Board(self, value): self.Board.append(value)
    def insert_Board_at(self, index, value): self.Board.insert(index, value)
    def replace_Board_at(self, index, value): self.Board[index] = value
    def hasContent_(self):
        if (
            self.Board
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Board':
            obj_ = BoardPersonal_21.factory()
            obj_.build(child_)
            self.Board.append(obj_)
            obj_.original_tagname_ = 'Board'
# end class ListOfBoards_21


class ListOfPinnedItems_21(GeneratedsSuper):
    member_data_items_ = {
        'PinnedItem': MemberSpec_('PinnedItem', 'PinnedItem_21', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, PinnedItem=None):
        self.original_tagname_ = None
        if PinnedItem is None:
            self.PinnedItem = []
        else:
            self.PinnedItem = PinnedItem
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfPinnedItems_21)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfPinnedItems_21.subclass:
            return ListOfPinnedItems_21.subclass(*args_, **kwargs_)
        else:
            return ListOfPinnedItems_21(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_PinnedItem(self): return self.PinnedItem
    def set_PinnedItem(self, PinnedItem): self.PinnedItem = PinnedItem
    def add_PinnedItem(self, value): self.PinnedItem.append(value)
    def insert_PinnedItem_at(self, index, value): self.PinnedItem.insert(index, value)
    def replace_PinnedItem_at(self, index, value): self.PinnedItem[index] = value
    def hasContent_(self):
        if (
            self.PinnedItem
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'PinnedItem':
            obj_ = PinnedItem_21.factory()
            obj_.build(child_)
            self.PinnedItem.append(obj_)
            obj_.original_tagname_ = 'PinnedItem'
# end class ListOfPinnedItems_21


class PinnedItem_21(GeneratedsSuper):
    member_data_items_ = {
        'Resource': MemberSpec_('Resource', 'ResourceBase_13', 0),
        'SortOrder': MemberSpec_('SortOrder', 'decimal', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Resource=None, SortOrder=None):
        self.original_tagname_ = None
        self.Resource = Resource
        self.SortOrder = SortOrder
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PinnedItem_21)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PinnedItem_21.subclass:
            return PinnedItem_21.subclass(*args_, **kwargs_)
        else:
            return PinnedItem_21(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Resource(self): return self.Resource
    def set_Resource(self, Resource): self.Resource = Resource
    def get_SortOrder(self): return self.SortOrder
    def set_SortOrder(self, SortOrder): self.SortOrder = SortOrder
    def hasContent_(self):
        if (
            self.Resource is not None or
            self.SortOrder is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Resource':
            class_obj_ = self.get_class_obj_(child_, ResourceBase_13)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Resource = obj_
            obj_.original_tagname_ = 'Resource'
        elif nodeName_ == 'SortOrder':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'SortOrder')
            self.SortOrder = fval_
# end class PinnedItem_21


class ListOfBoardsPage_20(GeneratedsSuper):
    member_data_items_ = {
        'BoardList': MemberSpec_('BoardList', 'ListOfBoards_20', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, BoardList=None, Paging=None):
        self.original_tagname_ = None
        self.BoardList = BoardList
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfBoardsPage_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfBoardsPage_20.subclass:
            return ListOfBoardsPage_20.subclass(*args_, **kwargs_)
        else:
            return ListOfBoardsPage_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_BoardList(self): return self.BoardList
    def set_BoardList(self, BoardList): self.BoardList = BoardList
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.BoardList is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'BoardList':
            obj_ = ListOfBoards_20.factory()
            obj_.build(child_)
            self.BoardList = obj_
            obj_.original_tagname_ = 'BoardList'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class ListOfBoardsPage_20


class ListOfBoards_20(GeneratedsSuper):
    member_data_items_ = {
        'Board': MemberSpec_('Board', 'BoardBase_20', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Board=None):
        self.original_tagname_ = None
        if Board is None:
            self.Board = []
        else:
            self.Board = Board
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfBoards_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfBoards_20.subclass:
            return ListOfBoards_20.subclass(*args_, **kwargs_)
        else:
            return ListOfBoards_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Board(self): return self.Board
    def set_Board(self, Board): self.Board = Board
    def add_Board(self, value): self.Board.append(value)
    def insert_Board_at(self, index, value): self.Board.insert(index, value)
    def replace_Board_at(self, index, value): self.Board[index] = value
    def hasContent_(self):
        if (
            self.Board
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Board':
            class_obj_ = self.get_class_obj_(child_, BoardBase_20)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Board.append(obj_)
            obj_.original_tagname_ = 'Board'
# end class ListOfBoards_20


class ListOfBoardsPage_15(GeneratedsSuper):
    member_data_items_ = {
        'BoardList': MemberSpec_('BoardList', 'ListOfBoards_15', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, BoardList=None, Paging=None):
        self.original_tagname_ = None
        self.BoardList = BoardList
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfBoardsPage_15)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfBoardsPage_15.subclass:
            return ListOfBoardsPage_15.subclass(*args_, **kwargs_)
        else:
            return ListOfBoardsPage_15(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_BoardList(self): return self.BoardList
    def set_BoardList(self, BoardList): self.BoardList = BoardList
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.BoardList is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'BoardList':
            obj_ = ListOfBoards_15.factory()
            obj_.build(child_)
            self.BoardList = obj_
            obj_.original_tagname_ = 'BoardList'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class ListOfBoardsPage_15


class ListOfBoards_15(GeneratedsSuper):
    member_data_items_ = {
        'Board': MemberSpec_('Board', 'BoardBase_15', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Board=None):
        self.original_tagname_ = None
        if Board is None:
            self.Board = []
        else:
            self.Board = Board
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfBoards_15)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfBoards_15.subclass:
            return ListOfBoards_15.subclass(*args_, **kwargs_)
        else:
            return ListOfBoards_15(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Board(self): return self.Board
    def set_Board(self, Board): self.Board = Board
    def add_Board(self, value): self.Board.append(value)
    def insert_Board_at(self, index, value): self.Board.insert(index, value)
    def replace_Board_at(self, index, value): self.Board[index] = value
    def hasContent_(self):
        if (
            self.Board
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Board':
            class_obj_ = self.get_class_obj_(child_, BoardBase_15)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Board.append(obj_)
            obj_.original_tagname_ = 'Board'
# end class ListOfBoards_15


class NotificationTrigger_18(GeneratedsSuper):
    member_data_items_ = {
        'ResourceId': MemberSpec_('ResourceId', 'string', 0),
        'NotificationTriggerType': MemberSpec_('NotificationTriggerType', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, ResourceId=None, NotificationTriggerType=None):
        self.original_tagname_ = None
        self.ResourceId = ResourceId
        self.NotificationTriggerType = NotificationTriggerType
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationTrigger_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationTrigger_18.subclass:
            return NotificationTrigger_18.subclass(*args_, **kwargs_)
        else:
            return NotificationTrigger_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ResourceId(self): return self.ResourceId
    def set_ResourceId(self, ResourceId): self.ResourceId = ResourceId
    def get_NotificationTriggerType(self): return self.NotificationTriggerType
    def set_NotificationTriggerType(self, NotificationTriggerType): self.NotificationTriggerType = NotificationTriggerType
    def hasContent_(self):
        if (
            self.ResourceId is not None or
            self.NotificationTriggerType is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ResourceId':
            ResourceId_ = child_.text
            ResourceId_ = self.gds_validate_string(ResourceId_, node, 'ResourceId')
            self.ResourceId = ResourceId_
        elif nodeName_ == 'NotificationTriggerType':
            NotificationTriggerType_ = child_.text
            NotificationTriggerType_ = self.gds_validate_string(NotificationTriggerType_, node, 'NotificationTriggerType')
            self.NotificationTriggerType = NotificationTriggerType_
# end class NotificationTrigger_18


class ListOfNotificationTriggers_18(GeneratedsSuper):
    member_data_items_ = {
        'NotificationTrigger': MemberSpec_('NotificationTrigger', 'NotificationTrigger_18', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, NotificationTrigger=None):
        self.original_tagname_ = None
        if NotificationTrigger is None:
            self.NotificationTrigger = []
        else:
            self.NotificationTrigger = NotificationTrigger
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfNotificationTriggers_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfNotificationTriggers_18.subclass:
            return ListOfNotificationTriggers_18.subclass(*args_, **kwargs_)
        else:
            return ListOfNotificationTriggers_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_NotificationTrigger(self): return self.NotificationTrigger
    def set_NotificationTrigger(self, NotificationTrigger): self.NotificationTrigger = NotificationTrigger
    def add_NotificationTrigger(self, value): self.NotificationTrigger.append(value)
    def insert_NotificationTrigger_at(self, index, value): self.NotificationTrigger.insert(index, value)
    def replace_NotificationTrigger_at(self, index, value): self.NotificationTrigger[index] = value
    def hasContent_(self):
        if (
            self.NotificationTrigger
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'NotificationTrigger':
            obj_ = NotificationTrigger_18.factory()
            obj_.build(child_)
            self.NotificationTrigger.append(obj_)
            obj_.original_tagname_ = 'NotificationTrigger'
# end class ListOfNotificationTriggers_18


class ListOfNotificationsPage_22(GeneratedsSuper):
    member_data_items_ = {
        'LastNotificationId': MemberSpec_('LastNotificationId', 'string', 0),
        'NotificationListPage': MemberSpec_('NotificationListPage', 'ListOfNotifications_22', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, LastNotificationId=None, NotificationListPage=None, Paging=None):
        self.original_tagname_ = None
        self.LastNotificationId = LastNotificationId
        self.NotificationListPage = NotificationListPage
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfNotificationsPage_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfNotificationsPage_22.subclass:
            return ListOfNotificationsPage_22.subclass(*args_, **kwargs_)
        else:
            return ListOfNotificationsPage_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_LastNotificationId(self): return self.LastNotificationId
    def set_LastNotificationId(self, LastNotificationId): self.LastNotificationId = LastNotificationId
    def get_NotificationListPage(self): return self.NotificationListPage
    def set_NotificationListPage(self, NotificationListPage): self.NotificationListPage = NotificationListPage
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.LastNotificationId is not None or
            self.NotificationListPage is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'LastNotificationId':
            LastNotificationId_ = child_.text
            LastNotificationId_ = self.gds_validate_string(LastNotificationId_, node, 'LastNotificationId')
            self.LastNotificationId = LastNotificationId_
        elif nodeName_ == 'NotificationListPage':
            obj_ = ListOfNotifications_22.factory()
            obj_.build(child_)
            self.NotificationListPage = obj_
            obj_.original_tagname_ = 'NotificationListPage'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class ListOfNotificationsPage_22


class ListOfNotifications_22(GeneratedsSuper):
    member_data_items_ = {
        'Notification': MemberSpec_('Notification', 'NotificationBase_22', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Notification=None):
        self.original_tagname_ = None
        if Notification is None:
            self.Notification = []
        else:
            self.Notification = Notification
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfNotifications_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfNotifications_22.subclass:
            return ListOfNotifications_22.subclass(*args_, **kwargs_)
        else:
            return ListOfNotifications_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Notification(self): return self.Notification
    def set_Notification(self, Notification): self.Notification = Notification
    def add_Notification(self, value): self.Notification.append(value)
    def insert_Notification_at(self, index, value): self.Notification.insert(index, value)
    def replace_Notification_at(self, index, value): self.Notification[index] = value
    def hasContent_(self):
        if (
            self.Notification
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Notification':
            class_obj_ = self.get_class_obj_(child_, NotificationBase_22)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Notification.append(obj_)
            obj_.original_tagname_ = 'Notification'
# end class ListOfNotifications_22


class NotificationBase_22(GeneratedsSuper):
    member_data_items_ = {
        'Id': MemberSpec_('Id', 'string', 0),
        'Created': MemberSpec_('Created', 'dateTime', 0),
        'Recipient': MemberSpec_('Recipient', 'User_14', 0),
        'TriggerList': MemberSpec_('TriggerList', 'ListOfNotificationTriggers_18', 0),
        'AlertMessage': MemberSpec_('AlertMessage', 'string', 0),
        'Sender': MemberSpec_('Sender', 'User_14', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Id=None, Created=None, Recipient=None, TriggerList=None, AlertMessage=None, Sender=None):
        self.original_tagname_ = None
        self.Id = Id
        if isinstance(Created, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(Created, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = Created
        self.Created = initvalue_
        self.Recipient = Recipient
        self.TriggerList = TriggerList
        self.AlertMessage = AlertMessage
        self.Sender = Sender
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationBase_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationBase_22.subclass:
            return NotificationBase_22.subclass(*args_, **kwargs_)
        else:
            return NotificationBase_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Id(self): return self.Id
    def set_Id(self, Id): self.Id = Id
    def get_Created(self): return self.Created
    def set_Created(self, Created): self.Created = Created
    def get_Recipient(self): return self.Recipient
    def set_Recipient(self, Recipient): self.Recipient = Recipient
    def get_TriggerList(self): return self.TriggerList
    def set_TriggerList(self, TriggerList): self.TriggerList = TriggerList
    def get_AlertMessage(self): return self.AlertMessage
    def set_AlertMessage(self, AlertMessage): self.AlertMessage = AlertMessage
    def get_Sender(self): return self.Sender
    def set_Sender(self, Sender): self.Sender = Sender
    def hasContent_(self):
        if (
            self.Id is not None or
            self.Created is not None or
            self.Recipient is not None or
            self.TriggerList is not None or
            self.AlertMessage is not None or
            self.Sender is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Id':
            Id_ = child_.text
            Id_ = self.gds_validate_string(Id_, node, 'Id')
            self.Id = Id_
        elif nodeName_ == 'Created':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.Created = dval_
        elif nodeName_ == 'Recipient':
            class_obj_ = self.get_class_obj_(child_, User_14)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Recipient = obj_
            obj_.original_tagname_ = 'Recipient'
        elif nodeName_ == 'TriggerList':
            obj_ = ListOfNotificationTriggers_18.factory()
            obj_.build(child_)
            self.TriggerList = obj_
            obj_.original_tagname_ = 'TriggerList'
        elif nodeName_ == 'AlertMessage':
            AlertMessage_ = child_.text
            AlertMessage_ = self.gds_validate_string(AlertMessage_, node, 'AlertMessage')
            self.AlertMessage = AlertMessage_
        elif nodeName_ == 'Sender':
            class_obj_ = self.get_class_obj_(child_, User_14)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Sender = obj_
            obj_.original_tagname_ = 'Sender'
# end class NotificationBase_22


class NotificationStreamCreated_22(NotificationBase_22):
    member_data_items_ = {
        'Stream': MemberSpec_('Stream', 'StreamBase_22', 0),
    }
    subclass = None
    superclass = NotificationBase_22
    def __init__(self, Stream=None):
        self.original_tagname_ = None
        super(NotificationStreamCreated_22, self).__init__()
        self.Stream = Stream
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationStreamCreated_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationStreamCreated_22.subclass:
            return NotificationStreamCreated_22.subclass(*args_, **kwargs_)
        else:
            return NotificationStreamCreated_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Stream(self): return self.Stream
    def set_Stream(self, Stream): self.Stream = Stream
    def hasContent_(self):
        if (
            self.Stream is not None or
            super(NotificationStreamCreated_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationStreamCreated_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Stream':
            class_obj_ = self.get_class_obj_(child_, StreamBase_22)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Stream = obj_
            obj_.original_tagname_ = 'Stream'
        super(NotificationStreamCreated_22, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationStreamCreated_22


class NotificationStreamUpdated_22(NotificationBase_22):
    member_data_items_ = {
        'Stream': MemberSpec_('Stream', 'StreamBase_22', 0),
    }
    subclass = None
    superclass = NotificationBase_22
    def __init__(self, Stream=None):
        self.original_tagname_ = None
        super(NotificationStreamUpdated_22, self).__init__()
        self.Stream = Stream
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationStreamUpdated_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationStreamUpdated_22.subclass:
            return NotificationStreamUpdated_22.subclass(*args_, **kwargs_)
        else:
            return NotificationStreamUpdated_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Stream(self): return self.Stream
    def set_Stream(self, Stream): self.Stream = Stream
    def hasContent_(self):
        if (
            self.Stream is not None or
            super(NotificationStreamUpdated_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationStreamUpdated_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Stream':
            class_obj_ = self.get_class_obj_(child_, StreamBase_22)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Stream = obj_
            obj_.original_tagname_ = 'Stream'
        super(NotificationStreamUpdated_22, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationStreamUpdated_22


class NotificationStreamDeleted_22(NotificationBase_22):
    member_data_items_ = {
        'Stream': MemberSpec_('Stream', 'StreamBase_22', 0),
    }
    subclass = None
    superclass = NotificationBase_22
    def __init__(self, Stream=None):
        self.original_tagname_ = None
        super(NotificationStreamDeleted_22, self).__init__()
        self.Stream = Stream
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationStreamDeleted_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationStreamDeleted_22.subclass:
            return NotificationStreamDeleted_22.subclass(*args_, **kwargs_)
        else:
            return NotificationStreamDeleted_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Stream(self): return self.Stream
    def set_Stream(self, Stream): self.Stream = Stream
    def hasContent_(self):
        if (
            self.Stream is not None or
            super(NotificationStreamDeleted_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationStreamDeleted_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Stream':
            class_obj_ = self.get_class_obj_(child_, StreamBase_22)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Stream = obj_
            obj_.original_tagname_ = 'Stream'
        super(NotificationStreamDeleted_22, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationStreamDeleted_22


class NotificationUserTokenInvalid_22(NotificationBase_22):
    member_data_items_ = {
        'TokenProvider': MemberSpec_('TokenProvider', 'string', 0),
    }
    subclass = None
    superclass = NotificationBase_22
    def __init__(self, TokenProvider=None):
        self.original_tagname_ = None
        super(NotificationUserTokenInvalid_22, self).__init__()
        self.TokenProvider = TokenProvider
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationUserTokenInvalid_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationUserTokenInvalid_22.subclass:
            return NotificationUserTokenInvalid_22.subclass(*args_, **kwargs_)
        else:
            return NotificationUserTokenInvalid_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_TokenProvider(self): return self.TokenProvider
    def set_TokenProvider(self, TokenProvider): self.TokenProvider = TokenProvider
    def hasContent_(self):
        if (
            self.TokenProvider is not None or
            super(NotificationUserTokenInvalid_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationUserTokenInvalid_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'TokenProvider':
            TokenProvider_ = child_.text
            TokenProvider_ = self.gds_validate_string(TokenProvider_, node, 'TokenProvider')
            self.TokenProvider = TokenProvider_
        super(NotificationUserTokenInvalid_22, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationUserTokenInvalid_22


class NotificationMailboxMissing_22(NotificationBase_22):
    member_data_items_ = {
        'TokenProvider': MemberSpec_('TokenProvider', 'string', 0),
    }
    subclass = None
    superclass = NotificationBase_22
    def __init__(self, TokenProvider=None):
        self.original_tagname_ = None
        super(NotificationMailboxMissing_22, self).__init__()
        self.TokenProvider = TokenProvider
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationMailboxMissing_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationMailboxMissing_22.subclass:
            return NotificationMailboxMissing_22.subclass(*args_, **kwargs_)
        else:
            return NotificationMailboxMissing_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_TokenProvider(self): return self.TokenProvider
    def set_TokenProvider(self, TokenProvider): self.TokenProvider = TokenProvider
    def hasContent_(self):
        if (
            self.TokenProvider is not None or
            super(NotificationMailboxMissing_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationMailboxMissing_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'TokenProvider':
            TokenProvider_ = child_.text
            TokenProvider_ = self.gds_validate_string(TokenProvider_, node, 'TokenProvider')
            self.TokenProvider = TokenProvider_
        super(NotificationMailboxMissing_22, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationMailboxMissing_22


class NotificationOnboardingComplete_22(NotificationBase_22):
    member_data_items_ = {
    }
    subclass = None
    superclass = NotificationBase_22
    def __init__(self):
        self.original_tagname_ = None
        super(NotificationOnboardingComplete_22, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationOnboardingComplete_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationOnboardingComplete_22.subclass:
            return NotificationOnboardingComplete_22.subclass(*args_, **kwargs_)
        else:
            return NotificationOnboardingComplete_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(NotificationOnboardingComplete_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationOnboardingComplete_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(NotificationOnboardingComplete_22, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class NotificationOnboardingComplete_22


class NotificationPostCreated_22(NotificationBase_22):
    member_data_items_ = {
        'Post': MemberSpec_('Post', 'Post_22', 0),
    }
    subclass = None
    superclass = NotificationBase_22
    def __init__(self, Post=None):
        self.original_tagname_ = None
        super(NotificationPostCreated_22, self).__init__()
        self.Post = Post
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationPostCreated_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationPostCreated_22.subclass:
            return NotificationPostCreated_22.subclass(*args_, **kwargs_)
        else:
            return NotificationPostCreated_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Post(self): return self.Post
    def set_Post(self, Post): self.Post = Post
    def hasContent_(self):
        if (
            self.Post is not None or
            super(NotificationPostCreated_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationPostCreated_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Post':
            class_obj_ = self.get_class_obj_(child_, Post_22)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Post = obj_
            obj_.original_tagname_ = 'Post'
        super(NotificationPostCreated_22, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationPostCreated_22


class NotificationPostUpdated_22(NotificationBase_22):
    member_data_items_ = {
        'Post': MemberSpec_('Post', 'Post_22', 0),
    }
    subclass = None
    superclass = NotificationBase_22
    def __init__(self, Post=None):
        self.original_tagname_ = None
        super(NotificationPostUpdated_22, self).__init__()
        self.Post = Post
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationPostUpdated_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationPostUpdated_22.subclass:
            return NotificationPostUpdated_22.subclass(*args_, **kwargs_)
        else:
            return NotificationPostUpdated_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Post(self): return self.Post
    def set_Post(self, Post): self.Post = Post
    def hasContent_(self):
        if (
            self.Post is not None or
            super(NotificationPostUpdated_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationPostUpdated_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Post':
            class_obj_ = self.get_class_obj_(child_, Post_22)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Post = obj_
            obj_.original_tagname_ = 'Post'
        super(NotificationPostUpdated_22, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationPostUpdated_22


class NotificationPostUnread_22(NotificationBase_22):
    member_data_items_ = {
        'UnreadInfo': MemberSpec_('UnreadInfo', 'PostUnread_22', 0),
    }
    subclass = None
    superclass = NotificationBase_22
    def __init__(self, UnreadInfo=None):
        self.original_tagname_ = None
        super(NotificationPostUnread_22, self).__init__()
        self.UnreadInfo = UnreadInfo
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationPostUnread_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationPostUnread_22.subclass:
            return NotificationPostUnread_22.subclass(*args_, **kwargs_)
        else:
            return NotificationPostUnread_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_UnreadInfo(self): return self.UnreadInfo
    def set_UnreadInfo(self, UnreadInfo): self.UnreadInfo = UnreadInfo
    def hasContent_(self):
        if (
            self.UnreadInfo is not None or
            super(NotificationPostUnread_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationPostUnread_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'UnreadInfo':
            obj_ = PostUnread_22.factory()
            obj_.build(child_)
            self.UnreadInfo = obj_
            obj_.original_tagname_ = 'UnreadInfo'
        super(NotificationPostUnread_22, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationPostUnread_22


class NotificationPostActionListUpdated_22(NotificationBase_22):
    member_data_items_ = {
        'PostActionList': MemberSpec_('PostActionList', 'PostActionList_22', 0),
    }
    subclass = None
    superclass = NotificationBase_22
    def __init__(self, PostActionList=None):
        self.original_tagname_ = None
        super(NotificationPostActionListUpdated_22, self).__init__()
        self.PostActionList = PostActionList
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationPostActionListUpdated_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationPostActionListUpdated_22.subclass:
            return NotificationPostActionListUpdated_22.subclass(*args_, **kwargs_)
        else:
            return NotificationPostActionListUpdated_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_PostActionList(self): return self.PostActionList
    def set_PostActionList(self, PostActionList): self.PostActionList = PostActionList
    def hasContent_(self):
        if (
            self.PostActionList is not None or
            super(NotificationPostActionListUpdated_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationPostActionListUpdated_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'PostActionList':
            obj_ = PostActionList_22.factory()
            obj_.build(child_)
            self.PostActionList = obj_
            obj_.original_tagname_ = 'PostActionList'
        super(NotificationPostActionListUpdated_22, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationPostActionListUpdated_22


class NotificationCardCreated_22(NotificationBase_22):
    member_data_items_ = {
        'Card': MemberSpec_('Card', 'DiscussionCard_22', 0),
    }
    subclass = None
    superclass = NotificationBase_22
    def __init__(self, Card=None):
        self.original_tagname_ = None
        super(NotificationCardCreated_22, self).__init__()
        self.Card = Card
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationCardCreated_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationCardCreated_22.subclass:
            return NotificationCardCreated_22.subclass(*args_, **kwargs_)
        else:
            return NotificationCardCreated_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Card(self): return self.Card
    def set_Card(self, Card): self.Card = Card
    def hasContent_(self):
        if (
            self.Card is not None or
            super(NotificationCardCreated_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationCardCreated_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Card':
            obj_ = DiscussionCard_22.factory()
            obj_.build(child_)
            self.Card = obj_
            obj_.original_tagname_ = 'Card'
        super(NotificationCardCreated_22, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationCardCreated_22


class NotificationCardUpdated_22(NotificationBase_22):
    member_data_items_ = {
        'Card': MemberSpec_('Card', 'DiscussionCard_22', 0),
    }
    subclass = None
    superclass = NotificationBase_22
    def __init__(self, Card=None):
        self.original_tagname_ = None
        super(NotificationCardUpdated_22, self).__init__()
        self.Card = Card
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationCardUpdated_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationCardUpdated_22.subclass:
            return NotificationCardUpdated_22.subclass(*args_, **kwargs_)
        else:
            return NotificationCardUpdated_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Card(self): return self.Card
    def set_Card(self, Card): self.Card = Card
    def hasContent_(self):
        if (
            self.Card is not None or
            super(NotificationCardUpdated_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationCardUpdated_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Card':
            obj_ = DiscussionCard_22.factory()
            obj_.build(child_)
            self.Card = obj_
            obj_.original_tagname_ = 'Card'
        super(NotificationCardUpdated_22, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationCardUpdated_22


class NotificationUserStatusChange_22(NotificationBase_22):
    member_data_items_ = {
        'OnlineStatus': MemberSpec_('OnlineStatus', 'string', 0),
        'LastActivityAt': MemberSpec_('LastActivityAt', 'dateTime', 0),
    }
    subclass = None
    superclass = NotificationBase_22
    def __init__(self, OnlineStatus=None, LastActivityAt=None):
        self.original_tagname_ = None
        super(NotificationUserStatusChange_22, self).__init__()
        self.OnlineStatus = OnlineStatus
        if isinstance(LastActivityAt, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(LastActivityAt, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = LastActivityAt
        self.LastActivityAt = initvalue_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationUserStatusChange_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationUserStatusChange_22.subclass:
            return NotificationUserStatusChange_22.subclass(*args_, **kwargs_)
        else:
            return NotificationUserStatusChange_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_OnlineStatus(self): return self.OnlineStatus
    def set_OnlineStatus(self, OnlineStatus): self.OnlineStatus = OnlineStatus
    def get_LastActivityAt(self): return self.LastActivityAt
    def set_LastActivityAt(self, LastActivityAt): self.LastActivityAt = LastActivityAt
    def hasContent_(self):
        if (
            self.OnlineStatus is not None or
            self.LastActivityAt is not None or
            super(NotificationUserStatusChange_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationUserStatusChange_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'OnlineStatus':
            OnlineStatus_ = child_.text
            OnlineStatus_ = self.gds_validate_string(OnlineStatus_, node, 'OnlineStatus')
            self.OnlineStatus = OnlineStatus_
        elif nodeName_ == 'LastActivityAt':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.LastActivityAt = dval_
        super(NotificationUserStatusChange_22, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationUserStatusChange_22


class NotificationBoardCreated_22(NotificationBase_22):
    member_data_items_ = {
        'Board': MemberSpec_('Board', 'BoardPersonal_22', 0),
    }
    subclass = None
    superclass = NotificationBase_22
    def __init__(self, Board=None):
        self.original_tagname_ = None
        super(NotificationBoardCreated_22, self).__init__()
        self.Board = Board
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationBoardCreated_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationBoardCreated_22.subclass:
            return NotificationBoardCreated_22.subclass(*args_, **kwargs_)
        else:
            return NotificationBoardCreated_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Board(self): return self.Board
    def set_Board(self, Board): self.Board = Board
    def hasContent_(self):
        if (
            self.Board is not None or
            super(NotificationBoardCreated_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationBoardCreated_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Board':
            obj_ = BoardPersonal_22.factory()
            obj_.build(child_)
            self.Board = obj_
            obj_.original_tagname_ = 'Board'
        super(NotificationBoardCreated_22, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationBoardCreated_22


class NotificationBoardUpdated_22(NotificationBase_22):
    member_data_items_ = {
        'Board': MemberSpec_('Board', 'BoardBase_22', 0),
    }
    subclass = None
    superclass = NotificationBase_22
    def __init__(self, Board=None):
        self.original_tagname_ = None
        super(NotificationBoardUpdated_22, self).__init__()
        self.Board = Board
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationBoardUpdated_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationBoardUpdated_22.subclass:
            return NotificationBoardUpdated_22.subclass(*args_, **kwargs_)
        else:
            return NotificationBoardUpdated_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Board(self): return self.Board
    def set_Board(self, Board): self.Board = Board
    def hasContent_(self):
        if (
            self.Board is not None or
            super(NotificationBoardUpdated_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationBoardUpdated_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Board':
            class_obj_ = self.get_class_obj_(child_, BoardBase_22)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Board = obj_
            obj_.original_tagname_ = 'Board'
        super(NotificationBoardUpdated_22, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationBoardUpdated_22


class NotificationBoardDeleted_22(NotificationBase_22):
    member_data_items_ = {
        'Board': MemberSpec_('Board', 'BoardPersonal_22', 0),
    }
    subclass = None
    superclass = NotificationBase_22
    def __init__(self, Board=None):
        self.original_tagname_ = None
        super(NotificationBoardDeleted_22, self).__init__()
        self.Board = Board
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationBoardDeleted_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationBoardDeleted_22.subclass:
            return NotificationBoardDeleted_22.subclass(*args_, **kwargs_)
        else:
            return NotificationBoardDeleted_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Board(self): return self.Board
    def set_Board(self, Board): self.Board = Board
    def hasContent_(self):
        if (
            self.Board is not None or
            super(NotificationBoardDeleted_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationBoardDeleted_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Board':
            obj_ = BoardPersonal_22.factory()
            obj_.build(child_)
            self.Board = obj_
            obj_.original_tagname_ = 'Board'
        super(NotificationBoardDeleted_22, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationBoardDeleted_22


class NotificationPostAssistantCreated_22(NotificationBase_22):
    member_data_items_ = {
        'PostAssistant': MemberSpec_('PostAssistant', 'PostAssistant_22', 0),
    }
    subclass = None
    superclass = NotificationBase_22
    def __init__(self, PostAssistant=None):
        self.original_tagname_ = None
        super(NotificationPostAssistantCreated_22, self).__init__()
        self.PostAssistant = PostAssistant
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationPostAssistantCreated_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationPostAssistantCreated_22.subclass:
            return NotificationPostAssistantCreated_22.subclass(*args_, **kwargs_)
        else:
            return NotificationPostAssistantCreated_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_PostAssistant(self): return self.PostAssistant
    def set_PostAssistant(self, PostAssistant): self.PostAssistant = PostAssistant
    def hasContent_(self):
        if (
            self.PostAssistant is not None or
            super(NotificationPostAssistantCreated_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationPostAssistantCreated_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'PostAssistant':
            obj_ = PostAssistant_22.factory()
            obj_.build(child_)
            self.PostAssistant = obj_
            obj_.original_tagname_ = 'PostAssistant'
        super(NotificationPostAssistantCreated_22, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationPostAssistantCreated_22


class NotificationPostAssistantUpdated_22(NotificationBase_22):
    member_data_items_ = {
        'PostAssistant': MemberSpec_('PostAssistant', 'PostAssistant_22', 0),
    }
    subclass = None
    superclass = NotificationBase_22
    def __init__(self, PostAssistant=None):
        self.original_tagname_ = None
        super(NotificationPostAssistantUpdated_22, self).__init__()
        self.PostAssistant = PostAssistant
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationPostAssistantUpdated_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationPostAssistantUpdated_22.subclass:
            return NotificationPostAssistantUpdated_22.subclass(*args_, **kwargs_)
        else:
            return NotificationPostAssistantUpdated_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_PostAssistant(self): return self.PostAssistant
    def set_PostAssistant(self, PostAssistant): self.PostAssistant = PostAssistant
    def hasContent_(self):
        if (
            self.PostAssistant is not None or
            super(NotificationPostAssistantUpdated_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationPostAssistantUpdated_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'PostAssistant':
            obj_ = PostAssistant_22.factory()
            obj_.build(child_)
            self.PostAssistant = obj_
            obj_.original_tagname_ = 'PostAssistant'
        super(NotificationPostAssistantUpdated_22, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationPostAssistantUpdated_22


class NotificationPostAssistantDeleted_22(NotificationBase_22):
    member_data_items_ = {
        'PostAssistant': MemberSpec_('PostAssistant', 'PostAssistant_22', 0),
    }
    subclass = None
    superclass = NotificationBase_22
    def __init__(self, PostAssistant=None):
        self.original_tagname_ = None
        super(NotificationPostAssistantDeleted_22, self).__init__()
        self.PostAssistant = PostAssistant
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationPostAssistantDeleted_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationPostAssistantDeleted_22.subclass:
            return NotificationPostAssistantDeleted_22.subclass(*args_, **kwargs_)
        else:
            return NotificationPostAssistantDeleted_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_PostAssistant(self): return self.PostAssistant
    def set_PostAssistant(self, PostAssistant): self.PostAssistant = PostAssistant
    def hasContent_(self):
        if (
            self.PostAssistant is not None or
            super(NotificationPostAssistantDeleted_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationPostAssistantDeleted_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'PostAssistant':
            obj_ = PostAssistant_22.factory()
            obj_.build(child_)
            self.PostAssistant = obj_
            obj_.original_tagname_ = 'PostAssistant'
        super(NotificationPostAssistantDeleted_22, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationPostAssistantDeleted_22


class NotificationAppointmentCreated_22(NotificationBase_22):
    member_data_items_ = {
        'Appointment': MemberSpec_('Appointment', 'Appointment_22', 0),
    }
    subclass = None
    superclass = NotificationBase_22
    def __init__(self, Appointment=None):
        self.original_tagname_ = None
        super(NotificationAppointmentCreated_22, self).__init__()
        self.Appointment = Appointment
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationAppointmentCreated_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationAppointmentCreated_22.subclass:
            return NotificationAppointmentCreated_22.subclass(*args_, **kwargs_)
        else:
            return NotificationAppointmentCreated_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Appointment(self): return self.Appointment
    def set_Appointment(self, Appointment): self.Appointment = Appointment
    def hasContent_(self):
        if (
            self.Appointment is not None or
            super(NotificationAppointmentCreated_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationAppointmentCreated_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Appointment':
            obj_ = Appointment_22.factory()
            obj_.build(child_)
            self.Appointment = obj_
            obj_.original_tagname_ = 'Appointment'
        super(NotificationAppointmentCreated_22, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationAppointmentCreated_22


class NotificationAppointmentUpdated_22(NotificationBase_22):
    member_data_items_ = {
        'Appointment': MemberSpec_('Appointment', 'Appointment_22', 0),
    }
    subclass = None
    superclass = NotificationBase_22
    def __init__(self, Appointment=None):
        self.original_tagname_ = None
        super(NotificationAppointmentUpdated_22, self).__init__()
        self.Appointment = Appointment
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationAppointmentUpdated_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationAppointmentUpdated_22.subclass:
            return NotificationAppointmentUpdated_22.subclass(*args_, **kwargs_)
        else:
            return NotificationAppointmentUpdated_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Appointment(self): return self.Appointment
    def set_Appointment(self, Appointment): self.Appointment = Appointment
    def hasContent_(self):
        if (
            self.Appointment is not None or
            super(NotificationAppointmentUpdated_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationAppointmentUpdated_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Appointment':
            obj_ = Appointment_22.factory()
            obj_.build(child_)
            self.Appointment = obj_
            obj_.original_tagname_ = 'Appointment'
        super(NotificationAppointmentUpdated_22, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationAppointmentUpdated_22


class NotificationAppointmentDeleted_22(NotificationBase_22):
    member_data_items_ = {
        'Appointment': MemberSpec_('Appointment', 'Appointment_22', 0),
    }
    subclass = None
    superclass = NotificationBase_22
    def __init__(self, Appointment=None):
        self.original_tagname_ = None
        super(NotificationAppointmentDeleted_22, self).__init__()
        self.Appointment = Appointment
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationAppointmentDeleted_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationAppointmentDeleted_22.subclass:
            return NotificationAppointmentDeleted_22.subclass(*args_, **kwargs_)
        else:
            return NotificationAppointmentDeleted_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Appointment(self): return self.Appointment
    def set_Appointment(self, Appointment): self.Appointment = Appointment
    def hasContent_(self):
        if (
            self.Appointment is not None or
            super(NotificationAppointmentDeleted_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationAppointmentDeleted_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Appointment':
            obj_ = Appointment_22.factory()
            obj_.build(child_)
            self.Appointment = obj_
            obj_.original_tagname_ = 'Appointment'
        super(NotificationAppointmentDeleted_22, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationAppointmentDeleted_22


class NotificationReminderCreated_22(NotificationBase_22):
    member_data_items_ = {
        'Reminder': MemberSpec_('Reminder', 'Reminder_22', 0),
    }
    subclass = None
    superclass = NotificationBase_22
    def __init__(self, Reminder=None):
        self.original_tagname_ = None
        super(NotificationReminderCreated_22, self).__init__()
        self.Reminder = Reminder
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationReminderCreated_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationReminderCreated_22.subclass:
            return NotificationReminderCreated_22.subclass(*args_, **kwargs_)
        else:
            return NotificationReminderCreated_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Reminder(self): return self.Reminder
    def set_Reminder(self, Reminder): self.Reminder = Reminder
    def hasContent_(self):
        if (
            self.Reminder is not None or
            super(NotificationReminderCreated_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationReminderCreated_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Reminder':
            obj_ = Reminder_22.factory()
            obj_.build(child_)
            self.Reminder = obj_
            obj_.original_tagname_ = 'Reminder'
        super(NotificationReminderCreated_22, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationReminderCreated_22


class NotificationReminderUpdated_22(NotificationBase_22):
    member_data_items_ = {
        'Reminder': MemberSpec_('Reminder', 'Reminder_22', 0),
    }
    subclass = None
    superclass = NotificationBase_22
    def __init__(self, Reminder=None):
        self.original_tagname_ = None
        super(NotificationReminderUpdated_22, self).__init__()
        self.Reminder = Reminder
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationReminderUpdated_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationReminderUpdated_22.subclass:
            return NotificationReminderUpdated_22.subclass(*args_, **kwargs_)
        else:
            return NotificationReminderUpdated_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Reminder(self): return self.Reminder
    def set_Reminder(self, Reminder): self.Reminder = Reminder
    def hasContent_(self):
        if (
            self.Reminder is not None or
            super(NotificationReminderUpdated_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationReminderUpdated_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Reminder':
            obj_ = Reminder_22.factory()
            obj_.build(child_)
            self.Reminder = obj_
            obj_.original_tagname_ = 'Reminder'
        super(NotificationReminderUpdated_22, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationReminderUpdated_22


class NotificationReminderDeleted_22(NotificationBase_22):
    member_data_items_ = {
        'Reminder': MemberSpec_('Reminder', 'Reminder_22', 0),
    }
    subclass = None
    superclass = NotificationBase_22
    def __init__(self, Reminder=None):
        self.original_tagname_ = None
        super(NotificationReminderDeleted_22, self).__init__()
        self.Reminder = Reminder
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationReminderDeleted_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationReminderDeleted_22.subclass:
            return NotificationReminderDeleted_22.subclass(*args_, **kwargs_)
        else:
            return NotificationReminderDeleted_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Reminder(self): return self.Reminder
    def set_Reminder(self, Reminder): self.Reminder = Reminder
    def hasContent_(self):
        if (
            self.Reminder is not None or
            super(NotificationReminderDeleted_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationReminderDeleted_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Reminder':
            obj_ = Reminder_22.factory()
            obj_.build(child_)
            self.Reminder = obj_
            obj_.original_tagname_ = 'Reminder'
        super(NotificationReminderDeleted_22, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationReminderDeleted_22


class NotificationSignatureCreated_22(NotificationBase_22):
    member_data_items_ = {
        'Signature': MemberSpec_('Signature', 'Signature_20', 0),
    }
    subclass = None
    superclass = NotificationBase_22
    def __init__(self, Signature=None):
        self.original_tagname_ = None
        super(NotificationSignatureCreated_22, self).__init__()
        self.Signature = Signature
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationSignatureCreated_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationSignatureCreated_22.subclass:
            return NotificationSignatureCreated_22.subclass(*args_, **kwargs_)
        else:
            return NotificationSignatureCreated_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Signature(self): return self.Signature
    def set_Signature(self, Signature): self.Signature = Signature
    def hasContent_(self):
        if (
            self.Signature is not None or
            super(NotificationSignatureCreated_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationSignatureCreated_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Signature':
            obj_ = Signature_20.factory()
            obj_.build(child_)
            self.Signature = obj_
            obj_.original_tagname_ = 'Signature'
        super(NotificationSignatureCreated_22, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationSignatureCreated_22


class NotificationSignatureUpdated_22(NotificationBase_22):
    member_data_items_ = {
        'Signature': MemberSpec_('Signature', 'Signature_20', 0),
    }
    subclass = None
    superclass = NotificationBase_22
    def __init__(self, Signature=None):
        self.original_tagname_ = None
        super(NotificationSignatureUpdated_22, self).__init__()
        self.Signature = Signature
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationSignatureUpdated_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationSignatureUpdated_22.subclass:
            return NotificationSignatureUpdated_22.subclass(*args_, **kwargs_)
        else:
            return NotificationSignatureUpdated_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Signature(self): return self.Signature
    def set_Signature(self, Signature): self.Signature = Signature
    def hasContent_(self):
        if (
            self.Signature is not None or
            super(NotificationSignatureUpdated_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationSignatureUpdated_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Signature':
            obj_ = Signature_20.factory()
            obj_.build(child_)
            self.Signature = obj_
            obj_.original_tagname_ = 'Signature'
        super(NotificationSignatureUpdated_22, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationSignatureUpdated_22


class NotificationSignatureDeleted_22(NotificationBase_22):
    member_data_items_ = {
        'Signature': MemberSpec_('Signature', 'Signature_20', 0),
    }
    subclass = None
    superclass = NotificationBase_22
    def __init__(self, Signature=None):
        self.original_tagname_ = None
        super(NotificationSignatureDeleted_22, self).__init__()
        self.Signature = Signature
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationSignatureDeleted_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationSignatureDeleted_22.subclass:
            return NotificationSignatureDeleted_22.subclass(*args_, **kwargs_)
        else:
            return NotificationSignatureDeleted_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Signature(self): return self.Signature
    def set_Signature(self, Signature): self.Signature = Signature
    def hasContent_(self):
        if (
            self.Signature is not None or
            super(NotificationSignatureDeleted_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationSignatureDeleted_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Signature':
            obj_ = Signature_20.factory()
            obj_.build(child_)
            self.Signature = obj_
            obj_.original_tagname_ = 'Signature'
        super(NotificationSignatureDeleted_22, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationSignatureDeleted_22


class NotificationReminderDue_22(NotificationBase_22):
    member_data_items_ = {
    }
    subclass = None
    superclass = NotificationBase_22
    def __init__(self):
        self.original_tagname_ = None
        super(NotificationReminderDue_22, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationReminderDue_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationReminderDue_22.subclass:
            return NotificationReminderDue_22.subclass(*args_, **kwargs_)
        else:
            return NotificationReminderDue_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(NotificationReminderDue_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationReminderDue_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(NotificationReminderDue_22, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class NotificationReminderDue_22


class NotificationReminderListUpdated_22(NotificationBase_22):
    member_data_items_ = {
        'BadgeCountPending': MemberSpec_('BadgeCountPending', 'int', 0),
        'BadgeCountToday': MemberSpec_('BadgeCountToday', 'int', 0),
        'BadgeCountTomorrow': MemberSpec_('BadgeCountTomorrow', 'int', 0),
        'BadgeCountLater': MemberSpec_('BadgeCountLater', 'int', 0),
    }
    subclass = None
    superclass = NotificationBase_22
    def __init__(self, BadgeCountPending=None, BadgeCountToday=None, BadgeCountTomorrow=None, BadgeCountLater=None):
        self.original_tagname_ = None
        super(NotificationReminderListUpdated_22, self).__init__()
        self.BadgeCountPending = BadgeCountPending
        self.BadgeCountToday = BadgeCountToday
        self.BadgeCountTomorrow = BadgeCountTomorrow
        self.BadgeCountLater = BadgeCountLater
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationReminderListUpdated_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationReminderListUpdated_22.subclass:
            return NotificationReminderListUpdated_22.subclass(*args_, **kwargs_)
        else:
            return NotificationReminderListUpdated_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_BadgeCountPending(self): return self.BadgeCountPending
    def set_BadgeCountPending(self, BadgeCountPending): self.BadgeCountPending = BadgeCountPending
    def get_BadgeCountToday(self): return self.BadgeCountToday
    def set_BadgeCountToday(self, BadgeCountToday): self.BadgeCountToday = BadgeCountToday
    def get_BadgeCountTomorrow(self): return self.BadgeCountTomorrow
    def set_BadgeCountTomorrow(self, BadgeCountTomorrow): self.BadgeCountTomorrow = BadgeCountTomorrow
    def get_BadgeCountLater(self): return self.BadgeCountLater
    def set_BadgeCountLater(self, BadgeCountLater): self.BadgeCountLater = BadgeCountLater
    def hasContent_(self):
        if (
            self.BadgeCountPending is not None or
            self.BadgeCountToday is not None or
            self.BadgeCountTomorrow is not None or
            self.BadgeCountLater is not None or
            super(NotificationReminderListUpdated_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationReminderListUpdated_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'BadgeCountPending':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'BadgeCountPending')
            self.BadgeCountPending = ival_
        elif nodeName_ == 'BadgeCountToday':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'BadgeCountToday')
            self.BadgeCountToday = ival_
        elif nodeName_ == 'BadgeCountTomorrow':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'BadgeCountTomorrow')
            self.BadgeCountTomorrow = ival_
        elif nodeName_ == 'BadgeCountLater':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'BadgeCountLater')
            self.BadgeCountLater = ival_
        super(NotificationReminderListUpdated_22, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationReminderListUpdated_22


class ListOfNotificationsPage_20(GeneratedsSuper):
    member_data_items_ = {
        'LastNotificationId': MemberSpec_('LastNotificationId', 'string', 0),
        'NotificationListPage': MemberSpec_('NotificationListPage', 'ListOfNotifications_20', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, LastNotificationId=None, NotificationListPage=None, Paging=None):
        self.original_tagname_ = None
        self.LastNotificationId = LastNotificationId
        self.NotificationListPage = NotificationListPage
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfNotificationsPage_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfNotificationsPage_20.subclass:
            return ListOfNotificationsPage_20.subclass(*args_, **kwargs_)
        else:
            return ListOfNotificationsPage_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_LastNotificationId(self): return self.LastNotificationId
    def set_LastNotificationId(self, LastNotificationId): self.LastNotificationId = LastNotificationId
    def get_NotificationListPage(self): return self.NotificationListPage
    def set_NotificationListPage(self, NotificationListPage): self.NotificationListPage = NotificationListPage
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.LastNotificationId is not None or
            self.NotificationListPage is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'LastNotificationId':
            LastNotificationId_ = child_.text
            LastNotificationId_ = self.gds_validate_string(LastNotificationId_, node, 'LastNotificationId')
            self.LastNotificationId = LastNotificationId_
        elif nodeName_ == 'NotificationListPage':
            obj_ = ListOfNotifications_20.factory()
            obj_.build(child_)
            self.NotificationListPage = obj_
            obj_.original_tagname_ = 'NotificationListPage'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class ListOfNotificationsPage_20


class ListOfNotifications_20(GeneratedsSuper):
    member_data_items_ = {
        'Notification': MemberSpec_('Notification', 'NotificationBase_20', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Notification=None):
        self.original_tagname_ = None
        if Notification is None:
            self.Notification = []
        else:
            self.Notification = Notification
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfNotifications_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfNotifications_20.subclass:
            return ListOfNotifications_20.subclass(*args_, **kwargs_)
        else:
            return ListOfNotifications_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Notification(self): return self.Notification
    def set_Notification(self, Notification): self.Notification = Notification
    def add_Notification(self, value): self.Notification.append(value)
    def insert_Notification_at(self, index, value): self.Notification.insert(index, value)
    def replace_Notification_at(self, index, value): self.Notification[index] = value
    def hasContent_(self):
        if (
            self.Notification
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Notification':
            class_obj_ = self.get_class_obj_(child_, NotificationBase_20)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Notification.append(obj_)
            obj_.original_tagname_ = 'Notification'
# end class ListOfNotifications_20


class NotificationBase_20(GeneratedsSuper):
    member_data_items_ = {
        'Id': MemberSpec_('Id', 'string', 0),
        'Recipient': MemberSpec_('Recipient', 'User_14', 0),
        'TriggerList': MemberSpec_('TriggerList', 'ListOfNotificationTriggers_18', 0),
        'AlertMessage': MemberSpec_('AlertMessage', 'string', 0),
        'Sender': MemberSpec_('Sender', 'User_14', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Id=None, Recipient=None, TriggerList=None, AlertMessage=None, Sender=None):
        self.original_tagname_ = None
        self.Id = Id
        self.Recipient = Recipient
        self.TriggerList = TriggerList
        self.AlertMessage = AlertMessage
        self.Sender = Sender
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationBase_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationBase_20.subclass:
            return NotificationBase_20.subclass(*args_, **kwargs_)
        else:
            return NotificationBase_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Id(self): return self.Id
    def set_Id(self, Id): self.Id = Id
    def get_Recipient(self): return self.Recipient
    def set_Recipient(self, Recipient): self.Recipient = Recipient
    def get_TriggerList(self): return self.TriggerList
    def set_TriggerList(self, TriggerList): self.TriggerList = TriggerList
    def get_AlertMessage(self): return self.AlertMessage
    def set_AlertMessage(self, AlertMessage): self.AlertMessage = AlertMessage
    def get_Sender(self): return self.Sender
    def set_Sender(self, Sender): self.Sender = Sender
    def hasContent_(self):
        if (
            self.Id is not None or
            self.Recipient is not None or
            self.TriggerList is not None or
            self.AlertMessage is not None or
            self.Sender is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Id':
            Id_ = child_.text
            Id_ = self.gds_validate_string(Id_, node, 'Id')
            self.Id = Id_
        elif nodeName_ == 'Recipient':
            class_obj_ = self.get_class_obj_(child_, User_14)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Recipient = obj_
            obj_.original_tagname_ = 'Recipient'
        elif nodeName_ == 'TriggerList':
            obj_ = ListOfNotificationTriggers_18.factory()
            obj_.build(child_)
            self.TriggerList = obj_
            obj_.original_tagname_ = 'TriggerList'
        elif nodeName_ == 'AlertMessage':
            AlertMessage_ = child_.text
            AlertMessage_ = self.gds_validate_string(AlertMessage_, node, 'AlertMessage')
            self.AlertMessage = AlertMessage_
        elif nodeName_ == 'Sender':
            class_obj_ = self.get_class_obj_(child_, User_14)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Sender = obj_
            obj_.original_tagname_ = 'Sender'
# end class NotificationBase_20


class NotificationUserStreamUpdated_20(NotificationBase_20):
    member_data_items_ = {
        'Scope': MemberSpec_('Scope', 'string', 0),
        'StreamId': MemberSpec_('StreamId', 'string', 0),
    }
    subclass = None
    superclass = NotificationBase_20
    def __init__(self, Scope=None, StreamId=None):
        self.original_tagname_ = None
        super(NotificationUserStreamUpdated_20, self).__init__()
        self.Scope = Scope
        self.StreamId = StreamId
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationUserStreamUpdated_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationUserStreamUpdated_20.subclass:
            return NotificationUserStreamUpdated_20.subclass(*args_, **kwargs_)
        else:
            return NotificationUserStreamUpdated_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Scope(self): return self.Scope
    def set_Scope(self, Scope): self.Scope = Scope
    def get_StreamId(self): return self.StreamId
    def set_StreamId(self, StreamId): self.StreamId = StreamId
    def hasContent_(self):
        if (
            self.Scope is not None or
            self.StreamId is not None or
            super(NotificationUserStreamUpdated_20, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationUserStreamUpdated_20, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Scope':
            Scope_ = child_.text
            Scope_ = self.gds_validate_string(Scope_, node, 'Scope')
            self.Scope = Scope_
        elif nodeName_ == 'StreamId':
            StreamId_ = child_.text
            StreamId_ = self.gds_validate_string(StreamId_, node, 'StreamId')
            self.StreamId = StreamId_
        super(NotificationUserStreamUpdated_20, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationUserStreamUpdated_20


class NotificationUserTokenInvalid_20(NotificationBase_20):
    member_data_items_ = {
        'TokenProvider': MemberSpec_('TokenProvider', 'string', 0),
    }
    subclass = None
    superclass = NotificationBase_20
    def __init__(self, TokenProvider=None):
        self.original_tagname_ = None
        super(NotificationUserTokenInvalid_20, self).__init__()
        self.TokenProvider = TokenProvider
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationUserTokenInvalid_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationUserTokenInvalid_20.subclass:
            return NotificationUserTokenInvalid_20.subclass(*args_, **kwargs_)
        else:
            return NotificationUserTokenInvalid_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_TokenProvider(self): return self.TokenProvider
    def set_TokenProvider(self, TokenProvider): self.TokenProvider = TokenProvider
    def hasContent_(self):
        if (
            self.TokenProvider is not None or
            super(NotificationUserTokenInvalid_20, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationUserTokenInvalid_20, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'TokenProvider':
            TokenProvider_ = child_.text
            TokenProvider_ = self.gds_validate_string(TokenProvider_, node, 'TokenProvider')
            self.TokenProvider = TokenProvider_
        super(NotificationUserTokenInvalid_20, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationUserTokenInvalid_20


class NotificationOnboardingComplete_20(NotificationBase_20):
    member_data_items_ = {
    }
    subclass = None
    superclass = NotificationBase_20
    def __init__(self):
        self.original_tagname_ = None
        super(NotificationOnboardingComplete_20, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationOnboardingComplete_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationOnboardingComplete_20.subclass:
            return NotificationOnboardingComplete_20.subclass(*args_, **kwargs_)
        else:
            return NotificationOnboardingComplete_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(NotificationOnboardingComplete_20, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationOnboardingComplete_20, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(NotificationOnboardingComplete_20, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class NotificationOnboardingComplete_20


class NotificationPost_20(NotificationBase_20):
    member_data_items_ = {
        'Post': MemberSpec_('Post', 'Post_20', 0),
    }
    subclass = None
    superclass = NotificationBase_20
    def __init__(self, Post=None):
        self.original_tagname_ = None
        super(NotificationPost_20, self).__init__()
        self.Post = Post
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationPost_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationPost_20.subclass:
            return NotificationPost_20.subclass(*args_, **kwargs_)
        else:
            return NotificationPost_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Post(self): return self.Post
    def set_Post(self, Post): self.Post = Post
    def hasContent_(self):
        if (
            self.Post is not None or
            super(NotificationPost_20, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationPost_20, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Post':
            class_obj_ = self.get_class_obj_(child_, Post_20)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Post = obj_
            obj_.original_tagname_ = 'Post'
        super(NotificationPost_20, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationPost_20


class NotificationUserStatusChange_20(NotificationBase_20):
    member_data_items_ = {
        'OnlineStatus': MemberSpec_('OnlineStatus', 'string', 0),
        'LastActivityAt': MemberSpec_('LastActivityAt', 'dateTime', 0),
    }
    subclass = None
    superclass = NotificationBase_20
    def __init__(self, OnlineStatus=None, LastActivityAt=None):
        self.original_tagname_ = None
        super(NotificationUserStatusChange_20, self).__init__()
        self.OnlineStatus = OnlineStatus
        if isinstance(LastActivityAt, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(LastActivityAt, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = LastActivityAt
        self.LastActivityAt = initvalue_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationUserStatusChange_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationUserStatusChange_20.subclass:
            return NotificationUserStatusChange_20.subclass(*args_, **kwargs_)
        else:
            return NotificationUserStatusChange_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_OnlineStatus(self): return self.OnlineStatus
    def set_OnlineStatus(self, OnlineStatus): self.OnlineStatus = OnlineStatus
    def get_LastActivityAt(self): return self.LastActivityAt
    def set_LastActivityAt(self, LastActivityAt): self.LastActivityAt = LastActivityAt
    def hasContent_(self):
        if (
            self.OnlineStatus is not None or
            self.LastActivityAt is not None or
            super(NotificationUserStatusChange_20, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationUserStatusChange_20, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'OnlineStatus':
            OnlineStatus_ = child_.text
            OnlineStatus_ = self.gds_validate_string(OnlineStatus_, node, 'OnlineStatus')
            self.OnlineStatus = OnlineStatus_
        elif nodeName_ == 'LastActivityAt':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.LastActivityAt = dval_
        super(NotificationUserStatusChange_20, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationUserStatusChange_20


class NotificationAssistantNudge_20(NotificationBase_20):
    member_data_items_ = {
        'ShowAssistant': MemberSpec_('ShowAssistant', 'boolean', 0),
    }
    subclass = None
    superclass = NotificationBase_20
    def __init__(self, ShowAssistant=None):
        self.original_tagname_ = None
        super(NotificationAssistantNudge_20, self).__init__()
        self.ShowAssistant = ShowAssistant
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationAssistantNudge_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationAssistantNudge_20.subclass:
            return NotificationAssistantNudge_20.subclass(*args_, **kwargs_)
        else:
            return NotificationAssistantNudge_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ShowAssistant(self): return self.ShowAssistant
    def set_ShowAssistant(self, ShowAssistant): self.ShowAssistant = ShowAssistant
    def hasContent_(self):
        if (
            self.ShowAssistant is not None or
            super(NotificationAssistantNudge_20, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationAssistantNudge_20, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ShowAssistant':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'ShowAssistant')
            self.ShowAssistant = ival_
        super(NotificationAssistantNudge_20, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationAssistantNudge_20


class NotificationActionListUpdated_20(NotificationBase_20):
    member_data_items_ = {
    }
    subclass = None
    superclass = NotificationBase_20
    def __init__(self):
        self.original_tagname_ = None
        super(NotificationActionListUpdated_20, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationActionListUpdated_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationActionListUpdated_20.subclass:
            return NotificationActionListUpdated_20.subclass(*args_, **kwargs_)
        else:
            return NotificationActionListUpdated_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(NotificationActionListUpdated_20, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationActionListUpdated_20, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(NotificationActionListUpdated_20, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class NotificationActionListUpdated_20


class NotificationActionListUpdatedLast_20(NotificationBase_20):
    member_data_items_ = {
        'ActionableResourceId': MemberSpec_('ActionableResourceId', 'string', 0),
        'Read': MemberSpec_('Read', 'boolean', 0),
    }
    subclass = None
    superclass = NotificationBase_20
    def __init__(self, ActionableResourceId=None, Read=None):
        self.original_tagname_ = None
        super(NotificationActionListUpdatedLast_20, self).__init__()
        self.ActionableResourceId = ActionableResourceId
        self.Read = Read
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationActionListUpdatedLast_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationActionListUpdatedLast_20.subclass:
            return NotificationActionListUpdatedLast_20.subclass(*args_, **kwargs_)
        else:
            return NotificationActionListUpdatedLast_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ActionableResourceId(self): return self.ActionableResourceId
    def set_ActionableResourceId(self, ActionableResourceId): self.ActionableResourceId = ActionableResourceId
    def get_Read(self): return self.Read
    def set_Read(self, Read): self.Read = Read
    def hasContent_(self):
        if (
            self.ActionableResourceId is not None or
            self.Read is not None or
            super(NotificationActionListUpdatedLast_20, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationActionListUpdatedLast_20, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ActionableResourceId':
            ActionableResourceId_ = child_.text
            ActionableResourceId_ = self.gds_validate_string(ActionableResourceId_, node, 'ActionableResourceId')
            self.ActionableResourceId = ActionableResourceId_
        elif nodeName_ == 'Read':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'Read')
            self.Read = ival_
        super(NotificationActionListUpdatedLast_20, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationActionListUpdatedLast_20


class ListOfNotificationsPage_15(GeneratedsSuper):
    member_data_items_ = {
        'LastNotificationId': MemberSpec_('LastNotificationId', 'string', 0),
        'NotificationListPage': MemberSpec_('NotificationListPage', 'ListOfNotifications_15', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, LastNotificationId=None, NotificationListPage=None, Paging=None):
        self.original_tagname_ = None
        self.LastNotificationId = LastNotificationId
        self.NotificationListPage = NotificationListPage
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfNotificationsPage_15)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfNotificationsPage_15.subclass:
            return ListOfNotificationsPage_15.subclass(*args_, **kwargs_)
        else:
            return ListOfNotificationsPage_15(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_LastNotificationId(self): return self.LastNotificationId
    def set_LastNotificationId(self, LastNotificationId): self.LastNotificationId = LastNotificationId
    def get_NotificationListPage(self): return self.NotificationListPage
    def set_NotificationListPage(self, NotificationListPage): self.NotificationListPage = NotificationListPage
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.LastNotificationId is not None or
            self.NotificationListPage is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'LastNotificationId':
            LastNotificationId_ = child_.text
            LastNotificationId_ = self.gds_validate_string(LastNotificationId_, node, 'LastNotificationId')
            self.LastNotificationId = LastNotificationId_
        elif nodeName_ == 'NotificationListPage':
            obj_ = ListOfNotifications_15.factory()
            obj_.build(child_)
            self.NotificationListPage = obj_
            obj_.original_tagname_ = 'NotificationListPage'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class ListOfNotificationsPage_15


class ListOfNotifications_15(GeneratedsSuper):
    member_data_items_ = {
        'Notification': MemberSpec_('Notification', 'NotificationBase_15', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Notification=None):
        self.original_tagname_ = None
        if Notification is None:
            self.Notification = []
        else:
            self.Notification = Notification
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfNotifications_15)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfNotifications_15.subclass:
            return ListOfNotifications_15.subclass(*args_, **kwargs_)
        else:
            return ListOfNotifications_15(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Notification(self): return self.Notification
    def set_Notification(self, Notification): self.Notification = Notification
    def add_Notification(self, value): self.Notification.append(value)
    def insert_Notification_at(self, index, value): self.Notification.insert(index, value)
    def replace_Notification_at(self, index, value): self.Notification[index] = value
    def hasContent_(self):
        if (
            self.Notification
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Notification':
            class_obj_ = self.get_class_obj_(child_, NotificationBase_15)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Notification.append(obj_)
            obj_.original_tagname_ = 'Notification'
# end class ListOfNotifications_15


class NotificationBase_15(GeneratedsSuper):
    member_data_items_ = {
        'Id': MemberSpec_('Id', 'string', 0),
        'Recipient': MemberSpec_('Recipient', 'User_14', 0),
        'TriggerList': MemberSpec_('TriggerList', 'ListOfNotificationTriggers_18', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Id=None, Recipient=None, TriggerList=None):
        self.original_tagname_ = None
        self.Id = Id
        self.Recipient = Recipient
        self.TriggerList = TriggerList
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationBase_15)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationBase_15.subclass:
            return NotificationBase_15.subclass(*args_, **kwargs_)
        else:
            return NotificationBase_15(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Id(self): return self.Id
    def set_Id(self, Id): self.Id = Id
    def get_Recipient(self): return self.Recipient
    def set_Recipient(self, Recipient): self.Recipient = Recipient
    def get_TriggerList(self): return self.TriggerList
    def set_TriggerList(self, TriggerList): self.TriggerList = TriggerList
    def hasContent_(self):
        if (
            self.Id is not None or
            self.Recipient is not None or
            self.TriggerList is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Id':
            Id_ = child_.text
            Id_ = self.gds_validate_string(Id_, node, 'Id')
            self.Id = Id_
        elif nodeName_ == 'Recipient':
            class_obj_ = self.get_class_obj_(child_, User_14)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Recipient = obj_
            obj_.original_tagname_ = 'Recipient'
        elif nodeName_ == 'TriggerList':
            obj_ = ListOfNotificationTriggers_18.factory()
            obj_.build(child_)
            self.TriggerList = obj_
            obj_.original_tagname_ = 'TriggerList'
# end class NotificationBase_15


class NotificationUserStreamUpdated_15(NotificationBase_15):
    member_data_items_ = {
        'Scope': MemberSpec_('Scope', 'string', 0),
        'StreamId': MemberSpec_('StreamId', 'string', 0),
    }
    subclass = None
    superclass = NotificationBase_15
    def __init__(self, Scope=None, StreamId=None):
        self.original_tagname_ = None
        super(NotificationUserStreamUpdated_15, self).__init__()
        self.Scope = Scope
        self.StreamId = StreamId
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationUserStreamUpdated_15)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationUserStreamUpdated_15.subclass:
            return NotificationUserStreamUpdated_15.subclass(*args_, **kwargs_)
        else:
            return NotificationUserStreamUpdated_15(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Scope(self): return self.Scope
    def set_Scope(self, Scope): self.Scope = Scope
    def get_StreamId(self): return self.StreamId
    def set_StreamId(self, StreamId): self.StreamId = StreamId
    def hasContent_(self):
        if (
            self.Scope is not None or
            self.StreamId is not None or
            super(NotificationUserStreamUpdated_15, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationUserStreamUpdated_15, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Scope':
            Scope_ = child_.text
            Scope_ = self.gds_validate_string(Scope_, node, 'Scope')
            self.Scope = Scope_
        elif nodeName_ == 'StreamId':
            StreamId_ = child_.text
            StreamId_ = self.gds_validate_string(StreamId_, node, 'StreamId')
            self.StreamId = StreamId_
        super(NotificationUserStreamUpdated_15, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationUserStreamUpdated_15


class NotificationUserTokenInvalid_15(NotificationBase_15):
    member_data_items_ = {
        'TokenProvider': MemberSpec_('TokenProvider', 'string', 0),
    }
    subclass = None
    superclass = NotificationBase_15
    def __init__(self, TokenProvider=None):
        self.original_tagname_ = None
        super(NotificationUserTokenInvalid_15, self).__init__()
        self.TokenProvider = TokenProvider
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationUserTokenInvalid_15)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationUserTokenInvalid_15.subclass:
            return NotificationUserTokenInvalid_15.subclass(*args_, **kwargs_)
        else:
            return NotificationUserTokenInvalid_15(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_TokenProvider(self): return self.TokenProvider
    def set_TokenProvider(self, TokenProvider): self.TokenProvider = TokenProvider
    def hasContent_(self):
        if (
            self.TokenProvider is not None or
            super(NotificationUserTokenInvalid_15, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationUserTokenInvalid_15, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'TokenProvider':
            TokenProvider_ = child_.text
            TokenProvider_ = self.gds_validate_string(TokenProvider_, node, 'TokenProvider')
            self.TokenProvider = TokenProvider_
        super(NotificationUserTokenInvalid_15, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationUserTokenInvalid_15


class NotificationOnboardingComplete_15(NotificationBase_15):
    member_data_items_ = {
    }
    subclass = None
    superclass = NotificationBase_15
    def __init__(self):
        self.original_tagname_ = None
        super(NotificationOnboardingComplete_15, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationOnboardingComplete_15)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationOnboardingComplete_15.subclass:
            return NotificationOnboardingComplete_15.subclass(*args_, **kwargs_)
        else:
            return NotificationOnboardingComplete_15(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(NotificationOnboardingComplete_15, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationOnboardingComplete_15, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(NotificationOnboardingComplete_15, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class NotificationOnboardingComplete_15


class Notification_15(NotificationBase_15):
    member_data_items_ = {
        'Sender': MemberSpec_('Sender', 'User_14', 0),
        'ActionMessage': MemberSpec_('ActionMessage', 'string', 0),
        'ActionComment': MemberSpec_('ActionComment', 'string', 0),
    }
    subclass = None
    superclass = NotificationBase_15
    def __init__(self, Sender=None, ActionMessage=None, ActionComment=None):
        self.original_tagname_ = None
        super(Notification_15, self).__init__()
        self.Sender = Sender
        self.ActionMessage = ActionMessage
        self.ActionComment = ActionComment
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Notification_15)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Notification_15.subclass:
            return Notification_15.subclass(*args_, **kwargs_)
        else:
            return Notification_15(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Sender(self): return self.Sender
    def set_Sender(self, Sender): self.Sender = Sender
    def get_ActionMessage(self): return self.ActionMessage
    def set_ActionMessage(self, ActionMessage): self.ActionMessage = ActionMessage
    def get_ActionComment(self): return self.ActionComment
    def set_ActionComment(self, ActionComment): self.ActionComment = ActionComment
    def hasContent_(self):
        if (
            self.Sender is not None or
            self.ActionMessage is not None or
            self.ActionComment is not None or
            super(Notification_15, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Notification_15, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Sender':
            class_obj_ = self.get_class_obj_(child_, User_14)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Sender = obj_
            obj_.original_tagname_ = 'Sender'
        elif nodeName_ == 'ActionMessage':
            ActionMessage_ = child_.text
            ActionMessage_ = self.gds_validate_string(ActionMessage_, node, 'ActionMessage')
            self.ActionMessage = ActionMessage_
        elif nodeName_ == 'ActionComment':
            ActionComment_ = child_.text
            ActionComment_ = self.gds_validate_string(ActionComment_, node, 'ActionComment')
            self.ActionComment = ActionComment_
        super(Notification_15, self).buildChildren(child_, node, nodeName_, True)
# end class Notification_15


class NotificationPost_15(Notification_15):
    member_data_items_ = {
        'Post': MemberSpec_('Post', 'Post_18', 0),
        'PostId': MemberSpec_('PostId', 'string', 0),
        'StreamId': MemberSpec_('StreamId', 'string', 0),
        'ClientResourceId': MemberSpec_('ClientResourceId', 'string', 0),
    }
    subclass = None
    superclass = Notification_15
    def __init__(self, Post=None, PostId=None, StreamId=None, ClientResourceId=None):
        self.original_tagname_ = None
        super(NotificationPost_15, self).__init__()
        self.Post = Post
        self.PostId = PostId
        self.StreamId = StreamId
        self.ClientResourceId = ClientResourceId
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationPost_15)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationPost_15.subclass:
            return NotificationPost_15.subclass(*args_, **kwargs_)
        else:
            return NotificationPost_15(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Post(self): return self.Post
    def set_Post(self, Post): self.Post = Post
    def get_PostId(self): return self.PostId
    def set_PostId(self, PostId): self.PostId = PostId
    def get_StreamId(self): return self.StreamId
    def set_StreamId(self, StreamId): self.StreamId = StreamId
    def get_ClientResourceId(self): return self.ClientResourceId
    def set_ClientResourceId(self, ClientResourceId): self.ClientResourceId = ClientResourceId
    def hasContent_(self):
        if (
            self.Post is not None or
            self.PostId is not None or
            self.StreamId is not None or
            self.ClientResourceId is not None or
            super(NotificationPost_15, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationPost_15, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Post':
            obj_ = Post_18.factory()
            obj_.build(child_)
            self.Post = obj_
            obj_.original_tagname_ = 'Post'
        elif nodeName_ == 'PostId':
            PostId_ = child_.text
            PostId_ = self.gds_validate_string(PostId_, node, 'PostId')
            self.PostId = PostId_
        elif nodeName_ == 'StreamId':
            StreamId_ = child_.text
            StreamId_ = self.gds_validate_string(StreamId_, node, 'StreamId')
            self.StreamId = StreamId_
        elif nodeName_ == 'ClientResourceId':
            ClientResourceId_ = child_.text
            ClientResourceId_ = self.gds_validate_string(ClientResourceId_, node, 'ClientResourceId')
            self.ClientResourceId = ClientResourceId_
        super(NotificationPost_15, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationPost_15


class NotificationActionListUpdated_18(Notification_15):
    member_data_items_ = {
    }
    subclass = None
    superclass = Notification_15
    def __init__(self):
        self.original_tagname_ = None
        super(NotificationActionListUpdated_18, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationActionListUpdated_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationActionListUpdated_18.subclass:
            return NotificationActionListUpdated_18.subclass(*args_, **kwargs_)
        else:
            return NotificationActionListUpdated_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(NotificationActionListUpdated_18, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationActionListUpdated_18, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(NotificationActionListUpdated_18, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class NotificationActionListUpdated_18


class NotificationActionListUpdatedLast_18(Notification_15):
    member_data_items_ = {
        'ActionableResourceId': MemberSpec_('ActionableResourceId', 'string', 0),
        'Read': MemberSpec_('Read', 'boolean', 0),
    }
    subclass = None
    superclass = Notification_15
    def __init__(self, ActionableResourceId=None, Read=None):
        self.original_tagname_ = None
        super(NotificationActionListUpdatedLast_18, self).__init__()
        self.ActionableResourceId = ActionableResourceId
        self.Read = Read
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationActionListUpdatedLast_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationActionListUpdatedLast_18.subclass:
            return NotificationActionListUpdatedLast_18.subclass(*args_, **kwargs_)
        else:
            return NotificationActionListUpdatedLast_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ActionableResourceId(self): return self.ActionableResourceId
    def set_ActionableResourceId(self, ActionableResourceId): self.ActionableResourceId = ActionableResourceId
    def get_Read(self): return self.Read
    def set_Read(self, Read): self.Read = Read
    def hasContent_(self):
        if (
            self.ActionableResourceId is not None or
            self.Read is not None or
            super(NotificationActionListUpdatedLast_18, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationActionListUpdatedLast_18, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ActionableResourceId':
            ActionableResourceId_ = child_.text
            ActionableResourceId_ = self.gds_validate_string(ActionableResourceId_, node, 'ActionableResourceId')
            self.ActionableResourceId = ActionableResourceId_
        elif nodeName_ == 'Read':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'Read')
            self.Read = ival_
        super(NotificationActionListUpdatedLast_18, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationActionListUpdatedLast_18


class NotificationUserStatusChange_18(Notification_15):
    member_data_items_ = {
        'OnlineStatus': MemberSpec_('OnlineStatus', 'string', 0),
        'LastActivityAt': MemberSpec_('LastActivityAt', 'dateTime', 0),
    }
    subclass = None
    superclass = Notification_15
    def __init__(self, OnlineStatus=None, LastActivityAt=None):
        self.original_tagname_ = None
        super(NotificationUserStatusChange_18, self).__init__()
        self.OnlineStatus = OnlineStatus
        if isinstance(LastActivityAt, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(LastActivityAt, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = LastActivityAt
        self.LastActivityAt = initvalue_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NotificationUserStatusChange_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NotificationUserStatusChange_18.subclass:
            return NotificationUserStatusChange_18.subclass(*args_, **kwargs_)
        else:
            return NotificationUserStatusChange_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_OnlineStatus(self): return self.OnlineStatus
    def set_OnlineStatus(self, OnlineStatus): self.OnlineStatus = OnlineStatus
    def get_LastActivityAt(self): return self.LastActivityAt
    def set_LastActivityAt(self, LastActivityAt): self.LastActivityAt = LastActivityAt
    def hasContent_(self):
        if (
            self.OnlineStatus is not None or
            self.LastActivityAt is not None or
            super(NotificationUserStatusChange_18, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NotificationUserStatusChange_18, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'OnlineStatus':
            OnlineStatus_ = child_.text
            OnlineStatus_ = self.gds_validate_string(OnlineStatus_, node, 'OnlineStatus')
            self.OnlineStatus = OnlineStatus_
        elif nodeName_ == 'LastActivityAt':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.LastActivityAt = dval_
        super(NotificationUserStatusChange_18, self).buildChildren(child_, node, nodeName_, True)
# end class NotificationUserStatusChange_18


class ListOfStreamsPage_22(GeneratedsSuper):
    member_data_items_ = {
        'StreamList': MemberSpec_('StreamList', 'ListOfStreams_22', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, StreamList=None, Paging=None):
        self.original_tagname_ = None
        self.StreamList = StreamList
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfStreamsPage_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfStreamsPage_22.subclass:
            return ListOfStreamsPage_22.subclass(*args_, **kwargs_)
        else:
            return ListOfStreamsPage_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_StreamList(self): return self.StreamList
    def set_StreamList(self, StreamList): self.StreamList = StreamList
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.StreamList is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'StreamList':
            obj_ = ListOfStreams_22.factory()
            obj_.build(child_)
            self.StreamList = obj_
            obj_.original_tagname_ = 'StreamList'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class ListOfStreamsPage_22


class ListOfStreams_22(GeneratedsSuper):
    member_data_items_ = {
        'Discussion': MemberSpec_('Discussion', 'StreamBase_22', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Discussion=None):
        self.original_tagname_ = None
        if Discussion is None:
            self.Discussion = []
        else:
            self.Discussion = Discussion
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfStreams_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfStreams_22.subclass:
            return ListOfStreams_22.subclass(*args_, **kwargs_)
        else:
            return ListOfStreams_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Discussion(self): return self.Discussion
    def set_Discussion(self, Discussion): self.Discussion = Discussion
    def add_Discussion(self, value): self.Discussion.append(value)
    def insert_Discussion_at(self, index, value): self.Discussion.insert(index, value)
    def replace_Discussion_at(self, index, value): self.Discussion[index] = value
    def hasContent_(self):
        if (
            self.Discussion
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Discussion':
            class_obj_ = self.get_class_obj_(child_, StreamBase_22)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Discussion.append(obj_)
            obj_.original_tagname_ = 'Discussion'
# end class ListOfStreams_22


class StreamVisibility_22(GeneratedsSuper):
    member_data_items_ = {
        'IsVisible': MemberSpec_('IsVisible', 'boolean', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, IsVisible=None):
        self.original_tagname_ = None
        self.IsVisible = IsVisible
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StreamVisibility_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StreamVisibility_22.subclass:
            return StreamVisibility_22.subclass(*args_, **kwargs_)
        else:
            return StreamVisibility_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_IsVisible(self): return self.IsVisible
    def set_IsVisible(self, IsVisible): self.IsVisible = IsVisible
    def hasContent_(self):
        if (
            self.IsVisible is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'IsVisible':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsVisible')
            self.IsVisible = ival_
# end class StreamVisibility_22


class StreamName_22(GeneratedsSuper):
    member_data_items_ = {
        'StreamName': MemberSpec_('StreamName', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, StreamName=None):
        self.original_tagname_ = None
        self.StreamName = StreamName
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StreamName_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StreamName_22.subclass:
            return StreamName_22.subclass(*args_, **kwargs_)
        else:
            return StreamName_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_StreamName(self): return self.StreamName
    def set_StreamName(self, StreamName): self.StreamName = StreamName
    def hasContent_(self):
        if (
            self.StreamName is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'StreamName':
            StreamName_ = child_.text
            StreamName_ = self.gds_validate_string(StreamName_, node, 'StreamName')
            self.StreamName = StreamName_
# end class StreamName_22


class Menu_22(GeneratedsSuper):
    member_data_items_ = {
        'StreamListPage': MemberSpec_('StreamListPage', 'ListOfStreamsPage_22', 0),
        'BadgeCountTotal': MemberSpec_('BadgeCountTotal', 'integer', 0),
        'HasUnreadItems': MemberSpec_('HasUnreadItems', 'boolean', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, StreamListPage=None, BadgeCountTotal=None, HasUnreadItems=None):
        self.original_tagname_ = None
        self.StreamListPage = StreamListPage
        self.BadgeCountTotal = BadgeCountTotal
        self.HasUnreadItems = HasUnreadItems
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Menu_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Menu_22.subclass:
            return Menu_22.subclass(*args_, **kwargs_)
        else:
            return Menu_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_StreamListPage(self): return self.StreamListPage
    def set_StreamListPage(self, StreamListPage): self.StreamListPage = StreamListPage
    def get_BadgeCountTotal(self): return self.BadgeCountTotal
    def set_BadgeCountTotal(self, BadgeCountTotal): self.BadgeCountTotal = BadgeCountTotal
    def get_HasUnreadItems(self): return self.HasUnreadItems
    def set_HasUnreadItems(self, HasUnreadItems): self.HasUnreadItems = HasUnreadItems
    def hasContent_(self):
        if (
            self.StreamListPage is not None or
            self.BadgeCountTotal is not None or
            self.HasUnreadItems is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'StreamListPage':
            obj_ = ListOfStreamsPage_22.factory()
            obj_.build(child_)
            self.StreamListPage = obj_
            obj_.original_tagname_ = 'StreamListPage'
        elif nodeName_ == 'BadgeCountTotal':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'BadgeCountTotal')
            self.BadgeCountTotal = ival_
        elif nodeName_ == 'HasUnreadItems':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'HasUnreadItems')
            self.HasUnreadItems = ival_
# end class Menu_22


class Menu_21(GeneratedsSuper):
    member_data_items_ = {
        'MenuItemList': MemberSpec_('MenuItemList', 'ListOfMenutItems_21', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
        'BadgeCountTotal': MemberSpec_('BadgeCountTotal', 'int', 0),
        'HasUnreadItems': MemberSpec_('HasUnreadItems', 'boolean', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, MenuItemList=None, Paging=None, BadgeCountTotal=None, HasUnreadItems=None):
        self.original_tagname_ = None
        self.MenuItemList = MenuItemList
        self.Paging = Paging
        self.BadgeCountTotal = BadgeCountTotal
        self.HasUnreadItems = HasUnreadItems
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Menu_21)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Menu_21.subclass:
            return Menu_21.subclass(*args_, **kwargs_)
        else:
            return Menu_21(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_MenuItemList(self): return self.MenuItemList
    def set_MenuItemList(self, MenuItemList): self.MenuItemList = MenuItemList
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def get_BadgeCountTotal(self): return self.BadgeCountTotal
    def set_BadgeCountTotal(self, BadgeCountTotal): self.BadgeCountTotal = BadgeCountTotal
    def get_HasUnreadItems(self): return self.HasUnreadItems
    def set_HasUnreadItems(self, HasUnreadItems): self.HasUnreadItems = HasUnreadItems
    def hasContent_(self):
        if (
            self.MenuItemList is not None or
            self.Paging is not None or
            self.BadgeCountTotal is not None or
            self.HasUnreadItems is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'MenuItemList':
            obj_ = ListOfMenutItems_21.factory()
            obj_.build(child_)
            self.MenuItemList = obj_
            obj_.original_tagname_ = 'MenuItemList'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
        elif nodeName_ == 'BadgeCountTotal':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'BadgeCountTotal')
            self.BadgeCountTotal = ival_
        elif nodeName_ == 'HasUnreadItems':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'HasUnreadItems')
            self.HasUnreadItems = ival_
# end class Menu_21


class ListOfMenutItems_21(GeneratedsSuper):
    member_data_items_ = {
        'MenuItem': MemberSpec_('MenuItem', 'MenuItem_21', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, MenuItem=None):
        self.original_tagname_ = None
        if MenuItem is None:
            self.MenuItem = []
        else:
            self.MenuItem = MenuItem
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfMenutItems_21)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfMenutItems_21.subclass:
            return ListOfMenutItems_21.subclass(*args_, **kwargs_)
        else:
            return ListOfMenutItems_21(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_MenuItem(self): return self.MenuItem
    def set_MenuItem(self, MenuItem): self.MenuItem = MenuItem
    def add_MenuItem(self, value): self.MenuItem.append(value)
    def insert_MenuItem_at(self, index, value): self.MenuItem.insert(index, value)
    def replace_MenuItem_at(self, index, value): self.MenuItem[index] = value
    def hasContent_(self):
        if (
            self.MenuItem
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'MenuItem':
            obj_ = MenuItem_21.factory()
            obj_.build(child_)
            self.MenuItem.append(obj_)
            obj_.original_tagname_ = 'MenuItem'
# end class ListOfMenutItems_21


class MenuItem_21(GeneratedsSuper):
    member_data_items_ = {
        'Resource': MemberSpec_('Resource', 'ResourceBase_13', 0),
        'LastPost': MemberSpec_('LastPost', 'Post_20', 0),
        'LastUnreadPost': MemberSpec_('LastUnreadPost', 'Post_20', 0),
        'OldestUnreadPost': MemberSpec_('OldestUnreadPost', 'Post_20', 0),
        'BadgeCount': MemberSpec_('BadgeCount', 'integer', 0),
        'BadgeCountCardStream': MemberSpec_('BadgeCountCardStream', 'integer', 0),
        'BadgeCountChatStream': MemberSpec_('BadgeCountChatStream', 'integer', 0),
        'Modified': MemberSpec_('Modified', 'dateTime', 0),
        'SortModified': MemberSpec_('SortModified', 'dateTime', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Resource=None, LastPost=None, LastUnreadPost=None, OldestUnreadPost=None, BadgeCount=None, BadgeCountCardStream=None, BadgeCountChatStream=None, Modified=None, SortModified=None):
        self.original_tagname_ = None
        self.Resource = Resource
        self.LastPost = LastPost
        self.LastUnreadPost = LastUnreadPost
        self.OldestUnreadPost = OldestUnreadPost
        self.BadgeCount = BadgeCount
        self.BadgeCountCardStream = BadgeCountCardStream
        self.BadgeCountChatStream = BadgeCountChatStream
        if isinstance(Modified, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(Modified, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = Modified
        self.Modified = initvalue_
        if isinstance(SortModified, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(SortModified, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = SortModified
        self.SortModified = initvalue_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, MenuItem_21)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if MenuItem_21.subclass:
            return MenuItem_21.subclass(*args_, **kwargs_)
        else:
            return MenuItem_21(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Resource(self): return self.Resource
    def set_Resource(self, Resource): self.Resource = Resource
    def get_LastPost(self): return self.LastPost
    def set_LastPost(self, LastPost): self.LastPost = LastPost
    def get_LastUnreadPost(self): return self.LastUnreadPost
    def set_LastUnreadPost(self, LastUnreadPost): self.LastUnreadPost = LastUnreadPost
    def get_OldestUnreadPost(self): return self.OldestUnreadPost
    def set_OldestUnreadPost(self, OldestUnreadPost): self.OldestUnreadPost = OldestUnreadPost
    def get_BadgeCount(self): return self.BadgeCount
    def set_BadgeCount(self, BadgeCount): self.BadgeCount = BadgeCount
    def get_BadgeCountCardStream(self): return self.BadgeCountCardStream
    def set_BadgeCountCardStream(self, BadgeCountCardStream): self.BadgeCountCardStream = BadgeCountCardStream
    def get_BadgeCountChatStream(self): return self.BadgeCountChatStream
    def set_BadgeCountChatStream(self, BadgeCountChatStream): self.BadgeCountChatStream = BadgeCountChatStream
    def get_Modified(self): return self.Modified
    def set_Modified(self, Modified): self.Modified = Modified
    def get_SortModified(self): return self.SortModified
    def set_SortModified(self, SortModified): self.SortModified = SortModified
    def hasContent_(self):
        if (
            self.Resource is not None or
            self.LastPost is not None or
            self.LastUnreadPost is not None or
            self.OldestUnreadPost is not None or
            self.BadgeCount is not None or
            self.BadgeCountCardStream is not None or
            self.BadgeCountChatStream is not None or
            self.Modified is not None or
            self.SortModified is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Resource':
            class_obj_ = self.get_class_obj_(child_, ResourceBase_13)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Resource = obj_
            obj_.original_tagname_ = 'Resource'
        elif nodeName_ == 'LastPost':
            class_obj_ = self.get_class_obj_(child_, Post_20)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.LastPost = obj_
            obj_.original_tagname_ = 'LastPost'
        elif nodeName_ == 'LastUnreadPost':
            class_obj_ = self.get_class_obj_(child_, Post_20)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.LastUnreadPost = obj_
            obj_.original_tagname_ = 'LastUnreadPost'
        elif nodeName_ == 'OldestUnreadPost':
            class_obj_ = self.get_class_obj_(child_, Post_20)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.OldestUnreadPost = obj_
            obj_.original_tagname_ = 'OldestUnreadPost'
        elif nodeName_ == 'BadgeCount':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'BadgeCount')
            self.BadgeCount = ival_
        elif nodeName_ == 'BadgeCountCardStream':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'BadgeCountCardStream')
            self.BadgeCountCardStream = ival_
        elif nodeName_ == 'BadgeCountChatStream':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'BadgeCountChatStream')
            self.BadgeCountChatStream = ival_
        elif nodeName_ == 'Modified':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.Modified = dval_
        elif nodeName_ == 'SortModified':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.SortModified = dval_
# end class MenuItem_21


class Menu_20(GeneratedsSuper):
    member_data_items_ = {
        'MenuItemList': MemberSpec_('MenuItemList', 'ListOfMenutItems_20', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
        'BadgeCountTotal': MemberSpec_('BadgeCountTotal', 'int', 0),
        'HasUnreadItems': MemberSpec_('HasUnreadItems', 'boolean', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, MenuItemList=None, Paging=None, BadgeCountTotal=None, HasUnreadItems=None):
        self.original_tagname_ = None
        self.MenuItemList = MenuItemList
        self.Paging = Paging
        self.BadgeCountTotal = BadgeCountTotal
        self.HasUnreadItems = HasUnreadItems
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Menu_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Menu_20.subclass:
            return Menu_20.subclass(*args_, **kwargs_)
        else:
            return Menu_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_MenuItemList(self): return self.MenuItemList
    def set_MenuItemList(self, MenuItemList): self.MenuItemList = MenuItemList
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def get_BadgeCountTotal(self): return self.BadgeCountTotal
    def set_BadgeCountTotal(self, BadgeCountTotal): self.BadgeCountTotal = BadgeCountTotal
    def get_HasUnreadItems(self): return self.HasUnreadItems
    def set_HasUnreadItems(self, HasUnreadItems): self.HasUnreadItems = HasUnreadItems
    def hasContent_(self):
        if (
            self.MenuItemList is not None or
            self.Paging is not None or
            self.BadgeCountTotal is not None or
            self.HasUnreadItems is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'MenuItemList':
            obj_ = ListOfMenutItems_20.factory()
            obj_.build(child_)
            self.MenuItemList = obj_
            obj_.original_tagname_ = 'MenuItemList'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
        elif nodeName_ == 'BadgeCountTotal':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'BadgeCountTotal')
            self.BadgeCountTotal = ival_
        elif nodeName_ == 'HasUnreadItems':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'HasUnreadItems')
            self.HasUnreadItems = ival_
# end class Menu_20


class ListOfMenutItems_20(GeneratedsSuper):
    member_data_items_ = {
        'MenuItem': MemberSpec_('MenuItem', 'MenuItem_20', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, MenuItem=None):
        self.original_tagname_ = None
        if MenuItem is None:
            self.MenuItem = []
        else:
            self.MenuItem = MenuItem
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfMenutItems_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfMenutItems_20.subclass:
            return ListOfMenutItems_20.subclass(*args_, **kwargs_)
        else:
            return ListOfMenutItems_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_MenuItem(self): return self.MenuItem
    def set_MenuItem(self, MenuItem): self.MenuItem = MenuItem
    def add_MenuItem(self, value): self.MenuItem.append(value)
    def insert_MenuItem_at(self, index, value): self.MenuItem.insert(index, value)
    def replace_MenuItem_at(self, index, value): self.MenuItem[index] = value
    def hasContent_(self):
        if (
            self.MenuItem
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'MenuItem':
            obj_ = MenuItem_20.factory()
            obj_.build(child_)
            self.MenuItem.append(obj_)
            obj_.original_tagname_ = 'MenuItem'
# end class ListOfMenutItems_20


class MenuItem_20(GeneratedsSuper):
    member_data_items_ = {
        'Resource': MemberSpec_('Resource', 'ResourceBase_13', 0),
        'LastPost': MemberSpec_('LastPost', 'Post_20', 0),
        'LastUnreadPost': MemberSpec_('LastUnreadPost', 'Post_20', 0),
        'OldestUnreadPost': MemberSpec_('OldestUnreadPost', 'Post_20', 0),
        'BadgeCount': MemberSpec_('BadgeCount', 'integer', 0),
        'BadgeCountCardStream': MemberSpec_('BadgeCountCardStream', 'integer', 0),
        'BadgeCountChatStream': MemberSpec_('BadgeCountChatStream', 'integer', 0),
        'Modified': MemberSpec_('Modified', 'dateTime', 0),
        'SortModified': MemberSpec_('SortModified', 'dateTime', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Resource=None, LastPost=None, LastUnreadPost=None, OldestUnreadPost=None, BadgeCount=None, BadgeCountCardStream=None, BadgeCountChatStream=None, Modified=None, SortModified=None):
        self.original_tagname_ = None
        self.Resource = Resource
        self.LastPost = LastPost
        self.LastUnreadPost = LastUnreadPost
        self.OldestUnreadPost = OldestUnreadPost
        self.BadgeCount = BadgeCount
        self.BadgeCountCardStream = BadgeCountCardStream
        self.BadgeCountChatStream = BadgeCountChatStream
        if isinstance(Modified, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(Modified, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = Modified
        self.Modified = initvalue_
        if isinstance(SortModified, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(SortModified, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = SortModified
        self.SortModified = initvalue_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, MenuItem_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if MenuItem_20.subclass:
            return MenuItem_20.subclass(*args_, **kwargs_)
        else:
            return MenuItem_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Resource(self): return self.Resource
    def set_Resource(self, Resource): self.Resource = Resource
    def get_LastPost(self): return self.LastPost
    def set_LastPost(self, LastPost): self.LastPost = LastPost
    def get_LastUnreadPost(self): return self.LastUnreadPost
    def set_LastUnreadPost(self, LastUnreadPost): self.LastUnreadPost = LastUnreadPost
    def get_OldestUnreadPost(self): return self.OldestUnreadPost
    def set_OldestUnreadPost(self, OldestUnreadPost): self.OldestUnreadPost = OldestUnreadPost
    def get_BadgeCount(self): return self.BadgeCount
    def set_BadgeCount(self, BadgeCount): self.BadgeCount = BadgeCount
    def get_BadgeCountCardStream(self): return self.BadgeCountCardStream
    def set_BadgeCountCardStream(self, BadgeCountCardStream): self.BadgeCountCardStream = BadgeCountCardStream
    def get_BadgeCountChatStream(self): return self.BadgeCountChatStream
    def set_BadgeCountChatStream(self, BadgeCountChatStream): self.BadgeCountChatStream = BadgeCountChatStream
    def get_Modified(self): return self.Modified
    def set_Modified(self, Modified): self.Modified = Modified
    def get_SortModified(self): return self.SortModified
    def set_SortModified(self, SortModified): self.SortModified = SortModified
    def hasContent_(self):
        if (
            self.Resource is not None or
            self.LastPost is not None or
            self.LastUnreadPost is not None or
            self.OldestUnreadPost is not None or
            self.BadgeCount is not None or
            self.BadgeCountCardStream is not None or
            self.BadgeCountChatStream is not None or
            self.Modified is not None or
            self.SortModified is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Resource':
            class_obj_ = self.get_class_obj_(child_, ResourceBase_13)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Resource = obj_
            obj_.original_tagname_ = 'Resource'
        elif nodeName_ == 'LastPost':
            class_obj_ = self.get_class_obj_(child_, Post_20)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.LastPost = obj_
            obj_.original_tagname_ = 'LastPost'
        elif nodeName_ == 'LastUnreadPost':
            class_obj_ = self.get_class_obj_(child_, Post_20)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.LastUnreadPost = obj_
            obj_.original_tagname_ = 'LastUnreadPost'
        elif nodeName_ == 'OldestUnreadPost':
            class_obj_ = self.get_class_obj_(child_, Post_20)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.OldestUnreadPost = obj_
            obj_.original_tagname_ = 'OldestUnreadPost'
        elif nodeName_ == 'BadgeCount':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'BadgeCount')
            self.BadgeCount = ival_
        elif nodeName_ == 'BadgeCountCardStream':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'BadgeCountCardStream')
            self.BadgeCountCardStream = ival_
        elif nodeName_ == 'BadgeCountChatStream':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'BadgeCountChatStream')
            self.BadgeCountChatStream = ival_
        elif nodeName_ == 'Modified':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.Modified = dval_
        elif nodeName_ == 'SortModified':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.SortModified = dval_
# end class MenuItem_20


class ListOfLocationsPage_19(GeneratedsSuper):
    member_data_items_ = {
        'LocationListPage': MemberSpec_('LocationListPage', 'ListOfLocations_19', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, LocationListPage=None, Paging=None):
        self.original_tagname_ = None
        self.LocationListPage = LocationListPage
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfLocationsPage_19)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfLocationsPage_19.subclass:
            return ListOfLocationsPage_19.subclass(*args_, **kwargs_)
        else:
            return ListOfLocationsPage_19(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_LocationListPage(self): return self.LocationListPage
    def set_LocationListPage(self, LocationListPage): self.LocationListPage = LocationListPage
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.LocationListPage is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'LocationListPage':
            obj_ = ListOfLocations_19.factory()
            obj_.build(child_)
            self.LocationListPage = obj_
            obj_.original_tagname_ = 'LocationListPage'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class ListOfLocationsPage_19


class ListOfLocations_19(GeneratedsSuper):
    member_data_items_ = {
        'Location': MemberSpec_('Location', 'Location_19', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Location=None):
        self.original_tagname_ = None
        if Location is None:
            self.Location = []
        else:
            self.Location = Location
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfLocations_19)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfLocations_19.subclass:
            return ListOfLocations_19.subclass(*args_, **kwargs_)
        else:
            return ListOfLocations_19(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Location(self): return self.Location
    def set_Location(self, Location): self.Location = Location
    def add_Location(self, value): self.Location.append(value)
    def insert_Location_at(self, index, value): self.Location.insert(index, value)
    def replace_Location_at(self, index, value): self.Location[index] = value
    def hasContent_(self):
        if (
            self.Location
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Location':
            obj_ = Location_19.factory()
            obj_.build(child_)
            self.Location.append(obj_)
            obj_.original_tagname_ = 'Location'
# end class ListOfLocations_19


class Location_19(GeneratedsSuper):
    member_data_items_ = {
        'Date': MemberSpec_('Date', 'dateTime', 0),
        'Position': MemberSpec_('Position', 'Position_19', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Date=None, Position=None):
        self.original_tagname_ = None
        if isinstance(Date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(Date, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = Date
        self.Date = initvalue_
        self.Position = Position
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Location_19)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Location_19.subclass:
            return Location_19.subclass(*args_, **kwargs_)
        else:
            return Location_19(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Date(self): return self.Date
    def set_Date(self, Date): self.Date = Date
    def get_Position(self): return self.Position
    def set_Position(self, Position): self.Position = Position
    def hasContent_(self):
        if (
            self.Date is not None or
            self.Position is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Date':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.Date = dval_
        elif nodeName_ == 'Position':
            obj_ = Position_19.factory()
            obj_.build(child_)
            self.Position = obj_
            obj_.original_tagname_ = 'Position'
# end class Location_19


class Position_19(GeneratedsSuper):
    member_data_items_ = {
        'Id': MemberSpec_('Id', 'string', 0),
        'Latitude': MemberSpec_('Latitude', 'float', 0),
        'Longitude': MemberSpec_('Longitude', 'float', 0),
        'Altitude': MemberSpec_('Altitude', 'float', 0),
        'Accuracy': MemberSpec_('Accuracy', 'float', 0),
        'Speed': MemberSpec_('Speed', 'float', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Id=None, Latitude=None, Longitude=None, Altitude=None, Accuracy=None, Speed=None):
        self.original_tagname_ = None
        self.Id = Id
        self.Latitude = Latitude
        self.Longitude = Longitude
        self.Altitude = Altitude
        self.Accuracy = Accuracy
        self.Speed = Speed
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Position_19)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Position_19.subclass:
            return Position_19.subclass(*args_, **kwargs_)
        else:
            return Position_19(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Id(self): return self.Id
    def set_Id(self, Id): self.Id = Id
    def get_Latitude(self): return self.Latitude
    def set_Latitude(self, Latitude): self.Latitude = Latitude
    def get_Longitude(self): return self.Longitude
    def set_Longitude(self, Longitude): self.Longitude = Longitude
    def get_Altitude(self): return self.Altitude
    def set_Altitude(self, Altitude): self.Altitude = Altitude
    def get_Accuracy(self): return self.Accuracy
    def set_Accuracy(self, Accuracy): self.Accuracy = Accuracy
    def get_Speed(self): return self.Speed
    def set_Speed(self, Speed): self.Speed = Speed
    def hasContent_(self):
        if (
            self.Id is not None or
            self.Latitude is not None or
            self.Longitude is not None or
            self.Altitude is not None or
            self.Accuracy is not None or
            self.Speed is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Id':
            Id_ = child_.text
            Id_ = self.gds_validate_string(Id_, node, 'Id')
            self.Id = Id_
        elif nodeName_ == 'Latitude':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'Latitude')
            self.Latitude = fval_
        elif nodeName_ == 'Longitude':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'Longitude')
            self.Longitude = fval_
        elif nodeName_ == 'Altitude':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'Altitude')
            self.Altitude = fval_
        elif nodeName_ == 'Accuracy':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'Accuracy')
            self.Accuracy = fval_
        elif nodeName_ == 'Speed':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'Speed')
            self.Speed = fval_
# end class Position_19


class ListOfActionableResourcesPage_22(GeneratedsSuper):
    member_data_items_ = {
        'ActionableResourceList': MemberSpec_('ActionableResourceList', 'ListOfActionableResources_22', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, ActionableResourceList=None, Paging=None):
        self.original_tagname_ = None
        self.ActionableResourceList = ActionableResourceList
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfActionableResourcesPage_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfActionableResourcesPage_22.subclass:
            return ListOfActionableResourcesPage_22.subclass(*args_, **kwargs_)
        else:
            return ListOfActionableResourcesPage_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ActionableResourceList(self): return self.ActionableResourceList
    def set_ActionableResourceList(self, ActionableResourceList): self.ActionableResourceList = ActionableResourceList
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.ActionableResourceList is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ActionableResourceList':
            obj_ = ListOfActionableResources_22.factory()
            obj_.build(child_)
            self.ActionableResourceList = obj_
            obj_.original_tagname_ = 'ActionableResourceList'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class ListOfActionableResourcesPage_22


class ListOfActionableResources_22(GeneratedsSuper):
    member_data_items_ = {
        'ActionableResource': MemberSpec_('ActionableResource', 'ActionableResource_22', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, ActionableResource=None):
        self.original_tagname_ = None
        if ActionableResource is None:
            self.ActionableResource = []
        else:
            self.ActionableResource = ActionableResource
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfActionableResources_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfActionableResources_22.subclass:
            return ListOfActionableResources_22.subclass(*args_, **kwargs_)
        else:
            return ListOfActionableResources_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ActionableResource(self): return self.ActionableResource
    def set_ActionableResource(self, ActionableResource): self.ActionableResource = ActionableResource
    def add_ActionableResource(self, value): self.ActionableResource.append(value)
    def insert_ActionableResource_at(self, index, value): self.ActionableResource.insert(index, value)
    def replace_ActionableResource_at(self, index, value): self.ActionableResource[index] = value
    def hasContent_(self):
        if (
            self.ActionableResource
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ActionableResource':
            class_obj_ = self.get_class_obj_(child_, ActionableResource_22)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.ActionableResource.append(obj_)
            obj_.original_tagname_ = 'ActionableResource'
# end class ListOfActionableResources_22


class ListOfActionableResourcesPage_21(GeneratedsSuper):
    member_data_items_ = {
        'ActionableResourceList': MemberSpec_('ActionableResourceList', 'ListOfActionableResources_21', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, ActionableResourceList=None, Paging=None):
        self.original_tagname_ = None
        self.ActionableResourceList = ActionableResourceList
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfActionableResourcesPage_21)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfActionableResourcesPage_21.subclass:
            return ListOfActionableResourcesPage_21.subclass(*args_, **kwargs_)
        else:
            return ListOfActionableResourcesPage_21(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ActionableResourceList(self): return self.ActionableResourceList
    def set_ActionableResourceList(self, ActionableResourceList): self.ActionableResourceList = ActionableResourceList
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.ActionableResourceList is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ActionableResourceList':
            obj_ = ListOfActionableResources_21.factory()
            obj_.build(child_)
            self.ActionableResourceList = obj_
            obj_.original_tagname_ = 'ActionableResourceList'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class ListOfActionableResourcesPage_21


class ListOfActionableResources_21(GeneratedsSuper):
    member_data_items_ = {
        'ActionableResource': MemberSpec_('ActionableResource', 'ActionableResource_21', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, ActionableResource=None):
        self.original_tagname_ = None
        if ActionableResource is None:
            self.ActionableResource = []
        else:
            self.ActionableResource = ActionableResource
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfActionableResources_21)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfActionableResources_21.subclass:
            return ListOfActionableResources_21.subclass(*args_, **kwargs_)
        else:
            return ListOfActionableResources_21(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ActionableResource(self): return self.ActionableResource
    def set_ActionableResource(self, ActionableResource): self.ActionableResource = ActionableResource
    def add_ActionableResource(self, value): self.ActionableResource.append(value)
    def insert_ActionableResource_at(self, index, value): self.ActionableResource.insert(index, value)
    def replace_ActionableResource_at(self, index, value): self.ActionableResource[index] = value
    def hasContent_(self):
        if (
            self.ActionableResource
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ActionableResource':
            class_obj_ = self.get_class_obj_(child_, ActionableResource_21)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.ActionableResource.append(obj_)
            obj_.original_tagname_ = 'ActionableResource'
# end class ListOfActionableResources_21


class ListOfActionableResourcesPage_20(GeneratedsSuper):
    member_data_items_ = {
        'ActionableResourceList': MemberSpec_('ActionableResourceList', 'ListOfActionableResources_20', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, ActionableResourceList=None, Paging=None):
        self.original_tagname_ = None
        self.ActionableResourceList = ActionableResourceList
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfActionableResourcesPage_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfActionableResourcesPage_20.subclass:
            return ListOfActionableResourcesPage_20.subclass(*args_, **kwargs_)
        else:
            return ListOfActionableResourcesPage_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ActionableResourceList(self): return self.ActionableResourceList
    def set_ActionableResourceList(self, ActionableResourceList): self.ActionableResourceList = ActionableResourceList
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.ActionableResourceList is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ActionableResourceList':
            obj_ = ListOfActionableResources_20.factory()
            obj_.build(child_)
            self.ActionableResourceList = obj_
            obj_.original_tagname_ = 'ActionableResourceList'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class ListOfActionableResourcesPage_20


class ListOfActionableResources_20(GeneratedsSuper):
    member_data_items_ = {
        'ActionableResource': MemberSpec_('ActionableResource', 'ActionableResource_20', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, ActionableResource=None):
        self.original_tagname_ = None
        if ActionableResource is None:
            self.ActionableResource = []
        else:
            self.ActionableResource = ActionableResource
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfActionableResources_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfActionableResources_20.subclass:
            return ListOfActionableResources_20.subclass(*args_, **kwargs_)
        else:
            return ListOfActionableResources_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ActionableResource(self): return self.ActionableResource
    def set_ActionableResource(self, ActionableResource): self.ActionableResource = ActionableResource
    def add_ActionableResource(self, value): self.ActionableResource.append(value)
    def insert_ActionableResource_at(self, index, value): self.ActionableResource.insert(index, value)
    def replace_ActionableResource_at(self, index, value): self.ActionableResource[index] = value
    def hasContent_(self):
        if (
            self.ActionableResource
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ActionableResource':
            class_obj_ = self.get_class_obj_(child_, ActionableResource_20)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.ActionableResource.append(obj_)
            obj_.original_tagname_ = 'ActionableResource'
# end class ListOfActionableResources_20


class ActionableResourceAvailability_20(GeneratedsSuper):
    member_data_items_ = {
        'Mode': MemberSpec_('Mode', 'string', 0),
        'ActionableResourceId': MemberSpec_('ActionableResourceId', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Mode=None, ActionableResourceId=None):
        self.original_tagname_ = None
        self.Mode = Mode
        self.ActionableResourceId = ActionableResourceId
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ActionableResourceAvailability_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ActionableResourceAvailability_20.subclass:
            return ActionableResourceAvailability_20.subclass(*args_, **kwargs_)
        else:
            return ActionableResourceAvailability_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Mode(self): return self.Mode
    def set_Mode(self, Mode): self.Mode = Mode
    def get_ActionableResourceId(self): return self.ActionableResourceId
    def set_ActionableResourceId(self, ActionableResourceId): self.ActionableResourceId = ActionableResourceId
    def hasContent_(self):
        if (
            self.Mode is not None or
            self.ActionableResourceId is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Mode':
            Mode_ = child_.text
            Mode_ = self.gds_validate_string(Mode_, node, 'Mode')
            self.Mode = Mode_
        elif nodeName_ == 'ActionableResourceId':
            ActionableResourceId_ = child_.text
            ActionableResourceId_ = self.gds_validate_string(ActionableResourceId_, node, 'ActionableResourceId')
            self.ActionableResourceId = ActionableResourceId_
# end class ActionableResourceAvailability_20


class ActionableResource_18(GeneratedsSuper):
    member_data_items_ = {
        'ActionResource': MemberSpec_('ActionResource', 'ResourceBase_13', 0),
        'NotificationType': MemberSpec_('NotificationType', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, ActionResource=None, NotificationType=None):
        self.original_tagname_ = None
        self.ActionResource = ActionResource
        self.NotificationType = NotificationType
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ActionableResource_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ActionableResource_18.subclass:
            return ActionableResource_18.subclass(*args_, **kwargs_)
        else:
            return ActionableResource_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ActionResource(self): return self.ActionResource
    def set_ActionResource(self, ActionResource): self.ActionResource = ActionResource
    def get_NotificationType(self): return self.NotificationType
    def set_NotificationType(self, NotificationType): self.NotificationType = NotificationType
    def hasContent_(self):
        if (
            self.ActionResource is not None or
            self.NotificationType is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ActionResource':
            class_obj_ = self.get_class_obj_(child_, ResourceBase_13)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.ActionResource = obj_
            obj_.original_tagname_ = 'ActionResource'
        elif nodeName_ == 'NotificationType':
            NotificationType_ = child_.text
            NotificationType_ = self.gds_validate_string(NotificationType_, node, 'NotificationType')
            self.NotificationType = NotificationType_
# end class ActionableResource_18


class ListOfActionableResources_18(GeneratedsSuper):
    member_data_items_ = {
        'ActionableResource': MemberSpec_('ActionableResource', 'ActionableResource_18', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, ActionableResource=None):
        self.original_tagname_ = None
        if ActionableResource is None:
            self.ActionableResource = []
        else:
            self.ActionableResource = ActionableResource
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfActionableResources_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfActionableResources_18.subclass:
            return ListOfActionableResources_18.subclass(*args_, **kwargs_)
        else:
            return ListOfActionableResources_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ActionableResource(self): return self.ActionableResource
    def set_ActionableResource(self, ActionableResource): self.ActionableResource = ActionableResource
    def add_ActionableResource(self, value): self.ActionableResource.append(value)
    def insert_ActionableResource_at(self, index, value): self.ActionableResource.insert(index, value)
    def replace_ActionableResource_at(self, index, value): self.ActionableResource[index] = value
    def hasContent_(self):
        if (
            self.ActionableResource
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ActionableResource':
            obj_ = ActionableResource_18.factory()
            obj_.build(child_)
            self.ActionableResource.append(obj_)
            obj_.original_tagname_ = 'ActionableResource'
# end class ListOfActionableResources_18


class ListOfActions_18(GeneratedsSuper):
    member_data_items_ = {
        'Action': MemberSpec_('Action', 'ActionBase_18', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Action=None):
        self.original_tagname_ = None
        if Action is None:
            self.Action = []
        else:
            self.Action = Action
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfActions_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfActions_18.subclass:
            return ListOfActions_18.subclass(*args_, **kwargs_)
        else:
            return ListOfActions_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Action(self): return self.Action
    def set_Action(self, Action): self.Action = Action
    def add_Action(self, value): self.Action.append(value)
    def insert_Action_at(self, index, value): self.Action.insert(index, value)
    def replace_Action_at(self, index, value): self.Action[index] = value
    def hasContent_(self):
        if (
            self.Action
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Action':
            class_obj_ = self.get_class_obj_(child_, ActionBase_18)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Action.append(obj_)
            obj_.original_tagname_ = 'Action'
# end class ListOfActions_18


class ListOfUserStatisticResponseTimes_20(GeneratedsSuper):
    member_data_items_ = {
        'UserStatisticResponseTime': MemberSpec_('UserStatisticResponseTime', 'StatisticsUserResponseTime_20', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, UserStatisticResponseTime=None):
        self.original_tagname_ = None
        if UserStatisticResponseTime is None:
            self.UserStatisticResponseTime = []
        else:
            self.UserStatisticResponseTime = UserStatisticResponseTime
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfUserStatisticResponseTimes_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfUserStatisticResponseTimes_20.subclass:
            return ListOfUserStatisticResponseTimes_20.subclass(*args_, **kwargs_)
        else:
            return ListOfUserStatisticResponseTimes_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_UserStatisticResponseTime(self): return self.UserStatisticResponseTime
    def set_UserStatisticResponseTime(self, UserStatisticResponseTime): self.UserStatisticResponseTime = UserStatisticResponseTime
    def add_UserStatisticResponseTime(self, value): self.UserStatisticResponseTime.append(value)
    def insert_UserStatisticResponseTime_at(self, index, value): self.UserStatisticResponseTime.insert(index, value)
    def replace_UserStatisticResponseTime_at(self, index, value): self.UserStatisticResponseTime[index] = value
    def hasContent_(self):
        if (
            self.UserStatisticResponseTime
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'UserStatisticResponseTime':
            obj_ = StatisticsUserResponseTime_20.factory()
            obj_.build(child_)
            self.UserStatisticResponseTime.append(obj_)
            obj_.original_tagname_ = 'UserStatisticResponseTime'
# end class ListOfUserStatisticResponseTimes_20


class ListOfUserStatistics_20(GeneratedsSuper):
    member_data_items_ = {
        'UserStatistics': MemberSpec_('UserStatistics', 'UserStatistics_20', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, UserStatistics=None):
        self.original_tagname_ = None
        if UserStatistics is None:
            self.UserStatistics = []
        else:
            self.UserStatistics = UserStatistics
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfUserStatistics_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfUserStatistics_20.subclass:
            return ListOfUserStatistics_20.subclass(*args_, **kwargs_)
        else:
            return ListOfUserStatistics_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_UserStatistics(self): return self.UserStatistics
    def set_UserStatistics(self, UserStatistics): self.UserStatistics = UserStatistics
    def add_UserStatistics(self, value): self.UserStatistics.append(value)
    def insert_UserStatistics_at(self, index, value): self.UserStatistics.insert(index, value)
    def replace_UserStatistics_at(self, index, value): self.UserStatistics[index] = value
    def hasContent_(self):
        if (
            self.UserStatistics
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'UserStatistics':
            obj_ = UserStatistics_20.factory()
            obj_.build(child_)
            self.UserStatistics.append(obj_)
            obj_.original_tagname_ = 'UserStatistics'
# end class ListOfUserStatistics_20


class UserStatistics_20(GeneratedsSuper):
    member_data_items_ = {
        'User': MemberSpec_('User', 'User_14', 0),
        'PostCount': MemberSpec_('PostCount', 'integer', 0),
        'QuickestResponse': MemberSpec_('QuickestResponse', 'ResponseStatistics_20', 0),
        'AverageResponse': MemberSpec_('AverageResponse', 'ResponseStatistics_20', 0),
        'NoResponse': MemberSpec_('NoResponse', 'ResponseStatistics_20', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, User=None, PostCount=None, QuickestResponse=None, AverageResponse=None, NoResponse=None):
        self.original_tagname_ = None
        self.User = User
        self.PostCount = PostCount
        self.QuickestResponse = QuickestResponse
        self.AverageResponse = AverageResponse
        self.NoResponse = NoResponse
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, UserStatistics_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if UserStatistics_20.subclass:
            return UserStatistics_20.subclass(*args_, **kwargs_)
        else:
            return UserStatistics_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_User(self): return self.User
    def set_User(self, User): self.User = User
    def get_PostCount(self): return self.PostCount
    def set_PostCount(self, PostCount): self.PostCount = PostCount
    def get_QuickestResponse(self): return self.QuickestResponse
    def set_QuickestResponse(self, QuickestResponse): self.QuickestResponse = QuickestResponse
    def get_AverageResponse(self): return self.AverageResponse
    def set_AverageResponse(self, AverageResponse): self.AverageResponse = AverageResponse
    def get_NoResponse(self): return self.NoResponse
    def set_NoResponse(self, NoResponse): self.NoResponse = NoResponse
    def hasContent_(self):
        if (
            self.User is not None or
            self.PostCount is not None or
            self.QuickestResponse is not None or
            self.AverageResponse is not None or
            self.NoResponse is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'User':
            class_obj_ = self.get_class_obj_(child_, User_14)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.User = obj_
            obj_.original_tagname_ = 'User'
        elif nodeName_ == 'PostCount':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'PostCount')
            self.PostCount = ival_
        elif nodeName_ == 'QuickestResponse':
            obj_ = ResponseStatistics_20.factory()
            obj_.build(child_)
            self.QuickestResponse = obj_
            obj_.original_tagname_ = 'QuickestResponse'
        elif nodeName_ == 'AverageResponse':
            obj_ = ResponseStatistics_20.factory()
            obj_.build(child_)
            self.AverageResponse = obj_
            obj_.original_tagname_ = 'AverageResponse'
        elif nodeName_ == 'NoResponse':
            obj_ = ResponseStatistics_20.factory()
            obj_.build(child_)
            self.NoResponse = obj_
            obj_.original_tagname_ = 'NoResponse'
# end class UserStatistics_20


class ResponseStatistics_20(GeneratedsSuper):
    member_data_items_ = {
        'DateTimeRange': MemberSpec_('DateTimeRange', 'DateTimeRange', 0),
        'TimeRange': MemberSpec_('TimeRange', 'TimeRange', 0),
        'ResponseTime': MemberSpec_('ResponseTime', 'integer', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, DateTimeRange=None, TimeRange=None, ResponseTime=None):
        self.original_tagname_ = None
        self.DateTimeRange = DateTimeRange
        self.TimeRange = TimeRange
        self.ResponseTime = ResponseTime
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ResponseStatistics_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ResponseStatistics_20.subclass:
            return ResponseStatistics_20.subclass(*args_, **kwargs_)
        else:
            return ResponseStatistics_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_DateTimeRange(self): return self.DateTimeRange
    def set_DateTimeRange(self, DateTimeRange): self.DateTimeRange = DateTimeRange
    def get_TimeRange(self): return self.TimeRange
    def set_TimeRange(self, TimeRange): self.TimeRange = TimeRange
    def get_ResponseTime(self): return self.ResponseTime
    def set_ResponseTime(self, ResponseTime): self.ResponseTime = ResponseTime
    def hasContent_(self):
        if (
            self.DateTimeRange is not None or
            self.TimeRange is not None or
            self.ResponseTime is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'DateTimeRange':
            obj_ = DateTimeRange.factory()
            obj_.build(child_)
            self.DateTimeRange = obj_
            obj_.original_tagname_ = 'DateTimeRange'
        elif nodeName_ == 'TimeRange':
            obj_ = TimeRange.factory()
            obj_.build(child_)
            self.TimeRange = obj_
            obj_.original_tagname_ = 'TimeRange'
        elif nodeName_ == 'ResponseTime':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'ResponseTime')
            self.ResponseTime = ival_
# end class ResponseStatistics_20


class FlagManagedByAssistantBase_20(GeneratedsSuper):
    member_data_items_ = {
        'ManagedByAssistant': MemberSpec_('ManagedByAssistant', 'boolean', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, ManagedByAssistant=None):
        self.original_tagname_ = None
        self.ManagedByAssistant = ManagedByAssistant
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, FlagManagedByAssistantBase_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if FlagManagedByAssistantBase_20.subclass:
            return FlagManagedByAssistantBase_20.subclass(*args_, **kwargs_)
        else:
            return FlagManagedByAssistantBase_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ManagedByAssistant(self): return self.ManagedByAssistant
    def set_ManagedByAssistant(self, ManagedByAssistant): self.ManagedByAssistant = ManagedByAssistant
    def hasContent_(self):
        if (
            self.ManagedByAssistant is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ManagedByAssistant':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'ManagedByAssistant')
            self.ManagedByAssistant = ival_
# end class FlagManagedByAssistantBase_20


class Result_1(GeneratedsSuper):
    member_data_items_ = {
        'Message': MemberSpec_('Message', 'string', 0),
        'ErrorCode': MemberSpec_('ErrorCode', 'string', 0),
        'Conflict': MemberSpec_('Conflict', 'ConflictInfo_1', 0),
        'Successful': MemberSpec_('Successful', 'boolean', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Message=None, ErrorCode=None, Conflict=None, Successful=None):
        self.original_tagname_ = None
        self.Message = Message
        self.ErrorCode = ErrorCode
        self.Conflict = Conflict
        self.Successful = Successful
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Result_1)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Result_1.subclass:
            return Result_1.subclass(*args_, **kwargs_)
        else:
            return Result_1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Message(self): return self.Message
    def set_Message(self, Message): self.Message = Message
    def get_ErrorCode(self): return self.ErrorCode
    def set_ErrorCode(self, ErrorCode): self.ErrorCode = ErrorCode
    def get_Conflict(self): return self.Conflict
    def set_Conflict(self, Conflict): self.Conflict = Conflict
    def get_Successful(self): return self.Successful
    def set_Successful(self, Successful): self.Successful = Successful
    def hasContent_(self):
        if (
            self.Message is not None or
            self.ErrorCode is not None or
            self.Conflict is not None or
            self.Successful is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Message':
            Message_ = child_.text
            Message_ = self.gds_validate_string(Message_, node, 'Message')
            self.Message = Message_
        elif nodeName_ == 'ErrorCode':
            ErrorCode_ = child_.text
            ErrorCode_ = self.gds_validate_string(ErrorCode_, node, 'ErrorCode')
            self.ErrorCode = ErrorCode_
        elif nodeName_ == 'Conflict':
            obj_ = ConflictInfo_1.factory()
            obj_.build(child_)
            self.Conflict = obj_
            obj_.original_tagname_ = 'Conflict'
        elif nodeName_ == 'Successful':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'Successful')
            self.Successful = ival_
# end class Result_1


class ConflictInfo_1(GeneratedsSuper):
    member_data_items_ = {
        'PostedResource': MemberSpec_('PostedResource', 'ResourceBase_13', 0),
        'ConflictedResource': MemberSpec_('ConflictedResource', 'ResourceBase_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, PostedResource=None, ConflictedResource=None):
        self.original_tagname_ = None
        self.PostedResource = PostedResource
        self.ConflictedResource = ConflictedResource
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ConflictInfo_1)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ConflictInfo_1.subclass:
            return ConflictInfo_1.subclass(*args_, **kwargs_)
        else:
            return ConflictInfo_1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_PostedResource(self): return self.PostedResource
    def set_PostedResource(self, PostedResource): self.PostedResource = PostedResource
    def get_ConflictedResource(self): return self.ConflictedResource
    def set_ConflictedResource(self, ConflictedResource): self.ConflictedResource = ConflictedResource
    def hasContent_(self):
        if (
            self.PostedResource is not None or
            self.ConflictedResource is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'PostedResource':
            class_obj_ = self.get_class_obj_(child_, ResourceBase_13)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.PostedResource = obj_
            obj_.original_tagname_ = 'PostedResource'
        elif nodeName_ == 'ConflictedResource':
            class_obj_ = self.get_class_obj_(child_, ResourceBase_13)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.ConflictedResource = obj_
            obj_.original_tagname_ = 'ConflictedResource'
# end class ConflictInfo_1


class LocalizedResult_1(Result_1):
    member_data_items_ = {
        'LocalizedMessage': MemberSpec_('LocalizedMessage', 'string', 0),
    }
    subclass = None
    superclass = Result_1
    def __init__(self, LocalizedMessage=None):
        self.original_tagname_ = None
        super(LocalizedResult_1, self).__init__()
        self.LocalizedMessage = LocalizedMessage
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, LocalizedResult_1)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if LocalizedResult_1.subclass:
            return LocalizedResult_1.subclass(*args_, **kwargs_)
        else:
            return LocalizedResult_1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_LocalizedMessage(self): return self.LocalizedMessage
    def set_LocalizedMessage(self, LocalizedMessage): self.LocalizedMessage = LocalizedMessage
    def hasContent_(self):
        if (
            self.LocalizedMessage is not None or
            super(LocalizedResult_1, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(LocalizedResult_1, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'LocalizedMessage':
            LocalizedMessage_ = child_.text
            LocalizedMessage_ = self.gds_validate_string(LocalizedMessage_, node, 'LocalizedMessage')
            self.LocalizedMessage = LocalizedMessage_
        super(LocalizedResult_1, self).buildChildren(child_, node, nodeName_, True)
# end class LocalizedResult_1


class ResourceBase_13(GeneratedsSuper):
    member_data_items_ = {
        'Id': MemberSpec_('Id', 'string', 0),
        'Name': MemberSpec_('Name', 'string', 0),
        'Revision': MemberSpec_('Revision', 'string', 0),
        'ClientResourceIdList': MemberSpec_('ClientResourceIdList', 'ListOfStrings', 0),
        'Created': MemberSpec_('Created', 'dateTime', 0),
        'Modified': MemberSpec_('Modified', 'dateTime', 0),
        'IsFull': MemberSpec_('IsFull', 'boolean', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Id=None, Name=None, Revision=None, ClientResourceIdList=None, Created=None, Modified=None, IsFull=None):
        self.original_tagname_ = None
        self.Id = Id
        self.Name = Name
        self.Revision = Revision
        self.ClientResourceIdList = ClientResourceIdList
        if isinstance(Created, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(Created, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = Created
        self.Created = initvalue_
        if isinstance(Modified, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(Modified, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = Modified
        self.Modified = initvalue_
        self.IsFull = IsFull
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ResourceBase_13)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ResourceBase_13.subclass:
            return ResourceBase_13.subclass(*args_, **kwargs_)
        else:
            return ResourceBase_13(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Id(self): return self.Id
    def set_Id(self, Id): self.Id = Id
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Revision(self): return self.Revision
    def set_Revision(self, Revision): self.Revision = Revision
    def get_ClientResourceIdList(self): return self.ClientResourceIdList
    def set_ClientResourceIdList(self, ClientResourceIdList): self.ClientResourceIdList = ClientResourceIdList
    def get_Created(self): return self.Created
    def set_Created(self, Created): self.Created = Created
    def get_Modified(self): return self.Modified
    def set_Modified(self, Modified): self.Modified = Modified
    def get_IsFull(self): return self.IsFull
    def set_IsFull(self, IsFull): self.IsFull = IsFull
    def hasContent_(self):
        if (
            self.Id is not None or
            self.Name is not None or
            self.Revision is not None or
            self.ClientResourceIdList is not None or
            self.Created is not None or
            self.Modified is not None or
            self.IsFull is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Id':
            Id_ = child_.text
            Id_ = self.gds_validate_string(Id_, node, 'Id')
            self.Id = Id_
        elif nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Revision':
            Revision_ = child_.text
            Revision_ = self.gds_validate_string(Revision_, node, 'Revision')
            self.Revision = Revision_
        elif nodeName_ == 'ClientResourceIdList':
            obj_ = ListOfStrings.factory()
            obj_.build(child_)
            self.ClientResourceIdList = obj_
            obj_.original_tagname_ = 'ClientResourceIdList'
        elif nodeName_ == 'Created':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.Created = dval_
        elif nodeName_ == 'Modified':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.Modified = dval_
        elif nodeName_ == 'IsFull':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsFull')
            self.IsFull = ival_
# end class ResourceBase_13


class ListOfResources_13(GeneratedsSuper):
    member_data_items_ = {
        'Resource': MemberSpec_('Resource', 'ResourceBase_13', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, Resource=None):
        self.original_tagname_ = None
        if Resource is None:
            self.Resource = []
        else:
            self.Resource = Resource
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfResources_13)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfResources_13.subclass:
            return ListOfResources_13.subclass(*args_, **kwargs_)
        else:
            return ListOfResources_13(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Resource(self): return self.Resource
    def set_Resource(self, Resource): self.Resource = Resource
    def add_Resource(self, value): self.Resource.append(value)
    def insert_Resource_at(self, index, value): self.Resource.insert(index, value)
    def replace_Resource_at(self, index, value): self.Resource[index] = value
    def hasContent_(self):
        if (
            self.Resource
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Resource':
            class_obj_ = self.get_class_obj_(child_, ResourceBase_13)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Resource.append(obj_)
            obj_.original_tagname_ = 'Resource'
# end class ListOfResources_13


class ListOfResourcesPage_13(GeneratedsSuper):
    member_data_items_ = {
        'ResourceList': MemberSpec_('ResourceList', 'ListOfResources_13', 0),
        'Paging': MemberSpec_('Paging', 'Paging_13', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, ResourceList=None, Paging=None):
        self.original_tagname_ = None
        self.ResourceList = ResourceList
        self.Paging = Paging
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfResourcesPage_13)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfResourcesPage_13.subclass:
            return ListOfResourcesPage_13.subclass(*args_, **kwargs_)
        else:
            return ListOfResourcesPage_13(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ResourceList(self): return self.ResourceList
    def set_ResourceList(self, ResourceList): self.ResourceList = ResourceList
    def get_Paging(self): return self.Paging
    def set_Paging(self, Paging): self.Paging = Paging
    def hasContent_(self):
        if (
            self.ResourceList is not None or
            self.Paging is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ResourceList':
            obj_ = ListOfResources_13.factory()
            obj_.build(child_)
            self.ResourceList = obj_
            obj_.original_tagname_ = 'ResourceList'
        elif nodeName_ == 'Paging':
            obj_ = Paging_13.factory()
            obj_.build(child_)
            self.Paging = obj_
            obj_.original_tagname_ = 'Paging'
# end class ListOfResourcesPage_13


class DateTimeRange(GeneratedsSuper):
    member_data_items_ = {
        'Start': MemberSpec_('Start', 'dateTime', 0),
        'End': MemberSpec_('End', 'dateTime', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Start=None, End=None):
        self.original_tagname_ = None
        if isinstance(Start, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(Start, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = Start
        self.Start = initvalue_
        if isinstance(End, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(End, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = End
        self.End = initvalue_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DateTimeRange)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DateTimeRange.subclass:
            return DateTimeRange.subclass(*args_, **kwargs_)
        else:
            return DateTimeRange(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Start(self): return self.Start
    def set_Start(self, Start): self.Start = Start
    def get_End(self): return self.End
    def set_End(self, End): self.End = End
    def hasContent_(self):
        if (
            self.Start is not None or
            self.End is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Start':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.Start = dval_
        elif nodeName_ == 'End':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.End = dval_
# end class DateTimeRange


class TimeRange(GeneratedsSuper):
    member_data_items_ = {
        'Start': MemberSpec_('Start', 'string', 0),
        'End': MemberSpec_('End', 'string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, Start=None, End=None):
        self.original_tagname_ = None
        self.Start = Start
        self.End = End
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TimeRange)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TimeRange.subclass:
            return TimeRange.subclass(*args_, **kwargs_)
        else:
            return TimeRange(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Start(self): return self.Start
    def set_Start(self, Start): self.Start = Start
    def get_End(self): return self.End
    def set_End(self, End): self.End = End
    def hasContent_(self):
        if (
            self.Start is not None or
            self.End is not None
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Start':
            Start_ = child_.text
            Start_ = self.gds_validate_string(Start_, node, 'Start')
            self.Start = Start_
        elif nodeName_ == 'End':
            End_ = child_.text
            End_ = self.gds_validate_string(End_, node, 'End')
            self.End = End_
# end class TimeRange


class ListOfStrings(GeneratedsSuper):
    member_data_items_ = {
        'stringItem': MemberSpec_('stringItem', 'string', 1),
    }
    subclass = None
    superclass = None
    def __init__(self, stringItem=None):
        self.original_tagname_ = None
        if stringItem is None:
            self.stringItem = []
        else:
            self.stringItem = stringItem
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ListOfStrings)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ListOfStrings.subclass:
            return ListOfStrings.subclass(*args_, **kwargs_)
        else:
            return ListOfStrings(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_stringItem(self): return self.stringItem
    def set_stringItem(self, stringItem): self.stringItem = stringItem
    def add_stringItem(self, value): self.stringItem.append(value)
    def insert_stringItem_at(self, index, value): self.stringItem.insert(index, value)
    def replace_stringItem_at(self, index, value): self.stringItem[index] = value
    def hasContent_(self):
        if (
            self.stringItem
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'stringItem':
            stringItem_ = child_.text
            stringItem_ = self.gds_validate_string(stringItem_, node, 'stringItem')
            self.stringItem.append(stringItem_)
# end class ListOfStrings


class StatisticsGroupActivity_20(ResourceBase_13):
    member_data_items_ = {
        'Group': MemberSpec_('Group', 'Group_17', 0),
        'MostActiveMembers': MemberSpec_('MostActiveMembers', 'ListOfUserStatistics_20', 0),
        'ActivityChart': MemberSpec_('ActivityChart', 'ActivityChart_13', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, Group=None, MostActiveMembers=None, ActivityChart=None):
        self.original_tagname_ = None
        super(StatisticsGroupActivity_20, self).__init__()
        self.Group = Group
        self.MostActiveMembers = MostActiveMembers
        self.ActivityChart = ActivityChart
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StatisticsGroupActivity_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StatisticsGroupActivity_20.subclass:
            return StatisticsGroupActivity_20.subclass(*args_, **kwargs_)
        else:
            return StatisticsGroupActivity_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Group(self): return self.Group
    def set_Group(self, Group): self.Group = Group
    def get_MostActiveMembers(self): return self.MostActiveMembers
    def set_MostActiveMembers(self, MostActiveMembers): self.MostActiveMembers = MostActiveMembers
    def get_ActivityChart(self): return self.ActivityChart
    def set_ActivityChart(self, ActivityChart): self.ActivityChart = ActivityChart
    def hasContent_(self):
        if (
            self.Group is not None or
            self.MostActiveMembers is not None or
            self.ActivityChart is not None or
            super(StatisticsGroupActivity_20, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(StatisticsGroupActivity_20, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Group':
            obj_ = Group_17.factory()
            obj_.build(child_)
            self.Group = obj_
            obj_.original_tagname_ = 'Group'
        elif nodeName_ == 'MostActiveMembers':
            obj_ = ListOfUserStatistics_20.factory()
            obj_.build(child_)
            self.MostActiveMembers = obj_
            obj_.original_tagname_ = 'MostActiveMembers'
        elif nodeName_ == 'ActivityChart':
            obj_ = ActivityChart_13.factory()
            obj_.build(child_)
            self.ActivityChart = obj_
            obj_.original_tagname_ = 'ActivityChart'
        super(StatisticsGroupActivity_20, self).buildChildren(child_, node, nodeName_, True)
# end class StatisticsGroupActivity_20


class StatisticsUserResponseTime_20(ResourceBase_13):
    member_data_items_ = {
        'Me': MemberSpec_('Me', 'UserStatistics_20', 0),
        'Other': MemberSpec_('Other', 'UserStatistics_20', 0),
        'ViewType': MemberSpec_('ViewType', 'string', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, Me=None, Other=None, ViewType=None):
        self.original_tagname_ = None
        super(StatisticsUserResponseTime_20, self).__init__()
        self.Me = Me
        self.Other = Other
        self.ViewType = ViewType
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StatisticsUserResponseTime_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StatisticsUserResponseTime_20.subclass:
            return StatisticsUserResponseTime_20.subclass(*args_, **kwargs_)
        else:
            return StatisticsUserResponseTime_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Me(self): return self.Me
    def set_Me(self, Me): self.Me = Me
    def get_Other(self): return self.Other
    def set_Other(self, Other): self.Other = Other
    def get_ViewType(self): return self.ViewType
    def set_ViewType(self, ViewType): self.ViewType = ViewType
    def hasContent_(self):
        if (
            self.Me is not None or
            self.Other is not None or
            self.ViewType is not None or
            super(StatisticsUserResponseTime_20, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(StatisticsUserResponseTime_20, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Me':
            obj_ = UserStatistics_20.factory()
            obj_.build(child_)
            self.Me = obj_
            obj_.original_tagname_ = 'Me'
        elif nodeName_ == 'Other':
            obj_ = UserStatistics_20.factory()
            obj_.build(child_)
            self.Other = obj_
            obj_.original_tagname_ = 'Other'
        elif nodeName_ == 'ViewType':
            ViewType_ = child_.text
            ViewType_ = self.gds_validate_string(ViewType_, node, 'ViewType')
            self.ViewType = ViewType_
        super(StatisticsUserResponseTime_20, self).buildChildren(child_, node, nodeName_, True)
# end class StatisticsUserResponseTime_20


class StatisticsUserResponseTimeList_20(ResourceBase_13):
    member_data_items_ = {
        'UserResponseTimeList': MemberSpec_('UserResponseTimeList', 'ListOfUserStatisticResponseTimes_20', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, UserResponseTimeList=None):
        self.original_tagname_ = None
        super(StatisticsUserResponseTimeList_20, self).__init__()
        self.UserResponseTimeList = UserResponseTimeList
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StatisticsUserResponseTimeList_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StatisticsUserResponseTimeList_20.subclass:
            return StatisticsUserResponseTimeList_20.subclass(*args_, **kwargs_)
        else:
            return StatisticsUserResponseTimeList_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_UserResponseTimeList(self): return self.UserResponseTimeList
    def set_UserResponseTimeList(self, UserResponseTimeList): self.UserResponseTimeList = UserResponseTimeList
    def hasContent_(self):
        if (
            self.UserResponseTimeList is not None or
            super(StatisticsUserResponseTimeList_20, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(StatisticsUserResponseTimeList_20, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'UserResponseTimeList':
            obj_ = ListOfUserStatisticResponseTimes_20.factory()
            obj_.build(child_)
            self.UserResponseTimeList = obj_
            obj_.original_tagname_ = 'UserResponseTimeList'
        super(StatisticsUserResponseTimeList_20, self).buildChildren(child_, node, nodeName_, True)
# end class StatisticsUserResponseTimeList_20


class ActionBase_18(ResourceBase_13):
    member_data_items_ = {
        'Description': MemberSpec_('Description', 'string', 0),
        'ResponseMessage': MemberSpec_('ResponseMessage', 'string', 0),
        'ActionType': MemberSpec_('ActionType', 'string', 0),
        'AssistantEmail': MemberSpec_('AssistantEmail', 'string', 0),
        'Primary': MemberSpec_('Primary', 'boolean', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, Description=None, ResponseMessage=None, ActionType=None, AssistantEmail=None, Primary=None):
        self.original_tagname_ = None
        super(ActionBase_18, self).__init__()
        self.Description = Description
        self.ResponseMessage = ResponseMessage
        self.ActionType = ActionType
        self.AssistantEmail = AssistantEmail
        self.Primary = Primary
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ActionBase_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ActionBase_18.subclass:
            return ActionBase_18.subclass(*args_, **kwargs_)
        else:
            return ActionBase_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_ResponseMessage(self): return self.ResponseMessage
    def set_ResponseMessage(self, ResponseMessage): self.ResponseMessage = ResponseMessage
    def get_ActionType(self): return self.ActionType
    def set_ActionType(self, ActionType): self.ActionType = ActionType
    def get_AssistantEmail(self): return self.AssistantEmail
    def set_AssistantEmail(self, AssistantEmail): self.AssistantEmail = AssistantEmail
    def get_Primary(self): return self.Primary
    def set_Primary(self, Primary): self.Primary = Primary
    def hasContent_(self):
        if (
            self.Description is not None or
            self.ResponseMessage is not None or
            self.ActionType is not None or
            self.AssistantEmail is not None or
            self.Primary is not None or
            super(ActionBase_18, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ActionBase_18, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Description':
            Description_ = child_.text
            Description_ = self.gds_validate_string(Description_, node, 'Description')
            self.Description = Description_
        elif nodeName_ == 'ResponseMessage':
            ResponseMessage_ = child_.text
            ResponseMessage_ = self.gds_validate_string(ResponseMessage_, node, 'ResponseMessage')
            self.ResponseMessage = ResponseMessage_
        elif nodeName_ == 'ActionType':
            ActionType_ = child_.text
            ActionType_ = self.gds_validate_string(ActionType_, node, 'ActionType')
            self.ActionType = ActionType_
        elif nodeName_ == 'AssistantEmail':
            AssistantEmail_ = child_.text
            AssistantEmail_ = self.gds_validate_string(AssistantEmail_, node, 'AssistantEmail')
            self.AssistantEmail = AssistantEmail_
        elif nodeName_ == 'Primary':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'Primary')
            self.Primary = ival_
        super(ActionBase_18, self).buildChildren(child_, node, nodeName_, True)
# end class ActionBase_18


class ActionableResource_20(ResourceBase_13):
    member_data_items_ = {
        'NotificationType': MemberSpec_('NotificationType', 'string', 0),
        'Resource': MemberSpec_('Resource', 'ResourceBase_13', 0),
        'DescriptionList': MemberSpec_('DescriptionList', 'ListOfStrings', 0),
        'ActionList': MemberSpec_('ActionList', 'ListOfActions_18', 0),
        'InsightList': MemberSpec_('InsightList', 'ListOfActionableResources_20', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, NotificationType=None, Resource=None, DescriptionList=None, ActionList=None, InsightList=None):
        self.original_tagname_ = None
        super(ActionableResource_20, self).__init__()
        self.NotificationType = NotificationType
        self.Resource = Resource
        self.DescriptionList = DescriptionList
        self.ActionList = ActionList
        self.InsightList = InsightList
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ActionableResource_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ActionableResource_20.subclass:
            return ActionableResource_20.subclass(*args_, **kwargs_)
        else:
            return ActionableResource_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_NotificationType(self): return self.NotificationType
    def set_NotificationType(self, NotificationType): self.NotificationType = NotificationType
    def get_Resource(self): return self.Resource
    def set_Resource(self, Resource): self.Resource = Resource
    def get_DescriptionList(self): return self.DescriptionList
    def set_DescriptionList(self, DescriptionList): self.DescriptionList = DescriptionList
    def get_ActionList(self): return self.ActionList
    def set_ActionList(self, ActionList): self.ActionList = ActionList
    def get_InsightList(self): return self.InsightList
    def set_InsightList(self, InsightList): self.InsightList = InsightList
    def hasContent_(self):
        if (
            self.NotificationType is not None or
            self.Resource is not None or
            self.DescriptionList is not None or
            self.ActionList is not None or
            self.InsightList is not None or
            super(ActionableResource_20, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ActionableResource_20, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'NotificationType':
            NotificationType_ = child_.text
            NotificationType_ = self.gds_validate_string(NotificationType_, node, 'NotificationType')
            self.NotificationType = NotificationType_
        elif nodeName_ == 'Resource':
            class_obj_ = self.get_class_obj_(child_, ResourceBase_13)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Resource = obj_
            obj_.original_tagname_ = 'Resource'
        elif nodeName_ == 'DescriptionList':
            obj_ = ListOfStrings.factory()
            obj_.build(child_)
            self.DescriptionList = obj_
            obj_.original_tagname_ = 'DescriptionList'
        elif nodeName_ == 'ActionList':
            obj_ = ListOfActions_18.factory()
            obj_.build(child_)
            self.ActionList = obj_
            obj_.original_tagname_ = 'ActionList'
        elif nodeName_ == 'InsightList':
            obj_ = ListOfActionableResources_20.factory()
            obj_.build(child_)
            self.InsightList = obj_
            obj_.original_tagname_ = 'InsightList'
        super(ActionableResource_20, self).buildChildren(child_, node, nodeName_, True)
# end class ActionableResource_20


class ActionableResource_21(ResourceBase_13):
    member_data_items_ = {
        'NotificationType': MemberSpec_('NotificationType', 'string', 0),
        'Resource': MemberSpec_('Resource', 'ResourceBase_13', 0),
        'DescriptionList': MemberSpec_('DescriptionList', 'ListOfStrings', 0),
        'ActionList': MemberSpec_('ActionList', 'ListOfActions_18', 0),
        'InsightList': MemberSpec_('InsightList', 'ListOfActionableResources_21', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, NotificationType=None, Resource=None, DescriptionList=None, ActionList=None, InsightList=None):
        self.original_tagname_ = None
        super(ActionableResource_21, self).__init__()
        self.NotificationType = NotificationType
        self.Resource = Resource
        self.DescriptionList = DescriptionList
        self.ActionList = ActionList
        self.InsightList = InsightList
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ActionableResource_21)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ActionableResource_21.subclass:
            return ActionableResource_21.subclass(*args_, **kwargs_)
        else:
            return ActionableResource_21(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_NotificationType(self): return self.NotificationType
    def set_NotificationType(self, NotificationType): self.NotificationType = NotificationType
    def get_Resource(self): return self.Resource
    def set_Resource(self, Resource): self.Resource = Resource
    def get_DescriptionList(self): return self.DescriptionList
    def set_DescriptionList(self, DescriptionList): self.DescriptionList = DescriptionList
    def get_ActionList(self): return self.ActionList
    def set_ActionList(self, ActionList): self.ActionList = ActionList
    def get_InsightList(self): return self.InsightList
    def set_InsightList(self, InsightList): self.InsightList = InsightList
    def hasContent_(self):
        if (
            self.NotificationType is not None or
            self.Resource is not None or
            self.DescriptionList is not None or
            self.ActionList is not None or
            self.InsightList is not None or
            super(ActionableResource_21, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ActionableResource_21, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'NotificationType':
            NotificationType_ = child_.text
            NotificationType_ = self.gds_validate_string(NotificationType_, node, 'NotificationType')
            self.NotificationType = NotificationType_
        elif nodeName_ == 'Resource':
            class_obj_ = self.get_class_obj_(child_, ResourceBase_13)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Resource = obj_
            obj_.original_tagname_ = 'Resource'
        elif nodeName_ == 'DescriptionList':
            obj_ = ListOfStrings.factory()
            obj_.build(child_)
            self.DescriptionList = obj_
            obj_.original_tagname_ = 'DescriptionList'
        elif nodeName_ == 'ActionList':
            obj_ = ListOfActions_18.factory()
            obj_.build(child_)
            self.ActionList = obj_
            obj_.original_tagname_ = 'ActionList'
        elif nodeName_ == 'InsightList':
            obj_ = ListOfActionableResources_21.factory()
            obj_.build(child_)
            self.InsightList = obj_
            obj_.original_tagname_ = 'InsightList'
        super(ActionableResource_21, self).buildChildren(child_, node, nodeName_, True)
# end class ActionableResource_21


class ActionableResource_22(ResourceBase_13):
    member_data_items_ = {
        'NotificationType': MemberSpec_('NotificationType', 'string', 0),
        'Resource': MemberSpec_('Resource', 'ResourceBase_13', 0),
        'DescriptionList': MemberSpec_('DescriptionList', 'ListOfStrings', 0),
        'ActionList': MemberSpec_('ActionList', 'ListOfActions_18', 0),
        'InsightList': MemberSpec_('InsightList', 'ListOfActionableResources_22', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, NotificationType=None, Resource=None, DescriptionList=None, ActionList=None, InsightList=None):
        self.original_tagname_ = None
        super(ActionableResource_22, self).__init__()
        self.NotificationType = NotificationType
        self.Resource = Resource
        self.DescriptionList = DescriptionList
        self.ActionList = ActionList
        self.InsightList = InsightList
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ActionableResource_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ActionableResource_22.subclass:
            return ActionableResource_22.subclass(*args_, **kwargs_)
        else:
            return ActionableResource_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_NotificationType(self): return self.NotificationType
    def set_NotificationType(self, NotificationType): self.NotificationType = NotificationType
    def get_Resource(self): return self.Resource
    def set_Resource(self, Resource): self.Resource = Resource
    def get_DescriptionList(self): return self.DescriptionList
    def set_DescriptionList(self, DescriptionList): self.DescriptionList = DescriptionList
    def get_ActionList(self): return self.ActionList
    def set_ActionList(self, ActionList): self.ActionList = ActionList
    def get_InsightList(self): return self.InsightList
    def set_InsightList(self, InsightList): self.InsightList = InsightList
    def hasContent_(self):
        if (
            self.NotificationType is not None or
            self.Resource is not None or
            self.DescriptionList is not None or
            self.ActionList is not None or
            self.InsightList is not None or
            super(ActionableResource_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ActionableResource_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'NotificationType':
            NotificationType_ = child_.text
            NotificationType_ = self.gds_validate_string(NotificationType_, node, 'NotificationType')
            self.NotificationType = NotificationType_
        elif nodeName_ == 'Resource':
            class_obj_ = self.get_class_obj_(child_, ResourceBase_13)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Resource = obj_
            obj_.original_tagname_ = 'Resource'
        elif nodeName_ == 'DescriptionList':
            obj_ = ListOfStrings.factory()
            obj_.build(child_)
            self.DescriptionList = obj_
            obj_.original_tagname_ = 'DescriptionList'
        elif nodeName_ == 'ActionList':
            obj_ = ListOfActions_18.factory()
            obj_.build(child_)
            self.ActionList = obj_
            obj_.original_tagname_ = 'ActionList'
        elif nodeName_ == 'InsightList':
            obj_ = ListOfActionableResources_22.factory()
            obj_.build(child_)
            self.InsightList = obj_
            obj_.original_tagname_ = 'InsightList'
        super(ActionableResource_22, self).buildChildren(child_, node, nodeName_, True)
# end class ActionableResource_22


class OnboardingHintReminderList_20(ResourceBase_13):
    member_data_items_ = {
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self):
        self.original_tagname_ = None
        super(OnboardingHintReminderList_20, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, OnboardingHintReminderList_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if OnboardingHintReminderList_20.subclass:
            return OnboardingHintReminderList_20.subclass(*args_, **kwargs_)
        else:
            return OnboardingHintReminderList_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(OnboardingHintReminderList_20, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(OnboardingHintReminderList_20, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(OnboardingHintReminderList_20, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class OnboardingHintReminderList_20


class OnboardingHintBoardList_20(ResourceBase_13):
    member_data_items_ = {
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self):
        self.original_tagname_ = None
        super(OnboardingHintBoardList_20, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, OnboardingHintBoardList_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if OnboardingHintBoardList_20.subclass:
            return OnboardingHintBoardList_20.subclass(*args_, **kwargs_)
        else:
            return OnboardingHintBoardList_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(OnboardingHintBoardList_20, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(OnboardingHintBoardList_20, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(OnboardingHintBoardList_20, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class OnboardingHintBoardList_20


class OnboardingHintGroupList_20(ResourceBase_13):
    member_data_items_ = {
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self):
        self.original_tagname_ = None
        super(OnboardingHintGroupList_20, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, OnboardingHintGroupList_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if OnboardingHintGroupList_20.subclass:
            return OnboardingHintGroupList_20.subclass(*args_, **kwargs_)
        else:
            return OnboardingHintGroupList_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(OnboardingHintGroupList_20, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(OnboardingHintGroupList_20, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(OnboardingHintGroupList_20, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class OnboardingHintGroupList_20


class OnboardingHintInvite_20(ResourceBase_13):
    member_data_items_ = {
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self):
        self.original_tagname_ = None
        super(OnboardingHintInvite_20, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, OnboardingHintInvite_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if OnboardingHintInvite_20.subclass:
            return OnboardingHintInvite_20.subclass(*args_, **kwargs_)
        else:
            return OnboardingHintInvite_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(OnboardingHintInvite_20, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(OnboardingHintInvite_20, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(OnboardingHintInvite_20, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class OnboardingHintInvite_20


class OnboardingHintLibrary_20(ResourceBase_13):
    member_data_items_ = {
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self):
        self.original_tagname_ = None
        super(OnboardingHintLibrary_20, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, OnboardingHintLibrary_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if OnboardingHintLibrary_20.subclass:
            return OnboardingHintLibrary_20.subclass(*args_, **kwargs_)
        else:
            return OnboardingHintLibrary_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(OnboardingHintLibrary_20, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(OnboardingHintLibrary_20, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(OnboardingHintLibrary_20, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class OnboardingHintLibrary_20


class OnboardingHintUserList_20(ResourceBase_13):
    member_data_items_ = {
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self):
        self.original_tagname_ = None
        super(OnboardingHintUserList_20, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, OnboardingHintUserList_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if OnboardingHintUserList_20.subclass:
            return OnboardingHintUserList_20.subclass(*args_, **kwargs_)
        else:
            return OnboardingHintUserList_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(OnboardingHintUserList_20, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(OnboardingHintUserList_20, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(OnboardingHintUserList_20, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class OnboardingHintUserList_20


class OnboardingHintUserStream_20(ResourceBase_13):
    member_data_items_ = {
        'UserStream': MemberSpec_('UserStream', 'StreamUser_17', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, UserStream=None):
        self.original_tagname_ = None
        super(OnboardingHintUserStream_20, self).__init__()
        self.UserStream = UserStream
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, OnboardingHintUserStream_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if OnboardingHintUserStream_20.subclass:
            return OnboardingHintUserStream_20.subclass(*args_, **kwargs_)
        else:
            return OnboardingHintUserStream_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_UserStream(self): return self.UserStream
    def set_UserStream(self, UserStream): self.UserStream = UserStream
    def hasContent_(self):
        if (
            self.UserStream is not None or
            super(OnboardingHintUserStream_20, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(OnboardingHintUserStream_20, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'UserStream':
            obj_ = StreamUser_17.factory()
            obj_.build(child_)
            self.UserStream = obj_
            obj_.original_tagname_ = 'UserStream'
        super(OnboardingHintUserStream_20, self).buildChildren(child_, node, nodeName_, True)
# end class OnboardingHintUserStream_20


class OnboardingHintImportantStreamList_20(ResourceBase_13):
    member_data_items_ = {
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self):
        self.original_tagname_ = None
        super(OnboardingHintImportantStreamList_20, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, OnboardingHintImportantStreamList_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if OnboardingHintImportantStreamList_20.subclass:
            return OnboardingHintImportantStreamList_20.subclass(*args_, **kwargs_)
        else:
            return OnboardingHintImportantStreamList_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(OnboardingHintImportantStreamList_20, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(OnboardingHintImportantStreamList_20, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(OnboardingHintImportantStreamList_20, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class OnboardingHintImportantStreamList_20


class OnboardingHintMutedStreamList_20(ResourceBase_13):
    member_data_items_ = {
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self):
        self.original_tagname_ = None
        super(OnboardingHintMutedStreamList_20, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, OnboardingHintMutedStreamList_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if OnboardingHintMutedStreamList_20.subclass:
            return OnboardingHintMutedStreamList_20.subclass(*args_, **kwargs_)
        else:
            return OnboardingHintMutedStreamList_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(OnboardingHintMutedStreamList_20, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(OnboardingHintMutedStreamList_20, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(OnboardingHintMutedStreamList_20, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class OnboardingHintMutedStreamList_20


class OnboardingHintFollowup_20(ResourceBase_13):
    member_data_items_ = {
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self):
        self.original_tagname_ = None
        super(OnboardingHintFollowup_20, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, OnboardingHintFollowup_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if OnboardingHintFollowup_20.subclass:
            return OnboardingHintFollowup_20.subclass(*args_, **kwargs_)
        else:
            return OnboardingHintFollowup_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(OnboardingHintFollowup_20, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(OnboardingHintFollowup_20, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(OnboardingHintFollowup_20, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class OnboardingHintFollowup_20


class StreamBase_17(ResourceBase_13):
    member_data_items_ = {
        'IsVisible': MemberSpec_('IsVisible', 'boolean', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, IsVisible=None):
        self.original_tagname_ = None
        super(StreamBase_17, self).__init__()
        self.IsVisible = IsVisible
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StreamBase_17)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StreamBase_17.subclass:
            return StreamBase_17.subclass(*args_, **kwargs_)
        else:
            return StreamBase_17(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_IsVisible(self): return self.IsVisible
    def set_IsVisible(self, IsVisible): self.IsVisible = IsVisible
    def hasContent_(self):
        if (
            self.IsVisible is not None or
            super(StreamBase_17, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(StreamBase_17, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'IsVisible':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsVisible')
            self.IsVisible = ival_
        super(StreamBase_17, self).buildChildren(child_, node, nodeName_, True)
# end class StreamBase_17


class StreamGroup_17(StreamBase_17):
    member_data_items_ = {
        'Members': MemberSpec_('Members', 'ListOfUsers_14', 0),
        'MemberCount': MemberSpec_('MemberCount', 'int', 0),
        'Administrators': MemberSpec_('Administrators', 'ListOfUsers_14', 0),
        'AdministratorCount': MemberSpec_('AdministratorCount', 'int', 0),
        'Description': MemberSpec_('Description', 'string', 0),
    }
    subclass = None
    superclass = StreamBase_17
    def __init__(self, Members=None, MemberCount=None, Administrators=None, AdministratorCount=None, Description=None):
        self.original_tagname_ = None
        super(StreamGroup_17, self).__init__()
        self.Members = Members
        self.MemberCount = MemberCount
        self.Administrators = Administrators
        self.AdministratorCount = AdministratorCount
        self.Description = Description
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StreamGroup_17)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StreamGroup_17.subclass:
            return StreamGroup_17.subclass(*args_, **kwargs_)
        else:
            return StreamGroup_17(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Members(self): return self.Members
    def set_Members(self, Members): self.Members = Members
    def get_MemberCount(self): return self.MemberCount
    def set_MemberCount(self, MemberCount): self.MemberCount = MemberCount
    def get_Administrators(self): return self.Administrators
    def set_Administrators(self, Administrators): self.Administrators = Administrators
    def get_AdministratorCount(self): return self.AdministratorCount
    def set_AdministratorCount(self, AdministratorCount): self.AdministratorCount = AdministratorCount
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def hasContent_(self):
        if (
            self.Members is not None or
            self.MemberCount is not None or
            self.Administrators is not None or
            self.AdministratorCount is not None or
            self.Description is not None or
            super(StreamGroup_17, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(StreamGroup_17, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Members':
            obj_ = ListOfUsers_14.factory()
            obj_.build(child_)
            self.Members = obj_
            obj_.original_tagname_ = 'Members'
        elif nodeName_ == 'MemberCount':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'MemberCount')
            self.MemberCount = ival_
        elif nodeName_ == 'Administrators':
            obj_ = ListOfUsers_14.factory()
            obj_.build(child_)
            self.Administrators = obj_
            obj_.original_tagname_ = 'Administrators'
        elif nodeName_ == 'AdministratorCount':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'AdministratorCount')
            self.AdministratorCount = ival_
        elif nodeName_ == 'Description':
            Description_ = child_.text
            Description_ = self.gds_validate_string(Description_, node, 'Description')
            self.Description = Description_
        super(StreamGroup_17, self).buildChildren(child_, node, nodeName_, True)
# end class StreamGroup_17


class StreamUser_17(StreamBase_17):
    member_data_items_ = {
        'User': MemberSpec_('User', 'User_14', 0),
    }
    subclass = None
    superclass = StreamBase_17
    def __init__(self, User=None):
        self.original_tagname_ = None
        super(StreamUser_17, self).__init__()
        self.User = User
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StreamUser_17)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StreamUser_17.subclass:
            return StreamUser_17.subclass(*args_, **kwargs_)
        else:
            return StreamUser_17(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_User(self): return self.User
    def set_User(self, User): self.User = User
    def hasContent_(self):
        if (
            self.User is not None or
            super(StreamUser_17, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(StreamUser_17, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'User':
            class_obj_ = self.get_class_obj_(child_, User_14)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.User = obj_
            obj_.original_tagname_ = 'User'
        super(StreamUser_17, self).buildChildren(child_, node, nodeName_, True)
# end class StreamUser_17


class StreamChat_22(ResourceBase_13):
    member_data_items_ = {
        'PostListPage': MemberSpec_('PostListPage', 'ListOfPostsPage_22', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, PostListPage=None):
        self.original_tagname_ = None
        super(StreamChat_22, self).__init__()
        self.PostListPage = PostListPage
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StreamChat_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StreamChat_22.subclass:
            return StreamChat_22.subclass(*args_, **kwargs_)
        else:
            return StreamChat_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_PostListPage(self): return self.PostListPage
    def set_PostListPage(self, PostListPage): self.PostListPage = PostListPage
    def hasContent_(self):
        if (
            self.PostListPage is not None or
            super(StreamChat_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(StreamChat_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'PostListPage':
            obj_ = ListOfPostsPage_22.factory()
            obj_.build(child_)
            self.PostListPage = obj_
            obj_.original_tagname_ = 'PostListPage'
        super(StreamChat_22, self).buildChildren(child_, node, nodeName_, True)
# end class StreamChat_22


class StreamCards_22(ResourceBase_13):
    member_data_items_ = {
        'CardListPage': MemberSpec_('CardListPage', 'ListOfDiscussionCardsPage_22', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, CardListPage=None):
        self.original_tagname_ = None
        super(StreamCards_22, self).__init__()
        self.CardListPage = CardListPage
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StreamCards_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StreamCards_22.subclass:
            return StreamCards_22.subclass(*args_, **kwargs_)
        else:
            return StreamCards_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_CardListPage(self): return self.CardListPage
    def set_CardListPage(self, CardListPage): self.CardListPage = CardListPage
    def hasContent_(self):
        if (
            self.CardListPage is not None or
            super(StreamCards_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(StreamCards_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'CardListPage':
            obj_ = ListOfDiscussionCardsPage_22.factory()
            obj_.build(child_)
            self.CardListPage = obj_
            obj_.original_tagname_ = 'CardListPage'
        super(StreamCards_22, self).buildChildren(child_, node, nodeName_, True)
# end class StreamCards_22


class StreamAssistant_22(ResourceBase_13):
    member_data_items_ = {
        'Insight': MemberSpec_('Insight', 'string', 0),
        'FlagType': MemberSpec_('FlagType', 'string', 0),
        'Parent': MemberSpec_('Parent', 'Post_22', 0),
        'NudgeText': MemberSpec_('NudgeText', 'string', 0),
        'EmailText': MemberSpec_('EmailText', 'string', 0),
        'InviteText': MemberSpec_('InviteText', 'string', 0),
        'Percentage': MemberSpec_('Percentage', 'string', 0),
        'TotalSent': MemberSpec_('TotalSent', 'string', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, Insight=None, FlagType=None, Parent=None, NudgeText=None, EmailText=None, InviteText=None, Percentage=None, TotalSent=None):
        self.original_tagname_ = None
        super(StreamAssistant_22, self).__init__()
        self.Insight = Insight
        self.FlagType = FlagType
        self.Parent = Parent
        self.NudgeText = NudgeText
        self.EmailText = EmailText
        self.InviteText = InviteText
        self.Percentage = Percentage
        self.TotalSent = TotalSent
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StreamAssistant_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StreamAssistant_22.subclass:
            return StreamAssistant_22.subclass(*args_, **kwargs_)
        else:
            return StreamAssistant_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Insight(self): return self.Insight
    def set_Insight(self, Insight): self.Insight = Insight
    def get_FlagType(self): return self.FlagType
    def set_FlagType(self, FlagType): self.FlagType = FlagType
    def get_Parent(self): return self.Parent
    def set_Parent(self, Parent): self.Parent = Parent
    def get_NudgeText(self): return self.NudgeText
    def set_NudgeText(self, NudgeText): self.NudgeText = NudgeText
    def get_EmailText(self): return self.EmailText
    def set_EmailText(self, EmailText): self.EmailText = EmailText
    def get_InviteText(self): return self.InviteText
    def set_InviteText(self, InviteText): self.InviteText = InviteText
    def get_Percentage(self): return self.Percentage
    def set_Percentage(self, Percentage): self.Percentage = Percentage
    def get_TotalSent(self): return self.TotalSent
    def set_TotalSent(self, TotalSent): self.TotalSent = TotalSent
    def hasContent_(self):
        if (
            self.Insight is not None or
            self.FlagType is not None or
            self.Parent is not None or
            self.NudgeText is not None or
            self.EmailText is not None or
            self.InviteText is not None or
            self.Percentage is not None or
            self.TotalSent is not None or
            super(StreamAssistant_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(StreamAssistant_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Insight':
            Insight_ = child_.text
            Insight_ = self.gds_validate_string(Insight_, node, 'Insight')
            self.Insight = Insight_
        elif nodeName_ == 'FlagType':
            FlagType_ = child_.text
            FlagType_ = self.gds_validate_string(FlagType_, node, 'FlagType')
            self.FlagType = FlagType_
        elif nodeName_ == 'Parent':
            class_obj_ = self.get_class_obj_(child_, Post_22)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Parent = obj_
            obj_.original_tagname_ = 'Parent'
        elif nodeName_ == 'NudgeText':
            NudgeText_ = child_.text
            NudgeText_ = self.gds_validate_string(NudgeText_, node, 'NudgeText')
            self.NudgeText = NudgeText_
        elif nodeName_ == 'EmailText':
            EmailText_ = child_.text
            EmailText_ = self.gds_validate_string(EmailText_, node, 'EmailText')
            self.EmailText = EmailText_
        elif nodeName_ == 'InviteText':
            InviteText_ = child_.text
            InviteText_ = self.gds_validate_string(InviteText_, node, 'InviteText')
            self.InviteText = InviteText_
        elif nodeName_ == 'Percentage':
            Percentage_ = child_.text
            Percentage_ = self.gds_validate_string(Percentage_, node, 'Percentage')
            self.Percentage = Percentage_
        elif nodeName_ == 'TotalSent':
            TotalSent_ = child_.text
            TotalSent_ = self.gds_validate_string(TotalSent_, node, 'TotalSent')
            self.TotalSent = TotalSent_
        super(StreamAssistant_22, self).buildChildren(child_, node, nodeName_, True)
# end class StreamAssistant_22


class StreamBase_22(ResourceBase_13):
    member_data_items_ = {
        'IsVisible': MemberSpec_('IsVisible', 'boolean', 0),
        'LastPost': MemberSpec_('LastPost', 'Post_22', 0),
        'LastUnreadPost': MemberSpec_('LastUnreadPost', 'Post_22', 0),
        'BadgeCount': MemberSpec_('BadgeCount', 'integer', 0),
        'BadgeCountCardStream': MemberSpec_('BadgeCountCardStream', 'integer', 0),
        'BadgeCountChatStream': MemberSpec_('BadgeCountChatStream', 'integer', 0),
        'SortModified': MemberSpec_('SortModified', 'dateTime', 0),
        'Parent': MemberSpec_('Parent', 'Menu_22', 0),
        'StreamAssistant': MemberSpec_('StreamAssistant', 'StreamAssistant_22', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, IsVisible=None, LastPost=None, LastUnreadPost=None, BadgeCount=None, BadgeCountCardStream=None, BadgeCountChatStream=None, SortModified=None, Parent=None, StreamAssistant=None):
        self.original_tagname_ = None
        super(StreamBase_22, self).__init__()
        self.IsVisible = IsVisible
        self.LastPost = LastPost
        self.LastUnreadPost = LastUnreadPost
        self.BadgeCount = BadgeCount
        self.BadgeCountCardStream = BadgeCountCardStream
        self.BadgeCountChatStream = BadgeCountChatStream
        if isinstance(SortModified, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(SortModified, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = SortModified
        self.SortModified = initvalue_
        self.Parent = Parent
        self.StreamAssistant = StreamAssistant
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StreamBase_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StreamBase_22.subclass:
            return StreamBase_22.subclass(*args_, **kwargs_)
        else:
            return StreamBase_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_IsVisible(self): return self.IsVisible
    def set_IsVisible(self, IsVisible): self.IsVisible = IsVisible
    def get_LastPost(self): return self.LastPost
    def set_LastPost(self, LastPost): self.LastPost = LastPost
    def get_LastUnreadPost(self): return self.LastUnreadPost
    def set_LastUnreadPost(self, LastUnreadPost): self.LastUnreadPost = LastUnreadPost
    def get_BadgeCount(self): return self.BadgeCount
    def set_BadgeCount(self, BadgeCount): self.BadgeCount = BadgeCount
    def get_BadgeCountCardStream(self): return self.BadgeCountCardStream
    def set_BadgeCountCardStream(self, BadgeCountCardStream): self.BadgeCountCardStream = BadgeCountCardStream
    def get_BadgeCountChatStream(self): return self.BadgeCountChatStream
    def set_BadgeCountChatStream(self, BadgeCountChatStream): self.BadgeCountChatStream = BadgeCountChatStream
    def get_SortModified(self): return self.SortModified
    def set_SortModified(self, SortModified): self.SortModified = SortModified
    def get_Parent(self): return self.Parent
    def set_Parent(self, Parent): self.Parent = Parent
    def get_StreamAssistant(self): return self.StreamAssistant
    def set_StreamAssistant(self, StreamAssistant): self.StreamAssistant = StreamAssistant
    def hasContent_(self):
        if (
            self.IsVisible is not None or
            self.LastPost is not None or
            self.LastUnreadPost is not None or
            self.BadgeCount is not None or
            self.BadgeCountCardStream is not None or
            self.BadgeCountChatStream is not None or
            self.SortModified is not None or
            self.Parent is not None or
            self.StreamAssistant is not None or
            super(StreamBase_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(StreamBase_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'IsVisible':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsVisible')
            self.IsVisible = ival_
        elif nodeName_ == 'LastPost':
            class_obj_ = self.get_class_obj_(child_, Post_22)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.LastPost = obj_
            obj_.original_tagname_ = 'LastPost'
        elif nodeName_ == 'LastUnreadPost':
            class_obj_ = self.get_class_obj_(child_, Post_22)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.LastUnreadPost = obj_
            obj_.original_tagname_ = 'LastUnreadPost'
        elif nodeName_ == 'BadgeCount':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'BadgeCount')
            self.BadgeCount = ival_
        elif nodeName_ == 'BadgeCountCardStream':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'BadgeCountCardStream')
            self.BadgeCountCardStream = ival_
        elif nodeName_ == 'BadgeCountChatStream':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'BadgeCountChatStream')
            self.BadgeCountChatStream = ival_
        elif nodeName_ == 'SortModified':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.SortModified = dval_
        elif nodeName_ == 'Parent':
            obj_ = Menu_22.factory()
            obj_.build(child_)
            self.Parent = obj_
            obj_.original_tagname_ = 'Parent'
        elif nodeName_ == 'StreamAssistant':
            obj_ = StreamAssistant_22.factory()
            obj_.build(child_)
            self.StreamAssistant = obj_
            obj_.original_tagname_ = 'StreamAssistant'
        super(StreamBase_22, self).buildChildren(child_, node, nodeName_, True)
# end class StreamBase_22


class Chat_15(ResourceBase_13):
    member_data_items_ = {
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self):
        self.original_tagname_ = None
        super(Chat_15, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Chat_15)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Chat_15.subclass:
            return Chat_15.subclass(*args_, **kwargs_)
        else:
            return Chat_15(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(Chat_15, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Chat_15, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(Chat_15, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class Chat_15


class BoardBase_15(ResourceBase_13):
    member_data_items_ = {
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self):
        self.original_tagname_ = None
        super(BoardBase_15, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BoardBase_15)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BoardBase_15.subclass:
            return BoardBase_15.subclass(*args_, **kwargs_)
        else:
            return BoardBase_15(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(BoardBase_15, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(BoardBase_15, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(BoardBase_15, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class BoardBase_15


class BoardBase_20(ResourceBase_13):
    member_data_items_ = {
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self):
        self.original_tagname_ = None
        super(BoardBase_20, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BoardBase_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BoardBase_20.subclass:
            return BoardBase_20.subclass(*args_, **kwargs_)
        else:
            return BoardBase_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(BoardBase_20, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(BoardBase_20, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(BoardBase_20, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class BoardBase_20


class BoardPersonal_21(ResourceBase_13):
    member_data_items_ = {
        'PinnedItemList': MemberSpec_('PinnedItemList', 'ListOfPinnedItems_21', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, PinnedItemList=None):
        self.original_tagname_ = None
        super(BoardPersonal_21, self).__init__()
        self.PinnedItemList = PinnedItemList
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BoardPersonal_21)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BoardPersonal_21.subclass:
            return BoardPersonal_21.subclass(*args_, **kwargs_)
        else:
            return BoardPersonal_21(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_PinnedItemList(self): return self.PinnedItemList
    def set_PinnedItemList(self, PinnedItemList): self.PinnedItemList = PinnedItemList
    def hasContent_(self):
        if (
            self.PinnedItemList is not None or
            super(BoardPersonal_21, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(BoardPersonal_21, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'PinnedItemList':
            obj_ = ListOfPinnedItems_21.factory()
            obj_.build(child_)
            self.PinnedItemList = obj_
            obj_.original_tagname_ = 'PinnedItemList'
        super(BoardPersonal_21, self).buildChildren(child_, node, nodeName_, True)
# end class BoardPersonal_21


class BoardBase_22(ResourceBase_13):
    member_data_items_ = {
        'Type': MemberSpec_('Type', 'string', 0),
        'PinnedItemList': MemberSpec_('PinnedItemList', 'ListOfPinnedItems_22', 0),
        'PinnedItemCount': MemberSpec_('PinnedItemCount', 'integer', 0),
        'LastPost': MemberSpec_('LastPost', 'Post_22', 0),
        'ParentGroup': MemberSpec_('ParentGroup', 'Group_17', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, Type=None, PinnedItemList=None, PinnedItemCount=None, LastPost=None, ParentGroup=None):
        self.original_tagname_ = None
        super(BoardBase_22, self).__init__()
        self.Type = Type
        self.PinnedItemList = PinnedItemList
        self.PinnedItemCount = PinnedItemCount
        self.LastPost = LastPost
        self.ParentGroup = ParentGroup
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BoardBase_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BoardBase_22.subclass:
            return BoardBase_22.subclass(*args_, **kwargs_)
        else:
            return BoardBase_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Type(self): return self.Type
    def set_Type(self, Type): self.Type = Type
    def get_PinnedItemList(self): return self.PinnedItemList
    def set_PinnedItemList(self, PinnedItemList): self.PinnedItemList = PinnedItemList
    def get_PinnedItemCount(self): return self.PinnedItemCount
    def set_PinnedItemCount(self, PinnedItemCount): self.PinnedItemCount = PinnedItemCount
    def get_LastPost(self): return self.LastPost
    def set_LastPost(self, LastPost): self.LastPost = LastPost
    def get_ParentGroup(self): return self.ParentGroup
    def set_ParentGroup(self, ParentGroup): self.ParentGroup = ParentGroup
    def hasContent_(self):
        if (
            self.Type is not None or
            self.PinnedItemList is not None or
            self.PinnedItemCount is not None or
            self.LastPost is not None or
            self.ParentGroup is not None or
            super(BoardBase_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(BoardBase_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Type':
            Type_ = child_.text
            Type_ = self.gds_validate_string(Type_, node, 'Type')
            self.Type = Type_
        elif nodeName_ == 'PinnedItemList':
            obj_ = ListOfPinnedItems_22.factory()
            obj_.build(child_)
            self.PinnedItemList = obj_
            obj_.original_tagname_ = 'PinnedItemList'
        elif nodeName_ == 'PinnedItemCount':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'PinnedItemCount')
            self.PinnedItemCount = ival_
        elif nodeName_ == 'LastPost':
            class_obj_ = self.get_class_obj_(child_, Post_22)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.LastPost = obj_
            obj_.original_tagname_ = 'LastPost'
        elif nodeName_ == 'ParentGroup':
            obj_ = Group_17.factory()
            obj_.build(child_)
            self.ParentGroup = obj_
            obj_.original_tagname_ = 'ParentGroup'
        super(BoardBase_22, self).buildChildren(child_, node, nodeName_, True)
# end class BoardBase_22


class BoardPersonal_22(BoardBase_22):
    member_data_items_ = {
    }
    subclass = None
    superclass = BoardBase_22
    def __init__(self):
        self.original_tagname_ = None
        super(BoardPersonal_22, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BoardPersonal_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BoardPersonal_22.subclass:
            return BoardPersonal_22.subclass(*args_, **kwargs_)
        else:
            return BoardPersonal_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(BoardPersonal_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(BoardPersonal_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(BoardPersonal_22, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class BoardPersonal_22


class BoardGroup_22(BoardBase_22):
    member_data_items_ = {
    }
    subclass = None
    superclass = BoardBase_22
    def __init__(self):
        self.original_tagname_ = None
        super(BoardGroup_22, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BoardGroup_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BoardGroup_22.subclass:
            return BoardGroup_22.subclass(*args_, **kwargs_)
        else:
            return BoardGroup_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(BoardGroup_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(BoardGroup_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(BoardGroup_22, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class BoardGroup_22


class SortActionBase_13(ResourceBase_13):
    member_data_items_ = {
        'DirectionHint': MemberSpec_('DirectionHint', 'SortDirectionHint_13', 0),
        'DefaultDirection': MemberSpec_('DefaultDirection', ['SortDirection', 'string'], 0),
        'IsSelected': MemberSpec_('IsSelected', 'SelectedSortAction_13', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, DirectionHint=None, DefaultDirection=None, IsSelected=None):
        self.original_tagname_ = None
        super(SortActionBase_13, self).__init__()
        self.DirectionHint = DirectionHint
        self.DefaultDirection = DefaultDirection
        self.validate_SortDirection(self.DefaultDirection)
        self.IsSelected = IsSelected
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SortActionBase_13)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SortActionBase_13.subclass:
            return SortActionBase_13.subclass(*args_, **kwargs_)
        else:
            return SortActionBase_13(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_DirectionHint(self): return self.DirectionHint
    def set_DirectionHint(self, DirectionHint): self.DirectionHint = DirectionHint
    def get_DefaultDirection(self): return self.DefaultDirection
    def set_DefaultDirection(self, DefaultDirection): self.DefaultDirection = DefaultDirection
    def get_IsSelected(self): return self.IsSelected
    def set_IsSelected(self, IsSelected): self.IsSelected = IsSelected
    def validate_SortDirection(self, value):
        # Validate type SortDirection, a restriction on string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['Ascending', 'Descending']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on SortDirection' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.DirectionHint is not None or
            self.DefaultDirection is not None or
            self.IsSelected is not None or
            super(SortActionBase_13, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(SortActionBase_13, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'DirectionHint':
            obj_ = SortDirectionHint_13.factory()
            obj_.build(child_)
            self.DirectionHint = obj_
            obj_.original_tagname_ = 'DirectionHint'
        elif nodeName_ == 'DefaultDirection':
            DefaultDirection_ = child_.text
            DefaultDirection_ = self.gds_validate_string(DefaultDirection_, node, 'DefaultDirection')
            self.DefaultDirection = DefaultDirection_
            # validate type SortDirection
            self.validate_SortDirection(self.DefaultDirection)
        elif nodeName_ == 'IsSelected':
            obj_ = SelectedSortAction_13.factory()
            obj_.build(child_)
            self.IsSelected = obj_
            obj_.original_tagname_ = 'IsSelected'
        super(SortActionBase_13, self).buildChildren(child_, node, nodeName_, True)
# end class SortActionBase_13


class ContextBase_13(ResourceBase_13):
    member_data_items_ = {
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self):
        self.original_tagname_ = None
        super(ContextBase_13, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ContextBase_13)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ContextBase_13.subclass:
            return ContextBase_13.subclass(*args_, **kwargs_)
        else:
            return ContextBase_13(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(ContextBase_13, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ContextBase_13, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ContextBase_13, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ContextBase_13


class AppointmentResponse_22(ResourceBase_13):
    member_data_items_ = {
        'Status': MemberSpec_('Status', 'string', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, Status=None):
        self.original_tagname_ = None
        super(AppointmentResponse_22, self).__init__()
        self.Status = Status
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AppointmentResponse_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AppointmentResponse_22.subclass:
            return AppointmentResponse_22.subclass(*args_, **kwargs_)
        else:
            return AppointmentResponse_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Status(self): return self.Status
    def set_Status(self, Status): self.Status = Status
    def hasContent_(self):
        if (
            self.Status is not None or
            super(AppointmentResponse_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(AppointmentResponse_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Status':
            Status_ = child_.text
            Status_ = self.gds_validate_string(Status_, node, 'Status')
            self.Status = Status_
        super(AppointmentResponse_22, self).buildChildren(child_, node, nodeName_, True)
# end class AppointmentResponse_22


class SignatureImage_20(ResourceBase_13):
    member_data_items_ = {
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self):
        self.original_tagname_ = None
        super(SignatureImage_20, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SignatureImage_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SignatureImage_20.subclass:
            return SignatureImage_20.subclass(*args_, **kwargs_)
        else:
            return SignatureImage_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(SignatureImage_20, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(SignatureImage_20, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(SignatureImage_20, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class SignatureImage_20


class Signature_20(ResourceBase_13):
    member_data_items_ = {
        'Title': MemberSpec_('Title', 'string', 0),
        'Text': MemberSpec_('Text', 'string', 0),
        'Html': MemberSpec_('Html', 'string', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, Title=None, Text=None, Html=None):
        self.original_tagname_ = None
        super(Signature_20, self).__init__()
        self.Title = Title
        self.Text = Text
        self.Html = Html
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Signature_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Signature_20.subclass:
            return Signature_20.subclass(*args_, **kwargs_)
        else:
            return Signature_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Title(self): return self.Title
    def set_Title(self, Title): self.Title = Title
    def get_Text(self): return self.Text
    def set_Text(self, Text): self.Text = Text
    def get_Html(self): return self.Html
    def set_Html(self, Html): self.Html = Html
    def hasContent_(self):
        if (
            self.Title is not None or
            self.Text is not None or
            self.Html is not None or
            super(Signature_20, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Signature_20, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Title':
            Title_ = child_.text
            Title_ = self.gds_validate_string(Title_, node, 'Title')
            self.Title = Title_
        elif nodeName_ == 'Text':
            Text_ = child_.text
            Text_ = self.gds_validate_string(Text_, node, 'Text')
            self.Text = Text_
        elif nodeName_ == 'Html':
            Html_ = child_.text
            Html_ = self.gds_validate_string(Html_, node, 'Html')
            self.Html = Html_
        super(Signature_20, self).buildChildren(child_, node, nodeName_, True)
# end class Signature_20


class PostFlagManagedByAssistant_20(FlagManagedByAssistantBase_20):
    member_data_items_ = {
        'ReminderType': MemberSpec_('ReminderType', 'string', 0),
        'AutomaticDetection': MemberSpec_('AutomaticDetection', 'boolean', 0),
    }
    subclass = None
    superclass = FlagManagedByAssistantBase_20
    def __init__(self, ReminderType=None, AutomaticDetection=None):
        self.original_tagname_ = None
        super(PostFlagManagedByAssistant_20, self).__init__()
        self.ReminderType = ReminderType
        self.AutomaticDetection = AutomaticDetection
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PostFlagManagedByAssistant_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PostFlagManagedByAssistant_20.subclass:
            return PostFlagManagedByAssistant_20.subclass(*args_, **kwargs_)
        else:
            return PostFlagManagedByAssistant_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ReminderType(self): return self.ReminderType
    def set_ReminderType(self, ReminderType): self.ReminderType = ReminderType
    def get_AutomaticDetection(self): return self.AutomaticDetection
    def set_AutomaticDetection(self, AutomaticDetection): self.AutomaticDetection = AutomaticDetection
    def hasContent_(self):
        if (
            self.ReminderType is not None or
            self.AutomaticDetection is not None or
            super(PostFlagManagedByAssistant_20, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(PostFlagManagedByAssistant_20, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ReminderType':
            ReminderType_ = child_.text
            ReminderType_ = self.gds_validate_string(ReminderType_, node, 'ReminderType')
            self.ReminderType = ReminderType_
        elif nodeName_ == 'AutomaticDetection':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'AutomaticDetection')
            self.AutomaticDetection = ival_
        super(PostFlagManagedByAssistant_20, self).buildChildren(child_, node, nodeName_, True)
# end class PostFlagManagedByAssistant_20


class Post_15(ResourceBase_13):
    member_data_items_ = {
        'Text': MemberSpec_('Text', 'string', 0),
        'ShareList': MemberSpec_('ShareList', 'ListOfResources_13', 0),
        'ParentId': MemberSpec_('ParentId', 'string', 0),
        'Files': MemberSpec_('Files', 'ListOfFiles_14', 0),
        'Author': MemberSpec_('Author', 'User_14', 0),
        'StreamId': MemberSpec_('StreamId', 'string', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, Text=None, ShareList=None, ParentId=None, Files=None, Author=None, StreamId=None):
        self.original_tagname_ = None
        super(Post_15, self).__init__()
        self.Text = Text
        self.ShareList = ShareList
        self.ParentId = ParentId
        self.Files = Files
        self.Author = Author
        self.StreamId = StreamId
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Post_15)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Post_15.subclass:
            return Post_15.subclass(*args_, **kwargs_)
        else:
            return Post_15(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Text(self): return self.Text
    def set_Text(self, Text): self.Text = Text
    def get_ShareList(self): return self.ShareList
    def set_ShareList(self, ShareList): self.ShareList = ShareList
    def get_ParentId(self): return self.ParentId
    def set_ParentId(self, ParentId): self.ParentId = ParentId
    def get_Files(self): return self.Files
    def set_Files(self, Files): self.Files = Files
    def get_Author(self): return self.Author
    def set_Author(self, Author): self.Author = Author
    def get_StreamId(self): return self.StreamId
    def set_StreamId(self, StreamId): self.StreamId = StreamId
    def hasContent_(self):
        if (
            self.Text is not None or
            self.ShareList is not None or
            self.ParentId is not None or
            self.Files is not None or
            self.Author is not None or
            self.StreamId is not None or
            super(Post_15, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Post_15, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Text':
            Text_ = child_.text
            Text_ = self.gds_validate_string(Text_, node, 'Text')
            self.Text = Text_
        elif nodeName_ == 'ShareList':
            obj_ = ListOfResources_13.factory()
            obj_.build(child_)
            self.ShareList = obj_
            obj_.original_tagname_ = 'ShareList'
        elif nodeName_ == 'ParentId':
            ParentId_ = child_.text
            ParentId_ = self.gds_validate_string(ParentId_, node, 'ParentId')
            self.ParentId = ParentId_
        elif nodeName_ == 'Files':
            obj_ = ListOfFiles_14.factory()
            obj_.build(child_)
            self.Files = obj_
            obj_.original_tagname_ = 'Files'
        elif nodeName_ == 'Author':
            class_obj_ = self.get_class_obj_(child_, User_14)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Author = obj_
            obj_.original_tagname_ = 'Author'
        elif nodeName_ == 'StreamId':
            StreamId_ = child_.text
            StreamId_ = self.gds_validate_string(StreamId_, node, 'StreamId')
            self.StreamId = StreamId_
        super(Post_15, self).buildChildren(child_, node, nodeName_, True)
# end class Post_15


class Post_18(ResourceBase_13):
    member_data_items_ = {
        'Text': MemberSpec_('Text', 'string', 0),
        'ShareList': MemberSpec_('ShareList', 'ListOfResources_13', 0),
        'VisibilityListCount': MemberSpec_('VisibilityListCount', 'int', 0),
        'Files': MemberSpec_('Files', 'ListOfFiles_14', 0),
        'Author': MemberSpec_('Author', 'User_14', 0),
        'Parent': MemberSpec_('Parent', 'DiscussionBase_18', 0),
        'Unread': MemberSpec_('Unread', 'boolean', 0),
        'UnreadClearedAt': MemberSpec_('UnreadClearedAt', 'dateTime', 0),
        'ErrorSending': MemberSpec_('ErrorSending', 'boolean', 0),
        'ImportedViaEmail': MemberSpec_('ImportedViaEmail', 'boolean', 0),
        'ForwardedCopy': MemberSpec_('ForwardedCopy', 'boolean', 0),
        'BodyFormat': MemberSpec_('BodyFormat', 'BodyFormat_18', 0),
        'ManagedByAssistant': MemberSpec_('ManagedByAssistant', 'boolean', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, Text=None, ShareList=None, VisibilityListCount=None, Files=None, Author=None, Parent=None, Unread=None, UnreadClearedAt=None, ErrorSending=None, ImportedViaEmail=None, ForwardedCopy=None, BodyFormat=None, ManagedByAssistant=None):
        self.original_tagname_ = None
        super(Post_18, self).__init__()
        self.Text = Text
        self.ShareList = ShareList
        self.VisibilityListCount = VisibilityListCount
        self.Files = Files
        self.Author = Author
        self.Parent = Parent
        self.Unread = Unread
        if isinstance(UnreadClearedAt, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(UnreadClearedAt, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = UnreadClearedAt
        self.UnreadClearedAt = initvalue_
        self.ErrorSending = ErrorSending
        self.ImportedViaEmail = ImportedViaEmail
        self.ForwardedCopy = ForwardedCopy
        self.BodyFormat = BodyFormat
        self.ManagedByAssistant = ManagedByAssistant
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Post_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Post_18.subclass:
            return Post_18.subclass(*args_, **kwargs_)
        else:
            return Post_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Text(self): return self.Text
    def set_Text(self, Text): self.Text = Text
    def get_ShareList(self): return self.ShareList
    def set_ShareList(self, ShareList): self.ShareList = ShareList
    def get_VisibilityListCount(self): return self.VisibilityListCount
    def set_VisibilityListCount(self, VisibilityListCount): self.VisibilityListCount = VisibilityListCount
    def get_Files(self): return self.Files
    def set_Files(self, Files): self.Files = Files
    def get_Author(self): return self.Author
    def set_Author(self, Author): self.Author = Author
    def get_Parent(self): return self.Parent
    def set_Parent(self, Parent): self.Parent = Parent
    def get_Unread(self): return self.Unread
    def set_Unread(self, Unread): self.Unread = Unread
    def get_UnreadClearedAt(self): return self.UnreadClearedAt
    def set_UnreadClearedAt(self, UnreadClearedAt): self.UnreadClearedAt = UnreadClearedAt
    def get_ErrorSending(self): return self.ErrorSending
    def set_ErrorSending(self, ErrorSending): self.ErrorSending = ErrorSending
    def get_ImportedViaEmail(self): return self.ImportedViaEmail
    def set_ImportedViaEmail(self, ImportedViaEmail): self.ImportedViaEmail = ImportedViaEmail
    def get_ForwardedCopy(self): return self.ForwardedCopy
    def set_ForwardedCopy(self, ForwardedCopy): self.ForwardedCopy = ForwardedCopy
    def get_BodyFormat(self): return self.BodyFormat
    def set_BodyFormat(self, BodyFormat): self.BodyFormat = BodyFormat
    def get_ManagedByAssistant(self): return self.ManagedByAssistant
    def set_ManagedByAssistant(self, ManagedByAssistant): self.ManagedByAssistant = ManagedByAssistant
    def hasContent_(self):
        if (
            self.Text is not None or
            self.ShareList is not None or
            self.VisibilityListCount is not None or
            self.Files is not None or
            self.Author is not None or
            self.Parent is not None or
            self.Unread is not None or
            self.UnreadClearedAt is not None or
            self.ErrorSending is not None or
            self.ImportedViaEmail is not None or
            self.ForwardedCopy is not None or
            self.BodyFormat is not None or
            self.ManagedByAssistant is not None or
            super(Post_18, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Post_18, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Text':
            Text_ = child_.text
            Text_ = self.gds_validate_string(Text_, node, 'Text')
            self.Text = Text_
        elif nodeName_ == 'ShareList':
            obj_ = ListOfResources_13.factory()
            obj_.build(child_)
            self.ShareList = obj_
            obj_.original_tagname_ = 'ShareList'
        elif nodeName_ == 'VisibilityListCount':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'VisibilityListCount')
            self.VisibilityListCount = ival_
        elif nodeName_ == 'Files':
            obj_ = ListOfFiles_14.factory()
            obj_.build(child_)
            self.Files = obj_
            obj_.original_tagname_ = 'Files'
        elif nodeName_ == 'Author':
            class_obj_ = self.get_class_obj_(child_, User_14)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Author = obj_
            obj_.original_tagname_ = 'Author'
        elif nodeName_ == 'Parent':
            class_obj_ = self.get_class_obj_(child_, DiscussionBase_18)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Parent = obj_
            obj_.original_tagname_ = 'Parent'
        elif nodeName_ == 'Unread':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'Unread')
            self.Unread = ival_
        elif nodeName_ == 'UnreadClearedAt':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.UnreadClearedAt = dval_
        elif nodeName_ == 'ErrorSending':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'ErrorSending')
            self.ErrorSending = ival_
        elif nodeName_ == 'ImportedViaEmail':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'ImportedViaEmail')
            self.ImportedViaEmail = ival_
        elif nodeName_ == 'ForwardedCopy':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'ForwardedCopy')
            self.ForwardedCopy = ival_
        elif nodeName_ == 'BodyFormat':
            obj_ = BodyFormat_18.factory()
            obj_.build(child_)
            self.BodyFormat = obj_
            obj_.original_tagname_ = 'BodyFormat'
        elif nodeName_ == 'ManagedByAssistant':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'ManagedByAssistant')
            self.ManagedByAssistant = ival_
        super(Post_18, self).buildChildren(child_, node, nodeName_, True)
# end class Post_18


class Post_20(ResourceBase_13):
    member_data_items_ = {
        'Text': MemberSpec_('Text', 'string', 0),
        'ShareList': MemberSpec_('ShareList', 'ListOfResources_13', 0),
        'VisibilityListCount': MemberSpec_('VisibilityListCount', 'int', 0),
        'Author': MemberSpec_('Author', 'User_14', 0),
        'Parent': MemberSpec_('Parent', 'DiscussionBase_20', 0),
        'Files': MemberSpec_('Files', 'ListOfFiles_14', 0),
        'Unread': MemberSpec_('Unread', 'boolean', 0),
        'UnreadClearedAt': MemberSpec_('UnreadClearedAt', 'dateTime', 0),
        'ErrorSending': MemberSpec_('ErrorSending', 'boolean', 0),
        'ImportedViaEmail': MemberSpec_('ImportedViaEmail', 'boolean', 0),
        'ForwardedCopy': MemberSpec_('ForwardedCopy', 'boolean', 0),
        'BodyFormat': MemberSpec_('BodyFormat', 'BodyFormat_18', 0),
        'BodyHtml': MemberSpec_('BodyHtml', 'string', 0),
        'BodySnippet': MemberSpec_('BodySnippet', 'string', 0),
        'ManagedByAssistant': MemberSpec_('ManagedByAssistant', 'boolean', 0),
        'ReminderType': MemberSpec_('ReminderType', 'string', 0),
        'ClientResourceId': MemberSpec_('ClientResourceId', 'string', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, Text=None, ShareList=None, VisibilityListCount=None, Author=None, Parent=None, Files=None, Unread=None, UnreadClearedAt=None, ErrorSending=None, ImportedViaEmail=None, ForwardedCopy=None, BodyFormat=None, BodyHtml=None, BodySnippet=None, ManagedByAssistant=None, ReminderType=None, ClientResourceId=None):
        self.original_tagname_ = None
        super(Post_20, self).__init__()
        self.Text = Text
        self.ShareList = ShareList
        self.VisibilityListCount = VisibilityListCount
        self.Author = Author
        self.Parent = Parent
        self.Files = Files
        self.Unread = Unread
        if isinstance(UnreadClearedAt, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(UnreadClearedAt, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = UnreadClearedAt
        self.UnreadClearedAt = initvalue_
        self.ErrorSending = ErrorSending
        self.ImportedViaEmail = ImportedViaEmail
        self.ForwardedCopy = ForwardedCopy
        self.BodyFormat = BodyFormat
        self.BodyHtml = BodyHtml
        self.BodySnippet = BodySnippet
        self.ManagedByAssistant = ManagedByAssistant
        self.ReminderType = ReminderType
        self.ClientResourceId = ClientResourceId
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Post_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Post_20.subclass:
            return Post_20.subclass(*args_, **kwargs_)
        else:
            return Post_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Text(self): return self.Text
    def set_Text(self, Text): self.Text = Text
    def get_ShareList(self): return self.ShareList
    def set_ShareList(self, ShareList): self.ShareList = ShareList
    def get_VisibilityListCount(self): return self.VisibilityListCount
    def set_VisibilityListCount(self, VisibilityListCount): self.VisibilityListCount = VisibilityListCount
    def get_Author(self): return self.Author
    def set_Author(self, Author): self.Author = Author
    def get_Parent(self): return self.Parent
    def set_Parent(self, Parent): self.Parent = Parent
    def get_Files(self): return self.Files
    def set_Files(self, Files): self.Files = Files
    def get_Unread(self): return self.Unread
    def set_Unread(self, Unread): self.Unread = Unread
    def get_UnreadClearedAt(self): return self.UnreadClearedAt
    def set_UnreadClearedAt(self, UnreadClearedAt): self.UnreadClearedAt = UnreadClearedAt
    def get_ErrorSending(self): return self.ErrorSending
    def set_ErrorSending(self, ErrorSending): self.ErrorSending = ErrorSending
    def get_ImportedViaEmail(self): return self.ImportedViaEmail
    def set_ImportedViaEmail(self, ImportedViaEmail): self.ImportedViaEmail = ImportedViaEmail
    def get_ForwardedCopy(self): return self.ForwardedCopy
    def set_ForwardedCopy(self, ForwardedCopy): self.ForwardedCopy = ForwardedCopy
    def get_BodyFormat(self): return self.BodyFormat
    def set_BodyFormat(self, BodyFormat): self.BodyFormat = BodyFormat
    def get_BodyHtml(self): return self.BodyHtml
    def set_BodyHtml(self, BodyHtml): self.BodyHtml = BodyHtml
    def get_BodySnippet(self): return self.BodySnippet
    def set_BodySnippet(self, BodySnippet): self.BodySnippet = BodySnippet
    def get_ManagedByAssistant(self): return self.ManagedByAssistant
    def set_ManagedByAssistant(self, ManagedByAssistant): self.ManagedByAssistant = ManagedByAssistant
    def get_ReminderType(self): return self.ReminderType
    def set_ReminderType(self, ReminderType): self.ReminderType = ReminderType
    def get_ClientResourceId(self): return self.ClientResourceId
    def set_ClientResourceId(self, ClientResourceId): self.ClientResourceId = ClientResourceId
    def hasContent_(self):
        if (
            self.Text is not None or
            self.ShareList is not None or
            self.VisibilityListCount is not None or
            self.Author is not None or
            self.Parent is not None or
            self.Files is not None or
            self.Unread is not None or
            self.UnreadClearedAt is not None or
            self.ErrorSending is not None or
            self.ImportedViaEmail is not None or
            self.ForwardedCopy is not None or
            self.BodyFormat is not None or
            self.BodyHtml is not None or
            self.BodySnippet is not None or
            self.ManagedByAssistant is not None or
            self.ReminderType is not None or
            self.ClientResourceId is not None or
            super(Post_20, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Post_20, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Text':
            Text_ = child_.text
            Text_ = self.gds_validate_string(Text_, node, 'Text')
            self.Text = Text_
        elif nodeName_ == 'ShareList':
            obj_ = ListOfResources_13.factory()
            obj_.build(child_)
            self.ShareList = obj_
            obj_.original_tagname_ = 'ShareList'
        elif nodeName_ == 'VisibilityListCount':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'VisibilityListCount')
            self.VisibilityListCount = ival_
        elif nodeName_ == 'Author':
            class_obj_ = self.get_class_obj_(child_, User_14)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Author = obj_
            obj_.original_tagname_ = 'Author'
        elif nodeName_ == 'Parent':
            class_obj_ = self.get_class_obj_(child_, DiscussionBase_20)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Parent = obj_
            obj_.original_tagname_ = 'Parent'
        elif nodeName_ == 'Files':
            obj_ = ListOfFiles_14.factory()
            obj_.build(child_)
            self.Files = obj_
            obj_.original_tagname_ = 'Files'
        elif nodeName_ == 'Unread':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'Unread')
            self.Unread = ival_
        elif nodeName_ == 'UnreadClearedAt':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.UnreadClearedAt = dval_
        elif nodeName_ == 'ErrorSending':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'ErrorSending')
            self.ErrorSending = ival_
        elif nodeName_ == 'ImportedViaEmail':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'ImportedViaEmail')
            self.ImportedViaEmail = ival_
        elif nodeName_ == 'ForwardedCopy':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'ForwardedCopy')
            self.ForwardedCopy = ival_
        elif nodeName_ == 'BodyFormat':
            obj_ = BodyFormat_18.factory()
            obj_.build(child_)
            self.BodyFormat = obj_
            obj_.original_tagname_ = 'BodyFormat'
        elif nodeName_ == 'BodyHtml':
            BodyHtml_ = child_.text
            BodyHtml_ = self.gds_validate_string(BodyHtml_, node, 'BodyHtml')
            self.BodyHtml = BodyHtml_
        elif nodeName_ == 'BodySnippet':
            BodySnippet_ = child_.text
            BodySnippet_ = self.gds_validate_string(BodySnippet_, node, 'BodySnippet')
            self.BodySnippet = BodySnippet_
        elif nodeName_ == 'ManagedByAssistant':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'ManagedByAssistant')
            self.ManagedByAssistant = ival_
        elif nodeName_ == 'ReminderType':
            ReminderType_ = child_.text
            ReminderType_ = self.gds_validate_string(ReminderType_, node, 'ReminderType')
            self.ReminderType = ReminderType_
        elif nodeName_ == 'ClientResourceId':
            ClientResourceId_ = child_.text
            ClientResourceId_ = self.gds_validate_string(ClientResourceId_, node, 'ClientResourceId')
            self.ClientResourceId = ClientResourceId_
        super(Post_20, self).buildChildren(child_, node, nodeName_, True)
# end class Post_20


class PostSeparator_22(ResourceBase_13):
    member_data_items_ = {
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self):
        self.original_tagname_ = None
        super(PostSeparator_22, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PostSeparator_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PostSeparator_22.subclass:
            return PostSeparator_22.subclass(*args_, **kwargs_)
        else:
            return PostSeparator_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(PostSeparator_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(PostSeparator_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(PostSeparator_22, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class PostSeparator_22


class PostAssistant_22(ResourceBase_13):
    member_data_items_ = {
        'Insight': MemberSpec_('Insight', 'string', 0),
        'FlagType': MemberSpec_('FlagType', 'string', 0),
        'Parent': MemberSpec_('Parent', 'Post_22', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, Insight=None, FlagType=None, Parent=None):
        self.original_tagname_ = None
        super(PostAssistant_22, self).__init__()
        self.Insight = Insight
        self.FlagType = FlagType
        self.Parent = Parent
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PostAssistant_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PostAssistant_22.subclass:
            return PostAssistant_22.subclass(*args_, **kwargs_)
        else:
            return PostAssistant_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Insight(self): return self.Insight
    def set_Insight(self, Insight): self.Insight = Insight
    def get_FlagType(self): return self.FlagType
    def set_FlagType(self, FlagType): self.FlagType = FlagType
    def get_Parent(self): return self.Parent
    def set_Parent(self, Parent): self.Parent = Parent
    def hasContent_(self):
        if (
            self.Insight is not None or
            self.FlagType is not None or
            self.Parent is not None or
            super(PostAssistant_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(PostAssistant_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Insight':
            Insight_ = child_.text
            Insight_ = self.gds_validate_string(Insight_, node, 'Insight')
            self.Insight = Insight_
        elif nodeName_ == 'FlagType':
            FlagType_ = child_.text
            FlagType_ = self.gds_validate_string(FlagType_, node, 'FlagType')
            self.FlagType = FlagType_
        elif nodeName_ == 'Parent':
            class_obj_ = self.get_class_obj_(child_, Post_22)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Parent = obj_
            obj_.original_tagname_ = 'Parent'
        super(PostAssistant_22, self).buildChildren(child_, node, nodeName_, True)
# end class PostAssistant_22


class PostBody_22(ResourceBase_13):
    member_data_items_ = {
        'MimeType': MemberSpec_('MimeType', 'string', 0),
        'Content': MemberSpec_('Content', 'string', 0),
        'Parent': MemberSpec_('Parent', 'Post_22', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, MimeType=None, Content=None, Parent=None):
        self.original_tagname_ = None
        super(PostBody_22, self).__init__()
        self.MimeType = MimeType
        self.Content = Content
        self.Parent = Parent
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PostBody_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PostBody_22.subclass:
            return PostBody_22.subclass(*args_, **kwargs_)
        else:
            return PostBody_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_MimeType(self): return self.MimeType
    def set_MimeType(self, MimeType): self.MimeType = MimeType
    def get_Content(self): return self.Content
    def set_Content(self, Content): self.Content = Content
    def get_Parent(self): return self.Parent
    def set_Parent(self, Parent): self.Parent = Parent
    def hasContent_(self):
        if (
            self.MimeType is not None or
            self.Content is not None or
            self.Parent is not None or
            super(PostBody_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(PostBody_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'MimeType':
            MimeType_ = child_.text
            MimeType_ = self.gds_validate_string(MimeType_, node, 'MimeType')
            self.MimeType = MimeType_
        elif nodeName_ == 'Content':
            Content_ = child_.text
            Content_ = self.gds_validate_string(Content_, node, 'Content')
            self.Content = Content_
        elif nodeName_ == 'Parent':
            class_obj_ = self.get_class_obj_(child_, Post_22)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Parent = obj_
            obj_.original_tagname_ = 'Parent'
        super(PostBody_22, self).buildChildren(child_, node, nodeName_, True)
# end class PostBody_22


class PostActionList_22(ResourceBase_13):
    member_data_items_ = {
        'ActionList': MemberSpec_('ActionList', 'ListOfActions_18', 0),
        'Parent': MemberSpec_('Parent', 'Post_22', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, ActionList=None, Parent=None):
        self.original_tagname_ = None
        super(PostActionList_22, self).__init__()
        self.ActionList = ActionList
        self.Parent = Parent
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PostActionList_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PostActionList_22.subclass:
            return PostActionList_22.subclass(*args_, **kwargs_)
        else:
            return PostActionList_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ActionList(self): return self.ActionList
    def set_ActionList(self, ActionList): self.ActionList = ActionList
    def get_Parent(self): return self.Parent
    def set_Parent(self, Parent): self.Parent = Parent
    def hasContent_(self):
        if (
            self.ActionList is not None or
            self.Parent is not None or
            super(PostActionList_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(PostActionList_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ActionList':
            obj_ = ListOfActions_18.factory()
            obj_.build(child_)
            self.ActionList = obj_
            obj_.original_tagname_ = 'ActionList'
        elif nodeName_ == 'Parent':
            class_obj_ = self.get_class_obj_(child_, Post_22)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Parent = obj_
            obj_.original_tagname_ = 'Parent'
        super(PostActionList_22, self).buildChildren(child_, node, nodeName_, True)
# end class PostActionList_22


class PostUnread_22(ResourceBase_13):
    member_data_items_ = {
        'Unread': MemberSpec_('Unread', 'boolean', 0),
        'Parent': MemberSpec_('Parent', 'Post_22', 0),
        'ParentStream': MemberSpec_('ParentStream', 'StreamBase_22', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, Unread=None, Parent=None, ParentStream=None):
        self.original_tagname_ = None
        super(PostUnread_22, self).__init__()
        self.Unread = Unread
        self.Parent = Parent
        self.ParentStream = ParentStream
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PostUnread_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PostUnread_22.subclass:
            return PostUnread_22.subclass(*args_, **kwargs_)
        else:
            return PostUnread_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Unread(self): return self.Unread
    def set_Unread(self, Unread): self.Unread = Unread
    def get_Parent(self): return self.Parent
    def set_Parent(self, Parent): self.Parent = Parent
    def get_ParentStream(self): return self.ParentStream
    def set_ParentStream(self, ParentStream): self.ParentStream = ParentStream
    def hasContent_(self):
        if (
            self.Unread is not None or
            self.Parent is not None or
            self.ParentStream is not None or
            super(PostUnread_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(PostUnread_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Unread':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'Unread')
            self.Unread = ival_
        elif nodeName_ == 'Parent':
            class_obj_ = self.get_class_obj_(child_, Post_22)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Parent = obj_
            obj_.original_tagname_ = 'Parent'
        elif nodeName_ == 'ParentStream':
            class_obj_ = self.get_class_obj_(child_, StreamBase_22)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.ParentStream = obj_
            obj_.original_tagname_ = 'ParentStream'
        super(PostUnread_22, self).buildChildren(child_, node, nodeName_, True)
# end class PostUnread_22


class Post_22(ResourceBase_13):
    member_data_items_ = {
        'Text': MemberSpec_('Text', 'string', 0),
        'Author': MemberSpec_('Author', 'User_14', 0),
        'Parent': MemberSpec_('Parent', 'DiscussionBase_22', 0),
        'ShareList': MemberSpec_('ShareList', 'ListOfResources_13', 0),
        'CcList': MemberSpec_('CcList', 'ListOfUsers_14', 0),
        'BccList': MemberSpec_('BccList', 'ListOfUsers_14', 0),
        'VisibilityList': MemberSpec_('VisibilityList', 'ListOfResources_13', 0),
        'VisibilityListCount': MemberSpec_('VisibilityListCount', 'int', 0),
        'Files': MemberSpec_('Files', 'ListOfFiles_14', 0),
        'UnreadInfo': MemberSpec_('UnreadInfo', 'PostUnread_22', 0),
        'Unread': MemberSpec_('Unread', 'boolean', 0),
        'UnreadClearedAt': MemberSpec_('UnreadClearedAt', 'dateTime', 0),
        'EmailMessageId': MemberSpec_('EmailMessageId', 'string', 0),
        'ImportedViaEmail': MemberSpec_('ImportedViaEmail', 'boolean', 0),
        'ErrorSending': MemberSpec_('ErrorSending', 'boolean', 0),
        'ForwardedCopy': MemberSpec_('ForwardedCopy', 'boolean', 0),
        'Body': MemberSpec_('Body', 'PostBody_22', 0),
        'BodyFormat': MemberSpec_('BodyFormat', 'BodyFormat_18', 0),
        'BodySnippet': MemberSpec_('BodySnippet', 'string', 0),
        'BodyHtml': MemberSpec_('BodyHtml', 'string', 0),
        'Assistant': MemberSpec_('Assistant', 'PostAssistant_22', 0),
        'ManagedByAssistant': MemberSpec_('ManagedByAssistant', 'boolean', 0),
        'ReminderType': MemberSpec_('ReminderType', 'string', 0),
        'AssistantInsight': MemberSpec_('AssistantInsight', 'string', 0),
        'ReminderDue': MemberSpec_('ReminderDue', 'Reminder_22', 0),
        'ClientResourceId': MemberSpec_('ClientResourceId', 'string', 0),
        'Actions': MemberSpec_('Actions', 'PostActionList_22', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, Text=None, Author=None, Parent=None, ShareList=None, CcList=None, BccList=None, VisibilityList=None, VisibilityListCount=None, Files=None, UnreadInfo=None, Unread=None, UnreadClearedAt=None, EmailMessageId=None, ImportedViaEmail=None, ErrorSending=None, ForwardedCopy=None, Body=None, BodyFormat=None, BodySnippet=None, BodyHtml=None, Assistant=None, ManagedByAssistant=None, ReminderType=None, AssistantInsight=None, ReminderDue=None, ClientResourceId=None, Actions=None):
        self.original_tagname_ = None
        super(Post_22, self).__init__()
        self.Text = Text
        self.Author = Author
        self.Parent = Parent
        self.ShareList = ShareList
        self.CcList = CcList
        self.BccList = BccList
        self.VisibilityList = VisibilityList
        self.VisibilityListCount = VisibilityListCount
        self.Files = Files
        self.UnreadInfo = UnreadInfo
        self.Unread = Unread
        if isinstance(UnreadClearedAt, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(UnreadClearedAt, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = UnreadClearedAt
        self.UnreadClearedAt = initvalue_
        self.EmailMessageId = EmailMessageId
        self.ImportedViaEmail = ImportedViaEmail
        self.ErrorSending = ErrorSending
        self.ForwardedCopy = ForwardedCopy
        self.Body = Body
        self.BodyFormat = BodyFormat
        self.BodySnippet = BodySnippet
        self.BodyHtml = BodyHtml
        self.Assistant = Assistant
        self.ManagedByAssistant = ManagedByAssistant
        self.ReminderType = ReminderType
        self.AssistantInsight = AssistantInsight
        self.ReminderDue = ReminderDue
        self.ClientResourceId = ClientResourceId
        self.Actions = Actions
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Post_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Post_22.subclass:
            return Post_22.subclass(*args_, **kwargs_)
        else:
            return Post_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Text(self): return self.Text
    def set_Text(self, Text): self.Text = Text
    def get_Author(self): return self.Author
    def set_Author(self, Author): self.Author = Author
    def get_Parent(self): return self.Parent
    def set_Parent(self, Parent): self.Parent = Parent
    def get_ShareList(self): return self.ShareList
    def set_ShareList(self, ShareList): self.ShareList = ShareList
    def get_CcList(self): return self.CcList
    def set_CcList(self, CcList): self.CcList = CcList
    def get_BccList(self): return self.BccList
    def set_BccList(self, BccList): self.BccList = BccList
    def get_VisibilityList(self): return self.VisibilityList
    def set_VisibilityList(self, VisibilityList): self.VisibilityList = VisibilityList
    def get_VisibilityListCount(self): return self.VisibilityListCount
    def set_VisibilityListCount(self, VisibilityListCount): self.VisibilityListCount = VisibilityListCount
    def get_Files(self): return self.Files
    def set_Files(self, Files): self.Files = Files
    def get_UnreadInfo(self): return self.UnreadInfo
    def set_UnreadInfo(self, UnreadInfo): self.UnreadInfo = UnreadInfo
    def get_Unread(self): return self.Unread
    def set_Unread(self, Unread): self.Unread = Unread
    def get_UnreadClearedAt(self): return self.UnreadClearedAt
    def set_UnreadClearedAt(self, UnreadClearedAt): self.UnreadClearedAt = UnreadClearedAt
    def get_EmailMessageId(self): return self.EmailMessageId
    def set_EmailMessageId(self, EmailMessageId): self.EmailMessageId = EmailMessageId
    def get_ImportedViaEmail(self): return self.ImportedViaEmail
    def set_ImportedViaEmail(self, ImportedViaEmail): self.ImportedViaEmail = ImportedViaEmail
    def get_ErrorSending(self): return self.ErrorSending
    def set_ErrorSending(self, ErrorSending): self.ErrorSending = ErrorSending
    def get_ForwardedCopy(self): return self.ForwardedCopy
    def set_ForwardedCopy(self, ForwardedCopy): self.ForwardedCopy = ForwardedCopy
    def get_Body(self): return self.Body
    def set_Body(self, Body): self.Body = Body
    def get_BodyFormat(self): return self.BodyFormat
    def set_BodyFormat(self, BodyFormat): self.BodyFormat = BodyFormat
    def get_BodySnippet(self): return self.BodySnippet
    def set_BodySnippet(self, BodySnippet): self.BodySnippet = BodySnippet
    def get_BodyHtml(self): return self.BodyHtml
    def set_BodyHtml(self, BodyHtml): self.BodyHtml = BodyHtml
    def get_Assistant(self): return self.Assistant
    def set_Assistant(self, Assistant): self.Assistant = Assistant
    def get_ManagedByAssistant(self): return self.ManagedByAssistant
    def set_ManagedByAssistant(self, ManagedByAssistant): self.ManagedByAssistant = ManagedByAssistant
    def get_ReminderType(self): return self.ReminderType
    def set_ReminderType(self, ReminderType): self.ReminderType = ReminderType
    def get_AssistantInsight(self): return self.AssistantInsight
    def set_AssistantInsight(self, AssistantInsight): self.AssistantInsight = AssistantInsight
    def get_ReminderDue(self): return self.ReminderDue
    def set_ReminderDue(self, ReminderDue): self.ReminderDue = ReminderDue
    def get_ClientResourceId(self): return self.ClientResourceId
    def set_ClientResourceId(self, ClientResourceId): self.ClientResourceId = ClientResourceId
    def get_Actions(self): return self.Actions
    def set_Actions(self, Actions): self.Actions = Actions
    def hasContent_(self):
        if (
            self.Text is not None or
            self.Author is not None or
            self.Parent is not None or
            self.ShareList is not None or
            self.CcList is not None or
            self.BccList is not None or
            self.VisibilityList is not None or
            self.VisibilityListCount is not None or
            self.Files is not None or
            self.UnreadInfo is not None or
            self.Unread is not None or
            self.UnreadClearedAt is not None or
            self.EmailMessageId is not None or
            self.ImportedViaEmail is not None or
            self.ErrorSending is not None or
            self.ForwardedCopy is not None or
            self.Body is not None or
            self.BodyFormat is not None or
            self.BodySnippet is not None or
            self.BodyHtml is not None or
            self.Assistant is not None or
            self.ManagedByAssistant is not None or
            self.ReminderType is not None or
            self.AssistantInsight is not None or
            self.ReminderDue is not None or
            self.ClientResourceId is not None or
            self.Actions is not None or
            super(Post_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Post_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Text':
            Text_ = child_.text
            Text_ = self.gds_validate_string(Text_, node, 'Text')
            self.Text = Text_
        elif nodeName_ == 'Author':
            class_obj_ = self.get_class_obj_(child_, User_14)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Author = obj_
            obj_.original_tagname_ = 'Author'
        elif nodeName_ == 'Parent':
            class_obj_ = self.get_class_obj_(child_, DiscussionBase_22)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Parent = obj_
            obj_.original_tagname_ = 'Parent'
        elif nodeName_ == 'ShareList':
            obj_ = ListOfResources_13.factory()
            obj_.build(child_)
            self.ShareList = obj_
            obj_.original_tagname_ = 'ShareList'
        elif nodeName_ == 'CcList':
            obj_ = ListOfUsers_14.factory()
            obj_.build(child_)
            self.CcList = obj_
            obj_.original_tagname_ = 'CcList'
        elif nodeName_ == 'BccList':
            obj_ = ListOfUsers_14.factory()
            obj_.build(child_)
            self.BccList = obj_
            obj_.original_tagname_ = 'BccList'
        elif nodeName_ == 'VisibilityList':
            obj_ = ListOfResources_13.factory()
            obj_.build(child_)
            self.VisibilityList = obj_
            obj_.original_tagname_ = 'VisibilityList'
        elif nodeName_ == 'VisibilityListCount':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'VisibilityListCount')
            self.VisibilityListCount = ival_
        elif nodeName_ == 'Files':
            obj_ = ListOfFiles_14.factory()
            obj_.build(child_)
            self.Files = obj_
            obj_.original_tagname_ = 'Files'
        elif nodeName_ == 'UnreadInfo':
            obj_ = PostUnread_22.factory()
            obj_.build(child_)
            self.UnreadInfo = obj_
            obj_.original_tagname_ = 'UnreadInfo'
        elif nodeName_ == 'Unread':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'Unread')
            self.Unread = ival_
        elif nodeName_ == 'UnreadClearedAt':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.UnreadClearedAt = dval_
        elif nodeName_ == 'EmailMessageId':
            EmailMessageId_ = child_.text
            EmailMessageId_ = self.gds_validate_string(EmailMessageId_, node, 'EmailMessageId')
            self.EmailMessageId = EmailMessageId_
        elif nodeName_ == 'ImportedViaEmail':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'ImportedViaEmail')
            self.ImportedViaEmail = ival_
        elif nodeName_ == 'ErrorSending':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'ErrorSending')
            self.ErrorSending = ival_
        elif nodeName_ == 'ForwardedCopy':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'ForwardedCopy')
            self.ForwardedCopy = ival_
        elif nodeName_ == 'Body':
            obj_ = PostBody_22.factory()
            obj_.build(child_)
            self.Body = obj_
            obj_.original_tagname_ = 'Body'
        elif nodeName_ == 'BodyFormat':
            obj_ = BodyFormat_18.factory()
            obj_.build(child_)
            self.BodyFormat = obj_
            obj_.original_tagname_ = 'BodyFormat'
        elif nodeName_ == 'BodySnippet':
            BodySnippet_ = child_.text
            BodySnippet_ = self.gds_validate_string(BodySnippet_, node, 'BodySnippet')
            self.BodySnippet = BodySnippet_
        elif nodeName_ == 'BodyHtml':
            BodyHtml_ = child_.text
            BodyHtml_ = self.gds_validate_string(BodyHtml_, node, 'BodyHtml')
            self.BodyHtml = BodyHtml_
        elif nodeName_ == 'Assistant':
            obj_ = PostAssistant_22.factory()
            obj_.build(child_)
            self.Assistant = obj_
            obj_.original_tagname_ = 'Assistant'
        elif nodeName_ == 'ManagedByAssistant':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'ManagedByAssistant')
            self.ManagedByAssistant = ival_
        elif nodeName_ == 'ReminderType':
            ReminderType_ = child_.text
            ReminderType_ = self.gds_validate_string(ReminderType_, node, 'ReminderType')
            self.ReminderType = ReminderType_
        elif nodeName_ == 'AssistantInsight':
            AssistantInsight_ = child_.text
            AssistantInsight_ = self.gds_validate_string(AssistantInsight_, node, 'AssistantInsight')
            self.AssistantInsight = AssistantInsight_
        elif nodeName_ == 'ReminderDue':
            obj_ = Reminder_22.factory()
            obj_.build(child_)
            self.ReminderDue = obj_
            obj_.original_tagname_ = 'ReminderDue'
        elif nodeName_ == 'ClientResourceId':
            ClientResourceId_ = child_.text
            ClientResourceId_ = self.gds_validate_string(ClientResourceId_, node, 'ClientResourceId')
            self.ClientResourceId = ClientResourceId_
        elif nodeName_ == 'Actions':
            obj_ = PostActionList_22.factory()
            obj_.build(child_)
            self.Actions = obj_
            obj_.original_tagname_ = 'Actions'
        super(Post_22, self).buildChildren(child_, node, nodeName_, True)
# end class Post_22


class DiscussionBase_18(ResourceBase_13):
    member_data_items_ = {
        'Parent': MemberSpec_('Parent', 'StreamBase_17', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, Parent=None):
        self.original_tagname_ = None
        super(DiscussionBase_18, self).__init__()
        self.Parent = Parent
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DiscussionBase_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DiscussionBase_18.subclass:
            return DiscussionBase_18.subclass(*args_, **kwargs_)
        else:
            return DiscussionBase_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Parent(self): return self.Parent
    def set_Parent(self, Parent): self.Parent = Parent
    def hasContent_(self):
        if (
            self.Parent is not None or
            super(DiscussionBase_18, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(DiscussionBase_18, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Parent':
            class_obj_ = self.get_class_obj_(child_, StreamBase_17)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Parent = obj_
            obj_.original_tagname_ = 'Parent'
        super(DiscussionBase_18, self).buildChildren(child_, node, nodeName_, True)
# end class DiscussionBase_18


class DiscussionBase_20(ResourceBase_13):
    member_data_items_ = {
        'Parent': MemberSpec_('Parent', 'StreamBase_17', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, Parent=None):
        self.original_tagname_ = None
        super(DiscussionBase_20, self).__init__()
        self.Parent = Parent
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DiscussionBase_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DiscussionBase_20.subclass:
            return DiscussionBase_20.subclass(*args_, **kwargs_)
        else:
            return DiscussionBase_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Parent(self): return self.Parent
    def set_Parent(self, Parent): self.Parent = Parent
    def hasContent_(self):
        if (
            self.Parent is not None or
            super(DiscussionBase_20, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(DiscussionBase_20, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Parent':
            class_obj_ = self.get_class_obj_(child_, StreamBase_17)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Parent = obj_
            obj_.original_tagname_ = 'Parent'
        super(DiscussionBase_20, self).buildChildren(child_, node, nodeName_, True)
# end class DiscussionBase_20


class DiscussionBase_22(ResourceBase_13):
    member_data_items_ = {
        'Parent': MemberSpec_('Parent', 'StreamBase_22', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, Parent=None):
        self.original_tagname_ = None
        super(DiscussionBase_22, self).__init__()
        self.Parent = Parent
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DiscussionBase_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DiscussionBase_22.subclass:
            return DiscussionBase_22.subclass(*args_, **kwargs_)
        else:
            return DiscussionBase_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Parent(self): return self.Parent
    def set_Parent(self, Parent): self.Parent = Parent
    def hasContent_(self):
        if (
            self.Parent is not None or
            super(DiscussionBase_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(DiscussionBase_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Parent':
            class_obj_ = self.get_class_obj_(child_, StreamBase_22)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Parent = obj_
            obj_.original_tagname_ = 'Parent'
        super(DiscussionBase_22, self).buildChildren(child_, node, nodeName_, True)
# end class DiscussionBase_22


class GroupLeave_22(ResourceBase_13):
    member_data_items_ = {
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self):
        self.original_tagname_ = None
        super(GroupLeave_22, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GroupLeave_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GroupLeave_22.subclass:
            return GroupLeave_22.subclass(*args_, **kwargs_)
        else:
            return GroupLeave_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(GroupLeave_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(GroupLeave_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(GroupLeave_22, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class GroupLeave_22


class Group_17(ResourceBase_13):
    member_data_items_ = {
        'Description': MemberSpec_('Description', 'string', 0),
        'Email': MemberSpec_('Email', 'GroupEmail_17', 0),
        'ShareOnlyMembers': MemberSpec_('ShareOnlyMembers', 'ListOfUsers_14', 0),
        'ShareOnlyMembersCount': MemberSpec_('ShareOnlyMembersCount', 'int', 0),
        'Members': MemberSpec_('Members', 'ListOfUsers_14', 0),
        'MemberCount': MemberSpec_('MemberCount', 'int', 0),
        'Administrators': MemberSpec_('Administrators', 'ListOfUsers_14', 0),
        'AdministratorCount': MemberSpec_('AdministratorCount', 'int', 0),
        'Boards': MemberSpec_('Boards', 'ListOfBoards_22', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, Description=None, Email=None, ShareOnlyMembers=None, ShareOnlyMembersCount=None, Members=None, MemberCount=None, Administrators=None, AdministratorCount=None, Boards=None):
        self.original_tagname_ = None
        super(Group_17, self).__init__()
        self.Description = Description
        self.Email = Email
        self.ShareOnlyMembers = ShareOnlyMembers
        self.ShareOnlyMembersCount = ShareOnlyMembersCount
        self.Members = Members
        self.MemberCount = MemberCount
        self.Administrators = Administrators
        self.AdministratorCount = AdministratorCount
        self.Boards = Boards
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Group_17)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Group_17.subclass:
            return Group_17.subclass(*args_, **kwargs_)
        else:
            return Group_17(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Email(self): return self.Email
    def set_Email(self, Email): self.Email = Email
    def get_ShareOnlyMembers(self): return self.ShareOnlyMembers
    def set_ShareOnlyMembers(self, ShareOnlyMembers): self.ShareOnlyMembers = ShareOnlyMembers
    def get_ShareOnlyMembersCount(self): return self.ShareOnlyMembersCount
    def set_ShareOnlyMembersCount(self, ShareOnlyMembersCount): self.ShareOnlyMembersCount = ShareOnlyMembersCount
    def get_Members(self): return self.Members
    def set_Members(self, Members): self.Members = Members
    def get_MemberCount(self): return self.MemberCount
    def set_MemberCount(self, MemberCount): self.MemberCount = MemberCount
    def get_Administrators(self): return self.Administrators
    def set_Administrators(self, Administrators): self.Administrators = Administrators
    def get_AdministratorCount(self): return self.AdministratorCount
    def set_AdministratorCount(self, AdministratorCount): self.AdministratorCount = AdministratorCount
    def get_Boards(self): return self.Boards
    def set_Boards(self, Boards): self.Boards = Boards
    def hasContent_(self):
        if (
            self.Description is not None or
            self.Email is not None or
            self.ShareOnlyMembers is not None or
            self.ShareOnlyMembersCount is not None or
            self.Members is not None or
            self.MemberCount is not None or
            self.Administrators is not None or
            self.AdministratorCount is not None or
            self.Boards is not None or
            super(Group_17, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Group_17, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Description':
            Description_ = child_.text
            Description_ = self.gds_validate_string(Description_, node, 'Description')
            self.Description = Description_
        elif nodeName_ == 'Email':
            obj_ = GroupEmail_17.factory()
            obj_.build(child_)
            self.Email = obj_
            obj_.original_tagname_ = 'Email'
        elif nodeName_ == 'ShareOnlyMembers':
            obj_ = ListOfUsers_14.factory()
            obj_.build(child_)
            self.ShareOnlyMembers = obj_
            obj_.original_tagname_ = 'ShareOnlyMembers'
        elif nodeName_ == 'ShareOnlyMembersCount':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'ShareOnlyMembersCount')
            self.ShareOnlyMembersCount = ival_
        elif nodeName_ == 'Members':
            obj_ = ListOfUsers_14.factory()
            obj_.build(child_)
            self.Members = obj_
            obj_.original_tagname_ = 'Members'
        elif nodeName_ == 'MemberCount':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'MemberCount')
            self.MemberCount = ival_
        elif nodeName_ == 'Administrators':
            obj_ = ListOfUsers_14.factory()
            obj_.build(child_)
            self.Administrators = obj_
            obj_.original_tagname_ = 'Administrators'
        elif nodeName_ == 'AdministratorCount':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'AdministratorCount')
            self.AdministratorCount = ival_
        elif nodeName_ == 'Boards':
            obj_ = ListOfBoards_22.factory()
            obj_.build(child_)
            self.Boards = obj_
            obj_.original_tagname_ = 'Boards'
        super(Group_17, self).buildChildren(child_, node, nodeName_, True)
# end class Group_17


class MicrosoftExchangeSyncInfo_16(ResourceBase_13):
    member_data_items_ = {
        'IsEnabled': MemberSpec_('IsEnabled', 'boolean', 0),
        'SyncTaskRunning': MemberSpec_('SyncTaskRunning', 'boolean', 0),
        'IsInitialSyncTaskFinished': MemberSpec_('IsInitialSyncTaskFinished', 'boolean', 0),
        'ImportedMessageCount': MemberSpec_('ImportedMessageCount', 'int', 0),
        'ImportedThreadCount': MemberSpec_('ImportedThreadCount', 'int', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, IsEnabled=None, SyncTaskRunning=None, IsInitialSyncTaskFinished=None, ImportedMessageCount=None, ImportedThreadCount=None):
        self.original_tagname_ = None
        super(MicrosoftExchangeSyncInfo_16, self).__init__()
        self.IsEnabled = IsEnabled
        self.SyncTaskRunning = SyncTaskRunning
        self.IsInitialSyncTaskFinished = IsInitialSyncTaskFinished
        self.ImportedMessageCount = ImportedMessageCount
        self.ImportedThreadCount = ImportedThreadCount
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, MicrosoftExchangeSyncInfo_16)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if MicrosoftExchangeSyncInfo_16.subclass:
            return MicrosoftExchangeSyncInfo_16.subclass(*args_, **kwargs_)
        else:
            return MicrosoftExchangeSyncInfo_16(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_IsEnabled(self): return self.IsEnabled
    def set_IsEnabled(self, IsEnabled): self.IsEnabled = IsEnabled
    def get_SyncTaskRunning(self): return self.SyncTaskRunning
    def set_SyncTaskRunning(self, SyncTaskRunning): self.SyncTaskRunning = SyncTaskRunning
    def get_IsInitialSyncTaskFinished(self): return self.IsInitialSyncTaskFinished
    def set_IsInitialSyncTaskFinished(self, IsInitialSyncTaskFinished): self.IsInitialSyncTaskFinished = IsInitialSyncTaskFinished
    def get_ImportedMessageCount(self): return self.ImportedMessageCount
    def set_ImportedMessageCount(self, ImportedMessageCount): self.ImportedMessageCount = ImportedMessageCount
    def get_ImportedThreadCount(self): return self.ImportedThreadCount
    def set_ImportedThreadCount(self, ImportedThreadCount): self.ImportedThreadCount = ImportedThreadCount
    def hasContent_(self):
        if (
            self.IsEnabled is not None or
            self.SyncTaskRunning is not None or
            self.IsInitialSyncTaskFinished is not None or
            self.ImportedMessageCount is not None or
            self.ImportedThreadCount is not None or
            super(MicrosoftExchangeSyncInfo_16, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(MicrosoftExchangeSyncInfo_16, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'IsEnabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsEnabled')
            self.IsEnabled = ival_
        elif nodeName_ == 'SyncTaskRunning':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'SyncTaskRunning')
            self.SyncTaskRunning = ival_
        elif nodeName_ == 'IsInitialSyncTaskFinished':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsInitialSyncTaskFinished')
            self.IsInitialSyncTaskFinished = ival_
        elif nodeName_ == 'ImportedMessageCount':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'ImportedMessageCount')
            self.ImportedMessageCount = ival_
        elif nodeName_ == 'ImportedThreadCount':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'ImportedThreadCount')
            self.ImportedThreadCount = ival_
        super(MicrosoftExchangeSyncInfo_16, self).buildChildren(child_, node, nodeName_, True)
# end class MicrosoftExchangeSyncInfo_16


class GMailSyncInfo_16(ResourceBase_13):
    member_data_items_ = {
        'IsEnabled': MemberSpec_('IsEnabled', 'boolean', 0),
        'SyncTaskRunning': MemberSpec_('SyncTaskRunning', 'boolean', 0),
        'IsInitialSyncTaskFinished': MemberSpec_('IsInitialSyncTaskFinished', 'boolean', 0),
        'ImportedMessageCount': MemberSpec_('ImportedMessageCount', 'int', 0),
        'ImportedThreadCount': MemberSpec_('ImportedThreadCount', 'int', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, IsEnabled=None, SyncTaskRunning=None, IsInitialSyncTaskFinished=None, ImportedMessageCount=None, ImportedThreadCount=None):
        self.original_tagname_ = None
        super(GMailSyncInfo_16, self).__init__()
        self.IsEnabled = IsEnabled
        self.SyncTaskRunning = SyncTaskRunning
        self.IsInitialSyncTaskFinished = IsInitialSyncTaskFinished
        self.ImportedMessageCount = ImportedMessageCount
        self.ImportedThreadCount = ImportedThreadCount
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GMailSyncInfo_16)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GMailSyncInfo_16.subclass:
            return GMailSyncInfo_16.subclass(*args_, **kwargs_)
        else:
            return GMailSyncInfo_16(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_IsEnabled(self): return self.IsEnabled
    def set_IsEnabled(self, IsEnabled): self.IsEnabled = IsEnabled
    def get_SyncTaskRunning(self): return self.SyncTaskRunning
    def set_SyncTaskRunning(self, SyncTaskRunning): self.SyncTaskRunning = SyncTaskRunning
    def get_IsInitialSyncTaskFinished(self): return self.IsInitialSyncTaskFinished
    def set_IsInitialSyncTaskFinished(self, IsInitialSyncTaskFinished): self.IsInitialSyncTaskFinished = IsInitialSyncTaskFinished
    def get_ImportedMessageCount(self): return self.ImportedMessageCount
    def set_ImportedMessageCount(self, ImportedMessageCount): self.ImportedMessageCount = ImportedMessageCount
    def get_ImportedThreadCount(self): return self.ImportedThreadCount
    def set_ImportedThreadCount(self, ImportedThreadCount): self.ImportedThreadCount = ImportedThreadCount
    def hasContent_(self):
        if (
            self.IsEnabled is not None or
            self.SyncTaskRunning is not None or
            self.IsInitialSyncTaskFinished is not None or
            self.ImportedMessageCount is not None or
            self.ImportedThreadCount is not None or
            super(GMailSyncInfo_16, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(GMailSyncInfo_16, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'IsEnabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsEnabled')
            self.IsEnabled = ival_
        elif nodeName_ == 'SyncTaskRunning':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'SyncTaskRunning')
            self.SyncTaskRunning = ival_
        elif nodeName_ == 'IsInitialSyncTaskFinished':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsInitialSyncTaskFinished')
            self.IsInitialSyncTaskFinished = ival_
        elif nodeName_ == 'ImportedMessageCount':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'ImportedMessageCount')
            self.ImportedMessageCount = ival_
        elif nodeName_ == 'ImportedThreadCount':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'ImportedThreadCount')
            self.ImportedThreadCount = ival_
        super(GMailSyncInfo_16, self).buildChildren(child_, node, nodeName_, True)
# end class GMailSyncInfo_16


class ActorBase_14(ResourceBase_13):
    member_data_items_ = {
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self):
        self.original_tagname_ = None
        super(ActorBase_14, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ActorBase_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ActorBase_14.subclass:
            return ActorBase_14.subclass(*args_, **kwargs_)
        else:
            return ActorBase_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(ActorBase_14, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ActorBase_14, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ActorBase_14, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ActorBase_14


class ActorBase_13(ResourceBase_13):
    member_data_items_ = {
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self):
        self.original_tagname_ = None
        super(ActorBase_13, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ActorBase_13)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ActorBase_13.subclass:
            return ActorBase_13.subclass(*args_, **kwargs_)
        else:
            return ActorBase_13(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(ActorBase_13, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ActorBase_13, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ActorBase_13, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ActorBase_13


class MobileDevice_4(Device_4):
    member_data_items_ = {
        'Type': MemberSpec_('Type', ['MobileDeviceType', 'string'], 0),
        'NotificationVersion': MemberSpec_('NotificationVersion', ['NotificationVersion', 'string'], 0),
        'PushNotificationId': MemberSpec_('PushNotificationId', 'string', 0),
    }
    subclass = None
    superclass = Device_4
    def __init__(self, Type=None, NotificationVersion=None, PushNotificationId=None):
        self.original_tagname_ = None
        super(MobileDevice_4, self).__init__()
        self.Type = Type
        self.validate_MobileDeviceType(self.Type)
        self.NotificationVersion = NotificationVersion
        self.validate_NotificationVersion(self.NotificationVersion)
        self.PushNotificationId = PushNotificationId
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, MobileDevice_4)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if MobileDevice_4.subclass:
            return MobileDevice_4.subclass(*args_, **kwargs_)
        else:
            return MobileDevice_4(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Type(self): return self.Type
    def set_Type(self, Type): self.Type = Type
    def get_NotificationVersion(self): return self.NotificationVersion
    def set_NotificationVersion(self, NotificationVersion): self.NotificationVersion = NotificationVersion
    def get_PushNotificationId(self): return self.PushNotificationId
    def set_PushNotificationId(self, PushNotificationId): self.PushNotificationId = PushNotificationId
    def validate_MobileDeviceType(self, value):
        # Validate type MobileDeviceType, a restriction on string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['iPhone', 'iPad', 'Android', 'Test', 'WindowsPhone']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on MobileDeviceType' % {"value" : value.encode("utf-8")} )
    def validate_NotificationVersion(self, value):
        # Validate type NotificationVersion, a restriction on string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['V15', 'V18', 'V19', 'V20', 'V22']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on NotificationVersion' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.Type is not None or
            self.NotificationVersion is not None or
            self.PushNotificationId is not None or
            super(MobileDevice_4, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(MobileDevice_4, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Type':
            Type_ = child_.text
            Type_ = self.gds_validate_string(Type_, node, 'Type')
            self.Type = Type_
            # validate type MobileDeviceType
            self.validate_MobileDeviceType(self.Type)
        elif nodeName_ == 'NotificationVersion':
            NotificationVersion_ = child_.text
            NotificationVersion_ = self.gds_validate_string(NotificationVersion_, node, 'NotificationVersion')
            self.NotificationVersion = NotificationVersion_
            # validate type NotificationVersion
            self.validate_NotificationVersion(self.NotificationVersion)
        elif nodeName_ == 'PushNotificationId':
            PushNotificationId_ = child_.text
            PushNotificationId_ = self.gds_validate_string(PushNotificationId_, node, 'PushNotificationId')
            self.PushNotificationId = PushNotificationId_
        super(MobileDevice_4, self).buildChildren(child_, node, nodeName_, True)
# end class MobileDevice_4


class Document_18(ResourceBase_13):
    member_data_items_ = {
        'Description': MemberSpec_('Description', 'string', 0),
        'Owner': MemberSpec_('Owner', 'ActorBase_14', 0),
        'File': MemberSpec_('File', 'File_14', 0),
        'ShareList': MemberSpec_('ShareList', 'ListOfResources_13', 0),
        'Size': MemberSpec_('Size', 'long', 0),
        'Parent': MemberSpec_('Parent', 'ResourceBase_13', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, Description=None, Owner=None, File=None, ShareList=None, Size=None, Parent=None):
        self.original_tagname_ = None
        super(Document_18, self).__init__()
        self.Description = Description
        self.Owner = Owner
        self.File = File
        self.ShareList = ShareList
        self.Size = Size
        self.Parent = Parent
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Document_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Document_18.subclass:
            return Document_18.subclass(*args_, **kwargs_)
        else:
            return Document_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Owner(self): return self.Owner
    def set_Owner(self, Owner): self.Owner = Owner
    def get_File(self): return self.File
    def set_File(self, File): self.File = File
    def get_ShareList(self): return self.ShareList
    def set_ShareList(self, ShareList): self.ShareList = ShareList
    def get_Size(self): return self.Size
    def set_Size(self, Size): self.Size = Size
    def get_Parent(self): return self.Parent
    def set_Parent(self, Parent): self.Parent = Parent
    def hasContent_(self):
        if (
            self.Description is not None or
            self.Owner is not None or
            self.File is not None or
            self.ShareList is not None or
            self.Size is not None or
            self.Parent is not None or
            super(Document_18, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Document_18, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Description':
            Description_ = child_.text
            Description_ = self.gds_validate_string(Description_, node, 'Description')
            self.Description = Description_
        elif nodeName_ == 'Owner':
            class_obj_ = self.get_class_obj_(child_, ActorBase_14)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Owner = obj_
            obj_.original_tagname_ = 'Owner'
        elif nodeName_ == 'File':
            obj_ = File_14.factory()
            obj_.build(child_)
            self.File = obj_
            obj_.original_tagname_ = 'File'
        elif nodeName_ == 'ShareList':
            obj_ = ListOfResources_13.factory()
            obj_.build(child_)
            self.ShareList = obj_
            obj_.original_tagname_ = 'ShareList'
        elif nodeName_ == 'Size':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Size')
            self.Size = ival_
        elif nodeName_ == 'Parent':
            class_obj_ = self.get_class_obj_(child_, ResourceBase_13)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Parent = obj_
            obj_.original_tagname_ = 'Parent'
        super(Document_18, self).buildChildren(child_, node, nodeName_, True)
# end class Document_18


class Document_14(ResourceBase_13):
    member_data_items_ = {
        'Description': MemberSpec_('Description', 'string', 0),
        'Owner': MemberSpec_('Owner', 'ActorBase_14', 0),
        'File': MemberSpec_('File', 'File_14', 0),
        'ShareList': MemberSpec_('ShareList', 'ListOfResources_13', 0),
        'Size': MemberSpec_('Size', 'long', 0),
        'Parent': MemberSpec_('Parent', 'ResourceBase_13', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, Description=None, Owner=None, File=None, ShareList=None, Size=None, Parent=None):
        self.original_tagname_ = None
        super(Document_14, self).__init__()
        self.Description = Description
        self.Owner = Owner
        self.File = File
        self.ShareList = ShareList
        self.Size = Size
        self.Parent = Parent
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Document_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Document_14.subclass:
            return Document_14.subclass(*args_, **kwargs_)
        else:
            return Document_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Owner(self): return self.Owner
    def set_Owner(self, Owner): self.Owner = Owner
    def get_File(self): return self.File
    def set_File(self, File): self.File = File
    def get_ShareList(self): return self.ShareList
    def set_ShareList(self, ShareList): self.ShareList = ShareList
    def get_Size(self): return self.Size
    def set_Size(self, Size): self.Size = Size
    def get_Parent(self): return self.Parent
    def set_Parent(self, Parent): self.Parent = Parent
    def hasContent_(self):
        if (
            self.Description is not None or
            self.Owner is not None or
            self.File is not None or
            self.ShareList is not None or
            self.Size is not None or
            self.Parent is not None or
            super(Document_14, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Document_14, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Description':
            Description_ = child_.text
            Description_ = self.gds_validate_string(Description_, node, 'Description')
            self.Description = Description_
        elif nodeName_ == 'Owner':
            class_obj_ = self.get_class_obj_(child_, ActorBase_14)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Owner = obj_
            obj_.original_tagname_ = 'Owner'
        elif nodeName_ == 'File':
            obj_ = File_14.factory()
            obj_.build(child_)
            self.File = obj_
            obj_.original_tagname_ = 'File'
        elif nodeName_ == 'ShareList':
            obj_ = ListOfResources_13.factory()
            obj_.build(child_)
            self.ShareList = obj_
            obj_.original_tagname_ = 'ShareList'
        elif nodeName_ == 'Size':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Size')
            self.Size = ival_
        elif nodeName_ == 'Parent':
            class_obj_ = self.get_class_obj_(child_, ResourceBase_13)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Parent = obj_
            obj_.original_tagname_ = 'Parent'
        super(Document_14, self).buildChildren(child_, node, nodeName_, True)
# end class Document_14


class File_14(ResourceBase_13):
    member_data_items_ = {
        'ThumbnailSupported': MemberSpec_('ThumbnailSupported', 'boolean', 0),
        'ThumbnailGenerationFailed': MemberSpec_('ThumbnailGenerationFailed', 'boolean', 0),
        'ThumbnailPreview': MemberSpec_('ThumbnailPreview', 'ThumbnailPreview_15', 0),
        'Parent': MemberSpec_('Parent', 'ResourceBase_13', 0),
        'Size': MemberSpec_('Size', 'long', 0),
        'ForwardedCopy': MemberSpec_('ForwardedCopy', 'boolean', 0),
        'Hidden': MemberSpec_('Hidden', 'boolean', 0),
    }
    subclass = None
    superclass = ResourceBase_13
    def __init__(self, ThumbnailSupported=None, ThumbnailGenerationFailed=None, ThumbnailPreview=None, Parent=None, Size=None, ForwardedCopy=None, Hidden=None):
        self.original_tagname_ = None
        super(File_14, self).__init__()
        self.ThumbnailSupported = ThumbnailSupported
        self.ThumbnailGenerationFailed = ThumbnailGenerationFailed
        self.ThumbnailPreview = ThumbnailPreview
        self.Parent = Parent
        self.Size = Size
        self.ForwardedCopy = ForwardedCopy
        self.Hidden = Hidden
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, File_14)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if File_14.subclass:
            return File_14.subclass(*args_, **kwargs_)
        else:
            return File_14(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ThumbnailSupported(self): return self.ThumbnailSupported
    def set_ThumbnailSupported(self, ThumbnailSupported): self.ThumbnailSupported = ThumbnailSupported
    def get_ThumbnailGenerationFailed(self): return self.ThumbnailGenerationFailed
    def set_ThumbnailGenerationFailed(self, ThumbnailGenerationFailed): self.ThumbnailGenerationFailed = ThumbnailGenerationFailed
    def get_ThumbnailPreview(self): return self.ThumbnailPreview
    def set_ThumbnailPreview(self, ThumbnailPreview): self.ThumbnailPreview = ThumbnailPreview
    def get_Parent(self): return self.Parent
    def set_Parent(self, Parent): self.Parent = Parent
    def get_Size(self): return self.Size
    def set_Size(self, Size): self.Size = Size
    def get_ForwardedCopy(self): return self.ForwardedCopy
    def set_ForwardedCopy(self, ForwardedCopy): self.ForwardedCopy = ForwardedCopy
    def get_Hidden(self): return self.Hidden
    def set_Hidden(self, Hidden): self.Hidden = Hidden
    def hasContent_(self):
        if (
            self.ThumbnailSupported is not None or
            self.ThumbnailGenerationFailed is not None or
            self.ThumbnailPreview is not None or
            self.Parent is not None or
            self.Size is not None or
            self.ForwardedCopy is not None or
            self.Hidden is not None or
            super(File_14, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(File_14, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ThumbnailSupported':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'ThumbnailSupported')
            self.ThumbnailSupported = ival_
        elif nodeName_ == 'ThumbnailGenerationFailed':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'ThumbnailGenerationFailed')
            self.ThumbnailGenerationFailed = ival_
        elif nodeName_ == 'ThumbnailPreview':
            obj_ = ThumbnailPreview_15.factory()
            obj_.build(child_)
            self.ThumbnailPreview = obj_
            obj_.original_tagname_ = 'ThumbnailPreview'
        elif nodeName_ == 'Parent':
            class_obj_ = self.get_class_obj_(child_, ResourceBase_13)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Parent = obj_
            obj_.original_tagname_ = 'Parent'
        elif nodeName_ == 'Size':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Size')
            self.Size = ival_
        elif nodeName_ == 'ForwardedCopy':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'ForwardedCopy')
            self.ForwardedCopy = ival_
        elif nodeName_ == 'Hidden':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'Hidden')
            self.Hidden = ival_
        super(File_14, self).buildChildren(child_, node, nodeName_, True)
# end class File_14


class ActionDeclineAppointment_18(ActionBase_18):
    member_data_items_ = {
    }
    subclass = None
    superclass = ActionBase_18
    def __init__(self):
        self.original_tagname_ = None
        super(ActionDeclineAppointment_18, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ActionDeclineAppointment_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ActionDeclineAppointment_18.subclass:
            return ActionDeclineAppointment_18.subclass(*args_, **kwargs_)
        else:
            return ActionDeclineAppointment_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(ActionDeclineAppointment_18, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ActionDeclineAppointment_18, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ActionDeclineAppointment_18, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ActionDeclineAppointment_18


class ActionTentativelyAcceptAppointment_18(ActionBase_18):
    member_data_items_ = {
    }
    subclass = None
    superclass = ActionBase_18
    def __init__(self):
        self.original_tagname_ = None
        super(ActionTentativelyAcceptAppointment_18, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ActionTentativelyAcceptAppointment_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ActionTentativelyAcceptAppointment_18.subclass:
            return ActionTentativelyAcceptAppointment_18.subclass(*args_, **kwargs_)
        else:
            return ActionTentativelyAcceptAppointment_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(ActionTentativelyAcceptAppointment_18, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ActionTentativelyAcceptAppointment_18, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ActionTentativelyAcceptAppointment_18, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ActionTentativelyAcceptAppointment_18


class ActionAcceptAppointment_18(ActionBase_18):
    member_data_items_ = {
    }
    subclass = None
    superclass = ActionBase_18
    def __init__(self):
        self.original_tagname_ = None
        super(ActionAcceptAppointment_18, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ActionAcceptAppointment_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ActionAcceptAppointment_18.subclass:
            return ActionAcceptAppointment_18.subclass(*args_, **kwargs_)
        else:
            return ActionAcceptAppointment_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(ActionAcceptAppointment_18, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ActionAcceptAppointment_18, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ActionAcceptAppointment_18, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ActionAcceptAppointment_18


class ActionMarkAsUnread_18(ActionBase_18):
    member_data_items_ = {
    }
    subclass = None
    superclass = ActionBase_18
    def __init__(self):
        self.original_tagname_ = None
        super(ActionMarkAsUnread_18, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ActionMarkAsUnread_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ActionMarkAsUnread_18.subclass:
            return ActionMarkAsUnread_18.subclass(*args_, **kwargs_)
        else:
            return ActionMarkAsUnread_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(ActionMarkAsUnread_18, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ActionMarkAsUnread_18, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ActionMarkAsUnread_18, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ActionMarkAsUnread_18


class ActionPin_18(ActionBase_18):
    member_data_items_ = {
    }
    subclass = None
    superclass = ActionBase_18
    def __init__(self):
        self.original_tagname_ = None
        super(ActionPin_18, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ActionPin_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ActionPin_18.subclass:
            return ActionPin_18.subclass(*args_, **kwargs_)
        else:
            return ActionPin_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(ActionPin_18, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ActionPin_18, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ActionPin_18, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ActionPin_18


class ActionForward_18(ActionBase_18):
    member_data_items_ = {
    }
    subclass = None
    superclass = ActionBase_18
    def __init__(self):
        self.original_tagname_ = None
        super(ActionForward_18, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ActionForward_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ActionForward_18.subclass:
            return ActionForward_18.subclass(*args_, **kwargs_)
        else:
            return ActionForward_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(ActionForward_18, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ActionForward_18, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ActionForward_18, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ActionForward_18


class ActionToggleNotifications_18(ActionBase_18):
    member_data_items_ = {
        'SendNotifications': MemberSpec_('SendNotifications', 'boolean', 0),
    }
    subclass = None
    superclass = ActionBase_18
    def __init__(self, SendNotifications=None):
        self.original_tagname_ = None
        super(ActionToggleNotifications_18, self).__init__()
        self.SendNotifications = SendNotifications
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ActionToggleNotifications_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ActionToggleNotifications_18.subclass:
            return ActionToggleNotifications_18.subclass(*args_, **kwargs_)
        else:
            return ActionToggleNotifications_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_SendNotifications(self): return self.SendNotifications
    def set_SendNotifications(self, SendNotifications): self.SendNotifications = SendNotifications
    def hasContent_(self):
        if (
            self.SendNotifications is not None or
            super(ActionToggleNotifications_18, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ActionToggleNotifications_18, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'SendNotifications':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'SendNotifications')
            self.SendNotifications = ival_
        super(ActionToggleNotifications_18, self).buildChildren(child_, node, nodeName_, True)
# end class ActionToggleNotifications_18


class ActionFollowup_18(ActionBase_18):
    member_data_items_ = {
    }
    subclass = None
    superclass = ActionBase_18
    def __init__(self):
        self.original_tagname_ = None
        super(ActionFollowup_18, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ActionFollowup_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ActionFollowup_18.subclass:
            return ActionFollowup_18.subclass(*args_, **kwargs_)
        else:
            return ActionFollowup_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(ActionFollowup_18, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ActionFollowup_18, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ActionFollowup_18, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ActionFollowup_18


class ActionReplyToAll_18(ActionBase_18):
    member_data_items_ = {
    }
    subclass = None
    superclass = ActionBase_18
    def __init__(self):
        self.original_tagname_ = None
        super(ActionReplyToAll_18, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ActionReplyToAll_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ActionReplyToAll_18.subclass:
            return ActionReplyToAll_18.subclass(*args_, **kwargs_)
        else:
            return ActionReplyToAll_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(ActionReplyToAll_18, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ActionReplyToAll_18, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ActionReplyToAll_18, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ActionReplyToAll_18


class ActionReply_18(ActionBase_18):
    member_data_items_ = {
    }
    subclass = None
    superclass = ActionBase_18
    def __init__(self):
        self.original_tagname_ = None
        super(ActionReply_18, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ActionReply_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ActionReply_18.subclass:
            return ActionReply_18.subclass(*args_, **kwargs_)
        else:
            return ActionReply_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(ActionReply_18, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ActionReply_18, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ActionReply_18, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ActionReply_18


class ActionDelete_18(ActionBase_18):
    member_data_items_ = {
        'Resource': MemberSpec_('Resource', 'ResourceBase_13', 0),
    }
    subclass = None
    superclass = ActionBase_18
    def __init__(self, Resource=None):
        self.original_tagname_ = None
        super(ActionDelete_18, self).__init__()
        self.Resource = Resource
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ActionDelete_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ActionDelete_18.subclass:
            return ActionDelete_18.subclass(*args_, **kwargs_)
        else:
            return ActionDelete_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Resource(self): return self.Resource
    def set_Resource(self, Resource): self.Resource = Resource
    def hasContent_(self):
        if (
            self.Resource is not None or
            super(ActionDelete_18, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ActionDelete_18, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Resource':
            class_obj_ = self.get_class_obj_(child_, ResourceBase_13)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Resource = obj_
            obj_.original_tagname_ = 'Resource'
        super(ActionDelete_18, self).buildChildren(child_, node, nodeName_, True)
# end class ActionDelete_18


class ActionFinishWorkflow_18(ActionBase_18):
    member_data_items_ = {
    }
    subclass = None
    superclass = ActionBase_18
    def __init__(self):
        self.original_tagname_ = None
        super(ActionFinishWorkflow_18, self).__init__()
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ActionFinishWorkflow_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ActionFinishWorkflow_18.subclass:
            return ActionFinishWorkflow_18.subclass(*args_, **kwargs_)
        else:
            return ActionFinishWorkflow_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(ActionFinishWorkflow_18, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ActionFinishWorkflow_18, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ActionFinishWorkflow_18, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ActionFinishWorkflow_18


class ActionNextStep_18(ActionBase_18):
    member_data_items_ = {
        'NextActionListId': MemberSpec_('NextActionListId', 'string', 0),
    }
    subclass = None
    superclass = ActionBase_18
    def __init__(self, NextActionListId=None):
        self.original_tagname_ = None
        super(ActionNextStep_18, self).__init__()
        self.NextActionListId = NextActionListId
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ActionNextStep_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ActionNextStep_18.subclass:
            return ActionNextStep_18.subclass(*args_, **kwargs_)
        else:
            return ActionNextStep_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_NextActionListId(self): return self.NextActionListId
    def set_NextActionListId(self, NextActionListId): self.NextActionListId = NextActionListId
    def hasContent_(self):
        if (
            self.NextActionListId is not None or
            super(ActionNextStep_18, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ActionNextStep_18, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'NextActionListId':
            NextActionListId_ = child_.text
            NextActionListId_ = self.gds_validate_string(NextActionListId_, node, 'NextActionListId')
            self.NextActionListId = NextActionListId_
        super(ActionNextStep_18, self).buildChildren(child_, node, nodeName_, True)
# end class ActionNextStep_18


class ActionHideStream_18(ActionBase_18):
    member_data_items_ = {
        'Stream': MemberSpec_('Stream', 'StreamBase_17', 0),
    }
    subclass = None
    superclass = ActionBase_18
    def __init__(self, Stream=None):
        self.original_tagname_ = None
        super(ActionHideStream_18, self).__init__()
        self.Stream = Stream
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ActionHideStream_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ActionHideStream_18.subclass:
            return ActionHideStream_18.subclass(*args_, **kwargs_)
        else:
            return ActionHideStream_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Stream(self): return self.Stream
    def set_Stream(self, Stream): self.Stream = Stream
    def hasContent_(self):
        if (
            self.Stream is not None or
            super(ActionHideStream_18, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ActionHideStream_18, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Stream':
            class_obj_ = self.get_class_obj_(child_, StreamBase_17)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Stream = obj_
            obj_.original_tagname_ = 'Stream'
        super(ActionHideStream_18, self).buildChildren(child_, node, nodeName_, True)
# end class ActionHideStream_18


class ActionDeletePinNotification_18(ActionBase_18):
    member_data_items_ = {
        'Resource': MemberSpec_('Resource', 'ResourceBase_13', 0),
    }
    subclass = None
    superclass = ActionBase_18
    def __init__(self, Resource=None):
        self.original_tagname_ = None
        super(ActionDeletePinNotification_18, self).__init__()
        self.Resource = Resource
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ActionDeletePinNotification_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ActionDeletePinNotification_18.subclass:
            return ActionDeletePinNotification_18.subclass(*args_, **kwargs_)
        else:
            return ActionDeletePinNotification_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Resource(self): return self.Resource
    def set_Resource(self, Resource): self.Resource = Resource
    def hasContent_(self):
        if (
            self.Resource is not None or
            super(ActionDeletePinNotification_18, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ActionDeletePinNotification_18, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Resource':
            class_obj_ = self.get_class_obj_(child_, ResourceBase_13)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Resource = obj_
            obj_.original_tagname_ = 'Resource'
        super(ActionDeletePinNotification_18, self).buildChildren(child_, node, nodeName_, True)
# end class ActionDeletePinNotification_18


class ActionDeleteMention_18(ActionBase_18):
    member_data_items_ = {
        'Resource': MemberSpec_('Resource', 'ResourceBase_13', 0),
    }
    subclass = None
    superclass = ActionBase_18
    def __init__(self, Resource=None):
        self.original_tagname_ = None
        super(ActionDeleteMention_18, self).__init__()
        self.Resource = Resource
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ActionDeleteMention_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ActionDeleteMention_18.subclass:
            return ActionDeleteMention_18.subclass(*args_, **kwargs_)
        else:
            return ActionDeleteMention_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Resource(self): return self.Resource
    def set_Resource(self, Resource): self.Resource = Resource
    def hasContent_(self):
        if (
            self.Resource is not None or
            super(ActionDeleteMention_18, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ActionDeleteMention_18, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Resource':
            class_obj_ = self.get_class_obj_(child_, ResourceBase_13)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Resource = obj_
            obj_.original_tagname_ = 'Resource'
        super(ActionDeleteMention_18, self).buildChildren(child_, node, nodeName_, True)
# end class ActionDeleteMention_18


class ActionDeleteQuestion_18(ActionBase_18):
    member_data_items_ = {
        'Resource': MemberSpec_('Resource', 'ResourceBase_13', 0),
    }
    subclass = None
    superclass = ActionBase_18
    def __init__(self, Resource=None):
        self.original_tagname_ = None
        super(ActionDeleteQuestion_18, self).__init__()
        self.Resource = Resource
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ActionDeleteQuestion_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ActionDeleteQuestion_18.subclass:
            return ActionDeleteQuestion_18.subclass(*args_, **kwargs_)
        else:
            return ActionDeleteQuestion_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Resource(self): return self.Resource
    def set_Resource(self, Resource): self.Resource = Resource
    def hasContent_(self):
        if (
            self.Resource is not None or
            super(ActionDeleteQuestion_18, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ActionDeleteQuestion_18, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Resource':
            class_obj_ = self.get_class_obj_(child_, ResourceBase_13)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Resource = obj_
            obj_.original_tagname_ = 'Resource'
        super(ActionDeleteQuestion_18, self).buildChildren(child_, node, nodeName_, True)
# end class ActionDeleteQuestion_18


class ActionDeleteReminder_18(ActionBase_18):
    member_data_items_ = {
        'Resource': MemberSpec_('Resource', 'ResourceBase_13', 0),
    }
    subclass = None
    superclass = ActionBase_18
    def __init__(self, Resource=None):
        self.original_tagname_ = None
        super(ActionDeleteReminder_18, self).__init__()
        self.Resource = Resource
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ActionDeleteReminder_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ActionDeleteReminder_18.subclass:
            return ActionDeleteReminder_18.subclass(*args_, **kwargs_)
        else:
            return ActionDeleteReminder_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Resource(self): return self.Resource
    def set_Resource(self, Resource): self.Resource = Resource
    def hasContent_(self):
        if (
            self.Resource is not None or
            super(ActionDeleteReminder_18, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ActionDeleteReminder_18, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Resource':
            class_obj_ = self.get_class_obj_(child_, ResourceBase_13)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Resource = obj_
            obj_.original_tagname_ = 'Resource'
        super(ActionDeleteReminder_18, self).buildChildren(child_, node, nodeName_, True)
# end class ActionDeleteReminder_18


class ActionRescheduleReminder_18(ActionBase_18):
    member_data_items_ = {
        'Resource': MemberSpec_('Resource', 'ResourceBase_13', 0),
        'Date': MemberSpec_('Date', 'dateTime', 0),
        'Timeframe': MemberSpec_('Timeframe', 'string', 0),
    }
    subclass = None
    superclass = ActionBase_18
    def __init__(self, Resource=None, Date=None, Timeframe=None):
        self.original_tagname_ = None
        super(ActionRescheduleReminder_18, self).__init__()
        self.Resource = Resource
        if isinstance(Date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(Date, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = Date
        self.Date = initvalue_
        self.Timeframe = Timeframe
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ActionRescheduleReminder_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ActionRescheduleReminder_18.subclass:
            return ActionRescheduleReminder_18.subclass(*args_, **kwargs_)
        else:
            return ActionRescheduleReminder_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Resource(self): return self.Resource
    def set_Resource(self, Resource): self.Resource = Resource
    def get_Date(self): return self.Date
    def set_Date(self, Date): self.Date = Date
    def get_Timeframe(self): return self.Timeframe
    def set_Timeframe(self, Timeframe): self.Timeframe = Timeframe
    def hasContent_(self):
        if (
            self.Resource is not None or
            self.Date is not None or
            self.Timeframe is not None or
            super(ActionRescheduleReminder_18, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ActionRescheduleReminder_18, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Resource':
            class_obj_ = self.get_class_obj_(child_, ResourceBase_13)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Resource = obj_
            obj_.original_tagname_ = 'Resource'
        elif nodeName_ == 'Date':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.Date = dval_
        elif nodeName_ == 'Timeframe':
            Timeframe_ = child_.text
            Timeframe_ = self.gds_validate_string(Timeframe_, node, 'Timeframe')
            self.Timeframe = Timeframe_
        super(ActionRescheduleReminder_18, self).buildChildren(child_, node, nodeName_, True)
# end class ActionRescheduleReminder_18


class ActionSetReminder_18(ActionBase_18):
    member_data_items_ = {
        'Resource': MemberSpec_('Resource', 'ResourceBase_13', 0),
        'Date': MemberSpec_('Date', 'dateTime', 0),
        'Timeframe': MemberSpec_('Timeframe', 'string', 0),
    }
    subclass = None
    superclass = ActionBase_18
    def __init__(self, Resource=None, Date=None, Timeframe=None):
        self.original_tagname_ = None
        super(ActionSetReminder_18, self).__init__()
        self.Resource = Resource
        if isinstance(Date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(Date, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = Date
        self.Date = initvalue_
        self.Timeframe = Timeframe
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ActionSetReminder_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ActionSetReminder_18.subclass:
            return ActionSetReminder_18.subclass(*args_, **kwargs_)
        else:
            return ActionSetReminder_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Resource(self): return self.Resource
    def set_Resource(self, Resource): self.Resource = Resource
    def get_Date(self): return self.Date
    def set_Date(self, Date): self.Date = Date
    def get_Timeframe(self): return self.Timeframe
    def set_Timeframe(self, Timeframe): self.Timeframe = Timeframe
    def hasContent_(self):
        if (
            self.Resource is not None or
            self.Date is not None or
            self.Timeframe is not None or
            super(ActionSetReminder_18, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ActionSetReminder_18, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Resource':
            class_obj_ = self.get_class_obj_(child_, ResourceBase_13)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Resource = obj_
            obj_.original_tagname_ = 'Resource'
        elif nodeName_ == 'Date':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.Date = dval_
        elif nodeName_ == 'Timeframe':
            Timeframe_ = child_.text
            Timeframe_ = self.gds_validate_string(Timeframe_, node, 'Timeframe')
            self.Timeframe = Timeframe_
        super(ActionSetReminder_18, self).buildChildren(child_, node, nodeName_, True)
# end class ActionSetReminder_18


class Action_18(ActionBase_18):
    member_data_items_ = {
        'Comment': MemberSpec_('Comment', 'string', 0),
        'IsCommentRequired': MemberSpec_('IsCommentRequired', 'boolean', 0),
    }
    subclass = None
    superclass = ActionBase_18
    def __init__(self, Comment=None, IsCommentRequired=None):
        self.original_tagname_ = None
        super(Action_18, self).__init__()
        self.Comment = Comment
        self.IsCommentRequired = IsCommentRequired
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Action_18)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Action_18.subclass:
            return Action_18.subclass(*args_, **kwargs_)
        else:
            return Action_18(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Comment(self): return self.Comment
    def set_Comment(self, Comment): self.Comment = Comment
    def get_IsCommentRequired(self): return self.IsCommentRequired
    def set_IsCommentRequired(self, IsCommentRequired): self.IsCommentRequired = IsCommentRequired
    def hasContent_(self):
        if (
            self.Comment is not None or
            self.IsCommentRequired is not None or
            super(Action_18, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Action_18, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Comment':
            Comment_ = child_.text
            Comment_ = self.gds_validate_string(Comment_, node, 'Comment')
            self.Comment = Comment_
        elif nodeName_ == 'IsCommentRequired':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsCommentRequired')
            self.IsCommentRequired = ival_
        super(Action_18, self).buildChildren(child_, node, nodeName_, True)
# end class Action_18


class ReminderBase_20(ActionableResource_20):
    member_data_items_ = {
        'Timeframe': MemberSpec_('Timeframe', 'string', 0),
        'Date': MemberSpec_('Date', 'dateTime', 0),
    }
    subclass = None
    superclass = ActionableResource_20
    def __init__(self, Timeframe=None, Date=None):
        self.original_tagname_ = None
        super(ReminderBase_20, self).__init__()
        self.Timeframe = Timeframe
        if isinstance(Date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(Date, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = Date
        self.Date = initvalue_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ReminderBase_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ReminderBase_20.subclass:
            return ReminderBase_20.subclass(*args_, **kwargs_)
        else:
            return ReminderBase_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Timeframe(self): return self.Timeframe
    def set_Timeframe(self, Timeframe): self.Timeframe = Timeframe
    def get_Date(self): return self.Date
    def set_Date(self, Date): self.Date = Date
    def hasContent_(self):
        if (
            self.Timeframe is not None or
            self.Date is not None or
            super(ReminderBase_20, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ReminderBase_20, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Timeframe':
            Timeframe_ = child_.text
            Timeframe_ = self.gds_validate_string(Timeframe_, node, 'Timeframe')
            self.Timeframe = Timeframe_
        elif nodeName_ == 'Date':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.Date = dval_
        super(ReminderBase_20, self).buildChildren(child_, node, nodeName_, True)
# end class ReminderBase_20


class Reminder_21(ActionableResource_21):
    member_data_items_ = {
        'ReminderType': MemberSpec_('ReminderType', 'string', 0),
        'Timeframe': MemberSpec_('Timeframe', 'string', 0),
        'Date': MemberSpec_('Date', 'dateTime', 0),
    }
    subclass = None
    superclass = ActionableResource_21
    def __init__(self, ReminderType=None, Timeframe=None, Date=None):
        self.original_tagname_ = None
        super(Reminder_21, self).__init__()
        self.ReminderType = ReminderType
        self.Timeframe = Timeframe
        if isinstance(Date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(Date, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = Date
        self.Date = initvalue_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Reminder_21)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Reminder_21.subclass:
            return Reminder_21.subclass(*args_, **kwargs_)
        else:
            return Reminder_21(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ReminderType(self): return self.ReminderType
    def set_ReminderType(self, ReminderType): self.ReminderType = ReminderType
    def get_Timeframe(self): return self.Timeframe
    def set_Timeframe(self, Timeframe): self.Timeframe = Timeframe
    def get_Date(self): return self.Date
    def set_Date(self, Date): self.Date = Date
    def hasContent_(self):
        if (
            self.ReminderType is not None or
            self.Timeframe is not None or
            self.Date is not None or
            super(Reminder_21, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Reminder_21, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ReminderType':
            ReminderType_ = child_.text
            ReminderType_ = self.gds_validate_string(ReminderType_, node, 'ReminderType')
            self.ReminderType = ReminderType_
        elif nodeName_ == 'Timeframe':
            Timeframe_ = child_.text
            Timeframe_ = self.gds_validate_string(Timeframe_, node, 'Timeframe')
            self.Timeframe = Timeframe_
        elif nodeName_ == 'Date':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.Date = dval_
        super(Reminder_21, self).buildChildren(child_, node, nodeName_, True)
# end class Reminder_21


class Reminder_22(ActionableResource_22):
    member_data_items_ = {
        'ReminderType': MemberSpec_('ReminderType', 'string', 0),
        'Timeframe': MemberSpec_('Timeframe', 'string', 0),
        'Date': MemberSpec_('Date', 'dateTime', 0),
        'IsAllDay': MemberSpec_('IsAllDay', 'boolean', 0),
        'DisableDefaultActions': MemberSpec_('DisableDefaultActions', 'boolean', 0),
        'ReminderSnippet': MemberSpec_('ReminderSnippet', 'string', 0),
    }
    subclass = None
    superclass = ActionableResource_22
    def __init__(self, ReminderType=None, Timeframe=None, Date=None, IsAllDay=None, DisableDefaultActions=None, ReminderSnippet=None):
        self.original_tagname_ = None
        super(Reminder_22, self).__init__()
        self.ReminderType = ReminderType
        self.Timeframe = Timeframe
        if isinstance(Date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(Date, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = Date
        self.Date = initvalue_
        self.IsAllDay = IsAllDay
        self.DisableDefaultActions = DisableDefaultActions
        self.ReminderSnippet = ReminderSnippet
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Reminder_22)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Reminder_22.subclass:
            return Reminder_22.subclass(*args_, **kwargs_)
        else:
            return Reminder_22(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ReminderType(self): return self.ReminderType
    def set_ReminderType(self, ReminderType): self.ReminderType = ReminderType
    def get_Timeframe(self): return self.Timeframe
    def set_Timeframe(self, Timeframe): self.Timeframe = Timeframe
    def get_Date(self): return self.Date
    def set_Date(self, Date): self.Date = Date
    def get_IsAllDay(self): return self.IsAllDay
    def set_IsAllDay(self, IsAllDay): self.IsAllDay = IsAllDay
    def get_DisableDefaultActions(self): return self.DisableDefaultActions
    def set_DisableDefaultActions(self, DisableDefaultActions): self.DisableDefaultActions = DisableDefaultActions
    def get_ReminderSnippet(self): return self.ReminderSnippet
    def set_ReminderSnippet(self, ReminderSnippet): self.ReminderSnippet = ReminderSnippet
    def hasContent_(self):
        if (
            self.ReminderType is not None or
            self.Timeframe is not None or
            self.Date is not None or
            self.IsAllDay is not None or
            self.DisableDefaultActions is not None or
            self.ReminderSnippet is not None or
            super(Reminder_22, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Reminder_22, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ReminderType':
            ReminderType_ = child_.text
            ReminderType_ = self.gds_validate_string(ReminderType_, node, 'ReminderType')
            self.ReminderType = ReminderType_
        elif nodeName_ == 'Timeframe':
            Timeframe_ = child_.text
            Timeframe_ = self.gds_validate_string(Timeframe_, node, 'Timeframe')
            self.Timeframe = Timeframe_
        elif nodeName_ == 'Date':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.Date = dval_
        elif nodeName_ == 'IsAllDay':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsAllDay')
            self.IsAllDay = ival_
        elif nodeName_ == 'DisableDefaultActions':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'DisableDefaultActions')
            self.DisableDefaultActions = ival_
        elif nodeName_ == 'ReminderSnippet':
            ReminderSnippet_ = child_.text
            ReminderSnippet_ = self.gds_validate_string(ReminderSnippet_, node, 'ReminderSnippet')
            self.ReminderSnippet = ReminderSnippet_
        super(Reminder_22, self).buildChildren(child_, node, nodeName_, True)
# end class Reminder_22


class ActionableResourceOverview_20(ActionableResource_20):
    member_data_items_ = {
        'NumberOfRemainingItems': MemberSpec_('NumberOfRemainingItems', 'int', 0),
        'NumberOfCompletedItems': MemberSpec_('NumberOfCompletedItems', 'int', 0),
    }
    subclass = None
    superclass = ActionableResource_20
    def __init__(self, NumberOfRemainingItems=None, NumberOfCompletedItems=None):
        self.original_tagname_ = None
        super(ActionableResourceOverview_20, self).__init__()
        self.NumberOfRemainingItems = NumberOfRemainingItems
        self.NumberOfCompletedItems = NumberOfCompletedItems
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ActionableResourceOverview_20)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ActionableResourceOverview_20.subclass:
            return ActionableResourceOverview_20.subclass(*args_, **kwargs_)
        else:
            return ActionableResourceOverview_20(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_NumberOfRemainingItems(self): return self.NumberOfRemainingItems
    def set_NumberOfRemainingItems(self, NumberOfRemainingItems): self.NumberOfRemainingItems = NumberOfRemainingItems
    def get_NumberOfCompletedItems(self): return self.NumberOfCompletedItems
    def set_NumberOfCompletedItems(self, NumberOfCompletedItems): self.NumberOfCompletedItems = NumberOfCompletedItems
    def hasContent_(self):
        if (
            self.NumberOfRemainingItems is not None or
            self.NumberOfCompletedItems is not None or
            super(ActionableResourceOverview_20, self).hasContent_()
        ):
            return True
        else:
            return False
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ActionableResourceOverview_20, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'NumberOfRemainingItems':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'NumberOfRemainingItems')
            self.NumberOfRemainingItems = ival_
        elif nodeName_ == 'NumberOfCompletedItems':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'NumberOfCompletedItems')
            self.NumberOfCompletedItems = ival_
        super(ActionableResourceOverview_20, self).buildChildren(child_, node, nodeName_, True)
# end class ActionableResourceOverview_20


class ActionableResourceOverview_21(ActionableResource_21):
    member_data_items_ = {
        'NumberOfRemainingItems': MemberSpec_('NumberOfRemainingItems', 'int', 0),
        'NumberOfCompletedItems': MemberSpec_('NumberOfCompletedItems', 'int', 0),
    }
    subclass = None
    superclass = ActionableResource_21
    def __init__(self, NumberOfRemainingItems=None, NumberOfCompletedItems=None):
        self.original_tagname_ = None
        super(ActionableResourceOverview_21, self).__init__()
        self.NumberOfRemainingItems = NumberOfRemainingItems
        self.NumberOfCompletedItems = NumberOfCompletedItems
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ActionableResourceOverview_21)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ActionableResourceOverview_21.subclass:
            return ActionableResourceOverview_21.subclass(*args_, **kwargs_)
        else:
            return ActionableResourceOverview_21(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_NumberOfRemainingItems(self): return self.NumberOfRemaining