#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated  by generateDS.py version 2.38.6.
# Python 3.8.5 (default, Jul 28 2020, 12:59:40)  [GCC 9.3.0]
#
# Command line options:
#   ('--no-namespace-defs', '')
#   ('--no-dates', '')
#   ('--member-specs', 'list')
#   ('--use-getter-setter', 'none')
#   ('-f', '')
#   ('-o', '/home/rvalyi/DEV/nfelib2/nfelib/v4_00/retConsReciNFe.py')
#
# Command line arguments:
#   /tmp/generated/schemas/nfe/v4_00/retConsReciNFe_v2.00.xsd
#
# Command line:
#   /usr/local/bin/generateDS.py --no-namespace-defs --no-dates --member-specs="list" --use-getter-setter="none" -f -o "/home/rvalyi/DEV/nfelib2/nfelib/v4_00/retConsReciNFe.py" /tmp/generated/schemas/nfe/v4_00/retConsReciNFe_v2.00.xsd
#
# Current working directory (os.getcwd()):
#   v4_00
#

import sys
try:
    ModulenotfoundExp_ = ModuleNotFoundError
except NameError:
    ModulenotfoundExp_ = ImportError
from six.moves import zip_longest
import os
import re as re_
import base64
import datetime as datetime_
import decimal as decimal_
try:
    from lxml import etree as etree_
except ModulenotfoundExp_ :
    from xml.etree import ElementTree as etree_


Validate_simpletypes_ = True
SaveElementTreeNode = True
if sys.version_info.major == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    try:
        if isinstance(infile, os.PathLike):
            infile = os.path.join(infile)
    except AttributeError:
        pass
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc

def parsexmlstring_(instring, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    element = etree_.fromstring(instring, parser=parser, **kwargs)
    return element

#
# Namespace prefix definition table (and other attributes, too)
#
# The module generatedsnamespaces, if it is importable, must contain
# a dictionary named GeneratedsNamespaceDefs.  This Python dictionary
# should map element type names (strings) to XML schema namespace prefix
# definitions.  The export method for any class for which there is
# a namespace prefix definition, will export that definition in the
# XML representation of that element.  See the export method of
# any generated element type class for an example of the use of this
# table.
# A sample table is:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceDefs = {
#         "ElementtypeA": "http://www.xxx.com/namespaceA",
#         "ElementtypeB": "http://www.xxx.com/namespaceB",
#     }
#
# Additionally, the generatedsnamespaces module can contain a python
# dictionary named GenerateDSNamespaceTypePrefixes that associates element
# types with the namespace prefixes that are to be added to the
# "xsi:type" attribute value.  See the exportAttributes method of
# any generated element type and the generation of "xsi:type" for an
# example of the use of this table.
# An example table:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceTypePrefixes = {
#         "ElementtypeC": "aaa:",
#         "ElementtypeD": "bbb:",
#     }
#

try:
    from generatedsnamespaces import GenerateDSNamespaceDefs as GenerateDSNamespaceDefs_
except ModulenotfoundExp_ :
    GenerateDSNamespaceDefs_ = {}
try:
    from generatedsnamespaces import GenerateDSNamespaceTypePrefixes as GenerateDSNamespaceTypePrefixes_
except ModulenotfoundExp_ :
    GenerateDSNamespaceTypePrefixes_ = {}

#
# You can replace the following class definition by defining an
# importable module named "generatedscollector" containing a class
# named "GdsCollector".  See the default class definition below for
# clues about the possible content of that class.
#
try:
    from generatedscollector import GdsCollector as GdsCollector_
except ModulenotfoundExp_ :

    class GdsCollector_(object):

        def __init__(self, messages=None):
            if messages is None:
                self.messages = []
            else:
                self.messages = messages

        def add_message(self, msg):
            self.messages.append(msg)

        def get_messages(self):
            return self.messages

        def clear_messages(self):
            self.messages = []

        def print_messages(self):
            for msg in self.messages:
                print("Warning: {}".format(msg))

        def write_messages(self, outstream):
            for msg in self.messages:
                outstream.write("Warning: {}\n".format(msg))


#
# The super-class for enum types
#

try:
    from enum import Enum
except ModulenotfoundExp_ :
    Enum = object

#
# The root super-class for element type classes
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ModulenotfoundExp_ as exp:
    
    class GeneratedsSuper(object):
        __hash__ = object.__hash__
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_parse_string(self, input_data, node=None, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_parse_integer(self, input_data, node=None, input_name=''):
            try:
                ival = int(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires integer value: %s' % exp)
            return ival
        def gds_validate_integer(self, input_data, node=None, input_name=''):
            try:
                value = int(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires integer value')
            return value
        def gds_format_integer_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integer values')
            return values
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_parse_float(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires float or double value: %s' % exp)
            return fval_
        def gds_validate_float(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires float value')
            return value
        def gds_format_float_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of float values')
            return values
        def gds_format_decimal(self, input_data, input_name=''):
            return_value = '%s' % input_data
            if '.' in return_value:
                return_value = return_value.rstrip('0')
                if return_value.endswith('.'):
                    return_value = return_value.rstrip('.')
            return return_value
        def gds_parse_decimal(self, input_data, node=None, input_name=''):
            try:
                decimal_value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return decimal_value
        def gds_validate_decimal(self, input_data, node=None, input_name=''):
            try:
                value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return value
        def gds_format_decimal_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return ' '.join([self.gds_format_decimal(item) for item in input_data])
        def gds_validate_decimal_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    decimal_.Decimal(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of decimal values')
            return values
        def gds_format_double(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_parse_double(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires double or float value: %s' % exp)
            return fval_
        def gds_validate_double(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires double or float value')
            return value
        def gds_format_double_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(
                        node, 'Requires sequence of double or float values')
            return values
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_parse_boolean(self, input_data, node=None, input_name=''):
            if input_data in ('true', '1'):
                bval = True
            elif input_data in ('false', '0'):
                bval = False
            else:
                raise_parse_error(node, 'Requires boolean value')
            return bval
        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            if input_data not in (True, 1, False, 0, ):
                raise_parse_error(
                    node,
                    'Requires boolean value '
                    '(one of True, 1, False, 0)')
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                value = self.gds_parse_boolean(value, node, input_name)
                if value not in (True, 1, False, 0, ):
                    raise_parse_error(
                        node,
                        'Requires sequence of boolean values '
                        '(one of True, 1, False, 0)')
            return values
        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (
                    time_parts[0], "{}".format(micro_seconds).rjust(6, "0"), )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(
                                hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.
            # The target value must match at least one of the patterns
            # in order for the test to succeed.
            found1 = True
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    mo = re_.search(patterns2, target)
                    if mo is not None and len(mo.group(0)) == len(target):
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_check_cardinality_(
                self, value, input_name,
                min_occurs=0, max_occurs=1, required=None):
            if value is None:
                length = 0
            elif isinstance(value, list):
                length = len(value)
            else:
                length = 1
            if required is not None :
                if required and length < 1:
                    self.gds_collector_.add_message(
                        "Required value {}{} is missing".format(
                            input_name, self.gds_get_node_lineno_()))
            if length < min_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is below "
                    "the minimum allowed, "
                    "expected at least {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        min_occurs, length))
            elif length > max_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is above "
                    "the maximum allowed, "
                    "expected at most {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        max_occurs, length))
        def gds_validate_builtin_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value, input_name=input_name)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_validate_defined_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            # provide default value in case option --disable-xml is used.
            content = ""
            content = etree_.tostring(node, encoding="unicode")
            return content
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.items()))
        @staticmethod
        def gds_encode(instring):
            if sys.version_info.major == 2:
                if ExternalEncoding:
                    encoding = ExternalEncoding
                else:
                    encoding = 'utf-8'
                return instring.encode(encoding)
            else:
                return instring
        @staticmethod
        def convert_unicode(instring):
            if isinstance(instring, str):
                result = quote_xml(instring)
            elif sys.version_info.major == 2 and isinstance(instring, unicode):
                result = quote_xml(instring).encode('utf8')
            else:
                result = GeneratedsSuper.gds_encode(str(instring))
            return result
        def __eq__(self, other):
            def excl_select_objs_(obj):
                return (obj[0] != 'parent_object_' and
                        obj[0] != 'gds_collector_')
            if type(self) != type(other):
                return False
            return all(x == y for x, y in zip_longest(
                filter(excl_select_objs_, self.__dict__.items()),
                filter(excl_select_objs_, other.__dict__.items())))
        def __ne__(self, other):
            return not self.__eq__(other)
        # Django ETL transform hooks.
        def gds_djo_etl_transform(self):
            pass
        def gds_djo_etl_transform_db_obj(self, dbobj):
            pass
        # SQLAlchemy ETL transform hooks.
        def gds_sqa_etl_transform(self):
            return 0, None
        def gds_sqa_etl_transform_db_obj(self, dbobj):
            pass
        def gds_get_node_lineno_(self):
            if (hasattr(self, "gds_elementtree_node_") and
                    self.gds_elementtree_node_ is not None):
                return ' near line {}'.format(
                    self.gds_elementtree_node_.sourceline)
            else:
                return ""
    
    
    def getSubclassFromModule_(module, class_):
        '''Get the subclass of a class from a specific module.'''
        name = class_.__name__ + 'Sub'
        if hasattr(module, name):
            return getattr(module, name)
        else:
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = ''
# Set this to false in order to deactivate during export, the use of
# name space prefixes captured from the input document.
UseCapturedNS_ = True
CapturedNsmap_ = {}
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ''
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s2 = ''
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos:mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start():mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        if prefix == 'xml':
            namespace = 'http://www.w3.org/XML/1998/namespace'
        else:
            namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


def encode_str_2_3(instr):
    return instr


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if node is not None:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace,
               pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(
                outfile, level, namespace, name_=name,
                pretty_print=pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name,
                base64.b64encode(self.value),
                self.name))
    def to_etree(self, element, mapping_=None, nsmap_=None):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(
                element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self, mapping_=None, nsmap_=None):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0,
            optional=0, child_attrs=None, choice=None):
        self.name = name
        self.data_type = data_type
        self.container = container
        self.child_attrs = child_attrs
        self.choice = choice
        self.optional = optional
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container
    def set_child_attrs(self, child_attrs): self.child_attrs = child_attrs
    def get_child_attrs(self): return self.child_attrs
    def set_choice(self, choice): self.choice = choice
    def get_choice(self): return self.choice
    def set_optional(self, optional): self.optional = optional
    def get_optional(self): return self.optional


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class CRTType(str, Enum):
    """Código de Regime Tributário.
    Este campo será obrigatoriamente preenchido com:
    1 – Simples Nacional;
    2 – Simples Nacional – excesso de sublimite de receita bruta;
    3 – Regime Normal. (v2.0)."""
    _1='1'
    _2='2'
    _3='3'


class CSOSNType(str, Enum):
    """101- Tributada pelo Simples Nacional com permissão de crédito.
    (v.2.0)"""
    _1_01='101'


class CSOSNType26(str, Enum):
    """102- Tributada pelo Simples Nacional sem permissão de crédito.
    103 – Isenção do ICMS no Simples Nacional para faixa de receita bruta.
    300 – Imune.
    400 – Não tributda pelo Simples Nacional (v.2.0) (v.2.0)"""
    _1_02='102'
    _1_03='103'
    _3_00='300'
    _4_00='400'


class CSOSNType27(str, Enum):
    """201- Tributada pelo Simples Nacional com permissão de crédito e com
    cobrança do ICMS por Substituição Tributária (v.2.0)"""
    _2_01='201'


class CSOSNType29(str, Enum):
    """202- Tributada pelo Simples Nacional sem permissão de crédito e com
    cobrança do ICMS por Substituição Tributária;
    203- Isenção do ICMS nos Simples Nacional para faixa de receita bruta e com
    cobrança do ICMS por Substituição Tributária (v.2.0)"""
    _2_02='202'
    _2_03='203'


class CSOSNType31(str, Enum):
    """500 – ICMS cobrado anterirmente por substituição tributária
    (substituído) ou por antecipação
    (v.2.0)"""
    _5_00='500'


class CSOSNType32(str, Enum):
    """Tributação pelo ICMS 900 - Outros(v2.0)"""
    _9_00='900'


class CSTType(str, Enum):
    """Tributção pelo ICMS
    00 - Tributada integralmente"""
    _0_0='00'


class CSTType10(str, Enum):
    """Tributção pelo ICMS
    30 - Isenta ou não tributada e com cobrança do ICMS por substituição
    tributária"""
    _3_0='30'


class CSTType12(str, Enum):
    """Tributação pelo ICMS
    40 - Isenta
    41 - Não tributada
    50 - Suspensão
    51 - Diferimento"""
    _4_0='40'
    _4_1='41'
    _5_0='50'


class CSTType13(str, Enum):
    """Tributção pelo ICMS
    20 - Com redução de base de cálculo"""
    _5_1='51'


class CSTType15(str, Enum):
    """Tributação pelo ICMS
    60 - ICMS cobrado anteriormente por substituição tributária"""
    _6_0='60'


class CSTType16(str, Enum):
    """Tributção pelo ICMS
    70 - Com redução de base de cálculo e cobrança do ICMS por substituição
    tributária"""
    _7_0='70'


class CSTType19(str, Enum):
    """Tributção pelo ICMS
    90 - Outras"""
    _9_0='90'


class CSTType22(str, Enum):
    """Tributação pelo ICMS
    10 - Tributada e com cobrança do ICMS por substituição tributária;
    90 – Outros."""
    _1_0='10'
    _9_0='90'


class CSTType25(str, Enum):
    """Tributção pelo ICMS
    41-Não Tributado (v2.0)"""
    _4_1='41'


class CSTType35(str, Enum):
    """Código da Situação Tributária do IPI:
    00-Entrada com recuperação de crédito
    49 - Outras entradas
    50-Saída tributada
    99-Outras saídas"""
    _0_0='00'
    _4_9='49'
    _5_0='50'
    _9_9='99'


class CSTType36(str, Enum):
    """Código da Situação Tributária do IPI:
    01-Entrada tributada com alíquota zero
    02-Entrada isenta
    03-Entrada não-tributada
    04-Entrada imune
    05-Entrada com suspensão
    51-Saída tributada com alíquota zero
    52-Saída isenta
    53-Saída não-tributada
    54-Saída imune
    55-Saída com suspensão"""
    _0_1='01'
    _0_2='02'
    _0_3='03'
    _0_4='04'
    _0_5='05'
    _5_1='51'
    _5_2='52'
    _5_3='53'
    _5_4='54'
    _5_5='55'


class CSTType37(str, Enum):
    """Código de Situação Tributária do PIS.
    01 – Operação Tributável - Base de Cálculo = Valor da Operação Alíquota
    Normal (Cumulativo/Não Cumulativo);
    02 - Operação Tributável - Base de Calculo = Valor da Operação (Alíquota
    Diferenciada);"""
    _0_1='01'
    _0_2='02'


class CSTType38(str, Enum):
    """Código de Situação Tributária do PIS.
    03 - Operação Tributável - Base de Calculo = Quantidade Vendida x Alíquota
    por Unidade de Produto;"""
    _0_3='03'


class CSTType39(str, Enum):
    """Código de Situação Tributária do PIS.
    04 - Operação Tributável - Tributação Monofásica - (Alíquota Zero);
    06 - Operação Tributável - Alíquota Zero;
    07 - Operação Isenta da contribuição;
    08 - Operação Sem Incidência da contribuição;
    09 - Operação com suspensão da contribuição;"""
    _0_4='04'
    _0_6='06'
    _0_7='07'
    _0_8='08'
    _0_9='09'


class CSTType40(str, Enum):
    """Código de Situação Tributária do PIS.
    99 - Outras Operações."""
    _4_9='49'
    _5_0='50'
    _5_1='51'
    _5_2='52'
    _5_3='53'
    _5_4='54'
    _5_5='55'
    _5_6='56'
    _6_0='60'
    _6_1='61'
    _6_2='62'
    _6_3='63'
    _6_4='64'
    _6_5='65'
    _6_6='66'
    _6_7='67'
    _7_0='70'
    _7_1='71'
    _7_2='72'
    _7_3='73'
    _7_4='74'
    _7_5='75'
    _9_8='98'
    _9_9='99'


class CSTType41(str, Enum):
    """Código de Situação Tributária do COFINS.
    01 – Operação Tributável - Base de Cálculo = Valor da Operação Alíquota
    Normal (Cumulativo/Não Cumulativo);
    02 - Operação Tributável - Base de Calculo = Valor da Operação (Alíquota
    Diferenciada);"""
    _0_1='01'
    _0_2='02'


class CSTType42(str, Enum):
    """Código de Situação Tributária do COFINS.
    03 - Operação Tributável - Base de Calculo = Quantidade Vendida x Alíquota
    por Unidade de Produto;"""
    _0_3='03'


class CSTType43(str, Enum):
    """Código de Situação Tributária do COFINS:
    04 - Operação Tributável - Tributação Monofásica - (Alíquota Zero);
    06 - Operação Tributável - Alíquota Zero;
    07 - Operação Isenta da contribuição;
    08 - Operação Sem Incidência da contribuição;
    09 - Operação com suspensão da contribuição;"""
    _0_4='04'
    _0_6='06'
    _0_7='07'
    _0_8='08'
    _0_9='09'


class CSTType44(str, Enum):
    """Código de Situação Tributária do COFINS:
    49 - Outras Operações de Saída
    50 - Operação com Direito a Crédito - Vinculada Exclusivamente a Receita
    Tributada no Mercado Interno
    51 - Operação com Direito a Crédito – Vinculada Exclusivamente a Receita
    Não Tributada no Mercado Interno
    52 - Operação com Direito a Crédito - Vinculada Exclusivamente a Receita de
    Exportação
    53 - Operação com Direito a Crédito - Vinculada a Receitas Tributadas e
    Não-Tributadas no Mercado Interno
    54 - Operação com Direito a Crédito - Vinculada a Receitas Tributadas no
    Mercado Interno e de Exportação
    55 - Operação com Direito a Crédito - Vinculada a Receitas Não-Tributadas
    no Mercado Interno e de Exportação
    56 - Operação com Direito a Crédito - Vinculada a Receitas Tributadas e
    Não-Tributadas no Mercado Interno, e de Exportação
    60 - Crédito Presumido - Operação de Aquisição Vinculada Exclusivamente a
    Receita Tributada no Mercado Interno
    61 - Crédito Presumido - Operação de Aquisição Vinculada Exclusivamente a
    Receita Não-Tributada no Mercado Interno
    62 - Crédito Presumido - Operação de Aquisição Vinculada Exclusivamente a
    Receita de Exportação
    63 - Crédito Presumido - Operação de Aquisição Vinculada a Receitas
    Tributadas e Não-Tributadas no Mercado Interno
    64 - Crédito Presumido - Operação de Aquisição Vinculada a Receitas
    Tributadas no Mercado Interno e de Exportação
    65 - Crédito Presumido - Operação de Aquisição Vinculada a Receitas Não-
    Tributadas no Mercado Interno e de Exportação
    66 - Crédito Presumido - Operação de Aquisição Vinculada a Receitas
    Tributadas e Não-Tributadas no Mercado Interno, e de Exportação
    67 - Crédito Presumido - Outras Operações
    70 - Operação de Aquisição sem Direito a Crédito
    71 - Operação de Aquisição com Isenção
    72 - Operação de Aquisição com Suspensão
    73 - Operação de Aquisição a Alíquota Zero
    74 - Operação de Aquisição sem Incidência da Contribuição
    75 - Operação de Aquisição por Substituição Tributária
    98 - Outras Operações de Entrada
    99 - Outras Operações."""
    _4_9='49'
    _5_0='50'
    _5_1='51'
    _5_2='52'
    _5_3='53'
    _5_4='54'
    _5_5='55'
    _5_6='56'
    _6_0='60'
    _6_1='61'
    _6_2='62'
    _6_3='63'
    _6_4='64'
    _6_5='65'
    _6_6='66'
    _6_7='67'
    _7_0='70'
    _7_1='71'
    _7_2='72'
    _7_3='73'
    _7_4='74'
    _7_5='75'
    _9_8='98'
    _9_9='99'


class CSTType6(str, Enum):
    """10 - Tributada e com cobrança do ICMS por substituição tributária"""
    _1_0='10'


class CSTType8(str, Enum):
    """Tributção pelo ICMS
    20 - Com redução de base de cálculo"""
    _2_0='20'


class TAmb(str, Enum):
    """Tipo Ambiente"""
    _1='1'
    _2='2'


class TCListServ(str, Enum):
    """Tipo Código da Lista de Serviços LC 116/2003"""
    _1_01='101'
    _1_02='102'
    _1_03='103'
    _1_04='104'
    _1_05='105'
    _1_06='106'
    _1_07='107'
    _1_08='108'
    _2_01='201'
    _3_02='302'
    _3_03='303'
    _3_04='304'
    _3_05='305'
    _4_01='401'
    _4_02='402'
    _4_03='403'
    _4_04='404'
    _4_05='405'
    _4_06='406'
    _4_07='407'
    _4_08='408'
    _4_09='409'
    _4_10='410'
    _4_11='411'
    _4_12='412'
    _4_13='413'
    _4_14='414'
    _4_15='415'
    _4_16='416'
    _4_17='417'
    _4_18='418'
    _4_19='419'
    _4_20='420'
    _4_21='421'
    _4_22='422'
    _4_23='423'
    _5_01='501'
    _5_02='502'
    _5_03='503'
    _5_04='504'
    _5_05='505'
    _5_06='506'
    _5_07='507'
    _5_08='508'
    _5_09='509'
    _6_01='601'
    _6_02='602'
    _6_03='603'
    _6_04='604'
    _6_05='605'
    _7_01='701'
    _7_02='702'
    _7_03='703'
    _7_04='704'
    _7_05='705'
    _7_06='706'
    _7_07='707'
    _7_08='708'
    _7_09='709'
    _7_10='710'
    _7_11='711'
    _7_12='712'
    _7_13='713'
    _7_16='716'
    _7_17='717'
    _7_18='718'
    _7_19='719'
    _7_20='720'
    _7_21='721'
    _7_22='722'
    _8_01='801'
    _8_02='802'
    _9_01='901'
    _9_02='902'
    _9_03='903'
    _1_001='1001'
    _1_002='1002'
    _1_003='1003'
    _1_004='1004'
    _1_005='1005'
    _1_006='1006'
    _1_007='1007'
    _1_008='1008'
    _1_009='1009'
    _1_010='1010'
    _1_101='1101'
    _1_102='1102'
    _1_103='1103'
    _1_104='1104'
    _1_201='1201'
    _1_202='1202'
    _1_203='1203'
    _1_204='1204'
    _1_205='1205'
    _1_206='1206'
    _1_207='1207'
    _1_208='1208'
    _1_209='1209'
    _1_210='1210'
    _1_211='1211'
    _1_212='1212'
    _1_213='1213'
    _1_214='1214'
    _1_215='1215'
    _1_216='1216'
    _1_217='1217'
    _1_302='1302'
    _1_303='1303'
    _1_304='1304'
    _1_305='1305'
    _1_401='1401'
    _1_402='1402'
    _1_403='1403'
    _1_404='1404'
    _1_405='1405'
    _1_406='1406'
    _1_407='1407'
    _1_408='1408'
    _1_409='1409'
    _1_410='1410'
    _1_411='1411'
    _1_412='1412'
    _1_413='1413'
    _1_501='1501'
    _1_502='1502'
    _1_503='1503'
    _1_504='1504'
    _1_505='1505'
    _1_506='1506'
    _1_507='1507'
    _1_508='1508'
    _1_509='1509'
    _1_510='1510'
    _1_511='1511'
    _1_512='1512'
    _1_513='1513'
    _1_514='1514'
    _1_515='1515'
    _1_516='1516'
    _1_517='1517'
    _1_518='1518'
    _1_601='1601'
    _1_701='1701'
    _1_702='1702'
    _1_703='1703'
    _1_704='1704'
    _1_705='1705'
    _1_706='1706'
    _1_708='1708'
    _1_709='1709'
    _1_710='1710'
    _1_711='1711'
    _1_712='1712'
    _1_713='1713'
    _1_714='1714'
    _1_715='1715'
    _1_716='1716'
    _1_717='1717'
    _1_718='1718'
    _1_719='1719'
    _1_720='1720'
    _1_721='1721'
    _1_722='1722'
    _1_723='1723'
    _1_724='1724'
    _1_801='1801'
    _1_901='1901'
    _2_001='2001'
    _2_002='2002'
    _2_003='2003'
    _2_101='2101'
    _2_201='2201'
    _2_301='2301'
    _2_401='2401'
    _2_501='2501'
    _2_502='2502'
    _2_503='2503'
    _2_504='2504'
    _2_601='2601'
    _2_701='2701'
    _2_801='2801'
    _2_901='2901'
    _3_001='3001'
    _3_101='3101'
    _3_201='3201'
    _3_301='3301'
    _3_401='3401'
    _3_501='3501'
    _3_601='3601'
    _3_701='3701'
    _3_801='3801'
    _3_901='3901'
    _4_001='4001'


class TCfop(str, Enum):
    """Tipo CFOP // maio/2009 - Atualização do Ajuste SINIEF 14/2009Tipo CFOP -
    PL_005d - 11/08/09 - atualizaçãp do Ajuste SINIEF 05/2009Tipo CFOP //
    24/10/08 acrescentada a lista de CFOP validos // PL_06 eliminado os
    CFOP de prestação de serviços de comunicação // PL_006f eliminado os
    CFOP de prestação de serviços de transporte"""
    _1_101='1101'
    _1_102='1102'
    _1_111='1111'
    _1_113='1113'
    _1_116='1116'
    _1_117='1117'
    _1_118='1118'
    _1_120='1120'
    _1_121='1121'
    _1_122='1122'
    _1_124='1124'
    _1_125='1125'
    _1_126='1126'
    _1_128='1128'
    _1_151='1151'
    _1_152='1152'
    _1_153='1153'
    _1_154='1154'
    _1_201='1201'
    _1_202='1202'
    _1_203='1203'
    _1_204='1204'
    _1_205='1205'
    _1_206='1206'
    _1_207='1207'
    _1_208='1208'
    _1_209='1209'
    _1_251='1251'
    _1_252='1252'
    _1_253='1253'
    _1_254='1254'
    _1_255='1255'
    _1_256='1256'
    _1_257='1257'
    _1_301='1301'
    _1_302='1302'
    _1_303='1303'
    _1_304='1304'
    _1_305='1305'
    _1_306='1306'
    _1_351='1351'
    _1_352='1352'
    _1_353='1353'
    _1_354='1354'
    _1_355='1355'
    _1_356='1356'
    _1_360='1360'
    _1_401='1401'
    _1_403='1403'
    _1_406='1406'
    _1_407='1407'
    _1_408='1408'
    _1_409='1409'
    _1_410='1410'
    _1_411='1411'
    _1_414='1414'
    _1_415='1415'
    _1_451='1451'
    _1_452='1452'
    _1_501='1501'
    _1_503='1503'
    _1_504='1504'
    _1_505='1505'
    _1_506='1506'
    _1_551='1551'
    _1_552='1552'
    _1_553='1553'
    _1_554='1554'
    _1_555='1555'
    _1_556='1556'
    _1_557='1557'
    _1_601='1601'
    _1_602='1602'
    _1_603='1603'
    _1_604='1604'
    _1_605='1605'
    _1_651='1651'
    _1_652='1652'
    _1_653='1653'
    _1_658='1658'
    _1_659='1659'
    _1_660='1660'
    _1_661='1661'
    _1_662='1662'
    _1_663='1663'
    _1_664='1664'
    _1_901='1901'
    _1_902='1902'
    _1_903='1903'
    _1_904='1904'
    _1_905='1905'
    _1_906='1906'
    _1_907='1907'
    _1_908='1908'
    _1_909='1909'
    _1_910='1910'
    _1_911='1911'
    _1_912='1912'
    _1_913='1913'
    _1_914='1914'
    _1_915='1915'
    _1_916='1916'
    _1_917='1917'
    _1_918='1918'
    _1_919='1919'
    _1_920='1920'
    _1_921='1921'
    _1_922='1922'
    _1_923='1923'
    _1_924='1924'
    _1_925='1925'
    _1_926='1926'
    _1_931='1931'
    _1_932='1932'
    _1_933='1933'
    _1_934='1934'
    _1_949='1949'
    _2_101='2101'
    _2_102='2102'
    _2_111='2111'
    _2_113='2113'
    _2_116='2116'
    _2_117='2117'
    _2_118='2118'
    _2_120='2120'
    _2_121='2121'
    _2_122='2122'
    _2_124='2124'
    _2_125='2125'
    _2_126='2126'
    _2_128='2128'
    _2_151='2151'
    _2_152='2152'
    _2_153='2153'
    _2_154='2154'
    _2_201='2201'
    _2_202='2202'
    _2_203='2203'
    _2_204='2204'
    _2_205='2205'
    _2_206='2206'
    _2_207='2207'
    _2_208='2208'
    _2_209='2209'
    _2_251='2251'
    _2_252='2252'
    _2_253='2253'
    _2_254='2254'
    _2_255='2255'
    _2_256='2256'
    _2_257='2257'
    _2_301='2301'
    _2_302='2302'
    _2_303='2303'
    _2_304='2304'
    _2_305='2305'
    _2_306='2306'
    _2_351='2351'
    _2_352='2352'
    _2_353='2353'
    _2_354='2354'
    _2_355='2355'
    _2_356='2356'
    _2_401='2401'
    _2_403='2403'
    _2_406='2406'
    _2_407='2407'
    _2_408='2408'
    _2_409='2409'
    _2_410='2410'
    _2_411='2411'
    _2_414='2414'
    _2_415='2415'
    _2_501='2501'
    _2_503='2503'
    _2_504='2504'
    _2_505='2505'
    _2_506='2506'
    _2_551='2551'
    _2_552='2552'
    _2_553='2553'
    _2_554='2554'
    _2_555='2555'
    _2_556='2556'
    _2_557='2557'
    _2_603='2603'
    _2_651='2651'
    _2_652='2652'
    _2_653='2653'
    _2_658='2658'
    _2_659='2659'
    _2_660='2660'
    _2_661='2661'
    _2_662='2662'
    _2_663='2663'
    _2_664='2664'
    _2_901='2901'
    _2_902='2902'
    _2_903='2903'
    _2_904='2904'
    _2_905='2905'
    _2_906='2906'
    _2_907='2907'
    _2_908='2908'
    _2_909='2909'
    _2_910='2910'
    _2_911='2911'
    _2_912='2912'
    _2_913='2913'
    _2_914='2914'
    _2_915='2915'
    _2_916='2916'
    _2_917='2917'
    _2_918='2918'
    _2_919='2919'
    _2_920='2920'
    _2_921='2921'
    _2_922='2922'
    _2_923='2923'
    _2_924='2924'
    _2_925='2925'
    _2_931='2931'
    _2_932='2932'
    _2_933='2933'
    _2_934='2934'
    _2_949='2949'
    _3_101='3101'
    _3_102='3102'
    _3_126='3126'
    _3_127='3127'
    _3_128='3128'
    _3_201='3201'
    _3_202='3202'
    _3_205='3205'
    _3_206='3206'
    _3_207='3207'
    _3_211='3211'
    _3_251='3251'
    _3_301='3301'
    _3_351='3351'
    _3_352='3352'
    _3_353='3353'
    _3_354='3354'
    _3_355='3355'
    _3_356='3356'
    _3_503='3503'
    _3_551='3551'
    _3_553='3553'
    _3_556='3556'
    _3_651='3651'
    _3_652='3652'
    _3_653='3653'
    _3_930='3930'
    _3_949='3949'
    _5_101='5101'
    _5_102='5102'
    _5_103='5103'
    _5_104='5104'
    _5_105='5105'
    _5_106='5106'
    _5_109='5109'
    _5_110='5110'
    _5_111='5111'
    _5_112='5112'
    _5_113='5113'
    _5_114='5114'
    _5_115='5115'
    _5_116='5116'
    _5_117='5117'
    _5_118='5118'
    _5_119='5119'
    _5_120='5120'
    _5_122='5122'
    _5_123='5123'
    _5_124='5124'
    _5_125='5125'
    _5_151='5151'
    _5_152='5152'
    _5_153='5153'
    _5_155='5155'
    _5_156='5156'
    _5_201='5201'
    _5_202='5202'
    _5_205='5205'
    _5_206='5206'
    _5_207='5207'
    _5_208='5208'
    _5_209='5209'
    _5_210='5210'
    _5_251='5251'
    _5_252='5252'
    _5_253='5253'
    _5_254='5254'
    _5_255='5255'
    _5_256='5256'
    _5_257='5257'
    _5_258='5258'
    _5_401='5401'
    _5_402='5402'
    _5_403='5403'
    _5_405='5405'
    _5_408='5408'
    _5_409='5409'
    _5_410='5410'
    _5_411='5411'
    _5_412='5412'
    _5_413='5413'
    _5_414='5414'
    _5_415='5415'
    _5_451='5451'
    _5_501='5501'
    _5_502='5502'
    _5_503='5503'
    _5_504='5504'
    _5_505='5505'
    _5_551='5551'
    _5_552='5552'
    _5_553='5553'
    _5_554='5554'
    _5_555='5555'
    _5_556='5556'
    _5_557='5557'
    _5_601='5601'
    _5_602='5602'
    _5_603='5603'
    _5_605='5605'
    _5_606='5606'
    _5_651='5651'
    _5_652='5652'
    _5_653='5653'
    _5_654='5654'
    _5_655='5655'
    _5_656='5656'
    _5_657='5657'
    _5_658='5658'
    _5_659='5659'
    _5_660='5660'
    _5_661='5661'
    _5_662='5662'
    _5_663='5663'
    _5_664='5664'
    _5_665='5665'
    _5_666='5666'
    _5_667='5667'
    _5_901='5901'
    _5_902='5902'
    _5_903='5903'
    _5_904='5904'
    _5_905='5905'
    _5_906='5906'
    _5_907='5907'
    _5_908='5908'
    _5_909='5909'
    _5_910='5910'
    _5_911='5911'
    _5_912='5912'
    _5_913='5913'
    _5_914='5914'
    _5_915='5915'
    _5_916='5916'
    _5_917='5917'
    _5_918='5918'
    _5_919='5919'
    _5_920='5920'
    _5_921='5921'
    _5_922='5922'
    _5_923='5923'
    _5_924='5924'
    _5_925='5925'
    _5_926='5926'
    _5_927='5927'
    _5_928='5928'
    _5_929='5929'
    _5_931='5931'
    _5_932='5932'
    _5_933='5933'
    _5_934='5934'
    _5_949='5949'
    _6_101='6101'
    _6_102='6102'
    _6_103='6103'
    _6_104='6104'
    _6_105='6105'
    _6_106='6106'
    _6_107='6107'
    _6_108='6108'
    _6_109='6109'
    _6_110='6110'
    _6_111='6111'
    _6_112='6112'
    _6_113='6113'
    _6_114='6114'
    _6_115='6115'
    _6_116='6116'
    _6_117='6117'
    _6_118='6118'
    _6_119='6119'
    _6_120='6120'
    _6_122='6122'
    _6_123='6123'
    _6_124='6124'
    _6_125='6125'
    _6_151='6151'
    _6_152='6152'
    _6_153='6153'
    _6_155='6155'
    _6_156='6156'
    _6_201='6201'
    _6_202='6202'
    _6_205='6205'
    _6_206='6206'
    _6_207='6207'
    _6_208='6208'
    _6_209='6209'
    _6_210='6210'
    _6_251='6251'
    _6_252='6252'
    _6_253='6253'
    _6_254='6254'
    _6_255='6255'
    _6_256='6256'
    _6_257='6257'
    _6_258='6258'
    _6_401='6401'
    _6_402='6402'
    _6_403='6403'
    _6_404='6404'
    _6_408='6408'
    _6_409='6409'
    _6_410='6410'
    _6_411='6411'
    _6_412='6412'
    _6_413='6413'
    _6_414='6414'
    _6_415='6415'
    _6_501='6501'
    _6_502='6502'
    _6_503='6503'
    _6_504='6504'
    _6_505='6505'
    _6_551='6551'
    _6_552='6552'
    _6_553='6553'
    _6_554='6554'
    _6_555='6555'
    _6_556='6556'
    _6_557='6557'
    _6_603='6603'
    _6_651='6651'
    _6_652='6652'
    _6_653='6653'
    _6_654='6654'
    _6_655='6655'
    _6_656='6656'
    _6_657='6657'
    _6_658='6658'
    _6_659='6659'
    _6_660='6660'
    _6_661='6661'
    _6_662='6662'
    _6_663='6663'
    _6_664='6664'
    _6_665='6665'
    _6_666='6666'
    _6_667='6667'
    _6_901='6901'
    _6_902='6902'
    _6_903='6903'
    _6_904='6904'
    _6_905='6905'
    _6_906='6906'
    _6_907='6907'
    _6_908='6908'
    _6_909='6909'
    _6_910='6910'
    _6_911='6911'
    _6_912='6912'
    _6_913='6913'
    _6_914='6914'
    _6_915='6915'
    _6_916='6916'
    _6_917='6917'
    _6_918='6918'
    _6_919='6919'
    _6_920='6920'
    _6_921='6921'
    _6_922='6922'
    _6_923='6923'
    _6_924='6924'
    _6_925='6925'
    _6_929='6929'
    _6_931='6931'
    _6_932='6932'
    _6_933='6933'
    _6_934='6934'
    _6_949='6949'
    _7_101='7101'
    _7_102='7102'
    _7_105='7105'
    _7_106='7106'
    _7_127='7127'
    _7_201='7201'
    _7_202='7202'
    _7_205='7205'
    _7_206='7206'
    _7_207='7207'
    _7_210='7210'
    _7_211='7211'
    _7_251='7251'
    _7_501='7501'
    _7_551='7551'
    _7_553='7553'
    _7_556='7556'
    _7_651='7651'
    _7_654='7654'
    _7_667='7667'
    _7_930='7930'
    _7_949='7949'


class TCfopTransp(str, Enum):
    """Tipo CFOP - Transportes - uso exclusivo na retenção - 31/05/2010
    Acrescimo dos CFOP de 5931/5932/6931/6932 no CFOP de retTransp"""
    _5_351='5351'
    _5_352='5352'
    _5_353='5353'
    _5_354='5354'
    _5_355='5355'
    _5_356='5356'
    _5_357='5357'
    _5_359='5359'
    _5_360='5360'
    _5_931='5931'
    _5_932='5932'
    _6_351='6351'
    _6_352='6352'
    _6_353='6353'
    _6_354='6354'
    _6_355='6355'
    _6_356='6356'
    _6_357='6357'
    _6_359='6359'
    _6_360='6360'
    _6_931='6931'
    _6_932='6932'
    _7_358='7358'


class TCodUfIBGE(str, Enum):
    """Tipo Código da UF da tabela do IBGE"""
    _1_1='11'
    _1_2='12'
    _1_3='13'
    _1_4='14'
    _1_5='15'
    _1_6='16'
    _1_7='17'
    _2_1='21'
    _2_2='22'
    _2_3='23'
    _2_4='24'
    _2_5='25'
    _2_6='26'
    _2_7='27'
    _2_8='28'
    _2_9='29'
    _3_1='31'
    _3_2='32'
    _3_3='33'
    _3_5='35'
    _4_1='41'
    _4_2='42'
    _4_3='43'
    _5_0='50'
    _5_1='51'
    _5_2='52'
    _5_3='53'


class TFinNFe(str, Enum):
    """Tipo Finalidade da NF-e"""
    _1='1'
    _2='2'
    _3='3'


class TMod(str, Enum):
    """Tipo Modelo Documento Fiscal"""
    _5_5='55'


class TProcEmi(str, Enum):
    """Tipo processo de emissão da NF-e"""
    _0='0'
    _1='1'
    _2='2'
    _3='3'


class TTransformURI(str, Enum):
    HTTPWWWW_3ORG_2000_09XMLDSIGENVELOPEDSIGNATURE='http://www.w3.org/2000/09/xmldsig#enveloped-signature'
    HTTPWWWW_3ORGTR_2001RECXMLC_14_N_20010315='http://www.w3.org/TR/2001/REC-xml-c14n-20010315'


class TUf(str, Enum):
    """Tipo Sigla da UF"""
    AC='AC'
    AL='AL'
    AM='AM'
    AP='AP'
    BA='BA'
    CE='CE'
    DF='DF'
    ES='ES'
    GO='GO'
    MA='MA'
    MG='MG'
    MS='MS'
    MT='MT'
    PA='PA'
    PB='PB'
    PE='PE'
    PI='PI'
    PR='PR'
    RJ='RJ'
    RN='RN'
    RO='RO'
    RR='RR'
    RS='RS'
    SC='SC'
    SE='SE'
    SP='SP'
    TO='TO'
    EX='EX'


class TUfEmi(str, Enum):
    """Tipo Sigla da UF de emissor // acrescentado em 24/10/08"""
    AC='AC'
    AL='AL'
    AM='AM'
    AP='AP'
    BA='BA'
    CE='CE'
    DF='DF'
    ES='ES'
    GO='GO'
    MA='MA'
    MG='MG'
    MS='MS'
    MT='MT'
    PA='PA'
    PB='PB'
    PE='PE'
    PI='PI'
    PR='PR'
    RJ='RJ'
    RN='RN'
    RO='RO'
    RR='RR'
    RS='RS'
    SC='SC'
    SE='SE'
    SP='SP'
    TO='TO'


class TcProdANP(str, Enum):
    """Código de produto da ANP de acordo com o Sistema de Movimentação de
    produtos - SIMP"""
    _1_10203073='110203073'
    _1_10204001='110204001'
    _1_10204002='110204002'
    _1_40101027='140101027'
    _1_40101026='140101026'
    _7_40101005='740101005'
    _7_40101004='740101004'
    _7_40101001='740101001'
    _7_40101006='740101006'
    _7_40101002='740101002'
    _1_10203083='110203083'
    _9_10101001='910101001'
    _1_10103001='110103001'
    _3_30101001='330101001'
    _1_10203091='110203091'
    _1_20204001='120204001'
    _1_10106001='110106001'
    _1_20206001='120206001'
    _1_10101001='110101001'
    _1_10101042='110101042'
    _8_10201001='810201001'
    _1_10204003='110204003'
    _3_30201005='330201005'
    _3_30201006='330201006'
    _3_30201004='330201004'
    _1_10105001='110105001'
    _1_10203072='110203072'
    _1_10203001='110203001'
    _1_10201001='110201001'
    _1_10101002='110101002'
    _1_10203002='110203002'
    _1_20205010='120205010'
    _1_10203003='110203003'
    _1_10204004='110204004'
    _1_10204005='110204005'
    _1_10204006='110204006'
    _1_10204007='110204007'
    _1_10204008='110204008'
    _1_10204009='110204009'
    _1_10204010='110204010'
    _1_10204011='110204011'
    _1_10105027='110105027'
    _1_10103003='110103003'
    _1_10103002='110103002'
    _1_10105002='110105002'
    _1_10205001='110205001'
    _1_20203002='120203002'
    _1_20205001='120205001'
    _1_10203004='110203004'
    _1_20203001='120203001'
    _5_30102001='530102001'
    _5_30101002='530101002'
    _1_10108001='110108001'
    _1_10105017='110105017'
    _1_10206019='110206019'
    _1_10205023='110205023'
    _1_10203092='110203092'
    _1_10201002='110201002'
    _1_20202001='120202001'
    _1_10101003='110101003'
    _1_10101004='110101004'
    _1_10103004='110103004'
    _1_10103005='110103005'
    _1_10101005='110101005'
    _1_10204012='110204012'
    _1_10204013='110204013'
    _1_10204014='110204014'
    _1_10102001='110102001'
    _1_20207003='120207003'
    _1_10201003='110201003'
    _1_10201004='110201004'
    _1_10201005='110201005'
    _1_10201006='110201006'
    _1_10206001='110206001'
    _1_10205002='110205002'
    _1_10203005='110203005'
    _1_10205003='110205003'
    _3_30201001='330201001'
    _1_10206002='110206002'
    _1_10101006='110101006'
    _1_10101007='110101007'
    _1_10101038='110101038'
    _1_20205002='120205002'
    _8_20101001='820101001'
    _8_20101010='820101010'
    _8_20101999='820101999'
    _1_10206003='110206003'
    _1_10201007='110201007'
    _1_20201001='120201001'
    _1_10201008='110201008'
    _1_10103017='110103017'
    _1_10205004='110205004'
    _1_10203077='110203077'
    _1_10101008='110101008'
    _1_10203006='110203006'
    _1_10203007='110203007'
    _1_10201009='110201009'
    _1_10203008='110203008'
    _1_10203009='110203009'
    _1_10203010='110203010'
    _1_20203004='120203004'
    _1_10206004='110206004'
    _6_10101009='610101009'
    _1_20205003='120205003'
    _1_10205005='110205005'
    _1_10203092_1='110203092'
    _1_10204015='110204015'
    _2_10202003='210202003'
    _2_10202001='210202001'
    _2_10202002='210202002'
    _1_10105018='110105018'
    _1_10203011='110203011'
    _1_10203012='110203012'
    _1_10101009='110101009'
    _1_10104001='110104001'
    _1_10104006='110104006'
    _1_10106010='110106010'
    _1_10202007='110202007'
    _1_10106002='110106002'
    _1_10111002='110111002'
    _1_10103006='110103006'
    _1_10105003='110105003'
    _1_10201010='110201010'
    _1_10201011='110201011'
    _1_10201012='110201012'
    _1_10101010='110101010'
    _1_10101011='110101011'
    _1_10108002='110108002'
    _1_10107001='110107001'
    _1_20202002='120202002'
    _1_10106003='110106003'
    _1_10108003='110108003'
    _1_10203085='110203085'
    _1_10201013='110201013'
    _1_10207001='110207001'
    _1_10105023='110105023'
    _1_10101012='110101012'
    _1_10201014='110201014'
    _6_20501002='620501002'
    _6_20501001='620501001'
    _6_10101005='610101005'
    _6_10101006='610101006'
    _5_30101001='530101001'
    _5_30101020='530101020'
    _5_30101018='530101018'
    _1_10205006='110205006'
    _1_10201015='110201015'
    _1_10203013='110203013'
    _1_10202001='110202001'
    _1_20104001='120104001'
    _1_20102001='120102001'
    _1_10205024='110205024'
    _1_20205009='120205009'
    _5_40101002='540101002'
    _5_40101001='540101001'
    _1_10107002='110107002'
    _6_20601003='620601003'
    _1_10201016='110201016'
    _1_10101013='110101013'
    _1_20207001='120207001'
    _1_10206020='110206020'
    _1_10104008='110104008'
    _1_10201017='110201017'
    _1_10108004='110108004'
    _1_10201018='110201018'
    _3_30201007='330201007'
    _1_10205007='110205007'
    _1_10203086='110203086'
    _1_10205008='110205008'
    _3_40101002='340101002'
    _1_30202002='130202002'
    _4_30101002='430101002'
    _1_30202003='130202003'
    _5_60101002='560101002'
    _1_30202004='130202004'
    _8_20101026='820101026'
    _8_20101032='820101032'
    _8_20101027='820101027'
    _8_20101004='820101004'
    _8_20101005='820101005'
    _8_20101022='820101022'
    _8_20101007='820101007'
    _8_20101002='820101002'
    _8_20101009='820101009'
    _8_20101008='820101008'
    _8_20101014='820101014'
    _8_20101006='820101006'
    _8_20101016='820101016'
    _8_20101015='820101015'
    _8_20101014_1='820101014'
    _8_20101006_1='820101006'
    _8_20101031='820101031'
    _8_20101030='820101030'
    _8_20101016_1='820101016'
    _8_20101015_1='820101015'
    _8_20101025='820101025'
    _8_20101007_1='820101007'
    _8_20101002_1='820101002'
    _8_20101026_1='820101026'
    _8_20101009_1='820101009'
    _8_20101008_1='820101008'
    _8_20101027_1='820101027'
    _8_20101007_2='820101007'
    _8_20101002_2='820101002'
    _8_20101028='820101028'
    _8_20101029='820101029'
    _8_20101009_2='820101009'
    _8_20101008_2='820101008'
    _8_20101011='820101011'
    _8_20101003='820101003'
    _8_20101013='820101013'
    _8_20101012='820101012'
    _8_20101017='820101017'
    _8_20101018='820101018'
    _8_20101019='820101019'
    _8_20101020='820101020'
    _8_20101021='820101021'
    _3_30101003='330101003'
    _1_30202006='130202006'
    _1_10203014='110203014'
    _4_20201001='420201001'
    _4_20201003='420201003'
    _1_20204010='120204010'
    _1_10103007='110103007'
    _1_10204017='110204017'
    _1_10204051='110204051'
    _1_10204018='110204018'
    _1_10205022='110205022'
    _1_10203069='110203069'
    _1_10203015='110203015'
    _1_10206005='110206005'
    _1_10203016='110203016'
    _1_10203017='110203017'
    _1_10203018='110203018'
    _1_10203088='110203088'
    _1_10203019='110203019'
    _5_30101003='530101003'
    _5_30101019='530101019'
    _1_10101014='110101014'
    _6_20101002='620101002'
    _7_20101001='720101001'
    _7_20101002='720101002'
    _1_20205004='120205004'
    _1_10203079='110203079'
    _1_10203020='110203020'
    _1_10201019='110201019'
    _1_10203021='110203021'
    _1_10108005='110108005'
    _1_10101015='110101015'
    _1_10104002='110104002'
    _1_10101016='110101016'
    _6_20101007='620101007'
    _1_40102001='140102001'
    _1_10105004='110105004'
    _1_10107003='110107003'
    _1_10203095='110203095'
    _2_10301001='210301001'
    _8_10102001='810102001'
    _8_10102004='810102004'
    _8_10102002='810102002'
    _1_30201002='130201002'
    _8_10102003='810102003'
    _8_10101002='810101002'
    _8_10101001='810101001'
    _8_10101003='810101003'
    _2_10301002='210301002'
    _3_30201010='330201010'
    _1_10204016='110204016'
    _1_10105005='110105005'
    _1_10105006='110105006'
    _1_10105007='110105007'
    _1_10104003='110104003'
    _1_10206006='110206006'
    _1_10206007='110206007'
    _1_10203022='110203022'
    _1_10204019='110204019'
    _1_10206008='110206008'
    _1_10206009='110206009'
    _1_10101043='110101043'
    _1_10201020='110201020'
    _1_10203023='110203023'
    _1_10101017='110101017'
    _1_10101018='110101018'
    _2_10302004='210302004'
    _2_10101001='210101001'
    _2_10302003='210302003'
    _2_10302002='210302002'
    _2_10204001='210204001'
    _2_20101003='220101003'
    _2_20101004='220101004'
    _2_20101002='220101002'
    _2_20101001='220101001'
    _2_20101005='220101005'
    _2_20101006='220101006'
    _1_30202001='130202001'
    _1_30202005='130202005'
    _5_20101001='520101001'
    _3_20101001='320101001'
    _3_20101003='320101003'
    _3_20101002='320101002'
    _3_20103001='320103001'
    _3_20102002='320102002'
    _3_20102001='320102001'
    _3_20102004='320102004'
    _3_20102003='320102003'
    _3_20201001='320201001'
    _3_20201002='320201002'
    _2_20102001='220102001'
    _3_20301002='320301002'
    _1_10204020='110204020'
    _1_10203024='110203024'
    _1_20205012='120205012'
    _1_10207002='110207002'
    _1_10203087='110203087'
    _7_30101002='730101002'
    _2_10203001='210203001'
    _2_10203002='210203002'
    _1_10104005='110104005'
    _1_40101023='140101023'
    _1_40101024='140101024'
    _1_40101025='140101025'
    _6_50101001='650101001'
    _1_10207003='110207003'
    _1_10201021='110201021'
    _1_10103013='110103013'
    _1_10201022='110201022'
    _1_10203025='110203025'
    _1_10203026='110203026'
    _1_10206011='110206011'
    _1_10206010='110206010'
    _1_10203027='110203027'
    _1_10203028='110203028'
    _1_10203028_1='110203028'
    _3_30101008='330101008'
    _3_30101002='330101002'
    _3_30101009='330101009'
    _6_20101001='620101001'
    _6_10201001='610201001'
    _6_10201002='610201002'
    _6_10201003='610201003'
    _7_10101001='710101001'
    _1_10203074='110203074'
    _1_10201023='110201023'
    _1_10103008='110103008'
    _1_10203029='110203029'
    _1_20205005='120205005'
    _1_10204021='110204021'
    _1_10204022='110204022'
    _1_10204023='110204023'
    _6_20101004='620101004'
    _6_20101005='620101005'
    _3_30101010='330101010'
    _1_10202002='110202002'
    _1_10202003='110202003'
    _1_10207004='110207004'
    _1_10101046='110101046'
    _1_10204024='110204024'
    _1_10113001='110113001'
    _1_10105015='110105015'
    _1_10101019='110101019'
    _1_10103015='110103015'
    _1_10205025='110205025'
    _1_10204025='110204025'
    _1_10204026='110204026'
    _1_10204027='110204027'
    _1_20204009='120204009'
    _1_10205026='110205026'
    _1_10204028='110204028'
    _1_10204029='110204029'
    _1_10203080='110203080'
    _1_20207004='120207004'
    _1_10203030='110203030'
    _1_10105025='110105025'
    _1_10203031='110203031'
    _1_10203084='110203084'
    _1_10203032='110203032'
    _1_10204030='110204030'
    _1_10205009='110205009'
    _1_10104004='110104004'
    _1_10201024='110201024'
    _1_10201025='110201025'
    _1_10201026='110201026'
    _1_10201027='110201027'
    _1_10201028='110201028'
    _1_10201029='110201029'
    _1_10201030='110201030'
    _1_10207005='110207005'
    _1_10204031='110204031'
    _1_10207006='110207006'
    _1_10201031='110201031'
    _1_10201032='110201032'
    _1_10201033='110201033'
    _1_20204002='120204002'
    _1_10101020='110101020'
    _2_20102002='220102002'
    _1_10105008='110105008'
    _1_10203033='110203033'
    _1_10105009='110105009'
    _1_10201034='110201034'
    _1_10203034='110203034'
    _1_10203035='110203035'
    _6_40201001='640201001'
    _1_20205011='120205011'
    _1_10101021='110101021'
    _1_20103001='120103001'
    _1_10203036='110203036'
    _1_20204003='120204003'
    _1_10201035='110201035'
    _1_10204032='110204032'
    _1_10101022='110101022'
    _1_10201036='110201036'
    _1_10101023='110101023'
    _1_10101024='110101024'
    _1_10101025='110101025'
    _1_10101039='110101039'
    _1_10204033='110204033'
    _1_20207002='120207002'
    _1_10202004='110202004'
    _1_10202005='110202005'
    _1_10203037='110203037'
    _1_10203037_1='110203037'
    _1_10201037='110201037'
    _1_10203078='110203078'
    _1_20203005='120203005'
    _1_20204010_1='120204010'
    _1_10201038='110201038'
    _1_10201039='110201039'
    _1_20101001='120101001'
    _1_10201040='110201040'
    _1_10201041='110201041'
    _7_40101007='740101007'
    _4_20201003_1='420201003'
    _6_40101001='640101001'
    _1_10205027='110205027'
    _1_10103009='110103009'
    _1_10103010='110103010'
    _1_10205010='110205010'
    _8_20101018_1='820101018'
    _8_20101017_1='820101017'
    _8_20101006_2='820101006'
    _8_20101014_2='820101014'
    _8_20101006_3='820101006'
    _8_20101016_2='820101016'
    _8_20101015_2='820101015'
    _8_20101006_4='820101006'
    _8_20101005_1='820101005'
    _8_20101004_1='820101004'
    _8_20101003_1='820101003'
    _8_20101011_1='820101011'
    _8_20101003_2='820101003'
    _8_20101013_1='820101013'
    _8_20101012_1='820101012'
    _8_20101002_3='820101002'
    _8_20101007_3='820101007'
    _8_20101002_4='820101002'
    _8_20101009_3='820101009'
    _8_20101008_3='820101008'
    _1_10301001='110301001'
    _1_10208001='110208001'
    _1_10203038='110203038'
    _1_10203089='110203089'
    _1_10201042='110201042'
    _1_10101026='110101026'
    _6_20502001='620502001'
    _1_10203039='110203039'
    _1_10202008='110202008'
    _1_10204034='110204034'
    _1_10110001='110110001'
    _3_10102001='310102001'
    _3_10103001='310103001'
    _3_10101001='310101001'
    _1_10101027='110101027'
    _1_10205011='110205011'
    _1_10201062='110201062'
    _1_10203040='110203040'
    _6_10101002='610101002'
    _6_10401002='610401002'
    _6_10101003='610101003'
    _6_10401003='610401003'
    _6_10101004='610101004'
    _6_10401004='610401004'
    _1_10203041='110203041'
    _1_10203042='110203042'
    _1_10203043='110203043'
    _1_10203094='110203094'
    _1_10203044='110203044'
    _1_10203044_1='110203044'
    _4_30101001='430101001'
    _1_10206021='110206021'
    _1_20204004='120204004'
    _1_10207007='110207007'
    _1_10203045='110203045'
    _1_10201043='110201043'
    _1_10203046='110203046'
    _1_10203047='110203047'
    _1_10203048='110203048'
    _1_10203081='110203081'
    _4_30101004='430101004'
    _5_10101003='510101003'
    _5_10101001='510101001'
    _5_10101002='510101002'
    _5_10102003='510102003'
    _5_10102001='510102001'
    _5_10102002='510102002'
    _5_10201001='510201001'
    _5_10201002='510201002'
    _5_10201003='510201003'
    _5_10301003='510301003'
    _1_40101015='140101015'
    _1_40101009='140101009'
    _1_40101016='140101016'
    _1_40101017='140101017'
    _1_40101005='140101005'
    _1_40101014='140101014'
    _1_40101018='140101018'
    _1_40101006='140101006'
    _1_40101028='140101028'
    _1_40101021='140101021'
    _1_40101010='140101010'
    _1_40101012='140101012'
    _1_40101013='140101013'
    _1_40101001='140101001'
    _1_40101011='140101011'
    _1_40101003='140101003'
    _1_40101002='140101002'
    _1_40101008='140101008'
    _1_40101007='140101007'
    _1_40101019='140101019'
    _1_40101004='140101004'
    _5_60101001='560101001'
    _4_20105001='420105001'
    _4_20101005='420101005'
    _4_20101004='420101004'
    _4_20101003='420101003'
    _4_20102006='420102006'
    _4_20102005='420102005'
    _4_20102004='420102004'
    _4_20102003='420102003'
    _4_20104001='420104001'
    _8_20101033='820101033'
    _8_20101034='820101034'
    _8_20101011_2='820101011'
    _8_20101003_3='820101003'
    _8_20101028_1='820101028'
    _8_20101029_1='820101029'
    _8_20101013_2='820101013'
    _8_20101012_2='820101012'
    _4_20301003='420301003'
    _4_20101005_1='420101005'
    _4_20101002='420101002'
    _4_20101001='420101001'
    _4_20101003_1='420101003'
    _4_20101004_1='420101004'
    _4_20101003_2='420101003'
    _4_20201001_1='420201001'
    _4_20201002='420201002'
    _4_20102005_1='420102005'
    _4_20102004_1='420102004'
    _4_20102002='420102002'
    _4_20102001='420102001'
    _4_20102003_1='420102003'
    _4_20102003_2='420102003'
    _4_20202001='420202001'
    _4_20301001='420301001'
    _4_20102006_1='420102006'
    _4_20103002='420103002'
    _4_20103001='420103001'
    _4_20103003='420103003'
    _6_10601001='610601001'
    _6_10701001='610701001'
    _5_10301002='510301002'
    _6_20601001='620601001'
    _6_60101001='660101001'
    _6_20401001='620401001'
    _6_20301001='620301001'
    _6_20201001='620201001'
    _6_30101001='630101001'
    _1_10202006='110202006'
    _1_10203093='110203093'
    _1_10204035='110204035'
    _1_10203049='110203049'
    _1_10201044='110201044'
    _1_10201045='110201045'
    _1_10206012='110206012'
    _1_20203003='120203003'
    _3_20301001='320301001'
    _3_20103002='320103002'
    _6_50101002='650101002'
    _3_10102002='310102002'
    _6_40401001='640401001'
    _1_40101029='140101029'
    _7_40101003='740101003'
    _8_10201002='810201002'
    _5_30103001='530103001'
    _3_40101003='340101003'
    _4_30101003='430101003'
    _5_60101003='560101003'
    _2_10302001='210302001'
    _2_10204002='210204002'
    _1_30201001='130201001'
    _5_30104001='530104001'
    _1_40101022='140101022'
    _1_40101999='140101999'
    _6_10201004='610201004'
    _5_10301001='510301001'
    _4_20301002='420301002'
    _6_20601004='620601004'
    _6_20505001='620505001'
    _6_10501001='610501001'
    _6_20101008='620101008'
    _6_10101010='610101010'
    _1_10208002='110208002'
    _1_10110002='110110002'
    _1_30202008='130202008'
    _4_10103001='410103001'
    _6_10301002='610301002'
    _6_10302001='610302001'
    _3_30101007='330101007'
    _3_30201009='330201009'
    _7_30101001='730101001'
    _1_10203050='110203050'
    _1_10101028='110101028'
    _1_10101049='110101049'
    _1_10101029='110101029'
    _1_10101030='110101030'
    _1_10104007='110104007'
    _1_10111001='110111001'
    _1_20205006='120205006'
    _1_10203051='110203051'
    _1_10101050='110101050'
    _1_10105028='110105028'
    _1_10105016='110105016'
    _1_10201046='110201046'
    _1_10106007='110106007'
    _1_10101031='110101031'
    _1_10203082='110203082'
    _6_10301001='610301001'
    _1_10101032='110101032'
    _1_10101047='110101047'
    _1_10105021='110105021'
    _1_10105010='110105010'
    _6_20101003='620101003'
    _2_10201001='210201001'
    _2_10201002='210201002'
    _2_10201003='210201003'
    _1_10105020='110105020'
    _1_10105022='110105022'
    _1_10205012='110205012'
    _6_20601002='620601002'
    _1_20206003='120206003'
    _1_10204036='110204036'
    _1_10204037='110204037'
    _1_10204038='110204038'
    _4_10101001='410101001'
    _4_10101002='410101002'
    _4_10102001='410102001'
    _4_10102002='410102002'
    _1_10103014='110103014'
    _1_10203052='110203052'
    _3_30101005='330101005'
    _3_30101006='330101006'
    _1_10205029='110205029'
    _1_10203053='110203053'
    _1_20204008='120204008'
    _1_10203054='110203054'
    _1_10204039='110204039'
    _1_10201047='110201047'
    _1_10201048='110201048'
    _1_10103011='110103011'
    _3_40101001='340101001'
    _5_50101001='550101001'
    _5_50101005='550101005'
    _5_50101002='550101002'
    _5_50101003='550101003'
    _5_50101004='550101004'
    _1_30202007='130202007'
    _1_10105011='110105011'
    _1_10201049='110201049'
    _1_10101048='110101048'
    _1_10101033='110101033'
    _1_10101040='110101040'
    _1_10101045='110101045'
    _1_10101041='110101041'
    _1_10204040='110204040'
    _1_10105019='110105019'
    _1_10204041='110204041'
    _1_10105024='110105024'
    _1_10203070='110203070'
    _1_10203055='110203055'
    _1_10204042='110204042'
    _1_10203075='110203075'
    _1_10201050='110201050'
    _1_10201051='110201051'
    _1_10201052='110201052'
    _1_10201053='110201053'
    _1_20201002='120201002'
    _1_10105029='110105029'
    _1_10203056='110203056'
    _1_10204043='110204043'
    _1_10203090='110203090'
    _1_40101020='140101020'
    _1_10103018='110103018'
    _1_10106004='110106004'
    _1_10106005='110106005'
    _1_10106006='110106006'
    _1_10205028='110205028'
    _1_10105012='110105012'
    _1_20204005='120204005'
    _1_10205013='110205013'
    _1_10201054='110201054'
    _1_10101044='110101044'
    _1_10204044='110204044'
    _1_10203057='110203057'
    _1_10203058='110203058'
    _1_20206002='120206002'
    _1_20206004='120206004'
    _3_30201008='330201008'
    _3_30101004='330101004'
    _1_10204045='110204045'
    _1_10204046='110204046'
    _1_10201063='110201063'
    _1_10206013='110206013'
    _1_10203059='110203059'
    _1_10203060='110203060'
    _6_10101001='610101001'
    _6_10401001='610401001'
    _1_10206015='110206015'
    _1_10206014='110206014'
    _1_10204052='110204052'
    _1_10205015='110205015'
    _1_10205014='110205014'
    _1_10204047='110204047'
    _1_10205016='110205016'
    _1_10203061='110203061'
    _1_10205017='110205017'
    _1_10106009='110106009'
    _1_10203062='110203062'
    _1_10206016='110206016'
    _1_20205007='120205007'
    _1_20201003='120201003'
    _6_20101006='620101006'
    _1_20205008='120205008'
    _1_20204006='120204006'
    _1_10201055='110201055'
    _1_10201056='110201056'
    _1_10201057='110201057'
    _1_10103016='110103016'
    _1_10205018='110205018'
    _1_10107005='110107005'
    _3_30201002='330201002'
    _6_20504001='620504001'
    _6_20503001='620503001'
    _1_10101034='110101034'
    _1_10107004='110107004'
    _6_10101007='610101007'
    _6_10101008='610101008'
    _1_10105014='110105014'
    _1_10205019='110205019'
    _1_10103012='110103012'
    _1_10203063='110203063'
    _1_20204007='120204007'
    _1_10204048='110204048'
    _1_10105013='110105013'
    _1_10204049='110204049'
    _1_10206017='110206017'
    _1_10109001='110109001'
    _1_10107006='110107006'
    _1_10201059='110201059'
    _1_10201058='110201058'
    _6_40301001='640301001'
    _1_10101035='110101035'
    _1_10101036='110101036'
    _1_10101037='110101037'
    _1_10205020='110205020'
    _1_20207005='120207005'
    _1_10206018='110206018'
    _1_10108006='110108006'
    _1_10203076='110203076'
    _1_10205021='110205021'
    _3_30201003='330201003'
    _1_30101001='130101001'
    _1_10201060='110201060'
    _1_10203071='110203071'
    _1_10203065='110203065'
    _1_10203064='110203064'
    _1_10204050='110204050'
    _1_10203066='110203066'
    _1_10203067='110203067'
    _1_10201061='110201061'
    _1_10203068='110203068'
    _1_10105026='110105026'
    _1_10106008='110106008'


class Torig(str, Enum):
    """Tipo Origem da mercadoria CST ICMS. origem da mercadoria: 0-Nacional
    1-Estrangeira - Importação direta; 2-Estrangeira - Adquirida no mercado
    interno; 3-Nacional, conteudo superior 40%; 4-Nacional, processos
    produtivos
    básicos; 5-Nacional, conteudo inferior 40%; 6-Estrangeira - Importação
    direta, com similar nacional, lista CAMEX; 7-Estrangeira - mercado
    interno, sem simular,lista CAMEX;8-Nacional, mercadoria ou bem com
    Conteúdo de Importação superior a 70%"""
    _0='0'
    _1='1'
    _2='2'
    _3='3'
    _4='4'
    _5='5'
    _6='6'
    _7='7'
    _8='8'


class Tpais(str, Enum):
    """Tipo Código do Pais
    // PL_005d - 11/08/09
    eliminado:
    4235-LEBUAN, ILHAS -
    acrescentado:
    7200 SAO TOME E PRINCIPE, ILHAS,
    8958 ZONA DO CANAL DO PANAMA
    9903 PROVISAO DE NAVIOS E AERONAVES
    9946 A DESIGNAR
    9950 BANCOS CENTRAIS
    9970 ORGANIZACOES INTERNACIONAIS
    // PL_005b - 24/10/08
    // Acrescentado:
    4235 - LEBUAN,ILHAS
    4885 - MAYOTTE (ILHAS FRANCESAS)
    // NT2011/004
    acrescentado a tabela de paises
    //PL_006t - 21/03/2014
    acrescentado:
    5780 - Palestina
    7600 - Sudão do Sul"""
    _1_32='132'
    _1_75='175'
    _2_30='230'
    _3_10='310'
    _3_70='370'
    _4_00='400'
    _4_18='418'
    _4_34='434'
    _4_77='477'
    _5_31='531'
    _5_90='590'
    _6_39='639'
    _6_47='647'
    _6_55='655'
    _6_98='698'
    _7_28='728'
    _7_36='736'
    _7_79='779'
    _8_09='809'
    _8_17='817'
    _8_33='833'
    _8_50='850'
    _8_76='876'
    _8_84='884'
    _9_06='906'
    _9_30='930'
    _9_73='973'
    _9_81='981'
    _0_132='0132'
    _0_175='0175'
    _0_230='0230'
    _0_310='0310'
    _0_370='0370'
    _0_400='0400'
    _0_418='0418'
    _0_434='0434'
    _0_477='0477'
    _0_531='0531'
    _0_590='0590'
    _0_639='0639'
    _0_647='0647'
    _0_655='0655'
    _0_698='0698'
    _0_728='0728'
    _0_736='0736'
    _0_779='0779'
    _0_809='0809'
    _0_817='0817'
    _0_833='0833'
    _0_850='0850'
    _0_876='0876'
    _0_884='0884'
    _0_906='0906'
    _0_930='0930'
    _0_973='0973'
    _0_981='0981'
    _1_015='1015'
    _1_058='1058'
    _1_082='1082'
    _1_112='1112'
    _1_155='1155'
    _1_198='1198'
    _1_279='1279'
    _1_376='1376'
    _1_414='1414'
    _1_457='1457'
    _1_490='1490'
    _1_504='1504'
    _1_508='1508'
    _1_511='1511'
    _1_538='1538'
    _1_546='1546'
    _1_589='1589'
    _1_600='1600'
    _1_619='1619'
    _1_635='1635'
    _1_651='1651'
    _1_694='1694'
    _1_732='1732'
    _1_775='1775'
    _1_830='1830'
    _1_872='1872'
    _1_902='1902'
    _1_937='1937'
    _1_953='1953'
    _1_961='1961'
    _1_988='1988'
    _1_996='1996'
    _2_291='2291'
    _2_321='2321'
    _2_356='2356'
    _2_399='2399'
    _2_402='2402'
    _2_437='2437'
    _2_445='2445'
    _2_453='2453'
    _2_461='2461'
    _2_470='2470'
    _2_496='2496'
    _2_518='2518'
    _2_534='2534'
    _2_550='2550'
    _2_593='2593'
    _2_674='2674'
    _2_712='2712'
    _2_755='2755'
    _2_810='2810'
    _2_852='2852'
    _2_895='2895'
    _2_917='2917'
    _2_933='2933'
    _2_976='2976'
    _3_018='3018'
    _3_050='3050'
    _3_093='3093'
    _3_131='3131'
    _3_174='3174'
    _3_255='3255'
    _3_298='3298'
    _3_310='3310'
    _3_344='3344'
    _3_379='3379'
    _3_417='3417'
    _3_450='3450'
    _3_514='3514'
    _3_557='3557'
    _3_573='3573'
    _3_595='3595'
    _3_611='3611'
    _3_654='3654'
    _3_697='3697'
    _3_727='3727'
    _3_751='3751'
    _3_794='3794'
    _3_832='3832'
    _3_867='3867'
    _3_913='3913'
    _3_964='3964'
    _3_999='3999'
    _4_030='4030'
    _4_111='4111'
    _4_200='4200'
    _4_235='4235'
    _4_260='4260'
    _4_278='4278'
    _4_316='4316'
    _4_340='4340'
    _4_383='4383'
    _4_405='4405'
    _4_421='4421'
    _4_456='4456'
    _4_472='4472'
    _4_499='4499'
    _4_502='4502'
    _4_525='4525'
    _4_553='4553'
    _4_588='4588'
    _4_618='4618'
    _4_642='4642'
    _4_677='4677'
    _4_723='4723'
    _4_740='4740'
    _4_766='4766'
    _4_774='4774'
    _4_855='4855'
    _4_880='4880'
    _4_885='4885'
    _4_901='4901'
    _4_936='4936'
    _4_944='4944'
    _4_952='4952'
    _4_979='4979'
    _4_985='4985'
    _4_995='4995'
    _5_010='5010'
    _5_053='5053'
    _5_070='5070'
    _5_088='5088'
    _5_118='5118'
    _5_177='5177'
    _5_215='5215'
    _5_258='5258'
    _5_282='5282'
    _5_312='5312'
    _5_355='5355'
    _5_380='5380'
    _5_428='5428'
    _5_452='5452'
    _5_487='5487'
    _5_517='5517'
    _5_568='5568'
    _5_665='5665'
    _5_738='5738'
    _5_754='5754'
    _5_762='5762'
    _5_780='5780'
    _5_800='5800'
    _5_860='5860'
    _5_894='5894'
    _5_932='5932'
    _5_991='5991'
    _6_033='6033'
    _6_076='6076'
    _6_114='6114'
    _6_238='6238'
    _6_254='6254'
    _6_289='6289'
    _6_408='6408'
    _6_475='6475'
    _6_602='6602'
    _6_653='6653'
    _6_700='6700'
    _6_750='6750'
    _6_769='6769'
    _6_777='6777'
    _6_781='6781'
    _6_858='6858'
    _6_874='6874'
    _6_904='6904'
    _6_912='6912'
    _6_955='6955'
    _6_971='6971'
    _7_005='7005'
    _7_056='7056'
    _7_102='7102'
    _7_153='7153'
    _7_200='7200'
    _7_285='7285'
    _7_315='7315'
    _7_358='7358'
    _7_370='7370'
    _7_412='7412'
    _7_447='7447'
    _7_480='7480'
    _7_501='7501'
    _7_544='7544'
    _7_560='7560'
    _7_595='7595'
    _7_600='7600'
    _7_641='7641'
    _7_676='7676'
    _7_706='7706'
    _7_722='7722'
    _7_765='7765'
    _7_803='7803'
    _7_820='7820'
    _7_838='7838'
    _7_889='7889'
    _7_919='7919'
    _7_951='7951'
    _8_001='8001'
    _8_052='8052'
    _8_109='8109'
    _8_150='8150'
    _8_206='8206'
    _8_230='8230'
    _8_249='8249'
    _8_273='8273'
    _8_281='8281'
    _8_311='8311'
    _8_338='8338'
    _8_451='8451'
    _8_478='8478'
    _8_486='8486'
    _8_508='8508'
    _8_583='8583'
    _8_630='8630'
    _8_664='8664'
    _8_702='8702'
    _8_737='8737'
    _8_885='8885'
    _8_907='8907'
    _8_958='8958'
    _9_903='9903'
    _9_946='9946'
    _9_950='9950'
    _9_970='9970'


class VINType(str, Enum):
    """Informa-se o veículo tem VIN (chassi) remarcado.
    R-Remarcado
    N-NormalVIN"""
    R='R'
    N='N'


class cPaisType(str, Enum):
    """Código do país"""
    _1_058='1058'


class cSitTribType(str, Enum):
    """Informar o código da tributação do ISSQN:
    N – NORMAL;
    R – RETIDA;
    S –SUBSTITUTA;
    I – ISENTA. (v.2.0)"""
    N='N'
    R='R'
    S='S'
    I='I'


class condVeicType(str, Enum):
    """Condição do veículo (1 - acabado; 2 - inacabado; 3 - semi-acabado)"""
    _1='1'
    _2='2'
    _3='3'


class indPagType(str, Enum):
    """Indicador da forma de pagamento:
    0 – pagamento à vista;
    1 – pagamento à prazo;
    2 – outros."""
    _0='0'
    _1='1'
    _2='2'


class indProcType(str, Enum):
    """Origem do processo, informar com:
    0 - SEFAZ;
    1 - Justiça Federal;
    2 - Justiça Estadual;
    3 - Secex/RFB;
    9 - Outros"""
    _0='0'
    _1='1'
    _2='2'
    _3='3'
    _9='9'


class indTotType(str, Enum):
    """Este campo deverá ser preenchido com:
    0 – o valor do item (vProd) não compõe o valor total da NF-e (vProd)
    1 – o valor do item (vProd) compõe o valor total da NF-e (vProd)
    (v2.0)"""
    _0='0'
    _1='1'


class modBCSTType(str, Enum):
    """Modalidade de determinação da BC do ICMS ST:
    0 – Preço tabelado ou máximo sugerido;
    1 - Lista Negativa (valor);
    2 - Lista Positiva (valor);
    3 - Lista Neutra (valor);
    4 - Margem Valor Agregado (%);
    5 - Pauta (valor);"""
    _0='0'
    _1='1'
    _2='2'
    _3='3'
    _4='4'
    _5='5'


class modBCSTType11(str, Enum):
    """Modalidade de determinação da BC do ICMS ST:
    0 – Preço tabelado ou máximo sugerido;
    1 - Lista Negativa (valor);
    2 - Lista Positiva (valor);
    3 - Lista Neutra (valor);
    4 - Margem Valor Agregado (%);
    5 - Pauta (valor)."""
    _0='0'
    _1='1'
    _2='2'
    _3='3'
    _4='4'
    _5='5'


class modBCSTType18(str, Enum):
    """Modalidade de determinação da BC do ICMS ST:
    0 – Preço tabelado ou máximo sugerido;
    1 - Lista Negativa (valor);
    2 - Lista Positiva (valor);
    3 - Lista Neutra (valor);
    4 - Margem Valor Agregado (%);
    5 - Pauta (valor)."""
    _0='0'
    _1='1'
    _2='2'
    _3='3'
    _4='4'
    _5='5'


class modBCSTType21(str, Enum):
    """Modalidade de determinação da BC do ICMS ST:
    0 – Preço tabelado ou máximo sugerido;
    1 - Lista Negativa (valor);
    2 - Lista Positiva (valor);
    3 - Lista Neutra (valor);
    4 - Margem Valor Agregado (%);
    5 - Pauta (valor)."""
    _0='0'
    _1='1'
    _2='2'
    _3='3'
    _4='4'
    _5='5'


class modBCSTType24(str, Enum):
    """Modalidade de determinação da BC do ICMS ST:
    0 – Preço tabelado ou máximo sugerido;
    1 - Lista Negativa (valor);
    2 - Lista Positiva (valor);
    3 - Lista Neutra (valor);
    4 - Margem Valor Agregado (%);
    5 - Pauta (valor). (v2.0)"""
    _0='0'
    _1='1'
    _2='2'
    _3='3'
    _4='4'
    _5='5'


class modBCSTType28(str, Enum):
    """Modalidade de determinação da BC do ICMS ST:
    0 – Preço tabelado ou máximo sugerido;
    1 - Lista Negativa (valor);
    2 - Lista Positiva (valor);
    3 - Lista Neutra (valor);
    4 - Margem Valor Agregado (%);
    5 - Pauta (valor). (v2.0)"""
    _0='0'
    _1='1'
    _2='2'
    _3='3'
    _4='4'
    _5='5'


class modBCSTType30(str, Enum):
    """Modalidade de determinação da BC do ICMS ST:
    0 – Preço tabelado ou máximo sugerido;
    1 - Lista Negativa (valor);
    2 - Lista Positiva (valor);
    3 - Lista Neutra (valor);
    4 - Margem Valor Agregado (%);
    5 - Pauta (valor). (v2.0)"""
    _0='0'
    _1='1'
    _2='2'
    _3='3'
    _4='4'
    _5='5'


class modBCSTType34(str, Enum):
    """Modalidade de determinação da BC do ICMS ST:
    0 – Preço tabelado ou máximo sugerido;
    1 - Lista Negativa (valor);
    2 - Lista Positiva (valor);
    3 - Lista Neutra (valor);
    4 - Margem Valor Agregado (%);
    5 - Pauta (valor)."""
    _0='0'
    _1='1'
    _2='2'
    _3='3'
    _4='4'
    _5='5'


class modBCType(str, Enum):
    """Modalidade de determinação da BC do ICMS:
    0 - Margem Valor Agregado (%);
    1 - Pauta (valor);
    2 - Preço Tabelado Máximo (valor);
    3 - Valor da Operação."""
    _0='0'
    _1='1'
    _2='2'
    _3='3'


class modBCType14(str, Enum):
    """Modalidade de determinação da BC do ICMS:
    0 - Margem Valor Agregado (%);
    1 - Pauta (valor);
    2 - Preço Tabelado Máximo (valor);
    3 - Valor da Operação."""
    _0='0'
    _1='1'
    _2='2'
    _3='3'


class modBCType17(str, Enum):
    """Modalidade de determinação da BC do ICMS:
    0 - Margem Valor Agregado (%);
    1 - Pauta (valor);
    2 - Preço Tabelado Máximo (valor);
    3 - Valor da Operação."""
    _0='0'
    _1='1'
    _2='2'
    _3='3'


class modBCType20(str, Enum):
    """Modalidade de determinação da BC do ICMS:
    0 - Margem Valor Agregado (%);
    1 - Pauta (valor);
    2 - Preço Tabelado Máximo (valor);
    3 - Valor da Operação."""
    _0='0'
    _1='1'
    _2='2'
    _3='3'


class modBCType23(str, Enum):
    """Modalidade de determinação da BC do ICMS:
    0 - Margem Valor Agregado (%);
    1 - Pauta (valor);
    2 - Preço Tabelado Máximo (valor);
    3 - Valor da Operação. (v2.0)"""
    _0='0'
    _1='1'
    _2='2'
    _3='3'


class modBCType33(str, Enum):
    """Modalidade de determinação da BC do ICMS:
    0 - Margem Valor Agregado (%);
    1 - Pauta (valor);
    2 - Preço Tabelado Máximo (valor);
    3 - Valor da Operação."""
    _0='0'
    _1='1'
    _2='2'
    _3='3'


class modBCType7(str, Enum):
    """Modalidade de determinação da BC do ICMS:
    0 - Margem Valor Agregado (%);
    1 - Pauta (valor);
    2 - Preço Tabelado Máximo (valor);
    3 - Valor da Operação."""
    _0='0'
    _1='1'
    _2='2'
    _3='3'


class modBCType9(str, Enum):
    """Modalidade de determinação da BC do ICMS:
    0 - Margem Valor Agregado (%);
    1 - Pauta (valor);
    2 - Preço Tabelado Máximo (valor);
    3 - Valor da Operação."""
    _0='0'
    _1='1'
    _2='2'
    _3='3'


class modFreteType(str, Enum):
    """Modalidade do frete
    0- Por conta do emitente;
    1- Por conta do destinatário/remetente;
    2- Por conta de terceiros;
    9- Sem frete (v2.0)"""
    _0='0'
    _1='1'
    _2='2'
    _9='9'


class modType(str, Enum):
    """Código do modelo do Documento Fiscal. Utilizar 01 para NF modelo 1/1A"""
    _0_1='01'


class modType2(str, Enum):
    """Código do modelo do Documento Fiscal - utilizar 04 para NF de produtor
    ou 01 para NF Avulsa(v2.0)"""
    _0_1='01'
    _0_4='04'


class modType3(str, Enum):
    """Código do modelo do Documento Fiscal
    Preencher com "2B", quando se tratar de Cupom Fiscal emitido por máquina
    registradora (não ECF), com "2C", quando se tratar de Cupom Fiscal PDV,
    ou "2D", quando se tratar de Cupom Fiscal (emitido por ECF) (v2.0)."""
    _2_B='2B'
    _2_C='2C'
    _2_D='2D'


class motDesICMSType(str, Enum):
    """Este campo será preenchido quando o campo anterior estiver preenchido.
    Informar o motivo da desoneração:
    1 – Táxi;
    2 – Deficiente Físico;
    3 – Produtor Agropecuário;
    4 – Frotista/Locadora;
    5 – Diplomático/Consular;
    6 – Utilitários e Motocicletas da Amazônia Ocidental e Áreas de Livre
    Comércio (Resolução 714/88 e 790/94 – CONTRAN e suas alterações);
    7 – SUFRAMA;
    8 - Venda a órgão Público;
    9 – outros. (v2.0)"""
    _1='1'
    _2='2'
    _3='3'
    _4='4'
    _5='5'
    _6='6'
    _7='7'
    _8='8'
    _9='9'


class tpArmaType(str, Enum):
    """Indicador do tipo de arma de fogo (0 - Uso permitido; 1 - Uso
    restrito)"""
    _0='0'
    _1='1'


class tpEmisType(str, Enum):
    """Forma de emissão da NF-e
    1 - Normal;
    2 - Contingência FS
    3 - Contingência SCAN
    4 - Contingência DPEC
    5 - Contingência FSDA
    6 - Contingência SVC - AN
    7 - Contingência SVC - RS"""
    _1='1'
    _2='2'
    _3='3'
    _4='4'
    _5='5'
    _6='6'
    _7='7'


class tpImpType(str, Enum):
    """Formato de impressão do DANFE (1 - Retrato; 2 - Paisagem)"""
    _1='1'
    _2='2'


class tpNFType(str, Enum):
    """Tipo do Documento Fiscal (0 - entrada; 1 - saída)"""
    _0='0'
    _1='1'


class tpOpType(str, Enum):
    """Tipo da Operação (1 - Venda concessionária; 2 - Faturamento direto; 3 -
    Venda direta; 0 - Outros)"""
    _0='0'
    _1='1'
    _2='2'
    _3='3'


class tpRestType(str, Enum):
    """Restrição
    0 - Não há;
    1 - Alienação Fiduciária;
    2 - Arrendamento Mercantil;
    3 - Reserva de Domínio;
    4 - Penhor de Veículos;
    9 - outras. (v2.0)"""
    _0='0'
    _1='1'
    _2='2'
    _3='3'
    _4='4'
    _9='9'


class xPaisType57(str, Enum):
    """Nome do país"""
    BRASIL='Brasil'
    BRASIL_1='BRASIL'


class TNFe(GeneratedsSuper):
    """Tipo Nota Fiscal Eletrônica // v2.0"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('infNFe', 'infNFeType', 0, 0, {'name': 'infNFe', 'type': 'infNFeType'}, None),
        MemberSpec_('Signature', 'SignatureType', 0, 0, {'name': 'Signature', 'ref': 'Signature', 'type': 'Signature'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, infNFe=None, Signature=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.infNFe = infNFe
        self.infNFe_nsprefix_ = None
        self.Signature = Signature
        self.Signature_nsprefix_ = "ds"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TNFe)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TNFe.subclass:
            return TNFe.subclass(*args_, **kwargs_)
        else:
            return TNFe(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.infNFe is not None or
            self.Signature is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TNFe', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TNFe')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TNFe':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TNFe')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TNFe', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TNFe'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TNFe', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.infNFe is not None:
            namespaceprefix_ = self.infNFe_nsprefix_ + ':' if (UseCapturedNS_ and self.infNFe_nsprefix_) else ''
            self.infNFe.export(outfile, level, namespaceprefix_, namespacedef_='', name_='infNFe', pretty_print=pretty_print)
        if self.Signature is not None:
            namespaceprefix_ = self.Signature_nsprefix_ + ':' if (UseCapturedNS_ and self.Signature_nsprefix_) else ''
            self.Signature.export(outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='Signature', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'infNFe':
            obj_ = infNFeType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.infNFe = obj_
            obj_.original_tagname_ = 'infNFe'
        elif nodeName_ == 'Signature':
            obj_ = SignatureType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Signature = obj_
            obj_.original_tagname_ = 'Signature'
# end class TNFe


class TProtNFe(GeneratedsSuper):
    """Tipo Protocolo de status resultado do processamento da NF-e"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('versao', 'TVerNFe', 0, 0, {'use': 'required'}),
        MemberSpec_('infProt', 'infProtType', 0, 0, {'name': 'infProt', 'type': 'infProtType'}, None),
        MemberSpec_('Signature', 'SignatureType', 0, 1, {'minOccurs': '0', 'name': 'Signature', 'ref': 'Signature', 'type': 'Signature'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, versao=None, infProt=None, Signature=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.versao = _cast(None, versao)
        self.versao_nsprefix_ = None
        self.infProt = infProt
        self.infProt_nsprefix_ = None
        self.Signature = Signature
        self.Signature_nsprefix_ = "ds"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TProtNFe)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TProtNFe.subclass:
            return TProtNFe.subclass(*args_, **kwargs_)
        else:
            return TProtNFe(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TVerNFe(self, value):
        # Validate type TVerNFe, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TVerNFe_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TVerNFe_patterns_, ))
    validate_TVerNFe_patterns_ = [['^(2\\.00)$']]
    def hasContent_(self):
        if (
            self.infProt is not None or
            self.Signature is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TProtNFe', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TProtNFe')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TProtNFe':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TProtNFe')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TProtNFe', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TProtNFe'):
        if self.versao is not None and 'versao' not in already_processed:
            already_processed.add('versao')
            outfile.write(' versao=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.versao), input_name='versao')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TProtNFe', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.infProt is not None:
            namespaceprefix_ = self.infProt_nsprefix_ + ':' if (UseCapturedNS_ and self.infProt_nsprefix_) else ''
            self.infProt.export(outfile, level, namespaceprefix_, namespacedef_='', name_='infProt', pretty_print=pretty_print)
        if self.Signature is not None:
            namespaceprefix_ = self.Signature_nsprefix_ + ':' if (UseCapturedNS_ and self.Signature_nsprefix_) else ''
            self.Signature.export(outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='Signature', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('versao', node)
        if value is not None and 'versao' not in already_processed:
            already_processed.add('versao')
            self.versao = value
            self.validate_TVerNFe(self.versao)    # validate type TVerNFe
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'infProt':
            obj_ = infProtType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.infProt = obj_
            obj_.original_tagname_ = 'infProt'
        elif nodeName_ == 'Signature':
            obj_ = SignatureType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Signature = obj_
            obj_.original_tagname_ = 'Signature'
# end class TProtNFe


class TEnviNFe(GeneratedsSuper):
    """Tipo Pedido de Concessão de Autorização da Nota Fiscal Eletrônica"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('versao', 'TVerNFe', 0, 0, {'use': 'required'}),
        MemberSpec_('idLote', ['TIdLote', 'xs:string'], 0, 0, {'name': 'idLote', 'type': 'xs:string'}, None),
        MemberSpec_('NFe', 'TNFe', 1, 0, {'maxOccurs': '50', 'name': 'NFe', 'type': 'TNFe'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, versao=None, idLote=None, NFe=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.versao = _cast(None, versao)
        self.versao_nsprefix_ = None
        self.idLote = idLote
        self.validate_TIdLote(self.idLote)
        self.idLote_nsprefix_ = None
        if NFe is None:
            self.NFe = []
        else:
            self.NFe = NFe
        self.NFe_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TEnviNFe)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TEnviNFe.subclass:
            return TEnviNFe.subclass(*args_, **kwargs_)
        else:
            return TEnviNFe(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TIdLote(self, value):
        result = True
        # Validate type TIdLote, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TIdLote_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TIdLote_patterns_, ))
                result = False
        return result
    validate_TIdLote_patterns_ = [['^([0-9]{1,15})$']]
    def validate_TVerNFe(self, value):
        # Validate type TVerNFe, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TVerNFe_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TVerNFe_patterns_, ))
    validate_TVerNFe_patterns_ = [['^(2\\.00)$']]
    def hasContent_(self):
        if (
            self.idLote is not None or
            self.NFe
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TEnviNFe', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TEnviNFe')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TEnviNFe':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TEnviNFe')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TEnviNFe', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TEnviNFe'):
        if self.versao is not None and 'versao' not in already_processed:
            already_processed.add('versao')
            outfile.write(' versao=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.versao), input_name='versao')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TEnviNFe', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.idLote is not None:
            namespaceprefix_ = self.idLote_nsprefix_ + ':' if (UseCapturedNS_ and self.idLote_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sidLote>%s</%sidLote>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.idLote), input_name='idLote')), namespaceprefix_ , eol_))
        for NFe_ in self.NFe:
            namespaceprefix_ = self.NFe_nsprefix_ + ':' if (UseCapturedNS_ and self.NFe_nsprefix_) else ''
            NFe_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='NFe', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('versao', node)
        if value is not None and 'versao' not in already_processed:
            already_processed.add('versao')
            self.versao = value
            self.validate_TVerNFe(self.versao)    # validate type TVerNFe
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'idLote':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'idLote')
            value_ = self.gds_validate_string(value_, node, 'idLote')
            self.idLote = value_
            self.idLote_nsprefix_ = child_.prefix
            # validate type TIdLote
            self.validate_TIdLote(self.idLote)
        elif nodeName_ == 'NFe':
            obj_ = TNFe.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.NFe.append(obj_)
            obj_.original_tagname_ = 'NFe'
# end class TEnviNFe


class TRetEnviNFe(GeneratedsSuper):
    """Tipo Retorno do Pedido de Concessão de Autorização da Nota Fiscal
    Eletrônica"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('versao', 'TVerNFe', 0, 0, {'use': 'required'}),
        MemberSpec_('tpAmb', ['TAmb', 'xs:string'], 0, 0, {'name': 'tpAmb', 'type': 'xs:string'}, None),
        MemberSpec_('verAplic', ['TVerAplic', 'nfe:TString'], 0, 0, {'name': 'verAplic', 'type': 'xs:string'}, None),
        MemberSpec_('cStat', ['TStat', 'xs:string'], 0, 0, {'name': 'cStat', 'type': 'xs:string'}, None),
        MemberSpec_('xMotivo', ['TMotivo', 'nfe:TString'], 0, 0, {'name': 'xMotivo', 'type': 'xs:string'}, None),
        MemberSpec_('cUF', ['TCodUfIBGE', 'xs:string'], 0, 0, {'name': 'cUF', 'type': 'xs:string'}, None),
        MemberSpec_('dhRecbto', 'xs:dateTime', 0, 0, {'name': 'dhRecbto', 'type': 'xs:dateTime'}, None),
        MemberSpec_('infRec', 'infRecType', 0, 1, {'minOccurs': '0', 'name': 'infRec', 'type': 'infRecType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, versao=None, tpAmb=None, verAplic=None, cStat=None, xMotivo=None, cUF=None, dhRecbto=None, infRec=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.versao = _cast(None, versao)
        self.versao_nsprefix_ = None
        self.tpAmb = tpAmb
        self.validate_TAmb(self.tpAmb)
        self.tpAmb_nsprefix_ = None
        self.verAplic = verAplic
        self.validate_TVerAplic(self.verAplic)
        self.verAplic_nsprefix_ = None
        self.cStat = cStat
        self.validate_TStat(self.cStat)
        self.cStat_nsprefix_ = None
        self.xMotivo = xMotivo
        self.validate_TMotivo(self.xMotivo)
        self.xMotivo_nsprefix_ = None
        self.cUF = cUF
        self.validate_TCodUfIBGE(self.cUF)
        self.cUF_nsprefix_ = None
        if isinstance(dhRecbto, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(dhRecbto, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = dhRecbto
        self.dhRecbto = initvalue_
        self.dhRecbto_nsprefix_ = None
        self.infRec = infRec
        self.infRec_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TRetEnviNFe)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TRetEnviNFe.subclass:
            return TRetEnviNFe.subclass(*args_, **kwargs_)
        else:
            return TRetEnviNFe(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TAmb(self, value):
        result = True
        # Validate type TAmb, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['1', '2']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TAmb' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TVerAplic(self, value):
        result = True
        # Validate type TVerAplic, a restriction on nfe:TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 20:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TVerAplic' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on TVerAplic' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TVerAplic_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TVerAplic_patterns_, ))
                result = False
        return result
    validate_TVerAplic_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TStat(self, value):
        result = True
        # Validate type TStat, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TStat_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TStat_patterns_, ))
                result = False
        return result
    validate_TStat_patterns_ = [['^([0-9]{3})$']]
    def validate_TMotivo(self, value):
        result = True
        # Validate type TMotivo, a restriction on nfe:TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 255:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TMotivo' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on TMotivo' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TMotivo_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TMotivo_patterns_, ))
                result = False
        return result
    validate_TMotivo_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TCodUfIBGE(self, value):
        result = True
        # Validate type TCodUfIBGE, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['11', '12', '13', '14', '15', '16', '17', '21', '22', '23', '24', '25', '26', '27', '28', '29', '31', '32', '33', '35', '41', '42', '43', '50', '51', '52', '53']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TCodUfIBGE' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TVerNFe(self, value):
        # Validate type TVerNFe, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TVerNFe_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TVerNFe_patterns_, ))
    validate_TVerNFe_patterns_ = [['^(2\\.00)$']]
    def hasContent_(self):
        if (
            self.tpAmb is not None or
            self.verAplic is not None or
            self.cStat is not None or
            self.xMotivo is not None or
            self.cUF is not None or
            self.dhRecbto is not None or
            self.infRec is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TRetEnviNFe', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TRetEnviNFe')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TRetEnviNFe':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TRetEnviNFe')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TRetEnviNFe', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TRetEnviNFe'):
        if self.versao is not None and 'versao' not in already_processed:
            already_processed.add('versao')
            outfile.write(' versao=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.versao), input_name='versao')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TRetEnviNFe', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.tpAmb is not None:
            namespaceprefix_ = self.tpAmb_nsprefix_ + ':' if (UseCapturedNS_ and self.tpAmb_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stpAmb>%s</%stpAmb>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tpAmb), input_name='tpAmb')), namespaceprefix_ , eol_))
        if self.verAplic is not None:
            namespaceprefix_ = self.verAplic_nsprefix_ + ':' if (UseCapturedNS_ and self.verAplic_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sverAplic>%s</%sverAplic>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.verAplic), input_name='verAplic')), namespaceprefix_ , eol_))
        if self.cStat is not None:
            namespaceprefix_ = self.cStat_nsprefix_ + ':' if (UseCapturedNS_ and self.cStat_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scStat>%s</%scStat>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cStat), input_name='cStat')), namespaceprefix_ , eol_))
        if self.xMotivo is not None:
            namespaceprefix_ = self.xMotivo_nsprefix_ + ':' if (UseCapturedNS_ and self.xMotivo_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxMotivo>%s</%sxMotivo>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xMotivo), input_name='xMotivo')), namespaceprefix_ , eol_))
        if self.cUF is not None:
            namespaceprefix_ = self.cUF_nsprefix_ + ':' if (UseCapturedNS_ and self.cUF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scUF>%s</%scUF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cUF), input_name='cUF')), namespaceprefix_ , eol_))
        if self.dhRecbto is not None:
            namespaceprefix_ = self.dhRecbto_nsprefix_ + ':' if (UseCapturedNS_ and self.dhRecbto_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdhRecbto>%s</%sdhRecbto>%s' % (namespaceprefix_ , self.gds_format_datetime(self.dhRecbto, input_name='dhRecbto'), namespaceprefix_ , eol_))
        if self.infRec is not None:
            namespaceprefix_ = self.infRec_nsprefix_ + ':' if (UseCapturedNS_ and self.infRec_nsprefix_) else ''
            self.infRec.export(outfile, level, namespaceprefix_, namespacedef_='', name_='infRec', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('versao', node)
        if value is not None and 'versao' not in already_processed:
            already_processed.add('versao')
            self.versao = value
            self.validate_TVerNFe(self.versao)    # validate type TVerNFe
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'tpAmb':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tpAmb')
            value_ = self.gds_validate_string(value_, node, 'tpAmb')
            self.tpAmb = value_
            self.tpAmb_nsprefix_ = child_.prefix
            # validate type TAmb
            self.validate_TAmb(self.tpAmb)
        elif nodeName_ == 'verAplic':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'verAplic')
            value_ = self.gds_validate_string(value_, node, 'verAplic')
            self.verAplic = value_
            self.verAplic_nsprefix_ = child_.prefix
            # validate type TVerAplic
            self.validate_TVerAplic(self.verAplic)
        elif nodeName_ == 'cStat':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cStat')
            value_ = self.gds_validate_string(value_, node, 'cStat')
            self.cStat = value_
            self.cStat_nsprefix_ = child_.prefix
            # validate type TStat
            self.validate_TStat(self.cStat)
        elif nodeName_ == 'xMotivo':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xMotivo')
            value_ = self.gds_validate_string(value_, node, 'xMotivo')
            self.xMotivo = value_
            self.xMotivo_nsprefix_ = child_.prefix
            # validate type TMotivo
            self.validate_TMotivo(self.xMotivo)
        elif nodeName_ == 'cUF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cUF')
            value_ = self.gds_validate_string(value_, node, 'cUF')
            self.cUF = value_
            self.cUF_nsprefix_ = child_.prefix
            # validate type TCodUfIBGE
            self.validate_TCodUfIBGE(self.cUF)
        elif nodeName_ == 'dhRecbto':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.dhRecbto = dval_
            self.dhRecbto_nsprefix_ = child_.prefix
        elif nodeName_ == 'infRec':
            obj_ = infRecType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.infRec = obj_
            obj_.original_tagname_ = 'infRec'
# end class TRetEnviNFe


class TConsReciNFe(GeneratedsSuper):
    """Tipo Pedido de Consulta do Recido do Lote de Notas Fiscais
    Eletrônicas"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('versao', 'TVerNFe', 0, 0, {'use': 'required'}),
        MemberSpec_('tpAmb', ['TAmb', 'xs:string'], 0, 0, {'name': 'tpAmb', 'type': 'xs:string'}, None),
        MemberSpec_('nRec', ['TRec', 'xs:string'], 0, 0, {'name': 'nRec', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, versao=None, tpAmb=None, nRec=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.versao = _cast(None, versao)
        self.versao_nsprefix_ = None
        self.tpAmb = tpAmb
        self.validate_TAmb(self.tpAmb)
        self.tpAmb_nsprefix_ = None
        self.nRec = nRec
        self.validate_TRec(self.nRec)
        self.nRec_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TConsReciNFe)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TConsReciNFe.subclass:
            return TConsReciNFe.subclass(*args_, **kwargs_)
        else:
            return TConsReciNFe(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TAmb(self, value):
        result = True
        # Validate type TAmb, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['1', '2']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TAmb' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TRec(self, value):
        result = True
        # Validate type TRec, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TRec_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TRec_patterns_, ))
                result = False
        return result
    validate_TRec_patterns_ = [['^([0-9]{15})$']]
    def validate_TVerNFe(self, value):
        # Validate type TVerNFe, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TVerNFe_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TVerNFe_patterns_, ))
    validate_TVerNFe_patterns_ = [['^(2\\.00)$']]
    def hasContent_(self):
        if (
            self.tpAmb is not None or
            self.nRec is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TConsReciNFe', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TConsReciNFe')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TConsReciNFe':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TConsReciNFe')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TConsReciNFe', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TConsReciNFe'):
        if self.versao is not None and 'versao' not in already_processed:
            already_processed.add('versao')
            outfile.write(' versao=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.versao), input_name='versao')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TConsReciNFe', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.tpAmb is not None:
            namespaceprefix_ = self.tpAmb_nsprefix_ + ':' if (UseCapturedNS_ and self.tpAmb_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stpAmb>%s</%stpAmb>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tpAmb), input_name='tpAmb')), namespaceprefix_ , eol_))
        if self.nRec is not None:
            namespaceprefix_ = self.nRec_nsprefix_ + ':' if (UseCapturedNS_ and self.nRec_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snRec>%s</%snRec>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nRec), input_name='nRec')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('versao', node)
        if value is not None and 'versao' not in already_processed:
            already_processed.add('versao')
            self.versao = value
            self.validate_TVerNFe(self.versao)    # validate type TVerNFe
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'tpAmb':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tpAmb')
            value_ = self.gds_validate_string(value_, node, 'tpAmb')
            self.tpAmb = value_
            self.tpAmb_nsprefix_ = child_.prefix
            # validate type TAmb
            self.validate_TAmb(self.tpAmb)
        elif nodeName_ == 'nRec':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nRec')
            value_ = self.gds_validate_string(value_, node, 'nRec')
            self.nRec = value_
            self.nRec_nsprefix_ = child_.prefix
            # validate type TRec
            self.validate_TRec(self.nRec)
# end class TConsReciNFe


class TRetConsReciNFe(GeneratedsSuper):
    """Tipo Retorno do Pedido de Consulta do Recido do Lote de Notas Fiscais
    Eletrônicas"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('versao', 'TVerNFe', 0, 0, {'use': 'required'}),
        MemberSpec_('tpAmb', ['TAmb', 'xs:string'], 0, 0, {'name': 'tpAmb', 'type': 'xs:string'}, None),
        MemberSpec_('verAplic', ['TVerAplic', 'nfe:TString'], 0, 0, {'name': 'verAplic', 'type': 'xs:string'}, None),
        MemberSpec_('nRec', ['TRec', 'xs:string'], 0, 0, {'name': 'nRec', 'type': 'xs:string'}, None),
        MemberSpec_('cStat', ['TStat', 'xs:string'], 0, 0, {'name': 'cStat', 'type': 'xs:string'}, None),
        MemberSpec_('xMotivo', ['TMotivo', 'nfe:TString'], 0, 0, {'name': 'xMotivo', 'type': 'xs:string'}, None),
        MemberSpec_('cUF', ['TCodUfIBGE', 'xs:string'], 0, 0, {'name': 'cUF', 'type': 'xs:string'}, None),
        MemberSpec_('cMsg', ['cMsgType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'cMsg', 'type': 'xs:string'}, None),
        MemberSpec_('xMsg', ['xMsgType', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'xMsg', 'type': 'xs:string'}, None),
        MemberSpec_('protNFe', 'TProtNFe', 1, 1, {'maxOccurs': '50', 'minOccurs': '0', 'name': 'protNFe', 'type': 'TProtNFe'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, versao=None, tpAmb=None, verAplic=None, nRec=None, cStat=None, xMotivo=None, cUF=None, cMsg=None, xMsg=None, protNFe=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.versao = _cast(None, versao)
        self.versao_nsprefix_ = None
        self.tpAmb = tpAmb
        self.validate_TAmb(self.tpAmb)
        self.tpAmb_nsprefix_ = None
        self.verAplic = verAplic
        self.validate_TVerAplic(self.verAplic)
        self.verAplic_nsprefix_ = None
        self.nRec = nRec
        self.validate_TRec(self.nRec)
        self.nRec_nsprefix_ = None
        self.cStat = cStat
        self.validate_TStat(self.cStat)
        self.cStat_nsprefix_ = None
        self.xMotivo = xMotivo
        self.validate_TMotivo(self.xMotivo)
        self.xMotivo_nsprefix_ = None
        self.cUF = cUF
        self.validate_TCodUfIBGE(self.cUF)
        self.cUF_nsprefix_ = None
        self.cMsg = cMsg
        self.validate_cMsgType(self.cMsg)
        self.cMsg_nsprefix_ = None
        self.xMsg = xMsg
        self.validate_xMsgType(self.xMsg)
        self.xMsg_nsprefix_ = None
        if protNFe is None:
            self.protNFe = []
        else:
            self.protNFe = protNFe
        self.protNFe_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TRetConsReciNFe)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TRetConsReciNFe.subclass:
            return TRetConsReciNFe.subclass(*args_, **kwargs_)
        else:
            return TRetConsReciNFe(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TAmb(self, value):
        result = True
        # Validate type TAmb, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['1', '2']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TAmb' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TVerAplic(self, value):
        result = True
        # Validate type TVerAplic, a restriction on nfe:TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 20:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TVerAplic' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on TVerAplic' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TVerAplic_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TVerAplic_patterns_, ))
                result = False
        return result
    validate_TVerAplic_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TRec(self, value):
        result = True
        # Validate type TRec, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TRec_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TRec_patterns_, ))
                result = False
        return result
    validate_TRec_patterns_ = [['^([0-9]{15})$']]
    def validate_TStat(self, value):
        result = True
        # Validate type TStat, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TStat_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TStat_patterns_, ))
                result = False
        return result
    validate_TStat_patterns_ = [['^([0-9]{3})$']]
    def validate_TMotivo(self, value):
        result = True
        # Validate type TMotivo, a restriction on nfe:TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 255:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TMotivo' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on TMotivo' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TMotivo_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TMotivo_patterns_, ))
                result = False
        return result
    validate_TMotivo_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TCodUfIBGE(self, value):
        result = True
        # Validate type TCodUfIBGE, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['11', '12', '13', '14', '15', '16', '17', '21', '22', '23', '24', '25', '26', '27', '28', '29', '31', '32', '33', '35', '41', '42', '43', '50', '51', '52', '53']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TCodUfIBGE' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_cMsgType(self, value):
        result = True
        # Validate type cMsgType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_cMsgType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cMsgType_patterns_, ))
                result = False
        return result
    validate_cMsgType_patterns_ = [['^([0-9]{1,4})$']]
    def validate_xMsgType(self, value):
        result = True
        # Validate type xMsgType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 200:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xMsgType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xMsgType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xMsgType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xMsgType_patterns_, ))
                result = False
        return result
    validate_xMsgType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TVerNFe(self, value):
        # Validate type TVerNFe, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TVerNFe_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TVerNFe_patterns_, ))
    validate_TVerNFe_patterns_ = [['^(2\\.00)$']]
    def hasContent_(self):
        if (
            self.tpAmb is not None or
            self.verAplic is not None or
            self.nRec is not None or
            self.cStat is not None or
            self.xMotivo is not None or
            self.cUF is not None or
            self.cMsg is not None or
            self.xMsg is not None or
            self.protNFe
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TRetConsReciNFe', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TRetConsReciNFe')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TRetConsReciNFe':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TRetConsReciNFe')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TRetConsReciNFe', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TRetConsReciNFe'):
        if self.versao is not None and 'versao' not in already_processed:
            already_processed.add('versao')
            outfile.write(' versao=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.versao), input_name='versao')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TRetConsReciNFe', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.tpAmb is not None:
            namespaceprefix_ = self.tpAmb_nsprefix_ + ':' if (UseCapturedNS_ and self.tpAmb_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stpAmb>%s</%stpAmb>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tpAmb), input_name='tpAmb')), namespaceprefix_ , eol_))
        if self.verAplic is not None:
            namespaceprefix_ = self.verAplic_nsprefix_ + ':' if (UseCapturedNS_ and self.verAplic_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sverAplic>%s</%sverAplic>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.verAplic), input_name='verAplic')), namespaceprefix_ , eol_))
        if self.nRec is not None:
            namespaceprefix_ = self.nRec_nsprefix_ + ':' if (UseCapturedNS_ and self.nRec_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snRec>%s</%snRec>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nRec), input_name='nRec')), namespaceprefix_ , eol_))
        if self.cStat is not None:
            namespaceprefix_ = self.cStat_nsprefix_ + ':' if (UseCapturedNS_ and self.cStat_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scStat>%s</%scStat>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cStat), input_name='cStat')), namespaceprefix_ , eol_))
        if self.xMotivo is not None:
            namespaceprefix_ = self.xMotivo_nsprefix_ + ':' if (UseCapturedNS_ and self.xMotivo_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxMotivo>%s</%sxMotivo>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xMotivo), input_name='xMotivo')), namespaceprefix_ , eol_))
        if self.cUF is not None:
            namespaceprefix_ = self.cUF_nsprefix_ + ':' if (UseCapturedNS_ and self.cUF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scUF>%s</%scUF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cUF), input_name='cUF')), namespaceprefix_ , eol_))
        if self.cMsg is not None:
            namespaceprefix_ = self.cMsg_nsprefix_ + ':' if (UseCapturedNS_ and self.cMsg_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scMsg>%s</%scMsg>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cMsg), input_name='cMsg')), namespaceprefix_ , eol_))
        if self.xMsg is not None:
            namespaceprefix_ = self.xMsg_nsprefix_ + ':' if (UseCapturedNS_ and self.xMsg_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxMsg>%s</%sxMsg>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xMsg), input_name='xMsg')), namespaceprefix_ , eol_))
        for protNFe_ in self.protNFe:
            namespaceprefix_ = self.protNFe_nsprefix_ + ':' if (UseCapturedNS_ and self.protNFe_nsprefix_) else ''
            protNFe_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='protNFe', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('versao', node)
        if value is not None and 'versao' not in already_processed:
            already_processed.add('versao')
            self.versao = value
            self.validate_TVerNFe(self.versao)    # validate type TVerNFe
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'tpAmb':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tpAmb')
            value_ = self.gds_validate_string(value_, node, 'tpAmb')
            self.tpAmb = value_
            self.tpAmb_nsprefix_ = child_.prefix
            # validate type TAmb
            self.validate_TAmb(self.tpAmb)
        elif nodeName_ == 'verAplic':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'verAplic')
            value_ = self.gds_validate_string(value_, node, 'verAplic')
            self.verAplic = value_
            self.verAplic_nsprefix_ = child_.prefix
            # validate type TVerAplic
            self.validate_TVerAplic(self.verAplic)
        elif nodeName_ == 'nRec':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nRec')
            value_ = self.gds_validate_string(value_, node, 'nRec')
            self.nRec = value_
            self.nRec_nsprefix_ = child_.prefix
            # validate type TRec
            self.validate_TRec(self.nRec)
        elif nodeName_ == 'cStat':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cStat')
            value_ = self.gds_validate_string(value_, node, 'cStat')
            self.cStat = value_
            self.cStat_nsprefix_ = child_.prefix
            # validate type TStat
            self.validate_TStat(self.cStat)
        elif nodeName_ == 'xMotivo':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xMotivo')
            value_ = self.gds_validate_string(value_, node, 'xMotivo')
            self.xMotivo = value_
            self.xMotivo_nsprefix_ = child_.prefix
            # validate type TMotivo
            self.validate_TMotivo(self.xMotivo)
        elif nodeName_ == 'cUF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cUF')
            value_ = self.gds_validate_string(value_, node, 'cUF')
            self.cUF = value_
            self.cUF_nsprefix_ = child_.prefix
            # validate type TCodUfIBGE
            self.validate_TCodUfIBGE(self.cUF)
        elif nodeName_ == 'cMsg':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cMsg')
            value_ = self.gds_validate_string(value_, node, 'cMsg')
            self.cMsg = value_
            self.cMsg_nsprefix_ = child_.prefix
            # validate type cMsgType
            self.validate_cMsgType(self.cMsg)
        elif nodeName_ == 'xMsg':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xMsg')
            value_ = self.gds_validate_string(value_, node, 'xMsg')
            self.xMsg = value_
            self.xMsg_nsprefix_ = child_.prefix
            # validate type xMsgType
            self.validate_xMsgType(self.xMsg)
        elif nodeName_ == 'protNFe':
            obj_ = TProtNFe.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.protNFe.append(obj_)
            obj_.original_tagname_ = 'protNFe'
# end class TRetConsReciNFe


class TNfeProc(GeneratedsSuper):
    """Tipo da NF-e processada"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('versao', 'TVerNFe', 0, 0, {'use': 'required'}),
        MemberSpec_('NFe', 'TNFe', 0, 0, {'name': 'NFe', 'type': 'TNFe'}, None),
        MemberSpec_('protNFe', 'TProtNFe', 0, 0, {'name': 'protNFe', 'type': 'TProtNFe'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, versao=None, NFe=None, protNFe=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.versao = _cast(None, versao)
        self.versao_nsprefix_ = None
        self.NFe = NFe
        self.NFe_nsprefix_ = None
        self.protNFe = protNFe
        self.protNFe_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TNfeProc)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TNfeProc.subclass:
            return TNfeProc.subclass(*args_, **kwargs_)
        else:
            return TNfeProc(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TVerNFe(self, value):
        # Validate type TVerNFe, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TVerNFe_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TVerNFe_patterns_, ))
    validate_TVerNFe_patterns_ = [['^(2\\.00)$']]
    def hasContent_(self):
        if (
            self.NFe is not None or
            self.protNFe is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TNfeProc', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TNfeProc')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TNfeProc':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TNfeProc')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TNfeProc', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TNfeProc'):
        if self.versao is not None and 'versao' not in already_processed:
            already_processed.add('versao')
            outfile.write(' versao=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.versao), input_name='versao')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TNfeProc', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.NFe is not None:
            namespaceprefix_ = self.NFe_nsprefix_ + ':' if (UseCapturedNS_ and self.NFe_nsprefix_) else ''
            self.NFe.export(outfile, level, namespaceprefix_, namespacedef_='', name_='NFe', pretty_print=pretty_print)
        if self.protNFe is not None:
            namespaceprefix_ = self.protNFe_nsprefix_ + ':' if (UseCapturedNS_ and self.protNFe_nsprefix_) else ''
            self.protNFe.export(outfile, level, namespaceprefix_, namespacedef_='', name_='protNFe', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('versao', node)
        if value is not None and 'versao' not in already_processed:
            already_processed.add('versao')
            self.versao = value
            self.validate_TVerNFe(self.versao)    # validate type TVerNFe
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'NFe':
            obj_ = TNFe.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.NFe = obj_
            obj_.original_tagname_ = 'NFe'
        elif nodeName_ == 'protNFe':
            obj_ = TProtNFe.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.protNFe = obj_
            obj_.original_tagname_ = 'protNFe'
# end class TNfeProc


class TEndereco(GeneratedsSuper):
    """Tipo Dados do Endereço // 24/10/08 - tamanho mínimo"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('xLgr', ['xLgrType', 'TString', 'xs:string'], 0, 0, {'name': 'xLgr', 'type': 'xs:string'}, None),
        MemberSpec_('nro', ['nroType', 'TString', 'xs:string'], 0, 0, {'name': 'nro', 'type': 'xs:string'}, None),
        MemberSpec_('xCpl', ['xCplType', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'xCpl', 'type': 'xs:string'}, None),
        MemberSpec_('xBairro', ['xBairroType', 'TString', 'xs:string'], 0, 0, {'name': 'xBairro', 'type': 'xs:string'}, None),
        MemberSpec_('cMun', ['TCodMunIBGE', 'xs:string'], 0, 0, {'name': 'cMun', 'type': 'xs:string'}, None),
        MemberSpec_('xMun', ['xMunType49', 'TString', 'xs:string'], 0, 0, {'name': 'xMun', 'type': 'xs:string'}, None),
        MemberSpec_('UF', ['TUf', 'xs:string'], 0, 0, {'name': 'UF', 'type': 'xs:string'}, None),
        MemberSpec_('CEP', ['CEPType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'CEP', 'type': 'xs:string'}, None),
        MemberSpec_('cPais', ['Tpais', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'cPais', 'type': 'xs:string'}, None),
        MemberSpec_('xPais', ['xPaisType', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'xPais', 'type': 'xs:string'}, None),
        MemberSpec_('fone', ['foneType50', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'fone', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, xLgr=None, nro=None, xCpl=None, xBairro=None, cMun=None, xMun=None, UF=None, CEP=None, cPais=None, xPais=None, fone=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.xLgr = xLgr
        self.validate_xLgrType(self.xLgr)
        self.xLgr_nsprefix_ = None
        self.nro = nro
        self.validate_nroType(self.nro)
        self.nro_nsprefix_ = None
        self.xCpl = xCpl
        self.validate_xCplType(self.xCpl)
        self.xCpl_nsprefix_ = None
        self.xBairro = xBairro
        self.validate_xBairroType(self.xBairro)
        self.xBairro_nsprefix_ = None
        self.cMun = cMun
        self.validate_TCodMunIBGE(self.cMun)
        self.cMun_nsprefix_ = None
        self.xMun = xMun
        self.validate_xMunType49(self.xMun)
        self.xMun_nsprefix_ = None
        self.UF = UF
        self.validate_TUf(self.UF)
        self.UF_nsprefix_ = None
        self.CEP = CEP
        self.validate_CEPType(self.CEP)
        self.CEP_nsprefix_ = None
        self.cPais = cPais
        self.validate_Tpais(self.cPais)
        self.cPais_nsprefix_ = None
        self.xPais = xPais
        self.validate_xPaisType(self.xPais)
        self.xPais_nsprefix_ = None
        self.fone = fone
        self.validate_foneType50(self.fone)
        self.fone_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TEndereco)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TEndereco.subclass:
            return TEndereco.subclass(*args_, **kwargs_)
        else:
            return TEndereco(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_xLgrType(self, value):
        result = True
        # Validate type xLgrType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xLgrType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xLgrType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xLgrType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xLgrType_patterns_, ))
                result = False
        return result
    validate_xLgrType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_nroType(self, value):
        result = True
        # Validate type nroType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on nroType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nroType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_nroType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nroType_patterns_, ))
                result = False
        return result
    validate_nroType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_xCplType(self, value):
        result = True
        # Validate type xCplType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xCplType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xCplType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xCplType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xCplType_patterns_, ))
                result = False
        return result
    validate_xCplType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_xBairroType(self, value):
        result = True
        # Validate type xBairroType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xBairroType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xBairroType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xBairroType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xBairroType_patterns_, ))
                result = False
        return result
    validate_xBairroType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TCodMunIBGE(self, value):
        result = True
        # Validate type TCodMunIBGE, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCodMunIBGE_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCodMunIBGE_patterns_, ))
                result = False
        return result
    validate_TCodMunIBGE_patterns_ = [['^([0-9]{7})$']]
    def validate_xMunType49(self, value):
        result = True
        # Validate type xMunType49, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xMunType49' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xMunType49' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xMunType49_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xMunType49_patterns_, ))
                result = False
        return result
    validate_xMunType49_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TUf(self, value):
        result = True
        # Validate type TUf, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['AC', 'AL', 'AM', 'AP', 'BA', 'CE', 'DF', 'ES', 'GO', 'MA', 'MG', 'MS', 'MT', 'PA', 'PB', 'PE', 'PI', 'PR', 'RJ', 'RN', 'RO', 'RR', 'RS', 'SC', 'SE', 'SP', 'TO', 'EX']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TUf' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CEPType(self, value):
        result = True
        # Validate type CEPType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_CEPType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_CEPType_patterns_, ))
                result = False
        return result
    validate_CEPType_patterns_ = [['^([0-9]{8})$']]
    def validate_Tpais(self, value):
        result = True
        # Validate type Tpais, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['132', '175', '230', '310', '370', '400', '418', '434', '477', '531', '590', '639', '647', '655', '698', '728', '736', '779', '809', '817', '833', '850', '876', '884', '906', '930', '973', '981', '0132', '0175', '0230', '0310', '0370', '0400', '0418', '0434', '0477', '0531', '0590', '0639', '0647', '0655', '0698', '0728', '0736', '0779', '0809', '0817', '0833', '0850', '0876', '0884', '0906', '0930', '0973', '0981', '1015', '1058', '1082', '1112', '1155', '1198', '1279', '1376', '1414', '1457', '1490', '1504', '1508', '1511', '1538', '1546', '1589', '1600', '1619', '1635', '1651', '1694', '1732', '1775', '1830', '1872', '1902', '1937', '1953', '1961', '1988', '1996', '2291', '2321', '2356', '2399', '2402', '2437', '2445', '2453', '2461', '2470', '2496', '2518', '2534', '2550', '2593', '2674', '2712', '2755', '2810', '2852', '2895', '2917', '2933', '2976', '3018', '3050', '3093', '3131', '3174', '3255', '3298', '3310', '3344', '3379', '3417', '3450', '3514', '3557', '3573', '3595', '3611', '3654', '3697', '3727', '3751', '3794', '3832', '3867', '3913', '3964', '3999', '4030', '4111', '4200', '4235', '4260', '4278', '4316', '4340', '4383', '4405', '4421', '4456', '4472', '4499', '4502', '4525', '4553', '4588', '4618', '4642', '4677', '4723', '4740', '4766', '4774', '4855', '4880', '4885', '4901', '4936', '4944', '4952', '4979', '4985', '4995', '5010', '5053', '5070', '5088', '5118', '5177', '5215', '5258', '5282', '5312', '5355', '5380', '5428', '5452', '5487', '5517', '5568', '5665', '5738', '5754', '5762', '5780', '5800', '5860', '5894', '5932', '5991', '6033', '6076', '6114', '6238', '6254', '6289', '6408', '6475', '6602', '6653', '6700', '6750', '6769', '6777', '6781', '6858', '6874', '6904', '6912', '6955', '6971', '7005', '7056', '7102', '7153', '7200', '7285', '7315', '7358', '7370', '7412', '7447', '7480', '7501', '7544', '7560', '7595', '7600', '7641', '7676', '7706', '7722', '7765', '7803', '7820', '7838', '7889', '7919', '7951', '8001', '8052', '8109', '8150', '8206', '8230', '8249', '8273', '8281', '8311', '8338', '8451', '8478', '8486', '8508', '8583', '8630', '8664', '8702', '8737', '8885', '8907', '8958', '9903', '9946', '9950', '9970']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on Tpais' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_xPaisType(self, value):
        result = True
        # Validate type xPaisType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xPaisType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xPaisType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xPaisType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xPaisType_patterns_, ))
                result = False
        return result
    validate_xPaisType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_foneType50(self, value):
        result = True
        # Validate type foneType50, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_foneType50_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_foneType50_patterns_, ))
                result = False
        return result
    validate_foneType50_patterns_ = [['^([0-9]{6,14})$']]
    def hasContent_(self):
        if (
            self.xLgr is not None or
            self.nro is not None or
            self.xCpl is not None or
            self.xBairro is not None or
            self.cMun is not None or
            self.xMun is not None or
            self.UF is not None or
            self.CEP is not None or
            self.cPais is not None or
            self.xPais is not None or
            self.fone is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TEndereco', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TEndereco')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TEndereco':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TEndereco')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TEndereco', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TEndereco'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TEndereco', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.xLgr is not None:
            namespaceprefix_ = self.xLgr_nsprefix_ + ':' if (UseCapturedNS_ and self.xLgr_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxLgr>%s</%sxLgr>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xLgr), input_name='xLgr')), namespaceprefix_ , eol_))
        if self.nro is not None:
            namespaceprefix_ = self.nro_nsprefix_ + ':' if (UseCapturedNS_ and self.nro_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snro>%s</%snro>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nro), input_name='nro')), namespaceprefix_ , eol_))
        if self.xCpl is not None:
            namespaceprefix_ = self.xCpl_nsprefix_ + ':' if (UseCapturedNS_ and self.xCpl_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxCpl>%s</%sxCpl>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xCpl), input_name='xCpl')), namespaceprefix_ , eol_))
        if self.xBairro is not None:
            namespaceprefix_ = self.xBairro_nsprefix_ + ':' if (UseCapturedNS_ and self.xBairro_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxBairro>%s</%sxBairro>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xBairro), input_name='xBairro')), namespaceprefix_ , eol_))
        if self.cMun is not None:
            namespaceprefix_ = self.cMun_nsprefix_ + ':' if (UseCapturedNS_ and self.cMun_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scMun>%s</%scMun>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cMun), input_name='cMun')), namespaceprefix_ , eol_))
        if self.xMun is not None:
            namespaceprefix_ = self.xMun_nsprefix_ + ':' if (UseCapturedNS_ and self.xMun_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxMun>%s</%sxMun>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xMun), input_name='xMun')), namespaceprefix_ , eol_))
        if self.UF is not None:
            namespaceprefix_ = self.UF_nsprefix_ + ':' if (UseCapturedNS_ and self.UF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUF>%s</%sUF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.UF), input_name='UF')), namespaceprefix_ , eol_))
        if self.CEP is not None:
            namespaceprefix_ = self.CEP_nsprefix_ + ':' if (UseCapturedNS_ and self.CEP_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCEP>%s</%sCEP>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CEP), input_name='CEP')), namespaceprefix_ , eol_))
        if self.cPais is not None:
            namespaceprefix_ = self.cPais_nsprefix_ + ':' if (UseCapturedNS_ and self.cPais_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scPais>%s</%scPais>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cPais), input_name='cPais')), namespaceprefix_ , eol_))
        if self.xPais is not None:
            namespaceprefix_ = self.xPais_nsprefix_ + ':' if (UseCapturedNS_ and self.xPais_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxPais>%s</%sxPais>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xPais), input_name='xPais')), namespaceprefix_ , eol_))
        if self.fone is not None:
            namespaceprefix_ = self.fone_nsprefix_ + ':' if (UseCapturedNS_ and self.fone_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfone>%s</%sfone>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.fone), input_name='fone')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'xLgr':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xLgr')
            value_ = self.gds_validate_string(value_, node, 'xLgr')
            self.xLgr = value_
            self.xLgr_nsprefix_ = child_.prefix
            # validate type xLgrType
            self.validate_xLgrType(self.xLgr)
        elif nodeName_ == 'nro':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nro')
            value_ = self.gds_validate_string(value_, node, 'nro')
            self.nro = value_
            self.nro_nsprefix_ = child_.prefix
            # validate type nroType
            self.validate_nroType(self.nro)
        elif nodeName_ == 'xCpl':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xCpl')
            value_ = self.gds_validate_string(value_, node, 'xCpl')
            self.xCpl = value_
            self.xCpl_nsprefix_ = child_.prefix
            # validate type xCplType
            self.validate_xCplType(self.xCpl)
        elif nodeName_ == 'xBairro':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xBairro')
            value_ = self.gds_validate_string(value_, node, 'xBairro')
            self.xBairro = value_
            self.xBairro_nsprefix_ = child_.prefix
            # validate type xBairroType
            self.validate_xBairroType(self.xBairro)
        elif nodeName_ == 'cMun':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cMun')
            value_ = self.gds_validate_string(value_, node, 'cMun')
            self.cMun = value_
            self.cMun_nsprefix_ = child_.prefix
            # validate type TCodMunIBGE
            self.validate_TCodMunIBGE(self.cMun)
        elif nodeName_ == 'xMun':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xMun')
            value_ = self.gds_validate_string(value_, node, 'xMun')
            self.xMun = value_
            self.xMun_nsprefix_ = child_.prefix
            # validate type xMunType49
            self.validate_xMunType49(self.xMun)
        elif nodeName_ == 'UF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'UF')
            value_ = self.gds_validate_string(value_, node, 'UF')
            self.UF = value_
            self.UF_nsprefix_ = child_.prefix
            # validate type TUf
            self.validate_TUf(self.UF)
        elif nodeName_ == 'CEP':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CEP')
            value_ = self.gds_validate_string(value_, node, 'CEP')
            self.CEP = value_
            self.CEP_nsprefix_ = child_.prefix
            # validate type CEPType
            self.validate_CEPType(self.CEP)
        elif nodeName_ == 'cPais':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cPais')
            value_ = self.gds_validate_string(value_, node, 'cPais')
            self.cPais = value_
            self.cPais_nsprefix_ = child_.prefix
            # validate type Tpais
            self.validate_Tpais(self.cPais)
        elif nodeName_ == 'xPais':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xPais')
            value_ = self.gds_validate_string(value_, node, 'xPais')
            self.xPais = value_
            self.xPais_nsprefix_ = child_.prefix
            # validate type xPaisType
            self.validate_xPaisType(self.xPais)
        elif nodeName_ == 'fone':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'fone')
            value_ = self.gds_validate_string(value_, node, 'fone')
            self.fone = value_
            self.fone_nsprefix_ = child_.prefix
            # validate type foneType50
            self.validate_foneType50(self.fone)
# end class TEndereco


class TEnderEmi(GeneratedsSuper):
    """Tipo Dados do Endereço do Emitente // 24/10/08 - desmembrado / tamanho
    mínimo"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('xLgr', ['xLgrType51', 'TString', 'xs:string'], 0, 0, {'name': 'xLgr', 'type': 'xs:string'}, None),
        MemberSpec_('nro', ['nroType52', 'TString', 'xs:string'], 0, 0, {'name': 'nro', 'type': 'xs:string'}, None),
        MemberSpec_('xCpl', ['xCplType53', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'xCpl', 'type': 'xs:string'}, None),
        MemberSpec_('xBairro', ['xBairroType54', 'TString', 'xs:string'], 0, 0, {'name': 'xBairro', 'type': 'xs:string'}, None),
        MemberSpec_('cMun', ['TCodMunIBGE', 'xs:string'], 0, 0, {'name': 'cMun', 'type': 'xs:string'}, None),
        MemberSpec_('xMun', ['xMunType55', 'TString', 'xs:string'], 0, 0, {'name': 'xMun', 'type': 'xs:string'}, None),
        MemberSpec_('UF', ['TUfEmi', 'xs:string'], 0, 0, {'name': 'UF', 'type': 'xs:string'}, None),
        MemberSpec_('CEP', ['CEPType56', 'xs:string'], 0, 0, {'name': 'CEP', 'type': 'xs:string'}, None),
        MemberSpec_('cPais', ['cPaisType', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'cPais', 'type': 'xs:string'}, None),
        MemberSpec_('xPais', ['xPaisType57', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'xPais', 'type': 'xs:string'}, None),
        MemberSpec_('fone', ['foneType58', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'fone', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, xLgr=None, nro=None, xCpl=None, xBairro=None, cMun=None, xMun=None, UF=None, CEP=None, cPais=None, xPais=None, fone=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.xLgr = xLgr
        self.validate_xLgrType51(self.xLgr)
        self.xLgr_nsprefix_ = None
        self.nro = nro
        self.validate_nroType52(self.nro)
        self.nro_nsprefix_ = None
        self.xCpl = xCpl
        self.validate_xCplType53(self.xCpl)
        self.xCpl_nsprefix_ = None
        self.xBairro = xBairro
        self.validate_xBairroType54(self.xBairro)
        self.xBairro_nsprefix_ = None
        self.cMun = cMun
        self.validate_TCodMunIBGE(self.cMun)
        self.cMun_nsprefix_ = None
        self.xMun = xMun
        self.validate_xMunType55(self.xMun)
        self.xMun_nsprefix_ = None
        self.UF = UF
        self.validate_TUfEmi(self.UF)
        self.UF_nsprefix_ = None
        self.CEP = CEP
        self.validate_CEPType56(self.CEP)
        self.CEP_nsprefix_ = None
        self.cPais = cPais
        self.validate_cPaisType(self.cPais)
        self.cPais_nsprefix_ = None
        self.xPais = xPais
        self.validate_xPaisType57(self.xPais)
        self.xPais_nsprefix_ = None
        self.fone = fone
        self.validate_foneType58(self.fone)
        self.fone_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TEnderEmi)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TEnderEmi.subclass:
            return TEnderEmi.subclass(*args_, **kwargs_)
        else:
            return TEnderEmi(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_xLgrType51(self, value):
        result = True
        # Validate type xLgrType51, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xLgrType51' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xLgrType51' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xLgrType51_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xLgrType51_patterns_, ))
                result = False
        return result
    validate_xLgrType51_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_nroType52(self, value):
        result = True
        # Validate type nroType52, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on nroType52' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nroType52' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_nroType52_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nroType52_patterns_, ))
                result = False
        return result
    validate_nroType52_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_xCplType53(self, value):
        result = True
        # Validate type xCplType53, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xCplType53' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xCplType53' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xCplType53_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xCplType53_patterns_, ))
                result = False
        return result
    validate_xCplType53_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_xBairroType54(self, value):
        result = True
        # Validate type xBairroType54, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xBairroType54' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xBairroType54' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xBairroType54_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xBairroType54_patterns_, ))
                result = False
        return result
    validate_xBairroType54_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TCodMunIBGE(self, value):
        result = True
        # Validate type TCodMunIBGE, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCodMunIBGE_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCodMunIBGE_patterns_, ))
                result = False
        return result
    validate_TCodMunIBGE_patterns_ = [['^([0-9]{7})$']]
    def validate_xMunType55(self, value):
        result = True
        # Validate type xMunType55, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xMunType55' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xMunType55' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xMunType55_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xMunType55_patterns_, ))
                result = False
        return result
    validate_xMunType55_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TUfEmi(self, value):
        result = True
        # Validate type TUfEmi, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['AC', 'AL', 'AM', 'AP', 'BA', 'CE', 'DF', 'ES', 'GO', 'MA', 'MG', 'MS', 'MT', 'PA', 'PB', 'PE', 'PI', 'PR', 'RJ', 'RN', 'RO', 'RR', 'RS', 'SC', 'SE', 'SP', 'TO']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TUfEmi' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CEPType56(self, value):
        result = True
        # Validate type CEPType56, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_CEPType56_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_CEPType56_patterns_, ))
                result = False
        return result
    validate_CEPType56_patterns_ = [['^([0-9]{8})$']]
    def validate_cPaisType(self, value):
        result = True
        # Validate type cPaisType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['1058']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on cPaisType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_cPaisType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cPaisType_patterns_, ))
                result = False
        return result
    validate_cPaisType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_xPaisType57(self, value):
        result = True
        # Validate type xPaisType57, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['Brasil', 'BRASIL']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on xPaisType57' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xPaisType57_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xPaisType57_patterns_, ))
                result = False
        return result
    validate_xPaisType57_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_foneType58(self, value):
        result = True
        # Validate type foneType58, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_foneType58_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_foneType58_patterns_, ))
                result = False
        return result
    validate_foneType58_patterns_ = [['^([0-9]{6,14})$']]
    def hasContent_(self):
        if (
            self.xLgr is not None or
            self.nro is not None or
            self.xCpl is not None or
            self.xBairro is not None or
            self.cMun is not None or
            self.xMun is not None or
            self.UF is not None or
            self.CEP is not None or
            self.cPais is not None or
            self.xPais is not None or
            self.fone is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TEnderEmi', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TEnderEmi')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TEnderEmi':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TEnderEmi')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TEnderEmi', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TEnderEmi'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TEnderEmi', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.xLgr is not None:
            namespaceprefix_ = self.xLgr_nsprefix_ + ':' if (UseCapturedNS_ and self.xLgr_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxLgr>%s</%sxLgr>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xLgr), input_name='xLgr')), namespaceprefix_ , eol_))
        if self.nro is not None:
            namespaceprefix_ = self.nro_nsprefix_ + ':' if (UseCapturedNS_ and self.nro_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snro>%s</%snro>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nro), input_name='nro')), namespaceprefix_ , eol_))
        if self.xCpl is not None:
            namespaceprefix_ = self.xCpl_nsprefix_ + ':' if (UseCapturedNS_ and self.xCpl_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxCpl>%s</%sxCpl>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xCpl), input_name='xCpl')), namespaceprefix_ , eol_))
        if self.xBairro is not None:
            namespaceprefix_ = self.xBairro_nsprefix_ + ':' if (UseCapturedNS_ and self.xBairro_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxBairro>%s</%sxBairro>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xBairro), input_name='xBairro')), namespaceprefix_ , eol_))
        if self.cMun is not None:
            namespaceprefix_ = self.cMun_nsprefix_ + ':' if (UseCapturedNS_ and self.cMun_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scMun>%s</%scMun>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cMun), input_name='cMun')), namespaceprefix_ , eol_))
        if self.xMun is not None:
            namespaceprefix_ = self.xMun_nsprefix_ + ':' if (UseCapturedNS_ and self.xMun_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxMun>%s</%sxMun>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xMun), input_name='xMun')), namespaceprefix_ , eol_))
        if self.UF is not None:
            namespaceprefix_ = self.UF_nsprefix_ + ':' if (UseCapturedNS_ and self.UF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUF>%s</%sUF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.UF), input_name='UF')), namespaceprefix_ , eol_))
        if self.CEP is not None:
            namespaceprefix_ = self.CEP_nsprefix_ + ':' if (UseCapturedNS_ and self.CEP_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCEP>%s</%sCEP>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CEP), input_name='CEP')), namespaceprefix_ , eol_))
        if self.cPais is not None:
            namespaceprefix_ = self.cPais_nsprefix_ + ':' if (UseCapturedNS_ and self.cPais_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scPais>%s</%scPais>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cPais), input_name='cPais')), namespaceprefix_ , eol_))
        if self.xPais is not None:
            namespaceprefix_ = self.xPais_nsprefix_ + ':' if (UseCapturedNS_ and self.xPais_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxPais>%s</%sxPais>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xPais), input_name='xPais')), namespaceprefix_ , eol_))
        if self.fone is not None:
            namespaceprefix_ = self.fone_nsprefix_ + ':' if (UseCapturedNS_ and self.fone_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfone>%s</%sfone>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.fone), input_name='fone')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'xLgr':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xLgr')
            value_ = self.gds_validate_string(value_, node, 'xLgr')
            self.xLgr = value_
            self.xLgr_nsprefix_ = child_.prefix
            # validate type xLgrType51
            self.validate_xLgrType51(self.xLgr)
        elif nodeName_ == 'nro':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nro')
            value_ = self.gds_validate_string(value_, node, 'nro')
            self.nro = value_
            self.nro_nsprefix_ = child_.prefix
            # validate type nroType52
            self.validate_nroType52(self.nro)
        elif nodeName_ == 'xCpl':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xCpl')
            value_ = self.gds_validate_string(value_, node, 'xCpl')
            self.xCpl = value_
            self.xCpl_nsprefix_ = child_.prefix
            # validate type xCplType53
            self.validate_xCplType53(self.xCpl)
        elif nodeName_ == 'xBairro':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xBairro')
            value_ = self.gds_validate_string(value_, node, 'xBairro')
            self.xBairro = value_
            self.xBairro_nsprefix_ = child_.prefix
            # validate type xBairroType54
            self.validate_xBairroType54(self.xBairro)
        elif nodeName_ == 'cMun':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cMun')
            value_ = self.gds_validate_string(value_, node, 'cMun')
            self.cMun = value_
            self.cMun_nsprefix_ = child_.prefix
            # validate type TCodMunIBGE
            self.validate_TCodMunIBGE(self.cMun)
        elif nodeName_ == 'xMun':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xMun')
            value_ = self.gds_validate_string(value_, node, 'xMun')
            self.xMun = value_
            self.xMun_nsprefix_ = child_.prefix
            # validate type xMunType55
            self.validate_xMunType55(self.xMun)
        elif nodeName_ == 'UF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'UF')
            value_ = self.gds_validate_string(value_, node, 'UF')
            self.UF = value_
            self.UF_nsprefix_ = child_.prefix
            # validate type TUfEmi
            self.validate_TUfEmi(self.UF)
        elif nodeName_ == 'CEP':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CEP')
            value_ = self.gds_validate_string(value_, node, 'CEP')
            self.CEP = value_
            self.CEP_nsprefix_ = child_.prefix
            # validate type CEPType56
            self.validate_CEPType56(self.CEP)
        elif nodeName_ == 'cPais':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cPais')
            value_ = self.gds_validate_string(value_, node, 'cPais')
            self.cPais = value_
            self.cPais_nsprefix_ = child_.prefix
            # validate type cPaisType
            self.validate_cPaisType(self.cPais)
        elif nodeName_ == 'xPais':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xPais')
            value_ = self.gds_validate_string(value_, node, 'xPais')
            self.xPais = value_
            self.xPais_nsprefix_ = child_.prefix
            # validate type xPaisType57
            self.validate_xPaisType57(self.xPais)
        elif nodeName_ == 'fone':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'fone')
            value_ = self.gds_validate_string(value_, node, 'fone')
            self.fone = value_
            self.fone_nsprefix_ = child_.prefix
            # validate type foneType58
            self.validate_foneType58(self.fone)
# end class TEnderEmi


class TLocal(GeneratedsSuper):
    """Tipo Dados do Local de Retirada ou Entrega // 24/10/08 - tamanho mínimo
    // v2.0"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('CNPJ', ['TCnpjOpc', 'xs:string'], 0, 0, {'name': 'CNPJ', 'type': 'xs:string'}, 1),
        MemberSpec_('CPF', ['TCpf', 'xs:string'], 0, 0, {'name': 'CPF', 'type': 'xs:string'}, 1),
        MemberSpec_('xLgr', ['xLgrType59', 'TString', 'xs:string'], 0, 0, {'name': 'xLgr', 'type': 'xs:string'}, None),
        MemberSpec_('nro', ['nroType60', 'TString', 'xs:string'], 0, 0, {'name': 'nro', 'type': 'xs:string'}, None),
        MemberSpec_('xCpl', ['xCplType61', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'xCpl', 'type': 'xs:string'}, None),
        MemberSpec_('xBairro', ['xBairroType62', 'TString', 'xs:string'], 0, 0, {'name': 'xBairro', 'type': 'xs:string'}, None),
        MemberSpec_('cMun', ['TCodMunIBGE', 'xs:string'], 0, 0, {'name': 'cMun', 'type': 'xs:string'}, None),
        MemberSpec_('xMun', ['xMunType63', 'TString', 'xs:string'], 0, 0, {'name': 'xMun', 'type': 'xs:string'}, None),
        MemberSpec_('UF', ['TUf', 'xs:string'], 0, 0, {'name': 'UF', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, CNPJ=None, CPF=None, xLgr=None, nro=None, xCpl=None, xBairro=None, cMun=None, xMun=None, UF=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.CNPJ = CNPJ
        self.validate_TCnpjOpc(self.CNPJ)
        self.CNPJ_nsprefix_ = None
        self.CPF = CPF
        self.validate_TCpf(self.CPF)
        self.CPF_nsprefix_ = None
        self.xLgr = xLgr
        self.validate_xLgrType59(self.xLgr)
        self.xLgr_nsprefix_ = None
        self.nro = nro
        self.validate_nroType60(self.nro)
        self.nro_nsprefix_ = None
        self.xCpl = xCpl
        self.validate_xCplType61(self.xCpl)
        self.xCpl_nsprefix_ = None
        self.xBairro = xBairro
        self.validate_xBairroType62(self.xBairro)
        self.xBairro_nsprefix_ = None
        self.cMun = cMun
        self.validate_TCodMunIBGE(self.cMun)
        self.cMun_nsprefix_ = None
        self.xMun = xMun
        self.validate_xMunType63(self.xMun)
        self.xMun_nsprefix_ = None
        self.UF = UF
        self.validate_TUf(self.UF)
        self.UF_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TLocal)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TLocal.subclass:
            return TLocal.subclass(*args_, **kwargs_)
        else:
            return TLocal(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TCnpjOpc(self, value):
        result = True
        # Validate type TCnpjOpc, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 14:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TCnpjOpc' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCnpjOpc_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCnpjOpc_patterns_, ))
                result = False
        return result
    validate_TCnpjOpc_patterns_ = [['^([0-9]{0}|[0-9]{14})$']]
    def validate_TCpf(self, value):
        result = True
        # Validate type TCpf, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCpf_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCpf_patterns_, ))
                result = False
        return result
    validate_TCpf_patterns_ = [['^([0-9]{11})$']]
    def validate_xLgrType59(self, value):
        result = True
        # Validate type xLgrType59, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xLgrType59' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xLgrType59' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xLgrType59_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xLgrType59_patterns_, ))
                result = False
        return result
    validate_xLgrType59_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_nroType60(self, value):
        result = True
        # Validate type nroType60, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on nroType60' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nroType60' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_nroType60_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nroType60_patterns_, ))
                result = False
        return result
    validate_nroType60_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_xCplType61(self, value):
        result = True
        # Validate type xCplType61, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xCplType61' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xCplType61' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xCplType61_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xCplType61_patterns_, ))
                result = False
        return result
    validate_xCplType61_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_xBairroType62(self, value):
        result = True
        # Validate type xBairroType62, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xBairroType62' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xBairroType62' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xBairroType62_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xBairroType62_patterns_, ))
                result = False
        return result
    validate_xBairroType62_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TCodMunIBGE(self, value):
        result = True
        # Validate type TCodMunIBGE, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCodMunIBGE_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCodMunIBGE_patterns_, ))
                result = False
        return result
    validate_TCodMunIBGE_patterns_ = [['^([0-9]{7})$']]
    def validate_xMunType63(self, value):
        result = True
        # Validate type xMunType63, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xMunType63' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xMunType63' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xMunType63_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xMunType63_patterns_, ))
                result = False
        return result
    validate_xMunType63_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TUf(self, value):
        result = True
        # Validate type TUf, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['AC', 'AL', 'AM', 'AP', 'BA', 'CE', 'DF', 'ES', 'GO', 'MA', 'MG', 'MS', 'MT', 'PA', 'PB', 'PE', 'PI', 'PR', 'RJ', 'RN', 'RO', 'RR', 'RS', 'SC', 'SE', 'SP', 'TO', 'EX']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TUf' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def hasContent_(self):
        if (
            self.CNPJ is not None or
            self.CPF is not None or
            self.xLgr is not None or
            self.nro is not None or
            self.xCpl is not None or
            self.xBairro is not None or
            self.cMun is not None or
            self.xMun is not None or
            self.UF is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TLocal', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TLocal')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TLocal':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TLocal')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TLocal', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TLocal'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TLocal', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CNPJ is not None:
            namespaceprefix_ = self.CNPJ_nsprefix_ + ':' if (UseCapturedNS_ and self.CNPJ_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCNPJ>%s</%sCNPJ>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CNPJ), input_name='CNPJ')), namespaceprefix_ , eol_))
        if self.CPF is not None:
            namespaceprefix_ = self.CPF_nsprefix_ + ':' if (UseCapturedNS_ and self.CPF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCPF>%s</%sCPF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CPF), input_name='CPF')), namespaceprefix_ , eol_))
        if self.xLgr is not None:
            namespaceprefix_ = self.xLgr_nsprefix_ + ':' if (UseCapturedNS_ and self.xLgr_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxLgr>%s</%sxLgr>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xLgr), input_name='xLgr')), namespaceprefix_ , eol_))
        if self.nro is not None:
            namespaceprefix_ = self.nro_nsprefix_ + ':' if (UseCapturedNS_ and self.nro_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snro>%s</%snro>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nro), input_name='nro')), namespaceprefix_ , eol_))
        if self.xCpl is not None:
            namespaceprefix_ = self.xCpl_nsprefix_ + ':' if (UseCapturedNS_ and self.xCpl_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxCpl>%s</%sxCpl>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xCpl), input_name='xCpl')), namespaceprefix_ , eol_))
        if self.xBairro is not None:
            namespaceprefix_ = self.xBairro_nsprefix_ + ':' if (UseCapturedNS_ and self.xBairro_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxBairro>%s</%sxBairro>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xBairro), input_name='xBairro')), namespaceprefix_ , eol_))
        if self.cMun is not None:
            namespaceprefix_ = self.cMun_nsprefix_ + ':' if (UseCapturedNS_ and self.cMun_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scMun>%s</%scMun>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cMun), input_name='cMun')), namespaceprefix_ , eol_))
        if self.xMun is not None:
            namespaceprefix_ = self.xMun_nsprefix_ + ':' if (UseCapturedNS_ and self.xMun_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxMun>%s</%sxMun>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xMun), input_name='xMun')), namespaceprefix_ , eol_))
        if self.UF is not None:
            namespaceprefix_ = self.UF_nsprefix_ + ':' if (UseCapturedNS_ and self.UF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUF>%s</%sUF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.UF), input_name='UF')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CNPJ':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CNPJ')
            value_ = self.gds_validate_string(value_, node, 'CNPJ')
            self.CNPJ = value_
            self.CNPJ_nsprefix_ = child_.prefix
            # validate type TCnpjOpc
            self.validate_TCnpjOpc(self.CNPJ)
        elif nodeName_ == 'CPF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CPF')
            value_ = self.gds_validate_string(value_, node, 'CPF')
            self.CPF = value_
            self.CPF_nsprefix_ = child_.prefix
            # validate type TCpf
            self.validate_TCpf(self.CPF)
        elif nodeName_ == 'xLgr':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xLgr')
            value_ = self.gds_validate_string(value_, node, 'xLgr')
            self.xLgr = value_
            self.xLgr_nsprefix_ = child_.prefix
            # validate type xLgrType59
            self.validate_xLgrType59(self.xLgr)
        elif nodeName_ == 'nro':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nro')
            value_ = self.gds_validate_string(value_, node, 'nro')
            self.nro = value_
            self.nro_nsprefix_ = child_.prefix
            # validate type nroType60
            self.validate_nroType60(self.nro)
        elif nodeName_ == 'xCpl':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xCpl')
            value_ = self.gds_validate_string(value_, node, 'xCpl')
            self.xCpl = value_
            self.xCpl_nsprefix_ = child_.prefix
            # validate type xCplType61
            self.validate_xCplType61(self.xCpl)
        elif nodeName_ == 'xBairro':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xBairro')
            value_ = self.gds_validate_string(value_, node, 'xBairro')
            self.xBairro = value_
            self.xBairro_nsprefix_ = child_.prefix
            # validate type xBairroType62
            self.validate_xBairroType62(self.xBairro)
        elif nodeName_ == 'cMun':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cMun')
            value_ = self.gds_validate_string(value_, node, 'cMun')
            self.cMun = value_
            self.cMun_nsprefix_ = child_.prefix
            # validate type TCodMunIBGE
            self.validate_TCodMunIBGE(self.cMun)
        elif nodeName_ == 'xMun':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xMun')
            value_ = self.gds_validate_string(value_, node, 'xMun')
            self.xMun = value_
            self.xMun_nsprefix_ = child_.prefix
            # validate type xMunType63
            self.validate_xMunType63(self.xMun)
        elif nodeName_ == 'UF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'UF')
            value_ = self.gds_validate_string(value_, node, 'UF')
            self.UF = value_
            self.UF_nsprefix_ = child_.prefix
            # validate type TUf
            self.validate_TUf(self.UF)
# end class TLocal


class TVeiculo(GeneratedsSuper):
    """Tipo Dados do Veículo"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('placa', ['placaType', 'xs:string'], 0, 0, {'name': 'placa', 'type': 'xs:string'}, None),
        MemberSpec_('UF', ['TUf', 'xs:string'], 0, 0, {'name': 'UF', 'type': 'xs:string'}, None),
        MemberSpec_('RNTC', ['RNTCType', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'RNTC', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, placa=None, UF=None, RNTC=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.placa = placa
        self.validate_placaType(self.placa)
        self.placa_nsprefix_ = None
        self.UF = UF
        self.validate_TUf(self.UF)
        self.UF_nsprefix_ = None
        self.RNTC = RNTC
        self.validate_RNTCType(self.RNTC)
        self.RNTC_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TVeiculo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TVeiculo.subclass:
            return TVeiculo.subclass(*args_, **kwargs_)
        else:
            return TVeiculo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_placaType(self, value):
        result = True
        # Validate type placaType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_placaType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_placaType_patterns_, ))
                result = False
        return result
    validate_placaType_patterns_ = [['^([A-Z]{2,3}[0-9]{4}|[A-Z]{3,4}[0-9]{3})$']]
    def validate_TUf(self, value):
        result = True
        # Validate type TUf, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['AC', 'AL', 'AM', 'AP', 'BA', 'CE', 'DF', 'ES', 'GO', 'MA', 'MG', 'MS', 'MT', 'PA', 'PB', 'PE', 'PI', 'PR', 'RJ', 'RN', 'RO', 'RR', 'RS', 'SC', 'SE', 'SP', 'TO', 'EX']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TUf' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_RNTCType(self, value):
        result = True
        # Validate type RNTCType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 20:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on RNTCType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on RNTCType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_RNTCType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_RNTCType_patterns_, ))
                result = False
        return result
    validate_RNTCType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def hasContent_(self):
        if (
            self.placa is not None or
            self.UF is not None or
            self.RNTC is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TVeiculo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TVeiculo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TVeiculo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TVeiculo')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TVeiculo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TVeiculo'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TVeiculo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.placa is not None:
            namespaceprefix_ = self.placa_nsprefix_ + ':' if (UseCapturedNS_ and self.placa_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%splaca>%s</%splaca>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.placa), input_name='placa')), namespaceprefix_ , eol_))
        if self.UF is not None:
            namespaceprefix_ = self.UF_nsprefix_ + ':' if (UseCapturedNS_ and self.UF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUF>%s</%sUF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.UF), input_name='UF')), namespaceprefix_ , eol_))
        if self.RNTC is not None:
            namespaceprefix_ = self.RNTC_nsprefix_ + ':' if (UseCapturedNS_ and self.RNTC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sRNTC>%s</%sRNTC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.RNTC), input_name='RNTC')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'placa':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'placa')
            value_ = self.gds_validate_string(value_, node, 'placa')
            self.placa = value_
            self.placa_nsprefix_ = child_.prefix
            # validate type placaType
            self.validate_placaType(self.placa)
        elif nodeName_ == 'UF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'UF')
            value_ = self.gds_validate_string(value_, node, 'UF')
            self.UF = value_
            self.UF_nsprefix_ = child_.prefix
            # validate type TUf
            self.validate_TUf(self.UF)
        elif nodeName_ == 'RNTC':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'RNTC')
            value_ = self.gds_validate_string(value_, node, 'RNTC')
            self.RNTC = value_
            self.RNTC_nsprefix_ = child_.prefix
            # validate type RNTCType
            self.validate_RNTCType(self.RNTC)
# end class TVeiculo


class SignatureType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('Id', 'ID', 0, 1, {'use': 'optional'}),
        MemberSpec_('SignedInfo', 'SignedInfoType', 0, 0, {'name': 'SignedInfo', 'type': 'SignedInfoType'}, None),
        MemberSpec_('SignatureValue', 'SignatureValueType', 0, 0, {'name': 'SignatureValue', 'type': 'SignatureValueType'}, None),
        MemberSpec_('KeyInfo', 'KeyInfoType', 0, 0, {'name': 'KeyInfo', 'type': 'KeyInfoType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, Id=None, SignedInfo=None, SignatureValue=None, KeyInfo=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Id = _cast(None, Id)
        self.Id_nsprefix_ = None
        self.SignedInfo = SignedInfo
        self.SignedInfo_nsprefix_ = "ds"
        self.SignatureValue = SignatureValue
        self.SignatureValue_nsprefix_ = "ds"
        self.KeyInfo = KeyInfo
        self.KeyInfo_nsprefix_ = "ds"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SignatureType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SignatureType.subclass:
            return SignatureType.subclass(*args_, **kwargs_)
        else:
            return SignatureType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.SignedInfo is not None or
            self.SignatureValue is not None or
            self.KeyInfo is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='SignatureType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SignatureType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SignatureType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SignatureType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SignatureType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ds:', name_='SignatureType'):
        if self.Id is not None and 'Id' not in already_processed:
            already_processed.add('Id')
            outfile.write(' Id=%s' % (quote_attrib(self.Id), ))
    def exportChildren(self, outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='SignatureType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.SignedInfo is not None:
            namespaceprefix_ = self.SignedInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.SignedInfo_nsprefix_) else ''
            self.SignedInfo.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SignedInfo', pretty_print=pretty_print)
        if self.SignatureValue is not None:
            namespaceprefix_ = self.SignatureValue_nsprefix_ + ':' if (UseCapturedNS_ and self.SignatureValue_nsprefix_) else ''
            self.SignatureValue.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SignatureValue', pretty_print=pretty_print)
        if self.KeyInfo is not None:
            namespaceprefix_ = self.KeyInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.KeyInfo_nsprefix_) else ''
            self.KeyInfo.export(outfile, level, namespaceprefix_, namespacedef_='', name_='KeyInfo', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('Id', node)
        if value is not None and 'Id' not in already_processed:
            already_processed.add('Id')
            self.Id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'SignedInfo':
            obj_ = SignedInfoType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SignedInfo = obj_
            obj_.original_tagname_ = 'SignedInfo'
        elif nodeName_ == 'SignatureValue':
            obj_ = SignatureValueType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SignatureValue = obj_
            obj_.original_tagname_ = 'SignatureValue'
        elif nodeName_ == 'KeyInfo':
            obj_ = KeyInfoType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.KeyInfo = obj_
            obj_.original_tagname_ = 'KeyInfo'
# end class SignatureType


class SignatureValueType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('Id', 'ID', 0, 1, {'use': 'optional'}),
        MemberSpec_('valueOf_', 'base64Binary', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, Id=None, valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Id = _cast(None, Id)
        self.Id_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SignatureValueType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SignatureValueType.subclass:
            return SignatureValueType.subclass(*args_, **kwargs_)
        else:
            return SignatureValueType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='SignatureValueType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SignatureValueType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SignatureValueType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SignatureValueType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SignatureValueType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ds:', name_='SignatureValueType'):
        if self.Id is not None and 'Id' not in already_processed:
            already_processed.add('Id')
            outfile.write(' Id=%s' % (quote_attrib(self.Id), ))
    def exportChildren(self, outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='SignatureValueType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('Id', node)
        if value is not None and 'Id' not in already_processed:
            already_processed.add('Id')
            self.Id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class SignatureValueType


class SignedInfoType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('Id', 'ID', 0, 1, {'use': 'optional'}),
        MemberSpec_('CanonicalizationMethod', 'CanonicalizationMethodType', 0, 0, {'name': 'CanonicalizationMethod', 'type': 'CanonicalizationMethodType'}, None),
        MemberSpec_('SignatureMethod', 'SignatureMethodType', 0, 0, {'name': 'SignatureMethod', 'type': 'SignatureMethodType'}, None),
        MemberSpec_('Reference', 'ReferenceType', 0, 0, {'name': 'Reference', 'type': 'ReferenceType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, Id=None, CanonicalizationMethod=None, SignatureMethod=None, Reference=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Id = _cast(None, Id)
        self.Id_nsprefix_ = None
        self.CanonicalizationMethod = CanonicalizationMethod
        self.CanonicalizationMethod_nsprefix_ = None
        self.SignatureMethod = SignatureMethod
        self.SignatureMethod_nsprefix_ = None
        self.Reference = Reference
        self.Reference_nsprefix_ = "ds"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SignedInfoType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SignedInfoType.subclass:
            return SignedInfoType.subclass(*args_, **kwargs_)
        else:
            return SignedInfoType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.CanonicalizationMethod is not None or
            self.SignatureMethod is not None or
            self.Reference is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='SignedInfoType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SignedInfoType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SignedInfoType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SignedInfoType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SignedInfoType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ds:', name_='SignedInfoType'):
        if self.Id is not None and 'Id' not in already_processed:
            already_processed.add('Id')
            outfile.write(' Id=%s' % (quote_attrib(self.Id), ))
    def exportChildren(self, outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='SignedInfoType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CanonicalizationMethod is not None:
            namespaceprefix_ = self.CanonicalizationMethod_nsprefix_ + ':' if (UseCapturedNS_ and self.CanonicalizationMethod_nsprefix_) else ''
            self.CanonicalizationMethod.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CanonicalizationMethod', pretty_print=pretty_print)
        if self.SignatureMethod is not None:
            namespaceprefix_ = self.SignatureMethod_nsprefix_ + ':' if (UseCapturedNS_ and self.SignatureMethod_nsprefix_) else ''
            self.SignatureMethod.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SignatureMethod', pretty_print=pretty_print)
        if self.Reference is not None:
            namespaceprefix_ = self.Reference_nsprefix_ + ':' if (UseCapturedNS_ and self.Reference_nsprefix_) else ''
            self.Reference.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Reference', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('Id', node)
        if value is not None and 'Id' not in already_processed:
            already_processed.add('Id')
            self.Id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CanonicalizationMethod':
            obj_ = CanonicalizationMethodType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CanonicalizationMethod = obj_
            obj_.original_tagname_ = 'CanonicalizationMethod'
        elif nodeName_ == 'SignatureMethod':
            obj_ = SignatureMethodType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SignatureMethod = obj_
            obj_.original_tagname_ = 'SignatureMethod'
        elif nodeName_ == 'Reference':
            obj_ = ReferenceType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Reference = obj_
            obj_.original_tagname_ = 'Reference'
# end class SignedInfoType


class ReferenceType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('Id', 'ID', 0, 1, {'use': 'optional'}),
        MemberSpec_('URI', 'URIType', 0, 0, {'use': 'required'}),
        MemberSpec_('Type', 'anyURI', 0, 1, {'use': 'optional'}),
        MemberSpec_('Transforms', 'TransformsType', 0, 0, {'name': 'Transforms', 'type': 'TransformsType'}, None),
        MemberSpec_('DigestMethod', 'DigestMethodType', 0, 0, {'name': 'DigestMethod', 'type': 'DigestMethodType'}, None),
        MemberSpec_('DigestValue', ['DigestValueType', 'base64Binary'], 0, 0, {'name': 'DigestValue', 'type': 'xs:base64Binary'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, Id=None, URI=None, Type=None, Transforms=None, DigestMethod=None, DigestValue=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Id = _cast(None, Id)
        self.Id_nsprefix_ = None
        self.URI = _cast(None, URI)
        self.URI_nsprefix_ = None
        self.Type = _cast(None, Type)
        self.Type_nsprefix_ = None
        self.Transforms = Transforms
        self.Transforms_nsprefix_ = "ds"
        self.DigestMethod = DigestMethod
        self.DigestMethod_nsprefix_ = None
        self.DigestValue = DigestValue
        self.validate_DigestValueType(self.DigestValue)
        self.DigestValue_nsprefix_ = "ds"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ReferenceType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ReferenceType.subclass:
            return ReferenceType.subclass(*args_, **kwargs_)
        else:
            return ReferenceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_DigestValueType(self, value):
        result = True
        # Validate type DigestValueType, a restriction on base64Binary.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            pass
        return result
    def validate_URIType(self, value):
        # Validate type URIType, a restriction on anyURI.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on URIType' % {"value" : value, "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            self.Transforms is not None or
            self.DigestMethod is not None or
            self.DigestValue is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='ReferenceType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ReferenceType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ReferenceType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ReferenceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ReferenceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ds:', name_='ReferenceType'):
        if self.Id is not None and 'Id' not in already_processed:
            already_processed.add('Id')
            outfile.write(' Id=%s' % (quote_attrib(self.Id), ))
        if self.URI is not None and 'URI' not in already_processed:
            already_processed.add('URI')
            outfile.write(' URI=%s' % (quote_attrib(self.URI), ))
        if self.Type is not None and 'Type' not in already_processed:
            already_processed.add('Type')
            outfile.write(' Type=%s' % (quote_attrib(self.Type), ))
    def exportChildren(self, outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='ReferenceType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Transforms is not None:
            namespaceprefix_ = self.Transforms_nsprefix_ + ':' if (UseCapturedNS_ and self.Transforms_nsprefix_) else ''
            self.Transforms.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Transforms', pretty_print=pretty_print)
        if self.DigestMethod is not None:
            namespaceprefix_ = self.DigestMethod_nsprefix_ + ':' if (UseCapturedNS_ and self.DigestMethod_nsprefix_) else ''
            self.DigestMethod.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DigestMethod', pretty_print=pretty_print)
        if self.DigestValue is not None:
            namespaceprefix_ = self.DigestValue_nsprefix_ + ':' if (UseCapturedNS_ and self.DigestValue_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDigestValue>%s</%sDigestValue>%s' % (namespaceprefix_ , self.gds_format_base64(self.DigestValue, input_name='DigestValue'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('Id', node)
        if value is not None and 'Id' not in already_processed:
            already_processed.add('Id')
            self.Id = value
        value = find_attr_value_('URI', node)
        if value is not None and 'URI' not in already_processed:
            already_processed.add('URI')
            self.URI = value
            self.validate_URIType(self.URI)    # validate type URIType
        value = find_attr_value_('Type', node)
        if value is not None and 'Type' not in already_processed:
            already_processed.add('Type')
            self.Type = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Transforms':
            obj_ = TransformsType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Transforms = obj_
            obj_.original_tagname_ = 'Transforms'
        elif nodeName_ == 'DigestMethod':
            obj_ = DigestMethodType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DigestMethod = obj_
            obj_.original_tagname_ = 'DigestMethod'
        elif nodeName_ == 'DigestValue':
            sval_ = child_.text
            if sval_ is not None:
                try:
                    bval_ = base64.b64decode(sval_)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(child_, 'requires base64 encoded string: %s' % exp)
                bval_ = self.gds_validate_base64(bval_, node, 'DigestValue')
            else:
                bval_ = None
            self.DigestValue = bval_
            self.DigestValue_nsprefix_ = child_.prefix
            # validate type DigestValueType
            self.validate_DigestValueType(self.DigestValue)
# end class ReferenceType


class TransformsType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('Transform', 'TransformType', 1, 0, {'maxOccurs': '2', 'minOccurs': '2', 'name': 'Transform', 'type': 'TransformType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, Transform=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if Transform is None:
            self.Transform = []
        else:
            self.Transform = Transform
        self.Transform_nsprefix_ = "ds"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TransformsType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TransformsType.subclass:
            return TransformsType.subclass(*args_, **kwargs_)
        else:
            return TransformsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.Transform
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='TransformsType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TransformsType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TransformsType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TransformsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TransformsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ds:', name_='TransformsType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='TransformsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Transform_ in self.Transform:
            namespaceprefix_ = self.Transform_nsprefix_ + ':' if (UseCapturedNS_ and self.Transform_nsprefix_) else ''
            Transform_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Transform', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Transform':
            obj_ = TransformType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Transform.append(obj_)
            obj_.original_tagname_ = 'Transform'
# end class TransformsType


class TransformType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('Algorithm', 'ds:TTransformURI', 0, 0, {'use': 'required'}),
        MemberSpec_('XPath', 'xs:string', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'XPath', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, Algorithm=None, XPath=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Algorithm = _cast(None, Algorithm)
        self.Algorithm_nsprefix_ = None
        if XPath is None:
            self.XPath = []
        else:
            self.XPath = XPath
        self.XPath_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TransformType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TransformType.subclass:
            return TransformType.subclass(*args_, **kwargs_)
        else:
            return TransformType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TTransformURI(self, value):
        # Validate type ds:TTransformURI, a restriction on anyURI.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['http://www.w3.org/2000/09/xmldsig#enveloped-signature', 'http://www.w3.org/TR/2001/REC-xml-c14n-20010315']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TTransformURI' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            self.XPath
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='TransformType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TransformType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TransformType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TransformType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TransformType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ds:', name_='TransformType'):
        if self.Algorithm is not None and 'Algorithm' not in already_processed:
            already_processed.add('Algorithm')
            outfile.write(' Algorithm=%s' % (quote_attrib(self.Algorithm), ))
    def exportChildren(self, outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='TransformType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for XPath_ in self.XPath:
            namespaceprefix_ = self.XPath_nsprefix_ + ':' if (UseCapturedNS_ and self.XPath_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sXPath>%s</%sXPath>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(XPath_), input_name='XPath')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('Algorithm', node)
        if value is not None and 'Algorithm' not in already_processed:
            already_processed.add('Algorithm')
            self.Algorithm = value
            self.validate_TTransformURI(self.Algorithm)    # validate type TTransformURI
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'XPath':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'XPath')
            value_ = self.gds_validate_string(value_, node, 'XPath')
            self.XPath.append(value_)
            self.XPath_nsprefix_ = child_.prefix
# end class TransformType


class KeyInfoType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('Id', 'ID', 0, 1, {'use': 'optional'}),
        MemberSpec_('X509Data', 'X509DataType', 0, 0, {'name': 'X509Data', 'type': 'X509DataType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, Id=None, X509Data=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Id = _cast(None, Id)
        self.Id_nsprefix_ = None
        self.X509Data = X509Data
        self.X509Data_nsprefix_ = "ds"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, KeyInfoType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if KeyInfoType.subclass:
            return KeyInfoType.subclass(*args_, **kwargs_)
        else:
            return KeyInfoType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.X509Data is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='KeyInfoType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('KeyInfoType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'KeyInfoType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='KeyInfoType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='KeyInfoType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ds:', name_='KeyInfoType'):
        if self.Id is not None and 'Id' not in already_processed:
            already_processed.add('Id')
            outfile.write(' Id=%s' % (quote_attrib(self.Id), ))
    def exportChildren(self, outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='KeyInfoType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.X509Data is not None:
            namespaceprefix_ = self.X509Data_nsprefix_ + ':' if (UseCapturedNS_ and self.X509Data_nsprefix_) else ''
            self.X509Data.export(outfile, level, namespaceprefix_, namespacedef_='', name_='X509Data', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('Id', node)
        if value is not None and 'Id' not in already_processed:
            already_processed.add('Id')
            self.Id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'X509Data':
            obj_ = X509DataType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.X509Data = obj_
            obj_.original_tagname_ = 'X509Data'
# end class KeyInfoType


class X509DataType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('X509Certificate', 'xs:string', 0, 0, {'name': 'X509Certificate', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, X509Certificate=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.X509Certificate = X509Certificate
        self.X509Certificate_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, X509DataType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if X509DataType.subclass:
            return X509DataType.subclass(*args_, **kwargs_)
        else:
            return X509DataType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.X509Certificate is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='X509DataType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('X509DataType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'X509DataType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='X509DataType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='X509DataType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ds:', name_='X509DataType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='X509DataType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.X509Certificate is not None:
            namespaceprefix_ = self.X509Certificate_nsprefix_ + ':' if (UseCapturedNS_ and self.X509Certificate_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sX509Certificate>%s</%sX509Certificate>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.X509Certificate), input_name='X509Certificate')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'X509Certificate':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'X509Certificate')
            value_ = self.gds_validate_string(value_, node, 'X509Certificate')
            self.X509Certificate = value_
            self.X509Certificate_nsprefix_ = child_.prefix
# end class X509DataType


class infNFeType(GeneratedsSuper):
    """Informações da Nota Fiscal eletrônicaVersão do leiaute (v2.0)PL_005d -
    11/08/09 - validação do Id"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('versao', 'TVerNFe', 0, 0, {'use': 'required'}),
        MemberSpec_('Id', 'IdType', 0, 0, {'use': 'required'}),
        MemberSpec_('ide', 'ideType', 0, 0, {'name': 'ide', 'type': 'ideType'}, None),
        MemberSpec_('emit', 'emitType', 0, 0, {'name': 'emit', 'type': 'emitType'}, None),
        MemberSpec_('avulsa', 'avulsaType', 0, 1, {'minOccurs': '0', 'name': 'avulsa', 'type': 'avulsaType'}, None),
        MemberSpec_('dest', 'destType', 0, 0, {'name': 'dest', 'type': 'destType'}, None),
        MemberSpec_('retirada', 'TLocal', 0, 1, {'minOccurs': '0', 'name': 'retirada', 'type': 'TLocal'}, None),
        MemberSpec_('entrega', 'TLocal', 0, 1, {'minOccurs': '0', 'name': 'entrega', 'type': 'TLocal'}, None),
        MemberSpec_('det', 'detType', 1, 0, {'maxOccurs': '990', 'name': 'det', 'type': 'detType'}, None),
        MemberSpec_('total', 'totalType', 0, 0, {'name': 'total', 'type': 'totalType'}, None),
        MemberSpec_('transp', 'transpType', 0, 0, {'name': 'transp', 'type': 'transpType'}, None),
        MemberSpec_('cobr', 'cobrType', 0, 1, {'minOccurs': '0', 'name': 'cobr', 'type': 'cobrType'}, None),
        MemberSpec_('infAdic', 'infAdicType', 0, 1, {'minOccurs': '0', 'name': 'infAdic', 'type': 'infAdicType'}, None),
        MemberSpec_('exporta', 'exportaType', 0, 1, {'minOccurs': '0', 'name': 'exporta', 'type': 'exportaType'}, None),
        MemberSpec_('compra', 'compraType', 0, 1, {'minOccurs': '0', 'name': 'compra', 'type': 'compraType'}, None),
        MemberSpec_('cana', 'canaType', 0, 1, {'minOccurs': '0', 'name': 'cana', 'type': 'canaType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, versao=None, Id=None, ide=None, emit=None, avulsa=None, dest=None, retirada=None, entrega=None, det=None, total=None, transp=None, cobr=None, infAdic=None, exporta=None, compra=None, cana=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.versao = _cast(None, versao)
        self.versao_nsprefix_ = None
        self.Id = _cast(None, Id)
        self.Id_nsprefix_ = None
        self.ide = ide
        self.ide_nsprefix_ = None
        self.emit = emit
        self.emit_nsprefix_ = None
        self.avulsa = avulsa
        self.avulsa_nsprefix_ = None
        self.dest = dest
        self.dest_nsprefix_ = None
        self.retirada = retirada
        self.retirada_nsprefix_ = None
        self.entrega = entrega
        self.entrega_nsprefix_ = None
        if det is None:
            self.det = []
        else:
            self.det = det
        self.det_nsprefix_ = None
        self.total = total
        self.total_nsprefix_ = None
        self.transp = transp
        self.transp_nsprefix_ = None
        self.cobr = cobr
        self.cobr_nsprefix_ = None
        self.infAdic = infAdic
        self.infAdic_nsprefix_ = None
        self.exporta = exporta
        self.exporta_nsprefix_ = None
        self.compra = compra
        self.compra_nsprefix_ = None
        self.cana = cana
        self.cana_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, infNFeType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if infNFeType.subclass:
            return infNFeType.subclass(*args_, **kwargs_)
        else:
            return infNFeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TVerNFe(self, value):
        # Validate type TVerNFe, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TVerNFe_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TVerNFe_patterns_, ))
    validate_TVerNFe_patterns_ = [['^(2\\.00)$']]
    def validate_IdType(self, value):
        # Validate type IdType, a restriction on xs:ID.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_IdType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_IdType_patterns_, ))
    validate_IdType_patterns_ = [['^(NFe[0-9]{44})$']]
    def hasContent_(self):
        if (
            self.ide is not None or
            self.emit is not None or
            self.avulsa is not None or
            self.dest is not None or
            self.retirada is not None or
            self.entrega is not None or
            self.det or
            self.total is not None or
            self.transp is not None or
            self.cobr is not None or
            self.infAdic is not None or
            self.exporta is not None or
            self.compra is not None or
            self.cana is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='infNFeType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('infNFeType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'infNFeType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='infNFeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='infNFeType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='infNFeType'):
        if self.versao is not None and 'versao' not in already_processed:
            already_processed.add('versao')
            outfile.write(' versao=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.versao), input_name='versao')), ))
        if self.Id is not None and 'Id' not in already_processed:
            already_processed.add('Id')
            outfile.write(' Id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.Id), input_name='Id')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='infNFeType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ide is not None:
            namespaceprefix_ = self.ide_nsprefix_ + ':' if (UseCapturedNS_ and self.ide_nsprefix_) else ''
            self.ide.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ide', pretty_print=pretty_print)
        if self.emit is not None:
            namespaceprefix_ = self.emit_nsprefix_ + ':' if (UseCapturedNS_ and self.emit_nsprefix_) else ''
            self.emit.export(outfile, level, namespaceprefix_, namespacedef_='', name_='emit', pretty_print=pretty_print)
        if self.avulsa is not None:
            namespaceprefix_ = self.avulsa_nsprefix_ + ':' if (UseCapturedNS_ and self.avulsa_nsprefix_) else ''
            self.avulsa.export(outfile, level, namespaceprefix_, namespacedef_='', name_='avulsa', pretty_print=pretty_print)
        if self.dest is not None:
            namespaceprefix_ = self.dest_nsprefix_ + ':' if (UseCapturedNS_ and self.dest_nsprefix_) else ''
            self.dest.export(outfile, level, namespaceprefix_, namespacedef_='', name_='dest', pretty_print=pretty_print)
        if self.retirada is not None:
            namespaceprefix_ = self.retirada_nsprefix_ + ':' if (UseCapturedNS_ and self.retirada_nsprefix_) else ''
            self.retirada.export(outfile, level, namespaceprefix_, namespacedef_='', name_='retirada', pretty_print=pretty_print)
        if self.entrega is not None:
            namespaceprefix_ = self.entrega_nsprefix_ + ':' if (UseCapturedNS_ and self.entrega_nsprefix_) else ''
            self.entrega.export(outfile, level, namespaceprefix_, namespacedef_='', name_='entrega', pretty_print=pretty_print)
        for det_ in self.det:
            namespaceprefix_ = self.det_nsprefix_ + ':' if (UseCapturedNS_ and self.det_nsprefix_) else ''
            det_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='det', pretty_print=pretty_print)
        if self.total is not None:
            namespaceprefix_ = self.total_nsprefix_ + ':' if (UseCapturedNS_ and self.total_nsprefix_) else ''
            self.total.export(outfile, level, namespaceprefix_, namespacedef_='', name_='total', pretty_print=pretty_print)
        if self.transp is not None:
            namespaceprefix_ = self.transp_nsprefix_ + ':' if (UseCapturedNS_ and self.transp_nsprefix_) else ''
            self.transp.export(outfile, level, namespaceprefix_, namespacedef_='', name_='transp', pretty_print=pretty_print)
        if self.cobr is not None:
            namespaceprefix_ = self.cobr_nsprefix_ + ':' if (UseCapturedNS_ and self.cobr_nsprefix_) else ''
            self.cobr.export(outfile, level, namespaceprefix_, namespacedef_='', name_='cobr', pretty_print=pretty_print)
        if self.infAdic is not None:
            namespaceprefix_ = self.infAdic_nsprefix_ + ':' if (UseCapturedNS_ and self.infAdic_nsprefix_) else ''
            self.infAdic.export(outfile, level, namespaceprefix_, namespacedef_='', name_='infAdic', pretty_print=pretty_print)
        if self.exporta is not None:
            namespaceprefix_ = self.exporta_nsprefix_ + ':' if (UseCapturedNS_ and self.exporta_nsprefix_) else ''
            self.exporta.export(outfile, level, namespaceprefix_, namespacedef_='', name_='exporta', pretty_print=pretty_print)
        if self.compra is not None:
            namespaceprefix_ = self.compra_nsprefix_ + ':' if (UseCapturedNS_ and self.compra_nsprefix_) else ''
            self.compra.export(outfile, level, namespaceprefix_, namespacedef_='', name_='compra', pretty_print=pretty_print)
        if self.cana is not None:
            namespaceprefix_ = self.cana_nsprefix_ + ':' if (UseCapturedNS_ and self.cana_nsprefix_) else ''
            self.cana.export(outfile, level, namespaceprefix_, namespacedef_='', name_='cana', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('versao', node)
        if value is not None and 'versao' not in already_processed:
            already_processed.add('versao')
            self.versao = value
            self.validate_TVerNFe(self.versao)    # validate type TVerNFe
        value = find_attr_value_('Id', node)
        if value is not None and 'Id' not in already_processed:
            already_processed.add('Id')
            self.Id = value
            self.validate_IdType(self.Id)    # validate type IdType
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ide':
            obj_ = ideType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ide = obj_
            obj_.original_tagname_ = 'ide'
        elif nodeName_ == 'emit':
            obj_ = emitType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.emit = obj_
            obj_.original_tagname_ = 'emit'
        elif nodeName_ == 'avulsa':
            obj_ = avulsaType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.avulsa = obj_
            obj_.original_tagname_ = 'avulsa'
        elif nodeName_ == 'dest':
            obj_ = destType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.dest = obj_
            obj_.original_tagname_ = 'dest'
        elif nodeName_ == 'retirada':
            obj_ = TLocal.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.retirada = obj_
            obj_.original_tagname_ = 'retirada'
        elif nodeName_ == 'entrega':
            obj_ = TLocal.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.entrega = obj_
            obj_.original_tagname_ = 'entrega'
        elif nodeName_ == 'det':
            obj_ = detType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.det.append(obj_)
            obj_.original_tagname_ = 'det'
        elif nodeName_ == 'total':
            obj_ = totalType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.total = obj_
            obj_.original_tagname_ = 'total'
        elif nodeName_ == 'transp':
            obj_ = transpType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.transp = obj_
            obj_.original_tagname_ = 'transp'
        elif nodeName_ == 'cobr':
            obj_ = cobrType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.cobr = obj_
            obj_.original_tagname_ = 'cobr'
        elif nodeName_ == 'infAdic':
            obj_ = infAdicType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.infAdic = obj_
            obj_.original_tagname_ = 'infAdic'
        elif nodeName_ == 'exporta':
            obj_ = exportaType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.exporta = obj_
            obj_.original_tagname_ = 'exporta'
        elif nodeName_ == 'compra':
            obj_ = compraType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.compra = obj_
            obj_.original_tagname_ = 'compra'
        elif nodeName_ == 'cana':
            obj_ = canaType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.cana = obj_
            obj_.original_tagname_ = 'cana'
# end class infNFeType


class ideType(GeneratedsSuper):
    """identificação da NF-eNT2011/004Informar apenas
    para tpEmis diferente de 1"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('cUF', ['TCodUfIBGE', 'xs:string'], 0, 0, {'name': 'cUF', 'type': 'xs:string'}, None),
        MemberSpec_('cNF', ['cNFType', 'xs:string'], 0, 0, {'name': 'cNF', 'type': 'xs:string'}, None),
        MemberSpec_('natOp', ['natOpType', 'TString', 'xs:string'], 0, 0, {'name': 'natOp', 'type': 'xs:string'}, None),
        MemberSpec_('indPag', ['indPagType', 'xs:string'], 0, 0, {'name': 'indPag', 'type': 'xs:string'}, None),
        MemberSpec_('mod', ['TMod', 'xs:string'], 0, 0, {'name': 'mod', 'type': 'xs:string'}, None),
        MemberSpec_('serie', ['TSerie', 'xs:string'], 0, 0, {'name': 'serie', 'type': 'xs:string'}, None),
        MemberSpec_('nNF', ['TNF', 'xs:string'], 0, 0, {'name': 'nNF', 'type': 'xs:string'}, None),
        MemberSpec_('dEmi', ['TData', 'xs:string'], 0, 0, {'name': 'dEmi', 'type': 'xs:string'}, None),
        MemberSpec_('dSaiEnt', ['TData', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'dSaiEnt', 'type': 'xs:string'}, None),
        MemberSpec_('hSaiEnt', ['TTime', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'hSaiEnt', 'type': 'xs:string'}, None),
        MemberSpec_('tpNF', ['tpNFType', 'xs:string'], 0, 0, {'name': 'tpNF', 'type': 'xs:string'}, None),
        MemberSpec_('cMunFG', ['TCodMunIBGE', 'xs:string'], 0, 0, {'name': 'cMunFG', 'type': 'xs:string'}, None),
        MemberSpec_('NFref', 'NFrefType', 1, 1, {'maxOccurs': '500', 'minOccurs': '0', 'name': 'NFref', 'type': 'NFrefType'}, None),
        MemberSpec_('tpImp', ['tpImpType', 'xs:string'], 0, 0, {'name': 'tpImp', 'type': 'xs:string'}, None),
        MemberSpec_('tpEmis', ['tpEmisType', 'xs:string'], 0, 0, {'name': 'tpEmis', 'type': 'xs:string'}, None),
        MemberSpec_('cDV', ['cDVType', 'xs:string'], 0, 0, {'name': 'cDV', 'type': 'xs:string'}, None),
        MemberSpec_('tpAmb', ['TAmb', 'xs:string'], 0, 0, {'name': 'tpAmb', 'type': 'xs:string'}, None),
        MemberSpec_('finNFe', ['TFinNFe', 'xs:string'], 0, 0, {'name': 'finNFe', 'type': 'xs:string'}, None),
        MemberSpec_('procEmi', ['TProcEmi', 'xs:string'], 0, 0, {'name': 'procEmi', 'type': 'xs:string'}, None),
        MemberSpec_('verProc', ['verProcType', 'TString', 'xs:string'], 0, 0, {'name': 'verProc', 'type': 'xs:string'}, None),
        MemberSpec_('dhCont', ['dhContType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'dhCont', 'type': 'xs:string'}, None),
        MemberSpec_('xJust', ['xJustType', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'xJust', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, cUF=None, cNF=None, natOp=None, indPag=None, mod=None, serie=None, nNF=None, dEmi=None, dSaiEnt=None, hSaiEnt=None, tpNF=None, cMunFG=None, NFref=None, tpImp=None, tpEmis=None, cDV=None, tpAmb=None, finNFe=None, procEmi=None, verProc=None, dhCont=None, xJust=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.cUF = cUF
        self.validate_TCodUfIBGE(self.cUF)
        self.cUF_nsprefix_ = None
        self.cNF = cNF
        self.validate_cNFType(self.cNF)
        self.cNF_nsprefix_ = None
        self.natOp = natOp
        self.validate_natOpType(self.natOp)
        self.natOp_nsprefix_ = None
        self.indPag = indPag
        self.validate_indPagType(self.indPag)
        self.indPag_nsprefix_ = None
        self.mod = mod
        self.validate_TMod(self.mod)
        self.mod_nsprefix_ = None
        self.serie = serie
        self.validate_TSerie(self.serie)
        self.serie_nsprefix_ = None
        self.nNF = nNF
        self.validate_TNF(self.nNF)
        self.nNF_nsprefix_ = None
        self.dEmi = dEmi
        self.validate_TData(self.dEmi)
        self.dEmi_nsprefix_ = None
        self.dSaiEnt = dSaiEnt
        self.validate_TData(self.dSaiEnt)
        self.dSaiEnt_nsprefix_ = None
        self.hSaiEnt = hSaiEnt
        self.validate_TTime(self.hSaiEnt)
        self.hSaiEnt_nsprefix_ = None
        self.tpNF = tpNF
        self.validate_tpNFType(self.tpNF)
        self.tpNF_nsprefix_ = None
        self.cMunFG = cMunFG
        self.validate_TCodMunIBGE(self.cMunFG)
        self.cMunFG_nsprefix_ = None
        if NFref is None:
            self.NFref = []
        else:
            self.NFref = NFref
        self.NFref_nsprefix_ = None
        self.tpImp = tpImp
        self.validate_tpImpType(self.tpImp)
        self.tpImp_nsprefix_ = None
        self.tpEmis = tpEmis
        self.validate_tpEmisType(self.tpEmis)
        self.tpEmis_nsprefix_ = None
        self.cDV = cDV
        self.validate_cDVType(self.cDV)
        self.cDV_nsprefix_ = None
        self.tpAmb = tpAmb
        self.validate_TAmb(self.tpAmb)
        self.tpAmb_nsprefix_ = None
        self.finNFe = finNFe
        self.validate_TFinNFe(self.finNFe)
        self.finNFe_nsprefix_ = None
        self.procEmi = procEmi
        self.validate_TProcEmi(self.procEmi)
        self.procEmi_nsprefix_ = None
        self.verProc = verProc
        self.validate_verProcType(self.verProc)
        self.verProc_nsprefix_ = None
        self.dhCont = dhCont
        self.validate_dhContType(self.dhCont)
        self.dhCont_nsprefix_ = None
        self.xJust = xJust
        self.validate_xJustType(self.xJust)
        self.xJust_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ideType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ideType.subclass:
            return ideType.subclass(*args_, **kwargs_)
        else:
            return ideType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TCodUfIBGE(self, value):
        result = True
        # Validate type TCodUfIBGE, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['11', '12', '13', '14', '15', '16', '17', '21', '22', '23', '24', '25', '26', '27', '28', '29', '31', '32', '33', '35', '41', '42', '43', '50', '51', '52', '53']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TCodUfIBGE' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_cNFType(self, value):
        result = True
        # Validate type cNFType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_cNFType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cNFType_patterns_, ))
                result = False
        return result
    validate_cNFType_patterns_ = [['^([0-9]{8})$']]
    def validate_natOpType(self, value):
        result = True
        # Validate type natOpType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on natOpType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on natOpType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_natOpType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_natOpType_patterns_, ))
                result = False
        return result
    validate_natOpType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_indPagType(self, value):
        result = True
        # Validate type indPagType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on indPagType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TMod(self, value):
        result = True
        # Validate type TMod, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['55']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TMod' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TSerie(self, value):
        result = True
        # Validate type TSerie, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TSerie_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TSerie_patterns_, ))
                result = False
        return result
    validate_TSerie_patterns_ = [['^(0|[1-9]{1}[0-9]{0,2})$']]
    def validate_TNF(self, value):
        result = True
        # Validate type TNF, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TNF_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TNF_patterns_, ))
                result = False
        return result
    validate_TNF_patterns_ = [['^([1-9]{1}[0-9]{0,8})$']]
    def validate_TData(self, value):
        result = True
        # Validate type TData, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TData_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TData_patterns_, ))
                result = False
        return result
    validate_TData_patterns_ = [['^((((20(([02468][048])|([13579][26]))-02-29))|(20[0-9][0-9])-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\\d)|(2[0-8])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30))))))$']]
    def validate_TTime(self, value):
        result = True
        # Validate type TTime, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TTime_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TTime_patterns_, ))
                result = False
        return result
    validate_TTime_patterns_ = [['^((([0-1][0-9])|([2][0-3])):([0-5][0-9]):([0-5][0-9]))$']]
    def validate_tpNFType(self, value):
        result = True
        # Validate type tpNFType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on tpNFType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TCodMunIBGE(self, value):
        result = True
        # Validate type TCodMunIBGE, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCodMunIBGE_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCodMunIBGE_patterns_, ))
                result = False
        return result
    validate_TCodMunIBGE_patterns_ = [['^([0-9]{7})$']]
    def validate_tpImpType(self, value):
        result = True
        # Validate type tpImpType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['1', '2']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on tpImpType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_tpEmisType(self, value):
        result = True
        # Validate type tpEmisType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['1', '2', '3', '4', '5', '6', '7']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on tpEmisType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_cDVType(self, value):
        result = True
        # Validate type cDVType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_cDVType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cDVType_patterns_, ))
                result = False
        return result
    validate_cDVType_patterns_ = [['^([0-9]{1})$']]
    def validate_TAmb(self, value):
        result = True
        # Validate type TAmb, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['1', '2']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TAmb' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TFinNFe(self, value):
        result = True
        # Validate type TFinNFe, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['1', '2', '3']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TFinNFe' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TProcEmi(self, value):
        result = True
        # Validate type TProcEmi, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TProcEmi' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_verProcType(self, value):
        result = True
        # Validate type verProcType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 20:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on verProcType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on verProcType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_verProcType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_verProcType_patterns_, ))
                result = False
        return result
    validate_verProcType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_dhContType(self, value):
        result = True
        # Validate type dhContType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_dhContType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_dhContType_patterns_, ))
                result = False
        return result
    validate_dhContType_patterns_ = [['^((((20(([02468][048])|([13579][26]))-02-29))|(20[0-9][0-9])-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\\d)|(2[0-8])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T(20|21|22|23|[0-1]\\d):[0-5]\\d:[0-5]\\d)$']]
    def validate_xJustType(self, value):
        result = True
        # Validate type xJustType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 256:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xJustType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 15:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xJustType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xJustType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xJustType_patterns_, ))
                result = False
        return result
    validate_xJustType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def hasContent_(self):
        if (
            self.cUF is not None or
            self.cNF is not None or
            self.natOp is not None or
            self.indPag is not None or
            self.mod is not None or
            self.serie is not None or
            self.nNF is not None or
            self.dEmi is not None or
            self.dSaiEnt is not None or
            self.hSaiEnt is not None or
            self.tpNF is not None or
            self.cMunFG is not None or
            self.NFref or
            self.tpImp is not None or
            self.tpEmis is not None or
            self.cDV is not None or
            self.tpAmb is not None or
            self.finNFe is not None or
            self.procEmi is not None or
            self.verProc is not None or
            self.dhCont is not None or
            self.xJust is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ideType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ideType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ideType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ideType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ideType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ideType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ideType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.cUF is not None:
            namespaceprefix_ = self.cUF_nsprefix_ + ':' if (UseCapturedNS_ and self.cUF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scUF>%s</%scUF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cUF), input_name='cUF')), namespaceprefix_ , eol_))
        if self.cNF is not None:
            namespaceprefix_ = self.cNF_nsprefix_ + ':' if (UseCapturedNS_ and self.cNF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scNF>%s</%scNF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cNF), input_name='cNF')), namespaceprefix_ , eol_))
        if self.natOp is not None:
            namespaceprefix_ = self.natOp_nsprefix_ + ':' if (UseCapturedNS_ and self.natOp_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snatOp>%s</%snatOp>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.natOp), input_name='natOp')), namespaceprefix_ , eol_))
        if self.indPag is not None:
            namespaceprefix_ = self.indPag_nsprefix_ + ':' if (UseCapturedNS_ and self.indPag_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sindPag>%s</%sindPag>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.indPag), input_name='indPag')), namespaceprefix_ , eol_))
        if self.mod is not None:
            namespaceprefix_ = self.mod_nsprefix_ + ':' if (UseCapturedNS_ and self.mod_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smod>%s</%smod>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.mod), input_name='mod')), namespaceprefix_ , eol_))
        if self.serie is not None:
            namespaceprefix_ = self.serie_nsprefix_ + ':' if (UseCapturedNS_ and self.serie_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sserie>%s</%sserie>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.serie), input_name='serie')), namespaceprefix_ , eol_))
        if self.nNF is not None:
            namespaceprefix_ = self.nNF_nsprefix_ + ':' if (UseCapturedNS_ and self.nNF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snNF>%s</%snNF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nNF), input_name='nNF')), namespaceprefix_ , eol_))
        if self.dEmi is not None:
            namespaceprefix_ = self.dEmi_nsprefix_ + ':' if (UseCapturedNS_ and self.dEmi_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdEmi>%s</%sdEmi>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.dEmi), input_name='dEmi')), namespaceprefix_ , eol_))
        if self.dSaiEnt is not None:
            namespaceprefix_ = self.dSaiEnt_nsprefix_ + ':' if (UseCapturedNS_ and self.dSaiEnt_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdSaiEnt>%s</%sdSaiEnt>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.dSaiEnt), input_name='dSaiEnt')), namespaceprefix_ , eol_))
        if self.hSaiEnt is not None:
            namespaceprefix_ = self.hSaiEnt_nsprefix_ + ':' if (UseCapturedNS_ and self.hSaiEnt_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%shSaiEnt>%s</%shSaiEnt>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.hSaiEnt), input_name='hSaiEnt')), namespaceprefix_ , eol_))
        if self.tpNF is not None:
            namespaceprefix_ = self.tpNF_nsprefix_ + ':' if (UseCapturedNS_ and self.tpNF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stpNF>%s</%stpNF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tpNF), input_name='tpNF')), namespaceprefix_ , eol_))
        if self.cMunFG is not None:
            namespaceprefix_ = self.cMunFG_nsprefix_ + ':' if (UseCapturedNS_ and self.cMunFG_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scMunFG>%s</%scMunFG>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cMunFG), input_name='cMunFG')), namespaceprefix_ , eol_))
        for NFref_ in self.NFref:
            namespaceprefix_ = self.NFref_nsprefix_ + ':' if (UseCapturedNS_ and self.NFref_nsprefix_) else ''
            NFref_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='NFref', pretty_print=pretty_print)
        if self.tpImp is not None:
            namespaceprefix_ = self.tpImp_nsprefix_ + ':' if (UseCapturedNS_ and self.tpImp_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stpImp>%s</%stpImp>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tpImp), input_name='tpImp')), namespaceprefix_ , eol_))
        if self.tpEmis is not None:
            namespaceprefix_ = self.tpEmis_nsprefix_ + ':' if (UseCapturedNS_ and self.tpEmis_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stpEmis>%s</%stpEmis>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tpEmis), input_name='tpEmis')), namespaceprefix_ , eol_))
        if self.cDV is not None:
            namespaceprefix_ = self.cDV_nsprefix_ + ':' if (UseCapturedNS_ and self.cDV_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scDV>%s</%scDV>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cDV), input_name='cDV')), namespaceprefix_ , eol_))
        if self.tpAmb is not None:
            namespaceprefix_ = self.tpAmb_nsprefix_ + ':' if (UseCapturedNS_ and self.tpAmb_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stpAmb>%s</%stpAmb>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tpAmb), input_name='tpAmb')), namespaceprefix_ , eol_))
        if self.finNFe is not None:
            namespaceprefix_ = self.finNFe_nsprefix_ + ':' if (UseCapturedNS_ and self.finNFe_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfinNFe>%s</%sfinNFe>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.finNFe), input_name='finNFe')), namespaceprefix_ , eol_))
        if self.procEmi is not None:
            namespaceprefix_ = self.procEmi_nsprefix_ + ':' if (UseCapturedNS_ and self.procEmi_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sprocEmi>%s</%sprocEmi>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.procEmi), input_name='procEmi')), namespaceprefix_ , eol_))
        if self.verProc is not None:
            namespaceprefix_ = self.verProc_nsprefix_ + ':' if (UseCapturedNS_ and self.verProc_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sverProc>%s</%sverProc>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.verProc), input_name='verProc')), namespaceprefix_ , eol_))
        if self.dhCont is not None:
            namespaceprefix_ = self.dhCont_nsprefix_ + ':' if (UseCapturedNS_ and self.dhCont_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdhCont>%s</%sdhCont>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.dhCont), input_name='dhCont')), namespaceprefix_ , eol_))
        if self.xJust is not None:
            namespaceprefix_ = self.xJust_nsprefix_ + ':' if (UseCapturedNS_ and self.xJust_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxJust>%s</%sxJust>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xJust), input_name='xJust')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'cUF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cUF')
            value_ = self.gds_validate_string(value_, node, 'cUF')
            self.cUF = value_
            self.cUF_nsprefix_ = child_.prefix
            # validate type TCodUfIBGE
            self.validate_TCodUfIBGE(self.cUF)
        elif nodeName_ == 'cNF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cNF')
            value_ = self.gds_validate_string(value_, node, 'cNF')
            self.cNF = value_
            self.cNF_nsprefix_ = child_.prefix
            # validate type cNFType
            self.validate_cNFType(self.cNF)
        elif nodeName_ == 'natOp':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'natOp')
            value_ = self.gds_validate_string(value_, node, 'natOp')
            self.natOp = value_
            self.natOp_nsprefix_ = child_.prefix
            # validate type natOpType
            self.validate_natOpType(self.natOp)
        elif nodeName_ == 'indPag':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'indPag')
            value_ = self.gds_validate_string(value_, node, 'indPag')
            self.indPag = value_
            self.indPag_nsprefix_ = child_.prefix
            # validate type indPagType
            self.validate_indPagType(self.indPag)
        elif nodeName_ == 'mod':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'mod')
            value_ = self.gds_validate_string(value_, node, 'mod')
            self.mod = value_
            self.mod_nsprefix_ = child_.prefix
            # validate type TMod
            self.validate_TMod(self.mod)
        elif nodeName_ == 'serie':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'serie')
            value_ = self.gds_validate_string(value_, node, 'serie')
            self.serie = value_
            self.serie_nsprefix_ = child_.prefix
            # validate type TSerie
            self.validate_TSerie(self.serie)
        elif nodeName_ == 'nNF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nNF')
            value_ = self.gds_validate_string(value_, node, 'nNF')
            self.nNF = value_
            self.nNF_nsprefix_ = child_.prefix
            # validate type TNF
            self.validate_TNF(self.nNF)
        elif nodeName_ == 'dEmi':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'dEmi')
            value_ = self.gds_validate_string(value_, node, 'dEmi')
            self.dEmi = value_
            self.dEmi_nsprefix_ = child_.prefix
            # validate type TData
            self.validate_TData(self.dEmi)
        elif nodeName_ == 'dSaiEnt':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'dSaiEnt')
            value_ = self.gds_validate_string(value_, node, 'dSaiEnt')
            self.dSaiEnt = value_
            self.dSaiEnt_nsprefix_ = child_.prefix
            # validate type TData
            self.validate_TData(self.dSaiEnt)
        elif nodeName_ == 'hSaiEnt':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'hSaiEnt')
            value_ = self.gds_validate_string(value_, node, 'hSaiEnt')
            self.hSaiEnt = value_
            self.hSaiEnt_nsprefix_ = child_.prefix
            # validate type TTime
            self.validate_TTime(self.hSaiEnt)
        elif nodeName_ == 'tpNF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tpNF')
            value_ = self.gds_validate_string(value_, node, 'tpNF')
            self.tpNF = value_
            self.tpNF_nsprefix_ = child_.prefix
            # validate type tpNFType
            self.validate_tpNFType(self.tpNF)
        elif nodeName_ == 'cMunFG':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cMunFG')
            value_ = self.gds_validate_string(value_, node, 'cMunFG')
            self.cMunFG = value_
            self.cMunFG_nsprefix_ = child_.prefix
            # validate type TCodMunIBGE
            self.validate_TCodMunIBGE(self.cMunFG)
        elif nodeName_ == 'NFref':
            obj_ = NFrefType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.NFref.append(obj_)
            obj_.original_tagname_ = 'NFref'
        elif nodeName_ == 'tpImp':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tpImp')
            value_ = self.gds_validate_string(value_, node, 'tpImp')
            self.tpImp = value_
            self.tpImp_nsprefix_ = child_.prefix
            # validate type tpImpType
            self.validate_tpImpType(self.tpImp)
        elif nodeName_ == 'tpEmis':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tpEmis')
            value_ = self.gds_validate_string(value_, node, 'tpEmis')
            self.tpEmis = value_
            self.tpEmis_nsprefix_ = child_.prefix
            # validate type tpEmisType
            self.validate_tpEmisType(self.tpEmis)
        elif nodeName_ == 'cDV':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cDV')
            value_ = self.gds_validate_string(value_, node, 'cDV')
            self.cDV = value_
            self.cDV_nsprefix_ = child_.prefix
            # validate type cDVType
            self.validate_cDVType(self.cDV)
        elif nodeName_ == 'tpAmb':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tpAmb')
            value_ = self.gds_validate_string(value_, node, 'tpAmb')
            self.tpAmb = value_
            self.tpAmb_nsprefix_ = child_.prefix
            # validate type TAmb
            self.validate_TAmb(self.tpAmb)
        elif nodeName_ == 'finNFe':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'finNFe')
            value_ = self.gds_validate_string(value_, node, 'finNFe')
            self.finNFe = value_
            self.finNFe_nsprefix_ = child_.prefix
            # validate type TFinNFe
            self.validate_TFinNFe(self.finNFe)
        elif nodeName_ == 'procEmi':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'procEmi')
            value_ = self.gds_validate_string(value_, node, 'procEmi')
            self.procEmi = value_
            self.procEmi_nsprefix_ = child_.prefix
            # validate type TProcEmi
            self.validate_TProcEmi(self.procEmi)
        elif nodeName_ == 'verProc':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'verProc')
            value_ = self.gds_validate_string(value_, node, 'verProc')
            self.verProc = value_
            self.verProc_nsprefix_ = child_.prefix
            # validate type verProcType
            self.validate_verProcType(self.verProc)
        elif nodeName_ == 'dhCont':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'dhCont')
            value_ = self.gds_validate_string(value_, node, 'dhCont')
            self.dhCont = value_
            self.dhCont_nsprefix_ = child_.prefix
            # validate type dhContType
            self.validate_dhContType(self.dhCont)
        elif nodeName_ == 'xJust':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xJust')
            value_ = self.gds_validate_string(value_, node, 'xJust')
            self.xJust = value_
            self.xJust_nsprefix_ = child_.prefix
            # validate type xJustType
            self.validate_xJustType(self.xJust)
# end class ideType


class NFrefType(GeneratedsSuper):
    """Grupo de infromações da NF referenciada"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('refNFe', ['TChNFe', 'xs:string'], 0, 0, {'name': 'refNFe', 'type': 'xs:string'}, 2),
        MemberSpec_('refNF', 'refNFType', 0, 0, {'name': 'refNF', 'type': 'refNFType'}, 2),
        MemberSpec_('refNFP', 'refNFPType', 0, 0, {'name': 'refNFP', 'type': 'refNFPType'}, 2),
        MemberSpec_('refCTe', ['TChNFe', 'xs:string'], 0, 0, {'name': 'refCTe', 'type': 'xs:string'}, 2),
        MemberSpec_('refECF', 'refECFType', 0, 0, {'name': 'refECF', 'type': 'refECFType'}, 2),
    ]
    subclass = None
    superclass = None
    def __init__(self, refNFe=None, refNF=None, refNFP=None, refCTe=None, refECF=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.refNFe = refNFe
        self.validate_TChNFe(self.refNFe)
        self.refNFe_nsprefix_ = None
        self.refNF = refNF
        self.refNF_nsprefix_ = None
        self.refNFP = refNFP
        self.refNFP_nsprefix_ = None
        self.refCTe = refCTe
        self.validate_TChNFe(self.refCTe)
        self.refCTe_nsprefix_ = None
        self.refECF = refECF
        self.refECF_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NFrefType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NFrefType.subclass:
            return NFrefType.subclass(*args_, **kwargs_)
        else:
            return NFrefType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TChNFe(self, value):
        result = True
        # Validate type TChNFe, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TChNFe_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TChNFe_patterns_, ))
                result = False
        return result
    validate_TChNFe_patterns_ = [['^([0-9]{44})$']]
    def hasContent_(self):
        if (
            self.refNFe is not None or
            self.refNF is not None or
            self.refNFP is not None or
            self.refCTe is not None or
            self.refECF is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='NFrefType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('NFrefType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'NFrefType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='NFrefType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='NFrefType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='NFrefType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='NFrefType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.refNFe is not None:
            namespaceprefix_ = self.refNFe_nsprefix_ + ':' if (UseCapturedNS_ and self.refNFe_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srefNFe>%s</%srefNFe>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.refNFe), input_name='refNFe')), namespaceprefix_ , eol_))
        if self.refNF is not None:
            namespaceprefix_ = self.refNF_nsprefix_ + ':' if (UseCapturedNS_ and self.refNF_nsprefix_) else ''
            self.refNF.export(outfile, level, namespaceprefix_, namespacedef_='', name_='refNF', pretty_print=pretty_print)
        if self.refNFP is not None:
            namespaceprefix_ = self.refNFP_nsprefix_ + ':' if (UseCapturedNS_ and self.refNFP_nsprefix_) else ''
            self.refNFP.export(outfile, level, namespaceprefix_, namespacedef_='', name_='refNFP', pretty_print=pretty_print)
        if self.refCTe is not None:
            namespaceprefix_ = self.refCTe_nsprefix_ + ':' if (UseCapturedNS_ and self.refCTe_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srefCTe>%s</%srefCTe>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.refCTe), input_name='refCTe')), namespaceprefix_ , eol_))
        if self.refECF is not None:
            namespaceprefix_ = self.refECF_nsprefix_ + ':' if (UseCapturedNS_ and self.refECF_nsprefix_) else ''
            self.refECF.export(outfile, level, namespaceprefix_, namespacedef_='', name_='refECF', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'refNFe':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'refNFe')
            value_ = self.gds_validate_string(value_, node, 'refNFe')
            self.refNFe = value_
            self.refNFe_nsprefix_ = child_.prefix
            # validate type TChNFe
            self.validate_TChNFe(self.refNFe)
        elif nodeName_ == 'refNF':
            obj_ = refNFType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.refNF = obj_
            obj_.original_tagname_ = 'refNF'
        elif nodeName_ == 'refNFP':
            obj_ = refNFPType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.refNFP = obj_
            obj_.original_tagname_ = 'refNFP'
        elif nodeName_ == 'refCTe':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'refCTe')
            value_ = self.gds_validate_string(value_, node, 'refCTe')
            self.refCTe = value_
            self.refCTe_nsprefix_ = child_.prefix
            # validate type TChNFe
            self.validate_TChNFe(self.refCTe)
        elif nodeName_ == 'refECF':
            obj_ = refECFType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.refECF = obj_
            obj_.original_tagname_ = 'refECF'
# end class NFrefType


class refNFType(GeneratedsSuper):
    """Dados da NF modelo 1/1A referenciada"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('cUF', ['TCodUfIBGE', 'xs:string'], 0, 0, {'name': 'cUF', 'type': 'xs:string'}, None),
        MemberSpec_('AAMM', ['AAMMType', 'xs:string'], 0, 0, {'name': 'AAMM', 'type': 'xs:string'}, None),
        MemberSpec_('CNPJ', ['TCnpj', 'xs:string'], 0, 0, {'name': 'CNPJ', 'type': 'xs:string'}, None),
        MemberSpec_('mod', ['modType', 'xs:string'], 0, 0, {'name': 'mod', 'type': 'xs:string'}, None),
        MemberSpec_('serie', ['TSerie', 'xs:string'], 0, 0, {'name': 'serie', 'type': 'xs:string'}, None),
        MemberSpec_('nNF', ['TNF', 'xs:string'], 0, 0, {'name': 'nNF', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, cUF=None, AAMM=None, CNPJ=None, mod=None, serie=None, nNF=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.cUF = cUF
        self.validate_TCodUfIBGE(self.cUF)
        self.cUF_nsprefix_ = None
        self.AAMM = AAMM
        self.validate_AAMMType(self.AAMM)
        self.AAMM_nsprefix_ = None
        self.CNPJ = CNPJ
        self.validate_TCnpj(self.CNPJ)
        self.CNPJ_nsprefix_ = None
        self.mod = mod
        self.validate_modType(self.mod)
        self.mod_nsprefix_ = None
        self.serie = serie
        self.validate_TSerie(self.serie)
        self.serie_nsprefix_ = None
        self.nNF = nNF
        self.validate_TNF(self.nNF)
        self.nNF_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, refNFType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if refNFType.subclass:
            return refNFType.subclass(*args_, **kwargs_)
        else:
            return refNFType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TCodUfIBGE(self, value):
        result = True
        # Validate type TCodUfIBGE, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['11', '12', '13', '14', '15', '16', '17', '21', '22', '23', '24', '25', '26', '27', '28', '29', '31', '32', '33', '35', '41', '42', '43', '50', '51', '52', '53']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TCodUfIBGE' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_AAMMType(self, value):
        result = True
        # Validate type AAMMType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_AAMMType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_AAMMType_patterns_, ))
                result = False
        return result
    validate_AAMMType_patterns_ = [['^([0-9]{2}[0]{1}[1-9]{1}|[0-9]{2}[1]{1}[0-2]{1})$']]
    def validate_TCnpj(self, value):
        result = True
        # Validate type TCnpj, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCnpj_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCnpj_patterns_, ))
                result = False
        return result
    validate_TCnpj_patterns_ = [['^([0-9]{14})$']]
    def validate_modType(self, value):
        result = True
        # Validate type modType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['01']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on modType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TSerie(self, value):
        result = True
        # Validate type TSerie, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TSerie_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TSerie_patterns_, ))
                result = False
        return result
    validate_TSerie_patterns_ = [['^(0|[1-9]{1}[0-9]{0,2})$']]
    def validate_TNF(self, value):
        result = True
        # Validate type TNF, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TNF_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TNF_patterns_, ))
                result = False
        return result
    validate_TNF_patterns_ = [['^([1-9]{1}[0-9]{0,8})$']]
    def hasContent_(self):
        if (
            self.cUF is not None or
            self.AAMM is not None or
            self.CNPJ is not None or
            self.mod is not None or
            self.serie is not None or
            self.nNF is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='refNFType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('refNFType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'refNFType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='refNFType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='refNFType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='refNFType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='refNFType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.cUF is not None:
            namespaceprefix_ = self.cUF_nsprefix_ + ':' if (UseCapturedNS_ and self.cUF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scUF>%s</%scUF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cUF), input_name='cUF')), namespaceprefix_ , eol_))
        if self.AAMM is not None:
            namespaceprefix_ = self.AAMM_nsprefix_ + ':' if (UseCapturedNS_ and self.AAMM_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAAMM>%s</%sAAMM>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.AAMM), input_name='AAMM')), namespaceprefix_ , eol_))
        if self.CNPJ is not None:
            namespaceprefix_ = self.CNPJ_nsprefix_ + ':' if (UseCapturedNS_ and self.CNPJ_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCNPJ>%s</%sCNPJ>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CNPJ), input_name='CNPJ')), namespaceprefix_ , eol_))
        if self.mod is not None:
            namespaceprefix_ = self.mod_nsprefix_ + ':' if (UseCapturedNS_ and self.mod_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smod>%s</%smod>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.mod), input_name='mod')), namespaceprefix_ , eol_))
        if self.serie is not None:
            namespaceprefix_ = self.serie_nsprefix_ + ':' if (UseCapturedNS_ and self.serie_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sserie>%s</%sserie>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.serie), input_name='serie')), namespaceprefix_ , eol_))
        if self.nNF is not None:
            namespaceprefix_ = self.nNF_nsprefix_ + ':' if (UseCapturedNS_ and self.nNF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snNF>%s</%snNF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nNF), input_name='nNF')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'cUF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cUF')
            value_ = self.gds_validate_string(value_, node, 'cUF')
            self.cUF = value_
            self.cUF_nsprefix_ = child_.prefix
            # validate type TCodUfIBGE
            self.validate_TCodUfIBGE(self.cUF)
        elif nodeName_ == 'AAMM':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'AAMM')
            value_ = self.gds_validate_string(value_, node, 'AAMM')
            self.AAMM = value_
            self.AAMM_nsprefix_ = child_.prefix
            # validate type AAMMType
            self.validate_AAMMType(self.AAMM)
        elif nodeName_ == 'CNPJ':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CNPJ')
            value_ = self.gds_validate_string(value_, node, 'CNPJ')
            self.CNPJ = value_
            self.CNPJ_nsprefix_ = child_.prefix
            # validate type TCnpj
            self.validate_TCnpj(self.CNPJ)
        elif nodeName_ == 'mod':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'mod')
            value_ = self.gds_validate_string(value_, node, 'mod')
            self.mod = value_
            self.mod_nsprefix_ = child_.prefix
            # validate type modType
            self.validate_modType(self.mod)
        elif nodeName_ == 'serie':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'serie')
            value_ = self.gds_validate_string(value_, node, 'serie')
            self.serie = value_
            self.serie_nsprefix_ = child_.prefix
            # validate type TSerie
            self.validate_TSerie(self.serie)
        elif nodeName_ == 'nNF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nNF')
            value_ = self.gds_validate_string(value_, node, 'nNF')
            self.nNF = value_
            self.nNF_nsprefix_ = child_.prefix
            # validate type TNF
            self.validate_TNF(self.nNF)
# end class refNFType


class refNFPType(GeneratedsSuper):
    """Grupo com as informações NF de produtor referenciada (v2.0)"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('cUF', ['TCodUfIBGE', 'xs:string'], 0, 0, {'name': 'cUF', 'type': 'xs:string'}, None),
        MemberSpec_('AAMM', ['AAMMType1', 'xs:string'], 0, 0, {'name': 'AAMM', 'type': 'xs:string'}, None),
        MemberSpec_('CNPJ', ['TCnpj', 'xs:string'], 0, 0, {'name': 'CNPJ', 'type': 'xs:string'}, 3),
        MemberSpec_('CPF', ['TCpf', 'xs:string'], 0, 0, {'name': 'CPF', 'type': 'xs:string'}, 3),
        MemberSpec_('IE', ['TIeDest', 'xs:string'], 0, 0, {'name': 'IE', 'type': 'xs:string'}, None),
        MemberSpec_('mod', ['modType2', 'xs:string'], 0, 0, {'name': 'mod', 'type': 'xs:string'}, None),
        MemberSpec_('serie', ['TSerie', 'xs:string'], 0, 0, {'name': 'serie', 'type': 'xs:string'}, None),
        MemberSpec_('nNF', ['TNF', 'xs:string'], 0, 0, {'name': 'nNF', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, cUF=None, AAMM=None, CNPJ=None, CPF=None, IE=None, mod=None, serie=None, nNF=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.cUF = cUF
        self.validate_TCodUfIBGE(self.cUF)
        self.cUF_nsprefix_ = None
        self.AAMM = AAMM
        self.validate_AAMMType1(self.AAMM)
        self.AAMM_nsprefix_ = None
        self.CNPJ = CNPJ
        self.validate_TCnpj(self.CNPJ)
        self.CNPJ_nsprefix_ = None
        self.CPF = CPF
        self.validate_TCpf(self.CPF)
        self.CPF_nsprefix_ = None
        self.IE = IE
        self.validate_TIeDest(self.IE)
        self.IE_nsprefix_ = None
        self.mod = mod
        self.validate_modType2(self.mod)
        self.mod_nsprefix_ = None
        self.serie = serie
        self.validate_TSerie(self.serie)
        self.serie_nsprefix_ = None
        self.nNF = nNF
        self.validate_TNF(self.nNF)
        self.nNF_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, refNFPType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if refNFPType.subclass:
            return refNFPType.subclass(*args_, **kwargs_)
        else:
            return refNFPType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TCodUfIBGE(self, value):
        result = True
        # Validate type TCodUfIBGE, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['11', '12', '13', '14', '15', '16', '17', '21', '22', '23', '24', '25', '26', '27', '28', '29', '31', '32', '33', '35', '41', '42', '43', '50', '51', '52', '53']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TCodUfIBGE' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_AAMMType1(self, value):
        result = True
        # Validate type AAMMType1, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_AAMMType1_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_AAMMType1_patterns_, ))
                result = False
        return result
    validate_AAMMType1_patterns_ = [['^([0-9]{2}[0]{1}[1-9]{1}|[0-9]{2}[1]{1}[0-2]{1})$']]
    def validate_TCnpj(self, value):
        result = True
        # Validate type TCnpj, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCnpj_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCnpj_patterns_, ))
                result = False
        return result
    validate_TCnpj_patterns_ = [['^([0-9]{14})$']]
    def validate_TCpf(self, value):
        result = True
        # Validate type TCpf, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCpf_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCpf_patterns_, ))
                result = False
        return result
    validate_TCpf_patterns_ = [['^([0-9]{11})$']]
    def validate_TIeDest(self, value):
        result = True
        # Validate type TIeDest, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TIeDest_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TIeDest_patterns_, ))
                result = False
        return result
    validate_TIeDest_patterns_ = [['^(ISENTO|[0-9]{0,14})$']]
    def validate_modType2(self, value):
        result = True
        # Validate type modType2, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['01', '04']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on modType2' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TSerie(self, value):
        result = True
        # Validate type TSerie, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TSerie_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TSerie_patterns_, ))
                result = False
        return result
    validate_TSerie_patterns_ = [['^(0|[1-9]{1}[0-9]{0,2})$']]
    def validate_TNF(self, value):
        result = True
        # Validate type TNF, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TNF_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TNF_patterns_, ))
                result = False
        return result
    validate_TNF_patterns_ = [['^([1-9]{1}[0-9]{0,8})$']]
    def hasContent_(self):
        if (
            self.cUF is not None or
            self.AAMM is not None or
            self.CNPJ is not None or
            self.CPF is not None or
            self.IE is not None or
            self.mod is not None or
            self.serie is not None or
            self.nNF is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='refNFPType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('refNFPType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'refNFPType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='refNFPType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='refNFPType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='refNFPType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='refNFPType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.cUF is not None:
            namespaceprefix_ = self.cUF_nsprefix_ + ':' if (UseCapturedNS_ and self.cUF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scUF>%s</%scUF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cUF), input_name='cUF')), namespaceprefix_ , eol_))
        if self.AAMM is not None:
            namespaceprefix_ = self.AAMM_nsprefix_ + ':' if (UseCapturedNS_ and self.AAMM_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAAMM>%s</%sAAMM>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.AAMM), input_name='AAMM')), namespaceprefix_ , eol_))
        if self.CNPJ is not None:
            namespaceprefix_ = self.CNPJ_nsprefix_ + ':' if (UseCapturedNS_ and self.CNPJ_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCNPJ>%s</%sCNPJ>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CNPJ), input_name='CNPJ')), namespaceprefix_ , eol_))
        if self.CPF is not None:
            namespaceprefix_ = self.CPF_nsprefix_ + ':' if (UseCapturedNS_ and self.CPF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCPF>%s</%sCPF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CPF), input_name='CPF')), namespaceprefix_ , eol_))
        if self.IE is not None:
            namespaceprefix_ = self.IE_nsprefix_ + ':' if (UseCapturedNS_ and self.IE_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIE>%s</%sIE>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.IE), input_name='IE')), namespaceprefix_ , eol_))
        if self.mod is not None:
            namespaceprefix_ = self.mod_nsprefix_ + ':' if (UseCapturedNS_ and self.mod_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smod>%s</%smod>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.mod), input_name='mod')), namespaceprefix_ , eol_))
        if self.serie is not None:
            namespaceprefix_ = self.serie_nsprefix_ + ':' if (UseCapturedNS_ and self.serie_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sserie>%s</%sserie>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.serie), input_name='serie')), namespaceprefix_ , eol_))
        if self.nNF is not None:
            namespaceprefix_ = self.nNF_nsprefix_ + ':' if (UseCapturedNS_ and self.nNF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snNF>%s</%snNF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nNF), input_name='nNF')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'cUF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cUF')
            value_ = self.gds_validate_string(value_, node, 'cUF')
            self.cUF = value_
            self.cUF_nsprefix_ = child_.prefix
            # validate type TCodUfIBGE
            self.validate_TCodUfIBGE(self.cUF)
        elif nodeName_ == 'AAMM':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'AAMM')
            value_ = self.gds_validate_string(value_, node, 'AAMM')
            self.AAMM = value_
            self.AAMM_nsprefix_ = child_.prefix
            # validate type AAMMType1
            self.validate_AAMMType1(self.AAMM)
        elif nodeName_ == 'CNPJ':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CNPJ')
            value_ = self.gds_validate_string(value_, node, 'CNPJ')
            self.CNPJ = value_
            self.CNPJ_nsprefix_ = child_.prefix
            # validate type TCnpj
            self.validate_TCnpj(self.CNPJ)
        elif nodeName_ == 'CPF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CPF')
            value_ = self.gds_validate_string(value_, node, 'CPF')
            self.CPF = value_
            self.CPF_nsprefix_ = child_.prefix
            # validate type TCpf
            self.validate_TCpf(self.CPF)
        elif nodeName_ == 'IE':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'IE')
            value_ = self.gds_validate_string(value_, node, 'IE')
            self.IE = value_
            self.IE_nsprefix_ = child_.prefix
            # validate type TIeDest
            self.validate_TIeDest(self.IE)
        elif nodeName_ == 'mod':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'mod')
            value_ = self.gds_validate_string(value_, node, 'mod')
            self.mod = value_
            self.mod_nsprefix_ = child_.prefix
            # validate type modType2
            self.validate_modType2(self.mod)
        elif nodeName_ == 'serie':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'serie')
            value_ = self.gds_validate_string(value_, node, 'serie')
            self.serie = value_
            self.serie_nsprefix_ = child_.prefix
            # validate type TSerie
            self.validate_TSerie(self.serie)
        elif nodeName_ == 'nNF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nNF')
            value_ = self.gds_validate_string(value_, node, 'nNF')
            self.nNF = value_
            self.nNF_nsprefix_ = child_.prefix
            # validate type TNF
            self.validate_TNF(self.nNF)
# end class refNFPType


class refECFType(GeneratedsSuper):
    """Grupo do Cupom Fiscal vinculado à NF-e (v2.0)."""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('mod', ['modType3', 'xs:string'], 0, 0, {'name': 'mod', 'type': 'xs:string'}, None),
        MemberSpec_('nECF', ['nECFType', 'xs:string'], 0, 0, {'name': 'nECF', 'type': 'xs:string'}, None),
        MemberSpec_('nCOO', ['nCOOType', 'xs:string'], 0, 0, {'name': 'nCOO', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, mod=None, nECF=None, nCOO=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.mod = mod
        self.validate_modType3(self.mod)
        self.mod_nsprefix_ = None
        self.nECF = nECF
        self.validate_nECFType(self.nECF)
        self.nECF_nsprefix_ = None
        self.nCOO = nCOO
        self.validate_nCOOType(self.nCOO)
        self.nCOO_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, refECFType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if refECFType.subclass:
            return refECFType.subclass(*args_, **kwargs_)
        else:
            return refECFType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_modType3(self, value):
        result = True
        # Validate type modType3, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['2B', '2C', '2D']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on modType3' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_nECFType(self, value):
        result = True
        # Validate type nECFType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_nECFType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nECFType_patterns_, ))
                result = False
        return result
    validate_nECFType_patterns_ = [['^([0-9]{1,3})$']]
    def validate_nCOOType(self, value):
        result = True
        # Validate type nCOOType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_nCOOType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nCOOType_patterns_, ))
                result = False
        return result
    validate_nCOOType_patterns_ = [['^([0-9]{1,6})$']]
    def hasContent_(self):
        if (
            self.mod is not None or
            self.nECF is not None or
            self.nCOO is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='refECFType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('refECFType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'refECFType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='refECFType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='refECFType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='refECFType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='refECFType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.mod is not None:
            namespaceprefix_ = self.mod_nsprefix_ + ':' if (UseCapturedNS_ and self.mod_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smod>%s</%smod>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.mod), input_name='mod')), namespaceprefix_ , eol_))
        if self.nECF is not None:
            namespaceprefix_ = self.nECF_nsprefix_ + ':' if (UseCapturedNS_ and self.nECF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snECF>%s</%snECF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nECF), input_name='nECF')), namespaceprefix_ , eol_))
        if self.nCOO is not None:
            namespaceprefix_ = self.nCOO_nsprefix_ + ':' if (UseCapturedNS_ and self.nCOO_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snCOO>%s</%snCOO>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nCOO), input_name='nCOO')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'mod':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'mod')
            value_ = self.gds_validate_string(value_, node, 'mod')
            self.mod = value_
            self.mod_nsprefix_ = child_.prefix
            # validate type modType3
            self.validate_modType3(self.mod)
        elif nodeName_ == 'nECF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nECF')
            value_ = self.gds_validate_string(value_, node, 'nECF')
            self.nECF = value_
            self.nECF_nsprefix_ = child_.prefix
            # validate type nECFType
            self.validate_nECFType(self.nECF)
        elif nodeName_ == 'nCOO':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nCOO')
            value_ = self.gds_validate_string(value_, node, 'nCOO')
            self.nCOO = value_
            self.nCOO_nsprefix_ = child_.prefix
            # validate type nCOOType
            self.validate_nCOOType(self.nCOO)
# end class refECFType


class emitType(GeneratedsSuper):
    """Identificação do emitenteGrupo de informações de interesse da
    Prefeitura"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('CNPJ', ['TCnpj', 'xs:string'], 0, 0, {'name': 'CNPJ', 'type': 'xs:string'}, 4),
        MemberSpec_('CPF', ['TCpf', 'xs:string'], 0, 0, {'name': 'CPF', 'type': 'xs:string'}, 4),
        MemberSpec_('xNome', ['xNomeType', 'TString', 'xs:string'], 0, 0, {'name': 'xNome', 'type': 'xs:string'}, None),
        MemberSpec_('xFant', ['xFantType', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'xFant', 'type': 'xs:string'}, None),
        MemberSpec_('enderEmit', 'TEnderEmi', 0, 0, {'name': 'enderEmit', 'type': 'TEnderEmi'}, None),
        MemberSpec_('IE', ['TIe', 'xs:string'], 0, 0, {'name': 'IE', 'type': 'xs:string'}, None),
        MemberSpec_('IEST', ['TIeST', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'IEST', 'type': 'xs:string'}, None),
        MemberSpec_('IM', ['IMType', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'IM', 'type': 'xs:string'}, None),
        MemberSpec_('CNAE', ['CNAEType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'CNAE', 'type': 'xs:string'}, None),
        MemberSpec_('CRT', ['CRTType', 'xs:string'], 0, 0, {'name': 'CRT', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, CNPJ=None, CPF=None, xNome=None, xFant=None, enderEmit=None, IE=None, IEST=None, IM=None, CNAE=None, CRT=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.CNPJ = CNPJ
        self.validate_TCnpj(self.CNPJ)
        self.CNPJ_nsprefix_ = None
        self.CPF = CPF
        self.validate_TCpf(self.CPF)
        self.CPF_nsprefix_ = None
        self.xNome = xNome
        self.validate_xNomeType(self.xNome)
        self.xNome_nsprefix_ = None
        self.xFant = xFant
        self.validate_xFantType(self.xFant)
        self.xFant_nsprefix_ = None
        self.enderEmit = enderEmit
        self.enderEmit_nsprefix_ = None
        self.IE = IE
        self.validate_TIe(self.IE)
        self.IE_nsprefix_ = None
        self.IEST = IEST
        self.validate_TIeST(self.IEST)
        self.IEST_nsprefix_ = None
        self.IM = IM
        self.validate_IMType(self.IM)
        self.IM_nsprefix_ = None
        self.CNAE = CNAE
        self.validate_CNAEType(self.CNAE)
        self.CNAE_nsprefix_ = None
        self.CRT = CRT
        self.validate_CRTType(self.CRT)
        self.CRT_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, emitType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if emitType.subclass:
            return emitType.subclass(*args_, **kwargs_)
        else:
            return emitType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TCnpj(self, value):
        result = True
        # Validate type TCnpj, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCnpj_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCnpj_patterns_, ))
                result = False
        return result
    validate_TCnpj_patterns_ = [['^([0-9]{14})$']]
    def validate_TCpf(self, value):
        result = True
        # Validate type TCpf, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCpf_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCpf_patterns_, ))
                result = False
        return result
    validate_TCpf_patterns_ = [['^([0-9]{11})$']]
    def validate_xNomeType(self, value):
        result = True
        # Validate type xNomeType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xNomeType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xNomeType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xNomeType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xNomeType_patterns_, ))
                result = False
        return result
    validate_xNomeType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_xFantType(self, value):
        result = True
        # Validate type xFantType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xFantType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xFantType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xFantType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xFantType_patterns_, ))
                result = False
        return result
    validate_xFantType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TIe(self, value):
        result = True
        # Validate type TIe, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TIe_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TIe_patterns_, ))
                result = False
        return result
    validate_TIe_patterns_ = [['^([0-9]{2,14}|ISENTO)$']]
    def validate_TIeST(self, value):
        result = True
        # Validate type TIeST, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TIeST_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TIeST_patterns_, ))
                result = False
        return result
    validate_TIeST_patterns_ = [['^([0-9]{2,14})$']]
    def validate_IMType(self, value):
        result = True
        # Validate type IMType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 15:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on IMType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on IMType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_IMType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_IMType_patterns_, ))
                result = False
        return result
    validate_IMType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_CNAEType(self, value):
        result = True
        # Validate type CNAEType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_CNAEType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_CNAEType_patterns_, ))
                result = False
        return result
    validate_CNAEType_patterns_ = [['^([0-9]{7})$']]
    def validate_CRTType(self, value):
        result = True
        # Validate type CRTType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['1', '2', '3']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on CRTType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def hasContent_(self):
        if (
            self.CNPJ is not None or
            self.CPF is not None or
            self.xNome is not None or
            self.xFant is not None or
            self.enderEmit is not None or
            self.IE is not None or
            self.IEST is not None or
            self.IM is not None or
            self.CNAE is not None or
            self.CRT is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='emitType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('emitType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'emitType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='emitType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='emitType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='emitType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='emitType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CNPJ is not None:
            namespaceprefix_ = self.CNPJ_nsprefix_ + ':' if (UseCapturedNS_ and self.CNPJ_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCNPJ>%s</%sCNPJ>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CNPJ), input_name='CNPJ')), namespaceprefix_ , eol_))
        if self.CPF is not None:
            namespaceprefix_ = self.CPF_nsprefix_ + ':' if (UseCapturedNS_ and self.CPF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCPF>%s</%sCPF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CPF), input_name='CPF')), namespaceprefix_ , eol_))
        if self.xNome is not None:
            namespaceprefix_ = self.xNome_nsprefix_ + ':' if (UseCapturedNS_ and self.xNome_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxNome>%s</%sxNome>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xNome), input_name='xNome')), namespaceprefix_ , eol_))
        if self.xFant is not None:
            namespaceprefix_ = self.xFant_nsprefix_ + ':' if (UseCapturedNS_ and self.xFant_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxFant>%s</%sxFant>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xFant), input_name='xFant')), namespaceprefix_ , eol_))
        if self.enderEmit is not None:
            namespaceprefix_ = self.enderEmit_nsprefix_ + ':' if (UseCapturedNS_ and self.enderEmit_nsprefix_) else ''
            self.enderEmit.export(outfile, level, namespaceprefix_, namespacedef_='', name_='enderEmit', pretty_print=pretty_print)
        if self.IE is not None:
            namespaceprefix_ = self.IE_nsprefix_ + ':' if (UseCapturedNS_ and self.IE_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIE>%s</%sIE>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.IE), input_name='IE')), namespaceprefix_ , eol_))
        if self.IEST is not None:
            namespaceprefix_ = self.IEST_nsprefix_ + ':' if (UseCapturedNS_ and self.IEST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIEST>%s</%sIEST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.IEST), input_name='IEST')), namespaceprefix_ , eol_))
        if self.IM is not None:
            namespaceprefix_ = self.IM_nsprefix_ + ':' if (UseCapturedNS_ and self.IM_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIM>%s</%sIM>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.IM), input_name='IM')), namespaceprefix_ , eol_))
        if self.CNAE is not None:
            namespaceprefix_ = self.CNAE_nsprefix_ + ':' if (UseCapturedNS_ and self.CNAE_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCNAE>%s</%sCNAE>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CNAE), input_name='CNAE')), namespaceprefix_ , eol_))
        if self.CRT is not None:
            namespaceprefix_ = self.CRT_nsprefix_ + ':' if (UseCapturedNS_ and self.CRT_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCRT>%s</%sCRT>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CRT), input_name='CRT')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CNPJ':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CNPJ')
            value_ = self.gds_validate_string(value_, node, 'CNPJ')
            self.CNPJ = value_
            self.CNPJ_nsprefix_ = child_.prefix
            # validate type TCnpj
            self.validate_TCnpj(self.CNPJ)
        elif nodeName_ == 'CPF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CPF')
            value_ = self.gds_validate_string(value_, node, 'CPF')
            self.CPF = value_
            self.CPF_nsprefix_ = child_.prefix
            # validate type TCpf
            self.validate_TCpf(self.CPF)
        elif nodeName_ == 'xNome':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xNome')
            value_ = self.gds_validate_string(value_, node, 'xNome')
            self.xNome = value_
            self.xNome_nsprefix_ = child_.prefix
            # validate type xNomeType
            self.validate_xNomeType(self.xNome)
        elif nodeName_ == 'xFant':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xFant')
            value_ = self.gds_validate_string(value_, node, 'xFant')
            self.xFant = value_
            self.xFant_nsprefix_ = child_.prefix
            # validate type xFantType
            self.validate_xFantType(self.xFant)
        elif nodeName_ == 'enderEmit':
            obj_ = TEnderEmi.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.enderEmit = obj_
            obj_.original_tagname_ = 'enderEmit'
        elif nodeName_ == 'IE':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'IE')
            value_ = self.gds_validate_string(value_, node, 'IE')
            self.IE = value_
            self.IE_nsprefix_ = child_.prefix
            # validate type TIe
            self.validate_TIe(self.IE)
        elif nodeName_ == 'IEST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'IEST')
            value_ = self.gds_validate_string(value_, node, 'IEST')
            self.IEST = value_
            self.IEST_nsprefix_ = child_.prefix
            # validate type TIeST
            self.validate_TIeST(self.IEST)
        elif nodeName_ == 'IM':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'IM')
            value_ = self.gds_validate_string(value_, node, 'IM')
            self.IM = value_
            self.IM_nsprefix_ = child_.prefix
            # validate type IMType
            self.validate_IMType(self.IM)
        elif nodeName_ == 'CNAE':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CNAE')
            value_ = self.gds_validate_string(value_, node, 'CNAE')
            self.CNAE = value_
            self.CNAE_nsprefix_ = child_.prefix
            # validate type CNAEType
            self.validate_CNAEType(self.CNAE)
        elif nodeName_ == 'CRT':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CRT')
            value_ = self.gds_validate_string(value_, node, 'CRT')
            self.CRT = value_
            self.CRT_nsprefix_ = child_.prefix
            # validate type CRTType
            self.validate_CRTType(self.CRT)
# end class emitType


class avulsaType(GeneratedsSuper):
    """Emissão de avulsa, informar os dados do Fisco emitente"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('CNPJ', ['TCnpj', 'xs:string'], 0, 0, {'name': 'CNPJ', 'type': 'xs:string'}, None),
        MemberSpec_('xOrgao', ['xOrgaoType', 'TString', 'xs:string'], 0, 0, {'name': 'xOrgao', 'type': 'xs:string'}, None),
        MemberSpec_('matr', ['matrType', 'TString', 'xs:string'], 0, 0, {'name': 'matr', 'type': 'xs:string'}, None),
        MemberSpec_('xAgente', ['xAgenteType', 'TString', 'xs:string'], 0, 0, {'name': 'xAgente', 'type': 'xs:string'}, None),
        MemberSpec_('fone', ['foneType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'fone', 'type': 'xs:string'}, None),
        MemberSpec_('UF', ['TUfEmi', 'xs:string'], 0, 0, {'name': 'UF', 'type': 'xs:string'}, None),
        MemberSpec_('nDAR', ['nDARType', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'nDAR', 'type': 'xs:string'}, None),
        MemberSpec_('dEmi', ['TData', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'dEmi', 'type': 'xs:string'}, None),
        MemberSpec_('vDAR', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vDAR', 'type': 'xs:string'}, None),
        MemberSpec_('repEmi', ['repEmiType', 'TString', 'xs:string'], 0, 0, {'name': 'repEmi', 'type': 'xs:string'}, None),
        MemberSpec_('dPag', ['TData', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'dPag', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, CNPJ=None, xOrgao=None, matr=None, xAgente=None, fone=None, UF=None, nDAR=None, dEmi=None, vDAR=None, repEmi=None, dPag=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.CNPJ = CNPJ
        self.validate_TCnpj(self.CNPJ)
        self.CNPJ_nsprefix_ = None
        self.xOrgao = xOrgao
        self.validate_xOrgaoType(self.xOrgao)
        self.xOrgao_nsprefix_ = None
        self.matr = matr
        self.validate_matrType(self.matr)
        self.matr_nsprefix_ = None
        self.xAgente = xAgente
        self.validate_xAgenteType(self.xAgente)
        self.xAgente_nsprefix_ = None
        self.fone = fone
        self.validate_foneType(self.fone)
        self.fone_nsprefix_ = None
        self.UF = UF
        self.validate_TUfEmi(self.UF)
        self.UF_nsprefix_ = None
        self.nDAR = nDAR
        self.validate_nDARType(self.nDAR)
        self.nDAR_nsprefix_ = None
        self.dEmi = dEmi
        self.validate_TData(self.dEmi)
        self.dEmi_nsprefix_ = None
        self.vDAR = vDAR
        self.validate_TDec_1302(self.vDAR)
        self.vDAR_nsprefix_ = None
        self.repEmi = repEmi
        self.validate_repEmiType(self.repEmi)
        self.repEmi_nsprefix_ = None
        self.dPag = dPag
        self.validate_TData(self.dPag)
        self.dPag_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, avulsaType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if avulsaType.subclass:
            return avulsaType.subclass(*args_, **kwargs_)
        else:
            return avulsaType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TCnpj(self, value):
        result = True
        # Validate type TCnpj, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCnpj_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCnpj_patterns_, ))
                result = False
        return result
    validate_TCnpj_patterns_ = [['^([0-9]{14})$']]
    def validate_xOrgaoType(self, value):
        result = True
        # Validate type xOrgaoType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xOrgaoType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xOrgaoType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xOrgaoType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xOrgaoType_patterns_, ))
                result = False
        return result
    validate_xOrgaoType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_matrType(self, value):
        result = True
        # Validate type matrType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on matrType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on matrType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_matrType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_matrType_patterns_, ))
                result = False
        return result
    validate_matrType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_xAgenteType(self, value):
        result = True
        # Validate type xAgenteType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xAgenteType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xAgenteType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xAgenteType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xAgenteType_patterns_, ))
                result = False
        return result
    validate_xAgenteType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_foneType(self, value):
        result = True
        # Validate type foneType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_foneType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_foneType_patterns_, ))
                result = False
        return result
    validate_foneType_patterns_ = [['^([0-9]{1,11})$']]
    def validate_TUfEmi(self, value):
        result = True
        # Validate type TUfEmi, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['AC', 'AL', 'AM', 'AP', 'BA', 'CE', 'DF', 'ES', 'GO', 'MA', 'MG', 'MS', 'MT', 'PA', 'PB', 'PE', 'PI', 'PR', 'RJ', 'RN', 'RO', 'RR', 'RS', 'SC', 'SE', 'SP', 'TO']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TUfEmi' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_nDARType(self, value):
        result = True
        # Validate type nDARType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on nDARType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nDARType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_nDARType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nDARType_patterns_, ))
                result = False
        return result
    validate_nDARType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TData(self, value):
        result = True
        # Validate type TData, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TData_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TData_patterns_, ))
                result = False
        return result
    validate_TData_patterns_ = [['^((((20(([02468][048])|([13579][26]))-02-29))|(20[0-9][0-9])-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\\d)|(2[0-8])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30))))))$']]
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def validate_repEmiType(self, value):
        result = True
        # Validate type repEmiType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on repEmiType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on repEmiType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_repEmiType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_repEmiType_patterns_, ))
                result = False
        return result
    validate_repEmiType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def hasContent_(self):
        if (
            self.CNPJ is not None or
            self.xOrgao is not None or
            self.matr is not None or
            self.xAgente is not None or
            self.fone is not None or
            self.UF is not None or
            self.nDAR is not None or
            self.dEmi is not None or
            self.vDAR is not None or
            self.repEmi is not None or
            self.dPag is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='avulsaType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('avulsaType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'avulsaType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='avulsaType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='avulsaType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='avulsaType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='avulsaType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CNPJ is not None:
            namespaceprefix_ = self.CNPJ_nsprefix_ + ':' if (UseCapturedNS_ and self.CNPJ_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCNPJ>%s</%sCNPJ>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CNPJ), input_name='CNPJ')), namespaceprefix_ , eol_))
        if self.xOrgao is not None:
            namespaceprefix_ = self.xOrgao_nsprefix_ + ':' if (UseCapturedNS_ and self.xOrgao_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxOrgao>%s</%sxOrgao>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xOrgao), input_name='xOrgao')), namespaceprefix_ , eol_))
        if self.matr is not None:
            namespaceprefix_ = self.matr_nsprefix_ + ':' if (UseCapturedNS_ and self.matr_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smatr>%s</%smatr>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.matr), input_name='matr')), namespaceprefix_ , eol_))
        if self.xAgente is not None:
            namespaceprefix_ = self.xAgente_nsprefix_ + ':' if (UseCapturedNS_ and self.xAgente_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxAgente>%s</%sxAgente>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xAgente), input_name='xAgente')), namespaceprefix_ , eol_))
        if self.fone is not None:
            namespaceprefix_ = self.fone_nsprefix_ + ':' if (UseCapturedNS_ and self.fone_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfone>%s</%sfone>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.fone), input_name='fone')), namespaceprefix_ , eol_))
        if self.UF is not None:
            namespaceprefix_ = self.UF_nsprefix_ + ':' if (UseCapturedNS_ and self.UF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUF>%s</%sUF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.UF), input_name='UF')), namespaceprefix_ , eol_))
        if self.nDAR is not None:
            namespaceprefix_ = self.nDAR_nsprefix_ + ':' if (UseCapturedNS_ and self.nDAR_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snDAR>%s</%snDAR>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nDAR), input_name='nDAR')), namespaceprefix_ , eol_))
        if self.dEmi is not None:
            namespaceprefix_ = self.dEmi_nsprefix_ + ':' if (UseCapturedNS_ and self.dEmi_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdEmi>%s</%sdEmi>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.dEmi), input_name='dEmi')), namespaceprefix_ , eol_))
        if self.vDAR is not None:
            namespaceprefix_ = self.vDAR_nsprefix_ + ':' if (UseCapturedNS_ and self.vDAR_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svDAR>%s</%svDAR>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vDAR), input_name='vDAR')), namespaceprefix_ , eol_))
        if self.repEmi is not None:
            namespaceprefix_ = self.repEmi_nsprefix_ + ':' if (UseCapturedNS_ and self.repEmi_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srepEmi>%s</%srepEmi>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.repEmi), input_name='repEmi')), namespaceprefix_ , eol_))
        if self.dPag is not None:
            namespaceprefix_ = self.dPag_nsprefix_ + ':' if (UseCapturedNS_ and self.dPag_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdPag>%s</%sdPag>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.dPag), input_name='dPag')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CNPJ':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CNPJ')
            value_ = self.gds_validate_string(value_, node, 'CNPJ')
            self.CNPJ = value_
            self.CNPJ_nsprefix_ = child_.prefix
            # validate type TCnpj
            self.validate_TCnpj(self.CNPJ)
        elif nodeName_ == 'xOrgao':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xOrgao')
            value_ = self.gds_validate_string(value_, node, 'xOrgao')
            self.xOrgao = value_
            self.xOrgao_nsprefix_ = child_.prefix
            # validate type xOrgaoType
            self.validate_xOrgaoType(self.xOrgao)
        elif nodeName_ == 'matr':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'matr')
            value_ = self.gds_validate_string(value_, node, 'matr')
            self.matr = value_
            self.matr_nsprefix_ = child_.prefix
            # validate type matrType
            self.validate_matrType(self.matr)
        elif nodeName_ == 'xAgente':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xAgente')
            value_ = self.gds_validate_string(value_, node, 'xAgente')
            self.xAgente = value_
            self.xAgente_nsprefix_ = child_.prefix
            # validate type xAgenteType
            self.validate_xAgenteType(self.xAgente)
        elif nodeName_ == 'fone':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'fone')
            value_ = self.gds_validate_string(value_, node, 'fone')
            self.fone = value_
            self.fone_nsprefix_ = child_.prefix
            # validate type foneType
            self.validate_foneType(self.fone)
        elif nodeName_ == 'UF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'UF')
            value_ = self.gds_validate_string(value_, node, 'UF')
            self.UF = value_
            self.UF_nsprefix_ = child_.prefix
            # validate type TUfEmi
            self.validate_TUfEmi(self.UF)
        elif nodeName_ == 'nDAR':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nDAR')
            value_ = self.gds_validate_string(value_, node, 'nDAR')
            self.nDAR = value_
            self.nDAR_nsprefix_ = child_.prefix
            # validate type nDARType
            self.validate_nDARType(self.nDAR)
        elif nodeName_ == 'dEmi':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'dEmi')
            value_ = self.gds_validate_string(value_, node, 'dEmi')
            self.dEmi = value_
            self.dEmi_nsprefix_ = child_.prefix
            # validate type TData
            self.validate_TData(self.dEmi)
        elif nodeName_ == 'vDAR':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vDAR')
            value_ = self.gds_validate_string(value_, node, 'vDAR')
            self.vDAR = value_
            self.vDAR_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vDAR)
        elif nodeName_ == 'repEmi':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'repEmi')
            value_ = self.gds_validate_string(value_, node, 'repEmi')
            self.repEmi = value_
            self.repEmi_nsprefix_ = child_.prefix
            # validate type repEmiType
            self.validate_repEmiType(self.repEmi)
        elif nodeName_ == 'dPag':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'dPag')
            value_ = self.gds_validate_string(value_, node, 'dPag')
            self.dPag = value_
            self.dPag_nsprefix_ = child_.prefix
            # validate type TData
            self.validate_TData(self.dPag)
# end class avulsaType


class destType(GeneratedsSuper):
    """Identificação do Destinatário"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('CNPJ', ['TCnpjOpc', 'xs:string'], 0, 0, {'name': 'CNPJ', 'type': 'xs:string'}, 5),
        MemberSpec_('CPF', ['TCpf', 'xs:string'], 0, 0, {'name': 'CPF', 'type': 'xs:string'}, 5),
        MemberSpec_('xNome', ['xNomeType4', 'TString', 'xs:string'], 0, 0, {'name': 'xNome', 'type': 'xs:string'}, None),
        MemberSpec_('enderDest', 'TEndereco', 0, 0, {'name': 'enderDest', 'type': 'TEndereco'}, None),
        MemberSpec_('IE', ['TIeDest', 'xs:string'], 0, 0, {'name': 'IE', 'type': 'xs:string'}, None),
        MemberSpec_('ISUF', ['ISUFType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'ISUF', 'type': 'xs:string'}, None),
        MemberSpec_('email', ['emailType', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'email', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, CNPJ=None, CPF=None, xNome=None, enderDest=None, IE=None, ISUF=None, email=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.CNPJ = CNPJ
        self.validate_TCnpjOpc(self.CNPJ)
        self.CNPJ_nsprefix_ = None
        self.CPF = CPF
        self.validate_TCpf(self.CPF)
        self.CPF_nsprefix_ = None
        self.xNome = xNome
        self.validate_xNomeType4(self.xNome)
        self.xNome_nsprefix_ = None
        self.enderDest = enderDest
        self.enderDest_nsprefix_ = None
        self.IE = IE
        self.validate_TIeDest(self.IE)
        self.IE_nsprefix_ = None
        self.ISUF = ISUF
        self.validate_ISUFType(self.ISUF)
        self.ISUF_nsprefix_ = None
        self.email = email
        self.validate_emailType(self.email)
        self.email_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, destType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if destType.subclass:
            return destType.subclass(*args_, **kwargs_)
        else:
            return destType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TCnpjOpc(self, value):
        result = True
        # Validate type TCnpjOpc, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 14:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TCnpjOpc' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCnpjOpc_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCnpjOpc_patterns_, ))
                result = False
        return result
    validate_TCnpjOpc_patterns_ = [['^([0-9]{0}|[0-9]{14})$']]
    def validate_TCpf(self, value):
        result = True
        # Validate type TCpf, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCpf_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCpf_patterns_, ))
                result = False
        return result
    validate_TCpf_patterns_ = [['^([0-9]{11})$']]
    def validate_xNomeType4(self, value):
        result = True
        # Validate type xNomeType4, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xNomeType4' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xNomeType4' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xNomeType4_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xNomeType4_patterns_, ))
                result = False
        return result
    validate_xNomeType4_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TIeDest(self, value):
        result = True
        # Validate type TIeDest, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TIeDest_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TIeDest_patterns_, ))
                result = False
        return result
    validate_TIeDest_patterns_ = [['^(ISENTO|[0-9]{0,14})$']]
    def validate_ISUFType(self, value):
        result = True
        # Validate type ISUFType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_ISUFType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ISUFType_patterns_, ))
                result = False
        return result
    validate_ISUFType_patterns_ = [['^([0-9]{8,9})$']]
    def validate_emailType(self, value):
        result = True
        # Validate type emailType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on emailType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on emailType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_emailType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_emailType_patterns_, ))
                result = False
        return result
    validate_emailType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def hasContent_(self):
        if (
            self.CNPJ is not None or
            self.CPF is not None or
            self.xNome is not None or
            self.enderDest is not None or
            self.IE is not None or
            self.ISUF is not None or
            self.email is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='destType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('destType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'destType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='destType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='destType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='destType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='destType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CNPJ is not None:
            namespaceprefix_ = self.CNPJ_nsprefix_ + ':' if (UseCapturedNS_ and self.CNPJ_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCNPJ>%s</%sCNPJ>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CNPJ), input_name='CNPJ')), namespaceprefix_ , eol_))
        if self.CPF is not None:
            namespaceprefix_ = self.CPF_nsprefix_ + ':' if (UseCapturedNS_ and self.CPF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCPF>%s</%sCPF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CPF), input_name='CPF')), namespaceprefix_ , eol_))
        if self.xNome is not None:
            namespaceprefix_ = self.xNome_nsprefix_ + ':' if (UseCapturedNS_ and self.xNome_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxNome>%s</%sxNome>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xNome), input_name='xNome')), namespaceprefix_ , eol_))
        if self.enderDest is not None:
            namespaceprefix_ = self.enderDest_nsprefix_ + ':' if (UseCapturedNS_ and self.enderDest_nsprefix_) else ''
            self.enderDest.export(outfile, level, namespaceprefix_, namespacedef_='', name_='enderDest', pretty_print=pretty_print)
        if self.IE is not None:
            namespaceprefix_ = self.IE_nsprefix_ + ':' if (UseCapturedNS_ and self.IE_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIE>%s</%sIE>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.IE), input_name='IE')), namespaceprefix_ , eol_))
        if self.ISUF is not None:
            namespaceprefix_ = self.ISUF_nsprefix_ + ':' if (UseCapturedNS_ and self.ISUF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sISUF>%s</%sISUF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ISUF), input_name='ISUF')), namespaceprefix_ , eol_))
        if self.email is not None:
            namespaceprefix_ = self.email_nsprefix_ + ':' if (UseCapturedNS_ and self.email_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%semail>%s</%semail>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.email), input_name='email')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CNPJ':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CNPJ')
            value_ = self.gds_validate_string(value_, node, 'CNPJ')
            self.CNPJ = value_
            self.CNPJ_nsprefix_ = child_.prefix
            # validate type TCnpjOpc
            self.validate_TCnpjOpc(self.CNPJ)
        elif nodeName_ == 'CPF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CPF')
            value_ = self.gds_validate_string(value_, node, 'CPF')
            self.CPF = value_
            self.CPF_nsprefix_ = child_.prefix
            # validate type TCpf
            self.validate_TCpf(self.CPF)
        elif nodeName_ == 'xNome':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xNome')
            value_ = self.gds_validate_string(value_, node, 'xNome')
            self.xNome = value_
            self.xNome_nsprefix_ = child_.prefix
            # validate type xNomeType4
            self.validate_xNomeType4(self.xNome)
        elif nodeName_ == 'enderDest':
            obj_ = TEndereco.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.enderDest = obj_
            obj_.original_tagname_ = 'enderDest'
        elif nodeName_ == 'IE':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'IE')
            value_ = self.gds_validate_string(value_, node, 'IE')
            self.IE = value_
            self.IE_nsprefix_ = child_.prefix
            # validate type TIeDest
            self.validate_TIeDest(self.IE)
        elif nodeName_ == 'ISUF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ISUF')
            value_ = self.gds_validate_string(value_, node, 'ISUF')
            self.ISUF = value_
            self.ISUF_nsprefix_ = child_.prefix
            # validate type ISUFType
            self.validate_ISUFType(self.ISUF)
        elif nodeName_ == 'email':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'email')
            value_ = self.gds_validate_string(value_, node, 'email')
            self.email = value_
            self.email_nsprefix_ = child_.prefix
            # validate type emailType
            self.validate_emailType(self.email)
# end class destType


class detType(GeneratedsSuper):
    """Dados dos detalhes da NF-eNúmero do item do NF"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('nItem', 'nItemType', 0, 0, {'use': 'required'}),
        MemberSpec_('prod', 'prodType', 0, 0, {'name': 'prod', 'type': 'prodType'}, None),
        MemberSpec_('imposto', 'impostoType', 0, 0, {'name': 'imposto', 'type': 'impostoType'}, None),
        MemberSpec_('infAdProd', ['infAdProdType', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'infAdProd', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, nItem=None, prod=None, imposto=None, infAdProd=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nItem = _cast(None, nItem)
        self.nItem_nsprefix_ = None
        self.prod = prod
        self.prod_nsprefix_ = None
        self.imposto = imposto
        self.imposto_nsprefix_ = None
        self.infAdProd = infAdProd
        self.validate_infAdProdType(self.infAdProd)
        self.infAdProd_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, detType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if detType.subclass:
            return detType.subclass(*args_, **kwargs_)
        else:
            return detType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_infAdProdType(self, value):
        result = True
        # Validate type infAdProdType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 500:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on infAdProdType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on infAdProdType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_infAdProdType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_infAdProdType_patterns_, ))
                result = False
        return result
    validate_infAdProdType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_nItemType(self, value):
        # Validate type nItemType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_nItemType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nItemType_patterns_, ))
    validate_nItemType_patterns_ = [['^([1-9]{1}[0-9]{0,1}|[1-8]{1}[0-9]{2}|[9]{1}[0-8]{1}[0-9]{1}|[9]{1}[9]{1}[0]{1})$']]
    def hasContent_(self):
        if (
            self.prod is not None or
            self.imposto is not None or
            self.infAdProd is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='detType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('detType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'detType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='detType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='detType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='detType'):
        if self.nItem is not None and 'nItem' not in already_processed:
            already_processed.add('nItem')
            outfile.write(' nItem=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.nItem), input_name='nItem')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='detType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.prod is not None:
            namespaceprefix_ = self.prod_nsprefix_ + ':' if (UseCapturedNS_ and self.prod_nsprefix_) else ''
            self.prod.export(outfile, level, namespaceprefix_, namespacedef_='', name_='prod', pretty_print=pretty_print)
        if self.imposto is not None:
            namespaceprefix_ = self.imposto_nsprefix_ + ':' if (UseCapturedNS_ and self.imposto_nsprefix_) else ''
            self.imposto.export(outfile, level, namespaceprefix_, namespacedef_='', name_='imposto', pretty_print=pretty_print)
        if self.infAdProd is not None:
            namespaceprefix_ = self.infAdProd_nsprefix_ + ':' if (UseCapturedNS_ and self.infAdProd_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinfAdProd>%s</%sinfAdProd>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.infAdProd), input_name='infAdProd')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nItem', node)
        if value is not None and 'nItem' not in already_processed:
            already_processed.add('nItem')
            self.nItem = value
            self.validate_nItemType(self.nItem)    # validate type nItemType
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'prod':
            obj_ = prodType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.prod = obj_
            obj_.original_tagname_ = 'prod'
        elif nodeName_ == 'imposto':
            obj_ = impostoType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.imposto = obj_
            obj_.original_tagname_ = 'imposto'
        elif nodeName_ == 'infAdProd':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'infAdProd')
            value_ = self.gds_validate_string(value_, node, 'infAdProd')
            self.infAdProd = value_
            self.infAdProd_nsprefix_ = child_.prefix
            # validate type infAdProdType
            self.validate_infAdProdType(self.infAdProd)
# end class detType


class prodType(GeneratedsSuper):
    """Dados dos produtos e serviços da NF-eInformações específicas de produtos
    e serviços"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('cProd', ['cProdType', 'TString', 'xs:string'], 0, 0, {'name': 'cProd', 'type': 'xs:string'}, None),
        MemberSpec_('cEAN', ['cEANType', 'xs:string'], 0, 0, {'name': 'cEAN', 'type': 'xs:string'}, None),
        MemberSpec_('xProd', ['xProdType', 'TString', 'xs:string'], 0, 0, {'name': 'xProd', 'type': 'xs:string'}, None),
        MemberSpec_('NCM', ['NCMType', 'xs:string'], 0, 0, {'name': 'NCM', 'type': 'xs:string'}, None),
        MemberSpec_('EXTIPI', ['EXTIPIType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'EXTIPI', 'type': 'xs:string'}, None),
        MemberSpec_('CFOP', ['TCfop', 'xs:string'], 0, 0, {'name': 'CFOP', 'type': 'xs:string'}, None),
        MemberSpec_('uCom', ['uComType', 'TString', 'xs:string'], 0, 0, {'name': 'uCom', 'type': 'xs:string'}, None),
        MemberSpec_('qCom', ['TDec_1104v', 'xs:string'], 0, 0, {'name': 'qCom', 'type': 'xs:string'}, None),
        MemberSpec_('vUnCom', ['TDec_1110', 'xs:string'], 0, 0, {'name': 'vUnCom', 'type': 'xs:string'}, None),
        MemberSpec_('vProd', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vProd', 'type': 'xs:string'}, None),
        MemberSpec_('cEANTrib', ['cEANTribType', 'xs:string'], 0, 0, {'name': 'cEANTrib', 'type': 'xs:string'}, None),
        MemberSpec_('uTrib', ['uTribType', 'TString', 'xs:string'], 0, 0, {'name': 'uTrib', 'type': 'xs:string'}, None),
        MemberSpec_('qTrib', ['TDec_1104v', 'xs:string'], 0, 0, {'name': 'qTrib', 'type': 'xs:string'}, None),
        MemberSpec_('vUnTrib', ['TDec_1110', 'xs:string'], 0, 0, {'name': 'vUnTrib', 'type': 'xs:string'}, None),
        MemberSpec_('vFrete', ['TDec_1302Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vFrete', 'type': 'xs:string'}, None),
        MemberSpec_('vSeg', ['TDec_1302Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vSeg', 'type': 'xs:string'}, None),
        MemberSpec_('vDesc', ['TDec_1302Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vDesc', 'type': 'xs:string'}, None),
        MemberSpec_('vOutro', ['TDec_1302Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vOutro', 'type': 'xs:string'}, None),
        MemberSpec_('indTot', ['indTotType', 'xs:string'], 0, 0, {'name': 'indTot', 'type': 'xs:string'}, None),
        MemberSpec_('DI', 'DIType', 1, 1, {'maxOccurs': '100', 'minOccurs': '0', 'name': 'DI', 'type': 'DIType'}, None),
        MemberSpec_('xPed', ['xPedType', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'xPed', 'type': 'xs:string'}, None),
        MemberSpec_('nItemPed', ['nItemPedType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'nItemPed', 'type': 'xs:string'}, None),
        MemberSpec_('nFCI', ['TGuid', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'nFCI', 'type': 'xs:string'}, None),
        MemberSpec_('veicProd', 'veicProdType', 0, 1, {'name': 'veicProd', 'type': 'veicProdType'}, 6),
        MemberSpec_('med', 'medType', 1, 1, {'maxOccurs': 'unbounded', 'name': 'med', 'type': 'medType'}, 6),
        MemberSpec_('arma', 'armaType', 1, 1, {'maxOccurs': 'unbounded', 'name': 'arma', 'type': 'armaType'}, 6),
        MemberSpec_('comb', 'combType', 0, 1, {'name': 'comb', 'type': 'combType'}, 6),
    ]
    subclass = None
    superclass = None
    def __init__(self, cProd=None, cEAN=None, xProd=None, NCM=None, EXTIPI=None, CFOP=None, uCom=None, qCom=None, vUnCom=None, vProd=None, cEANTrib=None, uTrib=None, qTrib=None, vUnTrib=None, vFrete=None, vSeg=None, vDesc=None, vOutro=None, indTot=None, DI=None, xPed=None, nItemPed=None, nFCI=None, veicProd=None, med=None, arma=None, comb=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.cProd = cProd
        self.validate_cProdType(self.cProd)
        self.cProd_nsprefix_ = None
        self.cEAN = cEAN
        self.validate_cEANType(self.cEAN)
        self.cEAN_nsprefix_ = None
        self.xProd = xProd
        self.validate_xProdType(self.xProd)
        self.xProd_nsprefix_ = None
        self.NCM = NCM
        self.validate_NCMType(self.NCM)
        self.NCM_nsprefix_ = None
        self.EXTIPI = EXTIPI
        self.validate_EXTIPIType(self.EXTIPI)
        self.EXTIPI_nsprefix_ = None
        self.CFOP = CFOP
        self.validate_TCfop(self.CFOP)
        self.CFOP_nsprefix_ = None
        self.uCom = uCom
        self.validate_uComType(self.uCom)
        self.uCom_nsprefix_ = None
        self.qCom = qCom
        self.validate_TDec_1104v(self.qCom)
        self.qCom_nsprefix_ = None
        self.vUnCom = vUnCom
        self.validate_TDec_1110(self.vUnCom)
        self.vUnCom_nsprefix_ = None
        self.vProd = vProd
        self.validate_TDec_1302(self.vProd)
        self.vProd_nsprefix_ = None
        self.cEANTrib = cEANTrib
        self.validate_cEANTribType(self.cEANTrib)
        self.cEANTrib_nsprefix_ = None
        self.uTrib = uTrib
        self.validate_uTribType(self.uTrib)
        self.uTrib_nsprefix_ = None
        self.qTrib = qTrib
        self.validate_TDec_1104v(self.qTrib)
        self.qTrib_nsprefix_ = None
        self.vUnTrib = vUnTrib
        self.validate_TDec_1110(self.vUnTrib)
        self.vUnTrib_nsprefix_ = None
        self.vFrete = vFrete
        self.validate_TDec_1302Opc(self.vFrete)
        self.vFrete_nsprefix_ = None
        self.vSeg = vSeg
        self.validate_TDec_1302Opc(self.vSeg)
        self.vSeg_nsprefix_ = None
        self.vDesc = vDesc
        self.validate_TDec_1302Opc(self.vDesc)
        self.vDesc_nsprefix_ = None
        self.vOutro = vOutro
        self.validate_TDec_1302Opc(self.vOutro)
        self.vOutro_nsprefix_ = None
        self.indTot = indTot
        self.validate_indTotType(self.indTot)
        self.indTot_nsprefix_ = None
        if DI is None:
            self.DI = []
        else:
            self.DI = DI
        self.DI_nsprefix_ = None
        self.xPed = xPed
        self.validate_xPedType(self.xPed)
        self.xPed_nsprefix_ = None
        self.nItemPed = nItemPed
        self.validate_nItemPedType(self.nItemPed)
        self.nItemPed_nsprefix_ = None
        self.nFCI = nFCI
        self.validate_TGuid(self.nFCI)
        self.nFCI_nsprefix_ = None
        self.veicProd = veicProd
        self.veicProd_nsprefix_ = None
        if med is None:
            self.med = []
        else:
            self.med = med
        self.med_nsprefix_ = None
        if arma is None:
            self.arma = []
        else:
            self.arma = arma
        self.arma_nsprefix_ = None
        self.comb = comb
        self.comb_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, prodType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if prodType.subclass:
            return prodType.subclass(*args_, **kwargs_)
        else:
            return prodType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_cProdType(self, value):
        result = True
        # Validate type cProdType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on cProdType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on cProdType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_cProdType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cProdType_patterns_, ))
                result = False
        return result
    validate_cProdType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_cEANType(self, value):
        result = True
        # Validate type cEANType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_cEANType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cEANType_patterns_, ))
                result = False
        return result
    validate_cEANType_patterns_ = [['^([0-9]{0}|[0-9]{8}|[0-9]{12,14})$']]
    def validate_xProdType(self, value):
        result = True
        # Validate type xProdType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 120:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xProdType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xProdType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xProdType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xProdType_patterns_, ))
                result = False
        return result
    validate_xProdType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_NCMType(self, value):
        result = True
        # Validate type NCMType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_NCMType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NCMType_patterns_, ))
                result = False
        return result
    validate_NCMType_patterns_ = [['^([0-9]{2}|[0][1-9][0-9]{6}|[1-9][0-9]{7})$']]
    def validate_EXTIPIType(self, value):
        result = True
        # Validate type EXTIPIType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_EXTIPIType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_EXTIPIType_patterns_, ))
                result = False
        return result
    validate_EXTIPIType_patterns_ = [['^([0-9]{2,3})$']]
    def validate_TCfop(self, value):
        result = True
        # Validate type TCfop, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['1101', '1102', '1111', '1113', '1116', '1117', '1118', '1120', '1121', '1122', '1124', '1125', '1126', '1128', '1151', '1152', '1153', '1154', '1201', '1202', '1203', '1204', '1205', '1206', '1207', '1208', '1209', '1251', '1252', '1253', '1254', '1255', '1256', '1257', '1301', '1302', '1303', '1304', '1305', '1306', '1351', '1352', '1353', '1354', '1355', '1356', '1360', '1401', '1403', '1406', '1407', '1408', '1409', '1410', '1411', '1414', '1415', '1451', '1452', '1501', '1503', '1504', '1505', '1506', '1551', '1552', '1553', '1554', '1555', '1556', '1557', '1601', '1602', '1603', '1604', '1605', '1651', '1652', '1653', '1658', '1659', '1660', '1661', '1662', '1663', '1664', '1901', '1902', '1903', '1904', '1905', '1906', '1907', '1908', '1909', '1910', '1911', '1912', '1913', '1914', '1915', '1916', '1917', '1918', '1919', '1920', '1921', '1922', '1923', '1924', '1925', '1926', '1931', '1932', '1933', '1934', '1949', '2101', '2102', '2111', '2113', '2116', '2117', '2118', '2120', '2121', '2122', '2124', '2125', '2126', '2128', '2151', '2152', '2153', '2154', '2201', '2202', '2203', '2204', '2205', '2206', '2207', '2208', '2209', '2251', '2252', '2253', '2254', '2255', '2256', '2257', '2301', '2302', '2303', '2304', '2305', '2306', '2351', '2352', '2353', '2354', '2355', '2356', '2401', '2403', '2406', '2407', '2408', '2409', '2410', '2411', '2414', '2415', '2501', '2503', '2504', '2505', '2506', '2551', '2552', '2553', '2554', '2555', '2556', '2557', '2603', '2651', '2652', '2653', '2658', '2659', '2660', '2661', '2662', '2663', '2664', '2901', '2902', '2903', '2904', '2905', '2906', '2907', '2908', '2909', '2910', '2911', '2912', '2913', '2914', '2915', '2916', '2917', '2918', '2919', '2920', '2921', '2922', '2923', '2924', '2925', '2931', '2932', '2933', '2934', '2949', '3101', '3102', '3126', '3127', '3128', '3201', '3202', '3205', '3206', '3207', '3211', '3251', '3301', '3351', '3352', '3353', '3354', '3355', '3356', '3503', '3551', '3553', '3556', '3651', '3652', '3653', '3930', '3949', '5101', '5102', '5103', '5104', '5105', '5106', '5109', '5110', '5111', '5112', '5113', '5114', '5115', '5116', '5117', '5118', '5119', '5120', '5122', '5123', '5124', '5125', '5151', '5152', '5153', '5155', '5156', '5201', '5202', '5205', '5206', '5207', '5208', '5209', '5210', '5251', '5252', '5253', '5254', '5255', '5256', '5257', '5258', '5401', '5402', '5403', '5405', '5408', '5409', '5410', '5411', '5412', '5413', '5414', '5415', '5451', '5501', '5502', '5503', '5504', '5505', '5551', '5552', '5553', '5554', '5555', '5556', '5557', '5601', '5602', '5603', '5605', '5606', '5651', '5652', '5653', '5654', '5655', '5656', '5657', '5658', '5659', '5660', '5661', '5662', '5663', '5664', '5665', '5666', '5667', '5901', '5902', '5903', '5904', '5905', '5906', '5907', '5908', '5909', '5910', '5911', '5912', '5913', '5914', '5915', '5916', '5917', '5918', '5919', '5920', '5921', '5922', '5923', '5924', '5925', '5926', '5927', '5928', '5929', '5931', '5932', '5933', '5934', '5949', '6101', '6102', '6103', '6104', '6105', '6106', '6107', '6108', '6109', '6110', '6111', '6112', '6113', '6114', '6115', '6116', '6117', '6118', '6119', '6120', '6122', '6123', '6124', '6125', '6151', '6152', '6153', '6155', '6156', '6201', '6202', '6205', '6206', '6207', '6208', '6209', '6210', '6251', '6252', '6253', '6254', '6255', '6256', '6257', '6258', '6401', '6402', '6403', '6404', '6408', '6409', '6410', '6411', '6412', '6413', '6414', '6415', '6501', '6502', '6503', '6504', '6505', '6551', '6552', '6553', '6554', '6555', '6556', '6557', '6603', '6651', '6652', '6653', '6654', '6655', '6656', '6657', '6658', '6659', '6660', '6661', '6662', '6663', '6664', '6665', '6666', '6667', '6901', '6902', '6903', '6904', '6905', '6906', '6907', '6908', '6909', '6910', '6911', '6912', '6913', '6914', '6915', '6916', '6917', '6918', '6919', '6920', '6921', '6922', '6923', '6924', '6925', '6929', '6931', '6932', '6933', '6934', '6949', '7101', '7102', '7105', '7106', '7127', '7201', '7202', '7205', '7206', '7207', '7210', '7211', '7251', '7501', '7551', '7553', '7556', '7651', '7654', '7667', '7930', '7949']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TCfop' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_uComType(self, value):
        result = True
        # Validate type uComType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 6:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on uComType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on uComType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_uComType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_uComType_patterns_, ))
                result = False
        return result
    validate_uComType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TDec_1104v(self, value):
        result = True
        # Validate type TDec_1104v, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1104v_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1104v_patterns_, ))
                result = False
        return result
    validate_TDec_1104v_patterns_ = [['^(0|0\\.[0-9]{1,4}|[1-9]{1}[0-9]{0,10}|[1-9]{1}[0-9]{0,10}(\\.[0-9]{1,4})?)$']]
    def validate_TDec_1110(self, value):
        result = True
        # Validate type TDec_1110, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1110_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1110_patterns_, ))
                result = False
        return result
    validate_TDec_1110_patterns_ = [['^(0|0\\.[0-9]{1,10}|[1-9]{1}[0-9]{0,10}|[1-9]{1}[0-9]{0,10}(\\.[0-9]{1,10})?)$']]
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def validate_cEANTribType(self, value):
        result = True
        # Validate type cEANTribType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_cEANTribType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cEANTribType_patterns_, ))
                result = False
        return result
    validate_cEANTribType_patterns_ = [['^([0-9]{0}|[0-9]{8}|[0-9]{12,14})$']]
    def validate_uTribType(self, value):
        result = True
        # Validate type uTribType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 6:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on uTribType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on uTribType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_uTribType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_uTribType_patterns_, ))
                result = False
        return result
    validate_uTribType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TDec_1302Opc(self, value):
        result = True
        # Validate type TDec_1302Opc, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302Opc_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302Opc_patterns_, ))
                result = False
        return result
    validate_TDec_1302Opc_patterns_ = [['^(0\\.[0-9]{1}[1-9]{1}|0\\.[1-9]{1}[0-9]{1}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def validate_indTotType(self, value):
        result = True
        # Validate type indTotType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on indTotType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_xPedType(self, value):
        result = True
        # Validate type xPedType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 15:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xPedType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xPedType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xPedType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xPedType_patterns_, ))
                result = False
        return result
    validate_xPedType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_nItemPedType(self, value):
        result = True
        # Validate type nItemPedType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_nItemPedType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nItemPedType_patterns_, ))
                result = False
        return result
    validate_nItemPedType_patterns_ = [['^([0-9]{1,6})$']]
    def validate_TGuid(self, value):
        result = True
        # Validate type TGuid, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TGuid_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TGuid_patterns_, ))
                result = False
        return result
    validate_TGuid_patterns_ = [['^([A-F0-9]{8}-[A-F0-9]{4}-[A-F0-9]{4}-[A-F0-9]{4}-[A-F0-9]{12})$']]
    def hasContent_(self):
        if (
            self.cProd is not None or
            self.cEAN is not None or
            self.xProd is not None or
            self.NCM is not None or
            self.EXTIPI is not None or
            self.CFOP is not None or
            self.uCom is not None or
            self.qCom is not None or
            self.vUnCom is not None or
            self.vProd is not None or
            self.cEANTrib is not None or
            self.uTrib is not None or
            self.qTrib is not None or
            self.vUnTrib is not None or
            self.vFrete is not None or
            self.vSeg is not None or
            self.vDesc is not None or
            self.vOutro is not None or
            self.indTot is not None or
            self.DI or
            self.xPed is not None or
            self.nItemPed is not None or
            self.nFCI is not None or
            self.veicProd is not None or
            self.med or
            self.arma or
            self.comb is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='prodType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('prodType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'prodType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='prodType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='prodType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='prodType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='prodType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.cProd is not None:
            namespaceprefix_ = self.cProd_nsprefix_ + ':' if (UseCapturedNS_ and self.cProd_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scProd>%s</%scProd>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cProd), input_name='cProd')), namespaceprefix_ , eol_))
        if self.cEAN is not None:
            namespaceprefix_ = self.cEAN_nsprefix_ + ':' if (UseCapturedNS_ and self.cEAN_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scEAN>%s</%scEAN>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cEAN), input_name='cEAN')), namespaceprefix_ , eol_))
        if self.xProd is not None:
            namespaceprefix_ = self.xProd_nsprefix_ + ':' if (UseCapturedNS_ and self.xProd_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxProd>%s</%sxProd>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xProd), input_name='xProd')), namespaceprefix_ , eol_))
        if self.NCM is not None:
            namespaceprefix_ = self.NCM_nsprefix_ + ':' if (UseCapturedNS_ and self.NCM_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sNCM>%s</%sNCM>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.NCM), input_name='NCM')), namespaceprefix_ , eol_))
        if self.EXTIPI is not None:
            namespaceprefix_ = self.EXTIPI_nsprefix_ + ':' if (UseCapturedNS_ and self.EXTIPI_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sEXTIPI>%s</%sEXTIPI>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.EXTIPI), input_name='EXTIPI')), namespaceprefix_ , eol_))
        if self.CFOP is not None:
            namespaceprefix_ = self.CFOP_nsprefix_ + ':' if (UseCapturedNS_ and self.CFOP_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCFOP>%s</%sCFOP>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CFOP), input_name='CFOP')), namespaceprefix_ , eol_))
        if self.uCom is not None:
            namespaceprefix_ = self.uCom_nsprefix_ + ':' if (UseCapturedNS_ and self.uCom_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suCom>%s</%suCom>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.uCom), input_name='uCom')), namespaceprefix_ , eol_))
        if self.qCom is not None:
            namespaceprefix_ = self.qCom_nsprefix_ + ':' if (UseCapturedNS_ and self.qCom_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sqCom>%s</%sqCom>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.qCom), input_name='qCom')), namespaceprefix_ , eol_))
        if self.vUnCom is not None:
            namespaceprefix_ = self.vUnCom_nsprefix_ + ':' if (UseCapturedNS_ and self.vUnCom_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svUnCom>%s</%svUnCom>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vUnCom), input_name='vUnCom')), namespaceprefix_ , eol_))
        if self.vProd is not None:
            namespaceprefix_ = self.vProd_nsprefix_ + ':' if (UseCapturedNS_ and self.vProd_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svProd>%s</%svProd>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vProd), input_name='vProd')), namespaceprefix_ , eol_))
        if self.cEANTrib is not None:
            namespaceprefix_ = self.cEANTrib_nsprefix_ + ':' if (UseCapturedNS_ and self.cEANTrib_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scEANTrib>%s</%scEANTrib>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cEANTrib), input_name='cEANTrib')), namespaceprefix_ , eol_))
        if self.uTrib is not None:
            namespaceprefix_ = self.uTrib_nsprefix_ + ':' if (UseCapturedNS_ and self.uTrib_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suTrib>%s</%suTrib>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.uTrib), input_name='uTrib')), namespaceprefix_ , eol_))
        if self.qTrib is not None:
            namespaceprefix_ = self.qTrib_nsprefix_ + ':' if (UseCapturedNS_ and self.qTrib_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sqTrib>%s</%sqTrib>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.qTrib), input_name='qTrib')), namespaceprefix_ , eol_))
        if self.vUnTrib is not None:
            namespaceprefix_ = self.vUnTrib_nsprefix_ + ':' if (UseCapturedNS_ and self.vUnTrib_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svUnTrib>%s</%svUnTrib>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vUnTrib), input_name='vUnTrib')), namespaceprefix_ , eol_))
        if self.vFrete is not None:
            namespaceprefix_ = self.vFrete_nsprefix_ + ':' if (UseCapturedNS_ and self.vFrete_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svFrete>%s</%svFrete>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vFrete), input_name='vFrete')), namespaceprefix_ , eol_))
        if self.vSeg is not None:
            namespaceprefix_ = self.vSeg_nsprefix_ + ':' if (UseCapturedNS_ and self.vSeg_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svSeg>%s</%svSeg>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vSeg), input_name='vSeg')), namespaceprefix_ , eol_))
        if self.vDesc is not None:
            namespaceprefix_ = self.vDesc_nsprefix_ + ':' if (UseCapturedNS_ and self.vDesc_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svDesc>%s</%svDesc>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vDesc), input_name='vDesc')), namespaceprefix_ , eol_))
        if self.vOutro is not None:
            namespaceprefix_ = self.vOutro_nsprefix_ + ':' if (UseCapturedNS_ and self.vOutro_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svOutro>%s</%svOutro>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vOutro), input_name='vOutro')), namespaceprefix_ , eol_))
        if self.indTot is not None:
            namespaceprefix_ = self.indTot_nsprefix_ + ':' if (UseCapturedNS_ and self.indTot_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sindTot>%s</%sindTot>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.indTot), input_name='indTot')), namespaceprefix_ , eol_))
        for DI_ in self.DI:
            namespaceprefix_ = self.DI_nsprefix_ + ':' if (UseCapturedNS_ and self.DI_nsprefix_) else ''
            DI_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DI', pretty_print=pretty_print)
        if self.xPed is not None:
            namespaceprefix_ = self.xPed_nsprefix_ + ':' if (UseCapturedNS_ and self.xPed_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxPed>%s</%sxPed>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xPed), input_name='xPed')), namespaceprefix_ , eol_))
        if self.nItemPed is not None:
            namespaceprefix_ = self.nItemPed_nsprefix_ + ':' if (UseCapturedNS_ and self.nItemPed_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snItemPed>%s</%snItemPed>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nItemPed), input_name='nItemPed')), namespaceprefix_ , eol_))
        if self.nFCI is not None:
            namespaceprefix_ = self.nFCI_nsprefix_ + ':' if (UseCapturedNS_ and self.nFCI_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snFCI>%s</%snFCI>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nFCI), input_name='nFCI')), namespaceprefix_ , eol_))
        if self.veicProd is not None:
            namespaceprefix_ = self.veicProd_nsprefix_ + ':' if (UseCapturedNS_ and self.veicProd_nsprefix_) else ''
            self.veicProd.export(outfile, level, namespaceprefix_, namespacedef_='', name_='veicProd', pretty_print=pretty_print)
        for med_ in self.med:
            namespaceprefix_ = self.med_nsprefix_ + ':' if (UseCapturedNS_ and self.med_nsprefix_) else ''
            med_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='med', pretty_print=pretty_print)
        for arma_ in self.arma:
            namespaceprefix_ = self.arma_nsprefix_ + ':' if (UseCapturedNS_ and self.arma_nsprefix_) else ''
            arma_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='arma', pretty_print=pretty_print)
        if self.comb is not None:
            namespaceprefix_ = self.comb_nsprefix_ + ':' if (UseCapturedNS_ and self.comb_nsprefix_) else ''
            self.comb.export(outfile, level, namespaceprefix_, namespacedef_='', name_='comb', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'cProd':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cProd')
            value_ = self.gds_validate_string(value_, node, 'cProd')
            self.cProd = value_
            self.cProd_nsprefix_ = child_.prefix
            # validate type cProdType
            self.validate_cProdType(self.cProd)
        elif nodeName_ == 'cEAN':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cEAN')
            value_ = self.gds_validate_string(value_, node, 'cEAN')
            self.cEAN = value_
            self.cEAN_nsprefix_ = child_.prefix
            # validate type cEANType
            self.validate_cEANType(self.cEAN)
        elif nodeName_ == 'xProd':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xProd')
            value_ = self.gds_validate_string(value_, node, 'xProd')
            self.xProd = value_
            self.xProd_nsprefix_ = child_.prefix
            # validate type xProdType
            self.validate_xProdType(self.xProd)
        elif nodeName_ == 'NCM':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'NCM')
            value_ = self.gds_validate_string(value_, node, 'NCM')
            self.NCM = value_
            self.NCM_nsprefix_ = child_.prefix
            # validate type NCMType
            self.validate_NCMType(self.NCM)
        elif nodeName_ == 'EXTIPI':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'EXTIPI')
            value_ = self.gds_validate_string(value_, node, 'EXTIPI')
            self.EXTIPI = value_
            self.EXTIPI_nsprefix_ = child_.prefix
            # validate type EXTIPIType
            self.validate_EXTIPIType(self.EXTIPI)
        elif nodeName_ == 'CFOP':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CFOP')
            value_ = self.gds_validate_string(value_, node, 'CFOP')
            self.CFOP = value_
            self.CFOP_nsprefix_ = child_.prefix
            # validate type TCfop
            self.validate_TCfop(self.CFOP)
        elif nodeName_ == 'uCom':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'uCom')
            value_ = self.gds_validate_string(value_, node, 'uCom')
            self.uCom = value_
            self.uCom_nsprefix_ = child_.prefix
            # validate type uComType
            self.validate_uComType(self.uCom)
        elif nodeName_ == 'qCom':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'qCom')
            value_ = self.gds_validate_string(value_, node, 'qCom')
            self.qCom = value_
            self.qCom_nsprefix_ = child_.prefix
            # validate type TDec_1104v
            self.validate_TDec_1104v(self.qCom)
        elif nodeName_ == 'vUnCom':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vUnCom')
            value_ = self.gds_validate_string(value_, node, 'vUnCom')
            self.vUnCom = value_
            self.vUnCom_nsprefix_ = child_.prefix
            # validate type TDec_1110
            self.validate_TDec_1110(self.vUnCom)
        elif nodeName_ == 'vProd':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vProd')
            value_ = self.gds_validate_string(value_, node, 'vProd')
            self.vProd = value_
            self.vProd_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vProd)
        elif nodeName_ == 'cEANTrib':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cEANTrib')
            value_ = self.gds_validate_string(value_, node, 'cEANTrib')
            self.cEANTrib = value_
            self.cEANTrib_nsprefix_ = child_.prefix
            # validate type cEANTribType
            self.validate_cEANTribType(self.cEANTrib)
        elif nodeName_ == 'uTrib':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'uTrib')
            value_ = self.gds_validate_string(value_, node, 'uTrib')
            self.uTrib = value_
            self.uTrib_nsprefix_ = child_.prefix
            # validate type uTribType
            self.validate_uTribType(self.uTrib)
        elif nodeName_ == 'qTrib':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'qTrib')
            value_ = self.gds_validate_string(value_, node, 'qTrib')
            self.qTrib = value_
            self.qTrib_nsprefix_ = child_.prefix
            # validate type TDec_1104v
            self.validate_TDec_1104v(self.qTrib)
        elif nodeName_ == 'vUnTrib':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vUnTrib')
            value_ = self.gds_validate_string(value_, node, 'vUnTrib')
            self.vUnTrib = value_
            self.vUnTrib_nsprefix_ = child_.prefix
            # validate type TDec_1110
            self.validate_TDec_1110(self.vUnTrib)
        elif nodeName_ == 'vFrete':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vFrete')
            value_ = self.gds_validate_string(value_, node, 'vFrete')
            self.vFrete = value_
            self.vFrete_nsprefix_ = child_.prefix
            # validate type TDec_1302Opc
            self.validate_TDec_1302Opc(self.vFrete)
        elif nodeName_ == 'vSeg':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vSeg')
            value_ = self.gds_validate_string(value_, node, 'vSeg')
            self.vSeg = value_
            self.vSeg_nsprefix_ = child_.prefix
            # validate type TDec_1302Opc
            self.validate_TDec_1302Opc(self.vSeg)
        elif nodeName_ == 'vDesc':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vDesc')
            value_ = self.gds_validate_string(value_, node, 'vDesc')
            self.vDesc = value_
            self.vDesc_nsprefix_ = child_.prefix
            # validate type TDec_1302Opc
            self.validate_TDec_1302Opc(self.vDesc)
        elif nodeName_ == 'vOutro':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vOutro')
            value_ = self.gds_validate_string(value_, node, 'vOutro')
            self.vOutro = value_
            self.vOutro_nsprefix_ = child_.prefix
            # validate type TDec_1302Opc
            self.validate_TDec_1302Opc(self.vOutro)
        elif nodeName_ == 'indTot':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'indTot')
            value_ = self.gds_validate_string(value_, node, 'indTot')
            self.indTot = value_
            self.indTot_nsprefix_ = child_.prefix
            # validate type indTotType
            self.validate_indTotType(self.indTot)
        elif nodeName_ == 'DI':
            obj_ = DIType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DI.append(obj_)
            obj_.original_tagname_ = 'DI'
        elif nodeName_ == 'xPed':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xPed')
            value_ = self.gds_validate_string(value_, node, 'xPed')
            self.xPed = value_
            self.xPed_nsprefix_ = child_.prefix
            # validate type xPedType
            self.validate_xPedType(self.xPed)
        elif nodeName_ == 'nItemPed':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nItemPed')
            value_ = self.gds_validate_string(value_, node, 'nItemPed')
            self.nItemPed = value_
            self.nItemPed_nsprefix_ = child_.prefix
            # validate type nItemPedType
            self.validate_nItemPedType(self.nItemPed)
        elif nodeName_ == 'nFCI':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nFCI')
            value_ = self.gds_validate_string(value_, node, 'nFCI')
            self.nFCI = value_
            self.nFCI_nsprefix_ = child_.prefix
            # validate type TGuid
            self.validate_TGuid(self.nFCI)
        elif nodeName_ == 'veicProd':
            obj_ = veicProdType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.veicProd = obj_
            obj_.original_tagname_ = 'veicProd'
        elif nodeName_ == 'med':
            obj_ = medType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.med.append(obj_)
            obj_.original_tagname_ = 'med'
        elif nodeName_ == 'arma':
            obj_ = armaType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.arma.append(obj_)
            obj_.original_tagname_ = 'arma'
        elif nodeName_ == 'comb':
            obj_ = combType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.comb = obj_
            obj_.original_tagname_ = 'comb'
# end class prodType


class DIType(GeneratedsSuper):
    """Delcaração de Importação
    (NT 2011/004)"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('nDI', ['nDIType', 'TString', 'xs:string'], 0, 0, {'name': 'nDI', 'type': 'xs:string'}, None),
        MemberSpec_('dDI', ['TData', 'xs:string'], 0, 0, {'name': 'dDI', 'type': 'xs:string'}, None),
        MemberSpec_('xLocDesemb', ['xLocDesembType', 'TString', 'xs:string'], 0, 0, {'name': 'xLocDesemb', 'type': 'xs:string'}, None),
        MemberSpec_('UFDesemb', ['TUfEmi', 'xs:string'], 0, 0, {'name': 'UFDesemb', 'type': 'xs:string'}, None),
        MemberSpec_('dDesemb', ['TData', 'xs:string'], 0, 0, {'name': 'dDesemb', 'type': 'xs:string'}, None),
        MemberSpec_('cExportador', ['cExportadorType', 'TString', 'xs:string'], 0, 0, {'name': 'cExportador', 'type': 'xs:string'}, None),
        MemberSpec_('adi', 'adiType', 1, 0, {'maxOccurs': '100', 'name': 'adi', 'type': 'adiType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, nDI=None, dDI=None, xLocDesemb=None, UFDesemb=None, dDesemb=None, cExportador=None, adi=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nDI = nDI
        self.validate_nDIType(self.nDI)
        self.nDI_nsprefix_ = None
        self.dDI = dDI
        self.validate_TData(self.dDI)
        self.dDI_nsprefix_ = None
        self.xLocDesemb = xLocDesemb
        self.validate_xLocDesembType(self.xLocDesemb)
        self.xLocDesemb_nsprefix_ = None
        self.UFDesemb = UFDesemb
        self.validate_TUfEmi(self.UFDesemb)
        self.UFDesemb_nsprefix_ = None
        self.dDesemb = dDesemb
        self.validate_TData(self.dDesemb)
        self.dDesemb_nsprefix_ = None
        self.cExportador = cExportador
        self.validate_cExportadorType(self.cExportador)
        self.cExportador_nsprefix_ = None
        if adi is None:
            self.adi = []
        else:
            self.adi = adi
        self.adi_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DIType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DIType.subclass:
            return DIType.subclass(*args_, **kwargs_)
        else:
            return DIType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_nDIType(self, value):
        result = True
        # Validate type nDIType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 12:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on nDIType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nDIType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_nDIType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nDIType_patterns_, ))
                result = False
        return result
    validate_nDIType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TData(self, value):
        result = True
        # Validate type TData, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TData_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TData_patterns_, ))
                result = False
        return result
    validate_TData_patterns_ = [['^((((20(([02468][048])|([13579][26]))-02-29))|(20[0-9][0-9])-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\\d)|(2[0-8])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30))))))$']]
    def validate_xLocDesembType(self, value):
        result = True
        # Validate type xLocDesembType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xLocDesembType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xLocDesembType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xLocDesembType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xLocDesembType_patterns_, ))
                result = False
        return result
    validate_xLocDesembType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TUfEmi(self, value):
        result = True
        # Validate type TUfEmi, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['AC', 'AL', 'AM', 'AP', 'BA', 'CE', 'DF', 'ES', 'GO', 'MA', 'MG', 'MS', 'MT', 'PA', 'PB', 'PE', 'PI', 'PR', 'RJ', 'RN', 'RO', 'RR', 'RS', 'SC', 'SE', 'SP', 'TO']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TUfEmi' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_cExportadorType(self, value):
        result = True
        # Validate type cExportadorType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on cExportadorType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on cExportadorType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_cExportadorType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cExportadorType_patterns_, ))
                result = False
        return result
    validate_cExportadorType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def hasContent_(self):
        if (
            self.nDI is not None or
            self.dDI is not None or
            self.xLocDesemb is not None or
            self.UFDesemb is not None or
            self.dDesemb is not None or
            self.cExportador is not None or
            self.adi
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DIType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DIType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DIType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DIType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DIType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DIType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DIType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.nDI is not None:
            namespaceprefix_ = self.nDI_nsprefix_ + ':' if (UseCapturedNS_ and self.nDI_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snDI>%s</%snDI>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nDI), input_name='nDI')), namespaceprefix_ , eol_))
        if self.dDI is not None:
            namespaceprefix_ = self.dDI_nsprefix_ + ':' if (UseCapturedNS_ and self.dDI_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdDI>%s</%sdDI>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.dDI), input_name='dDI')), namespaceprefix_ , eol_))
        if self.xLocDesemb is not None:
            namespaceprefix_ = self.xLocDesemb_nsprefix_ + ':' if (UseCapturedNS_ and self.xLocDesemb_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxLocDesemb>%s</%sxLocDesemb>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xLocDesemb), input_name='xLocDesemb')), namespaceprefix_ , eol_))
        if self.UFDesemb is not None:
            namespaceprefix_ = self.UFDesemb_nsprefix_ + ':' if (UseCapturedNS_ and self.UFDesemb_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUFDesemb>%s</%sUFDesemb>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.UFDesemb), input_name='UFDesemb')), namespaceprefix_ , eol_))
        if self.dDesemb is not None:
            namespaceprefix_ = self.dDesemb_nsprefix_ + ':' if (UseCapturedNS_ and self.dDesemb_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdDesemb>%s</%sdDesemb>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.dDesemb), input_name='dDesemb')), namespaceprefix_ , eol_))
        if self.cExportador is not None:
            namespaceprefix_ = self.cExportador_nsprefix_ + ':' if (UseCapturedNS_ and self.cExportador_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scExportador>%s</%scExportador>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cExportador), input_name='cExportador')), namespaceprefix_ , eol_))
        for adi_ in self.adi:
            namespaceprefix_ = self.adi_nsprefix_ + ':' if (UseCapturedNS_ and self.adi_nsprefix_) else ''
            adi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='adi', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'nDI':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nDI')
            value_ = self.gds_validate_string(value_, node, 'nDI')
            self.nDI = value_
            self.nDI_nsprefix_ = child_.prefix
            # validate type nDIType
            self.validate_nDIType(self.nDI)
        elif nodeName_ == 'dDI':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'dDI')
            value_ = self.gds_validate_string(value_, node, 'dDI')
            self.dDI = value_
            self.dDI_nsprefix_ = child_.prefix
            # validate type TData
            self.validate_TData(self.dDI)
        elif nodeName_ == 'xLocDesemb':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xLocDesemb')
            value_ = self.gds_validate_string(value_, node, 'xLocDesemb')
            self.xLocDesemb = value_
            self.xLocDesemb_nsprefix_ = child_.prefix
            # validate type xLocDesembType
            self.validate_xLocDesembType(self.xLocDesemb)
        elif nodeName_ == 'UFDesemb':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'UFDesemb')
            value_ = self.gds_validate_string(value_, node, 'UFDesemb')
            self.UFDesemb = value_
            self.UFDesemb_nsprefix_ = child_.prefix
            # validate type TUfEmi
            self.validate_TUfEmi(self.UFDesemb)
        elif nodeName_ == 'dDesemb':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'dDesemb')
            value_ = self.gds_validate_string(value_, node, 'dDesemb')
            self.dDesemb = value_
            self.dDesemb_nsprefix_ = child_.prefix
            # validate type TData
            self.validate_TData(self.dDesemb)
        elif nodeName_ == 'cExportador':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cExportador')
            value_ = self.gds_validate_string(value_, node, 'cExportador')
            self.cExportador = value_
            self.cExportador_nsprefix_ = child_.prefix
            # validate type cExportadorType
            self.validate_cExportadorType(self.cExportador)
        elif nodeName_ == 'adi':
            obj_ = adiType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.adi.append(obj_)
            obj_.original_tagname_ = 'adi'
# end class DIType


class adiType(GeneratedsSuper):
    """Adições (NT 2011/004)"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('nAdicao', ['nAdicaoType', 'xs:string'], 0, 0, {'name': 'nAdicao', 'type': 'xs:string'}, None),
        MemberSpec_('nSeqAdic', ['nSeqAdicType', 'xs:string'], 0, 0, {'name': 'nSeqAdic', 'type': 'xs:string'}, None),
        MemberSpec_('cFabricante', ['cFabricanteType', 'TString', 'xs:string'], 0, 0, {'name': 'cFabricante', 'type': 'xs:string'}, None),
        MemberSpec_('vDescDI', ['TDec_1302Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vDescDI', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, nAdicao=None, nSeqAdic=None, cFabricante=None, vDescDI=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nAdicao = nAdicao
        self.validate_nAdicaoType(self.nAdicao)
        self.nAdicao_nsprefix_ = None
        self.nSeqAdic = nSeqAdic
        self.validate_nSeqAdicType(self.nSeqAdic)
        self.nSeqAdic_nsprefix_ = None
        self.cFabricante = cFabricante
        self.validate_cFabricanteType(self.cFabricante)
        self.cFabricante_nsprefix_ = None
        self.vDescDI = vDescDI
        self.validate_TDec_1302Opc(self.vDescDI)
        self.vDescDI_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, adiType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if adiType.subclass:
            return adiType.subclass(*args_, **kwargs_)
        else:
            return adiType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_nAdicaoType(self, value):
        result = True
        # Validate type nAdicaoType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_nAdicaoType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nAdicaoType_patterns_, ))
                result = False
        return result
    validate_nAdicaoType_patterns_ = [['^([1-9]{1}[0-9]{0,2})$']]
    def validate_nSeqAdicType(self, value):
        result = True
        # Validate type nSeqAdicType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_nSeqAdicType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nSeqAdicType_patterns_, ))
                result = False
        return result
    validate_nSeqAdicType_patterns_ = [['^([1-9]{1}[0-9]{0,2})$']]
    def validate_cFabricanteType(self, value):
        result = True
        # Validate type cFabricanteType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on cFabricanteType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on cFabricanteType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_cFabricanteType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cFabricanteType_patterns_, ))
                result = False
        return result
    validate_cFabricanteType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TDec_1302Opc(self, value):
        result = True
        # Validate type TDec_1302Opc, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302Opc_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302Opc_patterns_, ))
                result = False
        return result
    validate_TDec_1302Opc_patterns_ = [['^(0\\.[0-9]{1}[1-9]{1}|0\\.[1-9]{1}[0-9]{1}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def hasContent_(self):
        if (
            self.nAdicao is not None or
            self.nSeqAdic is not None or
            self.cFabricante is not None or
            self.vDescDI is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='adiType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('adiType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'adiType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='adiType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='adiType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='adiType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='adiType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.nAdicao is not None:
            namespaceprefix_ = self.nAdicao_nsprefix_ + ':' if (UseCapturedNS_ and self.nAdicao_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snAdicao>%s</%snAdicao>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nAdicao), input_name='nAdicao')), namespaceprefix_ , eol_))
        if self.nSeqAdic is not None:
            namespaceprefix_ = self.nSeqAdic_nsprefix_ + ':' if (UseCapturedNS_ and self.nSeqAdic_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snSeqAdic>%s</%snSeqAdic>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nSeqAdic), input_name='nSeqAdic')), namespaceprefix_ , eol_))
        if self.cFabricante is not None:
            namespaceprefix_ = self.cFabricante_nsprefix_ + ':' if (UseCapturedNS_ and self.cFabricante_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scFabricante>%s</%scFabricante>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cFabricante), input_name='cFabricante')), namespaceprefix_ , eol_))
        if self.vDescDI is not None:
            namespaceprefix_ = self.vDescDI_nsprefix_ + ':' if (UseCapturedNS_ and self.vDescDI_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svDescDI>%s</%svDescDI>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vDescDI), input_name='vDescDI')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'nAdicao':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nAdicao')
            value_ = self.gds_validate_string(value_, node, 'nAdicao')
            self.nAdicao = value_
            self.nAdicao_nsprefix_ = child_.prefix
            # validate type nAdicaoType
            self.validate_nAdicaoType(self.nAdicao)
        elif nodeName_ == 'nSeqAdic':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nSeqAdic')
            value_ = self.gds_validate_string(value_, node, 'nSeqAdic')
            self.nSeqAdic = value_
            self.nSeqAdic_nsprefix_ = child_.prefix
            # validate type nSeqAdicType
            self.validate_nSeqAdicType(self.nSeqAdic)
        elif nodeName_ == 'cFabricante':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cFabricante')
            value_ = self.gds_validate_string(value_, node, 'cFabricante')
            self.cFabricante = value_
            self.cFabricante_nsprefix_ = child_.prefix
            # validate type cFabricanteType
            self.validate_cFabricanteType(self.cFabricante)
        elif nodeName_ == 'vDescDI':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vDescDI')
            value_ = self.gds_validate_string(value_, node, 'vDescDI')
            self.vDescDI = value_
            self.vDescDI_nsprefix_ = child_.prefix
            # validate type TDec_1302Opc
            self.validate_TDec_1302Opc(self.vDescDI)
# end class adiType


class veicProdType(GeneratedsSuper):
    """Veículos novos"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('tpOp', ['tpOpType', 'xs:string'], 0, 0, {'name': 'tpOp', 'type': 'xs:string'}, None),
        MemberSpec_('chassi', ['chassiType', 'xs:string'], 0, 0, {'name': 'chassi', 'type': 'xs:string'}, None),
        MemberSpec_('cCor', ['cCorType', 'TString', 'xs:string'], 0, 0, {'name': 'cCor', 'type': 'xs:string'}, None),
        MemberSpec_('xCor', ['xCorType', 'TString', 'xs:string'], 0, 0, {'name': 'xCor', 'type': 'xs:string'}, None),
        MemberSpec_('pot', ['potType', 'TString', 'xs:string'], 0, 0, {'name': 'pot', 'type': 'xs:string'}, None),
        MemberSpec_('cilin', ['cilinType', 'TString', 'xs:string'], 0, 0, {'name': 'cilin', 'type': 'xs:string'}, None),
        MemberSpec_('pesoL', ['pesoLType', 'TString', 'xs:string'], 0, 0, {'name': 'pesoL', 'type': 'xs:string'}, None),
        MemberSpec_('pesoB', ['pesoBType', 'TString', 'xs:string'], 0, 0, {'name': 'pesoB', 'type': 'xs:string'}, None),
        MemberSpec_('nSerie', ['nSerieType', 'TString', 'xs:string'], 0, 0, {'name': 'nSerie', 'type': 'xs:string'}, None),
        MemberSpec_('tpComb', ['tpCombType', 'TString', 'xs:string'], 0, 0, {'name': 'tpComb', 'type': 'xs:string'}, None),
        MemberSpec_('nMotor', ['nMotorType', 'TString', 'xs:string'], 0, 0, {'name': 'nMotor', 'type': 'xs:string'}, None),
        MemberSpec_('CMT', ['CMTType', 'TString', 'xs:string'], 0, 0, {'name': 'CMT', 'type': 'xs:string'}, None),
        MemberSpec_('dist', ['distType', 'TString', 'xs:string'], 0, 0, {'name': 'dist', 'type': 'xs:string'}, None),
        MemberSpec_('anoMod', ['anoModType', 'xs:string'], 0, 0, {'name': 'anoMod', 'type': 'xs:string'}, None),
        MemberSpec_('anoFab', ['anoFabType', 'xs:string'], 0, 0, {'name': 'anoFab', 'type': 'xs:string'}, None),
        MemberSpec_('tpPint', ['tpPintType', 'TString', 'xs:string'], 0, 0, {'name': 'tpPint', 'type': 'xs:string'}, None),
        MemberSpec_('tpVeic', ['tpVeicType', 'xs:string'], 0, 0, {'name': 'tpVeic', 'type': 'xs:string'}, None),
        MemberSpec_('espVeic', ['espVeicType', 'xs:string'], 0, 0, {'name': 'espVeic', 'type': 'xs:string'}, None),
        MemberSpec_('VIN', ['VINType', 'TString', 'xs:string'], 0, 0, {'name': 'VIN', 'type': 'xs:string'}, None),
        MemberSpec_('condVeic', ['condVeicType', 'xs:string'], 0, 0, {'name': 'condVeic', 'type': 'xs:string'}, None),
        MemberSpec_('cMod', ['cModType', 'xs:string'], 0, 0, {'name': 'cMod', 'type': 'xs:string'}, None),
        MemberSpec_('cCorDENATRAN', ['cCorDENATRANType', 'xs:string'], 0, 0, {'name': 'cCorDENATRAN', 'type': 'xs:string'}, None),
        MemberSpec_('lota', ['lotaType', 'xs:string'], 0, 0, {'name': 'lota', 'type': 'xs:string'}, None),
        MemberSpec_('tpRest', ['tpRestType', 'xs:string'], 0, 0, {'name': 'tpRest', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, tpOp=None, chassi=None, cCor=None, xCor=None, pot=None, cilin=None, pesoL=None, pesoB=None, nSerie=None, tpComb=None, nMotor=None, CMT=None, dist=None, anoMod=None, anoFab=None, tpPint=None, tpVeic=None, espVeic=None, VIN=None, condVeic=None, cMod=None, cCorDENATRAN=None, lota=None, tpRest=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.tpOp = tpOp
        self.validate_tpOpType(self.tpOp)
        self.tpOp_nsprefix_ = None
        self.chassi = chassi
        self.validate_chassiType(self.chassi)
        self.chassi_nsprefix_ = None
        self.cCor = cCor
        self.validate_cCorType(self.cCor)
        self.cCor_nsprefix_ = None
        self.xCor = xCor
        self.validate_xCorType(self.xCor)
        self.xCor_nsprefix_ = None
        self.pot = pot
        self.validate_potType(self.pot)
        self.pot_nsprefix_ = None
        self.cilin = cilin
        self.validate_cilinType(self.cilin)
        self.cilin_nsprefix_ = None
        self.pesoL = pesoL
        self.validate_pesoLType(self.pesoL)
        self.pesoL_nsprefix_ = None
        self.pesoB = pesoB
        self.validate_pesoBType(self.pesoB)
        self.pesoB_nsprefix_ = None
        self.nSerie = nSerie
        self.validate_nSerieType(self.nSerie)
        self.nSerie_nsprefix_ = None
        self.tpComb = tpComb
        self.validate_tpCombType(self.tpComb)
        self.tpComb_nsprefix_ = None
        self.nMotor = nMotor
        self.validate_nMotorType(self.nMotor)
        self.nMotor_nsprefix_ = None
        self.CMT = CMT
        self.validate_CMTType(self.CMT)
        self.CMT_nsprefix_ = None
        self.dist = dist
        self.validate_distType(self.dist)
        self.dist_nsprefix_ = None
        self.anoMod = anoMod
        self.validate_anoModType(self.anoMod)
        self.anoMod_nsprefix_ = None
        self.anoFab = anoFab
        self.validate_anoFabType(self.anoFab)
        self.anoFab_nsprefix_ = None
        self.tpPint = tpPint
        self.validate_tpPintType(self.tpPint)
        self.tpPint_nsprefix_ = None
        self.tpVeic = tpVeic
        self.validate_tpVeicType(self.tpVeic)
        self.tpVeic_nsprefix_ = None
        self.espVeic = espVeic
        self.validate_espVeicType(self.espVeic)
        self.espVeic_nsprefix_ = None
        self.VIN = VIN
        self.validate_VINType(self.VIN)
        self.VIN_nsprefix_ = None
        self.condVeic = condVeic
        self.validate_condVeicType(self.condVeic)
        self.condVeic_nsprefix_ = None
        self.cMod = cMod
        self.validate_cModType(self.cMod)
        self.cMod_nsprefix_ = None
        self.cCorDENATRAN = cCorDENATRAN
        self.validate_cCorDENATRANType(self.cCorDENATRAN)
        self.cCorDENATRAN_nsprefix_ = None
        self.lota = lota
        self.validate_lotaType(self.lota)
        self.lota_nsprefix_ = None
        self.tpRest = tpRest
        self.validate_tpRestType(self.tpRest)
        self.tpRest_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, veicProdType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if veicProdType.subclass:
            return veicProdType.subclass(*args_, **kwargs_)
        else:
            return veicProdType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_tpOpType(self, value):
        result = True
        # Validate type tpOpType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on tpOpType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_chassiType(self, value):
        result = True
        # Validate type chassiType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) != 17:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on chassiType' % {"value": encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_chassiType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_chassiType_patterns_, ))
                result = False
        return result
    validate_chassiType_patterns_ = [['^([A-Z0-9]+)$']]
    def validate_cCorType(self, value):
        result = True
        # Validate type cCorType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 4:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on cCorType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on cCorType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_cCorType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cCorType_patterns_, ))
                result = False
        return result
    validate_cCorType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_xCorType(self, value):
        result = True
        # Validate type xCorType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 40:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xCorType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xCorType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xCorType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xCorType_patterns_, ))
                result = False
        return result
    validate_xCorType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_potType(self, value):
        result = True
        # Validate type potType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 4:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on potType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on potType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_potType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_potType_patterns_, ))
                result = False
        return result
    validate_potType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_cilinType(self, value):
        result = True
        # Validate type cilinType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 4:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on cilinType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on cilinType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_cilinType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cilinType_patterns_, ))
                result = False
        return result
    validate_cilinType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_pesoLType(self, value):
        result = True
        # Validate type pesoLType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 9:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on pesoLType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on pesoLType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_pesoLType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_pesoLType_patterns_, ))
                result = False
        return result
    validate_pesoLType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_pesoBType(self, value):
        result = True
        # Validate type pesoBType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 9:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on pesoBType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on pesoBType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_pesoBType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_pesoBType_patterns_, ))
                result = False
        return result
    validate_pesoBType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_nSerieType(self, value):
        result = True
        # Validate type nSerieType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 9:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on nSerieType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nSerieType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_nSerieType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nSerieType_patterns_, ))
                result = False
        return result
    validate_nSerieType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_tpCombType(self, value):
        result = True
        # Validate type tpCombType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on tpCombType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on tpCombType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_tpCombType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_tpCombType_patterns_, ))
                result = False
        return result
    validate_tpCombType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_nMotorType(self, value):
        result = True
        # Validate type nMotorType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 21:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on nMotorType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nMotorType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_nMotorType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nMotorType_patterns_, ))
                result = False
        return result
    validate_nMotorType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_CMTType(self, value):
        result = True
        # Validate type CMTType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 9:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on CMTType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on CMTType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_CMTType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_CMTType_patterns_, ))
                result = False
        return result
    validate_CMTType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_distType(self, value):
        result = True
        # Validate type distType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 4:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on distType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on distType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_distType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_distType_patterns_, ))
                result = False
        return result
    validate_distType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_anoModType(self, value):
        result = True
        # Validate type anoModType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_anoModType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_anoModType_patterns_, ))
                result = False
        return result
    validate_anoModType_patterns_ = [['^([0-9]{4})$']]
    def validate_anoFabType(self, value):
        result = True
        # Validate type anoFabType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_anoFabType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_anoFabType_patterns_, ))
                result = False
        return result
    validate_anoFabType_patterns_ = [['^([0-9]{4})$']]
    def validate_tpPintType(self, value):
        result = True
        # Validate type tpPintType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) != 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on tpPintType' % {"value": value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_tpPintType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_tpPintType_patterns_, ))
                result = False
        return result
    validate_tpPintType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_tpVeicType(self, value):
        result = True
        # Validate type tpVeicType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_tpVeicType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_tpVeicType_patterns_, ))
                result = False
        return result
    validate_tpVeicType_patterns_ = [['^([0-9]{1,2})$']]
    def validate_espVeicType(self, value):
        result = True
        # Validate type espVeicType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_espVeicType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_espVeicType_patterns_, ))
                result = False
        return result
    validate_espVeicType_patterns_ = [['^([0-9]{1})$']]
    def validate_VINType(self, value):
        result = True
        # Validate type VINType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['R', 'N']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on VINType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) != 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on VINType' % {"value": value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_VINType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_VINType_patterns_, ))
                result = False
        return result
    validate_VINType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_condVeicType(self, value):
        result = True
        # Validate type condVeicType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['1', '2', '3']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on condVeicType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_cModType(self, value):
        result = True
        # Validate type cModType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_cModType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cModType_patterns_, ))
                result = False
        return result
    validate_cModType_patterns_ = [['^([0-9]{1,6})$']]
    def validate_cCorDENATRANType(self, value):
        result = True
        # Validate type cCorDENATRANType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on cCorDENATRANType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on cCorDENATRANType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_cCorDENATRANType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cCorDENATRANType_patterns_, ))
                result = False
        return result
    validate_cCorDENATRANType_patterns_ = [['^([0-9]{1,2})$']]
    def validate_lotaType(self, value):
        result = True
        # Validate type lotaType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on lotaType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on lotaType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_lotaType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_lotaType_patterns_, ))
                result = False
        return result
    validate_lotaType_patterns_ = [['^([0-9]{1,3})$']]
    def validate_tpRestType(self, value):
        result = True
        # Validate type tpRestType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '9']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on tpRestType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def hasContent_(self):
        if (
            self.tpOp is not None or
            self.chassi is not None or
            self.cCor is not None or
            self.xCor is not None or
            self.pot is not None or
            self.cilin is not None or
            self.pesoL is not None or
            self.pesoB is not None or
            self.nSerie is not None or
            self.tpComb is not None or
            self.nMotor is not None or
            self.CMT is not None or
            self.dist is not None or
            self.anoMod is not None or
            self.anoFab is not None or
            self.tpPint is not None or
            self.tpVeic is not None or
            self.espVeic is not None or
            self.VIN is not None or
            self.condVeic is not None or
            self.cMod is not None or
            self.cCorDENATRAN is not None or
            self.lota is not None or
            self.tpRest is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='veicProdType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('veicProdType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'veicProdType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='veicProdType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='veicProdType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='veicProdType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='veicProdType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.tpOp is not None:
            namespaceprefix_ = self.tpOp_nsprefix_ + ':' if (UseCapturedNS_ and self.tpOp_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stpOp>%s</%stpOp>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tpOp), input_name='tpOp')), namespaceprefix_ , eol_))
        if self.chassi is not None:
            namespaceprefix_ = self.chassi_nsprefix_ + ':' if (UseCapturedNS_ and self.chassi_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%schassi>%s</%schassi>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.chassi), input_name='chassi')), namespaceprefix_ , eol_))
        if self.cCor is not None:
            namespaceprefix_ = self.cCor_nsprefix_ + ':' if (UseCapturedNS_ and self.cCor_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scCor>%s</%scCor>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cCor), input_name='cCor')), namespaceprefix_ , eol_))
        if self.xCor is not None:
            namespaceprefix_ = self.xCor_nsprefix_ + ':' if (UseCapturedNS_ and self.xCor_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxCor>%s</%sxCor>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xCor), input_name='xCor')), namespaceprefix_ , eol_))
        if self.pot is not None:
            namespaceprefix_ = self.pot_nsprefix_ + ':' if (UseCapturedNS_ and self.pot_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spot>%s</%spot>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pot), input_name='pot')), namespaceprefix_ , eol_))
        if self.cilin is not None:
            namespaceprefix_ = self.cilin_nsprefix_ + ':' if (UseCapturedNS_ and self.cilin_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scilin>%s</%scilin>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cilin), input_name='cilin')), namespaceprefix_ , eol_))
        if self.pesoL is not None:
            namespaceprefix_ = self.pesoL_nsprefix_ + ':' if (UseCapturedNS_ and self.pesoL_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spesoL>%s</%spesoL>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pesoL), input_name='pesoL')), namespaceprefix_ , eol_))
        if self.pesoB is not None:
            namespaceprefix_ = self.pesoB_nsprefix_ + ':' if (UseCapturedNS_ and self.pesoB_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spesoB>%s</%spesoB>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pesoB), input_name='pesoB')), namespaceprefix_ , eol_))
        if self.nSerie is not None:
            namespaceprefix_ = self.nSerie_nsprefix_ + ':' if (UseCapturedNS_ and self.nSerie_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snSerie>%s</%snSerie>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nSerie), input_name='nSerie')), namespaceprefix_ , eol_))
        if self.tpComb is not None:
            namespaceprefix_ = self.tpComb_nsprefix_ + ':' if (UseCapturedNS_ and self.tpComb_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stpComb>%s</%stpComb>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tpComb), input_name='tpComb')), namespaceprefix_ , eol_))
        if self.nMotor is not None:
            namespaceprefix_ = self.nMotor_nsprefix_ + ':' if (UseCapturedNS_ and self.nMotor_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snMotor>%s</%snMotor>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nMotor), input_name='nMotor')), namespaceprefix_ , eol_))
        if self.CMT is not None:
            namespaceprefix_ = self.CMT_nsprefix_ + ':' if (UseCapturedNS_ and self.CMT_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCMT>%s</%sCMT>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CMT), input_name='CMT')), namespaceprefix_ , eol_))
        if self.dist is not None:
            namespaceprefix_ = self.dist_nsprefix_ + ':' if (UseCapturedNS_ and self.dist_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdist>%s</%sdist>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.dist), input_name='dist')), namespaceprefix_ , eol_))
        if self.anoMod is not None:
            namespaceprefix_ = self.anoMod_nsprefix_ + ':' if (UseCapturedNS_ and self.anoMod_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sanoMod>%s</%sanoMod>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.anoMod), input_name='anoMod')), namespaceprefix_ , eol_))
        if self.anoFab is not None:
            namespaceprefix_ = self.anoFab_nsprefix_ + ':' if (UseCapturedNS_ and self.anoFab_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sanoFab>%s</%sanoFab>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.anoFab), input_name='anoFab')), namespaceprefix_ , eol_))
        if self.tpPint is not None:
            namespaceprefix_ = self.tpPint_nsprefix_ + ':' if (UseCapturedNS_ and self.tpPint_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stpPint>%s</%stpPint>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tpPint), input_name='tpPint')), namespaceprefix_ , eol_))
        if self.tpVeic is not None:
            namespaceprefix_ = self.tpVeic_nsprefix_ + ':' if (UseCapturedNS_ and self.tpVeic_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stpVeic>%s</%stpVeic>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tpVeic), input_name='tpVeic')), namespaceprefix_ , eol_))
        if self.espVeic is not None:
            namespaceprefix_ = self.espVeic_nsprefix_ + ':' if (UseCapturedNS_ and self.espVeic_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sespVeic>%s</%sespVeic>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.espVeic), input_name='espVeic')), namespaceprefix_ , eol_))
        if self.VIN is not None:
            namespaceprefix_ = self.VIN_nsprefix_ + ':' if (UseCapturedNS_ and self.VIN_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sVIN>%s</%sVIN>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.VIN), input_name='VIN')), namespaceprefix_ , eol_))
        if self.condVeic is not None:
            namespaceprefix_ = self.condVeic_nsprefix_ + ':' if (UseCapturedNS_ and self.condVeic_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scondVeic>%s</%scondVeic>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.condVeic), input_name='condVeic')), namespaceprefix_ , eol_))
        if self.cMod is not None:
            namespaceprefix_ = self.cMod_nsprefix_ + ':' if (UseCapturedNS_ and self.cMod_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scMod>%s</%scMod>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cMod), input_name='cMod')), namespaceprefix_ , eol_))
        if self.cCorDENATRAN is not None:
            namespaceprefix_ = self.cCorDENATRAN_nsprefix_ + ':' if (UseCapturedNS_ and self.cCorDENATRAN_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scCorDENATRAN>%s</%scCorDENATRAN>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cCorDENATRAN), input_name='cCorDENATRAN')), namespaceprefix_ , eol_))
        if self.lota is not None:
            namespaceprefix_ = self.lota_nsprefix_ + ':' if (UseCapturedNS_ and self.lota_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slota>%s</%slota>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.lota), input_name='lota')), namespaceprefix_ , eol_))
        if self.tpRest is not None:
            namespaceprefix_ = self.tpRest_nsprefix_ + ':' if (UseCapturedNS_ and self.tpRest_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stpRest>%s</%stpRest>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tpRest), input_name='tpRest')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'tpOp':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tpOp')
            value_ = self.gds_validate_string(value_, node, 'tpOp')
            self.tpOp = value_
            self.tpOp_nsprefix_ = child_.prefix
            # validate type tpOpType
            self.validate_tpOpType(self.tpOp)
        elif nodeName_ == 'chassi':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'chassi')
            value_ = self.gds_validate_string(value_, node, 'chassi')
            self.chassi = value_
            self.chassi_nsprefix_ = child_.prefix
            # validate type chassiType
            self.validate_chassiType(self.chassi)
        elif nodeName_ == 'cCor':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cCor')
            value_ = self.gds_validate_string(value_, node, 'cCor')
            self.cCor = value_
            self.cCor_nsprefix_ = child_.prefix
            # validate type cCorType
            self.validate_cCorType(self.cCor)
        elif nodeName_ == 'xCor':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xCor')
            value_ = self.gds_validate_string(value_, node, 'xCor')
            self.xCor = value_
            self.xCor_nsprefix_ = child_.prefix
            # validate type xCorType
            self.validate_xCorType(self.xCor)
        elif nodeName_ == 'pot':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pot')
            value_ = self.gds_validate_string(value_, node, 'pot')
            self.pot = value_
            self.pot_nsprefix_ = child_.prefix
            # validate type potType
            self.validate_potType(self.pot)
        elif nodeName_ == 'cilin':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cilin')
            value_ = self.gds_validate_string(value_, node, 'cilin')
            self.cilin = value_
            self.cilin_nsprefix_ = child_.prefix
            # validate type cilinType
            self.validate_cilinType(self.cilin)
        elif nodeName_ == 'pesoL':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pesoL')
            value_ = self.gds_validate_string(value_, node, 'pesoL')
            self.pesoL = value_
            self.pesoL_nsprefix_ = child_.prefix
            # validate type pesoLType
            self.validate_pesoLType(self.pesoL)
        elif nodeName_ == 'pesoB':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pesoB')
            value_ = self.gds_validate_string(value_, node, 'pesoB')
            self.pesoB = value_
            self.pesoB_nsprefix_ = child_.prefix
            # validate type pesoBType
            self.validate_pesoBType(self.pesoB)
        elif nodeName_ == 'nSerie':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nSerie')
            value_ = self.gds_validate_string(value_, node, 'nSerie')
            self.nSerie = value_
            self.nSerie_nsprefix_ = child_.prefix
            # validate type nSerieType
            self.validate_nSerieType(self.nSerie)
        elif nodeName_ == 'tpComb':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tpComb')
            value_ = self.gds_validate_string(value_, node, 'tpComb')
            self.tpComb = value_
            self.tpComb_nsprefix_ = child_.prefix
            # validate type tpCombType
            self.validate_tpCombType(self.tpComb)
        elif nodeName_ == 'nMotor':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nMotor')
            value_ = self.gds_validate_string(value_, node, 'nMotor')
            self.nMotor = value_
            self.nMotor_nsprefix_ = child_.prefix
            # validate type nMotorType
            self.validate_nMotorType(self.nMotor)
        elif nodeName_ == 'CMT':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CMT')
            value_ = self.gds_validate_string(value_, node, 'CMT')
            self.CMT = value_
            self.CMT_nsprefix_ = child_.prefix
            # validate type CMTType
            self.validate_CMTType(self.CMT)
        elif nodeName_ == 'dist':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'dist')
            value_ = self.gds_validate_string(value_, node, 'dist')
            self.dist = value_
            self.dist_nsprefix_ = child_.prefix
            # validate type distType
            self.validate_distType(self.dist)
        elif nodeName_ == 'anoMod':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'anoMod')
            value_ = self.gds_validate_string(value_, node, 'anoMod')
            self.anoMod = value_
            self.anoMod_nsprefix_ = child_.prefix
            # validate type anoModType
            self.validate_anoModType(self.anoMod)
        elif nodeName_ == 'anoFab':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'anoFab')
            value_ = self.gds_validate_string(value_, node, 'anoFab')
            self.anoFab = value_
            self.anoFab_nsprefix_ = child_.prefix
            # validate type anoFabType
            self.validate_anoFabType(self.anoFab)
        elif nodeName_ == 'tpPint':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tpPint')
            value_ = self.gds_validate_string(value_, node, 'tpPint')
            self.tpPint = value_
            self.tpPint_nsprefix_ = child_.prefix
            # validate type tpPintType
            self.validate_tpPintType(self.tpPint)
        elif nodeName_ == 'tpVeic':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tpVeic')
            value_ = self.gds_validate_string(value_, node, 'tpVeic')
            self.tpVeic = value_
            self.tpVeic_nsprefix_ = child_.prefix
            # validate type tpVeicType
            self.validate_tpVeicType(self.tpVeic)
        elif nodeName_ == 'espVeic':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'espVeic')
            value_ = self.gds_validate_string(value_, node, 'espVeic')
            self.espVeic = value_
            self.espVeic_nsprefix_ = child_.prefix
            # validate type espVeicType
            self.validate_espVeicType(self.espVeic)
        elif nodeName_ == 'VIN':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'VIN')
            value_ = self.gds_validate_string(value_, node, 'VIN')
            self.VIN = value_
            self.VIN_nsprefix_ = child_.prefix
            # validate type VINType
            self.validate_VINType(self.VIN)
        elif nodeName_ == 'condVeic':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'condVeic')
            value_ = self.gds_validate_string(value_, node, 'condVeic')
            self.condVeic = value_
            self.condVeic_nsprefix_ = child_.prefix
            # validate type condVeicType
            self.validate_condVeicType(self.condVeic)
        elif nodeName_ == 'cMod':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cMod')
            value_ = self.gds_validate_string(value_, node, 'cMod')
            self.cMod = value_
            self.cMod_nsprefix_ = child_.prefix
            # validate type cModType
            self.validate_cModType(self.cMod)
        elif nodeName_ == 'cCorDENATRAN':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cCorDENATRAN')
            value_ = self.gds_validate_string(value_, node, 'cCorDENATRAN')
            self.cCorDENATRAN = value_
            self.cCorDENATRAN_nsprefix_ = child_.prefix
            # validate type cCorDENATRANType
            self.validate_cCorDENATRANType(self.cCorDENATRAN)
        elif nodeName_ == 'lota':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'lota')
            value_ = self.gds_validate_string(value_, node, 'lota')
            self.lota = value_
            self.lota_nsprefix_ = child_.prefix
            # validate type lotaType
            self.validate_lotaType(self.lota)
        elif nodeName_ == 'tpRest':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tpRest')
            value_ = self.gds_validate_string(value_, node, 'tpRest')
            self.tpRest = value_
            self.tpRest_nsprefix_ = child_.prefix
            # validate type tpRestType
            self.validate_tpRestType(self.tpRest)
# end class veicProdType


class medType(GeneratedsSuper):
    """grupo do detalhamento de Medicamentos e de matérias-primas
    farmacêuticas"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('nLote', ['nLoteType', 'TString', 'xs:string'], 0, 0, {'name': 'nLote', 'type': 'xs:string'}, None),
        MemberSpec_('qLote', ['TDec_0803', 'xs:string'], 0, 0, {'name': 'qLote', 'type': 'xs:string'}, None),
        MemberSpec_('dFab', ['TData', 'xs:string'], 0, 0, {'name': 'dFab', 'type': 'xs:string'}, None),
        MemberSpec_('dVal', ['TData', 'xs:string'], 0, 0, {'name': 'dVal', 'type': 'xs:string'}, None),
        MemberSpec_('vPMC', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vPMC', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, nLote=None, qLote=None, dFab=None, dVal=None, vPMC=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nLote = nLote
        self.validate_nLoteType(self.nLote)
        self.nLote_nsprefix_ = None
        self.qLote = qLote
        self.validate_TDec_0803(self.qLote)
        self.qLote_nsprefix_ = None
        self.dFab = dFab
        self.validate_TData(self.dFab)
        self.dFab_nsprefix_ = None
        self.dVal = dVal
        self.validate_TData(self.dVal)
        self.dVal_nsprefix_ = None
        self.vPMC = vPMC
        self.validate_TDec_1302(self.vPMC)
        self.vPMC_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, medType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if medType.subclass:
            return medType.subclass(*args_, **kwargs_)
        else:
            return medType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_nLoteType(self, value):
        result = True
        # Validate type nLoteType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 20:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on nLoteType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nLoteType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_nLoteType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nLoteType_patterns_, ))
                result = False
        return result
    validate_nLoteType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TDec_0803(self, value):
        result = True
        # Validate type TDec_0803, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0803_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0803_patterns_, ))
                result = False
        return result
    validate_TDec_0803_patterns_ = [['^(0|0\\.[0-9]{3}|[1-9]{1}[0-9]{0,7}(\\.[0-9]{3})?)$']]
    def validate_TData(self, value):
        result = True
        # Validate type TData, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TData_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TData_patterns_, ))
                result = False
        return result
    validate_TData_patterns_ = [['^((((20(([02468][048])|([13579][26]))-02-29))|(20[0-9][0-9])-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\\d)|(2[0-8])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30))))))$']]
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def hasContent_(self):
        if (
            self.nLote is not None or
            self.qLote is not None or
            self.dFab is not None or
            self.dVal is not None or
            self.vPMC is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='medType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('medType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'medType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='medType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='medType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='medType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='medType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.nLote is not None:
            namespaceprefix_ = self.nLote_nsprefix_ + ':' if (UseCapturedNS_ and self.nLote_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snLote>%s</%snLote>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nLote), input_name='nLote')), namespaceprefix_ , eol_))
        if self.qLote is not None:
            namespaceprefix_ = self.qLote_nsprefix_ + ':' if (UseCapturedNS_ and self.qLote_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sqLote>%s</%sqLote>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.qLote), input_name='qLote')), namespaceprefix_ , eol_))
        if self.dFab is not None:
            namespaceprefix_ = self.dFab_nsprefix_ + ':' if (UseCapturedNS_ and self.dFab_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdFab>%s</%sdFab>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.dFab), input_name='dFab')), namespaceprefix_ , eol_))
        if self.dVal is not None:
            namespaceprefix_ = self.dVal_nsprefix_ + ':' if (UseCapturedNS_ and self.dVal_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdVal>%s</%sdVal>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.dVal), input_name='dVal')), namespaceprefix_ , eol_))
        if self.vPMC is not None:
            namespaceprefix_ = self.vPMC_nsprefix_ + ':' if (UseCapturedNS_ and self.vPMC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svPMC>%s</%svPMC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vPMC), input_name='vPMC')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'nLote':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nLote')
            value_ = self.gds_validate_string(value_, node, 'nLote')
            self.nLote = value_
            self.nLote_nsprefix_ = child_.prefix
            # validate type nLoteType
            self.validate_nLoteType(self.nLote)
        elif nodeName_ == 'qLote':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'qLote')
            value_ = self.gds_validate_string(value_, node, 'qLote')
            self.qLote = value_
            self.qLote_nsprefix_ = child_.prefix
            # validate type TDec_0803
            self.validate_TDec_0803(self.qLote)
        elif nodeName_ == 'dFab':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'dFab')
            value_ = self.gds_validate_string(value_, node, 'dFab')
            self.dFab = value_
            self.dFab_nsprefix_ = child_.prefix
            # validate type TData
            self.validate_TData(self.dFab)
        elif nodeName_ == 'dVal':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'dVal')
            value_ = self.gds_validate_string(value_, node, 'dVal')
            self.dVal = value_
            self.dVal_nsprefix_ = child_.prefix
            # validate type TData
            self.validate_TData(self.dVal)
        elif nodeName_ == 'vPMC':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vPMC')
            value_ = self.gds_validate_string(value_, node, 'vPMC')
            self.vPMC = value_
            self.vPMC_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vPMC)
# end class medType


class armaType(GeneratedsSuper):
    """Armamentos"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('tpArma', ['tpArmaType', 'xs:string'], 0, 0, {'name': 'tpArma', 'type': 'xs:string'}, None),
        MemberSpec_('nSerie', ['nSerieType5', 'TString', 'xs:string'], 0, 0, {'name': 'nSerie', 'type': 'xs:string'}, None),
        MemberSpec_('nCano', ['nCanoType', 'TString', 'xs:string'], 0, 0, {'name': 'nCano', 'type': 'xs:string'}, None),
        MemberSpec_('descr', ['descrType', 'TString', 'xs:string'], 0, 0, {'name': 'descr', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, tpArma=None, nSerie=None, nCano=None, descr=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.tpArma = tpArma
        self.validate_tpArmaType(self.tpArma)
        self.tpArma_nsprefix_ = None
        self.nSerie = nSerie
        self.validate_nSerieType5(self.nSerie)
        self.nSerie_nsprefix_ = None
        self.nCano = nCano
        self.validate_nCanoType(self.nCano)
        self.nCano_nsprefix_ = None
        self.descr = descr
        self.validate_descrType(self.descr)
        self.descr_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, armaType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if armaType.subclass:
            return armaType.subclass(*args_, **kwargs_)
        else:
            return armaType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_tpArmaType(self, value):
        result = True
        # Validate type tpArmaType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on tpArmaType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_nSerieType5(self, value):
        result = True
        # Validate type nSerieType5, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 9:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on nSerieType5' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nSerieType5' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_nSerieType5_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nSerieType5_patterns_, ))
                result = False
        return result
    validate_nSerieType5_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_nCanoType(self, value):
        result = True
        # Validate type nCanoType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 9:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on nCanoType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nCanoType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_nCanoType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nCanoType_patterns_, ))
                result = False
        return result
    validate_nCanoType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_descrType(self, value):
        result = True
        # Validate type descrType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 256:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on descrType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on descrType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_descrType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_descrType_patterns_, ))
                result = False
        return result
    validate_descrType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def hasContent_(self):
        if (
            self.tpArma is not None or
            self.nSerie is not None or
            self.nCano is not None or
            self.descr is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='armaType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('armaType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'armaType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='armaType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='armaType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='armaType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='armaType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.tpArma is not None:
            namespaceprefix_ = self.tpArma_nsprefix_ + ':' if (UseCapturedNS_ and self.tpArma_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stpArma>%s</%stpArma>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tpArma), input_name='tpArma')), namespaceprefix_ , eol_))
        if self.nSerie is not None:
            namespaceprefix_ = self.nSerie_nsprefix_ + ':' if (UseCapturedNS_ and self.nSerie_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snSerie>%s</%snSerie>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nSerie), input_name='nSerie')), namespaceprefix_ , eol_))
        if self.nCano is not None:
            namespaceprefix_ = self.nCano_nsprefix_ + ':' if (UseCapturedNS_ and self.nCano_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snCano>%s</%snCano>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nCano), input_name='nCano')), namespaceprefix_ , eol_))
        if self.descr is not None:
            namespaceprefix_ = self.descr_nsprefix_ + ':' if (UseCapturedNS_ and self.descr_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescr>%s</%sdescr>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.descr), input_name='descr')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'tpArma':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tpArma')
            value_ = self.gds_validate_string(value_, node, 'tpArma')
            self.tpArma = value_
            self.tpArma_nsprefix_ = child_.prefix
            # validate type tpArmaType
            self.validate_tpArmaType(self.tpArma)
        elif nodeName_ == 'nSerie':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nSerie')
            value_ = self.gds_validate_string(value_, node, 'nSerie')
            self.nSerie = value_
            self.nSerie_nsprefix_ = child_.prefix
            # validate type nSerieType5
            self.validate_nSerieType5(self.nSerie)
        elif nodeName_ == 'nCano':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nCano')
            value_ = self.gds_validate_string(value_, node, 'nCano')
            self.nCano = value_
            self.nCano_nsprefix_ = child_.prefix
            # validate type nCanoType
            self.validate_nCanoType(self.nCano)
        elif nodeName_ == 'descr':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'descr')
            value_ = self.gds_validate_string(value_, node, 'descr')
            self.descr = value_
            self.descr_nsprefix_ = child_.prefix
            # validate type descrType
            self.validate_descrType(self.descr)
# end class armaType


class combType(GeneratedsSuper):
    """Informar apenas para operações com combustíveis líquidos"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('cProdANP', ['TcProdANP', 'xs:string'], 0, 0, {'name': 'cProdANP', 'type': 'xs:string'}, None),
        MemberSpec_('CODIF', ['CODIFType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'CODIF', 'type': 'xs:string'}, None),
        MemberSpec_('qTemp', ['TDec_1204Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'qTemp', 'type': 'xs:string'}, None),
        MemberSpec_('UFCons', ['TUf', 'xs:string'], 0, 0, {'name': 'UFCons', 'type': 'xs:string'}, None),
        MemberSpec_('CIDE', 'CIDEType', 0, 1, {'minOccurs': '0', 'name': 'CIDE', 'type': 'CIDEType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, cProdANP=None, CODIF=None, qTemp=None, UFCons=None, CIDE=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.cProdANP = cProdANP
        self.validate_TcProdANP(self.cProdANP)
        self.cProdANP_nsprefix_ = None
        self.CODIF = CODIF
        self.validate_CODIFType(self.CODIF)
        self.CODIF_nsprefix_ = None
        self.qTemp = qTemp
        self.validate_TDec_1204Opc(self.qTemp)
        self.qTemp_nsprefix_ = None
        self.UFCons = UFCons
        self.validate_TUf(self.UFCons)
        self.UFCons_nsprefix_ = None
        self.CIDE = CIDE
        self.CIDE_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, combType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if combType.subclass:
            return combType.subclass(*args_, **kwargs_)
        else:
            return combType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TcProdANP(self, value):
        result = True
        # Validate type TcProdANP, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['110203073', '110204001', '110204002', '140101027', '140101026', '740101005', '740101004', '740101001', '740101006', '740101002', '110203083', '910101001', '110103001', '330101001', '110203091', '120204001', '110106001', '120206001', '110101001', '110101042', '810201001', '110204003', '330201005', '330201006', '330201004', '110105001', '110203072', '110203001', '110201001', '110101002', '110203002', '120205010', '110203003', '110204004', '110204005', '110204006', '110204007', '110204008', '110204009', '110204010', '110204011', '110105027', '110103003', '110103002', '110105002', '110205001', '120203002', '120205001', '110203004', '120203001', '530102001', '530101002', '110108001', '110105017', '110206019', '110205023', '110203092', '110201002', '120202001', '110101003', '110101004', '110103004', '110103005', '110101005', '110204012', '110204013', '110204014', '110102001', '120207003', '110201003', '110201004', '110201005', '110201006', '110206001', '110205002', '110203005', '110205003', '330201001', '110206002', '110101006', '110101007', '110101038', '120205002', '820101001', '820101010', '820101999', '110206003', '110201007', '120201001', '110201008', '110103017', '110205004', '110203077', '110101008', '110203006', '110203007', '110201009', '110203008', '110203009', '110203010', '120203004', '110206004', '610101009', '120205003', '110205005', '110203092', '110204015', '210202003', '210202001', '210202002', '110105018', '110203011', '110203012', '110101009', '110104001', '110104006', '110106010', '110202007', '110106002', '110111002', '110103006', '110105003', '110201010', '110201011', '110201012', '110101010', '110101011', '110108002', '110107001', '120202002', '110106003', '110108003', '110203085', '110201013', '110207001', '110105023', '110101012', '110201014', '620501002', '620501001', '610101005', '610101006', '530101001', '530101020', '530101018', '110205006', '110201015', '110203013', '110202001', '120104001', '120102001', '110205024', '120205009', '540101002', '540101001', '110107002', '620601003', '110201016', '110101013', '120207001', '110206020', '110104008', '110201017', '110108004', '110201018', '330201007', '110205007', '110203086', '110205008', '340101002', '130202002', '430101002', '130202003', '560101002', '130202004', '820101026', '820101032', '820101027', '820101004', '820101005', '820101022', '820101007', '820101002', '820101009', '820101008', '820101014', '820101006', '820101016', '820101015', '820101014', '820101006', '820101031', '820101030', '820101016', '820101015', '820101025', '820101007', '820101002', '820101026', '820101009', '820101008', '820101027', '820101007', '820101002', '820101028', '820101029', '820101009', '820101008', '820101011', '820101003', '820101013', '820101012', '820101017', '820101018', '820101019', '820101020', '820101021', '330101003', '130202006', '110203014', '420201001', '420201003', '120204010', '110103007', '110204017', '110204051', '110204018', '110205022', '110203069', '110203015', '110206005', '110203016', '110203017', '110203018', '110203088', '110203019', '530101003', '530101019', '110101014', '620101002', '720101001', '720101002', '120205004', '110203079', '110203020', '110201019', '110203021', '110108005', '110101015', '110104002', '110101016', '620101007', '140102001', '110105004', '110107003', '110203095', '210301001', '810102001', '810102004', '810102002', '130201002', '810102003', '810101002', '810101001', '810101003', '210301002', '330201010', '110204016', '110105005', '110105006', '110105007', '110104003', '110206006', '110206007', '110203022', '110204019', '110206008', '110206009', '110101043', '110201020', '110203023', '110101017', '110101018', '210302004', '210101001', '210302003', '210302002', '210204001', '220101003', '220101004', '220101002', '220101001', '220101005', '220101006', '130202001', '130202005', '520101001', '320101001', '320101003', '320101002', '320103001', '320102002', '320102001', '320102004', '320102003', '320201001', '320201002', '220102001', '320301002', '110204020', '110203024', '120205012', '110207002', '110203087', '730101002', '210203001', '210203002', '110104005', '140101023', '140101024', '140101025', '650101001', '110207003', '110201021', '110103013', '110201022', '110203025', '110203026', '110206011', '110206010', '110203027', '110203028', '110203028', '330101008', '330101002', '330101009', '620101001', '610201001', '610201002', '610201003', '710101001', '110203074', '110201023', '110103008', '110203029', '120205005', '110204021', '110204022', '110204023', '620101004', '620101005', '330101010', '110202002', '110202003', '110207004', '110101046', '110204024', '110113001', '110105015', '110101019', '110103015', '110205025', '110204025', '110204026', '110204027', '120204009', '110205026', '110204028', '110204029', '110203080', '120207004', '110203030', '110105025', '110203031', '110203084', '110203032', '110204030', '110205009', '110104004', '110201024', '110201025', '110201026', '110201027', '110201028', '110201029', '110201030', '110207005', '110204031', '110207006', '110201031', '110201032', '110201033', '120204002', '110101020', '220102002', '110105008', '110203033', '110105009', '110201034', '110203034', '110203035', '640201001', '120205011', '110101021', '120103001', '110203036', '120204003', '110201035', '110204032', '110101022', '110201036', '110101023', '110101024', '110101025', '110101039', '110204033', '120207002', '110202004', '110202005', '110203037', '110203037', '110201037', '110203078', '120203005', '120204010', '110201038', '110201039', '120101001', '110201040', '110201041', '740101007', '420201003', '640101001', '110205027', '110103009', '110103010', '110205010', '820101018', '820101017', '820101006', '820101014', '820101006', '820101016', '820101015', '820101006', '820101005', '820101004', '820101003', '820101011', '820101003', '820101013', '820101012', '820101002', '820101007', '820101002', '820101009', '820101008', '110301001', '110208001', '110203038', '110203089', '110201042', '110101026', '620502001', '110203039', '110202008', '110204034', '110110001', '310102001', '310103001', '310101001', '110101027', '110205011', '110201062', '110203040', '610101002', '610401002', '610101003', '610401003', '610101004', '610401004', '110203041', '110203042', '110203043', '110203094', '110203044', '110203044', '430101001', '110206021', '120204004', '110207007', '110203045', '110201043', '110203046', '110203047', '110203048', '110203081', '430101004', '510101003', '510101001', '510101002', '510102003', '510102001', '510102002', '510201001', '510201002', '510201003', '510301003', '140101015', '140101009', '140101016', '140101017', '140101005', '140101014', '140101018', '140101006', '140101028', '140101021', '140101010', '140101012', '140101013', '140101001', '140101011', '140101003', '140101002', '140101008', '140101007', '140101019', '140101004', '560101001', '420105001', '420101005', '420101004', '420101003', '420102006', '420102005', '420102004', '420102003', '420104001', '820101033', '820101034', '820101011', '820101003', '820101028', '820101029', '820101013', '820101012', '420301003', '420101005', '420101002', '420101001', '420101003', '420101004', '420101003', '420201001', '420201002', '420102005', '420102004', '420102002', '420102001', '420102003', '420102003', '420202001', '420301001', '420102006', '420103002', '420103001', '420103003', '610601001', '610701001', '510301002', '620601001', '660101001', '620401001', '620301001', '620201001', '630101001', '110202006', '110203093', '110204035', '110203049', '110201044', '110201045', '110206012', '120203003', '320301001', '320103002', '650101002', '310102002', '640401001', '140101029', '740101003', '810201002', '530103001', '340101003', '430101003', '560101003', '210302001', '210204002', '130201001', '530104001', '140101022', '140101999', '610201004', '510301001', '420301002', '620601004', '620505001', '610501001', '620101008', '610101010', '110208002', '110110002', '130202008', '410103001', '610301002', '610302001', '330101007', '330201009', '730101001', '110203050', '110101028', '110101049', '110101029', '110101030', '110104007', '110111001', '120205006', '110203051', '110101050', '110105028', '110105016', '110201046', '110106007', '110101031', '110203082', '610301001', '110101032', '110101047', '110105021', '110105010', '620101003', '210201001', '210201002', '210201003', '110105020', '110105022', '110205012', '620601002', '120206003', '110204036', '110204037', '110204038', '410101001', '410101002', '410102001', '410102002', '110103014', '110203052', '330101005', '330101006', '110205029', '110203053', '120204008', '110203054', '110204039', '110201047', '110201048', '110103011', '340101001', '550101001', '550101005', '550101002', '550101003', '550101004', '130202007', '110105011', '110201049', '110101048', '110101033', '110101040', '110101045', '110101041', '110204040', '110105019', '110204041', '110105024', '110203070', '110203055', '110204042', '110203075', '110201050', '110201051', '110201052', '110201053', '120201002', '110105029', '110203056', '110204043', '110203090', '140101020', '110103018', '110106004', '110106005', '110106006', '110205028', '110105012', '120204005', '110205013', '110201054', '110101044', '110204044', '110203057', '110203058', '120206002', '120206004', '330201008', '330101004', '110204045', '110204046', '110201063', '110206013', '110203059', '110203060', '610101001', '610401001', '110206015', '110206014', '110204052', '110205015', '110205014', '110204047', '110205016', '110203061', '110205017', '110106009', '110203062', '110206016', '120205007', '120201003', '620101006', '120205008', '120204006', '110201055', '110201056', '110201057', '110103016', '110205018', '110107005', '330201002', '620504001', '620503001', '110101034', '110107004', '610101007', '610101008', '110105014', '110205019', '110103012', '110203063', '120204007', '110204048', '110105013', '110204049', '110206017', '110109001', '110107006', '110201059', '110201058', '640301001', '110101035', '110101036', '110101037', '110205020', '120207005', '110206018', '110108006', '110203076', '110205021', '330201003', '130101001', '110201060', '110203071', '110203065', '110203064', '110204050', '110203066', '110203067', '110201061', '110203068', '110105026', '110106008']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TcProdANP' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CODIFType(self, value):
        result = True
        # Validate type CODIFType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_CODIFType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_CODIFType_patterns_, ))
                result = False
        return result
    validate_CODIFType_patterns_ = [['^([0-9]{0,21})$']]
    def validate_TDec_1204Opc(self, value):
        result = True
        # Validate type TDec_1204Opc, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1204Opc_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1204Opc_patterns_, ))
                result = False
        return result
    validate_TDec_1204Opc_patterns_ = [['^(0\\.[1-9]{1}[0-9]{3}|0\\.[0-9]{3}[1-9]{1}|0\\.[0-9]{2}[1-9]{1}[0-9]{1}|0\\.[0-9]{1}[1-9]{1}[0-9]{2}|[1-9]{1}[0-9]{0,11}(\\.[0-9]{4})?)$']]
    def validate_TUf(self, value):
        result = True
        # Validate type TUf, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['AC', 'AL', 'AM', 'AP', 'BA', 'CE', 'DF', 'ES', 'GO', 'MA', 'MG', 'MS', 'MT', 'PA', 'PB', 'PE', 'PI', 'PR', 'RJ', 'RN', 'RO', 'RR', 'RS', 'SC', 'SE', 'SP', 'TO', 'EX']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TUf' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def hasContent_(self):
        if (
            self.cProdANP is not None or
            self.CODIF is not None or
            self.qTemp is not None or
            self.UFCons is not None or
            self.CIDE is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='combType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('combType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'combType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='combType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='combType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='combType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='combType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.cProdANP is not None:
            namespaceprefix_ = self.cProdANP_nsprefix_ + ':' if (UseCapturedNS_ and self.cProdANP_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scProdANP>%s</%scProdANP>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cProdANP), input_name='cProdANP')), namespaceprefix_ , eol_))
        if self.CODIF is not None:
            namespaceprefix_ = self.CODIF_nsprefix_ + ':' if (UseCapturedNS_ and self.CODIF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCODIF>%s</%sCODIF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CODIF), input_name='CODIF')), namespaceprefix_ , eol_))
        if self.qTemp is not None:
            namespaceprefix_ = self.qTemp_nsprefix_ + ':' if (UseCapturedNS_ and self.qTemp_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sqTemp>%s</%sqTemp>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.qTemp), input_name='qTemp')), namespaceprefix_ , eol_))
        if self.UFCons is not None:
            namespaceprefix_ = self.UFCons_nsprefix_ + ':' if (UseCapturedNS_ and self.UFCons_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUFCons>%s</%sUFCons>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.UFCons), input_name='UFCons')), namespaceprefix_ , eol_))
        if self.CIDE is not None:
            namespaceprefix_ = self.CIDE_nsprefix_ + ':' if (UseCapturedNS_ and self.CIDE_nsprefix_) else ''
            self.CIDE.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CIDE', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'cProdANP':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cProdANP')
            value_ = self.gds_validate_string(value_, node, 'cProdANP')
            self.cProdANP = value_
            self.cProdANP_nsprefix_ = child_.prefix
            # validate type TcProdANP
            self.validate_TcProdANP(self.cProdANP)
        elif nodeName_ == 'CODIF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CODIF')
            value_ = self.gds_validate_string(value_, node, 'CODIF')
            self.CODIF = value_
            self.CODIF_nsprefix_ = child_.prefix
            # validate type CODIFType
            self.validate_CODIFType(self.CODIF)
        elif nodeName_ == 'qTemp':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'qTemp')
            value_ = self.gds_validate_string(value_, node, 'qTemp')
            self.qTemp = value_
            self.qTemp_nsprefix_ = child_.prefix
            # validate type TDec_1204Opc
            self.validate_TDec_1204Opc(self.qTemp)
        elif nodeName_ == 'UFCons':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'UFCons')
            value_ = self.gds_validate_string(value_, node, 'UFCons')
            self.UFCons = value_
            self.UFCons_nsprefix_ = child_.prefix
            # validate type TUf
            self.validate_TUf(self.UFCons)
        elif nodeName_ == 'CIDE':
            obj_ = CIDEType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CIDE = obj_
            obj_.original_tagname_ = 'CIDE'
# end class combType


class CIDEType(GeneratedsSuper):
    """CIDE Combustíveis"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('qBCProd', ['TDec_1204', 'xs:string'], 0, 0, {'name': 'qBCProd', 'type': 'xs:string'}, None),
        MemberSpec_('vAliqProd', ['TDec_1104', 'xs:string'], 0, 0, {'name': 'vAliqProd', 'type': 'xs:string'}, None),
        MemberSpec_('vCIDE', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vCIDE', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, qBCProd=None, vAliqProd=None, vCIDE=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.qBCProd = qBCProd
        self.validate_TDec_1204(self.qBCProd)
        self.qBCProd_nsprefix_ = None
        self.vAliqProd = vAliqProd
        self.validate_TDec_1104(self.vAliqProd)
        self.vAliqProd_nsprefix_ = None
        self.vCIDE = vCIDE
        self.validate_TDec_1302(self.vCIDE)
        self.vCIDE_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CIDEType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CIDEType.subclass:
            return CIDEType.subclass(*args_, **kwargs_)
        else:
            return CIDEType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TDec_1204(self, value):
        result = True
        # Validate type TDec_1204, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1204_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1204_patterns_, ))
                result = False
        return result
    validate_TDec_1204_patterns_ = [['^(0|0\\.[0-9]{1,4}|[1-9]{1}[0-9]{0,11}|[1-9]{1}[0-9]{0,11}(\\.[0-9]{1,4})?)$']]
    def validate_TDec_1104(self, value):
        result = True
        # Validate type TDec_1104, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1104_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1104_patterns_, ))
                result = False
        return result
    validate_TDec_1104_patterns_ = [['^(0|0\\.[0-9]{4}|[1-9]{1}[0-9]{0,10}(\\.[0-9]{4})?)$']]
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def hasContent_(self):
        if (
            self.qBCProd is not None or
            self.vAliqProd is not None or
            self.vCIDE is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CIDEType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CIDEType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CIDEType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CIDEType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CIDEType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CIDEType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CIDEType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.qBCProd is not None:
            namespaceprefix_ = self.qBCProd_nsprefix_ + ':' if (UseCapturedNS_ and self.qBCProd_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sqBCProd>%s</%sqBCProd>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.qBCProd), input_name='qBCProd')), namespaceprefix_ , eol_))
        if self.vAliqProd is not None:
            namespaceprefix_ = self.vAliqProd_nsprefix_ + ':' if (UseCapturedNS_ and self.vAliqProd_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svAliqProd>%s</%svAliqProd>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vAliqProd), input_name='vAliqProd')), namespaceprefix_ , eol_))
        if self.vCIDE is not None:
            namespaceprefix_ = self.vCIDE_nsprefix_ + ':' if (UseCapturedNS_ and self.vCIDE_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svCIDE>%s</%svCIDE>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vCIDE), input_name='vCIDE')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'qBCProd':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'qBCProd')
            value_ = self.gds_validate_string(value_, node, 'qBCProd')
            self.qBCProd = value_
            self.qBCProd_nsprefix_ = child_.prefix
            # validate type TDec_1204
            self.validate_TDec_1204(self.qBCProd)
        elif nodeName_ == 'vAliqProd':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vAliqProd')
            value_ = self.gds_validate_string(value_, node, 'vAliqProd')
            self.vAliqProd = value_
            self.vAliqProd_nsprefix_ = child_.prefix
            # validate type TDec_1104
            self.validate_TDec_1104(self.vAliqProd)
        elif nodeName_ == 'vCIDE':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vCIDE')
            value_ = self.gds_validate_string(value_, node, 'vCIDE')
            self.vCIDE = value_
            self.vCIDE_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vCIDE)
# end class CIDEType


class impostoType(GeneratedsSuper):
    """Tributos incidentes nos produtos ou serviços da NF-e"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('vTotTrib', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vTotTrib', 'type': 'xs:string'}, None),
        MemberSpec_('ICMS', 'ICMSType', 0, 0, {'name': 'ICMS', 'type': 'ICMSType'}, 7),
        MemberSpec_('IPI', 'IPIType', 0, 1, {'minOccurs': '0', 'name': 'IPI', 'type': 'IPIType'}, 7),
        MemberSpec_('II', 'IIType', 0, 1, {'minOccurs': '0', 'name': 'II', 'type': 'IIType'}, 7),
        MemberSpec_('ISSQN', 'ISSQNType', 0, 0, {'name': 'ISSQN', 'type': 'ISSQNType'}, 7),
        MemberSpec_('PIS', 'PISType', 0, 0, {'name': 'PIS', 'type': 'PISType'}, None),
        MemberSpec_('PISST', 'PISSTType', 0, 1, {'minOccurs': '0', 'name': 'PISST', 'type': 'PISSTType'}, None),
        MemberSpec_('COFINS', 'COFINSType', 0, 0, {'name': 'COFINS', 'type': 'COFINSType'}, None),
        MemberSpec_('COFINSST', 'COFINSSTType', 0, 1, {'minOccurs': '0', 'name': 'COFINSST', 'type': 'COFINSSTType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, vTotTrib=None, ICMS=None, IPI=None, II=None, ISSQN=None, PIS=None, PISST=None, COFINS=None, COFINSST=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.vTotTrib = vTotTrib
        self.validate_TDec_1302(self.vTotTrib)
        self.vTotTrib_nsprefix_ = None
        self.ICMS = ICMS
        self.ICMS_nsprefix_ = None
        self.IPI = IPI
        self.IPI_nsprefix_ = None
        self.II = II
        self.II_nsprefix_ = None
        self.ISSQN = ISSQN
        self.ISSQN_nsprefix_ = None
        self.PIS = PIS
        self.PIS_nsprefix_ = None
        self.PISST = PISST
        self.PISST_nsprefix_ = None
        self.COFINS = COFINS
        self.COFINS_nsprefix_ = None
        self.COFINSST = COFINSST
        self.COFINSST_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, impostoType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if impostoType.subclass:
            return impostoType.subclass(*args_, **kwargs_)
        else:
            return impostoType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def hasContent_(self):
        if (
            self.vTotTrib is not None or
            self.ICMS is not None or
            self.IPI is not None or
            self.II is not None or
            self.ISSQN is not None or
            self.PIS is not None or
            self.PISST is not None or
            self.COFINS is not None or
            self.COFINSST is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='impostoType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('impostoType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'impostoType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='impostoType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='impostoType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='impostoType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='impostoType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.vTotTrib is not None:
            namespaceprefix_ = self.vTotTrib_nsprefix_ + ':' if (UseCapturedNS_ and self.vTotTrib_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svTotTrib>%s</%svTotTrib>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vTotTrib), input_name='vTotTrib')), namespaceprefix_ , eol_))
        if self.ICMS is not None:
            namespaceprefix_ = self.ICMS_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMS_nsprefix_) else ''
            self.ICMS.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMS', pretty_print=pretty_print)
        if self.IPI is not None:
            namespaceprefix_ = self.IPI_nsprefix_ + ':' if (UseCapturedNS_ and self.IPI_nsprefix_) else ''
            self.IPI.export(outfile, level, namespaceprefix_, namespacedef_='', name_='IPI', pretty_print=pretty_print)
        if self.II is not None:
            namespaceprefix_ = self.II_nsprefix_ + ':' if (UseCapturedNS_ and self.II_nsprefix_) else ''
            self.II.export(outfile, level, namespaceprefix_, namespacedef_='', name_='II', pretty_print=pretty_print)
        if self.ISSQN is not None:
            namespaceprefix_ = self.ISSQN_nsprefix_ + ':' if (UseCapturedNS_ and self.ISSQN_nsprefix_) else ''
            self.ISSQN.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ISSQN', pretty_print=pretty_print)
        if self.PIS is not None:
            namespaceprefix_ = self.PIS_nsprefix_ + ':' if (UseCapturedNS_ and self.PIS_nsprefix_) else ''
            self.PIS.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PIS', pretty_print=pretty_print)
        if self.PISST is not None:
            namespaceprefix_ = self.PISST_nsprefix_ + ':' if (UseCapturedNS_ and self.PISST_nsprefix_) else ''
            self.PISST.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PISST', pretty_print=pretty_print)
        if self.COFINS is not None:
            namespaceprefix_ = self.COFINS_nsprefix_ + ':' if (UseCapturedNS_ and self.COFINS_nsprefix_) else ''
            self.COFINS.export(outfile, level, namespaceprefix_, namespacedef_='', name_='COFINS', pretty_print=pretty_print)
        if self.COFINSST is not None:
            namespaceprefix_ = self.COFINSST_nsprefix_ + ':' if (UseCapturedNS_ and self.COFINSST_nsprefix_) else ''
            self.COFINSST.export(outfile, level, namespaceprefix_, namespacedef_='', name_='COFINSST', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'vTotTrib':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vTotTrib')
            value_ = self.gds_validate_string(value_, node, 'vTotTrib')
            self.vTotTrib = value_
            self.vTotTrib_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vTotTrib)
        elif nodeName_ == 'ICMS':
            obj_ = ICMSType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMS = obj_
            obj_.original_tagname_ = 'ICMS'
        elif nodeName_ == 'IPI':
            obj_ = IPIType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.IPI = obj_
            obj_.original_tagname_ = 'IPI'
        elif nodeName_ == 'II':
            obj_ = IIType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.II = obj_
            obj_.original_tagname_ = 'II'
        elif nodeName_ == 'ISSQN':
            obj_ = ISSQNType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ISSQN = obj_
            obj_.original_tagname_ = 'ISSQN'
        elif nodeName_ == 'PIS':
            obj_ = PISType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PIS = obj_
            obj_.original_tagname_ = 'PIS'
        elif nodeName_ == 'PISST':
            obj_ = PISSTType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PISST = obj_
            obj_.original_tagname_ = 'PISST'
        elif nodeName_ == 'COFINS':
            obj_ = COFINSType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.COFINS = obj_
            obj_.original_tagname_ = 'COFINS'
        elif nodeName_ == 'COFINSST':
            obj_ = COFINSSTType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.COFINSST = obj_
            obj_.original_tagname_ = 'COFINSST'
# end class impostoType


class ICMSType(GeneratedsSuper):
    """Dados do ICMS Normal e ST"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('ICMS00', 'ICMS00Type', 0, 0, {'name': 'ICMS00', 'type': 'ICMS00Type'}, 8),
        MemberSpec_('ICMS10', 'ICMS10Type', 0, 0, {'name': 'ICMS10', 'type': 'ICMS10Type'}, 8),
        MemberSpec_('ICMS20', 'ICMS20Type', 0, 0, {'name': 'ICMS20', 'type': 'ICMS20Type'}, 8),
        MemberSpec_('ICMS30', 'ICMS30Type', 0, 0, {'name': 'ICMS30', 'type': 'ICMS30Type'}, 8),
        MemberSpec_('ICMS40', 'ICMS40Type', 0, 0, {'name': 'ICMS40', 'type': 'ICMS40Type'}, 8),
        MemberSpec_('ICMS51', 'ICMS51Type', 0, 0, {'name': 'ICMS51', 'type': 'ICMS51Type'}, 8),
        MemberSpec_('ICMS60', 'ICMS60Type', 0, 0, {'name': 'ICMS60', 'type': 'ICMS60Type'}, 8),
        MemberSpec_('ICMS70', 'ICMS70Type', 0, 0, {'name': 'ICMS70', 'type': 'ICMS70Type'}, 8),
        MemberSpec_('ICMS90', 'ICMS90Type', 0, 0, {'name': 'ICMS90', 'type': 'ICMS90Type'}, 8),
        MemberSpec_('ICMSPart', 'ICMSPartType', 0, 0, {'name': 'ICMSPart', 'type': 'ICMSPartType'}, 8),
        MemberSpec_('ICMSST', 'ICMSSTType', 0, 0, {'name': 'ICMSST', 'type': 'ICMSSTType'}, 8),
        MemberSpec_('ICMSSN101', 'ICMSSN101Type', 0, 0, {'name': 'ICMSSN101', 'type': 'ICMSSN101Type'}, 8),
        MemberSpec_('ICMSSN102', 'ICMSSN102Type', 0, 0, {'name': 'ICMSSN102', 'type': 'ICMSSN102Type'}, 8),
        MemberSpec_('ICMSSN201', 'ICMSSN201Type', 0, 0, {'name': 'ICMSSN201', 'type': 'ICMSSN201Type'}, 8),
        MemberSpec_('ICMSSN202', 'ICMSSN202Type', 0, 0, {'name': 'ICMSSN202', 'type': 'ICMSSN202Type'}, 8),
        MemberSpec_('ICMSSN500', 'ICMSSN500Type', 0, 0, {'name': 'ICMSSN500', 'type': 'ICMSSN500Type'}, 8),
        MemberSpec_('ICMSSN900', 'ICMSSN900Type', 0, 0, {'name': 'ICMSSN900', 'type': 'ICMSSN900Type'}, 8),
    ]
    subclass = None
    superclass = None
    def __init__(self, ICMS00=None, ICMS10=None, ICMS20=None, ICMS30=None, ICMS40=None, ICMS51=None, ICMS60=None, ICMS70=None, ICMS90=None, ICMSPart=None, ICMSST=None, ICMSSN101=None, ICMSSN102=None, ICMSSN201=None, ICMSSN202=None, ICMSSN500=None, ICMSSN900=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ICMS00 = ICMS00
        self.ICMS00_nsprefix_ = None
        self.ICMS10 = ICMS10
        self.ICMS10_nsprefix_ = None
        self.ICMS20 = ICMS20
        self.ICMS20_nsprefix_ = None
        self.ICMS30 = ICMS30
        self.ICMS30_nsprefix_ = None
        self.ICMS40 = ICMS40
        self.ICMS40_nsprefix_ = None
        self.ICMS51 = ICMS51
        self.ICMS51_nsprefix_ = None
        self.ICMS60 = ICMS60
        self.ICMS60_nsprefix_ = None
        self.ICMS70 = ICMS70
        self.ICMS70_nsprefix_ = None
        self.ICMS90 = ICMS90
        self.ICMS90_nsprefix_ = None
        self.ICMSPart = ICMSPart
        self.ICMSPart_nsprefix_ = None
        self.ICMSST = ICMSST
        self.ICMSST_nsprefix_ = None
        self.ICMSSN101 = ICMSSN101
        self.ICMSSN101_nsprefix_ = None
        self.ICMSSN102 = ICMSSN102
        self.ICMSSN102_nsprefix_ = None
        self.ICMSSN201 = ICMSSN201
        self.ICMSSN201_nsprefix_ = None
        self.ICMSSN202 = ICMSSN202
        self.ICMSSN202_nsprefix_ = None
        self.ICMSSN500 = ICMSSN500
        self.ICMSSN500_nsprefix_ = None
        self.ICMSSN900 = ICMSSN900
        self.ICMSSN900_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ICMSType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ICMSType.subclass:
            return ICMSType.subclass(*args_, **kwargs_)
        else:
            return ICMSType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.ICMS00 is not None or
            self.ICMS10 is not None or
            self.ICMS20 is not None or
            self.ICMS30 is not None or
            self.ICMS40 is not None or
            self.ICMS51 is not None or
            self.ICMS60 is not None or
            self.ICMS70 is not None or
            self.ICMS90 is not None or
            self.ICMSPart is not None or
            self.ICMSST is not None or
            self.ICMSSN101 is not None or
            self.ICMSSN102 is not None or
            self.ICMSSN201 is not None or
            self.ICMSSN202 is not None or
            self.ICMSSN500 is not None or
            self.ICMSSN900 is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMSType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ICMSType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ICMSType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ICMSType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ICMSType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ICMSType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMSType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ICMS00 is not None:
            namespaceprefix_ = self.ICMS00_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMS00_nsprefix_) else ''
            self.ICMS00.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMS00', pretty_print=pretty_print)
        if self.ICMS10 is not None:
            namespaceprefix_ = self.ICMS10_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMS10_nsprefix_) else ''
            self.ICMS10.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMS10', pretty_print=pretty_print)
        if self.ICMS20 is not None:
            namespaceprefix_ = self.ICMS20_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMS20_nsprefix_) else ''
            self.ICMS20.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMS20', pretty_print=pretty_print)
        if self.ICMS30 is not None:
            namespaceprefix_ = self.ICMS30_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMS30_nsprefix_) else ''
            self.ICMS30.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMS30', pretty_print=pretty_print)
        if self.ICMS40 is not None:
            namespaceprefix_ = self.ICMS40_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMS40_nsprefix_) else ''
            self.ICMS40.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMS40', pretty_print=pretty_print)
        if self.ICMS51 is not None:
            namespaceprefix_ = self.ICMS51_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMS51_nsprefix_) else ''
            self.ICMS51.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMS51', pretty_print=pretty_print)
        if self.ICMS60 is not None:
            namespaceprefix_ = self.ICMS60_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMS60_nsprefix_) else ''
            self.ICMS60.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMS60', pretty_print=pretty_print)
        if self.ICMS70 is not None:
            namespaceprefix_ = self.ICMS70_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMS70_nsprefix_) else ''
            self.ICMS70.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMS70', pretty_print=pretty_print)
        if self.ICMS90 is not None:
            namespaceprefix_ = self.ICMS90_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMS90_nsprefix_) else ''
            self.ICMS90.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMS90', pretty_print=pretty_print)
        if self.ICMSPart is not None:
            namespaceprefix_ = self.ICMSPart_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMSPart_nsprefix_) else ''
            self.ICMSPart.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMSPart', pretty_print=pretty_print)
        if self.ICMSST is not None:
            namespaceprefix_ = self.ICMSST_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMSST_nsprefix_) else ''
            self.ICMSST.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMSST', pretty_print=pretty_print)
        if self.ICMSSN101 is not None:
            namespaceprefix_ = self.ICMSSN101_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMSSN101_nsprefix_) else ''
            self.ICMSSN101.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMSSN101', pretty_print=pretty_print)
        if self.ICMSSN102 is not None:
            namespaceprefix_ = self.ICMSSN102_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMSSN102_nsprefix_) else ''
            self.ICMSSN102.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMSSN102', pretty_print=pretty_print)
        if self.ICMSSN201 is not None:
            namespaceprefix_ = self.ICMSSN201_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMSSN201_nsprefix_) else ''
            self.ICMSSN201.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMSSN201', pretty_print=pretty_print)
        if self.ICMSSN202 is not None:
            namespaceprefix_ = self.ICMSSN202_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMSSN202_nsprefix_) else ''
            self.ICMSSN202.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMSSN202', pretty_print=pretty_print)
        if self.ICMSSN500 is not None:
            namespaceprefix_ = self.ICMSSN500_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMSSN500_nsprefix_) else ''
            self.ICMSSN500.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMSSN500', pretty_print=pretty_print)
        if self.ICMSSN900 is not None:
            namespaceprefix_ = self.ICMSSN900_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMSSN900_nsprefix_) else ''
            self.ICMSSN900.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMSSN900', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ICMS00':
            obj_ = ICMS00Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMS00 = obj_
            obj_.original_tagname_ = 'ICMS00'
        elif nodeName_ == 'ICMS10':
            obj_ = ICMS10Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMS10 = obj_
            obj_.original_tagname_ = 'ICMS10'
        elif nodeName_ == 'ICMS20':
            obj_ = ICMS20Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMS20 = obj_
            obj_.original_tagname_ = 'ICMS20'
        elif nodeName_ == 'ICMS30':
            obj_ = ICMS30Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMS30 = obj_
            obj_.original_tagname_ = 'ICMS30'
        elif nodeName_ == 'ICMS40':
            obj_ = ICMS40Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMS40 = obj_
            obj_.original_tagname_ = 'ICMS40'
        elif nodeName_ == 'ICMS51':
            obj_ = ICMS51Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMS51 = obj_
            obj_.original_tagname_ = 'ICMS51'
        elif nodeName_ == 'ICMS60':
            obj_ = ICMS60Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMS60 = obj_
            obj_.original_tagname_ = 'ICMS60'
        elif nodeName_ == 'ICMS70':
            obj_ = ICMS70Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMS70 = obj_
            obj_.original_tagname_ = 'ICMS70'
        elif nodeName_ == 'ICMS90':
            obj_ = ICMS90Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMS90 = obj_
            obj_.original_tagname_ = 'ICMS90'
        elif nodeName_ == 'ICMSPart':
            obj_ = ICMSPartType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMSPart = obj_
            obj_.original_tagname_ = 'ICMSPart'
        elif nodeName_ == 'ICMSST':
            obj_ = ICMSSTType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMSST = obj_
            obj_.original_tagname_ = 'ICMSST'
        elif nodeName_ == 'ICMSSN101':
            obj_ = ICMSSN101Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMSSN101 = obj_
            obj_.original_tagname_ = 'ICMSSN101'
        elif nodeName_ == 'ICMSSN102':
            obj_ = ICMSSN102Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMSSN102 = obj_
            obj_.original_tagname_ = 'ICMSSN102'
        elif nodeName_ == 'ICMSSN201':
            obj_ = ICMSSN201Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMSSN201 = obj_
            obj_.original_tagname_ = 'ICMSSN201'
        elif nodeName_ == 'ICMSSN202':
            obj_ = ICMSSN202Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMSSN202 = obj_
            obj_.original_tagname_ = 'ICMSSN202'
        elif nodeName_ == 'ICMSSN500':
            obj_ = ICMSSN500Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMSSN500 = obj_
            obj_.original_tagname_ = 'ICMSSN500'
        elif nodeName_ == 'ICMSSN900':
            obj_ = ICMSSN900Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMSSN900 = obj_
            obj_.original_tagname_ = 'ICMSSN900'
# end class ICMSType


class ICMS00Type(GeneratedsSuper):
    """Tributação pelo ICMS
    00 - Tributada integralmente"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('orig', ['Torig', 'xs:string'], 0, 0, {'name': 'orig', 'type': 'xs:string'}, None),
        MemberSpec_('CST', ['CSTType', 'xs:string'], 0, 0, {'name': 'CST', 'type': 'xs:string'}, None),
        MemberSpec_('modBC', ['modBCType', 'xs:string'], 0, 0, {'name': 'modBC', 'type': 'xs:string'}, None),
        MemberSpec_('vBC', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vBC', 'type': 'xs:string'}, None),
        MemberSpec_('pICMS', ['TDec_0302', 'xs:string'], 0, 0, {'name': 'pICMS', 'type': 'xs:string'}, None),
        MemberSpec_('vICMS', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vICMS', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, orig=None, CST=None, modBC=None, vBC=None, pICMS=None, vICMS=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.orig = orig
        self.validate_Torig(self.orig)
        self.orig_nsprefix_ = None
        self.CST = CST
        self.validate_CSTType(self.CST)
        self.CST_nsprefix_ = None
        self.modBC = modBC
        self.validate_modBCType(self.modBC)
        self.modBC_nsprefix_ = None
        self.vBC = vBC
        self.validate_TDec_1302(self.vBC)
        self.vBC_nsprefix_ = None
        self.pICMS = pICMS
        self.validate_TDec_0302(self.pICMS)
        self.pICMS_nsprefix_ = None
        self.vICMS = vICMS
        self.validate_TDec_1302(self.vICMS)
        self.vICMS_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ICMS00Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ICMS00Type.subclass:
            return ICMS00Type.subclass(*args_, **kwargs_)
        else:
            return ICMS00Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Torig(self, value):
        result = True
        # Validate type Torig, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5', '6', '7', '8']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on Torig' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CSTType(self, value):
        result = True
        # Validate type CSTType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['00']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on CSTType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_modBCType(self, value):
        result = True
        # Validate type modBCType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on modBCType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def validate_TDec_0302(self, value):
        result = True
        # Validate type TDec_0302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0302_patterns_, ))
                result = False
        return result
    validate_TDec_0302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,2}(\\.[0-9]{2})?)$']]
    def hasContent_(self):
        if (
            self.orig is not None or
            self.CST is not None or
            self.modBC is not None or
            self.vBC is not None or
            self.pICMS is not None or
            self.vICMS is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMS00Type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ICMS00Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ICMS00Type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ICMS00Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ICMS00Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ICMS00Type'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMS00Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.orig is not None:
            namespaceprefix_ = self.orig_nsprefix_ + ':' if (UseCapturedNS_ and self.orig_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorig>%s</%sorig>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.orig), input_name='orig')), namespaceprefix_ , eol_))
        if self.CST is not None:
            namespaceprefix_ = self.CST_nsprefix_ + ':' if (UseCapturedNS_ and self.CST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCST>%s</%sCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CST), input_name='CST')), namespaceprefix_ , eol_))
        if self.modBC is not None:
            namespaceprefix_ = self.modBC_nsprefix_ + ':' if (UseCapturedNS_ and self.modBC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smodBC>%s</%smodBC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.modBC), input_name='modBC')), namespaceprefix_ , eol_))
        if self.vBC is not None:
            namespaceprefix_ = self.vBC_nsprefix_ + ':' if (UseCapturedNS_ and self.vBC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svBC>%s</%svBC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vBC), input_name='vBC')), namespaceprefix_ , eol_))
        if self.pICMS is not None:
            namespaceprefix_ = self.pICMS_nsprefix_ + ':' if (UseCapturedNS_ and self.pICMS_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spICMS>%s</%spICMS>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pICMS), input_name='pICMS')), namespaceprefix_ , eol_))
        if self.vICMS is not None:
            namespaceprefix_ = self.vICMS_nsprefix_ + ':' if (UseCapturedNS_ and self.vICMS_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svICMS>%s</%svICMS>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vICMS), input_name='vICMS')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'orig':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'orig')
            value_ = self.gds_validate_string(value_, node, 'orig')
            self.orig = value_
            self.orig_nsprefix_ = child_.prefix
            # validate type Torig
            self.validate_Torig(self.orig)
        elif nodeName_ == 'CST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CST')
            value_ = self.gds_validate_string(value_, node, 'CST')
            self.CST = value_
            self.CST_nsprefix_ = child_.prefix
            # validate type CSTType
            self.validate_CSTType(self.CST)
        elif nodeName_ == 'modBC':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'modBC')
            value_ = self.gds_validate_string(value_, node, 'modBC')
            self.modBC = value_
            self.modBC_nsprefix_ = child_.prefix
            # validate type modBCType
            self.validate_modBCType(self.modBC)
        elif nodeName_ == 'vBC':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vBC')
            value_ = self.gds_validate_string(value_, node, 'vBC')
            self.vBC = value_
            self.vBC_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vBC)
        elif nodeName_ == 'pICMS':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pICMS')
            value_ = self.gds_validate_string(value_, node, 'pICMS')
            self.pICMS = value_
            self.pICMS_nsprefix_ = child_.prefix
            # validate type TDec_0302
            self.validate_TDec_0302(self.pICMS)
        elif nodeName_ == 'vICMS':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vICMS')
            value_ = self.gds_validate_string(value_, node, 'vICMS')
            self.vICMS = value_
            self.vICMS_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vICMS)
# end class ICMS00Type


class ICMS10Type(GeneratedsSuper):
    """Tributação pelo ICMS
    10 - Tributada e com cobrança do ICMS por substituição tributária"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('orig', ['Torig', 'xs:string'], 0, 0, {'name': 'orig', 'type': 'xs:string'}, None),
        MemberSpec_('CST', ['CSTType6', 'xs:string'], 0, 0, {'name': 'CST', 'type': 'xs:string'}, None),
        MemberSpec_('modBC', ['modBCType7', 'xs:string'], 0, 0, {'name': 'modBC', 'type': 'xs:string'}, None),
        MemberSpec_('vBC', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vBC', 'type': 'xs:string'}, None),
        MemberSpec_('pICMS', ['TDec_0302', 'xs:string'], 0, 0, {'name': 'pICMS', 'type': 'xs:string'}, None),
        MemberSpec_('vICMS', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vICMS', 'type': 'xs:string'}, None),
        MemberSpec_('modBCST', ['modBCSTType', 'xs:string'], 0, 0, {'name': 'modBCST', 'type': 'xs:string'}, None),
        MemberSpec_('pMVAST', ['TDec_0302Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pMVAST', 'type': 'xs:string'}, None),
        MemberSpec_('pRedBCST', ['TDec_0302Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pRedBCST', 'type': 'xs:string'}, None),
        MemberSpec_('vBCST', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vBCST', 'type': 'xs:string'}, None),
        MemberSpec_('pICMSST', ['TDec_0302', 'xs:string'], 0, 0, {'name': 'pICMSST', 'type': 'xs:string'}, None),
        MemberSpec_('vICMSST', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vICMSST', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, orig=None, CST=None, modBC=None, vBC=None, pICMS=None, vICMS=None, modBCST=None, pMVAST=None, pRedBCST=None, vBCST=None, pICMSST=None, vICMSST=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.orig = orig
        self.validate_Torig(self.orig)
        self.orig_nsprefix_ = None
        self.CST = CST
        self.validate_CSTType6(self.CST)
        self.CST_nsprefix_ = None
        self.modBC = modBC
        self.validate_modBCType7(self.modBC)
        self.modBC_nsprefix_ = None
        self.vBC = vBC
        self.validate_TDec_1302(self.vBC)
        self.vBC_nsprefix_ = None
        self.pICMS = pICMS
        self.validate_TDec_0302(self.pICMS)
        self.pICMS_nsprefix_ = None
        self.vICMS = vICMS
        self.validate_TDec_1302(self.vICMS)
        self.vICMS_nsprefix_ = None
        self.modBCST = modBCST
        self.validate_modBCSTType(self.modBCST)
        self.modBCST_nsprefix_ = None
        self.pMVAST = pMVAST
        self.validate_TDec_0302Opc(self.pMVAST)
        self.pMVAST_nsprefix_ = None
        self.pRedBCST = pRedBCST
        self.validate_TDec_0302Opc(self.pRedBCST)
        self.pRedBCST_nsprefix_ = None
        self.vBCST = vBCST
        self.validate_TDec_1302(self.vBCST)
        self.vBCST_nsprefix_ = None
        self.pICMSST = pICMSST
        self.validate_TDec_0302(self.pICMSST)
        self.pICMSST_nsprefix_ = None
        self.vICMSST = vICMSST
        self.validate_TDec_1302(self.vICMSST)
        self.vICMSST_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ICMS10Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ICMS10Type.subclass:
            return ICMS10Type.subclass(*args_, **kwargs_)
        else:
            return ICMS10Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Torig(self, value):
        result = True
        # Validate type Torig, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5', '6', '7', '8']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on Torig' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CSTType6(self, value):
        result = True
        # Validate type CSTType6, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['10']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on CSTType6' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_modBCType7(self, value):
        result = True
        # Validate type modBCType7, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on modBCType7' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def validate_TDec_0302(self, value):
        result = True
        # Validate type TDec_0302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0302_patterns_, ))
                result = False
        return result
    validate_TDec_0302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,2}(\\.[0-9]{2})?)$']]
    def validate_modBCSTType(self, value):
        result = True
        # Validate type modBCSTType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on modBCSTType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TDec_0302Opc(self, value):
        result = True
        # Validate type TDec_0302Opc, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0302Opc_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0302Opc_patterns_, ))
                result = False
        return result
    validate_TDec_0302Opc_patterns_ = [['^(0\\.[0-9]{1}[1-9]{1}|0\\.[1-9]{1}[0-9]{1}|[1-9]{1}[0-9]{0,2}(\\.[0-9]{2})?)$']]
    def hasContent_(self):
        if (
            self.orig is not None or
            self.CST is not None or
            self.modBC is not None or
            self.vBC is not None or
            self.pICMS is not None or
            self.vICMS is not None or
            self.modBCST is not None or
            self.pMVAST is not None or
            self.pRedBCST is not None or
            self.vBCST is not None or
            self.pICMSST is not None or
            self.vICMSST is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMS10Type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ICMS10Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ICMS10Type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ICMS10Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ICMS10Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ICMS10Type'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMS10Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.orig is not None:
            namespaceprefix_ = self.orig_nsprefix_ + ':' if (UseCapturedNS_ and self.orig_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorig>%s</%sorig>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.orig), input_name='orig')), namespaceprefix_ , eol_))
        if self.CST is not None:
            namespaceprefix_ = self.CST_nsprefix_ + ':' if (UseCapturedNS_ and self.CST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCST>%s</%sCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CST), input_name='CST')), namespaceprefix_ , eol_))
        if self.modBC is not None:
            namespaceprefix_ = self.modBC_nsprefix_ + ':' if (UseCapturedNS_ and self.modBC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smodBC>%s</%smodBC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.modBC), input_name='modBC')), namespaceprefix_ , eol_))
        if self.vBC is not None:
            namespaceprefix_ = self.vBC_nsprefix_ + ':' if (UseCapturedNS_ and self.vBC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svBC>%s</%svBC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vBC), input_name='vBC')), namespaceprefix_ , eol_))
        if self.pICMS is not None:
            namespaceprefix_ = self.pICMS_nsprefix_ + ':' if (UseCapturedNS_ and self.pICMS_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spICMS>%s</%spICMS>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pICMS), input_name='pICMS')), namespaceprefix_ , eol_))
        if self.vICMS is not None:
            namespaceprefix_ = self.vICMS_nsprefix_ + ':' if (UseCapturedNS_ and self.vICMS_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svICMS>%s</%svICMS>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vICMS), input_name='vICMS')), namespaceprefix_ , eol_))
        if self.modBCST is not None:
            namespaceprefix_ = self.modBCST_nsprefix_ + ':' if (UseCapturedNS_ and self.modBCST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smodBCST>%s</%smodBCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.modBCST), input_name='modBCST')), namespaceprefix_ , eol_))
        if self.pMVAST is not None:
            namespaceprefix_ = self.pMVAST_nsprefix_ + ':' if (UseCapturedNS_ and self.pMVAST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spMVAST>%s</%spMVAST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pMVAST), input_name='pMVAST')), namespaceprefix_ , eol_))
        if self.pRedBCST is not None:
            namespaceprefix_ = self.pRedBCST_nsprefix_ + ':' if (UseCapturedNS_ and self.pRedBCST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spRedBCST>%s</%spRedBCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pRedBCST), input_name='pRedBCST')), namespaceprefix_ , eol_))
        if self.vBCST is not None:
            namespaceprefix_ = self.vBCST_nsprefix_ + ':' if (UseCapturedNS_ and self.vBCST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svBCST>%s</%svBCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vBCST), input_name='vBCST')), namespaceprefix_ , eol_))
        if self.pICMSST is not None:
            namespaceprefix_ = self.pICMSST_nsprefix_ + ':' if (UseCapturedNS_ and self.pICMSST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spICMSST>%s</%spICMSST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pICMSST), input_name='pICMSST')), namespaceprefix_ , eol_))
        if self.vICMSST is not None:
            namespaceprefix_ = self.vICMSST_nsprefix_ + ':' if (UseCapturedNS_ and self.vICMSST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svICMSST>%s</%svICMSST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vICMSST), input_name='vICMSST')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'orig':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'orig')
            value_ = self.gds_validate_string(value_, node, 'orig')
            self.orig = value_
            self.orig_nsprefix_ = child_.prefix
            # validate type Torig
            self.validate_Torig(self.orig)
        elif nodeName_ == 'CST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CST')
            value_ = self.gds_validate_string(value_, node, 'CST')
            self.CST = value_
            self.CST_nsprefix_ = child_.prefix
            # validate type CSTType6
            self.validate_CSTType6(self.CST)
        elif nodeName_ == 'modBC':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'modBC')
            value_ = self.gds_validate_string(value_, node, 'modBC')
            self.modBC = value_
            self.modBC_nsprefix_ = child_.prefix
            # validate type modBCType7
            self.validate_modBCType7(self.modBC)
        elif nodeName_ == 'vBC':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vBC')
            value_ = self.gds_validate_string(value_, node, 'vBC')
            self.vBC = value_
            self.vBC_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vBC)
        elif nodeName_ == 'pICMS':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pICMS')
            value_ = self.gds_validate_string(value_, node, 'pICMS')
            self.pICMS = value_
            self.pICMS_nsprefix_ = child_.prefix
            # validate type TDec_0302
            self.validate_TDec_0302(self.pICMS)
        elif nodeName_ == 'vICMS':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vICMS')
            value_ = self.gds_validate_string(value_, node, 'vICMS')
            self.vICMS = value_
            self.vICMS_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vICMS)
        elif nodeName_ == 'modBCST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'modBCST')
            value_ = self.gds_validate_string(value_, node, 'modBCST')
            self.modBCST = value_
            self.modBCST_nsprefix_ = child_.prefix
            # validate type modBCSTType
            self.validate_modBCSTType(self.modBCST)
        elif nodeName_ == 'pMVAST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pMVAST')
            value_ = self.gds_validate_string(value_, node, 'pMVAST')
            self.pMVAST = value_
            self.pMVAST_nsprefix_ = child_.prefix
            # validate type TDec_0302Opc
            self.validate_TDec_0302Opc(self.pMVAST)
        elif nodeName_ == 'pRedBCST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pRedBCST')
            value_ = self.gds_validate_string(value_, node, 'pRedBCST')
            self.pRedBCST = value_
            self.pRedBCST_nsprefix_ = child_.prefix
            # validate type TDec_0302Opc
            self.validate_TDec_0302Opc(self.pRedBCST)
        elif nodeName_ == 'vBCST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vBCST')
            value_ = self.gds_validate_string(value_, node, 'vBCST')
            self.vBCST = value_
            self.vBCST_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vBCST)
        elif nodeName_ == 'pICMSST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pICMSST')
            value_ = self.gds_validate_string(value_, node, 'pICMSST')
            self.pICMSST = value_
            self.pICMSST_nsprefix_ = child_.prefix
            # validate type TDec_0302
            self.validate_TDec_0302(self.pICMSST)
        elif nodeName_ == 'vICMSST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vICMSST')
            value_ = self.gds_validate_string(value_, node, 'vICMSST')
            self.vICMSST = value_
            self.vICMSST_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vICMSST)
# end class ICMS10Type


class ICMS20Type(GeneratedsSuper):
    """Tributção pelo ICMS
    20 - Com redução de base de cálculo"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('orig', ['Torig', 'xs:string'], 0, 0, {'name': 'orig', 'type': 'xs:string'}, None),
        MemberSpec_('CST', ['CSTType8', 'xs:string'], 0, 0, {'name': 'CST', 'type': 'xs:string'}, None),
        MemberSpec_('modBC', ['modBCType9', 'xs:string'], 0, 0, {'name': 'modBC', 'type': 'xs:string'}, None),
        MemberSpec_('pRedBC', ['TDec_0302', 'xs:string'], 0, 0, {'name': 'pRedBC', 'type': 'xs:string'}, None),
        MemberSpec_('vBC', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vBC', 'type': 'xs:string'}, None),
        MemberSpec_('pICMS', ['TDec_0302', 'xs:string'], 0, 0, {'name': 'pICMS', 'type': 'xs:string'}, None),
        MemberSpec_('vICMS', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vICMS', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, orig=None, CST=None, modBC=None, pRedBC=None, vBC=None, pICMS=None, vICMS=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.orig = orig
        self.validate_Torig(self.orig)
        self.orig_nsprefix_ = None
        self.CST = CST
        self.validate_CSTType8(self.CST)
        self.CST_nsprefix_ = None
        self.modBC = modBC
        self.validate_modBCType9(self.modBC)
        self.modBC_nsprefix_ = None
        self.pRedBC = pRedBC
        self.validate_TDec_0302(self.pRedBC)
        self.pRedBC_nsprefix_ = None
        self.vBC = vBC
        self.validate_TDec_1302(self.vBC)
        self.vBC_nsprefix_ = None
        self.pICMS = pICMS
        self.validate_TDec_0302(self.pICMS)
        self.pICMS_nsprefix_ = None
        self.vICMS = vICMS
        self.validate_TDec_1302(self.vICMS)
        self.vICMS_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ICMS20Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ICMS20Type.subclass:
            return ICMS20Type.subclass(*args_, **kwargs_)
        else:
            return ICMS20Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Torig(self, value):
        result = True
        # Validate type Torig, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5', '6', '7', '8']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on Torig' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CSTType8(self, value):
        result = True
        # Validate type CSTType8, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['20']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on CSTType8' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_modBCType9(self, value):
        result = True
        # Validate type modBCType9, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on modBCType9' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TDec_0302(self, value):
        result = True
        # Validate type TDec_0302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0302_patterns_, ))
                result = False
        return result
    validate_TDec_0302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,2}(\\.[0-9]{2})?)$']]
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def hasContent_(self):
        if (
            self.orig is not None or
            self.CST is not None or
            self.modBC is not None or
            self.pRedBC is not None or
            self.vBC is not None or
            self.pICMS is not None or
            self.vICMS is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMS20Type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ICMS20Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ICMS20Type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ICMS20Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ICMS20Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ICMS20Type'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMS20Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.orig is not None:
            namespaceprefix_ = self.orig_nsprefix_ + ':' if (UseCapturedNS_ and self.orig_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorig>%s</%sorig>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.orig), input_name='orig')), namespaceprefix_ , eol_))
        if self.CST is not None:
            namespaceprefix_ = self.CST_nsprefix_ + ':' if (UseCapturedNS_ and self.CST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCST>%s</%sCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CST), input_name='CST')), namespaceprefix_ , eol_))
        if self.modBC is not None:
            namespaceprefix_ = self.modBC_nsprefix_ + ':' if (UseCapturedNS_ and self.modBC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smodBC>%s</%smodBC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.modBC), input_name='modBC')), namespaceprefix_ , eol_))
        if self.pRedBC is not None:
            namespaceprefix_ = self.pRedBC_nsprefix_ + ':' if (UseCapturedNS_ and self.pRedBC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spRedBC>%s</%spRedBC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pRedBC), input_name='pRedBC')), namespaceprefix_ , eol_))
        if self.vBC is not None:
            namespaceprefix_ = self.vBC_nsprefix_ + ':' if (UseCapturedNS_ and self.vBC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svBC>%s</%svBC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vBC), input_name='vBC')), namespaceprefix_ , eol_))
        if self.pICMS is not None:
            namespaceprefix_ = self.pICMS_nsprefix_ + ':' if (UseCapturedNS_ and self.pICMS_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spICMS>%s</%spICMS>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pICMS), input_name='pICMS')), namespaceprefix_ , eol_))
        if self.vICMS is not None:
            namespaceprefix_ = self.vICMS_nsprefix_ + ':' if (UseCapturedNS_ and self.vICMS_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svICMS>%s</%svICMS>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vICMS), input_name='vICMS')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'orig':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'orig')
            value_ = self.gds_validate_string(value_, node, 'orig')
            self.orig = value_
            self.orig_nsprefix_ = child_.prefix
            # validate type Torig
            self.validate_Torig(self.orig)
        elif nodeName_ == 'CST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CST')
            value_ = self.gds_validate_string(value_, node, 'CST')
            self.CST = value_
            self.CST_nsprefix_ = child_.prefix
            # validate type CSTType8
            self.validate_CSTType8(self.CST)
        elif nodeName_ == 'modBC':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'modBC')
            value_ = self.gds_validate_string(value_, node, 'modBC')
            self.modBC = value_
            self.modBC_nsprefix_ = child_.prefix
            # validate type modBCType9
            self.validate_modBCType9(self.modBC)
        elif nodeName_ == 'pRedBC':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pRedBC')
            value_ = self.gds_validate_string(value_, node, 'pRedBC')
            self.pRedBC = value_
            self.pRedBC_nsprefix_ = child_.prefix
            # validate type TDec_0302
            self.validate_TDec_0302(self.pRedBC)
        elif nodeName_ == 'vBC':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vBC')
            value_ = self.gds_validate_string(value_, node, 'vBC')
            self.vBC = value_
            self.vBC_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vBC)
        elif nodeName_ == 'pICMS':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pICMS')
            value_ = self.gds_validate_string(value_, node, 'pICMS')
            self.pICMS = value_
            self.pICMS_nsprefix_ = child_.prefix
            # validate type TDec_0302
            self.validate_TDec_0302(self.pICMS)
        elif nodeName_ == 'vICMS':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vICMS')
            value_ = self.gds_validate_string(value_, node, 'vICMS')
            self.vICMS = value_
            self.vICMS_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vICMS)
# end class ICMS20Type


class ICMS30Type(GeneratedsSuper):
    """Tributação pelo ICMS
    30 - Isenta ou não tributada e com cobrança do ICMS por substituição
    tributária"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('orig', ['Torig', 'xs:string'], 0, 0, {'name': 'orig', 'type': 'xs:string'}, None),
        MemberSpec_('CST', ['CSTType10', 'xs:string'], 0, 0, {'name': 'CST', 'type': 'xs:string'}, None),
        MemberSpec_('modBCST', ['modBCSTType11', 'xs:string'], 0, 0, {'name': 'modBCST', 'type': 'xs:string'}, None),
        MemberSpec_('pMVAST', ['TDec_0302Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pMVAST', 'type': 'xs:string'}, None),
        MemberSpec_('pRedBCST', ['TDec_0302Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pRedBCST', 'type': 'xs:string'}, None),
        MemberSpec_('vBCST', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vBCST', 'type': 'xs:string'}, None),
        MemberSpec_('pICMSST', ['TDec_0302', 'xs:string'], 0, 0, {'name': 'pICMSST', 'type': 'xs:string'}, None),
        MemberSpec_('vICMSST', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vICMSST', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, orig=None, CST=None, modBCST=None, pMVAST=None, pRedBCST=None, vBCST=None, pICMSST=None, vICMSST=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.orig = orig
        self.validate_Torig(self.orig)
        self.orig_nsprefix_ = None
        self.CST = CST
        self.validate_CSTType10(self.CST)
        self.CST_nsprefix_ = None
        self.modBCST = modBCST
        self.validate_modBCSTType11(self.modBCST)
        self.modBCST_nsprefix_ = None
        self.pMVAST = pMVAST
        self.validate_TDec_0302Opc(self.pMVAST)
        self.pMVAST_nsprefix_ = None
        self.pRedBCST = pRedBCST
        self.validate_TDec_0302Opc(self.pRedBCST)
        self.pRedBCST_nsprefix_ = None
        self.vBCST = vBCST
        self.validate_TDec_1302(self.vBCST)
        self.vBCST_nsprefix_ = None
        self.pICMSST = pICMSST
        self.validate_TDec_0302(self.pICMSST)
        self.pICMSST_nsprefix_ = None
        self.vICMSST = vICMSST
        self.validate_TDec_1302(self.vICMSST)
        self.vICMSST_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ICMS30Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ICMS30Type.subclass:
            return ICMS30Type.subclass(*args_, **kwargs_)
        else:
            return ICMS30Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Torig(self, value):
        result = True
        # Validate type Torig, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5', '6', '7', '8']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on Torig' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CSTType10(self, value):
        result = True
        # Validate type CSTType10, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['30']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on CSTType10' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_modBCSTType11(self, value):
        result = True
        # Validate type modBCSTType11, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on modBCSTType11' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TDec_0302Opc(self, value):
        result = True
        # Validate type TDec_0302Opc, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0302Opc_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0302Opc_patterns_, ))
                result = False
        return result
    validate_TDec_0302Opc_patterns_ = [['^(0\\.[0-9]{1}[1-9]{1}|0\\.[1-9]{1}[0-9]{1}|[1-9]{1}[0-9]{0,2}(\\.[0-9]{2})?)$']]
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def validate_TDec_0302(self, value):
        result = True
        # Validate type TDec_0302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0302_patterns_, ))
                result = False
        return result
    validate_TDec_0302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,2}(\\.[0-9]{2})?)$']]
    def hasContent_(self):
        if (
            self.orig is not None or
            self.CST is not None or
            self.modBCST is not None or
            self.pMVAST is not None or
            self.pRedBCST is not None or
            self.vBCST is not None or
            self.pICMSST is not None or
            self.vICMSST is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMS30Type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ICMS30Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ICMS30Type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ICMS30Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ICMS30Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ICMS30Type'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMS30Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.orig is not None:
            namespaceprefix_ = self.orig_nsprefix_ + ':' if (UseCapturedNS_ and self.orig_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorig>%s</%sorig>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.orig), input_name='orig')), namespaceprefix_ , eol_))
        if self.CST is not None:
            namespaceprefix_ = self.CST_nsprefix_ + ':' if (UseCapturedNS_ and self.CST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCST>%s</%sCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CST), input_name='CST')), namespaceprefix_ , eol_))
        if self.modBCST is not None:
            namespaceprefix_ = self.modBCST_nsprefix_ + ':' if (UseCapturedNS_ and self.modBCST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smodBCST>%s</%smodBCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.modBCST), input_name='modBCST')), namespaceprefix_ , eol_))
        if self.pMVAST is not None:
            namespaceprefix_ = self.pMVAST_nsprefix_ + ':' if (UseCapturedNS_ and self.pMVAST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spMVAST>%s</%spMVAST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pMVAST), input_name='pMVAST')), namespaceprefix_ , eol_))
        if self.pRedBCST is not None:
            namespaceprefix_ = self.pRedBCST_nsprefix_ + ':' if (UseCapturedNS_ and self.pRedBCST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spRedBCST>%s</%spRedBCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pRedBCST), input_name='pRedBCST')), namespaceprefix_ , eol_))
        if self.vBCST is not None:
            namespaceprefix_ = self.vBCST_nsprefix_ + ':' if (UseCapturedNS_ and self.vBCST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svBCST>%s</%svBCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vBCST), input_name='vBCST')), namespaceprefix_ , eol_))
        if self.pICMSST is not None:
            namespaceprefix_ = self.pICMSST_nsprefix_ + ':' if (UseCapturedNS_ and self.pICMSST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spICMSST>%s</%spICMSST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pICMSST), input_name='pICMSST')), namespaceprefix_ , eol_))
        if self.vICMSST is not None:
            namespaceprefix_ = self.vICMSST_nsprefix_ + ':' if (UseCapturedNS_ and self.vICMSST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svICMSST>%s</%svICMSST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vICMSST), input_name='vICMSST')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'orig':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'orig')
            value_ = self.gds_validate_string(value_, node, 'orig')
            self.orig = value_
            self.orig_nsprefix_ = child_.prefix
            # validate type Torig
            self.validate_Torig(self.orig)
        elif nodeName_ == 'CST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CST')
            value_ = self.gds_validate_string(value_, node, 'CST')
            self.CST = value_
            self.CST_nsprefix_ = child_.prefix
            # validate type CSTType10
            self.validate_CSTType10(self.CST)
        elif nodeName_ == 'modBCST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'modBCST')
            value_ = self.gds_validate_string(value_, node, 'modBCST')
            self.modBCST = value_
            self.modBCST_nsprefix_ = child_.prefix
            # validate type modBCSTType11
            self.validate_modBCSTType11(self.modBCST)
        elif nodeName_ == 'pMVAST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pMVAST')
            value_ = self.gds_validate_string(value_, node, 'pMVAST')
            self.pMVAST = value_
            self.pMVAST_nsprefix_ = child_.prefix
            # validate type TDec_0302Opc
            self.validate_TDec_0302Opc(self.pMVAST)
        elif nodeName_ == 'pRedBCST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pRedBCST')
            value_ = self.gds_validate_string(value_, node, 'pRedBCST')
            self.pRedBCST = value_
            self.pRedBCST_nsprefix_ = child_.prefix
            # validate type TDec_0302Opc
            self.validate_TDec_0302Opc(self.pRedBCST)
        elif nodeName_ == 'vBCST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vBCST')
            value_ = self.gds_validate_string(value_, node, 'vBCST')
            self.vBCST = value_
            self.vBCST_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vBCST)
        elif nodeName_ == 'pICMSST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pICMSST')
            value_ = self.gds_validate_string(value_, node, 'pICMSST')
            self.pICMSST = value_
            self.pICMSST_nsprefix_ = child_.prefix
            # validate type TDec_0302
            self.validate_TDec_0302(self.pICMSST)
        elif nodeName_ == 'vICMSST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vICMSST')
            value_ = self.gds_validate_string(value_, node, 'vICMSST')
            self.vICMSST = value_
            self.vICMSST_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vICMSST)
# end class ICMS30Type


class ICMS40Type(GeneratedsSuper):
    """Tributação pelo ICMS
    40 - Isenta
    41 - Não tributada
    50 - Suspensão"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('orig', ['Torig', 'xs:string'], 0, 0, {'name': 'orig', 'type': 'xs:string'}, None),
        MemberSpec_('CST', ['CSTType12', 'xs:string'], 0, 0, {'name': 'CST', 'type': 'xs:string'}, None),
        MemberSpec_('vICMS', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vICMS', 'type': 'xs:string'}, None),
        MemberSpec_('motDesICMS', ['motDesICMSType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'motDesICMS', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, orig=None, CST=None, vICMS=None, motDesICMS=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.orig = orig
        self.validate_Torig(self.orig)
        self.orig_nsprefix_ = None
        self.CST = CST
        self.validate_CSTType12(self.CST)
        self.CST_nsprefix_ = None
        self.vICMS = vICMS
        self.validate_TDec_1302(self.vICMS)
        self.vICMS_nsprefix_ = None
        self.motDesICMS = motDesICMS
        self.validate_motDesICMSType(self.motDesICMS)
        self.motDesICMS_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ICMS40Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ICMS40Type.subclass:
            return ICMS40Type.subclass(*args_, **kwargs_)
        else:
            return ICMS40Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Torig(self, value):
        result = True
        # Validate type Torig, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5', '6', '7', '8']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on Torig' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CSTType12(self, value):
        result = True
        # Validate type CSTType12, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['40', '41', '50']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on CSTType12' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def validate_motDesICMSType(self, value):
        result = True
        # Validate type motDesICMSType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['1', '2', '3', '4', '5', '6', '7', '8', '9']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on motDesICMSType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def hasContent_(self):
        if (
            self.orig is not None or
            self.CST is not None or
            self.vICMS is not None or
            self.motDesICMS is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMS40Type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ICMS40Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ICMS40Type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ICMS40Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ICMS40Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ICMS40Type'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMS40Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.orig is not None:
            namespaceprefix_ = self.orig_nsprefix_ + ':' if (UseCapturedNS_ and self.orig_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorig>%s</%sorig>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.orig), input_name='orig')), namespaceprefix_ , eol_))
        if self.CST is not None:
            namespaceprefix_ = self.CST_nsprefix_ + ':' if (UseCapturedNS_ and self.CST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCST>%s</%sCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CST), input_name='CST')), namespaceprefix_ , eol_))
        if self.vICMS is not None:
            namespaceprefix_ = self.vICMS_nsprefix_ + ':' if (UseCapturedNS_ and self.vICMS_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svICMS>%s</%svICMS>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vICMS), input_name='vICMS')), namespaceprefix_ , eol_))
        if self.motDesICMS is not None:
            namespaceprefix_ = self.motDesICMS_nsprefix_ + ':' if (UseCapturedNS_ and self.motDesICMS_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smotDesICMS>%s</%smotDesICMS>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.motDesICMS), input_name='motDesICMS')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'orig':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'orig')
            value_ = self.gds_validate_string(value_, node, 'orig')
            self.orig = value_
            self.orig_nsprefix_ = child_.prefix
            # validate type Torig
            self.validate_Torig(self.orig)
        elif nodeName_ == 'CST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CST')
            value_ = self.gds_validate_string(value_, node, 'CST')
            self.CST = value_
            self.CST_nsprefix_ = child_.prefix
            # validate type CSTType12
            self.validate_CSTType12(self.CST)
        elif nodeName_ == 'vICMS':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vICMS')
            value_ = self.gds_validate_string(value_, node, 'vICMS')
            self.vICMS = value_
            self.vICMS_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vICMS)
        elif nodeName_ == 'motDesICMS':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'motDesICMS')
            value_ = self.gds_validate_string(value_, node, 'motDesICMS')
            self.motDesICMS = value_
            self.motDesICMS_nsprefix_ = child_.prefix
            # validate type motDesICMSType
            self.validate_motDesICMSType(self.motDesICMS)
# end class ICMS40Type


class ICMS51Type(GeneratedsSuper):
    """Tributção pelo ICMS
    51 - Diferimento
    A exigência do preenchimento das informações do ICMS diferido fica à
    critério de cada UF."""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('orig', ['Torig', 'xs:string'], 0, 0, {'name': 'orig', 'type': 'xs:string'}, None),
        MemberSpec_('CST', ['CSTType13', 'xs:string'], 0, 0, {'name': 'CST', 'type': 'xs:string'}, None),
        MemberSpec_('modBC', ['modBCType14', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'modBC', 'type': 'xs:string'}, None),
        MemberSpec_('pRedBC', ['TDec_0302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pRedBC', 'type': 'xs:string'}, None),
        MemberSpec_('vBC', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vBC', 'type': 'xs:string'}, None),
        MemberSpec_('pICMS', ['TDec_0302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pICMS', 'type': 'xs:string'}, None),
        MemberSpec_('vICMS', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vICMS', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, orig=None, CST=None, modBC=None, pRedBC=None, vBC=None, pICMS=None, vICMS=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.orig = orig
        self.validate_Torig(self.orig)
        self.orig_nsprefix_ = None
        self.CST = CST
        self.validate_CSTType13(self.CST)
        self.CST_nsprefix_ = None
        self.modBC = modBC
        self.validate_modBCType14(self.modBC)
        self.modBC_nsprefix_ = None
        self.pRedBC = pRedBC
        self.validate_TDec_0302(self.pRedBC)
        self.pRedBC_nsprefix_ = None
        self.vBC = vBC
        self.validate_TDec_1302(self.vBC)
        self.vBC_nsprefix_ = None
        self.pICMS = pICMS
        self.validate_TDec_0302(self.pICMS)
        self.pICMS_nsprefix_ = None
        self.vICMS = vICMS
        self.validate_TDec_1302(self.vICMS)
        self.vICMS_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ICMS51Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ICMS51Type.subclass:
            return ICMS51Type.subclass(*args_, **kwargs_)
        else:
            return ICMS51Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Torig(self, value):
        result = True
        # Validate type Torig, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5', '6', '7', '8']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on Torig' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CSTType13(self, value):
        result = True
        # Validate type CSTType13, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['51']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on CSTType13' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_modBCType14(self, value):
        result = True
        # Validate type modBCType14, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on modBCType14' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TDec_0302(self, value):
        result = True
        # Validate type TDec_0302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0302_patterns_, ))
                result = False
        return result
    validate_TDec_0302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,2}(\\.[0-9]{2})?)$']]
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def hasContent_(self):
        if (
            self.orig is not None or
            self.CST is not None or
            self.modBC is not None or
            self.pRedBC is not None or
            self.vBC is not None or
            self.pICMS is not None or
            self.vICMS is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMS51Type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ICMS51Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ICMS51Type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ICMS51Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ICMS51Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ICMS51Type'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMS51Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.orig is not None:
            namespaceprefix_ = self.orig_nsprefix_ + ':' if (UseCapturedNS_ and self.orig_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorig>%s</%sorig>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.orig), input_name='orig')), namespaceprefix_ , eol_))
        if self.CST is not None:
            namespaceprefix_ = self.CST_nsprefix_ + ':' if (UseCapturedNS_ and self.CST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCST>%s</%sCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CST), input_name='CST')), namespaceprefix_ , eol_))
        if self.modBC is not None:
            namespaceprefix_ = self.modBC_nsprefix_ + ':' if (UseCapturedNS_ and self.modBC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smodBC>%s</%smodBC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.modBC), input_name='modBC')), namespaceprefix_ , eol_))
        if self.pRedBC is not None:
            namespaceprefix_ = self.pRedBC_nsprefix_ + ':' if (UseCapturedNS_ and self.pRedBC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spRedBC>%s</%spRedBC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pRedBC), input_name='pRedBC')), namespaceprefix_ , eol_))
        if self.vBC is not None:
            namespaceprefix_ = self.vBC_nsprefix_ + ':' if (UseCapturedNS_ and self.vBC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svBC>%s</%svBC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vBC), input_name='vBC')), namespaceprefix_ , eol_))
        if self.pICMS is not None:
            namespaceprefix_ = self.pICMS_nsprefix_ + ':' if (UseCapturedNS_ and self.pICMS_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spICMS>%s</%spICMS>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pICMS), input_name='pICMS')), namespaceprefix_ , eol_))
        if self.vICMS is not None:
            namespaceprefix_ = self.vICMS_nsprefix_ + ':' if (UseCapturedNS_ and self.vICMS_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svICMS>%s</%svICMS>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vICMS), input_name='vICMS')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'orig':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'orig')
            value_ = self.gds_validate_string(value_, node, 'orig')
            self.orig = value_
            self.orig_nsprefix_ = child_.prefix
            # validate type Torig
            self.validate_Torig(self.orig)
        elif nodeName_ == 'CST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CST')
            value_ = self.gds_validate_string(value_, node, 'CST')
            self.CST = value_
            self.CST_nsprefix_ = child_.prefix
            # validate type CSTType13
            self.validate_CSTType13(self.CST)
        elif nodeName_ == 'modBC':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'modBC')
            value_ = self.gds_validate_string(value_, node, 'modBC')
            self.modBC = value_
            self.modBC_nsprefix_ = child_.prefix
            # validate type modBCType14
            self.validate_modBCType14(self.modBC)
        elif nodeName_ == 'pRedBC':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pRedBC')
            value_ = self.gds_validate_string(value_, node, 'pRedBC')
            self.pRedBC = value_
            self.pRedBC_nsprefix_ = child_.prefix
            # validate type TDec_0302
            self.validate_TDec_0302(self.pRedBC)
        elif nodeName_ == 'vBC':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vBC')
            value_ = self.gds_validate_string(value_, node, 'vBC')
            self.vBC = value_
            self.vBC_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vBC)
        elif nodeName_ == 'pICMS':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pICMS')
            value_ = self.gds_validate_string(value_, node, 'pICMS')
            self.pICMS = value_
            self.pICMS_nsprefix_ = child_.prefix
            # validate type TDec_0302
            self.validate_TDec_0302(self.pICMS)
        elif nodeName_ == 'vICMS':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vICMS')
            value_ = self.gds_validate_string(value_, node, 'vICMS')
            self.vICMS = value_
            self.vICMS_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vICMS)
# end class ICMS51Type


class ICMS60Type(GeneratedsSuper):
    """Tributação pelo ICMS
    60 - ICMS cobrado anteriormente por substituição tributária NT2010/004"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('orig', ['Torig', 'xs:string'], 0, 0, {'name': 'orig', 'type': 'xs:string'}, None),
        MemberSpec_('CST', ['CSTType15', 'xs:string'], 0, 0, {'name': 'CST', 'type': 'xs:string'}, None),
        MemberSpec_('vBCSTRet', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vBCSTRet', 'type': 'xs:string'}, None),
        MemberSpec_('vICMSSTRet', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vICMSSTRet', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, orig=None, CST=None, vBCSTRet=None, vICMSSTRet=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.orig = orig
        self.validate_Torig(self.orig)
        self.orig_nsprefix_ = None
        self.CST = CST
        self.validate_CSTType15(self.CST)
        self.CST_nsprefix_ = None
        self.vBCSTRet = vBCSTRet
        self.validate_TDec_1302(self.vBCSTRet)
        self.vBCSTRet_nsprefix_ = None
        self.vICMSSTRet = vICMSSTRet
        self.validate_TDec_1302(self.vICMSSTRet)
        self.vICMSSTRet_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ICMS60Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ICMS60Type.subclass:
            return ICMS60Type.subclass(*args_, **kwargs_)
        else:
            return ICMS60Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Torig(self, value):
        result = True
        # Validate type Torig, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5', '6', '7', '8']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on Torig' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CSTType15(self, value):
        result = True
        # Validate type CSTType15, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['60']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on CSTType15' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def hasContent_(self):
        if (
            self.orig is not None or
            self.CST is not None or
            self.vBCSTRet is not None or
            self.vICMSSTRet is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMS60Type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ICMS60Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ICMS60Type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ICMS60Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ICMS60Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ICMS60Type'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMS60Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.orig is not None:
            namespaceprefix_ = self.orig_nsprefix_ + ':' if (UseCapturedNS_ and self.orig_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorig>%s</%sorig>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.orig), input_name='orig')), namespaceprefix_ , eol_))
        if self.CST is not None:
            namespaceprefix_ = self.CST_nsprefix_ + ':' if (UseCapturedNS_ and self.CST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCST>%s</%sCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CST), input_name='CST')), namespaceprefix_ , eol_))
        if self.vBCSTRet is not None:
            namespaceprefix_ = self.vBCSTRet_nsprefix_ + ':' if (UseCapturedNS_ and self.vBCSTRet_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svBCSTRet>%s</%svBCSTRet>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vBCSTRet), input_name='vBCSTRet')), namespaceprefix_ , eol_))
        if self.vICMSSTRet is not None:
            namespaceprefix_ = self.vICMSSTRet_nsprefix_ + ':' if (UseCapturedNS_ and self.vICMSSTRet_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svICMSSTRet>%s</%svICMSSTRet>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vICMSSTRet), input_name='vICMSSTRet')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'orig':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'orig')
            value_ = self.gds_validate_string(value_, node, 'orig')
            self.orig = value_
            self.orig_nsprefix_ = child_.prefix
            # validate type Torig
            self.validate_Torig(self.orig)
        elif nodeName_ == 'CST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CST')
            value_ = self.gds_validate_string(value_, node, 'CST')
            self.CST = value_
            self.CST_nsprefix_ = child_.prefix
            # validate type CSTType15
            self.validate_CSTType15(self.CST)
        elif nodeName_ == 'vBCSTRet':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vBCSTRet')
            value_ = self.gds_validate_string(value_, node, 'vBCSTRet')
            self.vBCSTRet = value_
            self.vBCSTRet_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vBCSTRet)
        elif nodeName_ == 'vICMSSTRet':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vICMSSTRet')
            value_ = self.gds_validate_string(value_, node, 'vICMSSTRet')
            self.vICMSSTRet = value_
            self.vICMSSTRet_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vICMSSTRet)
# end class ICMS60Type


class ICMS70Type(GeneratedsSuper):
    """Tributação pelo ICMS
    70 - Com redução de base de cálculo e cobrança do ICMS por substituição
    tributária"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('orig', ['Torig', 'xs:string'], 0, 0, {'name': 'orig', 'type': 'xs:string'}, None),
        MemberSpec_('CST', ['CSTType16', 'xs:string'], 0, 0, {'name': 'CST', 'type': 'xs:string'}, None),
        MemberSpec_('modBC', ['modBCType17', 'xs:string'], 0, 0, {'name': 'modBC', 'type': 'xs:string'}, None),
        MemberSpec_('pRedBC', ['TDec_0302', 'xs:string'], 0, 0, {'name': 'pRedBC', 'type': 'xs:string'}, None),
        MemberSpec_('vBC', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vBC', 'type': 'xs:string'}, None),
        MemberSpec_('pICMS', ['TDec_0302', 'xs:string'], 0, 0, {'name': 'pICMS', 'type': 'xs:string'}, None),
        MemberSpec_('vICMS', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vICMS', 'type': 'xs:string'}, None),
        MemberSpec_('modBCST', ['modBCSTType18', 'xs:string'], 0, 0, {'name': 'modBCST', 'type': 'xs:string'}, None),
        MemberSpec_('pMVAST', ['TDec_0302Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pMVAST', 'type': 'xs:string'}, None),
        MemberSpec_('pRedBCST', ['TDec_0302Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pRedBCST', 'type': 'xs:string'}, None),
        MemberSpec_('vBCST', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vBCST', 'type': 'xs:string'}, None),
        MemberSpec_('pICMSST', ['TDec_0302', 'xs:string'], 0, 0, {'name': 'pICMSST', 'type': 'xs:string'}, None),
        MemberSpec_('vICMSST', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vICMSST', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, orig=None, CST=None, modBC=None, pRedBC=None, vBC=None, pICMS=None, vICMS=None, modBCST=None, pMVAST=None, pRedBCST=None, vBCST=None, pICMSST=None, vICMSST=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.orig = orig
        self.validate_Torig(self.orig)
        self.orig_nsprefix_ = None
        self.CST = CST
        self.validate_CSTType16(self.CST)
        self.CST_nsprefix_ = None
        self.modBC = modBC
        self.validate_modBCType17(self.modBC)
        self.modBC_nsprefix_ = None
        self.pRedBC = pRedBC
        self.validate_TDec_0302(self.pRedBC)
        self.pRedBC_nsprefix_ = None
        self.vBC = vBC
        self.validate_TDec_1302(self.vBC)
        self.vBC_nsprefix_ = None
        self.pICMS = pICMS
        self.validate_TDec_0302(self.pICMS)
        self.pICMS_nsprefix_ = None
        self.vICMS = vICMS
        self.validate_TDec_1302(self.vICMS)
        self.vICMS_nsprefix_ = None
        self.modBCST = modBCST
        self.validate_modBCSTType18(self.modBCST)
        self.modBCST_nsprefix_ = None
        self.pMVAST = pMVAST
        self.validate_TDec_0302Opc(self.pMVAST)
        self.pMVAST_nsprefix_ = None
        self.pRedBCST = pRedBCST
        self.validate_TDec_0302Opc(self.pRedBCST)
        self.pRedBCST_nsprefix_ = None
        self.vBCST = vBCST
        self.validate_TDec_1302(self.vBCST)
        self.vBCST_nsprefix_ = None
        self.pICMSST = pICMSST
        self.validate_TDec_0302(self.pICMSST)
        self.pICMSST_nsprefix_ = None
        self.vICMSST = vICMSST
        self.validate_TDec_1302(self.vICMSST)
        self.vICMSST_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ICMS70Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ICMS70Type.subclass:
            return ICMS70Type.subclass(*args_, **kwargs_)
        else:
            return ICMS70Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Torig(self, value):
        result = True
        # Validate type Torig, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5', '6', '7', '8']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on Torig' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CSTType16(self, value):
        result = True
        # Validate type CSTType16, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['70']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on CSTType16' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_modBCType17(self, value):
        result = True
        # Validate type modBCType17, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on modBCType17' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TDec_0302(self, value):
        result = True
        # Validate type TDec_0302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0302_patterns_, ))
                result = False
        return result
    validate_TDec_0302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,2}(\\.[0-9]{2})?)$']]
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def validate_modBCSTType18(self, value):
        result = True
        # Validate type modBCSTType18, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on modBCSTType18' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TDec_0302Opc(self, value):
        result = True
        # Validate type TDec_0302Opc, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0302Opc_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0302Opc_patterns_, ))
                result = False
        return result
    validate_TDec_0302Opc_patterns_ = [['^(0\\.[0-9]{1}[1-9]{1}|0\\.[1-9]{1}[0-9]{1}|[1-9]{1}[0-9]{0,2}(\\.[0-9]{2})?)$']]
    def hasContent_(self):
        if (
            self.orig is not None or
            self.CST is not None or
            self.modBC is not None or
            self.pRedBC is not None or
            self.vBC is not None or
            self.pICMS is not None or
            self.vICMS is not None or
            self.modBCST is not None or
            self.pMVAST is not None or
            self.pRedBCST is not None or
            self.vBCST is not None or
            self.pICMSST is not None or
            self.vICMSST is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMS70Type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ICMS70Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ICMS70Type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ICMS70Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ICMS70Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ICMS70Type'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMS70Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.orig is not None:
            namespaceprefix_ = self.orig_nsprefix_ + ':' if (UseCapturedNS_ and self.orig_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorig>%s</%sorig>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.orig), input_name='orig')), namespaceprefix_ , eol_))
        if self.CST is not None:
            namespaceprefix_ = self.CST_nsprefix_ + ':' if (UseCapturedNS_ and self.CST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCST>%s</%sCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CST), input_name='CST')), namespaceprefix_ , eol_))
        if self.modBC is not None:
            namespaceprefix_ = self.modBC_nsprefix_ + ':' if (UseCapturedNS_ and self.modBC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smodBC>%s</%smodBC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.modBC), input_name='modBC')), namespaceprefix_ , eol_))
        if self.pRedBC is not None:
            namespaceprefix_ = self.pRedBC_nsprefix_ + ':' if (UseCapturedNS_ and self.pRedBC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spRedBC>%s</%spRedBC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pRedBC), input_name='pRedBC')), namespaceprefix_ , eol_))
        if self.vBC is not None:
            namespaceprefix_ = self.vBC_nsprefix_ + ':' if (UseCapturedNS_ and self.vBC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svBC>%s</%svBC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vBC), input_name='vBC')), namespaceprefix_ , eol_))
        if self.pICMS is not None:
            namespaceprefix_ = self.pICMS_nsprefix_ + ':' if (UseCapturedNS_ and self.pICMS_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spICMS>%s</%spICMS>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pICMS), input_name='pICMS')), namespaceprefix_ , eol_))
        if self.vICMS is not None:
            namespaceprefix_ = self.vICMS_nsprefix_ + ':' if (UseCapturedNS_ and self.vICMS_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svICMS>%s</%svICMS>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vICMS), input_name='vICMS')), namespaceprefix_ , eol_))
        if self.modBCST is not None:
            namespaceprefix_ = self.modBCST_nsprefix_ + ':' if (UseCapturedNS_ and self.modBCST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smodBCST>%s</%smodBCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.modBCST), input_name='modBCST')), namespaceprefix_ , eol_))
        if self.pMVAST is not None:
            namespaceprefix_ = self.pMVAST_nsprefix_ + ':' if (UseCapturedNS_ and self.pMVAST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spMVAST>%s</%spMVAST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pMVAST), input_name='pMVAST')), namespaceprefix_ , eol_))
        if self.pRedBCST is not None:
            namespaceprefix_ = self.pRedBCST_nsprefix_ + ':' if (UseCapturedNS_ and self.pRedBCST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spRedBCST>%s</%spRedBCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pRedBCST), input_name='pRedBCST')), namespaceprefix_ , eol_))
        if self.vBCST is not None:
            namespaceprefix_ = self.vBCST_nsprefix_ + ':' if (UseCapturedNS_ and self.vBCST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svBCST>%s</%svBCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vBCST), input_name='vBCST')), namespaceprefix_ , eol_))
        if self.pICMSST is not None:
            namespaceprefix_ = self.pICMSST_nsprefix_ + ':' if (UseCapturedNS_ and self.pICMSST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spICMSST>%s</%spICMSST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pICMSST), input_name='pICMSST')), namespaceprefix_ , eol_))
        if self.vICMSST is not None:
            namespaceprefix_ = self.vICMSST_nsprefix_ + ':' if (UseCapturedNS_ and self.vICMSST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svICMSST>%s</%svICMSST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vICMSST), input_name='vICMSST')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'orig':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'orig')
            value_ = self.gds_validate_string(value_, node, 'orig')
            self.orig = value_
            self.orig_nsprefix_ = child_.prefix
            # validate type Torig
            self.validate_Torig(self.orig)
        elif nodeName_ == 'CST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CST')
            value_ = self.gds_validate_string(value_, node, 'CST')
            self.CST = value_
            self.CST_nsprefix_ = child_.prefix
            # validate type CSTType16
            self.validate_CSTType16(self.CST)
        elif nodeName_ == 'modBC':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'modBC')
            value_ = self.gds_validate_string(value_, node, 'modBC')
            self.modBC = value_
            self.modBC_nsprefix_ = child_.prefix
            # validate type modBCType17
            self.validate_modBCType17(self.modBC)
        elif nodeName_ == 'pRedBC':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pRedBC')
            value_ = self.gds_validate_string(value_, node, 'pRedBC')
            self.pRedBC = value_
            self.pRedBC_nsprefix_ = child_.prefix
            # validate type TDec_0302
            self.validate_TDec_0302(self.pRedBC)
        elif nodeName_ == 'vBC':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vBC')
            value_ = self.gds_validate_string(value_, node, 'vBC')
            self.vBC = value_
            self.vBC_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vBC)
        elif nodeName_ == 'pICMS':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pICMS')
            value_ = self.gds_validate_string(value_, node, 'pICMS')
            self.pICMS = value_
            self.pICMS_nsprefix_ = child_.prefix
            # validate type TDec_0302
            self.validate_TDec_0302(self.pICMS)
        elif nodeName_ == 'vICMS':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vICMS')
            value_ = self.gds_validate_string(value_, node, 'vICMS')
            self.vICMS = value_
            self.vICMS_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vICMS)
        elif nodeName_ == 'modBCST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'modBCST')
            value_ = self.gds_validate_string(value_, node, 'modBCST')
            self.modBCST = value_
            self.modBCST_nsprefix_ = child_.prefix
            # validate type modBCSTType18
            self.validate_modBCSTType18(self.modBCST)
        elif nodeName_ == 'pMVAST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pMVAST')
            value_ = self.gds_validate_string(value_, node, 'pMVAST')
            self.pMVAST = value_
            self.pMVAST_nsprefix_ = child_.prefix
            # validate type TDec_0302Opc
            self.validate_TDec_0302Opc(self.pMVAST)
        elif nodeName_ == 'pRedBCST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pRedBCST')
            value_ = self.gds_validate_string(value_, node, 'pRedBCST')
            self.pRedBCST = value_
            self.pRedBCST_nsprefix_ = child_.prefix
            # validate type TDec_0302Opc
            self.validate_TDec_0302Opc(self.pRedBCST)
        elif nodeName_ == 'vBCST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vBCST')
            value_ = self.gds_validate_string(value_, node, 'vBCST')
            self.vBCST = value_
            self.vBCST_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vBCST)
        elif nodeName_ == 'pICMSST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pICMSST')
            value_ = self.gds_validate_string(value_, node, 'pICMSST')
            self.pICMSST = value_
            self.pICMSST_nsprefix_ = child_.prefix
            # validate type TDec_0302
            self.validate_TDec_0302(self.pICMSST)
        elif nodeName_ == 'vICMSST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vICMSST')
            value_ = self.gds_validate_string(value_, node, 'vICMSST')
            self.vICMSST = value_
            self.vICMSST_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vICMSST)
# end class ICMS70Type


class ICMS90Type(GeneratedsSuper):
    """Tributação pelo ICMS
    90 - Outras"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('orig', ['Torig', 'xs:string'], 0, 0, {'name': 'orig', 'type': 'xs:string'}, None),
        MemberSpec_('CST', ['CSTType19', 'xs:string'], 0, 0, {'name': 'CST', 'type': 'xs:string'}, None),
        MemberSpec_('modBC', ['modBCType20', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'modBC', 'type': 'xs:string'}, None),
        MemberSpec_('vBC', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vBC', 'type': 'xs:string'}, None),
        MemberSpec_('pRedBC', ['TDec_0302Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pRedBC', 'type': 'xs:string'}, None),
        MemberSpec_('pICMS', ['TDec_0302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pICMS', 'type': 'xs:string'}, None),
        MemberSpec_('vICMS', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vICMS', 'type': 'xs:string'}, None),
        MemberSpec_('modBCST', ['modBCSTType21', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'modBCST', 'type': 'xs:string'}, None),
        MemberSpec_('pMVAST', ['TDec_0302Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pMVAST', 'type': 'xs:string'}, None),
        MemberSpec_('pRedBCST', ['TDec_0302Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pRedBCST', 'type': 'xs:string'}, None),
        MemberSpec_('vBCST', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vBCST', 'type': 'xs:string'}, None),
        MemberSpec_('pICMSST', ['TDec_0302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pICMSST', 'type': 'xs:string'}, None),
        MemberSpec_('vICMSST', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vICMSST', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, orig=None, CST=None, modBC=None, vBC=None, pRedBC=None, pICMS=None, vICMS=None, modBCST=None, pMVAST=None, pRedBCST=None, vBCST=None, pICMSST=None, vICMSST=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.orig = orig
        self.validate_Torig(self.orig)
        self.orig_nsprefix_ = None
        self.CST = CST
        self.validate_CSTType19(self.CST)
        self.CST_nsprefix_ = None
        self.modBC = modBC
        self.validate_modBCType20(self.modBC)
        self.modBC_nsprefix_ = None
        self.vBC = vBC
        self.validate_TDec_1302(self.vBC)
        self.vBC_nsprefix_ = None
        self.pRedBC = pRedBC
        self.validate_TDec_0302Opc(self.pRedBC)
        self.pRedBC_nsprefix_ = None
        self.pICMS = pICMS
        self.validate_TDec_0302(self.pICMS)
        self.pICMS_nsprefix_ = None
        self.vICMS = vICMS
        self.validate_TDec_1302(self.vICMS)
        self.vICMS_nsprefix_ = None
        self.modBCST = modBCST
        self.validate_modBCSTType21(self.modBCST)
        self.modBCST_nsprefix_ = None
        self.pMVAST = pMVAST
        self.validate_TDec_0302Opc(self.pMVAST)
        self.pMVAST_nsprefix_ = None
        self.pRedBCST = pRedBCST
        self.validate_TDec_0302Opc(self.pRedBCST)
        self.pRedBCST_nsprefix_ = None
        self.vBCST = vBCST
        self.validate_TDec_1302(self.vBCST)
        self.vBCST_nsprefix_ = None
        self.pICMSST = pICMSST
        self.validate_TDec_0302(self.pICMSST)
        self.pICMSST_nsprefix_ = None
        self.vICMSST = vICMSST
        self.validate_TDec_1302(self.vICMSST)
        self.vICMSST_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ICMS90Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ICMS90Type.subclass:
            return ICMS90Type.subclass(*args_, **kwargs_)
        else:
            return ICMS90Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Torig(self, value):
        result = True
        # Validate type Torig, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5', '6', '7', '8']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on Torig' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CSTType19(self, value):
        result = True
        # Validate type CSTType19, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['90']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on CSTType19' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_modBCType20(self, value):
        result = True
        # Validate type modBCType20, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on modBCType20' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def validate_TDec_0302Opc(self, value):
        result = True
        # Validate type TDec_0302Opc, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0302Opc_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0302Opc_patterns_, ))
                result = False
        return result
    validate_TDec_0302Opc_patterns_ = [['^(0\\.[0-9]{1}[1-9]{1}|0\\.[1-9]{1}[0-9]{1}|[1-9]{1}[0-9]{0,2}(\\.[0-9]{2})?)$']]
    def validate_TDec_0302(self, value):
        result = True
        # Validate type TDec_0302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0302_patterns_, ))
                result = False
        return result
    validate_TDec_0302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,2}(\\.[0-9]{2})?)$']]
    def validate_modBCSTType21(self, value):
        result = True
        # Validate type modBCSTType21, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on modBCSTType21' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def hasContent_(self):
        if (
            self.orig is not None or
            self.CST is not None or
            self.modBC is not None or
            self.vBC is not None or
            self.pRedBC is not None or
            self.pICMS is not None or
            self.vICMS is not None or
            self.modBCST is not None or
            self.pMVAST is not None or
            self.pRedBCST is not None or
            self.vBCST is not None or
            self.pICMSST is not None or
            self.vICMSST is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMS90Type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ICMS90Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ICMS90Type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ICMS90Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ICMS90Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ICMS90Type'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMS90Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.orig is not None:
            namespaceprefix_ = self.orig_nsprefix_ + ':' if (UseCapturedNS_ and self.orig_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorig>%s</%sorig>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.orig), input_name='orig')), namespaceprefix_ , eol_))
        if self.CST is not None:
            namespaceprefix_ = self.CST_nsprefix_ + ':' if (UseCapturedNS_ and self.CST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCST>%s</%sCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CST), input_name='CST')), namespaceprefix_ , eol_))
        if self.modBC is not None:
            namespaceprefix_ = self.modBC_nsprefix_ + ':' if (UseCapturedNS_ and self.modBC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smodBC>%s</%smodBC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.modBC), input_name='modBC')), namespaceprefix_ , eol_))
        if self.vBC is not None:
            namespaceprefix_ = self.vBC_nsprefix_ + ':' if (UseCapturedNS_ and self.vBC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svBC>%s</%svBC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vBC), input_name='vBC')), namespaceprefix_ , eol_))
        if self.pRedBC is not None:
            namespaceprefix_ = self.pRedBC_nsprefix_ + ':' if (UseCapturedNS_ and self.pRedBC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spRedBC>%s</%spRedBC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pRedBC), input_name='pRedBC')), namespaceprefix_ , eol_))
        if self.pICMS is not None:
            namespaceprefix_ = self.pICMS_nsprefix_ + ':' if (UseCapturedNS_ and self.pICMS_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spICMS>%s</%spICMS>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pICMS), input_name='pICMS')), namespaceprefix_ , eol_))
        if self.vICMS is not None:
            namespaceprefix_ = self.vICMS_nsprefix_ + ':' if (UseCapturedNS_ and self.vICMS_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svICMS>%s</%svICMS>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vICMS), input_name='vICMS')), namespaceprefix_ , eol_))
        if self.modBCST is not None:
            namespaceprefix_ = self.modBCST_nsprefix_ + ':' if (UseCapturedNS_ and self.modBCST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smodBCST>%s</%smodBCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.modBCST), input_name='modBCST')), namespaceprefix_ , eol_))
        if self.pMVAST is not None:
            namespaceprefix_ = self.pMVAST_nsprefix_ + ':' if (UseCapturedNS_ and self.pMVAST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spMVAST>%s</%spMVAST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pMVAST), input_name='pMVAST')), namespaceprefix_ , eol_))
        if self.pRedBCST is not None:
            namespaceprefix_ = self.pRedBCST_nsprefix_ + ':' if (UseCapturedNS_ and self.pRedBCST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spRedBCST>%s</%spRedBCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pRedBCST), input_name='pRedBCST')), namespaceprefix_ , eol_))
        if self.vBCST is not None:
            namespaceprefix_ = self.vBCST_nsprefix_ + ':' if (UseCapturedNS_ and self.vBCST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svBCST>%s</%svBCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vBCST), input_name='vBCST')), namespaceprefix_ , eol_))
        if self.pICMSST is not None:
            namespaceprefix_ = self.pICMSST_nsprefix_ + ':' if (UseCapturedNS_ and self.pICMSST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spICMSST>%s</%spICMSST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pICMSST), input_name='pICMSST')), namespaceprefix_ , eol_))
        if self.vICMSST is not None:
            namespaceprefix_ = self.vICMSST_nsprefix_ + ':' if (UseCapturedNS_ and self.vICMSST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svICMSST>%s</%svICMSST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vICMSST), input_name='vICMSST')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'orig':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'orig')
            value_ = self.gds_validate_string(value_, node, 'orig')
            self.orig = value_
            self.orig_nsprefix_ = child_.prefix
            # validate type Torig
            self.validate_Torig(self.orig)
        elif nodeName_ == 'CST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CST')
            value_ = self.gds_validate_string(value_, node, 'CST')
            self.CST = value_
            self.CST_nsprefix_ = child_.prefix
            # validate type CSTType19
            self.validate_CSTType19(self.CST)
        elif nodeName_ == 'modBC':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'modBC')
            value_ = self.gds_validate_string(value_, node, 'modBC')
            self.modBC = value_
            self.modBC_nsprefix_ = child_.prefix
            # validate type modBCType20
            self.validate_modBCType20(self.modBC)
        elif nodeName_ == 'vBC':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vBC')
            value_ = self.gds_validate_string(value_, node, 'vBC')
            self.vBC = value_
            self.vBC_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vBC)
        elif nodeName_ == 'pRedBC':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pRedBC')
            value_ = self.gds_validate_string(value_, node, 'pRedBC')
            self.pRedBC = value_
            self.pRedBC_nsprefix_ = child_.prefix
            # validate type TDec_0302Opc
            self.validate_TDec_0302Opc(self.pRedBC)
        elif nodeName_ == 'pICMS':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pICMS')
            value_ = self.gds_validate_string(value_, node, 'pICMS')
            self.pICMS = value_
            self.pICMS_nsprefix_ = child_.prefix
            # validate type TDec_0302
            self.validate_TDec_0302(self.pICMS)
        elif nodeName_ == 'vICMS':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vICMS')
            value_ = self.gds_validate_string(value_, node, 'vICMS')
            self.vICMS = value_
            self.vICMS_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vICMS)
        elif nodeName_ == 'modBCST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'modBCST')
            value_ = self.gds_validate_string(value_, node, 'modBCST')
            self.modBCST = value_
            self.modBCST_nsprefix_ = child_.prefix
            # validate type modBCSTType21
            self.validate_modBCSTType21(self.modBCST)
        elif nodeName_ == 'pMVAST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pMVAST')
            value_ = self.gds_validate_string(value_, node, 'pMVAST')
            self.pMVAST = value_
            self.pMVAST_nsprefix_ = child_.prefix
            # validate type TDec_0302Opc
            self.validate_TDec_0302Opc(self.pMVAST)
        elif nodeName_ == 'pRedBCST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pRedBCST')
            value_ = self.gds_validate_string(value_, node, 'pRedBCST')
            self.pRedBCST = value_
            self.pRedBCST_nsprefix_ = child_.prefix
            # validate type TDec_0302Opc
            self.validate_TDec_0302Opc(self.pRedBCST)
        elif nodeName_ == 'vBCST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vBCST')
            value_ = self.gds_validate_string(value_, node, 'vBCST')
            self.vBCST = value_
            self.vBCST_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vBCST)
        elif nodeName_ == 'pICMSST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pICMSST')
            value_ = self.gds_validate_string(value_, node, 'pICMSST')
            self.pICMSST = value_
            self.pICMSST_nsprefix_ = child_.prefix
            # validate type TDec_0302
            self.validate_TDec_0302(self.pICMSST)
        elif nodeName_ == 'vICMSST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vICMSST')
            value_ = self.gds_validate_string(value_, node, 'vICMSST')
            self.vICMSST = value_
            self.vICMSST_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vICMSST)
# end class ICMS90Type


class ICMSPartType(GeneratedsSuper):
    """Partilha do ICMS entre a UF de origem e UF de destino ou a UF definida
    na legislação
    Operação interestadual para consumidor final com partilha do ICMS devido na
    operação entre a UF de origem e a UF do destinatário ou ou a UF
    definida na legislação. (Ex. UF da concessionária de entrega do
    veículos) (v2.0)"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('orig', ['Torig', 'xs:string'], 0, 0, {'name': 'orig', 'type': 'xs:string'}, None),
        MemberSpec_('CST', ['CSTType22', 'xs:string'], 0, 0, {'name': 'CST', 'type': 'xs:string'}, None),
        MemberSpec_('modBC', ['modBCType23', 'xs:string'], 0, 0, {'name': 'modBC', 'type': 'xs:string'}, None),
        MemberSpec_('vBC', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vBC', 'type': 'xs:string'}, None),
        MemberSpec_('pRedBC', ['TDec_0302Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pRedBC', 'type': 'xs:string'}, None),
        MemberSpec_('pICMS', ['TDec_0302', 'xs:string'], 0, 0, {'name': 'pICMS', 'type': 'xs:string'}, None),
        MemberSpec_('vICMS', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vICMS', 'type': 'xs:string'}, None),
        MemberSpec_('modBCST', ['modBCSTType24', 'xs:string'], 0, 0, {'name': 'modBCST', 'type': 'xs:string'}, None),
        MemberSpec_('pMVAST', ['TDec_0302Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pMVAST', 'type': 'xs:string'}, None),
        MemberSpec_('pRedBCST', ['TDec_0302Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pRedBCST', 'type': 'xs:string'}, None),
        MemberSpec_('vBCST', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vBCST', 'type': 'xs:string'}, None),
        MemberSpec_('pICMSST', ['TDec_0302', 'xs:string'], 0, 0, {'name': 'pICMSST', 'type': 'xs:string'}, None),
        MemberSpec_('vICMSST', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vICMSST', 'type': 'xs:string'}, None),
        MemberSpec_('pBCOp', ['TDec_0302Opc', 'xs:string'], 0, 0, {'name': 'pBCOp', 'type': 'xs:string'}, None),
        MemberSpec_('UFST', ['TUf', 'xs:string'], 0, 0, {'name': 'UFST', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, orig=None, CST=None, modBC=None, vBC=None, pRedBC=None, pICMS=None, vICMS=None, modBCST=None, pMVAST=None, pRedBCST=None, vBCST=None, pICMSST=None, vICMSST=None, pBCOp=None, UFST=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.orig = orig
        self.validate_Torig(self.orig)
        self.orig_nsprefix_ = None
        self.CST = CST
        self.validate_CSTType22(self.CST)
        self.CST_nsprefix_ = None
        self.modBC = modBC
        self.validate_modBCType23(self.modBC)
        self.modBC_nsprefix_ = None
        self.vBC = vBC
        self.validate_TDec_1302(self.vBC)
        self.vBC_nsprefix_ = None
        self.pRedBC = pRedBC
        self.validate_TDec_0302Opc(self.pRedBC)
        self.pRedBC_nsprefix_ = None
        self.pICMS = pICMS
        self.validate_TDec_0302(self.pICMS)
        self.pICMS_nsprefix_ = None
        self.vICMS = vICMS
        self.validate_TDec_1302(self.vICMS)
        self.vICMS_nsprefix_ = None
        self.modBCST = modBCST
        self.validate_modBCSTType24(self.modBCST)
        self.modBCST_nsprefix_ = None
        self.pMVAST = pMVAST
        self.validate_TDec_0302Opc(self.pMVAST)
        self.pMVAST_nsprefix_ = None
        self.pRedBCST = pRedBCST
        self.validate_TDec_0302Opc(self.pRedBCST)
        self.pRedBCST_nsprefix_ = None
        self.vBCST = vBCST
        self.validate_TDec_1302(self.vBCST)
        self.vBCST_nsprefix_ = None
        self.pICMSST = pICMSST
        self.validate_TDec_0302(self.pICMSST)
        self.pICMSST_nsprefix_ = None
        self.vICMSST = vICMSST
        self.validate_TDec_1302(self.vICMSST)
        self.vICMSST_nsprefix_ = None
        self.pBCOp = pBCOp
        self.validate_TDec_0302Opc(self.pBCOp)
        self.pBCOp_nsprefix_ = None
        self.UFST = UFST
        self.validate_TUf(self.UFST)
        self.UFST_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ICMSPartType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ICMSPartType.subclass:
            return ICMSPartType.subclass(*args_, **kwargs_)
        else:
            return ICMSPartType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Torig(self, value):
        result = True
        # Validate type Torig, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5', '6', '7', '8']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on Torig' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CSTType22(self, value):
        result = True
        # Validate type CSTType22, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['10', '90']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on CSTType22' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_modBCType23(self, value):
        result = True
        # Validate type modBCType23, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on modBCType23' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def validate_TDec_0302Opc(self, value):
        result = True
        # Validate type TDec_0302Opc, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0302Opc_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0302Opc_patterns_, ))
                result = False
        return result
    validate_TDec_0302Opc_patterns_ = [['^(0\\.[0-9]{1}[1-9]{1}|0\\.[1-9]{1}[0-9]{1}|[1-9]{1}[0-9]{0,2}(\\.[0-9]{2})?)$']]
    def validate_TDec_0302(self, value):
        result = True
        # Validate type TDec_0302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0302_patterns_, ))
                result = False
        return result
    validate_TDec_0302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,2}(\\.[0-9]{2})?)$']]
    def validate_modBCSTType24(self, value):
        result = True
        # Validate type modBCSTType24, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on modBCSTType24' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TUf(self, value):
        result = True
        # Validate type TUf, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['AC', 'AL', 'AM', 'AP', 'BA', 'CE', 'DF', 'ES', 'GO', 'MA', 'MG', 'MS', 'MT', 'PA', 'PB', 'PE', 'PI', 'PR', 'RJ', 'RN', 'RO', 'RR', 'RS', 'SC', 'SE', 'SP', 'TO', 'EX']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TUf' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def hasContent_(self):
        if (
            self.orig is not None or
            self.CST is not None or
            self.modBC is not None or
            self.vBC is not None or
            self.pRedBC is not None or
            self.pICMS is not None or
            self.vICMS is not None or
            self.modBCST is not None or
            self.pMVAST is not None or
            self.pRedBCST is not None or
            self.vBCST is not None or
            self.pICMSST is not None or
            self.vICMSST is not None or
            self.pBCOp is not None or
            self.UFST is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMSPartType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ICMSPartType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ICMSPartType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ICMSPartType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ICMSPartType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ICMSPartType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMSPartType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.orig is not None:
            namespaceprefix_ = self.orig_nsprefix_ + ':' if (UseCapturedNS_ and self.orig_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorig>%s</%sorig>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.orig), input_name='orig')), namespaceprefix_ , eol_))
        if self.CST is not None:
            namespaceprefix_ = self.CST_nsprefix_ + ':' if (UseCapturedNS_ and self.CST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCST>%s</%sCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CST), input_name='CST')), namespaceprefix_ , eol_))
        if self.modBC is not None:
            namespaceprefix_ = self.modBC_nsprefix_ + ':' if (UseCapturedNS_ and self.modBC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smodBC>%s</%smodBC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.modBC), input_name='modBC')), namespaceprefix_ , eol_))
        if self.vBC is not None:
            namespaceprefix_ = self.vBC_nsprefix_ + ':' if (UseCapturedNS_ and self.vBC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svBC>%s</%svBC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vBC), input_name='vBC')), namespaceprefix_ , eol_))
        if self.pRedBC is not None:
            namespaceprefix_ = self.pRedBC_nsprefix_ + ':' if (UseCapturedNS_ and self.pRedBC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spRedBC>%s</%spRedBC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pRedBC), input_name='pRedBC')), namespaceprefix_ , eol_))
        if self.pICMS is not None:
            namespaceprefix_ = self.pICMS_nsprefix_ + ':' if (UseCapturedNS_ and self.pICMS_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spICMS>%s</%spICMS>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pICMS), input_name='pICMS')), namespaceprefix_ , eol_))
        if self.vICMS is not None:
            namespaceprefix_ = self.vICMS_nsprefix_ + ':' if (UseCapturedNS_ and self.vICMS_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svICMS>%s</%svICMS>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vICMS), input_name='vICMS')), namespaceprefix_ , eol_))
        if self.modBCST is not None:
            namespaceprefix_ = self.modBCST_nsprefix_ + ':' if (UseCapturedNS_ and self.modBCST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smodBCST>%s</%smodBCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.modBCST), input_name='modBCST')), namespaceprefix_ , eol_))
        if self.pMVAST is not None:
            namespaceprefix_ = self.pMVAST_nsprefix_ + ':' if (UseCapturedNS_ and self.pMVAST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spMVAST>%s</%spMVAST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pMVAST), input_name='pMVAST')), namespaceprefix_ , eol_))
        if self.pRedBCST is not None:
            namespaceprefix_ = self.pRedBCST_nsprefix_ + ':' if (UseCapturedNS_ and self.pRedBCST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spRedBCST>%s</%spRedBCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pRedBCST), input_name='pRedBCST')), namespaceprefix_ , eol_))
        if self.vBCST is not None:
            namespaceprefix_ = self.vBCST_nsprefix_ + ':' if (UseCapturedNS_ and self.vBCST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svBCST>%s</%svBCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vBCST), input_name='vBCST')), namespaceprefix_ , eol_))
        if self.pICMSST is not None:
            namespaceprefix_ = self.pICMSST_nsprefix_ + ':' if (UseCapturedNS_ and self.pICMSST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spICMSST>%s</%spICMSST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pICMSST), input_name='pICMSST')), namespaceprefix_ , eol_))
        if self.vICMSST is not None:
            namespaceprefix_ = self.vICMSST_nsprefix_ + ':' if (UseCapturedNS_ and self.vICMSST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svICMSST>%s</%svICMSST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vICMSST), input_name='vICMSST')), namespaceprefix_ , eol_))
        if self.pBCOp is not None:
            namespaceprefix_ = self.pBCOp_nsprefix_ + ':' if (UseCapturedNS_ and self.pBCOp_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spBCOp>%s</%spBCOp>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pBCOp), input_name='pBCOp')), namespaceprefix_ , eol_))
        if self.UFST is not None:
            namespaceprefix_ = self.UFST_nsprefix_ + ':' if (UseCapturedNS_ and self.UFST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUFST>%s</%sUFST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.UFST), input_name='UFST')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'orig':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'orig')
            value_ = self.gds_validate_string(value_, node, 'orig')
            self.orig = value_
            self.orig_nsprefix_ = child_.prefix
            # validate type Torig
            self.validate_Torig(self.orig)
        elif nodeName_ == 'CST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CST')
            value_ = self.gds_validate_string(value_, node, 'CST')
            self.CST = value_
            self.CST_nsprefix_ = child_.prefix
            # validate type CSTType22
            self.validate_CSTType22(self.CST)
        elif nodeName_ == 'modBC':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'modBC')
            value_ = self.gds_validate_string(value_, node, 'modBC')
            self.modBC = value_
            self.modBC_nsprefix_ = child_.prefix
            # validate type modBCType23
            self.validate_modBCType23(self.modBC)
        elif nodeName_ == 'vBC':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vBC')
            value_ = self.gds_validate_string(value_, node, 'vBC')
            self.vBC = value_
            self.vBC_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vBC)
        elif nodeName_ == 'pRedBC':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pRedBC')
            value_ = self.gds_validate_string(value_, node, 'pRedBC')
            self.pRedBC = value_
            self.pRedBC_nsprefix_ = child_.prefix
            # validate type TDec_0302Opc
            self.validate_TDec_0302Opc(self.pRedBC)
        elif nodeName_ == 'pICMS':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pICMS')
            value_ = self.gds_validate_string(value_, node, 'pICMS')
            self.pICMS = value_
            self.pICMS_nsprefix_ = child_.prefix
            # validate type TDec_0302
            self.validate_TDec_0302(self.pICMS)
        elif nodeName_ == 'vICMS':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vICMS')
            value_ = self.gds_validate_string(value_, node, 'vICMS')
            self.vICMS = value_
            self.vICMS_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vICMS)
        elif nodeName_ == 'modBCST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'modBCST')
            value_ = self.gds_validate_string(value_, node, 'modBCST')
            self.modBCST = value_
            self.modBCST_nsprefix_ = child_.prefix
            # validate type modBCSTType24
            self.validate_modBCSTType24(self.modBCST)
        elif nodeName_ == 'pMVAST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pMVAST')
            value_ = self.gds_validate_string(value_, node, 'pMVAST')
            self.pMVAST = value_
            self.pMVAST_nsprefix_ = child_.prefix
            # validate type TDec_0302Opc
            self.validate_TDec_0302Opc(self.pMVAST)
        elif nodeName_ == 'pRedBCST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pRedBCST')
            value_ = self.gds_validate_string(value_, node, 'pRedBCST')
            self.pRedBCST = value_
            self.pRedBCST_nsprefix_ = child_.prefix
            # validate type TDec_0302Opc
            self.validate_TDec_0302Opc(self.pRedBCST)
        elif nodeName_ == 'vBCST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vBCST')
            value_ = self.gds_validate_string(value_, node, 'vBCST')
            self.vBCST = value_
            self.vBCST_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vBCST)
        elif nodeName_ == 'pICMSST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pICMSST')
            value_ = self.gds_validate_string(value_, node, 'pICMSST')
            self.pICMSST = value_
            self.pICMSST_nsprefix_ = child_.prefix
            # validate type TDec_0302
            self.validate_TDec_0302(self.pICMSST)
        elif nodeName_ == 'vICMSST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vICMSST')
            value_ = self.gds_validate_string(value_, node, 'vICMSST')
            self.vICMSST = value_
            self.vICMSST_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vICMSST)
        elif nodeName_ == 'pBCOp':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pBCOp')
            value_ = self.gds_validate_string(value_, node, 'pBCOp')
            self.pBCOp = value_
            self.pBCOp_nsprefix_ = child_.prefix
            # validate type TDec_0302Opc
            self.validate_TDec_0302Opc(self.pBCOp)
        elif nodeName_ == 'UFST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'UFST')
            value_ = self.gds_validate_string(value_, node, 'UFST')
            self.UFST = value_
            self.UFST_nsprefix_ = child_.prefix
            # validate type TUf
            self.validate_TUf(self.UFST)
# end class ICMSPartType


class ICMSSTType(GeneratedsSuper):
    """Grupo de informação do ICMSST devido para a UF de destino, nas operações
    interestaduais de produtos que tiveram retenção antecipada de ICMS por
    ST na UF do remetente. Repasse via Substituto Tributário. (v2.0)"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('orig', ['Torig', 'xs:string'], 0, 0, {'name': 'orig', 'type': 'xs:string'}, None),
        MemberSpec_('CST', ['CSTType25', 'xs:string'], 0, 0, {'name': 'CST', 'type': 'xs:string'}, None),
        MemberSpec_('vBCSTRet', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vBCSTRet', 'type': 'xs:string'}, None),
        MemberSpec_('vICMSSTRet', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vICMSSTRet', 'type': 'xs:string'}, None),
        MemberSpec_('vBCSTDest', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vBCSTDest', 'type': 'xs:string'}, None),
        MemberSpec_('vICMSSTDest', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vICMSSTDest', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, orig=None, CST=None, vBCSTRet=None, vICMSSTRet=None, vBCSTDest=None, vICMSSTDest=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.orig = orig
        self.validate_Torig(self.orig)
        self.orig_nsprefix_ = None
        self.CST = CST
        self.validate_CSTType25(self.CST)
        self.CST_nsprefix_ = None
        self.vBCSTRet = vBCSTRet
        self.validate_TDec_1302(self.vBCSTRet)
        self.vBCSTRet_nsprefix_ = None
        self.vICMSSTRet = vICMSSTRet
        self.validate_TDec_1302(self.vICMSSTRet)
        self.vICMSSTRet_nsprefix_ = None
        self.vBCSTDest = vBCSTDest
        self.validate_TDec_1302(self.vBCSTDest)
        self.vBCSTDest_nsprefix_ = None
        self.vICMSSTDest = vICMSSTDest
        self.validate_TDec_1302(self.vICMSSTDest)
        self.vICMSSTDest_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ICMSSTType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ICMSSTType.subclass:
            return ICMSSTType.subclass(*args_, **kwargs_)
        else:
            return ICMSSTType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Torig(self, value):
        result = True
        # Validate type Torig, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5', '6', '7', '8']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on Torig' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CSTType25(self, value):
        result = True
        # Validate type CSTType25, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['41']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on CSTType25' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def hasContent_(self):
        if (
            self.orig is not None or
            self.CST is not None or
            self.vBCSTRet is not None or
            self.vICMSSTRet is not None or
            self.vBCSTDest is not None or
            self.vICMSSTDest is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMSSTType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ICMSSTType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ICMSSTType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ICMSSTType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ICMSSTType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ICMSSTType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMSSTType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.orig is not None:
            namespaceprefix_ = self.orig_nsprefix_ + ':' if (UseCapturedNS_ and self.orig_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorig>%s</%sorig>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.orig), input_name='orig')), namespaceprefix_ , eol_))
        if self.CST is not None:
            namespaceprefix_ = self.CST_nsprefix_ + ':' if (UseCapturedNS_ and self.CST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCST>%s</%sCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CST), input_name='CST')), namespaceprefix_ , eol_))
        if self.vBCSTRet is not None:
            namespaceprefix_ = self.vBCSTRet_nsprefix_ + ':' if (UseCapturedNS_ and self.vBCSTRet_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svBCSTRet>%s</%svBCSTRet>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vBCSTRet), input_name='vBCSTRet')), namespaceprefix_ , eol_))
        if self.vICMSSTRet is not None:
            namespaceprefix_ = self.vICMSSTRet_nsprefix_ + ':' if (UseCapturedNS_ and self.vICMSSTRet_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svICMSSTRet>%s</%svICMSSTRet>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vICMSSTRet), input_name='vICMSSTRet')), namespaceprefix_ , eol_))
        if self.vBCSTDest is not None:
            namespaceprefix_ = self.vBCSTDest_nsprefix_ + ':' if (UseCapturedNS_ and self.vBCSTDest_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svBCSTDest>%s</%svBCSTDest>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vBCSTDest), input_name='vBCSTDest')), namespaceprefix_ , eol_))
        if self.vICMSSTDest is not None:
            namespaceprefix_ = self.vICMSSTDest_nsprefix_ + ':' if (UseCapturedNS_ and self.vICMSSTDest_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svICMSSTDest>%s</%svICMSSTDest>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vICMSSTDest), input_name='vICMSSTDest')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'orig':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'orig')
            value_ = self.gds_validate_string(value_, node, 'orig')
            self.orig = value_
            self.orig_nsprefix_ = child_.prefix
            # validate type Torig
            self.validate_Torig(self.orig)
        elif nodeName_ == 'CST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CST')
            value_ = self.gds_validate_string(value_, node, 'CST')
            self.CST = value_
            self.CST_nsprefix_ = child_.prefix
            # validate type CSTType25
            self.validate_CSTType25(self.CST)
        elif nodeName_ == 'vBCSTRet':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vBCSTRet')
            value_ = self.gds_validate_string(value_, node, 'vBCSTRet')
            self.vBCSTRet = value_
            self.vBCSTRet_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vBCSTRet)
        elif nodeName_ == 'vICMSSTRet':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vICMSSTRet')
            value_ = self.gds_validate_string(value_, node, 'vICMSSTRet')
            self.vICMSSTRet = value_
            self.vICMSSTRet_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vICMSSTRet)
        elif nodeName_ == 'vBCSTDest':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vBCSTDest')
            value_ = self.gds_validate_string(value_, node, 'vBCSTDest')
            self.vBCSTDest = value_
            self.vBCSTDest_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vBCSTDest)
        elif nodeName_ == 'vICMSSTDest':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vICMSSTDest')
            value_ = self.gds_validate_string(value_, node, 'vICMSSTDest')
            self.vICMSSTDest = value_
            self.vICMSSTDest_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vICMSSTDest)
# end class ICMSSTType


class ICMSSN101Type(GeneratedsSuper):
    """Tributação do ICMS pelo SIMPLES NACIONAL e CSOSN=101 (v.2.0)"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('orig', ['Torig', 'xs:string'], 0, 0, {'name': 'orig', 'type': 'xs:string'}, None),
        MemberSpec_('CSOSN', ['CSOSNType', 'xs:string'], 0, 0, {'name': 'CSOSN', 'type': 'xs:string'}, None),
        MemberSpec_('pCredSN', ['TDec_0302', 'xs:string'], 0, 0, {'name': 'pCredSN', 'type': 'xs:string'}, None),
        MemberSpec_('vCredICMSSN', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vCredICMSSN', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, orig=None, CSOSN=None, pCredSN=None, vCredICMSSN=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.orig = orig
        self.validate_Torig(self.orig)
        self.orig_nsprefix_ = None
        self.CSOSN = CSOSN
        self.validate_CSOSNType(self.CSOSN)
        self.CSOSN_nsprefix_ = None
        self.pCredSN = pCredSN
        self.validate_TDec_0302(self.pCredSN)
        self.pCredSN_nsprefix_ = None
        self.vCredICMSSN = vCredICMSSN
        self.validate_TDec_1302(self.vCredICMSSN)
        self.vCredICMSSN_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ICMSSN101Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ICMSSN101Type.subclass:
            return ICMSSN101Type.subclass(*args_, **kwargs_)
        else:
            return ICMSSN101Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Torig(self, value):
        result = True
        # Validate type Torig, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5', '6', '7', '8']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on Torig' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CSOSNType(self, value):
        result = True
        # Validate type CSOSNType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['101']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on CSOSNType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TDec_0302(self, value):
        result = True
        # Validate type TDec_0302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0302_patterns_, ))
                result = False
        return result
    validate_TDec_0302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,2}(\\.[0-9]{2})?)$']]
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def hasContent_(self):
        if (
            self.orig is not None or
            self.CSOSN is not None or
            self.pCredSN is not None or
            self.vCredICMSSN is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMSSN101Type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ICMSSN101Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ICMSSN101Type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ICMSSN101Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ICMSSN101Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ICMSSN101Type'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMSSN101Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.orig is not None:
            namespaceprefix_ = self.orig_nsprefix_ + ':' if (UseCapturedNS_ and self.orig_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorig>%s</%sorig>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.orig), input_name='orig')), namespaceprefix_ , eol_))
        if self.CSOSN is not None:
            namespaceprefix_ = self.CSOSN_nsprefix_ + ':' if (UseCapturedNS_ and self.CSOSN_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCSOSN>%s</%sCSOSN>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CSOSN), input_name='CSOSN')), namespaceprefix_ , eol_))
        if self.pCredSN is not None:
            namespaceprefix_ = self.pCredSN_nsprefix_ + ':' if (UseCapturedNS_ and self.pCredSN_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spCredSN>%s</%spCredSN>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pCredSN), input_name='pCredSN')), namespaceprefix_ , eol_))
        if self.vCredICMSSN is not None:
            namespaceprefix_ = self.vCredICMSSN_nsprefix_ + ':' if (UseCapturedNS_ and self.vCredICMSSN_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svCredICMSSN>%s</%svCredICMSSN>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vCredICMSSN), input_name='vCredICMSSN')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'orig':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'orig')
            value_ = self.gds_validate_string(value_, node, 'orig')
            self.orig = value_
            self.orig_nsprefix_ = child_.prefix
            # validate type Torig
            self.validate_Torig(self.orig)
        elif nodeName_ == 'CSOSN':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CSOSN')
            value_ = self.gds_validate_string(value_, node, 'CSOSN')
            self.CSOSN = value_
            self.CSOSN_nsprefix_ = child_.prefix
            # validate type CSOSNType
            self.validate_CSOSNType(self.CSOSN)
        elif nodeName_ == 'pCredSN':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pCredSN')
            value_ = self.gds_validate_string(value_, node, 'pCredSN')
            self.pCredSN = value_
            self.pCredSN_nsprefix_ = child_.prefix
            # validate type TDec_0302
            self.validate_TDec_0302(self.pCredSN)
        elif nodeName_ == 'vCredICMSSN':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vCredICMSSN')
            value_ = self.gds_validate_string(value_, node, 'vCredICMSSN')
            self.vCredICMSSN = value_
            self.vCredICMSSN_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vCredICMSSN)
# end class ICMSSN101Type


class ICMSSN102Type(GeneratedsSuper):
    """Tributação do ICMS pelo SIMPLES NACIONAL e CSOSN=102, 103, 300 ou 400
    (v.2.0))"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('orig', ['Torig', 'xs:string'], 0, 0, {'name': 'orig', 'type': 'xs:string'}, None),
        MemberSpec_('CSOSN', ['CSOSNType26', 'xs:string'], 0, 0, {'name': 'CSOSN', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, orig=None, CSOSN=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.orig = orig
        self.validate_Torig(self.orig)
        self.orig_nsprefix_ = None
        self.CSOSN = CSOSN
        self.validate_CSOSNType26(self.CSOSN)
        self.CSOSN_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ICMSSN102Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ICMSSN102Type.subclass:
            return ICMSSN102Type.subclass(*args_, **kwargs_)
        else:
            return ICMSSN102Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Torig(self, value):
        result = True
        # Validate type Torig, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5', '6', '7', '8']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on Torig' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CSOSNType26(self, value):
        result = True
        # Validate type CSOSNType26, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['102', '103', '300', '400']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on CSOSNType26' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def hasContent_(self):
        if (
            self.orig is not None or
            self.CSOSN is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMSSN102Type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ICMSSN102Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ICMSSN102Type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ICMSSN102Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ICMSSN102Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ICMSSN102Type'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMSSN102Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.orig is not None:
            namespaceprefix_ = self.orig_nsprefix_ + ':' if (UseCapturedNS_ and self.orig_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorig>%s</%sorig>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.orig), input_name='orig')), namespaceprefix_ , eol_))
        if self.CSOSN is not None:
            namespaceprefix_ = self.CSOSN_nsprefix_ + ':' if (UseCapturedNS_ and self.CSOSN_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCSOSN>%s</%sCSOSN>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CSOSN), input_name='CSOSN')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'orig':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'orig')
            value_ = self.gds_validate_string(value_, node, 'orig')
            self.orig = value_
            self.orig_nsprefix_ = child_.prefix
            # validate type Torig
            self.validate_Torig(self.orig)
        elif nodeName_ == 'CSOSN':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CSOSN')
            value_ = self.gds_validate_string(value_, node, 'CSOSN')
            self.CSOSN = value_
            self.CSOSN_nsprefix_ = child_.prefix
            # validate type CSOSNType26
            self.validate_CSOSNType26(self.CSOSN)
# end class ICMSSN102Type


class ICMSSN201Type(GeneratedsSuper):
    """Tributação do ICMS pelo SIMPLES NACIONAL e CSOSN=201 (v.2.0)"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('orig', ['Torig', 'xs:string'], 0, 0, {'name': 'orig', 'type': 'xs:string'}, None),
        MemberSpec_('CSOSN', ['CSOSNType27', 'xs:string'], 0, 0, {'name': 'CSOSN', 'type': 'xs:string'}, None),
        MemberSpec_('modBCST', ['modBCSTType28', 'xs:string'], 0, 0, {'name': 'modBCST', 'type': 'xs:string'}, None),
        MemberSpec_('pMVAST', ['TDec_0302Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pMVAST', 'type': 'xs:string'}, None),
        MemberSpec_('pRedBCST', ['TDec_0302Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pRedBCST', 'type': 'xs:string'}, None),
        MemberSpec_('vBCST', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vBCST', 'type': 'xs:string'}, None),
        MemberSpec_('pICMSST', ['TDec_0302', 'xs:string'], 0, 0, {'name': 'pICMSST', 'type': 'xs:string'}, None),
        MemberSpec_('vICMSST', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vICMSST', 'type': 'xs:string'}, None),
        MemberSpec_('pCredSN', ['TDec_0302', 'xs:string'], 0, 0, {'name': 'pCredSN', 'type': 'xs:string'}, None),
        MemberSpec_('vCredICMSSN', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vCredICMSSN', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, orig=None, CSOSN=None, modBCST=None, pMVAST=None, pRedBCST=None, vBCST=None, pICMSST=None, vICMSST=None, pCredSN=None, vCredICMSSN=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.orig = orig
        self.validate_Torig(self.orig)
        self.orig_nsprefix_ = None
        self.CSOSN = CSOSN
        self.validate_CSOSNType27(self.CSOSN)
        self.CSOSN_nsprefix_ = None
        self.modBCST = modBCST
        self.validate_modBCSTType28(self.modBCST)
        self.modBCST_nsprefix_ = None
        self.pMVAST = pMVAST
        self.validate_TDec_0302Opc(self.pMVAST)
        self.pMVAST_nsprefix_ = None
        self.pRedBCST = pRedBCST
        self.validate_TDec_0302Opc(self.pRedBCST)
        self.pRedBCST_nsprefix_ = None
        self.vBCST = vBCST
        self.validate_TDec_1302(self.vBCST)
        self.vBCST_nsprefix_ = None
        self.pICMSST = pICMSST
        self.validate_TDec_0302(self.pICMSST)
        self.pICMSST_nsprefix_ = None
        self.vICMSST = vICMSST
        self.validate_TDec_1302(self.vICMSST)
        self.vICMSST_nsprefix_ = None
        self.pCredSN = pCredSN
        self.validate_TDec_0302(self.pCredSN)
        self.pCredSN_nsprefix_ = None
        self.vCredICMSSN = vCredICMSSN
        self.validate_TDec_1302(self.vCredICMSSN)
        self.vCredICMSSN_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ICMSSN201Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ICMSSN201Type.subclass:
            return ICMSSN201Type.subclass(*args_, **kwargs_)
        else:
            return ICMSSN201Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Torig(self, value):
        result = True
        # Validate type Torig, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5', '6', '7', '8']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on Torig' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CSOSNType27(self, value):
        result = True
        # Validate type CSOSNType27, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['201']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on CSOSNType27' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_modBCSTType28(self, value):
        result = True
        # Validate type modBCSTType28, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on modBCSTType28' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TDec_0302Opc(self, value):
        result = True
        # Validate type TDec_0302Opc, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0302Opc_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0302Opc_patterns_, ))
                result = False
        return result
    validate_TDec_0302Opc_patterns_ = [['^(0\\.[0-9]{1}[1-9]{1}|0\\.[1-9]{1}[0-9]{1}|[1-9]{1}[0-9]{0,2}(\\.[0-9]{2})?)$']]
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def validate_TDec_0302(self, value):
        result = True
        # Validate type TDec_0302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0302_patterns_, ))
                result = False
        return result
    validate_TDec_0302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,2}(\\.[0-9]{2})?)$']]
    def hasContent_(self):
        if (
            self.orig is not None or
            self.CSOSN is not None or
            self.modBCST is not None or
            self.pMVAST is not None or
            self.pRedBCST is not None or
            self.vBCST is not None or
            self.pICMSST is not None or
            self.vICMSST is not None or
            self.pCredSN is not None or
            self.vCredICMSSN is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMSSN201Type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ICMSSN201Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ICMSSN201Type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ICMSSN201Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ICMSSN201Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ICMSSN201Type'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMSSN201Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.orig is not None:
            namespaceprefix_ = self.orig_nsprefix_ + ':' if (UseCapturedNS_ and self.orig_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorig>%s</%sorig>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.orig), input_name='orig')), namespaceprefix_ , eol_))
        if self.CSOSN is not None:
            namespaceprefix_ = self.CSOSN_nsprefix_ + ':' if (UseCapturedNS_ and self.CSOSN_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCSOSN>%s</%sCSOSN>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CSOSN), input_name='CSOSN')), namespaceprefix_ , eol_))
        if self.modBCST is not None:
            namespaceprefix_ = self.modBCST_nsprefix_ + ':' if (UseCapturedNS_ and self.modBCST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smodBCST>%s</%smodBCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.modBCST), input_name='modBCST')), namespaceprefix_ , eol_))
        if self.pMVAST is not None:
            namespaceprefix_ = self.pMVAST_nsprefix_ + ':' if (UseCapturedNS_ and self.pMVAST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spMVAST>%s</%spMVAST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pMVAST), input_name='pMVAST')), namespaceprefix_ , eol_))
        if self.pRedBCST is not None:
            namespaceprefix_ = self.pRedBCST_nsprefix_ + ':' if (UseCapturedNS_ and self.pRedBCST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spRedBCST>%s</%spRedBCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pRedBCST), input_name='pRedBCST')), namespaceprefix_ , eol_))
        if self.vBCST is not None:
            namespaceprefix_ = self.vBCST_nsprefix_ + ':' if (UseCapturedNS_ and self.vBCST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svBCST>%s</%svBCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vBCST), input_name='vBCST')), namespaceprefix_ , eol_))
        if self.pICMSST is not None:
            namespaceprefix_ = self.pICMSST_nsprefix_ + ':' if (UseCapturedNS_ and self.pICMSST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spICMSST>%s</%spICMSST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pICMSST), input_name='pICMSST')), namespaceprefix_ , eol_))
        if self.vICMSST is not None:
            namespaceprefix_ = self.vICMSST_nsprefix_ + ':' if (UseCapturedNS_ and self.vICMSST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svICMSST>%s</%svICMSST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vICMSST), input_name='vICMSST')), namespaceprefix_ , eol_))
        if self.pCredSN is not None:
            namespaceprefix_ = self.pCredSN_nsprefix_ + ':' if (UseCapturedNS_ and self.pCredSN_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spCredSN>%s</%spCredSN>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pCredSN), input_name='pCredSN')), namespaceprefix_ , eol_))
        if self.vCredICMSSN is not None:
            namespaceprefix_ = self.vCredICMSSN_nsprefix_ + ':' if (UseCapturedNS_ and self.vCredICMSSN_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svCredICMSSN>%s</%svCredICMSSN>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vCredICMSSN), input_name='vCredICMSSN')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'orig':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'orig')
            value_ = self.gds_validate_string(value_, node, 'orig')
            self.orig = value_
            self.orig_nsprefix_ = child_.prefix
            # validate type Torig
            self.validate_Torig(self.orig)
        elif nodeName_ == 'CSOSN':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CSOSN')
            value_ = self.gds_validate_string(value_, node, 'CSOSN')
            self.CSOSN = value_
            self.CSOSN_nsprefix_ = child_.prefix
            # validate type CSOSNType27
            self.validate_CSOSNType27(self.CSOSN)
        elif nodeName_ == 'modBCST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'modBCST')
            value_ = self.gds_validate_string(value_, node, 'modBCST')
            self.modBCST = value_
            self.modBCST_nsprefix_ = child_.prefix
            # validate type modBCSTType28
            self.validate_modBCSTType28(self.modBCST)
        elif nodeName_ == 'pMVAST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pMVAST')
            value_ = self.gds_validate_string(value_, node, 'pMVAST')
            self.pMVAST = value_
            self.pMVAST_nsprefix_ = child_.prefix
            # validate type TDec_0302Opc
            self.validate_TDec_0302Opc(self.pMVAST)
        elif nodeName_ == 'pRedBCST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pRedBCST')
            value_ = self.gds_validate_string(value_, node, 'pRedBCST')
            self.pRedBCST = value_
            self.pRedBCST_nsprefix_ = child_.prefix
            # validate type TDec_0302Opc
            self.validate_TDec_0302Opc(self.pRedBCST)
        elif nodeName_ == 'vBCST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vBCST')
            value_ = self.gds_validate_string(value_, node, 'vBCST')
            self.vBCST = value_
            self.vBCST_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vBCST)
        elif nodeName_ == 'pICMSST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pICMSST')
            value_ = self.gds_validate_string(value_, node, 'pICMSST')
            self.pICMSST = value_
            self.pICMSST_nsprefix_ = child_.prefix
            # validate type TDec_0302
            self.validate_TDec_0302(self.pICMSST)
        elif nodeName_ == 'vICMSST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vICMSST')
            value_ = self.gds_validate_string(value_, node, 'vICMSST')
            self.vICMSST = value_
            self.vICMSST_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vICMSST)
        elif nodeName_ == 'pCredSN':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pCredSN')
            value_ = self.gds_validate_string(value_, node, 'pCredSN')
            self.pCredSN = value_
            self.pCredSN_nsprefix_ = child_.prefix
            # validate type TDec_0302
            self.validate_TDec_0302(self.pCredSN)
        elif nodeName_ == 'vCredICMSSN':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vCredICMSSN')
            value_ = self.gds_validate_string(value_, node, 'vCredICMSSN')
            self.vCredICMSSN = value_
            self.vCredICMSSN_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vCredICMSSN)
# end class ICMSSN201Type


class ICMSSN202Type(GeneratedsSuper):
    """Tributação do ICMS pelo SIMPLES NACIONAL e CSOSN=202 ou 203 (v.2.0)"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('orig', ['Torig', 'xs:string'], 0, 0, {'name': 'orig', 'type': 'xs:string'}, None),
        MemberSpec_('CSOSN', ['CSOSNType29', 'xs:string'], 0, 0, {'name': 'CSOSN', 'type': 'xs:string'}, None),
        MemberSpec_('modBCST', ['modBCSTType30', 'xs:string'], 0, 0, {'name': 'modBCST', 'type': 'xs:string'}, None),
        MemberSpec_('pMVAST', ['TDec_0302Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pMVAST', 'type': 'xs:string'}, None),
        MemberSpec_('pRedBCST', ['TDec_0302Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pRedBCST', 'type': 'xs:string'}, None),
        MemberSpec_('vBCST', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vBCST', 'type': 'xs:string'}, None),
        MemberSpec_('pICMSST', ['TDec_0302', 'xs:string'], 0, 0, {'name': 'pICMSST', 'type': 'xs:string'}, None),
        MemberSpec_('vICMSST', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vICMSST', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, orig=None, CSOSN=None, modBCST=None, pMVAST=None, pRedBCST=None, vBCST=None, pICMSST=None, vICMSST=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.orig = orig
        self.validate_Torig(self.orig)
        self.orig_nsprefix_ = None
        self.CSOSN = CSOSN
        self.validate_CSOSNType29(self.CSOSN)
        self.CSOSN_nsprefix_ = None
        self.modBCST = modBCST
        self.validate_modBCSTType30(self.modBCST)
        self.modBCST_nsprefix_ = None
        self.pMVAST = pMVAST
        self.validate_TDec_0302Opc(self.pMVAST)
        self.pMVAST_nsprefix_ = None
        self.pRedBCST = pRedBCST
        self.validate_TDec_0302Opc(self.pRedBCST)
        self.pRedBCST_nsprefix_ = None
        self.vBCST = vBCST
        self.validate_TDec_1302(self.vBCST)
        self.vBCST_nsprefix_ = None
        self.pICMSST = pICMSST
        self.validate_TDec_0302(self.pICMSST)
        self.pICMSST_nsprefix_ = None
        self.vICMSST = vICMSST
        self.validate_TDec_1302(self.vICMSST)
        self.vICMSST_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ICMSSN202Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ICMSSN202Type.subclass:
            return ICMSSN202Type.subclass(*args_, **kwargs_)
        else:
            return ICMSSN202Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Torig(self, value):
        result = True
        # Validate type Torig, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5', '6', '7', '8']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on Torig' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CSOSNType29(self, value):
        result = True
        # Validate type CSOSNType29, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['202', '203']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on CSOSNType29' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_modBCSTType30(self, value):
        result = True
        # Validate type modBCSTType30, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on modBCSTType30' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TDec_0302Opc(self, value):
        result = True
        # Validate type TDec_0302Opc, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0302Opc_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0302Opc_patterns_, ))
                result = False
        return result
    validate_TDec_0302Opc_patterns_ = [['^(0\\.[0-9]{1}[1-9]{1}|0\\.[1-9]{1}[0-9]{1}|[1-9]{1}[0-9]{0,2}(\\.[0-9]{2})?)$']]
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def validate_TDec_0302(self, value):
        result = True
        # Validate type TDec_0302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0302_patterns_, ))
                result = False
        return result
    validate_TDec_0302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,2}(\\.[0-9]{2})?)$']]
    def hasContent_(self):
        if (
            self.orig is not None or
            self.CSOSN is not None or
            self.modBCST is not None or
            self.pMVAST is not None or
            self.pRedBCST is not None or
            self.vBCST is not None or
            self.pICMSST is not None or
            self.vICMSST is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMSSN202Type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ICMSSN202Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ICMSSN202Type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ICMSSN202Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ICMSSN202Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ICMSSN202Type'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMSSN202Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.orig is not None:
            namespaceprefix_ = self.orig_nsprefix_ + ':' if (UseCapturedNS_ and self.orig_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorig>%s</%sorig>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.orig), input_name='orig')), namespaceprefix_ , eol_))
        if self.CSOSN is not None:
            namespaceprefix_ = self.CSOSN_nsprefix_ + ':' if (UseCapturedNS_ and self.CSOSN_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCSOSN>%s</%sCSOSN>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CSOSN), input_name='CSOSN')), namespaceprefix_ , eol_))
        if self.modBCST is not None:
            namespaceprefix_ = self.modBCST_nsprefix_ + ':' if (UseCapturedNS_ and self.modBCST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smodBCST>%s</%smodBCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.modBCST), input_name='modBCST')), namespaceprefix_ , eol_))
        if self.pMVAST is not None:
            namespaceprefix_ = self.pMVAST_nsprefix_ + ':' if (UseCapturedNS_ and self.pMVAST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spMVAST>%s</%spMVAST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pMVAST), input_name='pMVAST')), namespaceprefix_ , eol_))
        if self.pRedBCST is not None:
            namespaceprefix_ = self.pRedBCST_nsprefix_ + ':' if (UseCapturedNS_ and self.pRedBCST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spRedBCST>%s</%spRedBCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pRedBCST), input_name='pRedBCST')), namespaceprefix_ , eol_))
        if self.vBCST is not None:
            namespaceprefix_ = self.vBCST_nsprefix_ + ':' if (UseCapturedNS_ and self.vBCST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svBCST>%s</%svBCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vBCST), input_name='vBCST')), namespaceprefix_ , eol_))
        if self.pICMSST is not None:
            namespaceprefix_ = self.pICMSST_nsprefix_ + ':' if (UseCapturedNS_ and self.pICMSST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spICMSST>%s</%spICMSST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pICMSST), input_name='pICMSST')), namespaceprefix_ , eol_))
        if self.vICMSST is not None:
            namespaceprefix_ = self.vICMSST_nsprefix_ + ':' if (UseCapturedNS_ and self.vICMSST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svICMSST>%s</%svICMSST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vICMSST), input_name='vICMSST')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'orig':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'orig')
            value_ = self.gds_validate_string(value_, node, 'orig')
            self.orig = value_
            self.orig_nsprefix_ = child_.prefix
            # validate type Torig
            self.validate_Torig(self.orig)
        elif nodeName_ == 'CSOSN':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CSOSN')
            value_ = self.gds_validate_string(value_, node, 'CSOSN')
            self.CSOSN = value_
            self.CSOSN_nsprefix_ = child_.prefix
            # validate type CSOSNType29
            self.validate_CSOSNType29(self.CSOSN)
        elif nodeName_ == 'modBCST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'modBCST')
            value_ = self.gds_validate_string(value_, node, 'modBCST')
            self.modBCST = value_
            self.modBCST_nsprefix_ = child_.prefix
            # validate type modBCSTType30
            self.validate_modBCSTType30(self.modBCST)
        elif nodeName_ == 'pMVAST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pMVAST')
            value_ = self.gds_validate_string(value_, node, 'pMVAST')
            self.pMVAST = value_
            self.pMVAST_nsprefix_ = child_.prefix
            # validate type TDec_0302Opc
            self.validate_TDec_0302Opc(self.pMVAST)
        elif nodeName_ == 'pRedBCST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pRedBCST')
            value_ = self.gds_validate_string(value_, node, 'pRedBCST')
            self.pRedBCST = value_
            self.pRedBCST_nsprefix_ = child_.prefix
            # validate type TDec_0302Opc
            self.validate_TDec_0302Opc(self.pRedBCST)
        elif nodeName_ == 'vBCST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vBCST')
            value_ = self.gds_validate_string(value_, node, 'vBCST')
            self.vBCST = value_
            self.vBCST_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vBCST)
        elif nodeName_ == 'pICMSST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pICMSST')
            value_ = self.gds_validate_string(value_, node, 'pICMSST')
            self.pICMSST = value_
            self.pICMSST_nsprefix_ = child_.prefix
            # validate type TDec_0302
            self.validate_TDec_0302(self.pICMSST)
        elif nodeName_ == 'vICMSST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vICMSST')
            value_ = self.gds_validate_string(value_, node, 'vICMSST')
            self.vICMSST = value_
            self.vICMSST_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vICMSST)
# end class ICMSSN202Type


class ICMSSN500Type(GeneratedsSuper):
    """Tributação do ICMS pelo SIMPLES NACIONAL,CRT=1 – Simples Nacional e
    CSOSN=500 (v.2.0)NT2011/004"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('orig', ['Torig', 'xs:string'], 0, 0, {'name': 'orig', 'type': 'xs:string'}, None),
        MemberSpec_('CSOSN', ['CSOSNType31', 'xs:string'], 0, 0, {'name': 'CSOSN', 'type': 'xs:string'}, None),
        MemberSpec_('vBCSTRet', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vBCSTRet', 'type': 'xs:string'}, None),
        MemberSpec_('vICMSSTRet', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vICMSSTRet', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, orig=None, CSOSN=None, vBCSTRet=None, vICMSSTRet=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.orig = orig
        self.validate_Torig(self.orig)
        self.orig_nsprefix_ = None
        self.CSOSN = CSOSN
        self.validate_CSOSNType31(self.CSOSN)
        self.CSOSN_nsprefix_ = None
        self.vBCSTRet = vBCSTRet
        self.validate_TDec_1302(self.vBCSTRet)
        self.vBCSTRet_nsprefix_ = None
        self.vICMSSTRet = vICMSSTRet
        self.validate_TDec_1302(self.vICMSSTRet)
        self.vICMSSTRet_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ICMSSN500Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ICMSSN500Type.subclass:
            return ICMSSN500Type.subclass(*args_, **kwargs_)
        else:
            return ICMSSN500Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Torig(self, value):
        result = True
        # Validate type Torig, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5', '6', '7', '8']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on Torig' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CSOSNType31(self, value):
        result = True
        # Validate type CSOSNType31, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['500']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on CSOSNType31' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def hasContent_(self):
        if (
            self.orig is not None or
            self.CSOSN is not None or
            self.vBCSTRet is not None or
            self.vICMSSTRet is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMSSN500Type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ICMSSN500Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ICMSSN500Type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ICMSSN500Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ICMSSN500Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ICMSSN500Type'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMSSN500Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.orig is not None:
            namespaceprefix_ = self.orig_nsprefix_ + ':' if (UseCapturedNS_ and self.orig_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorig>%s</%sorig>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.orig), input_name='orig')), namespaceprefix_ , eol_))
        if self.CSOSN is not None:
            namespaceprefix_ = self.CSOSN_nsprefix_ + ':' if (UseCapturedNS_ and self.CSOSN_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCSOSN>%s</%sCSOSN>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CSOSN), input_name='CSOSN')), namespaceprefix_ , eol_))
        if self.vBCSTRet is not None:
            namespaceprefix_ = self.vBCSTRet_nsprefix_ + ':' if (UseCapturedNS_ and self.vBCSTRet_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svBCSTRet>%s</%svBCSTRet>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vBCSTRet), input_name='vBCSTRet')), namespaceprefix_ , eol_))
        if self.vICMSSTRet is not None:
            namespaceprefix_ = self.vICMSSTRet_nsprefix_ + ':' if (UseCapturedNS_ and self.vICMSSTRet_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svICMSSTRet>%s</%svICMSSTRet>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vICMSSTRet), input_name='vICMSSTRet')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'orig':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'orig')
            value_ = self.gds_validate_string(value_, node, 'orig')
            self.orig = value_
            self.orig_nsprefix_ = child_.prefix
            # validate type Torig
            self.validate_Torig(self.orig)
        elif nodeName_ == 'CSOSN':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CSOSN')
            value_ = self.gds_validate_string(value_, node, 'CSOSN')
            self.CSOSN = value_
            self.CSOSN_nsprefix_ = child_.prefix
            # validate type CSOSNType31
            self.validate_CSOSNType31(self.CSOSN)
        elif nodeName_ == 'vBCSTRet':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vBCSTRet')
            value_ = self.gds_validate_string(value_, node, 'vBCSTRet')
            self.vBCSTRet = value_
            self.vBCSTRet_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vBCSTRet)
        elif nodeName_ == 'vICMSSTRet':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vICMSSTRet')
            value_ = self.gds_validate_string(value_, node, 'vICMSSTRet')
            self.vICMSSTRet = value_
            self.vICMSSTRet_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vICMSSTRet)
# end class ICMSSN500Type


class ICMSSN900Type(GeneratedsSuper):
    """Tributação do ICMS pelo SIMPLES NACIONAL, CRT=1 – Simples Nacional e
    CSOSN=900 (v2.0)"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('orig', ['Torig', 'xs:string'], 0, 0, {'name': 'orig', 'type': 'xs:string'}, None),
        MemberSpec_('CSOSN', ['CSOSNType32', 'xs:string'], 0, 0, {'name': 'CSOSN', 'type': 'xs:string'}, None),
        MemberSpec_('modBC', ['modBCType33', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'modBC', 'type': 'xs:string'}, None),
        MemberSpec_('vBC', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vBC', 'type': 'xs:string'}, None),
        MemberSpec_('pRedBC', ['TDec_0302Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pRedBC', 'type': 'xs:string'}, None),
        MemberSpec_('pICMS', ['TDec_0302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pICMS', 'type': 'xs:string'}, None),
        MemberSpec_('vICMS', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vICMS', 'type': 'xs:string'}, None),
        MemberSpec_('modBCST', ['modBCSTType34', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'modBCST', 'type': 'xs:string'}, None),
        MemberSpec_('pMVAST', ['TDec_0302Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pMVAST', 'type': 'xs:string'}, None),
        MemberSpec_('pRedBCST', ['TDec_0302Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pRedBCST', 'type': 'xs:string'}, None),
        MemberSpec_('vBCST', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vBCST', 'type': 'xs:string'}, None),
        MemberSpec_('pICMSST', ['TDec_0302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pICMSST', 'type': 'xs:string'}, None),
        MemberSpec_('vICMSST', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vICMSST', 'type': 'xs:string'}, None),
        MemberSpec_('pCredSN', ['TDec_0302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pCredSN', 'type': 'xs:string'}, None),
        MemberSpec_('vCredICMSSN', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vCredICMSSN', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, orig=None, CSOSN=None, modBC=None, vBC=None, pRedBC=None, pICMS=None, vICMS=None, modBCST=None, pMVAST=None, pRedBCST=None, vBCST=None, pICMSST=None, vICMSST=None, pCredSN=None, vCredICMSSN=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.orig = orig
        self.validate_Torig(self.orig)
        self.orig_nsprefix_ = None
        self.CSOSN = CSOSN
        self.validate_CSOSNType32(self.CSOSN)
        self.CSOSN_nsprefix_ = None
        self.modBC = modBC
        self.validate_modBCType33(self.modBC)
        self.modBC_nsprefix_ = None
        self.vBC = vBC
        self.validate_TDec_1302(self.vBC)
        self.vBC_nsprefix_ = None
        self.pRedBC = pRedBC
        self.validate_TDec_0302Opc(self.pRedBC)
        self.pRedBC_nsprefix_ = None
        self.pICMS = pICMS
        self.validate_TDec_0302(self.pICMS)
        self.pICMS_nsprefix_ = None
        self.vICMS = vICMS
        self.validate_TDec_1302(self.vICMS)
        self.vICMS_nsprefix_ = None
        self.modBCST = modBCST
        self.validate_modBCSTType34(self.modBCST)
        self.modBCST_nsprefix_ = None
        self.pMVAST = pMVAST
        self.validate_TDec_0302Opc(self.pMVAST)
        self.pMVAST_nsprefix_ = None
        self.pRedBCST = pRedBCST
        self.validate_TDec_0302Opc(self.pRedBCST)
        self.pRedBCST_nsprefix_ = None
        self.vBCST = vBCST
        self.validate_TDec_1302(self.vBCST)
        self.vBCST_nsprefix_ = None
        self.pICMSST = pICMSST
        self.validate_TDec_0302(self.pICMSST)
        self.pICMSST_nsprefix_ = None
        self.vICMSST = vICMSST
        self.validate_TDec_1302(self.vICMSST)
        self.vICMSST_nsprefix_ = None
        self.pCredSN = pCredSN
        self.validate_TDec_0302(self.pCredSN)
        self.pCredSN_nsprefix_ = None
        self.vCredICMSSN = vCredICMSSN
        self.validate_TDec_1302(self.vCredICMSSN)
        self.vCredICMSSN_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ICMSSN900Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ICMSSN900Type.subclass:
            return ICMSSN900Type.subclass(*args_, **kwargs_)
        else:
            return ICMSSN900Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Torig(self, value):
        result = True
        # Validate type Torig, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5', '6', '7', '8']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on Torig' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CSOSNType32(self, value):
        result = True
        # Validate type CSOSNType32, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['900']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on CSOSNType32' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_modBCType33(self, value):
        result = True
        # Validate type modBCType33, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on modBCType33' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def validate_TDec_0302Opc(self, value):
        result = True
        # Validate type TDec_0302Opc, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0302Opc_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0302Opc_patterns_, ))
                result = False
        return result
    validate_TDec_0302Opc_patterns_ = [['^(0\\.[0-9]{1}[1-9]{1}|0\\.[1-9]{1}[0-9]{1}|[1-9]{1}[0-9]{0,2}(\\.[0-9]{2})?)$']]
    def validate_TDec_0302(self, value):
        result = True
        # Validate type TDec_0302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0302_patterns_, ))
                result = False
        return result
    validate_TDec_0302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,2}(\\.[0-9]{2})?)$']]
    def validate_modBCSTType34(self, value):
        result = True
        # Validate type modBCSTType34, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on modBCSTType34' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def hasContent_(self):
        if (
            self.orig is not None or
            self.CSOSN is not None or
            self.modBC is not None or
            self.vBC is not None or
            self.pRedBC is not None or
            self.pICMS is not None or
            self.vICMS is not None or
            self.modBCST is not None or
            self.pMVAST is not None or
            self.pRedBCST is not None or
            self.vBCST is not None or
            self.pICMSST is not None or
            self.vICMSST is not None or
            self.pCredSN is not None or
            self.vCredICMSSN is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMSSN900Type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ICMSSN900Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ICMSSN900Type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ICMSSN900Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ICMSSN900Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ICMSSN900Type'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMSSN900Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.orig is not None:
            namespaceprefix_ = self.orig_nsprefix_ + ':' if (UseCapturedNS_ and self.orig_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorig>%s</%sorig>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.orig), input_name='orig')), namespaceprefix_ , eol_))
        if self.CSOSN is not None:
            namespaceprefix_ = self.CSOSN_nsprefix_ + ':' if (UseCapturedNS_ and self.CSOSN_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCSOSN>%s</%sCSOSN>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CSOSN), input_name='CSOSN')), namespaceprefix_ , eol_))
        if self.modBC is not None:
            namespaceprefix_ = self.modBC_nsprefix_ + ':' if (UseCapturedNS_ and self.modBC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smodBC>%s</%smodBC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.modBC), input_name='modBC')), namespaceprefix_ , eol_))
        if self.vBC is not None:
            namespaceprefix_ = self.vBC_nsprefix_ + ':' if (UseCapturedNS_ and self.vBC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svBC>%s</%svBC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vBC), input_name='vBC')), namespaceprefix_ , eol_))
        if self.pRedBC is not None:
            namespaceprefix_ = self.pRedBC_nsprefix_ + ':' if (UseCapturedNS_ and self.pRedBC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spRedBC>%s</%spRedBC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pRedBC), input_name='pRedBC')), namespaceprefix_ , eol_))
        if self.pICMS is not None:
            namespaceprefix_ = self.pICMS_nsprefix_ + ':' if (UseCapturedNS_ and self.pICMS_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spICMS>%s</%spICMS>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pICMS), input_name='pICMS')), namespaceprefix_ , eol_))
        if self.vICMS is not None:
            namespaceprefix_ = self.vICMS_nsprefix_ + ':' if (UseCapturedNS_ and self.vICMS_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svICMS>%s</%svICMS>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vICMS), input_name='vICMS')), namespaceprefix_ , eol_))
        if self.modBCST is not None:
            namespaceprefix_ = self.modBCST_nsprefix_ + ':' if (UseCapturedNS_ and self.modBCST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smodBCST>%s</%smodBCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(se