#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated  by generateDS.py version 2.38.6.
# Python 3.8.5 (default, Jul 28 2020, 12:59:40)  [GCC 9.3.0]
#
# Command line options:
#   ('--no-namespace-defs', '')
#   ('--no-dates', '')
#   ('--member-specs', 'list')
#   ('--use-getter-setter', 'none')
#   ('-f', '')
#   ('-o', '/home/rvalyi/DEV/nfelib2/nfelib/v4_00/retEnviNFe.py')
#
# Command line arguments:
#   /tmp/generated/schemas/nfe/v4_00/retEnviNFe_v4.00.xsd
#
# Command line:
#   /usr/local/bin/generateDS.py --no-namespace-defs --no-dates --member-specs="list" --use-getter-setter="none" -f -o "/home/rvalyi/DEV/nfelib2/nfelib/v4_00/retEnviNFe.py" /tmp/generated/schemas/nfe/v4_00/retEnviNFe_v4.00.xsd
#
# Current working directory (os.getcwd()):
#   v4_00
#

import sys
try:
    ModulenotfoundExp_ = ModuleNotFoundError
except NameError:
    ModulenotfoundExp_ = ImportError
from six.moves import zip_longest
import os
import re as re_
import base64
import datetime as datetime_
import decimal as decimal_
try:
    from lxml import etree as etree_
except ModulenotfoundExp_ :
    from xml.etree import ElementTree as etree_


Validate_simpletypes_ = True
SaveElementTreeNode = True
if sys.version_info.major == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    try:
        if isinstance(infile, os.PathLike):
            infile = os.path.join(infile)
    except AttributeError:
        pass
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc

def parsexmlstring_(instring, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    element = etree_.fromstring(instring, parser=parser, **kwargs)
    return element

#
# Namespace prefix definition table (and other attributes, too)
#
# The module generatedsnamespaces, if it is importable, must contain
# a dictionary named GeneratedsNamespaceDefs.  This Python dictionary
# should map element type names (strings) to XML schema namespace prefix
# definitions.  The export method for any class for which there is
# a namespace prefix definition, will export that definition in the
# XML representation of that element.  See the export method of
# any generated element type class for an example of the use of this
# table.
# A sample table is:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceDefs = {
#         "ElementtypeA": "http://www.xxx.com/namespaceA",
#         "ElementtypeB": "http://www.xxx.com/namespaceB",
#     }
#
# Additionally, the generatedsnamespaces module can contain a python
# dictionary named GenerateDSNamespaceTypePrefixes that associates element
# types with the namespace prefixes that are to be added to the
# "xsi:type" attribute value.  See the exportAttributes method of
# any generated element type and the generation of "xsi:type" for an
# example of the use of this table.
# An example table:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceTypePrefixes = {
#         "ElementtypeC": "aaa:",
#         "ElementtypeD": "bbb:",
#     }
#

try:
    from generatedsnamespaces import GenerateDSNamespaceDefs as GenerateDSNamespaceDefs_
except ModulenotfoundExp_ :
    GenerateDSNamespaceDefs_ = {}
try:
    from generatedsnamespaces import GenerateDSNamespaceTypePrefixes as GenerateDSNamespaceTypePrefixes_
except ModulenotfoundExp_ :
    GenerateDSNamespaceTypePrefixes_ = {}

#
# You can replace the following class definition by defining an
# importable module named "generatedscollector" containing a class
# named "GdsCollector".  See the default class definition below for
# clues about the possible content of that class.
#
try:
    from generatedscollector import GdsCollector as GdsCollector_
except ModulenotfoundExp_ :

    class GdsCollector_(object):

        def __init__(self, messages=None):
            if messages is None:
                self.messages = []
            else:
                self.messages = messages

        def add_message(self, msg):
            self.messages.append(msg)

        def get_messages(self):
            return self.messages

        def clear_messages(self):
            self.messages = []

        def print_messages(self):
            for msg in self.messages:
                print("Warning: {}".format(msg))

        def write_messages(self, outstream):
            for msg in self.messages:
                outstream.write("Warning: {}\n".format(msg))


#
# The super-class for enum types
#

try:
    from enum import Enum
except ModulenotfoundExp_ :
    Enum = object

#
# The root super-class for element type classes
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ModulenotfoundExp_ as exp:
    
    class GeneratedsSuper(object):
        __hash__ = object.__hash__
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_parse_string(self, input_data, node=None, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_parse_integer(self, input_data, node=None, input_name=''):
            try:
                ival = int(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires integer value: %s' % exp)
            return ival
        def gds_validate_integer(self, input_data, node=None, input_name=''):
            try:
                value = int(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires integer value')
            return value
        def gds_format_integer_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integer values')
            return values
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_parse_float(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires float or double value: %s' % exp)
            return fval_
        def gds_validate_float(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires float value')
            return value
        def gds_format_float_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of float values')
            return values
        def gds_format_decimal(self, input_data, input_name=''):
            return_value = '%s' % input_data
            if '.' in return_value:
                return_value = return_value.rstrip('0')
                if return_value.endswith('.'):
                    return_value = return_value.rstrip('.')
            return return_value
        def gds_parse_decimal(self, input_data, node=None, input_name=''):
            try:
                decimal_value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return decimal_value
        def gds_validate_decimal(self, input_data, node=None, input_name=''):
            try:
                value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return value
        def gds_format_decimal_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return ' '.join([self.gds_format_decimal(item) for item in input_data])
        def gds_validate_decimal_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    decimal_.Decimal(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of decimal values')
            return values
        def gds_format_double(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_parse_double(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires double or float value: %s' % exp)
            return fval_
        def gds_validate_double(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires double or float value')
            return value
        def gds_format_double_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(
                        node, 'Requires sequence of double or float values')
            return values
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_parse_boolean(self, input_data, node=None, input_name=''):
            if input_data in ('true', '1'):
                bval = True
            elif input_data in ('false', '0'):
                bval = False
            else:
                raise_parse_error(node, 'Requires boolean value')
            return bval
        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            if input_data not in (True, 1, False, 0, ):
                raise_parse_error(
                    node,
                    'Requires boolean value '
                    '(one of True, 1, False, 0)')
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                value = self.gds_parse_boolean(value, node, input_name)
                if value not in (True, 1, False, 0, ):
                    raise_parse_error(
                        node,
                        'Requires sequence of boolean values '
                        '(one of True, 1, False, 0)')
            return values
        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (
                    time_parts[0], "{}".format(micro_seconds).rjust(6, "0"), )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(
                                hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.
            # The target value must match at least one of the patterns
            # in order for the test to succeed.
            found1 = True
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    mo = re_.search(patterns2, target)
                    if mo is not None and len(mo.group(0)) == len(target):
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_check_cardinality_(
                self, value, input_name,
                min_occurs=0, max_occurs=1, required=None):
            if value is None:
                length = 0
            elif isinstance(value, list):
                length = len(value)
            else:
                length = 1
            if required is not None :
                if required and length < 1:
                    self.gds_collector_.add_message(
                        "Required value {}{} is missing".format(
                            input_name, self.gds_get_node_lineno_()))
            if length < min_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is below "
                    "the minimum allowed, "
                    "expected at least {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        min_occurs, length))
            elif length > max_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is above "
                    "the maximum allowed, "
                    "expected at most {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        max_occurs, length))
        def gds_validate_builtin_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value, input_name=input_name)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_validate_defined_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            # provide default value in case option --disable-xml is used.
            content = ""
            content = etree_.tostring(node, encoding="unicode")
            return content
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.items()))
        @staticmethod
        def gds_encode(instring):
            if sys.version_info.major == 2:
                if ExternalEncoding:
                    encoding = ExternalEncoding
                else:
                    encoding = 'utf-8'
                return instring.encode(encoding)
            else:
                return instring
        @staticmethod
        def convert_unicode(instring):
            if isinstance(instring, str):
                result = quote_xml(instring)
            elif sys.version_info.major == 2 and isinstance(instring, unicode):
                result = quote_xml(instring).encode('utf8')
            else:
                result = GeneratedsSuper.gds_encode(str(instring))
            return result
        def __eq__(self, other):
            def excl_select_objs_(obj):
                return (obj[0] != 'parent_object_' and
                        obj[0] != 'gds_collector_')
            if type(self) != type(other):
                return False
            return all(x == y for x, y in zip_longest(
                filter(excl_select_objs_, self.__dict__.items()),
                filter(excl_select_objs_, other.__dict__.items())))
        def __ne__(self, other):
            return not self.__eq__(other)
        # Django ETL transform hooks.
        def gds_djo_etl_transform(self):
            pass
        def gds_djo_etl_transform_db_obj(self, dbobj):
            pass
        # SQLAlchemy ETL transform hooks.
        def gds_sqa_etl_transform(self):
            return 0, None
        def gds_sqa_etl_transform_db_obj(self, dbobj):
            pass
        def gds_get_node_lineno_(self):
            if (hasattr(self, "gds_elementtree_node_") and
                    self.gds_elementtree_node_ is not None):
                return ' near line {}'.format(
                    self.gds_elementtree_node_.sourceline)
            else:
                return ""
    
    
    def getSubclassFromModule_(module, class_):
        '''Get the subclass of a class from a specific module.'''
        name = class_.__name__ + 'Sub'
        if hasattr(module, name):
            return getattr(module, name)
        else:
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = ''
# Set this to false in order to deactivate during export, the use of
# name space prefixes captured from the input document.
UseCapturedNS_ = True
CapturedNsmap_ = {}
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ''
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s2 = ''
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos:mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start():mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        if prefix == 'xml':
            namespace = 'http://www.w3.org/XML/1998/namespace'
        else:
            namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


def encode_str_2_3(instr):
    return instr


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if node is not None:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace,
               pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(
                outfile, level, namespace, name_=name,
                pretty_print=pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name,
                base64.b64encode(self.value),
                self.name))
    def to_etree(self, element, mapping_=None, nsmap_=None):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(
                element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self, mapping_=None, nsmap_=None):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0,
            optional=0, child_attrs=None, choice=None):
        self.name = name
        self.data_type = data_type
        self.container = container
        self.child_attrs = child_attrs
        self.choice = choice
        self.optional = optional
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container
    def set_child_attrs(self, child_attrs): self.child_attrs = child_attrs
    def get_child_attrs(self): return self.child_attrs
    def set_choice(self, choice): self.choice = choice
    def get_choice(self): return self.choice
    def set_optional(self, optional): self.optional = optional
    def get_optional(self): return self.optional


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class CRTType(str, Enum):
    """Código de Regime Tributário.
    Este campo será obrigatoriamente preenchido com:
    1 – Simples Nacional;
    2 – Simples Nacional – excesso de sublimite de receita bruta;
    3 – Regime Normal."""
    _1='1'
    _2='2'
    _3='3'


class CSOSNType(str, Enum):
    """101- Tributada pelo Simples Nacional com permissão de crédito.
    (v.2.0)"""
    _1_01='101'


class CSOSNType34(str, Enum):
    """102- Tributada pelo Simples Nacional sem permissão de crédito.
    103 – Isenção do ICMS no Simples Nacional para faixa de receita bruta.
    300 – Imune.
    400 – Não tributda pelo Simples Nacional (v.2.0) (v.2.0)"""
    _1_02='102'
    _1_03='103'
    _3_00='300'
    _4_00='400'


class CSOSNType35(str, Enum):
    """201- Tributada pelo Simples Nacional com permissão de crédito e com
    cobrança do ICMS por Substituição Tributária (v.2.0)"""
    _2_01='201'


class CSOSNType37(str, Enum):
    """202- Tributada pelo Simples Nacional sem permissão de crédito e com
    cobrança do ICMS por Substituição Tributária;
    203- Isenção do ICMS nos Simples Nacional para faixa de receita bruta e com
    cobrança do ICMS por Substituição Tributária (v.2.0)"""
    _2_02='202'
    _2_03='203'


class CSOSNType39(str, Enum):
    """500 – ICMS cobrado anterirmente por substituição tributária
    (substituído) ou por antecipação
    (v.2.0)"""
    _5_00='500'


class CSOSNType40(str, Enum):
    """Tributação pelo ICMS 900 - Outros(v2.0)"""
    _9_00='900'


class CSTType(str, Enum):
    """Tributção pelo ICMS
    00 - Tributada integralmente"""
    _0_0='00'


class CSTType10(str, Enum):
    """Tributção pelo ICMS
    20 - Com redução de base de cálculo"""
    _2_0='20'


class CSTType12(str, Enum):
    """Tributção pelo ICMS
    30 - Isenta ou não tributada e com cobrança do ICMS por substituição
    tributária"""
    _3_0='30'


class CSTType15(str, Enum):
    """Tributação pelo ICMS
    40 - Isenta
    41 - Não tributada
    50 - Suspensão
    51 - Diferimento"""
    _4_0='40'
    _4_1='41'
    _5_0='50'


class CSTType17(str, Enum):
    """Tributção pelo ICMS
    20 - Com redução de base de cálculo"""
    _5_1='51'


class CSTType19(str, Enum):
    """Tributação pelo ICMS
    60 - ICMS cobrado anteriormente por substituição tributária"""
    _6_0='60'


class CSTType20(str, Enum):
    """Tributção pelo ICMS
    70 - Com redução de base de cálculo e cobrança do ICMS por substituição
    tributária"""
    _7_0='70'


class CSTType25(str, Enum):
    """Tributção pelo ICMS
    90 - Outras"""
    _9_0='90'


class CSTType30(str, Enum):
    """Tributação pelo ICMS
    10 - Tributada e com cobrança do ICMS por substituição tributária;
    90 – Outros."""
    _1_0='10'
    _9_0='90'


class CSTType33(str, Enum):
    """Tributção pelo ICMS
    41-Não Tributado.
    60-Cobrado anteriormente por substituição tributária."""
    _4_1='41'
    _6_0='60'


class CSTType43(str, Enum):
    """Código de Situação Tributária do PIS.
    01 – Operação Tributável - Base de Cálculo = Valor da Operação Alíquota
    Normal (Cumulativo/Não Cumulativo);
    02 - Operação Tributável - Base de Calculo = Valor da Operação (Alíquota
    Diferenciada);"""
    _0_1='01'
    _0_2='02'


class CSTType44(str, Enum):
    """Código de Situação Tributária do PIS.
    03 - Operação Tributável - Base de Calculo = Quantidade Vendida x Alíquota
    por Unidade de Produto;"""
    _0_3='03'


class CSTType45(str, Enum):
    """Código de Situação Tributária do PIS.
    04 - Operação Tributável - Tributação Monofásica - (Alíquota Zero);
    05 - Operação Tributável (ST);
    06 - Operação Tributável - Alíquota Zero;
    07 - Operação Isenta da contribuição;
    08 - Operação Sem Incidência da contribuição;
    09 - Operação com suspensão da contribuição;"""
    _0_4='04'
    _0_5='05'
    _0_6='06'
    _0_7='07'
    _0_8='08'
    _0_9='09'


class CSTType46(str, Enum):
    """Código de Situação Tributária do PIS.
    99 - Outras Operações."""
    _4_9='49'
    _5_0='50'
    _5_1='51'
    _5_2='52'
    _5_3='53'
    _5_4='54'
    _5_5='55'
    _5_6='56'
    _6_0='60'
    _6_1='61'
    _6_2='62'
    _6_3='63'
    _6_4='64'
    _6_5='65'
    _6_6='66'
    _6_7='67'
    _7_0='70'
    _7_1='71'
    _7_2='72'
    _7_3='73'
    _7_4='74'
    _7_5='75'
    _9_8='98'
    _9_9='99'


class CSTType47(str, Enum):
    """Código de Situação Tributária do COFINS.
    01 – Operação Tributável - Base de Cálculo = Valor da Operação Alíquota
    Normal (Cumulativo/Não Cumulativo);
    02 - Operação Tributável - Base de Calculo = Valor da Operação (Alíquota
    Diferenciada);"""
    _0_1='01'
    _0_2='02'


class CSTType48(str, Enum):
    """Código de Situação Tributária do COFINS.
    03 - Operação Tributável - Base de Calculo = Quantidade Vendida x Alíquota
    por Unidade de Produto;"""
    _0_3='03'


class CSTType49(str, Enum):
    """Código de Situação Tributária do COFINS:
    04 - Operação Tributável - Tributação Monofásica - (Alíquota Zero);
    05 - Operação Tributável (ST);
    06 - Operação Tributável - Alíquota Zero;
    07 - Operação Isenta da contribuição;
    08 - Operação Sem Incidência da contribuição;
    09 - Operação com suspensão da contribuição;"""
    _0_4='04'
    _0_5='05'
    _0_6='06'
    _0_7='07'
    _0_8='08'
    _0_9='09'


class CSTType50(str, Enum):
    """Código de Situação Tributária do COFINS:
    49 - Outras Operações de Saída
    50 - Operação com Direito a Crédito - Vinculada Exclusivamente a Receita
    Tributada no Mercado Interno
    51 - Operação com Direito a Crédito – Vinculada Exclusivamente a Receita
    Não Tributada no Mercado Interno
    52 - Operação com Direito a Crédito - Vinculada Exclusivamente a Receita de
    Exportação
    53 - Operação com Direito a Crédito - Vinculada a Receitas Tributadas e
    Não-Tributadas no Mercado Interno
    54 - Operação com Direito a Crédito - Vinculada a Receitas Tributadas no
    Mercado Interno e de Exportação
    55 - Operação com Direito a Crédito - Vinculada a Receitas Não-Tributadas
    no Mercado Interno e de Exportação
    56 - Operação com Direito a Crédito - Vinculada a Receitas Tributadas e
    Não-Tributadas no Mercado Interno, e de Exportação
    60 - Crédito Presumido - Operação de Aquisição Vinculada Exclusivamente a
    Receita Tributada no Mercado Interno
    61 - Crédito Presumido - Operação de Aquisição Vinculada Exclusivamente a
    Receita Não-Tributada no Mercado Interno
    62 - Crédito Presumido - Operação de Aquisição Vinculada Exclusivamente a
    Receita de Exportação
    63 - Crédito Presumido - Operação de Aquisição Vinculada a Receitas
    Tributadas e Não-Tributadas no Mercado Interno
    64 - Crédito Presumido - Operação de Aquisição Vinculada a Receitas
    Tributadas no Mercado Interno e de Exportação
    65 - Crédito Presumido - Operação de Aquisição Vinculada a Receitas Não-
    Tributadas no Mercado Interno e de Exportação
    66 - Crédito Presumido - Operação de Aquisição Vinculada a Receitas
    Tributadas e Não-Tributadas no Mercado Interno, e de Exportação
    67 - Crédito Presumido - Outras Operações
    70 - Operação de Aquisição sem Direito a Crédito
    71 - Operação de Aquisição com Isenção
    72 - Operação de Aquisição com Suspensão
    73 - Operação de Aquisição a Alíquota Zero
    74 - Operação de Aquisição sem Incidência da Contribuição
    75 - Operação de Aquisição por Substituição Tributária
    98 - Outras Operações de Entrada
    99 - Outras Operações."""
    _4_9='49'
    _5_0='50'
    _5_1='51'
    _5_2='52'
    _5_3='53'
    _5_4='54'
    _5_5='55'
    _5_6='56'
    _6_0='60'
    _6_1='61'
    _6_2='62'
    _6_3='63'
    _6_4='64'
    _6_5='65'
    _6_6='66'
    _6_7='67'
    _7_0='70'
    _7_1='71'
    _7_2='72'
    _7_3='73'
    _7_4='74'
    _7_5='75'
    _9_8='98'
    _9_9='99'


class CSTType8(str, Enum):
    """10 - Tributada e com cobrança do ICMS por substituição tributária"""
    _1_0='10'


class CSTType83(str, Enum):
    """Código da Situação Tributária do IPI:
    00-Entrada com recuperação de crédito
    49 - Outras entradas
    50-Saída tributada
    99-Outras saídas"""
    _0_0='00'
    _4_9='49'
    _5_0='50'
    _9_9='99'


class CSTType84(str, Enum):
    """Código da Situação Tributária do IPI:
    01-Entrada tributada com alíquota zero
    02-Entrada isenta
    03-Entrada não-tributada
    04-Entrada imune
    05-Entrada com suspensão
    51-Saída tributada com alíquota zero
    52-Saída isenta
    53-Saída não-tributada
    54-Saída imune
    55-Saída com suspensão"""
    _0_1='01'
    _0_2='02'
    _0_3='03'
    _0_4='04'
    _0_5='05'
    _5_1='51'
    _5_2='52'
    _5_3='53'
    _5_4='54'
    _5_5='55'


class TAmb(str, Enum):
    """Tipo Ambiente"""
    _1='1'
    _2='2'


class TCListServ(str, Enum):
    """Tipo Código da Lista de Serviços LC 116/2003"""
    _0_1_01='01.01'
    _0_1_02='01.02'
    _0_1_03='01.03'
    _0_1_04='01.04'
    _0_1_05='01.05'
    _0_1_06='01.06'
    _0_1_07='01.07'
    _0_1_08='01.08'
    _0_1_09='01.09'
    _0_2_01='02.01'
    _0_3_02='03.02'
    _0_3_03='03.03'
    _0_3_04='03.04'
    _0_3_05='03.05'
    _0_4_01='04.01'
    _0_4_02='04.02'
    _0_4_03='04.03'
    _0_4_04='04.04'
    _0_4_05='04.05'
    _0_4_06='04.06'
    _0_4_07='04.07'
    _0_4_08='04.08'
    _0_4_09='04.09'
    _0_4_10='04.10'
    _0_4_11='04.11'
    _0_4_12='04.12'
    _0_4_13='04.13'
    _0_4_14='04.14'
    _0_4_15='04.15'
    _0_4_16='04.16'
    _0_4_17='04.17'
    _0_4_18='04.18'
    _0_4_19='04.19'
    _0_4_20='04.20'
    _0_4_21='04.21'
    _0_4_22='04.22'
    _0_4_23='04.23'
    _0_5_01='05.01'
    _0_5_02='05.02'
    _0_5_03='05.03'
    _0_5_04='05.04'
    _0_5_05='05.05'
    _0_5_06='05.06'
    _0_5_07='05.07'
    _0_5_08='05.08'
    _0_5_09='05.09'
    _0_6_01='06.01'
    _0_6_02='06.02'
    _0_6_03='06.03'
    _0_6_04='06.04'
    _0_6_05='06.05'
    _0_6_06='06.06'
    _0_7_01='07.01'
    _0_7_02='07.02'
    _0_7_03='07.03'
    _0_7_04='07.04'
    _0_7_05='07.05'
    _0_7_06='07.06'
    _0_7_07='07.07'
    _0_7_08='07.08'
    _0_7_09='07.09'
    _0_7_10='07.10'
    _0_7_11='07.11'
    _0_7_12='07.12'
    _0_7_13='07.13'
    _0_7_16='07.16'
    _0_7_17='07.17'
    _0_7_18='07.18'
    _0_7_19='07.19'
    _0_7_20='07.20'
    _0_7_21='07.21'
    _0_7_22='07.22'
    _0_8_01='08.01'
    _0_8_02='08.02'
    _0_9_01='09.01'
    _0_9_02='09.02'
    _0_9_03='09.03'
    _1_0_01='10.01'
    _1_0_02='10.02'
    _1_0_03='10.03'
    _1_0_04='10.04'
    _1_0_05='10.05'
    _1_0_06='10.06'
    _1_0_07='10.07'
    _1_0_08='10.08'
    _1_0_09='10.09'
    _1_0_10='10.10'
    _1_1_01='11.01'
    _1_1_02='11.02'
    _1_1_03='11.03'
    _1_1_04='11.04'
    _1_2_01='12.01'
    _1_2_02='12.02'
    _1_2_03='12.03'
    _1_2_04='12.04'
    _1_2_05='12.05'
    _1_2_06='12.06'
    _1_2_07='12.07'
    _1_2_08='12.08'
    _1_2_09='12.09'
    _1_2_10='12.10'
    _1_2_11='12.11'
    _1_2_12='12.12'
    _1_2_13='12.13'
    _1_2_14='12.14'
    _1_2_15='12.15'
    _1_2_16='12.16'
    _1_2_17='12.17'
    _1_3_02='13.02'
    _1_3_03='13.03'
    _1_3_04='13.04'
    _1_3_05='13.05'
    _1_4_01='14.01'
    _1_4_02='14.02'
    _1_4_03='14.03'
    _1_4_04='14.04'
    _1_4_05='14.05'
    _1_4_06='14.06'
    _1_4_07='14.07'
    _1_4_08='14.08'
    _1_4_09='14.09'
    _1_4_10='14.10'
    _1_4_11='14.11'
    _1_4_12='14.12'
    _1_4_13='14.13'
    _1_4_14='14.14'
    _1_5_01='15.01'
    _1_5_02='15.02'
    _1_5_03='15.03'
    _1_5_04='15.04'
    _1_5_05='15.05'
    _1_5_06='15.06'
    _1_5_07='15.07'
    _1_5_08='15.08'
    _1_5_09='15.09'
    _1_5_10='15.10'
    _1_5_11='15.11'
    _1_5_12='15.12'
    _1_5_13='15.13'
    _1_5_14='15.14'
    _1_5_15='15.15'
    _1_5_16='15.16'
    _1_5_17='15.17'
    _1_5_18='15.18'
    _1_6_01='16.01'
    _1_6_02='16.02'
    _1_7_01='17.01'
    _1_7_02='17.02'
    _1_7_03='17.03'
    _1_7_04='17.04'
    _1_7_05='17.05'
    _1_7_06='17.06'
    _1_7_08='17.08'
    _1_7_09='17.09'
    _1_7_10='17.10'
    _1_7_11='17.11'
    _1_7_12='17.12'
    _1_7_13='17.13'
    _1_7_14='17.14'
    _1_7_15='17.15'
    _1_7_16='17.16'
    _1_7_17='17.17'
    _1_7_18='17.18'
    _1_7_19='17.19'
    _1_7_20='17.20'
    _1_7_21='17.21'
    _1_7_22='17.22'
    _1_7_23='17.23'
    _1_7_24='17.24'
    _1_7_25='17.25'
    _1_8_01='18.01'
    _1_9_01='19.01'
    _2_0_01='20.01'
    _2_0_02='20.02'
    _2_0_03='20.03'
    _2_1_01='21.01'
    _2_2_01='22.01'
    _2_3_01='23.01'
    _2_4_01='24.01'
    _2_5_01='25.01'
    _2_5_02='25.02'
    _2_5_03='25.03'
    _2_5_04='25.04'
    _2_5_05='25.05'
    _2_6_01='26.01'
    _2_7_01='27.01'
    _2_8_01='28.01'
    _2_9_01='29.01'
    _3_0_01='30.01'
    _3_1_01='31.01'
    _3_2_01='32.01'
    _3_3_01='33.01'
    _3_4_01='34.01'
    _3_5_01='35.01'
    _3_6_01='36.01'
    _3_7_01='37.01'
    _3_8_01='38.01'
    _3_9_01='39.01'
    _4_0_01='40.01'


class TCOrgaoIBGE(str, Enum):
    """Tipo Código de orgão (UF da tabela do IBGE + 90 RFB)"""
    _1_1='11'
    _1_2='12'
    _1_3='13'
    _1_4='14'
    _1_5='15'
    _1_6='16'
    _1_7='17'
    _2_1='21'
    _2_2='22'
    _2_3='23'
    _2_4='24'
    _2_5='25'
    _2_6='26'
    _2_7='27'
    _2_8='28'
    _2_9='29'
    _3_1='31'
    _3_2='32'
    _3_3='33'
    _3_5='35'
    _4_1='41'
    _4_2='42'
    _4_3='43'
    _5_0='50'
    _5_1='51'
    _5_2='52'
    _5_3='53'
    _9_0='90'
    _9_1='91'
    _9_2='92'


class TCodUfIBGE(str, Enum):
    """Tipo Código da UF da tabela do IBGE"""
    _1_1='11'
    _1_2='12'
    _1_3='13'
    _1_4='14'
    _1_5='15'
    _1_6='16'
    _1_7='17'
    _2_1='21'
    _2_2='22'
    _2_3='23'
    _2_4='24'
    _2_5='25'
    _2_6='26'
    _2_7='27'
    _2_8='28'
    _2_9='29'
    _3_1='31'
    _3_2='32'
    _3_3='33'
    _3_5='35'
    _4_1='41'
    _4_2='42'
    _4_3='43'
    _5_0='50'
    _5_1='51'
    _5_2='52'
    _5_3='53'


class TFinNFe(str, Enum):
    """Tipo Finalidade da NF-e (1=Normal; 2=Complementar; 3=Ajuste;
    4=Devolução/Retorno)"""
    _1='1'
    _2='2'
    _3='3'
    _4='4'


class TMod(str, Enum):
    """Tipo Modelo Documento Fiscal"""
    _5_5='55'
    _6_5='65'


class TProcEmi(str, Enum):
    """Tipo processo de emissão da NF-e"""
    _0='0'
    _1='1'
    _2='2'
    _3='3'


class TTransformURI(str, Enum):
    HTTPWWWW_3ORG_2000_09XMLDSIGENVELOPEDSIGNATURE='http://www.w3.org/2000/09/xmldsig#enveloped-signature'
    HTTPWWWW_3ORGTR_2001RECXMLC_14_N_20010315='http://www.w3.org/TR/2001/REC-xml-c14n-20010315'


class TUf(str, Enum):
    """Tipo Sigla da UF"""
    AC='AC'
    AL='AL'
    AM='AM'
    AP='AP'
    BA='BA'
    CE='CE'
    DF='DF'
    ES='ES'
    GO='GO'
    MA='MA'
    MG='MG'
    MS='MS'
    MT='MT'
    PA='PA'
    PB='PB'
    PE='PE'
    PI='PI'
    PR='PR'
    RJ='RJ'
    RN='RN'
    RO='RO'
    RR='RR'
    RS='RS'
    SC='SC'
    SE='SE'
    SP='SP'
    TO='TO'
    EX='EX'


class TUfEmi(str, Enum):
    """Tipo Sigla da UF de emissor // acrescentado em 24/10/08"""
    AC='AC'
    AL='AL'
    AM='AM'
    AP='AP'
    BA='BA'
    CE='CE'
    DF='DF'
    ES='ES'
    GO='GO'
    MA='MA'
    MG='MG'
    MS='MS'
    MT='MT'
    PA='PA'
    PB='PB'
    PE='PE'
    PI='PI'
    PR='PR'
    RJ='RJ'
    RN='RN'
    RO='RO'
    RR='RR'
    RS='RS'
    SC='SC'
    SE='SE'
    SP='SP'
    TO='TO'


class Torig(str, Enum):
    """Tipo Origem da mercadoria CST ICMS origem da mercadoria: 0-Nacional
    exceto as indicadas nos códigos 3, 4, 5 e 8;
    1-Estrangeira - Importação direta; 2-Estrangeira - Adquirida no mercado
    interno; 3-Nacional, conteudo superior 40% e inferior ou igual a 70%;
    4-Nacional, processos produtivos básicos; 5-Nacional, conteudo inferior
    40%; 6-Estrangeira - Importação direta, com similar nacional, lista
    CAMEX; 7-Estrangeira - mercado interno, sem simular,lista
    CAMEX;8-Nacional, Conteúdo de Importação superior a 70%."""
    _0='0'
    _1='1'
    _2='2'
    _3='3'
    _4='4'
    _5='5'
    _6='6'
    _7='7'
    _8='8'


class VINType(str, Enum):
    """Informa-se o veículo tem VIN (chassi) remarcado.
    R-Remarcado
    N-NormalVIN"""
    R='R'
    N='N'


class cPaisType67(str, Enum):
    """Código do país"""
    _1_058='1058'


class cRegTribType(str, Enum):
    """Código do regime especial de tributação"""
    _1='1'
    _2='2'
    _3='3'
    _4='4'
    _5='5'
    _6='6'


class condVeicType(str, Enum):
    """Condição do veículo (1 - acabado; 2 - inacabado; 3 - semi-acabado)"""
    _1='1'
    _2='2'
    _3='3'


class idDestType(str, Enum):
    """Identificador de Local de destino da operação
    (1-Interna;2-Interestadual;3-Exterior)"""
    _1='1'
    _2='2'
    _3='3'


class indEscalaType(str, Enum):
    S='S'
    N='N'


class indFinalType(str, Enum):
    """Indica operação com consumidor final (0-Não;1-Consumidor Final)"""
    _0='0'
    _1='1'


class indIEDestType(str, Enum):
    """Indicador da IE do destinatário:
    1 – Contribuinte ICMSpagamento à vista;
    2 – Contribuinte isento de inscrição;
    9 – Não Contribuinte"""
    _1='1'
    _2='2'
    _9='9'


class indISSType(str, Enum):
    """Exibilidade do ISS:1-Exigível;2-Não
    incidente;3-Isenção;4-Exportação;5-Imunidade;6-Exig.Susp.
    Judicial;7-Exig.Susp. ADM"""
    _1='1'
    _2='2'
    _3='3'
    _4='4'
    _5='5'
    _6='6'
    _7='7'


class indIncentivoType(str, Enum):
    """Indicador de Incentivo Fiscal. 1=Sim; 2=Não"""
    _1='1'
    _2='2'


class indIntermedType(str, Enum):
    """Indicador de intermediador/marketplace
    0=Operação sem intermediador (em site ou plataforma própria)
    1=Operação em site ou plataforma de terceiros
    (intermediadores/marketplace)"""
    _0='0'
    _1='1'


class indPagType(str, Enum):
    """Indicador da Forma de Pagamento:0-Pagamento à Vista;1-Pagamento à
    Prazo;"""
    _0='0'
    _1='1'


class indPresType(str, Enum):
    """Indicador de presença do comprador no estabelecimento comercial no
    momento da oepração
    (0-Não se aplica (ex.: Nota Fiscal complementar ou de ajuste;1-Operação
    presencial;2-Não presencial, internet;3-Não presencial,
    teleatendimento;4-NFC-e entrega em domicílio;5-Operação presencial,
    fora do estabelecimento;9-Não presencial, outros)"""
    _0='0'
    _1='1'
    _2='2'
    _3='3'
    _4='4'
    _5='5'
    _9='9'


class indProcType(str, Enum):
    """Origem do processo, informar com:
    0 - SEFAZ;
    1 - Justiça Federal;
    2 - Justiça Estadual;
    3 - Secex/RFB;
    9 - Outros"""
    _0='0'
    _1='1'
    _2='2'
    _3='3'
    _9='9'


class indSincType(str, Enum):
    """Indicador de processamento síncrono. 0=NÃO; 1=SIM=Síncrono"""
    _0='0'
    _1='1'


class indSomaCOFINSSTType(str, Enum):
    """Indica se o valor da COFINS ST compõe o valor total da NFe"""
    _0='0'
    _1='1'


class indSomaPISSTType(str, Enum):
    """Indica se o valor do PISST compõe o valor total da NF-e"""
    _0='0'
    _1='1'


class indTotType(str, Enum):
    """Este campo deverá ser preenchido com:
    0 – o valor do item (vProd) não compõe o valor total da NF-e (vProd)
    1 – o valor do item (vProd) compõe o valor total da NF-e (vProd)"""
    _0='0'
    _1='1'


class modBCSTType(str, Enum):
    """Modalidade de determinação da BC do ICMS ST:
    0 – Preço tabelado ou máximo sugerido;
    1 - Lista Negativa (valor);
    2 - Lista Positiva (valor);
    3 - Lista Neutra (valor);
    4 - Margem Valor Agregado (%);
    5 - Pauta (valor)
    6-Valor da Operação;"""
    _0='0'
    _1='1'
    _2='2'
    _3='3'
    _4='4'
    _5='5'
    _6='6'


class modBCSTType13(str, Enum):
    """Modalidade de determinação da BC do ICMS ST:
    0 – Preço tabelado ou máximo sugerido;
    1 - Lista Negativa (valor);
    2 - Lista Positiva (valor);
    3 - Lista Neutra (valor);
    4 - Margem Valor Agregado (%);
    5 - Pauta (valor).
    6 - Valor da Operação"""
    _0='0'
    _1='1'
    _2='2'
    _3='3'
    _4='4'
    _5='5'
    _6='6'


class modBCSTType22(str, Enum):
    """Modalidade de determinação da BC do ICMS ST:
    0 – Preço tabelado ou máximo sugerido;
    1 - Lista Negativa (valor);
    2 - Lista Positiva (valor);
    3 - Lista Neutra (valor);
    4 - Margem Valor Agregado (%);
    5 - Pauta (valor);
    6 - Valor da Operação."""
    _0='0'
    _1='1'
    _2='2'
    _3='3'
    _4='4'
    _5='5'
    _6='6'


class modBCSTType27(str, Enum):
    """Modalidade de determinação da BC do ICMS ST:
    0 – Preço tabelado ou máximo sugerido;
    1 - Lista Negativa (valor);
    2 - Lista Positiva (valor);
    3 - Lista Neutra (valor);
    4 - Margem Valor Agregado (%);
    5 - Pauta (valor);
    6 - Valor da Operação."""
    _0='0'
    _1='1'
    _2='2'
    _3='3'
    _4='4'
    _5='5'
    _6='6'


class modBCSTType32(str, Enum):
    """Modalidade de determinação da BC do ICMS ST:
    0 – Preço tabelado ou máximo sugerido;
    1 - Lista Negativa (valor);
    2 - Lista Positiva (valor);
    3 - Lista Neutra (valor);
    4 - Margem Valor Agregado (%);
    5 - Pauta (valor).
    6 - Valor da Operação"""
    _0='0'
    _1='1'
    _2='2'
    _3='3'
    _4='4'
    _5='5'
    _6='6'


class modBCSTType36(str, Enum):
    """Modalidade de determinação da BC do ICMS ST:
    0 – Preço tabelado ou máximo sugerido;
    1 - Lista Negativa (valor);
    2 - Lista Positiva (valor);
    3 - Lista Neutra (valor);
    4 - Margem Valor Agregado (%);
    5 - Pauta (valor). (v2.0)
    6 - Valor da Operação"""
    _0='0'
    _1='1'
    _2='2'
    _3='3'
    _4='4'
    _5='5'
    _6='6'


class modBCSTType38(str, Enum):
    """Modalidade de determinação da BC do ICMS ST:
    0 – Preço tabelado ou máximo sugerido;
    1 - Lista Negativa (valor);
    2 - Lista Positiva (valor);
    3 - Lista Neutra (valor);
    4 - Margem Valor Agregado (%);
    5 - Pauta (valor). (v2.0)
    6 - Valor da Operação"""
    _0='0'
    _1='1'
    _2='2'
    _3='3'
    _4='4'
    _5='5'
    _6='6'


class modBCSTType42(str, Enum):
    """Modalidade de determinação da BC do ICMS ST:
    0 – Preço tabelado ou máximo sugerido;
    1 - Lista Negativa (valor);
    2 - Lista Positiva (valor);
    3 - Lista Neutra (valor);
    4 - Margem Valor Agregado (%);
    5 - Pauta (valor).
    6 - Valor da Operação"""
    _0='0'
    _1='1'
    _2='2'
    _3='3'
    _4='4'
    _5='5'
    _6='6'


class modBCType(str, Enum):
    """Modalidade de determinação da BC do ICMS:
    0 - Margem Valor Agregado (%);
    1 - Pauta (valor);
    2 - Preço Tabelado Máximo (valor);
    3 - Valor da Operação."""
    _0='0'
    _1='1'
    _2='2'
    _3='3'


class modBCType11(str, Enum):
    """Modalidade de determinação da BC do ICMS:
    0 - Margem Valor Agregado (%);
    1 - Pauta (valor);
    2 - Preço Tabelado Máximo (valor);
    3 - Valor da Operação."""
    _0='0'
    _1='1'
    _2='2'
    _3='3'


class modBCType18(str, Enum):
    """Modalidade de determinação da BC do ICMS:
    0 - Margem Valor Agregado (%);
    1 - Pauta (valor);
    2 - Preço Tabelado Máximo (valor);
    3 - Valor da Operação."""
    _0='0'
    _1='1'
    _2='2'
    _3='3'


class modBCType21(str, Enum):
    """Modalidade de determinação da BC do ICMS:
    0 - Margem Valor Agregado (%);
    1 - Pauta (valor);
    2 - Preço Tabelado Máximo (valor);
    3 - Valor da Operação."""
    _0='0'
    _1='1'
    _2='2'
    _3='3'


class modBCType26(str, Enum):
    """Modalidade de determinação da BC do ICMS:
    0 - Margem Valor Agregado (%);
    1 - Pauta (valor);
    2 - Preço Tabelado Máximo (valor);
    3 - Valor da Operação."""
    _0='0'
    _1='1'
    _2='2'
    _3='3'


class modBCType31(str, Enum):
    """Modalidade de determinação da BC do ICMS:
    0 - Margem Valor Agregado (%);
    1 - Pauta (valor);
    2 - Preço Tabelado Máximo (valor);
    3 - Valor da Operação."""
    _0='0'
    _1='1'
    _2='2'
    _3='3'


class modBCType41(str, Enum):
    """Modalidade de determinação da BC do ICMS:
    0 - Margem Valor Agregado (%);
    1 - Pauta (valor);
    2 - Preço Tabelado Máximo (valor);
    3 - Valor da Operação."""
    _0='0'
    _1='1'
    _2='2'
    _3='3'


class modBCType9(str, Enum):
    """Modalidade de determinação da BC do ICMS:
    0 - Margem Valor Agregado (%);
    1 - Pauta (valor);
    2 - Preço Tabelado Máximo (valor);
    3 - Valor da Operação."""
    _0='0'
    _1='1'
    _2='2'
    _3='3'


class modFreteType(str, Enum):
    """Modalidade do frete
    0- Contratação do Frete por conta do Remetente (CIF);
    1- Contratação do Frete por conta do destinatário/remetente (FOB);
    2- Contratação do Frete por conta de terceiros;
    3- Transporte próprio por conta do remetente;
    4- Transporte próprio por conta do destinatário;
    9- Sem Ocorrência de transporte."""
    _0='0'
    _1='1'
    _2='2'
    _3='3'
    _4='4'
    _9='9'


class modType(str, Enum):
    """Código do modelo do Documento Fiscal. Utilizar 01 para NF modelo 1/1A e
    02 para NF modelo 02"""
    _0_1='01'
    _0_2='02'


class modType2(str, Enum):
    """Código do modelo do Documento Fiscal - utilizar 04 para NF de produtor
    ou 01 para NF Avulsa"""
    _0_1='01'
    _0_4='04'


class modType3(str, Enum):
    """Código do modelo do Documento Fiscal
    Preencher com "2B", quando se tratar de Cupom Fiscal emitido por máquina
    registradora (não ECF), com "2C", quando se tratar de Cupom Fiscal PDV,
    ou "2D", quando se tratar de Cupom Fiscal (emitido por ECF)"""
    _2_B='2B'
    _2_C='2C'
    _2_D='2D'


class motDesICMSSTType(str, Enum):
    """Motivo da desoneração do ICMS-ST: 3-Uso na agropecuária; 9-Outros;
    12-Fomento agropecuário."""
    _3='3'
    _9='9'
    _1_2='12'


class motDesICMSSTType24(str, Enum):
    """Motivo da desoneração do ICMS-ST: 3-Uso na agropecuária; 9-Outros;
    12-Fomento agropecuário."""
    _3='3'
    _9='9'
    _1_2='12'


class motDesICMSSTType29(str, Enum):
    """Motivo da desoneração do ICMS-ST: 3-Uso na agropecuária; 9-Outros;
    12-Fomento agropecuário."""
    _3='3'
    _9='9'
    _1_2='12'


class motDesICMSType(str, Enum):
    """Motivo da desoneração do ICMS:3-Uso na agropecuária;9-Outros;12-Fomento
    agropecuário"""
    _3='3'
    _9='9'
    _1_2='12'


class motDesICMSType14(str, Enum):
    """Motivo da desoneração do ICMS:6-Utilitários Motocicleta AÁrea
    Livre;7-SUFRAMA;9-Outros"""
    _6='6'
    _7='7'
    _9='9'


class motDesICMSType16(str, Enum):
    """Este campo será preenchido quando o campo anterior estiver preenchido.
    Informar o motivo da desoneração:
    1 – Táxi;
    3 – Produtor Agropecuário;
    4 – Frotista/Locadora;
    5 – Diplomático/Consular;
    6 – Utilitários e Motocicletas da Amazônia Ocidental e Áreas de Livre
    Comércio (Resolução 714/88 e 790/94 – CONTRAN e suas alterações);
    7 – SUFRAMA;
    8 - Venda a órgão Público;
    9 – Outros
    10- Deficiente Condutor
    11- Deficiente não condutor
    16 - Olimpíadas Rio 2016
    90 - Solicitado pelo Fisco"""
    _1='1'
    _3='3'
    _4='4'
    _5='5'
    _6='6'
    _7='7'
    _8='8'
    _9='9'
    _1_0='10'
    _1_1='11'
    _1_6='16'
    _9_0='90'


class motDesICMSType23(str, Enum):
    """Motivo da desoneração do ICMS:3-Uso na agropecuária;9-Outros;12-Fomento
    agropecuário"""
    _3='3'
    _9='9'
    _1_2='12'


class motDesICMSType28(str, Enum):
    """Motivo da desoneração do ICMS:3-Uso na agropecuária;9-Outros;12-Fomento
    agropecuário"""
    _3='3'
    _9='9'
    _1_2='12'


class pICMSInterType(str, Enum):
    """Alíquota interestadual das UF envolvidas: - 4% alíquota interestadual
    para produtos importados; - 7% para os Estados de origem do Sul e
    Sudeste (exceto ES), destinado para os Estados do Norte e Nordeste ou
    ES; - 12% para os demais casos."""
    _4_00='4.00'
    _7_00='7.00'
    _1_2_00='12.00'


class tpArmaType(str, Enum):
    """Indicador do tipo de arma de fogo (0 - Uso permitido; 1 - Uso
    restrito)"""
    _0='0'
    _1='1'


class tpEmisType(str, Enum):
    """Forma de emissão da NF-e
    1 - Normal;
    2 - Contingência FS
    3 - Regime Especial NFF (NT 2021.002)
    4 - Contingência DPEC
    5 - Contingência FSDA
    6 - Contingência SVC - AN
    7 - Contingência SVC - RS
    9 - Contingência off-line NFC-e"""
    _1='1'
    _2='2'
    _3='3'
    _4='4'
    _5='5'
    _6='6'
    _7='7'
    _9='9'


class tpImpType(str, Enum):
    """Formato de impressão do DANFE (0-sem DANFE;1-DANFe Retrato; 2-DANFe
    Paisagem;3-DANFe Simplificado;
    4-DANFe NFC-e;5-DANFe NFC-e em mensagem eletrônica)"""
    _0='0'
    _1='1'
    _2='2'
    _3='3'
    _4='4'
    _5='5'


class tpIntegraType(str, Enum):
    """Tipo de Integração do processo de pagamento com o sistema de automação
    da empresa/
    1=Pagamento integrado com o sistema de automação da empresa Ex. equipamento
    TEF , Comercio Eletronico
    2=Pagamento não integrado com o sistema de automação da empresa Ex:
    equipamento POS"""
    _1='1'
    _2='2'


class tpIntermedioType(str, Enum):
    """Forma de Importação quanto a intermediação
    1-por conta propria;2-por conta e ordem;3-encomenda"""
    _1='1'
    _2='2'
    _3='3'


class tpNFType(str, Enum):
    """Tipo do Documento Fiscal (0 - entrada; 1 - saída)"""
    _0='0'
    _1='1'


class tpOpType(str, Enum):
    """Tipo da Operação (1 - Venda concessionária; 2 - Faturamento direto; 3 -
    Venda direta; 0 - Outros)"""
    _0='0'
    _1='1'
    _2='2'
    _3='3'


class tpRestType(str, Enum):
    """Restrição
    0 - Não há;
    1 - Alienação Fiduciária;
    2 - Arrendamento Mercantil;
    3 - Reserva de Domínio;
    4 - Penhor de Veículos;
    9 - outras."""
    _0='0'
    _1='1'
    _2='2'
    _3='3'
    _4='4'
    _9='9'


class tpViaTranspType(str, Enum):
    """Via de transporte internacional informada na DI
    1-Maritima;2-Fluvial;3-Lacustre;4-Aerea;5-Postal;6-Ferroviaria;7-Rodoviaria
    ;8-Conduto;9-Meios Proprios;10-Entrada/Saida Ficta;
    11-Courier;12-Em maos;13-Por reboque."""
    _1='1'
    _2='2'
    _3='3'
    _4='4'
    _5='5'
    _6='6'
    _7='7'
    _8='8'
    _9='9'
    _1_0='10'
    _1_1='11'
    _1_2='12'
    _1_3='13'


class xPaisType68(str, Enum):
    """Nome do país"""
    BRASIL='Brasil'
    BRASIL_1='BRASIL'


class TNFe(GeneratedsSuper):
    """Tipo Nota Fiscal Eletrônica"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('infNFe', 'infNFeType', 0, 0, {'name': 'infNFe', 'type': 'infNFeType'}, None),
        MemberSpec_('infNFeSupl', 'infNFeSuplType', 0, 1, {'minOccurs': '0', 'name': 'infNFeSupl', 'type': 'infNFeSuplType'}, None),
        MemberSpec_('Signature', 'SignatureType', 0, 0, {'name': 'Signature', 'ref': 'Signature', 'type': 'Signature'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, infNFe=None, infNFeSupl=None, Signature=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.infNFe = infNFe
        self.infNFe_nsprefix_ = None
        self.infNFeSupl = infNFeSupl
        self.infNFeSupl_nsprefix_ = None
        self.Signature = Signature
        self.Signature_nsprefix_ = "ds"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TNFe)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TNFe.subclass:
            return TNFe.subclass(*args_, **kwargs_)
        else:
            return TNFe(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.infNFe is not None or
            self.infNFeSupl is not None or
            self.Signature is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TNFe', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TNFe')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TNFe':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TNFe')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TNFe', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TNFe'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TNFe', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.infNFe is not None:
            namespaceprefix_ = self.infNFe_nsprefix_ + ':' if (UseCapturedNS_ and self.infNFe_nsprefix_) else ''
            self.infNFe.export(outfile, level, namespaceprefix_, namespacedef_='', name_='infNFe', pretty_print=pretty_print)
        if self.infNFeSupl is not None:
            namespaceprefix_ = self.infNFeSupl_nsprefix_ + ':' if (UseCapturedNS_ and self.infNFeSupl_nsprefix_) else ''
            self.infNFeSupl.export(outfile, level, namespaceprefix_, namespacedef_='', name_='infNFeSupl', pretty_print=pretty_print)
        if self.Signature is not None:
            namespaceprefix_ = self.Signature_nsprefix_ + ':' if (UseCapturedNS_ and self.Signature_nsprefix_) else ''
            self.Signature.export(outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='Signature', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'infNFe':
            obj_ = infNFeType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.infNFe = obj_
            obj_.original_tagname_ = 'infNFe'
        elif nodeName_ == 'infNFeSupl':
            obj_ = infNFeSuplType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.infNFeSupl = obj_
            obj_.original_tagname_ = 'infNFeSupl'
        elif nodeName_ == 'Signature':
            obj_ = SignatureType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Signature = obj_
            obj_.original_tagname_ = 'Signature'
# end class TNFe


class TProtNFe(GeneratedsSuper):
    """Tipo Protocolo de status resultado do processamento da NF-e"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('versao', 'TVerNFe', 0, 0, {'use': 'required'}),
        MemberSpec_('infProt', 'infProtType', 0, 0, {'name': 'infProt', 'type': 'infProtType'}, None),
        MemberSpec_('Signature', 'SignatureType', 0, 1, {'minOccurs': '0', 'name': 'Signature', 'ref': 'Signature', 'type': 'Signature'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, versao=None, infProt=None, Signature=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.versao = _cast(None, versao)
        self.versao_nsprefix_ = None
        self.infProt = infProt
        self.infProt_nsprefix_ = None
        self.Signature = Signature
        self.Signature_nsprefix_ = "ds"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TProtNFe)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TProtNFe.subclass:
            return TProtNFe.subclass(*args_, **kwargs_)
        else:
            return TProtNFe(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TVerNFe(self, value):
        # Validate type TVerNFe, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TVerNFe_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TVerNFe_patterns_, ))
    validate_TVerNFe_patterns_ = [['^(4\\.00)$']]
    def hasContent_(self):
        if (
            self.infProt is not None or
            self.Signature is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TProtNFe', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TProtNFe')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TProtNFe':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TProtNFe')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TProtNFe', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TProtNFe'):
        if self.versao is not None and 'versao' not in already_processed:
            already_processed.add('versao')
            outfile.write(' versao=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.versao), input_name='versao')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TProtNFe', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.infProt is not None:
            namespaceprefix_ = self.infProt_nsprefix_ + ':' if (UseCapturedNS_ and self.infProt_nsprefix_) else ''
            self.infProt.export(outfile, level, namespaceprefix_, namespacedef_='', name_='infProt', pretty_print=pretty_print)
        if self.Signature is not None:
            namespaceprefix_ = self.Signature_nsprefix_ + ':' if (UseCapturedNS_ and self.Signature_nsprefix_) else ''
            self.Signature.export(outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='Signature', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('versao', node)
        if value is not None and 'versao' not in already_processed:
            already_processed.add('versao')
            self.versao = value
            self.validate_TVerNFe(self.versao)    # validate type TVerNFe
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'infProt':
            obj_ = infProtType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.infProt = obj_
            obj_.original_tagname_ = 'infProt'
        elif nodeName_ == 'Signature':
            obj_ = SignatureType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Signature = obj_
            obj_.original_tagname_ = 'Signature'
# end class TProtNFe


class TEnviNFe(GeneratedsSuper):
    """Tipo Pedido de Concessão de Autorização da Nota Fiscal Eletrônica"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('versao', 'TVerNFe', 0, 0, {'use': 'required'}),
        MemberSpec_('idLote', ['TIdLote', 'xs:string'], 0, 0, {'name': 'idLote', 'type': 'xs:string'}, None),
        MemberSpec_('indSinc', ['indSincType', 'xs:string'], 0, 0, {'name': 'indSinc', 'type': 'xs:string'}, None),
        MemberSpec_('NFe', 'TNFe', 1, 0, {'maxOccurs': '50', 'name': 'NFe', 'type': 'TNFe'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, versao=None, idLote=None, indSinc=None, NFe=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.versao = _cast(None, versao)
        self.versao_nsprefix_ = None
        self.idLote = idLote
        self.validate_TIdLote(self.idLote)
        self.idLote_nsprefix_ = None
        self.indSinc = indSinc
        self.validate_indSincType(self.indSinc)
        self.indSinc_nsprefix_ = None
        if NFe is None:
            self.NFe = []
        else:
            self.NFe = NFe
        self.NFe_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TEnviNFe)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TEnviNFe.subclass:
            return TEnviNFe.subclass(*args_, **kwargs_)
        else:
            return TEnviNFe(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TIdLote(self, value):
        result = True
        # Validate type TIdLote, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TIdLote_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TIdLote_patterns_, ))
                result = False
        return result
    validate_TIdLote_patterns_ = [['^([0-9]{1,15})$']]
    def validate_indSincType(self, value):
        result = True
        # Validate type indSincType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on indSincType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TVerNFe(self, value):
        # Validate type TVerNFe, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TVerNFe_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TVerNFe_patterns_, ))
    validate_TVerNFe_patterns_ = [['^(4\\.00)$']]
    def hasContent_(self):
        if (
            self.idLote is not None or
            self.indSinc is not None or
            self.NFe
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TEnviNFe', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TEnviNFe')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TEnviNFe':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TEnviNFe')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TEnviNFe', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TEnviNFe'):
        if self.versao is not None and 'versao' not in already_processed:
            already_processed.add('versao')
            outfile.write(' versao=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.versao), input_name='versao')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TEnviNFe', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.idLote is not None:
            namespaceprefix_ = self.idLote_nsprefix_ + ':' if (UseCapturedNS_ and self.idLote_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sidLote>%s</%sidLote>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.idLote), input_name='idLote')), namespaceprefix_ , eol_))
        if self.indSinc is not None:
            namespaceprefix_ = self.indSinc_nsprefix_ + ':' if (UseCapturedNS_ and self.indSinc_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sindSinc>%s</%sindSinc>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.indSinc), input_name='indSinc')), namespaceprefix_ , eol_))
        for NFe_ in self.NFe:
            namespaceprefix_ = self.NFe_nsprefix_ + ':' if (UseCapturedNS_ and self.NFe_nsprefix_) else ''
            NFe_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='NFe', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('versao', node)
        if value is not None and 'versao' not in already_processed:
            already_processed.add('versao')
            self.versao = value
            self.validate_TVerNFe(self.versao)    # validate type TVerNFe
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'idLote':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'idLote')
            value_ = self.gds_validate_string(value_, node, 'idLote')
            self.idLote = value_
            self.idLote_nsprefix_ = child_.prefix
            # validate type TIdLote
            self.validate_TIdLote(self.idLote)
        elif nodeName_ == 'indSinc':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'indSinc')
            value_ = self.gds_validate_string(value_, node, 'indSinc')
            self.indSinc = value_
            self.indSinc_nsprefix_ = child_.prefix
            # validate type indSincType
            self.validate_indSincType(self.indSinc)
        elif nodeName_ == 'NFe':
            obj_ = TNFe.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.NFe.append(obj_)
            obj_.original_tagname_ = 'NFe'
# end class TEnviNFe


class TRetEnviNFe(GeneratedsSuper):
    """Tipo Retorno do Pedido de Autorização da Nota Fiscal Eletrônica"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('versao', 'TVerNFe', 0, 0, {'use': 'required'}),
        MemberSpec_('tpAmb', ['TAmb', 'xs:string'], 0, 0, {'name': 'tpAmb', 'type': 'xs:string'}, None),
        MemberSpec_('verAplic', ['TVerAplic', 'nfe:TString'], 0, 0, {'name': 'verAplic', 'type': 'xs:string'}, None),
        MemberSpec_('cStat', ['TStat', 'xs:string'], 0, 0, {'name': 'cStat', 'type': 'xs:string'}, None),
        MemberSpec_('xMotivo', ['TMotivo', 'nfe:TString'], 0, 0, {'name': 'xMotivo', 'type': 'xs:string'}, None),
        MemberSpec_('cUF', ['TCodUfIBGE', 'xs:string'], 0, 0, {'name': 'cUF', 'type': 'xs:string'}, None),
        MemberSpec_('dhRecbto', ['TDateTimeUTC', 'xs:string'], 0, 0, {'name': 'dhRecbto', 'type': 'xs:string'}, None),
        MemberSpec_('infRec', 'infRecType', 0, 1, {'minOccurs': '0', 'name': 'infRec', 'type': 'infRecType'}, 1),
        MemberSpec_('protNFe', 'TProtNFe', 0, 1, {'minOccurs': '0', 'name': 'protNFe', 'type': 'TProtNFe'}, 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, versao=None, tpAmb=None, verAplic=None, cStat=None, xMotivo=None, cUF=None, dhRecbto=None, infRec=None, protNFe=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.versao = _cast(None, versao)
        self.versao_nsprefix_ = None
        self.tpAmb = tpAmb
        self.validate_TAmb(self.tpAmb)
        self.tpAmb_nsprefix_ = None
        self.verAplic = verAplic
        self.validate_TVerAplic(self.verAplic)
        self.verAplic_nsprefix_ = None
        self.cStat = cStat
        self.validate_TStat(self.cStat)
        self.cStat_nsprefix_ = None
        self.xMotivo = xMotivo
        self.validate_TMotivo(self.xMotivo)
        self.xMotivo_nsprefix_ = None
        self.cUF = cUF
        self.validate_TCodUfIBGE(self.cUF)
        self.cUF_nsprefix_ = None
        self.dhRecbto = dhRecbto
        self.validate_TDateTimeUTC(self.dhRecbto)
        self.dhRecbto_nsprefix_ = None
        self.infRec = infRec
        self.infRec_nsprefix_ = None
        self.protNFe = protNFe
        self.protNFe_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TRetEnviNFe)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TRetEnviNFe.subclass:
            return TRetEnviNFe.subclass(*args_, **kwargs_)
        else:
            return TRetEnviNFe(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TAmb(self, value):
        result = True
        # Validate type TAmb, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['1', '2']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TAmb' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TVerAplic(self, value):
        result = True
        # Validate type TVerAplic, a restriction on nfe:TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 20:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TVerAplic' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on TVerAplic' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TVerAplic_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TVerAplic_patterns_, ))
                result = False
        return result
    validate_TVerAplic_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TStat(self, value):
        result = True
        # Validate type TStat, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TStat' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TStat_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TStat_patterns_, ))
                result = False
        return result
    validate_TStat_patterns_ = [['^([0-9]{3})$']]
    def validate_TMotivo(self, value):
        result = True
        # Validate type TMotivo, a restriction on nfe:TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 255:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TMotivo' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on TMotivo' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TMotivo_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TMotivo_patterns_, ))
                result = False
        return result
    validate_TMotivo_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TCodUfIBGE(self, value):
        result = True
        # Validate type TCodUfIBGE, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['11', '12', '13', '14', '15', '16', '17', '21', '22', '23', '24', '25', '26', '27', '28', '29', '31', '32', '33', '35', '41', '42', '43', '50', '51', '52', '53']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TCodUfIBGE' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TDateTimeUTC(self, value):
        result = True
        # Validate type TDateTimeUTC, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDateTimeUTC_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDateTimeUTC_patterns_, ))
                result = False
        return result
    validate_TDateTimeUTC_patterns_ = [['^((((20(([02468][048])|([13579][26]))-02-29))|(20[0-9][0-9])-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\\d)|(2[0-8])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T(20|21|22|23|[0-1]\\d):[0-5]\\d:[0-5]\\d([\\-,\\+](0[0-9]|10|11):00|([\\+](12):00)))$']]
    def validate_TVerNFe(self, value):
        # Validate type TVerNFe, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TVerNFe_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TVerNFe_patterns_, ))
    validate_TVerNFe_patterns_ = [['^(4\\.00)$']]
    def hasContent_(self):
        if (
            self.tpAmb is not None or
            self.verAplic is not None or
            self.cStat is not None or
            self.xMotivo is not None or
            self.cUF is not None or
            self.dhRecbto is not None or
            self.infRec is not None or
            self.protNFe is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TRetEnviNFe', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TRetEnviNFe')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TRetEnviNFe':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TRetEnviNFe')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TRetEnviNFe', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TRetEnviNFe'):
        if self.versao is not None and 'versao' not in already_processed:
            already_processed.add('versao')
            outfile.write(' versao=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.versao), input_name='versao')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TRetEnviNFe', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.tpAmb is not None:
            namespaceprefix_ = self.tpAmb_nsprefix_ + ':' if (UseCapturedNS_ and self.tpAmb_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stpAmb>%s</%stpAmb>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tpAmb), input_name='tpAmb')), namespaceprefix_ , eol_))
        if self.verAplic is not None:
            namespaceprefix_ = self.verAplic_nsprefix_ + ':' if (UseCapturedNS_ and self.verAplic_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sverAplic>%s</%sverAplic>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.verAplic), input_name='verAplic')), namespaceprefix_ , eol_))
        if self.cStat is not None:
            namespaceprefix_ = self.cStat_nsprefix_ + ':' if (UseCapturedNS_ and self.cStat_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scStat>%s</%scStat>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cStat), input_name='cStat')), namespaceprefix_ , eol_))
        if self.xMotivo is not None:
            namespaceprefix_ = self.xMotivo_nsprefix_ + ':' if (UseCapturedNS_ and self.xMotivo_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxMotivo>%s</%sxMotivo>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xMotivo), input_name='xMotivo')), namespaceprefix_ , eol_))
        if self.cUF is not None:
            namespaceprefix_ = self.cUF_nsprefix_ + ':' if (UseCapturedNS_ and self.cUF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scUF>%s</%scUF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cUF), input_name='cUF')), namespaceprefix_ , eol_))
        if self.dhRecbto is not None:
            namespaceprefix_ = self.dhRecbto_nsprefix_ + ':' if (UseCapturedNS_ and self.dhRecbto_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdhRecbto>%s</%sdhRecbto>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.dhRecbto), input_name='dhRecbto')), namespaceprefix_ , eol_))
        if self.infRec is not None:
            namespaceprefix_ = self.infRec_nsprefix_ + ':' if (UseCapturedNS_ and self.infRec_nsprefix_) else ''
            self.infRec.export(outfile, level, namespaceprefix_, namespacedef_='', name_='infRec', pretty_print=pretty_print)
        if self.protNFe is not None:
            namespaceprefix_ = self.protNFe_nsprefix_ + ':' if (UseCapturedNS_ and self.protNFe_nsprefix_) else ''
            self.protNFe.export(outfile, level, namespaceprefix_, namespacedef_='', name_='protNFe', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('versao', node)
        if value is not None and 'versao' not in already_processed:
            already_processed.add('versao')
            self.versao = value
            self.validate_TVerNFe(self.versao)    # validate type TVerNFe
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'tpAmb':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tpAmb')
            value_ = self.gds_validate_string(value_, node, 'tpAmb')
            self.tpAmb = value_
            self.tpAmb_nsprefix_ = child_.prefix
            # validate type TAmb
            self.validate_TAmb(self.tpAmb)
        elif nodeName_ == 'verAplic':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'verAplic')
            value_ = self.gds_validate_string(value_, node, 'verAplic')
            self.verAplic = value_
            self.verAplic_nsprefix_ = child_.prefix
            # validate type TVerAplic
            self.validate_TVerAplic(self.verAplic)
        elif nodeName_ == 'cStat':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cStat')
            value_ = self.gds_validate_string(value_, node, 'cStat')
            self.cStat = value_
            self.cStat_nsprefix_ = child_.prefix
            # validate type TStat
            self.validate_TStat(self.cStat)
        elif nodeName_ == 'xMotivo':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xMotivo')
            value_ = self.gds_validate_string(value_, node, 'xMotivo')
            self.xMotivo = value_
            self.xMotivo_nsprefix_ = child_.prefix
            # validate type TMotivo
            self.validate_TMotivo(self.xMotivo)
        elif nodeName_ == 'cUF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cUF')
            value_ = self.gds_validate_string(value_, node, 'cUF')
            self.cUF = value_
            self.cUF_nsprefix_ = child_.prefix
            # validate type TCodUfIBGE
            self.validate_TCodUfIBGE(self.cUF)
        elif nodeName_ == 'dhRecbto':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'dhRecbto')
            value_ = self.gds_validate_string(value_, node, 'dhRecbto')
            self.dhRecbto = value_
            self.dhRecbto_nsprefix_ = child_.prefix
            # validate type TDateTimeUTC
            self.validate_TDateTimeUTC(self.dhRecbto)
        elif nodeName_ == 'infRec':
            obj_ = infRecType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.infRec = obj_
            obj_.original_tagname_ = 'infRec'
        elif nodeName_ == 'protNFe':
            obj_ = TProtNFe.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.protNFe = obj_
            obj_.original_tagname_ = 'protNFe'
# end class TRetEnviNFe


class TConsReciNFe(GeneratedsSuper):
    """Tipo Pedido de Consulta do Recido do Lote de Notas Fiscais
    Eletrônicas"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('versao', 'TVerNFe', 0, 0, {'use': 'required'}),
        MemberSpec_('tpAmb', ['TAmb', 'xs:string'], 0, 0, {'name': 'tpAmb', 'type': 'xs:string'}, None),
        MemberSpec_('nRec', ['TRec', 'xs:string'], 0, 0, {'name': 'nRec', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, versao=None, tpAmb=None, nRec=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.versao = _cast(None, versao)
        self.versao_nsprefix_ = None
        self.tpAmb = tpAmb
        self.validate_TAmb(self.tpAmb)
        self.tpAmb_nsprefix_ = None
        self.nRec = nRec
        self.validate_TRec(self.nRec)
        self.nRec_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TConsReciNFe)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TConsReciNFe.subclass:
            return TConsReciNFe.subclass(*args_, **kwargs_)
        else:
            return TConsReciNFe(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TAmb(self, value):
        result = True
        # Validate type TAmb, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['1', '2']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TAmb' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TRec(self, value):
        result = True
        # Validate type TRec, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 15:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TRec' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TRec_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TRec_patterns_, ))
                result = False
        return result
    validate_TRec_patterns_ = [['^([0-9]{15})$']]
    def validate_TVerNFe(self, value):
        # Validate type TVerNFe, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TVerNFe_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TVerNFe_patterns_, ))
    validate_TVerNFe_patterns_ = [['^(4\\.00)$']]
    def hasContent_(self):
        if (
            self.tpAmb is not None or
            self.nRec is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TConsReciNFe', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TConsReciNFe')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TConsReciNFe':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TConsReciNFe')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TConsReciNFe', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TConsReciNFe'):
        if self.versao is not None and 'versao' not in already_processed:
            already_processed.add('versao')
            outfile.write(' versao=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.versao), input_name='versao')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TConsReciNFe', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.tpAmb is not None:
            namespaceprefix_ = self.tpAmb_nsprefix_ + ':' if (UseCapturedNS_ and self.tpAmb_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stpAmb>%s</%stpAmb>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tpAmb), input_name='tpAmb')), namespaceprefix_ , eol_))
        if self.nRec is not None:
            namespaceprefix_ = self.nRec_nsprefix_ + ':' if (UseCapturedNS_ and self.nRec_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snRec>%s</%snRec>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nRec), input_name='nRec')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('versao', node)
        if value is not None and 'versao' not in already_processed:
            already_processed.add('versao')
            self.versao = value
            self.validate_TVerNFe(self.versao)    # validate type TVerNFe
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'tpAmb':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tpAmb')
            value_ = self.gds_validate_string(value_, node, 'tpAmb')
            self.tpAmb = value_
            self.tpAmb_nsprefix_ = child_.prefix
            # validate type TAmb
            self.validate_TAmb(self.tpAmb)
        elif nodeName_ == 'nRec':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nRec')
            value_ = self.gds_validate_string(value_, node, 'nRec')
            self.nRec = value_
            self.nRec_nsprefix_ = child_.prefix
            # validate type TRec
            self.validate_TRec(self.nRec)
# end class TConsReciNFe


class TRetConsReciNFe(GeneratedsSuper):
    """Tipo Retorno do Pedido de Consulta do Recido do Lote de Notas Fiscais
    Eletrônicas"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('versao', 'TVerNFe', 0, 0, {'use': 'required'}),
        MemberSpec_('tpAmb', ['TAmb', 'xs:string'], 0, 0, {'name': 'tpAmb', 'type': 'xs:string'}, None),
        MemberSpec_('verAplic', ['TVerAplic', 'nfe:TString'], 0, 0, {'name': 'verAplic', 'type': 'xs:string'}, None),
        MemberSpec_('nRec', ['TRec', 'xs:string'], 0, 0, {'name': 'nRec', 'type': 'xs:string'}, None),
        MemberSpec_('cStat', ['TStat', 'xs:string'], 0, 0, {'name': 'cStat', 'type': 'xs:string'}, None),
        MemberSpec_('xMotivo', ['TMotivo', 'nfe:TString'], 0, 0, {'name': 'xMotivo', 'type': 'xs:string'}, None),
        MemberSpec_('cUF', ['TCodUfIBGE', 'xs:string'], 0, 0, {'name': 'cUF', 'type': 'xs:string'}, None),
        MemberSpec_('dhRecbto', ['TDateTimeUTC', 'xs:string'], 0, 0, {'name': 'dhRecbto', 'type': 'xs:string'}, None),
        MemberSpec_('cMsg', ['cMsgType56', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'cMsg', 'type': 'xs:string'}, None),
        MemberSpec_('xMsg', ['xMsgType57', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'xMsg', 'type': 'xs:string'}, None),
        MemberSpec_('protNFe', 'TProtNFe', 1, 1, {'maxOccurs': '50', 'minOccurs': '0', 'name': 'protNFe', 'type': 'TProtNFe'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, versao=None, tpAmb=None, verAplic=None, nRec=None, cStat=None, xMotivo=None, cUF=None, dhRecbto=None, cMsg=None, xMsg=None, protNFe=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.versao = _cast(None, versao)
        self.versao_nsprefix_ = None
        self.tpAmb = tpAmb
        self.validate_TAmb(self.tpAmb)
        self.tpAmb_nsprefix_ = None
        self.verAplic = verAplic
        self.validate_TVerAplic(self.verAplic)
        self.verAplic_nsprefix_ = None
        self.nRec = nRec
        self.validate_TRec(self.nRec)
        self.nRec_nsprefix_ = None
        self.cStat = cStat
        self.validate_TStat(self.cStat)
        self.cStat_nsprefix_ = None
        self.xMotivo = xMotivo
        self.validate_TMotivo(self.xMotivo)
        self.xMotivo_nsprefix_ = None
        self.cUF = cUF
        self.validate_TCodUfIBGE(self.cUF)
        self.cUF_nsprefix_ = None
        self.dhRecbto = dhRecbto
        self.validate_TDateTimeUTC(self.dhRecbto)
        self.dhRecbto_nsprefix_ = None
        self.cMsg = cMsg
        self.validate_cMsgType56(self.cMsg)
        self.cMsg_nsprefix_ = None
        self.xMsg = xMsg
        self.validate_xMsgType57(self.xMsg)
        self.xMsg_nsprefix_ = None
        if protNFe is None:
            self.protNFe = []
        else:
            self.protNFe = protNFe
        self.protNFe_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TRetConsReciNFe)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TRetConsReciNFe.subclass:
            return TRetConsReciNFe.subclass(*args_, **kwargs_)
        else:
            return TRetConsReciNFe(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TAmb(self, value):
        result = True
        # Validate type TAmb, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['1', '2']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TAmb' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TVerAplic(self, value):
        result = True
        # Validate type TVerAplic, a restriction on nfe:TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 20:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TVerAplic' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on TVerAplic' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TVerAplic_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TVerAplic_patterns_, ))
                result = False
        return result
    validate_TVerAplic_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TRec(self, value):
        result = True
        # Validate type TRec, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 15:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TRec' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TRec_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TRec_patterns_, ))
                result = False
        return result
    validate_TRec_patterns_ = [['^([0-9]{15})$']]
    def validate_TStat(self, value):
        result = True
        # Validate type TStat, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TStat' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TStat_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TStat_patterns_, ))
                result = False
        return result
    validate_TStat_patterns_ = [['^([0-9]{3})$']]
    def validate_TMotivo(self, value):
        result = True
        # Validate type TMotivo, a restriction on nfe:TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 255:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TMotivo' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on TMotivo' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TMotivo_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TMotivo_patterns_, ))
                result = False
        return result
    validate_TMotivo_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TCodUfIBGE(self, value):
        result = True
        # Validate type TCodUfIBGE, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['11', '12', '13', '14', '15', '16', '17', '21', '22', '23', '24', '25', '26', '27', '28', '29', '31', '32', '33', '35', '41', '42', '43', '50', '51', '52', '53']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TCodUfIBGE' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TDateTimeUTC(self, value):
        result = True
        # Validate type TDateTimeUTC, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDateTimeUTC_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDateTimeUTC_patterns_, ))
                result = False
        return result
    validate_TDateTimeUTC_patterns_ = [['^((((20(([02468][048])|([13579][26]))-02-29))|(20[0-9][0-9])-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\\d)|(2[0-8])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T(20|21|22|23|[0-1]\\d):[0-5]\\d:[0-5]\\d([\\-,\\+](0[0-9]|10|11):00|([\\+](12):00)))$']]
    def validate_cMsgType56(self, value):
        result = True
        # Validate type cMsgType56, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_cMsgType56_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cMsgType56_patterns_, ))
                result = False
        return result
    validate_cMsgType56_patterns_ = [['^([0-9]{1,4})$']]
    def validate_xMsgType57(self, value):
        result = True
        # Validate type xMsgType57, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 200:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xMsgType57' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xMsgType57' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xMsgType57_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xMsgType57_patterns_, ))
                result = False
        return result
    validate_xMsgType57_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TVerNFe(self, value):
        # Validate type TVerNFe, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TVerNFe_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TVerNFe_patterns_, ))
    validate_TVerNFe_patterns_ = [['^(4\\.00)$']]
    def hasContent_(self):
        if (
            self.tpAmb is not None or
            self.verAplic is not None or
            self.nRec is not None or
            self.cStat is not None or
            self.xMotivo is not None or
            self.cUF is not None or
            self.dhRecbto is not None or
            self.cMsg is not None or
            self.xMsg is not None or
            self.protNFe
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TRetConsReciNFe', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TRetConsReciNFe')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TRetConsReciNFe':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TRetConsReciNFe')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TRetConsReciNFe', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TRetConsReciNFe'):
        if self.versao is not None and 'versao' not in already_processed:
            already_processed.add('versao')
            outfile.write(' versao=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.versao), input_name='versao')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TRetConsReciNFe', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.tpAmb is not None:
            namespaceprefix_ = self.tpAmb_nsprefix_ + ':' if (UseCapturedNS_ and self.tpAmb_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stpAmb>%s</%stpAmb>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tpAmb), input_name='tpAmb')), namespaceprefix_ , eol_))
        if self.verAplic is not None:
            namespaceprefix_ = self.verAplic_nsprefix_ + ':' if (UseCapturedNS_ and self.verAplic_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sverAplic>%s</%sverAplic>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.verAplic), input_name='verAplic')), namespaceprefix_ , eol_))
        if self.nRec is not None:
            namespaceprefix_ = self.nRec_nsprefix_ + ':' if (UseCapturedNS_ and self.nRec_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snRec>%s</%snRec>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nRec), input_name='nRec')), namespaceprefix_ , eol_))
        if self.cStat is not None:
            namespaceprefix_ = self.cStat_nsprefix_ + ':' if (UseCapturedNS_ and self.cStat_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scStat>%s</%scStat>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cStat), input_name='cStat')), namespaceprefix_ , eol_))
        if self.xMotivo is not None:
            namespaceprefix_ = self.xMotivo_nsprefix_ + ':' if (UseCapturedNS_ and self.xMotivo_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxMotivo>%s</%sxMotivo>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xMotivo), input_name='xMotivo')), namespaceprefix_ , eol_))
        if self.cUF is not None:
            namespaceprefix_ = self.cUF_nsprefix_ + ':' if (UseCapturedNS_ and self.cUF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scUF>%s</%scUF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cUF), input_name='cUF')), namespaceprefix_ , eol_))
        if self.dhRecbto is not None:
            namespaceprefix_ = self.dhRecbto_nsprefix_ + ':' if (UseCapturedNS_ and self.dhRecbto_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdhRecbto>%s</%sdhRecbto>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.dhRecbto), input_name='dhRecbto')), namespaceprefix_ , eol_))
        if self.cMsg is not None:
            namespaceprefix_ = self.cMsg_nsprefix_ + ':' if (UseCapturedNS_ and self.cMsg_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scMsg>%s</%scMsg>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cMsg), input_name='cMsg')), namespaceprefix_ , eol_))
        if self.xMsg is not None:
            namespaceprefix_ = self.xMsg_nsprefix_ + ':' if (UseCapturedNS_ and self.xMsg_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxMsg>%s</%sxMsg>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xMsg), input_name='xMsg')), namespaceprefix_ , eol_))
        for protNFe_ in self.protNFe:
            namespaceprefix_ = self.protNFe_nsprefix_ + ':' if (UseCapturedNS_ and self.protNFe_nsprefix_) else ''
            protNFe_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='protNFe', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('versao', node)
        if value is not None and 'versao' not in already_processed:
            already_processed.add('versao')
            self.versao = value
            self.validate_TVerNFe(self.versao)    # validate type TVerNFe
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'tpAmb':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tpAmb')
            value_ = self.gds_validate_string(value_, node, 'tpAmb')
            self.tpAmb = value_
            self.tpAmb_nsprefix_ = child_.prefix
            # validate type TAmb
            self.validate_TAmb(self.tpAmb)
        elif nodeName_ == 'verAplic':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'verAplic')
            value_ = self.gds_validate_string(value_, node, 'verAplic')
            self.verAplic = value_
            self.verAplic_nsprefix_ = child_.prefix
            # validate type TVerAplic
            self.validate_TVerAplic(self.verAplic)
        elif nodeName_ == 'nRec':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nRec')
            value_ = self.gds_validate_string(value_, node, 'nRec')
            self.nRec = value_
            self.nRec_nsprefix_ = child_.prefix
            # validate type TRec
            self.validate_TRec(self.nRec)
        elif nodeName_ == 'cStat':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cStat')
            value_ = self.gds_validate_string(value_, node, 'cStat')
            self.cStat = value_
            self.cStat_nsprefix_ = child_.prefix
            # validate type TStat
            self.validate_TStat(self.cStat)
        elif nodeName_ == 'xMotivo':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xMotivo')
            value_ = self.gds_validate_string(value_, node, 'xMotivo')
            self.xMotivo = value_
            self.xMotivo_nsprefix_ = child_.prefix
            # validate type TMotivo
            self.validate_TMotivo(self.xMotivo)
        elif nodeName_ == 'cUF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cUF')
            value_ = self.gds_validate_string(value_, node, 'cUF')
            self.cUF = value_
            self.cUF_nsprefix_ = child_.prefix
            # validate type TCodUfIBGE
            self.validate_TCodUfIBGE(self.cUF)
        elif nodeName_ == 'dhRecbto':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'dhRecbto')
            value_ = self.gds_validate_string(value_, node, 'dhRecbto')
            self.dhRecbto = value_
            self.dhRecbto_nsprefix_ = child_.prefix
            # validate type TDateTimeUTC
            self.validate_TDateTimeUTC(self.dhRecbto)
        elif nodeName_ == 'cMsg':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cMsg')
            value_ = self.gds_validate_string(value_, node, 'cMsg')
            self.cMsg = value_
            self.cMsg_nsprefix_ = child_.prefix
            # validate type cMsgType56
            self.validate_cMsgType56(self.cMsg)
        elif nodeName_ == 'xMsg':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xMsg')
            value_ = self.gds_validate_string(value_, node, 'xMsg')
            self.xMsg = value_
            self.xMsg_nsprefix_ = child_.prefix
            # validate type xMsgType57
            self.validate_xMsgType57(self.xMsg)
        elif nodeName_ == 'protNFe':
            obj_ = TProtNFe.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.protNFe.append(obj_)
            obj_.original_tagname_ = 'protNFe'
# end class TRetConsReciNFe


class TNfeProc(GeneratedsSuper):
    """Tipo da NF-e processada"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('versao', 'TVerNFe', 0, 0, {'use': 'required'}),
        MemberSpec_('NFe', 'TNFe', 0, 0, {'name': 'NFe', 'type': 'TNFe'}, None),
        MemberSpec_('protNFe', 'TProtNFe', 0, 0, {'name': 'protNFe', 'type': 'TProtNFe'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, versao=None, NFe=None, protNFe=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.versao = _cast(None, versao)
        self.versao_nsprefix_ = None
        self.NFe = NFe
        self.NFe_nsprefix_ = None
        self.protNFe = protNFe
        self.protNFe_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TNfeProc)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TNfeProc.subclass:
            return TNfeProc.subclass(*args_, **kwargs_)
        else:
            return TNfeProc(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TVerNFe(self, value):
        # Validate type TVerNFe, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TVerNFe_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TVerNFe_patterns_, ))
    validate_TVerNFe_patterns_ = [['^(4\\.00)$']]
    def hasContent_(self):
        if (
            self.NFe is not None or
            self.protNFe is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TNfeProc', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TNfeProc')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TNfeProc':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TNfeProc')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TNfeProc', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TNfeProc'):
        if self.versao is not None and 'versao' not in already_processed:
            already_processed.add('versao')
            outfile.write(' versao=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.versao), input_name='versao')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TNfeProc', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.NFe is not None:
            namespaceprefix_ = self.NFe_nsprefix_ + ':' if (UseCapturedNS_ and self.NFe_nsprefix_) else ''
            self.NFe.export(outfile, level, namespaceprefix_, namespacedef_='', name_='NFe', pretty_print=pretty_print)
        if self.protNFe is not None:
            namespaceprefix_ = self.protNFe_nsprefix_ + ':' if (UseCapturedNS_ and self.protNFe_nsprefix_) else ''
            self.protNFe.export(outfile, level, namespaceprefix_, namespacedef_='', name_='protNFe', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('versao', node)
        if value is not None and 'versao' not in already_processed:
            already_processed.add('versao')
            self.versao = value
            self.validate_TVerNFe(self.versao)    # validate type TVerNFe
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'NFe':
            obj_ = TNFe.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.NFe = obj_
            obj_.original_tagname_ = 'NFe'
        elif nodeName_ == 'protNFe':
            obj_ = TProtNFe.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.protNFe = obj_
            obj_.original_tagname_ = 'protNFe'
# end class TNfeProc


class TEndereco(GeneratedsSuper):
    """Tipo Dados do Endereço // 24/10/08 - tamanho mínimo"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('xLgr', ['xLgrType', 'TString', 'xs:string'], 0, 0, {'name': 'xLgr', 'type': 'xs:string'}, None),
        MemberSpec_('nro', ['nroType', 'TString', 'xs:string'], 0, 0, {'name': 'nro', 'type': 'xs:string'}, None),
        MemberSpec_('xCpl', ['xCplType', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'xCpl', 'type': 'xs:string'}, None),
        MemberSpec_('xBairro', ['xBairroType', 'TString', 'xs:string'], 0, 0, {'name': 'xBairro', 'type': 'xs:string'}, None),
        MemberSpec_('cMun', ['TCodMunIBGE', 'xs:string'], 0, 0, {'name': 'cMun', 'type': 'xs:string'}, None),
        MemberSpec_('xMun', ['xMunType58', 'TString', 'xs:string'], 0, 0, {'name': 'xMun', 'type': 'xs:string'}, None),
        MemberSpec_('UF', ['TUf', 'xs:string'], 0, 0, {'name': 'UF', 'type': 'xs:string'}, None),
        MemberSpec_('CEP', ['CEPType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'CEP', 'type': 'xs:string'}, None),
        MemberSpec_('cPais', ['cPaisType59', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'cPais', 'type': 'xs:string'}, None),
        MemberSpec_('xPais', ['xPaisType', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'xPais', 'type': 'xs:string'}, None),
        MemberSpec_('fone', ['foneType60', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'fone', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, xLgr=None, nro=None, xCpl=None, xBairro=None, cMun=None, xMun=None, UF=None, CEP=None, cPais=None, xPais=None, fone=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.xLgr = xLgr
        self.validate_xLgrType(self.xLgr)
        self.xLgr_nsprefix_ = None
        self.nro = nro
        self.validate_nroType(self.nro)
        self.nro_nsprefix_ = None
        self.xCpl = xCpl
        self.validate_xCplType(self.xCpl)
        self.xCpl_nsprefix_ = None
        self.xBairro = xBairro
        self.validate_xBairroType(self.xBairro)
        self.xBairro_nsprefix_ = None
        self.cMun = cMun
        self.validate_TCodMunIBGE(self.cMun)
        self.cMun_nsprefix_ = None
        self.xMun = xMun
        self.validate_xMunType58(self.xMun)
        self.xMun_nsprefix_ = None
        self.UF = UF
        self.validate_TUf(self.UF)
        self.UF_nsprefix_ = None
        self.CEP = CEP
        self.validate_CEPType(self.CEP)
        self.CEP_nsprefix_ = None
        self.cPais = cPais
        self.validate_cPaisType59(self.cPais)
        self.cPais_nsprefix_ = None
        self.xPais = xPais
        self.validate_xPaisType(self.xPais)
        self.xPais_nsprefix_ = None
        self.fone = fone
        self.validate_foneType60(self.fone)
        self.fone_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TEndereco)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TEndereco.subclass:
            return TEndereco.subclass(*args_, **kwargs_)
        else:
            return TEndereco(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_xLgrType(self, value):
        result = True
        # Validate type xLgrType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xLgrType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xLgrType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xLgrType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xLgrType_patterns_, ))
                result = False
        return result
    validate_xLgrType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_nroType(self, value):
        result = True
        # Validate type nroType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on nroType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nroType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_nroType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nroType_patterns_, ))
                result = False
        return result
    validate_nroType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_xCplType(self, value):
        result = True
        # Validate type xCplType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xCplType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xCplType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xCplType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xCplType_patterns_, ))
                result = False
        return result
    validate_xCplType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_xBairroType(self, value):
        result = True
        # Validate type xBairroType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xBairroType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xBairroType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xBairroType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xBairroType_patterns_, ))
                result = False
        return result
    validate_xBairroType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TCodMunIBGE(self, value):
        result = True
        # Validate type TCodMunIBGE, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCodMunIBGE_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCodMunIBGE_patterns_, ))
                result = False
        return result
    validate_TCodMunIBGE_patterns_ = [['^([0-9]{7})$']]
    def validate_xMunType58(self, value):
        result = True
        # Validate type xMunType58, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xMunType58' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xMunType58' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xMunType58_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xMunType58_patterns_, ))
                result = False
        return result
    validate_xMunType58_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TUf(self, value):
        result = True
        # Validate type TUf, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['AC', 'AL', 'AM', 'AP', 'BA', 'CE', 'DF', 'ES', 'GO', 'MA', 'MG', 'MS', 'MT', 'PA', 'PB', 'PE', 'PI', 'PR', 'RJ', 'RN', 'RO', 'RR', 'RS', 'SC', 'SE', 'SP', 'TO', 'EX']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TUf' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CEPType(self, value):
        result = True
        # Validate type CEPType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_CEPType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_CEPType_patterns_, ))
                result = False
        return result
    validate_CEPType_patterns_ = [['^([0-9]{8})$']]
    def validate_cPaisType59(self, value):
        result = True
        # Validate type cPaisType59, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_cPaisType59_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cPaisType59_patterns_, ))
                result = False
        return result
    validate_cPaisType59_patterns_ = [['^([0-9]{1,4})$']]
    def validate_xPaisType(self, value):
        result = True
        # Validate type xPaisType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xPaisType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xPaisType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xPaisType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xPaisType_patterns_, ))
                result = False
        return result
    validate_xPaisType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_foneType60(self, value):
        result = True
        # Validate type foneType60, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_foneType60_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_foneType60_patterns_, ))
                result = False
        return result
    validate_foneType60_patterns_ = [['^([0-9]{6,14})$']]
    def hasContent_(self):
        if (
            self.xLgr is not None or
            self.nro is not None or
            self.xCpl is not None or
            self.xBairro is not None or
            self.cMun is not None or
            self.xMun is not None or
            self.UF is not None or
            self.CEP is not None or
            self.cPais is not None or
            self.xPais is not None or
            self.fone is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TEndereco', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TEndereco')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TEndereco':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TEndereco')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TEndereco', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TEndereco'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TEndereco', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.xLgr is not None:
            namespaceprefix_ = self.xLgr_nsprefix_ + ':' if (UseCapturedNS_ and self.xLgr_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxLgr>%s</%sxLgr>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xLgr), input_name='xLgr')), namespaceprefix_ , eol_))
        if self.nro is not None:
            namespaceprefix_ = self.nro_nsprefix_ + ':' if (UseCapturedNS_ and self.nro_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snro>%s</%snro>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nro), input_name='nro')), namespaceprefix_ , eol_))
        if self.xCpl is not None:
            namespaceprefix_ = self.xCpl_nsprefix_ + ':' if (UseCapturedNS_ and self.xCpl_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxCpl>%s</%sxCpl>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xCpl), input_name='xCpl')), namespaceprefix_ , eol_))
        if self.xBairro is not None:
            namespaceprefix_ = self.xBairro_nsprefix_ + ':' if (UseCapturedNS_ and self.xBairro_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxBairro>%s</%sxBairro>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xBairro), input_name='xBairro')), namespaceprefix_ , eol_))
        if self.cMun is not None:
            namespaceprefix_ = self.cMun_nsprefix_ + ':' if (UseCapturedNS_ and self.cMun_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scMun>%s</%scMun>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cMun), input_name='cMun')), namespaceprefix_ , eol_))
        if self.xMun is not None:
            namespaceprefix_ = self.xMun_nsprefix_ + ':' if (UseCapturedNS_ and self.xMun_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxMun>%s</%sxMun>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xMun), input_name='xMun')), namespaceprefix_ , eol_))
        if self.UF is not None:
            namespaceprefix_ = self.UF_nsprefix_ + ':' if (UseCapturedNS_ and self.UF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUF>%s</%sUF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.UF), input_name='UF')), namespaceprefix_ , eol_))
        if self.CEP is not None:
            namespaceprefix_ = self.CEP_nsprefix_ + ':' if (UseCapturedNS_ and self.CEP_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCEP>%s</%sCEP>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CEP), input_name='CEP')), namespaceprefix_ , eol_))
        if self.cPais is not None:
            namespaceprefix_ = self.cPais_nsprefix_ + ':' if (UseCapturedNS_ and self.cPais_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scPais>%s</%scPais>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cPais), input_name='cPais')), namespaceprefix_ , eol_))
        if self.xPais is not None:
            namespaceprefix_ = self.xPais_nsprefix_ + ':' if (UseCapturedNS_ and self.xPais_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxPais>%s</%sxPais>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xPais), input_name='xPais')), namespaceprefix_ , eol_))
        if self.fone is not None:
            namespaceprefix_ = self.fone_nsprefix_ + ':' if (UseCapturedNS_ and self.fone_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfone>%s</%sfone>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.fone), input_name='fone')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'xLgr':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xLgr')
            value_ = self.gds_validate_string(value_, node, 'xLgr')
            self.xLgr = value_
            self.xLgr_nsprefix_ = child_.prefix
            # validate type xLgrType
            self.validate_xLgrType(self.xLgr)
        elif nodeName_ == 'nro':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nro')
            value_ = self.gds_validate_string(value_, node, 'nro')
            self.nro = value_
            self.nro_nsprefix_ = child_.prefix
            # validate type nroType
            self.validate_nroType(self.nro)
        elif nodeName_ == 'xCpl':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xCpl')
            value_ = self.gds_validate_string(value_, node, 'xCpl')
            self.xCpl = value_
            self.xCpl_nsprefix_ = child_.prefix
            # validate type xCplType
            self.validate_xCplType(self.xCpl)
        elif nodeName_ == 'xBairro':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xBairro')
            value_ = self.gds_validate_string(value_, node, 'xBairro')
            self.xBairro = value_
            self.xBairro_nsprefix_ = child_.prefix
            # validate type xBairroType
            self.validate_xBairroType(self.xBairro)
        elif nodeName_ == 'cMun':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cMun')
            value_ = self.gds_validate_string(value_, node, 'cMun')
            self.cMun = value_
            self.cMun_nsprefix_ = child_.prefix
            # validate type TCodMunIBGE
            self.validate_TCodMunIBGE(self.cMun)
        elif nodeName_ == 'xMun':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xMun')
            value_ = self.gds_validate_string(value_, node, 'xMun')
            self.xMun = value_
            self.xMun_nsprefix_ = child_.prefix
            # validate type xMunType58
            self.validate_xMunType58(self.xMun)
        elif nodeName_ == 'UF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'UF')
            value_ = self.gds_validate_string(value_, node, 'UF')
            self.UF = value_
            self.UF_nsprefix_ = child_.prefix
            # validate type TUf
            self.validate_TUf(self.UF)
        elif nodeName_ == 'CEP':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CEP')
            value_ = self.gds_validate_string(value_, node, 'CEP')
            self.CEP = value_
            self.CEP_nsprefix_ = child_.prefix
            # validate type CEPType
            self.validate_CEPType(self.CEP)
        elif nodeName_ == 'cPais':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cPais')
            value_ = self.gds_validate_string(value_, node, 'cPais')
            self.cPais = value_
            self.cPais_nsprefix_ = child_.prefix
            # validate type cPaisType59
            self.validate_cPaisType59(self.cPais)
        elif nodeName_ == 'xPais':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xPais')
            value_ = self.gds_validate_string(value_, node, 'xPais')
            self.xPais = value_
            self.xPais_nsprefix_ = child_.prefix
            # validate type xPaisType
            self.validate_xPaisType(self.xPais)
        elif nodeName_ == 'fone':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'fone')
            value_ = self.gds_validate_string(value_, node, 'fone')
            self.fone = value_
            self.fone_nsprefix_ = child_.prefix
            # validate type foneType60
            self.validate_foneType60(self.fone)
# end class TEndereco


class TEnderEmi(GeneratedsSuper):
    """Tipo Dados do Endereço do Emitente // 24/10/08 - desmembrado / tamanho
    mínimo"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('xLgr', ['xLgrType61', 'TString', 'xs:string'], 0, 0, {'name': 'xLgr', 'type': 'xs:string'}, None),
        MemberSpec_('nro', ['nroType62', 'TString', 'xs:string'], 0, 0, {'name': 'nro', 'type': 'xs:string'}, None),
        MemberSpec_('xCpl', ['xCplType63', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'xCpl', 'type': 'xs:string'}, None),
        MemberSpec_('xBairro', ['xBairroType64', 'TString', 'xs:string'], 0, 0, {'name': 'xBairro', 'type': 'xs:string'}, None),
        MemberSpec_('cMun', ['TCodMunIBGE', 'xs:string'], 0, 0, {'name': 'cMun', 'type': 'xs:string'}, None),
        MemberSpec_('xMun', ['xMunType65', 'TString', 'xs:string'], 0, 0, {'name': 'xMun', 'type': 'xs:string'}, None),
        MemberSpec_('UF', ['TUfEmi', 'xs:string'], 0, 0, {'name': 'UF', 'type': 'xs:string'}, None),
        MemberSpec_('CEP', ['CEPType66', 'xs:string'], 0, 0, {'name': 'CEP', 'type': 'xs:string'}, None),
        MemberSpec_('cPais', ['cPaisType67', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'cPais', 'type': 'xs:string'}, None),
        MemberSpec_('xPais', ['xPaisType68', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'xPais', 'type': 'xs:string'}, None),
        MemberSpec_('fone', ['foneType69', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'fone', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, xLgr=None, nro=None, xCpl=None, xBairro=None, cMun=None, xMun=None, UF=None, CEP=None, cPais=None, xPais=None, fone=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.xLgr = xLgr
        self.validate_xLgrType61(self.xLgr)
        self.xLgr_nsprefix_ = None
        self.nro = nro
        self.validate_nroType62(self.nro)
        self.nro_nsprefix_ = None
        self.xCpl = xCpl
        self.validate_xCplType63(self.xCpl)
        self.xCpl_nsprefix_ = None
        self.xBairro = xBairro
        self.validate_xBairroType64(self.xBairro)
        self.xBairro_nsprefix_ = None
        self.cMun = cMun
        self.validate_TCodMunIBGE(self.cMun)
        self.cMun_nsprefix_ = None
        self.xMun = xMun
        self.validate_xMunType65(self.xMun)
        self.xMun_nsprefix_ = None
        self.UF = UF
        self.validate_TUfEmi(self.UF)
        self.UF_nsprefix_ = None
        self.CEP = CEP
        self.validate_CEPType66(self.CEP)
        self.CEP_nsprefix_ = None
        self.cPais = cPais
        self.validate_cPaisType67(self.cPais)
        self.cPais_nsprefix_ = None
        self.xPais = xPais
        self.validate_xPaisType68(self.xPais)
        self.xPais_nsprefix_ = None
        self.fone = fone
        self.validate_foneType69(self.fone)
        self.fone_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TEnderEmi)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TEnderEmi.subclass:
            return TEnderEmi.subclass(*args_, **kwargs_)
        else:
            return TEnderEmi(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_xLgrType61(self, value):
        result = True
        # Validate type xLgrType61, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xLgrType61' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xLgrType61' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xLgrType61_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xLgrType61_patterns_, ))
                result = False
        return result
    validate_xLgrType61_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_nroType62(self, value):
        result = True
        # Validate type nroType62, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on nroType62' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nroType62' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_nroType62_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nroType62_patterns_, ))
                result = False
        return result
    validate_nroType62_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_xCplType63(self, value):
        result = True
        # Validate type xCplType63, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xCplType63' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xCplType63' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xCplType63_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xCplType63_patterns_, ))
                result = False
        return result
    validate_xCplType63_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_xBairroType64(self, value):
        result = True
        # Validate type xBairroType64, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xBairroType64' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xBairroType64' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xBairroType64_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xBairroType64_patterns_, ))
                result = False
        return result
    validate_xBairroType64_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TCodMunIBGE(self, value):
        result = True
        # Validate type TCodMunIBGE, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCodMunIBGE_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCodMunIBGE_patterns_, ))
                result = False
        return result
    validate_TCodMunIBGE_patterns_ = [['^([0-9]{7})$']]
    def validate_xMunType65(self, value):
        result = True
        # Validate type xMunType65, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xMunType65' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xMunType65' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xMunType65_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xMunType65_patterns_, ))
                result = False
        return result
    validate_xMunType65_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TUfEmi(self, value):
        result = True
        # Validate type TUfEmi, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['AC', 'AL', 'AM', 'AP', 'BA', 'CE', 'DF', 'ES', 'GO', 'MA', 'MG', 'MS', 'MT', 'PA', 'PB', 'PE', 'PI', 'PR', 'RJ', 'RN', 'RO', 'RR', 'RS', 'SC', 'SE', 'SP', 'TO']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TUfEmi' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CEPType66(self, value):
        result = True
        # Validate type CEPType66, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_CEPType66_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_CEPType66_patterns_, ))
                result = False
        return result
    validate_CEPType66_patterns_ = [['^([0-9]{8})$']]
    def validate_cPaisType67(self, value):
        result = True
        # Validate type cPaisType67, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['1058']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on cPaisType67' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_cPaisType67_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cPaisType67_patterns_, ))
                result = False
        return result
    validate_cPaisType67_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_xPaisType68(self, value):
        result = True
        # Validate type xPaisType68, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['Brasil', 'BRASIL']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on xPaisType68' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xPaisType68_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xPaisType68_patterns_, ))
                result = False
        return result
    validate_xPaisType68_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_foneType69(self, value):
        result = True
        # Validate type foneType69, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_foneType69_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_foneType69_patterns_, ))
                result = False
        return result
    validate_foneType69_patterns_ = [['^([0-9]{6,14})$']]
    def hasContent_(self):
        if (
            self.xLgr is not None or
            self.nro is not None or
            self.xCpl is not None or
            self.xBairro is not None or
            self.cMun is not None or
            self.xMun is not None or
            self.UF is not None or
            self.CEP is not None or
            self.cPais is not None or
            self.xPais is not None or
            self.fone is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TEnderEmi', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TEnderEmi')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TEnderEmi':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TEnderEmi')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TEnderEmi', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TEnderEmi'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TEnderEmi', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.xLgr is not None:
            namespaceprefix_ = self.xLgr_nsprefix_ + ':' if (UseCapturedNS_ and self.xLgr_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxLgr>%s</%sxLgr>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xLgr), input_name='xLgr')), namespaceprefix_ , eol_))
        if self.nro is not None:
            namespaceprefix_ = self.nro_nsprefix_ + ':' if (UseCapturedNS_ and self.nro_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snro>%s</%snro>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nro), input_name='nro')), namespaceprefix_ , eol_))
        if self.xCpl is not None:
            namespaceprefix_ = self.xCpl_nsprefix_ + ':' if (UseCapturedNS_ and self.xCpl_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxCpl>%s</%sxCpl>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xCpl), input_name='xCpl')), namespaceprefix_ , eol_))
        if self.xBairro is not None:
            namespaceprefix_ = self.xBairro_nsprefix_ + ':' if (UseCapturedNS_ and self.xBairro_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxBairro>%s</%sxBairro>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xBairro), input_name='xBairro')), namespaceprefix_ , eol_))
        if self.cMun is not None:
            namespaceprefix_ = self.cMun_nsprefix_ + ':' if (UseCapturedNS_ and self.cMun_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scMun>%s</%scMun>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cMun), input_name='cMun')), namespaceprefix_ , eol_))
        if self.xMun is not None:
            namespaceprefix_ = self.xMun_nsprefix_ + ':' if (UseCapturedNS_ and self.xMun_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxMun>%s</%sxMun>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xMun), input_name='xMun')), namespaceprefix_ , eol_))
        if self.UF is not None:
            namespaceprefix_ = self.UF_nsprefix_ + ':' if (UseCapturedNS_ and self.UF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUF>%s</%sUF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.UF), input_name='UF')), namespaceprefix_ , eol_))
        if self.CEP is not None:
            namespaceprefix_ = self.CEP_nsprefix_ + ':' if (UseCapturedNS_ and self.CEP_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCEP>%s</%sCEP>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CEP), input_name='CEP')), namespaceprefix_ , eol_))
        if self.cPais is not None:
            namespaceprefix_ = self.cPais_nsprefix_ + ':' if (UseCapturedNS_ and self.cPais_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scPais>%s</%scPais>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cPais), input_name='cPais')), namespaceprefix_ , eol_))
        if self.xPais is not None:
            namespaceprefix_ = self.xPais_nsprefix_ + ':' if (UseCapturedNS_ and self.xPais_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxPais>%s</%sxPais>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xPais), input_name='xPais')), namespaceprefix_ , eol_))
        if self.fone is not None:
            namespaceprefix_ = self.fone_nsprefix_ + ':' if (UseCapturedNS_ and self.fone_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfone>%s</%sfone>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.fone), input_name='fone')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'xLgr':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xLgr')
            value_ = self.gds_validate_string(value_, node, 'xLgr')
            self.xLgr = value_
            self.xLgr_nsprefix_ = child_.prefix
            # validate type xLgrType61
            self.validate_xLgrType61(self.xLgr)
        elif nodeName_ == 'nro':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nro')
            value_ = self.gds_validate_string(value_, node, 'nro')
            self.nro = value_
            self.nro_nsprefix_ = child_.prefix
            # validate type nroType62
            self.validate_nroType62(self.nro)
        elif nodeName_ == 'xCpl':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xCpl')
            value_ = self.gds_validate_string(value_, node, 'xCpl')
            self.xCpl = value_
            self.xCpl_nsprefix_ = child_.prefix
            # validate type xCplType63
            self.validate_xCplType63(self.xCpl)
        elif nodeName_ == 'xBairro':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xBairro')
            value_ = self.gds_validate_string(value_, node, 'xBairro')
            self.xBairro = value_
            self.xBairro_nsprefix_ = child_.prefix
            # validate type xBairroType64
            self.validate_xBairroType64(self.xBairro)
        elif nodeName_ == 'cMun':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cMun')
            value_ = self.gds_validate_string(value_, node, 'cMun')
            self.cMun = value_
            self.cMun_nsprefix_ = child_.prefix
            # validate type TCodMunIBGE
            self.validate_TCodMunIBGE(self.cMun)
        elif nodeName_ == 'xMun':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xMun')
            value_ = self.gds_validate_string(value_, node, 'xMun')
            self.xMun = value_
            self.xMun_nsprefix_ = child_.prefix
            # validate type xMunType65
            self.validate_xMunType65(self.xMun)
        elif nodeName_ == 'UF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'UF')
            value_ = self.gds_validate_string(value_, node, 'UF')
            self.UF = value_
            self.UF_nsprefix_ = child_.prefix
            # validate type TUfEmi
            self.validate_TUfEmi(self.UF)
        elif nodeName_ == 'CEP':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CEP')
            value_ = self.gds_validate_string(value_, node, 'CEP')
            self.CEP = value_
            self.CEP_nsprefix_ = child_.prefix
            # validate type CEPType66
            self.validate_CEPType66(self.CEP)
        elif nodeName_ == 'cPais':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cPais')
            value_ = self.gds_validate_string(value_, node, 'cPais')
            self.cPais = value_
            self.cPais_nsprefix_ = child_.prefix
            # validate type cPaisType67
            self.validate_cPaisType67(self.cPais)
        elif nodeName_ == 'xPais':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xPais')
            value_ = self.gds_validate_string(value_, node, 'xPais')
            self.xPais = value_
            self.xPais_nsprefix_ = child_.prefix
            # validate type xPaisType68
            self.validate_xPaisType68(self.xPais)
        elif nodeName_ == 'fone':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'fone')
            value_ = self.gds_validate_string(value_, node, 'fone')
            self.fone = value_
            self.fone_nsprefix_ = child_.prefix
            # validate type foneType69
            self.validate_foneType69(self.fone)
# end class TEnderEmi


class TLocal(GeneratedsSuper):
    """Tipo Dados do Local de Retirada ou Entrega // 24/10/08 - tamanho mínimo
    // v2.0"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('CNPJ', ['TCnpjOpc', 'xs:string'], 0, 0, {'name': 'CNPJ', 'type': 'xs:string'}, 2),
        MemberSpec_('CPF', ['TCpf', 'xs:string'], 0, 0, {'name': 'CPF', 'type': 'xs:string'}, 2),
        MemberSpec_('xNome', ['xNomeType70', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'xNome', 'type': 'xs:string'}, None),
        MemberSpec_('xLgr', ['xLgrType71', 'TString', 'xs:string'], 0, 0, {'name': 'xLgr', 'type': 'xs:string'}, None),
        MemberSpec_('nro', ['nroType72', 'TString', 'xs:string'], 0, 0, {'name': 'nro', 'type': 'xs:string'}, None),
        MemberSpec_('xCpl', ['xCplType73', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'xCpl', 'type': 'xs:string'}, None),
        MemberSpec_('xBairro', ['xBairroType74', 'TString', 'xs:string'], 0, 0, {'name': 'xBairro', 'type': 'xs:string'}, None),
        MemberSpec_('cMun', ['TCodMunIBGE', 'xs:string'], 0, 0, {'name': 'cMun', 'type': 'xs:string'}, None),
        MemberSpec_('xMun', ['xMunType75', 'TString', 'xs:string'], 0, 0, {'name': 'xMun', 'type': 'xs:string'}, None),
        MemberSpec_('UF', ['TUf', 'xs:string'], 0, 0, {'name': 'UF', 'type': 'xs:string'}, None),
        MemberSpec_('CEP', ['CEPType76', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'CEP', 'type': 'xs:string'}, None),
        MemberSpec_('cPais', ['cPaisType77', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'cPais', 'type': 'xs:string'}, None),
        MemberSpec_('xPais', ['xPaisType78', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'xPais', 'type': 'xs:string'}, None),
        MemberSpec_('fone', ['foneType79', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'fone', 'type': 'xs:string'}, None),
        MemberSpec_('email', ['emailType80', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'email', 'type': 'xs:string'}, None),
        MemberSpec_('IE', ['TIe', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'IE', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, CNPJ=None, CPF=None, xNome=None, xLgr=None, nro=None, xCpl=None, xBairro=None, cMun=None, xMun=None, UF=None, CEP=None, cPais=None, xPais=None, fone=None, email=None, IE=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.CNPJ = CNPJ
        self.validate_TCnpjOpc(self.CNPJ)
        self.CNPJ_nsprefix_ = None
        self.CPF = CPF
        self.validate_TCpf(self.CPF)
        self.CPF_nsprefix_ = None
        self.xNome = xNome
        self.validate_xNomeType70(self.xNome)
        self.xNome_nsprefix_ = None
        self.xLgr = xLgr
        self.validate_xLgrType71(self.xLgr)
        self.xLgr_nsprefix_ = None
        self.nro = nro
        self.validate_nroType72(self.nro)
        self.nro_nsprefix_ = None
        self.xCpl = xCpl
        self.validate_xCplType73(self.xCpl)
        self.xCpl_nsprefix_ = None
        self.xBairro = xBairro
        self.validate_xBairroType74(self.xBairro)
        self.xBairro_nsprefix_ = None
        self.cMun = cMun
        self.validate_TCodMunIBGE(self.cMun)
        self.cMun_nsprefix_ = None
        self.xMun = xMun
        self.validate_xMunType75(self.xMun)
        self.xMun_nsprefix_ = None
        self.UF = UF
        self.validate_TUf(self.UF)
        self.UF_nsprefix_ = None
        self.CEP = CEP
        self.validate_CEPType76(self.CEP)
        self.CEP_nsprefix_ = None
        self.cPais = cPais
        self.validate_cPaisType77(self.cPais)
        self.cPais_nsprefix_ = None
        self.xPais = xPais
        self.validate_xPaisType78(self.xPais)
        self.xPais_nsprefix_ = None
        self.fone = fone
        self.validate_foneType79(self.fone)
        self.fone_nsprefix_ = None
        self.email = email
        self.validate_emailType80(self.email)
        self.email_nsprefix_ = None
        self.IE = IE
        self.validate_TIe(self.IE)
        self.IE_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TLocal)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TLocal.subclass:
            return TLocal.subclass(*args_, **kwargs_)
        else:
            return TLocal(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TCnpjOpc(self, value):
        result = True
        # Validate type TCnpjOpc, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 14:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TCnpjOpc' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCnpjOpc_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCnpjOpc_patterns_, ))
                result = False
        return result
    validate_TCnpjOpc_patterns_ = [['^([0-9]{0}|[0-9]{14})$']]
    def validate_TCpf(self, value):
        result = True
        # Validate type TCpf, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 11:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TCpf' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCpf_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCpf_patterns_, ))
                result = False
        return result
    validate_TCpf_patterns_ = [['^([0-9]{11})$']]
    def validate_xNomeType70(self, value):
        result = True
        # Validate type xNomeType70, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xNomeType70' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xNomeType70' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xNomeType70_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xNomeType70_patterns_, ))
                result = False
        return result
    validate_xNomeType70_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_xLgrType71(self, value):
        result = True
        # Validate type xLgrType71, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xLgrType71' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xLgrType71' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xLgrType71_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xLgrType71_patterns_, ))
                result = False
        return result
    validate_xLgrType71_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_nroType72(self, value):
        result = True
        # Validate type nroType72, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on nroType72' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nroType72' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_nroType72_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nroType72_patterns_, ))
                result = False
        return result
    validate_nroType72_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_xCplType73(self, value):
        result = True
        # Validate type xCplType73, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xCplType73' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xCplType73' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xCplType73_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xCplType73_patterns_, ))
                result = False
        return result
    validate_xCplType73_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_xBairroType74(self, value):
        result = True
        # Validate type xBairroType74, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xBairroType74' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xBairroType74' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xBairroType74_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xBairroType74_patterns_, ))
                result = False
        return result
    validate_xBairroType74_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TCodMunIBGE(self, value):
        result = True
        # Validate type TCodMunIBGE, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCodMunIBGE_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCodMunIBGE_patterns_, ))
                result = False
        return result
    validate_TCodMunIBGE_patterns_ = [['^([0-9]{7})$']]
    def validate_xMunType75(self, value):
        result = True
        # Validate type xMunType75, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xMunType75' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xMunType75' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xMunType75_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xMunType75_patterns_, ))
                result = False
        return result
    validate_xMunType75_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TUf(self, value):
        result = True
        # Validate type TUf, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['AC', 'AL', 'AM', 'AP', 'BA', 'CE', 'DF', 'ES', 'GO', 'MA', 'MG', 'MS', 'MT', 'PA', 'PB', 'PE', 'PI', 'PR', 'RJ', 'RN', 'RO', 'RR', 'RS', 'SC', 'SE', 'SP', 'TO', 'EX']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TUf' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CEPType76(self, value):
        result = True
        # Validate type CEPType76, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_CEPType76_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_CEPType76_patterns_, ))
                result = False
        return result
    validate_CEPType76_patterns_ = [['^([0-9]{8})$']]
    def validate_cPaisType77(self, value):
        result = True
        # Validate type cPaisType77, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_cPaisType77_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cPaisType77_patterns_, ))
                result = False
        return result
    validate_cPaisType77_patterns_ = [['^([0-9]{1,4})$']]
    def validate_xPaisType78(self, value):
        result = True
        # Validate type xPaisType78, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xPaisType78' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xPaisType78' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xPaisType78_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xPaisType78_patterns_, ))
                result = False
        return result
    validate_xPaisType78_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_foneType79(self, value):
        result = True
        # Validate type foneType79, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_foneType79_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_foneType79_patterns_, ))
                result = False
        return result
    validate_foneType79_patterns_ = [['^([0-9]{6,14})$']]
    def validate_emailType80(self, value):
        result = True
        # Validate type emailType80, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on emailType80' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on emailType80' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_emailType80_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_emailType80_patterns_, ))
                result = False
        return result
    validate_emailType80_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TIe(self, value):
        result = True
        # Validate type TIe, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 14:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TIe' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TIe_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TIe_patterns_, ))
                result = False
        return result
    validate_TIe_patterns_ = [['^([0-9]{2,14}|ISENTO)$']]
    def hasContent_(self):
        if (
            self.CNPJ is not None or
            self.CPF is not None or
            self.xNome is not None or
            self.xLgr is not None or
            self.nro is not None or
            self.xCpl is not None or
            self.xBairro is not None or
            self.cMun is not None or
            self.xMun is not None or
            self.UF is not None or
            self.CEP is not None or
            self.cPais is not None or
            self.xPais is not None or
            self.fone is not None or
            self.email is not None or
            self.IE is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TLocal', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TLocal')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TLocal':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TLocal')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TLocal', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TLocal'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TLocal', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CNPJ is not None:
            namespaceprefix_ = self.CNPJ_nsprefix_ + ':' if (UseCapturedNS_ and self.CNPJ_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCNPJ>%s</%sCNPJ>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CNPJ), input_name='CNPJ')), namespaceprefix_ , eol_))
        if self.CPF is not None:
            namespaceprefix_ = self.CPF_nsprefix_ + ':' if (UseCapturedNS_ and self.CPF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCPF>%s</%sCPF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CPF), input_name='CPF')), namespaceprefix_ , eol_))
        if self.xNome is not None:
            namespaceprefix_ = self.xNome_nsprefix_ + ':' if (UseCapturedNS_ and self.xNome_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxNome>%s</%sxNome>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xNome), input_name='xNome')), namespaceprefix_ , eol_))
        if self.xLgr is not None:
            namespaceprefix_ = self.xLgr_nsprefix_ + ':' if (UseCapturedNS_ and self.xLgr_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxLgr>%s</%sxLgr>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xLgr), input_name='xLgr')), namespaceprefix_ , eol_))
        if self.nro is not None:
            namespaceprefix_ = self.nro_nsprefix_ + ':' if (UseCapturedNS_ and self.nro_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snro>%s</%snro>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nro), input_name='nro')), namespaceprefix_ , eol_))
        if self.xCpl is not None:
            namespaceprefix_ = self.xCpl_nsprefix_ + ':' if (UseCapturedNS_ and self.xCpl_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxCpl>%s</%sxCpl>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xCpl), input_name='xCpl')), namespaceprefix_ , eol_))
        if self.xBairro is not None:
            namespaceprefix_ = self.xBairro_nsprefix_ + ':' if (UseCapturedNS_ and self.xBairro_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxBairro>%s</%sxBairro>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xBairro), input_name='xBairro')), namespaceprefix_ , eol_))
        if self.cMun is not None:
            namespaceprefix_ = self.cMun_nsprefix_ + ':' if (UseCapturedNS_ and self.cMun_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scMun>%s</%scMun>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cMun), input_name='cMun')), namespaceprefix_ , eol_))
        if self.xMun is not None:
            namespaceprefix_ = self.xMun_nsprefix_ + ':' if (UseCapturedNS_ and self.xMun_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxMun>%s</%sxMun>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xMun), input_name='xMun')), namespaceprefix_ , eol_))
        if self.UF is not None:
            namespaceprefix_ = self.UF_nsprefix_ + ':' if (UseCapturedNS_ and self.UF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUF>%s</%sUF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.UF), input_name='UF')), namespaceprefix_ , eol_))
        if self.CEP is not None:
            namespaceprefix_ = self.CEP_nsprefix_ + ':' if (UseCapturedNS_ and self.CEP_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCEP>%s</%sCEP>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CEP), input_name='CEP')), namespaceprefix_ , eol_))
        if self.cPais is not None:
            namespaceprefix_ = self.cPais_nsprefix_ + ':' if (UseCapturedNS_ and self.cPais_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scPais>%s</%scPais>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cPais), input_name='cPais')), namespaceprefix_ , eol_))
        if self.xPais is not None:
            namespaceprefix_ = self.xPais_nsprefix_ + ':' if (UseCapturedNS_ and self.xPais_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxPais>%s</%sxPais>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xPais), input_name='xPais')), namespaceprefix_ , eol_))
        if self.fone is not None:
            namespaceprefix_ = self.fone_nsprefix_ + ':' if (UseCapturedNS_ and self.fone_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfone>%s</%sfone>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.fone), input_name='fone')), namespaceprefix_ , eol_))
        if self.email is not None:
            namespaceprefix_ = self.email_nsprefix_ + ':' if (UseCapturedNS_ and self.email_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%semail>%s</%semail>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.email), input_name='email')), namespaceprefix_ , eol_))
        if self.IE is not None:
            namespaceprefix_ = self.IE_nsprefix_ + ':' if (UseCapturedNS_ and self.IE_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIE>%s</%sIE>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.IE), input_name='IE')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CNPJ':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CNPJ')
            value_ = self.gds_validate_string(value_, node, 'CNPJ')
            self.CNPJ = value_
            self.CNPJ_nsprefix_ = child_.prefix
            # validate type TCnpjOpc
            self.validate_TCnpjOpc(self.CNPJ)
        elif nodeName_ == 'CPF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CPF')
            value_ = self.gds_validate_string(value_, node, 'CPF')
            self.CPF = value_
            self.CPF_nsprefix_ = child_.prefix
            # validate type TCpf
            self.validate_TCpf(self.CPF)
        elif nodeName_ == 'xNome':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xNome')
            value_ = self.gds_validate_string(value_, node, 'xNome')
            self.xNome = value_
            self.xNome_nsprefix_ = child_.prefix
            # validate type xNomeType70
            self.validate_xNomeType70(self.xNome)
        elif nodeName_ == 'xLgr':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xLgr')
            value_ = self.gds_validate_string(value_, node, 'xLgr')
            self.xLgr = value_
            self.xLgr_nsprefix_ = child_.prefix
            # validate type xLgrType71
            self.validate_xLgrType71(self.xLgr)
        elif nodeName_ == 'nro':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nro')
            value_ = self.gds_validate_string(value_, node, 'nro')
            self.nro = value_
            self.nro_nsprefix_ = child_.prefix
            # validate type nroType72
            self.validate_nroType72(self.nro)
        elif nodeName_ == 'xCpl':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xCpl')
            value_ = self.gds_validate_string(value_, node, 'xCpl')
            self.xCpl = value_
            self.xCpl_nsprefix_ = child_.prefix
            # validate type xCplType73
            self.validate_xCplType73(self.xCpl)
        elif nodeName_ == 'xBairro':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xBairro')
            value_ = self.gds_validate_string(value_, node, 'xBairro')
            self.xBairro = value_
            self.xBairro_nsprefix_ = child_.prefix
            # validate type xBairroType74
            self.validate_xBairroType74(self.xBairro)
        elif nodeName_ == 'cMun':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cMun')
            value_ = self.gds_validate_string(value_, node, 'cMun')
            self.cMun = value_
            self.cMun_nsprefix_ = child_.prefix
            # validate type TCodMunIBGE
            self.validate_TCodMunIBGE(self.cMun)
        elif nodeName_ == 'xMun':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xMun')
            value_ = self.gds_validate_string(value_, node, 'xMun')
            self.xMun = value_
            self.xMun_nsprefix_ = child_.prefix
            # validate type xMunType75
            self.validate_xMunType75(self.xMun)
        elif nodeName_ == 'UF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'UF')
            value_ = self.gds_validate_string(value_, node, 'UF')
            self.UF = value_
            self.UF_nsprefix_ = child_.prefix
            # validate type TUf
            self.validate_TUf(self.UF)
        elif nodeName_ == 'CEP':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CEP')
            value_ = self.gds_validate_string(value_, node, 'CEP')
            self.CEP = value_
            self.CEP_nsprefix_ = child_.prefix
            # validate type CEPType76
            self.validate_CEPType76(self.CEP)
        elif nodeName_ == 'cPais':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cPais')
            value_ = self.gds_validate_string(value_, node, 'cPais')
            self.cPais = value_
            self.cPais_nsprefix_ = child_.prefix
            # validate type cPaisType77
            self.validate_cPaisType77(self.cPais)
        elif nodeName_ == 'xPais':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xPais')
            value_ = self.gds_validate_string(value_, node, 'xPais')
            self.xPais = value_
            self.xPais_nsprefix_ = child_.prefix
            # validate type xPaisType78
            self.validate_xPaisType78(self.xPais)
        elif nodeName_ == 'fone':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'fone')
            value_ = self.gds_validate_string(value_, node, 'fone')
            self.fone = value_
            self.fone_nsprefix_ = child_.prefix
            # validate type foneType79
            self.validate_foneType79(self.fone)
        elif nodeName_ == 'email':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'email')
            value_ = self.gds_validate_string(value_, node, 'email')
            self.email = value_
            self.email_nsprefix_ = child_.prefix
            # validate type emailType80
            self.validate_emailType80(self.email)
        elif nodeName_ == 'IE':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'IE')
            value_ = self.gds_validate_string(value_, node, 'IE')
            self.IE = value_
            self.IE_nsprefix_ = child_.prefix
            # validate type TIe
            self.validate_TIe(self.IE)
# end class TLocal


class TInfRespTec(GeneratedsSuper):
    """Grupo de informações do responsável técnico pelo sistema de emissão de
    DF-e"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('CNPJ', ['TCnpjOpc', 'xs:string'], 0, 0, {'name': 'CNPJ', 'type': 'xs:string'}, None),
        MemberSpec_('xContato', ['xContatoType', 'TString', 'xs:string'], 0, 0, {'name': 'xContato', 'type': 'xs:string'}, None),
        MemberSpec_('email', ['emailType81', 'TString', 'xs:string'], 0, 0, {'name': 'email', 'type': 'xs:string'}, None),
        MemberSpec_('fone', ['foneType82', 'xs:string'], 0, 0, {'name': 'fone', 'type': 'xs:string'}, None),
        MemberSpec_('idCSRT', ['idCSRTType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'idCSRT', 'type': 'xs:string'}, None),
        MemberSpec_('hashCSRT', ['hashCSRTType', 'xs:base64Binary'], 0, 1, {'minOccurs': '0', 'name': 'hashCSRT', 'type': 'xs:base64Binary'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, CNPJ=None, xContato=None, email=None, fone=None, idCSRT=None, hashCSRT=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.CNPJ = CNPJ
        self.validate_TCnpjOpc(self.CNPJ)
        self.CNPJ_nsprefix_ = None
        self.xContato = xContato
        self.validate_xContatoType(self.xContato)
        self.xContato_nsprefix_ = None
        self.email = email
        self.validate_emailType81(self.email)
        self.email_nsprefix_ = None
        self.fone = fone
        self.validate_foneType82(self.fone)
        self.fone_nsprefix_ = None
        self.idCSRT = idCSRT
        self.validate_idCSRTType(self.idCSRT)
        self.idCSRT_nsprefix_ = None
        self.hashCSRT = hashCSRT
        self.validate_hashCSRTType(self.hashCSRT)
        self.hashCSRT_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TInfRespTec)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TInfRespTec.subclass:
            return TInfRespTec.subclass(*args_, **kwargs_)
        else:
            return TInfRespTec(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TCnpjOpc(self, value):
        result = True
        # Validate type TCnpjOpc, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 14:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TCnpjOpc' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCnpjOpc_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCnpjOpc_patterns_, ))
                result = False
        return result
    validate_TCnpjOpc_patterns_ = [['^([0-9]{0}|[0-9]{14})$']]
    def validate_xContatoType(self, value):
        result = True
        # Validate type xContatoType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xContatoType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xContatoType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xContatoType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xContatoType_patterns_, ))
                result = False
        return result
    validate_xContatoType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_emailType81(self, value):
        result = True
        # Validate type emailType81, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on emailType81' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 6:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on emailType81' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_emailType81_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_emailType81_patterns_, ))
                result = False
        return result
    validate_emailType81_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_foneType82(self, value):
        result = True
        # Validate type foneType82, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_foneType82_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_foneType82_patterns_, ))
                result = False
        return result
    validate_foneType82_patterns_ = [['^([0-9]{6,14})$']]
    def validate_idCSRTType(self, value):
        result = True
        # Validate type idCSRTType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_idCSRTType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_idCSRTType_patterns_, ))
                result = False
        return result
    validate_idCSRTType_patterns_ = [['^([0-9]{2})$']]
    def validate_hashCSRTType(self, value):
        result = True
        # Validate type hashCSRTType, a restriction on xs:base64Binary.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if len(value) != 20:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on hashCSRTType' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def hasContent_(self):
        if (
            self.CNPJ is not None or
            self.xContato is not None or
            self.email is not None or
            self.fone is not None or
            self.idCSRT is not None or
            self.hashCSRT is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TInfRespTec', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TInfRespTec')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TInfRespTec':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TInfRespTec')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TInfRespTec', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TInfRespTec'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TInfRespTec', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CNPJ is not None:
            namespaceprefix_ = self.CNPJ_nsprefix_ + ':' if (UseCapturedNS_ and self.CNPJ_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCNPJ>%s</%sCNPJ>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CNPJ), input_name='CNPJ')), namespaceprefix_ , eol_))
        if self.xContato is not None:
            namespaceprefix_ = self.xContato_nsprefix_ + ':' if (UseCapturedNS_ and self.xContato_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxContato>%s</%sxContato>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xContato), input_name='xContato')), namespaceprefix_ , eol_))
        if self.email is not None:
            namespaceprefix_ = self.email_nsprefix_ + ':' if (UseCapturedNS_ and self.email_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%semail>%s</%semail>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.email), input_name='email')), namespaceprefix_ , eol_))
        if self.fone is not None:
            namespaceprefix_ = self.fone_nsprefix_ + ':' if (UseCapturedNS_ and self.fone_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfone>%s</%sfone>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.fone), input_name='fone')), namespaceprefix_ , eol_))
        if self.idCSRT is not None:
            namespaceprefix_ = self.idCSRT_nsprefix_ + ':' if (UseCapturedNS_ and self.idCSRT_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sidCSRT>%s</%sidCSRT>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.idCSRT), input_name='idCSRT')), namespaceprefix_ , eol_))
        if self.hashCSRT is not None:
            namespaceprefix_ = self.hashCSRT_nsprefix_ + ':' if (UseCapturedNS_ and self.hashCSRT_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%shashCSRT>%s</%shashCSRT>%s' % (namespaceprefix_ , self.gds_format_base64(self.hashCSRT, input_name='hashCSRT'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CNPJ':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CNPJ')
            value_ = self.gds_validate_string(value_, node, 'CNPJ')
            self.CNPJ = value_
            self.CNPJ_nsprefix_ = child_.prefix
            # validate type TCnpjOpc
            self.validate_TCnpjOpc(self.CNPJ)
        elif nodeName_ == 'xContato':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xContato')
            value_ = self.gds_validate_string(value_, node, 'xContato')
            self.xContato = value_
            self.xContato_nsprefix_ = child_.prefix
            # validate type xContatoType
            self.validate_xContatoType(self.xContato)
        elif nodeName_ == 'email':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'email')
            value_ = self.gds_validate_string(value_, node, 'email')
            self.email = value_
            self.email_nsprefix_ = child_.prefix
            # validate type emailType81
            self.validate_emailType81(self.email)
        elif nodeName_ == 'fone':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'fone')
            value_ = self.gds_validate_string(value_, node, 'fone')
            self.fone = value_
            self.fone_nsprefix_ = child_.prefix
            # validate type foneType82
            self.validate_foneType82(self.fone)
        elif nodeName_ == 'idCSRT':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'idCSRT')
            value_ = self.gds_validate_string(value_, node, 'idCSRT')
            self.idCSRT = value_
            self.idCSRT_nsprefix_ = child_.prefix
            # validate type idCSRTType
            self.validate_idCSRTType(self.idCSRT)
        elif nodeName_ == 'hashCSRT':
            sval_ = child_.text
            if sval_ is not None:
                try:
                    bval_ = base64.b64decode(sval_)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(child_, 'requires base64 encoded string: %s' % exp)
                bval_ = self.gds_validate_base64(bval_, node, 'hashCSRT')
            else:
                bval_ = None
            self.hashCSRT = bval_
            self.hashCSRT_nsprefix_ = child_.prefix
            # validate type hashCSRTType
            self.validate_hashCSRTType(self.hashCSRT)
# end class TInfRespTec


class TVeiculo(GeneratedsSuper):
    """Tipo Dados do Veículo"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('placa', ['placaType', 'xs:string'], 0, 0, {'name': 'placa', 'type': 'xs:string'}, None),
        MemberSpec_('UF', ['TUf', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'UF', 'type': 'xs:string'}, None),
        MemberSpec_('RNTC', ['RNTCType', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'RNTC', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, placa=None, UF=None, RNTC=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.placa = placa
        self.validate_placaType(self.placa)
        self.placa_nsprefix_ = None
        self.UF = UF
        self.validate_TUf(self.UF)
        self.UF_nsprefix_ = None
        self.RNTC = RNTC
        self.validate_RNTCType(self.RNTC)
        self.RNTC_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TVeiculo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TVeiculo.subclass:
            return TVeiculo.subclass(*args_, **kwargs_)
        else:
            return TVeiculo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_placaType(self, value):
        result = True
        # Validate type placaType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_placaType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_placaType_patterns_, ))
                result = False
        return result
    validate_placaType_patterns_ = [['^([A-Z]{2,3}[0-9]{4}|[A-Z]{3,4}[0-9]{3}|[A-Z0-9]{7})$']]
    def validate_TUf(self, value):
        result = True
        # Validate type TUf, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['AC', 'AL', 'AM', 'AP', 'BA', 'CE', 'DF', 'ES', 'GO', 'MA', 'MG', 'MS', 'MT', 'PA', 'PB', 'PE', 'PI', 'PR', 'RJ', 'RN', 'RO', 'RR', 'RS', 'SC', 'SE', 'SP', 'TO', 'EX']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TUf' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_RNTCType(self, value):
        result = True
        # Validate type RNTCType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 20:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on RNTCType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on RNTCType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_RNTCType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_RNTCType_patterns_, ))
                result = False
        return result
    validate_RNTCType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def hasContent_(self):
        if (
            self.placa is not None or
            self.UF is not None or
            self.RNTC is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TVeiculo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TVeiculo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TVeiculo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TVeiculo')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TVeiculo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TVeiculo'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TVeiculo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.placa is not None:
            namespaceprefix_ = self.placa_nsprefix_ + ':' if (UseCapturedNS_ and self.placa_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%splaca>%s</%splaca>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.placa), input_name='placa')), namespaceprefix_ , eol_))
        if self.UF is not None:
            namespaceprefix_ = self.UF_nsprefix_ + ':' if (UseCapturedNS_ and self.UF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUF>%s</%sUF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.UF), input_name='UF')), namespaceprefix_ , eol_))
        if self.RNTC is not None:
            namespaceprefix_ = self.RNTC_nsprefix_ + ':' if (UseCapturedNS_ and self.RNTC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sRNTC>%s</%sRNTC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.RNTC), input_name='RNTC')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'placa':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'placa')
            value_ = self.gds_validate_string(value_, node, 'placa')
            self.placa = value_
            self.placa_nsprefix_ = child_.prefix
            # validate type placaType
            self.validate_placaType(self.placa)
        elif nodeName_ == 'UF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'UF')
            value_ = self.gds_validate_string(value_, node, 'UF')
            self.UF = value_
            self.UF_nsprefix_ = child_.prefix
            # validate type TUf
            self.validate_TUf(self.UF)
        elif nodeName_ == 'RNTC':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'RNTC')
            value_ = self.gds_validate_string(value_, node, 'RNTC')
            self.RNTC = value_
            self.RNTC_nsprefix_ = child_.prefix
            # validate type RNTCType
            self.validate_RNTCType(self.RNTC)
# end class TVeiculo


class TIpi(GeneratedsSuper):
    """Tipo: Dados do IPI"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('CNPJProd', ['TCnpj', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'CNPJProd', 'type': 'xs:string'}, None),
        MemberSpec_('cSelo', ['cSeloType', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'cSelo', 'type': 'xs:string'}, None),
        MemberSpec_('qSelo', ['qSeloType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'qSelo', 'type': 'xs:string'}, None),
        MemberSpec_('cEnq', ['cEnqType', 'TString', 'xs:string'], 0, 0, {'name': 'cEnq', 'type': 'xs:string'}, None),
        MemberSpec_('IPITrib', 'IPITribType', 0, 0, {'name': 'IPITrib', 'type': 'IPITribType'}, 3),
        MemberSpec_('IPINT', 'IPINTType', 0, 0, {'name': 'IPINT', 'type': 'IPINTType'}, 3),
    ]
    subclass = None
    superclass = None
    def __init__(self, CNPJProd=None, cSelo=None, qSelo=None, cEnq=None, IPITrib=None, IPINT=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.CNPJProd = CNPJProd
        self.validate_TCnpj(self.CNPJProd)
        self.CNPJProd_nsprefix_ = None
        self.cSelo = cSelo
        self.validate_cSeloType(self.cSelo)
        self.cSelo_nsprefix_ = None
        self.qSelo = qSelo
        self.validate_qSeloType(self.qSelo)
        self.qSelo_nsprefix_ = None
        self.cEnq = cEnq
        self.validate_cEnqType(self.cEnq)
        self.cEnq_nsprefix_ = None
        self.IPITrib = IPITrib
        self.IPITrib_nsprefix_ = None
        self.IPINT = IPINT
        self.IPINT_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TIpi)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TIpi.subclass:
            return TIpi.subclass(*args_, **kwargs_)
        else:
            return TIpi(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TCnpj(self, value):
        result = True
        # Validate type TCnpj, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 14:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TCnpj' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCnpj_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCnpj_patterns_, ))
                result = False
        return result
    validate_TCnpj_patterns_ = [['^([0-9]{14})$']]
    def validate_cSeloType(self, value):
        result = True
        # Validate type cSeloType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on cSeloType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on cSeloType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_cSeloType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cSeloType_patterns_, ))
                result = False
        return result
    validate_cSeloType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_qSeloType(self, value):
        result = True
        # Validate type qSeloType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_qSeloType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_qSeloType_patterns_, ))
                result = False
        return result
    validate_qSeloType_patterns_ = [['^([0-9]{1,12})$']]
    def validate_cEnqType(self, value):
        result = True
        # Validate type cEnqType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on cEnqType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on cEnqType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_cEnqType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cEnqType_patterns_, ))
                result = False
        return result
    validate_cEnqType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def hasContent_(self):
        if (
            self.CNPJProd is not None or
            self.cSelo is not None or
            self.qSelo is not None or
            self.cEnq is not None or
            self.IPITrib is not None or
            self.IPINT is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TIpi', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TIpi')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TIpi':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TIpi')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TIpi', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TIpi'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TIpi', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CNPJProd is not None:
            namespaceprefix_ = self.CNPJProd_nsprefix_ + ':' if (UseCapturedNS_ and self.CNPJProd_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCNPJProd>%s</%sCNPJProd>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CNPJProd), input_name='CNPJProd')), namespaceprefix_ , eol_))
        if self.cSelo is not None:
            namespaceprefix_ = self.cSelo_nsprefix_ + ':' if (UseCapturedNS_ and self.cSelo_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scSelo>%s</%scSelo>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cSelo), input_name='cSelo')), namespaceprefix_ , eol_))
        if self.qSelo is not None:
            namespaceprefix_ = self.qSelo_nsprefix_ + ':' if (UseCapturedNS_ and self.qSelo_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sqSelo>%s</%sqSelo>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.qSelo), input_name='qSelo')), namespaceprefix_ , eol_))
        if self.cEnq is not None:
            namespaceprefix_ = self.cEnq_nsprefix_ + ':' if (UseCapturedNS_ and self.cEnq_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scEnq>%s</%scEnq>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cEnq), input_name='cEnq')), namespaceprefix_ , eol_))
        if self.IPITrib is not None:
            namespaceprefix_ = self.IPITrib_nsprefix_ + ':' if (UseCapturedNS_ and self.IPITrib_nsprefix_) else ''
            self.IPITrib.export(outfile, level, namespaceprefix_, namespacedef_='', name_='IPITrib', pretty_print=pretty_print)
        if self.IPINT is not None:
            namespaceprefix_ = self.IPINT_nsprefix_ + ':' if (UseCapturedNS_ and self.IPINT_nsprefix_) else ''
            self.IPINT.export(outfile, level, namespaceprefix_, namespacedef_='', name_='IPINT', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CNPJProd':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CNPJProd')
            value_ = self.gds_validate_string(value_, node, 'CNPJProd')
            self.CNPJProd = value_
            self.CNPJProd_nsprefix_ = child_.prefix
            # validate type TCnpj
            self.validate_TCnpj(self.CNPJProd)
        elif nodeName_ == 'cSelo':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cSelo')
            value_ = self.gds_validate_string(value_, node, 'cSelo')
            self.cSelo = value_
            self.cSelo_nsprefix_ = child_.prefix
            # validate type cSeloType
            self.validate_cSeloType(self.cSelo)
        elif nodeName_ == 'qSelo':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'qSelo')
            value_ = self.gds_validate_string(value_, node, 'qSelo')
            self.qSelo = value_
            self.qSelo_nsprefix_ = child_.prefix
            # validate type qSeloType
            self.validate_qSeloType(self.qSelo)
        elif nodeName_ == 'cEnq':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cEnq')
            value_ = self.gds_validate_string(value_, node, 'cEnq')
            self.cEnq = value_
            self.cEnq_nsprefix_ = child_.prefix
            # validate type cEnqType
            self.validate_cEnqType(self.cEnq)
        elif nodeName_ == 'IPITrib':
            obj_ = IPITribType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.IPITrib = obj_
            obj_.original_tagname_ = 'IPITrib'
        elif nodeName_ == 'IPINT':
            obj_ = IPINTType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.IPINT = obj_
            obj_.original_tagname_ = 'IPINT'
# end class TIpi


class SignatureType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('Id', 'ID', 0, 1, {'use': 'optional'}),
        MemberSpec_('SignedInfo', 'SignedInfoType', 0, 0, {'name': 'SignedInfo', 'type': 'SignedInfoType'}, None),
        MemberSpec_('SignatureValue', 'SignatureValueType', 0, 0, {'name': 'SignatureValue', 'type': 'SignatureValueType'}, None),
        MemberSpec_('KeyInfo', 'KeyInfoType', 0, 0, {'name': 'KeyInfo', 'type': 'KeyInfoType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, Id=None, SignedInfo=None, SignatureValue=None, KeyInfo=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Id = _cast(None, Id)
        self.Id_nsprefix_ = None
        self.SignedInfo = SignedInfo
        self.SignedInfo_nsprefix_ = "ds"
        self.SignatureValue = SignatureValue
        self.SignatureValue_nsprefix_ = "ds"
        self.KeyInfo = KeyInfo
        self.KeyInfo_nsprefix_ = "ds"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SignatureType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SignatureType.subclass:
            return SignatureType.subclass(*args_, **kwargs_)
        else:
            return SignatureType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.SignedInfo is not None or
            self.SignatureValue is not None or
            self.KeyInfo is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='SignatureType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SignatureType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SignatureType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SignatureType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SignatureType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ds:', name_='SignatureType'):
        if self.Id is not None and 'Id' not in already_processed:
            already_processed.add('Id')
            outfile.write(' Id=%s' % (quote_attrib(self.Id), ))
    def exportChildren(self, outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='SignatureType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.SignedInfo is not None:
            namespaceprefix_ = self.SignedInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.SignedInfo_nsprefix_) else ''
            self.SignedInfo.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SignedInfo', pretty_print=pretty_print)
        if self.SignatureValue is not None:
            namespaceprefix_ = self.SignatureValue_nsprefix_ + ':' if (UseCapturedNS_ and self.SignatureValue_nsprefix_) else ''
            self.SignatureValue.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SignatureValue', pretty_print=pretty_print)
        if self.KeyInfo is not None:
            namespaceprefix_ = self.KeyInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.KeyInfo_nsprefix_) else ''
            self.KeyInfo.export(outfile, level, namespaceprefix_, namespacedef_='', name_='KeyInfo', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('Id', node)
        if value is not None and 'Id' not in already_processed:
            already_processed.add('Id')
            self.Id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'SignedInfo':
            obj_ = SignedInfoType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SignedInfo = obj_
            obj_.original_tagname_ = 'SignedInfo'
        elif nodeName_ == 'SignatureValue':
            obj_ = SignatureValueType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SignatureValue = obj_
            obj_.original_tagname_ = 'SignatureValue'
        elif nodeName_ == 'KeyInfo':
            obj_ = KeyInfoType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.KeyInfo = obj_
            obj_.original_tagname_ = 'KeyInfo'
# end class SignatureType


class SignatureValueType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('Id', 'ID', 0, 1, {'use': 'optional'}),
        MemberSpec_('valueOf_', 'base64Binary', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, Id=None, valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Id = _cast(None, Id)
        self.Id_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SignatureValueType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SignatureValueType.subclass:
            return SignatureValueType.subclass(*args_, **kwargs_)
        else:
            return SignatureValueType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='SignatureValueType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SignatureValueType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SignatureValueType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SignatureValueType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SignatureValueType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ds:', name_='SignatureValueType'):
        if self.Id is not None and 'Id' not in already_processed:
            already_processed.add('Id')
            outfile.write(' Id=%s' % (quote_attrib(self.Id), ))
    def exportChildren(self, outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='SignatureValueType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('Id', node)
        if value is not None and 'Id' not in already_processed:
            already_processed.add('Id')
            self.Id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class SignatureValueType


class SignedInfoType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('Id', 'ID', 0, 1, {'use': 'optional'}),
        MemberSpec_('CanonicalizationMethod', 'CanonicalizationMethodType', 0, 0, {'name': 'CanonicalizationMethod', 'type': 'CanonicalizationMethodType'}, None),
        MemberSpec_('SignatureMethod', 'SignatureMethodType', 0, 0, {'name': 'SignatureMethod', 'type': 'SignatureMethodType'}, None),
        MemberSpec_('Reference', 'ReferenceType', 0, 0, {'name': 'Reference', 'type': 'ReferenceType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, Id=None, CanonicalizationMethod=None, SignatureMethod=None, Reference=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Id = _cast(None, Id)
        self.Id_nsprefix_ = None
        self.CanonicalizationMethod = CanonicalizationMethod
        self.CanonicalizationMethod_nsprefix_ = None
        self.SignatureMethod = SignatureMethod
        self.SignatureMethod_nsprefix_ = None
        self.Reference = Reference
        self.Reference_nsprefix_ = "ds"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SignedInfoType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SignedInfoType.subclass:
            return SignedInfoType.subclass(*args_, **kwargs_)
        else:
            return SignedInfoType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.CanonicalizationMethod is not None or
            self.SignatureMethod is not None or
            self.Reference is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='SignedInfoType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SignedInfoType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SignedInfoType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SignedInfoType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SignedInfoType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ds:', name_='SignedInfoType'):
        if self.Id is not None and 'Id' not in already_processed:
            already_processed.add('Id')
            outfile.write(' Id=%s' % (quote_attrib(self.Id), ))
    def exportChildren(self, outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='SignedInfoType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CanonicalizationMethod is not None:
            namespaceprefix_ = self.CanonicalizationMethod_nsprefix_ + ':' if (UseCapturedNS_ and self.CanonicalizationMethod_nsprefix_) else ''
            self.CanonicalizationMethod.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CanonicalizationMethod', pretty_print=pretty_print)
        if self.SignatureMethod is not None:
            namespaceprefix_ = self.SignatureMethod_nsprefix_ + ':' if (UseCapturedNS_ and self.SignatureMethod_nsprefix_) else ''
            self.SignatureMethod.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SignatureMethod', pretty_print=pretty_print)
        if self.Reference is not None:
            namespaceprefix_ = self.Reference_nsprefix_ + ':' if (UseCapturedNS_ and self.Reference_nsprefix_) else ''
            self.Reference.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Reference', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('Id', node)
        if value is not None and 'Id' not in already_processed:
            already_processed.add('Id')
            self.Id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CanonicalizationMethod':
            obj_ = CanonicalizationMethodType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CanonicalizationMethod = obj_
            obj_.original_tagname_ = 'CanonicalizationMethod'
        elif nodeName_ == 'SignatureMethod':
            obj_ = SignatureMethodType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SignatureMethod = obj_
            obj_.original_tagname_ = 'SignatureMethod'
        elif nodeName_ == 'Reference':
            obj_ = ReferenceType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Reference = obj_
            obj_.original_tagname_ = 'Reference'
# end class SignedInfoType


class ReferenceType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('Id', 'ID', 0, 1, {'use': 'optional'}),
        MemberSpec_('URI', 'URIType', 0, 0, {'use': 'required'}),
        MemberSpec_('Type', 'anyURI', 0, 1, {'use': 'optional'}),
        MemberSpec_('Transforms', 'TransformsType', 0, 0, {'name': 'Transforms', 'type': 'TransformsType'}, None),
        MemberSpec_('DigestMethod', 'DigestMethodType', 0, 0, {'name': 'DigestMethod', 'type': 'DigestMethodType'}, None),
        MemberSpec_('DigestValue', ['DigestValueType', 'base64Binary'], 0, 0, {'name': 'DigestValue', 'type': 'xs:base64Binary'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, Id=None, URI=None, Type=None, Transforms=None, DigestMethod=None, DigestValue=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Id = _cast(None, Id)
        self.Id_nsprefix_ = None
        self.URI = _cast(None, URI)
        self.URI_nsprefix_ = None
        self.Type = _cast(None, Type)
        self.Type_nsprefix_ = None
        self.Transforms = Transforms
        self.Transforms_nsprefix_ = "ds"
        self.DigestMethod = DigestMethod
        self.DigestMethod_nsprefix_ = None
        self.DigestValue = DigestValue
        self.validate_DigestValueType(self.DigestValue)
        self.DigestValue_nsprefix_ = "ds"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ReferenceType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ReferenceType.subclass:
            return ReferenceType.subclass(*args_, **kwargs_)
        else:
            return ReferenceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_DigestValueType(self, value):
        result = True
        # Validate type DigestValueType, a restriction on base64Binary.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            pass
        return result
    def validate_URIType(self, value):
        # Validate type URIType, a restriction on anyURI.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on URIType' % {"value" : value, "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            self.Transforms is not None or
            self.DigestMethod is not None or
            self.DigestValue is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='ReferenceType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ReferenceType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ReferenceType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ReferenceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ReferenceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ds:', name_='ReferenceType'):
        if self.Id is not None and 'Id' not in already_processed:
            already_processed.add('Id')
            outfile.write(' Id=%s' % (quote_attrib(self.Id), ))
        if self.URI is not None and 'URI' not in already_processed:
            already_processed.add('URI')
            outfile.write(' URI=%s' % (quote_attrib(self.URI), ))
        if self.Type is not None and 'Type' not in already_processed:
            already_processed.add('Type')
            outfile.write(' Type=%s' % (quote_attrib(self.Type), ))
    def exportChildren(self, outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='ReferenceType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Transforms is not None:
            namespaceprefix_ = self.Transforms_nsprefix_ + ':' if (UseCapturedNS_ and self.Transforms_nsprefix_) else ''
            self.Transforms.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Transforms', pretty_print=pretty_print)
        if self.DigestMethod is not None:
            namespaceprefix_ = self.DigestMethod_nsprefix_ + ':' if (UseCapturedNS_ and self.DigestMethod_nsprefix_) else ''
            self.DigestMethod.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DigestMethod', pretty_print=pretty_print)
        if self.DigestValue is not None:
            namespaceprefix_ = self.DigestValue_nsprefix_ + ':' if (UseCapturedNS_ and self.DigestValue_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDigestValue>%s</%sDigestValue>%s' % (namespaceprefix_ , self.gds_format_base64(self.DigestValue, input_name='DigestValue'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('Id', node)
        if value is not None and 'Id' not in already_processed:
            already_processed.add('Id')
            self.Id = value
        value = find_attr_value_('URI', node)
        if value is not None and 'URI' not in already_processed:
            already_processed.add('URI')
            self.URI = value
            self.validate_URIType(self.URI)    # validate type URIType
        value = find_attr_value_('Type', node)
        if value is not None and 'Type' not in already_processed:
            already_processed.add('Type')
            self.Type = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Transforms':
            obj_ = TransformsType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Transforms = obj_
            obj_.original_tagname_ = 'Transforms'
        elif nodeName_ == 'DigestMethod':
            obj_ = DigestMethodType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DigestMethod = obj_
            obj_.original_tagname_ = 'DigestMethod'
        elif nodeName_ == 'DigestValue':
            sval_ = child_.text
            if sval_ is not None:
                try:
                    bval_ = base64.b64decode(sval_)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(child_, 'requires base64 encoded string: %s' % exp)
                bval_ = self.gds_validate_base64(bval_, node, 'DigestValue')
            else:
                bval_ = None
            self.DigestValue = bval_
            self.DigestValue_nsprefix_ = child_.prefix
            # validate type DigestValueType
            self.validate_DigestValueType(self.DigestValue)
# end class ReferenceType


class TransformsType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('Transform', 'TransformType', 1, 0, {'maxOccurs': '2', 'minOccurs': '2', 'name': 'Transform', 'type': 'TransformType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, Transform=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if Transform is None:
            self.Transform = []
        else:
            self.Transform = Transform
        self.Transform_nsprefix_ = "ds"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TransformsType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TransformsType.subclass:
            return TransformsType.subclass(*args_, **kwargs_)
        else:
            return TransformsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.Transform
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='TransformsType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TransformsType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TransformsType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TransformsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TransformsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ds:', name_='TransformsType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='TransformsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Transform_ in self.Transform:
            namespaceprefix_ = self.Transform_nsprefix_ + ':' if (UseCapturedNS_ and self.Transform_nsprefix_) else ''
            Transform_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Transform', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Transform':
            obj_ = TransformType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Transform.append(obj_)
            obj_.original_tagname_ = 'Transform'
# end class TransformsType


class TransformType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('Algorithm', 'ds:TTransformURI', 0, 0, {'use': 'required'}),
        MemberSpec_('XPath', 'xs:string', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'XPath', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, Algorithm=None, XPath=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Algorithm = _cast(None, Algorithm)
        self.Algorithm_nsprefix_ = None
        if XPath is None:
            self.XPath = []
        else:
            self.XPath = XPath
        self.XPath_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TransformType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TransformType.subclass:
            return TransformType.subclass(*args_, **kwargs_)
        else:
            return TransformType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TTransformURI(self, value):
        # Validate type ds:TTransformURI, a restriction on anyURI.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['http://www.w3.org/2000/09/xmldsig#enveloped-signature', 'http://www.w3.org/TR/2001/REC-xml-c14n-20010315']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TTransformURI' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            self.XPath
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='TransformType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TransformType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TransformType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TransformType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TransformType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ds:', name_='TransformType'):
        if self.Algorithm is not None and 'Algorithm' not in already_processed:
            already_processed.add('Algorithm')
            outfile.write(' Algorithm=%s' % (quote_attrib(self.Algorithm), ))
    def exportChildren(self, outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='TransformType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for XPath_ in self.XPath:
            namespaceprefix_ = self.XPath_nsprefix_ + ':' if (UseCapturedNS_ and self.XPath_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sXPath>%s</%sXPath>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(XPath_), input_name='XPath')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('Algorithm', node)
        if value is not None and 'Algorithm' not in already_processed:
            already_processed.add('Algorithm')
            self.Algorithm = value
            self.validate_TTransformURI(self.Algorithm)    # validate type TTransformURI
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'XPath':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'XPath')
            value_ = self.gds_validate_string(value_, node, 'XPath')
            self.XPath.append(value_)
            self.XPath_nsprefix_ = child_.prefix
# end class TransformType


class KeyInfoType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('Id', 'ID', 0, 1, {'use': 'optional'}),
        MemberSpec_('X509Data', 'X509DataType', 0, 0, {'name': 'X509Data', 'type': 'X509DataType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, Id=None, X509Data=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Id = _cast(None, Id)
        self.Id_nsprefix_ = None
        self.X509Data = X509Data
        self.X509Data_nsprefix_ = "ds"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, KeyInfoType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if KeyInfoType.subclass:
            return KeyInfoType.subclass(*args_, **kwargs_)
        else:
            return KeyInfoType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.X509Data is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='KeyInfoType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('KeyInfoType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'KeyInfoType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='KeyInfoType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='KeyInfoType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ds:', name_='KeyInfoType'):
        if self.Id is not None and 'Id' not in already_processed:
            already_processed.add('Id')
            outfile.write(' Id=%s' % (quote_attrib(self.Id), ))
    def exportChildren(self, outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='KeyInfoType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.X509Data is not None:
            namespaceprefix_ = self.X509Data_nsprefix_ + ':' if (UseCapturedNS_ and self.X509Data_nsprefix_) else ''
            self.X509Data.export(outfile, level, namespaceprefix_, namespacedef_='', name_='X509Data', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('Id', node)
        if value is not None and 'Id' not in already_processed:
            already_processed.add('Id')
            self.Id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'X509Data':
            obj_ = X509DataType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.X509Data = obj_
            obj_.original_tagname_ = 'X509Data'
# end class KeyInfoType


class X509DataType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('X509Certificate', 'xs:string', 0, 0, {'name': 'X509Certificate', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, X509Certificate=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.X509Certificate = X509Certificate
        self.X509Certificate_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, X509DataType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if X509DataType.subclass:
            return X509DataType.subclass(*args_, **kwargs_)
        else:
            return X509DataType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.X509Certificate is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='X509DataType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('X509DataType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'X509DataType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='X509DataType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='X509DataType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='ds:', name_='X509DataType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='ds:', namespacedef_='', name_='X509DataType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.X509Certificate is not None:
            namespaceprefix_ = self.X509Certificate_nsprefix_ + ':' if (UseCapturedNS_ and self.X509Certificate_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sX509Certificate>%s</%sX509Certificate>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.X509Certificate), input_name='X509Certificate')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'X509Certificate':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'X509Certificate')
            value_ = self.gds_validate_string(value_, node, 'X509Certificate')
            self.X509Certificate = value_
            self.X509Certificate_nsprefix_ = child_.prefix
# end class X509DataType


class infNFeType(GeneratedsSuper):
    """Informações da Nota Fiscal eletrônicaVersão do leiaute (v4.00)PL_005d -
    11/08/09 - validação do Id"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('versao', 'TVerNFe', 0, 0, {'use': 'required'}),
        MemberSpec_('Id', 'IdType', 0, 0, {'use': 'required'}),
        MemberSpec_('ide', 'ideType', 0, 0, {'name': 'ide', 'type': 'ideType'}, None),
        MemberSpec_('emit', 'emitType', 0, 0, {'name': 'emit', 'type': 'emitType'}, None),
        MemberSpec_('avulsa', 'avulsaType', 0, 1, {'minOccurs': '0', 'name': 'avulsa', 'type': 'avulsaType'}, None),
        MemberSpec_('dest', 'destType', 0, 1, {'minOccurs': '0', 'name': 'dest', 'type': 'destType'}, None),
        MemberSpec_('retirada', 'TLocal', 0, 1, {'minOccurs': '0', 'name': 'retirada', 'type': 'TLocal'}, None),
        MemberSpec_('entrega', 'TLocal', 0, 1, {'minOccurs': '0', 'name': 'entrega', 'type': 'TLocal'}, None),
        MemberSpec_('autXML', 'autXMLType', 1, 1, {'maxOccurs': '10', 'minOccurs': '0', 'name': 'autXML', 'type': 'autXMLType'}, None),
        MemberSpec_('det', 'detType', 1, 0, {'maxOccurs': '990', 'name': 'det', 'type': 'detType'}, None),
        MemberSpec_('total', 'totalType', 0, 0, {'name': 'total', 'type': 'totalType'}, None),
        MemberSpec_('transp', 'transpType', 0, 0, {'name': 'transp', 'type': 'transpType'}, None),
        MemberSpec_('cobr', 'cobrType', 0, 1, {'minOccurs': '0', 'name': 'cobr', 'type': 'cobrType'}, None),
        MemberSpec_('pag', 'pagType', 0, 0, {'name': 'pag', 'type': 'pagType'}, None),
        MemberSpec_('infIntermed', 'infIntermedType', 0, 1, {'minOccurs': '0', 'name': 'infIntermed', 'type': 'infIntermedType'}, None),
        MemberSpec_('infAdic', 'infAdicType', 0, 1, {'minOccurs': '0', 'name': 'infAdic', 'type': 'infAdicType'}, None),
        MemberSpec_('exporta', 'exportaType', 0, 1, {'minOccurs': '0', 'name': 'exporta', 'type': 'exportaType'}, None),
        MemberSpec_('compra', 'compraType', 0, 1, {'minOccurs': '0', 'name': 'compra', 'type': 'compraType'}, None),
        MemberSpec_('cana', 'canaType', 0, 1, {'minOccurs': '0', 'name': 'cana', 'type': 'canaType'}, None),
        MemberSpec_('infRespTec', 'TInfRespTec', 0, 1, {'minOccurs': '0', 'name': 'infRespTec', 'type': 'TInfRespTec'}, None),
        MemberSpec_('infSolicNFF', 'infSolicNFFType', 0, 1, {'minOccurs': '0', 'name': 'infSolicNFF', 'type': 'infSolicNFFType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, versao=None, Id=None, ide=None, emit=None, avulsa=None, dest=None, retirada=None, entrega=None, autXML=None, det=None, total=None, transp=None, cobr=None, pag=None, infIntermed=None, infAdic=None, exporta=None, compra=None, cana=None, infRespTec=None, infSolicNFF=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.versao = _cast(None, versao)
        self.versao_nsprefix_ = None
        self.Id = _cast(None, Id)
        self.Id_nsprefix_ = None
        self.ide = ide
        self.ide_nsprefix_ = None
        self.emit = emit
        self.emit_nsprefix_ = None
        self.avulsa = avulsa
        self.avulsa_nsprefix_ = None
        self.dest = dest
        self.dest_nsprefix_ = None
        self.retirada = retirada
        self.retirada_nsprefix_ = None
        self.entrega = entrega
        self.entrega_nsprefix_ = None
        if autXML is None:
            self.autXML = []
        else:
            self.autXML = autXML
        self.autXML_nsprefix_ = None
        if det is None:
            self.det = []
        else:
            self.det = det
        self.det_nsprefix_ = None
        self.total = total
        self.total_nsprefix_ = None
        self.transp = transp
        self.transp_nsprefix_ = None
        self.cobr = cobr
        self.cobr_nsprefix_ = None
        self.pag = pag
        self.pag_nsprefix_ = None
        self.infIntermed = infIntermed
        self.infIntermed_nsprefix_ = None
        self.infAdic = infAdic
        self.infAdic_nsprefix_ = None
        self.exporta = exporta
        self.exporta_nsprefix_ = None
        self.compra = compra
        self.compra_nsprefix_ = None
        self.cana = cana
        self.cana_nsprefix_ = None
        self.infRespTec = infRespTec
        self.infRespTec_nsprefix_ = None
        self.infSolicNFF = infSolicNFF
        self.infSolicNFF_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, infNFeType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if infNFeType.subclass:
            return infNFeType.subclass(*args_, **kwargs_)
        else:
            return infNFeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TVerNFe(self, value):
        # Validate type TVerNFe, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TVerNFe_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TVerNFe_patterns_, ))
    validate_TVerNFe_patterns_ = [['^(4\\.00)$']]
    def validate_IdType(self, value):
        # Validate type IdType, a restriction on xs:ID.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_IdType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_IdType_patterns_, ))
    validate_IdType_patterns_ = [['^(NFe[0-9]{44})$']]
    def hasContent_(self):
        if (
            self.ide is not None or
            self.emit is not None or
            self.avulsa is not None or
            self.dest is not None or
            self.retirada is not None or
            self.entrega is not None or
            self.autXML or
            self.det or
            self.total is not None or
            self.transp is not None or
            self.cobr is not None or
            self.pag is not None or
            self.infIntermed is not None or
            self.infAdic is not None or
            self.exporta is not None or
            self.compra is not None or
            self.cana is not None or
            self.infRespTec is not None or
            self.infSolicNFF is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='infNFeType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('infNFeType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'infNFeType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='infNFeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='infNFeType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='infNFeType'):
        if self.versao is not None and 'versao' not in already_processed:
            already_processed.add('versao')
            outfile.write(' versao=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.versao), input_name='versao')), ))
        if self.Id is not None and 'Id' not in already_processed:
            already_processed.add('Id')
            outfile.write(' Id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.Id), input_name='Id')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='infNFeType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ide is not None:
            namespaceprefix_ = self.ide_nsprefix_ + ':' if (UseCapturedNS_ and self.ide_nsprefix_) else ''
            self.ide.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ide', pretty_print=pretty_print)
        if self.emit is not None:
            namespaceprefix_ = self.emit_nsprefix_ + ':' if (UseCapturedNS_ and self.emit_nsprefix_) else ''
            self.emit.export(outfile, level, namespaceprefix_, namespacedef_='', name_='emit', pretty_print=pretty_print)
        if self.avulsa is not None:
            namespaceprefix_ = self.avulsa_nsprefix_ + ':' if (UseCapturedNS_ and self.avulsa_nsprefix_) else ''
            self.avulsa.export(outfile, level, namespaceprefix_, namespacedef_='', name_='avulsa', pretty_print=pretty_print)
        if self.dest is not None:
            namespaceprefix_ = self.dest_nsprefix_ + ':' if (UseCapturedNS_ and self.dest_nsprefix_) else ''
            self.dest.export(outfile, level, namespaceprefix_, namespacedef_='', name_='dest', pretty_print=pretty_print)
        if self.retirada is not None:
            namespaceprefix_ = self.retirada_nsprefix_ + ':' if (UseCapturedNS_ and self.retirada_nsprefix_) else ''
            self.retirada.export(outfile, level, namespaceprefix_, namespacedef_='', name_='retirada', pretty_print=pretty_print)
        if self.entrega is not None:
            namespaceprefix_ = self.entrega_nsprefix_ + ':' if (UseCapturedNS_ and self.entrega_nsprefix_) else ''
            self.entrega.export(outfile, level, namespaceprefix_, namespacedef_='', name_='entrega', pretty_print=pretty_print)
        for autXML_ in self.autXML:
            namespaceprefix_ = self.autXML_nsprefix_ + ':' if (UseCapturedNS_ and self.autXML_nsprefix_) else ''
            autXML_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='autXML', pretty_print=pretty_print)
        for det_ in self.det:
            namespaceprefix_ = self.det_nsprefix_ + ':' if (UseCapturedNS_ and self.det_nsprefix_) else ''
            det_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='det', pretty_print=pretty_print)
        if self.total is not None:
            namespaceprefix_ = self.total_nsprefix_ + ':' if (UseCapturedNS_ and self.total_nsprefix_) else ''
            self.total.export(outfile, level, namespaceprefix_, namespacedef_='', name_='total', pretty_print=pretty_print)
        if self.transp is not None:
            namespaceprefix_ = self.transp_nsprefix_ + ':' if (UseCapturedNS_ and self.transp_nsprefix_) else ''
            self.transp.export(outfile, level, namespaceprefix_, namespacedef_='', name_='transp', pretty_print=pretty_print)
        if self.cobr is not None:
            namespaceprefix_ = self.cobr_nsprefix_ + ':' if (UseCapturedNS_ and self.cobr_nsprefix_) else ''
            self.cobr.export(outfile, level, namespaceprefix_, namespacedef_='', name_='cobr', pretty_print=pretty_print)
        if self.pag is not None:
            namespaceprefix_ = self.pag_nsprefix_ + ':' if (UseCapturedNS_ and self.pag_nsprefix_) else ''
            self.pag.export(outfile, level, namespaceprefix_, namespacedef_='', name_='pag', pretty_print=pretty_print)
        if self.infIntermed is not None:
            namespaceprefix_ = self.infIntermed_nsprefix_ + ':' if (UseCapturedNS_ and self.infIntermed_nsprefix_) else ''
            self.infIntermed.export(outfile, level, namespaceprefix_, namespacedef_='', name_='infIntermed', pretty_print=pretty_print)
        if self.infAdic is not None:
            namespaceprefix_ = self.infAdic_nsprefix_ + ':' if (UseCapturedNS_ and self.infAdic_nsprefix_) else ''
            self.infAdic.export(outfile, level, namespaceprefix_, namespacedef_='', name_='infAdic', pretty_print=pretty_print)
        if self.exporta is not None:
            namespaceprefix_ = self.exporta_nsprefix_ + ':' if (UseCapturedNS_ and self.exporta_nsprefix_) else ''
            self.exporta.export(outfile, level, namespaceprefix_, namespacedef_='', name_='exporta', pretty_print=pretty_print)
        if self.compra is not None:
            namespaceprefix_ = self.compra_nsprefix_ + ':' if (UseCapturedNS_ and self.compra_nsprefix_) else ''
            self.compra.export(outfile, level, namespaceprefix_, namespacedef_='', name_='compra', pretty_print=pretty_print)
        if self.cana is not None:
            namespaceprefix_ = self.cana_nsprefix_ + ':' if (UseCapturedNS_ and self.cana_nsprefix_) else ''
            self.cana.export(outfile, level, namespaceprefix_, namespacedef_='', name_='cana', pretty_print=pretty_print)
        if self.infRespTec is not None:
            namespaceprefix_ = self.infRespTec_nsprefix_ + ':' if (UseCapturedNS_ and self.infRespTec_nsprefix_) else ''
            self.infRespTec.export(outfile, level, namespaceprefix_, namespacedef_='', name_='infRespTec', pretty_print=pretty_print)
        if self.infSolicNFF is not None:
            namespaceprefix_ = self.infSolicNFF_nsprefix_ + ':' if (UseCapturedNS_ and self.infSolicNFF_nsprefix_) else ''
            self.infSolicNFF.export(outfile, level, namespaceprefix_, namespacedef_='', name_='infSolicNFF', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('versao', node)
        if value is not None and 'versao' not in already_processed:
            already_processed.add('versao')
            self.versao = value
            self.validate_TVerNFe(self.versao)    # validate type TVerNFe
        value = find_attr_value_('Id', node)
        if value is not None and 'Id' not in already_processed:
            already_processed.add('Id')
            self.Id = value
            self.validate_IdType(self.Id)    # validate type IdType
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ide':
            obj_ = ideType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ide = obj_
            obj_.original_tagname_ = 'ide'
        elif nodeName_ == 'emit':
            obj_ = emitType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.emit = obj_
            obj_.original_tagname_ = 'emit'
        elif nodeName_ == 'avulsa':
            obj_ = avulsaType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.avulsa = obj_
            obj_.original_tagname_ = 'avulsa'
        elif nodeName_ == 'dest':
            obj_ = destType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.dest = obj_
            obj_.original_tagname_ = 'dest'
        elif nodeName_ == 'retirada':
            obj_ = TLocal.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.retirada = obj_
            obj_.original_tagname_ = 'retirada'
        elif nodeName_ == 'entrega':
            obj_ = TLocal.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.entrega = obj_
            obj_.original_tagname_ = 'entrega'
        elif nodeName_ == 'autXML':
            obj_ = autXMLType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.autXML.append(obj_)
            obj_.original_tagname_ = 'autXML'
        elif nodeName_ == 'det':
            obj_ = detType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.det.append(obj_)
            obj_.original_tagname_ = 'det'
        elif nodeName_ == 'total':
            obj_ = totalType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.total = obj_
            obj_.original_tagname_ = 'total'
        elif nodeName_ == 'transp':
            obj_ = transpType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.transp = obj_
            obj_.original_tagname_ = 'transp'
        elif nodeName_ == 'cobr':
            obj_ = cobrType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.cobr = obj_
            obj_.original_tagname_ = 'cobr'
        elif nodeName_ == 'pag':
            obj_ = pagType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.pag = obj_
            obj_.original_tagname_ = 'pag'
        elif nodeName_ == 'infIntermed':
            obj_ = infIntermedType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.infIntermed = obj_
            obj_.original_tagname_ = 'infIntermed'
        elif nodeName_ == 'infAdic':
            obj_ = infAdicType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.infAdic = obj_
            obj_.original_tagname_ = 'infAdic'
        elif nodeName_ == 'exporta':
            obj_ = exportaType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.exporta = obj_
            obj_.original_tagname_ = 'exporta'
        elif nodeName_ == 'compra':
            obj_ = compraType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.compra = obj_
            obj_.original_tagname_ = 'compra'
        elif nodeName_ == 'cana':
            obj_ = canaType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.cana = obj_
            obj_.original_tagname_ = 'cana'
        elif nodeName_ == 'infRespTec':
            obj_ = TInfRespTec.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.infRespTec = obj_
            obj_.original_tagname_ = 'infRespTec'
        elif nodeName_ == 'infSolicNFF':
            obj_ = infSolicNFFType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.infSolicNFF = obj_
            obj_.original_tagname_ = 'infSolicNFF'
# end class infNFeType


class ideType(GeneratedsSuper):
    """identificação da NF-eInformar apenas
    para tpEmis diferente de 1"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('cUF', ['TCodUfIBGE', 'xs:string'], 0, 0, {'name': 'cUF', 'type': 'xs:string'}, None),
        MemberSpec_('cNF', ['cNFType', 'xs:string'], 0, 0, {'name': 'cNF', 'type': 'xs:string'}, None),
        MemberSpec_('natOp', ['natOpType', 'TString', 'xs:string'], 0, 0, {'name': 'natOp', 'type': 'xs:string'}, None),
        MemberSpec_('mod', ['TMod', 'xs:string'], 0, 0, {'name': 'mod', 'type': 'xs:string'}, None),
        MemberSpec_('serie', ['TSerie', 'xs:string'], 0, 0, {'name': 'serie', 'type': 'xs:string'}, None),
        MemberSpec_('nNF', ['TNF', 'xs:string'], 0, 0, {'name': 'nNF', 'type': 'xs:string'}, None),
        MemberSpec_('dhEmi', ['TDateTimeUTC', 'xs:string'], 0, 0, {'name': 'dhEmi', 'type': 'xs:string'}, None),
        MemberSpec_('dhSaiEnt', ['TDateTimeUTC', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'dhSaiEnt', 'type': 'xs:string'}, None),
        MemberSpec_('tpNF', ['tpNFType', 'xs:string'], 0, 0, {'name': 'tpNF', 'type': 'xs:string'}, None),
        MemberSpec_('idDest', ['idDestType', 'xs:string'], 0, 0, {'name': 'idDest', 'type': 'xs:string'}, None),
        MemberSpec_('cMunFG', ['TCodMunIBGE', 'xs:string'], 0, 0, {'name': 'cMunFG', 'type': 'xs:string'}, None),
        MemberSpec_('tpImp', ['tpImpType', 'xs:string'], 0, 0, {'name': 'tpImp', 'type': 'xs:string'}, None),
        MemberSpec_('tpEmis', ['tpEmisType', 'xs:string'], 0, 0, {'name': 'tpEmis', 'type': 'xs:string'}, None),
        MemberSpec_('cDV', ['cDVType', 'xs:string'], 0, 0, {'name': 'cDV', 'type': 'xs:string'}, None),
        MemberSpec_('tpAmb', ['TAmb', 'xs:string'], 0, 0, {'name': 'tpAmb', 'type': 'xs:string'}, None),
        MemberSpec_('finNFe', ['TFinNFe', 'xs:string'], 0, 0, {'name': 'finNFe', 'type': 'xs:string'}, None),
        MemberSpec_('indFinal', ['indFinalType', 'xs:string'], 0, 0, {'name': 'indFinal', 'type': 'xs:string'}, None),
        MemberSpec_('indPres', ['indPresType', 'xs:string'], 0, 0, {'name': 'indPres', 'type': 'xs:string'}, None),
        MemberSpec_('indIntermed', ['indIntermedType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'indIntermed', 'type': 'xs:string'}, None),
        MemberSpec_('procEmi', ['TProcEmi', 'xs:string'], 0, 0, {'name': 'procEmi', 'type': 'xs:string'}, None),
        MemberSpec_('verProc', ['verProcType', 'TString', 'xs:string'], 0, 0, {'name': 'verProc', 'type': 'xs:string'}, None),
        MemberSpec_('dhCont', ['TDateTimeUTC', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'dhCont', 'type': 'xs:string'}, None),
        MemberSpec_('xJust', ['xJustType', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'xJust', 'type': 'xs:string'}, None),
        MemberSpec_('NFref', 'NFrefType', 1, 1, {'maxOccurs': '500', 'minOccurs': '0', 'name': 'NFref', 'type': 'NFrefType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, cUF=None, cNF=None, natOp=None, mod=None, serie=None, nNF=None, dhEmi=None, dhSaiEnt=None, tpNF=None, idDest=None, cMunFG=None, tpImp=None, tpEmis=None, cDV=None, tpAmb=None, finNFe=None, indFinal=None, indPres=None, indIntermed=None, procEmi=None, verProc=None, dhCont=None, xJust=None, NFref=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.cUF = cUF
        self.validate_TCodUfIBGE(self.cUF)
        self.cUF_nsprefix_ = None
        self.cNF = cNF
        self.validate_cNFType(self.cNF)
        self.cNF_nsprefix_ = None
        self.natOp = natOp
        self.validate_natOpType(self.natOp)
        self.natOp_nsprefix_ = None
        self.mod = mod
        self.validate_TMod(self.mod)
        self.mod_nsprefix_ = None
        self.serie = serie
        self.validate_TSerie(self.serie)
        self.serie_nsprefix_ = None
        self.nNF = nNF
        self.validate_TNF(self.nNF)
        self.nNF_nsprefix_ = None
        self.dhEmi = dhEmi
        self.validate_TDateTimeUTC(self.dhEmi)
        self.dhEmi_nsprefix_ = None
        self.dhSaiEnt = dhSaiEnt
        self.validate_TDateTimeUTC(self.dhSaiEnt)
        self.dhSaiEnt_nsprefix_ = None
        self.tpNF = tpNF
        self.validate_tpNFType(self.tpNF)
        self.tpNF_nsprefix_ = None
        self.idDest = idDest
        self.validate_idDestType(self.idDest)
        self.idDest_nsprefix_ = None
        self.cMunFG = cMunFG
        self.validate_TCodMunIBGE(self.cMunFG)
        self.cMunFG_nsprefix_ = None
        self.tpImp = tpImp
        self.validate_tpImpType(self.tpImp)
        self.tpImp_nsprefix_ = None
        self.tpEmis = tpEmis
        self.validate_tpEmisType(self.tpEmis)
        self.tpEmis_nsprefix_ = None
        self.cDV = cDV
        self.validate_cDVType(self.cDV)
        self.cDV_nsprefix_ = None
        self.tpAmb = tpAmb
        self.validate_TAmb(self.tpAmb)
        self.tpAmb_nsprefix_ = None
        self.finNFe = finNFe
        self.validate_TFinNFe(self.finNFe)
        self.finNFe_nsprefix_ = None
        self.indFinal = indFinal
        self.validate_indFinalType(self.indFinal)
        self.indFinal_nsprefix_ = None
        self.indPres = indPres
        self.validate_indPresType(self.indPres)
        self.indPres_nsprefix_ = None
        self.indIntermed = indIntermed
        self.validate_indIntermedType(self.indIntermed)
        self.indIntermed_nsprefix_ = None
        self.procEmi = procEmi
        self.validate_TProcEmi(self.procEmi)
        self.procEmi_nsprefix_ = None
        self.verProc = verProc
        self.validate_verProcType(self.verProc)
        self.verProc_nsprefix_ = None
        self.dhCont = dhCont
        self.validate_TDateTimeUTC(self.dhCont)
        self.dhCont_nsprefix_ = None
        self.xJust = xJust
        self.validate_xJustType(self.xJust)
        self.xJust_nsprefix_ = None
        if NFref is None:
            self.NFref = []
        else:
            self.NFref = NFref
        self.NFref_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ideType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ideType.subclass:
            return ideType.subclass(*args_, **kwargs_)
        else:
            return ideType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TCodUfIBGE(self, value):
        result = True
        # Validate type TCodUfIBGE, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['11', '12', '13', '14', '15', '16', '17', '21', '22', '23', '24', '25', '26', '27', '28', '29', '31', '32', '33', '35', '41', '42', '43', '50', '51', '52', '53']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TCodUfIBGE' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_cNFType(self, value):
        result = True
        # Validate type cNFType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_cNFType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cNFType_patterns_, ))
                result = False
        return result
    validate_cNFType_patterns_ = [['^([0-9]{8})$']]
    def validate_natOpType(self, value):
        result = True
        # Validate type natOpType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on natOpType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on natOpType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_natOpType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_natOpType_patterns_, ))
                result = False
        return result
    validate_natOpType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TMod(self, value):
        result = True
        # Validate type TMod, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['55', '65']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TMod' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TSerie(self, value):
        result = True
        # Validate type TSerie, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TSerie_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TSerie_patterns_, ))
                result = False
        return result
    validate_TSerie_patterns_ = [['^(0|[1-9]{1}[0-9]{0,2})$']]
    def validate_TNF(self, value):
        result = True
        # Validate type TNF, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TNF_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TNF_patterns_, ))
                result = False
        return result
    validate_TNF_patterns_ = [['^([1-9]{1}[0-9]{0,8})$']]
    def validate_TDateTimeUTC(self, value):
        result = True
        # Validate type TDateTimeUTC, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDateTimeUTC_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDateTimeUTC_patterns_, ))
                result = False
        return result
    validate_TDateTimeUTC_patterns_ = [['^((((20(([02468][048])|([13579][26]))-02-29))|(20[0-9][0-9])-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\\d)|(2[0-8])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T(20|21|22|23|[0-1]\\d):[0-5]\\d:[0-5]\\d([\\-,\\+](0[0-9]|10|11):00|([\\+](12):00)))$']]
    def validate_tpNFType(self, value):
        result = True
        # Validate type tpNFType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on tpNFType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_idDestType(self, value):
        result = True
        # Validate type idDestType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['1', '2', '3']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on idDestType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TCodMunIBGE(self, value):
        result = True
        # Validate type TCodMunIBGE, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCodMunIBGE_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCodMunIBGE_patterns_, ))
                result = False
        return result
    validate_TCodMunIBGE_patterns_ = [['^([0-9]{7})$']]
    def validate_tpImpType(self, value):
        result = True
        # Validate type tpImpType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on tpImpType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_tpEmisType(self, value):
        result = True
        # Validate type tpEmisType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['1', '2', '3', '4', '5', '6', '7', '9']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on tpEmisType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_cDVType(self, value):
        result = True
        # Validate type cDVType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_cDVType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cDVType_patterns_, ))
                result = False
        return result
    validate_cDVType_patterns_ = [['^([0-9]{1})$']]
    def validate_TAmb(self, value):
        result = True
        # Validate type TAmb, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['1', '2']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TAmb' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TFinNFe(self, value):
        result = True
        # Validate type TFinNFe, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['1', '2', '3', '4']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TFinNFe' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_indFinalType(self, value):
        result = True
        # Validate type indFinalType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on indFinalType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_indPresType(self, value):
        result = True
        # Validate type indPresType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5', '9']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on indPresType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_indIntermedType(self, value):
        result = True
        # Validate type indIntermedType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on indIntermedType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TProcEmi(self, value):
        result = True
        # Validate type TProcEmi, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TProcEmi' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_verProcType(self, value):
        result = True
        # Validate type verProcType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 20:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on verProcType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on verProcType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_verProcType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_verProcType_patterns_, ))
                result = False
        return result
    validate_verProcType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_xJustType(self, value):
        result = True
        # Validate type xJustType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 256:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xJustType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 15:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xJustType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xJustType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xJustType_patterns_, ))
                result = False
        return result
    validate_xJustType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def hasContent_(self):
        if (
            self.cUF is not None or
            self.cNF is not None or
            self.natOp is not None or
            self.mod is not None or
            self.serie is not None or
            self.nNF is not None or
            self.dhEmi is not None or
            self.dhSaiEnt is not None or
            self.tpNF is not None or
            self.idDest is not None or
            self.cMunFG is not None or
            self.tpImp is not None or
            self.tpEmis is not None or
            self.cDV is not None or
            self.tpAmb is not None or
            self.finNFe is not None or
            self.indFinal is not None or
            self.indPres is not None or
            self.indIntermed is not None or
            self.procEmi is not None or
            self.verProc is not None or
            self.dhCont is not None or
            self.xJust is not None or
            self.NFref
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ideType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ideType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ideType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ideType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ideType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ideType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ideType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.cUF is not None:
            namespaceprefix_ = self.cUF_nsprefix_ + ':' if (UseCapturedNS_ and self.cUF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scUF>%s</%scUF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cUF), input_name='cUF')), namespaceprefix_ , eol_))
        if self.cNF is not None:
            namespaceprefix_ = self.cNF_nsprefix_ + ':' if (UseCapturedNS_ and self.cNF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scNF>%s</%scNF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cNF), input_name='cNF')), namespaceprefix_ , eol_))
        if self.natOp is not None:
            namespaceprefix_ = self.natOp_nsprefix_ + ':' if (UseCapturedNS_ and self.natOp_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snatOp>%s</%snatOp>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.natOp), input_name='natOp')), namespaceprefix_ , eol_))
        if self.mod is not None:
            namespaceprefix_ = self.mod_nsprefix_ + ':' if (UseCapturedNS_ and self.mod_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smod>%s</%smod>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.mod), input_name='mod')), namespaceprefix_ , eol_))
        if self.serie is not None:
            namespaceprefix_ = self.serie_nsprefix_ + ':' if (UseCapturedNS_ and self.serie_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sserie>%s</%sserie>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.serie), input_name='serie')), namespaceprefix_ , eol_))
        if self.nNF is not None:
            namespaceprefix_ = self.nNF_nsprefix_ + ':' if (UseCapturedNS_ and self.nNF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snNF>%s</%snNF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nNF), input_name='nNF')), namespaceprefix_ , eol_))
        if self.dhEmi is not None:
            namespaceprefix_ = self.dhEmi_nsprefix_ + ':' if (UseCapturedNS_ and self.dhEmi_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdhEmi>%s</%sdhEmi>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.dhEmi), input_name='dhEmi')), namespaceprefix_ , eol_))
        if self.dhSaiEnt is not None:
            namespaceprefix_ = self.dhSaiEnt_nsprefix_ + ':' if (UseCapturedNS_ and self.dhSaiEnt_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdhSaiEnt>%s</%sdhSaiEnt>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.dhSaiEnt), input_name='dhSaiEnt')), namespaceprefix_ , eol_))
        if self.tpNF is not None:
            namespaceprefix_ = self.tpNF_nsprefix_ + ':' if (UseCapturedNS_ and self.tpNF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stpNF>%s</%stpNF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tpNF), input_name='tpNF')), namespaceprefix_ , eol_))
        if self.idDest is not None:
            namespaceprefix_ = self.idDest_nsprefix_ + ':' if (UseCapturedNS_ and self.idDest_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sidDest>%s</%sidDest>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.idDest), input_name='idDest')), namespaceprefix_ , eol_))
        if self.cMunFG is not None:
            namespaceprefix_ = self.cMunFG_nsprefix_ + ':' if (UseCapturedNS_ and self.cMunFG_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scMunFG>%s</%scMunFG>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cMunFG), input_name='cMunFG')), namespaceprefix_ , eol_))
        if self.tpImp is not None:
            namespaceprefix_ = self.tpImp_nsprefix_ + ':' if (UseCapturedNS_ and self.tpImp_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stpImp>%s</%stpImp>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tpImp), input_name='tpImp')), namespaceprefix_ , eol_))
        if self.tpEmis is not None:
            namespaceprefix_ = self.tpEmis_nsprefix_ + ':' if (UseCapturedNS_ and self.tpEmis_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stpEmis>%s</%stpEmis>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tpEmis), input_name='tpEmis')), namespaceprefix_ , eol_))
        if self.cDV is not None:
            namespaceprefix_ = self.cDV_nsprefix_ + ':' if (UseCapturedNS_ and self.cDV_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scDV>%s</%scDV>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cDV), input_name='cDV')), namespaceprefix_ , eol_))
        if self.tpAmb is not None:
            namespaceprefix_ = self.tpAmb_nsprefix_ + ':' if (UseCapturedNS_ and self.tpAmb_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stpAmb>%s</%stpAmb>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tpAmb), input_name='tpAmb')), namespaceprefix_ , eol_))
        if self.finNFe is not None:
            namespaceprefix_ = self.finNFe_nsprefix_ + ':' if (UseCapturedNS_ and self.finNFe_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfinNFe>%s</%sfinNFe>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.finNFe), input_name='finNFe')), namespaceprefix_ , eol_))
        if self.indFinal is not None:
            namespaceprefix_ = self.indFinal_nsprefix_ + ':' if (UseCapturedNS_ and self.indFinal_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sindFinal>%s</%sindFinal>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.indFinal), input_name='indFinal')), namespaceprefix_ , eol_))
        if self.indPres is not None:
            namespaceprefix_ = self.indPres_nsprefix_ + ':' if (UseCapturedNS_ and self.indPres_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sindPres>%s</%sindPres>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.indPres), input_name='indPres')), namespaceprefix_ , eol_))
        if self.indIntermed is not None:
            namespaceprefix_ = self.indIntermed_nsprefix_ + ':' if (UseCapturedNS_ and self.indIntermed_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sindIntermed>%s</%sindIntermed>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.indIntermed), input_name='indIntermed')), namespaceprefix_ , eol_))
        if self.procEmi is not None:
            namespaceprefix_ = self.procEmi_nsprefix_ + ':' if (UseCapturedNS_ and self.procEmi_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sprocEmi>%s</%sprocEmi>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.procEmi), input_name='procEmi')), namespaceprefix_ , eol_))
        if self.verProc is not None:
            namespaceprefix_ = self.verProc_nsprefix_ + ':' if (UseCapturedNS_ and self.verProc_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sverProc>%s</%sverProc>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.verProc), input_name='verProc')), namespaceprefix_ , eol_))
        if self.dhCont is not None:
            namespaceprefix_ = self.dhCont_nsprefix_ + ':' if (UseCapturedNS_ and self.dhCont_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdhCont>%s</%sdhCont>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.dhCont), input_name='dhCont')), namespaceprefix_ , eol_))
        if self.xJust is not None:
            namespaceprefix_ = self.xJust_nsprefix_ + ':' if (UseCapturedNS_ and self.xJust_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxJust>%s</%sxJust>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xJust), input_name='xJust')), namespaceprefix_ , eol_))
        for NFref_ in self.NFref:
            namespaceprefix_ = self.NFref_nsprefix_ + ':' if (UseCapturedNS_ and self.NFref_nsprefix_) else ''
            NFref_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='NFref', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'cUF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cUF')
            value_ = self.gds_validate_string(value_, node, 'cUF')
            self.cUF = value_
            self.cUF_nsprefix_ = child_.prefix
            # validate type TCodUfIBGE
            self.validate_TCodUfIBGE(self.cUF)
        elif nodeName_ == 'cNF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cNF')
            value_ = self.gds_validate_string(value_, node, 'cNF')
            self.cNF = value_
            self.cNF_nsprefix_ = child_.prefix
            # validate type cNFType
            self.validate_cNFType(self.cNF)
        elif nodeName_ == 'natOp':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'natOp')
            value_ = self.gds_validate_string(value_, node, 'natOp')
            self.natOp = value_
            self.natOp_nsprefix_ = child_.prefix
            # validate type natOpType
            self.validate_natOpType(self.natOp)
        elif nodeName_ == 'mod':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'mod')
            value_ = self.gds_validate_string(value_, node, 'mod')
            self.mod = value_
            self.mod_nsprefix_ = child_.prefix
            # validate type TMod
            self.validate_TMod(self.mod)
        elif nodeName_ == 'serie':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'serie')
            value_ = self.gds_validate_string(value_, node, 'serie')
            self.serie = value_
            self.serie_nsprefix_ = child_.prefix
            # validate type TSerie
            self.validate_TSerie(self.serie)
        elif nodeName_ == 'nNF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nNF')
            value_ = self.gds_validate_string(value_, node, 'nNF')
            self.nNF = value_
            self.nNF_nsprefix_ = child_.prefix
            # validate type TNF
            self.validate_TNF(self.nNF)
        elif nodeName_ == 'dhEmi':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'dhEmi')
            value_ = self.gds_validate_string(value_, node, 'dhEmi')
            self.dhEmi = value_
            self.dhEmi_nsprefix_ = child_.prefix
            # validate type TDateTimeUTC
            self.validate_TDateTimeUTC(self.dhEmi)
        elif nodeName_ == 'dhSaiEnt':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'dhSaiEnt')
            value_ = self.gds_validate_string(value_, node, 'dhSaiEnt')
            self.dhSaiEnt = value_
            self.dhSaiEnt_nsprefix_ = child_.prefix
            # validate type TDateTimeUTC
            self.validate_TDateTimeUTC(self.dhSaiEnt)
        elif nodeName_ == 'tpNF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tpNF')
            value_ = self.gds_validate_string(value_, node, 'tpNF')
            self.tpNF = value_
            self.tpNF_nsprefix_ = child_.prefix
            # validate type tpNFType
            self.validate_tpNFType(self.tpNF)
        elif nodeName_ == 'idDest':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'idDest')
            value_ = self.gds_validate_string(value_, node, 'idDest')
            self.idDest = value_
            self.idDest_nsprefix_ = child_.prefix
            # validate type idDestType
            self.validate_idDestType(self.idDest)
        elif nodeName_ == 'cMunFG':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cMunFG')
            value_ = self.gds_validate_string(value_, node, 'cMunFG')
            self.cMunFG = value_
            self.cMunFG_nsprefix_ = child_.prefix
            # validate type TCodMunIBGE
            self.validate_TCodMunIBGE(self.cMunFG)
        elif nodeName_ == 'tpImp':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tpImp')
            value_ = self.gds_validate_string(value_, node, 'tpImp')
            self.tpImp = value_
            self.tpImp_nsprefix_ = child_.prefix
            # validate type tpImpType
            self.validate_tpImpType(self.tpImp)
        elif nodeName_ == 'tpEmis':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tpEmis')
            value_ = self.gds_validate_string(value_, node, 'tpEmis')
            self.tpEmis = value_
            self.tpEmis_nsprefix_ = child_.prefix
            # validate type tpEmisType
            self.validate_tpEmisType(self.tpEmis)
        elif nodeName_ == 'cDV':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cDV')
            value_ = self.gds_validate_string(value_, node, 'cDV')
            self.cDV = value_
            self.cDV_nsprefix_ = child_.prefix
            # validate type cDVType
            self.validate_cDVType(self.cDV)
        elif nodeName_ == 'tpAmb':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tpAmb')
            value_ = self.gds_validate_string(value_, node, 'tpAmb')
            self.tpAmb = value_
            self.tpAmb_nsprefix_ = child_.prefix
            # validate type TAmb
            self.validate_TAmb(self.tpAmb)
        elif nodeName_ == 'finNFe':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'finNFe')
            value_ = self.gds_validate_string(value_, node, 'finNFe')
            self.finNFe = value_
            self.finNFe_nsprefix_ = child_.prefix
            # validate type TFinNFe
            self.validate_TFinNFe(self.finNFe)
        elif nodeName_ == 'indFinal':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'indFinal')
            value_ = self.gds_validate_string(value_, node, 'indFinal')
            self.indFinal = value_
            self.indFinal_nsprefix_ = child_.prefix
            # validate type indFinalType
            self.validate_indFinalType(self.indFinal)
        elif nodeName_ == 'indPres':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'indPres')
            value_ = self.gds_validate_string(value_, node, 'indPres')
            self.indPres = value_
            self.indPres_nsprefix_ = child_.prefix
            # validate type indPresType
            self.validate_indPresType(self.indPres)
        elif nodeName_ == 'indIntermed':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'indIntermed')
            value_ = self.gds_validate_string(value_, node, 'indIntermed')
            self.indIntermed = value_
            self.indIntermed_nsprefix_ = child_.prefix
            # validate type indIntermedType
            self.validate_indIntermedType(self.indIntermed)
        elif nodeName_ == 'procEmi':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'procEmi')
            value_ = self.gds_validate_string(value_, node, 'procEmi')
            self.procEmi = value_
            self.procEmi_nsprefix_ = child_.prefix
            # validate type TProcEmi
            self.validate_TProcEmi(self.procEmi)
        elif nodeName_ == 'verProc':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'verProc')
            value_ = self.gds_validate_string(value_, node, 'verProc')
            self.verProc = value_
            self.verProc_nsprefix_ = child_.prefix
            # validate type verProcType
            self.validate_verProcType(self.verProc)
        elif nodeName_ == 'dhCont':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'dhCont')
            value_ = self.gds_validate_string(value_, node, 'dhCont')
            self.dhCont = value_
            self.dhCont_nsprefix_ = child_.prefix
            # validate type TDateTimeUTC
            self.validate_TDateTimeUTC(self.dhCont)
        elif nodeName_ == 'xJust':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xJust')
            value_ = self.gds_validate_string(value_, node, 'xJust')
            self.xJust = value_
            self.xJust_nsprefix_ = child_.prefix
            # validate type xJustType
            self.validate_xJustType(self.xJust)
        elif nodeName_ == 'NFref':
            obj_ = NFrefType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.NFref.append(obj_)
            obj_.original_tagname_ = 'NFref'
# end class ideType


class NFrefType(GeneratedsSuper):
    """Grupo de infromações da NF referenciada"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('refNFe', ['TChNFe', 'xs:string'], 0, 0, {'name': 'refNFe', 'type': 'xs:string'}, 4),
        MemberSpec_('refNF', 'refNFType', 0, 0, {'name': 'refNF', 'type': 'refNFType'}, 4),
        MemberSpec_('refNFP', 'refNFPType', 0, 0, {'name': 'refNFP', 'type': 'refNFPType'}, 4),
        MemberSpec_('refCTe', ['TChNFe', 'xs:string'], 0, 0, {'name': 'refCTe', 'type': 'xs:string'}, 4),
        MemberSpec_('refECF', 'refECFType', 0, 0, {'name': 'refECF', 'type': 'refECFType'}, 4),
    ]
    subclass = None
    superclass = None
    def __init__(self, refNFe=None, refNF=None, refNFP=None, refCTe=None, refECF=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.refNFe = refNFe
        self.validate_TChNFe(self.refNFe)
        self.refNFe_nsprefix_ = None
        self.refNF = refNF
        self.refNF_nsprefix_ = None
        self.refNFP = refNFP
        self.refNFP_nsprefix_ = None
        self.refCTe = refCTe
        self.validate_TChNFe(self.refCTe)
        self.refCTe_nsprefix_ = None
        self.refECF = refECF
        self.refECF_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NFrefType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NFrefType.subclass:
            return NFrefType.subclass(*args_, **kwargs_)
        else:
            return NFrefType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TChNFe(self, value):
        result = True
        # Validate type TChNFe, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 44:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TChNFe' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TChNFe_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TChNFe_patterns_, ))
                result = False
        return result
    validate_TChNFe_patterns_ = [['^([0-9]{44})$']]
    def hasContent_(self):
        if (
            self.refNFe is not None or
            self.refNF is not None or
            self.refNFP is not None or
            self.refCTe is not None or
            self.refECF is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='NFrefType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('NFrefType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'NFrefType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='NFrefType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='NFrefType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='NFrefType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='NFrefType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.refNFe is not None:
            namespaceprefix_ = self.refNFe_nsprefix_ + ':' if (UseCapturedNS_ and self.refNFe_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srefNFe>%s</%srefNFe>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.refNFe), input_name='refNFe')), namespaceprefix_ , eol_))
        if self.refNF is not None:
            namespaceprefix_ = self.refNF_nsprefix_ + ':' if (UseCapturedNS_ and self.refNF_nsprefix_) else ''
            self.refNF.export(outfile, level, namespaceprefix_, namespacedef_='', name_='refNF', pretty_print=pretty_print)
        if self.refNFP is not None:
            namespaceprefix_ = self.refNFP_nsprefix_ + ':' if (UseCapturedNS_ and self.refNFP_nsprefix_) else ''
            self.refNFP.export(outfile, level, namespaceprefix_, namespacedef_='', name_='refNFP', pretty_print=pretty_print)
        if self.refCTe is not None:
            namespaceprefix_ = self.refCTe_nsprefix_ + ':' if (UseCapturedNS_ and self.refCTe_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srefCTe>%s</%srefCTe>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.refCTe), input_name='refCTe')), namespaceprefix_ , eol_))
        if self.refECF is not None:
            namespaceprefix_ = self.refECF_nsprefix_ + ':' if (UseCapturedNS_ and self.refECF_nsprefix_) else ''
            self.refECF.export(outfile, level, namespaceprefix_, namespacedef_='', name_='refECF', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'refNFe':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'refNFe')
            value_ = self.gds_validate_string(value_, node, 'refNFe')
            self.refNFe = value_
            self.refNFe_nsprefix_ = child_.prefix
            # validate type TChNFe
            self.validate_TChNFe(self.refNFe)
        elif nodeName_ == 'refNF':
            obj_ = refNFType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.refNF = obj_
            obj_.original_tagname_ = 'refNF'
        elif nodeName_ == 'refNFP':
            obj_ = refNFPType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.refNFP = obj_
            obj_.original_tagname_ = 'refNFP'
        elif nodeName_ == 'refCTe':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'refCTe')
            value_ = self.gds_validate_string(value_, node, 'refCTe')
            self.refCTe = value_
            self.refCTe_nsprefix_ = child_.prefix
            # validate type TChNFe
            self.validate_TChNFe(self.refCTe)
        elif nodeName_ == 'refECF':
            obj_ = refECFType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.refECF = obj_
            obj_.original_tagname_ = 'refECF'
# end class NFrefType


class refNFType(GeneratedsSuper):
    """Dados da NF modelo 1/1A referenciada ou NF modelo 2 referenciada"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('cUF', ['TCodUfIBGE', 'xs:string'], 0, 0, {'name': 'cUF', 'type': 'xs:string'}, None),
        MemberSpec_('AAMM', ['AAMMType', 'xs:string'], 0, 0, {'name': 'AAMM', 'type': 'xs:string'}, None),
        MemberSpec_('CNPJ', ['TCnpj', 'xs:string'], 0, 0, {'name': 'CNPJ', 'type': 'xs:string'}, None),
        MemberSpec_('mod', ['modType', 'xs:string'], 0, 0, {'name': 'mod', 'type': 'xs:string'}, None),
        MemberSpec_('serie', ['TSerie', 'xs:string'], 0, 0, {'name': 'serie', 'type': 'xs:string'}, None),
        MemberSpec_('nNF', ['TNF', 'xs:string'], 0, 0, {'name': 'nNF', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, cUF=None, AAMM=None, CNPJ=None, mod=None, serie=None, nNF=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.cUF = cUF
        self.validate_TCodUfIBGE(self.cUF)
        self.cUF_nsprefix_ = None
        self.AAMM = AAMM
        self.validate_AAMMType(self.AAMM)
        self.AAMM_nsprefix_ = None
        self.CNPJ = CNPJ
        self.validate_TCnpj(self.CNPJ)
        self.CNPJ_nsprefix_ = None
        self.mod = mod
        self.validate_modType(self.mod)
        self.mod_nsprefix_ = None
        self.serie = serie
        self.validate_TSerie(self.serie)
        self.serie_nsprefix_ = None
        self.nNF = nNF
        self.validate_TNF(self.nNF)
        self.nNF_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, refNFType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if refNFType.subclass:
            return refNFType.subclass(*args_, **kwargs_)
        else:
            return refNFType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TCodUfIBGE(self, value):
        result = True
        # Validate type TCodUfIBGE, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['11', '12', '13', '14', '15', '16', '17', '21', '22', '23', '24', '25', '26', '27', '28', '29', '31', '32', '33', '35', '41', '42', '43', '50', '51', '52', '53']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TCodUfIBGE' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_AAMMType(self, value):
        result = True
        # Validate type AAMMType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_AAMMType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_AAMMType_patterns_, ))
                result = False
        return result
    validate_AAMMType_patterns_ = [['^([0-9]{2}[0]{1}[1-9]{1}|[0-9]{2}[1]{1}[0-2]{1})$']]
    def validate_TCnpj(self, value):
        result = True
        # Validate type TCnpj, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 14:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TCnpj' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCnpj_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCnpj_patterns_, ))
                result = False
        return result
    validate_TCnpj_patterns_ = [['^([0-9]{14})$']]
    def validate_modType(self, value):
        result = True
        # Validate type modType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['01', '02']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on modType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TSerie(self, value):
        result = True
        # Validate type TSerie, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TSerie_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TSerie_patterns_, ))
                result = False
        return result
    validate_TSerie_patterns_ = [['^(0|[1-9]{1}[0-9]{0,2})$']]
    def validate_TNF(self, value):
        result = True
        # Validate type TNF, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TNF_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TNF_patterns_, ))
                result = False
        return result
    validate_TNF_patterns_ = [['^([1-9]{1}[0-9]{0,8})$']]
    def hasContent_(self):
        if (
            self.cUF is not None or
            self.AAMM is not None or
            self.CNPJ is not None or
            self.mod is not None or
            self.serie is not None or
            self.nNF is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='refNFType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('refNFType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'refNFType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='refNFType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='refNFType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='refNFType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='refNFType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.cUF is not None:
            namespaceprefix_ = self.cUF_nsprefix_ + ':' if (UseCapturedNS_ and self.cUF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scUF>%s</%scUF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cUF), input_name='cUF')), namespaceprefix_ , eol_))
        if self.AAMM is not None:
            namespaceprefix_ = self.AAMM_nsprefix_ + ':' if (UseCapturedNS_ and self.AAMM_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAAMM>%s</%sAAMM>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.AAMM), input_name='AAMM')), namespaceprefix_ , eol_))
        if self.CNPJ is not None:
            namespaceprefix_ = self.CNPJ_nsprefix_ + ':' if (UseCapturedNS_ and self.CNPJ_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCNPJ>%s</%sCNPJ>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CNPJ), input_name='CNPJ')), namespaceprefix_ , eol_))
        if self.mod is not None:
            namespaceprefix_ = self.mod_nsprefix_ + ':' if (UseCapturedNS_ and self.mod_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smod>%s</%smod>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.mod), input_name='mod')), namespaceprefix_ , eol_))
        if self.serie is not None:
            namespaceprefix_ = self.serie_nsprefix_ + ':' if (UseCapturedNS_ and self.serie_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sserie>%s</%sserie>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.serie), input_name='serie')), namespaceprefix_ , eol_))
        if self.nNF is not None:
            namespaceprefix_ = self.nNF_nsprefix_ + ':' if (UseCapturedNS_ and self.nNF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snNF>%s</%snNF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nNF), input_name='nNF')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'cUF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cUF')
            value_ = self.gds_validate_string(value_, node, 'cUF')
            self.cUF = value_
            self.cUF_nsprefix_ = child_.prefix
            # validate type TCodUfIBGE
            self.validate_TCodUfIBGE(self.cUF)
        elif nodeName_ == 'AAMM':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'AAMM')
            value_ = self.gds_validate_string(value_, node, 'AAMM')
            self.AAMM = value_
            self.AAMM_nsprefix_ = child_.prefix
            # validate type AAMMType
            self.validate_AAMMType(self.AAMM)
        elif nodeName_ == 'CNPJ':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CNPJ')
            value_ = self.gds_validate_string(value_, node, 'CNPJ')
            self.CNPJ = value_
            self.CNPJ_nsprefix_ = child_.prefix
            # validate type TCnpj
            self.validate_TCnpj(self.CNPJ)
        elif nodeName_ == 'mod':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'mod')
            value_ = self.gds_validate_string(value_, node, 'mod')
            self.mod = value_
            self.mod_nsprefix_ = child_.prefix
            # validate type modType
            self.validate_modType(self.mod)
        elif nodeName_ == 'serie':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'serie')
            value_ = self.gds_validate_string(value_, node, 'serie')
            self.serie = value_
            self.serie_nsprefix_ = child_.prefix
            # validate type TSerie
            self.validate_TSerie(self.serie)
        elif nodeName_ == 'nNF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nNF')
            value_ = self.gds_validate_string(value_, node, 'nNF')
            self.nNF = value_
            self.nNF_nsprefix_ = child_.prefix
            # validate type TNF
            self.validate_TNF(self.nNF)
# end class refNFType


class refNFPType(GeneratedsSuper):
    """Grupo com as informações NF de produtor referenciada"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('cUF', ['TCodUfIBGE', 'xs:string'], 0, 0, {'name': 'cUF', 'type': 'xs:string'}, None),
        MemberSpec_('AAMM', ['AAMMType1', 'xs:string'], 0, 0, {'name': 'AAMM', 'type': 'xs:string'}, None),
        MemberSpec_('CNPJ', ['TCnpj', 'xs:string'], 0, 0, {'name': 'CNPJ', 'type': 'xs:string'}, 5),
        MemberSpec_('CPF', ['TCpf', 'xs:string'], 0, 0, {'name': 'CPF', 'type': 'xs:string'}, 5),
        MemberSpec_('IE', ['TIeDest', 'xs:string'], 0, 0, {'name': 'IE', 'type': 'xs:string'}, None),
        MemberSpec_('mod', ['modType2', 'xs:string'], 0, 0, {'name': 'mod', 'type': 'xs:string'}, None),
        MemberSpec_('serie', ['TSerie', 'xs:string'], 0, 0, {'name': 'serie', 'type': 'xs:string'}, None),
        MemberSpec_('nNF', ['TNF', 'xs:string'], 0, 0, {'name': 'nNF', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, cUF=None, AAMM=None, CNPJ=None, CPF=None, IE=None, mod=None, serie=None, nNF=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.cUF = cUF
        self.validate_TCodUfIBGE(self.cUF)
        self.cUF_nsprefix_ = None
        self.AAMM = AAMM
        self.validate_AAMMType1(self.AAMM)
        self.AAMM_nsprefix_ = None
        self.CNPJ = CNPJ
        self.validate_TCnpj(self.CNPJ)
        self.CNPJ_nsprefix_ = None
        self.CPF = CPF
        self.validate_TCpf(self.CPF)
        self.CPF_nsprefix_ = None
        self.IE = IE
        self.validate_TIeDest(self.IE)
        self.IE_nsprefix_ = None
        self.mod = mod
        self.validate_modType2(self.mod)
        self.mod_nsprefix_ = None
        self.serie = serie
        self.validate_TSerie(self.serie)
        self.serie_nsprefix_ = None
        self.nNF = nNF
        self.validate_TNF(self.nNF)
        self.nNF_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, refNFPType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if refNFPType.subclass:
            return refNFPType.subclass(*args_, **kwargs_)
        else:
            return refNFPType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TCodUfIBGE(self, value):
        result = True
        # Validate type TCodUfIBGE, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['11', '12', '13', '14', '15', '16', '17', '21', '22', '23', '24', '25', '26', '27', '28', '29', '31', '32', '33', '35', '41', '42', '43', '50', '51', '52', '53']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TCodUfIBGE' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_AAMMType1(self, value):
        result = True
        # Validate type AAMMType1, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_AAMMType1_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_AAMMType1_patterns_, ))
                result = False
        return result
    validate_AAMMType1_patterns_ = [['^([0-9]{2}[0]{1}[1-9]{1}|[0-9]{2}[1]{1}[0-2]{1})$']]
    def validate_TCnpj(self, value):
        result = True
        # Validate type TCnpj, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 14:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TCnpj' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCnpj_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCnpj_patterns_, ))
                result = False
        return result
    validate_TCnpj_patterns_ = [['^([0-9]{14})$']]
    def validate_TCpf(self, value):
        result = True
        # Validate type TCpf, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 11:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TCpf' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCpf_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCpf_patterns_, ))
                result = False
        return result
    validate_TCpf_patterns_ = [['^([0-9]{11})$']]
    def validate_TIeDest(self, value):
        result = True
        # Validate type TIeDest, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 14:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TIeDest' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TIeDest_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TIeDest_patterns_, ))
                result = False
        return result
    validate_TIeDest_patterns_ = [['^(ISENTO|[0-9]{2,14})$']]
    def validate_modType2(self, value):
        result = True
        # Validate type modType2, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['01', '04']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on modType2' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TSerie(self, value):
        result = True
        # Validate type TSerie, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TSerie_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TSerie_patterns_, ))
                result = False
        return result
    validate_TSerie_patterns_ = [['^(0|[1-9]{1}[0-9]{0,2})$']]
    def validate_TNF(self, value):
        result = True
        # Validate type TNF, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TNF_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TNF_patterns_, ))
                result = False
        return result
    validate_TNF_patterns_ = [['^([1-9]{1}[0-9]{0,8})$']]
    def hasContent_(self):
        if (
            self.cUF is not None or
            self.AAMM is not None or
            self.CNPJ is not None or
            self.CPF is not None or
            self.IE is not None or
            self.mod is not None or
            self.serie is not None or
            self.nNF is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='refNFPType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('refNFPType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'refNFPType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='refNFPType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='refNFPType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='refNFPType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='refNFPType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.cUF is not None:
            namespaceprefix_ = self.cUF_nsprefix_ + ':' if (UseCapturedNS_ and self.cUF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scUF>%s</%scUF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cUF), input_name='cUF')), namespaceprefix_ , eol_))
        if self.AAMM is not None:
            namespaceprefix_ = self.AAMM_nsprefix_ + ':' if (UseCapturedNS_ and self.AAMM_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAAMM>%s</%sAAMM>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.AAMM), input_name='AAMM')), namespaceprefix_ , eol_))
        if self.CNPJ is not None:
            namespaceprefix_ = self.CNPJ_nsprefix_ + ':' if (UseCapturedNS_ and self.CNPJ_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCNPJ>%s</%sCNPJ>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CNPJ), input_name='CNPJ')), namespaceprefix_ , eol_))
        if self.CPF is not None:
            namespaceprefix_ = self.CPF_nsprefix_ + ':' if (UseCapturedNS_ and self.CPF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCPF>%s</%sCPF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CPF), input_name='CPF')), namespaceprefix_ , eol_))
        if self.IE is not None:
            namespaceprefix_ = self.IE_nsprefix_ + ':' if (UseCapturedNS_ and self.IE_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIE>%s</%sIE>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.IE), input_name='IE')), namespaceprefix_ , eol_))
        if self.mod is not None:
            namespaceprefix_ = self.mod_nsprefix_ + ':' if (UseCapturedNS_ and self.mod_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smod>%s</%smod>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.mod), input_name='mod')), namespaceprefix_ , eol_))
        if self.serie is not None:
            namespaceprefix_ = self.serie_nsprefix_ + ':' if (UseCapturedNS_ and self.serie_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sserie>%s</%sserie>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.serie), input_name='serie')), namespaceprefix_ , eol_))
        if self.nNF is not None:
            namespaceprefix_ = self.nNF_nsprefix_ + ':' if (UseCapturedNS_ and self.nNF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snNF>%s</%snNF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nNF), input_name='nNF')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'cUF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cUF')
            value_ = self.gds_validate_string(value_, node, 'cUF')
            self.cUF = value_
            self.cUF_nsprefix_ = child_.prefix
            # validate type TCodUfIBGE
            self.validate_TCodUfIBGE(self.cUF)
        elif nodeName_ == 'AAMM':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'AAMM')
            value_ = self.gds_validate_string(value_, node, 'AAMM')
            self.AAMM = value_
            self.AAMM_nsprefix_ = child_.prefix
            # validate type AAMMType1
            self.validate_AAMMType1(self.AAMM)
        elif nodeName_ == 'CNPJ':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CNPJ')
            value_ = self.gds_validate_string(value_, node, 'CNPJ')
            self.CNPJ = value_
            self.CNPJ_nsprefix_ = child_.prefix
            # validate type TCnpj
            self.validate_TCnpj(self.CNPJ)
        elif nodeName_ == 'CPF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CPF')
            value_ = self.gds_validate_string(value_, node, 'CPF')
            self.CPF = value_
            self.CPF_nsprefix_ = child_.prefix
            # validate type TCpf
            self.validate_TCpf(self.CPF)
        elif nodeName_ == 'IE':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'IE')
            value_ = self.gds_validate_string(value_, node, 'IE')
            self.IE = value_
            self.IE_nsprefix_ = child_.prefix
            # validate type TIeDest
            self.validate_TIeDest(self.IE)
        elif nodeName_ == 'mod':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'mod')
            value_ = self.gds_validate_string(value_, node, 'mod')
            self.mod = value_
            self.mod_nsprefix_ = child_.prefix
            # validate type modType2
            self.validate_modType2(self.mod)
        elif nodeName_ == 'serie':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'serie')
            value_ = self.gds_validate_string(value_, node, 'serie')
            self.serie = value_
            self.serie_nsprefix_ = child_.prefix
            # validate type TSerie
            self.validate_TSerie(self.serie)
        elif nodeName_ == 'nNF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nNF')
            value_ = self.gds_validate_string(value_, node, 'nNF')
            self.nNF = value_
            self.nNF_nsprefix_ = child_.prefix
            # validate type TNF
            self.validate_TNF(self.nNF)
# end class refNFPType


class refECFType(GeneratedsSuper):
    """Grupo do Cupom Fiscal vinculado à NF-e"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('mod', ['modType3', 'xs:string'], 0, 0, {'name': 'mod', 'type': 'xs:string'}, None),
        MemberSpec_('nECF', ['nECFType', 'xs:string'], 0, 0, {'name': 'nECF', 'type': 'xs:string'}, None),
        MemberSpec_('nCOO', ['nCOOType', 'xs:string'], 0, 0, {'name': 'nCOO', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, mod=None, nECF=None, nCOO=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.mod = mod
        self.validate_modType3(self.mod)
        self.mod_nsprefix_ = None
        self.nECF = nECF
        self.validate_nECFType(self.nECF)
        self.nECF_nsprefix_ = None
        self.nCOO = nCOO
        self.validate_nCOOType(self.nCOO)
        self.nCOO_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, refECFType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if refECFType.subclass:
            return refECFType.subclass(*args_, **kwargs_)
        else:
            return refECFType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_modType3(self, value):
        result = True
        # Validate type modType3, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['2B', '2C', '2D']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on modType3' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_nECFType(self, value):
        result = True
        # Validate type nECFType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_nECFType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nECFType_patterns_, ))
                result = False
        return result
    validate_nECFType_patterns_ = [['^([0-9]{1,3})$']]
    def validate_nCOOType(self, value):
        result = True
        # Validate type nCOOType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_nCOOType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nCOOType_patterns_, ))
                result = False
        return result
    validate_nCOOType_patterns_ = [['^([0-9]{1,6})$']]
    def hasContent_(self):
        if (
            self.mod is not None or
            self.nECF is not None or
            self.nCOO is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='refECFType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('refECFType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'refECFType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='refECFType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='refECFType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='refECFType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='refECFType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.mod is not None:
            namespaceprefix_ = self.mod_nsprefix_ + ':' if (UseCapturedNS_ and self.mod_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smod>%s</%smod>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.mod), input_name='mod')), namespaceprefix_ , eol_))
        if self.nECF is not None:
            namespaceprefix_ = self.nECF_nsprefix_ + ':' if (UseCapturedNS_ and self.nECF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snECF>%s</%snECF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nECF), input_name='nECF')), namespaceprefix_ , eol_))
        if self.nCOO is not None:
            namespaceprefix_ = self.nCOO_nsprefix_ + ':' if (UseCapturedNS_ and self.nCOO_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snCOO>%s</%snCOO>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nCOO), input_name='nCOO')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'mod':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'mod')
            value_ = self.gds_validate_string(value_, node, 'mod')
            self.mod = value_
            self.mod_nsprefix_ = child_.prefix
            # validate type modType3
            self.validate_modType3(self.mod)
        elif nodeName_ == 'nECF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nECF')
            value_ = self.gds_validate_string(value_, node, 'nECF')
            self.nECF = value_
            self.nECF_nsprefix_ = child_.prefix
            # validate type nECFType
            self.validate_nECFType(self.nECF)
        elif nodeName_ == 'nCOO':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nCOO')
            value_ = self.gds_validate_string(value_, node, 'nCOO')
            self.nCOO = value_
            self.nCOO_nsprefix_ = child_.prefix
            # validate type nCOOType
            self.validate_nCOOType(self.nCOO)
# end class refECFType


class emitType(GeneratedsSuper):
    """Identificação do emitenteGrupo de informações de interesse da
    Prefeitura"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('CNPJ', ['TCnpj', 'xs:string'], 0, 0, {'name': 'CNPJ', 'type': 'xs:string'}, 6),
        MemberSpec_('CPF', ['TCpf', 'xs:string'], 0, 0, {'name': 'CPF', 'type': 'xs:string'}, 6),
        MemberSpec_('xNome', ['xNomeType', 'TString', 'xs:string'], 0, 0, {'name': 'xNome', 'type': 'xs:string'}, None),
        MemberSpec_('xFant', ['xFantType', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'xFant', 'type': 'xs:string'}, None),
        MemberSpec_('enderEmit', 'TEnderEmi', 0, 0, {'name': 'enderEmit', 'type': 'TEnderEmi'}, None),
        MemberSpec_('IE', ['TIe', 'xs:string'], 0, 0, {'name': 'IE', 'type': 'xs:string'}, None),
        MemberSpec_('IEST', ['TIeST', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'IEST', 'type': 'xs:string'}, None),
        MemberSpec_('IM', ['IMType', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'IM', 'type': 'xs:string'}, None),
        MemberSpec_('CNAE', ['CNAEType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'CNAE', 'type': 'xs:string'}, None),
        MemberSpec_('CRT', ['CRTType', 'xs:string'], 0, 0, {'name': 'CRT', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, CNPJ=None, CPF=None, xNome=None, xFant=None, enderEmit=None, IE=None, IEST=None, IM=None, CNAE=None, CRT=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.CNPJ = CNPJ
        self.validate_TCnpj(self.CNPJ)
        self.CNPJ_nsprefix_ = None
        self.CPF = CPF
        self.validate_TCpf(self.CPF)
        self.CPF_nsprefix_ = None
        self.xNome = xNome
        self.validate_xNomeType(self.xNome)
        self.xNome_nsprefix_ = None
        self.xFant = xFant
        self.validate_xFantType(self.xFant)
        self.xFant_nsprefix_ = None
        self.enderEmit = enderEmit
        self.enderEmit_nsprefix_ = None
        self.IE = IE
        self.validate_TIe(self.IE)
        self.IE_nsprefix_ = None
        self.IEST = IEST
        self.validate_TIeST(self.IEST)
        self.IEST_nsprefix_ = None
        self.IM = IM
        self.validate_IMType(self.IM)
        self.IM_nsprefix_ = None
        self.CNAE = CNAE
        self.validate_CNAEType(self.CNAE)
        self.CNAE_nsprefix_ = None
        self.CRT = CRT
        self.validate_CRTType(self.CRT)
        self.CRT_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, emitType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if emitType.subclass:
            return emitType.subclass(*args_, **kwargs_)
        else:
            return emitType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TCnpj(self, value):
        result = True
        # Validate type TCnpj, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 14:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TCnpj' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCnpj_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCnpj_patterns_, ))
                result = False
        return result
    validate_TCnpj_patterns_ = [['^([0-9]{14})$']]
    def validate_TCpf(self, value):
        result = True
        # Validate type TCpf, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 11:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TCpf' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCpf_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCpf_patterns_, ))
                result = False
        return result
    validate_TCpf_patterns_ = [['^([0-9]{11})$']]
    def validate_xNomeType(self, value):
        result = True
        # Validate type xNomeType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xNomeType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xNomeType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xNomeType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xNomeType_patterns_, ))
                result = False
        return result
    validate_xNomeType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_xFantType(self, value):
        result = True
        # Validate type xFantType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xFantType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xFantType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xFantType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xFantType_patterns_, ))
                result = False
        return result
    validate_xFantType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TIe(self, value):
        result = True
        # Validate type TIe, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 14:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TIe' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TIe_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TIe_patterns_, ))
                result = False
        return result
    validate_TIe_patterns_ = [['^([0-9]{2,14}|ISENTO)$']]
    def validate_TIeST(self, value):
        result = True
        # Validate type TIeST, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 14:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TIeST' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TIeST_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TIeST_patterns_, ))
                result = False
        return result
    validate_TIeST_patterns_ = [['^([0-9]{2,14})$']]
    def validate_IMType(self, value):
        result = True
        # Validate type IMType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 15:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on IMType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on IMType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_IMType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_IMType_patterns_, ))
                result = False
        return result
    validate_IMType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_CNAEType(self, value):
        result = True
        # Validate type CNAEType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_CNAEType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_CNAEType_patterns_, ))
                result = False
        return result
    validate_CNAEType_patterns_ = [['^([0-9]{7})$']]
    def validate_CRTType(self, value):
        result = True
        # Validate type CRTType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['1', '2', '3']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on CRTType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def hasContent_(self):
        if (
            self.CNPJ is not None or
            self.CPF is not None or
            self.xNome is not None or
            self.xFant is not None or
            self.enderEmit is not None or
            self.IE is not None or
            self.IEST is not None or
            self.IM is not None or
            self.CNAE is not None or
            self.CRT is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='emitType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('emitType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'emitType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='emitType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='emitType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='emitType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='emitType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CNPJ is not None:
            namespaceprefix_ = self.CNPJ_nsprefix_ + ':' if (UseCapturedNS_ and self.CNPJ_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCNPJ>%s</%sCNPJ>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CNPJ), input_name='CNPJ')), namespaceprefix_ , eol_))
        if self.CPF is not None:
            namespaceprefix_ = self.CPF_nsprefix_ + ':' if (UseCapturedNS_ and self.CPF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCPF>%s</%sCPF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CPF), input_name='CPF')), namespaceprefix_ , eol_))
        if self.xNome is not None:
            namespaceprefix_ = self.xNome_nsprefix_ + ':' if (UseCapturedNS_ and self.xNome_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxNome>%s</%sxNome>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xNome), input_name='xNome')), namespaceprefix_ , eol_))
        if self.xFant is not None:
            namespaceprefix_ = self.xFant_nsprefix_ + ':' if (UseCapturedNS_ and self.xFant_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxFant>%s</%sxFant>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xFant), input_name='xFant')), namespaceprefix_ , eol_))
        if self.enderEmit is not None:
            namespaceprefix_ = self.enderEmit_nsprefix_ + ':' if (UseCapturedNS_ and self.enderEmit_nsprefix_) else ''
            self.enderEmit.export(outfile, level, namespaceprefix_, namespacedef_='', name_='enderEmit', pretty_print=pretty_print)
        if self.IE is not None:
            namespaceprefix_ = self.IE_nsprefix_ + ':' if (UseCapturedNS_ and self.IE_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIE>%s</%sIE>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.IE), input_name='IE')), namespaceprefix_ , eol_))
        if self.IEST is not None:
            namespaceprefix_ = self.IEST_nsprefix_ + ':' if (UseCapturedNS_ and self.IEST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIEST>%s</%sIEST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.IEST), input_name='IEST')), namespaceprefix_ , eol_))
        if self.IM is not None:
            namespaceprefix_ = self.IM_nsprefix_ + ':' if (UseCapturedNS_ and self.IM_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIM>%s</%sIM>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.IM), input_name='IM')), namespaceprefix_ , eol_))
        if self.CNAE is not None:
            namespaceprefix_ = self.CNAE_nsprefix_ + ':' if (UseCapturedNS_ and self.CNAE_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCNAE>%s</%sCNAE>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CNAE), input_name='CNAE')), namespaceprefix_ , eol_))
        if self.CRT is not None:
            namespaceprefix_ = self.CRT_nsprefix_ + ':' if (UseCapturedNS_ and self.CRT_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCRT>%s</%sCRT>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CRT), input_name='CRT')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CNPJ':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CNPJ')
            value_ = self.gds_validate_string(value_, node, 'CNPJ')
            self.CNPJ = value_
            self.CNPJ_nsprefix_ = child_.prefix
            # validate type TCnpj
            self.validate_TCnpj(self.CNPJ)
        elif nodeName_ == 'CPF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CPF')
            value_ = self.gds_validate_string(value_, node, 'CPF')
            self.CPF = value_
            self.CPF_nsprefix_ = child_.prefix
            # validate type TCpf
            self.validate_TCpf(self.CPF)
        elif nodeName_ == 'xNome':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xNome')
            value_ = self.gds_validate_string(value_, node, 'xNome')
            self.xNome = value_
            self.xNome_nsprefix_ = child_.prefix
            # validate type xNomeType
            self.validate_xNomeType(self.xNome)
        elif nodeName_ == 'xFant':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xFant')
            value_ = self.gds_validate_string(value_, node, 'xFant')
            self.xFant = value_
            self.xFant_nsprefix_ = child_.prefix
            # validate type xFantType
            self.validate_xFantType(self.xFant)
        elif nodeName_ == 'enderEmit':
            obj_ = TEnderEmi.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.enderEmit = obj_
            obj_.original_tagname_ = 'enderEmit'
        elif nodeName_ == 'IE':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'IE')
            value_ = self.gds_validate_string(value_, node, 'IE')
            self.IE = value_
            self.IE_nsprefix_ = child_.prefix
            # validate type TIe
            self.validate_TIe(self.IE)
        elif nodeName_ == 'IEST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'IEST')
            value_ = self.gds_validate_string(value_, node, 'IEST')
            self.IEST = value_
            self.IEST_nsprefix_ = child_.prefix
            # validate type TIeST
            self.validate_TIeST(self.IEST)
        elif nodeName_ == 'IM':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'IM')
            value_ = self.gds_validate_string(value_, node, 'IM')
            self.IM = value_
            self.IM_nsprefix_ = child_.prefix
            # validate type IMType
            self.validate_IMType(self.IM)
        elif nodeName_ == 'CNAE':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CNAE')
            value_ = self.gds_validate_string(value_, node, 'CNAE')
            self.CNAE = value_
            self.CNAE_nsprefix_ = child_.prefix
            # validate type CNAEType
            self.validate_CNAEType(self.CNAE)
        elif nodeName_ == 'CRT':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CRT')
            value_ = self.gds_validate_string(value_, node, 'CRT')
            self.CRT = value_
            self.CRT_nsprefix_ = child_.prefix
            # validate type CRTType
            self.validate_CRTType(self.CRT)
# end class emitType


class avulsaType(GeneratedsSuper):
    """Emissão de avulsa, informar os dados do Fisco emitente"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('CNPJ', ['TCnpj', 'xs:string'], 0, 0, {'name': 'CNPJ', 'type': 'xs:string'}, None),
        MemberSpec_('xOrgao', ['xOrgaoType', 'TString', 'xs:string'], 0, 0, {'name': 'xOrgao', 'type': 'xs:string'}, None),
        MemberSpec_('matr', ['matrType', 'TString', 'xs:string'], 0, 0, {'name': 'matr', 'type': 'xs:string'}, None),
        MemberSpec_('xAgente', ['xAgenteType', 'TString', 'xs:string'], 0, 0, {'name': 'xAgente', 'type': 'xs:string'}, None),
        MemberSpec_('fone', ['foneType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'fone', 'type': 'xs:string'}, None),
        MemberSpec_('UF', ['TUfEmi', 'xs:string'], 0, 0, {'name': 'UF', 'type': 'xs:string'}, None),
        MemberSpec_('nDAR', ['nDARType', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'nDAR', 'type': 'xs:string'}, None),
        MemberSpec_('dEmi', ['TData', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'dEmi', 'type': 'xs:string'}, None),
        MemberSpec_('vDAR', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vDAR', 'type': 'xs:string'}, None),
        MemberSpec_('repEmi', ['repEmiType', 'TString', 'xs:string'], 0, 0, {'name': 'repEmi', 'type': 'xs:string'}, None),
        MemberSpec_('dPag', ['TData', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'dPag', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, CNPJ=None, xOrgao=None, matr=None, xAgente=None, fone=None, UF=None, nDAR=None, dEmi=None, vDAR=None, repEmi=None, dPag=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.CNPJ = CNPJ
        self.validate_TCnpj(self.CNPJ)
        self.CNPJ_nsprefix_ = None
        self.xOrgao = xOrgao
        self.validate_xOrgaoType(self.xOrgao)
        self.xOrgao_nsprefix_ = None
        self.matr = matr
        self.validate_matrType(self.matr)
        self.matr_nsprefix_ = None
        self.xAgente = xAgente
        self.validate_xAgenteType(self.xAgente)
        self.xAgente_nsprefix_ = None
        self.fone = fone
        self.validate_foneType(self.fone)
        self.fone_nsprefix_ = None
        self.UF = UF
        self.validate_TUfEmi(self.UF)
        self.UF_nsprefix_ = None
        self.nDAR = nDAR
        self.validate_nDARType(self.nDAR)
        self.nDAR_nsprefix_ = None
        self.dEmi = dEmi
        self.validate_TData(self.dEmi)
        self.dEmi_nsprefix_ = None
        self.vDAR = vDAR
        self.validate_TDec_1302(self.vDAR)
        self.vDAR_nsprefix_ = None
        self.repEmi = repEmi
        self.validate_repEmiType(self.repEmi)
        self.repEmi_nsprefix_ = None
        self.dPag = dPag
        self.validate_TData(self.dPag)
        self.dPag_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, avulsaType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if avulsaType.subclass:
            return avulsaType.subclass(*args_, **kwargs_)
        else:
            return avulsaType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TCnpj(self, value):
        result = True
        # Validate type TCnpj, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 14:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TCnpj' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCnpj_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCnpj_patterns_, ))
                result = False
        return result
    validate_TCnpj_patterns_ = [['^([0-9]{14})$']]
    def validate_xOrgaoType(self, value):
        result = True
        # Validate type xOrgaoType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xOrgaoType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xOrgaoType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xOrgaoType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xOrgaoType_patterns_, ))
                result = False
        return result
    validate_xOrgaoType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_matrType(self, value):
        result = True
        # Validate type matrType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on matrType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on matrType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_matrType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_matrType_patterns_, ))
                result = False
        return result
    validate_matrType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_xAgenteType(self, value):
        result = True
        # Validate type xAgenteType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xAgenteType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xAgenteType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xAgenteType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xAgenteType_patterns_, ))
                result = False
        return result
    validate_xAgenteType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_foneType(self, value):
        result = True
        # Validate type foneType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_foneType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_foneType_patterns_, ))
                result = False
        return result
    validate_foneType_patterns_ = [['^([0-9]{6,14})$']]
    def validate_TUfEmi(self, value):
        result = True
        # Validate type TUfEmi, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['AC', 'AL', 'AM', 'AP', 'BA', 'CE', 'DF', 'ES', 'GO', 'MA', 'MG', 'MS', 'MT', 'PA', 'PB', 'PE', 'PI', 'PR', 'RJ', 'RN', 'RO', 'RR', 'RS', 'SC', 'SE', 'SP', 'TO']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TUfEmi' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_nDARType(self, value):
        result = True
        # Validate type nDARType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on nDARType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nDARType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_nDARType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nDARType_patterns_, ))
                result = False
        return result
    validate_nDARType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TData(self, value):
        result = True
        # Validate type TData, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TData_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TData_patterns_, ))
                result = False
        return result
    validate_TData_patterns_ = [['^((((20(([02468][048])|([13579][26]))-02-29))|(20[0-9][0-9])-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\\d)|(2[0-8])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30))))))$']]
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def validate_repEmiType(self, value):
        result = True
        # Validate type repEmiType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on repEmiType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on repEmiType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_repEmiType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_repEmiType_patterns_, ))
                result = False
        return result
    validate_repEmiType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def hasContent_(self):
        if (
            self.CNPJ is not None or
            self.xOrgao is not None or
            self.matr is not None or
            self.xAgente is not None or
            self.fone is not None or
            self.UF is not None or
            self.nDAR is not None or
            self.dEmi is not None or
            self.vDAR is not None or
            self.repEmi is not None or
            self.dPag is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='avulsaType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('avulsaType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'avulsaType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='avulsaType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='avulsaType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='avulsaType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='avulsaType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CNPJ is not None:
            namespaceprefix_ = self.CNPJ_nsprefix_ + ':' if (UseCapturedNS_ and self.CNPJ_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCNPJ>%s</%sCNPJ>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CNPJ), input_name='CNPJ')), namespaceprefix_ , eol_))
        if self.xOrgao is not None:
            namespaceprefix_ = self.xOrgao_nsprefix_ + ':' if (UseCapturedNS_ and self.xOrgao_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxOrgao>%s</%sxOrgao>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xOrgao), input_name='xOrgao')), namespaceprefix_ , eol_))
        if self.matr is not None:
            namespaceprefix_ = self.matr_nsprefix_ + ':' if (UseCapturedNS_ and self.matr_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smatr>%s</%smatr>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.matr), input_name='matr')), namespaceprefix_ , eol_))
        if self.xAgente is not None:
            namespaceprefix_ = self.xAgente_nsprefix_ + ':' if (UseCapturedNS_ and self.xAgente_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxAgente>%s</%sxAgente>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xAgente), input_name='xAgente')), namespaceprefix_ , eol_))
        if self.fone is not None:
            namespaceprefix_ = self.fone_nsprefix_ + ':' if (UseCapturedNS_ and self.fone_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfone>%s</%sfone>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.fone), input_name='fone')), namespaceprefix_ , eol_))
        if self.UF is not None:
            namespaceprefix_ = self.UF_nsprefix_ + ':' if (UseCapturedNS_ and self.UF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUF>%s</%sUF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.UF), input_name='UF')), namespaceprefix_ , eol_))
        if self.nDAR is not None:
            namespaceprefix_ = self.nDAR_nsprefix_ + ':' if (UseCapturedNS_ and self.nDAR_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snDAR>%s</%snDAR>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nDAR), input_name='nDAR')), namespaceprefix_ , eol_))
        if self.dEmi is not None:
            namespaceprefix_ = self.dEmi_nsprefix_ + ':' if (UseCapturedNS_ and self.dEmi_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdEmi>%s</%sdEmi>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.dEmi), input_name='dEmi')), namespaceprefix_ , eol_))
        if self.vDAR is not None:
            namespaceprefix_ = self.vDAR_nsprefix_ + ':' if (UseCapturedNS_ and self.vDAR_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svDAR>%s</%svDAR>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vDAR), input_name='vDAR')), namespaceprefix_ , eol_))
        if self.repEmi is not None:
            namespaceprefix_ = self.repEmi_nsprefix_ + ':' if (UseCapturedNS_ and self.repEmi_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srepEmi>%s</%srepEmi>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.repEmi), input_name='repEmi')), namespaceprefix_ , eol_))
        if self.dPag is not None:
            namespaceprefix_ = self.dPag_nsprefix_ + ':' if (UseCapturedNS_ and self.dPag_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdPag>%s</%sdPag>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.dPag), input_name='dPag')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CNPJ':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CNPJ')
            value_ = self.gds_validate_string(value_, node, 'CNPJ')
            self.CNPJ = value_
            self.CNPJ_nsprefix_ = child_.prefix
            # validate type TCnpj
            self.validate_TCnpj(self.CNPJ)
        elif nodeName_ == 'xOrgao':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xOrgao')
            value_ = self.gds_validate_string(value_, node, 'xOrgao')
            self.xOrgao = value_
            self.xOrgao_nsprefix_ = child_.prefix
            # validate type xOrgaoType
            self.validate_xOrgaoType(self.xOrgao)
        elif nodeName_ == 'matr':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'matr')
            value_ = self.gds_validate_string(value_, node, 'matr')
            self.matr = value_
            self.matr_nsprefix_ = child_.prefix
            # validate type matrType
            self.validate_matrType(self.matr)
        elif nodeName_ == 'xAgente':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xAgente')
            value_ = self.gds_validate_string(value_, node, 'xAgente')
            self.xAgente = value_
            self.xAgente_nsprefix_ = child_.prefix
            # validate type xAgenteType
            self.validate_xAgenteType(self.xAgente)
        elif nodeName_ == 'fone':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'fone')
            value_ = self.gds_validate_string(value_, node, 'fone')
            self.fone = value_
            self.fone_nsprefix_ = child_.prefix
            # validate type foneType
            self.validate_foneType(self.fone)
        elif nodeName_ == 'UF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'UF')
            value_ = self.gds_validate_string(value_, node, 'UF')
            self.UF = value_
            self.UF_nsprefix_ = child_.prefix
            # validate type TUfEmi
            self.validate_TUfEmi(self.UF)
        elif nodeName_ == 'nDAR':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nDAR')
            value_ = self.gds_validate_string(value_, node, 'nDAR')
            self.nDAR = value_
            self.nDAR_nsprefix_ = child_.prefix
            # validate type nDARType
            self.validate_nDARType(self.nDAR)
        elif nodeName_ == 'dEmi':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'dEmi')
            value_ = self.gds_validate_string(value_, node, 'dEmi')
            self.dEmi = value_
            self.dEmi_nsprefix_ = child_.prefix
            # validate type TData
            self.validate_TData(self.dEmi)
        elif nodeName_ == 'vDAR':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vDAR')
            value_ = self.gds_validate_string(value_, node, 'vDAR')
            self.vDAR = value_
            self.vDAR_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vDAR)
        elif nodeName_ == 'repEmi':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'repEmi')
            value_ = self.gds_validate_string(value_, node, 'repEmi')
            self.repEmi = value_
            self.repEmi_nsprefix_ = child_.prefix
            # validate type repEmiType
            self.validate_repEmiType(self.repEmi)
        elif nodeName_ == 'dPag':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'dPag')
            value_ = self.gds_validate_string(value_, node, 'dPag')
            self.dPag = value_
            self.dPag_nsprefix_ = child_.prefix
            # validate type TData
            self.validate_TData(self.dPag)
# end class avulsaType


class destType(GeneratedsSuper):
    """Identificação do Destinatário"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('CNPJ', ['TCnpj', 'xs:string'], 0, 0, {'name': 'CNPJ', 'type': 'xs:string'}, 7),
        MemberSpec_('CPF', ['TCpf', 'xs:string'], 0, 0, {'name': 'CPF', 'type': 'xs:string'}, 7),
        MemberSpec_('idEstrangeiro', ['idEstrangeiroType', 'xs:string'], 0, 0, {'name': 'idEstrangeiro', 'type': 'xs:string'}, 7),
        MemberSpec_('xNome', ['xNomeType4', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'xNome', 'type': 'xs:string'}, None),
        MemberSpec_('enderDest', 'TEndereco', 0, 1, {'minOccurs': '0', 'name': 'enderDest', 'type': 'TEndereco'}, None),
        MemberSpec_('indIEDest', ['indIEDestType', 'xs:string'], 0, 0, {'name': 'indIEDest', 'type': 'xs:string'}, None),
        MemberSpec_('IE', ['TIeDestNaoIsento', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'IE', 'type': 'xs:string'}, None),
        MemberSpec_('ISUF', ['ISUFType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'ISUF', 'type': 'xs:string'}, None),
        MemberSpec_('IM', ['IMType5', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'IM', 'type': 'xs:string'}, None),
        MemberSpec_('email', ['emailType', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'email', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, CNPJ=None, CPF=None, idEstrangeiro=None, xNome=None, enderDest=None, indIEDest=None, IE=None, ISUF=None, IM=None, email=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.CNPJ = CNPJ
        self.validate_TCnpj(self.CNPJ)
        self.CNPJ_nsprefix_ = None
        self.CPF = CPF
        self.validate_TCpf(self.CPF)
        self.CPF_nsprefix_ = None
        self.idEstrangeiro = idEstrangeiro
        self.validate_idEstrangeiroType(self.idEstrangeiro)
        self.idEstrangeiro_nsprefix_ = None
        self.xNome = xNome
        self.validate_xNomeType4(self.xNome)
        self.xNome_nsprefix_ = None
        self.enderDest = enderDest
        self.enderDest_nsprefix_ = None
        self.indIEDest = indIEDest
        self.validate_indIEDestType(self.indIEDest)
        self.indIEDest_nsprefix_ = None
        self.IE = IE
        self.validate_TIeDestNaoIsento(self.IE)
        self.IE_nsprefix_ = None
        self.ISUF = ISUF
        self.validate_ISUFType(self.ISUF)
        self.ISUF_nsprefix_ = None
        self.IM = IM
        self.validate_IMType5(self.IM)
        self.IM_nsprefix_ = None
        self.email = email
        self.validate_emailType(self.email)
        self.email_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, destType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if destType.subclass:
            return destType.subclass(*args_, **kwargs_)
        else:
            return destType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TCnpj(self, value):
        result = True
        # Validate type TCnpj, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 14:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TCnpj' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCnpj_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCnpj_patterns_, ))
                result = False
        return result
    validate_TCnpj_patterns_ = [['^([0-9]{14})$']]
    def validate_TCpf(self, value):
        result = True
        # Validate type TCpf, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 11:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TCpf' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCpf_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCpf_patterns_, ))
                result = False
        return result
    validate_TCpf_patterns_ = [['^([0-9]{11})$']]
    def validate_idEstrangeiroType(self, value):
        result = True
        # Validate type idEstrangeiroType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_idEstrangeiroType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_idEstrangeiroType_patterns_, ))
                result = False
        return result
    validate_idEstrangeiroType_patterns_ = [['^(([!-ÿ]{0}|[!-ÿ]{5,20})?)$']]
    def validate_xNomeType4(self, value):
        result = True
        # Validate type xNomeType4, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xNomeType4' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xNomeType4' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xNomeType4_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xNomeType4_patterns_, ))
                result = False
        return result
    validate_xNomeType4_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_indIEDestType(self, value):
        result = True
        # Validate type indIEDestType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['1', '2', '9']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on indIEDestType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TIeDestNaoIsento(self, value):
        result = True
        # Validate type TIeDestNaoIsento, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 14:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TIeDestNaoIsento' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TIeDestNaoIsento_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TIeDestNaoIsento_patterns_, ))
                result = False
        return result
    validate_TIeDestNaoIsento_patterns_ = [['^([0-9]{2,14})$']]
    def validate_ISUFType(self, value):
        result = True
        # Validate type ISUFType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_ISUFType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ISUFType_patterns_, ))
                result = False
        return result
    validate_ISUFType_patterns_ = [['^([0-9]{8,9})$']]
    def validate_IMType5(self, value):
        result = True
        # Validate type IMType5, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 15:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on IMType5' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on IMType5' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_IMType5_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_IMType5_patterns_, ))
                result = False
        return result
    validate_IMType5_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_emailType(self, value):
        result = True
        # Validate type emailType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on emailType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on emailType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_emailType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_emailType_patterns_, ))
                result = False
        return result
    validate_emailType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def hasContent_(self):
        if (
            self.CNPJ is not None or
            self.CPF is not None or
            self.idEstrangeiro is not None or
            self.xNome is not None or
            self.enderDest is not None or
            self.indIEDest is not None or
            self.IE is not None or
            self.ISUF is not None or
            self.IM is not None or
            self.email is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='destType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('destType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'destType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='destType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='destType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='destType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='destType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CNPJ is not None:
            namespaceprefix_ = self.CNPJ_nsprefix_ + ':' if (UseCapturedNS_ and self.CNPJ_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCNPJ>%s</%sCNPJ>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CNPJ), input_name='CNPJ')), namespaceprefix_ , eol_))
        if self.CPF is not None:
            namespaceprefix_ = self.CPF_nsprefix_ + ':' if (UseCapturedNS_ and self.CPF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCPF>%s</%sCPF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CPF), input_name='CPF')), namespaceprefix_ , eol_))
        if self.idEstrangeiro is not None:
            namespaceprefix_ = self.idEstrangeiro_nsprefix_ + ':' if (UseCapturedNS_ and self.idEstrangeiro_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sidEstrangeiro>%s</%sidEstrangeiro>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.idEstrangeiro), input_name='idEstrangeiro')), namespaceprefix_ , eol_))
        if self.xNome is not None:
            namespaceprefix_ = self.xNome_nsprefix_ + ':' if (UseCapturedNS_ and self.xNome_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxNome>%s</%sxNome>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xNome), input_name='xNome')), namespaceprefix_ , eol_))
        if self.enderDest is not None:
            namespaceprefix_ = self.enderDest_nsprefix_ + ':' if (UseCapturedNS_ and self.enderDest_nsprefix_) else ''
            self.enderDest.export(outfile, level, namespaceprefix_, namespacedef_='', name_='enderDest', pretty_print=pretty_print)
        if self.indIEDest is not None:
            namespaceprefix_ = self.indIEDest_nsprefix_ + ':' if (UseCapturedNS_ and self.indIEDest_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sindIEDest>%s</%sindIEDest>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.indIEDest), input_name='indIEDest')), namespaceprefix_ , eol_))
        if self.IE is not None:
            namespaceprefix_ = self.IE_nsprefix_ + ':' if (UseCapturedNS_ and self.IE_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIE>%s</%sIE>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.IE), input_name='IE')), namespaceprefix_ , eol_))
        if self.ISUF is not None:
            namespaceprefix_ = self.ISUF_nsprefix_ + ':' if (UseCapturedNS_ and self.ISUF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sISUF>%s</%sISUF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ISUF), input_name='ISUF')), namespaceprefix_ , eol_))
        if self.IM is not None:
            namespaceprefix_ = self.IM_nsprefix_ + ':' if (UseCapturedNS_ and self.IM_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIM>%s</%sIM>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.IM), input_name='IM')), namespaceprefix_ , eol_))
        if self.email is not None:
            namespaceprefix_ = self.email_nsprefix_ + ':' if (UseCapturedNS_ and self.email_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%semail>%s</%semail>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.email), input_name='email')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CNPJ':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CNPJ')
            value_ = self.gds_validate_string(value_, node, 'CNPJ')
            self.CNPJ = value_
            self.CNPJ_nsprefix_ = child_.prefix
            # validate type TCnpj
            self.validate_TCnpj(self.CNPJ)
        elif nodeName_ == 'CPF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CPF')
            value_ = self.gds_validate_string(value_, node, 'CPF')
            self.CPF = value_
            self.CPF_nsprefix_ = child_.prefix
            # validate type TCpf
            self.validate_TCpf(self.CPF)
        elif nodeName_ == 'idEstrangeiro':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'idEstrangeiro')
            value_ = self.gds_validate_string(value_, node, 'idEstrangeiro')
            self.idEstrangeiro = value_
            self.idEstrangeiro_nsprefix_ = child_.prefix
            # validate type idEstrangeiroType
            self.validate_idEstrangeiroType(self.idEstrangeiro)
        elif nodeName_ == 'xNome':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xNome')
            value_ = self.gds_validate_string(value_, node, 'xNome')
            self.xNome = value_
            self.xNome_nsprefix_ = child_.prefix
            # validate type xNomeType4
            self.validate_xNomeType4(self.xNome)
        elif nodeName_ == 'enderDest':
            obj_ = TEndereco.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.enderDest = obj_
            obj_.original_tagname_ = 'enderDest'
        elif nodeName_ == 'indIEDest':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'indIEDest')
            value_ = self.gds_validate_string(value_, node, 'indIEDest')
            self.indIEDest = value_
            self.indIEDest_nsprefix_ = child_.prefix
            # validate type indIEDestType
            self.validate_indIEDestType(self.indIEDest)
        elif nodeName_ == 'IE':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'IE')
            value_ = self.gds_validate_string(value_, node, 'IE')
            self.IE = value_
            self.IE_nsprefix_ = child_.prefix
            # validate type TIeDestNaoIsento
            self.validate_TIeDestNaoIsento(self.IE)
        elif nodeName_ == 'ISUF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ISUF')
            value_ = self.gds_validate_string(value_, node, 'ISUF')
            self.ISUF = value_
            self.ISUF_nsprefix_ = child_.prefix
            # validate type ISUFType
            self.validate_ISUFType(self.ISUF)
        elif nodeName_ == 'IM':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'IM')
            value_ = self.gds_validate_string(value_, node, 'IM')
            self.IM = value_
            self.IM_nsprefix_ = child_.prefix
            # validate type IMType5
            self.validate_IMType5(self.IM)
        elif nodeName_ == 'email':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'email')
            value_ = self.gds_validate_string(value_, node, 'email')
            self.email = value_
            self.email_nsprefix_ = child_.prefix
            # validate type emailType
            self.validate_emailType(self.email)
# end class destType


class autXMLType(GeneratedsSuper):
    """Pessoas autorizadas para o download do XML da NF-e"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('CNPJ', ['TCnpj', 'xs:string'], 0, 0, {'name': 'CNPJ', 'type': 'xs:string'}, 8),
        MemberSpec_('CPF', ['TCpf', 'xs:string'], 0, 0, {'name': 'CPF', 'type': 'xs:string'}, 8),
    ]
    subclass = None
    superclass = None
    def __init__(self, CNPJ=None, CPF=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.CNPJ = CNPJ
        self.validate_TCnpj(self.CNPJ)
        self.CNPJ_nsprefix_ = None
        self.CPF = CPF
        self.validate_TCpf(self.CPF)
        self.CPF_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, autXMLType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if autXMLType.subclass:
            return autXMLType.subclass(*args_, **kwargs_)
        else:
            return autXMLType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TCnpj(self, value):
        result = True
        # Validate type TCnpj, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 14:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TCnpj' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCnpj_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCnpj_patterns_, ))
                result = False
        return result
    validate_TCnpj_patterns_ = [['^([0-9]{14})$']]
    def validate_TCpf(self, value):
        result = True
        # Validate type TCpf, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 11:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TCpf' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCpf_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCpf_patterns_, ))
                result = False
        return result
    validate_TCpf_patterns_ = [['^([0-9]{11})$']]
    def hasContent_(self):
        if (
            self.CNPJ is not None or
            self.CPF is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='autXMLType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('autXMLType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'autXMLType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='autXMLType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='autXMLType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='autXMLType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='autXMLType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CNPJ is not None:
            namespaceprefix_ = self.CNPJ_nsprefix_ + ':' if (UseCapturedNS_ and self.CNPJ_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCNPJ>%s</%sCNPJ>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CNPJ), input_name='CNPJ')), namespaceprefix_ , eol_))
        if self.CPF is not None:
            namespaceprefix_ = self.CPF_nsprefix_ + ':' if (UseCapturedNS_ and self.CPF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCPF>%s</%sCPF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CPF), input_name='CPF')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CNPJ':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CNPJ')
            value_ = self.gds_validate_string(value_, node, 'CNPJ')
            self.CNPJ = value_
            self.CNPJ_nsprefix_ = child_.prefix
            # validate type TCnpj
            self.validate_TCnpj(self.CNPJ)
        elif nodeName_ == 'CPF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CPF')
            value_ = self.gds_validate_string(value_, node, 'CPF')
            self.CPF = value_
            self.CPF_nsprefix_ = child_.prefix
            # validate type TCpf
            self.validate_TCpf(self.CPF)
# end class autXMLType


class detType(GeneratedsSuper):
    """Dados dos detalhes da NF-eNúmero do item do NF"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('nItem', 'nItemType', 0, 0, {'use': 'required'}),
        MemberSpec_('prod', 'prodType', 0, 0, {'name': 'prod', 'type': 'prodType'}, None),
        MemberSpec_('imposto', 'impostoType', 0, 0, {'name': 'imposto', 'type': 'impostoType'}, None),
        MemberSpec_('impostoDevol', 'impostoDevolType', 0, 1, {'minOccurs': '0', 'name': 'impostoDevol', 'type': 'impostoDevolType'}, None),
        MemberSpec_('infAdProd', ['infAdProdType', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'infAdProd', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, nItem=None, prod=None, imposto=None, impostoDevol=None, infAdProd=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nItem = _cast(None, nItem)
        self.nItem_nsprefix_ = None
        self.prod = prod
        self.prod_nsprefix_ = None
        self.imposto = imposto
        self.imposto_nsprefix_ = None
        self.impostoDevol = impostoDevol
        self.impostoDevol_nsprefix_ = None
        self.infAdProd = infAdProd
        self.validate_infAdProdType(self.infAdProd)
        self.infAdProd_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, detType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if detType.subclass:
            return detType.subclass(*args_, **kwargs_)
        else:
            return detType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_infAdProdType(self, value):
        result = True
        # Validate type infAdProdType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 500:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on infAdProdType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on infAdProdType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_infAdProdType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_infAdProdType_patterns_, ))
                result = False
        return result
    validate_infAdProdType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_nItemType(self, value):
        # Validate type nItemType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_nItemType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nItemType_patterns_, ))
    validate_nItemType_patterns_ = [['^([1-9]{1}[0-9]{0,1}|[1-8]{1}[0-9]{2}|[9]{1}[0-8]{1}[0-9]{1}|[9]{1}[9]{1}[0]{1})$']]
    def hasContent_(self):
        if (
            self.prod is not None or
            self.imposto is not None or
            self.impostoDevol is not None or
            self.infAdProd is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='detType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('detType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'detType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='detType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='detType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='detType'):
        if self.nItem is not None and 'nItem' not in already_processed:
            already_processed.add('nItem')
            outfile.write(' nItem=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.nItem), input_name='nItem')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='detType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.prod is not None:
            namespaceprefix_ = self.prod_nsprefix_ + ':' if (UseCapturedNS_ and self.prod_nsprefix_) else ''
            self.prod.export(outfile, level, namespaceprefix_, namespacedef_='', name_='prod', pretty_print=pretty_print)
        if self.imposto is not None:
            namespaceprefix_ = self.imposto_nsprefix_ + ':' if (UseCapturedNS_ and self.imposto_nsprefix_) else ''
            self.imposto.export(outfile, level, namespaceprefix_, namespacedef_='', name_='imposto', pretty_print=pretty_print)
        if self.impostoDevol is not None:
            namespaceprefix_ = self.impostoDevol_nsprefix_ + ':' if (UseCapturedNS_ and self.impostoDevol_nsprefix_) else ''
            self.impostoDevol.export(outfile, level, namespaceprefix_, namespacedef_='', name_='impostoDevol', pretty_print=pretty_print)
        if self.infAdProd is not None:
            namespaceprefix_ = self.infAdProd_nsprefix_ + ':' if (UseCapturedNS_ and self.infAdProd_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinfAdProd>%s</%sinfAdProd>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.infAdProd), input_name='infAdProd')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nItem', node)
        if value is not None and 'nItem' not in already_processed:
            already_processed.add('nItem')
            self.nItem = value
            self.validate_nItemType(self.nItem)    # validate type nItemType
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'prod':
            obj_ = prodType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.prod = obj_
            obj_.original_tagname_ = 'prod'
        elif nodeName_ == 'imposto':
            obj_ = impostoType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.imposto = obj_
            obj_.original_tagname_ = 'imposto'
        elif nodeName_ == 'impostoDevol':
            obj_ = impostoDevolType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.impostoDevol = obj_
            obj_.original_tagname_ = 'impostoDevol'
        elif nodeName_ == 'infAdProd':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'infAdProd')
            value_ = self.gds_validate_string(value_, node, 'infAdProd')
            self.infAdProd = value_
            self.infAdProd_nsprefix_ = child_.prefix
            # validate type infAdProdType
            self.validate_infAdProdType(self.infAdProd)
# end class detType


class prodType(GeneratedsSuper):
    """Dados dos produtos e serviços da NF-eInformações específicas de produtos
    e serviços"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('cProd', ['cProdType', 'TString', 'xs:string'], 0, 0, {'name': 'cProd', 'type': 'xs:string'}, None),
        MemberSpec_('cEAN', ['cEANType', 'xs:string'], 0, 0, {'name': 'cEAN', 'type': 'xs:string'}, None),
        MemberSpec_('cBarra', ['cBarraType', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'cBarra', 'type': 'xs:string'}, None),
        MemberSpec_('xProd', ['xProdType', 'TString', 'xs:string'], 0, 0, {'name': 'xProd', 'type': 'xs:string'}, None),
        MemberSpec_('NCM', ['NCMType', 'xs:string'], 0, 0, {'name': 'NCM', 'type': 'xs:string'}, None),
        MemberSpec_('NVE', ['NVEType', 'xs:string'], 1, 1, {'maxOccurs': '8', 'minOccurs': '0', 'name': 'NVE', 'type': 'xs:string'}, None),
        MemberSpec_('CEST', ['CESTType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'CEST', 'type': 'xs:string'}, None),
        MemberSpec_('indEscala', ['indEscalaType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'indEscala', 'type': 'xs:string'}, None),
        MemberSpec_('CNPJFab', ['TCnpj', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'CNPJFab', 'type': 'xs:string'}, None),
        MemberSpec_('cBenef', ['cBenefType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'cBenef', 'type': 'xs:string'}, None),
        MemberSpec_('EXTIPI', ['EXTIPIType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'EXTIPI', 'type': 'xs:string'}, None),
        MemberSpec_('CFOP', ['CFOPType', 'xs:string'], 0, 0, {'name': 'CFOP', 'type': 'xs:string'}, None),
        MemberSpec_('uCom', ['uComType', 'TString', 'xs:string'], 0, 0, {'name': 'uCom', 'type': 'xs:string'}, None),
        MemberSpec_('qCom', ['TDec_1104v', 'xs:string'], 0, 0, {'name': 'qCom', 'type': 'xs:string'}, None),
        MemberSpec_('vUnCom', ['TDec_1110v', 'xs:string'], 0, 0, {'name': 'vUnCom', 'type': 'xs:string'}, None),
        MemberSpec_('vProd', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vProd', 'type': 'xs:string'}, None),
        MemberSpec_('cEANTrib', ['cEANTribType', 'xs:string'], 0, 0, {'name': 'cEANTrib', 'type': 'xs:string'}, None),
        MemberSpec_('cBarraTrib', ['cBarraTribType', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'cBarraTrib', 'type': 'xs:string'}, None),
        MemberSpec_('uTrib', ['uTribType', 'TString', 'xs:string'], 0, 0, {'name': 'uTrib', 'type': 'xs:string'}, None),
        MemberSpec_('qTrib', ['TDec_1104v', 'xs:string'], 0, 0, {'name': 'qTrib', 'type': 'xs:string'}, None),
        MemberSpec_('vUnTrib', ['TDec_1110v', 'xs:string'], 0, 0, {'name': 'vUnTrib', 'type': 'xs:string'}, None),
        MemberSpec_('vFrete', ['TDec_1302Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vFrete', 'type': 'xs:string'}, None),
        MemberSpec_('vSeg', ['TDec_1302Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vSeg', 'type': 'xs:string'}, None),
        MemberSpec_('vDesc', ['TDec_1302Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vDesc', 'type': 'xs:string'}, None),
        MemberSpec_('vOutro', ['TDec_1302Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vOutro', 'type': 'xs:string'}, None),
        MemberSpec_('indTot', ['indTotType', 'xs:string'], 0, 0, {'name': 'indTot', 'type': 'xs:string'}, None),
        MemberSpec_('DI', 'DIType', 1, 1, {'maxOccurs': '100', 'minOccurs': '0', 'name': 'DI', 'type': 'DIType'}, None),
        MemberSpec_('detExport', 'detExportType', 1, 1, {'maxOccurs': '500', 'minOccurs': '0', 'name': 'detExport', 'type': 'detExportType'}, None),
        MemberSpec_('xPed', ['xPedType', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'xPed', 'type': 'xs:string'}, None),
        MemberSpec_('nItemPed', ['nItemPedType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'nItemPed', 'type': 'xs:string'}, None),
        MemberSpec_('nFCI', ['TGuid', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'nFCI', 'type': 'xs:string'}, None),
        MemberSpec_('rastro', 'rastroType', 1, 1, {'maxOccurs': '500', 'minOccurs': '0', 'name': 'rastro', 'type': 'rastroType'}, None),
        MemberSpec_('infProdNFF', 'infProdNFFType', 0, 1, {'minOccurs': '0', 'name': 'infProdNFF', 'type': 'infProdNFFType'}, None),
        MemberSpec_('infProdEmb', 'infProdEmbType', 0, 1, {'minOccurs': '0', 'name': 'infProdEmb', 'type': 'infProdEmbType'}, None),
        MemberSpec_('veicProd', 'veicProdType', 0, 1, {'name': 'veicProd', 'type': 'veicProdType'}, 9),
        MemberSpec_('med', 'medType', 0, 1, {'name': 'med', 'type': 'medType'}, 9),
        MemberSpec_('arma', 'armaType', 1, 1, {'maxOccurs': '500', 'name': 'arma', 'type': 'armaType'}, 9),
        MemberSpec_('comb', 'combType', 0, 1, {'name': 'comb', 'type': 'combType'}, 9),
        MemberSpec_('nRECOPI', ['nRECOPIType', 'xs:string'], 0, 1, {'name': 'nRECOPI', 'type': 'xs:string'}, 9),
    ]
    subclass = None
    superclass = None
    def __init__(self, cProd=None, cEAN=None, cBarra=None, xProd=None, NCM=None, NVE=None, CEST=None, indEscala=None, CNPJFab=None, cBenef=None, EXTIPI=None, CFOP=None, uCom=None, qCom=None, vUnCom=None, vProd=None, cEANTrib=None, cBarraTrib=None, uTrib=None, qTrib=None, vUnTrib=None, vFrete=None, vSeg=None, vDesc=None, vOutro=None, indTot=None, DI=None, detExport=None, xPed=None, nItemPed=None, nFCI=None, rastro=None, infProdNFF=None, infProdEmb=None, veicProd=None, med=None, arma=None, comb=None, nRECOPI=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.cProd = cProd
        self.validate_cProdType(self.cProd)
        self.cProd_nsprefix_ = None
        self.cEAN = cEAN
        self.validate_cEANType(self.cEAN)
        self.cEAN_nsprefix_ = None
        self.cBarra = cBarra
        self.validate_cBarraType(self.cBarra)
        self.cBarra_nsprefix_ = None
        self.xProd = xProd
        self.validate_xProdType(self.xProd)
        self.xProd_nsprefix_ = None
        self.NCM = NCM
        self.validate_NCMType(self.NCM)
        self.NCM_nsprefix_ = None
        if NVE is None:
            self.NVE = []
        else:
            self.NVE = NVE
        self.NVE_nsprefix_ = None
        self.CEST = CEST
        self.validate_CESTType(self.CEST)
        self.CEST_nsprefix_ = None
        self.indEscala = indEscala
        self.validate_indEscalaType(self.indEscala)
        self.indEscala_nsprefix_ = None
        self.CNPJFab = CNPJFab
        self.validate_TCnpj(self.CNPJFab)
        self.CNPJFab_nsprefix_ = None
        self.cBenef = cBenef
        self.validate_cBenefType(self.cBenef)
        self.cBenef_nsprefix_ = None
        self.EXTIPI = EXTIPI
        self.validate_EXTIPIType(self.EXTIPI)
        self.EXTIPI_nsprefix_ = None
        self.CFOP = CFOP
        self.validate_CFOPType(self.CFOP)
        self.CFOP_nsprefix_ = None
        self.uCom = uCom
        self.validate_uComType(self.uCom)
        self.uCom_nsprefix_ = None
        self.qCom = qCom
        self.validate_TDec_1104v(self.qCom)
        self.qCom_nsprefix_ = None
        self.vUnCom = vUnCom
        self.validate_TDec_1110v(self.vUnCom)
        self.vUnCom_nsprefix_ = None
        self.vProd = vProd
        self.validate_TDec_1302(self.vProd)
        self.vProd_nsprefix_ = None
        self.cEANTrib = cEANTrib
        self.validate_cEANTribType(self.cEANTrib)
        self.cEANTrib_nsprefix_ = None
        self.cBarraTrib = cBarraTrib
        self.validate_cBarraTribType(self.cBarraTrib)
        self.cBarraTrib_nsprefix_ = None
        self.uTrib = uTrib
        self.validate_uTribType(self.uTrib)
        self.uTrib_nsprefix_ = None
        self.qTrib = qTrib
        self.validate_TDec_1104v(self.qTrib)
        self.qTrib_nsprefix_ = None
        self.vUnTrib = vUnTrib
        self.validate_TDec_1110v(self.vUnTrib)
        self.vUnTrib_nsprefix_ = None
        self.vFrete = vFrete
        self.validate_TDec_1302Opc(self.vFrete)
        self.vFrete_nsprefix_ = None
        self.vSeg = vSeg
        self.validate_TDec_1302Opc(self.vSeg)
        self.vSeg_nsprefix_ = None
        self.vDesc = vDesc
        self.validate_TDec_1302Opc(self.vDesc)
        self.vDesc_nsprefix_ = None
        self.vOutro = vOutro
        self.validate_TDec_1302Opc(self.vOutro)
        self.vOutro_nsprefix_ = None
        self.indTot = indTot
        self.validate_indTotType(self.indTot)
        self.indTot_nsprefix_ = None
        if DI is None:
            self.DI = []
        else:
            self.DI = DI
        self.DI_nsprefix_ = None
        if detExport is None:
            self.detExport = []
        else:
            self.detExport = detExport
        self.detExport_nsprefix_ = None
        self.xPed = xPed
        self.validate_xPedType(self.xPed)
        self.xPed_nsprefix_ = None
        self.nItemPed = nItemPed
        self.validate_nItemPedType(self.nItemPed)
        self.nItemPed_nsprefix_ = None
        self.nFCI = nFCI
        self.validate_TGuid(self.nFCI)
        self.nFCI_nsprefix_ = None
        if rastro is None:
            self.rastro = []
        else:
            self.rastro = rastro
        self.rastro_nsprefix_ = None
        self.infProdNFF = infProdNFF
        self.infProdNFF_nsprefix_ = None
        self.infProdEmb = infProdEmb
        self.infProdEmb_nsprefix_ = None
        self.veicProd = veicProd
        self.veicProd_nsprefix_ = None
        self.med = med
        self.med_nsprefix_ = None
        if arma is None:
            self.arma = []
        else:
            self.arma = arma
        self.arma_nsprefix_ = None
        self.comb = comb
        self.comb_nsprefix_ = None
        self.nRECOPI = nRECOPI
        self.validate_nRECOPIType(self.nRECOPI)
        self.nRECOPI_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, prodType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if prodType.subclass:
            return prodType.subclass(*args_, **kwargs_)
        else:
            return prodType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_cProdType(self, value):
        result = True
        # Validate type cProdType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on cProdType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on cProdType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_cProdType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cProdType_patterns_, ))
                result = False
        return result
    validate_cProdType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_cEANType(self, value):
        result = True
        # Validate type cEANType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_cEANType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cEANType_patterns_, ))
                result = False
        return result
    validate_cEANType_patterns_ = [['^(SEM GTIN|[0-9]{0}|[0-9]{8}|[0-9]{12,14})$']]
    def validate_cBarraType(self, value):
        result = True
        # Validate type cBarraType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 30:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on cBarraType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on cBarraType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_cBarraType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cBarraType_patterns_, ))
                result = False
        return result
    validate_cBarraType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_xProdType(self, value):
        result = True
        # Validate type xProdType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 120:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xProdType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xProdType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xProdType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xProdType_patterns_, ))
                result = False
        return result
    validate_xProdType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_NCMType(self, value):
        result = True
        # Validate type NCMType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_NCMType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NCMType_patterns_, ))
                result = False
        return result
    validate_NCMType_patterns_ = [['^([0-9]{2}|[0-9]{8})$']]
    def validate_NVEType(self, value):
        result = True
        # Validate type NVEType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_NVEType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NVEType_patterns_, ))
                result = False
        return result
    validate_NVEType_patterns_ = [['^([A-Z]{2}[0-9]{4})$']]
    def validate_CESTType(self, value):
        result = True
        # Validate type CESTType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_CESTType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_CESTType_patterns_, ))
                result = False
        return result
    validate_CESTType_patterns_ = [['^([0-9]{7})$']]
    def validate_indEscalaType(self, value):
        result = True
        # Validate type indEscalaType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['S', 'N']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on indEscalaType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TCnpj(self, value):
        result = True
        # Validate type TCnpj, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 14:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TCnpj' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCnpj_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCnpj_patterns_, ))
                result = False
        return result
    validate_TCnpj_patterns_ = [['^([0-9]{14})$']]
    def validate_cBenefType(self, value):
        result = True
        # Validate type cBenefType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_cBenefType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cBenefType_patterns_, ))
                result = False
        return result
    validate_cBenefType_patterns_ = [['^(([!-ÿ]{8}|[!-ÿ]{10}|SEM CBENEF)?)$']]
    def validate_EXTIPIType(self, value):
        result = True
        # Validate type EXTIPIType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_EXTIPIType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_EXTIPIType_patterns_, ))
                result = False
        return result
    validate_EXTIPIType_patterns_ = [['^([0-9]{2,3})$']]
    def validate_CFOPType(self, value):
        result = True
        # Validate type CFOPType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_CFOPType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_CFOPType_patterns_, ))
                result = False
        return result
    validate_CFOPType_patterns_ = [['^([1,2,3,5,6,7]{1}[0-9]{3})$']]
    def validate_uComType(self, value):
        result = True
        # Validate type uComType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 6:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on uComType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on uComType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_uComType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_uComType_patterns_, ))
                result = False
        return result
    validate_uComType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TDec_1104v(self, value):
        result = True
        # Validate type TDec_1104v, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1104v_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1104v_patterns_, ))
                result = False
        return result
    validate_TDec_1104v_patterns_ = [['^(0|0\\.[0-9]{1,4}|[1-9]{1}[0-9]{0,10}|[1-9]{1}[0-9]{0,10}(\\.[0-9]{1,4})?)$']]
    def validate_TDec_1110v(self, value):
        result = True
        # Validate type TDec_1110v, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1110v_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1110v_patterns_, ))
                result = False
        return result
    validate_TDec_1110v_patterns_ = [['^(0|0\\.[0-9]{1,10}|[1-9]{1}[0-9]{0,10}|[1-9]{1}[0-9]{0,10}(\\.[0-9]{1,10})?)$']]
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def validate_cEANTribType(self, value):
        result = True
        # Validate type cEANTribType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_cEANTribType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cEANTribType_patterns_, ))
                result = False
        return result
    validate_cEANTribType_patterns_ = [['^(SEM GTIN|[0-9]{0}|[0-9]{8}|[0-9]{12,14})$']]
    def validate_cBarraTribType(self, value):
        result = True
        # Validate type cBarraTribType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 30:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on cBarraTribType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on cBarraTribType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_cBarraTribType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cBarraTribType_patterns_, ))
                result = False
        return result
    validate_cBarraTribType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_uTribType(self, value):
        result = True
        # Validate type uTribType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 6:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on uTribType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on uTribType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_uTribType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_uTribType_patterns_, ))
                result = False
        return result
    validate_uTribType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TDec_1302Opc(self, value):
        result = True
        # Validate type TDec_1302Opc, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302Opc_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302Opc_patterns_, ))
                result = False
        return result
    validate_TDec_1302Opc_patterns_ = [['^(0\\.[0-9]{1}[1-9]{1}|0\\.[1-9]{1}[0-9]{1}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def validate_indTotType(self, value):
        result = True
        # Validate type indTotType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on indTotType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_xPedType(self, value):
        result = True
        # Validate type xPedType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 15:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xPedType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xPedType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xPedType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xPedType_patterns_, ))
                result = False
        return result
    validate_xPedType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_nItemPedType(self, value):
        result = True
        # Validate type nItemPedType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_nItemPedType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nItemPedType_patterns_, ))
                result = False
        return result
    validate_nItemPedType_patterns_ = [['^([0-9]{1,6})$']]
    def validate_TGuid(self, value):
        result = True
        # Validate type TGuid, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TGuid_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TGuid_patterns_, ))
                result = False
        return result
    validate_TGuid_patterns_ = [['^([A-F0-9]{8}-[A-F0-9]{4}-[A-F0-9]{4}-[A-F0-9]{4}-[A-F0-9]{12})$']]
    def validate_nRECOPIType(self, value):
        result = True
        # Validate type nRECOPIType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 20:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on nRECOPIType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_nRECOPIType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nRECOPIType_patterns_, ))
                result = False
        return result
    validate_nRECOPIType_patterns_ = [['^([0-9]{20})$']]
    def hasContent_(self):
        if (
            self.cProd is not None or
            self.cEAN is not None or
            self.cBarra is not None or
            self.xProd is not None or
            self.NCM is not None or
            self.NVE or
            self.CEST is not None or
            self.indEscala is not None or
            self.CNPJFab is not None or
            self.cBenef is not None or
            self.EXTIPI is not None or
            self.CFOP is not None or
            self.uCom is not None or
            self.qCom is not None or
            self.vUnCom is not None or
            self.vProd is not None or
            self.cEANTrib is not None or
            self.cBarraTrib is not None or
            self.uTrib is not None or
            self.qTrib is not None or
            self.vUnTrib is not None or
            self.vFrete is not None or
            self.vSeg is not None or
            self.vDesc is not None or
            self.vOutro is not None or
            self.indTot is not None or
            self.DI or
            self.detExport or
            self.xPed is not None or
            self.nItemPed is not None or
            self.nFCI is not None or
            self.rastro or
            self.infProdNFF is not None or
            self.infProdEmb is not None or
            self.veicProd is not None or
            self.med is not None or
            self.arma or
            self.comb is not None or
            self.nRECOPI is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='prodType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('prodType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'prodType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='prodType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='prodType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='prodType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='prodType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.cProd is not None:
            namespaceprefix_ = self.cProd_nsprefix_ + ':' if (UseCapturedNS_ and self.cProd_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scProd>%s</%scProd>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cProd), input_name='cProd')), namespaceprefix_ , eol_))
        if self.cEAN is not None:
            namespaceprefix_ = self.cEAN_nsprefix_ + ':' if (UseCapturedNS_ and self.cEAN_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scEAN>%s</%scEAN>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cEAN), input_name='cEAN')), namespaceprefix_ , eol_))
        if self.cBarra is not None:
            namespaceprefix_ = self.cBarra_nsprefix_ + ':' if (UseCapturedNS_ and self.cBarra_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scBarra>%s</%scBarra>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cBarra), input_name='cBarra')), namespaceprefix_ , eol_))
        if self.xProd is not None:
            namespaceprefix_ = self.xProd_nsprefix_ + ':' if (UseCapturedNS_ and self.xProd_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxProd>%s</%sxProd>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xProd), input_name='xProd')), namespaceprefix_ , eol_))
        if self.NCM is not None:
            namespaceprefix_ = self.NCM_nsprefix_ + ':' if (UseCapturedNS_ and self.NCM_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sNCM>%s</%sNCM>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.NCM), input_name='NCM')), namespaceprefix_ , eol_))
        for NVE_ in self.NVE:
            namespaceprefix_ = self.NVE_nsprefix_ + ':' if (UseCapturedNS_ and self.NVE_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sNVE>%s</%sNVE>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(NVE_), input_name='NVE')), namespaceprefix_ , eol_))
        if self.CEST is not None:
            namespaceprefix_ = self.CEST_nsprefix_ + ':' if (UseCapturedNS_ and self.CEST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCEST>%s</%sCEST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CEST), input_name='CEST')), namespaceprefix_ , eol_))
        if self.indEscala is not None:
            namespaceprefix_ = self.indEscala_nsprefix_ + ':' if (UseCapturedNS_ and self.indEscala_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sindEscala>%s</%sindEscala>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.indEscala), input_name='indEscala')), namespaceprefix_ , eol_))
        if self.CNPJFab is not None:
            namespaceprefix_ = self.CNPJFab_nsprefix_ + ':' if (UseCapturedNS_ and self.CNPJFab_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCNPJFab>%s</%sCNPJFab>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CNPJFab), input_name='CNPJFab')), namespaceprefix_ , eol_))
        if self.cBenef is not None:
            namespaceprefix_ = self.cBenef_nsprefix_ + ':' if (UseCapturedNS_ and self.cBenef_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scBenef>%s</%scBenef>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cBenef), input_name='cBenef')), namespaceprefix_ , eol_))
        if self.EXTIPI is not None:
            namespaceprefix_ = self.EXTIPI_nsprefix_ + ':' if (UseCapturedNS_ and self.EXTIPI_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sEXTIPI>%s</%sEXTIPI>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.EXTIPI), input_name='EXTIPI')), namespaceprefix_ , eol_))
        if self.CFOP is not None:
            namespaceprefix_ = self.CFOP_nsprefix_ + ':' if (UseCapturedNS_ and self.CFOP_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCFOP>%s</%sCFOP>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CFOP), input_name='CFOP')), namespaceprefix_ , eol_))
        if self.uCom is not None:
            namespaceprefix_ = self.uCom_nsprefix_ + ':' if (UseCapturedNS_ and self.uCom_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suCom>%s</%suCom>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.uCom), input_name='uCom')), namespaceprefix_ , eol_))
        if self.qCom is not None:
            namespaceprefix_ = self.qCom_nsprefix_ + ':' if (UseCapturedNS_ and self.qCom_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sqCom>%s</%sqCom>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.qCom), input_name='qCom')), namespaceprefix_ , eol_))
        if self.vUnCom is not None:
            namespaceprefix_ = self.vUnCom_nsprefix_ + ':' if (UseCapturedNS_ and self.vUnCom_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svUnCom>%s</%svUnCom>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vUnCom), input_name='vUnCom')), namespaceprefix_ , eol_))
        if self.vProd is not None:
            namespaceprefix_ = self.vProd_nsprefix_ + ':' if (UseCapturedNS_ and self.vProd_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svProd>%s</%svProd>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vProd), input_name='vProd')), namespaceprefix_ , eol_))
        if self.cEANTrib is not None:
            namespaceprefix_ = self.cEANTrib_nsprefix_ + ':' if (UseCapturedNS_ and self.cEANTrib_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scEANTrib>%s</%scEANTrib>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cEANTrib), input_name='cEANTrib')), namespaceprefix_ , eol_))
        if self.cBarraTrib is not None:
            namespaceprefix_ = self.cBarraTrib_nsprefix_ + ':' if (UseCapturedNS_ and self.cBarraTrib_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scBarraTrib>%s</%scBarraTrib>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cBarraTrib), input_name='cBarraTrib')), namespaceprefix_ , eol_))
        if self.uTrib is not None:
            namespaceprefix_ = self.uTrib_nsprefix_ + ':' if (UseCapturedNS_ and self.uTrib_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suTrib>%s</%suTrib>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.uTrib), input_name='uTrib')), namespaceprefix_ , eol_))
        if self.qTrib is not None:
            namespaceprefix_ = self.qTrib_nsprefix_ + ':' if (UseCapturedNS_ and self.qTrib_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sqTrib>%s</%sqTrib>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.qTrib), input_name='qTrib')), namespaceprefix_ , eol_))
        if self.vUnTrib is not None:
            namespaceprefix_ = self.vUnTrib_nsprefix_ + ':' if (UseCapturedNS_ and self.vUnTrib_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svUnTrib>%s</%svUnTrib>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vUnTrib), input_name='vUnTrib')), namespaceprefix_ , eol_))
        if self.vFrete is not None:
            namespaceprefix_ = self.vFrete_nsprefix_ + ':' if (UseCapturedNS_ and self.vFrete_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svFrete>%s</%svFrete>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vFrete), input_name='vFrete')), namespaceprefix_ , eol_))
        if self.vSeg is not None:
            namespaceprefix_ = self.vSeg_nsprefix_ + ':' if (UseCapturedNS_ and self.vSeg_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svSeg>%s</%svSeg>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vSeg), input_name='vSeg')), namespaceprefix_ , eol_))
        if self.vDesc is not None:
            namespaceprefix_ = self.vDesc_nsprefix_ + ':' if (UseCapturedNS_ and self.vDesc_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svDesc>%s</%svDesc>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vDesc), input_name='vDesc')), namespaceprefix_ , eol_))
        if self.vOutro is not None:
            namespaceprefix_ = self.vOutro_nsprefix_ + ':' if (UseCapturedNS_ and self.vOutro_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svOutro>%s</%svOutro>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vOutro), input_name='vOutro')), namespaceprefix_ , eol_))
        if self.indTot is not None:
            namespaceprefix_ = self.indTot_nsprefix_ + ':' if (UseCapturedNS_ and self.indTot_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sindTot>%s</%sindTot>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.indTot), input_name='indTot')), namespaceprefix_ , eol_))
        for DI_ in self.DI:
            namespaceprefix_ = self.DI_nsprefix_ + ':' if (UseCapturedNS_ and self.DI_nsprefix_) else ''
            DI_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DI', pretty_print=pretty_print)
        for detExport_ in self.detExport:
            namespaceprefix_ = self.detExport_nsprefix_ + ':' if (UseCapturedNS_ and self.detExport_nsprefix_) else ''
            detExport_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='detExport', pretty_print=pretty_print)
        if self.xPed is not None:
            namespaceprefix_ = self.xPed_nsprefix_ + ':' if (UseCapturedNS_ and self.xPed_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxPed>%s</%sxPed>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xPed), input_name='xPed')), namespaceprefix_ , eol_))
        if self.nItemPed is not None:
            namespaceprefix_ = self.nItemPed_nsprefix_ + ':' if (UseCapturedNS_ and self.nItemPed_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snItemPed>%s</%snItemPed>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nItemPed), input_name='nItemPed')), namespaceprefix_ , eol_))
        if self.nFCI is not None:
            namespaceprefix_ = self.nFCI_nsprefix_ + ':' if (UseCapturedNS_ and self.nFCI_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snFCI>%s</%snFCI>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nFCI), input_name='nFCI')), namespaceprefix_ , eol_))
        for rastro_ in self.rastro:
            namespaceprefix_ = self.rastro_nsprefix_ + ':' if (UseCapturedNS_ and self.rastro_nsprefix_) else ''
            rastro_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='rastro', pretty_print=pretty_print)
        if self.infProdNFF is not None:
            namespaceprefix_ = self.infProdNFF_nsprefix_ + ':' if (UseCapturedNS_ and self.infProdNFF_nsprefix_) else ''
            self.infProdNFF.export(outfile, level, namespaceprefix_, namespacedef_='', name_='infProdNFF', pretty_print=pretty_print)
        if self.infProdEmb is not None:
            namespaceprefix_ = self.infProdEmb_nsprefix_ + ':' if (UseCapturedNS_ and self.infProdEmb_nsprefix_) else ''
            self.infProdEmb.export(outfile, level, namespaceprefix_, namespacedef_='', name_='infProdEmb', pretty_print=pretty_print)
        if self.veicProd is not None:
            namespaceprefix_ = self.veicProd_nsprefix_ + ':' if (UseCapturedNS_ and self.veicProd_nsprefix_) else ''
            self.veicProd.export(outfile, level, namespaceprefix_, namespacedef_='', name_='veicProd', pretty_print=pretty_print)
        if self.med is not None:
            namespaceprefix_ = self.med_nsprefix_ + ':' if (UseCapturedNS_ and self.med_nsprefix_) else ''
            self.med.export(outfile, level, namespaceprefix_, namespacedef_='', name_='med', pretty_print=pretty_print)
        for arma_ in self.arma:
            namespaceprefix_ = self.arma_nsprefix_ + ':' if (UseCapturedNS_ and self.arma_nsprefix_) else ''
            arma_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='arma', pretty_print=pretty_print)
        if self.comb is not None:
            namespaceprefix_ = self.comb_nsprefix_ + ':' if (UseCapturedNS_ and self.comb_nsprefix_) else ''
            self.comb.export(outfile, level, namespaceprefix_, namespacedef_='', name_='comb', pretty_print=pretty_print)
        if self.nRECOPI is not None:
            namespaceprefix_ = self.nRECOPI_nsprefix_ + ':' if (UseCapturedNS_ and self.nRECOPI_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snRECOPI>%s</%snRECOPI>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nRECOPI), input_name='nRECOPI')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'cProd':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cProd')
            value_ = self.gds_validate_string(value_, node, 'cProd')
            self.cProd = value_
            self.cProd_nsprefix_ = child_.prefix
            # validate type cProdType
            self.validate_cProdType(self.cProd)
        elif nodeName_ == 'cEAN':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cEAN')
            value_ = self.gds_validate_string(value_, node, 'cEAN')
            self.cEAN = value_
            self.cEAN_nsprefix_ = child_.prefix
            # validate type cEANType
            self.validate_cEANType(self.cEAN)
        elif nodeName_ == 'cBarra':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cBarra')
            value_ = self.gds_validate_string(value_, node, 'cBarra')
            self.cBarra = value_
            self.cBarra_nsprefix_ = child_.prefix
            # validate type cBarraType
            self.validate_cBarraType(self.cBarra)
        elif nodeName_ == 'xProd':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xProd')
            value_ = self.gds_validate_string(value_, node, 'xProd')
            self.xProd = value_
            self.xProd_nsprefix_ = child_.prefix
            # validate type xProdType
            self.validate_xProdType(self.xProd)
        elif nodeName_ == 'NCM':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'NCM')
            value_ = self.gds_validate_string(value_, node, 'NCM')
            self.NCM = value_
            self.NCM_nsprefix_ = child_.prefix
            # validate type NCMType
            self.validate_NCMType(self.NCM)
        elif nodeName_ == 'NVE':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'NVE')
            value_ = self.gds_validate_string(value_, node, 'NVE')
            self.NVE.append(value_)
            self.NVE_nsprefix_ = child_.prefix
            # validate type NVEType
            self.validate_NVEType(self.NVE[-1])
        elif nodeName_ == 'CEST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CEST')
            value_ = self.gds_validate_string(value_, node, 'CEST')
            self.CEST = value_
            self.CEST_nsprefix_ = child_.prefix
            # validate type CESTType
            self.validate_CESTType(self.CEST)
        elif nodeName_ == 'indEscala':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'indEscala')
            value_ = self.gds_validate_string(value_, node, 'indEscala')
            self.indEscala = value_
            self.indEscala_nsprefix_ = child_.prefix
            # validate type indEscalaType
            self.validate_indEscalaType(self.indEscala)
        elif nodeName_ == 'CNPJFab':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CNPJFab')
            value_ = self.gds_validate_string(value_, node, 'CNPJFab')
            self.CNPJFab = value_
            self.CNPJFab_nsprefix_ = child_.prefix
            # validate type TCnpj
            self.validate_TCnpj(self.CNPJFab)
        elif nodeName_ == 'cBenef':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cBenef')
            value_ = self.gds_validate_string(value_, node, 'cBenef')
            self.cBenef = value_
            self.cBenef_nsprefix_ = child_.prefix
            # validate type cBenefType
            self.validate_cBenefType(self.cBenef)
        elif nodeName_ == 'EXTIPI':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'EXTIPI')
            value_ = self.gds_validate_string(value_, node, 'EXTIPI')
            self.EXTIPI = value_
            self.EXTIPI_nsprefix_ = child_.prefix
            # validate type EXTIPIType
            self.validate_EXTIPIType(self.EXTIPI)
        elif nodeName_ == 'CFOP':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CFOP')
            value_ = self.gds_validate_string(value_, node, 'CFOP')
            self.CFOP = value_
            self.CFOP_nsprefix_ = child_.prefix
            # validate type CFOPType
            self.validate_CFOPType(self.CFOP)
        elif nodeName_ == 'uCom':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'uCom')
            value_ = self.gds_validate_string(value_, node, 'uCom')
            self.uCom = value_
            self.uCom_nsprefix_ = child_.prefix
            # validate type uComType
            self.validate_uComType(self.uCom)
        elif nodeName_ == 'qCom':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'qCom')
            value_ = self.gds_validate_string(value_, node, 'qCom')
            self.qCom = value_
            self.qCom_nsprefix_ = child_.prefix
            # validate type TDec_1104v
            self.validate_TDec_1104v(self.qCom)
        elif nodeName_ == 'vUnCom':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vUnCom')
            value_ = self.gds_validate_string(value_, node, 'vUnCom')
            self.vUnCom = value_
            self.vUnCom_nsprefix_ = child_.prefix
            # validate type TDec_1110v
            self.validate_TDec_1110v(self.vUnCom)
        elif nodeName_ == 'vProd':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vProd')
            value_ = self.gds_validate_string(value_, node, 'vProd')
            self.vProd = value_
            self.vProd_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vProd)
        elif nodeName_ == 'cEANTrib':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cEANTrib')
            value_ = self.gds_validate_string(value_, node, 'cEANTrib')
            self.cEANTrib = value_
            self.cEANTrib_nsprefix_ = child_.prefix
            # validate type cEANTribType
            self.validate_cEANTribType(self.cEANTrib)
        elif nodeName_ == 'cBarraTrib':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cBarraTrib')
            value_ = self.gds_validate_string(value_, node, 'cBarraTrib')
            self.cBarraTrib = value_
            self.cBarraTrib_nsprefix_ = child_.prefix
            # validate type cBarraTribType
            self.validate_cBarraTribType(self.cBarraTrib)
        elif nodeName_ == 'uTrib':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'uTrib')
            value_ = self.gds_validate_string(value_, node, 'uTrib')
            self.uTrib = value_
            self.uTrib_nsprefix_ = child_.prefix
            # validate type uTribType
            self.validate_uTribType(self.uTrib)
        elif nodeName_ == 'qTrib':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'qTrib')
            value_ = self.gds_validate_string(value_, node, 'qTrib')
            self.qTrib = value_
            self.qTrib_nsprefix_ = child_.prefix
            # validate type TDec_1104v
            self.validate_TDec_1104v(self.qTrib)
        elif nodeName_ == 'vUnTrib':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vUnTrib')
            value_ = self.gds_validate_string(value_, node, 'vUnTrib')
            self.vUnTrib = value_
            self.vUnTrib_nsprefix_ = child_.prefix
            # validate type TDec_1110v
            self.validate_TDec_1110v(self.vUnTrib)
        elif nodeName_ == 'vFrete':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vFrete')
            value_ = self.gds_validate_string(value_, node, 'vFrete')
            self.vFrete = value_
            self.vFrete_nsprefix_ = child_.prefix
            # validate type TDec_1302Opc
            self.validate_TDec_1302Opc(self.vFrete)
        elif nodeName_ == 'vSeg':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vSeg')
            value_ = self.gds_validate_string(value_, node, 'vSeg')
            self.vSeg = value_
            self.vSeg_nsprefix_ = child_.prefix
            # validate type TDec_1302Opc
            self.validate_TDec_1302Opc(self.vSeg)
        elif nodeName_ == 'vDesc':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vDesc')
            value_ = self.gds_validate_string(value_, node, 'vDesc')
            self.vDesc = value_
            self.vDesc_nsprefix_ = child_.prefix
            # validate type TDec_1302Opc
            self.validate_TDec_1302Opc(self.vDesc)
        elif nodeName_ == 'vOutro':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vOutro')
            value_ = self.gds_validate_string(value_, node, 'vOutro')
            self.vOutro = value_
            self.vOutro_nsprefix_ = child_.prefix
            # validate type TDec_1302Opc
            self.validate_TDec_1302Opc(self.vOutro)
        elif nodeName_ == 'indTot':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'indTot')
            value_ = self.gds_validate_string(value_, node, 'indTot')
            self.indTot = value_
            self.indTot_nsprefix_ = child_.prefix
            # validate type indTotType
            self.validate_indTotType(self.indTot)
        elif nodeName_ == 'DI':
            obj_ = DIType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DI.append(obj_)
            obj_.original_tagname_ = 'DI'
        elif nodeName_ == 'detExport':
            obj_ = detExportType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.detExport.append(obj_)
            obj_.original_tagname_ = 'detExport'
        elif nodeName_ == 'xPed':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xPed')
            value_ = self.gds_validate_string(value_, node, 'xPed')
            self.xPed = value_
            self.xPed_nsprefix_ = child_.prefix
            # validate type xPedType
            self.validate_xPedType(self.xPed)
        elif nodeName_ == 'nItemPed':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nItemPed')
            value_ = self.gds_validate_string(value_, node, 'nItemPed')
            self.nItemPed = value_
            self.nItemPed_nsprefix_ = child_.prefix
            # validate type nItemPedType
            self.validate_nItemPedType(self.nItemPed)
        elif nodeName_ == 'nFCI':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nFCI')
            value_ = self.gds_validate_string(value_, node, 'nFCI')
            self.nFCI = value_
            self.nFCI_nsprefix_ = child_.prefix
            # validate type TGuid
            self.validate_TGuid(self.nFCI)
        elif nodeName_ == 'rastro':
            obj_ = rastroType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.rastro.append(obj_)
            obj_.original_tagname_ = 'rastro'
        elif nodeName_ == 'infProdNFF':
            obj_ = infProdNFFType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.infProdNFF = obj_
            obj_.original_tagname_ = 'infProdNFF'
        elif nodeName_ == 'infProdEmb':
            obj_ = infProdEmbType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.infProdEmb = obj_
            obj_.original_tagname_ = 'infProdEmb'
        elif nodeName_ == 'veicProd':
            obj_ = veicProdType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.veicProd = obj_
            obj_.original_tagname_ = 'veicProd'
        elif nodeName_ == 'med':
            obj_ = medType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.med = obj_
            obj_.original_tagname_ = 'med'
        elif nodeName_ == 'arma':
            obj_ = armaType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.arma.append(obj_)
            obj_.original_tagname_ = 'arma'
        elif nodeName_ == 'comb':
            obj_ = combType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.comb = obj_
            obj_.original_tagname_ = 'comb'
        elif nodeName_ == 'nRECOPI':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nRECOPI')
            value_ = self.gds_validate_string(value_, node, 'nRECOPI')
            self.nRECOPI = value_
            self.nRECOPI_nsprefix_ = child_.prefix
            # validate type nRECOPIType
            self.validate_nRECOPIType(self.nRECOPI)
# end class prodType


class DIType(GeneratedsSuper):
    """Delcaração de Importação
    (NT 2011/004)"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('nDI', ['nDIType', 'TString', 'xs:string'], 0, 0, {'name': 'nDI', 'type': 'xs:string'}, None),
        MemberSpec_('dDI', ['TData', 'xs:string'], 0, 0, {'name': 'dDI', 'type': 'xs:string'}, None),
        MemberSpec_('xLocDesemb', ['xLocDesembType', 'TString', 'xs:string'], 0, 0, {'name': 'xLocDesemb', 'type': 'xs:string'}, None),
        MemberSpec_('UFDesemb', ['TUfEmi', 'xs:string'], 0, 0, {'name': 'UFDesemb', 'type': 'xs:string'}, None),
        MemberSpec_('dDesemb', ['TData', 'xs:string'], 0, 0, {'name': 'dDesemb', 'type': 'xs:string'}, None),
        MemberSpec_('tpViaTransp', ['tpViaTranspType', 'xs:string'], 0, 0, {'name': 'tpViaTransp', 'type': 'xs:string'}, None),
        MemberSpec_('vAFRMM', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vAFRMM', 'type': 'xs:string'}, None),
        MemberSpec_('tpIntermedio', ['tpIntermedioType', 'xs:string'], 0, 0, {'name': 'tpIntermedio', 'type': 'xs:string'}, None),
        MemberSpec_('CNPJ', ['TCnpj', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'CNPJ', 'type': 'xs:string'}, None),
        MemberSpec_('UFTerceiro', ['TUfEmi', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'UFTerceiro', 'type': 'xs:string'}, None),
        MemberSpec_('cExportador', ['cExportadorType', 'TString', 'xs:string'], 0, 0, {'name': 'cExportador', 'type': 'xs:string'}, None),
        MemberSpec_('adi', 'adiType', 1, 0, {'maxOccurs': '999', 'name': 'adi', 'type': 'adiType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, nDI=None, dDI=None, xLocDesemb=None, UFDesemb=None, dDesemb=None, tpViaTransp=None, vAFRMM=None, tpIntermedio=None, CNPJ=None, UFTerceiro=None, cExportador=None, adi=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nDI = nDI
        self.validate_nDIType(self.nDI)
        self.nDI_nsprefix_ = None
        self.dDI = dDI
        self.validate_TData(self.dDI)
        self.dDI_nsprefix_ = None
        self.xLocDesemb = xLocDesemb
        self.validate_xLocDesembType(self.xLocDesemb)
        self.xLocDesemb_nsprefix_ = None
        self.UFDesemb = UFDesemb
        self.validate_TUfEmi(self.UFDesemb)
        self.UFDesemb_nsprefix_ = None
        self.dDesemb = dDesemb
        self.validate_TData(self.dDesemb)
        self.dDesemb_nsprefix_ = None
        self.tpViaTransp = tpViaTransp
        self.validate_tpViaTranspType(self.tpViaTransp)
        self.tpViaTransp_nsprefix_ = None
        self.vAFRMM = vAFRMM
        self.validate_TDec_1302(self.vAFRMM)
        self.vAFRMM_nsprefix_ = None
        self.tpIntermedio = tpIntermedio
        self.validate_tpIntermedioType(self.tpIntermedio)
        self.tpIntermedio_nsprefix_ = None
        self.CNPJ = CNPJ
        self.validate_TCnpj(self.CNPJ)
        self.CNPJ_nsprefix_ = None
        self.UFTerceiro = UFTerceiro
        self.validate_TUfEmi(self.UFTerceiro)
        self.UFTerceiro_nsprefix_ = None
        self.cExportador = cExportador
        self.validate_cExportadorType(self.cExportador)
        self.cExportador_nsprefix_ = None
        if adi is None:
            self.adi = []
        else:
            self.adi = adi
        self.adi_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DIType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DIType.subclass:
            return DIType.subclass(*args_, **kwargs_)
        else:
            return DIType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_nDIType(self, value):
        result = True
        # Validate type nDIType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 15:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on nDIType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nDIType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_nDIType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nDIType_patterns_, ))
                result = False
        return result
    validate_nDIType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TData(self, value):
        result = True
        # Validate type TData, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TData_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TData_patterns_, ))
                result = False
        return result
    validate_TData_patterns_ = [['^((((20(([02468][048])|([13579][26]))-02-29))|(20[0-9][0-9])-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\\d)|(2[0-8])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30))))))$']]
    def validate_xLocDesembType(self, value):
        result = True
        # Validate type xLocDesembType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xLocDesembType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xLocDesembType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xLocDesembType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xLocDesembType_patterns_, ))
                result = False
        return result
    validate_xLocDesembType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TUfEmi(self, value):
        result = True
        # Validate type TUfEmi, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['AC', 'AL', 'AM', 'AP', 'BA', 'CE', 'DF', 'ES', 'GO', 'MA', 'MG', 'MS', 'MT', 'PA', 'PB', 'PE', 'PI', 'PR', 'RJ', 'RN', 'RO', 'RR', 'RS', 'SC', 'SE', 'SP', 'TO']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TUfEmi' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_tpViaTranspType(self, value):
        result = True
        # Validate type tpViaTranspType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12', '13']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on tpViaTranspType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def validate_tpIntermedioType(self, value):
        result = True
        # Validate type tpIntermedioType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['1', '2', '3']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on tpIntermedioType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TCnpj(self, value):
        result = True
        # Validate type TCnpj, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 14:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TCnpj' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TCnpj_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TCnpj_patterns_, ))
                result = False
        return result
    validate_TCnpj_patterns_ = [['^([0-9]{14})$']]
    def validate_cExportadorType(self, value):
        result = True
        # Validate type cExportadorType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on cExportadorType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on cExportadorType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_cExportadorType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cExportadorType_patterns_, ))
                result = False
        return result
    validate_cExportadorType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def hasContent_(self):
        if (
            self.nDI is not None or
            self.dDI is not None or
            self.xLocDesemb is not None or
            self.UFDesemb is not None or
            self.dDesemb is not None or
            self.tpViaTransp is not None or
            self.vAFRMM is not None or
            self.tpIntermedio is not None or
            self.CNPJ is not None or
            self.UFTerceiro is not None or
            self.cExportador is not None or
            self.adi
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DIType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DIType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DIType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DIType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DIType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DIType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DIType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.nDI is not None:
            namespaceprefix_ = self.nDI_nsprefix_ + ':' if (UseCapturedNS_ and self.nDI_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snDI>%s</%snDI>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nDI), input_name='nDI')), namespaceprefix_ , eol_))
        if self.dDI is not None:
            namespaceprefix_ = self.dDI_nsprefix_ + ':' if (UseCapturedNS_ and self.dDI_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdDI>%s</%sdDI>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.dDI), input_name='dDI')), namespaceprefix_ , eol_))
        if self.xLocDesemb is not None:
            namespaceprefix_ = self.xLocDesemb_nsprefix_ + ':' if (UseCapturedNS_ and self.xLocDesemb_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxLocDesemb>%s</%sxLocDesemb>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xLocDesemb), input_name='xLocDesemb')), namespaceprefix_ , eol_))
        if self.UFDesemb is not None:
            namespaceprefix_ = self.UFDesemb_nsprefix_ + ':' if (UseCapturedNS_ and self.UFDesemb_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUFDesemb>%s</%sUFDesemb>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.UFDesemb), input_name='UFDesemb')), namespaceprefix_ , eol_))
        if self.dDesemb is not None:
            namespaceprefix_ = self.dDesemb_nsprefix_ + ':' if (UseCapturedNS_ and self.dDesemb_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdDesemb>%s</%sdDesemb>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.dDesemb), input_name='dDesemb')), namespaceprefix_ , eol_))
        if self.tpViaTransp is not None:
            namespaceprefix_ = self.tpViaTransp_nsprefix_ + ':' if (UseCapturedNS_ and self.tpViaTransp_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stpViaTransp>%s</%stpViaTransp>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tpViaTransp), input_name='tpViaTransp')), namespaceprefix_ , eol_))
        if self.vAFRMM is not None:
            namespaceprefix_ = self.vAFRMM_nsprefix_ + ':' if (UseCapturedNS_ and self.vAFRMM_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svAFRMM>%s</%svAFRMM>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vAFRMM), input_name='vAFRMM')), namespaceprefix_ , eol_))
        if self.tpIntermedio is not None:
            namespaceprefix_ = self.tpIntermedio_nsprefix_ + ':' if (UseCapturedNS_ and self.tpIntermedio_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stpIntermedio>%s</%stpIntermedio>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tpIntermedio), input_name='tpIntermedio')), namespaceprefix_ , eol_))
        if self.CNPJ is not None:
            namespaceprefix_ = self.CNPJ_nsprefix_ + ':' if (UseCapturedNS_ and self.CNPJ_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCNPJ>%s</%sCNPJ>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CNPJ), input_name='CNPJ')), namespaceprefix_ , eol_))
        if self.UFTerceiro is not None:
            namespaceprefix_ = self.UFTerceiro_nsprefix_ + ':' if (UseCapturedNS_ and self.UFTerceiro_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUFTerceiro>%s</%sUFTerceiro>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.UFTerceiro), input_name='UFTerceiro')), namespaceprefix_ , eol_))
        if self.cExportador is not None:
            namespaceprefix_ = self.cExportador_nsprefix_ + ':' if (UseCapturedNS_ and self.cExportador_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scExportador>%s</%scExportador>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cExportador), input_name='cExportador')), namespaceprefix_ , eol_))
        for adi_ in self.adi:
            namespaceprefix_ = self.adi_nsprefix_ + ':' if (UseCapturedNS_ and self.adi_nsprefix_) else ''
            adi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='adi', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'nDI':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nDI')
            value_ = self.gds_validate_string(value_, node, 'nDI')
            self.nDI = value_
            self.nDI_nsprefix_ = child_.prefix
            # validate type nDIType
            self.validate_nDIType(self.nDI)
        elif nodeName_ == 'dDI':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'dDI')
            value_ = self.gds_validate_string(value_, node, 'dDI')
            self.dDI = value_
            self.dDI_nsprefix_ = child_.prefix
            # validate type TData
            self.validate_TData(self.dDI)
        elif nodeName_ == 'xLocDesemb':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xLocDesemb')
            value_ = self.gds_validate_string(value_, node, 'xLocDesemb')
            self.xLocDesemb = value_
            self.xLocDesemb_nsprefix_ = child_.prefix
            # validate type xLocDesembType
            self.validate_xLocDesembType(self.xLocDesemb)
        elif nodeName_ == 'UFDesemb':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'UFDesemb')
            value_ = self.gds_validate_string(value_, node, 'UFDesemb')
            self.UFDesemb = value_
            self.UFDesemb_nsprefix_ = child_.prefix
            # validate type TUfEmi
            self.validate_TUfEmi(self.UFDesemb)
        elif nodeName_ == 'dDesemb':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'dDesemb')
            value_ = self.gds_validate_string(value_, node, 'dDesemb')
            self.dDesemb = value_
            self.dDesemb_nsprefix_ = child_.prefix
            # validate type TData
            self.validate_TData(self.dDesemb)
        elif nodeName_ == 'tpViaTransp':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tpViaTransp')
            value_ = self.gds_validate_string(value_, node, 'tpViaTransp')
            self.tpViaTransp = value_
            self.tpViaTransp_nsprefix_ = child_.prefix
            # validate type tpViaTranspType
            self.validate_tpViaTranspType(self.tpViaTransp)
        elif nodeName_ == 'vAFRMM':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vAFRMM')
            value_ = self.gds_validate_string(value_, node, 'vAFRMM')
            self.vAFRMM = value_
            self.vAFRMM_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vAFRMM)
        elif nodeName_ == 'tpIntermedio':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tpIntermedio')
            value_ = self.gds_validate_string(value_, node, 'tpIntermedio')
            self.tpIntermedio = value_
            self.tpIntermedio_nsprefix_ = child_.prefix
            # validate type tpIntermedioType
            self.validate_tpIntermedioType(self.tpIntermedio)
        elif nodeName_ == 'CNPJ':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CNPJ')
            value_ = self.gds_validate_string(value_, node, 'CNPJ')
            self.CNPJ = value_
            self.CNPJ_nsprefix_ = child_.prefix
            # validate type TCnpj
            self.validate_TCnpj(self.CNPJ)
        elif nodeName_ == 'UFTerceiro':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'UFTerceiro')
            value_ = self.gds_validate_string(value_, node, 'UFTerceiro')
            self.UFTerceiro = value_
            self.UFTerceiro_nsprefix_ = child_.prefix
            # validate type TUfEmi
            self.validate_TUfEmi(self.UFTerceiro)
        elif nodeName_ == 'cExportador':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cExportador')
            value_ = self.gds_validate_string(value_, node, 'cExportador')
            self.cExportador = value_
            self.cExportador_nsprefix_ = child_.prefix
            # validate type cExportadorType
            self.validate_cExportadorType(self.cExportador)
        elif nodeName_ == 'adi':
            obj_ = adiType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.adi.append(obj_)
            obj_.original_tagname_ = 'adi'
# end class DIType


class adiType(GeneratedsSuper):
    """Adições (NT 2011/004)"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('nAdicao', ['nAdicaoType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'nAdicao', 'type': 'xs:string'}, None),
        MemberSpec_('nSeqAdic', ['nSeqAdicType', 'xs:string'], 0, 0, {'name': 'nSeqAdic', 'type': 'xs:string'}, None),
        MemberSpec_('cFabricante', ['cFabricanteType', 'TString', 'xs:string'], 0, 0, {'name': 'cFabricante', 'type': 'xs:string'}, None),
        MemberSpec_('vDescDI', ['TDec_1302Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vDescDI', 'type': 'xs:string'}, None),
        MemberSpec_('nDraw', ['nDrawType', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'nDraw', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, nAdicao=None, nSeqAdic=None, cFabricante=None, vDescDI=None, nDraw=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nAdicao = nAdicao
        self.validate_nAdicaoType(self.nAdicao)
        self.nAdicao_nsprefix_ = None
        self.nSeqAdic = nSeqAdic
        self.validate_nSeqAdicType(self.nSeqAdic)
        self.nSeqAdic_nsprefix_ = None
        self.cFabricante = cFabricante
        self.validate_cFabricanteType(self.cFabricante)
        self.cFabricante_nsprefix_ = None
        self.vDescDI = vDescDI
        self.validate_TDec_1302Opc(self.vDescDI)
        self.vDescDI_nsprefix_ = None
        self.nDraw = nDraw
        self.validate_nDrawType(self.nDraw)
        self.nDraw_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, adiType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if adiType.subclass:
            return adiType.subclass(*args_, **kwargs_)
        else:
            return adiType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_nAdicaoType(self, value):
        result = True
        # Validate type nAdicaoType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_nAdicaoType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nAdicaoType_patterns_, ))
                result = False
        return result
    validate_nAdicaoType_patterns_ = [['^([1-9]{1}[0-9]{0,2})$']]
    def validate_nSeqAdicType(self, value):
        result = True
        # Validate type nSeqAdicType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_nSeqAdicType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nSeqAdicType_patterns_, ))
                result = False
        return result
    validate_nSeqAdicType_patterns_ = [['^([1-9]{1}[0-9]{0,4})$']]
    def validate_cFabricanteType(self, value):
        result = True
        # Validate type cFabricanteType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 60:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on cFabricanteType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on cFabricanteType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_cFabricanteType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cFabricanteType_patterns_, ))
                result = False
        return result
    validate_cFabricanteType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TDec_1302Opc(self, value):
        result = True
        # Validate type TDec_1302Opc, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302Opc_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302Opc_patterns_, ))
                result = False
        return result
    validate_TDec_1302Opc_patterns_ = [['^(0\\.[0-9]{1}[1-9]{1}|0\\.[1-9]{1}[0-9]{1}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def validate_nDrawType(self, value):
        result = True
        # Validate type nDrawType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 20:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on nDrawType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nDrawType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_nDrawType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nDrawType_patterns_, ))
                result = False
        return result
    validate_nDrawType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def hasContent_(self):
        if (
            self.nAdicao is not None or
            self.nSeqAdic is not None or
            self.cFabricante is not None or
            self.vDescDI is not None or
            self.nDraw is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='adiType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('adiType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'adiType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='adiType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='adiType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='adiType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='adiType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.nAdicao is not None:
            namespaceprefix_ = self.nAdicao_nsprefix_ + ':' if (UseCapturedNS_ and self.nAdicao_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snAdicao>%s</%snAdicao>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nAdicao), input_name='nAdicao')), namespaceprefix_ , eol_))
        if self.nSeqAdic is not None:
            namespaceprefix_ = self.nSeqAdic_nsprefix_ + ':' if (UseCapturedNS_ and self.nSeqAdic_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snSeqAdic>%s</%snSeqAdic>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nSeqAdic), input_name='nSeqAdic')), namespaceprefix_ , eol_))
        if self.cFabricante is not None:
            namespaceprefix_ = self.cFabricante_nsprefix_ + ':' if (UseCapturedNS_ and self.cFabricante_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scFabricante>%s</%scFabricante>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cFabricante), input_name='cFabricante')), namespaceprefix_ , eol_))
        if self.vDescDI is not None:
            namespaceprefix_ = self.vDescDI_nsprefix_ + ':' if (UseCapturedNS_ and self.vDescDI_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svDescDI>%s</%svDescDI>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vDescDI), input_name='vDescDI')), namespaceprefix_ , eol_))
        if self.nDraw is not None:
            namespaceprefix_ = self.nDraw_nsprefix_ + ':' if (UseCapturedNS_ and self.nDraw_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snDraw>%s</%snDraw>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nDraw), input_name='nDraw')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'nAdicao':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nAdicao')
            value_ = self.gds_validate_string(value_, node, 'nAdicao')
            self.nAdicao = value_
            self.nAdicao_nsprefix_ = child_.prefix
            # validate type nAdicaoType
            self.validate_nAdicaoType(self.nAdicao)
        elif nodeName_ == 'nSeqAdic':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nSeqAdic')
            value_ = self.gds_validate_string(value_, node, 'nSeqAdic')
            self.nSeqAdic = value_
            self.nSeqAdic_nsprefix_ = child_.prefix
            # validate type nSeqAdicType
            self.validate_nSeqAdicType(self.nSeqAdic)
        elif nodeName_ == 'cFabricante':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cFabricante')
            value_ = self.gds_validate_string(value_, node, 'cFabricante')
            self.cFabricante = value_
            self.cFabricante_nsprefix_ = child_.prefix
            # validate type cFabricanteType
            self.validate_cFabricanteType(self.cFabricante)
        elif nodeName_ == 'vDescDI':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vDescDI')
            value_ = self.gds_validate_string(value_, node, 'vDescDI')
            self.vDescDI = value_
            self.vDescDI_nsprefix_ = child_.prefix
            # validate type TDec_1302Opc
            self.validate_TDec_1302Opc(self.vDescDI)
        elif nodeName_ == 'nDraw':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nDraw')
            value_ = self.gds_validate_string(value_, node, 'nDraw')
            self.nDraw = value_
            self.nDraw_nsprefix_ = child_.prefix
            # validate type nDrawType
            self.validate_nDrawType(self.nDraw)
# end class adiType


class detExportType(GeneratedsSuper):
    """Detalhe da exportação"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('nDraw', ['nDrawType6', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'nDraw', 'type': 'xs:string'}, None),
        MemberSpec_('exportInd', 'exportIndType', 0, 1, {'minOccurs': '0', 'name': 'exportInd', 'type': 'exportIndType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, nDraw=None, exportInd=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nDraw = nDraw
        self.validate_nDrawType6(self.nDraw)
        self.nDraw_nsprefix_ = None
        self.exportInd = exportInd
        self.exportInd_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, detExportType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if detExportType.subclass:
            return detExportType.subclass(*args_, **kwargs_)
        else:
            return detExportType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_nDrawType6(self, value):
        result = True
        # Validate type nDrawType6, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 20:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on nDrawType6' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nDrawType6' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_nDrawType6_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nDrawType6_patterns_, ))
                result = False
        return result
    validate_nDrawType6_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def hasContent_(self):
        if (
            self.nDraw is not None or
            self.exportInd is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='detExportType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('detExportType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'detExportType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='detExportType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='detExportType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='detExportType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='detExportType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.nDraw is not None:
            namespaceprefix_ = self.nDraw_nsprefix_ + ':' if (UseCapturedNS_ and self.nDraw_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snDraw>%s</%snDraw>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nDraw), input_name='nDraw')), namespaceprefix_ , eol_))
        if self.exportInd is not None:
            namespaceprefix_ = self.exportInd_nsprefix_ + ':' if (UseCapturedNS_ and self.exportInd_nsprefix_) else ''
            self.exportInd.export(outfile, level, namespaceprefix_, namespacedef_='', name_='exportInd', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'nDraw':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nDraw')
            value_ = self.gds_validate_string(value_, node, 'nDraw')
            self.nDraw = value_
            self.nDraw_nsprefix_ = child_.prefix
            # validate type nDrawType6
            self.validate_nDrawType6(self.nDraw)
        elif nodeName_ == 'exportInd':
            obj_ = exportIndType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.exportInd = obj_
            obj_.original_tagname_ = 'exportInd'
# end class detExportType


class exportIndType(GeneratedsSuper):
    """Exportação indireta"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('nRE', ['nREType', 'xs:string'], 0, 0, {'name': 'nRE', 'type': 'xs:string'}, None),
        MemberSpec_('chNFe', ['TChNFe', 'xs:string'], 0, 0, {'name': 'chNFe', 'type': 'xs:string'}, None),
        MemberSpec_('qExport', ['TDec_1104v', 'xs:string'], 0, 0, {'name': 'qExport', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, nRE=None, chNFe=None, qExport=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nRE = nRE
        self.validate_nREType(self.nRE)
        self.nRE_nsprefix_ = None
        self.chNFe = chNFe
        self.validate_TChNFe(self.chNFe)
        self.chNFe_nsprefix_ = None
        self.qExport = qExport
        self.validate_TDec_1104v(self.qExport)
        self.qExport_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, exportIndType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if exportIndType.subclass:
            return exportIndType.subclass(*args_, **kwargs_)
        else:
            return exportIndType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_nREType(self, value):
        result = True
        # Validate type nREType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_nREType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nREType_patterns_, ))
                result = False
        return result
    validate_nREType_patterns_ = [['^([0-9]{0,12})$']]
    def validate_TChNFe(self, value):
        result = True
        # Validate type TChNFe, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 44:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TChNFe' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TChNFe_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TChNFe_patterns_, ))
                result = False
        return result
    validate_TChNFe_patterns_ = [['^([0-9]{44})$']]
    def validate_TDec_1104v(self, value):
        result = True
        # Validate type TDec_1104v, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1104v_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1104v_patterns_, ))
                result = False
        return result
    validate_TDec_1104v_patterns_ = [['^(0|0\\.[0-9]{1,4}|[1-9]{1}[0-9]{0,10}|[1-9]{1}[0-9]{0,10}(\\.[0-9]{1,4})?)$']]
    def hasContent_(self):
        if (
            self.nRE is not None or
            self.chNFe is not None or
            self.qExport is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='exportIndType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('exportIndType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'exportIndType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='exportIndType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='exportIndType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='exportIndType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='exportIndType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.nRE is not None:
            namespaceprefix_ = self.nRE_nsprefix_ + ':' if (UseCapturedNS_ and self.nRE_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snRE>%s</%snRE>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nRE), input_name='nRE')), namespaceprefix_ , eol_))
        if self.chNFe is not None:
            namespaceprefix_ = self.chNFe_nsprefix_ + ':' if (UseCapturedNS_ and self.chNFe_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%schNFe>%s</%schNFe>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.chNFe), input_name='chNFe')), namespaceprefix_ , eol_))
        if self.qExport is not None:
            namespaceprefix_ = self.qExport_nsprefix_ + ':' if (UseCapturedNS_ and self.qExport_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sqExport>%s</%sqExport>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.qExport), input_name='qExport')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'nRE':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nRE')
            value_ = self.gds_validate_string(value_, node, 'nRE')
            self.nRE = value_
            self.nRE_nsprefix_ = child_.prefix
            # validate type nREType
            self.validate_nREType(self.nRE)
        elif nodeName_ == 'chNFe':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'chNFe')
            value_ = self.gds_validate_string(value_, node, 'chNFe')
            self.chNFe = value_
            self.chNFe_nsprefix_ = child_.prefix
            # validate type TChNFe
            self.validate_TChNFe(self.chNFe)
        elif nodeName_ == 'qExport':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'qExport')
            value_ = self.gds_validate_string(value_, node, 'qExport')
            self.qExport = value_
            self.qExport_nsprefix_ = child_.prefix
            # validate type TDec_1104v
            self.validate_TDec_1104v(self.qExport)
# end class exportIndType


class rastroType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('nLote', ['nLoteType', 'xs:string'], 0, 0, {'name': 'nLote', 'type': 'xs:string'}, None),
        MemberSpec_('qLote', ['TDec_0803v', 'xs:string'], 0, 0, {'name': 'qLote', 'type': 'xs:string'}, None),
        MemberSpec_('dFab', ['TData', 'xs:string'], 0, 0, {'name': 'dFab', 'type': 'xs:string'}, None),
        MemberSpec_('dVal', ['TData', 'xs:string'], 0, 0, {'name': 'dVal', 'type': 'xs:string'}, None),
        MemberSpec_('cAgreg', ['cAgregType', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'cAgreg', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, nLote=None, qLote=None, dFab=None, dVal=None, cAgreg=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nLote = nLote
        self.validate_nLoteType(self.nLote)
        self.nLote_nsprefix_ = None
        self.qLote = qLote
        self.validate_TDec_0803v(self.qLote)
        self.qLote_nsprefix_ = None
        self.dFab = dFab
        self.validate_TData(self.dFab)
        self.dFab_nsprefix_ = None
        self.dVal = dVal
        self.validate_TData(self.dVal)
        self.dVal_nsprefix_ = None
        self.cAgreg = cAgreg
        self.validate_cAgregType(self.cAgreg)
        self.cAgreg_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, rastroType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if rastroType.subclass:
            return rastroType.subclass(*args_, **kwargs_)
        else:
            return rastroType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_nLoteType(self, value):
        result = True
        # Validate type nLoteType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 20:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on nLoteType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nLoteType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TDec_0803v(self, value):
        result = True
        # Validate type TDec_0803v, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0803v_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0803v_patterns_, ))
                result = False
        return result
    validate_TDec_0803v_patterns_ = [['^(0|0\\.[0-9]{3}|[1-9]{1}[0-9]{0,7}(\\.[0-9]{1,3})?)$']]
    def validate_TData(self, value):
        result = True
        # Validate type TData, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TData_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TData_patterns_, ))
                result = False
        return result
    validate_TData_patterns_ = [['^((((20(([02468][048])|([13579][26]))-02-29))|(20[0-9][0-9])-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\\d)|(2[0-8])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30))))))$']]
    def validate_cAgregType(self, value):
        result = True
        # Validate type cAgregType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 20:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on cAgregType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on cAgregType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_cAgregType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cAgregType_patterns_, ))
                result = False
        return result
    validate_cAgregType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def hasContent_(self):
        if (
            self.nLote is not None or
            self.qLote is not None or
            self.dFab is not None or
            self.dVal is not None or
            self.cAgreg is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='rastroType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('rastroType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'rastroType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='rastroType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='rastroType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='rastroType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='rastroType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.nLote is not None:
            namespaceprefix_ = self.nLote_nsprefix_ + ':' if (UseCapturedNS_ and self.nLote_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snLote>%s</%snLote>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nLote), input_name='nLote')), namespaceprefix_ , eol_))
        if self.qLote is not None:
            namespaceprefix_ = self.qLote_nsprefix_ + ':' if (UseCapturedNS_ and self.qLote_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sqLote>%s</%sqLote>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.qLote), input_name='qLote')), namespaceprefix_ , eol_))
        if self.dFab is not None:
            namespaceprefix_ = self.dFab_nsprefix_ + ':' if (UseCapturedNS_ and self.dFab_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdFab>%s</%sdFab>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.dFab), input_name='dFab')), namespaceprefix_ , eol_))
        if self.dVal is not None:
            namespaceprefix_ = self.dVal_nsprefix_ + ':' if (UseCapturedNS_ and self.dVal_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdVal>%s</%sdVal>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.dVal), input_name='dVal')), namespaceprefix_ , eol_))
        if self.cAgreg is not None:
            namespaceprefix_ = self.cAgreg_nsprefix_ + ':' if (UseCapturedNS_ and self.cAgreg_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scAgreg>%s</%scAgreg>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cAgreg), input_name='cAgreg')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'nLote':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nLote')
            value_ = self.gds_validate_string(value_, node, 'nLote')
            self.nLote = value_
            self.nLote_nsprefix_ = child_.prefix
            # validate type nLoteType
            self.validate_nLoteType(self.nLote)
        elif nodeName_ == 'qLote':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'qLote')
            value_ = self.gds_validate_string(value_, node, 'qLote')
            self.qLote = value_
            self.qLote_nsprefix_ = child_.prefix
            # validate type TDec_0803v
            self.validate_TDec_0803v(self.qLote)
        elif nodeName_ == 'dFab':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'dFab')
            value_ = self.gds_validate_string(value_, node, 'dFab')
            self.dFab = value_
            self.dFab_nsprefix_ = child_.prefix
            # validate type TData
            self.validate_TData(self.dFab)
        elif nodeName_ == 'dVal':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'dVal')
            value_ = self.gds_validate_string(value_, node, 'dVal')
            self.dVal = value_
            self.dVal_nsprefix_ = child_.prefix
            # validate type TData
            self.validate_TData(self.dVal)
        elif nodeName_ == 'cAgreg':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cAgreg')
            value_ = self.gds_validate_string(value_, node, 'cAgreg')
            self.cAgreg = value_
            self.cAgreg_nsprefix_ = child_.prefix
            # validate type cAgregType
            self.validate_cAgregType(self.cAgreg)
# end class rastroType


class infProdNFFType(GeneratedsSuper):
    """Informações mais detalhadas do produto (usada na NFF)"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('cProdFisco', ['cProdFiscoType', 'TString', 'xs:string'], 0, 0, {'name': 'cProdFisco', 'type': 'xs:string'}, None),
        MemberSpec_('cOperNFF', ['cOperNFFType', 'xs:string'], 0, 0, {'name': 'cOperNFF', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, cProdFisco=None, cOperNFF=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.cProdFisco = cProdFisco
        self.validate_cProdFiscoType(self.cProdFisco)
        self.cProdFisco_nsprefix_ = None
        self.cOperNFF = cOperNFF
        self.validate_cOperNFFType(self.cOperNFF)
        self.cOperNFF_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, infProdNFFType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if infProdNFFType.subclass:
            return infProdNFFType.subclass(*args_, **kwargs_)
        else:
            return infProdNFFType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_cProdFiscoType(self, value):
        result = True
        # Validate type cProdFiscoType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) != 14:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on cProdFiscoType' % {"value": value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_cProdFiscoType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cProdFiscoType_patterns_, ))
                result = False
        return result
    validate_cProdFiscoType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_cOperNFFType(self, value):
        result = True
        # Validate type cOperNFFType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_cOperNFFType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cOperNFFType_patterns_, ))
                result = False
        return result
    validate_cOperNFFType_patterns_ = [['^([0-9]{1,5})$']]
    def hasContent_(self):
        if (
            self.cProdFisco is not None or
            self.cOperNFF is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='infProdNFFType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('infProdNFFType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'infProdNFFType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='infProdNFFType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='infProdNFFType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='infProdNFFType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='infProdNFFType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.cProdFisco is not None:
            namespaceprefix_ = self.cProdFisco_nsprefix_ + ':' if (UseCapturedNS_ and self.cProdFisco_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scProdFisco>%s</%scProdFisco>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cProdFisco), input_name='cProdFisco')), namespaceprefix_ , eol_))
        if self.cOperNFF is not None:
            namespaceprefix_ = self.cOperNFF_nsprefix_ + ':' if (UseCapturedNS_ and self.cOperNFF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scOperNFF>%s</%scOperNFF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cOperNFF), input_name='cOperNFF')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'cProdFisco':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cProdFisco')
            value_ = self.gds_validate_string(value_, node, 'cProdFisco')
            self.cProdFisco = value_
            self.cProdFisco_nsprefix_ = child_.prefix
            # validate type cProdFiscoType
            self.validate_cProdFiscoType(self.cProdFisco)
        elif nodeName_ == 'cOperNFF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cOperNFF')
            value_ = self.gds_validate_string(value_, node, 'cOperNFF')
            self.cOperNFF = value_
            self.cOperNFF_nsprefix_ = child_.prefix
            # validate type cOperNFFType
            self.validate_cOperNFFType(self.cOperNFF)
# end class infProdNFFType


class infProdEmbType(GeneratedsSuper):
    """Informações mais detalhadas do produto (usada na NFF)"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('xEmb', ['xEmbType', 'TString', 'xs:string'], 0, 0, {'name': 'xEmb', 'type': 'xs:string'}, None),
        MemberSpec_('qVolEmb', ['TDec_0803v', 'xs:string'], 0, 0, {'name': 'qVolEmb', 'type': 'xs:string'}, None),
        MemberSpec_('uEmb', ['uEmbType', 'TString', 'xs:string'], 0, 0, {'name': 'uEmb', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, xEmb=None, qVolEmb=None, uEmb=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.xEmb = xEmb
        self.validate_xEmbType(self.xEmb)
        self.xEmb_nsprefix_ = None
        self.qVolEmb = qVolEmb
        self.validate_TDec_0803v(self.qVolEmb)
        self.qVolEmb_nsprefix_ = None
        self.uEmb = uEmb
        self.validate_uEmbType(self.uEmb)
        self.uEmb_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, infProdEmbType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if infProdEmbType.subclass:
            return infProdEmbType.subclass(*args_, **kwargs_)
        else:
            return infProdEmbType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_xEmbType(self, value):
        result = True
        # Validate type xEmbType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 8:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xEmbType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xEmbType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xEmbType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xEmbType_patterns_, ))
                result = False
        return result
    validate_xEmbType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TDec_0803v(self, value):
        result = True
        # Validate type TDec_0803v, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0803v_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0803v_patterns_, ))
                result = False
        return result
    validate_TDec_0803v_patterns_ = [['^(0|0\\.[0-9]{3}|[1-9]{1}[0-9]{0,7}(\\.[0-9]{1,3})?)$']]
    def validate_uEmbType(self, value):
        result = True
        # Validate type uEmbType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 8:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on uEmbType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on uEmbType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_uEmbType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_uEmbType_patterns_, ))
                result = False
        return result
    validate_uEmbType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def hasContent_(self):
        if (
            self.xEmb is not None or
            self.qVolEmb is not None or
            self.uEmb is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='infProdEmbType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('infProdEmbType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'infProdEmbType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='infProdEmbType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='infProdEmbType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='infProdEmbType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='infProdEmbType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.xEmb is not None:
            namespaceprefix_ = self.xEmb_nsprefix_ + ':' if (UseCapturedNS_ and self.xEmb_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxEmb>%s</%sxEmb>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xEmb), input_name='xEmb')), namespaceprefix_ , eol_))
        if self.qVolEmb is not None:
            namespaceprefix_ = self.qVolEmb_nsprefix_ + ':' if (UseCapturedNS_ and self.qVolEmb_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sqVolEmb>%s</%sqVolEmb>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.qVolEmb), input_name='qVolEmb')), namespaceprefix_ , eol_))
        if self.uEmb is not None:
            namespaceprefix_ = self.uEmb_nsprefix_ + ':' if (UseCapturedNS_ and self.uEmb_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suEmb>%s</%suEmb>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.uEmb), input_name='uEmb')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'xEmb':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xEmb')
            value_ = self.gds_validate_string(value_, node, 'xEmb')
            self.xEmb = value_
            self.xEmb_nsprefix_ = child_.prefix
            # validate type xEmbType
            self.validate_xEmbType(self.xEmb)
        elif nodeName_ == 'qVolEmb':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'qVolEmb')
            value_ = self.gds_validate_string(value_, node, 'qVolEmb')
            self.qVolEmb = value_
            self.qVolEmb_nsprefix_ = child_.prefix
            # validate type TDec_0803v
            self.validate_TDec_0803v(self.qVolEmb)
        elif nodeName_ == 'uEmb':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'uEmb')
            value_ = self.gds_validate_string(value_, node, 'uEmb')
            self.uEmb = value_
            self.uEmb_nsprefix_ = child_.prefix
            # validate type uEmbType
            self.validate_uEmbType(self.uEmb)
# end class infProdEmbType


class veicProdType(GeneratedsSuper):
    """Veículos novos"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('tpOp', ['tpOpType', 'xs:string'], 0, 0, {'name': 'tpOp', 'type': 'xs:string'}, None),
        MemberSpec_('chassi', ['chassiType', 'xs:string'], 0, 0, {'name': 'chassi', 'type': 'xs:string'}, None),
        MemberSpec_('cCor', ['cCorType', 'TString', 'xs:string'], 0, 0, {'name': 'cCor', 'type': 'xs:string'}, None),
        MemberSpec_('xCor', ['xCorType', 'TString', 'xs:string'], 0, 0, {'name': 'xCor', 'type': 'xs:string'}, None),
        MemberSpec_('pot', ['potType', 'TString', 'xs:string'], 0, 0, {'name': 'pot', 'type': 'xs:string'}, None),
        MemberSpec_('cilin', ['cilinType', 'TString', 'xs:string'], 0, 0, {'name': 'cilin', 'type': 'xs:string'}, None),
        MemberSpec_('pesoL', ['pesoLType', 'TString', 'xs:string'], 0, 0, {'name': 'pesoL', 'type': 'xs:string'}, None),
        MemberSpec_('pesoB', ['pesoBType', 'TString', 'xs:string'], 0, 0, {'name': 'pesoB', 'type': 'xs:string'}, None),
        MemberSpec_('nSerie', ['nSerieType', 'TString', 'xs:string'], 0, 0, {'name': 'nSerie', 'type': 'xs:string'}, None),
        MemberSpec_('tpComb', ['tpCombType', 'TString', 'xs:string'], 0, 0, {'name': 'tpComb', 'type': 'xs:string'}, None),
        MemberSpec_('nMotor', ['nMotorType', 'TString', 'xs:string'], 0, 0, {'name': 'nMotor', 'type': 'xs:string'}, None),
        MemberSpec_('CMT', ['CMTType', 'TString', 'xs:string'], 0, 0, {'name': 'CMT', 'type': 'xs:string'}, None),
        MemberSpec_('dist', ['distType', 'TString', 'xs:string'], 0, 0, {'name': 'dist', 'type': 'xs:string'}, None),
        MemberSpec_('anoMod', ['anoModType', 'xs:string'], 0, 0, {'name': 'anoMod', 'type': 'xs:string'}, None),
        MemberSpec_('anoFab', ['anoFabType', 'xs:string'], 0, 0, {'name': 'anoFab', 'type': 'xs:string'}, None),
        MemberSpec_('tpPint', ['tpPintType', 'TString', 'xs:string'], 0, 0, {'name': 'tpPint', 'type': 'xs:string'}, None),
        MemberSpec_('tpVeic', ['tpVeicType', 'xs:string'], 0, 0, {'name': 'tpVeic', 'type': 'xs:string'}, None),
        MemberSpec_('espVeic', ['espVeicType', 'xs:string'], 0, 0, {'name': 'espVeic', 'type': 'xs:string'}, None),
        MemberSpec_('VIN', ['VINType', 'TString', 'xs:string'], 0, 0, {'name': 'VIN', 'type': 'xs:string'}, None),
        MemberSpec_('condVeic', ['condVeicType', 'xs:string'], 0, 0, {'name': 'condVeic', 'type': 'xs:string'}, None),
        MemberSpec_('cMod', ['cModType', 'xs:string'], 0, 0, {'name': 'cMod', 'type': 'xs:string'}, None),
        MemberSpec_('cCorDENATRAN', ['cCorDENATRANType', 'xs:string'], 0, 0, {'name': 'cCorDENATRAN', 'type': 'xs:string'}, None),
        MemberSpec_('lota', ['lotaType', 'xs:string'], 0, 0, {'name': 'lota', 'type': 'xs:string'}, None),
        MemberSpec_('tpRest', ['tpRestType', 'xs:string'], 0, 0, {'name': 'tpRest', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, tpOp=None, chassi=None, cCor=None, xCor=None, pot=None, cilin=None, pesoL=None, pesoB=None, nSerie=None, tpComb=None, nMotor=None, CMT=None, dist=None, anoMod=None, anoFab=None, tpPint=None, tpVeic=None, espVeic=None, VIN=None, condVeic=None, cMod=None, cCorDENATRAN=None, lota=None, tpRest=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.tpOp = tpOp
        self.validate_tpOpType(self.tpOp)
        self.tpOp_nsprefix_ = None
        self.chassi = chassi
        self.validate_chassiType(self.chassi)
        self.chassi_nsprefix_ = None
        self.cCor = cCor
        self.validate_cCorType(self.cCor)
        self.cCor_nsprefix_ = None
        self.xCor = xCor
        self.validate_xCorType(self.xCor)
        self.xCor_nsprefix_ = None
        self.pot = pot
        self.validate_potType(self.pot)
        self.pot_nsprefix_ = None
        self.cilin = cilin
        self.validate_cilinType(self.cilin)
        self.cilin_nsprefix_ = None
        self.pesoL = pesoL
        self.validate_pesoLType(self.pesoL)
        self.pesoL_nsprefix_ = None
        self.pesoB = pesoB
        self.validate_pesoBType(self.pesoB)
        self.pesoB_nsprefix_ = None
        self.nSerie = nSerie
        self.validate_nSerieType(self.nSerie)
        self.nSerie_nsprefix_ = None
        self.tpComb = tpComb
        self.validate_tpCombType(self.tpComb)
        self.tpComb_nsprefix_ = None
        self.nMotor = nMotor
        self.validate_nMotorType(self.nMotor)
        self.nMotor_nsprefix_ = None
        self.CMT = CMT
        self.validate_CMTType(self.CMT)
        self.CMT_nsprefix_ = None
        self.dist = dist
        self.validate_distType(self.dist)
        self.dist_nsprefix_ = None
        self.anoMod = anoMod
        self.validate_anoModType(self.anoMod)
        self.anoMod_nsprefix_ = None
        self.anoFab = anoFab
        self.validate_anoFabType(self.anoFab)
        self.anoFab_nsprefix_ = None
        self.tpPint = tpPint
        self.validate_tpPintType(self.tpPint)
        self.tpPint_nsprefix_ = None
        self.tpVeic = tpVeic
        self.validate_tpVeicType(self.tpVeic)
        self.tpVeic_nsprefix_ = None
        self.espVeic = espVeic
        self.validate_espVeicType(self.espVeic)
        self.espVeic_nsprefix_ = None
        self.VIN = VIN
        self.validate_VINType(self.VIN)
        self.VIN_nsprefix_ = None
        self.condVeic = condVeic
        self.validate_condVeicType(self.condVeic)
        self.condVeic_nsprefix_ = None
        self.cMod = cMod
        self.validate_cModType(self.cMod)
        self.cMod_nsprefix_ = None
        self.cCorDENATRAN = cCorDENATRAN
        self.validate_cCorDENATRANType(self.cCorDENATRAN)
        self.cCorDENATRAN_nsprefix_ = None
        self.lota = lota
        self.validate_lotaType(self.lota)
        self.lota_nsprefix_ = None
        self.tpRest = tpRest
        self.validate_tpRestType(self.tpRest)
        self.tpRest_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, veicProdType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if veicProdType.subclass:
            return veicProdType.subclass(*args_, **kwargs_)
        else:
            return veicProdType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_tpOpType(self, value):
        result = True
        # Validate type tpOpType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on tpOpType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_chassiType(self, value):
        result = True
        # Validate type chassiType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) != 17:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on chassiType' % {"value": encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_chassiType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_chassiType_patterns_, ))
                result = False
        return result
    validate_chassiType_patterns_ = [['^([A-Z0-9]+)$']]
    def validate_cCorType(self, value):
        result = True
        # Validate type cCorType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 4:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on cCorType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on cCorType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_cCorType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cCorType_patterns_, ))
                result = False
        return result
    validate_cCorType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_xCorType(self, value):
        result = True
        # Validate type xCorType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 40:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xCorType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xCorType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xCorType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xCorType_patterns_, ))
                result = False
        return result
    validate_xCorType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_potType(self, value):
        result = True
        # Validate type potType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 4:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on potType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on potType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_potType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_potType_patterns_, ))
                result = False
        return result
    validate_potType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_cilinType(self, value):
        result = True
        # Validate type cilinType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 4:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on cilinType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on cilinType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_cilinType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cilinType_patterns_, ))
                result = False
        return result
    validate_cilinType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_pesoLType(self, value):
        result = True
        # Validate type pesoLType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 9:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on pesoLType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on pesoLType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_pesoLType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_pesoLType_patterns_, ))
                result = False
        return result
    validate_pesoLType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_pesoBType(self, value):
        result = True
        # Validate type pesoBType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 9:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on pesoBType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on pesoBType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_pesoBType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_pesoBType_patterns_, ))
                result = False
        return result
    validate_pesoBType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_nSerieType(self, value):
        result = True
        # Validate type nSerieType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 9:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on nSerieType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nSerieType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_nSerieType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nSerieType_patterns_, ))
                result = False
        return result
    validate_nSerieType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_tpCombType(self, value):
        result = True
        # Validate type tpCombType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on tpCombType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on tpCombType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_tpCombType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_tpCombType_patterns_, ))
                result = False
        return result
    validate_tpCombType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_nMotorType(self, value):
        result = True
        # Validate type nMotorType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 21:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on nMotorType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nMotorType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_nMotorType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nMotorType_patterns_, ))
                result = False
        return result
    validate_nMotorType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_CMTType(self, value):
        result = True
        # Validate type CMTType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 9:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on CMTType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on CMTType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_CMTType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_CMTType_patterns_, ))
                result = False
        return result
    validate_CMTType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_distType(self, value):
        result = True
        # Validate type distType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 4:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on distType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on distType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_distType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_distType_patterns_, ))
                result = False
        return result
    validate_distType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_anoModType(self, value):
        result = True
        # Validate type anoModType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_anoModType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_anoModType_patterns_, ))
                result = False
        return result
    validate_anoModType_patterns_ = [['^([0-9]{4})$']]
    def validate_anoFabType(self, value):
        result = True
        # Validate type anoFabType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_anoFabType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_anoFabType_patterns_, ))
                result = False
        return result
    validate_anoFabType_patterns_ = [['^([0-9]{4})$']]
    def validate_tpPintType(self, value):
        result = True
        # Validate type tpPintType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) != 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on tpPintType' % {"value": value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_tpPintType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_tpPintType_patterns_, ))
                result = False
        return result
    validate_tpPintType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_tpVeicType(self, value):
        result = True
        # Validate type tpVeicType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_tpVeicType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_tpVeicType_patterns_, ))
                result = False
        return result
    validate_tpVeicType_patterns_ = [['^([0-9]{1,2})$']]
    def validate_espVeicType(self, value):
        result = True
        # Validate type espVeicType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_espVeicType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_espVeicType_patterns_, ))
                result = False
        return result
    validate_espVeicType_patterns_ = [['^([0-9]{1})$']]
    def validate_VINType(self, value):
        result = True
        # Validate type VINType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['R', 'N']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on VINType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) != 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on VINType' % {"value": value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_VINType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_VINType_patterns_, ))
                result = False
        return result
    validate_VINType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_condVeicType(self, value):
        result = True
        # Validate type condVeicType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['1', '2', '3']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on condVeicType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_cModType(self, value):
        result = True
        # Validate type cModType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_cModType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cModType_patterns_, ))
                result = False
        return result
    validate_cModType_patterns_ = [['^([0-9]{1,6})$']]
    def validate_cCorDENATRANType(self, value):
        result = True
        # Validate type cCorDENATRANType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on cCorDENATRANType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on cCorDENATRANType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_cCorDENATRANType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cCorDENATRANType_patterns_, ))
                result = False
        return result
    validate_cCorDENATRANType_patterns_ = [['^([0-9]{1,2})$']]
    def validate_lotaType(self, value):
        result = True
        # Validate type lotaType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on lotaType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on lotaType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_lotaType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_lotaType_patterns_, ))
                result = False
        return result
    validate_lotaType_patterns_ = [['^([0-9]{1,3})$']]
    def validate_tpRestType(self, value):
        result = True
        # Validate type tpRestType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '9']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on tpRestType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def hasContent_(self):
        if (
            self.tpOp is not None or
            self.chassi is not None or
            self.cCor is not None or
            self.xCor is not None or
            self.pot is not None or
            self.cilin is not None or
            self.pesoL is not None or
            self.pesoB is not None or
            self.nSerie is not None or
            self.tpComb is not None or
            self.nMotor is not None or
            self.CMT is not None or
            self.dist is not None or
            self.anoMod is not None or
            self.anoFab is not None or
            self.tpPint is not None or
            self.tpVeic is not None or
            self.espVeic is not None or
            self.VIN is not None or
            self.condVeic is not None or
            self.cMod is not None or
            self.cCorDENATRAN is not None or
            self.lota is not None or
            self.tpRest is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='veicProdType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('veicProdType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'veicProdType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='veicProdType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='veicProdType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='veicProdType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='veicProdType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.tpOp is not None:
            namespaceprefix_ = self.tpOp_nsprefix_ + ':' if (UseCapturedNS_ and self.tpOp_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stpOp>%s</%stpOp>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tpOp), input_name='tpOp')), namespaceprefix_ , eol_))
        if self.chassi is not None:
            namespaceprefix_ = self.chassi_nsprefix_ + ':' if (UseCapturedNS_ and self.chassi_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%schassi>%s</%schassi>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.chassi), input_name='chassi')), namespaceprefix_ , eol_))
        if self.cCor is not None:
            namespaceprefix_ = self.cCor_nsprefix_ + ':' if (UseCapturedNS_ and self.cCor_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scCor>%s</%scCor>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cCor), input_name='cCor')), namespaceprefix_ , eol_))
        if self.xCor is not None:
            namespaceprefix_ = self.xCor_nsprefix_ + ':' if (UseCapturedNS_ and self.xCor_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxCor>%s</%sxCor>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xCor), input_name='xCor')), namespaceprefix_ , eol_))
        if self.pot is not None:
            namespaceprefix_ = self.pot_nsprefix_ + ':' if (UseCapturedNS_ and self.pot_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spot>%s</%spot>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pot), input_name='pot')), namespaceprefix_ , eol_))
        if self.cilin is not None:
            namespaceprefix_ = self.cilin_nsprefix_ + ':' if (UseCapturedNS_ and self.cilin_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scilin>%s</%scilin>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cilin), input_name='cilin')), namespaceprefix_ , eol_))
        if self.pesoL is not None:
            namespaceprefix_ = self.pesoL_nsprefix_ + ':' if (UseCapturedNS_ and self.pesoL_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spesoL>%s</%spesoL>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pesoL), input_name='pesoL')), namespaceprefix_ , eol_))
        if self.pesoB is not None:
            namespaceprefix_ = self.pesoB_nsprefix_ + ':' if (UseCapturedNS_ and self.pesoB_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spesoB>%s</%spesoB>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pesoB), input_name='pesoB')), namespaceprefix_ , eol_))
        if self.nSerie is not None:
            namespaceprefix_ = self.nSerie_nsprefix_ + ':' if (UseCapturedNS_ and self.nSerie_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snSerie>%s</%snSerie>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nSerie), input_name='nSerie')), namespaceprefix_ , eol_))
        if self.tpComb is not None:
            namespaceprefix_ = self.tpComb_nsprefix_ + ':' if (UseCapturedNS_ and self.tpComb_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stpComb>%s</%stpComb>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tpComb), input_name='tpComb')), namespaceprefix_ , eol_))
        if self.nMotor is not None:
            namespaceprefix_ = self.nMotor_nsprefix_ + ':' if (UseCapturedNS_ and self.nMotor_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snMotor>%s</%snMotor>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nMotor), input_name='nMotor')), namespaceprefix_ , eol_))
        if self.CMT is not None:
            namespaceprefix_ = self.CMT_nsprefix_ + ':' if (UseCapturedNS_ and self.CMT_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCMT>%s</%sCMT>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CMT), input_name='CMT')), namespaceprefix_ , eol_))
        if self.dist is not None:
            namespaceprefix_ = self.dist_nsprefix_ + ':' if (UseCapturedNS_ and self.dist_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdist>%s</%sdist>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.dist), input_name='dist')), namespaceprefix_ , eol_))
        if self.anoMod is not None:
            namespaceprefix_ = self.anoMod_nsprefix_ + ':' if (UseCapturedNS_ and self.anoMod_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sanoMod>%s</%sanoMod>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.anoMod), input_name='anoMod')), namespaceprefix_ , eol_))
        if self.anoFab is not None:
            namespaceprefix_ = self.anoFab_nsprefix_ + ':' if (UseCapturedNS_ and self.anoFab_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sanoFab>%s</%sanoFab>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.anoFab), input_name='anoFab')), namespaceprefix_ , eol_))
        if self.tpPint is not None:
            namespaceprefix_ = self.tpPint_nsprefix_ + ':' if (UseCapturedNS_ and self.tpPint_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stpPint>%s</%stpPint>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tpPint), input_name='tpPint')), namespaceprefix_ , eol_))
        if self.tpVeic is not None:
            namespaceprefix_ = self.tpVeic_nsprefix_ + ':' if (UseCapturedNS_ and self.tpVeic_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stpVeic>%s</%stpVeic>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tpVeic), input_name='tpVeic')), namespaceprefix_ , eol_))
        if self.espVeic is not None:
            namespaceprefix_ = self.espVeic_nsprefix_ + ':' if (UseCapturedNS_ and self.espVeic_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sespVeic>%s</%sespVeic>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.espVeic), input_name='espVeic')), namespaceprefix_ , eol_))
        if self.VIN is not None:
            namespaceprefix_ = self.VIN_nsprefix_ + ':' if (UseCapturedNS_ and self.VIN_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sVIN>%s</%sVIN>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.VIN), input_name='VIN')), namespaceprefix_ , eol_))
        if self.condVeic is not None:
            namespaceprefix_ = self.condVeic_nsprefix_ + ':' if (UseCapturedNS_ and self.condVeic_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scondVeic>%s</%scondVeic>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.condVeic), input_name='condVeic')), namespaceprefix_ , eol_))
        if self.cMod is not None:
            namespaceprefix_ = self.cMod_nsprefix_ + ':' if (UseCapturedNS_ and self.cMod_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scMod>%s</%scMod>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cMod), input_name='cMod')), namespaceprefix_ , eol_))
        if self.cCorDENATRAN is not None:
            namespaceprefix_ = self.cCorDENATRAN_nsprefix_ + ':' if (UseCapturedNS_ and self.cCorDENATRAN_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scCorDENATRAN>%s</%scCorDENATRAN>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cCorDENATRAN), input_name='cCorDENATRAN')), namespaceprefix_ , eol_))
        if self.lota is not None:
            namespaceprefix_ = self.lota_nsprefix_ + ':' if (UseCapturedNS_ and self.lota_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slota>%s</%slota>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.lota), input_name='lota')), namespaceprefix_ , eol_))
        if self.tpRest is not None:
            namespaceprefix_ = self.tpRest_nsprefix_ + ':' if (UseCapturedNS_ and self.tpRest_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stpRest>%s</%stpRest>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tpRest), input_name='tpRest')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'tpOp':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tpOp')
            value_ = self.gds_validate_string(value_, node, 'tpOp')
            self.tpOp = value_
            self.tpOp_nsprefix_ = child_.prefix
            # validate type tpOpType
            self.validate_tpOpType(self.tpOp)
        elif nodeName_ == 'chassi':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'chassi')
            value_ = self.gds_validate_string(value_, node, 'chassi')
            self.chassi = value_
            self.chassi_nsprefix_ = child_.prefix
            # validate type chassiType
            self.validate_chassiType(self.chassi)
        elif nodeName_ == 'cCor':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cCor')
            value_ = self.gds_validate_string(value_, node, 'cCor')
            self.cCor = value_
            self.cCor_nsprefix_ = child_.prefix
            # validate type cCorType
            self.validate_cCorType(self.cCor)
        elif nodeName_ == 'xCor':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xCor')
            value_ = self.gds_validate_string(value_, node, 'xCor')
            self.xCor = value_
            self.xCor_nsprefix_ = child_.prefix
            # validate type xCorType
            self.validate_xCorType(self.xCor)
        elif nodeName_ == 'pot':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pot')
            value_ = self.gds_validate_string(value_, node, 'pot')
            self.pot = value_
            self.pot_nsprefix_ = child_.prefix
            # validate type potType
            self.validate_potType(self.pot)
        elif nodeName_ == 'cilin':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cilin')
            value_ = self.gds_validate_string(value_, node, 'cilin')
            self.cilin = value_
            self.cilin_nsprefix_ = child_.prefix
            # validate type cilinType
            self.validate_cilinType(self.cilin)
        elif nodeName_ == 'pesoL':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pesoL')
            value_ = self.gds_validate_string(value_, node, 'pesoL')
            self.pesoL = value_
            self.pesoL_nsprefix_ = child_.prefix
            # validate type pesoLType
            self.validate_pesoLType(self.pesoL)
        elif nodeName_ == 'pesoB':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pesoB')
            value_ = self.gds_validate_string(value_, node, 'pesoB')
            self.pesoB = value_
            self.pesoB_nsprefix_ = child_.prefix
            # validate type pesoBType
            self.validate_pesoBType(self.pesoB)
        elif nodeName_ == 'nSerie':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nSerie')
            value_ = self.gds_validate_string(value_, node, 'nSerie')
            self.nSerie = value_
            self.nSerie_nsprefix_ = child_.prefix
            # validate type nSerieType
            self.validate_nSerieType(self.nSerie)
        elif nodeName_ == 'tpComb':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tpComb')
            value_ = self.gds_validate_string(value_, node, 'tpComb')
            self.tpComb = value_
            self.tpComb_nsprefix_ = child_.prefix
            # validate type tpCombType
            self.validate_tpCombType(self.tpComb)
        elif nodeName_ == 'nMotor':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nMotor')
            value_ = self.gds_validate_string(value_, node, 'nMotor')
            self.nMotor = value_
            self.nMotor_nsprefix_ = child_.prefix
            # validate type nMotorType
            self.validate_nMotorType(self.nMotor)
        elif nodeName_ == 'CMT':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CMT')
            value_ = self.gds_validate_string(value_, node, 'CMT')
            self.CMT = value_
            self.CMT_nsprefix_ = child_.prefix
            # validate type CMTType
            self.validate_CMTType(self.CMT)
        elif nodeName_ == 'dist':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'dist')
            value_ = self.gds_validate_string(value_, node, 'dist')
            self.dist = value_
            self.dist_nsprefix_ = child_.prefix
            # validate type distType
            self.validate_distType(self.dist)
        elif nodeName_ == 'anoMod':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'anoMod')
            value_ = self.gds_validate_string(value_, node, 'anoMod')
            self.anoMod = value_
            self.anoMod_nsprefix_ = child_.prefix
            # validate type anoModType
            self.validate_anoModType(self.anoMod)
        elif nodeName_ == 'anoFab':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'anoFab')
            value_ = self.gds_validate_string(value_, node, 'anoFab')
            self.anoFab = value_
            self.anoFab_nsprefix_ = child_.prefix
            # validate type anoFabType
            self.validate_anoFabType(self.anoFab)
        elif nodeName_ == 'tpPint':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tpPint')
            value_ = self.gds_validate_string(value_, node, 'tpPint')
            self.tpPint = value_
            self.tpPint_nsprefix_ = child_.prefix
            # validate type tpPintType
            self.validate_tpPintType(self.tpPint)
        elif nodeName_ == 'tpVeic':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tpVeic')
            value_ = self.gds_validate_string(value_, node, 'tpVeic')
            self.tpVeic = value_
            self.tpVeic_nsprefix_ = child_.prefix
            # validate type tpVeicType
            self.validate_tpVeicType(self.tpVeic)
        elif nodeName_ == 'espVeic':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'espVeic')
            value_ = self.gds_validate_string(value_, node, 'espVeic')
            self.espVeic = value_
            self.espVeic_nsprefix_ = child_.prefix
            # validate type espVeicType
            self.validate_espVeicType(self.espVeic)
        elif nodeName_ == 'VIN':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'VIN')
            value_ = self.gds_validate_string(value_, node, 'VIN')
            self.VIN = value_
            self.VIN_nsprefix_ = child_.prefix
            # validate type VINType
            self.validate_VINType(self.VIN)
        elif nodeName_ == 'condVeic':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'condVeic')
            value_ = self.gds_validate_string(value_, node, 'condVeic')
            self.condVeic = value_
            self.condVeic_nsprefix_ = child_.prefix
            # validate type condVeicType
            self.validate_condVeicType(self.condVeic)
        elif nodeName_ == 'cMod':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cMod')
            value_ = self.gds_validate_string(value_, node, 'cMod')
            self.cMod = value_
            self.cMod_nsprefix_ = child_.prefix
            # validate type cModType
            self.validate_cModType(self.cMod)
        elif nodeName_ == 'cCorDENATRAN':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cCorDENATRAN')
            value_ = self.gds_validate_string(value_, node, 'cCorDENATRAN')
            self.cCorDENATRAN = value_
            self.cCorDENATRAN_nsprefix_ = child_.prefix
            # validate type cCorDENATRANType
            self.validate_cCorDENATRANType(self.cCorDENATRAN)
        elif nodeName_ == 'lota':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'lota')
            value_ = self.gds_validate_string(value_, node, 'lota')
            self.lota = value_
            self.lota_nsprefix_ = child_.prefix
            # validate type lotaType
            self.validate_lotaType(self.lota)
        elif nodeName_ == 'tpRest':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tpRest')
            value_ = self.gds_validate_string(value_, node, 'tpRest')
            self.tpRest = value_
            self.tpRest_nsprefix_ = child_.prefix
            # validate type tpRestType
            self.validate_tpRestType(self.tpRest)
# end class veicProdType


class medType(GeneratedsSuper):
    """grupo do detalhamento de Medicamentos e de matérias-primas
    farmacêuticas"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('cProdANVISA', ['cProdANVISAType', 'TString', 'xs:string'], 0, 0, {'name': 'cProdANVISA', 'type': 'xs:string'}, None),
        MemberSpec_('xMotivoIsencao', ['xMotivoIsencaoType', 'TString', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'xMotivoIsencao', 'type': 'xs:string'}, None),
        MemberSpec_('vPMC', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vPMC', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, cProdANVISA=None, xMotivoIsencao=None, vPMC=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.cProdANVISA = cProdANVISA
        self.validate_cProdANVISAType(self.cProdANVISA)
        self.cProdANVISA_nsprefix_ = None
        self.xMotivoIsencao = xMotivoIsencao
        self.validate_xMotivoIsencaoType(self.xMotivoIsencao)
        self.xMotivoIsencao_nsprefix_ = None
        self.vPMC = vPMC
        self.validate_TDec_1302(self.vPMC)
        self.vPMC_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, medType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if medType.subclass:
            return medType.subclass(*args_, **kwargs_)
        else:
            return medType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_cProdANVISAType(self, value):
        result = True
        # Validate type cProdANVISAType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_cProdANVISAType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cProdANVISAType_patterns_, ))
                result = False
        return result
    validate_cProdANVISAType_patterns_ = [['^([0-9]{13}|ISENTO)$'], ['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_xMotivoIsencaoType(self, value):
        result = True
        # Validate type xMotivoIsencaoType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 255:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on xMotivoIsencaoType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on xMotivoIsencaoType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_xMotivoIsencaoType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_xMotivoIsencaoType_patterns_, ))
                result = False
        return result
    validate_xMotivoIsencaoType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def hasContent_(self):
        if (
            self.cProdANVISA is not None or
            self.xMotivoIsencao is not None or
            self.vPMC is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='medType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('medType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'medType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='medType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='medType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='medType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='medType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.cProdANVISA is not None:
            namespaceprefix_ = self.cProdANVISA_nsprefix_ + ':' if (UseCapturedNS_ and self.cProdANVISA_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scProdANVISA>%s</%scProdANVISA>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cProdANVISA), input_name='cProdANVISA')), namespaceprefix_ , eol_))
        if self.xMotivoIsencao is not None:
            namespaceprefix_ = self.xMotivoIsencao_nsprefix_ + ':' if (UseCapturedNS_ and self.xMotivoIsencao_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxMotivoIsencao>%s</%sxMotivoIsencao>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.xMotivoIsencao), input_name='xMotivoIsencao')), namespaceprefix_ , eol_))
        if self.vPMC is not None:
            namespaceprefix_ = self.vPMC_nsprefix_ + ':' if (UseCapturedNS_ and self.vPMC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svPMC>%s</%svPMC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vPMC), input_name='vPMC')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'cProdANVISA':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cProdANVISA')
            value_ = self.gds_validate_string(value_, node, 'cProdANVISA')
            self.cProdANVISA = value_
            self.cProdANVISA_nsprefix_ = child_.prefix
            # validate type cProdANVISAType
            self.validate_cProdANVISAType(self.cProdANVISA)
        elif nodeName_ == 'xMotivoIsencao':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'xMotivoIsencao')
            value_ = self.gds_validate_string(value_, node, 'xMotivoIsencao')
            self.xMotivoIsencao = value_
            self.xMotivoIsencao_nsprefix_ = child_.prefix
            # validate type xMotivoIsencaoType
            self.validate_xMotivoIsencaoType(self.xMotivoIsencao)
        elif nodeName_ == 'vPMC':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vPMC')
            value_ = self.gds_validate_string(value_, node, 'vPMC')
            self.vPMC = value_
            self.vPMC_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vPMC)
# end class medType


class armaType(GeneratedsSuper):
    """Armamentos"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('tpArma', ['tpArmaType', 'xs:string'], 0, 0, {'name': 'tpArma', 'type': 'xs:string'}, None),
        MemberSpec_('nSerie', ['nSerieType7', 'TString', 'xs:string'], 0, 0, {'name': 'nSerie', 'type': 'xs:string'}, None),
        MemberSpec_('nCano', ['nCanoType', 'TString', 'xs:string'], 0, 0, {'name': 'nCano', 'type': 'xs:string'}, None),
        MemberSpec_('descr', ['descrType', 'TString', 'xs:string'], 0, 0, {'name': 'descr', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, tpArma=None, nSerie=None, nCano=None, descr=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.tpArma = tpArma
        self.validate_tpArmaType(self.tpArma)
        self.tpArma_nsprefix_ = None
        self.nSerie = nSerie
        self.validate_nSerieType7(self.nSerie)
        self.nSerie_nsprefix_ = None
        self.nCano = nCano
        self.validate_nCanoType(self.nCano)
        self.nCano_nsprefix_ = None
        self.descr = descr
        self.validate_descrType(self.descr)
        self.descr_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, armaType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if armaType.subclass:
            return armaType.subclass(*args_, **kwargs_)
        else:
            return armaType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_tpArmaType(self, value):
        result = True
        # Validate type tpArmaType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on tpArmaType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_nSerieType7(self, value):
        result = True
        # Validate type nSerieType7, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 15:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on nSerieType7' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nSerieType7' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_nSerieType7_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nSerieType7_patterns_, ))
                result = False
        return result
    validate_nSerieType7_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_nCanoType(self, value):
        result = True
        # Validate type nCanoType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 15:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on nCanoType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nCanoType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_nCanoType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nCanoType_patterns_, ))
                result = False
        return result
    validate_nCanoType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def validate_descrType(self, value):
        result = True
        # Validate type descrType, a restriction on TString.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 256:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on descrType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on descrType' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_descrType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_descrType_patterns_, ))
                result = False
        return result
    validate_descrType_patterns_ = [['^([!-ÿ]{1}[ -ÿ]{0,}[!-ÿ]{1}|[!-ÿ]{1})$']]
    def hasContent_(self):
        if (
            self.tpArma is not None or
            self.nSerie is not None or
            self.nCano is not None or
            self.descr is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='armaType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('armaType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'armaType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='armaType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='armaType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='armaType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='armaType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.tpArma is not None:
            namespaceprefix_ = self.tpArma_nsprefix_ + ':' if (UseCapturedNS_ and self.tpArma_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stpArma>%s</%stpArma>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tpArma), input_name='tpArma')), namespaceprefix_ , eol_))
        if self.nSerie is not None:
            namespaceprefix_ = self.nSerie_nsprefix_ + ':' if (UseCapturedNS_ and self.nSerie_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snSerie>%s</%snSerie>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nSerie), input_name='nSerie')), namespaceprefix_ , eol_))
        if self.nCano is not None:
            namespaceprefix_ = self.nCano_nsprefix_ + ':' if (UseCapturedNS_ and self.nCano_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snCano>%s</%snCano>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nCano), input_name='nCano')), namespaceprefix_ , eol_))
        if self.descr is not None:
            namespaceprefix_ = self.descr_nsprefix_ + ':' if (UseCapturedNS_ and self.descr_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescr>%s</%sdescr>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.descr), input_name='descr')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'tpArma':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tpArma')
            value_ = self.gds_validate_string(value_, node, 'tpArma')
            self.tpArma = value_
            self.tpArma_nsprefix_ = child_.prefix
            # validate type tpArmaType
            self.validate_tpArmaType(self.tpArma)
        elif nodeName_ == 'nSerie':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nSerie')
            value_ = self.gds_validate_string(value_, node, 'nSerie')
            self.nSerie = value_
            self.nSerie_nsprefix_ = child_.prefix
            # validate type nSerieType7
            self.validate_nSerieType7(self.nSerie)
        elif nodeName_ == 'nCano':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nCano')
            value_ = self.gds_validate_string(value_, node, 'nCano')
            self.nCano = value_
            self.nCano_nsprefix_ = child_.prefix
            # validate type nCanoType
            self.validate_nCanoType(self.nCano)
        elif nodeName_ == 'descr':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'descr')
            value_ = self.gds_validate_string(value_, node, 'descr')
            self.descr = value_
            self.descr_nsprefix_ = child_.prefix
            # validate type descrType
            self.validate_descrType(self.descr)
# end class armaType


class combType(GeneratedsSuper):
    """Informar apenas para operações com combustíveis líquidos"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('cProdANP', ['cProdANPType', 'xs:string'], 0, 0, {'name': 'cProdANP', 'type': 'xs:string'}, None),
        MemberSpec_('descANP', ['descANPType', 'xs:string'], 0, 0, {'name': 'descANP', 'type': 'xs:string'}, None),
        MemberSpec_('pGLP', ['TDec_0302a04Max100', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pGLP', 'type': 'xs:string'}, None),
        MemberSpec_('pGNn', ['TDec_0302a04Max100', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pGNn', 'type': 'xs:string'}, None),
        MemberSpec_('pGNi', ['TDec_0302a04Max100', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pGNi', 'type': 'xs:string'}, None),
        MemberSpec_('vPart', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vPart', 'type': 'xs:string'}, None),
        MemberSpec_('CODIF', ['CODIFType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'CODIF', 'type': 'xs:string'}, None),
        MemberSpec_('qTemp', ['TDec_1204temperatura', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'qTemp', 'type': 'xs:string'}, None),
        MemberSpec_('UFCons', ['TUf', 'xs:string'], 0, 0, {'name': 'UFCons', 'type': 'xs:string'}, None),
        MemberSpec_('CIDE', 'CIDEType', 0, 1, {'minOccurs': '0', 'name': 'CIDE', 'type': 'CIDEType'}, None),
        MemberSpec_('encerrante', 'encerranteType', 0, 1, {'minOccurs': '0', 'name': 'encerrante', 'type': 'encerranteType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, cProdANP=None, descANP=None, pGLP=None, pGNn=None, pGNi=None, vPart=None, CODIF=None, qTemp=None, UFCons=None, CIDE=None, encerrante=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.cProdANP = cProdANP
        self.validate_cProdANPType(self.cProdANP)
        self.cProdANP_nsprefix_ = None
        self.descANP = descANP
        self.validate_descANPType(self.descANP)
        self.descANP_nsprefix_ = None
        self.pGLP = pGLP
        self.validate_TDec_0302a04Max100(self.pGLP)
        self.pGLP_nsprefix_ = None
        self.pGNn = pGNn
        self.validate_TDec_0302a04Max100(self.pGNn)
        self.pGNn_nsprefix_ = None
        self.pGNi = pGNi
        self.validate_TDec_0302a04Max100(self.pGNi)
        self.pGNi_nsprefix_ = None
        self.vPart = vPart
        self.validate_TDec_1302(self.vPart)
        self.vPart_nsprefix_ = None
        self.CODIF = CODIF
        self.validate_CODIFType(self.CODIF)
        self.CODIF_nsprefix_ = None
        self.qTemp = qTemp
        self.validate_TDec_1204temperatura(self.qTemp)
        self.qTemp_nsprefix_ = None
        self.UFCons = UFCons
        self.validate_TUf(self.UFCons)
        self.UFCons_nsprefix_ = None
        self.CIDE = CIDE
        self.CIDE_nsprefix_ = None
        self.encerrante = encerrante
        self.encerrante_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, combType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if combType.subclass:
            return combType.subclass(*args_, **kwargs_)
        else:
            return combType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_cProdANPType(self, value):
        result = True
        # Validate type cProdANPType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_cProdANPType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_cProdANPType_patterns_, ))
                result = False
        return result
    validate_cProdANPType_patterns_ = [['^([0-9]{9})$']]
    def validate_descANPType(self, value):
        result = True
        # Validate type descANPType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 95:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on descANPType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on descANPType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TDec_0302a04Max100(self, value):
        result = True
        # Validate type TDec_0302a04Max100, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0302a04Max100_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0302a04Max100_patterns_, ))
                result = False
        return result
    validate_TDec_0302a04Max100_patterns_ = [['^(0(\\.[0-9]{2,4})?|[1-9]{1}[0-9]{0,1}(\\.[0-9]{2,4})?|100(\\.0{2,4})?)$']]
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def validate_CODIFType(self, value):
        result = True
        # Validate type CODIFType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_CODIFType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_CODIFType_patterns_, ))
                result = False
        return result
    validate_CODIFType_patterns_ = [['^([0-9]{1,21})$']]
    def validate_TDec_1204temperatura(self, value):
        result = True
        # Validate type TDec_1204temperatura, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1204temperatura_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1204temperatura_patterns_, ))
                result = False
        return result
    validate_TDec_1204temperatura_patterns_ = [['^(0\\.[1-9]{1}[0-9]{3}|0\\.[0-9]{3}[1-9]{1}|0\\.[0-9]{2}[1-9]{1}[0-9]{1}|0\\.[0-9]{1}[1-9]{1}[0-9]{2}|[1-9]{1}[0-9]{0,11}(\\.[0-9]{4})?)$']]
    def validate_TUf(self, value):
        result = True
        # Validate type TUf, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['AC', 'AL', 'AM', 'AP', 'BA', 'CE', 'DF', 'ES', 'GO', 'MA', 'MG', 'MS', 'MT', 'PA', 'PB', 'PE', 'PI', 'PR', 'RJ', 'RN', 'RO', 'RR', 'RS', 'SC', 'SE', 'SP', 'TO', 'EX']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TUf' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def hasContent_(self):
        if (
            self.cProdANP is not None or
            self.descANP is not None or
            self.pGLP is not None or
            self.pGNn is not None or
            self.pGNi is not None or
            self.vPart is not None or
            self.CODIF is not None or
            self.qTemp is not None or
            self.UFCons is not None or
            self.CIDE is not None or
            self.encerrante is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='combType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('combType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'combType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='combType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='combType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='combType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='combType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.cProdANP is not None:
            namespaceprefix_ = self.cProdANP_nsprefix_ + ':' if (UseCapturedNS_ and self.cProdANP_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scProdANP>%s</%scProdANP>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cProdANP), input_name='cProdANP')), namespaceprefix_ , eol_))
        if self.descANP is not None:
            namespaceprefix_ = self.descANP_nsprefix_ + ':' if (UseCapturedNS_ and self.descANP_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescANP>%s</%sdescANP>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.descANP), input_name='descANP')), namespaceprefix_ , eol_))
        if self.pGLP is not None:
            namespaceprefix_ = self.pGLP_nsprefix_ + ':' if (UseCapturedNS_ and self.pGLP_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spGLP>%s</%spGLP>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pGLP), input_name='pGLP')), namespaceprefix_ , eol_))
        if self.pGNn is not None:
            namespaceprefix_ = self.pGNn_nsprefix_ + ':' if (UseCapturedNS_ and self.pGNn_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spGNn>%s</%spGNn>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pGNn), input_name='pGNn')), namespaceprefix_ , eol_))
        if self.pGNi is not None:
            namespaceprefix_ = self.pGNi_nsprefix_ + ':' if (UseCapturedNS_ and self.pGNi_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spGNi>%s</%spGNi>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pGNi), input_name='pGNi')), namespaceprefix_ , eol_))
        if self.vPart is not None:
            namespaceprefix_ = self.vPart_nsprefix_ + ':' if (UseCapturedNS_ and self.vPart_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svPart>%s</%svPart>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vPart), input_name='vPart')), namespaceprefix_ , eol_))
        if self.CODIF is not None:
            namespaceprefix_ = self.CODIF_nsprefix_ + ':' if (UseCapturedNS_ and self.CODIF_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCODIF>%s</%sCODIF>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CODIF), input_name='CODIF')), namespaceprefix_ , eol_))
        if self.qTemp is not None:
            namespaceprefix_ = self.qTemp_nsprefix_ + ':' if (UseCapturedNS_ and self.qTemp_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sqTemp>%s</%sqTemp>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.qTemp), input_name='qTemp')), namespaceprefix_ , eol_))
        if self.UFCons is not None:
            namespaceprefix_ = self.UFCons_nsprefix_ + ':' if (UseCapturedNS_ and self.UFCons_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUFCons>%s</%sUFCons>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.UFCons), input_name='UFCons')), namespaceprefix_ , eol_))
        if self.CIDE is not None:
            namespaceprefix_ = self.CIDE_nsprefix_ + ':' if (UseCapturedNS_ and self.CIDE_nsprefix_) else ''
            self.CIDE.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CIDE', pretty_print=pretty_print)
        if self.encerrante is not None:
            namespaceprefix_ = self.encerrante_nsprefix_ + ':' if (UseCapturedNS_ and self.encerrante_nsprefix_) else ''
            self.encerrante.export(outfile, level, namespaceprefix_, namespacedef_='', name_='encerrante', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'cProdANP':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'cProdANP')
            value_ = self.gds_validate_string(value_, node, 'cProdANP')
            self.cProdANP = value_
            self.cProdANP_nsprefix_ = child_.prefix
            # validate type cProdANPType
            self.validate_cProdANPType(self.cProdANP)
        elif nodeName_ == 'descANP':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'descANP')
            value_ = self.gds_validate_string(value_, node, 'descANP')
            self.descANP = value_
            self.descANP_nsprefix_ = child_.prefix
            # validate type descANPType
            self.validate_descANPType(self.descANP)
        elif nodeName_ == 'pGLP':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pGLP')
            value_ = self.gds_validate_string(value_, node, 'pGLP')
            self.pGLP = value_
            self.pGLP_nsprefix_ = child_.prefix
            # validate type TDec_0302a04Max100
            self.validate_TDec_0302a04Max100(self.pGLP)
        elif nodeName_ == 'pGNn':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pGNn')
            value_ = self.gds_validate_string(value_, node, 'pGNn')
            self.pGNn = value_
            self.pGNn_nsprefix_ = child_.prefix
            # validate type TDec_0302a04Max100
            self.validate_TDec_0302a04Max100(self.pGNn)
        elif nodeName_ == 'pGNi':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pGNi')
            value_ = self.gds_validate_string(value_, node, 'pGNi')
            self.pGNi = value_
            self.pGNi_nsprefix_ = child_.prefix
            # validate type TDec_0302a04Max100
            self.validate_TDec_0302a04Max100(self.pGNi)
        elif nodeName_ == 'vPart':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vPart')
            value_ = self.gds_validate_string(value_, node, 'vPart')
            self.vPart = value_
            self.vPart_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vPart)
        elif nodeName_ == 'CODIF':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CODIF')
            value_ = self.gds_validate_string(value_, node, 'CODIF')
            self.CODIF = value_
            self.CODIF_nsprefix_ = child_.prefix
            # validate type CODIFType
            self.validate_CODIFType(self.CODIF)
        elif nodeName_ == 'qTemp':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'qTemp')
            value_ = self.gds_validate_string(value_, node, 'qTemp')
            self.qTemp = value_
            self.qTemp_nsprefix_ = child_.prefix
            # validate type TDec_1204temperatura
            self.validate_TDec_1204temperatura(self.qTemp)
        elif nodeName_ == 'UFCons':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'UFCons')
            value_ = self.gds_validate_string(value_, node, 'UFCons')
            self.UFCons = value_
            self.UFCons_nsprefix_ = child_.prefix
            # validate type TUf
            self.validate_TUf(self.UFCons)
        elif nodeName_ == 'CIDE':
            obj_ = CIDEType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CIDE = obj_
            obj_.original_tagname_ = 'CIDE'
        elif nodeName_ == 'encerrante':
            obj_ = encerranteType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.encerrante = obj_
            obj_.original_tagname_ = 'encerrante'
# end class combType


class CIDEType(GeneratedsSuper):
    """CIDE Combustíveis"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('qBCProd', ['TDec_1204v', 'xs:string'], 0, 0, {'name': 'qBCProd', 'type': 'xs:string'}, None),
        MemberSpec_('vAliqProd', ['TDec_1104', 'xs:string'], 0, 0, {'name': 'vAliqProd', 'type': 'xs:string'}, None),
        MemberSpec_('vCIDE', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vCIDE', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, qBCProd=None, vAliqProd=None, vCIDE=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.qBCProd = qBCProd
        self.validate_TDec_1204v(self.qBCProd)
        self.qBCProd_nsprefix_ = None
        self.vAliqProd = vAliqProd
        self.validate_TDec_1104(self.vAliqProd)
        self.vAliqProd_nsprefix_ = None
        self.vCIDE = vCIDE
        self.validate_TDec_1302(self.vCIDE)
        self.vCIDE_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CIDEType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CIDEType.subclass:
            return CIDEType.subclass(*args_, **kwargs_)
        else:
            return CIDEType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TDec_1204v(self, value):
        result = True
        # Validate type TDec_1204v, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1204v_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1204v_patterns_, ))
                result = False
        return result
    validate_TDec_1204v_patterns_ = [['^(0|0\\.[0-9]{1,4}|[1-9]{1}[0-9]{0,11}|[1-9]{1}[0-9]{0,11}(\\.[0-9]{1,4})?)$']]
    def validate_TDec_1104(self, value):
        result = True
        # Validate type TDec_1104, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1104_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1104_patterns_, ))
                result = False
        return result
    validate_TDec_1104_patterns_ = [['^(0|0\\.[0-9]{4}|[1-9]{1}[0-9]{0,10}(\\.[0-9]{4})?)$']]
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def hasContent_(self):
        if (
            self.qBCProd is not None or
            self.vAliqProd is not None or
            self.vCIDE is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CIDEType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CIDEType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CIDEType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CIDEType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CIDEType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CIDEType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CIDEType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.qBCProd is not None:
            namespaceprefix_ = self.qBCProd_nsprefix_ + ':' if (UseCapturedNS_ and self.qBCProd_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sqBCProd>%s</%sqBCProd>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.qBCProd), input_name='qBCProd')), namespaceprefix_ , eol_))
        if self.vAliqProd is not None:
            namespaceprefix_ = self.vAliqProd_nsprefix_ + ':' if (UseCapturedNS_ and self.vAliqProd_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svAliqProd>%s</%svAliqProd>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vAliqProd), input_name='vAliqProd')), namespaceprefix_ , eol_))
        if self.vCIDE is not None:
            namespaceprefix_ = self.vCIDE_nsprefix_ + ':' if (UseCapturedNS_ and self.vCIDE_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svCIDE>%s</%svCIDE>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vCIDE), input_name='vCIDE')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'qBCProd':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'qBCProd')
            value_ = self.gds_validate_string(value_, node, 'qBCProd')
            self.qBCProd = value_
            self.qBCProd_nsprefix_ = child_.prefix
            # validate type TDec_1204v
            self.validate_TDec_1204v(self.qBCProd)
        elif nodeName_ == 'vAliqProd':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vAliqProd')
            value_ = self.gds_validate_string(value_, node, 'vAliqProd')
            self.vAliqProd = value_
            self.vAliqProd_nsprefix_ = child_.prefix
            # validate type TDec_1104
            self.validate_TDec_1104(self.vAliqProd)
        elif nodeName_ == 'vCIDE':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vCIDE')
            value_ = self.gds_validate_string(value_, node, 'vCIDE')
            self.vCIDE = value_
            self.vCIDE_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vCIDE)
# end class CIDEType


class encerranteType(GeneratedsSuper):
    """Informações do grupo de "encerrante" """
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('nBico', ['nBicoType', 'xs:string'], 0, 0, {'name': 'nBico', 'type': 'xs:string'}, None),
        MemberSpec_('nBomba', ['nBombaType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'nBomba', 'type': 'xs:string'}, None),
        MemberSpec_('nTanque', ['nTanqueType', 'xs:string'], 0, 0, {'name': 'nTanque', 'type': 'xs:string'}, None),
        MemberSpec_('vEncIni', ['TDec_1203', 'xs:string'], 0, 0, {'name': 'vEncIni', 'type': 'xs:string'}, None),
        MemberSpec_('vEncFin', ['TDec_1203', 'xs:string'], 0, 0, {'name': 'vEncFin', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, nBico=None, nBomba=None, nTanque=None, vEncIni=None, vEncFin=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nBico = nBico
        self.validate_nBicoType(self.nBico)
        self.nBico_nsprefix_ = None
        self.nBomba = nBomba
        self.validate_nBombaType(self.nBomba)
        self.nBomba_nsprefix_ = None
        self.nTanque = nTanque
        self.validate_nTanqueType(self.nTanque)
        self.nTanque_nsprefix_ = None
        self.vEncIni = vEncIni
        self.validate_TDec_1203(self.vEncIni)
        self.vEncIni_nsprefix_ = None
        self.vEncFin = vEncFin
        self.validate_TDec_1203(self.vEncFin)
        self.vEncFin_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, encerranteType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if encerranteType.subclass:
            return encerranteType.subclass(*args_, **kwargs_)
        else:
            return encerranteType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_nBicoType(self, value):
        result = True
        # Validate type nBicoType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_nBicoType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nBicoType_patterns_, ))
                result = False
        return result
    validate_nBicoType_patterns_ = [['^([0-9]{1,3})$']]
    def validate_nBombaType(self, value):
        result = True
        # Validate type nBombaType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_nBombaType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nBombaType_patterns_, ))
                result = False
        return result
    validate_nBombaType_patterns_ = [['^([0-9]{1,3})$']]
    def validate_nTanqueType(self, value):
        result = True
        # Validate type nTanqueType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_nTanqueType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_nTanqueType_patterns_, ))
                result = False
        return result
    validate_nTanqueType_patterns_ = [['^([0-9]{1,3})$']]
    def validate_TDec_1203(self, value):
        result = True
        # Validate type TDec_1203, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1203_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1203_patterns_, ))
                result = False
        return result
    validate_TDec_1203_patterns_ = [['^(0|0\\.[0-9]{3}|[1-9]{1}[0-9]{0,11}(\\.[0-9]{3})?)$']]
    def hasContent_(self):
        if (
            self.nBico is not None or
            self.nBomba is not None or
            self.nTanque is not None or
            self.vEncIni is not None or
            self.vEncFin is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='encerranteType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('encerranteType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'encerranteType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='encerranteType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='encerranteType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='encerranteType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='encerranteType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.nBico is not None:
            namespaceprefix_ = self.nBico_nsprefix_ + ':' if (UseCapturedNS_ and self.nBico_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snBico>%s</%snBico>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nBico), input_name='nBico')), namespaceprefix_ , eol_))
        if self.nBomba is not None:
            namespaceprefix_ = self.nBomba_nsprefix_ + ':' if (UseCapturedNS_ and self.nBomba_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snBomba>%s</%snBomba>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nBomba), input_name='nBomba')), namespaceprefix_ , eol_))
        if self.nTanque is not None:
            namespaceprefix_ = self.nTanque_nsprefix_ + ':' if (UseCapturedNS_ and self.nTanque_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snTanque>%s</%snTanque>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.nTanque), input_name='nTanque')), namespaceprefix_ , eol_))
        if self.vEncIni is not None:
            namespaceprefix_ = self.vEncIni_nsprefix_ + ':' if (UseCapturedNS_ and self.vEncIni_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svEncIni>%s</%svEncIni>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vEncIni), input_name='vEncIni')), namespaceprefix_ , eol_))
        if self.vEncFin is not None:
            namespaceprefix_ = self.vEncFin_nsprefix_ + ':' if (UseCapturedNS_ and self.vEncFin_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svEncFin>%s</%svEncFin>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vEncFin), input_name='vEncFin')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'nBico':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nBico')
            value_ = self.gds_validate_string(value_, node, 'nBico')
            self.nBico = value_
            self.nBico_nsprefix_ = child_.prefix
            # validate type nBicoType
            self.validate_nBicoType(self.nBico)
        elif nodeName_ == 'nBomba':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nBomba')
            value_ = self.gds_validate_string(value_, node, 'nBomba')
            self.nBomba = value_
            self.nBomba_nsprefix_ = child_.prefix
            # validate type nBombaType
            self.validate_nBombaType(self.nBomba)
        elif nodeName_ == 'nTanque':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'nTanque')
            value_ = self.gds_validate_string(value_, node, 'nTanque')
            self.nTanque = value_
            self.nTanque_nsprefix_ = child_.prefix
            # validate type nTanqueType
            self.validate_nTanqueType(self.nTanque)
        elif nodeName_ == 'vEncIni':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vEncIni')
            value_ = self.gds_validate_string(value_, node, 'vEncIni')
            self.vEncIni = value_
            self.vEncIni_nsprefix_ = child_.prefix
            # validate type TDec_1203
            self.validate_TDec_1203(self.vEncIni)
        elif nodeName_ == 'vEncFin':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vEncFin')
            value_ = self.gds_validate_string(value_, node, 'vEncFin')
            self.vEncFin = value_
            self.vEncFin_nsprefix_ = child_.prefix
            # validate type TDec_1203
            self.validate_TDec_1203(self.vEncFin)
# end class encerranteType


class impostoType(GeneratedsSuper):
    """Tributos incidentes nos produtos ou serviços da NF-e"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('vTotTrib', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vTotTrib', 'type': 'xs:string'}, None),
        MemberSpec_('ICMS', 'ICMSType', 0, 0, {'name': 'ICMS', 'type': 'ICMSType'}, 10),
        MemberSpec_('IPI', 'TIpi', 0, 1, {'minOccurs': '0', 'name': 'IPI', 'type': 'TIpi'}, 10),
        MemberSpec_('II', 'IIType', 0, 1, {'minOccurs': '0', 'name': 'II', 'type': 'IIType'}, 10),
        MemberSpec_('ISSQN', 'ISSQNType', 0, 0, {'name': 'ISSQN', 'type': 'ISSQNType'}, 10),
        MemberSpec_('PIS', 'PISType', 0, 1, {'minOccurs': '0', 'name': 'PIS', 'type': 'PISType'}, None),
        MemberSpec_('PISST', 'PISSTType', 0, 1, {'minOccurs': '0', 'name': 'PISST', 'type': 'PISSTType'}, None),
        MemberSpec_('COFINS', 'COFINSType', 0, 1, {'minOccurs': '0', 'name': 'COFINS', 'type': 'COFINSType'}, None),
        MemberSpec_('COFINSST', 'COFINSSTType', 0, 1, {'minOccurs': '0', 'name': 'COFINSST', 'type': 'COFINSSTType'}, None),
        MemberSpec_('ICMSUFDest', 'ICMSUFDestType', 0, 1, {'minOccurs': '0', 'name': 'ICMSUFDest', 'type': 'ICMSUFDestType'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, vTotTrib=None, ICMS=None, II=None, IPI=None, ISSQN=None, PIS=None, PISST=None, COFINS=None, COFINSST=None, ICMSUFDest=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.vTotTrib = vTotTrib
        self.validate_TDec_1302(self.vTotTrib)
        self.vTotTrib_nsprefix_ = None
        self.ICMS = ICMS
        self.ICMS_nsprefix_ = None
        self.IPI = IPI
        self.IPI_nsprefix_ = None
        self.II = II
        self.II_nsprefix_ = None
        self.ISSQN = ISSQN
        self.ISSQN_nsprefix_ = None
        self.PIS = PIS
        self.PIS_nsprefix_ = None
        self.PISST = PISST
        self.PISST_nsprefix_ = None
        self.COFINS = COFINS
        self.COFINS_nsprefix_ = None
        self.COFINSST = COFINSST
        self.COFINSST_nsprefix_ = None
        self.ICMSUFDest = ICMSUFDest
        self.ICMSUFDest_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, impostoType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if impostoType.subclass:
            return impostoType.subclass(*args_, **kwargs_)
        else:
            return impostoType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def hasContent_(self):
        if (
            self.vTotTrib is not None or
            self.ICMS is not None or
            self.IPI is not None or
            self.II is not None or
            self.ISSQN is not None or
            self.PIS is not None or
            self.PISST is not None or
            self.COFINS is not None or
            self.COFINSST is not None or
            self.ICMSUFDest is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='impostoType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('impostoType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'impostoType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='impostoType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='impostoType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='impostoType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='impostoType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.vTotTrib is not None:
            namespaceprefix_ = self.vTotTrib_nsprefix_ + ':' if (UseCapturedNS_ and self.vTotTrib_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svTotTrib>%s</%svTotTrib>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vTotTrib), input_name='vTotTrib')), namespaceprefix_ , eol_))
        if self.ICMS is not None:
            namespaceprefix_ = self.ICMS_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMS_nsprefix_) else ''
            self.ICMS.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMS', pretty_print=pretty_print)
        if self.IPI is not None:
            namespaceprefix_ = self.IPI_nsprefix_ + ':' if (UseCapturedNS_ and self.IPI_nsprefix_) else ''
            self.IPI.export(outfile, level, namespaceprefix_, namespacedef_='', name_='IPI', pretty_print=pretty_print)
        if self.II is not None:
            namespaceprefix_ = self.II_nsprefix_ + ':' if (UseCapturedNS_ and self.II_nsprefix_) else ''
            self.II.export(outfile, level, namespaceprefix_, namespacedef_='', name_='II', pretty_print=pretty_print)
        if self.ISSQN is not None:
            namespaceprefix_ = self.ISSQN_nsprefix_ + ':' if (UseCapturedNS_ and self.ISSQN_nsprefix_) else ''
            self.ISSQN.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ISSQN', pretty_print=pretty_print)
        if self.PIS is not None:
            namespaceprefix_ = self.PIS_nsprefix_ + ':' if (UseCapturedNS_ and self.PIS_nsprefix_) else ''
            self.PIS.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PIS', pretty_print=pretty_print)
        if self.PISST is not None:
            namespaceprefix_ = self.PISST_nsprefix_ + ':' if (UseCapturedNS_ and self.PISST_nsprefix_) else ''
            self.PISST.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PISST', pretty_print=pretty_print)
        if self.COFINS is not None:
            namespaceprefix_ = self.COFINS_nsprefix_ + ':' if (UseCapturedNS_ and self.COFINS_nsprefix_) else ''
            self.COFINS.export(outfile, level, namespaceprefix_, namespacedef_='', name_='COFINS', pretty_print=pretty_print)
        if self.COFINSST is not None:
            namespaceprefix_ = self.COFINSST_nsprefix_ + ':' if (UseCapturedNS_ and self.COFINSST_nsprefix_) else ''
            self.COFINSST.export(outfile, level, namespaceprefix_, namespacedef_='', name_='COFINSST', pretty_print=pretty_print)
        if self.ICMSUFDest is not None:
            namespaceprefix_ = self.ICMSUFDest_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMSUFDest_nsprefix_) else ''
            self.ICMSUFDest.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMSUFDest', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'vTotTrib':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vTotTrib')
            value_ = self.gds_validate_string(value_, node, 'vTotTrib')
            self.vTotTrib = value_
            self.vTotTrib_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vTotTrib)
        elif nodeName_ == 'ICMS':
            obj_ = ICMSType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMS = obj_
            obj_.original_tagname_ = 'ICMS'
        elif nodeName_ == 'IPI':
            obj_ = TIpi.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.IPI = obj_
            obj_.original_tagname_ = 'IPI'
        elif nodeName_ == 'II':
            obj_ = IIType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.II = obj_
            obj_.original_tagname_ = 'II'
        elif nodeName_ == 'ISSQN':
            obj_ = ISSQNType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ISSQN = obj_
            obj_.original_tagname_ = 'ISSQN'
        elif nodeName_ == 'PIS':
            obj_ = PISType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PIS = obj_
            obj_.original_tagname_ = 'PIS'
        elif nodeName_ == 'PISST':
            obj_ = PISSTType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PISST = obj_
            obj_.original_tagname_ = 'PISST'
        elif nodeName_ == 'COFINS':
            obj_ = COFINSType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.COFINS = obj_
            obj_.original_tagname_ = 'COFINS'
        elif nodeName_ == 'COFINSST':
            obj_ = COFINSSTType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.COFINSST = obj_
            obj_.original_tagname_ = 'COFINSST'
        elif nodeName_ == 'ICMSUFDest':
            obj_ = ICMSUFDestType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMSUFDest = obj_
            obj_.original_tagname_ = 'ICMSUFDest'
# end class impostoType


class ICMSType(GeneratedsSuper):
    """Dados do ICMS Normal e ST"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('ICMS00', 'ICMS00Type', 0, 0, {'name': 'ICMS00', 'type': 'ICMS00Type'}, 11),
        MemberSpec_('ICMS10', 'ICMS10Type', 0, 0, {'name': 'ICMS10', 'type': 'ICMS10Type'}, 11),
        MemberSpec_('ICMS20', 'ICMS20Type', 0, 0, {'name': 'ICMS20', 'type': 'ICMS20Type'}, 11),
        MemberSpec_('ICMS30', 'ICMS30Type', 0, 0, {'name': 'ICMS30', 'type': 'ICMS30Type'}, 11),
        MemberSpec_('ICMS40', 'ICMS40Type', 0, 0, {'name': 'ICMS40', 'type': 'ICMS40Type'}, 11),
        MemberSpec_('ICMS51', 'ICMS51Type', 0, 0, {'name': 'ICMS51', 'type': 'ICMS51Type'}, 11),
        MemberSpec_('ICMS60', 'ICMS60Type', 0, 0, {'name': 'ICMS60', 'type': 'ICMS60Type'}, 11),
        MemberSpec_('ICMS70', 'ICMS70Type', 0, 0, {'name': 'ICMS70', 'type': 'ICMS70Type'}, 11),
        MemberSpec_('ICMS90', 'ICMS90Type', 0, 0, {'name': 'ICMS90', 'type': 'ICMS90Type'}, 11),
        MemberSpec_('ICMSPart', 'ICMSPartType', 0, 0, {'name': 'ICMSPart', 'type': 'ICMSPartType'}, 11),
        MemberSpec_('ICMSST', 'ICMSSTType', 0, 0, {'name': 'ICMSST', 'type': 'ICMSSTType'}, 11),
        MemberSpec_('ICMSSN101', 'ICMSSN101Type', 0, 0, {'name': 'ICMSSN101', 'type': 'ICMSSN101Type'}, 11),
        MemberSpec_('ICMSSN102', 'ICMSSN102Type', 0, 0, {'name': 'ICMSSN102', 'type': 'ICMSSN102Type'}, 11),
        MemberSpec_('ICMSSN201', 'ICMSSN201Type', 0, 0, {'name': 'ICMSSN201', 'type': 'ICMSSN201Type'}, 11),
        MemberSpec_('ICMSSN202', 'ICMSSN202Type', 0, 0, {'name': 'ICMSSN202', 'type': 'ICMSSN202Type'}, 11),
        MemberSpec_('ICMSSN500', 'ICMSSN500Type', 0, 0, {'name': 'ICMSSN500', 'type': 'ICMSSN500Type'}, 11),
        MemberSpec_('ICMSSN900', 'ICMSSN900Type', 0, 0, {'name': 'ICMSSN900', 'type': 'ICMSSN900Type'}, 11),
    ]
    subclass = None
    superclass = None
    def __init__(self, ICMS00=None, ICMS10=None, ICMS20=None, ICMS30=None, ICMS40=None, ICMS51=None, ICMS60=None, ICMS70=None, ICMS90=None, ICMSPart=None, ICMSST=None, ICMSSN101=None, ICMSSN102=None, ICMSSN201=None, ICMSSN202=None, ICMSSN500=None, ICMSSN900=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ICMS00 = ICMS00
        self.ICMS00_nsprefix_ = None
        self.ICMS10 = ICMS10
        self.ICMS10_nsprefix_ = None
        self.ICMS20 = ICMS20
        self.ICMS20_nsprefix_ = None
        self.ICMS30 = ICMS30
        self.ICMS30_nsprefix_ = None
        self.ICMS40 = ICMS40
        self.ICMS40_nsprefix_ = None
        self.ICMS51 = ICMS51
        self.ICMS51_nsprefix_ = None
        self.ICMS60 = ICMS60
        self.ICMS60_nsprefix_ = None
        self.ICMS70 = ICMS70
        self.ICMS70_nsprefix_ = None
        self.ICMS90 = ICMS90
        self.ICMS90_nsprefix_ = None
        self.ICMSPart = ICMSPart
        self.ICMSPart_nsprefix_ = None
        self.ICMSST = ICMSST
        self.ICMSST_nsprefix_ = None
        self.ICMSSN101 = ICMSSN101
        self.ICMSSN101_nsprefix_ = None
        self.ICMSSN102 = ICMSSN102
        self.ICMSSN102_nsprefix_ = None
        self.ICMSSN201 = ICMSSN201
        self.ICMSSN201_nsprefix_ = None
        self.ICMSSN202 = ICMSSN202
        self.ICMSSN202_nsprefix_ = None
        self.ICMSSN500 = ICMSSN500
        self.ICMSSN500_nsprefix_ = None
        self.ICMSSN900 = ICMSSN900
        self.ICMSSN900_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ICMSType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ICMSType.subclass:
            return ICMSType.subclass(*args_, **kwargs_)
        else:
            return ICMSType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.ICMS00 is not None or
            self.ICMS10 is not None or
            self.ICMS20 is not None or
            self.ICMS30 is not None or
            self.ICMS40 is not None or
            self.ICMS51 is not None or
            self.ICMS60 is not None or
            self.ICMS70 is not None or
            self.ICMS90 is not None or
            self.ICMSPart is not None or
            self.ICMSST is not None or
            self.ICMSSN101 is not None or
            self.ICMSSN102 is not None or
            self.ICMSSN201 is not None or
            self.ICMSSN202 is not None or
            self.ICMSSN500 is not None or
            self.ICMSSN900 is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMSType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ICMSType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ICMSType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ICMSType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ICMSType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ICMSType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMSType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ICMS00 is not None:
            namespaceprefix_ = self.ICMS00_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMS00_nsprefix_) else ''
            self.ICMS00.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMS00', pretty_print=pretty_print)
        if self.ICMS10 is not None:
            namespaceprefix_ = self.ICMS10_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMS10_nsprefix_) else ''
            self.ICMS10.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMS10', pretty_print=pretty_print)
        if self.ICMS20 is not None:
            namespaceprefix_ = self.ICMS20_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMS20_nsprefix_) else ''
            self.ICMS20.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMS20', pretty_print=pretty_print)
        if self.ICMS30 is not None:
            namespaceprefix_ = self.ICMS30_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMS30_nsprefix_) else ''
            self.ICMS30.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMS30', pretty_print=pretty_print)
        if self.ICMS40 is not None:
            namespaceprefix_ = self.ICMS40_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMS40_nsprefix_) else ''
            self.ICMS40.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMS40', pretty_print=pretty_print)
        if self.ICMS51 is not None:
            namespaceprefix_ = self.ICMS51_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMS51_nsprefix_) else ''
            self.ICMS51.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMS51', pretty_print=pretty_print)
        if self.ICMS60 is not None:
            namespaceprefix_ = self.ICMS60_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMS60_nsprefix_) else ''
            self.ICMS60.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMS60', pretty_print=pretty_print)
        if self.ICMS70 is not None:
            namespaceprefix_ = self.ICMS70_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMS70_nsprefix_) else ''
            self.ICMS70.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMS70', pretty_print=pretty_print)
        if self.ICMS90 is not None:
            namespaceprefix_ = self.ICMS90_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMS90_nsprefix_) else ''
            self.ICMS90.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMS90', pretty_print=pretty_print)
        if self.ICMSPart is not None:
            namespaceprefix_ = self.ICMSPart_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMSPart_nsprefix_) else ''
            self.ICMSPart.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMSPart', pretty_print=pretty_print)
        if self.ICMSST is not None:
            namespaceprefix_ = self.ICMSST_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMSST_nsprefix_) else ''
            self.ICMSST.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMSST', pretty_print=pretty_print)
        if self.ICMSSN101 is not None:
            namespaceprefix_ = self.ICMSSN101_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMSSN101_nsprefix_) else ''
            self.ICMSSN101.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMSSN101', pretty_print=pretty_print)
        if self.ICMSSN102 is not None:
            namespaceprefix_ = self.ICMSSN102_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMSSN102_nsprefix_) else ''
            self.ICMSSN102.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMSSN102', pretty_print=pretty_print)
        if self.ICMSSN201 is not None:
            namespaceprefix_ = self.ICMSSN201_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMSSN201_nsprefix_) else ''
            self.ICMSSN201.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMSSN201', pretty_print=pretty_print)
        if self.ICMSSN202 is not None:
            namespaceprefix_ = self.ICMSSN202_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMSSN202_nsprefix_) else ''
            self.ICMSSN202.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMSSN202', pretty_print=pretty_print)
        if self.ICMSSN500 is not None:
            namespaceprefix_ = self.ICMSSN500_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMSSN500_nsprefix_) else ''
            self.ICMSSN500.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMSSN500', pretty_print=pretty_print)
        if self.ICMSSN900 is not None:
            namespaceprefix_ = self.ICMSSN900_nsprefix_ + ':' if (UseCapturedNS_ and self.ICMSSN900_nsprefix_) else ''
            self.ICMSSN900.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ICMSSN900', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ICMS00':
            obj_ = ICMS00Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMS00 = obj_
            obj_.original_tagname_ = 'ICMS00'
        elif nodeName_ == 'ICMS10':
            obj_ = ICMS10Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMS10 = obj_
            obj_.original_tagname_ = 'ICMS10'
        elif nodeName_ == 'ICMS20':
            obj_ = ICMS20Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMS20 = obj_
            obj_.original_tagname_ = 'ICMS20'
        elif nodeName_ == 'ICMS30':
            obj_ = ICMS30Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMS30 = obj_
            obj_.original_tagname_ = 'ICMS30'
        elif nodeName_ == 'ICMS40':
            obj_ = ICMS40Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMS40 = obj_
            obj_.original_tagname_ = 'ICMS40'
        elif nodeName_ == 'ICMS51':
            obj_ = ICMS51Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMS51 = obj_
            obj_.original_tagname_ = 'ICMS51'
        elif nodeName_ == 'ICMS60':
            obj_ = ICMS60Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMS60 = obj_
            obj_.original_tagname_ = 'ICMS60'
        elif nodeName_ == 'ICMS70':
            obj_ = ICMS70Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMS70 = obj_
            obj_.original_tagname_ = 'ICMS70'
        elif nodeName_ == 'ICMS90':
            obj_ = ICMS90Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMS90 = obj_
            obj_.original_tagname_ = 'ICMS90'
        elif nodeName_ == 'ICMSPart':
            obj_ = ICMSPartType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMSPart = obj_
            obj_.original_tagname_ = 'ICMSPart'
        elif nodeName_ == 'ICMSST':
            obj_ = ICMSSTType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMSST = obj_
            obj_.original_tagname_ = 'ICMSST'
        elif nodeName_ == 'ICMSSN101':
            obj_ = ICMSSN101Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMSSN101 = obj_
            obj_.original_tagname_ = 'ICMSSN101'
        elif nodeName_ == 'ICMSSN102':
            obj_ = ICMSSN102Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMSSN102 = obj_
            obj_.original_tagname_ = 'ICMSSN102'
        elif nodeName_ == 'ICMSSN201':
            obj_ = ICMSSN201Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMSSN201 = obj_
            obj_.original_tagname_ = 'ICMSSN201'
        elif nodeName_ == 'ICMSSN202':
            obj_ = ICMSSN202Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMSSN202 = obj_
            obj_.original_tagname_ = 'ICMSSN202'
        elif nodeName_ == 'ICMSSN500':
            obj_ = ICMSSN500Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMSSN500 = obj_
            obj_.original_tagname_ = 'ICMSSN500'
        elif nodeName_ == 'ICMSSN900':
            obj_ = ICMSSN900Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ICMSSN900 = obj_
            obj_.original_tagname_ = 'ICMSSN900'
# end class ICMSType


class ICMS00Type(GeneratedsSuper):
    """Tributação pelo ICMS
    00 - Tributada integralmente"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('orig', ['Torig', 'xs:string'], 0, 0, {'name': 'orig', 'type': 'xs:string'}, None),
        MemberSpec_('CST', ['CSTType', 'xs:string'], 0, 0, {'name': 'CST', 'type': 'xs:string'}, None),
        MemberSpec_('modBC', ['modBCType', 'xs:string'], 0, 0, {'name': 'modBC', 'type': 'xs:string'}, None),
        MemberSpec_('vBC', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vBC', 'type': 'xs:string'}, None),
        MemberSpec_('pICMS', ['TDec_0302a04', 'xs:string'], 0, 0, {'name': 'pICMS', 'type': 'xs:string'}, None),
        MemberSpec_('vICMS', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vICMS', 'type': 'xs:string'}, None),
        MemberSpec_('pFCP', ['TDec_0302a04Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pFCP', 'type': 'xs:string'}, None),
        MemberSpec_('vFCP', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vFCP', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, orig=None, CST=None, modBC=None, vBC=None, pICMS=None, vICMS=None, pFCP=None, vFCP=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.orig = orig
        self.validate_Torig(self.orig)
        self.orig_nsprefix_ = None
        self.CST = CST
        self.validate_CSTType(self.CST)
        self.CST_nsprefix_ = None
        self.modBC = modBC
        self.validate_modBCType(self.modBC)
        self.modBC_nsprefix_ = None
        self.vBC = vBC
        self.validate_TDec_1302(self.vBC)
        self.vBC_nsprefix_ = None
        self.pICMS = pICMS
        self.validate_TDec_0302a04(self.pICMS)
        self.pICMS_nsprefix_ = None
        self.vICMS = vICMS
        self.validate_TDec_1302(self.vICMS)
        self.vICMS_nsprefix_ = None
        self.pFCP = pFCP
        self.validate_TDec_0302a04Opc(self.pFCP)
        self.pFCP_nsprefix_ = None
        self.vFCP = vFCP
        self.validate_TDec_1302(self.vFCP)
        self.vFCP_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ICMS00Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ICMS00Type.subclass:
            return ICMS00Type.subclass(*args_, **kwargs_)
        else:
            return ICMS00Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Torig(self, value):
        result = True
        # Validate type Torig, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5', '6', '7', '8']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on Torig' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CSTType(self, value):
        result = True
        # Validate type CSTType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['00']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on CSTType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_modBCType(self, value):
        result = True
        # Validate type modBCType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on modBCType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def validate_TDec_0302a04(self, value):
        result = True
        # Validate type TDec_0302a04, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0302a04_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0302a04_patterns_, ))
                result = False
        return result
    validate_TDec_0302a04_patterns_ = [['^(0|0\\.[0-9]{2,4}|[1-9]{1}[0-9]{0,2}(\\.[0-9]{2,4})?)$']]
    def validate_TDec_0302a04Opc(self, value):
        result = True
        # Validate type TDec_0302a04Opc, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0302a04Opc_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0302a04Opc_patterns_, ))
                result = False
        return result
    validate_TDec_0302a04Opc_patterns_ = [['^(0\\.[0-9]{2,4}|[1-9]{1}[0-9]{0,2}(\\.[0-9]{2,4})?)$']]
    def hasContent_(self):
        if (
            self.orig is not None or
            self.CST is not None or
            self.modBC is not None or
            self.vBC is not None or
            self.pICMS is not None or
            self.vICMS is not None or
            self.pFCP is not None or
            self.vFCP is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMS00Type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ICMS00Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ICMS00Type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ICMS00Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ICMS00Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ICMS00Type'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMS00Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.orig is not None:
            namespaceprefix_ = self.orig_nsprefix_ + ':' if (UseCapturedNS_ and self.orig_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorig>%s</%sorig>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.orig), input_name='orig')), namespaceprefix_ , eol_))
        if self.CST is not None:
            namespaceprefix_ = self.CST_nsprefix_ + ':' if (UseCapturedNS_ and self.CST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCST>%s</%sCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CST), input_name='CST')), namespaceprefix_ , eol_))
        if self.modBC is not None:
            namespaceprefix_ = self.modBC_nsprefix_ + ':' if (UseCapturedNS_ and self.modBC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smodBC>%s</%smodBC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.modBC), input_name='modBC')), namespaceprefix_ , eol_))
        if self.vBC is not None:
            namespaceprefix_ = self.vBC_nsprefix_ + ':' if (UseCapturedNS_ and self.vBC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svBC>%s</%svBC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vBC), input_name='vBC')), namespaceprefix_ , eol_))
        if self.pICMS is not None:
            namespaceprefix_ = self.pICMS_nsprefix_ + ':' if (UseCapturedNS_ and self.pICMS_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spICMS>%s</%spICMS>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pICMS), input_name='pICMS')), namespaceprefix_ , eol_))
        if self.vICMS is not None:
            namespaceprefix_ = self.vICMS_nsprefix_ + ':' if (UseCapturedNS_ and self.vICMS_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svICMS>%s</%svICMS>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vICMS), input_name='vICMS')), namespaceprefix_ , eol_))
        if self.pFCP is not None:
            namespaceprefix_ = self.pFCP_nsprefix_ + ':' if (UseCapturedNS_ and self.pFCP_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spFCP>%s</%spFCP>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pFCP), input_name='pFCP')), namespaceprefix_ , eol_))
        if self.vFCP is not None:
            namespaceprefix_ = self.vFCP_nsprefix_ + ':' if (UseCapturedNS_ and self.vFCP_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svFCP>%s</%svFCP>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vFCP), input_name='vFCP')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'orig':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'orig')
            value_ = self.gds_validate_string(value_, node, 'orig')
            self.orig = value_
            self.orig_nsprefix_ = child_.prefix
            # validate type Torig
            self.validate_Torig(self.orig)
        elif nodeName_ == 'CST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CST')
            value_ = self.gds_validate_string(value_, node, 'CST')
            self.CST = value_
            self.CST_nsprefix_ = child_.prefix
            # validate type CSTType
            self.validate_CSTType(self.CST)
        elif nodeName_ == 'modBC':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'modBC')
            value_ = self.gds_validate_string(value_, node, 'modBC')
            self.modBC = value_
            self.modBC_nsprefix_ = child_.prefix
            # validate type modBCType
            self.validate_modBCType(self.modBC)
        elif nodeName_ == 'vBC':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vBC')
            value_ = self.gds_validate_string(value_, node, 'vBC')
            self.vBC = value_
            self.vBC_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vBC)
        elif nodeName_ == 'pICMS':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pICMS')
            value_ = self.gds_validate_string(value_, node, 'pICMS')
            self.pICMS = value_
            self.pICMS_nsprefix_ = child_.prefix
            # validate type TDec_0302a04
            self.validate_TDec_0302a04(self.pICMS)
        elif nodeName_ == 'vICMS':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vICMS')
            value_ = self.gds_validate_string(value_, node, 'vICMS')
            self.vICMS = value_
            self.vICMS_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vICMS)
        elif nodeName_ == 'pFCP':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pFCP')
            value_ = self.gds_validate_string(value_, node, 'pFCP')
            self.pFCP = value_
            self.pFCP_nsprefix_ = child_.prefix
            # validate type TDec_0302a04Opc
            self.validate_TDec_0302a04Opc(self.pFCP)
        elif nodeName_ == 'vFCP':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vFCP')
            value_ = self.gds_validate_string(value_, node, 'vFCP')
            self.vFCP = value_
            self.vFCP_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vFCP)
# end class ICMS00Type


class ICMS10Type(GeneratedsSuper):
    """Tributação pelo ICMS
    10 - Tributada e com cobrança do ICMS por substituição tributária"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('orig', ['Torig', 'xs:string'], 0, 0, {'name': 'orig', 'type': 'xs:string'}, None),
        MemberSpec_('CST', ['CSTType8', 'xs:string'], 0, 0, {'name': 'CST', 'type': 'xs:string'}, None),
        MemberSpec_('modBC', ['modBCType9', 'xs:string'], 0, 0, {'name': 'modBC', 'type': 'xs:string'}, None),
        MemberSpec_('vBC', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vBC', 'type': 'xs:string'}, None),
        MemberSpec_('pICMS', ['TDec_0302a04', 'xs:string'], 0, 0, {'name': 'pICMS', 'type': 'xs:string'}, None),
        MemberSpec_('vICMS', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vICMS', 'type': 'xs:string'}, None),
        MemberSpec_('vBCFCP', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vBCFCP', 'type': 'xs:string'}, None),
        MemberSpec_('pFCP', ['TDec_0302a04Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pFCP', 'type': 'xs:string'}, None),
        MemberSpec_('vFCP', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vFCP', 'type': 'xs:string'}, None),
        MemberSpec_('modBCST', ['modBCSTType', 'xs:string'], 0, 0, {'name': 'modBCST', 'type': 'xs:string'}, None),
        MemberSpec_('pMVAST', ['TDec_0302a04Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pMVAST', 'type': 'xs:string'}, None),
        MemberSpec_('pRedBCST', ['TDec_0302a04Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pRedBCST', 'type': 'xs:string'}, None),
        MemberSpec_('vBCST', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vBCST', 'type': 'xs:string'}, None),
        MemberSpec_('pICMSST', ['TDec_0302a04', 'xs:string'], 0, 0, {'name': 'pICMSST', 'type': 'xs:string'}, None),
        MemberSpec_('vICMSST', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vICMSST', 'type': 'xs:string'}, None),
        MemberSpec_('vBCFCPST', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vBCFCPST', 'type': 'xs:string'}, None),
        MemberSpec_('pFCPST', ['TDec_0302a04Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pFCPST', 'type': 'xs:string'}, None),
        MemberSpec_('vFCPST', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vFCPST', 'type': 'xs:string'}, None),
        MemberSpec_('vICMSSTDeson', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vICMSSTDeson', 'type': 'xs:string'}, None),
        MemberSpec_('motDesICMSST', ['motDesICMSSTType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'motDesICMSST', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, orig=None, CST=None, modBC=None, vBC=None, pICMS=None, vICMS=None, vBCFCP=None, pFCP=None, vFCP=None, modBCST=None, pMVAST=None, pRedBCST=None, vBCST=None, pICMSST=None, vICMSST=None, vBCFCPST=None, pFCPST=None, vFCPST=None, vICMSSTDeson=None, motDesICMSST=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.orig = orig
        self.validate_Torig(self.orig)
        self.orig_nsprefix_ = None
        self.CST = CST
        self.validate_CSTType8(self.CST)
        self.CST_nsprefix_ = None
        self.modBC = modBC
        self.validate_modBCType9(self.modBC)
        self.modBC_nsprefix_ = None
        self.vBC = vBC
        self.validate_TDec_1302(self.vBC)
        self.vBC_nsprefix_ = None
        self.pICMS = pICMS
        self.validate_TDec_0302a04(self.pICMS)
        self.pICMS_nsprefix_ = None
        self.vICMS = vICMS
        self.validate_TDec_1302(self.vICMS)
        self.vICMS_nsprefix_ = None
        self.vBCFCP = vBCFCP
        self.validate_TDec_1302(self.vBCFCP)
        self.vBCFCP_nsprefix_ = None
        self.pFCP = pFCP
        self.validate_TDec_0302a04Opc(self.pFCP)
        self.pFCP_nsprefix_ = None
        self.vFCP = vFCP
        self.validate_TDec_1302(self.vFCP)
        self.vFCP_nsprefix_ = None
        self.modBCST = modBCST
        self.validate_modBCSTType(self.modBCST)
        self.modBCST_nsprefix_ = None
        self.pMVAST = pMVAST
        self.validate_TDec_0302a04Opc(self.pMVAST)
        self.pMVAST_nsprefix_ = None
        self.pRedBCST = pRedBCST
        self.validate_TDec_0302a04Opc(self.pRedBCST)
        self.pRedBCST_nsprefix_ = None
        self.vBCST = vBCST
        self.validate_TDec_1302(self.vBCST)
        self.vBCST_nsprefix_ = None
        self.pICMSST = pICMSST
        self.validate_TDec_0302a04(self.pICMSST)
        self.pICMSST_nsprefix_ = None
        self.vICMSST = vICMSST
        self.validate_TDec_1302(self.vICMSST)
        self.vICMSST_nsprefix_ = None
        self.vBCFCPST = vBCFCPST
        self.validate_TDec_1302(self.vBCFCPST)
        self.vBCFCPST_nsprefix_ = None
        self.pFCPST = pFCPST
        self.validate_TDec_0302a04Opc(self.pFCPST)
        self.pFCPST_nsprefix_ = None
        self.vFCPST = vFCPST
        self.validate_TDec_1302(self.vFCPST)
        self.vFCPST_nsprefix_ = None
        self.vICMSSTDeson = vICMSSTDeson
        self.validate_TDec_1302(self.vICMSSTDeson)
        self.vICMSSTDeson_nsprefix_ = None
        self.motDesICMSST = motDesICMSST
        self.validate_motDesICMSSTType(self.motDesICMSST)
        self.motDesICMSST_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ICMS10Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ICMS10Type.subclass:
            return ICMS10Type.subclass(*args_, **kwargs_)
        else:
            return ICMS10Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Torig(self, value):
        result = True
        # Validate type Torig, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5', '6', '7', '8']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on Torig' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CSTType8(self, value):
        result = True
        # Validate type CSTType8, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['10']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on CSTType8' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_modBCType9(self, value):
        result = True
        # Validate type modBCType9, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on modBCType9' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def validate_TDec_0302a04(self, value):
        result = True
        # Validate type TDec_0302a04, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0302a04_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0302a04_patterns_, ))
                result = False
        return result
    validate_TDec_0302a04_patterns_ = [['^(0|0\\.[0-9]{2,4}|[1-9]{1}[0-9]{0,2}(\\.[0-9]{2,4})?)$']]
    def validate_TDec_0302a04Opc(self, value):
        result = True
        # Validate type TDec_0302a04Opc, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0302a04Opc_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0302a04Opc_patterns_, ))
                result = False
        return result
    validate_TDec_0302a04Opc_patterns_ = [['^(0\\.[0-9]{2,4}|[1-9]{1}[0-9]{0,2}(\\.[0-9]{2,4})?)$']]
    def validate_modBCSTType(self, value):
        result = True
        # Validate type modBCSTType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5', '6']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on modBCSTType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_motDesICMSSTType(self, value):
        result = True
        # Validate type motDesICMSSTType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['3', '9', '12']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on motDesICMSSTType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def hasContent_(self):
        if (
            self.orig is not None or
            self.CST is not None or
            self.modBC is not None or
            self.vBC is not None or
            self.pICMS is not None or
            self.vICMS is not None or
            self.vBCFCP is not None or
            self.pFCP is not None or
            self.vFCP is not None or
            self.modBCST is not None or
            self.pMVAST is not None or
            self.pRedBCST is not None or
            self.vBCST is not None or
            self.pICMSST is not None or
            self.vICMSST is not None or
            self.vBCFCPST is not None or
            self.pFCPST is not None or
            self.vFCPST is not None or
            self.vICMSSTDeson is not None or
            self.motDesICMSST is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMS10Type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ICMS10Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ICMS10Type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ICMS10Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ICMS10Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ICMS10Type'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMS10Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.orig is not None:
            namespaceprefix_ = self.orig_nsprefix_ + ':' if (UseCapturedNS_ and self.orig_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorig>%s</%sorig>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.orig), input_name='orig')), namespaceprefix_ , eol_))
        if self.CST is not None:
            namespaceprefix_ = self.CST_nsprefix_ + ':' if (UseCapturedNS_ and self.CST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCST>%s</%sCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CST), input_name='CST')), namespaceprefix_ , eol_))
        if self.modBC is not None:
            namespaceprefix_ = self.modBC_nsprefix_ + ':' if (UseCapturedNS_ and self.modBC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smodBC>%s</%smodBC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.modBC), input_name='modBC')), namespaceprefix_ , eol_))
        if self.vBC is not None:
            namespaceprefix_ = self.vBC_nsprefix_ + ':' if (UseCapturedNS_ and self.vBC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svBC>%s</%svBC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vBC), input_name='vBC')), namespaceprefix_ , eol_))
        if self.pICMS is not None:
            namespaceprefix_ = self.pICMS_nsprefix_ + ':' if (UseCapturedNS_ and self.pICMS_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spICMS>%s</%spICMS>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pICMS), input_name='pICMS')), namespaceprefix_ , eol_))
        if self.vICMS is not None:
            namespaceprefix_ = self.vICMS_nsprefix_ + ':' if (UseCapturedNS_ and self.vICMS_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svICMS>%s</%svICMS>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vICMS), input_name='vICMS')), namespaceprefix_ , eol_))
        if self.vBCFCP is not None:
            namespaceprefix_ = self.vBCFCP_nsprefix_ + ':' if (UseCapturedNS_ and self.vBCFCP_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svBCFCP>%s</%svBCFCP>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vBCFCP), input_name='vBCFCP')), namespaceprefix_ , eol_))
        if self.pFCP is not None:
            namespaceprefix_ = self.pFCP_nsprefix_ + ':' if (UseCapturedNS_ and self.pFCP_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spFCP>%s</%spFCP>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pFCP), input_name='pFCP')), namespaceprefix_ , eol_))
        if self.vFCP is not None:
            namespaceprefix_ = self.vFCP_nsprefix_ + ':' if (UseCapturedNS_ and self.vFCP_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svFCP>%s</%svFCP>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vFCP), input_name='vFCP')), namespaceprefix_ , eol_))
        if self.modBCST is not None:
            namespaceprefix_ = self.modBCST_nsprefix_ + ':' if (UseCapturedNS_ and self.modBCST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smodBCST>%s</%smodBCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.modBCST), input_name='modBCST')), namespaceprefix_ , eol_))
        if self.pMVAST is not None:
            namespaceprefix_ = self.pMVAST_nsprefix_ + ':' if (UseCapturedNS_ and self.pMVAST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spMVAST>%s</%spMVAST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pMVAST), input_name='pMVAST')), namespaceprefix_ , eol_))
        if self.pRedBCST is not None:
            namespaceprefix_ = self.pRedBCST_nsprefix_ + ':' if (UseCapturedNS_ and self.pRedBCST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spRedBCST>%s</%spRedBCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pRedBCST), input_name='pRedBCST')), namespaceprefix_ , eol_))
        if self.vBCST is not None:
            namespaceprefix_ = self.vBCST_nsprefix_ + ':' if (UseCapturedNS_ and self.vBCST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svBCST>%s</%svBCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vBCST), input_name='vBCST')), namespaceprefix_ , eol_))
        if self.pICMSST is not None:
            namespaceprefix_ = self.pICMSST_nsprefix_ + ':' if (UseCapturedNS_ and self.pICMSST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spICMSST>%s</%spICMSST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pICMSST), input_name='pICMSST')), namespaceprefix_ , eol_))
        if self.vICMSST is not None:
            namespaceprefix_ = self.vICMSST_nsprefix_ + ':' if (UseCapturedNS_ and self.vICMSST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svICMSST>%s</%svICMSST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vICMSST), input_name='vICMSST')), namespaceprefix_ , eol_))
        if self.vBCFCPST is not None:
            namespaceprefix_ = self.vBCFCPST_nsprefix_ + ':' if (UseCapturedNS_ and self.vBCFCPST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svBCFCPST>%s</%svBCFCPST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vBCFCPST), input_name='vBCFCPST')), namespaceprefix_ , eol_))
        if self.pFCPST is not None:
            namespaceprefix_ = self.pFCPST_nsprefix_ + ':' if (UseCapturedNS_ and self.pFCPST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spFCPST>%s</%spFCPST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pFCPST), input_name='pFCPST')), namespaceprefix_ , eol_))
        if self.vFCPST is not None:
            namespaceprefix_ = self.vFCPST_nsprefix_ + ':' if (UseCapturedNS_ and self.vFCPST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svFCPST>%s</%svFCPST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vFCPST), input_name='vFCPST')), namespaceprefix_ , eol_))
        if self.vICMSSTDeson is not None:
            namespaceprefix_ = self.vICMSSTDeson_nsprefix_ + ':' if (UseCapturedNS_ and self.vICMSSTDeson_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svICMSSTDeson>%s</%svICMSSTDeson>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vICMSSTDeson), input_name='vICMSSTDeson')), namespaceprefix_ , eol_))
        if self.motDesICMSST is not None:
            namespaceprefix_ = self.motDesICMSST_nsprefix_ + ':' if (UseCapturedNS_ and self.motDesICMSST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smotDesICMSST>%s</%smotDesICMSST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.motDesICMSST), input_name='motDesICMSST')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'orig':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'orig')
            value_ = self.gds_validate_string(value_, node, 'orig')
            self.orig = value_
            self.orig_nsprefix_ = child_.prefix
            # validate type Torig
            self.validate_Torig(self.orig)
        elif nodeName_ == 'CST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CST')
            value_ = self.gds_validate_string(value_, node, 'CST')
            self.CST = value_
            self.CST_nsprefix_ = child_.prefix
            # validate type CSTType8
            self.validate_CSTType8(self.CST)
        elif nodeName_ == 'modBC':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'modBC')
            value_ = self.gds_validate_string(value_, node, 'modBC')
            self.modBC = value_
            self.modBC_nsprefix_ = child_.prefix
            # validate type modBCType9
            self.validate_modBCType9(self.modBC)
        elif nodeName_ == 'vBC':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vBC')
            value_ = self.gds_validate_string(value_, node, 'vBC')
            self.vBC = value_
            self.vBC_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vBC)
        elif nodeName_ == 'pICMS':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pICMS')
            value_ = self.gds_validate_string(value_, node, 'pICMS')
            self.pICMS = value_
            self.pICMS_nsprefix_ = child_.prefix
            # validate type TDec_0302a04
            self.validate_TDec_0302a04(self.pICMS)
        elif nodeName_ == 'vICMS':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vICMS')
            value_ = self.gds_validate_string(value_, node, 'vICMS')
            self.vICMS = value_
            self.vICMS_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vICMS)
        elif nodeName_ == 'vBCFCP':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vBCFCP')
            value_ = self.gds_validate_string(value_, node, 'vBCFCP')
            self.vBCFCP = value_
            self.vBCFCP_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vBCFCP)
        elif nodeName_ == 'pFCP':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pFCP')
            value_ = self.gds_validate_string(value_, node, 'pFCP')
            self.pFCP = value_
            self.pFCP_nsprefix_ = child_.prefix
            # validate type TDec_0302a04Opc
            self.validate_TDec_0302a04Opc(self.pFCP)
        elif nodeName_ == 'vFCP':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vFCP')
            value_ = self.gds_validate_string(value_, node, 'vFCP')
            self.vFCP = value_
            self.vFCP_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vFCP)
        elif nodeName_ == 'modBCST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'modBCST')
            value_ = self.gds_validate_string(value_, node, 'modBCST')
            self.modBCST = value_
            self.modBCST_nsprefix_ = child_.prefix
            # validate type modBCSTType
            self.validate_modBCSTType(self.modBCST)
        elif nodeName_ == 'pMVAST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pMVAST')
            value_ = self.gds_validate_string(value_, node, 'pMVAST')
            self.pMVAST = value_
            self.pMVAST_nsprefix_ = child_.prefix
            # validate type TDec_0302a04Opc
            self.validate_TDec_0302a04Opc(self.pMVAST)
        elif nodeName_ == 'pRedBCST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pRedBCST')
            value_ = self.gds_validate_string(value_, node, 'pRedBCST')
            self.pRedBCST = value_
            self.pRedBCST_nsprefix_ = child_.prefix
            # validate type TDec_0302a04Opc
            self.validate_TDec_0302a04Opc(self.pRedBCST)
        elif nodeName_ == 'vBCST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vBCST')
            value_ = self.gds_validate_string(value_, node, 'vBCST')
            self.vBCST = value_
            self.vBCST_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vBCST)
        elif nodeName_ == 'pICMSST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pICMSST')
            value_ = self.gds_validate_string(value_, node, 'pICMSST')
            self.pICMSST = value_
            self.pICMSST_nsprefix_ = child_.prefix
            # validate type TDec_0302a04
            self.validate_TDec_0302a04(self.pICMSST)
        elif nodeName_ == 'vICMSST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vICMSST')
            value_ = self.gds_validate_string(value_, node, 'vICMSST')
            self.vICMSST = value_
            self.vICMSST_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vICMSST)
        elif nodeName_ == 'vBCFCPST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vBCFCPST')
            value_ = self.gds_validate_string(value_, node, 'vBCFCPST')
            self.vBCFCPST = value_
            self.vBCFCPST_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vBCFCPST)
        elif nodeName_ == 'pFCPST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pFCPST')
            value_ = self.gds_validate_string(value_, node, 'pFCPST')
            self.pFCPST = value_
            self.pFCPST_nsprefix_ = child_.prefix
            # validate type TDec_0302a04Opc
            self.validate_TDec_0302a04Opc(self.pFCPST)
        elif nodeName_ == 'vFCPST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vFCPST')
            value_ = self.gds_validate_string(value_, node, 'vFCPST')
            self.vFCPST = value_
            self.vFCPST_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vFCPST)
        elif nodeName_ == 'vICMSSTDeson':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vICMSSTDeson')
            value_ = self.gds_validate_string(value_, node, 'vICMSSTDeson')
            self.vICMSSTDeson = value_
            self.vICMSSTDeson_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vICMSSTDeson)
        elif nodeName_ == 'motDesICMSST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'motDesICMSST')
            value_ = self.gds_validate_string(value_, node, 'motDesICMSST')
            self.motDesICMSST = value_
            self.motDesICMSST_nsprefix_ = child_.prefix
            # validate type motDesICMSSTType
            self.validate_motDesICMSSTType(self.motDesICMSST)
# end class ICMS10Type


class ICMS20Type(GeneratedsSuper):
    """Tributção pelo ICMS
    20 - Com redução de base de cálculoGrupo desoneração"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('orig', ['Torig', 'xs:string'], 0, 0, {'name': 'orig', 'type': 'xs:string'}, None),
        MemberSpec_('CST', ['CSTType10', 'xs:string'], 0, 0, {'name': 'CST', 'type': 'xs:string'}, None),
        MemberSpec_('modBC', ['modBCType11', 'xs:string'], 0, 0, {'name': 'modBC', 'type': 'xs:string'}, None),
        MemberSpec_('pRedBC', ['TDec_0302a04', 'xs:string'], 0, 0, {'name': 'pRedBC', 'type': 'xs:string'}, None),
        MemberSpec_('vBC', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vBC', 'type': 'xs:string'}, None),
        MemberSpec_('pICMS', ['TDec_0302a04', 'xs:string'], 0, 0, {'name': 'pICMS', 'type': 'xs:string'}, None),
        MemberSpec_('vICMS', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vICMS', 'type': 'xs:string'}, None),
        MemberSpec_('vBCFCP', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vBCFCP', 'type': 'xs:string'}, None),
        MemberSpec_('pFCP', ['TDec_0302a04Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pFCP', 'type': 'xs:string'}, None),
        MemberSpec_('vFCP', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vFCP', 'type': 'xs:string'}, None),
        MemberSpec_('vICMSDeson', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vICMSDeson', 'type': 'xs:string'}, None),
        MemberSpec_('motDesICMS', ['motDesICMSType', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'motDesICMS', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, orig=None, CST=None, modBC=None, pRedBC=None, vBC=None, pICMS=None, vICMS=None, vBCFCP=None, pFCP=None, vFCP=None, vICMSDeson=None, motDesICMS=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.orig = orig
        self.validate_Torig(self.orig)
        self.orig_nsprefix_ = None
        self.CST = CST
        self.validate_CSTType10(self.CST)
        self.CST_nsprefix_ = None
        self.modBC = modBC
        self.validate_modBCType11(self.modBC)
        self.modBC_nsprefix_ = None
        self.pRedBC = pRedBC
        self.validate_TDec_0302a04(self.pRedBC)
        self.pRedBC_nsprefix_ = None
        self.vBC = vBC
        self.validate_TDec_1302(self.vBC)
        self.vBC_nsprefix_ = None
        self.pICMS = pICMS
        self.validate_TDec_0302a04(self.pICMS)
        self.pICMS_nsprefix_ = None
        self.vICMS = vICMS
        self.validate_TDec_1302(self.vICMS)
        self.vICMS_nsprefix_ = None
        self.vBCFCP = vBCFCP
        self.validate_TDec_1302(self.vBCFCP)
        self.vBCFCP_nsprefix_ = None
        self.pFCP = pFCP
        self.validate_TDec_0302a04Opc(self.pFCP)
        self.pFCP_nsprefix_ = None
        self.vFCP = vFCP
        self.validate_TDec_1302(self.vFCP)
        self.vFCP_nsprefix_ = None
        self.vICMSDeson = vICMSDeson
        self.validate_TDec_1302(self.vICMSDeson)
        self.vICMSDeson_nsprefix_ = None
        self.motDesICMS = motDesICMS
        self.validate_motDesICMSType(self.motDesICMS)
        self.motDesICMS_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ICMS20Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ICMS20Type.subclass:
            return ICMS20Type.subclass(*args_, **kwargs_)
        else:
            return ICMS20Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Torig(self, value):
        result = True
        # Validate type Torig, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5', '6', '7', '8']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on Torig' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CSTType10(self, value):
        result = True
        # Validate type CSTType10, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['20']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on CSTType10' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_modBCType11(self, value):
        result = True
        # Validate type modBCType11, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on modBCType11' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TDec_0302a04(self, value):
        result = True
        # Validate type TDec_0302a04, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0302a04_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0302a04_patterns_, ))
                result = False
        return result
    validate_TDec_0302a04_patterns_ = [['^(0|0\\.[0-9]{2,4}|[1-9]{1}[0-9]{0,2}(\\.[0-9]{2,4})?)$']]
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def validate_TDec_0302a04Opc(self, value):
        result = True
        # Validate type TDec_0302a04Opc, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0302a04Opc_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0302a04Opc_patterns_, ))
                result = False
        return result
    validate_TDec_0302a04Opc_patterns_ = [['^(0\\.[0-9]{2,4}|[1-9]{1}[0-9]{0,2}(\\.[0-9]{2,4})?)$']]
    def validate_motDesICMSType(self, value):
        result = True
        # Validate type motDesICMSType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['3', '9', '12']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on motDesICMSType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def hasContent_(self):
        if (
            self.orig is not None or
            self.CST is not None or
            self.modBC is not None or
            self.pRedBC is not None or
            self.vBC is not None or
            self.pICMS is not None or
            self.vICMS is not None or
            self.vBCFCP is not None or
            self.pFCP is not None or
            self.vFCP is not None or
            self.vICMSDeson is not None or
            self.motDesICMS is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMS20Type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ICMS20Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ICMS20Type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ICMS20Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ICMS20Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ICMS20Type'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMS20Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.orig is not None:
            namespaceprefix_ = self.orig_nsprefix_ + ':' if (UseCapturedNS_ and self.orig_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorig>%s</%sorig>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.orig), input_name='orig')), namespaceprefix_ , eol_))
        if self.CST is not None:
            namespaceprefix_ = self.CST_nsprefix_ + ':' if (UseCapturedNS_ and self.CST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCST>%s</%sCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CST), input_name='CST')), namespaceprefix_ , eol_))
        if self.modBC is not None:
            namespaceprefix_ = self.modBC_nsprefix_ + ':' if (UseCapturedNS_ and self.modBC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smodBC>%s</%smodBC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.modBC), input_name='modBC')), namespaceprefix_ , eol_))
        if self.pRedBC is not None:
            namespaceprefix_ = self.pRedBC_nsprefix_ + ':' if (UseCapturedNS_ and self.pRedBC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spRedBC>%s</%spRedBC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pRedBC), input_name='pRedBC')), namespaceprefix_ , eol_))
        if self.vBC is not None:
            namespaceprefix_ = self.vBC_nsprefix_ + ':' if (UseCapturedNS_ and self.vBC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svBC>%s</%svBC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vBC), input_name='vBC')), namespaceprefix_ , eol_))
        if self.pICMS is not None:
            namespaceprefix_ = self.pICMS_nsprefix_ + ':' if (UseCapturedNS_ and self.pICMS_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spICMS>%s</%spICMS>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pICMS), input_name='pICMS')), namespaceprefix_ , eol_))
        if self.vICMS is not None:
            namespaceprefix_ = self.vICMS_nsprefix_ + ':' if (UseCapturedNS_ and self.vICMS_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svICMS>%s</%svICMS>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vICMS), input_name='vICMS')), namespaceprefix_ , eol_))
        if self.vBCFCP is not None:
            namespaceprefix_ = self.vBCFCP_nsprefix_ + ':' if (UseCapturedNS_ and self.vBCFCP_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svBCFCP>%s</%svBCFCP>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vBCFCP), input_name='vBCFCP')), namespaceprefix_ , eol_))
        if self.pFCP is not None:
            namespaceprefix_ = self.pFCP_nsprefix_ + ':' if (UseCapturedNS_ and self.pFCP_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spFCP>%s</%spFCP>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pFCP), input_name='pFCP')), namespaceprefix_ , eol_))
        if self.vFCP is not None:
            namespaceprefix_ = self.vFCP_nsprefix_ + ':' if (UseCapturedNS_ and self.vFCP_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svFCP>%s</%svFCP>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vFCP), input_name='vFCP')), namespaceprefix_ , eol_))
        if self.vICMSDeson is not None:
            namespaceprefix_ = self.vICMSDeson_nsprefix_ + ':' if (UseCapturedNS_ and self.vICMSDeson_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svICMSDeson>%s</%svICMSDeson>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vICMSDeson), input_name='vICMSDeson')), namespaceprefix_ , eol_))
        if self.motDesICMS is not None:
            namespaceprefix_ = self.motDesICMS_nsprefix_ + ':' if (UseCapturedNS_ and self.motDesICMS_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smotDesICMS>%s</%smotDesICMS>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.motDesICMS), input_name='motDesICMS')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'orig':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'orig')
            value_ = self.gds_validate_string(value_, node, 'orig')
            self.orig = value_
            self.orig_nsprefix_ = child_.prefix
            # validate type Torig
            self.validate_Torig(self.orig)
        elif nodeName_ == 'CST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CST')
            value_ = self.gds_validate_string(value_, node, 'CST')
            self.CST = value_
            self.CST_nsprefix_ = child_.prefix
            # validate type CSTType10
            self.validate_CSTType10(self.CST)
        elif nodeName_ == 'modBC':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'modBC')
            value_ = self.gds_validate_string(value_, node, 'modBC')
            self.modBC = value_
            self.modBC_nsprefix_ = child_.prefix
            # validate type modBCType11
            self.validate_modBCType11(self.modBC)
        elif nodeName_ == 'pRedBC':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pRedBC')
            value_ = self.gds_validate_string(value_, node, 'pRedBC')
            self.pRedBC = value_
            self.pRedBC_nsprefix_ = child_.prefix
            # validate type TDec_0302a04
            self.validate_TDec_0302a04(self.pRedBC)
        elif nodeName_ == 'vBC':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vBC')
            value_ = self.gds_validate_string(value_, node, 'vBC')
            self.vBC = value_
            self.vBC_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vBC)
        elif nodeName_ == 'pICMS':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pICMS')
            value_ = self.gds_validate_string(value_, node, 'pICMS')
            self.pICMS = value_
            self.pICMS_nsprefix_ = child_.prefix
            # validate type TDec_0302a04
            self.validate_TDec_0302a04(self.pICMS)
        elif nodeName_ == 'vICMS':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vICMS')
            value_ = self.gds_validate_string(value_, node, 'vICMS')
            self.vICMS = value_
            self.vICMS_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vICMS)
        elif nodeName_ == 'vBCFCP':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vBCFCP')
            value_ = self.gds_validate_string(value_, node, 'vBCFCP')
            self.vBCFCP = value_
            self.vBCFCP_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vBCFCP)
        elif nodeName_ == 'pFCP':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pFCP')
            value_ = self.gds_validate_string(value_, node, 'pFCP')
            self.pFCP = value_
            self.pFCP_nsprefix_ = child_.prefix
            # validate type TDec_0302a04Opc
            self.validate_TDec_0302a04Opc(self.pFCP)
        elif nodeName_ == 'vFCP':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vFCP')
            value_ = self.gds_validate_string(value_, node, 'vFCP')
            self.vFCP = value_
            self.vFCP_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vFCP)
        elif nodeName_ == 'vICMSDeson':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vICMSDeson')
            value_ = self.gds_validate_string(value_, node, 'vICMSDeson')
            self.vICMSDeson = value_
            self.vICMSDeson_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vICMSDeson)
        elif nodeName_ == 'motDesICMS':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'motDesICMS')
            value_ = self.gds_validate_string(value_, node, 'motDesICMS')
            self.motDesICMS = value_
            self.motDesICMS_nsprefix_ = child_.prefix
            # validate type motDesICMSType
            self.validate_motDesICMSType(self.motDesICMS)
# end class ICMS20Type


class ICMS30Type(GeneratedsSuper):
    """Tributação pelo ICMS
    30 - Isenta ou não tributada e com cobrança do ICMS por substituição
    tributáriaGrupo desoneração"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('orig', ['Torig', 'xs:string'], 0, 0, {'name': 'orig', 'type': 'xs:string'}, None),
        MemberSpec_('CST', ['CSTType12', 'xs:string'], 0, 0, {'name': 'CST', 'type': 'xs:string'}, None),
        MemberSpec_('modBCST', ['modBCSTType13', 'xs:string'], 0, 0, {'name': 'modBCST', 'type': 'xs:string'}, None),
        MemberSpec_('pMVAST', ['TDec_0302a04Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pMVAST', 'type': 'xs:string'}, None),
        MemberSpec_('pRedBCST', ['TDec_0302a04Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pRedBCST', 'type': 'xs:string'}, None),
        MemberSpec_('vBCST', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vBCST', 'type': 'xs:string'}, None),
        MemberSpec_('pICMSST', ['TDec_0302a04', 'xs:string'], 0, 0, {'name': 'pICMSST', 'type': 'xs:string'}, None),
        MemberSpec_('vICMSST', ['TDec_1302', 'xs:string'], 0, 0, {'name': 'vICMSST', 'type': 'xs:string'}, None),
        MemberSpec_('vBCFCPST', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vBCFCPST', 'type': 'xs:string'}, None),
        MemberSpec_('pFCPST', ['TDec_0302a04Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pFCPST', 'type': 'xs:string'}, None),
        MemberSpec_('vFCPST', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vFCPST', 'type': 'xs:string'}, None),
        MemberSpec_('vICMSDeson', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vICMSDeson', 'type': 'xs:string'}, None),
        MemberSpec_('motDesICMS', ['motDesICMSType14', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'motDesICMS', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, orig=None, CST=None, modBCST=None, pMVAST=None, pRedBCST=None, vBCST=None, pICMSST=None, vICMSST=None, vBCFCPST=None, pFCPST=None, vFCPST=None, vICMSDeson=None, motDesICMS=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.orig = orig
        self.validate_Torig(self.orig)
        self.orig_nsprefix_ = None
        self.CST = CST
        self.validate_CSTType12(self.CST)
        self.CST_nsprefix_ = None
        self.modBCST = modBCST
        self.validate_modBCSTType13(self.modBCST)
        self.modBCST_nsprefix_ = None
        self.pMVAST = pMVAST
        self.validate_TDec_0302a04Opc(self.pMVAST)
        self.pMVAST_nsprefix_ = None
        self.pRedBCST = pRedBCST
        self.validate_TDec_0302a04Opc(self.pRedBCST)
        self.pRedBCST_nsprefix_ = None
        self.vBCST = vBCST
        self.validate_TDec_1302(self.vBCST)
        self.vBCST_nsprefix_ = None
        self.pICMSST = pICMSST
        self.validate_TDec_0302a04(self.pICMSST)
        self.pICMSST_nsprefix_ = None
        self.vICMSST = vICMSST
        self.validate_TDec_1302(self.vICMSST)
        self.vICMSST_nsprefix_ = None
        self.vBCFCPST = vBCFCPST
        self.validate_TDec_1302(self.vBCFCPST)
        self.vBCFCPST_nsprefix_ = None
        self.pFCPST = pFCPST
        self.validate_TDec_0302a04Opc(self.pFCPST)
        self.pFCPST_nsprefix_ = None
        self.vFCPST = vFCPST
        self.validate_TDec_1302(self.vFCPST)
        self.vFCPST_nsprefix_ = None
        self.vICMSDeson = vICMSDeson
        self.validate_TDec_1302(self.vICMSDeson)
        self.vICMSDeson_nsprefix_ = None
        self.motDesICMS = motDesICMS
        self.validate_motDesICMSType14(self.motDesICMS)
        self.motDesICMS_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ICMS30Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ICMS30Type.subclass:
            return ICMS30Type.subclass(*args_, **kwargs_)
        else:
            return ICMS30Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Torig(self, value):
        result = True
        # Validate type Torig, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5', '6', '7', '8']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on Torig' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CSTType12(self, value):
        result = True
        # Validate type CSTType12, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['30']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on CSTType12' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_modBCSTType13(self, value):
        result = True
        # Validate type modBCSTType13, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5', '6']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on modBCSTType13' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TDec_0302a04Opc(self, value):
        result = True
        # Validate type TDec_0302a04Opc, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0302a04Opc_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0302a04Opc_patterns_, ))
                result = False
        return result
    validate_TDec_0302a04Opc_patterns_ = [['^(0\\.[0-9]{2,4}|[1-9]{1}[0-9]{0,2}(\\.[0-9]{2,4})?)$']]
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def validate_TDec_0302a04(self, value):
        result = True
        # Validate type TDec_0302a04, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0302a04_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0302a04_patterns_, ))
                result = False
        return result
    validate_TDec_0302a04_patterns_ = [['^(0|0\\.[0-9]{2,4}|[1-9]{1}[0-9]{0,2}(\\.[0-9]{2,4})?)$']]
    def validate_motDesICMSType14(self, value):
        result = True
        # Validate type motDesICMSType14, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['6', '7', '9']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on motDesICMSType14' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def hasContent_(self):
        if (
            self.orig is not None or
            self.CST is not None or
            self.modBCST is not None or
            self.pMVAST is not None or
            self.pRedBCST is not None or
            self.vBCST is not None or
            self.pICMSST is not None or
            self.vICMSST is not None or
            self.vBCFCPST is not None or
            self.pFCPST is not None or
            self.vFCPST is not None or
            self.vICMSDeson is not None or
            self.motDesICMS is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMS30Type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ICMS30Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ICMS30Type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ICMS30Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ICMS30Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ICMS30Type'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMS30Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.orig is not None:
            namespaceprefix_ = self.orig_nsprefix_ + ':' if (UseCapturedNS_ and self.orig_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorig>%s</%sorig>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.orig), input_name='orig')), namespaceprefix_ , eol_))
        if self.CST is not None:
            namespaceprefix_ = self.CST_nsprefix_ + ':' if (UseCapturedNS_ and self.CST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCST>%s</%sCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CST), input_name='CST')), namespaceprefix_ , eol_))
        if self.modBCST is not None:
            namespaceprefix_ = self.modBCST_nsprefix_ + ':' if (UseCapturedNS_ and self.modBCST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smodBCST>%s</%smodBCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.modBCST), input_name='modBCST')), namespaceprefix_ , eol_))
        if self.pMVAST is not None:
            namespaceprefix_ = self.pMVAST_nsprefix_ + ':' if (UseCapturedNS_ and self.pMVAST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spMVAST>%s</%spMVAST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pMVAST), input_name='pMVAST')), namespaceprefix_ , eol_))
        if self.pRedBCST is not None:
            namespaceprefix_ = self.pRedBCST_nsprefix_ + ':' if (UseCapturedNS_ and self.pRedBCST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spRedBCST>%s</%spRedBCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pRedBCST), input_name='pRedBCST')), namespaceprefix_ , eol_))
        if self.vBCST is not None:
            namespaceprefix_ = self.vBCST_nsprefix_ + ':' if (UseCapturedNS_ and self.vBCST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svBCST>%s</%svBCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vBCST), input_name='vBCST')), namespaceprefix_ , eol_))
        if self.pICMSST is not None:
            namespaceprefix_ = self.pICMSST_nsprefix_ + ':' if (UseCapturedNS_ and self.pICMSST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spICMSST>%s</%spICMSST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pICMSST), input_name='pICMSST')), namespaceprefix_ , eol_))
        if self.vICMSST is not None:
            namespaceprefix_ = self.vICMSST_nsprefix_ + ':' if (UseCapturedNS_ and self.vICMSST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svICMSST>%s</%svICMSST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vICMSST), input_name='vICMSST')), namespaceprefix_ , eol_))
        if self.vBCFCPST is not None:
            namespaceprefix_ = self.vBCFCPST_nsprefix_ + ':' if (UseCapturedNS_ and self.vBCFCPST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svBCFCPST>%s</%svBCFCPST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vBCFCPST), input_name='vBCFCPST')), namespaceprefix_ , eol_))
        if self.pFCPST is not None:
            namespaceprefix_ = self.pFCPST_nsprefix_ + ':' if (UseCapturedNS_ and self.pFCPST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spFCPST>%s</%spFCPST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pFCPST), input_name='pFCPST')), namespaceprefix_ , eol_))
        if self.vFCPST is not None:
            namespaceprefix_ = self.vFCPST_nsprefix_ + ':' if (UseCapturedNS_ and self.vFCPST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svFCPST>%s</%svFCPST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vFCPST), input_name='vFCPST')), namespaceprefix_ , eol_))
        if self.vICMSDeson is not None:
            namespaceprefix_ = self.vICMSDeson_nsprefix_ + ':' if (UseCapturedNS_ and self.vICMSDeson_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svICMSDeson>%s</%svICMSDeson>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vICMSDeson), input_name='vICMSDeson')), namespaceprefix_ , eol_))
        if self.motDesICMS is not None:
            namespaceprefix_ = self.motDesICMS_nsprefix_ + ':' if (UseCapturedNS_ and self.motDesICMS_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smotDesICMS>%s</%smotDesICMS>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.motDesICMS), input_name='motDesICMS')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'orig':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'orig')
            value_ = self.gds_validate_string(value_, node, 'orig')
            self.orig = value_
            self.orig_nsprefix_ = child_.prefix
            # validate type Torig
            self.validate_Torig(self.orig)
        elif nodeName_ == 'CST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CST')
            value_ = self.gds_validate_string(value_, node, 'CST')
            self.CST = value_
            self.CST_nsprefix_ = child_.prefix
            # validate type CSTType12
            self.validate_CSTType12(self.CST)
        elif nodeName_ == 'modBCST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'modBCST')
            value_ = self.gds_validate_string(value_, node, 'modBCST')
            self.modBCST = value_
            self.modBCST_nsprefix_ = child_.prefix
            # validate type modBCSTType13
            self.validate_modBCSTType13(self.modBCST)
        elif nodeName_ == 'pMVAST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pMVAST')
            value_ = self.gds_validate_string(value_, node, 'pMVAST')
            self.pMVAST = value_
            self.pMVAST_nsprefix_ = child_.prefix
            # validate type TDec_0302a04Opc
            self.validate_TDec_0302a04Opc(self.pMVAST)
        elif nodeName_ == 'pRedBCST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pRedBCST')
            value_ = self.gds_validate_string(value_, node, 'pRedBCST')
            self.pRedBCST = value_
            self.pRedBCST_nsprefix_ = child_.prefix
            # validate type TDec_0302a04Opc
            self.validate_TDec_0302a04Opc(self.pRedBCST)
        elif nodeName_ == 'vBCST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vBCST')
            value_ = self.gds_validate_string(value_, node, 'vBCST')
            self.vBCST = value_
            self.vBCST_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vBCST)
        elif nodeName_ == 'pICMSST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pICMSST')
            value_ = self.gds_validate_string(value_, node, 'pICMSST')
            self.pICMSST = value_
            self.pICMSST_nsprefix_ = child_.prefix
            # validate type TDec_0302a04
            self.validate_TDec_0302a04(self.pICMSST)
        elif nodeName_ == 'vICMSST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vICMSST')
            value_ = self.gds_validate_string(value_, node, 'vICMSST')
            self.vICMSST = value_
            self.vICMSST_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vICMSST)
        elif nodeName_ == 'vBCFCPST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vBCFCPST')
            value_ = self.gds_validate_string(value_, node, 'vBCFCPST')
            self.vBCFCPST = value_
            self.vBCFCPST_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vBCFCPST)
        elif nodeName_ == 'pFCPST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pFCPST')
            value_ = self.gds_validate_string(value_, node, 'pFCPST')
            self.pFCPST = value_
            self.pFCPST_nsprefix_ = child_.prefix
            # validate type TDec_0302a04Opc
            self.validate_TDec_0302a04Opc(self.pFCPST)
        elif nodeName_ == 'vFCPST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vFCPST')
            value_ = self.gds_validate_string(value_, node, 'vFCPST')
            self.vFCPST = value_
            self.vFCPST_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vFCPST)
        elif nodeName_ == 'vICMSDeson':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vICMSDeson')
            value_ = self.gds_validate_string(value_, node, 'vICMSDeson')
            self.vICMSDeson = value_
            self.vICMSDeson_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vICMSDeson)
        elif nodeName_ == 'motDesICMS':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'motDesICMS')
            value_ = self.gds_validate_string(value_, node, 'motDesICMS')
            self.motDesICMS = value_
            self.motDesICMS_nsprefix_ = child_.prefix
            # validate type motDesICMSType14
            self.validate_motDesICMSType14(self.motDesICMS)
# end class ICMS30Type


class ICMS40Type(GeneratedsSuper):
    """Tributação pelo ICMS
    40 - Isenta
    41 - Não tributada
    50 - Suspensão"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('orig', ['Torig', 'xs:string'], 0, 0, {'name': 'orig', 'type': 'xs:string'}, None),
        MemberSpec_('CST', ['CSTType15', 'xs:string'], 0, 0, {'name': 'CST', 'type': 'xs:string'}, None),
        MemberSpec_('vICMSDeson', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vICMSDeson', 'type': 'xs:string'}, None),
        MemberSpec_('motDesICMS', ['motDesICMSType16', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'motDesICMS', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, orig=None, CST=None, vICMSDeson=None, motDesICMS=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.orig = orig
        self.validate_Torig(self.orig)
        self.orig_nsprefix_ = None
        self.CST = CST
        self.validate_CSTType15(self.CST)
        self.CST_nsprefix_ = None
        self.vICMSDeson = vICMSDeson
        self.validate_TDec_1302(self.vICMSDeson)
        self.vICMSDeson_nsprefix_ = None
        self.motDesICMS = motDesICMS
        self.validate_motDesICMSType16(self.motDesICMS)
        self.motDesICMS_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ICMS40Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ICMS40Type.subclass:
            return ICMS40Type.subclass(*args_, **kwargs_)
        else:
            return ICMS40Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Torig(self, value):
        result = True
        # Validate type Torig, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5', '6', '7', '8']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on Torig' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CSTType15(self, value):
        result = True
        # Validate type CSTType15, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['40', '41', '50']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on CSTType15' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def validate_motDesICMSType16(self, value):
        result = True
        # Validate type motDesICMSType16, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['1', '3', '4', '5', '6', '7', '8', '9', '10', '11', '16', '90']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on motDesICMSType16' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def hasContent_(self):
        if (
            self.orig is not None or
            self.CST is not None or
            self.vICMSDeson is not None or
            self.motDesICMS is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMS40Type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ICMS40Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ICMS40Type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ICMS40Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ICMS40Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ICMS40Type'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMS40Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.orig is not None:
            namespaceprefix_ = self.orig_nsprefix_ + ':' if (UseCapturedNS_ and self.orig_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorig>%s</%sorig>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.orig), input_name='orig')), namespaceprefix_ , eol_))
        if self.CST is not None:
            namespaceprefix_ = self.CST_nsprefix_ + ':' if (UseCapturedNS_ and self.CST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCST>%s</%sCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CST), input_name='CST')), namespaceprefix_ , eol_))
        if self.vICMSDeson is not None:
            namespaceprefix_ = self.vICMSDeson_nsprefix_ + ':' if (UseCapturedNS_ and self.vICMSDeson_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svICMSDeson>%s</%svICMSDeson>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vICMSDeson), input_name='vICMSDeson')), namespaceprefix_ , eol_))
        if self.motDesICMS is not None:
            namespaceprefix_ = self.motDesICMS_nsprefix_ + ':' if (UseCapturedNS_ and self.motDesICMS_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smotDesICMS>%s</%smotDesICMS>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.motDesICMS), input_name='motDesICMS')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'orig':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'orig')
            value_ = self.gds_validate_string(value_, node, 'orig')
            self.orig = value_
            self.orig_nsprefix_ = child_.prefix
            # validate type Torig
            self.validate_Torig(self.orig)
        elif nodeName_ == 'CST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CST')
            value_ = self.gds_validate_string(value_, node, 'CST')
            self.CST = value_
            self.CST_nsprefix_ = child_.prefix
            # validate type CSTType15
            self.validate_CSTType15(self.CST)
        elif nodeName_ == 'vICMSDeson':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vICMSDeson')
            value_ = self.gds_validate_string(value_, node, 'vICMSDeson')
            self.vICMSDeson = value_
            self.vICMSDeson_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vICMSDeson)
        elif nodeName_ == 'motDesICMS':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'motDesICMS')
            value_ = self.gds_validate_string(value_, node, 'motDesICMS')
            self.motDesICMS = value_
            self.motDesICMS_nsprefix_ = child_.prefix
            # validate type motDesICMSType16
            self.validate_motDesICMSType16(self.motDesICMS)
# end class ICMS40Type


class ICMS51Type(GeneratedsSuper):
    """Tributção pelo ICMS
    51 - Diferimento
    A exigência do preenchimento das informações do ICMS diferido fica à
    critério de cada UF."""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('orig', ['Torig', 'xs:string'], 0, 0, {'name': 'orig', 'type': 'xs:string'}, None),
        MemberSpec_('CST', ['CSTType17', 'xs:string'], 0, 0, {'name': 'CST', 'type': 'xs:string'}, None),
        MemberSpec_('modBC', ['modBCType18', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'modBC', 'type': 'xs:string'}, None),
        MemberSpec_('pRedBC', ['TDec_0302a04', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pRedBC', 'type': 'xs:string'}, None),
        MemberSpec_('vBC', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vBC', 'type': 'xs:string'}, None),
        MemberSpec_('pICMS', ['TDec_0302a04', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pICMS', 'type': 'xs:string'}, None),
        MemberSpec_('vICMSOp', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vICMSOp', 'type': 'xs:string'}, None),
        MemberSpec_('pDif', ['TDec_0302a04Max100', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pDif', 'type': 'xs:string'}, None),
        MemberSpec_('vICMSDif', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vICMSDif', 'type': 'xs:string'}, None),
        MemberSpec_('vICMS', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vICMS', 'type': 'xs:string'}, None),
        MemberSpec_('vBCFCP', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vBCFCP', 'type': 'xs:string'}, None),
        MemberSpec_('pFCP', ['TDec_0302a04Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pFCP', 'type': 'xs:string'}, None),
        MemberSpec_('vFCP', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vFCP', 'type': 'xs:string'}, None),
        MemberSpec_('pFCPDif', ['TDec_0302a04Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pFCPDif', 'type': 'xs:string'}, None),
        MemberSpec_('vFCPDif', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vFCPDif', 'type': 'xs:string'}, None),
        MemberSpec_('vFCPEfet', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vFCPEfet', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, orig=None, CST=None, modBC=None, pRedBC=None, vBC=None, pICMS=None, vICMSOp=None, pDif=None, vICMSDif=None, vICMS=None, vBCFCP=None, pFCP=None, vFCP=None, pFCPDif=None, vFCPDif=None, vFCPEfet=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.orig = orig
        self.validate_Torig(self.orig)
        self.orig_nsprefix_ = None
        self.CST = CST
        self.validate_CSTType17(self.CST)
        self.CST_nsprefix_ = None
        self.modBC = modBC
        self.validate_modBCType18(self.modBC)
        self.modBC_nsprefix_ = None
        self.pRedBC = pRedBC
        self.validate_TDec_0302a04(self.pRedBC)
        self.pRedBC_nsprefix_ = None
        self.vBC = vBC
        self.validate_TDec_1302(self.vBC)
        self.vBC_nsprefix_ = None
        self.pICMS = pICMS
        self.validate_TDec_0302a04(self.pICMS)
        self.pICMS_nsprefix_ = None
        self.vICMSOp = vICMSOp
        self.validate_TDec_1302(self.vICMSOp)
        self.vICMSOp_nsprefix_ = None
        self.pDif = pDif
        self.validate_TDec_0302a04Max100(self.pDif)
        self.pDif_nsprefix_ = None
        self.vICMSDif = vICMSDif
        self.validate_TDec_1302(self.vICMSDif)
        self.vICMSDif_nsprefix_ = None
        self.vICMS = vICMS
        self.validate_TDec_1302(self.vICMS)
        self.vICMS_nsprefix_ = None
        self.vBCFCP = vBCFCP
        self.validate_TDec_1302(self.vBCFCP)
        self.vBCFCP_nsprefix_ = None
        self.pFCP = pFCP
        self.validate_TDec_0302a04Opc(self.pFCP)
        self.pFCP_nsprefix_ = None
        self.vFCP = vFCP
        self.validate_TDec_1302(self.vFCP)
        self.vFCP_nsprefix_ = None
        self.pFCPDif = pFCPDif
        self.validate_TDec_0302a04Opc(self.pFCPDif)
        self.pFCPDif_nsprefix_ = None
        self.vFCPDif = vFCPDif
        self.validate_TDec_1302(self.vFCPDif)
        self.vFCPDif_nsprefix_ = None
        self.vFCPEfet = vFCPEfet
        self.validate_TDec_1302(self.vFCPEfet)
        self.vFCPEfet_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ICMS51Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ICMS51Type.subclass:
            return ICMS51Type.subclass(*args_, **kwargs_)
        else:
            return ICMS51Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Torig(self, value):
        result = True
        # Validate type Torig, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5', '6', '7', '8']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on Torig' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CSTType17(self, value):
        result = True
        # Validate type CSTType17, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['51']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on CSTType17' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_modBCType18(self, value):
        result = True
        # Validate type modBCType18, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on modBCType18' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TDec_0302a04(self, value):
        result = True
        # Validate type TDec_0302a04, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0302a04_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0302a04_patterns_, ))
                result = False
        return result
    validate_TDec_0302a04_patterns_ = [['^(0|0\\.[0-9]{2,4}|[1-9]{1}[0-9]{0,2}(\\.[0-9]{2,4})?)$']]
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def validate_TDec_0302a04Max100(self, value):
        result = True
        # Validate type TDec_0302a04Max100, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0302a04Max100_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0302a04Max100_patterns_, ))
                result = False
        return result
    validate_TDec_0302a04Max100_patterns_ = [['^(0(\\.[0-9]{2,4})?|[1-9]{1}[0-9]{0,1}(\\.[0-9]{2,4})?|100(\\.0{2,4})?)$']]
    def validate_TDec_0302a04Opc(self, value):
        result = True
        # Validate type TDec_0302a04Opc, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_0302a04Opc_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_0302a04Opc_patterns_, ))
                result = False
        return result
    validate_TDec_0302a04Opc_patterns_ = [['^(0\\.[0-9]{2,4}|[1-9]{1}[0-9]{0,2}(\\.[0-9]{2,4})?)$']]
    def hasContent_(self):
        if (
            self.orig is not None or
            self.CST is not None or
            self.modBC is not None or
            self.pRedBC is not None or
            self.vBC is not None or
            self.pICMS is not None or
            self.vICMSOp is not None or
            self.pDif is not None or
            self.vICMSDif is not None or
            self.vICMS is not None or
            self.vBCFCP is not None or
            self.pFCP is not None or
            self.vFCP is not None or
            self.pFCPDif is not None or
            self.vFCPDif is not None or
            self.vFCPEfet is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMS51Type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ICMS51Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ICMS51Type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ICMS51Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ICMS51Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ICMS51Type'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ICMS51Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.orig is not None:
            namespaceprefix_ = self.orig_nsprefix_ + ':' if (UseCapturedNS_ and self.orig_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorig>%s</%sorig>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.orig), input_name='orig')), namespaceprefix_ , eol_))
        if self.CST is not None:
            namespaceprefix_ = self.CST_nsprefix_ + ':' if (UseCapturedNS_ and self.CST_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCST>%s</%sCST>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CST), input_name='CST')), namespaceprefix_ , eol_))
        if self.modBC is not None:
            namespaceprefix_ = self.modBC_nsprefix_ + ':' if (UseCapturedNS_ and self.modBC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smodBC>%s</%smodBC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.modBC), input_name='modBC')), namespaceprefix_ , eol_))
        if self.pRedBC is not None:
            namespaceprefix_ = self.pRedBC_nsprefix_ + ':' if (UseCapturedNS_ and self.pRedBC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spRedBC>%s</%spRedBC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pRedBC), input_name='pRedBC')), namespaceprefix_ , eol_))
        if self.vBC is not None:
            namespaceprefix_ = self.vBC_nsprefix_ + ':' if (UseCapturedNS_ and self.vBC_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svBC>%s</%svBC>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vBC), input_name='vBC')), namespaceprefix_ , eol_))
        if self.pICMS is not None:
            namespaceprefix_ = self.pICMS_nsprefix_ + ':' if (UseCapturedNS_ and self.pICMS_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spICMS>%s</%spICMS>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pICMS), input_name='pICMS')), namespaceprefix_ , eol_))
        if self.vICMSOp is not None:
            namespaceprefix_ = self.vICMSOp_nsprefix_ + ':' if (UseCapturedNS_ and self.vICMSOp_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svICMSOp>%s</%svICMSOp>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vICMSOp), input_name='vICMSOp')), namespaceprefix_ , eol_))
        if self.pDif is not None:
            namespaceprefix_ = self.pDif_nsprefix_ + ':' if (UseCapturedNS_ and self.pDif_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spDif>%s</%spDif>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pDif), input_name='pDif')), namespaceprefix_ , eol_))
        if self.vICMSDif is not None:
            namespaceprefix_ = self.vICMSDif_nsprefix_ + ':' if (UseCapturedNS_ and self.vICMSDif_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svICMSDif>%s</%svICMSDif>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vICMSDif), input_name='vICMSDif')), namespaceprefix_ , eol_))
        if self.vICMS is not None:
            namespaceprefix_ = self.vICMS_nsprefix_ + ':' if (UseCapturedNS_ and self.vICMS_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svICMS>%s</%svICMS>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vICMS), input_name='vICMS')), namespaceprefix_ , eol_))
        if self.vBCFCP is not None:
            namespaceprefix_ = self.vBCFCP_nsprefix_ + ':' if (UseCapturedNS_ and self.vBCFCP_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svBCFCP>%s</%svBCFCP>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vBCFCP), input_name='vBCFCP')), namespaceprefix_ , eol_))
        if self.pFCP is not None:
            namespaceprefix_ = self.pFCP_nsprefix_ + ':' if (UseCapturedNS_ and self.pFCP_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spFCP>%s</%spFCP>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pFCP), input_name='pFCP')), namespaceprefix_ , eol_))
        if self.vFCP is not None:
            namespaceprefix_ = self.vFCP_nsprefix_ + ':' if (UseCapturedNS_ and self.vFCP_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svFCP>%s</%svFCP>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vFCP), input_name='vFCP')), namespaceprefix_ , eol_))
        if self.pFCPDif is not None:
            namespaceprefix_ = self.pFCPDif_nsprefix_ + ':' if (UseCapturedNS_ and self.pFCPDif_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spFCPDif>%s</%spFCPDif>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pFCPDif), input_name='pFCPDif')), namespaceprefix_ , eol_))
        if self.vFCPDif is not None:
            namespaceprefix_ = self.vFCPDif_nsprefix_ + ':' if (UseCapturedNS_ and self.vFCPDif_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svFCPDif>%s</%svFCPDif>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vFCPDif), input_name='vFCPDif')), namespaceprefix_ , eol_))
        if self.vFCPEfet is not None:
            namespaceprefix_ = self.vFCPEfet_nsprefix_ + ':' if (UseCapturedNS_ and self.vFCPEfet_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svFCPEfet>%s</%svFCPEfet>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.vFCPEfet), input_name='vFCPEfet')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'orig':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'orig')
            value_ = self.gds_validate_string(value_, node, 'orig')
            self.orig = value_
            self.orig_nsprefix_ = child_.prefix
            # validate type Torig
            self.validate_Torig(self.orig)
        elif nodeName_ == 'CST':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CST')
            value_ = self.gds_validate_string(value_, node, 'CST')
            self.CST = value_
            self.CST_nsprefix_ = child_.prefix
            # validate type CSTType17
            self.validate_CSTType17(self.CST)
        elif nodeName_ == 'modBC':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'modBC')
            value_ = self.gds_validate_string(value_, node, 'modBC')
            self.modBC = value_
            self.modBC_nsprefix_ = child_.prefix
            # validate type modBCType18
            self.validate_modBCType18(self.modBC)
        elif nodeName_ == 'pRedBC':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pRedBC')
            value_ = self.gds_validate_string(value_, node, 'pRedBC')
            self.pRedBC = value_
            self.pRedBC_nsprefix_ = child_.prefix
            # validate type TDec_0302a04
            self.validate_TDec_0302a04(self.pRedBC)
        elif nodeName_ == 'vBC':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vBC')
            value_ = self.gds_validate_string(value_, node, 'vBC')
            self.vBC = value_
            self.vBC_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vBC)
        elif nodeName_ == 'pICMS':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pICMS')
            value_ = self.gds_validate_string(value_, node, 'pICMS')
            self.pICMS = value_
            self.pICMS_nsprefix_ = child_.prefix
            # validate type TDec_0302a04
            self.validate_TDec_0302a04(self.pICMS)
        elif nodeName_ == 'vICMSOp':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vICMSOp')
            value_ = self.gds_validate_string(value_, node, 'vICMSOp')
            self.vICMSOp = value_
            self.vICMSOp_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vICMSOp)
        elif nodeName_ == 'pDif':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pDif')
            value_ = self.gds_validate_string(value_, node, 'pDif')
            self.pDif = value_
            self.pDif_nsprefix_ = child_.prefix
            # validate type TDec_0302a04Max100
            self.validate_TDec_0302a04Max100(self.pDif)
        elif nodeName_ == 'vICMSDif':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vICMSDif')
            value_ = self.gds_validate_string(value_, node, 'vICMSDif')
            self.vICMSDif = value_
            self.vICMSDif_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vICMSDif)
        elif nodeName_ == 'vICMS':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vICMS')
            value_ = self.gds_validate_string(value_, node, 'vICMS')
            self.vICMS = value_
            self.vICMS_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vICMS)
        elif nodeName_ == 'vBCFCP':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vBCFCP')
            value_ = self.gds_validate_string(value_, node, 'vBCFCP')
            self.vBCFCP = value_
            self.vBCFCP_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vBCFCP)
        elif nodeName_ == 'pFCP':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pFCP')
            value_ = self.gds_validate_string(value_, node, 'pFCP')
            self.pFCP = value_
            self.pFCP_nsprefix_ = child_.prefix
            # validate type TDec_0302a04Opc
            self.validate_TDec_0302a04Opc(self.pFCP)
        elif nodeName_ == 'vFCP':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vFCP')
            value_ = self.gds_validate_string(value_, node, 'vFCP')
            self.vFCP = value_
            self.vFCP_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vFCP)
        elif nodeName_ == 'pFCPDif':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'pFCPDif')
            value_ = self.gds_validate_string(value_, node, 'pFCPDif')
            self.pFCPDif = value_
            self.pFCPDif_nsprefix_ = child_.prefix
            # validate type TDec_0302a04Opc
            self.validate_TDec_0302a04Opc(self.pFCPDif)
        elif nodeName_ == 'vFCPDif':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vFCPDif')
            value_ = self.gds_validate_string(value_, node, 'vFCPDif')
            self.vFCPDif = value_
            self.vFCPDif_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vFCPDif)
        elif nodeName_ == 'vFCPEfet':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'vFCPEfet')
            value_ = self.gds_validate_string(value_, node, 'vFCPEfet')
            self.vFCPEfet = value_
            self.vFCPEfet_nsprefix_ = child_.prefix
            # validate type TDec_1302
            self.validate_TDec_1302(self.vFCPEfet)
# end class ICMS51Type


class ICMS60Type(GeneratedsSuper):
    """Tributação pelo ICMS
    60 - ICMS cobrado anteriormente por substituição tributáriaNT2010/004"""
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_('orig', ['Torig', 'xs:string'], 0, 0, {'name': 'orig', 'type': 'xs:string'}, None),
        MemberSpec_('CST', ['CSTType19', 'xs:string'], 0, 0, {'name': 'CST', 'type': 'xs:string'}, None),
        MemberSpec_('vBCSTRet', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vBCSTRet', 'type': 'xs:string'}, None),
        MemberSpec_('pST', ['TDec_0302a04Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pST', 'type': 'xs:string'}, None),
        MemberSpec_('vICMSSubstituto', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vICMSSubstituto', 'type': 'xs:string'}, None),
        MemberSpec_('vICMSSTRet', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vICMSSTRet', 'type': 'xs:string'}, None),
        MemberSpec_('vBCFCPSTRet', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vBCFCPSTRet', 'type': 'xs:string'}, None),
        MemberSpec_('pFCPSTRet', ['TDec_0302a04Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pFCPSTRet', 'type': 'xs:string'}, None),
        MemberSpec_('vFCPSTRet', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vFCPSTRet', 'type': 'xs:string'}, None),
        MemberSpec_('pRedBCEfet', ['TDec_0302a04Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pRedBCEfet', 'type': 'xs:string'}, None),
        MemberSpec_('vBCEfet', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vBCEfet', 'type': 'xs:string'}, None),
        MemberSpec_('pICMSEfet', ['TDec_0302a04Opc', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'pICMSEfet', 'type': 'xs:string'}, None),
        MemberSpec_('vICMSEfet', ['TDec_1302', 'xs:string'], 0, 1, {'minOccurs': '0', 'name': 'vICMSEfet', 'type': 'xs:string'}, None),
    ]
    subclass = None
    superclass = None
    def __init__(self, orig=None, CST=None, vBCSTRet=None, pST=None, vICMSSubstituto=None, vICMSSTRet=None, vBCFCPSTRet=None, pFCPSTRet=None, vFCPSTRet=None, pRedBCEfet=None, vBCEfet=None, pICMSEfet=None, vICMSEfet=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.orig = orig
        self.validate_Torig(self.orig)
        self.orig_nsprefix_ = None
        self.CST = CST
        self.validate_CSTType19(self.CST)
        self.CST_nsprefix_ = None
        self.vBCSTRet = vBCSTRet
        self.validate_TDec_1302(self.vBCSTRet)
        self.vBCSTRet_nsprefix_ = None
        self.pST = pST
        self.validate_TDec_0302a04Opc(self.pST)
        self.pST_nsprefix_ = None
        self.vICMSSubstituto = vICMSSubstituto
        self.validate_TDec_1302(self.vICMSSubstituto)
        self.vICMSSubstituto_nsprefix_ = None
        self.vICMSSTRet = vICMSSTRet
        self.validate_TDec_1302(self.vICMSSTRet)
        self.vICMSSTRet_nsprefix_ = None
        self.vBCFCPSTRet = vBCFCPSTRet
        self.validate_TDec_1302(self.vBCFCPSTRet)
        self.vBCFCPSTRet_nsprefix_ = None
        self.pFCPSTRet = pFCPSTRet
        self.validate_TDec_0302a04Opc(self.pFCPSTRet)
        self.pFCPSTRet_nsprefix_ = None
        self.vFCPSTRet = vFCPSTRet
        self.validate_TDec_1302(self.vFCPSTRet)
        self.vFCPSTRet_nsprefix_ = None
        self.pRedBCEfet = pRedBCEfet
        self.validate_TDec_0302a04Opc(self.pRedBCEfet)
        self.pRedBCEfet_nsprefix_ = None
        self.vBCEfet = vBCEfet
        self.validate_TDec_1302(self.vBCEfet)
        self.vBCEfet_nsprefix_ = None
        self.pICMSEfet = pICMSEfet
        self.validate_TDec_0302a04Opc(self.pICMSEfet)
        self.pICMSEfet_nsprefix_ = None
        self.vICMSEfet = vICMSEfet
        self.validate_TDec_1302(self.vICMSEfet)
        self.vICMSEfet_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ICMS60Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ICMS60Type.subclass:
            return ICMS60Type.subclass(*args_, **kwargs_)
        else:
            return ICMS60Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Torig(self, value):
        result = True
        # Validate type Torig, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5', '6', '7', '8']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on Torig' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CSTType19(self, value):
        result = True
        # Validate type CSTType19, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['60']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on CSTType19' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TDec_1302(self, value):
        result = True
        # Validate type TDec_1302, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_TDec_1302_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TDec_1302_patterns_, ))
                result = False
        return result
    validate_TDec_1302_patterns_ = [['^(0|0\\.[0-9]{2}|[1-9]{1}[0-9]{0,12}(\\.[0-9]{2})?)$']]
    def validate_TDec_0302a04Opc(self, value):
        result = True
        # Validate type TDec_0302a04Opc, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_sim