from typing import Any, AnyStr, Callable

class Operators(object):
    def op(self, opstring: AnyStr, precedence: int, is_comparison: bool): ...
    def operate(self, op: Callable[[Any], Any], *other, **kwargs): ...
    def reverse_operator(self, op: Callable[[Any], Any], *other, **kwargs): ...
    def __and__(self, other): ...
    def __or__(self, other): ...
    def __invert__(self): ...


class ColumnOperators(Operators):
    def concat(self, other): ...
    def like(self, other, escape=None): ...
    def ilike(self, other, escape=None): ...
    def notlike(self, other, escape=None): ...
    def notilike(self, other, escape=None): ...
    def in_(self, other): ...
    def notin_(self, other): ...
    def is_(self, other): ...
    def startswith(self, other, **kwargs): ...
    def endswith(self, other, **kwargs): ...
    def contains(self, other, **kwargs): ...
    def match(self, other, **kwargs): ...
    def desc(self): ...
    def asc(self): ...
    def nullsfirst(self): ...
    def nullslast(self): ...
    def collate(self, collation): ...
    def between(self, cleft, cright, symmetric: bool = ...): ...
    def distinct(self): ...

    def __lt__(self, other): ...
    def __le__(self, other): ...
    def __eq__(self, other): ...
    def __ne__(self, other): ...
    def __gt__(self, other): ...
    def __ge__(self, other): ...
    def __neg__(self, other): ...
    def __getitem__(self, index): ...
    def __lshift__(self, other): ...
    def __rshift__(self, other): ...

    def __radd__(self, other): ...
    def __rsub__(self, other): ...
    def __rmul__(self, other): ...
    def __rdiv__(self, other): ...
    def __rmod__(self, other): ...
    def __add__(self, other): ...
    def __sub__(self, other): ...
    def __mul__(self, other): ...
    def __div__(self, other): ...
    def __mod__(self, other): ...
    def __truediv__(self, other): ...
    def __rtruediv__(self, other): ...

def from_(): ...
def as_(): ...
def exists(): ...
def istrue(a): ...
def isfalse(a): ...
def is_(a, b): ...
def isnot(a, b): ...
def collate(a, b): ...
def op(a, opstring, b): ...

def like_op(a, b, escape=None): ...
def notlike_op(a, b, escape=None): ...
def ilike_op(a, b, escape=None): ...
def notilike_op(a, b, escape=None): ...
def between_op(a, b, symmetric: bool): ...
def notbetween_(a, b, symmetric: bool): ...

def in_op(a, b): ...
def notin_op(a, b): ...
def distinct_op(a): ...

def startswith_op(a, b, escape=None): ...
def notstartswith_op(a, b, escape=None): ...
def endswith_op(a, b, escape=None): ...
def notendswith_op(a, b, escape=None): ...
def contains_op(a, b, escape=None): ...
def notcontains_op(a, b, escape=None): ...

def match_op(a, b, **kw): ...
def notmatch_op(a, b, **kw): ...

def comma_op(a, b): ...
def concat_op(a, b): ...

def desc_op(a): ...
def asc_op(a): ...
def nullsfirst_op(a): ...
def nullslast_op(a): ...

def is_comparison(op): ...
def is_commutative(op): ...
def is_ordering_modified(op): ...
def is_precedent(operator, against): ...
