"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
TODO: Consider consolidating common components in another package
and language namespaces for re-use with Runner Api.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import google.protobuf.timestamp_pb2
import org.apache.beam.model.pipeline.v1.beam_runner_api_pb2
import org.apache.beam.model.pipeline.v1.endpoints_pb2
import org.apache.beam.model.pipeline.v1.metrics_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class RemoteGrpcPort(google.protobuf.message.Message):
    """A descriptor for connecting to a remote port using the Beam Fn Data API.
    Allows for communication between two environments (for example between the
    runner and the SDK).
    Stable
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    API_SERVICE_DESCRIPTOR_FIELD_NUMBER: builtins.int
    CODER_ID_FIELD_NUMBER: builtins.int
    @property
    def api_service_descriptor(self) -> org.apache.beam.model.pipeline.v1.endpoints_pb2.ApiServiceDescriptor:
        """(Required) An API descriptor which describes where to
        connect to including any authentication that is required.
        """
    coder_id: builtins.str
    """(Required) The ID of the Coder that will be used to encode and decode data
    sent over this port.
    """
    def __init__(
        self,
        *,
        api_service_descriptor: org.apache.beam.model.pipeline.v1.endpoints_pb2.ApiServiceDescriptor | None = ...,
        coder_id: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["api_service_descriptor", b"api_service_descriptor"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["api_service_descriptor", b"api_service_descriptor", "coder_id", b"coder_id"]) -> None: ...

global___RemoteGrpcPort = RemoteGrpcPort

@typing_extensions.final
class GetProcessBundleDescriptorRequest(google.protobuf.message.Message):
    """Requests the ProcessBundleDescriptor with the given id."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROCESS_BUNDLE_DESCRIPTOR_ID_FIELD_NUMBER: builtins.int
    process_bundle_descriptor_id: builtins.str
    def __init__(
        self,
        *,
        process_bundle_descriptor_id: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["process_bundle_descriptor_id", b"process_bundle_descriptor_id"]) -> None: ...

global___GetProcessBundleDescriptorRequest = GetProcessBundleDescriptorRequest

@typing_extensions.final
class InstructionRequest(google.protobuf.message.Message):
    """A request sent by a runner which the SDK is asked to fulfill.
    For any unsupported request type, an error should be returned with a
    matching instruction id.
    Stable
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUCTION_ID_FIELD_NUMBER: builtins.int
    PROCESS_BUNDLE_FIELD_NUMBER: builtins.int
    PROCESS_BUNDLE_PROGRESS_FIELD_NUMBER: builtins.int
    PROCESS_BUNDLE_SPLIT_FIELD_NUMBER: builtins.int
    FINALIZE_BUNDLE_FIELD_NUMBER: builtins.int
    MONITORING_INFOS_FIELD_NUMBER: builtins.int
    HARNESS_MONITORING_INFOS_FIELD_NUMBER: builtins.int
    SAMPLE_DATA_FIELD_NUMBER: builtins.int
    REGISTER_FIELD_NUMBER: builtins.int
    instruction_id: builtins.str
    """(Required) A unique identifier provided by the runner which represents
    this requests execution. The InstructionResponse MUST have the matching id.
    """
    @property
    def process_bundle(self) -> global___ProcessBundleRequest: ...
    @property
    def process_bundle_progress(self) -> global___ProcessBundleProgressRequest: ...
    @property
    def process_bundle_split(self) -> global___ProcessBundleSplitRequest: ...
    @property
    def finalize_bundle(self) -> global___FinalizeBundleRequest: ...
    @property
    def monitoring_infos(self) -> global___MonitoringInfosMetadataRequest: ...
    @property
    def harness_monitoring_infos(self) -> global___HarnessMonitoringInfosRequest: ...
    @property
    def sample_data(self) -> global___SampleDataRequest: ...
    @property
    def register(self) -> global___RegisterRequest:
        """DEPRECATED"""
    def __init__(
        self,
        *,
        instruction_id: builtins.str | None = ...,
        process_bundle: global___ProcessBundleRequest | None = ...,
        process_bundle_progress: global___ProcessBundleProgressRequest | None = ...,
        process_bundle_split: global___ProcessBundleSplitRequest | None = ...,
        finalize_bundle: global___FinalizeBundleRequest | None = ...,
        monitoring_infos: global___MonitoringInfosMetadataRequest | None = ...,
        harness_monitoring_infos: global___HarnessMonitoringInfosRequest | None = ...,
        sample_data: global___SampleDataRequest | None = ...,
        register: global___RegisterRequest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["finalize_bundle", b"finalize_bundle", "harness_monitoring_infos", b"harness_monitoring_infos", "monitoring_infos", b"monitoring_infos", "process_bundle", b"process_bundle", "process_bundle_progress", b"process_bundle_progress", "process_bundle_split", b"process_bundle_split", "register", b"register", "request", b"request", "sample_data", b"sample_data"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["finalize_bundle", b"finalize_bundle", "harness_monitoring_infos", b"harness_monitoring_infos", "instruction_id", b"instruction_id", "monitoring_infos", b"monitoring_infos", "process_bundle", b"process_bundle", "process_bundle_progress", b"process_bundle_progress", "process_bundle_split", b"process_bundle_split", "register", b"register", "request", b"request", "sample_data", b"sample_data"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["request", b"request"]) -> typing_extensions.Literal["process_bundle", "process_bundle_progress", "process_bundle_split", "finalize_bundle", "monitoring_infos", "harness_monitoring_infos", "sample_data", "register"] | None: ...

global___InstructionRequest = InstructionRequest

@typing_extensions.final
class InstructionResponse(google.protobuf.message.Message):
    """The response for an associated request the SDK had been asked to fulfill.
    Stable
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUCTION_ID_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    PROCESS_BUNDLE_FIELD_NUMBER: builtins.int
    PROCESS_BUNDLE_PROGRESS_FIELD_NUMBER: builtins.int
    PROCESS_BUNDLE_SPLIT_FIELD_NUMBER: builtins.int
    FINALIZE_BUNDLE_FIELD_NUMBER: builtins.int
    MONITORING_INFOS_FIELD_NUMBER: builtins.int
    HARNESS_MONITORING_INFOS_FIELD_NUMBER: builtins.int
    SAMPLE_DATA_FIELD_NUMBER: builtins.int
    REGISTER_FIELD_NUMBER: builtins.int
    instruction_id: builtins.str
    """(Required) A reference provided by the runner which represents a requests
    execution. The InstructionResponse MUST have the matching id when
    responding to the runner.
    """
    error: builtins.str
    """If this is specified, then this instruction has failed.
    A human readable string representing the reason as to why processing has
    failed.
    """
    @property
    def process_bundle(self) -> global___ProcessBundleResponse: ...
    @property
    def process_bundle_progress(self) -> global___ProcessBundleProgressResponse: ...
    @property
    def process_bundle_split(self) -> global___ProcessBundleSplitResponse: ...
    @property
    def finalize_bundle(self) -> global___FinalizeBundleResponse: ...
    @property
    def monitoring_infos(self) -> global___MonitoringInfosMetadataResponse: ...
    @property
    def harness_monitoring_infos(self) -> global___HarnessMonitoringInfosResponse: ...
    @property
    def sample_data(self) -> global___SampleDataResponse: ...
    @property
    def register(self) -> global___RegisterResponse:
        """DEPRECATED"""
    def __init__(
        self,
        *,
        instruction_id: builtins.str | None = ...,
        error: builtins.str | None = ...,
        process_bundle: global___ProcessBundleResponse | None = ...,
        process_bundle_progress: global___ProcessBundleProgressResponse | None = ...,
        process_bundle_split: global___ProcessBundleSplitResponse | None = ...,
        finalize_bundle: global___FinalizeBundleResponse | None = ...,
        monitoring_infos: global___MonitoringInfosMetadataResponse | None = ...,
        harness_monitoring_infos: global___HarnessMonitoringInfosResponse | None = ...,
        sample_data: global___SampleDataResponse | None = ...,
        register: global___RegisterResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["finalize_bundle", b"finalize_bundle", "harness_monitoring_infos", b"harness_monitoring_infos", "monitoring_infos", b"monitoring_infos", "process_bundle", b"process_bundle", "process_bundle_progress", b"process_bundle_progress", "process_bundle_split", b"process_bundle_split", "register", b"register", "response", b"response", "sample_data", b"sample_data"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["error", b"error", "finalize_bundle", b"finalize_bundle", "harness_monitoring_infos", b"harness_monitoring_infos", "instruction_id", b"instruction_id", "monitoring_infos", b"monitoring_infos", "process_bundle", b"process_bundle", "process_bundle_progress", b"process_bundle_progress", "process_bundle_split", b"process_bundle_split", "register", b"register", "response", b"response", "sample_data", b"sample_data"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["response", b"response"]) -> typing_extensions.Literal["process_bundle", "process_bundle_progress", "process_bundle_split", "finalize_bundle", "monitoring_infos", "harness_monitoring_infos", "sample_data", "register"] | None: ...

global___InstructionResponse = InstructionResponse

@typing_extensions.final
class SampleDataRequest(google.protobuf.message.Message):
    """If supported, the `SampleDataRequest` will respond with a
    `SampleDataResponse`. The SDK being queried must have the
    "beam:protocol:data_sampling:v1" capability. Samples are taken only from the
    specified PCollection ids. An empty list will return everything.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PCOLLECTION_IDS_FIELD_NUMBER: builtins.int
    @property
    def pcollection_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """(Optional) The PCollection ids to filter for."""
    def __init__(
        self,
        *,
        pcollection_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["pcollection_ids", b"pcollection_ids"]) -> None: ...

global___SampleDataRequest = SampleDataRequest

@typing_extensions.final
class SampledElement(google.protobuf.message.Message):
    """An element sampled when the SDK is processing a bundle. This is a proto
    message to allow for additional per-element metadata.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ELEMENT_FIELD_NUMBER: builtins.int
    element: builtins.bytes
    """Required. Sampled raw bytes for an element. This is a
    single encoded element in the nested context.
    """
    def __init__(
        self,
        *,
        element: builtins.bytes | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["element", b"element"]) -> None: ...

global___SampledElement = SampledElement

@typing_extensions.final
class SampleDataResponse(google.protobuf.message.Message):
    """If supported, the `SampleDataResponse` will contain samples from PCollections
    based upon the filters specified in the request.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class ElementList(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ELEMENTS_FIELD_NUMBER: builtins.int
        @property
        def elements(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SampledElement]:
            """Required. The individual elements sampled from a PCollection."""
        def __init__(
            self,
            *,
            elements: collections.abc.Iterable[global___SampledElement] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["elements", b"elements"]) -> None: ...

    @typing_extensions.final
    class ElementSamplesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___SampleDataResponse.ElementList: ...
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: global___SampleDataResponse.ElementList | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    ELEMENT_SAMPLES_FIELD_NUMBER: builtins.int
    @property
    def element_samples(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___SampleDataResponse.ElementList]:
        """Map from PCollection id to sampled elements."""
    def __init__(
        self,
        *,
        element_samples: collections.abc.Mapping[builtins.str, global___SampleDataResponse.ElementList] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["element_samples", b"element_samples"]) -> None: ...

global___SampleDataResponse = SampleDataResponse

@typing_extensions.final
class HarnessMonitoringInfosRequest(google.protobuf.message.Message):
    """A request to provide full MonitoringInfo associated with the entire SDK
    harness process, not specific to a bundle.

    An SDK can report metrics using an identifier that only contains the
    associated payload. A runner who wants to receive the full metrics
    information can request all the monitoring metadata via a
    MonitoringInfosMetadataRequest providing a list of ids as necessary.

    The SDK is allowed to reuse the identifiers
    for the lifetime of the associated control connection as long
    as the MonitoringInfo could be reconstructed fully by overwriting its
    payload field with the bytes specified here.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___HarnessMonitoringInfosRequest = HarnessMonitoringInfosRequest

@typing_extensions.final
class HarnessMonitoringInfosResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class MonitoringDataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.bytes
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: builtins.bytes | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    MONITORING_DATA_FIELD_NUMBER: builtins.int
    @property
    def monitoring_data(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.bytes]:
        """An identifier to MonitoringInfo.payload mapping containing
        Metrics associated with the SDK harness, not a specific bundle.

        An SDK can report metrics using an identifier that only contains the
        associated payload. A runner who wants to receive the full metrics
        information can request all the monitoring metadata via a
        MonitoringInfosMetadataRequest providing a list of ids as necessary.

        The SDK is allowed to reuse the identifiers
        for the lifetime of the associated control connection as long
        as the MonitoringInfo could be reconstructed fully by overwriting its
        payload field with the bytes specified here.
        """
    def __init__(
        self,
        *,
        monitoring_data: collections.abc.Mapping[builtins.str, builtins.bytes] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["monitoring_data", b"monitoring_data"]) -> None: ...

global___HarnessMonitoringInfosResponse = HarnessMonitoringInfosResponse

@typing_extensions.final
class RegisterRequest(google.protobuf.message.Message):
    """A list of objects which can be referred to by the runner in
    future requests.
    Stable
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROCESS_BUNDLE_DESCRIPTOR_FIELD_NUMBER: builtins.int
    @property
    def process_bundle_descriptor(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ProcessBundleDescriptor]:
        """(Optional) The set of descriptors used to process bundles."""
    def __init__(
        self,
        *,
        process_bundle_descriptor: collections.abc.Iterable[global___ProcessBundleDescriptor] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["process_bundle_descriptor", b"process_bundle_descriptor"]) -> None: ...

global___RegisterRequest = RegisterRequest

@typing_extensions.final
class RegisterResponse(google.protobuf.message.Message):
    """Stable"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___RegisterResponse = RegisterResponse

@typing_extensions.final
class ProcessBundleDescriptor(google.protobuf.message.Message):
    """Definitions that should be used to construct the bundle processing graph."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class TransformsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.PTransform: ...
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.PTransform | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class PcollectionsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.PCollection: ...
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.PCollection | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class WindowingStrategiesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.WindowingStrategy: ...
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.WindowingStrategy | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class CodersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.Coder: ...
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.Coder | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class EnvironmentsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.Environment: ...
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.Environment | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    TRANSFORMS_FIELD_NUMBER: builtins.int
    PCOLLECTIONS_FIELD_NUMBER: builtins.int
    WINDOWING_STRATEGIES_FIELD_NUMBER: builtins.int
    CODERS_FIELD_NUMBER: builtins.int
    ENVIRONMENTS_FIELD_NUMBER: builtins.int
    STATE_API_SERVICE_DESCRIPTOR_FIELD_NUMBER: builtins.int
    TIMER_API_SERVICE_DESCRIPTOR_FIELD_NUMBER: builtins.int
    id: builtins.str
    """(Required) A pipeline level unique id which can be used as a reference to
    refer to this.
    """
    @property
    def transforms(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.PTransform]:
        """(Required) A map from pipeline-scoped id to PTransform."""
    @property
    def pcollections(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.PCollection]:
        """(Required) A map from pipeline-scoped id to PCollection."""
    @property
    def windowing_strategies(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.WindowingStrategy]:
        """(Required) A map from pipeline-scoped id to WindowingStrategy."""
    @property
    def coders(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.Coder]:
        """(Required) A map from pipeline-scoped id to Coder."""
    @property
    def environments(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.Environment]:
        """(Required) A map from pipeline-scoped id to Environment."""
    @property
    def state_api_service_descriptor(self) -> org.apache.beam.model.pipeline.v1.endpoints_pb2.ApiServiceDescriptor:
        """A descriptor describing the end point to use for State API
        calls. Required if the Runner intends to send remote references over the
        data plane or if any of the transforms rely on user state or side inputs.
        """
    @property
    def timer_api_service_descriptor(self) -> org.apache.beam.model.pipeline.v1.endpoints_pb2.ApiServiceDescriptor:
        """A descriptor describing the end point to use for Data API for user timers.
        Required if the ProcessBundleDescriptor contains any transforms that have user timers.
        """
    def __init__(
        self,
        *,
        id: builtins.str | None = ...,
        transforms: collections.abc.Mapping[builtins.str, org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.PTransform] | None = ...,
        pcollections: collections.abc.Mapping[builtins.str, org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.PCollection] | None = ...,
        windowing_strategies: collections.abc.Mapping[builtins.str, org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.WindowingStrategy] | None = ...,
        coders: collections.abc.Mapping[builtins.str, org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.Coder] | None = ...,
        environments: collections.abc.Mapping[builtins.str, org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.Environment] | None = ...,
        state_api_service_descriptor: org.apache.beam.model.pipeline.v1.endpoints_pb2.ApiServiceDescriptor | None = ...,
        timer_api_service_descriptor: org.apache.beam.model.pipeline.v1.endpoints_pb2.ApiServiceDescriptor | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["state_api_service_descriptor", b"state_api_service_descriptor", "timer_api_service_descriptor", b"timer_api_service_descriptor"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["coders", b"coders", "environments", b"environments", "id", b"id", "pcollections", b"pcollections", "state_api_service_descriptor", b"state_api_service_descriptor", "timer_api_service_descriptor", b"timer_api_service_descriptor", "transforms", b"transforms", "windowing_strategies", b"windowing_strategies"]) -> None: ...

global___ProcessBundleDescriptor = ProcessBundleDescriptor

@typing_extensions.final
class BundleApplication(google.protobuf.message.Message):
    """One of the applications specifying the scope of work for a bundle.
    See
    https://docs.google.com/document/d/1tUDb45sStdR8u7-jBkGdw3OGFK7aa2-V7eo86zYSE_4/edit#heading=h.9g3g5weg2u9
    for further details.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class OutputWatermarksEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    TRANSFORM_ID_FIELD_NUMBER: builtins.int
    INPUT_ID_FIELD_NUMBER: builtins.int
    ELEMENT_FIELD_NUMBER: builtins.int
    OUTPUT_WATERMARKS_FIELD_NUMBER: builtins.int
    IS_BOUNDED_FIELD_NUMBER: builtins.int
    transform_id: builtins.str
    """(Required) The transform to which to pass the element"""
    input_id: builtins.str
    """(Required) Name of the transform's input to which to pass the element."""
    element: builtins.bytes
    """(Required) The encoded element to pass to the transform."""
    @property
    def output_watermarks(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, google.protobuf.timestamp_pb2.Timestamp]:
        """The map is keyed by the local output name of the PTransform. Each
        value represents a lower bound on the timestamps of elements that
        are produced by this PTransform into each of its output PCollections
        when invoked with this application.

        If there is no watermark reported from RestrictionTracker, the runner will
        use MIN_TIMESTAMP by default.
        """
    is_bounded: org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.IsBounded.Enum.ValueType
    """Whether this application potentially produces an unbounded
    amount of data. Note that this should only be set to BOUNDED if and
    only if the application is known to produce a finite amount of output.
    """
    def __init__(
        self,
        *,
        transform_id: builtins.str | None = ...,
        input_id: builtins.str | None = ...,
        element: builtins.bytes | None = ...,
        output_watermarks: collections.abc.Mapping[builtins.str, google.protobuf.timestamp_pb2.Timestamp] | None = ...,
        is_bounded: org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.IsBounded.Enum.ValueType | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["element", b"element", "input_id", b"input_id", "is_bounded", b"is_bounded", "output_watermarks", b"output_watermarks", "transform_id", b"transform_id"]) -> None: ...

global___BundleApplication = BundleApplication

@typing_extensions.final
class DelayedBundleApplication(google.protobuf.message.Message):
    """An Application should be scheduled for execution after a delay.
    Either an absolute timestamp or a relative timestamp can represent a
    scheduled execution time.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPLICATION_FIELD_NUMBER: builtins.int
    REQUESTED_TIME_DELAY_FIELD_NUMBER: builtins.int
    @property
    def application(self) -> global___BundleApplication:
        """(Required) The application that should be scheduled."""
    @property
    def requested_time_delay(self) -> google.protobuf.duration_pb2.Duration:
        """Recommended time delay at which the application should be scheduled to
        execute by the runner. Time delay that equals 0 may be scheduled to execute
        immediately. The unit of time delay should be microsecond.
        """
    def __init__(
        self,
        *,
        application: global___BundleApplication | None = ...,
        requested_time_delay: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["application", b"application", "requested_time_delay", b"requested_time_delay"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["application", b"application", "requested_time_delay", b"requested_time_delay"]) -> None: ...

global___DelayedBundleApplication = DelayedBundleApplication

@typing_extensions.final
class ProcessBundleRequest(google.protobuf.message.Message):
    """A request to process a given bundle.
    Stable
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class CacheToken(google.protobuf.message.Message):
        """Contains the cache token and also defines the scope of what the token applies to.

        See https://s.apache.org/beam-fn-state-api-and-bundle-processing#heading=h.7ghoih5aig5m
        for additional details on how to use the cache token with the State API
        to cache data across bundle boundaries.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing_extensions.final
        class UserState(google.protobuf.message.Message):
            """A flag to indicate a cache token is valid for all user state."""

            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            def __init__(
                self,
            ) -> None: ...

        @typing_extensions.final
        class SideInput(google.protobuf.message.Message):
            """A flag to indicate a cache token is valid for a side input."""

            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            TRANSFORM_ID_FIELD_NUMBER: builtins.int
            SIDE_INPUT_ID_FIELD_NUMBER: builtins.int
            transform_id: builtins.str
            """(Required) The id of the PTransform containing a side input."""
            side_input_id: builtins.str
            """(Required) The id of the side input."""
            def __init__(
                self,
                *,
                transform_id: builtins.str | None = ...,
                side_input_id: builtins.str | None = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing_extensions.Literal["side_input_id", b"side_input_id", "transform_id", b"transform_id"]) -> None: ...

        USER_STATE_FIELD_NUMBER: builtins.int
        SIDE_INPUT_FIELD_NUMBER: builtins.int
        TOKEN_FIELD_NUMBER: builtins.int
        @property
        def user_state(self) -> global___ProcessBundleRequest.CacheToken.UserState: ...
        @property
        def side_input(self) -> global___ProcessBundleRequest.CacheToken.SideInput: ...
        token: builtins.bytes
        """An opaque token used with the StateKey to create a globally unique
        identifier.
        """
        def __init__(
            self,
            *,
            user_state: global___ProcessBundleRequest.CacheToken.UserState | None = ...,
            side_input: global___ProcessBundleRequest.CacheToken.SideInput | None = ...,
            token: builtins.bytes | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["side_input", b"side_input", "type", b"type", "user_state", b"user_state"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["side_input", b"side_input", "token", b"token", "type", b"type", "user_state", b"user_state"]) -> None: ...
        def WhichOneof(self, oneof_group: typing_extensions.Literal["type", b"type"]) -> typing_extensions.Literal["user_state", "side_input"] | None: ...

    PROCESS_BUNDLE_DESCRIPTOR_ID_FIELD_NUMBER: builtins.int
    CACHE_TOKENS_FIELD_NUMBER: builtins.int
    ELEMENTS_FIELD_NUMBER: builtins.int
    process_bundle_descriptor_id: builtins.str
    """(Required) A reference to the process bundle descriptor that must be
    instantiated and executed by the SDK harness.
    """
    @property
    def cache_tokens(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ProcessBundleRequest.CacheToken]:
        """(Optional) A list of cache tokens that can be used by an SDK to reuse
        cached data returned by the State API across multiple bundles.

        Note that SDKs that can efficiently consume this field should declare
        the beam:protocol:state_caching:v1 capability enabling runners to reduce
        the amount of memory used.

        See https://s.apache.org/beam-fn-state-api-and-bundle-processing#heading=h.7ghoih5aig5m
        for additional details on how to use the cache token with the State API
        to cache data across bundle boundaries.
        """
    @property
    def elements(self) -> global___Elements:
        """(Optional) Elements to be processed with the bundle. Either all or
        none of the bundle elements should be included in the ProcessBundleRequest.
        This embedding is to achieve better efficiency for bundles that contain
        only small amounts of data and are cheap to be processed on the SDK harness
        side. This field can be set only if the SDK declares that it supports the
        beam:protocol:control_request_elements_embedding:v1 capability. See more
        at https://s.apache.org/beam-fn-api-control-data-embedding.
        """
    def __init__(
        self,
        *,
        process_bundle_descriptor_id: builtins.str | None = ...,
        cache_tokens: collections.abc.Iterable[global___ProcessBundleRequest.CacheToken] | None = ...,
        elements: global___Elements | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["elements", b"elements"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cache_tokens", b"cache_tokens", "elements", b"elements", "process_bundle_descriptor_id", b"process_bundle_descriptor_id"]) -> None: ...

global___ProcessBundleRequest = ProcessBundleRequest

@typing_extensions.final
class ProcessBundleResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class MonitoringDataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.bytes
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: builtins.bytes | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    RESIDUAL_ROOTS_FIELD_NUMBER: builtins.int
    MONITORING_INFOS_FIELD_NUMBER: builtins.int
    REQUIRES_FINALIZATION_FIELD_NUMBER: builtins.int
    MONITORING_DATA_FIELD_NUMBER: builtins.int
    ELEMENTS_FIELD_NUMBER: builtins.int
    @property
    def residual_roots(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DelayedBundleApplication]:
        """(Optional) Specifies that the bundle has not been completed and the
        following applications need to be scheduled and executed in the future.
        A runner that does not yet support residual roots MUST still check that
        this is empty for correctness.

        Note that these residual roots must not have been returned as part of a
        prior split for this bundle.
        """
    @property
    def monitoring_infos(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[org.apache.beam.model.pipeline.v1.metrics_pb2.MonitoringInfo]:
        """DEPRECATED (Required) The list of metrics or other MonitoredState
        collected while processing this bundle.
        """
    requires_finalization: builtins.bool
    """(Optional) Specifies that the runner must callback to this worker
    once the output of the bundle is committed. The Runner must send a
    FinalizeBundleRequest with the instruction id of the ProcessBundleRequest
    that is related to this ProcessBundleResponse.
    """
    @property
    def monitoring_data(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.bytes]:
        """An identifier to MonitoringInfo.payload mapping.

        An SDK can report metrics using an identifier that only contains the
        associated payload. A runner who wants to receive the full metrics
        information can request all the monitoring metadata via a
        MonitoringInfosMetadataRequest providing a list of ids as necessary.

        The SDK is allowed to reuse the identifiers across multiple bundles as long
        as the MonitoringInfo could be reconstructed fully by overwriting its
        payload field with the bytes specified here.
        """
    @property
    def elements(self) -> global___Elements:
        """(Optional) Output elements of the processed bundle. Either all or
        none of the bundle elements should be included in the ProcessBundleResponse.
        This embedding is to achieve better efficiency for bundles that only
        contain small amounts of data. his field can be set only if the runner
        declares that it supports the
        beam:protocol:control_request_elements_embedding:v1 capability. See more at
        https://s.apache.org/beam-fn-api-control-data-embedding.
        """
    def __init__(
        self,
        *,
        residual_roots: collections.abc.Iterable[global___DelayedBundleApplication] | None = ...,
        monitoring_infos: collections.abc.Iterable[org.apache.beam.model.pipeline.v1.metrics_pb2.MonitoringInfo] | None = ...,
        requires_finalization: builtins.bool | None = ...,
        monitoring_data: collections.abc.Mapping[builtins.str, builtins.bytes] | None = ...,
        elements: global___Elements | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["elements", b"elements"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["elements", b"elements", "monitoring_data", b"monitoring_data", "monitoring_infos", b"monitoring_infos", "requires_finalization", b"requires_finalization", "residual_roots", b"residual_roots"]) -> None: ...

global___ProcessBundleResponse = ProcessBundleResponse

@typing_extensions.final
class ProcessBundleProgressRequest(google.protobuf.message.Message):
    """A request to report progress information for a given bundle.
    This is an optional request to be handled and is used to support advanced
    SDK features such as SplittableDoFn, user level metrics etc.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUCTION_ID_FIELD_NUMBER: builtins.int
    instruction_id: builtins.str
    """(Required) A reference to an active process bundle request with the given
    instruction id.
    """
    def __init__(
        self,
        *,
        instruction_id: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["instruction_id", b"instruction_id"]) -> None: ...

global___ProcessBundleProgressRequest = ProcessBundleProgressRequest

@typing_extensions.final
class MonitoringInfosMetadataRequest(google.protobuf.message.Message):
    """A request to provide full MonitoringInfo for a set of provided ids.

    An SDK can report metrics using an identifier that only contains the
    associated payload. A runner who wants to receive the full metrics
    information can request all the monitoring metadata via a
    MonitoringInfosMetadataRequest providing a list of ids as necessary.

    The SDK is allowed to reuse the identifiers for the lifetime of the
    associated control connection as long as the MonitoringInfo could be
    reconstructed fully by overwriting its payload field with the bytes specified
    here.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MONITORING_INFO_ID_FIELD_NUMBER: builtins.int
    @property
    def monitoring_info_id(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A list of ids for which the full MonitoringInfo is requested for."""
    def __init__(
        self,
        *,
        monitoring_info_id: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["monitoring_info_id", b"monitoring_info_id"]) -> None: ...

global___MonitoringInfosMetadataRequest = MonitoringInfosMetadataRequest

@typing_extensions.final
class ProcessBundleProgressResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class MonitoringDataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.bytes
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: builtins.bytes | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    MONITORING_INFOS_FIELD_NUMBER: builtins.int
    MONITORING_DATA_FIELD_NUMBER: builtins.int
    @property
    def monitoring_infos(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[org.apache.beam.model.pipeline.v1.metrics_pb2.MonitoringInfo]:
        """DEPRECATED (Required) The list of metrics or other MonitoredState
        collected while processing this bundle.
        """
    @property
    def monitoring_data(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.bytes]:
        """An identifier to MonitoringInfo.payload mapping.

        An SDK can report metrics using an identifier that only contains the
        associated payload. A runner who wants to receive the full metrics
        information can request all the monitoring metadata via a
        MonitoringInfosMetadataRequest providing a list of ids as necessary.

        The SDK is allowed to reuse the identifiers
        for the lifetime of the associated control connection as long
        as the MonitoringInfo could be reconstructed fully by overwriting its
        payload field with the bytes specified here.
        """
    def __init__(
        self,
        *,
        monitoring_infos: collections.abc.Iterable[org.apache.beam.model.pipeline.v1.metrics_pb2.MonitoringInfo] | None = ...,
        monitoring_data: collections.abc.Mapping[builtins.str, builtins.bytes] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["monitoring_data", b"monitoring_data", "monitoring_infos", b"monitoring_infos"]) -> None: ...

global___ProcessBundleProgressResponse = ProcessBundleProgressResponse

@typing_extensions.final
class MonitoringInfosMetadataResponse(google.protobuf.message.Message):
    """A response that contains the full mapping information associated with
    a specified set of identifiers.

    An SDK can report metrics using an identifier that only contains the
    associated payload. A runner who wants to receive the full metrics
    information can request all the monitoring metadata via a
    MonitoringInfosMetadataRequest providing a list of ids as necessary.

    The SDK is allowed to reuse the identifiers
    for the lifetime of the associated control connection as long
    as the MonitoringInfo could be reconstructed fully by overwriting its
    payload field with the bytes specified here.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class MonitoringInfoEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> org.apache.beam.model.pipeline.v1.metrics_pb2.MonitoringInfo: ...
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: org.apache.beam.model.pipeline.v1.metrics_pb2.MonitoringInfo | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    MONITORING_INFO_FIELD_NUMBER: builtins.int
    @property
    def monitoring_info(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, org.apache.beam.model.pipeline.v1.metrics_pb2.MonitoringInfo]:
        """A mapping from an identifier to the full metrics information."""
    def __init__(
        self,
        *,
        monitoring_info: collections.abc.Mapping[builtins.str, org.apache.beam.model.pipeline.v1.metrics_pb2.MonitoringInfo] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["monitoring_info", b"monitoring_info"]) -> None: ...

global___MonitoringInfosMetadataResponse = MonitoringInfosMetadataResponse

@typing_extensions.final
class ProcessBundleSplitRequest(google.protobuf.message.Message):
    """Represents a request to the SDK to split a currently active bundle."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class DesiredSplit(google.protobuf.message.Message):
        """A message specifying the desired split for a single transform."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        FRACTION_OF_REMAINDER_FIELD_NUMBER: builtins.int
        ALLOWED_SPLIT_POINTS_FIELD_NUMBER: builtins.int
        ESTIMATED_INPUT_ELEMENTS_FIELD_NUMBER: builtins.int
        fraction_of_remainder: builtins.float
        """(Required) The fraction of known work remaining in this bundle
        for this transform that should be kept by the SDK after this split.

        Set to 0 to "checkpoint" as soon as possible (keeping as little work as
        possible and returning the remainder).
        """
        @property
        def allowed_split_points(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
            """(Optional) A set of allowed element indices where the SDK may split. When
            this is empty, there are no constraints on where to split.
            """
        estimated_input_elements: builtins.int
        """(Required for gRPC Read operation transforms) Number of total elements
        expected to be sent to this GrpcRead operation, required to correctly
        account for unreceived data when determining where to split.
        """
        def __init__(
            self,
            *,
            fraction_of_remainder: builtins.float | None = ...,
            allowed_split_points: collections.abc.Iterable[builtins.int] | None = ...,
            estimated_input_elements: builtins.int | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["allowed_split_points", b"allowed_split_points", "estimated_input_elements", b"estimated_input_elements", "fraction_of_remainder", b"fraction_of_remainder"]) -> None: ...

    @typing_extensions.final
    class DesiredSplitsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___ProcessBundleSplitRequest.DesiredSplit: ...
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: global___ProcessBundleSplitRequest.DesiredSplit | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    INSTRUCTION_ID_FIELD_NUMBER: builtins.int
    DESIRED_SPLITS_FIELD_NUMBER: builtins.int
    instruction_id: builtins.str
    """(Required) A reference to an active process bundle request with the given
    instruction id.
    """
    @property
    def desired_splits(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___ProcessBundleSplitRequest.DesiredSplit]:
        """(Required) Specifies the desired split for each transform.

        Currently only splits at gRPC read operations are supported.
        This may, of course, limit the amount of work downstream operations
        receive.
        """
    def __init__(
        self,
        *,
        instruction_id: builtins.str | None = ...,
        desired_splits: collections.abc.Mapping[builtins.str, global___ProcessBundleSplitRequest.DesiredSplit] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["desired_splits", b"desired_splits", "instruction_id", b"instruction_id"]) -> None: ...

global___ProcessBundleSplitRequest = ProcessBundleSplitRequest

@typing_extensions.final
class ProcessBundleSplitResponse(google.protobuf.message.Message):
    """Represents a partition of the bundle: a "primary" and a "residual", with the
    following properties:
    - The work in primary and residual doesn't overlap, and combined, adds up
      to the work in the current bundle if the split hadn't happened.
    - The current bundle, if it keeps executing, will have done exactly none of
      the work under residual_roots and none of the elements at and beyond the
      first_residual_element.
    - The current bundle, if no further splits happen, will have done exactly
      the work under primary_roots and all elements up to and including the
      channel splits last_primary_element.

    This allows the SDK to relinquish ownership of and commit to not process some
    of the elements that it may have been sent (the residual) while retaining
    ownership and commitment to finish the other portion (the primary).

    For example, lets say the SDK is processing elements A B C D E and a split
    request comes in. The SDK could return a response with a channel split
    representing a last_primary_element of 3 (D) and first_residual_element of 4
    (E). The SDK is now responsible for processing A B C D and the runner must
    process E in the future. A future split request could have the SDK split the
    elements B into B1 and B2 and C into C1 and C2 representing their primary and
    residual roots. The SDK would return a response with a channel split
    representing a last_primary_element of 0 (A) and first_residual_element of 3
    (D) with primary_roots (B1, C1) and residual_roots (B2, C2). The SDK is now
    responsible for processing A B1 C1 and the runner must process C2 D2 (and E
    from the prior split) in the future. Yet another future split request could
    have the SDK could split B1 further into B1a and B1b primary and residuals
    and return C2 as a residual (assuming C2 was left unprocessed). The SDK would
    return a response with a channel split representing a last_primary_element of
    0 (A) and first_residual_element of 4 (E) with primary_roots (B1a) and
    residual_roots (B1b, C1). The SDK is now responsible for processing A B1a the
    runner must process B1b C1 (in addition to C2, D, E from prior splits) in the
    future.

    For more rigorous definitions see https://s.apache.org/beam-breaking-fusion
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class ChannelSplit(google.protobuf.message.Message):
        """Represents contiguous portions of the data channel that are either
        entirely processed or entirely unprocessed and belong to the primary
        or residual respectively.

        This affords both a more efficient representation over the FnAPI
        (if the bundle is large) and often a more efficient representation
        on the runner side (e.g. if the set of elements can be represented
        as some range in an underlying dataset).

        Note that for a split the following properties must hold:
        - last_primary_element < first_residual_element
        - primary roots and residual roots can only be specified if the
          last_primary_element + 1 < first_residual_element
          (typically there is one primary and residual root per element in the
          range (last_primary_element, first_residual_element))
        - primary roots and residual roots must represent a disjoint but full
          coverage of work represented by the elements between last_primary_element
          and first_residual_element

        Note that subsequent splits of the same bundle must ensure that:
        - the first_residual_element does not increase
        - the first_residual_element does not decrease if there were residual
          or primary roots returned in a prior split.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TRANSFORM_ID_FIELD_NUMBER: builtins.int
        LAST_PRIMARY_ELEMENT_FIELD_NUMBER: builtins.int
        FIRST_RESIDUAL_ELEMENT_FIELD_NUMBER: builtins.int
        transform_id: builtins.str
        """(Required) The grpc read transform reading this channel."""
        last_primary_element: builtins.int
        """(Required) The last element of the input channel that should be entirely
        considered part of the primary, identified by its absolute zero-based
        index in the (ordered) channel.
        """
        first_residual_element: builtins.int
        """(Required) The first element of the input channel that should be entirely
        considered part of the residual, identified by its absolute zero-based
        index in the (ordered) channel.
        """
        def __init__(
            self,
            *,
            transform_id: builtins.str | None = ...,
            last_primary_element: builtins.int | None = ...,
            first_residual_element: builtins.int | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["first_residual_element", b"first_residual_element", "last_primary_element", b"last_primary_element", "transform_id", b"transform_id"]) -> None: ...

    PRIMARY_ROOTS_FIELD_NUMBER: builtins.int
    RESIDUAL_ROOTS_FIELD_NUMBER: builtins.int
    CHANNEL_SPLITS_FIELD_NUMBER: builtins.int
    @property
    def primary_roots(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BundleApplication]:
        """(Optional) Root applications that should replace the current bundle.

        Note that primary roots can only be specified if a channel split's
        last_primary_element + 1 < first_residual_element

        Note that there must be a corresponding residual root contained within
        residual_roots representing the remainder of processing for the original
        element this this primary root represents a fraction of.
        """
    @property
    def residual_roots(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DelayedBundleApplication]:
        """(Optional) Root applications that have been removed from the current bundle and
        have to be executed in a separate bundle (e.g. in parallel on a different
        worker, or after the current bundle completes, etc.)

        Note that residual roots can only be specified if a channel split's
        last_primary_element + 1 < first_residual_element

        Note that there must be a corresponding primary root contained within
        primary_roots representing the remainder of processing for the original
        element this this residual root represents a fraction of.

        Note that subsequent splits must not return prior residual roots.
        """
    @property
    def channel_splits(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ProcessBundleSplitResponse.ChannelSplit]:
        """(Required) Partitions of input data channels into primary and residual
        elements, if any. Must not include any elements represented in the bundle
        applications roots above of the current split or any prior split of the
        same bundle.
        """
    def __init__(
        self,
        *,
        primary_roots: collections.abc.Iterable[global___BundleApplication] | None = ...,
        residual_roots: collections.abc.Iterable[global___DelayedBundleApplication] | None = ...,
        channel_splits: collections.abc.Iterable[global___ProcessBundleSplitResponse.ChannelSplit] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["channel_splits", b"channel_splits", "primary_roots", b"primary_roots", "residual_roots", b"residual_roots"]) -> None: ...

global___ProcessBundleSplitResponse = ProcessBundleSplitResponse

@typing_extensions.final
class FinalizeBundleRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUCTION_ID_FIELD_NUMBER: builtins.int
    instruction_id: builtins.str
    """(Required) A reference to a completed process bundle request with the given
    instruction id.
    """
    def __init__(
        self,
        *,
        instruction_id: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["instruction_id", b"instruction_id"]) -> None: ...

global___FinalizeBundleRequest = FinalizeBundleRequest

@typing_extensions.final
class FinalizeBundleResponse(google.protobuf.message.Message):
    """Empty"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___FinalizeBundleResponse = FinalizeBundleResponse

@typing_extensions.final
class Elements(google.protobuf.message.Message):
    """
    Data Plane API

    Messages used to represent logical byte streams.
    Stable
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class Data(google.protobuf.message.Message):
        """Represents multiple encoded elements in nested context for a given named
        instruction and transform.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        INSTRUCTION_ID_FIELD_NUMBER: builtins.int
        TRANSFORM_ID_FIELD_NUMBER: builtins.int
        DATA_FIELD_NUMBER: builtins.int
        IS_LAST_FIELD_NUMBER: builtins.int
        instruction_id: builtins.str
        """(Required) A reference to an active instruction request with the given
        instruction id.
        """
        transform_id: builtins.str
        """(Required) A definition representing a consumer or producer of this data.
        If received by a harness, this represents the consumer within that
        harness that should consume these bytes. If sent by a harness, this
        represents the producer of these bytes.

        Note that a single element may span multiple Data messages.

        Note that a sending/receiving pair should share the same identifier.
        """
        data: builtins.bytes
        """(Optional) Represents a part of a logical byte stream. Elements within
        the logical byte stream are encoded in the nested context and
        concatenated together.
        """
        is_last: builtins.bool
        """(Optional) Set this bit to indicate the this is the last data block
        for the given instruction and transform, ending the stream.
        """
        def __init__(
            self,
            *,
            instruction_id: builtins.str | None = ...,
            transform_id: builtins.str | None = ...,
            data: builtins.bytes | None = ...,
            is_last: builtins.bool | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["data", b"data", "instruction_id", b"instruction_id", "is_last", b"is_last", "transform_id", b"transform_id"]) -> None: ...

    @typing_extensions.final
    class Timers(google.protobuf.message.Message):
        """Represent the encoded user timer for a given instruction, transform and
        timer id.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        INSTRUCTION_ID_FIELD_NUMBER: builtins.int
        TRANSFORM_ID_FIELD_NUMBER: builtins.int
        TIMER_FAMILY_ID_FIELD_NUMBER: builtins.int
        TIMERS_FIELD_NUMBER: builtins.int
        IS_LAST_FIELD_NUMBER: builtins.int
        instruction_id: builtins.str
        """(Required) A reference to an active instruction request with the given
        instruction id.
        """
        transform_id: builtins.str
        """(Required) A definition representing a consumer or producer of this data.
        If received by a harness, this represents the consumer within that
        harness that should consume these timers. If sent by a harness, this
        represents the producer of these timers.
        """
        timer_family_id: builtins.str
        """(Required) The local timer family name used to identify the associated
        timer family specification
        """
        timers: builtins.bytes
        """(Optional) Represents a logical byte stream of timers. Encoded according
        to the coder in the timer spec.
        """
        is_last: builtins.bool
        """(Optional) Set this bit to indicate the this is the last data block
        for the given instruction and transform, ending the stream.
        """
        def __init__(
            self,
            *,
            instruction_id: builtins.str | None = ...,
            transform_id: builtins.str | None = ...,
            timer_family_id: builtins.str | None = ...,
            timers: builtins.bytes | None = ...,
            is_last: builtins.bool | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["instruction_id", b"instruction_id", "is_last", b"is_last", "timer_family_id", b"timer_family_id", "timers", b"timers", "transform_id", b"transform_id"]) -> None: ...

    DATA_FIELD_NUMBER: builtins.int
    TIMERS_FIELD_NUMBER: builtins.int
    @property
    def data(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Elements.Data]:
        """(Optional) A list containing parts of logical byte streams."""
    @property
    def timers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Elements.Timers]:
        """(Optional)  A list of timer byte streams."""
    def __init__(
        self,
        *,
        data: collections.abc.Iterable[global___Elements.Data] | None = ...,
        timers: collections.abc.Iterable[global___Elements.Timers] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["data", b"data", "timers", b"timers"]) -> None: ...

global___Elements = Elements

@typing_extensions.final
class StateRequest(google.protobuf.message.Message):
    """
    State API
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    INSTRUCTION_ID_FIELD_NUMBER: builtins.int
    STATE_KEY_FIELD_NUMBER: builtins.int
    GET_FIELD_NUMBER: builtins.int
    APPEND_FIELD_NUMBER: builtins.int
    CLEAR_FIELD_NUMBER: builtins.int
    id: builtins.str
    """(Required) A unique identifier provided by the SDK which represents this
    requests execution. The StateResponse corresponding with this request
    will have the matching id.
    """
    instruction_id: builtins.str
    """(Required) The associated instruction id of the work that is currently
    being processed. This allows for the runner to associate any modifications
    to state to be committed with the appropriate work execution.
    """
    @property
    def state_key(self) -> global___StateKey:
        """(Required) The state key this request is for."""
    @property
    def get(self) -> global___StateGetRequest:
        """A request to get state."""
    @property
    def append(self) -> global___StateAppendRequest:
        """A request to append to state."""
    @property
    def clear(self) -> global___StateClearRequest:
        """A request to clear state."""
    def __init__(
        self,
        *,
        id: builtins.str | None = ...,
        instruction_id: builtins.str | None = ...,
        state_key: global___StateKey | None = ...,
        get: global___StateGetRequest | None = ...,
        append: global___StateAppendRequest | None = ...,
        clear: global___StateClearRequest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["append", b"append", "clear", b"clear", "get", b"get", "request", b"request", "state_key", b"state_key"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["append", b"append", "clear", b"clear", "get", b"get", "id", b"id", "instruction_id", b"instruction_id", "request", b"request", "state_key", b"state_key"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["request", b"request"]) -> typing_extensions.Literal["get", "append", "clear"] | None: ...

global___StateRequest = StateRequest

@typing_extensions.final
class StateResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    GET_FIELD_NUMBER: builtins.int
    APPEND_FIELD_NUMBER: builtins.int
    CLEAR_FIELD_NUMBER: builtins.int
    id: builtins.str
    """(Required) A reference provided by the SDK which represents a requests
    execution. The StateResponse must have the matching id when responding
    to the SDK.
    """
    error: builtins.str
    """(Optional) If this is specified, then the state request has failed.
    A human readable string representing the reason as to why the request
    failed.
    """
    @property
    def get(self) -> global___StateGetResponse:
        """A response to getting state."""
    @property
    def append(self) -> global___StateAppendResponse:
        """A response to appending to state."""
    @property
    def clear(self) -> global___StateClearResponse:
        """A response to clearing state."""
    def __init__(
        self,
        *,
        id: builtins.str | None = ...,
        error: builtins.str | None = ...,
        get: global___StateGetResponse | None = ...,
        append: global___StateAppendResponse | None = ...,
        clear: global___StateClearResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["append", b"append", "clear", b"clear", "get", b"get", "response", b"response"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["append", b"append", "clear", b"clear", "error", b"error", "get", b"get", "id", b"id", "response", b"response"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["response", b"response"]) -> typing_extensions.Literal["get", "append", "clear"] | None: ...

global___StateResponse = StateResponse

@typing_extensions.final
class StateKey(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class Runner(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        key: builtins.bytes
        """(Required) Opaque information supplied by the runner. Used to support
        remote references.
        https://s.apache.org/beam-fn-api-send-and-receive-data

        Used by state backed iterable. And in this use case, request type can
        only be of type get. Details see:
        https://s.apache.org/beam-fn-api-state-backed-iterables
        """
        def __init__(
            self,
            *,
            key: builtins.bytes | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key"]) -> None: ...

    @typing_extensions.final
    class IterableSideInput(google.protobuf.message.Message):
        """Represents a request for the values associated with a specified window
        in a PCollection. See
        https://s.apache.org/beam-fn-state-api-and-bundle-processing for further
        details.

        Can only be used to perform StateGetRequests on side inputs of the URN
        beam:side_input:iterable:v1.

        For a PCollection<V>, the response data stream will be a concatenation
        of all V's. See https://s.apache.org/beam-fn-api-send-and-receive-data
        for further details.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TRANSFORM_ID_FIELD_NUMBER: builtins.int
        SIDE_INPUT_ID_FIELD_NUMBER: builtins.int
        WINDOW_FIELD_NUMBER: builtins.int
        transform_id: builtins.str
        """(Required) The id of the PTransform containing a side input."""
        side_input_id: builtins.str
        """(Required) The id of the side input."""
        window: builtins.bytes
        """(Required) The window (after mapping the currently executing elements
        window into the side input windows domain) encoded in a nested context.
        """
        def __init__(
            self,
            *,
            transform_id: builtins.str | None = ...,
            side_input_id: builtins.str | None = ...,
            window: builtins.bytes | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["side_input_id", b"side_input_id", "transform_id", b"transform_id", "window", b"window"]) -> None: ...

    @typing_extensions.final
    class MultimapSideInput(google.protobuf.message.Message):
        """Represents a request for the values associated with a specified user key
        and window in a PCollection. See
        https://s.apache.org/beam-fn-state-api-and-bundle-processing for further
        details.

        Can only be used to perform StateGetRequests on side inputs of the URN
        beam:side_input:multimap:v1.

        For a PCollection<KV<K, V>>, the response data stream will be a
        concatenation of all V's associated with the specified key K. See
        https://s.apache.org/beam-fn-api-send-and-receive-data for further
        details.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TRANSFORM_ID_FIELD_NUMBER: builtins.int
        SIDE_INPUT_ID_FIELD_NUMBER: builtins.int
        WINDOW_FIELD_NUMBER: builtins.int
        KEY_FIELD_NUMBER: builtins.int
        transform_id: builtins.str
        """(Required) The id of the PTransform containing a side input."""
        side_input_id: builtins.str
        """(Required) The id of the side input."""
        window: builtins.bytes
        """(Required) The window (after mapping the currently executing elements
        window into the side input windows domain) encoded in a nested context.
        """
        key: builtins.bytes
        """(Required) The key encoded in a nested context."""
        def __init__(
            self,
            *,
            transform_id: builtins.str | None = ...,
            side_input_id: builtins.str | None = ...,
            window: builtins.bytes | None = ...,
            key: builtins.bytes | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "side_input_id", b"side_input_id", "transform_id", b"transform_id", "window", b"window"]) -> None: ...

    @typing_extensions.final
    class MultimapKeysSideInput(google.protobuf.message.Message):
        """Represents a request for the keys associated with a specified window in a PCollection. See
        https://s.apache.org/beam-fn-state-api-and-bundle-processing for further
        details.

        Can only be used to perform StateGetRequests on side inputs of the URN
        beam:side_input:multimap:v1.

        For a PCollection<KV<K, V>>, the response data stream will be a
        concatenation of all K's associated with the specified window. See
        https://s.apache.org/beam-fn-api-send-and-receive-data for further
        details.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TRANSFORM_ID_FIELD_NUMBER: builtins.int
        SIDE_INPUT_ID_FIELD_NUMBER: builtins.int
        WINDOW_FIELD_NUMBER: builtins.int
        transform_id: builtins.str
        """(Required) The id of the PTransform containing a side input."""
        side_input_id: builtins.str
        """(Required) The id of the side input."""
        window: builtins.bytes
        """(Required) The window (after mapping the currently executing elements
        window into the side input windows domain) encoded in a nested context.
        """
        def __init__(
            self,
            *,
            transform_id: builtins.str | None = ...,
            side_input_id: builtins.str | None = ...,
            window: builtins.bytes | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["side_input_id", b"side_input_id", "transform_id", b"transform_id", "window", b"window"]) -> None: ...

    @typing_extensions.final
    class BagUserState(google.protobuf.message.Message):
        """Represents a request for an unordered set of values associated with a
        specified user key and window for a PTransform. See
        https://s.apache.org/beam-fn-state-api-and-bundle-processing for further
        details.

        The response data stream will be a concatenation of all V's associated
        with the specified user key and window.
        See https://s.apache.org/beam-fn-api-send-and-receive-data for further
        details.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TRANSFORM_ID_FIELD_NUMBER: builtins.int
        USER_STATE_ID_FIELD_NUMBER: builtins.int
        WINDOW_FIELD_NUMBER: builtins.int
        KEY_FIELD_NUMBER: builtins.int
        transform_id: builtins.str
        """(Required) The id of the PTransform containing user state."""
        user_state_id: builtins.str
        """(Required) The id of the user state."""
        window: builtins.bytes
        """(Required) The window encoded in a nested context."""
        key: builtins.bytes
        """(Required) The key of the currently executing element encoded in a
        nested context.
        """
        def __init__(
            self,
            *,
            transform_id: builtins.str | None = ...,
            user_state_id: builtins.str | None = ...,
            window: builtins.bytes | None = ...,
            key: builtins.bytes | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "transform_id", b"transform_id", "user_state_id", b"user_state_id", "window", b"window"]) -> None: ...

    @typing_extensions.final
    class MultimapKeysUserState(google.protobuf.message.Message):
        """Represents a request for the keys of a multimap associated with a specified
        user key and window for a PTransform. See
        https://s.apache.org/beam-fn-state-api-and-bundle-processing for further
        details.

        Can only be used to perform StateGetRequests and StateClearRequests on the
        user state.

        The response data stream will be a concatenation of all K's associated
        with the specified user key and window.
        See https://s.apache.org/beam-fn-api-send-and-receive-data for further
        details.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TRANSFORM_ID_FIELD_NUMBER: builtins.int
        USER_STATE_ID_FIELD_NUMBER: builtins.int
        WINDOW_FIELD_NUMBER: builtins.int
        KEY_FIELD_NUMBER: builtins.int
        transform_id: builtins.str
        """(Required) The id of the PTransform containing user state."""
        user_state_id: builtins.str
        """(Required) The id of the user state."""
        window: builtins.bytes
        """(Required) The window encoded in a nested context."""
        key: builtins.bytes
        """(Required) The key of the currently executing element encoded in a
        nested context.
        """
        def __init__(
            self,
            *,
            transform_id: builtins.str | None = ...,
            user_state_id: builtins.str | None = ...,
            window: builtins.bytes | None = ...,
            key: builtins.bytes | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "transform_id", b"transform_id", "user_state_id", b"user_state_id", "window", b"window"]) -> None: ...

    @typing_extensions.final
    class MultimapUserState(google.protobuf.message.Message):
        """Represents a request for the values of the map key associated with a
        specified user key and window for a PTransform. See
        https://s.apache.org/beam-fn-state-api-and-bundle-processing for further
        details.

        The response data stream will be a concatenation of all V's associated
        with the specified map key, user key, and window.
        See https://s.apache.org/beam-fn-api-send-and-receive-data for further
        details.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TRANSFORM_ID_FIELD_NUMBER: builtins.int
        USER_STATE_ID_FIELD_NUMBER: builtins.int
        WINDOW_FIELD_NUMBER: builtins.int
        KEY_FIELD_NUMBER: builtins.int
        MAP_KEY_FIELD_NUMBER: builtins.int
        transform_id: builtins.str
        """(Required) The id of the PTransform containing user state."""
        user_state_id: builtins.str
        """(Required) The id of the user state."""
        window: builtins.bytes
        """(Required) The window encoded in a nested context."""
        key: builtins.bytes
        """(Required) The key of the currently executing element encoded in a
        nested context.
        """
        map_key: builtins.bytes
        """(Required) The map key encoded in a nested context."""
        def __init__(
            self,
            *,
            transform_id: builtins.str | None = ...,
            user_state_id: builtins.str | None = ...,
            window: builtins.bytes | None = ...,
            key: builtins.bytes | None = ...,
            map_key: builtins.bytes | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "map_key", b"map_key", "transform_id", b"transform_id", "user_state_id", b"user_state_id", "window", b"window"]) -> None: ...

    RUNNER_FIELD_NUMBER: builtins.int
    MULTIMAP_SIDE_INPUT_FIELD_NUMBER: builtins.int
    BAG_USER_STATE_FIELD_NUMBER: builtins.int
    ITERABLE_SIDE_INPUT_FIELD_NUMBER: builtins.int
    MULTIMAP_KEYS_SIDE_INPUT_FIELD_NUMBER: builtins.int
    MULTIMAP_KEYS_USER_STATE_FIELD_NUMBER: builtins.int
    MULTIMAP_USER_STATE_FIELD_NUMBER: builtins.int
    @property
    def runner(self) -> global___StateKey.Runner: ...
    @property
    def multimap_side_input(self) -> global___StateKey.MultimapSideInput: ...
    @property
    def bag_user_state(self) -> global___StateKey.BagUserState: ...
    @property
    def iterable_side_input(self) -> global___StateKey.IterableSideInput: ...
    @property
    def multimap_keys_side_input(self) -> global___StateKey.MultimapKeysSideInput: ...
    @property
    def multimap_keys_user_state(self) -> global___StateKey.MultimapKeysUserState: ...
    @property
    def multimap_user_state(self) -> global___StateKey.MultimapUserState: ...
    def __init__(
        self,
        *,
        runner: global___StateKey.Runner | None = ...,
        multimap_side_input: global___StateKey.MultimapSideInput | None = ...,
        bag_user_state: global___StateKey.BagUserState | None = ...,
        iterable_side_input: global___StateKey.IterableSideInput | None = ...,
        multimap_keys_side_input: global___StateKey.MultimapKeysSideInput | None = ...,
        multimap_keys_user_state: global___StateKey.MultimapKeysUserState | None = ...,
        multimap_user_state: global___StateKey.MultimapUserState | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["bag_user_state", b"bag_user_state", "iterable_side_input", b"iterable_side_input", "multimap_keys_side_input", b"multimap_keys_side_input", "multimap_keys_user_state", b"multimap_keys_user_state", "multimap_side_input", b"multimap_side_input", "multimap_user_state", b"multimap_user_state", "runner", b"runner", "type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["bag_user_state", b"bag_user_state", "iterable_side_input", b"iterable_side_input", "multimap_keys_side_input", b"multimap_keys_side_input", "multimap_keys_user_state", b"multimap_keys_user_state", "multimap_side_input", b"multimap_side_input", "multimap_user_state", b"multimap_user_state", "runner", b"runner", "type", b"type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["type", b"type"]) -> typing_extensions.Literal["runner", "multimap_side_input", "bag_user_state", "iterable_side_input", "multimap_keys_side_input", "multimap_keys_user_state", "multimap_user_state"] | None: ...

global___StateKey = StateKey

@typing_extensions.final
class StateGetRequest(google.protobuf.message.Message):
    """A request to get state."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTINUATION_TOKEN_FIELD_NUMBER: builtins.int
    continuation_token: builtins.bytes
    """(Optional) If specified, signals to the runner that the response
    should resume from the following continuation token.

    If unspecified, signals to the runner that the response should start
    from the beginning of the logical continuable stream.
    """
    def __init__(
        self,
        *,
        continuation_token: builtins.bytes | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["continuation_token", b"continuation_token"]) -> None: ...

global___StateGetRequest = StateGetRequest

@typing_extensions.final
class StateGetResponse(google.protobuf.message.Message):
    """A response to get state representing a logical byte stream which can be
    continued using the state API.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTINUATION_TOKEN_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    continuation_token: builtins.bytes
    """(Optional) If specified, represents a token which can be used with the
    state API to get the next chunk of this logical byte stream. The end of
    the logical byte stream is signalled by this field being unset.
    """
    data: builtins.bytes
    """Represents a part of a logical byte stream. Elements within
    the logical byte stream are encoded in the nested context and
    concatenated together.
    """
    def __init__(
        self,
        *,
        continuation_token: builtins.bytes | None = ...,
        data: builtins.bytes | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["continuation_token", b"continuation_token", "data", b"data"]) -> None: ...

global___StateGetResponse = StateGetResponse

@typing_extensions.final
class StateAppendRequest(google.protobuf.message.Message):
    """A request to append state."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATA_FIELD_NUMBER: builtins.int
    data: builtins.bytes
    """Represents a part of a logical byte stream. Elements within
    the logical byte stream are encoded in the nested context and
    multiple append requests are concatenated together.
    """
    def __init__(
        self,
        *,
        data: builtins.bytes | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["data", b"data"]) -> None: ...

global___StateAppendRequest = StateAppendRequest

@typing_extensions.final
class StateAppendResponse(google.protobuf.message.Message):
    """A response to append state."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___StateAppendResponse = StateAppendResponse

@typing_extensions.final
class StateClearRequest(google.protobuf.message.Message):
    """A request to clear state."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___StateClearRequest = StateClearRequest

@typing_extensions.final
class StateClearResponse(google.protobuf.message.Message):
    """A response to clear state."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___StateClearResponse = StateClearResponse

@typing_extensions.final
class LogEntry(google.protobuf.message.Message):
    """
    Logging API

    This is very stable. There can be some changes to how we define a LogEntry,
    to increase/decrease the severity types, the way we format an exception/stack
    trace, or the log site.

    A log entry
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class List(google.protobuf.message.Message):
        """A list of log entries, enables buffering and batching of multiple
        log messages using the logging API.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        LOG_ENTRIES_FIELD_NUMBER: builtins.int
        @property
        def log_entries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___LogEntry]:
            """(Required) One or or more log messages."""
        def __init__(
            self,
            *,
            log_entries: collections.abc.Iterable[global___LogEntry] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["log_entries", b"log_entries"]) -> None: ...

    @typing_extensions.final
    class Severity(google.protobuf.message.Message):
        """The severity of the event described in a log entry, expressed as one of the
        severity levels listed below. For your reference, the levels are
        assigned the listed numeric values. The effect of using numeric values
        other than those listed is undefined.

        If you are writing log entries, you should map other severity encodings to
        one of these standard levels. For example, you might map all of
        Java's FINE, FINER, and FINEST levels to `Severity.DEBUG`.

        This list is intentionally not comprehensive; the intent is to provide a
        common set of "good enough" severity levels so that logging front ends
        can provide filtering and searching across log types. Users of the API are
        free not to use all severity levels in their log messages.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _Enum:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _EnumEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[LogEntry.Severity._Enum.ValueType], builtins.type):  # noqa: F821
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            UNSPECIFIED: LogEntry.Severity._Enum.ValueType  # 0
            """Unspecified level information. Will be logged at the TRACE level."""
            TRACE: LogEntry.Severity._Enum.ValueType  # 1
            DEBUG: LogEntry.Severity._Enum.ValueType  # 2
            """Debugging information."""
            INFO: LogEntry.Severity._Enum.ValueType  # 3
            """Normal events."""
            NOTICE: LogEntry.Severity._Enum.ValueType  # 4
            """Normal but significant events, such as start up, shut down, or
            configuration.
            """
            WARN: LogEntry.Severity._Enum.ValueType  # 5
            """Warning events might cause problems."""
            ERROR: LogEntry.Severity._Enum.ValueType  # 6
            """Error events are likely to cause problems."""
            CRITICAL: LogEntry.Severity._Enum.ValueType  # 7
            """Critical events cause severe problems or brief outages and may
            indicate that a person must take action.
            """

        class Enum(_Enum, metaclass=_EnumEnumTypeWrapper): ...
        UNSPECIFIED: LogEntry.Severity.Enum.ValueType  # 0
        """Unspecified level information. Will be logged at the TRACE level."""
        TRACE: LogEntry.Severity.Enum.ValueType  # 1
        DEBUG: LogEntry.Severity.Enum.ValueType  # 2
        """Debugging information."""
        INFO: LogEntry.Severity.Enum.ValueType  # 3
        """Normal events."""
        NOTICE: LogEntry.Severity.Enum.ValueType  # 4
        """Normal but significant events, such as start up, shut down, or
        configuration.
        """
        WARN: LogEntry.Severity.Enum.ValueType  # 5
        """Warning events might cause problems."""
        ERROR: LogEntry.Severity.Enum.ValueType  # 6
        """Error events are likely to cause problems."""
        CRITICAL: LogEntry.Severity.Enum.ValueType  # 7
        """Critical events cause severe problems or brief outages and may
        indicate that a person must take action.
        """

        def __init__(
            self,
        ) -> None: ...

    SEVERITY_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    TRACE_FIELD_NUMBER: builtins.int
    INSTRUCTION_ID_FIELD_NUMBER: builtins.int
    TRANSFORM_ID_FIELD_NUMBER: builtins.int
    LOG_LOCATION_FIELD_NUMBER: builtins.int
    THREAD_FIELD_NUMBER: builtins.int
    CUSTOM_DATA_FIELD_NUMBER: builtins.int
    severity: global___LogEntry.Severity.Enum.ValueType
    """(Required) The severity of the log statement."""
    @property
    def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """(Required) The time at which this log statement occurred."""
    message: builtins.str
    """(Required) A human readable message."""
    trace: builtins.str
    """(Optional) An optional trace of the functions involved. For example, in
    Java this can include multiple causes and multiple suppressed exceptions.
    """
    instruction_id: builtins.str
    """(Optional) A reference to the instruction this log statement is associated
    with.
    """
    transform_id: builtins.str
    """(Optional) A reference to the transform this log statement is
    associated with.
    """
    log_location: builtins.str
    """(Optional) Human-readable name of the function or method being invoked,
    with optional context such as the class or package name. The format can
    vary by language. For example:
      qual.if.ied.Class.method (Java)
      dir/package.func (Go)
      module.function (Python)
      file.cc:382 (C++)
    """
    thread: builtins.str
    """(Optional) The name of the thread this log statement is associated with."""
    @property
    def custom_data(self) -> google.protobuf.struct_pb2.Struct:
        """(Optional) Additional structured data to log.
        Keys are limited to these characters: [a-zA-Z_-]
        """
    def __init__(
        self,
        *,
        severity: global___LogEntry.Severity.Enum.ValueType | None = ...,
        timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        message: builtins.str | None = ...,
        trace: builtins.str | None = ...,
        instruction_id: builtins.str | None = ...,
        transform_id: builtins.str | None = ...,
        log_location: builtins.str | None = ...,
        thread: builtins.str | None = ...,
        custom_data: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["custom_data", b"custom_data", "timestamp", b"timestamp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["custom_data", b"custom_data", "instruction_id", b"instruction_id", "log_location", b"log_location", "message", b"message", "severity", b"severity", "thread", b"thread", "timestamp", b"timestamp", "trace", b"trace", "transform_id", b"transform_id"]) -> None: ...

global___LogEntry = LogEntry

@typing_extensions.final
class LogControl(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___LogControl = LogControl

@typing_extensions.final
class StartWorkerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class ParamsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: builtins.str | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    WORKER_ID_FIELD_NUMBER: builtins.int
    CONTROL_ENDPOINT_FIELD_NUMBER: builtins.int
    LOGGING_ENDPOINT_FIELD_NUMBER: builtins.int
    ARTIFACT_ENDPOINT_FIELD_NUMBER: builtins.int
    PROVISION_ENDPOINT_FIELD_NUMBER: builtins.int
    PARAMS_FIELD_NUMBER: builtins.int
    worker_id: builtins.str
    @property
    def control_endpoint(self) -> org.apache.beam.model.pipeline.v1.endpoints_pb2.ApiServiceDescriptor: ...
    @property
    def logging_endpoint(self) -> org.apache.beam.model.pipeline.v1.endpoints_pb2.ApiServiceDescriptor: ...
    @property
    def artifact_endpoint(self) -> org.apache.beam.model.pipeline.v1.endpoints_pb2.ApiServiceDescriptor: ...
    @property
    def provision_endpoint(self) -> org.apache.beam.model.pipeline.v1.endpoints_pb2.ApiServiceDescriptor: ...
    @property
    def params(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]: ...
    def __init__(
        self,
        *,
        worker_id: builtins.str | None = ...,
        control_endpoint: org.apache.beam.model.pipeline.v1.endpoints_pb2.ApiServiceDescriptor | None = ...,
        logging_endpoint: org.apache.beam.model.pipeline.v1.endpoints_pb2.ApiServiceDescriptor | None = ...,
        artifact_endpoint: org.apache.beam.model.pipeline.v1.endpoints_pb2.ApiServiceDescriptor | None = ...,
        provision_endpoint: org.apache.beam.model.pipeline.v1.endpoints_pb2.ApiServiceDescriptor | None = ...,
        params: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["artifact_endpoint", b"artifact_endpoint", "control_endpoint", b"control_endpoint", "logging_endpoint", b"logging_endpoint", "provision_endpoint", b"provision_endpoint"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["artifact_endpoint", b"artifact_endpoint", "control_endpoint", b"control_endpoint", "logging_endpoint", b"logging_endpoint", "params", b"params", "provision_endpoint", b"provision_endpoint", "worker_id", b"worker_id"]) -> None: ...

global___StartWorkerRequest = StartWorkerRequest

@typing_extensions.final
class StartWorkerResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ERROR_FIELD_NUMBER: builtins.int
    error: builtins.str
    def __init__(
        self,
        *,
        error: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["error", b"error"]) -> None: ...

global___StartWorkerResponse = StartWorkerResponse

@typing_extensions.final
class StopWorkerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WORKER_ID_FIELD_NUMBER: builtins.int
    worker_id: builtins.str
    def __init__(
        self,
        *,
        worker_id: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["worker_id", b"worker_id"]) -> None: ...

global___StopWorkerRequest = StopWorkerRequest

@typing_extensions.final
class StopWorkerResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ERROR_FIELD_NUMBER: builtins.int
    error: builtins.str
    def __init__(
        self,
        *,
        error: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["error", b"error"]) -> None: ...

global___StopWorkerResponse = StopWorkerResponse

@typing_extensions.final
class WorkerStatusRequest(google.protobuf.message.Message):
    """Request from runner to SDK Harness asking for its status. For more details see
    https://s.apache.org/beam-fn-api-harness-status
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """(Required) Unique ID identifying this request."""
    def __init__(
        self,
        *,
        id: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id"]) -> None: ...

global___WorkerStatusRequest = WorkerStatusRequest

@typing_extensions.final
class WorkerStatusResponse(google.protobuf.message.Message):
    """Response from SDK Harness to runner containing the debug related status info."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    STATUS_INFO_FIELD_NUMBER: builtins.int
    id: builtins.str
    """(Required) Unique ID from the original request."""
    error: builtins.str
    """(Optional) Error message if exception encountered generating the status response."""
    status_info: builtins.str
    """(Optional) Status debugging info reported by SDK harness worker. Content and
    format is not strongly enforced but should be print-friendly and
    appropriate as an HTTP response body for end user. For details of the preferred
    info to include in the message see
    https://s.apache.org/beam-fn-api-harness-status
    """
    def __init__(
        self,
        *,
        id: builtins.str | None = ...,
        error: builtins.str | None = ...,
        status_info: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["error", b"error", "id", b"id", "status_info", b"status_info"]) -> None: ...

global___WorkerStatusResponse = WorkerStatusResponse
