"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

Protocol Buffers describing the Job API, api for communicating with a runner
for job submission over GRPC.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import google.protobuf.timestamp_pb2
import org.apache.beam.model.pipeline.v1.beam_runner_api_pb2
import org.apache.beam.model.pipeline.v1.endpoints_pb2
import org.apache.beam.model.pipeline.v1.metrics_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class PrepareJobRequest(google.protobuf.message.Message):
    """Prepare is a synchronous request that returns a preparationId back
    Throws error GRPC_STATUS_UNAVAILABLE if server is down
    Throws error ALREADY_EXISTS if the jobName is reused. Runners are permitted to deduplicate based on the name of the job.
    Throws error UNKNOWN for all other issues
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    PIPELINE_OPTIONS_FIELD_NUMBER: builtins.int
    JOB_NAME_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.Pipeline:
        """(required)"""
    @property
    def pipeline_options(self) -> google.protobuf.struct_pb2.Struct:
        """(required)"""
    job_name: builtins.str
    """(required)"""
    def __init__(
        self,
        *,
        pipeline: org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.Pipeline | None = ...,
        pipeline_options: google.protobuf.struct_pb2.Struct | None = ...,
        job_name: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline", "pipeline_options", b"pipeline_options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["job_name", b"job_name", "pipeline", b"pipeline", "pipeline_options", b"pipeline_options"]) -> None: ...

global___PrepareJobRequest = PrepareJobRequest

@typing_extensions.final
class PrepareJobResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PREPARATION_ID_FIELD_NUMBER: builtins.int
    ARTIFACT_STAGING_ENDPOINT_FIELD_NUMBER: builtins.int
    STAGING_SESSION_TOKEN_FIELD_NUMBER: builtins.int
    preparation_id: builtins.str
    """(required) The ID used to associate calls made while preparing the job. preparationId is used
    to run the job.
    """
    @property
    def artifact_staging_endpoint(self) -> org.apache.beam.model.pipeline.v1.endpoints_pb2.ApiServiceDescriptor:
        """An endpoint which exposes the Beam Artifact Staging API. Artifacts used by the job should be
        staged to this endpoint, and will be available during job execution.
        """
    staging_session_token: builtins.str
    """(required) Token for the artifact staging. This token also represent an artifact
    staging session with the artifact staging service.
    """
    def __init__(
        self,
        *,
        preparation_id: builtins.str | None = ...,
        artifact_staging_endpoint: org.apache.beam.model.pipeline.v1.endpoints_pb2.ApiServiceDescriptor | None = ...,
        staging_session_token: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["artifact_staging_endpoint", b"artifact_staging_endpoint"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["artifact_staging_endpoint", b"artifact_staging_endpoint", "preparation_id", b"preparation_id", "staging_session_token", b"staging_session_token"]) -> None: ...

global___PrepareJobResponse = PrepareJobResponse

@typing_extensions.final
class RunJobRequest(google.protobuf.message.Message):
    """Run is a synchronous request that returns a jobId back.
    Throws error GRPC_STATUS_UNAVAILABLE if server is down
    Throws error NOT_FOUND if the preparation ID does not exist
    Throws error UNKNOWN for all other issues
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PREPARATION_ID_FIELD_NUMBER: builtins.int
    RETRIEVAL_TOKEN_FIELD_NUMBER: builtins.int
    preparation_id: builtins.str
    """(required) The ID provided by an earlier call to prepare. Runs the job. All prerequisite tasks
    must have been completed.
    """
    retrieval_token: builtins.str
    """(optional) If any artifacts have been staged for this job, contains the retrieval_token returned
    from the CommitManifestResponse.
    """
    def __init__(
        self,
        *,
        preparation_id: builtins.str | None = ...,
        retrieval_token: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["preparation_id", b"preparation_id", "retrieval_token", b"retrieval_token"]) -> None: ...

global___RunJobRequest = RunJobRequest

@typing_extensions.final
class RunJobResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JOB_ID_FIELD_NUMBER: builtins.int
    job_id: builtins.str
    """(required) The ID for the executing job"""
    def __init__(
        self,
        *,
        job_id: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["job_id", b"job_id"]) -> None: ...

global___RunJobResponse = RunJobResponse

@typing_extensions.final
class CancelJobRequest(google.protobuf.message.Message):
    """Cancel is a synchronus request that returns a job state back
    Throws error GRPC_STATUS_UNAVAILABLE if server is down
    Throws error NOT_FOUND if the jobId is not found
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JOB_ID_FIELD_NUMBER: builtins.int
    job_id: builtins.str
    """(required)"""
    def __init__(
        self,
        *,
        job_id: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["job_id", b"job_id"]) -> None: ...

global___CancelJobRequest = CancelJobRequest

@typing_extensions.final
class CancelJobResponse(google.protobuf.message.Message):
    """Valid responses include any terminal state or CANCELLING"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATE_FIELD_NUMBER: builtins.int
    state: global___JobState.Enum.ValueType
    """(required)"""
    def __init__(
        self,
        *,
        state: global___JobState.Enum.ValueType | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["state", b"state"]) -> None: ...

global___CancelJobResponse = CancelJobResponse

@typing_extensions.final
class JobInfo(google.protobuf.message.Message):
    """A subset of info provided by ProvisionApi.ProvisionInfo"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JOB_ID_FIELD_NUMBER: builtins.int
    JOB_NAME_FIELD_NUMBER: builtins.int
    PIPELINE_OPTIONS_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    job_id: builtins.str
    """(required)"""
    job_name: builtins.str
    """(required)"""
    @property
    def pipeline_options(self) -> google.protobuf.struct_pb2.Struct:
        """(required)"""
    state: global___JobState.Enum.ValueType
    """(required)"""
    def __init__(
        self,
        *,
        job_id: builtins.str | None = ...,
        job_name: builtins.str | None = ...,
        pipeline_options: google.protobuf.struct_pb2.Struct | None = ...,
        state: global___JobState.Enum.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline_options", b"pipeline_options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["job_id", b"job_id", "job_name", b"job_name", "pipeline_options", b"pipeline_options", "state", b"state"]) -> None: ...

global___JobInfo = JobInfo

@typing_extensions.final
class GetJobsRequest(google.protobuf.message.Message):
    """GetJobs is a synchronus request that returns a list of invoked jobs back
    Throws error GRPC_STATUS_UNAVAILABLE if server is down
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___GetJobsRequest = GetJobsRequest

@typing_extensions.final
class GetJobsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JOB_INFO_FIELD_NUMBER: builtins.int
    @property
    def job_info(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___JobInfo]:
        """(required)"""
    def __init__(
        self,
        *,
        job_info: collections.abc.Iterable[global___JobInfo] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["job_info", b"job_info"]) -> None: ...

global___GetJobsResponse = GetJobsResponse

@typing_extensions.final
class GetJobStateRequest(google.protobuf.message.Message):
    """GetState is a synchronus request that returns a job state back
    Throws error GRPC_STATUS_UNAVAILABLE if server is down
    Throws error NOT_FOUND if the jobId is not found
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JOB_ID_FIELD_NUMBER: builtins.int
    job_id: builtins.str
    """(required)"""
    def __init__(
        self,
        *,
        job_id: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["job_id", b"job_id"]) -> None: ...

global___GetJobStateRequest = GetJobStateRequest

@typing_extensions.final
class JobStateEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATE_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    state: global___JobState.Enum.ValueType
    """(required)"""
    @property
    def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """(required)"""
    def __init__(
        self,
        *,
        state: global___JobState.Enum.ValueType | None = ...,
        timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["timestamp", b"timestamp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["state", b"state", "timestamp", b"timestamp"]) -> None: ...

global___JobStateEvent = JobStateEvent

@typing_extensions.final
class GetJobPipelineRequest(google.protobuf.message.Message):
    """GetPipeline is a synchronus request that returns a pipeline back
    Throws error GRPC_STATUS_UNAVAILABLE if server is down
    Throws error NOT_FOUND if the jobId is not found
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JOB_ID_FIELD_NUMBER: builtins.int
    job_id: builtins.str
    """(required)"""
    def __init__(
        self,
        *,
        job_id: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["job_id", b"job_id"]) -> None: ...

global___GetJobPipelineRequest = GetJobPipelineRequest

@typing_extensions.final
class GetJobPipelineResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.Pipeline:
        """(required)"""
    def __init__(
        self,
        *,
        pipeline: org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___GetJobPipelineResponse = GetJobPipelineResponse

@typing_extensions.final
class JobMessagesRequest(google.protobuf.message.Message):
    """GetJobMessages is a streaming api for streaming job messages from the service
    One request will connect you to the job and you'll get a stream of job state
    and job messages back; one is used for logging and the other for detecting
    the job ended.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JOB_ID_FIELD_NUMBER: builtins.int
    job_id: builtins.str
    """(required)"""
    def __init__(
        self,
        *,
        job_id: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["job_id", b"job_id"]) -> None: ...

global___JobMessagesRequest = JobMessagesRequest

@typing_extensions.final
class JobMessage(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _MessageImportance:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _MessageImportanceEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[JobMessage._MessageImportance.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        MESSAGE_IMPORTANCE_UNSPECIFIED: JobMessage._MessageImportance.ValueType  # 0
        JOB_MESSAGE_DEBUG: JobMessage._MessageImportance.ValueType  # 1
        JOB_MESSAGE_DETAILED: JobMessage._MessageImportance.ValueType  # 2
        JOB_MESSAGE_BASIC: JobMessage._MessageImportance.ValueType  # 3
        JOB_MESSAGE_WARNING: JobMessage._MessageImportance.ValueType  # 4
        JOB_MESSAGE_ERROR: JobMessage._MessageImportance.ValueType  # 5

    class MessageImportance(_MessageImportance, metaclass=_MessageImportanceEnumTypeWrapper): ...
    MESSAGE_IMPORTANCE_UNSPECIFIED: JobMessage.MessageImportance.ValueType  # 0
    JOB_MESSAGE_DEBUG: JobMessage.MessageImportance.ValueType  # 1
    JOB_MESSAGE_DETAILED: JobMessage.MessageImportance.ValueType  # 2
    JOB_MESSAGE_BASIC: JobMessage.MessageImportance.ValueType  # 3
    JOB_MESSAGE_WARNING: JobMessage.MessageImportance.ValueType  # 4
    JOB_MESSAGE_ERROR: JobMessage.MessageImportance.ValueType  # 5

    MESSAGE_ID_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    IMPORTANCE_FIELD_NUMBER: builtins.int
    MESSAGE_TEXT_FIELD_NUMBER: builtins.int
    message_id: builtins.str
    time: builtins.str
    importance: global___JobMessage.MessageImportance.ValueType
    message_text: builtins.str
    def __init__(
        self,
        *,
        message_id: builtins.str | None = ...,
        time: builtins.str | None = ...,
        importance: global___JobMessage.MessageImportance.ValueType | None = ...,
        message_text: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["importance", b"importance", "message_id", b"message_id", "message_text", b"message_text", "time", b"time"]) -> None: ...

global___JobMessage = JobMessage

@typing_extensions.final
class JobMessagesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESSAGE_RESPONSE_FIELD_NUMBER: builtins.int
    STATE_RESPONSE_FIELD_NUMBER: builtins.int
    @property
    def message_response(self) -> global___JobMessage: ...
    @property
    def state_response(self) -> global___JobStateEvent: ...
    def __init__(
        self,
        *,
        message_response: global___JobMessage | None = ...,
        state_response: global___JobStateEvent | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["message_response", b"message_response", "response", b"response", "state_response", b"state_response"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["message_response", b"message_response", "response", b"response", "state_response", b"state_response"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["response", b"response"]) -> typing_extensions.Literal["message_response", "state_response"] | None: ...

global___JobMessagesResponse = JobMessagesResponse

@typing_extensions.final
class JobState(google.protobuf.message.Message):
    """Enumeration of all JobStates

    The state transition diagram is:
      STOPPED -> STARTING -> RUNNING -> DONE
                                     \\> FAILED
                                     \\> CANCELLING -> CANCELLED
                                     \\> UPDATING -> UPDATED
                                     \\> DRAINING -> DRAINED

    Transitions are optional such that a job may go from STOPPED to RUNNING
    without needing to pass through STARTING.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Enum:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnumEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[JobState._Enum.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNSPECIFIED: JobState._Enum.ValueType  # 0
        """The job state reported by a runner cannot be interpreted by the SDK."""
        STOPPED: JobState._Enum.ValueType  # 1
        """The job has not yet started."""
        RUNNING: JobState._Enum.ValueType  # 2
        """The job is currently running."""
        DONE: JobState._Enum.ValueType  # 3
        """The job has successfully completed. (terminal)"""
        FAILED: JobState._Enum.ValueType  # 4
        """The job has failed. (terminal)"""
        CANCELLED: JobState._Enum.ValueType  # 5
        """The job has been explicitly cancelled. (terminal)"""
        UPDATED: JobState._Enum.ValueType  # 6
        """The job has been updated. (terminal)"""
        DRAINING: JobState._Enum.ValueType  # 7
        """The job is draining its data. (optional)"""
        DRAINED: JobState._Enum.ValueType  # 8
        """The job has completed draining its data. (terminal)"""
        STARTING: JobState._Enum.ValueType  # 9
        """The job is starting up."""
        CANCELLING: JobState._Enum.ValueType  # 10
        """The job is cancelling. (optional)"""
        UPDATING: JobState._Enum.ValueType  # 11
        """The job is in the process of being updated. (optional)"""

    class Enum(_Enum, metaclass=_EnumEnumTypeWrapper): ...
    UNSPECIFIED: JobState.Enum.ValueType  # 0
    """The job state reported by a runner cannot be interpreted by the SDK."""
    STOPPED: JobState.Enum.ValueType  # 1
    """The job has not yet started."""
    RUNNING: JobState.Enum.ValueType  # 2
    """The job is currently running."""
    DONE: JobState.Enum.ValueType  # 3
    """The job has successfully completed. (terminal)"""
    FAILED: JobState.Enum.ValueType  # 4
    """The job has failed. (terminal)"""
    CANCELLED: JobState.Enum.ValueType  # 5
    """The job has been explicitly cancelled. (terminal)"""
    UPDATED: JobState.Enum.ValueType  # 6
    """The job has been updated. (terminal)"""
    DRAINING: JobState.Enum.ValueType  # 7
    """The job is draining its data. (optional)"""
    DRAINED: JobState.Enum.ValueType  # 8
    """The job has completed draining its data. (terminal)"""
    STARTING: JobState.Enum.ValueType  # 9
    """The job is starting up."""
    CANCELLING: JobState.Enum.ValueType  # 10
    """The job is cancelling. (optional)"""
    UPDATING: JobState.Enum.ValueType  # 11
    """The job is in the process of being updated. (optional)"""

    def __init__(
        self,
    ) -> None: ...

global___JobState = JobState

@typing_extensions.final
class GetJobMetricsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JOB_ID_FIELD_NUMBER: builtins.int
    job_id: builtins.str
    """(required)"""
    def __init__(
        self,
        *,
        job_id: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["job_id", b"job_id"]) -> None: ...

global___GetJobMetricsRequest = GetJobMetricsRequest

@typing_extensions.final
class GetJobMetricsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    METRICS_FIELD_NUMBER: builtins.int
    @property
    def metrics(self) -> global___MetricResults: ...
    def __init__(
        self,
        *,
        metrics: global___MetricResults | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["metrics", b"metrics"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["metrics", b"metrics"]) -> None: ...

global___GetJobMetricsResponse = GetJobMetricsResponse

@typing_extensions.final
class MetricResults(google.protobuf.message.Message):
    """All metrics for a given job.  Runners may support one or the other or both."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ATTEMPTED_FIELD_NUMBER: builtins.int
    COMMITTED_FIELD_NUMBER: builtins.int
    @property
    def attempted(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[org.apache.beam.model.pipeline.v1.metrics_pb2.MonitoringInfo]: ...
    @property
    def committed(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[org.apache.beam.model.pipeline.v1.metrics_pb2.MonitoringInfo]: ...
    def __init__(
        self,
        *,
        attempted: collections.abc.Iterable[org.apache.beam.model.pipeline.v1.metrics_pb2.MonitoringInfo] | None = ...,
        committed: collections.abc.Iterable[org.apache.beam.model.pipeline.v1.metrics_pb2.MonitoringInfo] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["attempted", b"attempted", "committed", b"committed"]) -> None: ...

global___MetricResults = MetricResults

@typing_extensions.final
class DescribePipelineOptionsRequest(google.protobuf.message.Message):
    """DescribePipelineOptions provides metadata about the options supported by a runner.
    It will be used by the SDK client to validate the options specified by or
    list available options to the user.
    Throws error GRPC_STATUS_UNAVAILABLE if server is down
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DescribePipelineOptionsRequest = DescribePipelineOptionsRequest

@typing_extensions.final
class PipelineOptionType(google.protobuf.message.Message):
    """Type for pipeline options.
    Types mirror those of JSON, since that's how pipeline options are serialized.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Enum:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnumEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[PipelineOptionType._Enum.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STRING: PipelineOptionType._Enum.ValueType  # 0
        BOOLEAN: PipelineOptionType._Enum.ValueType  # 1
        INTEGER: PipelineOptionType._Enum.ValueType  # 2
        """whole numbers, see https://json-schema.org/understanding-json-schema/reference/numeric.html"""
        NUMBER: PipelineOptionType._Enum.ValueType  # 3
        ARRAY: PipelineOptionType._Enum.ValueType  # 4
        OBJECT: PipelineOptionType._Enum.ValueType  # 5

    class Enum(_Enum, metaclass=_EnumEnumTypeWrapper): ...
    STRING: PipelineOptionType.Enum.ValueType  # 0
    BOOLEAN: PipelineOptionType.Enum.ValueType  # 1
    INTEGER: PipelineOptionType.Enum.ValueType  # 2
    """whole numbers, see https://json-schema.org/understanding-json-schema/reference/numeric.html"""
    NUMBER: PipelineOptionType.Enum.ValueType  # 3
    ARRAY: PipelineOptionType.Enum.ValueType  # 4
    OBJECT: PipelineOptionType.Enum.ValueType  # 5

    def __init__(
        self,
    ) -> None: ...

global___PipelineOptionType = PipelineOptionType

@typing_extensions.final
class PipelineOptionDescriptor(google.protobuf.message.Message):
    """Metadata for a pipeline option."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    DEFAULT_VALUE_FIELD_NUMBER: builtins.int
    GROUP_FIELD_NUMBER: builtins.int
    name: builtins.str
    """(Required) The option name."""
    type: global___PipelineOptionType.Enum.ValueType
    """(Required) Type of option."""
    description: builtins.str
    """(Optional) Description suitable for display / help text."""
    default_value: builtins.str
    """(Optional) Default value."""
    group: builtins.str
    """(Required) The group this option belongs to."""
    def __init__(
        self,
        *,
        name: builtins.str | None = ...,
        type: global___PipelineOptionType.Enum.ValueType | None = ...,
        description: builtins.str | None = ...,
        default_value: builtins.str | None = ...,
        group: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["default_value", b"default_value", "description", b"description", "group", b"group", "name", b"name", "type", b"type"]) -> None: ...

global___PipelineOptionDescriptor = PipelineOptionDescriptor

@typing_extensions.final
class DescribePipelineOptionsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPTIONS_FIELD_NUMBER: builtins.int
    @property
    def options(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PipelineOptionDescriptor]:
        """List of pipeline option descriptors."""
    def __init__(
        self,
        *,
        options: collections.abc.Iterable[global___PipelineOptionDescriptor] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["options", b"options"]) -> None: ...

global___DescribePipelineOptionsResponse = DescribePipelineOptionsResponse
