"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

Protocol Buffers describing the Runner API, which is the runner-independent,
SDK-independent definition of the Beam model.
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class GlobalWindowsPayload(google.protobuf.message.Message):
    """By default, all data in a PCollection is assigned to the single global
    window. See BeamConstants for the time span this window encompasses.

    See https://beam.apache.org/documentation/programming-guide/#single-global-window
    for additional details.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Enum:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnumEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[GlobalWindowsPayload._Enum.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PROPERTIES: GlobalWindowsPayload._Enum.ValueType  # 0

    class Enum(_Enum, metaclass=_EnumEnumTypeWrapper): ...
    PROPERTIES: GlobalWindowsPayload.Enum.ValueType  # 0

    def __init__(
        self,
    ) -> None: ...

global___GlobalWindowsPayload = GlobalWindowsPayload

@typing_extensions.final
class FixedWindowsPayload(google.protobuf.message.Message):
    """A fixed time window represents a consistent duration size, non overlapping
    time interval in the data stream.

    See https://beam.apache.org/documentation/programming-guide/#fixed-time-windows
    for additional details.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Enum:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnumEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[FixedWindowsPayload._Enum.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PROPERTIES: FixedWindowsPayload._Enum.ValueType  # 0

    class Enum(_Enum, metaclass=_EnumEnumTypeWrapper): ...
    PROPERTIES: FixedWindowsPayload.Enum.ValueType  # 0

    SIZE_FIELD_NUMBER: builtins.int
    OFFSET_FIELD_NUMBER: builtins.int
    @property
    def size(self) -> google.protobuf.duration_pb2.Duration:
        """(Required) Represents the size of the window."""
    @property
    def offset(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """(Required) Represents the timestamp of when the first window begins.
        Window N will start at offset + N * size.
        """
    def __init__(
        self,
        *,
        size: google.protobuf.duration_pb2.Duration | None = ...,
        offset: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["offset", b"offset", "size", b"size"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["offset", b"offset", "size", b"size"]) -> None: ...

global___FixedWindowsPayload = FixedWindowsPayload

@typing_extensions.final
class SlidingWindowsPayload(google.protobuf.message.Message):
    """A sliding time window represents time intervals in the data stream that can
    overlap. For example, each window might capture 60 seconds worth of data, but
    a new window starts every 30 seconds. The frequency with which sliding
    windows begin is called the period. Therefore, our example would have a
    window size of 60 seconds and a period of 30 seconds.

    Because multiple windows overlap, most elements in a data set will belong to
    more than one window. This kind of windowing is useful for taking running
    averages of data; using sliding time windows, you can compute a running
    average of the past 60 seconds’ worth of data, updated every 30 seconds, in
    our example.

    See https://beam.apache.org/documentation/programming-guide/#sliding-time-windows
    for additional details.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Enum:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnumEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SlidingWindowsPayload._Enum.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PROPERTIES: SlidingWindowsPayload._Enum.ValueType  # 0

    class Enum(_Enum, metaclass=_EnumEnumTypeWrapper): ...
    PROPERTIES: SlidingWindowsPayload.Enum.ValueType  # 0

    SIZE_FIELD_NUMBER: builtins.int
    OFFSET_FIELD_NUMBER: builtins.int
    PERIOD_FIELD_NUMBER: builtins.int
    @property
    def size(self) -> google.protobuf.duration_pb2.Duration:
        """(Required) Represents the size of the window."""
    @property
    def offset(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """(Required) Represents the timestamp of when the first window begins.
        Window N will start at offset + N * period.
        """
    @property
    def period(self) -> google.protobuf.duration_pb2.Duration:
        """(Required) Represents the amount of time between each start of a window."""
    def __init__(
        self,
        *,
        size: google.protobuf.duration_pb2.Duration | None = ...,
        offset: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        period: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["offset", b"offset", "period", b"period", "size", b"size"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["offset", b"offset", "period", b"period", "size", b"size"]) -> None: ...

global___SlidingWindowsPayload = SlidingWindowsPayload

@typing_extensions.final
class SessionWindowsPayload(google.protobuf.message.Message):
    """A session window function defines windows that contain elements that are
    within a certain gap size of another element. Session windowing applies
    on a per-key basis and is useful for data that is irregularly distributed
    with respect to time. For example, a data stream representing user mouse
    activity may have long periods of idle time interspersed with high
    concentrations of clicks. If data arrives after the minimum specified gap
    size duration, this initiates the start of a new window.

    See https://beam.apache.org/documentation/programming-guide/#session-windows
    for additional details.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Enum:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnumEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SessionWindowsPayload._Enum.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PROPERTIES: SessionWindowsPayload._Enum.ValueType  # 0

    class Enum(_Enum, metaclass=_EnumEnumTypeWrapper): ...
    PROPERTIES: SessionWindowsPayload.Enum.ValueType  # 0

    GAP_SIZE_FIELD_NUMBER: builtins.int
    @property
    def gap_size(self) -> google.protobuf.duration_pb2.Duration:
        """(Required) Minimum duration of gaps between sessions."""
    def __init__(
        self,
        *,
        gap_size: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["gap_size", b"gap_size"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["gap_size", b"gap_size"]) -> None: ...

global___SessionWindowsPayload = SessionWindowsPayload
