# Copyright 2020 StrongDM Inc
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#     http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# 
# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from . import secret_store_healths_pb2 as secret__store__healths__pb2


class SecretStoreHealthsStub(object):
    """SecretStoreHealths exposes health states for secret stores.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.List = channel.unary_unary(
                '/v1.SecretStoreHealths/List',
                request_serializer=secret__store__healths__pb2.SecretStoreHealthListRequest.SerializeToString,
                response_deserializer=secret__store__healths__pb2.SecretStoreHealthListResponse.FromString,
                )
        self.Check = channel.unary_unary(
                '/v1.SecretStoreHealths/Check',
                request_serializer=secret__store__healths__pb2.SecretStoreHealthCheckRequest.SerializeToString,
                response_deserializer=secret__store__healths__pb2.SecretStoreHealthCheckResponse.FromString,
                )
        self.Healthcheck = channel.unary_unary(
                '/v1.SecretStoreHealths/Healthcheck',
                request_serializer=secret__store__healths__pb2.SecretStoreHealthcheckRequest.SerializeToString,
                response_deserializer=secret__store__healths__pb2.SecretStoreHealthcheckResponse.FromString,
                )


class SecretStoreHealthsServicer(object):
    """SecretStoreHealths exposes health states for secret stores.
    """

    def List(self, request, context):
        """List reports the health status of node to secret store pairs.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Check(self, request, context):
        """Check pushes a healthcheck request for a secret store
        Deprecated: use Healthcheck instead
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Healthcheck(self, request, context):
        """Healthcheck triggers a remote healthcheck request for a secret store. It may take minutes
        to propagate across a large network of Nodes. The call will return immediately, and the
        updated health of the Secret Store can be retrieved via List.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_SecretStoreHealthsServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'List': grpc.unary_unary_rpc_method_handler(
                    servicer.List,
                    request_deserializer=secret__store__healths__pb2.SecretStoreHealthListRequest.FromString,
                    response_serializer=secret__store__healths__pb2.SecretStoreHealthListResponse.SerializeToString,
            ),
            'Check': grpc.unary_unary_rpc_method_handler(
                    servicer.Check,
                    request_deserializer=secret__store__healths__pb2.SecretStoreHealthCheckRequest.FromString,
                    response_serializer=secret__store__healths__pb2.SecretStoreHealthCheckResponse.SerializeToString,
            ),
            'Healthcheck': grpc.unary_unary_rpc_method_handler(
                    servicer.Healthcheck,
                    request_deserializer=secret__store__healths__pb2.SecretStoreHealthcheckRequest.FromString,
                    response_serializer=secret__store__healths__pb2.SecretStoreHealthcheckResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'v1.SecretStoreHealths', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class SecretStoreHealths(object):
    """SecretStoreHealths exposes health states for secret stores.
    """

    @staticmethod
    def List(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.SecretStoreHealths/List',
            secret__store__healths__pb2.SecretStoreHealthListRequest.SerializeToString,
            secret__store__healths__pb2.SecretStoreHealthListResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Check(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.SecretStoreHealths/Check',
            secret__store__healths__pb2.SecretStoreHealthCheckRequest.SerializeToString,
            secret__store__healths__pb2.SecretStoreHealthCheckResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Healthcheck(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.SecretStoreHealths/Healthcheck',
            secret__store__healths__pb2.SecretStoreHealthcheckRequest.SerializeToString,
            secret__store__healths__pb2.SecretStoreHealthcheckResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
