# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class PlatformProperties(Model):
    """The platform properties against which the build has to happen.

    All required parameters must be populated in order to send to Azure.

    :param os_type: Required. The operating system type required for the
     build. Possible values include: 'Windows', 'Linux'
    :type os_type: str or
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.OsType
    :param cpu: The CPU configuration in terms of number of cores required for
     the build.
    :type cpu: int
    """

    _validation = {
        'os_type': {'required': True},
    }

    _attribute_map = {
        'os_type': {'key': 'osType', 'type': 'str'},
        'cpu': {'key': 'cpu', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(PlatformProperties, self).__init__(**kwargs)
        self.os_type = kwargs.get('os_type', None)
        self.cpu = kwargs.get('cpu', None)
