# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SourceRepositoryProperties(Model):
    """The properties of the source code repository.

    All required parameters must be populated in order to send to Azure.

    :param source_control_type: Required. The type of source control service.
     Possible values include: 'Github', 'VisualStudioTeamService'
    :type source_control_type: str or
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.SourceControlType
    :param repository_url: Required. The full URL to the source code
     respository
    :type repository_url: str
    :param is_commit_trigger_enabled: The value of this property indicates
     whether the source control commit trigger is enabled or not. Default
     value: False .
    :type is_commit_trigger_enabled: bool
    :param source_control_auth_properties: The authorization properties for
     accessing the source code repository.
    :type source_control_auth_properties:
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.SourceControlAuthInfo
    """

    _validation = {
        'source_control_type': {'required': True},
        'repository_url': {'required': True},
    }

    _attribute_map = {
        'source_control_type': {'key': 'sourceControlType', 'type': 'str'},
        'repository_url': {'key': 'repositoryUrl', 'type': 'str'},
        'is_commit_trigger_enabled': {'key': 'isCommitTriggerEnabled', 'type': 'bool'},
        'source_control_auth_properties': {'key': 'sourceControlAuthProperties', 'type': 'SourceControlAuthInfo'},
    }

    def __init__(self, **kwargs):
        super(SourceRepositoryProperties, self).__init__(**kwargs)
        self.source_control_type = kwargs.get('source_control_type', None)
        self.repository_url = kwargs.get('repository_url', None)
        self.is_commit_trigger_enabled = kwargs.get('is_commit_trigger_enabled', False)
        self.source_control_auth_properties = kwargs.get('source_control_auth_properties', None)
