# Konfuzio SDK

The Konfuzio Software Development Kit (Konfuzio SDK) provides a [Python API](https://dev.konfuzio.com/sdk/sourcecode.html) to interact with the 
[Konfuzio Server](https://dev.konfuzio.com/index.html#konfuzio-server).

## Quickstart

You can use pip to install Konfuzio SDK.

  `pip install konfuzio_sdk`

You need to initialize it with your credentials. You can register a free account [here](https://app.konfuzio.com/accounts/signup/).

  `konfuzio_sdk init`

Find the full installation guide [here](https://dev.konfuzio.com/sdk/configuration_reference.html)
or setup PyCharm as described [here](https://dev.konfuzio.com/sdk/quickstart_pycharm.html).


## Tutorials

- [Example Usage](https://dev.konfuzio.com/sdk/examples/examples.html): Some examples of the basic Konfuzio SDK functionalities.
- [Create Regex-based Annotations](https://dev.konfuzio.com/sdk/examples/examples.html#create-regex-based-annotations)
: An example of how to create regex-based annotations in a Konfuzio project.
- [Retrain Flair NER-Ontonotes-Fast with Human Revised Annotations](https://dev.konfuzio.com/sdk/examples/examples.html#retrain-flair-ner-ontonotes-fast-with-human-revised-annotations) [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/konfuzio-ai/document-ai-python-sdk/blob/master/docs/sdk/examples/human_in_the_loop.ipynb): An example of how Konfuzio SDK package can be used in a pipeline to have an easy feedback workflow can be seen in this tutorial
- [Count Relevant Expressions in Annual Reports](https://dev.konfuzio.com/sdk/examples/examples.html#count-relevant-expressions-in-annual-reports) [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/konfuzio-ai/document-ai-python-sdk/blob/master/docs/sdk/examples/word_count.ipynb): An example of how to retrieve structured and organized information from documents.


## References

- [Konfuzio SDK Python API - Source Code](https://dev.konfuzio.com/sdk/sourcecode.html)
- [Konfuzio Server REST API](https://app.konfuzio.com/v2/swagger/)
- [How to Contribute](https://dev.konfuzio.com/sdk/contribution.html)
- [Issue Tracker](https://github.com/konfuzio-ai/document-ai-python-sdk/issues)
- [MIT License](https://github.com/konfuzio-ai/document-ai-python-sdk/blob/master/LICENSE.md)
- [Konfuzio Homepage](https://www.konfuzio.com/en/)
