"use strict";
// Transcrypt'ed from Python, 2016-06-10 11:00:47
function pong () {
	var __all__ = {};
	var __world__ = __all__;
	
	// Nested object creator, part of the nesting may already exist and have attributes
	var __nest__ = function (headObject, tailNames, value) {
		// In some cases this will be a global object, e.g. 'window'
		var current = headObject;
		
		if (tailNames != '') {	// Split on empty string doesn't give empty list
			// Find the last already created object in tailNames
			var tailChain = tailNames.split ('.');
			var firstNewIndex = tailChain.length;
			for (var index = 0; index < tailChain.length; index++) {
				if (!current.hasOwnProperty (tailChain [index])) {
					firstNewIndex = index;
					break;
				}
				current = current [tailChain [index]];
			}
			
			// Create the rest of the objects, if any
			for (var index = firstNewIndex; index < tailChain.length; index++) {
				current [tailChain [index]] = {};
				current = current [tailChain [index]];
			}
		}
		
		// Insert it new attributes, it may have been created earlier and have other attributes
		for (var attrib in value) {
			current [attrib] = value [attrib];			
		}		
	};
	__all__.__nest__ = __nest__;
	
	// Initialize module if not yet done and return its globals
	var __init__ = function (module) {
		if (!module.__inited__) {
			module.__all__.__init__ (module.__all__);
			module.__inited__ = true;
		}
		return module.__all__;
	};
	__all__.__init__ = __init__;
	
	// Since we want to assign functions, a = b.f should make b.f produce a bound function
	// So __get__ should be called by a property rather then a function
	// Factory __get__ creates one of three curried functions for func
	// Which one is produced depends on what's to the left of the dot of the corresponding JavaScript property
	var __get__ = function (self, func, quotedFuncName) {
		if (self) {
			if (self.hasOwnProperty ('__class__') || typeof self == 'string' || self instanceof String) {			// Object before the dot
				if (quotedFuncName) {									// Memoize call since fcall is on, by installing bound function in instance
					Object.defineProperty (self, quotedFuncName, {		// Will override the non-own property, next time it will be called directly
						value: function () {							// So next time just call curry function that calls function
							var args = [] .slice.apply (arguments);
							return func.apply (null, [self] .concat (args));
						},				
						writable: true,
						enumerable: true,
						configurable: true
					});
				}
				return function () {									// Return bound function, code dupplication for efficiency if no memoizing
					var args = [] .slice.apply (arguments);				// So multilayer search prototype, apply __get__, call curry func that calls func
					return func.apply (null, [self] .concat (args));
				};
			}
			else {														// Class before the dot
				return func;											// Return static method
			}
		}
		else {															// Nothing before the dot
			return func;												// Return free function
		}
	}
	__all__.__get__ = __get__;
			
	// Class creator function
	var __class__ = function (name, bases, extra) {
		// Create class functor
		var cls = function () {
			var args = [] .slice.apply (arguments);
			return cls.__new__ (args);
		};
		
		// Copy methods, properties and static attributes from base classes to new class object
		for (var index = bases.length - 1; index >= 0; index--) {	// Reversed order, since class vars of first base should win
			var base = bases [index];
			for (var attrib in base) {
				var descrip = Object.getOwnPropertyDescriptor (base, attrib);
				Object.defineProperty (cls, attrib, descrip);
			}
		}
		
		// Add class specific attributes to class object
		cls.__name__ = name;
		cls.__bases__ = bases;
		
		// Add own methods, properties and static attributes to class object
		for (var attrib in extra) {
			var descrip = Object.getOwnPropertyDescriptor (extra, attrib);
			Object.defineProperty (cls, attrib, descrip);
		}
				
		// Return class object
		return cls;
	};
	__all__.__class__ = __class__;

	// Create mother of all classes		
	var object = __all__.__class__ ('object', [], {
		__init__: function (self) {},
			
		__name__: 'object',
		__bases__: [],
			
		// Object creator function is inherited by all classes (??? Make global?)
		__new__: function (args) {	// Args are just the constructor args		
			// In JavaScript the Python class is the prototype of the Python object
			// In this way methods and static attributes will be available both with a class and an object before the dot
			// The descriptor produced by __get__ will return the right method flavor
			var instance = Object.create (this, {__class__: {value: this, enumerable: true}});
			
			// Call constructor
			this.__init__.apply (null, [instance] .concat (args));
			
			// Return instance			
			return instance;
		}	
	});
	__all__.object = object;
	
	// Define __pragma__ to preserve '<all>' and '</all>', since it's never generated as a function, must be done early, so here
	var __pragma__ = function () {};
	__all__.__pragma__ = __pragma__;
	__nest__ (
		__all__,
		'org.transcrypt.__base__', {
			__all__: {
				__inited__: false,
				__init__: function (__all__) {
					var __Envir__ = __class__ ('__Envir__', [object], {
						get __init__ () {return __get__ (this, function (self) {
							self.transpiler_name = 'transcrypt';
							self.transpiler_version = '3.5.170';
							self.target_subdir = '__javascript__';
						});}
					});
					var __envir__ = __Envir__ ();
					__pragma__ ('<all>')
						__all__.__Envir__ = __Envir__;
						__all__.__envir__ = __envir__;
					__pragma__ ('</all>')
				}
			}
		}
	);
	__nest__ (
		__all__,
		'org.transcrypt.__standard__', {
			__all__: {
				__inited__: false,
				__init__: function (__all__) {
					var Exception = __class__ ('Exception', [object], {
						get __init__ () {return __get__ (this, function (self) {
							var args = tuple ([].slice.apply (arguments).slice (1));
							self.args = args;
						});},
						get __repr__ () {return __get__ (this, function (self) {
							if (len (self.args)) {
								return '{}{}'.format (self.__class__.__name__, repr (tuple (self.args)));
							}
							else {
								return '???';
							}
						});},
						get __str__ () {return __get__ (this, function (self) {
							if (len (self.args) > 1) {
								return str (tuple (self.args));
							}
							else {
								if (len (self.args)) {
									return str (self.args [0]);
								}
								else {
									return '???';
								}
							}
						});}
					});
					var ValueError = __class__ ('ValueError', [Exception], {
					});
					var __sort__ = function (iterable, key, reverse) {
						if (typeof key == 'undefined' || (key != null && key .__class__ == __kwargdict__)) {;
							var key = null;
						};
						if (typeof reverse == 'undefined' || (reverse != null && reverse .__class__ == __kwargdict__)) {;
							var reverse = false;
						};
						if (arguments.length) {
							var __ilastarg0__ = arguments.length - 1;
							if (arguments [__ilastarg0__] && arguments [__ilastarg0__].__class__ == __kwargdict__) {
								var __allkwargs0__ = arguments [__ilastarg0__--];
								for (var __attrib0__ in __allkwargs0__) {
									switch (__attrib0__) {
										case 'iterable': var iterable = __allkwargs0__ [__attrib0__]; break;
										case 'key': var key = __allkwargs0__ [__attrib0__]; break;
										case 'reverse': var reverse = __allkwargs0__ [__attrib0__]; break;
									}
								}
							}
						}
						if (key) {
							iterable.sort ((function __lambda__ (a, b) {
								if (arguments.length) {
									var __ilastarg0__ = arguments.length - 1;
									if (arguments [__ilastarg0__] && arguments [__ilastarg0__].__class__ == __kwargdict__) {
										var __allkwargs0__ = arguments [__ilastarg0__--];
										for (var __attrib0__ in __allkwargs0__) {
											switch (__attrib0__) {
												case 'a': var a = __allkwargs0__ [__attrib0__]; break;
												case 'b': var b = __allkwargs0__ [__attrib0__]; break;
											}
										}
									}
								}
								return key (a) > key (b);}));
						}
						else {
							iterable.sort ();
						}
						if (reverse) {
							iterable.reverse ();
						}
					};
					var sorted = function (iterable, key, reverse) {
						if (typeof key == 'undefined' || (key != null && key .__class__ == __kwargdict__)) {;
							var key = null;
						};
						if (typeof reverse == 'undefined' || (reverse != null && reverse .__class__ == __kwargdict__)) {;
							var reverse = false;
						};
						if (arguments.length) {
							var __ilastarg0__ = arguments.length - 1;
							if (arguments [__ilastarg0__] && arguments [__ilastarg0__].__class__ == __kwargdict__) {
								var __allkwargs0__ = arguments [__ilastarg0__--];
								for (var __attrib0__ in __allkwargs0__) {
									switch (__attrib0__) {
										case 'iterable': var iterable = __allkwargs0__ [__attrib0__]; break;
										case 'key': var key = __allkwargs0__ [__attrib0__]; break;
										case 'reverse': var reverse = __allkwargs0__ [__attrib0__]; break;
									}
								}
							}
						}
						if (type (iterable) == dict) {
							var result = copy (iterable.keys ());
						}
						else {
							var result = copy (iterable);
						}
						__sort__ (result, key, reverse);
						return result;
					};
					__pragma__ ('<all>')
						__all__.Exception = Exception;
						__all__.ValueError = ValueError;
						__all__.__sort__ = __sort__;
						__all__.sorted = sorted;
					__pragma__ ('</all>')
				}
			}
		}
	);

	// Initialize non-nested modules __base__ and __standard__ and make its names available directly and via __all__
	// It can't do that itself, because it is a regular Python module
	// The compiler recognizes its their namesand generates them inline rather than nesting them
	// In this way it isn't needed to import them everywhere
	 	
	__nest__ (__all__, '', __init__ (__all__.org.transcrypt.__base__));
	var __envir__ = __all__.__envir__;

	__nest__ (__all__, '', __init__ (__all__.org.transcrypt.__standard__));
	var Exception = __all__.Exception;
	var __sort__ = __all__.__sort__;
	var sorted = __all__.sorted;

	// Complete __envir__, that was created in __base__, for non-stub mode
	__envir__.executor_name = __envir__.transpiler_name;
	
	// Make make __main__ available in browser
	var __main__ = {__file__: ''};
	__all__.main = __main__;
	
	// Define current exception, there's at most one exception in the air at any time
	var __except__ = null;
	__all__.__except__ = __except__;
		
	// Define recognizable dictionary for **kwargs parameter
	var __kwargdict__ = function (anObject) {
		anObject.__class__ = __kwargdict__;	// This class needs no __name__
		anObject.constructor = Object;
		return anObject;
	}
	__all__.___kwargdict__ = __kwargdict__;
	
	// Property installer function, no member since that would bloat classes
	var property = function (getter, setter) {	// Returns a property descriptor rather than a property
		if (!setter) {	// ??? Make setter optional instead of dummy?
			setter = function () {};
		}
		return {get: function () {return getter (this)}, set: function (value) {setter (this, value)}, enumerable: true};
	}
	__all__.property = property;
	
	var __merge__ = function (object0, object1) {
		var result = {};
		for (var attrib in object0) {
			result [attrib] = object0 [attrib];
		}
		for (var attrib in object1) {
			result [attrib] = object1 [attrib];
		}
		return result;
	}
	__all__.__merge__ = __merge__;
	
	// Console message
	var print = function () {
		var args = [] .slice.apply (arguments)
		var result = ''
		for (var i = 0; i < args.length; i++) {
			result += str (args [i]) + ' ';
		}
		console.log (result);
	};
	__all__.print = print;
	
	// Make console.log understand apply
	console.log.apply = function () {
		print ([] .slice.apply (arguments) .slice (1));
	};

	// In function, used to mimic Python's in operator
	var __in__ = function (element, container) {
		if (type (container) == dict) {
			return container.keys () .indexOf (element) > -1;
		}
		else {
			return container.indexOf (element) > -1;
		}
	}
	__all__.__in__ = __in__;
	
	// Find out if an attribute is special
	var __specialattrib__ = function (attrib) {
		return (attrib.startswith ('__') && attrib.endswith ('__')) || attrib == 'constructor' || attrib.startswith ('py_');
	}
	__all__.__specialattrib__ = __specialattrib__;
		
	// Len function for any object
	var len = function (anObject) {
		try {
			return anObject.length;
		}
		catch (exception) {
			var result = 0;
			for (attrib in anObject) {
				if (!__specialattrib__ (attrib)) {
					result++;
				}
			}
			return result;
		}
	};
	__all__.len = len;
	
	var bool = {__name__: 'bool'}
	__all__.bool = bool;
	
	var float = function (any) {
		if (isNaN (any)) {
			throw ('ValueError');	// !!! Turn into real value error
		}
		else {
			return +any;
		}
	}
	float.__name__ = 'float'
	__all__.float = float;
	
	var int = function (any) {
		return float (any) | 0
	}
	int.__name__ = 'int';
	__all__.int = int;
	
	var type = function (anObject) {
		try {
			return anObject.__class__;
		}
		catch (exception) {
			var aType = typeof anObject;
			if (aType == 'boolean') {
				return bool;
			}
			else if (aType == 'number') {
				if (anObject % 1 == 0) {
					return int;
				}
				else {
					return float;
				}				
			}
			else {
				return aType;
			}
		}
	}
	__all__.type = type;
	
	var isinstance = function (anObject, classinfo) {
		function isA (queryClass) {
			if (queryClass == classinfo) {
				return true;
			}
			for (var index = 0; index < queryClass.__bases__.length; index++) {
				if (isA (queryClass.__bases__ [index], classinfo)) {
					return true;
				}
			}
			return false;
		}
		return isA (anObject.__class__)
	};
	__all__.isinstance = isinstance;
	
	// Repr function uses __repr__ method, then __str__ then toString
	var repr = function (anObject) {
		try {
			return anObject.__repr__ ();
		}
		catch (exception) {
			try {
				return anObject.__str__ ();
			}
			catch (exception) {	// It was a dict in Python, so an Object in JavaScript
				try {
					if (anObject.constructor == Object) {
						var result = '{';
						var comma = false;
						for (var attrib in anObject) {
							if (!__specialattrib__ (attrib)) {
								if (attrib.isnumeric ()) {
									var attribRepr = attrib;				// If key can be interpreted as numerical, we make it numerical 
								}											// So we accept that '1' is misrepresented as 1
								else {
									var attribRepr = '\'' + attrib + '\'';	// Alpha key in dict
								}
								
								if (comma) {
									result += ', ';
								}
								else {
									comma = true;
								}
								try {
									result += attribRepr + ': ' + anObject [attrib] .__repr__ ();
								}
								catch (exception) {
									result += attribRepr + ': ' + anObject [attrib] .toString ();
								}
							}
						}
						result += '}';
						return result;					
					}
					else {
						return typeof anObject == 'boolean' ? anObject.toString () .capitalize () : anObject.toString ();
					}
				}
				catch (exception) {
					console.log ('ERROR: Could not evaluate repr (<object of type ' + typeof anObject + '>)');
					return '???';
				}
			}
		}
	}
	__all__.repr = repr;
	
	// Char from Unicode or ASCII
	var chr = function (charCode) {
		return String.fromCharCode (charCode);
	}
	__all__.chr = chr;

	// Unicode or ASCII from char
	var ord = function (aChar) {
		return aChar.charCodeAt (0);
	}
	__all__.org = ord;
	
	// Maximum of n numbers
	var max = Math.max;
	__all__.max = max;
	
	// Minimum of n numbers
	var min = Math.min;
	__all__.min = min;
	
	// Reversed function for arrays
	var reversed = function (iterable) {
		iterable = iterable.slice ();
		iterable.reverse ();
		return iterable;
	}
	
	// Zip method for arrays
	var zip = function () {
		var args = [] .slice.call (arguments);
		var shortest = args.length == 0 ? [] : args.reduce (	// Find shortest array in arguments
			function (array0, array1) {
				return array0.length < array1.length ? array0 : array1;
			}
		);
		return shortest.map (					// Map each element of shortest array
			function (current, index) {			// To the result of this function
				return args.map (				// Map each array in arguments
					function (current) {		// To the result of this function
						return current [index]; // Namely it's index't entry
					}
				);
			}
		);
	}
	__all__.zip = zip;
	
	// Range method, returning an array
	function range (start, stop, step) {
		if (typeof stop == 'undefined') {
			// one param defined
			stop = start;
			start = 0;
		}
		if (typeof step == 'undefined') {
			step = 1;
		}
		if ((step > 0 && start >= stop) || (step < 0 && start <= stop)) {
			return [];
		}
		var result = [];
		for (var i = start; step > 0 ? i < stop : i > stop; i += step) {
			result.push(i);
		}
		return result;
	};
	__all__.range = range;
	
	// Enumerate method, returning a zipped list
	function enumerate (iterable) {
		return zip (range (len (iterable)), iterable);
	}
	__all__.enumerate = enumerate;
		
	// Shallow and deepcopy
	
	function copy (anObject) {
		if (anObject == null || typeof anObject == "object") {
			return anObject;
		}
		else {
			var result = {}
			for (var attrib in obj) {
				if (anObject.hasOwnProperty (attrib)) {
					result [attrib] = anObject [attrib];
				}
			}
			return result;
		}
	}
	__all__.copy = copy;
	
	function deepcopy (anObject) {
		if (anObject == null || typeof anObject == "object") {
			return anObject;
		}
		else {
			var result = {}
			for (var attrib in obj) {
				if (anObject.hasOwnProperty (attrib)) {
					result [attrib] = deepcopy (anObject [attrib]);
				}
			}
			return result;
		}
	}
	__all__.deepcopy = deepcopy;
		
	// List extensions to Array
	
	function list (iterable) {										// All such creators should be callable without new
		var instance = iterable ? [] .slice.apply (iterable) : [];	// Spread iterable, n.b. array.slice (), so array before dot
		// Sort is the normal JavaScript sort, Python sort is a non-member function
		return instance;
	}
	__all__.list = list;
	Array.prototype.__class__ = list;	// All arrays are lists (not only if constructed by the list ctor), unless constructed otherwise
	list.__name__ = 'list';
	
	Array.prototype.__getslice__ = function (start, stop, step) {
		if (start < 0) {
			start = this.length + start;
		}
		
		if (stop == null) {
			stop = this.length;
		}
		else if (stop < 0) {
			stop = this.length + stop;
		}
		
		var result = list ([]);
		for (var index = start; index < stop; index += step) {
			result.push (this [index]);
		}
		
		return result;
	}
		
	Array.prototype.__setslice__ = function (start, stop, step, source) {
		if (start < 0) {
			start = this.length + start;
		}
			
		if (stop == null) {
			stop = this.length;
		}
		else if (stop < 0) {
			stop = this.length + stop;
		}
			
		if (step == null) {	// Assign to 'ordinary' slice, replace subsequence
			Array.prototype.splice.apply (this, [start, stop - start] .concat (source)) 
		}
		else {				// Assign to extended slice, replace designated items one by one
			var sourceIndex = 0;
			for (var targetIndex = start; targetIndex < stop; targetIndex += step) {
				this [targetIndex] = source [sourceIndex++];
			}
		}
	}
	
	Array.prototype.__repr__ = function () {
		if (this.__class__ == set && !this.length) {
			return 'set()';
		}
		
		var result = !this.__class__ || this.__class__ == list ? '[' : this.__class__ == tuple ? '(' : '{';
		
		for (var index = 0; index < this.length; index++) {
			if (index) {
				result += ', ';
			}
			try {
				result += this [index] .__repr__ ();
			}
			catch (exception) {
				result += this [index] .toString ();
			}
		}
		
		if (this.__class__ == tuple && this.length == 1) {
			result += ',';
		}
		
		result += !this.__class__ || this.__class__ == list ? ']' : this.__class__ == tuple ? ')' : '}';;
		return result;
	};
	
	Array.prototype.__str__ = Array.prototype.__repr__;
	
	Array.prototype.append = function (element) {
		this.push (element);
	};

	Array.prototype.clear = function () {
		this.length = 0;
	};
	
	Array.prototype.extend = function (aList) {
		this.push.apply (this, aList);
	};
	
	Array.prototype.insert = function (index, element) {
		this.splice (index, 0, element);
	};

	Array.prototype.remove = function (element) {
		var index = this.indexOf (element);
		if (index == -1) {
			throw ('KeyError');
		}
		this.splice (index, 1);
	};

	Array.prototype.index = function (element) {
		return this.indexOf (element)
	};
	
	Array.prototype.py_pop = function (index) {
		if (index == undefined) {
			return this.pop ()	// Remove last element
		}
		else {
			return this.splice (index, 1) [0];
		}
	};	
	
	Array.prototype.py_sort = function () {
		__sort__.apply  (null, [this].concat ([] .slice.apply (arguments)));	// Can't work directly with arguments
		// Python params: (iterable, key = None, reverse = False)
		// py_sort is called with the Transcrypt kwargs mechanism, and just passes the params on to __sort__
		// __sort__ is def'ed with the Transcrypt kwargs mechanism
	};
	
	// Tuple extensions to Array
	
	function tuple (iterable) {
		var instance = iterable ? [] .slice.apply (iterable) : [];
		instance.__class__ = tuple;	// Not all arrays are tuples
		return instance;
	}
	__all__.tuple = tuple;
	tuple.__name__ = 'tuple';
	
	// Set extensions to Array
	// N.B. Since sets are unordered, set operations will occasionally alter the 'this' array by sorting it
		
	function set (iterable) {
		var instance = [];
		if (iterable) {
			for (var index = 0; index < iterable.length; index++) {
				instance.add (iterable [index]);
			}
			
			
		}
		instance.__class__ = set;	// Not all arrays are sets
		return instance;
	}
	__all__.set = set;
	set.__name__ = 'set';
	
	Array.prototype.__bindexOf__ = function (element) {	// Used to turn O (n^2) into O (n log n)
	// Since sorting is lex, compare has to be lex. This also allows for mixed lists
	
		element += '';
	
		var mindex = 0;
		var maxdex = this.length - 1;
			 
		while (mindex <= maxdex) {
			var index = (mindex + maxdex) / 2 | 0;
			var middle = this [index] + '';
	 
			if (middle < element) {
				mindex = index + 1;
			}
			else if (middle > element) {
				maxdex = index - 1;
			}
			else {
				return index;
			}
		}
	 
		return -1;
	}
	
	Array.prototype.add = function (element) {		
		if (this.indexOf (element) == -1) {	// Avoid duplicates in set
			this.push (element);
		}
	};
	
	Array.prototype.discard = function (element) {
		var index = this.indexOf (element);
		if (index != -1) {
			this.splice (index, 1);
		}
	};
	
	Array.prototype.isdisjoint = function (other) {
		this.sort ();
		for (var i = 0; i < other.length; i++) {
			if (this.__bindexOf__ (other [i]) != -1) {
				return false;
			}
		}
		return true;
	};
	
	Array.prototype.issuperset = function (other) {
		this.sort ();
		for (var i = 0; i < other.length; i++) {
			if (this.__bindexOf__ (other [i]) == -1) {
				return false;
			}
		}
		return true;
	};
	
	Array.prototype.issubset = function (other) {
		return set (other.slice ()) .issuperset (this);	// Sort copy of 'other', not 'other' itself, since it may be an ordered sequence
	};
	
	Array.prototype.union = function (other) {
		var result = set (this.slice () .sort ());
		for (var i = 0; i < other.length; i++) {
			if (result.__bindexOf__ (other [i]) == -1) {
				result.push (other [i]);
			}
		}
		return result;
	};
	
	Array.prototype.intersection = function (other) {
		this.sort ();
		var result = set ();
		for (var i = 0; i < other.length; i++) {
			if (this.__bindexOf__ (other [i]) != -1) {
				result.push (other [i]);
			}
		}
		return result;
	};
	
	Array.prototype.difference = function (other) {
		var sother = set (other.slice () .sort ());
		var result = set ();
		for (var i = 0; i < this.length; i++) {
			if (sother.__bindexOf__ (this [i]) == -1) {
				result.push (this [i]);
			}
		}
		return result;
	};
	
	Array.prototype.symmetric_difference = function (other) {
		return this.union (other) .difference (this.intersection (other));
	};
	
	Array.prototype.update = function () {	// O (n)
		var updated = [] .concat.apply (this.slice (), arguments) .sort ();		
		this.clear ();
		for (var i = 0; i < updated.length; i++) {
			if (updated [i] != updated [i - 1]) {
				this.push (updated [i]);
			}
		}
	};
	
	Array.prototype.__eq__ = function (other) {	// Also used for list
		if (this.length != other.length) {
			return false;
		}
		if (this.__class__ == set) {
			this.sort ();
			other.sort ();
		}	
		for (var i = 0; i < this.length; i++) {
			if (this [i] != other [i]) {
				return false;
			}
		}
		return true;
	};
	
	Array.prototype.__ne__ = function (other) {	// Also used for list
		return !this.__eq__ (other);
	}
		
	Array.prototype.__le__ = function (other) {
		return this.issubset (other);
	}
		
	Array.prototype.__ge__ = function (other) {
		return this.issuperset (other);
	}
		
	Array.prototype.__lt__ = function (other) {
		return this.issubset (other) && !this.issuperset (other);
	}
		
	Array.prototype.__gt__ = function (other) {
		return this.issuperset (other) && !this.issubset (other);
	}
	
	// Dict extensions to object
	
	function __keys__ () {
		var keys = []
		for (var attrib in this) {
			if (!__specialattrib__ (attrib)) {
				keys.push (attrib);
			}     
		}
		return keys;
	}
	__all__.__keys__ = __keys__;
		
	function __items__ () {
		var items = []
		for (var attrib in this) {
			if (!__specialattrib__ (attrib)) {
				items.push ([attrib, this [attrib]]);
			}     
		}
		return items;
	}
	__all__.__items__ = __items__;
		
	function __del__ (key) {
		delete this [key];
	}
	__all__.__del__ = __del__;
	
	function __clear__ () {
		for (var attrib in this) {
			delete this [attrib];
		}
	}
	__all__.__clear__ = __clear__;
		
	function dict (objectOrPairs) {
		if (!objectOrPairs || objectOrPairs instanceof Array) {	// It's undefined or an array of pairs
			var instance = {};
			if (objectOrPairs) {
				for (var index = 0; index < objectOrPairs.length; index++) {
					var pair = objectOrPairs [index];
					instance [pair [0]] = pair [1];
				}
			}
		}
		else {													// It's a JavaScript object literal
			var instance = objectOrPairs;
		}
			
		// Trancrypt interprets e.g. {aKey: 'aValue'} as a Python dict literal rather than a JavaScript object literal
		// So dict literals rather than bare Object literals will be passed to JavaScript libraries
		// Some JavaScript libraries call all enumerable callable properties of an object that's passed to them
		// So the properties of a dict should be non-enumerable
		Object.defineProperty (instance, '__class__', {value: dict, enumerable: false, writable: true});
		Object.defineProperty (instance, 'keys', {value: __keys__, enumerable: false});			
		Object.defineProperty (instance, 'items', {value: __items__, enumerable: false});		
		Object.defineProperty (instance, 'del', {value: __del__, enumerable: false});
		Object.defineProperty (instance, 'clear', {value: __clear__, enumerable: false});
		
		return instance;
	}
	__all__.dict = dict;
	dict.__name__ = 'dict';
	
	// String extensions
		
	function str (stringable) {
		try {
			return stringable.__str__ ();
		}
		catch (e) {
			return new String (stringable);
		}
	}
	__all__.str = str;	
	
	String.prototype.__class__ = str;	// All strings are str
	str.__name__ = 'str';
	
	String.prototype.__repr__ = function () {
		return (this.indexOf ('\'') == -1 ? '\'' + this + '\'' : '"' + this + '"') .replace ('\n', '\\n');
	};
	
	String.prototype.__str__ = function () {
		return this;
	};
	
	String.prototype.capitalize = function () {
		return this.charAt (0).toUpperCase () + this.slice (1);
	};
	
	String.prototype.endswith = function (suffix) {
		return suffix == '' || this.slice (-suffix.length) == suffix;
	};
	
	String.prototype.find  = function (sub, start) {
		return this.indexOf (sub, start);
	};
	
	String.prototype.__getslice__ = function (start, stop, step) {
		if (start < 0) {
			start = this.length + start;
		}
		
		if (stop == null) {
			stop = this.length;
		}
		else if (stop < 0) {
			stop = this.length + stop;
		}
		
		var result = '';
		if (step == 1) {
			result = this.substring (start, stop);
		}
		else {
			for (var index = start; index < stop; index += step) {
				result = result.concat (this.charAt(index));
			}
	    }
	    return result;
	}	
	
	// Since it's worthwhile for the 'format' function to be able to deal with *args, it is defined as a property
	// __get__ will produce a bound function if there's something before the dot
	// Since a call using *args is compiled to e.g. <object>.<function>.apply (null, args), the function has to be bound already
	// Otherwise it will never be, because of the null argument
	// Using 'this' rather than 'null' contradicts the requirement to be able to pass bound functions around
	// The object 'before the dot' won't be available at call time in that case, unless implicitly via the function bound to it
	// While for Python methods this mechanism is generated by the compiler, for JavaScript methods it has to be provided manually
	// Call memoizing is unattractive here, since every string would then have to hold a reference to a bound format method
	Object.defineProperty (String.prototype, 'format', {
		get: function () {return __get__ (this, function (self) {
			var args = tuple ([] .slice.apply (arguments).slice (1));			
			var autoIndex = 0;
			return self.replace (/\{(\w*)\}/g, function (match, key) { 
				if (key == '') {
					key = autoIndex++;
				}
				if (key == +key) {	// So key is numerical
					return args [key] == 'undefined' ? match : args [key];
				}
				else {				// Key is a string
					for (var index = 0; index < args.length; index++) {
						// Find first 'dict' that has that key and the right field
						if (typeof args [index] == 'object' && typeof args [index][key] != 'undefined') {
							return args [index][key];	// Return that field field
						}
					}
					return match;
				}
			});
		});},
		enumerable: true
	});
	
	String.prototype.isnumeric = function () {
		return !isNaN (parseFloat (this)) && isFinite (this);
	};
	
	String.prototype.join = function (aList) {
		return aList.join (this);
	};
	
	String.prototype.lower = function () {
		return this.toLowerCase ();
	};
	
	String.prototype.py_replace = function (old, aNew, maxreplace) {
		return this.split (old, maxreplace) .join (aNew);
	};
	
	String.prototype.lstrip = function () {
		return this.replace (/^\s*/g, '');
	};
	
	String.prototype.rfind = function (sub, start) {
		return this.lastIndexOf (sub, start);
	};
	
	String.prototype.rsplit = function (sep, maxsplit) {
		var split = this.split (sep || /s+/);
		return maxsplit ? [ split.slice (0, -maxsplit) .join (sep) ].concat (split.slice (-maxsplit)) : split;
	};
	
	String.prototype.rstrip = function () {
		return this.replace (/\s*$/g, '');
	};
	
	String.prototype.py_split = function (sep, maxsplit) {
		if (!sep) {
			sep = ' ';
		}
		return this.split (sep || /s+/, maxsplit);
	};
	
	String.prototype.startswith = function (prefix) {
		return this.indexOf (prefix) == 0;
	};
	
	String.prototype.strip = function () {
		return this.trim ();
	};
		
	String.prototype.upper = function () {
		return this.toUpperCase ();
	};
	
	// Operator overloading, only the ones that make most sense in matrix operations
	
	var __neg__ = function (a) {
		if (typeof a == 'object' && '__neg__' in a) {
			return a.__neg__ ();
		}
		else {
			return -a;
		}
	};  
	__all__.__neg__ = __neg__;
	
	var __matmul__ = function (a, b) {
		return a.__matmul__ (b);
	};  
	__all__.__matmul__ = __matmul__;
	
	var __mul__ = function (a, b) {
		if (typeof a == 'object' && '__mul__' in a) {
			return a.__mul__ (b);
		}
		else if (typeof b == 'object' && '__rmul__' in b) {
			return b.__rmul__ (a);
		}
		else {
			return a * b;
		}
	};  
	__all__.__mul__ = __mul__;
	
	var __div__ = function (a, b) {
		if (typeof a == 'object' && '__div__' in a) {
			return a.__div__ (b);
		}
		else if (typeof b == 'object' && '__rdiv__' in b) {
			return b.__rdiv__ (a);
		}
		else {
			return a / b;
		}
	};  
	__all__.__div__ = __div__;
	
	var __add__ = function (a, b) {
		if (typeof a == 'object' && '__add__' in a) {
			return a.__add__ (b);
		}
		else if (typeof b == 'object' && '__radd__' in b) {
			return b.__radd__ (a);
		}
		else {
			return a + b;
		}
	};  
	__all__.__add__ = __add__;
	
	var __sub__ = function (a, b) {
		if (typeof a == 'object' && '__sub__' in a) {
			return a.__sub__ (b);
		}
		else if (typeof b == 'object' && '__rsub__' in b) {
			return b.__rsub__ (a);
		}
		else {
			return a - b;
		}
	};  
	__all__.__sub__ = __sub__;
	
	var __eq__ = function (a, b) {
		if (typeof a == 'object' && '__eq__' in a) {
			return a.__eq__ (b);
		}
		else {
			return a == b
		}
	};
	__all__.__eq__ = __eq__;
		
	var __ne__ = function (a, b) {
		if (typeof a == 'object' && '__ne__' in a) {
			return a.__ne__ (b);
		}
		else {
			return a != b
		}
	};
	__all__.__ne__ = __ne__;
		
	var __lt__ = function (a, b) {
		if (typeof a == 'object' && '__lt__' in a) {
			return a.__lt__ (b);
		}
		else {
			return a < b
		}
	};
	__all__.__lt__ = __lt__;
		
	var __le__ = function (a, b) {
		if (typeof a == 'object' && '__le__' in a) {
			return a.__le__ (b);
		}
		else {
			return a <= b
		}
	};
	__all__.__le__ = __le__;
		
	var __gt__ = function (a, b) {
		if (typeof a == 'object' && '__gt__' in a) {
			return a.__gt__ (b);
		}
		else {
			return a > b
		}
	};
	__all__.__gt__ = __gt__;
		
	var __ge__ = function (a, b) {
		if (typeof a == 'object' && '__ge__' in a) {
			return a.__ge__ (b);
		}
		else {
			return a >= b
		}
	};
	__all__.__ge__ = __ge__;
		
	var __getitem__ = function (container, key) {
		if (typeof container == 'object' && '__getitem__' in container) {
			return container.__getitem__ (key);
		}
		else {
			return container [key];
		}
	};
	__all__.__getitem__ = __getitem__;

	var __setitem__ = function (container, key, value) {
		if (typeof container == 'object' && '__setitem__' in container) {
			container.__setitem__ (key, value);
		}
		else {
			container [key] = value;
		}
	};
	__all__.__setitem__ = __setitem__;

	var __getslice__ = function (container, lower, upper, step) {
		if (typeof container == 'object' && '__getitem__' in container) {
			return container.__getitem__ ([lower, upper, step]);
		}
		else {
			return container.__getslice__ (lower, upper, step);
		}
	};
	__all__.__getslice__ = __getslice__;

	var __setslice__ = function (container, lower, upper, step, value) {
		if (typeof container == 'object' && '__setitem__' in container) {
			container.__setitem__ ([lower, upper, step], value);
		}
		else {
			container.__setslice__ (lower, upper, step, value);
		}
	};
	__all__.__setslice__ = __setslice__;

	var __call__ = function (/* <callee>, <params>* */) {
		var args = [] .slice.apply (arguments)
		if (typeof args [0] == 'object' && '__call__' in args [0]) {
			return args [0] .__call__ .apply (null,  args.slice (1));
		}
		else {
			return args [0] .apply (null, args.slice (1));
		}		
	};
	__all__.__call__ = __call__;

	__nest__ (
		__all__,
		'com.fabricjs', {
			__all__: {
				__inited__: false,
				__init__: function (__all__) {
					var fabric = 
					(function () {
						var exports = {};
						/* build: `node build.js modules=text,interaction minifier=uglifyjs` */
					/*! Fabric.js Copyright 2008-2015, Printio (Juriy Zaytsev, Maxim Chernyak) */
					
					var fabric = fabric || { version: "1.5.0" };
					if (typeof exports !== 'undefined') {
					  exports.fabric = fabric;
					}
					
					if (typeof document !== 'undefined' && typeof window !== 'undefined') {
					  fabric.document = document;
					  fabric.window = window;
					  // ensure globality even if entire library were function wrapped (as in Meteor.js packaging system)
					  window.fabric = fabric;
					}
					else {
					  // assume we're running under node.js when document/window are not present
					  fabric.document = require("jsdom")
					    .jsdom("<!DOCTYPE html><html><head></head><body></body></html>");
					
					  if (fabric.document.createWindow) {
					    fabric.window = fabric.document.createWindow();
					  } else {
					    fabric.window = fabric.document.parentWindow;
					  }
					}
					
					/**
					 * True when in environment that supports touch events
					 * @type boolean
					 */
					fabric.isTouchSupported = "ontouchstart" in fabric.document.documentElement;
					
					/**
					 * True when in environment that's probably Node.js
					 * @type boolean
					 */
					fabric.isLikelyNode = typeof Buffer !== 'undefined' &&
					                      typeof window === 'undefined';
					
					/* _FROM_SVG_START_ */
					/**
					 * Attributes parsed from all SVG elements
					 * @type array
					 */
					fabric.SHARED_ATTRIBUTES = [
					  "display",
					  "transform",
					  "fill", "fill-opacity", "fill-rule",
					  "opacity",
					  "stroke", "stroke-dasharray", "stroke-linecap",
					  "stroke-linejoin", "stroke-miterlimit",
					  "stroke-opacity", "stroke-width"
					];
					/* _FROM_SVG_END_ */
					
					/**
					 * Pixel per Inch as a default value set to 96. Can be changed for more realistic conversion.
					 */
					fabric.DPI = 96;
					fabric.reNum = '(?:[-+]?(?:\\d+|\\d*\\.\\d+)(?:e[-+]?\\d+)?)';
					(function() {
					
					  /**
					   * @private
					   * @param {String} eventName
					   * @param {Function} handler
					   */
					  function _removeEventListener(eventName, handler) {
					    if (!this.__eventListeners[eventName]) {
					      return;
					    }
					
					    if (handler) {
					      fabric.util.removeFromArray(this.__eventListeners[eventName], handler);
					    }
					    else {
					      this.__eventListeners[eventName].length = 0;
					    }
					  }
					
					  /**
					   * Observes specified event
					   * @deprecated `observe` deprecated since 0.8.34 (use `on` instead)
					   * @memberOf fabric.Observable
					   * @alias on
					   * @param {String|Object} eventName Event name (eg. 'after:render') or object with key/value pairs (eg. {'after:render': handler, 'selection:cleared': handler})
					   * @param {Function} handler Function that receives a notification when an event of the specified type occurs
					   * @return {Self} thisArg
					   * @chainable
					   */
					  function observe(eventName, handler) {
					    if (!this.__eventListeners) {
					      this.__eventListeners = { };
					    }
					    // one object with key/value pairs was passed
					    if (arguments.length === 1) {
					      for (var prop in eventName) {
					        this.on(prop, eventName[prop]);
					      }
					    }
					    else {
					      if (!this.__eventListeners[eventName]) {
					        this.__eventListeners[eventName] = [ ];
					      }
					      this.__eventListeners[eventName].push(handler);
					    }
					    return this;
					  }
					
					  /**
					   * Stops event observing for a particular event handler. Calling this method
					   * without arguments removes all handlers for all events
					   * @deprecated `stopObserving` deprecated since 0.8.34 (use `off` instead)
					   * @memberOf fabric.Observable
					   * @alias off
					   * @param {String|Object} eventName Event name (eg. 'after:render') or object with key/value pairs (eg. {'after:render': handler, 'selection:cleared': handler})
					   * @param {Function} handler Function to be deleted from EventListeners
					   * @return {Self} thisArg
					   * @chainable
					   */
					  function stopObserving(eventName, handler) {
					    if (!this.__eventListeners) {
					      return;
					    }
					
					    // remove all key/value pairs (event name -> event handler)
					    if (arguments.length === 0) {
					      this.__eventListeners = { };
					    }
					    // one object with key/value pairs was passed
					    else if (arguments.length === 1 && typeof arguments[0] === 'object') {
					      for (var prop in eventName) {
					        _removeEventListener.call(this, prop, eventName[prop]);
					      }
					    }
					    else {
					      _removeEventListener.call(this, eventName, handler);
					    }
					    return this;
					  }
					
					  /**
					   * Fires event with an optional options object
					   * @deprecated `fire` deprecated since 1.0.7 (use `trigger` instead)
					   * @memberOf fabric.Observable
					   * @alias trigger
					   * @param {String} eventName Event name to fire
					   * @param {Object} [options] Options object
					   * @return {Self} thisArg
					   * @chainable
					   */
					  function fire(eventName, options) {
					    if (!this.__eventListeners) {
					      return;
					    }
					
					    var listenersForEvent = this.__eventListeners[eventName];
					    if (!listenersForEvent) {
					      return;
					    }
					
					    for (var i = 0, len = listenersForEvent.length; i < len; i++) {
					      // avoiding try/catch for perf. reasons
					      listenersForEvent[i].call(this, options || { });
					    }
					    return this;
					  }
					
					  /**
					   * @namespace fabric.Observable
					   * @tutorial {@link http://fabricjs.com/fabric-intro-part-2/#events}
					   * @see {@link http://fabricjs.com/events/|Events demo}
					   */
					  fabric.Observable = {
					    observe: observe,
					    stopObserving: stopObserving,
					    fire: fire,
					
					    on: observe,
					    off: stopObserving,
					    trigger: fire
					  };
					})();
					/**
					 * @namespace fabric.Collection
					 */
					fabric.Collection = {
					
					  /**
					   * Adds objects to collection, then renders canvas (if `renderOnAddRemove` is not `false`)
					   * Objects should be instances of (or inherit from) fabric.Object
					   * @param {...fabric.Object} object Zero or more fabric instances
					   * @return {Self} thisArg
					   */
					  add: function () {
					    this._objects.push.apply(this._objects, arguments);
					    for (var i = 0, length = arguments.length; i < length; i++) {
					      this._onObjectAdded(arguments[i]);
					    }
					    this.renderOnAddRemove && this.renderAll();
					    return this;
					  },
					
					  /**
					   * Inserts an object into collection at specified index, then renders canvas (if `renderOnAddRemove` is not `false`)
					   * An object should be an instance of (or inherit from) fabric.Object
					   * @param {Object} object Object to insert
					   * @param {Number} index Index to insert object at
					   * @param {Boolean} nonSplicing When `true`, no splicing (shifting) of objects occurs
					   * @return {Self} thisArg
					   * @chainable
					   */
					  insertAt: function (object, index, nonSplicing) {
					    var objects = this.getObjects();
					    if (nonSplicing) {
					      objects[index] = object;
					    }
					    else {
					      objects.splice(index, 0, object);
					    }
					    this._onObjectAdded(object);
					    this.renderOnAddRemove && this.renderAll();
					    return this;
					  },
					
					  /**
					   * Removes objects from a collection, then renders canvas (if `renderOnAddRemove` is not `false`)
					   * @param {...fabric.Object} object Zero or more fabric instances
					   * @return {Self} thisArg
					   * @chainable
					   */
					  remove: function() {
					    var objects = this.getObjects(),
					        index;
					
					    for (var i = 0, length = arguments.length; i < length; i++) {
					      index = objects.indexOf(arguments[i]);
					
					      // only call onObjectRemoved if an object was actually removed
					      if (index !== -1) {
					        objects.splice(index, 1);
					        this._onObjectRemoved(arguments[i]);
					      }
					    }
					
					    this.renderOnAddRemove && this.renderAll();
					    return this;
					  },
					
					  /**
					   * Executes given function for each object in this group
					   * @param {Function} callback
					   *                   Callback invoked with current object as first argument,
					   *                   index - as second and an array of all objects - as third.
					   *                   Iteration happens in reverse order (for performance reasons).
					   *                   Callback is invoked in a context of Global Object (e.g. `window`)
					   *                   when no `context` argument is given
					   *
					   * @param {Object} context Context (aka thisObject)
					   * @return {Self} thisArg
					   */
					  forEachObject: function(callback, context) {
					    var objects = this.getObjects(),
					        i = objects.length;
					    while (i--) {
					      callback.call(context, objects[i], i, objects);
					    }
					    return this;
					  },
					
					  /**
					   * Returns an array of children objects of this instance
					   * Type parameter introduced in 1.3.10
					   * @param {String} [type] When specified, only objects of this type are returned
					   * @return {Array}
					   */
					  getObjects: function(type) {
					    if (typeof type === 'undefined') {
					      return this._objects;
					    }
					    return this._objects.filter(function(o) {
					      return o.type === type;
					    });
					  },
					
					  /**
					   * Returns object at specified index
					   * @param {Number} index
					   * @return {Self} thisArg
					   */
					  item: function (index) {
					    return this.getObjects()[index];
					  },
					
					  /**
					   * Returns true if collection contains no objects
					   * @return {Boolean} true if collection is empty
					   */
					  isEmpty: function () {
					    return this.getObjects().length === 0;
					  },
					
					  /**
					   * Returns a size of a collection (i.e: length of an array containing its objects)
					   * @return {Number} Collection size
					   */
					  size: function() {
					    return this.getObjects().length;
					  },
					
					  /**
					   * Returns true if collection contains an object
					   * @param {Object} object Object to check against
					   * @return {Boolean} `true` if collection contains an object
					   */
					  contains: function(object) {
					    return this.getObjects().indexOf(object) > -1;
					  },
					
					  /**
					   * Returns number representation of a collection complexity
					   * @return {Number} complexity
					   */
					  complexity: function () {
					    return this.getObjects().reduce(function (memo, current) {
					      memo += current.complexity ? current.complexity() : 0;
					      return memo;
					    }, 0);
					  }
					};
					(function(global) {
					
					  var sqrt = Math.sqrt,
					      atan2 = Math.atan2,
					      PiBy180 = Math.PI / 180;
					
					  /**
					   * @namespace fabric.util
					   */
					  fabric.util = {
					
					    /**
					     * Removes value from an array.
					     * Presence of value (and its position in an array) is determined via `Array.prototype.indexOf`
					     * @static
					     * @memberOf fabric.util
					     * @param {Array} array
					     * @param {Any} value
					     * @return {Array} original array
					     */
					    removeFromArray: function(array, value) {
					      var idx = array.indexOf(value);
					      if (idx !== -1) {
					        array.splice(idx, 1);
					      }
					      return array;
					    },
					
					    /**
					     * Returns random number between 2 specified ones.
					     * @static
					     * @memberOf fabric.util
					     * @param {Number} min lower limit
					     * @param {Number} max upper limit
					     * @return {Number} random value (between min and max)
					     */
					    getRandomInt: function(min, max) {
					      return Math.floor(Math.random() * (max - min + 1)) + min;
					    },
					
					    /**
					     * Transforms degrees to radians.
					     * @static
					     * @memberOf fabric.util
					     * @param {Number} degrees value in degrees
					     * @return {Number} value in radians
					     */
					    degreesToRadians: function(degrees) {
					      return degrees * PiBy180;
					    },
					
					    /**
					     * Transforms radians to degrees.
					     * @static
					     * @memberOf fabric.util
					     * @param {Number} radians value in radians
					     * @return {Number} value in degrees
					     */
					    radiansToDegrees: function(radians) {
					      return radians / PiBy180;
					    },
					
					    /**
					     * Rotates `point` around `origin` with `radians`
					     * @static
					     * @memberOf fabric.util
					     * @param {fabric.Point} point The point to rotate
					     * @param {fabric.Point} origin The origin of the rotation
					     * @param {Number} radians The radians of the angle for the rotation
					     * @return {fabric.Point} The new rotated point
					     */
					    rotatePoint: function(point, origin, radians) {
					      var sin = Math.sin(radians),
					          cos = Math.cos(radians);
					
					      point.subtractEquals(origin);
					
					      var rx = point.x * cos - point.y * sin,
					          ry = point.x * sin + point.y * cos;
					
					      return new fabric.Point(rx, ry).addEquals(origin);
					    },
					
					    /**
					     * Apply transform t to point p
					     * @static
					     * @memberOf fabric.util
					     * @param  {fabric.Point} p The point to transform
					     * @param  {Array} t The transform
					     * @param  {Boolean} [ignoreOffset] Indicates that the offset should not be applied
					     * @return {fabric.Point} The transformed point
					     */
					    transformPoint: function(p, t, ignoreOffset) {
					      if (ignoreOffset) {
					        return new fabric.Point(
					          t[0] * p.x + t[2] * p.y,
					          t[1] * p.x + t[3] * p.y
					        );
					      }
					      return new fabric.Point(
					        t[0] * p.x + t[2] * p.y + t[4],
					        t[1] * p.x + t[3] * p.y + t[5]
					      );
					    },
					
					    /**
					     * Invert transformation t
					     * @static
					     * @memberOf fabric.util
					     * @param {Array} t The transform
					     * @return {Array} The inverted transform
					     */
					    invertTransform: function(t) {
					      var r = t.slice(),
					          a = 1 / (t[0] * t[3] - t[1] * t[2]);
					      r = [a * t[3], -a * t[1], -a * t[2], a * t[0], 0, 0];
					      var o = fabric.util.transformPoint({ x: t[4], y: t[5] }, r);
					      r[4] = -o.x;
					      r[5] = -o.y;
					      return r;
					    },
					
					    /**
					     * A wrapper around Number#toFixed, which contrary to native method returns number, not string.
					     * @static
					     * @memberOf fabric.util
					     * @param {Number|String} number number to operate on
					     * @param {Number} fractionDigits number of fraction digits to "leave"
					     * @return {Number}
					     */
					    toFixed: function(number, fractionDigits) {
					      return parseFloat(Number(number).toFixed(fractionDigits));
					    },
					
					    /**
					     * Converts from attribute value to pixel value if applicable.
					     * Returns converted pixels or original value not converted.
					     * @param {Number|String} value number to operate on
					     * @return {Number|String}
					     */
					    parseUnit: function(value, fontSize) {
					      var unit = /\D{0,2}$/.exec(value),
					          number = parseFloat(value);
					      if (!fontSize) {
					        fontSize = fabric.Text.DEFAULT_SVG_FONT_SIZE;
					      }
					      switch (unit[0]) {
					        case 'mm':
					          return number * fabric.DPI / 25.4;
					
					        case 'cm':
					          return number * fabric.DPI / 2.54;
					
					        case 'in':
					          return number * fabric.DPI;
					
					        case 'pt':
					          return number * fabric.DPI / 72; // or * 4 / 3
					
					        case 'pc':
					          return number * fabric.DPI / 72 * 12; // or * 16
					
					        case 'em':
					          return number * fontSize;
					
					        default:
					          return number;
					      }
					    },
					
					    /**
					     * Function which always returns `false`.
					     * @static
					     * @memberOf fabric.util
					     * @return {Boolean}
					     */
					    falseFunction: function() {
					      return false;
					    },
					
					    /**
					      * Returns klass "Class" object of given namespace
					      * @memberOf fabric.util
					      * @param {String} type Type of object (eg. 'circle')
					      * @param {String} namespace Namespace to get klass "Class" object from
					      * @return {Object} klass "Class"
					      */
					    getKlass: function(type, namespace) {
					      // capitalize first letter only
					      type = fabric.util.string.camelize(type.charAt(0).toUpperCase() + type.slice(1));
					      return fabric.util.resolveNamespace(namespace)[type];
					    },
					
					    /**
					     * Returns object of given namespace
					     * @memberOf fabric.util
					     * @param {String} namespace Namespace string e.g. 'fabric.Image.filter' or 'fabric'
					     * @return {Object} Object for given namespace (default fabric)
					     */
					    resolveNamespace: function(namespace) {
					      if (!namespace) {
					        return fabric;
					      }
					
					      var parts = namespace.split('.'),
					          len = parts.length,
					          obj = global || fabric.window;
					
					      for (var i = 0; i < len; ++i) {
					        obj = obj[parts[i]];
					      }
					
					      return obj;
					    },
					
					    /**
					     * Loads image element from given url and passes it to a callback
					     * @memberOf fabric.util
					     * @param {String} url URL representing an image
					     * @param {Function} callback Callback; invoked with loaded image
					     * @param {Any} [context] Context to invoke callback in
					     * @param {Object} [crossOrigin] crossOrigin value to set image element to
					     */
					    loadImage: function(url, callback, context, crossOrigin) {
					      if (!url) {
					        callback && callback.call(context, url);
					        return;
					      }
					
					      var img = fabric.util.createImage();
					
					      /** @ignore */
					      img.onload = function () {
					        callback && callback.call(context, img);
					        img = img.onload = img.onerror = null;
					      };
					
					      /** @ignore */
					      img.onerror = function() {
					        fabric.log('Error loading ' + img.src);
					        callback && callback.call(context, null, true);
					        img = img.onload = img.onerror = null;
					      };
					
					      // data-urls appear to be buggy with crossOrigin
					      // https://github.com/kangax/fabric.js/commit/d0abb90f1cd5c5ef9d2a94d3fb21a22330da3e0a#commitcomment-4513767
					      // see https://code.google.com/p/chromium/issues/detail?id=315152
					      //     https://bugzilla.mozilla.org/show_bug.cgi?id=935069
					      if (url.indexOf('data') !== 0 && typeof crossOrigin !== 'undefined') {
					        img.crossOrigin = crossOrigin;
					      }
					
					      img.src = url;
					    },
					
					    /**
					     * Creates corresponding fabric instances from their object representations
					     * @static
					     * @memberOf fabric.util
					     * @param {Array} objects Objects to enliven
					     * @param {Function} callback Callback to invoke when all objects are created
					     * @param {String} namespace Namespace to get klass "Class" object from
					     * @param {Function} reviver Method for further parsing of object elements,
					     * called after each fabric object created.
					     */
					    enlivenObjects: function(objects, callback, namespace, reviver) {
					      objects = objects || [ ];
					
					      function onLoaded() {
					        if (++numLoadedObjects === numTotalObjects) {
					          callback && callback(enlivenedObjects);
					        }
					      }
					
					      var enlivenedObjects = [ ],
					          numLoadedObjects = 0,
					          numTotalObjects = objects.length;
					
					      if (!numTotalObjects) {
					        callback && callback(enlivenedObjects);
					        return;
					      }
					
					      objects.forEach(function (o, index) {
					        // if sparse array
					        if (!o || !o.type) {
					          onLoaded();
					          return;
					        }
					        var klass = fabric.util.getKlass(o.type, namespace);
					        if (klass.async) {
					          klass.fromObject(o, function (obj, error) {
					            if (!error) {
					              enlivenedObjects[index] = obj;
					              reviver && reviver(o, enlivenedObjects[index]);
					            }
					            onLoaded();
					          });
					        }
					        else {
					          enlivenedObjects[index] = klass.fromObject(o);
					          reviver && reviver(o, enlivenedObjects[index]);
					          onLoaded();
					        }
					      });
					    },
					
					    /**
					     * Groups SVG elements (usually those retrieved from SVG document)
					     * @static
					     * @memberOf fabric.util
					     * @param {Array} elements SVG elements to group
					     * @param {Object} [options] Options object
					     * @return {fabric.Object|fabric.PathGroup}
					     */
					    groupSVGElements: function(elements, options, path) {
					      var object;
					
					      object = new fabric.PathGroup(elements, options);
					
					      if (typeof path !== 'undefined') {
					        object.setSourcePath(path);
					      }
					      return object;
					    },
					
					    /**
					     * Populates an object with properties of another object
					     * @static
					     * @memberOf fabric.util
					     * @param {Object} source Source object
					     * @param {Object} destination Destination object
					     * @return {Array} properties Propertie names to include
					     */
					    populateWithProperties: function(source, destination, properties) {
					      if (properties && Object.prototype.toString.call(properties) === '[object Array]') {
					        for (var i = 0, len = properties.length; i < len; i++) {
					          if (properties[i] in source) {
					            destination[properties[i]] = source[properties[i]];
					          }
					        }
					      }
					    },
					
					    /**
					     * Draws a dashed line between two points
					     *
					     * This method is used to draw dashed line around selection area.
					     * See <a href="http://stackoverflow.com/questions/4576724/dotted-stroke-in-canvas">dotted stroke in canvas</a>
					     *
					     * @param {CanvasRenderingContext2D} ctx context
					     * @param {Number} x  start x coordinate
					     * @param {Number} y start y coordinate
					     * @param {Number} x2 end x coordinate
					     * @param {Number} y2 end y coordinate
					     * @param {Array} da dash array pattern
					     */
					    drawDashedLine: function(ctx, x, y, x2, y2, da) {
					      var dx = x2 - x,
					          dy = y2 - y,
					          len = sqrt(dx * dx + dy * dy),
					          rot = atan2(dy, dx),
					          dc = da.length,
					          di = 0,
					          draw = true;
					
					      ctx.save();
					      ctx.translate(x, y);
					      ctx.moveTo(0, 0);
					      ctx.rotate(rot);
					
					      x = 0;
					      while (len > x) {
					        x += da[di++ % dc];
					        if (x > len) {
					          x = len;
					        }
					        ctx[draw ? 'lineTo' : 'moveTo'](x, 0);
					        draw = !draw;
					      }
					
					      ctx.restore();
					    },
					
					    /**
					     * Creates canvas element and initializes it via excanvas if necessary
					     * @static
					     * @memberOf fabric.util
					     * @param {CanvasElement} [canvasEl] optional canvas element to initialize;
					     * when not given, element is created implicitly
					     * @return {CanvasElement} initialized canvas element
					     */
					    createCanvasElement: function(canvasEl) {
					      canvasEl || (canvasEl = fabric.document.createElement('canvas'));
					      //jscs:disable requireCamelCaseOrUpperCaseIdentifiers
					      if (!canvasEl.getContext && typeof G_vmlCanvasManager !== 'undefined') {
					        G_vmlCanvasManager.initElement(canvasEl);
					      }
					      //jscs:enable requireCamelCaseOrUpperCaseIdentifiers
					      return canvasEl;
					    },
					
					    /**
					     * Creates image element (works on client and node)
					     * @static
					     * @memberOf fabric.util
					     * @return {HTMLImageElement} HTML image element
					     */
					    createImage: function() {
					      return fabric.isLikelyNode
					        ? new (require('canvas').Image)()
					        : fabric.document.createElement('img');
					    },
					
					    /**
					     * Creates accessors (getXXX, setXXX) for a "class", based on "stateProperties" array
					     * @static
					     * @memberOf fabric.util
					     * @param {Object} klass "Class" to create accessors for
					     */
					    createAccessors: function(klass) {
					      var proto = klass.prototype;
					
					      for (var i = proto.stateProperties.length; i--; ) {
					
					        var propName = proto.stateProperties[i],
					            capitalizedPropName = propName.charAt(0).toUpperCase() + propName.slice(1),
					            setterName = 'set' + capitalizedPropName,
					            getterName = 'get' + capitalizedPropName;
					
					        // using `new Function` for better introspection
					        if (!proto[getterName]) {
					          proto[getterName] = (function(property) {
					            return new Function('return this.get("' + property + '")');
					          })(propName);
					        }
					        if (!proto[setterName]) {
					          proto[setterName] = (function(property) {
					            return new Function('value', 'return this.set("' + property + '", value)');
					          })(propName);
					        }
					      }
					    },
					
					    /**
					     * @static
					     * @memberOf fabric.util
					     * @param {fabric.Object} receiver Object implementing `clipTo` method
					     * @param {CanvasRenderingContext2D} ctx Context to clip
					     */
					    clipContext: function(receiver, ctx) {
					      ctx.save();
					      ctx.beginPath();
					      receiver.clipTo(ctx);
					      ctx.clip();
					    },
					
					    /**
					     * Multiply matrix A by matrix B to nest transformations
					     * @static
					     * @memberOf fabric.util
					     * @param  {Array} a First transformMatrix
					     * @param  {Array} b Second transformMatrix
					     * @return {Array} The product of the two transform matrices
					     */
					    multiplyTransformMatrices: function(a, b) {
					      // Matrix multiply a * b
					      return [
					        a[0] * b[0] + a[2] * b[1],
					        a[1] * b[0] + a[3] * b[1],
					        a[0] * b[2] + a[2] * b[3],
					        a[1] * b[2] + a[3] * b[3],
					        a[0] * b[4] + a[2] * b[5] + a[4],
					        a[1] * b[4] + a[3] * b[5] + a[5]
					      ];
					    },
					
					    /**
					     * Returns string representation of function body
					     * @param {Function} fn Function to get body of
					     * @return {String} Function body
					     */
					    getFunctionBody: function(fn) {
					      return (String(fn).match(/function[^{]*\{([\s\S]*)\}/) || {})[1];
					    },
					
					    /**
					     * Returns true if context has transparent pixel
					     * at specified location (taking tolerance into account)
					     * @param {CanvasRenderingContext2D} ctx context
					     * @param {Number} x x coordinate
					     * @param {Number} y y coordinate
					     * @param {Number} tolerance Tolerance
					     */
					    isTransparent: function(ctx, x, y, tolerance) {
					
					      // If tolerance is > 0 adjust start coords to take into account.
					      // If moves off Canvas fix to 0
					      if (tolerance > 0) {
					        if (x > tolerance) {
					          x -= tolerance;
					        }
					        else {
					          x = 0;
					        }
					        if (y > tolerance) {
					          y -= tolerance;
					        }
					        else {
					          y = 0;
					        }
					      }
					
					      var _isTransparent = true,
					          imageData = ctx.getImageData(x, y, (tolerance * 2) || 1, (tolerance * 2) || 1);
					
					      // Split image data - for tolerance > 1, pixelDataSize = 4;
					      for (var i = 3, l = imageData.data.length; i < l; i += 4) {
					        var temp = imageData.data[i];
					        _isTransparent = temp <= 0;
					        if (_isTransparent === false) {
					          break; // Stop if colour found
					        }
					      }
					
					      imageData = null;
					
					      return _isTransparent;
					    }
					  };
					
					})(typeof exports !== 'undefined' ? exports : this);
					(function() {
					
					  var arcToSegmentsCache = { },
					      segmentToBezierCache = { },
					      boundsOfCurveCache = { },
					      _join = Array.prototype.join;
					
					  /* Adapted from http://dxr.mozilla.org/mozilla-central/source/content/svg/content/src/nsSVGPathDataParser.cpp
					   * by Andrea Bogazzi code is under MPL. if you don't have a copy of the license you can take it here
					   * http://mozilla.org/MPL/2.0/
					   */
					  function arcToSegments(toX, toY, rx, ry, large, sweep, rotateX) {
					    var argsString = _join.call(arguments);
					    if (arcToSegmentsCache[argsString]) {
					      return arcToSegmentsCache[argsString];
					    }
					
					    var PI = Math.PI, th = rotateX * PI / 180,
					        sinTh = Math.sin(th),
					        cosTh = Math.cos(th),
					        fromX = 0, fromY = 0;
					
					    rx = Math.abs(rx);
					    ry = Math.abs(ry);
					
					    var px = -cosTh * toX * 0.5 - sinTh * toY * 0.5,
					        py = -cosTh * toY * 0.5 + sinTh * toX * 0.5,
					        rx2 = rx * rx, ry2 = ry * ry, py2 = py * py, px2 = px * px,
					        pl = rx2 * ry2 - rx2 * py2 - ry2 * px2,
					        root = 0;
					
					    if (pl < 0) {
					      var s = Math.sqrt(1 - pl/(rx2 * ry2));
					      rx *= s;
					      ry *= s;
					    }
					    else {
					      root = (large === sweep ? -1.0 : 1.0) *
					              Math.sqrt( pl /(rx2 * py2 + ry2 * px2));
					    }
					
					    var cx = root * rx * py / ry,
					        cy = -root * ry * px / rx,
					        cx1 = cosTh * cx - sinTh * cy + toX * 0.5,
					        cy1 = sinTh * cx + cosTh * cy + toY * 0.5,
					        mTheta = calcVectorAngle(1, 0, (px - cx) / rx, (py - cy) / ry),
					        dtheta = calcVectorAngle((px - cx) / rx, (py - cy) / ry, (-px - cx) / rx, (-py - cy) / ry);
					
					    if (sweep === 0 && dtheta > 0) {
					      dtheta -= 2 * PI;
					    }
					    else if (sweep === 1 && dtheta < 0) {
					      dtheta += 2 * PI;
					    }
					
					    // Convert into cubic bezier segments <= 90deg
					    var segments = Math.ceil(Math.abs(dtheta / PI * 2)),
					        result = [], mDelta = dtheta / segments,
					        mT = 8 / 3 * Math.sin(mDelta / 4) * Math.sin(mDelta / 4) / Math.sin(mDelta / 2),
					        th3 = mTheta + mDelta;
					
					    for (var i = 0; i < segments; i++) {
					      result[i] = segmentToBezier(mTheta, th3, cosTh, sinTh, rx, ry, cx1, cy1, mT, fromX, fromY);
					      fromX = result[i][4];
					      fromY = result[i][5];
					      mTheta = th3;
					      th3 += mDelta;
					    }
					    arcToSegmentsCache[argsString] = result;
					    return result;
					  }
					
					  function segmentToBezier(th2, th3, cosTh, sinTh, rx, ry, cx1, cy1, mT, fromX, fromY) {
					    var argsString2 = _join.call(arguments);
					    if (segmentToBezierCache[argsString2]) {
					      return segmentToBezierCache[argsString2];
					    }
					
					    var costh2 = Math.cos(th2),
					        sinth2 = Math.sin(th2),
					        costh3 = Math.cos(th3),
					        sinth3 = Math.sin(th3),
					        toX = cosTh * rx * costh3 - sinTh * ry * sinth3 + cx1,
					        toY = sinTh * rx * costh3 + cosTh * ry * sinth3 + cy1,
					        cp1X = fromX + mT * ( - cosTh * rx * sinth2 - sinTh * ry * costh2),
					        cp1Y = fromY + mT * ( - sinTh * rx * sinth2 + cosTh * ry * costh2),
					        cp2X = toX + mT * ( cosTh * rx * sinth3 + sinTh * ry * costh3),
					        cp2Y = toY + mT * ( sinTh * rx * sinth3 - cosTh * ry * costh3);
					
					    segmentToBezierCache[argsString2] = [
					      cp1X, cp1Y,
					      cp2X, cp2Y,
					      toX, toY
					    ];
					    return segmentToBezierCache[argsString2];
					  }
					
					  /*
					  * Private
					  */
					  function calcVectorAngle(ux, uy, vx, vy) {
					    var ta = Math.atan2(uy, ux),
					        tb = Math.atan2(vy, vx);
					    if (tb >= ta) {
					      return tb - ta;
					    }
					    else {
					      return 2 * Math.PI - (ta - tb);
					    }
					  }
					
					  /**
					   * Draws arc
					   * @param {CanvasRenderingContext2D} ctx
					   * @param {Number} fx
					   * @param {Number} fy
					   * @param {Array} coords
					   */
					  fabric.util.drawArc = function(ctx, fx, fy, coords) {
					    var rx = coords[0],
					        ry = coords[1],
					        rot = coords[2],
					        large = coords[3],
					        sweep = coords[4],
					        tx = coords[5],
					        ty = coords[6],
					        segs = [[ ], [ ], [ ], [ ]],
					        segsNorm = arcToSegments(tx - fx, ty - fy, rx, ry, large, sweep, rot);
					
					    for (var i = 0, len = segsNorm.length; i < len; i++) {
					      segs[i][0] = segsNorm[i][0] + fx;
					      segs[i][1] = segsNorm[i][1] + fy;
					      segs[i][2] = segsNorm[i][2] + fx;
					      segs[i][3] = segsNorm[i][3] + fy;
					      segs[i][4] = segsNorm[i][4] + fx;
					      segs[i][5] = segsNorm[i][5] + fy;
					      ctx.bezierCurveTo.apply(ctx, segs[i]);
					    }
					  };
					
					  /**
					   * Calculate bounding box of a elliptic-arc
					   * @param {Number} fx start point of arc
					   * @param {Number} fy
					   * @param {Number} rx horizontal radius
					   * @param {Number} ry vertical radius
					   * @param {Number} rot angle of horizontal axe
					   * @param {Number} large 1 or 0, whatever the arc is the big or the small on the 2 points
					   * @param {Number} sweep 1 or 0, 1 clockwise or counterclockwise direction
					   * @param {Number} tx end point of arc
					   * @param {Number} ty
					   */
					  fabric.util.getBoundsOfArc = function(fx, fy, rx, ry, rot, large, sweep, tx, ty) {
					
					    var fromX = 0, fromY = 0, bound = [ ], bounds = [ ],
					    segs = arcToSegments(tx - fx, ty - fy, rx, ry, large, sweep, rot),
					    boundCopy = [[ ], [ ]];
					
					    for (var i = 0, len = segs.length; i < len; i++) {
					      bound = getBoundsOfCurve(fromX, fromY, segs[i][0], segs[i][1], segs[i][2], segs[i][3], segs[i][4], segs[i][5]);
					      boundCopy[0].x = bound[0].x + fx;
					      boundCopy[0].y = bound[0].y + fy;
					      boundCopy[1].x = bound[1].x + fx;
					      boundCopy[1].y = bound[1].y + fy;
					      bounds.push(boundCopy[0]);
					      bounds.push(boundCopy[1]);
					      fromX = segs[i][4];
					      fromY = segs[i][5];
					    }
					    return bounds;
					  };
					
					  /**
					   * Calculate bounding box of a beziercurve
					   * @param {Number} x0 starting point
					   * @param {Number} y0
					   * @param {Number} x1 first control point
					   * @param {Number} y1
					   * @param {Number} x2 secondo control point
					   * @param {Number} y2
					   * @param {Number} x3 end of beizer
					   * @param {Number} y3
					   */
					  // taken from http://jsbin.com/ivomiq/56/edit  no credits available for that.
					  function getBoundsOfCurve(x0, y0, x1, y1, x2, y2, x3, y3) {
					    var argsString = _join.call(arguments);
					    if (boundsOfCurveCache[argsString]) {
					      return boundsOfCurveCache[argsString];
					    }
					
					    var sqrt = Math.sqrt,
					        min = Math.min, max = Math.max,
					        abs = Math.abs, tvalues = [ ],
					        bounds = [[ ], [ ]],
					        a, b, c, t, t1, t2, b2ac, sqrtb2ac;
					
					    b = 6 * x0 - 12 * x1 + 6 * x2;
					    a = -3 * x0 + 9 * x1 - 9 * x2 + 3 * x3;
					    c = 3 * x1 - 3 * x0;
					
					    for (var i = 0; i < 2; ++i) {
					      if (i > 0) {
					        b = 6 * y0 - 12 * y1 + 6 * y2;
					        a = -3 * y0 + 9 * y1 - 9 * y2 + 3 * y3;
					        c = 3 * y1 - 3 * y0;
					      }
					
					      if (abs(a) < 1e-12) {
					        if (abs(b) < 1e-12) {
					          continue;
					        }
					        t = -c / b;
					        if (0 < t && t < 1) {
					          tvalues.push(t);
					        }
					        continue;
					      }
					      b2ac = b * b - 4 * c * a;
					      if (b2ac < 0) {
					        continue;
					      }
					      sqrtb2ac = sqrt(b2ac);
					      t1 = (-b + sqrtb2ac) / (2 * a);
					      if (0 < t1 && t1 < 1) {
					        tvalues.push(t1);
					      }
					      t2 = (-b - sqrtb2ac) / (2 * a);
					      if (0 < t2 && t2 < 1) {
					        tvalues.push(t2);
					      }
					    }
					
					    var x, y, j = tvalues.length, jlen = j, mt;
					    while (j--) {
					      t = tvalues[j];
					      mt = 1 - t;
					      x = (mt * mt * mt * x0) + (3 * mt * mt * t * x1) + (3 * mt * t * t * x2) + (t * t * t * x3);
					      bounds[0][j] = x;
					
					      y = (mt * mt * mt * y0) + (3 * mt * mt * t * y1) + (3 * mt * t * t * y2) + (t * t * t * y3);
					      bounds[1][j] = y;
					    }
					
					    bounds[0][jlen] = x0;
					    bounds[1][jlen] = y0;
					    bounds[0][jlen + 1] = x3;
					    bounds[1][jlen + 1] = y3;
					    var result = [
					      {
					        x: min.apply(null, bounds[0]),
					        y: min.apply(null, bounds[1])
					      },
					      {
					        x: max.apply(null, bounds[0]),
					        y: max.apply(null, bounds[1])
					      }
					    ];
					    boundsOfCurveCache[argsString] = result;
					    return result;
					  }
					
					  fabric.util.getBoundsOfCurve = getBoundsOfCurve;
					
					})();
					(function() {
					
					  var slice = Array.prototype.slice;
					
					  /* _ES5_COMPAT_START_ */
					
					  if (!Array.prototype.indexOf) {
					    /**
					     * Finds index of an element in an array
					     * @param {Any} searchElement
					     * @param {Number} [fromIndex]
					     * @return {Number}
					     */
					    Array.prototype.indexOf = function (searchElement /*, fromIndex */ ) {
					      if (this === void 0 || this === null) {
					        throw new TypeError();
					      }
					      var t = Object(this), len = t.length >>> 0;
					      if (len === 0) {
					        return -1;
					      }
					      var n = 0;
					      if (arguments.length > 0) {
					        n = Number(arguments[1]);
					        if (n !== n) { // shortcut for verifying if it's NaN
					          n = 0;
					        }
					        else if (n !== 0 && n !== Number.POSITIVE_INFINITY && n !== Number.NEGATIVE_INFINITY) {
					          n = (n > 0 || -1) * Math.floor(Math.abs(n));
					        }
					      }
					      if (n >= len) {
					        return -1;
					      }
					      var k = n >= 0 ? n : Math.max(len - Math.abs(n), 0);
					      for (; k < len; k++) {
					        if (k in t && t[k] === searchElement) {
					          return k;
					        }
					      }
					      return -1;
					    };
					  }
					
					  if (!Array.prototype.forEach) {
					    /**
					     * Iterates an array, invoking callback for each element
					     * @param {Function} fn Callback to invoke for each element
					     * @param {Object} [context] Context to invoke callback in
					     * @return {Array}
					     */
					    Array.prototype.forEach = function(fn, context) {
					      for (var i = 0, len = this.length >>> 0; i < len; i++) {
					        if (i in this) {
					          fn.call(context, this[i], i, this);
					        }
					      }
					    };
					  }
					
					  if (!Array.prototype.map) {
					    /**
					     * Returns a result of iterating over an array, invoking callback for each element
					     * @param {Function} fn Callback to invoke for each element
					     * @param {Object} [context] Context to invoke callback in
					     * @return {Array}
					     */
					    Array.prototype.map = function(fn, context) {
					      var result = [ ];
					      for (var i = 0, len = this.length >>> 0; i < len; i++) {
					        if (i in this) {
					          result[i] = fn.call(context, this[i], i, this);
					        }
					      }
					      return result;
					    };
					  }
					
					  if (!Array.prototype.every) {
					    /**
					     * Returns true if a callback returns truthy value for all elements in an array
					     * @param {Function} fn Callback to invoke for each element
					     * @param {Object} [context] Context to invoke callback in
					     * @return {Boolean}
					     */
					    Array.prototype.every = function(fn, context) {
					      for (var i = 0, len = this.length >>> 0; i < len; i++) {
					        if (i in this && !fn.call(context, this[i], i, this)) {
					          return false;
					        }
					      }
					      return true;
					    };
					  }
					
					  if (!Array.prototype.some) {
					    /**
					     * Returns true if a callback returns truthy value for at least one element in an array
					     * @param {Function} fn Callback to invoke for each element
					     * @param {Object} [context] Context to invoke callback in
					     * @return {Boolean}
					     */
					    Array.prototype.some = function(fn, context) {
					      for (var i = 0, len = this.length >>> 0; i < len; i++) {
					        if (i in this && fn.call(context, this[i], i, this)) {
					          return true;
					        }
					      }
					      return false;
					    };
					  }
					
					  if (!Array.prototype.filter) {
					    /**
					     * Returns the result of iterating over elements in an array
					     * @param {Function} fn Callback to invoke for each element
					     * @param {Object} [context] Context to invoke callback in
					     * @return {Array}
					     */
					    Array.prototype.filter = function(fn, context) {
					      var result = [ ], val;
					      for (var i = 0, len = this.length >>> 0; i < len; i++) {
					        if (i in this) {
					          val = this[i]; // in case fn mutates this
					          if (fn.call(context, val, i, this)) {
					            result.push(val);
					          }
					        }
					      }
					      return result;
					    };
					  }
					
					  if (!Array.prototype.reduce) {
					    /**
					     * Returns "folded" (reduced) result of iterating over elements in an array
					     * @param {Function} fn Callback to invoke for each element
					     * @param {Object} [initial] Object to use as the first argument to the first call of the callback
					     * @return {Any}
					     */
					    Array.prototype.reduce = function(fn /*, initial*/) {
					      var len = this.length >>> 0,
					          i = 0,
					          rv;
					
					      if (arguments.length > 1) {
					        rv = arguments[1];
					      }
					      else {
					        do {
					          if (i in this) {
					            rv = this[i++];
					            break;
					          }
					          // if array contains no values, no initial value to return
					          if (++i >= len) {
					            throw new TypeError();
					          }
					        }
					        while (true);
					      }
					      for (; i < len; i++) {
					        if (i in this) {
					          rv = fn.call(null, rv, this[i], i, this);
					        }
					      }
					      return rv;
					    };
					  }
					
					  /* _ES5_COMPAT_END_ */
					
					  /**
					   * Invokes method on all items in a given array
					   * @memberOf fabric.util.array
					   * @param {Array} array Array to iterate over
					   * @param {String} method Name of a method to invoke
					   * @return {Array}
					   */
					  function invoke(array, method) {
					    var args = slice.call(arguments, 2), result = [ ];
					    for (var i = 0, len = array.length; i < len; i++) {
					      result[i] = args.length ? array[i][method].apply(array[i], args) : array[i][method].call(array[i]);
					    }
					    return result;
					  }
					
					  /**
					   * Finds maximum value in array (not necessarily "first" one)
					   * @memberOf fabric.util.array
					   * @param {Array} array Array to iterate over
					   * @param {String} byProperty
					   * @return {Any}
					   */
					  function max(array, byProperty) {
					    return find(array, byProperty, function(value1, value2) {
					      return value1 >= value2;
					    });
					  }
					
					  /**
					   * Finds minimum value in array (not necessarily "first" one)
					   * @memberOf fabric.util.array
					   * @param {Array} array Array to iterate over
					   * @param {String} byProperty
					   * @return {Any}
					   */
					  function min(array, byProperty) {
					    return find(array, byProperty, function(value1, value2) {
					      return value1 < value2;
					    });
					  }
					
					  /**
					   * @private
					   */
					  function find(array, byProperty, condition) {
					    if (!array || array.length === 0) {
					      return;
					    }
					
					    var i = array.length - 1,
					        result = byProperty ? array[i][byProperty] : array[i];
					    if (byProperty) {
					      while (i--) {
					        if (condition(array[i][byProperty], result)) {
					          result = array[i][byProperty];
					        }
					      }
					    }
					    else {
					      while (i--) {
					        if (condition(array[i], result)) {
					          result = array[i];
					        }
					      }
					    }
					    return result;
					  }
					
					  /**
					   * @namespace fabric.util.array
					   */
					  fabric.util.array = {
					    invoke: invoke,
					    min: min,
					    max: max
					  };
					
					})();
					(function() {
					
					  /**
					   * Copies all enumerable properties of one object to another
					   * @memberOf fabric.util.object
					   * @param {Object} destination Where to copy to
					   * @param {Object} source Where to copy from
					   * @return {Object}
					   */
					  function extend(destination, source) {
					    // JScript DontEnum bug is not taken care of
					    for (var property in source) {
					      destination[property] = source[property];
					    }
					    return destination;
					  }
					
					  /**
					   * Creates an empty object and copies all enumerable properties of another object to it
					   * @memberOf fabric.util.object
					   * @param {Object} object Object to clone
					   * @return {Object}
					   */
					  function clone(object) {
					    return extend({ }, object);
					  }
					
					  /** @namespace fabric.util.object */
					  fabric.util.object = {
					    extend: extend,
					    clone: clone
					  };
					
					})();
					(function() {
					
					  /* _ES5_COMPAT_START_ */
					  if (!String.prototype.trim) {
					    /**
					     * Trims a string (removing whitespace from the beginning and the end)
					     * @function external:String#trim
					     * @see <a href="https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/String/Trim">String#trim on MDN</a>
					     */
					    String.prototype.trim = function () {
					      // this trim is not fully ES3 or ES5 compliant, but it should cover most cases for now
					      return this.replace(/^[\s\xA0]+/, '').replace(/[\s\xA0]+$/, '');
					    };
					  }
					  /* _ES5_COMPAT_END_ */
					
					  /**
					   * Camelizes a string
					   * @memberOf fabric.util.string
					   * @param {String} string String to camelize
					   * @return {String} Camelized version of a string
					   */
					  function camelize(string) {
					    return string.replace(/-+(.)?/g, function(match, character) {
					      return character ? character.toUpperCase() : '';
					    });
					  }
					
					  /**
					   * Capitalizes a string
					   * @memberOf fabric.util.string
					   * @param {String} string String to capitalize
					   * @param {Boolean} [firstLetterOnly] If true only first letter is capitalized
					   * and other letters stay untouched, if false first letter is capitalized
					   * and other letters are converted to lowercase.
					   * @return {String} Capitalized version of a string
					   */
					  function capitalize(string, firstLetterOnly) {
					    return string.charAt(0).toUpperCase() +
					      (firstLetterOnly ? string.slice(1) : string.slice(1).toLowerCase());
					  }
					
					  /**
					   * Escapes XML in a string
					   * @memberOf fabric.util.string
					   * @param {String} string String to escape
					   * @return {String} Escaped version of a string
					   */
					  function escapeXml(string) {
					    return string.replace(/&/g, '&amp;')
					       .replace(/"/g, '&quot;')
					       .replace(/'/g, '&apos;')
					       .replace(/</g, '&lt;')
					       .replace(/>/g, '&gt;');
					  }
					
					  /**
					   * String utilities
					   * @namespace fabric.util.string
					   */
					  fabric.util.string = {
					    camelize: camelize,
					    capitalize: capitalize,
					    escapeXml: escapeXml
					  };
					}());
					/* _ES5_COMPAT_START_ */
					(function() {
					
					  var slice = Array.prototype.slice,
					      apply = Function.prototype.apply,
					      Dummy = function() { };
					
					  if (!Function.prototype.bind) {
					    /**
					     * Cross-browser approximation of ES5 Function.prototype.bind (not fully spec conforming)
					     * @see <a href="https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Function/bind">Function#bind on MDN</a>
					     * @param {Object} thisArg Object to bind function to
					     * @param {Any[]} [...] Values to pass to a bound function
					     * @return {Function}
					     */
					    Function.prototype.bind = function(thisArg) {
					      var _this = this, args = slice.call(arguments, 1), bound;
					      if (args.length) {
					        bound = function() {
					          return apply.call(_this, this instanceof Dummy ? this : thisArg, args.concat(slice.call(arguments)));
					        };
					      }
					      else {
					        /** @ignore */
					        bound = function() {
					          return apply.call(_this, this instanceof Dummy ? this : thisArg, arguments);
					        };
					      }
					      Dummy.prototype = this.prototype;
					      bound.prototype = new Dummy();
					
					      return bound;
					    };
					  }
					
					})();
					/* _ES5_COMPAT_END_ */
					(function() {
					
					  var slice = Array.prototype.slice, emptyFunction = function() { },
					
					      IS_DONTENUM_BUGGY = (function() {
					        for (var p in { toString: 1 }) {
					          if (p === 'toString') {
					            return false;
					          }
					        }
					        return true;
					      })(),
					
					      /** @ignore */
					      addMethods = function(klass, source, parent) {
					        for (var property in source) {
					
					          if (property in klass.prototype &&
					              typeof klass.prototype[property] === 'function' &&
					              (source[property] + '').indexOf('callSuper') > -1) {
					
					            klass.prototype[property] = (function(property) {
					              return function() {
					
					                var superclass = this.constructor.superclass;
					                this.constructor.superclass = parent;
					                var returnValue = source[property].apply(this, arguments);
					                this.constructor.superclass = superclass;
					
					                if (property !== 'initialize') {
					                  return returnValue;
					                }
					              };
					            })(property);
					          }
					          else {
					            klass.prototype[property] = source[property];
					          }
					
					          if (IS_DONTENUM_BUGGY) {
					            if (source.toString !== Object.prototype.toString) {
					              klass.prototype.toString = source.toString;
					            }
					            if (source.valueOf !== Object.prototype.valueOf) {
					              klass.prototype.valueOf = source.valueOf;
					            }
					          }
					        }
					      };
					
					  function Subclass() { }
					
					  function callSuper(methodName) {
					    var fn = this.constructor.superclass.prototype[methodName];
					    return (arguments.length > 1)
					      ? fn.apply(this, slice.call(arguments, 1))
					      : fn.call(this);
					  }
					
					  /**
					   * Helper for creation of "classes".
					   * @memberOf fabric.util
					   * @param {Function} [parent] optional "Class" to inherit from
					   * @param {Object} [properties] Properties shared by all instances of this class
					   *                  (be careful modifying objects defined here as this would affect all instances)
					   */
					  function createClass() {
					    var parent = null,
					        properties = slice.call(arguments, 0);
					
					    if (typeof properties[0] === 'function') {
					      parent = properties.shift();
					    }
					    function klass() {
					      this.initialize.apply(this, arguments);
					    }
					
					    klass.superclass = parent;
					    klass.subclasses = [ ];
					
					    if (parent) {
					      Subclass.prototype = parent.prototype;
					      klass.prototype = new Subclass();
					      parent.subclasses.push(klass);
					    }
					    for (var i = 0, length = properties.length; i < length; i++) {
					      addMethods(klass, properties[i], parent);
					    }
					    if (!klass.prototype.initialize) {
					      klass.prototype.initialize = emptyFunction;
					    }
					    klass.prototype.constructor = klass;
					    klass.prototype.callSuper = callSuper;
					    return klass;
					  }
					
					  fabric.util.createClass = createClass;
					})();
					(function () {
					
					  var unknown = 'unknown';
					
					  /* EVENT HANDLING */
					
					  function areHostMethods(object) {
					    var methodNames = Array.prototype.slice.call(arguments, 1),
					        t, i, len = methodNames.length;
					    for (i = 0; i < len; i++) {
					      t = typeof object[methodNames[i]];
					      if (!(/^(?:function|object|unknown)$/).test(t)) {
					        return false;
					      }
					    }
					    return true;
					  }
					
					  /** @ignore */
					  var getElement,
					      setElement,
					      getUniqueId = (function () {
					        var uid = 0;
					        return function (element) {
					          return element.__uniqueID || (element.__uniqueID = 'uniqueID__' + uid++);
					        };
					      })();
					
					  (function () {
					    var elements = { };
					    /** @ignore */
					    getElement = function (uid) {
					      return elements[uid];
					    };
					    /** @ignore */
					    setElement = function (uid, element) {
					      elements[uid] = element;
					    };
					  })();
					
					  function createListener(uid, handler) {
					    return {
					      handler: handler,
					      wrappedHandler: createWrappedHandler(uid, handler)
					    };
					  }
					
					  function createWrappedHandler(uid, handler) {
					    return function (e) {
					      handler.call(getElement(uid), e || fabric.window.event);
					    };
					  }
					
					  function createDispatcher(uid, eventName) {
					    return function (e) {
					      if (handlers[uid] && handlers[uid][eventName]) {
					        var handlersForEvent = handlers[uid][eventName];
					        for (var i = 0, len = handlersForEvent.length; i < len; i++) {
					          handlersForEvent[i].call(this, e || fabric.window.event);
					        }
					      }
					    };
					  }
					
					  var shouldUseAddListenerRemoveListener = (
					        areHostMethods(fabric.document.documentElement, 'addEventListener', 'removeEventListener') &&
					        areHostMethods(fabric.window, 'addEventListener', 'removeEventListener')),
					
					      shouldUseAttachEventDetachEvent = (
					        areHostMethods(fabric.document.documentElement, 'attachEvent', 'detachEvent') &&
					        areHostMethods(fabric.window, 'attachEvent', 'detachEvent')),
					
					      // IE branch
					      listeners = { },
					
					      // DOM L0 branch
					      handlers = { },
					
					      addListener, removeListener;
					
					  if (shouldUseAddListenerRemoveListener) {
					    /** @ignore */
					    addListener = function (element, eventName, handler) {
					      element.addEventListener(eventName, handler, false);
					    };
					    /** @ignore */
					    removeListener = function (element, eventName, handler) {
					      element.removeEventListener(eventName, handler, false);
					    };
					  }
					
					  else if (shouldUseAttachEventDetachEvent) {
					    /** @ignore */
					    addListener = function (element, eventName, handler) {
					      var uid = getUniqueId(element);
					      setElement(uid, element);
					      if (!listeners[uid]) {
					        listeners[uid] = { };
					      }
					      if (!listeners[uid][eventName]) {
					        listeners[uid][eventName] = [ ];
					
					      }
					      var listener = createListener(uid, handler);
					      listeners[uid][eventName].push(listener);
					      element.attachEvent('on' + eventName, listener.wrappedHandler);
					    };
					    /** @ignore */
					    removeListener = function (element, eventName, handler) {
					      var uid = getUniqueId(element), listener;
					      if (listeners[uid] && listeners[uid][eventName]) {
					        for (var i = 0, len = listeners[uid][eventName].length; i < len; i++) {
					          listener = listeners[uid][eventName][i];
					          if (listener && listener.handler === handler) {
					            element.detachEvent('on' + eventName, listener.wrappedHandler);
					            listeners[uid][eventName][i] = null;
					          }
					        }
					      }
					    };
					  }
					  else {
					    /** @ignore */
					    addListener = function (element, eventName, handler) {
					      var uid = getUniqueId(element);
					      if (!handlers[uid]) {
					        handlers[uid] = { };
					      }
					      if (!handlers[uid][eventName]) {
					        handlers[uid][eventName] = [ ];
					        var existingHandler = element['on' + eventName];
					        if (existingHandler) {
					          handlers[uid][eventName].push(existingHandler);
					        }
					        element['on' + eventName] = createDispatcher(uid, eventName);
					      }
					      handlers[uid][eventName].push(handler);
					    };
					    /** @ignore */
					    removeListener = function (element, eventName, handler) {
					      var uid = getUniqueId(element);
					      if (handlers[uid] && handlers[uid][eventName]) {
					        var handlersForEvent = handlers[uid][eventName];
					        for (var i = 0, len = handlersForEvent.length; i < len; i++) {
					          if (handlersForEvent[i] === handler) {
					            handlersForEvent.splice(i, 1);
					          }
					        }
					      }
					    };
					  }
					
					  /**
					   * Adds an event listener to an element
					   * @function
					   * @memberOf fabric.util
					   * @param {HTMLElement} element
					   * @param {String} eventName
					   * @param {Function} handler
					   */
					  fabric.util.addListener = addListener;
					
					  /**
					   * Removes an event listener from an element
					   * @function
					   * @memberOf fabric.util
					   * @param {HTMLElement} element
					   * @param {String} eventName
					   * @param {Function} handler
					   */
					  fabric.util.removeListener = removeListener;
					
					  /**
					   * Cross-browser wrapper for getting event's coordinates
					   * @memberOf fabric.util
					   * @param {Event} event Event object
					   * @param {HTMLCanvasElement} upperCanvasEl &lt;canvas> element on which object selection is drawn
					   */
					  function getPointer(event, upperCanvasEl) {
					    event || (event = fabric.window.event);
					
					    var element = event.target ||
					                  (typeof event.srcElement !== unknown ? event.srcElement : null),
					
					        scroll = fabric.util.getScrollLeftTop(element, upperCanvasEl);
					
					    return {
					      x: pointerX(event) + scroll.left,
					      y: pointerY(event) + scroll.top
					    };
					  }
					
					  var pointerX = function(event) {
					    // looks like in IE (<9) clientX at certain point (apparently when mouseup fires on VML element)
					    // is represented as COM object, with all the consequences, like "unknown" type and error on [[Get]]
					    // need to investigate later
					    return (typeof event.clientX !== unknown ? event.clientX : 0);
					  },
					
					  pointerY = function(event) {
					    return (typeof event.clientY !== unknown ? event.clientY : 0);
					  };
					
					  function _getPointer(event, pageProp, clientProp) {
					    var touchProp = event.type === 'touchend' ? 'changedTouches' : 'touches';
					
					    return (event[touchProp] && event[touchProp][0]
					      ? (event[touchProp][0][pageProp] - (event[touchProp][0][pageProp] - event[touchProp][0][clientProp]))
					        || event[clientProp]
					      : event[clientProp]);
					  }
					
					  if (fabric.isTouchSupported) {
					    pointerX = function(event) {
					      return _getPointer(event, 'pageX', 'clientX');
					    };
					    pointerY = function(event) {
					      return _getPointer(event, 'pageY', 'clientY');
					    };
					  }
					
					  fabric.util.getPointer = getPointer;
					
					  fabric.util.object.extend(fabric.util, fabric.Observable);
					
					})();
					(function () {
					
					  /**
					   * Cross-browser wrapper for setting element's style
					   * @memberOf fabric.util
					   * @param {HTMLElement} element
					   * @param {Object} styles
					   * @return {HTMLElement} Element that was passed as a first argument
					   */
					  function setStyle(element, styles) {
					    var elementStyle = element.style;
					    if (!elementStyle) {
					      return element;
					    }
					    if (typeof styles === 'string') {
					      element.style.cssText += ';' + styles;
					      return styles.indexOf('opacity') > -1
					        ? setOpacity(element, styles.match(/opacity:\s*(\d?\.?\d*)/)[1])
					        : element;
					    }
					    for (var property in styles) {
					      if (property === 'opacity') {
					        setOpacity(element, styles[property]);
					      }
					      else {
					        var normalizedProperty = (property === 'float' || property === 'cssFloat')
					          ? (typeof elementStyle.styleFloat === 'undefined' ? 'cssFloat' : 'styleFloat')
					          : property;
					        elementStyle[normalizedProperty] = styles[property];
					      }
					    }
					    return element;
					  }
					
					  var parseEl = fabric.document.createElement('div'),
					      supportsOpacity = typeof parseEl.style.opacity === 'string',
					      supportsFilters = typeof parseEl.style.filter === 'string',
					      reOpacity = /alpha\s*\(\s*opacity\s*=\s*([^\)]+)\)/,
					
					      /** @ignore */
					      setOpacity = function (element) { return element; };
					
					  if (supportsOpacity) {
					    /** @ignore */
					    setOpacity = function(element, value) {
					      element.style.opacity = value;
					      return element;
					    };
					  }
					  else if (supportsFilters) {
					    /** @ignore */
					    setOpacity = function(element, value) {
					      var es = element.style;
					      if (element.currentStyle && !element.currentStyle.hasLayout) {
					        es.zoom = 1;
					      }
					      if (reOpacity.test(es.filter)) {
					        value = value >= 0.9999 ? '' : ('alpha(opacity=' + (value * 100) + ')');
					        es.filter = es.filter.replace(reOpacity, value);
					      }
					      else {
					        es.filter += ' alpha(opacity=' + (value * 100) + ')';
					      }
					      return element;
					    };
					  }
					
					  fabric.util.setStyle = setStyle;
					
					})();
					(function() {
					
					  var _slice = Array.prototype.slice;
					
					  /**
					   * Takes id and returns an element with that id (if one exists in a document)
					   * @memberOf fabric.util
					   * @param {String|HTMLElement} id
					   * @return {HTMLElement|null}
					   */
					  function getById(id) {
					    return typeof id === 'string' ? fabric.document.getElementById(id) : id;
					  }
					
					  var sliceCanConvertNodelists,
					      /* * !!! Misplaced docstring acc. to closure compiler
					       * Converts an array-like object (e.g. arguments or NodeList) to an array
					       * @memberOf fabric.util
					       * @param {Object} arrayLike
					       * @return {Array}
					       */
					      toArray = function(arrayLike) {
					        return _slice.call(arrayLike, 0);
					      };
					
					  try {
					    sliceCanConvertNodelists = toArray(fabric.document.childNodes) instanceof Array;
					  }
					  catch (err) { }
					
					  if (!sliceCanConvertNodelists) {
					    toArray = function(arrayLike) {
					      var arr = new Array(arrayLike.length), i = arrayLike.length;
					      while (i--) {
					        arr[i] = arrayLike[i];
					      }
					      return arr;
					    };
					  }
					
					  /**
					   * Creates specified element with specified attributes
					   * @memberOf fabric.util
					   * @param {String} tagName Type of an element to create
					   * @param {Object} [attributes] Attributes to set on an element
					   * @return {HTMLElement} Newly created element
					   */
					  function makeElement(tagName, attributes) {
					    var el = fabric.document.createElement(tagName);
					    for (var prop in attributes) {
					      if (prop === 'class') {
					        el.className = attributes[prop];
					      }
					      else if (prop === 'for') {
					        el.htmlFor = attributes[prop];
					      }
					      else {
					        el.setAttribute(prop, attributes[prop]);
					      }
					    }
					    return el;
					  }
					
					  /**
					   * Adds class to an element
					   * @memberOf fabric.util
					   * @param {HTMLElement} element Element to add class to
					   * @param {String} className Class to add to an element
					   */
					  function addClass(element, className) {
					    if (element && (' ' + element.className + ' ').indexOf(' ' + className + ' ') === -1) {
					      element.className += (element.className ? ' ' : '') + className;
					    }
					  }
					
					  /**
					   * Wraps element with another element
					   * @memberOf fabric.util
					   * @param {HTMLElement} element Element to wrap
					   * @param {HTMLElement|String} wrapper Element to wrap with
					   * @param {Object} [attributes] Attributes to set on a wrapper
					   * @return {HTMLElement} wrapper
					   */
					  function wrapElement(element, wrapper, attributes) {
					    if (typeof wrapper === 'string') {
					      wrapper = makeElement(wrapper, attributes);
					    }
					    if (element.parentNode) {
					      element.parentNode.replaceChild(wrapper, element);
					    }
					    wrapper.appendChild(element);
					    return wrapper;
					  }
					
					  /**
					   * Returns element scroll offsets
					   * @memberOf fabric.util
					   * @param {HTMLElement} element Element to operate on
					   * @param {HTMLElement} upperCanvasEl Upper canvas element
					   * @return {Object} Object with left/top values
					   */
					  function getScrollLeftTop(element, upperCanvasEl) {
					
					    var firstFixedAncestor,
					        origElement,
					        left = 0,
					        top = 0,
					        docElement = fabric.document.documentElement,
					        body = fabric.document.body || {
					          scrollLeft: 0, scrollTop: 0
					        };
					
					    origElement = element;
					
					    while (element && element.parentNode && !firstFixedAncestor) {
					
					      element = element.parentNode;
					
					      if (element.nodeType === 1 &&
					          fabric.util.getElementStyle(element, 'position') === 'fixed') {
					        firstFixedAncestor = element;
					      }
					
					      if (element.nodeType === 1 &&
					          origElement !== upperCanvasEl &&
					          fabric.util.getElementStyle(element, 'position') === 'absolute') {
					        left = 0;
					        top = 0;
					      }
					      else if (element === fabric.document) {
					        left = body.scrollLeft || docElement.scrollLeft || 0;
					        top = body.scrollTop ||  docElement.scrollTop || 0;
					      }
					      else {
					        left += element.scrollLeft || 0;
					        top += element.scrollTop || 0;
					      }
					    }
					
					    return { left: left, top: top };
					  }
					
					  /**
					   * Returns offset for a given element
					   * @function
					   * @memberOf fabric.util
					   * @param {HTMLElement} element Element to get offset for
					   * @return {Object} Object with "left" and "top" properties
					   */
					  function getElementOffset(element) {
					    var docElem,
					        doc = element && element.ownerDocument,
					        box = { left: 0, top: 0 },
					        offset = { left: 0, top: 0 },
					        scrollLeftTop,
					        offsetAttributes = {
					          borderLeftWidth: 'left',
					          borderTopWidth:  'top',
					          paddingLeft:     'left',
					          paddingTop:      'top'
					        };
					
					    if (!doc) {
					      return { left: 0, top: 0 };
					    }
					
					    for (var attr in offsetAttributes) {
					      offset[offsetAttributes[attr]] += parseInt(getElementStyle(element, attr), 10) || 0;
					    }
					
					    docElem = doc.documentElement;
					    if ( typeof element.getBoundingClientRect !== 'undefined' ) {
					      box = element.getBoundingClientRect();
					    }
					
					    scrollLeftTop = fabric.util.getScrollLeftTop(element, null);
					
					    return {
					      left: box.left + scrollLeftTop.left - (docElem.clientLeft || 0) + offset.left,
					      top: box.top + scrollLeftTop.top - (docElem.clientTop || 0)  + offset.top
					    };
					  }
					
					  /**
					  * Returns style attribute value of a given element
					  * @memberOf fabric.util
					  * @param {HTMLElement} element Element to get style attribute for
					  * @param {String} attr Style attribute to get for element
					  * @return {String} Style attribute value of the given element.
					  */
					  var getElementStyle;
					  if (fabric.document.defaultView && fabric.document.defaultView.getComputedStyle) {
					    getElementStyle = function(element, attr) {
					      var style = fabric.document.defaultView.getComputedStyle(element, null);
					      return style ? style[attr] : undefined;
					    };
					  }
					  else {
					    getElementStyle = function(element, attr) {
					      var value = element.style[attr];
					      if (!value && element.currentStyle) {
					        value = element.currentStyle[attr];
					      }
					      return value;
					    };
					  }
					
					  (function () {
					    var style = fabric.document.documentElement.style,
					        selectProp = 'userSelect' in style
					          ? 'userSelect'
					          : 'MozUserSelect' in style
					            ? 'MozUserSelect'
					            : 'WebkitUserSelect' in style
					              ? 'WebkitUserSelect'
					              : 'KhtmlUserSelect' in style
					                ? 'KhtmlUserSelect'
					                : '';
					
					    /**
					     * Makes element unselectable
					     * @memberOf fabric.util
					     * @param {HTMLElement} element Element to make unselectable
					     * @return {HTMLElement} Element that was passed in
					     */
					    function makeElementUnselectable(element) {
					      if (typeof element.onselectstart !== 'undefined') {
					        element.onselectstart = fabric.util.falseFunction;
					      }
					      if (selectProp) {
					        element.style[selectProp] = 'none';
					      }
					      else if (typeof element.unselectable === 'string') {
					        element.unselectable = 'on';
					      }
					      return element;
					    }
					
					    /**
					     * Makes element selectable
					     * @memberOf fabric.util
					     * @param {HTMLElement} element Element to make selectable
					     * @return {HTMLElement} Element that was passed in
					     */
					    function makeElementSelectable(element) {
					      if (typeof element.onselectstart !== 'undefined') {
					        element.onselectstart = null;
					      }
					      if (selectProp) {
					        element.style[selectProp] = '';
					      }
					      else if (typeof element.unselectable === 'string') {
					        element.unselectable = '';
					      }
					      return element;
					    }
					
					    fabric.util.makeElementUnselectable = makeElementUnselectable;
					    fabric.util.makeElementSelectable = makeElementSelectable;
					  })();
					
					  (function() {
					
					    /**
					     * Inserts a script element with a given url into a document; invokes callback, when that script is finished loading
					     * @memberOf fabric.util
					     * @param {String} url URL of a script to load
					     * @param {Function} callback Callback to execute when script is finished loading
					     */
					    function getScript(url, callback) {
					      var headEl = fabric.document.getElementsByTagName('head')[0],
					          scriptEl = fabric.document.createElement('script'),
					          loading = true;
					
					      /** @ignore */
					      scriptEl.onload = /** @ignore */ scriptEl.onreadystatechange = function(e) {
					        if (loading) {
					          if (typeof this.readyState === 'string' &&
					              this.readyState !== 'loaded' &&
					              this.readyState !== 'complete') {
					            return;
					          }
					          loading = false;
					          callback(e || fabric.window.event);
					          scriptEl = scriptEl.onload = scriptEl.onreadystatechange = null;
					        }
					      };
					      scriptEl.src = url;
					      headEl.appendChild(scriptEl);
					      // causes issue in Opera
					      // headEl.removeChild(scriptEl);
					    }
					
					    fabric.util.getScript = getScript;
					  })();
					
					  fabric.util.getById = getById;
					  fabric.util.toArray = toArray;
					  fabric.util.makeElement = makeElement;
					  fabric.util.addClass = addClass;
					  fabric.util.wrapElement = wrapElement;
					  fabric.util.getScrollLeftTop = getScrollLeftTop;
					  fabric.util.getElementOffset = getElementOffset;
					  fabric.util.getElementStyle = getElementStyle;
					
					})();
					(function() {
					
					  function addParamToUrl(url, param) {
					    return url + (/\?/.test(url) ? '&' : '?') + param;
					  }
					
					  var makeXHR = (function() {
					    var factories = [
					      function() { return new ActiveXObject('Microsoft.XMLHTTP'); },
					      function() { return new ActiveXObject('Msxml2.XMLHTTP'); },
					      function() { return new ActiveXObject('Msxml2.XMLHTTP.3.0'); },
					      function() { return new XMLHttpRequest(); }
					    ];
					    for (var i = factories.length; i--; ) {
					      try {
					        var req = factories[i]();
					        if (req) {
					          return factories[i];
					        }
					      }
					      catch (err) { }
					    }
					  })();
					
					  function emptyFn() { }
					
					  /**
					   * Cross-browser abstraction for sending XMLHttpRequest
					   * @memberOf fabric.util
					   * @param {String} url URL to send XMLHttpRequest to
					   * @param {Object} [options] Options object
					   * @param {String} [options.method="GET"]
					   * @param {Function} options.onComplete Callback to invoke when request is completed
					   * @return {XMLHttpRequest} request
					   */
					  function request(url, options) {
					
					    options || (options = { });
					
					    var method = options.method ? options.method.toUpperCase() : 'GET',
					        onComplete = options.onComplete || function() { },
					        xhr = makeXHR(),
					        body;
					
					    /** @ignore */
					    xhr.onreadystatechange = function() {
					      if (xhr.readyState === 4) {
					        onComplete(xhr);
					        xhr.onreadystatechange = emptyFn;
					      }
					    };
					
					    if (method === 'GET') {
					      body = null;
					      if (typeof options.parameters === 'string') {
					        url = addParamToUrl(url, options.parameters);
					      }
					    }
					
					    xhr.open(method, url, true);
					
					    if (method === 'POST' || method === 'PUT') {
					      xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
					    }
					
					    xhr.send(body);
					    return xhr;
					  }
					
					  fabric.util.request = request;
					})();
					/**
					 * Wrapper around `console.log` (when available)
					 * @param {Any} [values] Values to log
					 */
					fabric.log = function() { };
					
					/**
					 * Wrapper around `console.warn` (when available)
					 * @param {Any} [values] Values to log as a warning
					 */
					fabric.warn = function() { };
					
					if (typeof console !== 'undefined') {
					
					  ['log', 'warn'].forEach(function(methodName) {
					
					    if (typeof console[methodName] !== 'undefined' &&
					        typeof console[methodName].apply === 'function') {
					
					      fabric[methodName] = function() {
					        return console[methodName].apply(console, arguments);
					      };
					    }
					  });
					}
					(function(global) {
					
					  'use strict';
					
					  /* Adaptation of work of Kevin Lindsey (kevin@kevlindev.com) */
					
					  var fabric = global.fabric || (global.fabric = { });
					
					  if (fabric.Point) {
					    fabric.warn('fabric.Point is already defined');
					    return;
					  }
					
					  fabric.Point = Point;
					
					  /**
					   * Point class
					   * @class fabric.Point
					   * @memberOf fabric
					   * @constructor
					   * @param {Number} x
					   * @param {Number} y
					   * @return {fabric.Point} thisArg
					   */
					  function Point(x, y) {
					    this.x = x;
					    this.y = y;
					  }
					
					  Point.prototype = /** @lends fabric.Point.prototype */ {
					
					    constructor: Point,
					
					    /**
					     * Adds another point to this one and returns another one
					     * @param {fabric.Point} that
					     * @return {fabric.Point} new Point instance with added values
					     */
					    add: function (that) {
					      return new Point(this.x + that.x, this.y + that.y);
					    },
					
					    /**
					     * Adds another point to this one
					     * @param {fabric.Point} that
					     * @return {fabric.Point} thisArg
					     */
					    addEquals: function (that) {
					      this.x += that.x;
					      this.y += that.y;
					      return this;
					    },
					
					    /**
					     * Adds value to this point and returns a new one
					     * @param {Number} scalar
					     * @return {fabric.Point} new Point with added value
					     */
					    scalarAdd: function (scalar) {
					      return new Point(this.x + scalar, this.y + scalar);
					    },
					
					    /**
					     * Adds value to this point
					     * @param {Number} scalar
					     * @return {fabric.Point} thisArg
					     */
					    scalarAddEquals: function (scalar) {
					      this.x += scalar;
					      this.y += scalar;
					      return this;
					    },
					
					    /**
					     * Subtracts another point from this point and returns a new one
					     * @param {fabric.Point} that
					     * @return {fabric.Point} new Point object with subtracted values
					     */
					    subtract: function (that) {
					      return new Point(this.x - that.x, this.y - that.y);
					    },
					
					    /**
					     * Subtracts another point from this point
					     * @param {fabric.Point} that
					     * @return {fabric.Point} thisArg
					     */
					    subtractEquals: function (that) {
					      this.x -= that.x;
					      this.y -= that.y;
					      return this;
					    },
					
					    /**
					     * Subtracts value from this point and returns a new one
					     * @param {Number} scalar
					     * @return {fabric.Point}
					     */
					    scalarSubtract: function (scalar) {
					      return new Point(this.x - scalar, this.y - scalar);
					    },
					
					    /**
					     * Subtracts value from this point
					     * @param {Number} scalar
					     * @return {fabric.Point} thisArg
					     */
					    scalarSubtractEquals: function (scalar) {
					      this.x -= scalar;
					      this.y -= scalar;
					      return this;
					    },
					
					    /**
					     * Miltiplies this point by a value and returns a new one
					     * @param {Number} scalar
					     * @return {fabric.Point}
					     */
					    multiply: function (scalar) {
					      return new Point(this.x * scalar, this.y * scalar);
					    },
					
					    /**
					     * Miltiplies this point by a value
					     * @param {Number} scalar
					     * @return {fabric.Point} thisArg
					     */
					    multiplyEquals: function (scalar) {
					      this.x *= scalar;
					      this.y *= scalar;
					      return this;
					    },
					
					    /**
					     * Divides this point by a value and returns a new one
					     * @param {Number} scalar
					     * @return {fabric.Point}
					     */
					    divide: function (scalar) {
					      return new Point(this.x / scalar, this.y / scalar);
					    },
					
					    /**
					     * Divides this point by a value
					     * @param {Number} scalar
					     * @return {fabric.Point} thisArg
					     */
					    divideEquals: function (scalar) {
					      this.x /= scalar;
					      this.y /= scalar;
					      return this;
					    },
					
					    /**
					     * Returns true if this point is equal to another one
					     * @param {fabric.Point} that
					     * @return {Boolean}
					     */
					    eq: function (that) {
					      return (this.x === that.x && this.y === that.y);
					    },
					
					    /**
					     * Returns true if this point is less than another one
					     * @param {fabric.Point} that
					     * @return {Boolean}
					     */
					    lt: function (that) {
					      return (this.x < that.x && this.y < that.y);
					    },
					
					    /**
					     * Returns true if this point is less than or equal to another one
					     * @param {fabric.Point} that
					     * @return {Boolean}
					     */
					    lte: function (that) {
					      return (this.x <= that.x && this.y <= that.y);
					    },
					
					    /**
					
					     * Returns true if this point is greater another one
					     * @param {fabric.Point} that
					     * @return {Boolean}
					     */
					    gt: function (that) {
					      return (this.x > that.x && this.y > that.y);
					    },
					
					    /**
					     * Returns true if this point is greater than or equal to another one
					     * @param {fabric.Point} that
					     * @return {Boolean}
					     */
					    gte: function (that) {
					      return (this.x >= that.x && this.y >= that.y);
					    },
					
					    /**
					     * Returns new point which is the result of linear interpolation with this one and another one
					     * @param {fabric.Point} that
					     * @param {Number} t
					     * @return {fabric.Point}
					     */
					    lerp: function (that, t) {
					      return new Point(this.x + (that.x - this.x) * t, this.y + (that.y - this.y) * t);
					    },
					
					    /**
					     * Returns distance from this point and another one
					     * @param {fabric.Point} that
					     * @return {Number}
					     */
					    distanceFrom: function (that) {
					      var dx = this.x - that.x,
					          dy = this.y - that.y;
					      return Math.sqrt(dx * dx + dy * dy);
					    },
					
					    /**
					     * Returns the point between this point and another one
					     * @param {fabric.Point} that
					     * @return {fabric.Point}
					     */
					    midPointFrom: function (that) {
					      return new Point(this.x + (that.x - this.x)/2, this.y + (that.y - this.y)/2);
					    },
					
					    /**
					     * Returns a new point which is the min of this and another one
					     * @param {fabric.Point} that
					     * @return {fabric.Point}
					     */
					    min: function (that) {
					      return new Point(Math.min(this.x, that.x), Math.min(this.y, that.y));
					    },
					
					    /**
					     * Returns a new point which is the max of this and another one
					     * @param {fabric.Point} that
					     * @return {fabric.Point}
					     */
					    max: function (that) {
					      return new Point(Math.max(this.x, that.x), Math.max(this.y, that.y));
					    },
					
					    /**
					     * Returns string representation of this point
					     * @return {String}
					     */
					    toString: function () {
					      return this.x + ',' + this.y;
					    },
					
					    /**
					     * Sets x/y of this point
					     * @param {Number} x
					     * @param {Number} y
					     */
					    setXY: function (x, y) {
					      this.x = x;
					      this.y = y;
					    },
					
					    /**
					     * Sets x/y of this point from another point
					     * @param {fabric.Point} that
					     */
					    setFromPoint: function (that) {
					      this.x = that.x;
					      this.y = that.y;
					    },
					
					    /**
					     * Swaps x/y of this point and another point
					     * @param {fabric.Point} that
					     */
					    swap: function (that) {
					      var x = this.x,
					          y = this.y;
					      this.x = that.x;
					      this.y = that.y;
					      that.x = x;
					      that.y = y;
					    }
					  };
					
					})(typeof exports !== 'undefined' ? exports : this);
					(function(global) {
					
					  'use strict';
					
					  /* Adaptation of work of Kevin Lindsey (kevin@kevlindev.com) */
					  var fabric = global.fabric || (global.fabric = { });
					
					  if (fabric.Intersection) {
					    fabric.warn('fabric.Intersection is already defined');
					    return;
					  }
					
					  /**
					   * Intersection class
					   * @class fabric.Intersection
					   * @memberOf fabric
					   * @constructor
					   */
					  function Intersection(status) {
					    this.status = status;
					    this.points = [];
					  }
					
					  fabric.Intersection = Intersection;
					
					  fabric.Intersection.prototype = /** @lends fabric.Intersection.prototype */ {
					
					    /**
					     * Appends a point to intersection
					     * @param {fabric.Point} point
					     */
					    appendPoint: function (point) {
					      this.points.push(point);
					    },
					
					    /**
					     * Appends points to intersection
					     * @param {Array} points
					     */
					    appendPoints: function (points) {
					      this.points = this.points.concat(points);
					    }
					  };
					
					  /**
					   * Checks if one line intersects another
					   * @static
					   * @param {fabric.Point} a1
					   * @param {fabric.Point} a2
					   * @param {fabric.Point} b1
					   * @param {fabric.Point} b2
					   * @return {fabric.Intersection}
					   */
					  fabric.Intersection.intersectLineLine = function (a1, a2, b1, b2) {
					    var result,
					        uaT = (b2.x - b1.x) * (a1.y - b1.y) - (b2.y - b1.y) * (a1.x - b1.x),
					        ubT = (a2.x - a1.x) * (a1.y - b1.y) - (a2.y - a1.y) * (a1.x - b1.x),
					        uB = (b2.y - b1.y) * (a2.x - a1.x) - (b2.x - b1.x) * (a2.y - a1.y);
					    if (uB !== 0) {
					      var ua = uaT / uB,
					          ub = ubT / uB;
					      if (0 <= ua && ua <= 1 && 0 <= ub && ub <= 1) {
					        result = new Intersection('Intersection');
					        result.points.push(new fabric.Point(a1.x + ua * (a2.x - a1.x), a1.y + ua * (a2.y - a1.y)));
					      }
					      else {
					        result = new Intersection();
					      }
					    }
					    else {
					      if (uaT === 0 || ubT === 0) {
					        result = new Intersection('Coincident');
					      }
					      else {
					        result = new Intersection('Parallel');
					      }
					    }
					    return result;
					  };
					
					  /**
					   * Checks if line intersects polygon
					   * @static
					   * @param {fabric.Point} a1
					   * @param {fabric.Point} a2
					   * @param {Array} points
					   * @return {fabric.Intersection}
					   */
					  fabric.Intersection.intersectLinePolygon = function(a1, a2, points) {
					    var result = new Intersection(),
					        length = points.length;
					
					    for (var i = 0; i < length; i++) {
					      var b1 = points[i],
					          b2 = points[(i + 1) % length],
					          inter = Intersection.intersectLineLine(a1, a2, b1, b2);
					
					      result.appendPoints(inter.points);
					    }
					    if (result.points.length > 0) {
					      result.status = 'Intersection';
					    }
					    return result;
					  };
					
					  /**
					   * Checks if polygon intersects another polygon
					   * @static
					   * @param {Array} points1
					   * @param {Array} points2
					   * @return {fabric.Intersection}
					   */
					  fabric.Intersection.intersectPolygonPolygon = function (points1, points2) {
					    var result = new Intersection(),
					        length = points1.length;
					
					    for (var i = 0; i < length; i++) {
					      var a1 = points1[i],
					          a2 = points1[(i + 1) % length],
					          inter = Intersection.intersectLinePolygon(a1, a2, points2);
					
					      result.appendPoints(inter.points);
					    }
					    if (result.points.length > 0) {
					      result.status = 'Intersection';
					    }
					    return result;
					  };
					
					  /**
					   * Checks if polygon intersects rectangle
					   * @static
					   * @param {Array} points
					   * @param {Number} r1
					   * @param {Number} r2
					   * @return {fabric.Intersection}
					   */
					  fabric.Intersection.intersectPolygonRectangle = function (points, r1, r2) {
					    var min = r1.min(r2),
					        max = r1.max(r2),
					        topRight = new fabric.Point(max.x, min.y),
					        bottomLeft = new fabric.Point(min.x, max.y),
					        inter1 = Intersection.intersectLinePolygon(min, topRight, points),
					        inter2 = Intersection.intersectLinePolygon(topRight, max, points),
					        inter3 = Intersection.intersectLinePolygon(max, bottomLeft, points),
					        inter4 = Intersection.intersectLinePolygon(bottomLeft, min, points),
					        result = new Intersection();
					
					    result.appendPoints(inter1.points);
					    result.appendPoints(inter2.points);
					    result.appendPoints(inter3.points);
					    result.appendPoints(inter4.points);
					
					    if (result.points.length > 0) {
					      result.status = 'Intersection';
					    }
					    return result;
					  };
					
					})(typeof exports !== 'undefined' ? exports : this);
					(function(global) {
					
					  'use strict';
					
					  var fabric = global.fabric || (global.fabric = { });
					
					  if (fabric.Color) {
					    fabric.warn('fabric.Color is already defined.');
					    return;
					  }
					
					  /**
					   * Color class
					   * The purpose of {@link fabric.Color} is to abstract and encapsulate common color operations;
					   * {@link fabric.Color} is a constructor and creates instances of {@link fabric.Color} objects.
					   *
					   * @class fabric.Color
					   * @param {String} color optional in hex or rgb(a) format
					   * @return {fabric.Color} thisArg
					   * @tutorial {@link http://fabricjs.com/fabric-intro-part-2/#colors}
					   */
					  function Color(color) {
					    if (!color) {
					      this.setSource([0, 0, 0, 1]);
					    }
					    else {
					      this._tryParsingColor(color);
					    }
					  }
					
					  fabric.Color = Color;
					
					  fabric.Color.prototype = /** @lends fabric.Color.prototype */ {
					
					    /**
					     * @private
					     * @param {String|Array} color Color value to parse
					     */
					    _tryParsingColor: function(color) {
					      var source;
					
					      if (color in Color.colorNameMap) {
					        color = Color.colorNameMap[color];
					      }
					
					      if (color === 'transparent') {
					        this.setSource([255, 255, 255, 0]);
					        return;
					      }
					
					      source = Color.sourceFromHex(color);
					
					      if (!source) {
					        source = Color.sourceFromRgb(color);
					      }
					      if (!source) {
					        source = Color.sourceFromHsl(color);
					      }
					      if (source) {
					        this.setSource(source);
					      }
					    },
					
					    /**
					     * Adapted from <a href="https://rawgithub.com/mjijackson/mjijackson.github.com/master/2008/02/rgb-to-hsl-and-rgb-to-hsv-color-model-conversion-algorithms-in-javascript.html">https://github.com/mjijackson</a>
					     * @private
					     * @param {Number} r Red color value
					     * @param {Number} g Green color value
					     * @param {Number} b Blue color value
					     * @return {Array} Hsl color
					     */
					    _rgbToHsl: function(r, g, b) {
					      r /= 255, g /= 255, b /= 255;
					
					      var h, s, l,
					          max = fabric.util.array.max([r, g, b]),
					          min = fabric.util.array.min([r, g, b]);
					
					      l = (max + min) / 2;
					
					      if (max === min) {
					        h = s = 0; // achromatic
					      }
					      else {
					        var d = max - min;
					        s = l > 0.5 ? d / (2 - max - min) : d / (max + min);
					        switch (max) {
					          case r:
					            h = (g - b) / d + (g < b ? 6 : 0);
					            break;
					          case g:
					            h = (b - r) / d + 2;
					            break;
					          case b:
					            h = (r - g) / d + 4;
					            break;
					        }
					        h /= 6;
					      }
					
					      return [
					        Math.round(h * 360),
					        Math.round(s * 100),
					        Math.round(l * 100)
					      ];
					    },
					
					    /**
					     * Returns source of this color (where source is an array representation; ex: [200, 200, 100, 1])
					     * @return {Array}
					     */
					    getSource: function() {
					      return this._source;
					    },
					
					    /**
					     * Sets source of this color (where source is an array representation; ex: [200, 200, 100, 1])
					     * @param {Array} source
					     */
					    setSource: function(source) {
					      this._source = source;
					    },
					
					    /**
					     * Returns color represenation in RGB format
					     * @return {String} ex: rgb(0-255,0-255,0-255)
					     */
					    toRgb: function() {
					      var source = this.getSource();
					      return 'rgb(' + source[0] + ',' + source[1] + ',' + source[2] + ')';
					    },
					
					    /**
					     * Returns color represenation in RGBA format
					     * @return {String} ex: rgba(0-255,0-255,0-255,0-1)
					     */
					    toRgba: function() {
					      var source = this.getSource();
					      return 'rgba(' + source[0] + ',' + source[1] + ',' + source[2] + ',' + source[3] + ')';
					    },
					
					    /**
					     * Returns color represenation in HSL format
					     * @return {String} ex: hsl(0-360,0%-100%,0%-100%)
					     */
					    toHsl: function() {
					      var source = this.getSource(),
					          hsl = this._rgbToHsl(source[0], source[1], source[2]);
					
					      return 'hsl(' + hsl[0] + ',' + hsl[1] + '%,' + hsl[2] + '%)';
					    },
					
					    /**
					     * Returns color represenation in HSLA format
					     * @return {String} ex: hsla(0-360,0%-100%,0%-100%,0-1)
					     */
					    toHsla: function() {
					      var source = this.getSource(),
					          hsl = this._rgbToHsl(source[0], source[1], source[2]);
					
					      return 'hsla(' + hsl[0] + ',' + hsl[1] + '%,' + hsl[2] + '%,' + source[3] + ')';
					    },
					
					    /**
					     * Returns color represenation in HEX format
					     * @return {String} ex: FF5555
					     */
					    toHex: function() {
					      var source = this.getSource(), r, g, b;
					
					      r = source[0].toString(16);
					      r = (r.length === 1) ? ('0' + r) : r;
					
					      g = source[1].toString(16);
					      g = (g.length === 1) ? ('0' + g) : g;
					
					      b = source[2].toString(16);
					      b = (b.length === 1) ? ('0' + b) : b;
					
					      return r.toUpperCase() + g.toUpperCase() + b.toUpperCase();
					    },
					
					    /**
					     * Gets value of alpha channel for this color
					     * @return {Number} 0-1
					     */
					    getAlpha: function() {
					      return this.getSource()[3];
					    },
					
					    /**
					     * Sets value of alpha channel for this color
					     * @param {Number} alpha Alpha value 0-1
					     * @return {fabric.Color} thisArg
					     */
					    setAlpha: function(alpha) {
					      var source = this.getSource();
					      source[3] = alpha;
					      this.setSource(source);
					      return this;
					    },
					
					    /**
					     * Transforms color to its grayscale representation
					     * @return {fabric.Color} thisArg
					     */
					    toGrayscale: function() {
					      var source = this.getSource(),
					          average = parseInt((source[0] * 0.3 + source[1] * 0.59 + source[2] * 0.11).toFixed(0), 10),
					          currentAlpha = source[3];
					      this.setSource([average, average, average, currentAlpha]);
					      return this;
					    },
					
					    /**
					     * Transforms color to its black and white representation
					     * @param {Number} threshold
					     * @return {fabric.Color} thisArg
					     */
					    toBlackWhite: function(threshold) {
					      var source = this.getSource(),
					          average = (source[0] * 0.3 + source[1] * 0.59 + source[2] * 0.11).toFixed(0),
					          currentAlpha = source[3];
					
					      threshold = threshold || 127;
					
					      average = (Number(average) < Number(threshold)) ? 0 : 255;
					      this.setSource([average, average, average, currentAlpha]);
					      return this;
					    },
					
					    /**
					     * Overlays color with another color
					     * @param {String|fabric.Color} otherColor
					     * @return {fabric.Color} thisArg
					     */
					    overlayWith: function(otherColor) {
					      if (!(otherColor instanceof Color)) {
					        otherColor = new Color(otherColor);
					      }
					
					      var result = [],
					          alpha = this.getAlpha(),
					          otherAlpha = 0.5,
					          source = this.getSource(),
					          otherSource = otherColor.getSource();
					
					      for (var i = 0; i < 3; i++) {
					        result.push(Math.round((source[i] * (1 - otherAlpha)) + (otherSource[i] * otherAlpha)));
					      }
					
					      result[3] = alpha;
					      this.setSource(result);
					      return this;
					    }
					  };
					
					  /**
					   * Regex matching color in RGB or RGBA formats (ex: rgb(0, 0, 0), rgba(255, 100, 10, 0.5), rgba( 255 , 100 , 10 , 0.5 ), rgb(1,1,1), rgba(100%, 60%, 10%, 0.5))
					   * @static
					   * @field
					   * @memberOf fabric.Color
					   */
					  fabric.Color.reRGBa = /^rgba?\(\s*(\d{1,3}(?:\.\d+)?\%?)\s*,\s*(\d{1,3}(?:\.\d+)?\%?)\s*,\s*(\d{1,3}(?:\.\d+)?\%?)\s*(?:\s*,\s*(\d+(?:\.\d+)?)\s*)?\)$/;
					
					  /**
					   * Regex matching color in HSL or HSLA formats (ex: hsl(200, 80%, 10%), hsla(300, 50%, 80%, 0.5), hsla( 300 , 50% , 80% , 0.5 ))
					   * @static
					   * @field
					   * @memberOf fabric.Color
					   */
					  fabric.Color.reHSLa = /^hsla?\(\s*(\d{1,3})\s*,\s*(\d{1,3}\%)\s*,\s*(\d{1,3}\%)\s*(?:\s*,\s*(\d+(?:\.\d+)?)\s*)?\)$/;
					
					  /**
					   * Regex matching color in HEX format (ex: #FF5555, 010155, aff)
					   * @static
					   * @field
					   * @memberOf fabric.Color
					   */
					  fabric.Color.reHex = /^#?([0-9a-f]{6}|[0-9a-f]{3})$/i;
					
					  /**
					   * Map of the 17 basic color names with HEX code
					   * @static
					   * @field
					   * @memberOf fabric.Color
					   * @see: http://www.w3.org/TR/CSS2/syndata.html#color-units
					   */
					  fabric.Color.colorNameMap = {
					    aqua:    '#00FFFF',
					    black:   '#000000',
					    blue:    '#0000FF',
					    fuchsia: '#FF00FF',
					    gray:    '#808080',
					    green:   '#008000',
					    lime:    '#00FF00',
					    maroon:  '#800000',
					    navy:    '#000080',
					    olive:   '#808000',
					    orange:  '#FFA500',
					    purple:  '#800080',
					    red:     '#FF0000',
					    silver:  '#C0C0C0',
					    teal:    '#008080',
					    white:   '#FFFFFF',
					    yellow:  '#FFFF00'
					  };
					
					  /**
					   * @private
					   * @param {Number} p
					   * @param {Number} q
					   * @param {Number} t
					   * @return {Number}
					   */
					  function hue2rgb(p, q, t) {
					    if (t < 0) {
					      t += 1;
					    }
					    if (t > 1) {
					      t -= 1;
					    }
					    if (t < 1/6) {
					      return p + (q - p) * 6 * t;
					    }
					    if (t < 1/2) {
					      return q;
					    }
					    if (t < 2/3) {
					      return p + (q - p) * (2/3 - t) * 6;
					    }
					    return p;
					  }
					
					  /**
					   * Returns new color object, when given a color in RGB format
					   * @memberOf fabric.Color
					   * @param {String} color Color value ex: rgb(0-255,0-255,0-255)
					   * @return {fabric.Color}
					   */
					  fabric.Color.fromRgb = function(color) {
					    return Color.fromSource(Color.sourceFromRgb(color));
					  };
					
					  /**
					   * Returns array represenatation (ex: [100, 100, 200, 1]) of a color that's in RGB or RGBA format
					   * @memberOf fabric.Color
					   * @param {String} color Color value ex: rgb(0-255,0-255,0-255), rgb(0%-100%,0%-100%,0%-100%)
					   * @return {Array} source
					   */
					  fabric.Color.sourceFromRgb = function(color) {
					    var match = color.match(Color.reRGBa);
					    if (match) {
					      var r = parseInt(match[1], 10) / (/%$/.test(match[1]) ? 100 : 1) * (/%$/.test(match[1]) ? 255 : 1),
					          g = parseInt(match[2], 10) / (/%$/.test(match[2]) ? 100 : 1) * (/%$/.test(match[2]) ? 255 : 1),
					          b = parseInt(match[3], 10) / (/%$/.test(match[3]) ? 100 : 1) * (/%$/.test(match[3]) ? 255 : 1);
					
					      return [
					        parseInt(r, 10),
					        parseInt(g, 10),
					        parseInt(b, 10),
					        match[4] ? parseFloat(match[4]) : 1
					      ];
					    }
					  };
					
					  /**
					   * Returns new color object, when given a color in RGBA format
					   * @static
					   * @function
					   * @memberOf fabric.Color
					   * @param {String} color
					   * @return {fabric.Color}
					   */
					  fabric.Color.fromRgba = Color.fromRgb;
					
					  /**
					   * Returns new color object, when given a color in HSL format
					   * @param {String} color Color value ex: hsl(0-260,0%-100%,0%-100%)
					   * @memberOf fabric.Color
					   * @return {fabric.Color}
					   */
					  fabric.Color.fromHsl = function(color) {
					    return Color.fromSource(Color.sourceFromHsl(color));
					  };
					
					  /**
					   * Returns array represenatation (ex: [100, 100, 200, 1]) of a color that's in HSL or HSLA format.
					   * Adapted from <a href="https://rawgithub.com/mjijackson/mjijackson.github.com/master/2008/02/rgb-to-hsl-and-rgb-to-hsv-color-model-conversion-algorithms-in-javascript.html">https://github.com/mjijackson</a>
					   * @memberOf fabric.Color
					   * @param {String} color Color value ex: hsl(0-360,0%-100%,0%-100%) or hsla(0-360,0%-100%,0%-100%, 0-1)
					   * @return {Array} source
					   * @see http://http://www.w3.org/TR/css3-color/#hsl-color
					   */
					  fabric.Color.sourceFromHsl = function(color) {
					    var match = color.match(Color.reHSLa);
					    if (!match) {
					      return;
					    }
					
					    var h = (((parseFloat(match[1]) % 360) + 360) % 360) / 360,
					        s = parseFloat(match[2]) / (/%$/.test(match[2]) ? 100 : 1),
					        l = parseFloat(match[3]) / (/%$/.test(match[3]) ? 100 : 1),
					        r, g, b;
					
					    if (s === 0) {
					      r = g = b = l;
					    }
					    else {
					      var q = l <= 0.5 ? l * (s + 1) : l + s - l * s,
					          p = l * 2 - q;
					
					      r = hue2rgb(p, q, h + 1/3);
					      g = hue2rgb(p, q, h);
					      b = hue2rgb(p, q, h - 1/3);
					    }
					
					    return [
					      Math.round(r * 255),
					      Math.round(g * 255),
					      Math.round(b * 255),
					      match[4] ? parseFloat(match[4]) : 1
					    ];
					  };
					
					  /**
					   * Returns new color object, when given a color in HSLA format
					   * @static
					   * @function
					   * @memberOf fabric.Color
					   * @param {String} color
					   * @return {fabric.Color}
					   */
					  fabric.Color.fromHsla = Color.fromHsl;
					
					  /**
					   * Returns new color object, when given a color in HEX format
					   * @static
					   * @memberOf fabric.Color
					   * @param {String} color Color value ex: FF5555
					   * @return {fabric.Color}
					   */
					  fabric.Color.fromHex = function(color) {
					    return Color.fromSource(Color.sourceFromHex(color));
					  };
					
					  /**
					   * Returns array represenatation (ex: [100, 100, 200, 1]) of a color that's in HEX format
					   * @static
					   * @memberOf fabric.Color
					   * @param {String} color ex: FF5555
					   * @return {Array} source
					   */
					  fabric.Color.sourceFromHex = function(color) {
					    if (color.match(Color.reHex)) {
					      var value = color.slice(color.indexOf('#') + 1),
					          isShortNotation = (value.length === 3),
					          r = isShortNotation ? (value.charAt(0) + value.charAt(0)) : value.substring(0, 2),
					          g = isShortNotation ? (value.charAt(1) + value.charAt(1)) : value.substring(2, 4),
					          b = isShortNotation ? (value.charAt(2) + value.charAt(2)) : value.substring(4, 6);
					
					      return [
					        parseInt(r, 16),
					        parseInt(g, 16),
					        parseInt(b, 16),
					        1
					      ];
					    }
					  };
					
					  /**
					   * Returns new color object, when given color in array representation (ex: [200, 100, 100, 0.5])
					   * @static
					   * @memberOf fabric.Color
					   * @param {Array} source
					   * @return {fabric.Color}
					   */
					  fabric.Color.fromSource = function(source) {
					    var oColor = new Color();
					    oColor.setSource(source);
					    return oColor;
					  };
					
					})(typeof exports !== 'undefined' ? exports : this);
					(function () {
					
					  'use strict';
					
					  if (fabric.StaticCanvas) {
					    fabric.warn('fabric.StaticCanvas is already defined.');
					    return;
					  }
					
					  // aliases for faster resolution
					  var extend = fabric.util.object.extend,
					      getElementOffset = fabric.util.getElementOffset,
					      removeFromArray = fabric.util.removeFromArray,
					
					      CANVAS_INIT_ERROR = new Error('Could not initialize `canvas` element');
					
					  /**
					   * Static canvas class
					   * @class fabric.StaticCanvas
					   * @mixes fabric.Collection
					   * @mixes fabric.Observable
					   * @see {@link http://fabricjs.com/static_canvas/|StaticCanvas demo}
					   * @see {@link fabric.StaticCanvas#initialize} for constructor definition
					   * @fires before:render
					   * @fires after:render
					   * @fires canvas:cleared
					   * @fires object:added
					   * @fires object:removed
					   */
					  fabric.StaticCanvas = fabric.util.createClass(/** @lends fabric.StaticCanvas.prototype */ {
					
					    /**
					     * Constructor
					     * @param {HTMLElement | String} el &lt;canvas> element to initialize instance on
					     * @param {Object} [options] Options object
					     * @return {Object} thisArg
					     */
					    initialize: function(el, options) {
					      options || (options = { });
					
					      this._initStatic(el, options);
					      fabric.StaticCanvas.activeInstance = this;
					    },
					
					    /**
					     * Background color of canvas instance.
					     * Should be set via {@link fabric.StaticCanvas#setBackgroundColor}.
					     * @type {(String|fabric.Pattern)}
					     * @default
					     */
					    backgroundColor: '',
					
					    /**
					     * Background image of canvas instance.
					     * Should be set via {@link fabric.StaticCanvas#setBackgroundImage}.
					     * <b>Backwards incompatibility note:</b> The "backgroundImageOpacity"
					     * and "backgroundImageStretch" properties are deprecated since 1.3.9.
					     * Use {@link fabric.Image#opacity}, {@link fabric.Image#width} and {@link fabric.Image#height}.
					     * @type fabric.Image
					     * @default
					     */
					    backgroundImage: null,
					
					    /**
					     * Overlay color of canvas instance.
					     * Should be set via {@link fabric.StaticCanvas#setOverlayColor}
					     * @since 1.3.9
					     * @type {(String|fabric.Pattern)}
					     * @default
					     */
					    overlayColor: '',
					
					    /**
					     * Overlay image of canvas instance.
					     * Should be set via {@link fabric.StaticCanvas#setOverlayImage}.
					     * <b>Backwards incompatibility note:</b> The "overlayImageLeft"
					     * and "overlayImageTop" properties are deprecated since 1.3.9.
					     * Use {@link fabric.Image#left} and {@link fabric.Image#top}.
					     * @type fabric.Image
					     * @default
					     */
					    overlayImage: null,
					
					    /**
					     * Indicates whether toObject/toDatalessObject should include default values
					     * @type Boolean
					     * @default
					     */
					    includeDefaultValues: true,
					
					    /**
					     * Indicates whether objects' state should be saved
					     * @type Boolean
					     * @default
					     */
					    stateful: true,
					
					    /**
					     * Indicates whether {@link fabric.Collection.add}, {@link fabric.Collection.insertAt} and {@link fabric.Collection.remove} should also re-render canvas.
					     * Disabling this option could give a great performance boost when adding/removing a lot of objects to/from canvas at once
					     * (followed by a manual rendering after addition/deletion)
					     * @type Boolean
					     * @default
					     */
					    renderOnAddRemove: true,
					
					    /**
					     * Function that determines clipping of entire canvas area
					     * Being passed context as first argument. See clipping canvas area in {@link https://github.com/kangax/fabric.js/wiki/FAQ}
					     * @type Function
					     * @default
					     */
					    clipTo: null,
					
					    /**
					     * Indicates whether object controls (borders/controls) are rendered above overlay image
					     * @type Boolean
					     * @default
					     */
					    controlsAboveOverlay: false,
					
					    /**
					     * Indicates whether the browser can be scrolled when using a touchscreen and dragging on the canvas
					     * @type Boolean
					     * @default
					     */
					    allowTouchScrolling: false,
					
					    /**
					     * Indicates whether this canvas will use image smoothing, this is on by default in browsers
					     * @type Boolean
					     * @default
					     */
					    imageSmoothingEnabled: true,
					
					    /**
					     * Indicates whether objects should remain in current stack position when selected. When false objects are brought to top and rendered as part of the selection group
					     * @type Boolean
					     * @default
					     */
					    preserveObjectStacking: false,
					
					    /**
					     * The transformation (in the format of Canvas transform) which focuses the viewport
					     * @type Array
					     * @default
					     */
					    viewportTransform: [1, 0, 0, 1, 0, 0],
					
					    /**
					     * Callback; invoked right before object is about to be scaled/rotated
					     */
					    onBeforeScaleRotate: function () {
					      /* NOOP */
					    },
					
					    /**
					     * @private
					     * @param {HTMLElement | String} el &lt;canvas> element to initialize instance on
					     * @param {Object} [options] Options object
					     */
					    _initStatic: function(el, options) {
					      this._objects = [];
					
					      this._createLowerCanvas(el);
					      this._initOptions(options);
					      this._setImageSmoothing();
					
					      if (options.overlayImage) {
					        this.setOverlayImage(options.overlayImage, this.renderAll.bind(this));
					      }
					      if (options.backgroundImage) {
					        this.setBackgroundImage(options.backgroundImage, this.renderAll.bind(this));
					      }
					      if (options.backgroundColor) {
					        this.setBackgroundColor(options.backgroundColor, this.renderAll.bind(this));
					      }
					      if (options.overlayColor) {
					        this.setOverlayColor(options.overlayColor, this.renderAll.bind(this));
					      }
					      this.calcOffset();
					    },
					
					    /**
					     * Calculates canvas element offset relative to the document
					     * This method is also attached as "resize" event handler of window
					     * @return {fabric.Canvas} instance
					     * @chainable
					     */
					    calcOffset: function () {
					      this._offset = getElementOffset(this.lowerCanvasEl);
					      return this;
					    },
					
					    /**
					     * Sets {@link fabric.StaticCanvas#overlayImage|overlay image} for this canvas
					     * @param {(fabric.Image|String)} image fabric.Image instance or URL of an image to set overlay to
					     * @param {Function} callback callback to invoke when image is loaded and set as an overlay
					     * @param {Object} [options] Optional options to set for the {@link fabric.Image|overlay image}.
					     * @return {fabric.Canvas} thisArg
					     * @chainable
					     * @see {@link http://jsfiddle.net/fabricjs/MnzHT/|jsFiddle demo}
					     * @example <caption>Normal overlayImage with left/top = 0</caption>
					     * canvas.setOverlayImage('http://fabricjs.com/assets/jail_cell_bars.png', canvas.renderAll.bind(canvas), {
					     *   // Needed to position overlayImage at 0/0
					     *   originX: 'left',
					     *   originY: 'top'
					     * });
					     * @example <caption>overlayImage with different properties</caption>
					     * canvas.setOverlayImage('http://fabricjs.com/assets/jail_cell_bars.png', canvas.renderAll.bind(canvas), {
					     *   opacity: 0.5,
					     *   angle: 45,
					     *   left: 400,
					     *   top: 400,
					     *   originX: 'left',
					     *   originY: 'top'
					     * });
					     * @example <caption>Stretched overlayImage #1 - width/height correspond to canvas width/height</caption>
					     * fabric.Image.fromURL('http://fabricjs.com/assets/jail_cell_bars.png', function(img) {
					     *    img.set({width: canvas.width, height: canvas.height, originX: 'left', originY: 'top'});
					     *    canvas.setOverlayImage(img, canvas.renderAll.bind(canvas));
					     * });
					     * @example <caption>Stretched overlayImage #2 - width/height correspond to canvas width/height</caption>
					     * canvas.setOverlayImage('http://fabricjs.com/assets/jail_cell_bars.png', canvas.renderAll.bind(canvas), {
					     *   width: canvas.width,
					     *   height: canvas.height,
					     *   // Needed to position overlayImage at 0/0
					     *   originX: 'left',
					     *   originY: 'top'
					     * });
					     * @example <caption>overlayImage loaded from cross-origin</caption>
					     * canvas.setOverlayImage('http://fabricjs.com/assets/jail_cell_bars.png', canvas.renderAll.bind(canvas), {
					     *   opacity: 0.5,
					     *   angle: 45,
					     *   left: 400,
					     *   top: 400,
					     *   originX: 'left',
					     *   originY: 'top',
					     *   crossOrigin: 'anonymous'
					     * });
					     */
					    setOverlayImage: function (image, callback, options) {
					      return this.__setBgOverlayImage('overlayImage', image, callback, options);
					    },
					
					    /**
					     * Sets {@link fabric.StaticCanvas#backgroundImage|background image} for this canvas
					     * @param {(fabric.Image|String)} image fabric.Image instance or URL of an image to set background to
					     * @param {Function} callback Callback to invoke when image is loaded and set as background
					     * @param {Object} [options] Optional options to set for the {@link fabric.Image|background image}.
					     * @return {fabric.Canvas} thisArg
					     * @chainable
					     * @see {@link http://jsfiddle.net/fabricjs/YH9yD/|jsFiddle demo}
					     * @example <caption>Normal backgroundImage with left/top = 0</caption>
					     * canvas.setBackgroundImage('http://fabricjs.com/assets/honey_im_subtle.png', canvas.renderAll.bind(canvas), {
					     *   // Needed to position backgroundImage at 0/0
					     *   originX: 'left',
					     *   originY: 'top'
					     * });
					     * @example <caption>backgroundImage with different properties</caption>
					     * canvas.setBackgroundImage('http://fabricjs.com/assets/honey_im_subtle.png', canvas.renderAll.bind(canvas), {
					     *   opacity: 0.5,
					     *   angle: 45,
					     *   left: 400,
					     *   top: 400,
					     *   originX: 'left',
					     *   originY: 'top'
					     * });
					     * @example <caption>Stretched backgroundImage #1 - width/height correspond to canvas width/height</caption>
					     * fabric.Image.fromURL('http://fabricjs.com/assets/honey_im_subtle.png', function(img) {
					     *    img.set({width: canvas.width, height: canvas.height, originX: 'left', originY: 'top'});
					     *    canvas.setBackgroundImage(img, canvas.renderAll.bind(canvas));
					     * });
					     * @example <caption>Stretched backgroundImage #2 - width/height correspond to canvas width/height</caption>
					     * canvas.setBackgroundImage('http://fabricjs.com/assets/honey_im_subtle.png', canvas.renderAll.bind(canvas), {
					     *   width: canvas.width,
					     *   height: canvas.height,
					     *   // Needed to position backgroundImage at 0/0
					     *   originX: 'left',
					     *   originY: 'top'
					     * });
					     * @example <caption>backgroundImage loaded from cross-origin</caption>
					     * canvas.setBackgroundImage('http://fabricjs.com/assets/honey_im_subtle.png', canvas.renderAll.bind(canvas), {
					     *   opacity: 0.5,
					     *   angle: 45,
					     *   left: 400,
					     *   top: 400,
					     *   originX: 'left',
					     *   originY: 'top',
					     *   crossOrigin: 'anonymous'
					     * });
					     */
					    setBackgroundImage: function (image, callback, options) {
					      return this.__setBgOverlayImage('backgroundImage', image, callback, options);
					    },
					
					    /**
					     * Sets {@link fabric.StaticCanvas#overlayColor|background color} for this canvas
					     * @param {(String|fabric.Pattern)} overlayColor Color or pattern to set background color to
					     * @param {Function} callback Callback to invoke when background color is set
					     * @return {fabric.Canvas} thisArg
					     * @chainable
					     * @see {@link http://jsfiddle.net/fabricjs/pB55h/|jsFiddle demo}
					     * @example <caption>Normal overlayColor - color value</caption>
					     * canvas.setOverlayColor('rgba(255, 73, 64, 0.6)', canvas.renderAll.bind(canvas));
					     * @example <caption>fabric.Pattern used as overlayColor</caption>
					     * canvas.setOverlayColor({
					     *   source: 'http://fabricjs.com/assets/escheresque_ste.png'
					     * }, canvas.renderAll.bind(canvas));
					     * @example <caption>fabric.Pattern used as overlayColor with repeat and offset</caption>
					     * canvas.setOverlayColor({
					     *   source: 'http://fabricjs.com/assets/escheresque_ste.png',
					     *   repeat: 'repeat',
					     *   offsetX: 200,
					     *   offsetY: 100
					     * }, canvas.renderAll.bind(canvas));
					     */
					    setOverlayColor: function(overlayColor, callback) {
					      return this.__setBgOverlayColor('overlayColor', overlayColor, callback);
					    },
					
					    /**
					     * Sets {@link fabric.StaticCanvas#backgroundColor|background color} for this canvas
					     * @param {(String|fabric.Pattern)} backgroundColor Color or pattern to set background color to
					     * @param {Function} callback Callback to invoke when background color is set
					     * @return {fabric.Canvas} thisArg
					     * @chainable
					     * @see {@link http://jsfiddle.net/fabricjs/hXzvk/|jsFiddle demo}
					     * @example <caption>Normal backgroundColor - color value</caption>
					     * canvas.setBackgroundColor('rgba(255, 73, 64, 0.6)', canvas.renderAll.bind(canvas));
					     * @example <caption>fabric.Pattern used as backgroundColor</caption>
					     * canvas.setBackgroundColor({
					     *   source: 'http://fabricjs.com/assets/escheresque_ste.png'
					     * }, canvas.renderAll.bind(canvas));
					     * @example <caption>fabric.Pattern used as backgroundColor with repeat and offset</caption>
					     * canvas.setBackgroundColor({
					     *   source: 'http://fabricjs.com/assets/escheresque_ste.png',
					     *   repeat: 'repeat',
					     *   offsetX: 200,
					     *   offsetY: 100
					     * }, canvas.renderAll.bind(canvas));
					     */
					    setBackgroundColor: function(backgroundColor, callback) {
					      return this.__setBgOverlayColor('backgroundColor', backgroundColor, callback);
					    },
					
					    /**
					     * @private
					     * @see {@link http://www.whatwg.org/specs/web-apps/current-work/multipage/the-canvas-element.html#dom-context-2d-imagesmoothingenabled|WhatWG Canvas Standard}
					     */
					    _setImageSmoothing: function() {
					      var ctx = this.getContext();
					
					      ctx.imageSmoothingEnabled       = this.imageSmoothingEnabled;
					      ctx.webkitImageSmoothingEnabled = this.imageSmoothingEnabled;
					      ctx.mozImageSmoothingEnabled    = this.imageSmoothingEnabled;
					      ctx.msImageSmoothingEnabled     = this.imageSmoothingEnabled;
					      ctx.oImageSmoothingEnabled      = this.imageSmoothingEnabled;
					    },
					
					    /**
					     * @private
					     * @param {String} property Property to set ({@link fabric.StaticCanvas#backgroundImage|backgroundImage}
					     * or {@link fabric.StaticCanvas#overlayImage|overlayImage})
					     * @param {(fabric.Image|String|null)} image fabric.Image instance, URL of an image or null to set background or overlay to
					     * @param {Function} callback Callback to invoke when image is loaded and set as background or overlay
					     * @param {Object} [options] Optional options to set for the {@link fabric.Image|image}.
					     */
					    __setBgOverlayImage: function(property, image, callback, options) {
					      if (typeof image === 'string') {
					        fabric.util.loadImage(image, function(img) {
					          this[property] = new fabric.Image(img, options);
					          callback && callback();
					        }, this, options && options.crossOrigin);
					      }
					      else {
					        options && image.setOptions(options);
					        this[property] = image;
					        callback && callback();
					      }
					
					      return this;
					    },
					
					    /**
					     * @private
					     * @param {String} property Property to set ({@link fabric.StaticCanvas#backgroundColor|backgroundColor}
					     * or {@link fabric.StaticCanvas#overlayColor|overlayColor})
					     * @param {(Object|String|null)} color Object with pattern information, color value or null
					     * @param {Function} [callback] Callback is invoked when color is set
					     */
					    __setBgOverlayColor: function(property, color, callback) {
					      if (color && color.source) {
					        var _this = this;
					        fabric.util.loadImage(color.source, function(img) {
					          _this[property] = new fabric.Pattern({
					            source: img,
					            repeat: color.repeat,
					            offsetX: color.offsetX,
					            offsetY: color.offsetY
					          });
					          callback && callback();
					        });
					      }
					      else {
					        this[property] = color;
					        callback && callback();
					      }
					
					      return this;
					    },
					
					    /**
					     * @private
					     */
					    _createCanvasElement: function() {
					      var element = fabric.document.createElement('canvas');
					      if (!element.style) {
					        element.style = { };
					      }
					      if (!element) {
					        throw CANVAS_INIT_ERROR;
					      }
					      this._initCanvasElement(element);
					      return element;
					    },
					
					    /**
					     * @private
					     * @param {HTMLElement} element
					     */
					    _initCanvasElement: function(element) {
					      fabric.util.createCanvasElement(element);
					
					      if (typeof element.getContext === 'undefined') {
					        throw CANVAS_INIT_ERROR;
					      }
					    },
					
					    /**
					     * @private
					     * @param {Object} [options] Options object
					     */
					    _initOptions: function (options) {
					      for (var prop in options) {
					        this[prop] = options[prop];
					      }
					
					      this.width = this.width || parseInt(this.lowerCanvasEl.width, 10) || 0;
					      this.height = this.height || parseInt(this.lowerCanvasEl.height, 10) || 0;
					
					      if (!this.lowerCanvasEl.style) {
					        return;
					      }
					
					      this.lowerCanvasEl.width = this.width;
					      this.lowerCanvasEl.height = this.height;
					
					      this.lowerCanvasEl.style.width = this.width + 'px';
					      this.lowerCanvasEl.style.height = this.height + 'px';
					
					      this.viewportTransform = this.viewportTransform.slice();
					    },
					
					    /**
					     * Creates a bottom canvas
					     * @private
					     * @param {HTMLElement} [canvasEl]
					     */
					    _createLowerCanvas: function (canvasEl) {
					      this.lowerCanvasEl = fabric.util.getById(canvasEl) || this._createCanvasElement();
					      this._initCanvasElement(this.lowerCanvasEl);
					
					      fabric.util.addClass(this.lowerCanvasEl, 'lower-canvas');
					
					      if (this.interactive) {
					        this._applyCanvasStyle(this.lowerCanvasEl);
					      }
					
					      this.contextContainer = this.lowerCanvasEl.getContext('2d');
					    },
					
					    /**
					     * Returns canvas width (in px)
					     * @return {Number}
					     */
					    getWidth: function () {
					      return this.width;
					    },
					
					    /**
					     * Returns canvas height (in px)
					     * @return {Number}
					     */
					    getHeight: function () {
					      return this.height;
					    },
					
					    /**
					     * Sets width of this canvas instance
					     * @param {Number|String} value                         Value to set width to
					     * @param {Object}        [options]                     Options object
					     * @param {Boolean}       [options.backstoreOnly=false] Set the given dimensions only as canvas backstore dimensions
					     * @param {Boolean}       [options.cssOnly=false]       Set the given dimensions only as css dimensions
					     * @return {fabric.Canvas} instance
					     * @chainable true
					     */
					    setWidth: function (value, options) {
					      return this.setDimensions({ width: value }, options);
					    },
					
					    /**
					     * Sets height of this canvas instance
					     * @param {Number|String} value                         Value to set height to
					     * @param {Object}        [options]                     Options object
					     * @param {Boolean}       [options.backstoreOnly=false] Set the given dimensions only as canvas backstore dimensions
					     * @param {Boolean}       [options.cssOnly=false]       Set the given dimensions only as css dimensions
					     * @return {fabric.Canvas} instance
					     * @chainable true
					     */
					    setHeight: function (value, options) {
					      return this.setDimensions({ height: value }, options);
					    },
					
					    /**
					     * Sets dimensions (width, height) of this canvas instance. when options.cssOnly flag active you should also supply the unit of measure (px/%/em)
					     * @param {Object}        dimensions                    Object with width/height properties
					     * @param {Number|String} [dimensions.width]            Width of canvas element
					     * @param {Number|String} [dimensions.height]           Height of canvas element
					     * @param {Object}        [options]                     Options object
					     * @param {Boolean}       [options.backstoreOnly=false] Set the given dimensions only as canvas backstore dimensions
					     * @param {Boolean}       [options.cssOnly=false]       Set the given dimensions only as css dimensions
					     * @return {fabric.Canvas} thisArg
					     * @chainable
					     */
					    setDimensions: function (dimensions, options) {
					      var cssValue;
					
					      options = options || {};
					
					      for (var prop in dimensions) {
					        cssValue = dimensions[prop];
					
					        if (!options.cssOnly) {
					          this._setBackstoreDimension(prop, dimensions[prop]);
					          cssValue += 'px';
					        }
					
					        if (!options.backstoreOnly) {
					          this._setCssDimension(prop, cssValue);
					        }
					      }
					
					      if (!options.cssOnly) {
					        this.renderAll();
					      }
					
					      this.calcOffset();
					
					      return this;
					    },
					
					    /**
					     * Helper for setting width/height
					     * @private
					     * @param {String} prop property (width|height)
					     * @param {Number} value value to set property to
					     * @return {fabric.Canvas} instance
					     * @chainable true
					     */
					    _setBackstoreDimension: function (prop, value) {
					      this.lowerCanvasEl[prop] = value;
					
					      if (this.upperCanvasEl) {
					        this.upperCanvasEl[prop] = value;
					      }
					
					      if (this.cacheCanvasEl) {
					        this.cacheCanvasEl[prop] = value;
					      }
					
					      this[prop] = value;
					
					      return this;
					    },
					
					    /**
					     * Helper for setting css width/height
					     * @private
					     * @param {String} prop property (width|height)
					     * @param {String} value value to set property to
					     * @return {fabric.Canvas} instance
					     * @chainable true
					     */
					    _setCssDimension: function (prop, value) {
					      this.lowerCanvasEl.style[prop] = value;
					
					      if (this.upperCanvasEl) {
					        this.upperCanvasEl.style[prop] = value;
					      }
					
					      if (this.wrapperEl) {
					        this.wrapperEl.style[prop] = value;
					      }
					
					      return this;
					    },
					
					    /**
					     * Returns canvas zoom level
					     * @return {Number}
					     */
					    getZoom: function () {
					      return Math.sqrt(this.viewportTransform[0] * this.viewportTransform[3]);
					    },
					
					    /**
					     * Sets viewport transform of this canvas instance
					     * @param {Array} vpt the transform in the form of context.transform
					     * @return {fabric.Canvas} instance
					     * @chainable true
					     */
					    setViewportTransform: function (vpt) {
					      var activeGroup = this.getActiveGroup();
					      this.viewportTransform = vpt;
					      this.renderAll();
					      for (var i = 0, len = this._objects.length; i < len; i++) {
					        this._objects[i].setCoords();
					      }
					      if (activeGroup) {
					        activeGroup.setCoords();
					      }
					      return this;
					    },
					
					    /**
					     * Sets zoom level of this canvas instance, zoom centered around point
					     * @param {fabric.Point} point to zoom with respect to
					     * @param {Number} value to set zoom to, less than 1 zooms out
					     * @return {fabric.Canvas} instance
					     * @chainable true
					     */
					    zoomToPoint: function (point, value) {
					      // TODO: just change the scale, preserve other transformations
					      var before = point;
					      point = fabric.util.transformPoint(point, fabric.util.invertTransform(this.viewportTransform));
					      this.viewportTransform[0] = value;
					      this.viewportTransform[3] = value;
					      var after = fabric.util.transformPoint(point, this.viewportTransform);
					      this.viewportTransform[4] += before.x - after.x;
					      this.viewportTransform[5] += before.y - after.y;
					      this.renderAll();
					      for (var i = 0, len = this._objects.length; i < len; i++) {
					        this._objects[i].setCoords();
					      }
					      return this;
					    },
					
					    /**
					     * Sets zoom level of this canvas instance
					     * @param {Number} value to set zoom to, less than 1 zooms out
					     * @return {fabric.Canvas} instance
					     * @chainable true
					     */
					    setZoom: function (value) {
					      this.zoomToPoint(new fabric.Point(0, 0), value);
					      return this;
					    },
					
					    /**
					     * Pan viewport so as to place point at top left corner of canvas
					     * @param {fabric.Point} point to move to
					     * @return {fabric.Canvas} instance
					     * @chainable true
					     */
					    absolutePan: function (point) {
					      this.viewportTransform[4] = -point.x;
					      this.viewportTransform[5] = -point.y;
					      this.renderAll();
					      for (var i = 0, len = this._objects.length; i < len; i++) {
					        this._objects[i].setCoords();
					      }
					      return this;
					    },
					
					    /**
					     * Pans viewpoint relatively
					     * @param {fabric.Point} point (position vector) to move by
					     * @return {fabric.Canvas} instance
					     * @chainable true
					     */
					    relativePan: function (point) {
					      return this.absolutePan(new fabric.Point(
					        -point.x - this.viewportTransform[4],
					        -point.y - this.viewportTransform[5]
					      ));
					    },
					
					    /**
					     * Returns &lt;canvas> element corresponding to this instance
					     * @return {HTMLCanvasElement}
					     */
					    getElement: function () {
					      return this.lowerCanvasEl;
					    },
					
					    /**
					     * Returns currently selected object, if any
					     * @return {fabric.Object}
					     */
					    getActiveObject: function() {
					      return null;
					    },
					
					    /**
					     * Returns currently selected group of object, if any
					     * @return {fabric.Group}
					     */
					    getActiveGroup: function() {
					      return null;
					    },
					
					    /**
					     * Given a context, renders an object on that context
					     * @param {CanvasRenderingContext2D} ctx Context to render object on
					     * @param {fabric.Object} object Object to render
					     * @private
					     */
					    _draw: function (ctx, object) {
					      if (!object) {
					        return;
					      }
					
					      ctx.save();
					      var v = this.viewportTransform;
					      ctx.transform(v[0], v[1], v[2], v[3], v[4], v[5]);
					      if (this._shouldRenderObject(object)) {
					        object.render(ctx);
					      }
					      ctx.restore();
					      if (!this.controlsAboveOverlay) {
					        object._renderControls(ctx);
					      }
					    },
					
					    _shouldRenderObject: function(object) {
					      if (!object) {
					        return false;
					      }
					      return (object !== this.getActiveGroup() || !this.preserveObjectStacking);
					    },
					
					    /**
					     * @private
					     * @param {fabric.Object} obj Object that was added
					     */
					    _onObjectAdded: function(obj) {
					      this.stateful && obj.setupState();
					      obj.canvas = this;
					      obj.setCoords();
					      this.fire('object:added', { target: obj });
					      obj.fire('added');
					    },
					
					    /**
					     * @private
					     * @param {fabric.Object} obj Object that was removed
					     */
					    _onObjectRemoved: function(obj) {
					      // removing active object should fire "selection:cleared" events
					      if (this.getActiveObject() === obj) {
					        this.fire('before:selection:cleared', { target: obj });
					        this._discardActiveObject();
					        this.fire('selection:cleared');
					      }
					
					      this.fire('object:removed', { target: obj });
					      obj.fire('removed');
					    },
					
					    /**
					     * Clears specified context of canvas element
					     * @param {CanvasRenderingContext2D} ctx Context to clear
					     * @return {fabric.Canvas} thisArg
					     * @chainable
					     */
					    clearContext: function(ctx) {
					      ctx.clearRect(0, 0, this.width, this.height);
					      return this;
					    },
					
					    /**
					     * Returns context of canvas where objects are drawn
					     * @return {CanvasRenderingContext2D}
					     */
					    getContext: function () {
					      return this.contextContainer;
					    },
					
					    /**
					     * Clears all contexts (background, main, top) of an instance
					     * @return {fabric.Canvas} thisArg
					     * @chainable
					     */
					    clear: function () {
					      this._objects.length = 0;
					      if (this.discardActiveGroup) {
					        this.discardActiveGroup();
					      }
					      if (this.discardActiveObject) {
					        this.discardActiveObject();
					      }
					      this.clearContext(this.contextContainer);
					      if (this.contextTop) {
					        this.clearContext(this.contextTop);
					      }
					      this.fire('canvas:cleared');
					      this.renderAll();
					      return this;
					    },
					
					    /**
					     * Renders both the top canvas and the secondary container canvas.
					     * @param {Boolean} [allOnTop] Whether we want to force all images to be rendered on the top canvas
					     * @return {fabric.Canvas} instance
					     * @chainable
					     */
					    renderAll: function (allOnTop) {
					      var canvasToDrawOn = this[(allOnTop === true && this.interactive) ? 'contextTop' : 'contextContainer'],
					          activeGroup = this.getActiveGroup();
					
					      if (this.contextTop && this.selection && !this._groupSelector) {
					        this.clearContext(this.contextTop);
					      }
					
					      if (!allOnTop) {
					        this.clearContext(canvasToDrawOn);
					      }
					
					      this.fire('before:render');
					
					      if (this.clipTo) {
					        fabric.util.clipContext(this, canvasToDrawOn);
					      }
					
					      this._renderBackground(canvasToDrawOn);
					      this._renderObjects(canvasToDrawOn, activeGroup);
					      this._renderActiveGroup(canvasToDrawOn, activeGroup);
					
					      if (this.clipTo) {
					        canvasToDrawOn.restore();
					      }
					
					      this._renderOverlay(canvasToDrawOn);
					
					      if (this.controlsAboveOverlay && this.interactive) {
					        this.drawControls(canvasToDrawOn);
					      }
					
					      this.fire('after:render');
					
					      return this;
					    },
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     * @param {fabric.Group} activeGroup
					     */
					    _renderObjects: function(ctx, activeGroup) {
					      var i, length;
					
					      // fast path
					      if (!activeGroup || this.preserveObjectStacking) {
					        for (i = 0, length = this._objects.length; i < length; ++i) {
					          this._draw(ctx, this._objects[i]);
					        }
					      }
					      else {
					        for (i = 0, length = this._objects.length; i < length; ++i) {
					          if (this._objects[i] && !activeGroup.contains(this._objects[i])) {
					            this._draw(ctx, this._objects[i]);
					          }
					        }
					      }
					    },
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     * @param {fabric.Group} activeGroup
					     */
					    _renderActiveGroup: function(ctx, activeGroup) {
					
					      // delegate rendering to group selection (if one exists)
					      if (activeGroup) {
					
					        //Store objects in group preserving order, then replace
					        var sortedObjects = [];
					        this.forEachObject(function (object) {
					          if (activeGroup.contains(object)) {
					            sortedObjects.push(object);
					          }
					        });
					        activeGroup._set('objects', sortedObjects);
					        this._draw(ctx, activeGroup);
					      }
					    },
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     */
					    _renderBackground: function(ctx) {
					      if (this.backgroundColor) {
					        ctx.fillStyle = this.backgroundColor.toLive
					          ? this.backgroundColor.toLive(ctx)
					          : this.backgroundColor;
					
					        ctx.fillRect(
					          this.backgroundColor.offsetX || 0,
					          this.backgroundColor.offsetY || 0,
					          this.width,
					          this.height);
					      }
					      if (this.backgroundImage) {
					        this._draw(ctx, this.backgroundImage);
					      }
					    },
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     */
					    _renderOverlay: function(ctx) {
					      if (this.overlayColor) {
					        ctx.fillStyle = this.overlayColor.toLive
					          ? this.overlayColor.toLive(ctx)
					          : this.overlayColor;
					
					        ctx.fillRect(
					          this.overlayColor.offsetX || 0,
					          this.overlayColor.offsetY || 0,
					          this.width,
					          this.height);
					      }
					      if (this.overlayImage) {
					        this._draw(ctx, this.overlayImage);
					      }
					    },
					
					    /**
					     * Method to render only the top canvas.
					     * Also used to render the group selection box.
					     * @return {fabric.Canvas} thisArg
					     * @chainable
					     */
					    renderTop: function () {
					      var ctx = this.contextTop || this.contextContainer;
					      this.clearContext(ctx);
					
					      // we render the top context - last object
					      if (this.selection && this._groupSelector) {
					        this._drawSelection();
					      }
					
					      // delegate rendering to group selection if one exists
					      // used for drawing selection borders/controls
					      var activeGroup = this.getActiveGroup();
					      if (activeGroup) {
					        activeGroup.render(ctx);
					      }
					
					      this._renderOverlay(ctx);
					
					      this.fire('after:render');
					
					      return this;
					    },
					
					    /**
					     * Returns coordinates of a center of canvas.
					     * Returned value is an object with top and left properties
					     * @return {Object} object with "top" and "left" number values
					     */
					    getCenter: function () {
					      return {
					        top: this.getHeight() / 2,
					        left: this.getWidth() / 2
					      };
					    },
					
					    /**
					     * Centers object horizontally.
					     * You might need to call `setCoords` on an object after centering, to update controls area.
					     * @param {fabric.Object} object Object to center horizontally
					     * @return {fabric.Canvas} thisArg
					     */
					    centerObjectH: function (object) {
					      this._centerObject(object, new fabric.Point(this.getCenter().left, object.getCenterPoint().y));
					      this.renderAll();
					      return this;
					    },
					
					    /**
					     * Centers object vertically.
					     * You might need to call `setCoords` on an object after centering, to update controls area.
					     * @param {fabric.Object} object Object to center vertically
					     * @return {fabric.Canvas} thisArg
					     * @chainable
					     */
					    centerObjectV: function (object) {
					      this._centerObject(object, new fabric.Point(object.getCenterPoint().x, this.getCenter().top));
					      this.renderAll();
					      return this;
					    },
					
					    /**
					     * Centers object vertically and horizontally.
					     * You might need to call `setCoords` on an object after centering, to update controls area.
					     * @param {fabric.Object} object Object to center vertically and horizontally
					     * @return {fabric.Canvas} thisArg
					     * @chainable
					     */
					    centerObject: function(object) {
					      var center = this.getCenter();
					
					      this._centerObject(object, new fabric.Point(center.left, center.top));
					      this.renderAll();
					      return this;
					    },
					
					    /**
					     * @private
					     * @param {fabric.Object} object Object to center
					     * @param {fabric.Point} center Center point
					     * @return {fabric.Canvas} thisArg
					     * @chainable
					     */
					    _centerObject: function(object, center) {
					      object.setPositionByOrigin(center, 'center', 'center');
					      return this;
					    },
					
					    /**
					     * Returs dataless JSON representation of canvas
					     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output
					     * @return {String} json string
					     */
					    toDatalessJSON: function (propertiesToInclude) {
					      return this.toDatalessObject(propertiesToInclude);
					    },
					
					    /**
					     * Returns object representation of canvas
					     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output
					     * @return {Object} object representation of an instance
					     */
					    toObject: function (propertiesToInclude) {
					      return this._toObjectMethod('toObject', propertiesToInclude);
					    },
					
					    /**
					     * Returns dataless object representation of canvas
					     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output
					     * @return {Object} object representation of an instance
					     */
					    toDatalessObject: function (propertiesToInclude) {
					      return this._toObjectMethod('toDatalessObject', propertiesToInclude);
					    },
					
					    /**
					     * @private
					     */
					    _toObjectMethod: function (methodName, propertiesToInclude) {
					
					      var data = {
					        objects: this._toObjects(methodName, propertiesToInclude)
					      };
					
					      extend(data, this.__serializeBgOverlay());
					
					      fabric.util.populateWithProperties(this, data, propertiesToInclude);
					
					      return data;
					    },
					
					    /**
					     * @private
					     */
					    _toObjects: function(methodName, propertiesToInclude) {
					      return this.getObjects().map(function(instance) {
					        return this._toObject(instance, methodName, propertiesToInclude);
					      }, this);
					    },
					
					    /**
					     * @private
					     */
					    _toObject: function(instance, methodName, propertiesToInclude) {
					      var originalValue;
					
					      if (!this.includeDefaultValues) {
					        originalValue = instance.includeDefaultValues;
					        instance.includeDefaultValues = false;
					      }
					
					      //If the object is part of the current selection group, it should
					      //be transformed appropriately
					      //i.e. it should be serialised as it would appear if the selection group
					      //were to be destroyed.
					      var originalProperties = this._realizeGroupTransformOnObject(instance),
					          object = instance[methodName](propertiesToInclude);
					      if (!this.includeDefaultValues) {
					        instance.includeDefaultValues = originalValue;
					      }
					
					      //Undo the damage we did by changing all of its properties
					      this._unwindGroupTransformOnObject(instance, originalProperties);
					
					      return object;
					    },
					
					    /**
					     * Realises an object's group transformation on it
					     * @private
					     * @param {fabric.Object} [instance] the object to transform (gets mutated)
					     * @returns the original values of instance which were changed
					     */
					    _realizeGroupTransformOnObject: function(instance) {
					      var layoutProps = ['angle', 'flipX', 'flipY', 'height', 'left', 'scaleX', 'scaleY', 'top', 'width'];
					      if (instance.group && instance.group === this.getActiveGroup()) {
					        //Copy all the positionally relevant properties across now
					        var originalValues = {};
					        layoutProps.forEach(function(prop) {
					          originalValues[prop] = instance[prop];
					        });
					        this.getActiveGroup().realizeTransform(instance);
					        return originalValues;
					      }
					      else {
					        return null;
					      }
					    },
					
					    /*
					     * Restores the changed properties of instance
					     * @private
					     * @param {fabric.Object} [instance] the object to un-transform (gets mutated)
					     * @param {Object} [originalValues] the original values of instance, as returned by _realizeGroupTransformOnObject
					     */
					    _unwindGroupTransformOnObject: function(instance, originalValues) {
					      if (originalValues) {
					        instance.set(originalValues);
					      }
					    },
					
					    /**
					     * @private
					     */
					    __serializeBgOverlay: function() {
					      var data = {
					        background: (this.backgroundColor && this.backgroundColor.toObject)
					          ? this.backgroundColor.toObject()
					          : this.backgroundColor
					      };
					
					      if (this.overlayColor) {
					        data.overlay = this.overlayColor.toObject
					          ? this.overlayColor.toObject()
					          : this.overlayColor;
					      }
					      if (this.backgroundImage) {
					        data.backgroundImage = this.backgroundImage.toObject();
					      }
					      if (this.overlayImage) {
					        data.overlayImage = this.overlayImage.toObject();
					      }
					
					      return data;
					    },
					
					    /* _TO_SVG_START_ */
					    /**
					     * When true, getSvgTransform() will apply the StaticCanvas.viewportTransform to the SVG transformation. When true,
					     * a zoomed canvas will then produce zoomed SVG output.
					     * @type Boolean
					     * @default
					     */
					    svgViewportTransformation: true,
					
					    /**
					     * Returns SVG representation of canvas
					     * @function
					     * @param {Object} [options] Options object for SVG output
					     * @param {Boolean} [options.suppressPreamble=false] If true xml tag is not included
					     * @param {Object} [options.viewBox] SVG viewbox object
					     * @param {Number} [options.viewBox.x] x-cooridnate of viewbox
					     * @param {Number} [options.viewBox.y] y-coordinate of viewbox
					     * @param {Number} [options.viewBox.width] Width of viewbox
					     * @param {Number} [options.viewBox.height] Height of viewbox
					     * @param {String} [options.encoding=UTF-8] Encoding of SVG output
					     * @param {Function} [reviver] Method for further parsing of svg elements, called after each fabric object converted into svg representation.
					     * @return {String} SVG string
					     * @tutorial {@link http://fabricjs.com/fabric-intro-part-3/#serialization}
					     * @see {@link http://jsfiddle.net/fabricjs/jQ3ZZ/|jsFiddle demo}
					     * @example <caption>Normal SVG output</caption>
					     * var svg = canvas.toSVG();
					     * @example <caption>SVG output without preamble (without &lt;?xml ../>)</caption>
					     * var svg = canvas.toSVG({suppressPreamble: true});
					     * @example <caption>SVG output with viewBox attribute</caption>
					     * var svg = canvas.toSVG({
					     *   viewBox: {
					     *     x: 100,
					     *     y: 100,
					     *     width: 200,
					     *     height: 300
					     *   }
					     * });
					     * @example <caption>SVG output with different encoding (default: UTF-8)</caption>
					     * var svg = canvas.toSVG({encoding: 'ISO-8859-1'});
					     * @example <caption>Modify SVG output with reviver function</caption>
					     * var svg = canvas.toSVG(null, function(svg) {
					     *   return svg.replace('stroke-dasharray: ; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; ', '');
					     * });
					     */
					    toSVG: function(options, reviver) {
					      options || (options = { });
					
					      var markup = [];
					
					      this._setSVGPreamble(markup, options);
					      this._setSVGHeader(markup, options);
					
					      this._setSVGBgOverlayColor(markup, 'backgroundColor');
					      this._setSVGBgOverlayImage(markup, 'backgroundImage');
					
					      this._setSVGObjects(markup, reviver);
					
					      this._setSVGBgOverlayColor(markup, 'overlayColor');
					      this._setSVGBgOverlayImage(markup, 'overlayImage');
					
					      markup.push('</svg>');
					
					      return markup.join('');
					    },
					
					    /**
					     * @private
					     */
					    _setSVGPreamble: function(markup, options) {
					      if (!options.suppressPreamble) {
					        markup.push(
					          '<?xml version="1.0" encoding="', (options.encoding || 'UTF-8'), '" standalone="no" ?>',
					            '<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" ',
					              '"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">\n'
					        );
					      }
					    },
					
					    /**
					     * @private
					     */
					    _setSVGHeader: function(markup, options) {
					      var width, height, vpt;
					
					      if (options.viewBox) {
					        width = options.viewBox.width;
					        height = options.viewBox.height;
					      }
					      else {
					        width = this.width;
					        height = this.height;
					        if (!this.svgViewportTransformation) {
					          vpt = this.viewportTransform;
					          width /= vpt[0];
					          height /= vpt[3];
					        }
					      }
					
					      markup.push(
					        '<svg ',
					          'xmlns="http://www.w3.org/2000/svg" ',
					          'xmlns:xlink="http://www.w3.org/1999/xlink" ',
					          'version="1.1" ',
					          'width="', width, '" ',
					          'height="', height, '" ',
					          (this.backgroundColor && !this.backgroundColor.toLive
					            ? 'style="background-color: ' + this.backgroundColor + '" '
					            : null),
					          (options.viewBox
					              ? 'viewBox="' +
					                options.viewBox.x + ' ' +
					                options.viewBox.y + ' ' +
					                options.viewBox.width + ' ' +
					                options.viewBox.height + '" '
					              : null),
					          'xml:space="preserve">',
					        '<desc>Created with Fabric.js ', fabric.version, '</desc>',
					        '<defs>',
					          fabric.createSVGFontFacesMarkup(this.getObjects()),
					          fabric.createSVGRefElementsMarkup(this),
					        '</defs>'
					      );
					    },
					
					    /**
					     * @private
					     */
					    _setSVGObjects: function(markup, reviver) {
					      for (var i = 0, objects = this.getObjects(), len = objects.length; i < len; i++) {
					        var instance = objects[i],
					            //If the object is in a selection group, simulate what would happen to that
					            //object when the group is deselected
					            originalProperties = this._realizeGroupTransformOnObject(instance);
					        markup.push(instance.toSVG(reviver));
					        this._unwindGroupTransformOnObject(instance, originalProperties);
					      }
					    },
					
					    /**
					     * @private
					     */
					    _setSVGBgOverlayImage: function(markup, property) {
					      if (this[property] && this[property].toSVG) {
					        markup.push(this[property].toSVG());
					      }
					    },
					
					    /**
					     * @private
					     */
					    _setSVGBgOverlayColor: function(markup, property) {
					      if (this[property] && this[property].source) {
					        markup.push(
					          '<rect x="', this[property].offsetX, '" y="', this[property].offsetY, '" ',
					            'width="',
					              (this[property].repeat === 'repeat-y' || this[property].repeat === 'no-repeat'
					                ? this[property].source.width
					                : this.width),
					            '" height="',
					              (this[property].repeat === 'repeat-x' || this[property].repeat === 'no-repeat'
					                ? this[property].source.height
					                : this.height),
					            '" fill="url(#' + property + 'Pattern)"',
					          '></rect>'
					        );
					      }
					      else if (this[property] && property === 'overlayColor') {
					        markup.push(
					          '<rect x="0" y="0" ',
					            'width="', this.width,
					            '" height="', this.height,
					            '" fill="', this[property], '"',
					          '></rect>'
					        );
					      }
					    },
					    /* _TO_SVG_END_ */
					
					    /**
					     * Moves an object to the bottom of the stack of drawn objects
					     * @param {fabric.Object} object Object to send to back
					     * @return {fabric.Canvas} thisArg
					     * @chainable
					     */
					    sendToBack: function (object) {
					      removeFromArray(this._objects, object);
					      this._objects.unshift(object);
					      return this.renderAll && this.renderAll();
					    },
					
					    /**
					     * Moves an object to the top of the stack of drawn objects
					     * @param {fabric.Object} object Object to send
					     * @return {fabric.Canvas} thisArg
					     * @chainable
					     */
					    bringToFront: function (object) {
					      removeFromArray(this._objects, object);
					      this._objects.push(object);
					      return this.renderAll && this.renderAll();
					    },
					
					    /**
					     * Moves an object down in stack of drawn objects
					     * @param {fabric.Object} object Object to send
					     * @param {Boolean} [intersecting] If `true`, send object behind next lower intersecting object
					     * @return {fabric.Canvas} thisArg
					     * @chainable
					     */
					    sendBackwards: function (object, intersecting) {
					      var idx = this._objects.indexOf(object);
					
					      // if object is not on the bottom of stack
					      if (idx !== 0) {
					        var newIdx = this._findNewLowerIndex(object, idx, intersecting);
					
					        removeFromArray(this._objects, object);
					        this._objects.splice(newIdx, 0, object);
					        this.renderAll && this.renderAll();
					      }
					      return this;
					    },
					
					    /**
					     * @private
					     */
					    _findNewLowerIndex: function(object, idx, intersecting) {
					      var newIdx;
					
					      if (intersecting) {
					        newIdx = idx;
					
					        // traverse down the stack looking for the nearest intersecting object
					        for (var i = idx - 1; i >= 0; --i) {
					
					          var isIntersecting = object.intersectsWithObject(this._objects[i]) ||
					                               object.isContainedWithinObject(this._objects[i]) ||
					                               this._objects[i].isContainedWithinObject(object);
					
					          if (isIntersecting) {
					            newIdx = i;
					            break;
					          }
					        }
					      }
					      else {
					        newIdx = idx - 1;
					      }
					
					      return newIdx;
					    },
					
					    /**
					     * Moves an object up in stack of drawn objects
					     * @param {fabric.Object} object Object to send
					     * @param {Boolean} [intersecting] If `true`, send object in front of next upper intersecting object
					     * @return {fabric.Canvas} thisArg
					     * @chainable
					     */
					    bringForward: function (object, intersecting) {
					      var idx = this._objects.indexOf(object);
					
					      // if object is not on top of stack (last item in an array)
					      if (idx !== this._objects.length - 1) {
					        var newIdx = this._findNewUpperIndex(object, idx, intersecting);
					
					        removeFromArray(this._objects, object);
					        this._objects.splice(newIdx, 0, object);
					        this.renderAll && this.renderAll();
					      }
					      return this;
					    },
					
					    /**
					     * @private
					     */
					    _findNewUpperIndex: function(object, idx, intersecting) {
					      var newIdx;
					
					      if (intersecting) {
					        newIdx = idx;
					
					        // traverse up the stack looking for the nearest intersecting object
					        for (var i = idx + 1; i < this._objects.length; ++i) {
					
					          var isIntersecting = object.intersectsWithObject(this._objects[i]) ||
					                               object.isContainedWithinObject(this._objects[i]) ||
					                               this._objects[i].isContainedWithinObject(object);
					
					          if (isIntersecting) {
					            newIdx = i;
					            break;
					          }
					        }
					      }
					      else {
					        newIdx = idx + 1;
					      }
					
					      return newIdx;
					    },
					
					    /**
					     * Moves an object to specified level in stack of drawn objects
					     * @param {fabric.Object} object Object to send
					     * @param {Number} index Position to move to
					     * @return {fabric.Canvas} thisArg
					     * @chainable
					     */
					    moveTo: function (object, index) {
					      removeFromArray(this._objects, object);
					      this._objects.splice(index, 0, object);
					      return this.renderAll && this.renderAll();
					    },
					
					    /**
					     * Clears a canvas element and removes all event listeners
					     * @return {fabric.Canvas} thisArg
					     * @chainable
					     */
					    dispose: function () {
					      this.clear();
					      this.interactive && this.removeListeners();
					      return this;
					    },
					
					    /**
					     * Returns a string representation of an instance
					     * @return {String} string representation of an instance
					     */
					    toString: function () {
					      return '#<fabric.Canvas (' + this.complexity() + '): ' +
					               '{ objects: ' + this.getObjects().length + ' }>';
					    }
					  });
					
					  extend(fabric.StaticCanvas.prototype, fabric.Observable);
					  extend(fabric.StaticCanvas.prototype, fabric.Collection);
					  extend(fabric.StaticCanvas.prototype, fabric.DataURLExporter);
					
					  extend(fabric.StaticCanvas, /** @lends fabric.StaticCanvas */ {
					
					    /**
					     * @static
					     * @type String
					     * @default
					     */
					    EMPTY_JSON: '{"objects": [], "background": "white"}',
					
					    /**
					     * Provides a way to check support of some of the canvas methods
					     * (either those of HTMLCanvasElement itself, or rendering context)
					     *
					     * @param {String} methodName Method to check support for;
					     *                            Could be one of "getImageData", "toDataURL", "toDataURLWithQuality" or "setLineDash"
					     * @return {Boolean | null} `true` if method is supported (or at least exists),
					     *                          `null` if canvas element or context can not be initialized
					     */
					    supports: function (methodName) {
					      var el = fabric.util.createCanvasElement();
					
					      if (!el || !el.getContext) {
					        return null;
					      }
					
					      var ctx = el.getContext('2d');
					      if (!ctx) {
					        return null;
					      }
					
					      switch (methodName) {
					
					        case 'getImageData':
					          return typeof ctx.getImageData !== 'undefined';
					
					        case 'setLineDash':
					          return typeof ctx.setLineDash !== 'undefined';
					
					        case 'toDataURL':
					          return typeof el.toDataURL !== 'undefined';
					
					        case 'toDataURLWithQuality':
					          try {
					            el.toDataURL('image/jpeg', 0);
					            return true;
					          }
					          catch (e) { }
					          return false;
					
					        default:
					          return null;
					      }
					    }
					  });
					
					  /**
					   * Returns JSON representation of canvas
					   * @function
					   * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output
					   * @return {String} JSON string
					   * @tutorial {@link http://fabricjs.com/fabric-intro-part-3/#serialization}
					   * @see {@link http://jsfiddle.net/fabricjs/pec86/|jsFiddle demo}
					   * @example <caption>JSON without additional properties</caption>
					   * var json = canvas.toJSON();
					   * @example <caption>JSON with additional properties included</caption>
					   * var json = canvas.toJSON(['lockMovementX', 'lockMovementY', 'lockRotation', 'lockScalingX', 'lockScalingY', 'lockUniScaling']);
					   * @example <caption>JSON without default values</caption>
					   * canvas.includeDefaultValues = false;
					   * var json = canvas.toJSON();
					   */
					  fabric.StaticCanvas.prototype.toJSON = fabric.StaticCanvas.prototype.toObject;
					
					})();
					(function() {
					
					  var getPointer = fabric.util.getPointer,
					      degreesToRadians = fabric.util.degreesToRadians,
					      radiansToDegrees = fabric.util.radiansToDegrees,
					      atan2 = Math.atan2,
					      abs = Math.abs,
					
					      STROKE_OFFSET = 0.5;
					
					  /**
					   * Canvas class
					   * @class fabric.Canvas
					   * @extends fabric.StaticCanvas
					   * @tutorial {@link http://fabricjs.com/fabric-intro-part-1/#canvas}
					   * @see {@link fabric.Canvas#initialize} for constructor definition
					   *
					   * @fires object:modified
					   * @fires object:rotating
					   * @fires object:scaling
					   * @fires object:moving
					   * @fires object:selected
					   *
					   * @fires before:selection:cleared
					   * @fires selection:cleared
					   * @fires selection:created
					   *
					   * @fires path:created
					   * @fires mouse:down
					   * @fires mouse:move
					   * @fires mouse:up
					   * @fires mouse:over
					   * @fires mouse:out
					   *
					   */
					  fabric.Canvas = fabric.util.createClass(fabric.StaticCanvas, /** @lends fabric.Canvas.prototype */ {
					
					    /**
					     * Constructor
					     * @param {HTMLElement | String} el &lt;canvas> element to initialize instance on
					     * @param {Object} [options] Options object
					     * @return {Object} thisArg
					     */
					    initialize: function(el, options) {
					      options || (options = { });
					
					      this._initStatic(el, options);
					      this._initInteractive();
					      this._createCacheCanvas();
					
					      fabric.Canvas.activeInstance = this;
					    },
					
					    /**
					     * When true, objects can be transformed by one side (unproportionally)
					     * @type Boolean
					     * @default
					     */
					    uniScaleTransform:      false,
					
					    /**
					     * When true, objects use center point as the origin of scale transformation.
					     * <b>Backwards incompatibility note:</b> This property replaces "centerTransform" (Boolean).
					     * @since 1.3.4
					     * @type Boolean
					     * @default
					     */
					    centeredScaling:        false,
					
					    /**
					     * When true, objects use center point as the origin of rotate transformation.
					     * <b>Backwards incompatibility note:</b> This property replaces "centerTransform" (Boolean).
					     * @since 1.3.4
					     * @type Boolean
					     * @default
					     */
					    centeredRotation:       false,
					
					    /**
					     * Indicates that canvas is interactive. This property should not be changed.
					     * @type Boolean
					     * @default
					     */
					    interactive:            true,
					
					    /**
					     * Indicates whether group selection should be enabled
					     * @type Boolean
					     * @default
					     */
					    selection:              true,
					
					    /**
					     * Color of selection
					     * @type String
					     * @default
					     */
					    selectionColor:         'rgba(100, 100, 255, 0.3)', // blue
					
					    /**
					     * Default dash array pattern
					     * If not empty the selection border is dashed
					     * @type Array
					     */
					    selectionDashArray:     [ ],
					
					    /**
					     * Color of the border of selection (usually slightly darker than color of selection itself)
					     * @type String
					     * @default
					     */
					    selectionBorderColor:   'rgba(255, 255, 255, 0.3)',
					
					    /**
					     * Width of a line used in object/group selection
					     * @type Number
					     * @default
					     */
					    selectionLineWidth:     1,
					
					    /**
					     * Default cursor value used when hovering over an object on canvas
					     * @type String
					     * @default
					     */
					    hoverCursor:            'move',
					
					    /**
					     * Default cursor value used when moving an object on canvas
					     * @type String
					     * @default
					     */
					    moveCursor:             'move',
					
					    /**
					     * Default cursor value used for the entire canvas
					     * @type String
					     * @default
					     */
					    defaultCursor:          'default',
					
					    /**
					     * Cursor value used during free drawing
					     * @type String
					     * @default
					     */
					    freeDrawingCursor:      'crosshair',
					
					    /**
					     * Cursor value used for rotation point
					     * @type String
					     * @default
					     */
					    rotationCursor:         'crosshair',
					
					    /**
					     * Default element class that's given to wrapper (div) element of canvas
					     * @type String
					     * @default
					     */
					    containerClass:         'canvas-container',
					
					    /**
					     * When true, object detection happens on per-pixel basis rather than on per-bounding-box
					     * @type Boolean
					     * @default
					     */
					    perPixelTargetFind:     false,
					
					    /**
					     * Number of pixels around target pixel to tolerate (consider active) during object detection
					     * @type Number
					     * @default
					     */
					    targetFindTolerance:    0,
					
					    /**
					     * When true, target detection is skipped when hovering over canvas. This can be used to improve performance.
					     * @type Boolean
					     * @default
					     */
					    skipTargetFind:         false,
					
					    /**
					     * @private
					     */
					    _initInteractive: function() {
					      this._currentTransform = null;
					      this._groupSelector = null;
					      this._initWrapperElement();
					      this._createUpperCanvas();
					      this._initEventListeners();
					
					      this.freeDrawingBrush = fabric.PencilBrush && new fabric.PencilBrush(this);
					
					      this.calcOffset();
					    },
					
					    /**
					     * Resets the current transform to its original values and chooses the type of resizing based on the event
					     * @private
					     * @param {Event} e Event object fired on mousemove
					     */
					    _resetCurrentTransform: function(e) {
					      var t = this._currentTransform;
					
					      t.target.set({
					        scaleX: t.original.scaleX,
					        scaleY: t.original.scaleY,
					        left: t.original.left,
					        top: t.original.top
					      });
					
					      if (this._shouldCenterTransform(e, t.target)) {
					        if (t.action === 'rotate') {
					          this._setOriginToCenter(t.target);
					        }
					        else {
					          if (t.originX !== 'center') {
					            if (t.originX === 'right') {
					              t.mouseXSign = -1;
					            }
					            else {
					              t.mouseXSign = 1;
					            }
					          }
					          if (t.originY !== 'center') {
					            if (t.originY === 'bottom') {
					              t.mouseYSign = -1;
					            }
					            else {
					              t.mouseYSign = 1;
					            }
					          }
					
					          t.originX = 'center';
					          t.originY = 'center';
					        }
					      }
					      else {
					        t.originX = t.original.originX;
					        t.originY = t.original.originY;
					      }
					    },
					
					    /**
					     * Checks if point is contained within an area of given object
					     * @param {Event} e Event object
					     * @param {fabric.Object} target Object to test against
					     * @return {Boolean} true if point is contained within an area of given object
					     */
					    containsPoint: function (e, target) {
					      var pointer = this.getPointer(e, true),
					          xy = this._normalizePointer(target, pointer);
					
					      // http://www.geog.ubc.ca/courses/klink/gis.notes/ncgia/u32.html
					      // http://idav.ucdavis.edu/~okreylos/TAship/Spring2000/PointInPolygon.html
					      return (target.containsPoint(xy) || target._findTargetCorner(pointer));
					    },
					
					    /**
					     * @private
					     */
					    _normalizePointer: function (object, pointer) {
					      var activeGroup = this.getActiveGroup(),
					          x = pointer.x,
					          y = pointer.y,
					          isObjectInGroup = (
					            activeGroup &&
					            object.type !== 'group' &&
					            activeGroup.contains(object)),
					          lt;
					
					      if (isObjectInGroup) {
					        lt = new fabric.Point(activeGroup.left, activeGroup.top);
					        lt = fabric.util.transformPoint(lt, this.viewportTransform, true);
					        x -= lt.x;
					        y -= lt.y;
					      }
					      return { x: x, y: y };
					    },
					
					    /**
					     * Returns true if object is transparent at a certain location
					     * @param {fabric.Object} target Object to check
					     * @param {Number} x Left coordinate
					     * @param {Number} y Top coordinate
					     * @return {Boolean}
					     */
					    isTargetTransparent: function (target, x, y) {
					      var hasBorders = target.hasBorders,
					          transparentCorners = target.transparentCorners;
					
					      target.hasBorders = target.transparentCorners = false;
					
					      this._draw(this.contextCache, target);
					
					      target.hasBorders = hasBorders;
					      target.transparentCorners = transparentCorners;
					
					      var isTransparent = fabric.util.isTransparent(
					        this.contextCache, x, y, this.targetFindTolerance);
					
					      this.clearContext(this.contextCache);
					
					      return isTransparent;
					    },
					
					    /**
					     * @private
					     * @param {Event} e Event object
					     * @param {fabric.Object} target
					     */
					    _shouldClearSelection: function (e, target) {
					      var activeGroup = this.getActiveGroup(),
					          activeObject = this.getActiveObject();
					
					      return (
					        !target
					        ||
					        (target &&
					          activeGroup &&
					          !activeGroup.contains(target) &&
					          activeGroup !== target &&
					          !e.shiftKey)
					        ||
					        (target && !target.evented)
					        ||
					        (target &&
					          !target.selectable &&
					          activeObject &&
					          activeObject !== target)
					      );
					    },
					
					    /**
					     * @private
					     * @param {Event} e Event object
					     * @param {fabric.Object} target
					     */
					    _shouldCenterTransform: function (e, target) {
					      if (!target) {
					        return;
					      }
					
					      var t = this._currentTransform,
					          centerTransform;
					
					      if (t.action === 'scale' || t.action === 'scaleX' || t.action === 'scaleY') {
					        centerTransform = this.centeredScaling || target.centeredScaling;
					      }
					      else if (t.action === 'rotate') {
					        centerTransform = this.centeredRotation || target.centeredRotation;
					      }
					
					      return centerTransform ? !e.altKey : e.altKey;
					    },
					
					    /**
					     * @private
					     */
					    _getOriginFromCorner: function(target, corner) {
					      var origin = {
					        x: target.originX,
					        y: target.originY
					      };
					
					      if (corner === 'ml' || corner === 'tl' || corner === 'bl') {
					        origin.x = 'right';
					      }
					      else if (corner === 'mr' || corner === 'tr' || corner === 'br') {
					        origin.x = 'left';
					      }
					
					      if (corner === 'tl' || corner === 'mt' || corner === 'tr') {
					        origin.y = 'bottom';
					      }
					      else if (corner === 'bl' || corner === 'mb' || corner === 'br') {
					        origin.y = 'top';
					      }
					
					      return origin;
					    },
					
					    /**
					     * @private
					     */
					    _getActionFromCorner: function(target, corner) {
					      var action = 'drag';
					      if (corner) {
					        action = (corner === 'ml' || corner === 'mr')
					          ? 'scaleX'
					          : (corner === 'mt' || corner === 'mb')
					            ? 'scaleY'
					            : corner === 'mtr'
					              ? 'rotate'
					              : 'scale';
					      }
					      return action;
					    },
					
					    /**
					     * @private
					     * @param {Event} e Event object
					     * @param {fabric.Object} target
					     */
					    _setupCurrentTransform: function (e, target) {
					      if (!target) {
					        return;
					      }
					
					      var pointer = this.getPointer(e),
					          corner = target._findTargetCorner(this.getPointer(e, true)),
					          action = this._getActionFromCorner(target, corner),
					          origin = this._getOriginFromCorner(target, corner);
					
					      this._currentTransform = {
					        target: target,
					        action: action,
					        scaleX: target.scaleX,
					        scaleY: target.scaleY,
					        offsetX: pointer.x - target.left,
					        offsetY: pointer.y - target.top,
					        originX: origin.x,
					        originY: origin.y,
					        ex: pointer.x,
					        ey: pointer.y,
					        left: target.left,
					        top: target.top,
					        theta: degreesToRadians(target.angle),
					        width: target.width * target.scaleX,
					        mouseXSign: 1,
					        mouseYSign: 1
					      };
					
					      this._currentTransform.original = {
					        left: target.left,
					        top: target.top,
					        scaleX: target.scaleX,
					        scaleY: target.scaleY,
					        originX: origin.x,
					        originY: origin.y
					      };
					
					      this._resetCurrentTransform(e);
					    },
					
					    /**
					     * Translates object by "setting" its left/top
					     * @private
					     * @param {Number} x pointer's x coordinate
					     * @param {Number} y pointer's y coordinate
					     */
					    _translateObject: function (x, y) {
					      var target = this._currentTransform.target;
					
					      if (!target.get('lockMovementX')) {
					        target.set('left', x - this._currentTransform.offsetX);
					      }
					      if (!target.get('lockMovementY')) {
					        target.set('top', y - this._currentTransform.offsetY);
					      }
					    },
					
					    /**
					     * Scales object by invoking its scaleX/scaleY methods
					     * @private
					     * @param {Number} x pointer's x coordinate
					     * @param {Number} y pointer's y coordinate
					     * @param {String} by Either 'x' or 'y' - specifies dimension constraint by which to scale an object.
					     *                    When not provided, an object is scaled by both dimensions equally
					     */
					    _scaleObject: function (x, y, by) {
					      var t = this._currentTransform,
					          target = t.target,
					          lockScalingX = target.get('lockScalingX'),
					          lockScalingY = target.get('lockScalingY'),
					          lockScalingFlip = target.get('lockScalingFlip');
					
					      if (lockScalingX && lockScalingY) {
					        return;
					      }
					
					      // Get the constraint point
					      var constraintPosition = target.translateToOriginPoint(target.getCenterPoint(), t.originX, t.originY),
					          localMouse = target.toLocalPoint(new fabric.Point(x, y), t.originX, t.originY);
					
					      this._setLocalMouse(localMouse, t);
					
					      // Actually scale the object
					      this._setObjectScale(localMouse, t, lockScalingX, lockScalingY, by, lockScalingFlip);
					
					      // Make sure the constraints apply
					      target.setPositionByOrigin(constraintPosition, t.originX, t.originY);
					    },
					
					    /**
					     * @private
					     */
					    _setObjectScale: function(localMouse, transform, lockScalingX, lockScalingY, by, lockScalingFlip) {
					      var target = transform.target, forbidScalingX = false, forbidScalingY = false,
					          strokeWidth = target.stroke ? target.strokeWidth : 0;
					
					      transform.newScaleX = localMouse.x / (target.width + strokeWidth / 2);
					      transform.newScaleY = localMouse.y / (target.height + strokeWidth / 2);
					
					      if (lockScalingFlip && transform.newScaleX <= 0 && transform.newScaleX < target.scaleX) {
					        forbidScalingX = true;
					      }
					
					      if (lockScalingFlip && transform.newScaleY <= 0 && transform.newScaleY < target.scaleY) {
					        forbidScalingY = true;
					      }
					
					      if (by === 'equally' && !lockScalingX && !lockScalingY) {
					        forbidScalingX || forbidScalingY || this._scaleObjectEqually(localMouse, target, transform);
					      }
					      else if (!by) {
					        forbidScalingX || lockScalingX || target.set('scaleX', transform.newScaleX);
					        forbidScalingY || lockScalingY || target.set('scaleY', transform.newScaleY);
					      }
					      else if (by === 'x' && !target.get('lockUniScaling')) {
					        forbidScalingX || lockScalingX || target.set('scaleX', transform.newScaleX);
					      }
					      else if (by === 'y' && !target.get('lockUniScaling')) {
					        forbidScalingY || lockScalingY || target.set('scaleY', transform.newScaleY);
					      }
					
					      forbidScalingX || forbidScalingY || this._flipObject(transform, by);
					
					    },
					
					    /**
					     * @private
					     */
					    _scaleObjectEqually: function(localMouse, target, transform) {
					
					      var dist = localMouse.y + localMouse.x,
					          strokeWidth = target.stroke ? target.strokeWidth : 0,
					          lastDist = (target.height + (strokeWidth / 2)) * transform.original.scaleY +
					                     (target.width + (strokeWidth / 2)) * transform.original.scaleX;
					
					      // We use transform.scaleX/Y instead of target.scaleX/Y
					      // because the object may have a min scale and we'll loose the proportions
					      transform.newScaleX = transform.original.scaleX * dist / lastDist;
					      transform.newScaleY = transform.original.scaleY * dist / lastDist;
					
					      target.set('scaleX', transform.newScaleX);
					      target.set('scaleY', transform.newScaleY);
					    },
					
					    /**
					     * @private
					     */
					    _flipObject: function(transform, by) {
					      if (transform.newScaleX < 0 && by !== 'y') {
					        if (transform.originX === 'left') {
					          transform.originX = 'right';
					        }
					        else if (transform.originX === 'right') {
					          transform.originX = 'left';
					        }
					      }
					
					      if (transform.newScaleY < 0 && by !== 'x') {
					        if (transform.originY === 'top') {
					          transform.originY = 'bottom';
					        }
					        else if (transform.originY === 'bottom') {
					          transform.originY = 'top';
					        }
					      }
					    },
					
					    /**
					     * @private
					     */
					    _setLocalMouse: function(localMouse, t) {
					      var target = t.target;
					
					      if (t.originX === 'right') {
					        localMouse.x *= -1;
					      }
					      else if (t.originX === 'center') {
					        localMouse.x *= t.mouseXSign * 2;
					
					        if (localMouse.x < 0) {
					          t.mouseXSign = -t.mouseXSign;
					        }
					      }
					
					      if (t.originY === 'bottom') {
					        localMouse.y *= -1;
					      }
					      else if (t.originY === 'center') {
					        localMouse.y *= t.mouseYSign * 2;
					
					        if (localMouse.y < 0) {
					          t.mouseYSign = -t.mouseYSign;
					        }
					      }
					
					      // adjust the mouse coordinates when dealing with padding
					      if (abs(localMouse.x) > target.padding) {
					        if (localMouse.x < 0) {
					          localMouse.x += target.padding;
					        }
					        else {
					          localMouse.x -= target.padding;
					        }
					      }
					      else { // mouse is within the padding, set to 0
					        localMouse.x = 0;
					      }
					
					      if (abs(localMouse.y) > target.padding) {
					        if (localMouse.y < 0) {
					          localMouse.y += target.padding;
					        }
					        else {
					          localMouse.y -= target.padding;
					        }
					      }
					      else {
					        localMouse.y = 0;
					      }
					    },
					
					    /**
					     * Rotates object by invoking its rotate method
					     * @private
					     * @param {Number} x pointer's x coordinate
					     * @param {Number} y pointer's y coordinate
					     */
					    _rotateObject: function (x, y) {
					
					      var t = this._currentTransform;
					
					      if (t.target.get('lockRotation')) {
					        return;
					      }
					
					      var lastAngle = atan2(t.ey - t.top, t.ex - t.left),
					          curAngle = atan2(y - t.top, x - t.left),
					          angle = radiansToDegrees(curAngle - lastAngle + t.theta);
					
					      // normalize angle to positive value
					      if (angle < 0) {
					        angle = 360 + angle;
					      }
					
					      t.target.angle = angle % 360;
					    },
					
					    /**
					     * Set the cursor type of the canvas element
					     * @param {String} value Cursor type of the canvas element.
					     * @see http://www.w3.org/TR/css3-ui/#cursor
					     */
					    setCursor: function (value) {
					      this.upperCanvasEl.style.cursor = value;
					    },
					
					    /**
					     * @private
					     */
					    _resetObjectTransform: function (target) {
					      target.scaleX = 1;
					      target.scaleY = 1;
					      target.setAngle(0);
					    },
					
					    /**
					     * @private
					     */
					    _drawSelection: function () {
					      var ctx = this.contextTop,
					          groupSelector = this._groupSelector,
					          left = groupSelector.left,
					          top = groupSelector.top,
					          aleft = abs(left),
					          atop = abs(top);
					
					      ctx.fillStyle = this.selectionColor;
					
					      ctx.fillRect(
					        groupSelector.ex - ((left > 0) ? 0 : -left),
					        groupSelector.ey - ((top > 0) ? 0 : -top),
					        aleft,
					        atop
					      );
					
					      ctx.lineWidth = this.selectionLineWidth;
					      ctx.strokeStyle = this.selectionBorderColor;
					
					      // selection border
					      if (this.selectionDashArray.length > 1) {
					
					        var px = groupSelector.ex + STROKE_OFFSET - ((left > 0) ? 0: aleft),
					            py = groupSelector.ey + STROKE_OFFSET - ((top > 0) ? 0: atop);
					
					        ctx.beginPath();
					
					        fabric.util.drawDashedLine(ctx, px, py, px + aleft, py, this.selectionDashArray);
					        fabric.util.drawDashedLine(ctx, px, py + atop - 1, px + aleft, py + atop - 1, this.selectionDashArray);
					        fabric.util.drawDashedLine(ctx, px, py, px, py + atop, this.selectionDashArray);
					        fabric.util.drawDashedLine(ctx, px + aleft - 1, py, px + aleft - 1, py + atop, this.selectionDashArray);
					
					        ctx.closePath();
					        ctx.stroke();
					      }
					      else {
					        ctx.strokeRect(
					          groupSelector.ex + STROKE_OFFSET - ((left > 0) ? 0 : aleft),
					          groupSelector.ey + STROKE_OFFSET - ((top > 0) ? 0 : atop),
					          aleft,
					          atop
					        );
					      }
					    },
					
					    /**
					     * @private
					     */
					    _isLastRenderedObject: function(e) {
					      return (
					        this.controlsAboveOverlay &&
					        this.lastRenderedObjectWithControlsAboveOverlay &&
					        this.lastRenderedObjectWithControlsAboveOverlay.visible &&
					        this.containsPoint(e, this.lastRenderedObjectWithControlsAboveOverlay) &&
					        this.lastRenderedObjectWithControlsAboveOverlay._findTargetCorner(this.getPointer(e, true)));
					    },
					
					    /**
					     * Method that determines what object we are clicking on
					     * @param {Event} e mouse event
					     * @param {Boolean} skipGroup when true, group is skipped and only objects are traversed through
					     */
					    findTarget: function (e, skipGroup) {
					      if (this.skipTargetFind) {
					        return;
					      }
					
					      if (this._isLastRenderedObject(e)) {
					        return this.lastRenderedObjectWithControlsAboveOverlay;
					      }
					
					      // first check current group (if one exists)
					      var activeGroup = this.getActiveGroup();
					      if (activeGroup && !skipGroup && this.containsPoint(e, activeGroup)) {
					        return activeGroup;
					      }
					
					      var target = this._searchPossibleTargets(e);
					      this._fireOverOutEvents(target);
					
					      return target;
					    },
					
					    /**
					     * @private
					     */
					    _fireOverOutEvents: function(target) {
					      if (target) {
					        if (this._hoveredTarget !== target) {
					          this.fire('mouse:over', { target: target });
					          target.fire('mouseover');
					          if (this._hoveredTarget) {
					            this.fire('mouse:out', { target: this._hoveredTarget });
					            this._hoveredTarget.fire('mouseout');
					          }
					          this._hoveredTarget = target;
					        }
					      }
					      else if (this._hoveredTarget) {
					        this.fire('mouse:out', { target: this._hoveredTarget });
					        this._hoveredTarget.fire('mouseout');
					        this._hoveredTarget = null;
					      }
					    },
					
					    /**
					    * @private
					    */
					    _checkTarget: function(e, obj, pointer) {
					      if (obj &&
					          obj.visible &&
					          obj.evented &&
					          this.containsPoint(e, obj)){
					        if ((this.perPixelTargetFind || obj.perPixelTargetFind) && !obj.isEditing) {
					          var isTransparent = this.isTargetTransparent(obj, pointer.x, pointer.y);
					          if (!isTransparent) {
					            return true;
					          }
					        }
					        else {
					          return true;
					        }
					      }
					    },
					
					    /**
					     * @private
					     */
					    _searchPossibleTargets: function(e) {
					
					      // Cache all targets where their bounding box contains point.
					      var target,
					          pointer = this.getPointer(e, true),
					          i = this._objects.length;
					      // Do not check for currently grouped objects, since we check the parent group itself.
					      while (i--) {
					        if (!this._objects[i].group && this._checkTarget(e, this._objects[i], pointer)){
					          this.relatedTarget = this._objects[i];
					          target = this._objects[i];
					          break;
					        }
					      }
					
					      return target;
					    },
					
					    /**
					     * Returns pointer coordinates relative to canvas.
					     * @param {Event} e
					     * @return {Object} object with "x" and "y" number values
					     */
					    getPointer: function (e, ignoreZoom, upperCanvasEl) {
					      if (!upperCanvasEl) {
					        upperCanvasEl = this.upperCanvasEl;
					      }
					      var pointer = getPointer(e, upperCanvasEl),
					          bounds = upperCanvasEl.getBoundingClientRect(),
					          boundsWidth = bounds.width || 0,
					          boundsHeight = bounds.height || 0,
					          cssScale;
					
					      if (!boundsWidth || !boundsHeight ) {
					        if ('top' in bounds && 'bottom' in bounds) {
					          boundsHeight = Math.abs( bounds.top - bounds.bottom );
					        }
					        if ('right' in bounds && 'left' in bounds) {
					          boundsWidth = Math.abs( bounds.right - bounds.left );
					        }
					      }
					
					      this.calcOffset();
					
					      pointer.x = pointer.x - this._offset.left;
					      pointer.y = pointer.y - this._offset.top;
					      if (!ignoreZoom) {
					        pointer = fabric.util.transformPoint(
					          pointer,
					          fabric.util.invertTransform(this.viewportTransform)
					        );
					      }
					
					      if (boundsWidth === 0 || boundsHeight === 0) {
					        // If bounds are not available (i.e. not visible), do not apply scale.
					        cssScale = { width: 1, height: 1 };
					      }
					      else {
					        cssScale = {
					          width: upperCanvasEl.width / boundsWidth,
					          height: upperCanvasEl.height / boundsHeight
					        };
					      }
					
					      return {
					        x: pointer.x * cssScale.width,
					        y: pointer.y * cssScale.height
					      };
					    },
					
					    /**
					     * @private
					     * @throws {CANVAS_INIT_ERROR} If canvas can not be initialized
					     */
					    _createUpperCanvas: function () {
					      var lowerCanvasClass = this.lowerCanvasEl.className.replace(/\s*lower-canvas\s*/, '');
					
					      this.upperCanvasEl = this._createCanvasElement();
					      fabric.util.addClass(this.upperCanvasEl, 'upper-canvas ' + lowerCanvasClass);
					
					      this.wrapperEl.appendChild(this.upperCanvasEl);
					
					      this._copyCanvasStyle(this.lowerCanvasEl, this.upperCanvasEl);
					      this._applyCanvasStyle(this.upperCanvasEl);
					      this.contextTop = this.upperCanvasEl.getContext('2d');
					    },
					
					    /**
					     * @private
					     */
					    _createCacheCanvas: function () {
					      this.cacheCanvasEl = this._createCanvasElement();
					      this.cacheCanvasEl.setAttribute('width', this.width);
					      this.cacheCanvasEl.setAttribute('height', this.height);
					      this.contextCache = this.cacheCanvasEl.getContext('2d');
					    },
					
					    /**
					     * @private
					     */
					    _initWrapperElement: function () {
					      this.wrapperEl = fabric.util.wrapElement(this.lowerCanvasEl, 'div', {
					        'class': this.containerClass
					      });
					      fabric.util.setStyle(this.wrapperEl, {
					        width: this.getWidth() + 'px',
					        height: this.getHeight() + 'px',
					        position: 'relative'
					      });
					      fabric.util.makeElementUnselectable(this.wrapperEl);
					    },
					
					    /**
					     * @private
					     * @param {HTMLElement} element canvas element to apply styles on
					     */
					    _applyCanvasStyle: function (element) {
					      var width = this.getWidth() || element.width,
					          height = this.getHeight() || element.height;
					
					      fabric.util.setStyle(element, {
					        position: 'absolute',
					        width: width + 'px',
					        height: height + 'px',
					        left: 0,
					        top: 0
					      });
					      element.width = width;
					      element.height = height;
					      fabric.util.makeElementUnselectable(element);
					    },
					
					    /**
					     * Copys the the entire inline style from one element (fromEl) to another (toEl)
					     * @private
					     * @param {Element} fromEl Element style is copied from
					     * @param {Element} toEl Element copied style is applied to
					     */
					    _copyCanvasStyle: function (fromEl, toEl) {
					      toEl.style.cssText = fromEl.style.cssText;
					    },
					
					    /**
					     * Returns context of canvas where object selection is drawn
					     * @return {CanvasRenderingContext2D}
					     */
					    getSelectionContext: function() {
					      return this.contextTop;
					    },
					
					    /**
					     * Returns &lt;canvas> element on which object selection is drawn
					     * @return {HTMLCanvasElement}
					     */
					    getSelectionElement: function () {
					      return this.upperCanvasEl;
					    },
					
					    /**
					     * @private
					     * @param {Object} object
					     */
					    _setActiveObject: function(object) {
					      if (this._activeObject) {
					        this._activeObject.set('active', false);
					      }
					      this._activeObject = object;
					      object.set('active', true);
					    },
					
					    /**
					     * Sets given object as the only active object on canvas
					     * @param {fabric.Object} object Object to set as an active one
					     * @param {Event} [e] Event (passed along when firing "object:selected")
					     * @return {fabric.Canvas} thisArg
					     * @chainable
					     */
					    setActiveObject: function (object, e) {
					      this._setActiveObject(object);
					      this.renderAll();
					      this.fire('object:selected', { target: object, e: e });
					      object.fire('selected', { e: e });
					      return this;
					    },
					
					    /**
					     * Returns currently active object
					     * @return {fabric.Object} active object
					     */
					    getActiveObject: function () {
					      return this._activeObject;
					    },
					
					    /**
					     * @private
					     */
					    _discardActiveObject: function() {
					      if (this._activeObject) {
					        this._activeObject.set('active', false);
					      }
					      this._activeObject = null;
					    },
					
					    /**
					     * Discards currently active object
					     * @return {fabric.Canvas} thisArg
					     * @chainable
					     */
					    discardActiveObject: function (e) {
					      this._discardActiveObject();
					      this.renderAll();
					      this.fire('selection:cleared', { e: e });
					      return this;
					    },
					
					    /**
					     * @private
					     * @param {fabric.Group} group
					     */
					    _setActiveGroup: function(group) {
					      this._activeGroup = group;
					      if (group) {
					        group.set('active', true);
					      }
					    },
					
					    /**
					     * Sets active group to a speicified one
					     * @param {fabric.Group} group Group to set as a current one
					     * @return {fabric.Canvas} thisArg
					     * @chainable
					     */
					    setActiveGroup: function (group, e) {
					      this._setActiveGroup(group);
					      if (group) {
					        this.fire('object:selected', { target: group, e: e });
					        group.fire('selected', { e: e });
					      }
					      return this;
					    },
					
					    /**
					     * Returns currently active group
					     * @return {fabric.Group} Current group
					     */
					    getActiveGroup: function () {
					      return this._activeGroup;
					    },
					
					    /**
					     * @private
					     */
					    _discardActiveGroup: function() {
					      var g = this.getActiveGroup();
					      if (g) {
					        g.destroy();
					      }
					      this.setActiveGroup(null);
					    },
					
					    /**
					     * Discards currently active group
					     * @return {fabric.Canvas} thisArg
					     */
					    discardActiveGroup: function (e) {
					      this._discardActiveGroup();
					      this.fire('selection:cleared', { e: e });
					      return this;
					    },
					
					    /**
					     * Deactivates all objects on canvas, removing any active group or object
					     * @return {fabric.Canvas} thisArg
					     */
					    deactivateAll: function () {
					      var allObjects = this.getObjects(),
					          i = 0,
					          len = allObjects.length;
					      for ( ; i < len; i++) {
					        allObjects[i].set('active', false);
					      }
					      this._discardActiveGroup();
					      this._discardActiveObject();
					      return this;
					    },
					
					    /**
					     * Deactivates all objects and dispatches appropriate events
					     * @return {fabric.Canvas} thisArg
					     */
					    deactivateAllWithDispatch: function (e) {
					      var activeObject = this.getActiveGroup() || this.getActiveObject();
					      if (activeObject) {
					        this.fire('before:selection:cleared', { target: activeObject, e: e });
					      }
					      this.deactivateAll();
					      if (activeObject) {
					        this.fire('selection:cleared', { e: e });
					      }
					      return this;
					    },
					
					    /**
					     * Draws objects' controls (borders/controls)
					     * @param {CanvasRenderingContext2D} ctx Context to render controls on
					     */
					    drawControls: function(ctx) {
					      var activeGroup = this.getActiveGroup();
					      if (activeGroup) {
					        this._drawGroupControls(ctx, activeGroup);
					      }
					      else {
					        this._drawObjectsControls(ctx);
					      }
					    },
					
					    /**
					     * @private
					     */
					    _drawGroupControls: function(ctx, activeGroup) {
					      activeGroup._renderControls(ctx);
					    },
					
					    /**
					     * @private
					     */
					    _drawObjectsControls: function(ctx) {
					      for (var i = 0, len = this._objects.length; i < len; ++i) {
					        if (!this._objects[i] || !this._objects[i].active) {
					          continue;
					        }
					        this._objects[i]._renderControls(ctx);
					        this.lastRenderedObjectWithControlsAboveOverlay = this._objects[i];
					      }
					    }
					  });
					
					  // copying static properties manually to work around Opera's bug,
					  // where "prototype" property is enumerable and overrides existing prototype
					  for (var prop in fabric.StaticCanvas) {
					    if (prop !== 'prototype') {
					      fabric.Canvas[prop] = fabric.StaticCanvas[prop];
					    }
					  }
					
					  if (fabric.isTouchSupported) {
					    /** @ignore */
					    fabric.Canvas.prototype._setCursorFromEvent = function() { };
					  }
					
					  /**
					   * @class fabric.Element
					   * @alias fabric.Canvas
					   * @deprecated Use {@link fabric.Canvas} instead.
					   * @constructor
					   */
					  fabric.Element = fabric.Canvas;
					})();
					(function() {
					
					  var cursorOffset = {
					    mt: 0, // n
					    tr: 1, // ne
					    mr: 2, // e
					    br: 3, // se
					    mb: 4, // s
					    bl: 5, // sw
					    ml: 6, // w
					    tl: 7 // nw
					  },
					  addListener = fabric.util.addListener,
					  removeListener = fabric.util.removeListener;
					
					  fabric.util.object.extend(fabric.Canvas.prototype, /** @lends fabric.Canvas.prototype */ {
					
					    /**
					     * Map of cursor style values for each of the object controls
					     * @private
					     */
					    cursorMap: [
					      'n-resize',
					      'ne-resize',
					      'e-resize',
					      'se-resize',
					      's-resize',
					      'sw-resize',
					      'w-resize',
					      'nw-resize'
					    ],
					
					    /**
					     * Adds mouse listeners to canvas
					     * @private
					     */
					    _initEventListeners: function () {
					
					      this._bindEvents();
					
					      addListener(fabric.window, 'resize', this._onResize);
					
					      // mouse events
					      addListener(this.upperCanvasEl, 'mousedown', this._onMouseDown);
					      addListener(this.upperCanvasEl, 'mousemove', this._onMouseMove);
					      addListener(this.upperCanvasEl, 'mousewheel', this._onMouseWheel);
					
					      // touch events
					      addListener(this.upperCanvasEl, 'touchstart', this._onMouseDown);
					      addListener(this.upperCanvasEl, 'touchmove', this._onMouseMove);
					
					      if (typeof eventjs !== 'undefined' && 'add' in eventjs) {
					        eventjs.add(this.upperCanvasEl, 'gesture', this._onGesture);
					        eventjs.add(this.upperCanvasEl, 'drag', this._onDrag);
					        eventjs.add(this.upperCanvasEl, 'orientation', this._onOrientationChange);
					        eventjs.add(this.upperCanvasEl, 'shake', this._onShake);
					        eventjs.add(this.upperCanvasEl, 'longpress', this._onLongPress);
					      }
					    },
					
					    /**
					     * @private
					     */
					    _bindEvents: function() {
					      this._onMouseDown = this._onMouseDown.bind(this);
					      this._onMouseMove = this._onMouseMove.bind(this);
					      this._onMouseUp = this._onMouseUp.bind(this);
					      this._onResize = this._onResize.bind(this);
					      this._onGesture = this._onGesture.bind(this);
					      this._onDrag = this._onDrag.bind(this);
					      this._onShake = this._onShake.bind(this);
					      this._onLongPress = this._onLongPress.bind(this);
					      this._onOrientationChange = this._onOrientationChange.bind(this);
					      this._onMouseWheel = this._onMouseWheel.bind(this);
					    },
					
					    /**
					     * Removes all event listeners
					     */
					    removeListeners: function() {
					      removeListener(fabric.window, 'resize', this._onResize);
					
					      removeListener(this.upperCanvasEl, 'mousedown', this._onMouseDown);
					      removeListener(this.upperCanvasEl, 'mousemove', this._onMouseMove);
					      removeListener(this.upperCanvasEl, 'mousewheel', this._onMouseWheel);
					
					      removeListener(this.upperCanvasEl, 'touchstart', this._onMouseDown);
					      removeListener(this.upperCanvasEl, 'touchmove', this._onMouseMove);
					
					      if (typeof eventjs !== 'undefined' && 'remove' in eventjs) {
					        eventjs.remove(this.upperCanvasEl, 'gesture', this._onGesture);
					        eventjs.remove(this.upperCanvasEl, 'drag', this._onDrag);
					        eventjs.remove(this.upperCanvasEl, 'orientation', this._onOrientationChange);
					        eventjs.remove(this.upperCanvasEl, 'shake', this._onShake);
					        eventjs.remove(this.upperCanvasEl, 'longpress', this._onLongPress);
					      }
					    },
					
					    /**
					     * @private
					     * @param {Event} [e] Event object fired on Event.js gesture
					     * @param {Event} [self] Inner Event object
					     */
					    _onGesture: function(e, self) {
					      this.__onTransformGesture && this.__onTransformGesture(e, self);
					    },
					
					    /**
					     * @private
					     * @param {Event} [e] Event object fired on Event.js drag
					     * @param {Event} [self] Inner Event object
					     */
					    _onDrag: function(e, self) {
					      this.__onDrag && this.__onDrag(e, self);
					    },
					
					    /**
					     * @private
					     * @param {Event} [e] Event object fired on Event.js wheel event
					     * @param {Event} [self] Inner Event object
					     */
					    _onMouseWheel: function(e, self) {
					      this.__onMouseWheel && this.__onMouseWheel(e, self);
					    },
					
					    /**
					     * @private
					     * @param {Event} [e] Event object fired on Event.js orientation change
					     * @param {Event} [self] Inner Event object
					     */
					    _onOrientationChange: function(e, self) {
					      this.__onOrientationChange && this.__onOrientationChange(e, self);
					    },
					
					    /**
					     * @private
					     * @param {Event} [e] Event object fired on Event.js shake
					     * @param {Event} [self] Inner Event object
					     */
					    _onShake: function(e, self) {
					      this.__onShake && this.__onShake(e, self);
					    },
					    /**
					     * @private
					     * @param {Event} [e] Event object fired on Event.js shake
					     * @param {Event} [self] Inner Event object
					     */
					    _onLongPress: function(e, self) {
					      this.__onLongPress && this.__onLongPress(e, self);
					    },
					
					    /**
					     * @private
					     * @param {Event} e Event object fired on mousedown
					     */
					    _onMouseDown: function (e) {
					      this.__onMouseDown(e);
					
					      addListener(fabric.document, 'touchend', this._onMouseUp);
					      addListener(fabric.document, 'touchmove', this._onMouseMove);
					
					      removeListener(this.upperCanvasEl, 'mousemove', this._onMouseMove);
					      removeListener(this.upperCanvasEl, 'touchmove', this._onMouseMove);
					
					      if (e.type === 'touchstart') {
					        // Unbind mousedown to prevent double triggers from touch devices
					        removeListener(this.upperCanvasEl, 'mousedown', this._onMouseDown);
					      }
					      else {
					        addListener(fabric.document, 'mouseup', this._onMouseUp);
					        addListener(fabric.document, 'mousemove', this._onMouseMove);
					      }
					    },
					
					    /**
					     * @private
					     * @param {Event} e Event object fired on mouseup
					     */
					    _onMouseUp: function (e) {
					      this.__onMouseUp(e);
					
					      removeListener(fabric.document, 'mouseup', this._onMouseUp);
					      removeListener(fabric.document, 'touchend', this._onMouseUp);
					
					      removeListener(fabric.document, 'mousemove', this._onMouseMove);
					      removeListener(fabric.document, 'touchmove', this._onMouseMove);
					
					      addListener(this.upperCanvasEl, 'mousemove', this._onMouseMove);
					      addListener(this.upperCanvasEl, 'touchmove', this._onMouseMove);
					
					      if (e.type === 'touchend') {
					        // Wait 400ms before rebinding mousedown to prevent double triggers
					        // from touch devices
					        var _this = this;
					        setTimeout(function() {
					          addListener(_this.upperCanvasEl, 'mousedown', _this._onMouseDown);
					        }, 400);
					      }
					    },
					
					    /**
					     * @private
					     * @param {Event} e Event object fired on mousemove
					     */
					    _onMouseMove: function (e) {
					      !this.allowTouchScrolling && e.preventDefault && e.preventDefault();
					      this.__onMouseMove(e);
					    },
					
					    /**
					     * @private
					     */
					    _onResize: function () {
					      this.calcOffset();
					    },
					
					    /**
					     * Decides whether the canvas should be redrawn in mouseup and mousedown events.
					     * @private
					     * @param {Object} target
					     * @param {Object} pointer
					     */
					    _shouldRender: function(target, pointer) {
					      var activeObject = this.getActiveGroup() || this.getActiveObject();
					
					      return !!(
					        (target && (
					          target.isMoving ||
					          target !== activeObject))
					        ||
					        (!target && !!activeObject)
					        ||
					        (!target && !activeObject && !this._groupSelector)
					        ||
					        (pointer &&
					          this._previousPointer &&
					          this.selection && (
					          pointer.x !== this._previousPointer.x ||
					          pointer.y !== this._previousPointer.y))
					      );
					    },
					
					    /**
					     * Method that defines the actions when mouse is released on canvas.
					     * The method resets the currentTransform parameters, store the image corner
					     * position in the image object and render the canvas on top.
					     * @private
					     * @param {Event} e Event object fired on mouseup
					     */
					    __onMouseUp: function (e) {
					      var target;
					
					      if (this.isDrawingMode && this._isCurrentlyDrawing) {
					        this._onMouseUpInDrawingMode(e);
					        return;
					      }
					
					      if (this._currentTransform) {
					        this._finalizeCurrentTransform();
					        target = this._currentTransform.target;
					      }
					      else {
					        target = this.findTarget(e, true);
					      }
					
					      var shouldRender = this._shouldRender(target, this.getPointer(e));
					
					      this._maybeGroupObjects(e);
					
					      if (target) {
					        target.isMoving = false;
					      }
					
					      shouldRender && this.renderAll();
					
					      this._handleCursorAndEvent(e, target);
					    },
					
					    _handleCursorAndEvent: function(e, target) {
					      this._setCursorFromEvent(e, target);
					
					      // TODO: why are we doing this?
					      var _this = this;
					      setTimeout(function () {
					        _this._setCursorFromEvent(e, target);
					      }, 50);
					
					      this.fire('mouse:up', { target: target, e: e });
					      target && target.fire('mouseup', { e: e });
					    },
					
					    /**
					     * @private
					     */
					    _finalizeCurrentTransform: function() {
					
					      var transform = this._currentTransform,
					          target = transform.target;
					
					      if (target._scaling) {
					        target._scaling = false;
					      }
					
					      target.setCoords();
					
					      // only fire :modified event if target coordinates were changed during mousedown-mouseup
					      if (this.stateful && target.hasStateChanged()) {
					        this.fire('object:modified', { target: target });
					        target.fire('modified');
					      }
					
					      this._restoreOriginXY(target);
					    },
					
					    /**
					     * @private
					     * @param {Object} target Object to restore
					     */
					    _restoreOriginXY: function(target) {
					      if (this._previousOriginX && this._previousOriginY) {
					
					        var originPoint = target.translateToOriginPoint(
					          target.getCenterPoint(),
					          this._previousOriginX,
					          this._previousOriginY);
					
					        target.originX = this._previousOriginX;
					        target.originY = this._previousOriginY;
					
					        target.left = originPoint.x;
					        target.top = originPoint.y;
					
					        this._previousOriginX = null;
					        this._previousOriginY = null;
					      }
					    },
					
					    /**
					     * @private
					     * @param {Event} e Event object fired on mousedown
					     */
					    _onMouseDownInDrawingMode: function(e) {
					      this._isCurrentlyDrawing = true;
					      this.discardActiveObject(e).renderAll();
					      if (this.clipTo) {
					        fabric.util.clipContext(this, this.contextTop);
					      }
					      var ivt = fabric.util.invertTransform(this.viewportTransform),
					          pointer = fabric.util.transformPoint(this.getPointer(e, true), ivt);
					      this.freeDrawingBrush.onMouseDown(pointer);
					      this.fire('mouse:down', { e: e });
					
					      var target = this.findTarget(e);
					      if (typeof target !== 'undefined') {
					        target.fire('mousedown', { e: e, target: target });
					      }
					    },
					
					    /**
					     * @private
					     * @param {Event} e Event object fired on mousemove
					     */
					    _onMouseMoveInDrawingMode: function(e) {
					      if (this._isCurrentlyDrawing) {
					        var ivt = fabric.util.invertTransform(this.viewportTransform),
					            pointer = fabric.util.transformPoint(this.getPointer(e, true), ivt);
					        this.freeDrawingBrush.onMouseMove(pointer);
					      }
					      this.setCursor(this.freeDrawingCursor);
					      this.fire('mouse:move', { e: e });
					
					      var target = this.findTarget(e);
					      if (typeof target !== 'undefined') {
					        target.fire('mousemove', { e: e, target: target });
					      }
					    },
					
					    /**
					     * @private
					     * @param {Event} e Event object fired on mouseup
					     */
					    _onMouseUpInDrawingMode: function(e) {
					      this._isCurrentlyDrawing = false;
					      if (this.clipTo) {
					        this.contextTop.restore();
					      }
					      this.freeDrawingBrush.onMouseUp();
					      this.fire('mouse:up', { e: e });
					
					      var target = this.findTarget(e);
					      if (typeof target !== 'undefined') {
					        target.fire('mouseup', { e: e, target: target });
					      }
					    },
					
					    /**
					     * Method that defines the actions when mouse is clic ked on canvas.
					     * The method inits the currentTransform parameters and renders all the
					     * canvas so the current image can be placed on the top canvas and the rest
					     * in on the container one.
					     * @private
					     * @param {Event} e Event object fired on mousedown
					     */
					    __onMouseDown: function (e) {
					
					      // accept only left clicks
					      var isLeftClick  = 'which' in e ? e.which === 1 : e.button === 1;
					      if (!isLeftClick && !fabric.isTouchSupported) {
					        return;
					      }
					
					      if (this.isDrawingMode) {
					        this._onMouseDownInDrawingMode(e);
					        return;
					      }
					
					      // ignore if some object is being transformed at this moment
					      if (this._currentTransform) {
					        return;
					      }
					
					      var target = this.findTarget(e),
					          pointer = this.getPointer(e, true);
					
					      // save pointer for check in __onMouseUp event
					      this._previousPointer = pointer;
					
					      var shouldRender = this._shouldRender(target, pointer),
					          shouldGroup = this._shouldGroup(e, target);
					
					      if (this._shouldClearSelection(e, target)) {
					        this._clearSelection(e, target, pointer);
					      }
					      else if (shouldGroup) {
					        this._handleGrouping(e, target);
					        target = this.getActiveGroup();
					      }
					
					      if (target && target.selectable && !shouldGroup) {
					        this._beforeTransform(e, target);
					        this._setupCurrentTransform(e, target);
					      }
					      // we must renderAll so that active image is placed on the top canvas
					      shouldRender && this.renderAll();
					
					      this.fire('mouse:down', { target: target, e: e });
					      target && target.fire('mousedown', { e: e });
					    },
					
					    /**
					     * @private
					     */
					    _beforeTransform: function(e, target) {
					      this.stateful && target.saveState();
					
					      // determine if it's a drag or rotate case
					      if (target._findTargetCorner(this.getPointer(e))) {
					        this.onBeforeScaleRotate(target);
					      }
					
					      if (target !== this.getActiveGroup() && target !== this.getActiveObject()) {
					        this.deactivateAll();
					        this.setActiveObject(target, e);
					      }
					    },
					
					    /**
					     * @private
					     */
					    _clearSelection: function(e, target, pointer) {
					      this.deactivateAllWithDispatch(e);
					
					      if (target && target.selectable) {
					        this.setActiveObject(target, e);
					      }
					      else if (this.selection) {
					        this._groupSelector = {
					          ex: pointer.x,
					          ey: pointer.y,
					          top: 0,
					          left: 0
					        };
					      }
					    },
					
					    /**
					     * @private
					     * @param {Object} target Object for that origin is set to center
					     */
					    _setOriginToCenter: function(target) {
					      this._previousOriginX = this._currentTransform.target.originX;
					      this._previousOriginY = this._currentTransform.target.originY;
					
					      var center = target.getCenterPoint();
					
					      target.originX = 'center';
					      target.originY = 'center';
					
					      target.left = center.x;
					      target.top = center.y;
					
					      this._currentTransform.left = target.left;
					      this._currentTransform.top = target.top;
					    },
					
					    /**
					     * @private
					     * @param {Object} target Object for that center is set to origin
					     */
					    _setCenterToOrigin: function(target) {
					      var originPoint = target.translateToOriginPoint(
					        target.getCenterPoint(),
					        this._previousOriginX,
					        this._previousOriginY);
					
					      target.originX = this._previousOriginX;
					      target.originY = this._previousOriginY;
					
					      target.left = originPoint.x;
					      target.top = originPoint.y;
					
					      this._previousOriginX = null;
					      this._previousOriginY = null;
					    },
					
					    /**
					      * Method that defines the actions when mouse is hovering the canvas.
					      * The currentTransform parameter will definde whether the user is rotating/scaling/translating
					      * an image or neither of them (only hovering). A group selection is also possible and would cancel
					      * all any other type of action.
					      * In case of an image transformation only the top canvas will be rendered.
					      * @private
					      * @param {Event} e Event object fired on mousemove
					      */
					    __onMouseMove: function (e) {
					
					      var target, pointer;
					
					      if (this.isDrawingMode) {
					        this._onMouseMoveInDrawingMode(e);
					        return;
					      }
					      if (typeof e.touches !== 'undefined' && e.touches.length > 1) {
					        return;
					      }
					
					      var groupSelector = this._groupSelector;
					
					      // We initially clicked in an empty area, so we draw a box for multiple selection
					      if (groupSelector) {
					        pointer = this.getPointer(e, true);
					
					        groupSelector.left = pointer.x - groupSelector.ex;
					        groupSelector.top = pointer.y - groupSelector.ey;
					
					        this.renderTop();
					      }
					      else if (!this._currentTransform) {
					
					        target = this.findTarget(e);
					
					        if (!target || target && !target.selectable) {
					          this.setCursor(this.defaultCursor);
					        }
					        else {
					          this._setCursorFromEvent(e, target);
					        }
					      }
					      else {
					        this._transformObject(e);
					      }
					
					      this.fire('mouse:move', { target: target, e: e });
					      target && target.fire('mousemove', { e: e });
					    },
					
					    /**
					     * @private
					     * @param {Event} e Event fired on mousemove
					     */
					    _transformObject: function(e) {
					      var pointer = this.getPointer(e),
					          transform = this._currentTransform;
					
					      transform.reset = false,
					      transform.target.isMoving = true;
					
					      this._beforeScaleTransform(e, transform);
					      this._performTransformAction(e, transform, pointer);
					
					      this.renderAll();
					    },
					
					    /**
					     * @private
					     */
					    _performTransformAction: function(e, transform, pointer) {
					      var x = pointer.x,
					          y = pointer.y,
					          target = transform.target,
					          action = transform.action;
					
					      if (action === 'rotate') {
					        this._rotateObject(x, y);
					        this._fire('rotating', target, e);
					      }
					      else if (action === 'scale') {
					        this._onScale(e, transform, x, y);
					        this._fire('scaling', target, e);
					      }
					      else if (action === 'scaleX') {
					        this._scaleObject(x, y, 'x');
					        this._fire('scaling', target, e);
					      }
					      else if (action === 'scaleY') {
					        this._scaleObject(x, y, 'y');
					        this._fire('scaling', target, e);
					      }
					      else {
					        this._translateObject(x, y);
					        this._fire('moving', target, e);
					        this.setCursor(this.moveCursor);
					      }
					    },
					
					    /**
					     * @private
					     */
					    _fire: function(eventName, target, e) {
					      this.fire('object:' + eventName, { target: target, e: e });
					      target.fire(eventName, { e: e });
					    },
					
					    /**
					     * @private
					     */
					    _beforeScaleTransform: function(e, transform) {
					      if (transform.action === 'scale' || transform.action === 'scaleX' || transform.action === 'scaleY') {
					        var centerTransform = this._shouldCenterTransform(e, transform.target);
					
					        // Switch from a normal resize to center-based
					        if ((centerTransform && (transform.originX !== 'center' || transform.originY !== 'center')) ||
					           // Switch from center-based resize to normal one
					           (!centerTransform && transform.originX === 'center' && transform.originY === 'center')
					        ) {
					          this._resetCurrentTransform(e);
					          transform.reset = true;
					        }
					      }
					    },
					
					    /**
					     * @private
					     */
					    _onScale: function(e, transform, x, y) {
					      // rotate object only if shift key is not pressed
					      // and if it is not a group we are transforming
					      if ((e.shiftKey || this.uniScaleTransform) && !transform.target.get('lockUniScaling')) {
					        transform.currentAction = 'scale';
					        this._scaleObject(x, y);
					      }
					      else {
					        // Switch from a normal resize to proportional
					        if (!transform.reset && transform.currentAction === 'scale') {
					          this._resetCurrentTransform(e, transform.target);
					        }
					
					        transform.currentAction = 'scaleEqually';
					        this._scaleObject(x, y, 'equally');
					      }
					    },
					
					    /**
					     * Sets the cursor depending on where the canvas is being hovered.
					     * Note: very buggy in Opera
					     * @param {Event} e Event object
					     * @param {Object} target Object that the mouse is hovering, if so.
					     */
					    _setCursorFromEvent: function (e, target) {
					      if (!target || !target.selectable) {
					        this.setCursor(this.defaultCursor);
					        return false;
					      }
					      else {
					        var activeGroup = this.getActiveGroup(),
					            // only show proper corner when group selection is not active
					            corner = target._findTargetCorner
					                      && (!activeGroup || !activeGroup.contains(target))
					                      && target._findTargetCorner(this.getPointer(e, true));
					
					        if (!corner) {
					          this.setCursor(target.hoverCursor || this.hoverCursor);
					        }
					        else {
					          this._setCornerCursor(corner, target);
					        }
					      }
					      return true;
					    },
					
					    /**
					     * @private
					     */
					    _setCornerCursor: function(corner, target) {
					      if (corner in cursorOffset) {
					        this.setCursor(this._getRotatedCornerCursor(corner, target));
					      }
					      else if (corner === 'mtr' && target.hasRotatingPoint) {
					        this.setCursor(this.rotationCursor);
					      }
					      else {
					        this.setCursor(this.defaultCursor);
					        return false;
					      }
					    },
					
					    /**
					     * @private
					     */
					    _getRotatedCornerCursor: function(corner, target) {
					      var n = Math.round((target.getAngle() % 360) / 45);
					
					      if (n < 0) {
					        n += 8; // full circle ahead
					      }
					      n += cursorOffset[corner];
					      // normalize n to be from 0 to 7
					      n %= 8;
					
					      return this.cursorMap[n];
					    }
					  });
					})();
					(function() {
					
					  var min = Math.min,
					      max = Math.max;
					
					  fabric.util.object.extend(fabric.Canvas.prototype, /** @lends fabric.Canvas.prototype */ {
					
					    /**
					     * @private
					     * @param {Event} e Event object
					     * @param {fabric.Object} target
					     * @return {Boolean}
					     */
					    _shouldGroup: function(e, target) {
					      var activeObject = this.getActiveObject();
					      return e.shiftKey &&
					            (this.getActiveGroup() || (activeObject && activeObject !== target))
					            && this.selection;
					    },
					
					    /**
					     * @private
					     * @param {Event} e Event object
					     * @param {fabric.Object} target
					     */
					    _handleGrouping: function (e, target) {
					
					      if (target === this.getActiveGroup()) {
					
					        // if it's a group, find target again, this time skipping group
					        target = this.findTarget(e, true);
					
					        // if even object is not found, bail out
					        if (!target || target.isType('group')) {
					          return;
					        }
					      }
					      if (this.getActiveGroup()) {
					        this._updateActiveGroup(target, e);
					      }
					      else {
					        this._createActiveGroup(target, e);
					      }
					
					      if (this._activeGroup) {
					        this._activeGroup.saveCoords();
					      }
					    },
					
					    /**
					     * @private
					     */
					    _updateActiveGroup: function(target, e) {
					      var activeGroup = this.getActiveGroup();
					
					      if (activeGroup.contains(target)) {
					
					        activeGroup.removeWithUpdate(target);
					        this._resetObjectTransform(activeGroup);
					        target.set('active', false);
					
					        if (activeGroup.size() === 1) {
					          // remove group alltogether if after removal it only contains 1 object
					          this.discardActiveGroup(e);
					          // activate last remaining object
					          this.setActiveObject(activeGroup.item(0));
					          return;
					        }
					      }
					      else {
					        activeGroup.addWithUpdate(target);
					        this._resetObjectTransform(activeGroup);
					      }
					      this.fire('selection:created', { target: activeGroup, e: e });
					      activeGroup.set('active', true);
					    },
					
					    /**
					     * @private
					     */
					    _createActiveGroup: function(target, e) {
					
					      if (this._activeObject && target !== this._activeObject) {
					
					        var group = this._createGroup(target);
					        group.addWithUpdate();
					
					        this.setActiveGroup(group);
					        this._activeObject = null;
					
					        this.fire('selection:created', { target: group, e: e });
					      }
					
					      target.set('active', true);
					    },
					
					    /**
					     * @private
					     * @param {Object} target
					     */
					    _createGroup: function(target) {
					
					      var objects = this.getObjects(),
					          isActiveLower = objects.indexOf(this._activeObject) < objects.indexOf(target),
					          groupObjects = isActiveLower
					            ? [ this._activeObject, target ]
					            : [ target, this._activeObject ];
					
					      return new fabric.Group(groupObjects, {
					        canvas: this
					      });
					    },
					
					    /**
					     * @private
					     * @param {Event} e mouse event
					     */
					    _groupSelectedObjects: function (e) {
					
					      var group = this._collectObjects();
					
					      // do not create group for 1 element only
					      if (group.length === 1) {
					        this.setActiveObject(group[0], e);
					      }
					      else if (group.length > 1) {
					        group = new fabric.Group(group.reverse(), {
					          canvas: this
					        });
					        group.addWithUpdate();
					        this.setActiveGroup(group, e);
					        group.saveCoords();
					        this.fire('selection:created', { target: group });
					        this.renderAll();
					      }
					    },
					
					    /**
					     * @private
					     */
					    _collectObjects: function() {
					      var group = [ ],
					          currentObject,
					          x1 = this._groupSelector.ex,
					          y1 = this._groupSelector.ey,
					          x2 = x1 + this._groupSelector.left,
					          y2 = y1 + this._groupSelector.top,
					          selectionX1Y1 = new fabric.Point(min(x1, x2), min(y1, y2)),
					          selectionX2Y2 = new fabric.Point(max(x1, x2), max(y1, y2)),
					          isClick = x1 === x2 && y1 === y2;
					
					      for (var i = this._objects.length; i--; ) {
					        currentObject = this._objects[i];
					
					        if (!currentObject || !currentObject.selectable || !currentObject.visible) {
					          continue;
					        }
					
					        if (currentObject.intersectsWithRect(selectionX1Y1, selectionX2Y2) ||
					            currentObject.isContainedWithinRect(selectionX1Y1, selectionX2Y2) ||
					            currentObject.containsPoint(selectionX1Y1) ||
					            currentObject.containsPoint(selectionX2Y2)
					        ) {
					          currentObject.set('active', true);
					          group.push(currentObject);
					
					          // only add one object if it's a click
					          if (isClick) {
					            break;
					          }
					        }
					      }
					
					      return group;
					    },
					
					    /**
					     * @private
					     */
					    _maybeGroupObjects: function(e) {
					      if (this.selection && this._groupSelector) {
					        this._groupSelectedObjects(e);
					      }
					
					      var activeGroup = this.getActiveGroup();
					      if (activeGroup) {
					        activeGroup.setObjectsCoords().setCoords();
					        activeGroup.isMoving = false;
					        this.setCursor(this.defaultCursor);
					      }
					
					      // clear selection and current transformation
					      this._groupSelector = null;
					      this._currentTransform = null;
					    }
					  });
					
					})();
					fabric.util.object.extend(fabric.StaticCanvas.prototype, /** @lends fabric.StaticCanvas.prototype */ {
					
					  /**
					   * Exports canvas element to a dataurl image. Note that when multiplier is used, cropping is scaled appropriately
					   * @param {Object} [options] Options object
					   * @param {String} [options.format=png] The format of the output image. Either "jpeg" or "png"
					   * @param {Number} [options.quality=1] Quality level (0..1). Only used for jpeg.
					   * @param {Number} [options.multiplier=1] Multiplier to scale by
					   * @param {Number} [options.left] Cropping left offset. Introduced in v1.2.14
					   * @param {Number} [options.top] Cropping top offset. Introduced in v1.2.14
					   * @param {Number} [options.width] Cropping width. Introduced in v1.2.14
					   * @param {Number} [options.height] Cropping height. Introduced in v1.2.14
					   * @return {String} Returns a data: URL containing a representation of the object in the format specified by options.format
					   * @see {@link http://jsfiddle.net/fabricjs/NfZVb/|jsFiddle demo}
					   * @example <caption>Generate jpeg dataURL with lower quality</caption>
					   * var dataURL = canvas.toDataURL({
					   *   format: 'jpeg',
					   *   quality: 0.8
					   * });
					   * @example <caption>Generate cropped png dataURL (clipping of canvas)</caption>
					   * var dataURL = canvas.toDataURL({
					   *   format: 'png',
					   *   left: 100,
					   *   top: 100,
					   *   width: 200,
					   *   height: 200
					   * });
					   * @example <caption>Generate double scaled png dataURL</caption>
					   * var dataURL = canvas.toDataURL({
					   *   format: 'png',
					   *   multiplier: 2
					   * });
					   */
					  toDataURL: function (options) {
					    options || (options = { });
					
					    var format = options.format || 'png',
					        quality = options.quality || 1,
					        multiplier = options.multiplier || 1,
					        cropping = {
					          left: options.left,
					          top: options.top,
					          width: options.width,
					          height: options.height
					        };
					
					    if (multiplier !== 1) {
					      return this.__toDataURLWithMultiplier(format, quality, cropping, multiplier);
					    }
					    else {
					      return this.__toDataURL(format, quality, cropping);
					    }
					  },
					
					  /**
					   * @private
					   */
					  __toDataURL: function(format, quality, cropping) {
					
					    this.renderAll(true);
					
					    var canvasEl = this.upperCanvasEl || this.lowerCanvasEl,
					        croppedCanvasEl = this.__getCroppedCanvas(canvasEl, cropping);
					
					    // to avoid common confusion https://github.com/kangax/fabric.js/issues/806
					    if (format === 'jpg') {
					      format = 'jpeg';
					    }
					
					    var data = (fabric.StaticCanvas.supports('toDataURLWithQuality'))
					              ? (croppedCanvasEl || canvasEl).toDataURL('image/' + format, quality)
					              : (croppedCanvasEl || canvasEl).toDataURL('image/' + format);
					
					    this.contextTop && this.clearContext(this.contextTop);
					    this.renderAll();
					
					    if (croppedCanvasEl) {
					      croppedCanvasEl = null;
					    }
					
					    return data;
					  },
					
					  /**
					   * @private
					   */
					  __getCroppedCanvas: function(canvasEl, cropping) {
					
					    var croppedCanvasEl,
					        croppedCtx,
					        shouldCrop = 'left' in cropping ||
					                     'top' in cropping ||
					                     'width' in cropping ||
					                     'height' in cropping;
					
					    if (shouldCrop) {
					
					      croppedCanvasEl = fabric.util.createCanvasElement();
					      croppedCtx = croppedCanvasEl.getContext('2d');
					
					      croppedCanvasEl.width = cropping.width || this.width;
					      croppedCanvasEl.height = cropping.height || this.height;
					
					      croppedCtx.drawImage(canvasEl, -cropping.left || 0, -cropping.top || 0);
					    }
					
					    return croppedCanvasEl;
					  },
					
					  /**
					   * @private
					   */
					  __toDataURLWithMultiplier: function(format, quality, cropping, multiplier) {
					
					    var origWidth = this.getWidth(),
					        origHeight = this.getHeight(),
					        scaledWidth = origWidth * multiplier,
					        scaledHeight = origHeight * multiplier,
					        activeObject = this.getActiveObject(),
					        activeGroup = this.getActiveGroup(),
					
					        ctx = this.contextTop || this.contextContainer;
					
					    if (multiplier > 1) {
					      this.setWidth(scaledWidth).setHeight(scaledHeight);
					    }
					    ctx.scale(multiplier, multiplier);
					
					    if (cropping.left) {
					      cropping.left *= multiplier;
					    }
					    if (cropping.top) {
					      cropping.top *= multiplier;
					    }
					    if (cropping.width) {
					      cropping.width *= multiplier;
					    }
					    else if (multiplier < 1) {
					      cropping.width = scaledWidth;
					    }
					    if (cropping.height) {
					      cropping.height *= multiplier;
					    }
					    else if (multiplier < 1) {
					      cropping.height = scaledHeight;
					    }
					
					    if (activeGroup) {
					      // not removing group due to complications with restoring it with correct state afterwords
					      this._tempRemoveBordersControlsFromGroup(activeGroup);
					    }
					    else if (activeObject && this.deactivateAll) {
					      this.deactivateAll();
					    }
					
					    this.renderAll(true);
					
					    var data = this.__toDataURL(format, quality, cropping);
					
					    // restoring width, height for `renderAll` to draw
					    // background properly (while context is scaled)
					    this.width = origWidth;
					    this.height = origHeight;
					
					    ctx.scale(1 / multiplier,  1 / multiplier);
					    this.setWidth(origWidth).setHeight(origHeight);
					
					    if (activeGroup) {
					      this._restoreBordersControlsOnGroup(activeGroup);
					    }
					    else if (activeObject && this.setActiveObject) {
					      this.setActiveObject(activeObject);
					    }
					
					    this.contextTop && this.clearContext(this.contextTop);
					    this.renderAll();
					
					    return data;
					  },
					
					  /**
					   * Exports canvas element to a dataurl image (allowing to change image size via multiplier).
					   * @deprecated since 1.0.13
					   * @param {String} format (png|jpeg)
					   * @param {Number} multiplier
					   * @param {Number} quality (0..1)
					   * @return {String}
					   */
					  toDataURLWithMultiplier: function (format, multiplier, quality) {
					    return this.toDataURL({
					      format: format,
					      multiplier: multiplier,
					      quality: quality
					    });
					  },
					
					  /**
					   * @private
					   */
					  _tempRemoveBordersControlsFromGroup: function(group) {
					    group.origHasControls = group.hasControls;
					    group.origBorderColor = group.borderColor;
					
					    group.hasControls = true;
					    group.borderColor = 'rgba(0,0,0,0)';
					
					    group.forEachObject(function(o) {
					      o.origBorderColor = o.borderColor;
					      o.borderColor = 'rgba(0,0,0,0)';
					    });
					  },
					
					  /**
					   * @private
					   */
					  _restoreBordersControlsOnGroup: function(group) {
					    group.hideControls = group.origHideControls;
					    group.borderColor = group.origBorderColor;
					
					    group.forEachObject(function(o) {
					      o.borderColor = o.origBorderColor;
					      delete o.origBorderColor;
					    });
					  }
					});
					(function(global) {
					
					  'use strict';
					
					  var fabric = global.fabric || (global.fabric = { }),
					      extend = fabric.util.object.extend,
					      toFixed = fabric.util.toFixed,
					      capitalize = fabric.util.string.capitalize,
					      degreesToRadians = fabric.util.degreesToRadians,
					      supportsLineDash = fabric.StaticCanvas.supports('setLineDash');
					
					  if (fabric.Object) {
					    return;
					  }
					
					  /**
					   * Root object class from which all 2d shape classes inherit from
					   * @class fabric.Object
					   * @tutorial {@link http://fabricjs.com/fabric-intro-part-1/#objects}
					   * @see {@link fabric.Object#initialize} for constructor definition
					   *
					   * @fires added
					   * @fires removed
					   *
					   * @fires selected
					   * @fires modified
					   * @fires rotating
					   * @fires scaling
					   * @fires moving
					   *
					   * @fires mousedown
					   * @fires mouseup
					   */
					  fabric.Object = fabric.util.createClass(/** @lends fabric.Object.prototype */ {
					
					    /**
					     * Retrieves object's {@link fabric.Object#clipTo|clipping function}
					     * @method getClipTo
					     * @memberOf fabric.Object.prototype
					     * @return {Function}
					     */
					
					    /**
					     * Sets object's {@link fabric.Object#clipTo|clipping function}
					     * @method setClipTo
					     * @memberOf fabric.Object.prototype
					     * @param {Function} clipTo Clipping function
					     * @return {fabric.Object} thisArg
					     * @chainable
					     */
					
					    /**
					     * Retrieves object's {@link fabric.Object#transformMatrix|transformMatrix}
					     * @method getTransformMatrix
					     * @memberOf fabric.Object.prototype
					     * @return {Array} transformMatrix
					     */
					
					    /**
					     * Sets object's {@link fabric.Object#transformMatrix|transformMatrix}
					     * @method setTransformMatrix
					     * @memberOf fabric.Object.prototype
					     * @param {Array} transformMatrix
					     * @return {fabric.Object} thisArg
					     * @chainable
					     */
					
					    /**
					     * Retrieves object's {@link fabric.Object#visible|visible} state
					     * @method getVisible
					     * @memberOf fabric.Object.prototype
					     * @return {Boolean} True if visible
					     */
					
					    /**
					     * Sets object's {@link fabric.Object#visible|visible} state
					     * @method setVisible
					     * @memberOf fabric.Object.prototype
					     * @param {Boolean} value visible value
					     * @return {fabric.Object} thisArg
					     * @chainable
					     */
					
					    /**
					     * Retrieves object's {@link fabric.Object#shadow|shadow}
					     * @method getShadow
					     * @memberOf fabric.Object.prototype
					     * @return {Object} Shadow instance
					     */
					
					    /**
					     * Retrieves object's {@link fabric.Object#stroke|stroke}
					     * @method getStroke
					     * @memberOf fabric.Object.prototype
					     * @return {String} stroke value
					     */
					
					    /**
					     * Sets object's {@link fabric.Object#stroke|stroke}
					     * @method setStroke
					     * @memberOf fabric.Object.prototype
					     * @param {String} value stroke value
					     * @return {fabric.Object} thisArg
					     * @chainable
					     */
					
					    /**
					     * Retrieves object's {@link fabric.Object#strokeWidth|strokeWidth}
					     * @method getStrokeWidth
					     * @memberOf fabric.Object.prototype
					     * @return {Number} strokeWidth value
					     */
					
					    /**
					     * Sets object's {@link fabric.Object#strokeWidth|strokeWidth}
					     * @method setStrokeWidth
					     * @memberOf fabric.Object.prototype
					     * @param {Number} value strokeWidth value
					     * @return {fabric.Object} thisArg
					     * @chainable
					     */
					
					    /**
					     * Retrieves object's {@link fabric.Object#originX|originX}
					     * @method getOriginX
					     * @memberOf fabric.Object.prototype
					     * @return {String} originX value
					     */
					
					    /**
					     * Sets object's {@link fabric.Object#originX|originX}
					     * @method setOriginX
					     * @memberOf fabric.Object.prototype
					     * @param {String} value originX value
					     * @return {fabric.Object} thisArg
					     * @chainable
					     */
					
					    /**
					     * Retrieves object's {@link fabric.Object#originY|originY}
					     * @method getOriginY
					     * @memberOf fabric.Object.prototype
					     * @return {String} originY value
					     */
					
					    /**
					     * Sets object's {@link fabric.Object#originY|originY}
					     * @method setOriginY
					     * @memberOf fabric.Object.prototype
					     * @param {String} value originY value
					     * @return {fabric.Object} thisArg
					     * @chainable
					     */
					
					    /**
					     * Retrieves object's {@link fabric.Object#fill|fill}
					     * @method getFill
					     * @memberOf fabric.Object.prototype
					     * @return {String} Fill value
					     */
					
					    /**
					     * Sets object's {@link fabric.Object#fill|fill}
					     * @method setFill
					     * @memberOf fabric.Object.prototype
					     * @param {String} value Fill value
					     * @return {fabric.Object} thisArg
					     * @chainable
					     */
					
					    /**
					     * Retrieves object's {@link fabric.Object#opacity|opacity}
					     * @method getOpacity
					     * @memberOf fabric.Object.prototype
					     * @return {Number} Opacity value (0-1)
					     */
					
					    /**
					     * Sets object's {@link fabric.Object#opacity|opacity}
					     * @method setOpacity
					     * @memberOf fabric.Object.prototype
					     * @param {Number} value Opacity value (0-1)
					     * @return {fabric.Object} thisArg
					     * @chainable
					     */
					
					    /**
					     * Retrieves object's {@link fabric.Object#angle|angle} (in degrees)
					     * @method getAngle
					     * @memberOf fabric.Object.prototype
					     * @return {Number}
					     */
					
					    /**
					     * Retrieves object's {@link fabric.Object#top|top position}
					     * @method getTop
					     * @memberOf fabric.Object.prototype
					     * @return {Number} Top value (in pixels)
					     */
					
					    /**
					     * Sets object's {@link fabric.Object#top|top position}
					     * @method setTop
					     * @memberOf fabric.Object.prototype
					     * @param {Number} value Top value (in pixels)
					     * @return {fabric.Object} thisArg
					     * @chainable
					     */
					
					    /**
					     * Retrieves object's {@link fabric.Object#left|left position}
					     * @method getLeft
					     * @memberOf fabric.Object.prototype
					     * @return {Number} Left value (in pixels)
					     */
					
					    /**
					     * Sets object's {@link fabric.Object#left|left position}
					     * @method setLeft
					     * @memberOf fabric.Object.prototype
					     * @param {Number} value Left value (in pixels)
					     * @return {fabric.Object} thisArg
					     * @chainable
					     */
					
					    /**
					     * Retrieves object's {@link fabric.Object#scaleX|scaleX} value
					     * @method getScaleX
					     * @memberOf fabric.Object.prototype
					     * @return {Number} scaleX value
					     */
					
					    /**
					     * Sets object's {@link fabric.Object#scaleX|scaleX} value
					     * @method setScaleX
					     * @memberOf fabric.Object.prototype
					     * @param {Number} value scaleX value
					     * @return {fabric.Object} thisArg
					     * @chainable
					     */
					
					    /**
					     * Retrieves object's {@link fabric.Object#scaleY|scaleY} value
					     * @method getScaleY
					     * @memberOf fabric.Object.prototype
					     * @return {Number} scaleY value
					     */
					
					    /**
					     * Sets object's {@link fabric.Object#scaleY|scaleY} value
					     * @method setScaleY
					     * @memberOf fabric.Object.prototype
					     * @param {Number} value scaleY value
					     * @return {fabric.Object} thisArg
					     * @chainable
					     */
					
					    /**
					     * Retrieves object's {@link fabric.Object#flipX|flipX} value
					     * @method getFlipX
					     * @memberOf fabric.Object.prototype
					     * @return {Boolean} flipX value
					     */
					
					    /**
					     * Sets object's {@link fabric.Object#flipX|flipX} value
					     * @method setFlipX
					     * @memberOf fabric.Object.prototype
					     * @param {Boolean} value flipX value
					     * @return {fabric.Object} thisArg
					     * @chainable
					     */
					
					    /**
					     * Retrieves object's {@link fabric.Object#flipY|flipY} value
					     * @method getFlipY
					     * @memberOf fabric.Object.prototype
					     * @return {Boolean} flipY value
					     */
					
					    /**
					     * Sets object's {@link fabric.Object#flipY|flipY} value
					     * @method setFlipY
					     * @memberOf fabric.Object.prototype
					     * @param {Boolean} value flipY value
					     * @return {fabric.Object} thisArg
					     * @chainable
					     */
					
					    /**
					     * Type of an object (rect, circle, path, etc.).
					     * Note that this property is meant to be read-only and not meant to be modified.
					     * If you modify, certain parts of Fabric (such as JSON loading) won't work correctly.
					     * @type String
					     * @default
					     */
					    type:                     'object',
					
					    /**
					     * Horizontal origin of transformation of an object (one of "left", "right", "center")
					     * See http://jsfiddle.net/1ow02gea/40/ on how originX/originY affect objects in groups
					     * @type String
					     * @default
					     */
					    originX:                  'left',
					
					    /**
					     * Vertical origin of transformation of an object (one of "top", "bottom", "center")
					     * See http://jsfiddle.net/1ow02gea/40/ on how originX/originY affect objects in groups
					     * @type String
					     * @default
					     */
					    originY:                  'top',
					
					    /**
					     * Top position of an object. Note that by default it's relative to object center. You can change this by setting originY={top/center/bottom}
					     * @type Number
					     * @default
					     */
					    top:                      0,
					
					    /**
					     * Left position of an object. Note that by default it's relative to object center. You can change this by setting originX={left/center/right}
					     * @type Number
					     * @default
					     */
					    left:                     0,
					
					    /**
					     * Object width
					     * @type Number
					     * @default
					     */
					    width:                    0,
					
					    /**
					     * Object height
					     * @type Number
					     * @default
					     */
					    height:                   0,
					
					    /**
					     * Object scale factor (horizontal)
					     * @type Number
					     * @default
					     */
					    scaleX:                   1,
					
					    /**
					     * Object scale factor (vertical)
					     * @type Number
					     * @default
					     */
					    scaleY:                   1,
					
					    /**
					     * When true, an object is rendered as flipped horizontally
					     * @type Boolean
					     * @default
					     */
					    flipX:                    false,
					
					    /**
					     * When true, an object is rendered as flipped vertically
					     * @type Boolean
					     * @default
					     */
					    flipY:                    false,
					
					    /**
					     * Opacity of an object
					     * @type Number
					     * @default
					     */
					    opacity:                  1,
					
					    /**
					     * Angle of rotation of an object (in degrees)
					     * @type Number
					     * @default
					     */
					    angle:                    0,
					
					    /**
					     * Size of object's controlling corners (in pixels)
					     * @type Number
					     * @default
					     */
					    cornerSize:               12,
					
					    /**
					     * When true, object's controlling corners are rendered as transparent inside (i.e. stroke instead of fill)
					     * @type Boolean
					     * @default
					     */
					    transparentCorners:       true,
					
					    /**
					     * Default cursor value used when hovering over this object on canvas
					     * @type String
					     * @default
					     */
					    hoverCursor:              null,
					
					    /**
					     * Padding between object and its controlling borders (in pixels)
					     * @type Number
					     * @default
					     */
					    padding:                  0,
					
					    /**
					     * Color of controlling borders of an object (when it's active)
					     * @type String
					     * @default
					     */
					    borderColor:              'rgba(102,153,255,0.75)',
					
					    /**
					     * Color of controlling corners of an object (when it's active)
					     * @type String
					     * @default
					     */
					    cornerColor:              'rgba(102,153,255,0.5)',
					
					    /**
					     * When true, this object will use center point as the origin of transformation
					     * when being scaled via the controls.
					     * <b>Backwards incompatibility note:</b> This property replaces "centerTransform" (Boolean).
					     * @since 1.3.4
					     * @type Boolean
					     * @default
					     */
					    centeredScaling:          false,
					
					    /**
					     * When true, this object will use center point as the origin of transformation
					     * when being rotated via the controls.
					     * <b>Backwards incompatibility note:</b> This property replaces "centerTransform" (Boolean).
					     * @since 1.3.4
					     * @type Boolean
					     * @default
					     */
					    centeredRotation:         true,
					
					    /**
					     * Color of object's fill
					     * @type String
					     * @default
					     */
					    fill:                     'rgb(0,0,0)',
					
					    /**
					     * Fill rule used to fill an object
					     * accepted values are nonzero, evenodd
					     * <b>Backwards incompatibility note:</b> This property was used for setting globalCompositeOperation until v1.4.12 (use `fabric.Object#globalCompositeOperation` instead)
					     * @type String
					     * @default
					     */
					    fillRule:                 'nonzero',
					
					    /**
					     * Composite rule used for canvas globalCompositeOperation
					     * @type String
					     * @default
					     */
					    globalCompositeOperation: 'source-over',
					
					    /**
					     * Background color of an object. Only works with text objects at the moment.
					     * @type String
					     * @default
					     */
					    backgroundColor:          '',
					
					    /**
					     * When defined, an object is rendered via stroke and this property specifies its color
					     * @type String
					     * @default
					     */
					    stroke:                   null,
					
					    /**
					     * Width of a stroke used to render this object
					     * @type Number
					     * @default
					     */
					    strokeWidth:              1,
					
					    /**
					     * Array specifying dash pattern of an object's stroke (stroke must be defined)
					     * @type Array
					     */
					    strokeDashArray:          null,
					
					    /**
					     * Line endings style of an object's stroke (one of "butt", "round", "square")
					     * @type String
					     * @default
					     */
					    strokeLineCap:            'butt',
					
					    /**
					     * Corner style of an object's stroke (one of "bevil", "round", "miter")
					     * @type String
					     * @default
					     */
					    strokeLineJoin:           'miter',
					
					    /**
					     * Maximum miter length (used for strokeLineJoin = "miter") of an object's stroke
					     * @type Number
					     * @default
					     */
					    strokeMiterLimit:         10,
					
					    /**
					     * Shadow object representing shadow of this shape
					     * @type fabric.Shadow
					     * @default
					     */
					    shadow:                   null,
					
					    /**
					     * Opacity of object's controlling borders when object is active and moving
					     * @type Number
					     * @default
					     */
					    borderOpacityWhenMoving:  0.4,
					
					    /**
					     * Scale factor of object's controlling borders
					     * @type Number
					     * @default
					     */
					    borderScaleFactor:        1,
					
					    /**
					     * Transform matrix (similar to SVG's transform matrix)
					     * @type Array
					     */
					    transformMatrix:          null,
					
					    /**
					     * Minimum allowed scale value of an object
					     * @type Number
					     * @default
					     */
					    minScaleLimit:            0.01,
					
					    /**
					     * When set to `false`, an object can not be selected for modification (using either point-click-based or group-based selection).
					     * But events still fire on it.
					     * @type Boolean
					     * @default
					     */
					    selectable:               true,
					
					    /**
					     * When set to `false`, an object can not be a target of events. All events propagate through it. Introduced in v1.3.4
					     * @type Boolean
					     * @default
					     */
					    evented:                  true,
					
					    /**
					     * When set to `false`, an object is not rendered on canvas
					     * @type Boolean
					     * @default
					     */
					    visible:                  true,
					
					    /**
					     * When set to `false`, object's controls are not displayed and can not be used to manipulate object
					     * @type Boolean
					     * @default
					     */
					    hasControls:              true,
					
					    /**
					     * When set to `false`, object's controlling borders are not rendered
					     * @type Boolean
					     * @default
					     */
					    hasBorders:               true,
					
					    /**
					     * When set to `false`, object's controlling rotating point will not be visible or selectable
					     * @type Boolean
					     * @default
					     */
					    hasRotatingPoint:         true,
					
					    /**
					     * Offset for object's controlling rotating point (when enabled via `hasRotatingPoint`)
					     * @type Number
					     * @default
					     */
					    rotatingPointOffset:      40,
					
					    /**
					     * When set to `true`, objects are "found" on canvas on per-pixel basis rather than according to bounding box
					     * @type Boolean
					     * @default
					     */
					    perPixelTargetFind:       false,
					
					    /**
					     * When `false`, default object's values are not included in its serialization
					     * @type Boolean
					     * @default
					     */
					    includeDefaultValues:     true,
					
					    /**
					     * Function that determines clipping of an object (context is passed as a first argument)
					     * Note that context origin is at the object's center point (not left/top corner)
					     * @type Function
					     */
					    clipTo:                   null,
					
					    /**
					     * When `true`, object horizontal movement is locked
					     * @type Boolean
					     * @default
					     */
					    lockMovementX:            false,
					
					    /**
					     * When `true`, object vertical movement is locked
					     * @type Boolean
					     * @default
					     */
					    lockMovementY:            false,
					
					    /**
					     * When `true`, object rotation is locked
					     * @type Boolean
					     * @default
					     */
					    lockRotation:             false,
					
					    /**
					     * When `true`, object horizontal scaling is locked
					     * @type Boolean
					     * @default
					     */
					    lockScalingX:             false,
					
					    /**
					     * When `true`, object vertical scaling is locked
					     * @type Boolean
					     * @default
					     */
					    lockScalingY:             false,
					
					    /**
					     * When `true`, object non-uniform scaling is locked
					     * @type Boolean
					     * @default
					     */
					    lockUniScaling:           false,
					
					    /**
					     * When `true`, object cannot be flipped by scaling into negative values
					     * @type Boolean
					     * @default
					     */
					
					    lockScalingFlip:          false,
					    /**
					     * List of properties to consider when checking if state
					     * of an object is changed (fabric.Object#hasStateChanged)
					     * as well as for history (undo/redo) purposes
					     * @type Array
					     */
					    stateProperties:  (
					      'top left width height scaleX scaleY flipX flipY originX originY transformMatrix ' +
					      'stroke strokeWidth strokeDashArray strokeLineCap strokeLineJoin strokeMiterLimit ' +
					      'angle opacity fill fillRule globalCompositeOperation shadow clipTo visible backgroundColor'
					    ).split(' '),
					
					    /**
					     * Constructor
					     * @param {Object} [options] Options object
					     */
					    initialize: function(options) {
					      if (options) {
					        this.setOptions(options);
					      }
					    },
					
					    /**
					     * @private
					     * @param {Object} [options] Options object
					     */
					    _initGradient: function(options) {
					      if (options.fill && options.fill.colorStops && !(options.fill instanceof fabric.Gradient)) {
					        this.set('fill', new fabric.Gradient(options.fill));
					      }
					    },
					
					    /**
					     * @private
					     * @param {Object} [options] Options object
					     */
					    _initPattern: function(options) {
					      if (options.fill && options.fill.source && !(options.fill instanceof fabric.Pattern)) {
					        this.set('fill', new fabric.Pattern(options.fill));
					      }
					      if (options.stroke && options.stroke.source && !(options.stroke instanceof fabric.Pattern)) {
					        this.set('stroke', new fabric.Pattern(options.stroke));
					      }
					    },
					
					    /**
					     * @private
					     * @param {Object} [options] Options object
					     */
					    _initClipping: function(options) {
					      if (!options.clipTo || typeof options.clipTo !== 'string') {
					        return;
					      }
					
					      var functionBody = fabric.util.getFunctionBody(options.clipTo);
					      if (typeof functionBody !== 'undefined') {
					        this.clipTo = new Function('ctx', functionBody);
					      }
					    },
					
					    /**
					     * Sets object's properties from options
					     * @param {Object} [options] Options object
					     */
					    setOptions: function(options) {
					      for (var prop in options) {
					        this.set(prop, options[prop]);
					      }
					      this._initGradient(options);
					      this._initPattern(options);
					      this._initClipping(options);
					    },
					
					    /**
					     * Transforms context when rendering an object
					     * @param {CanvasRenderingContext2D} ctx Context
					     * @param {Boolean} fromLeft When true, context is transformed to object's top/left corner. This is used when rendering text on Node
					     */
					    transform: function(ctx, fromLeft) {
					      var center = fromLeft ? this._getLeftTopCoords() : this.getCenterPoint();
					      ctx.translate(center.x, center.y);
					      ctx.rotate(degreesToRadians(this.angle));
					      ctx.scale(
					        this.scaleX * (this.flipX ? -1 : 1),
					        this.scaleY * (this.flipY ? -1 : 1)
					      );
					    },
					
					    /**
					     * Returns an object representation of an instance
					     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output
					     * @return {Object} Object representation of an instance
					     */
					    toObject: function(propertiesToInclude) {
					      var NUM_FRACTION_DIGITS = fabric.Object.NUM_FRACTION_DIGITS,
					
					          object = {
					            type:                     this.type,
					            originX:                  this.originX,
					            originY:                  this.originY,
					            left:                     toFixed(this.left, NUM_FRACTION_DIGITS),
					            top:                      toFixed(this.top, NUM_FRACTION_DIGITS),
					            width:                    toFixed(this.width, NUM_FRACTION_DIGITS),
					            height:                   toFixed(this.height, NUM_FRACTION_DIGITS),
					            fill:                     (this.fill && this.fill.toObject) ? this.fill.toObject() : this.fill,
					            stroke:                   (this.stroke && this.stroke.toObject) ? this.stroke.toObject() : this.stroke,
					            strokeWidth:              toFixed(this.strokeWidth, NUM_FRACTION_DIGITS),
					            strokeDashArray:          this.strokeDashArray,
					            strokeLineCap:            this.strokeLineCap,
					            strokeLineJoin:           this.strokeLineJoin,
					            strokeMiterLimit:         toFixed(this.strokeMiterLimit, NUM_FRACTION_DIGITS),
					            scaleX:                   toFixed(this.scaleX, NUM_FRACTION_DIGITS),
					            scaleY:                   toFixed(this.scaleY, NUM_FRACTION_DIGITS),
					            angle:                    toFixed(this.getAngle(), NUM_FRACTION_DIGITS),
					            flipX:                    this.flipX,
					            flipY:                    this.flipY,
					            opacity:                  toFixed(this.opacity, NUM_FRACTION_DIGITS),
					            shadow:                   (this.shadow && this.shadow.toObject) ? this.shadow.toObject() : this.shadow,
					            visible:                  this.visible,
					            clipTo:                   this.clipTo && String(this.clipTo),
					            backgroundColor:          this.backgroundColor,
					            fillRule:                 this.fillRule,
					            globalCompositeOperation: this.globalCompositeOperation
					          };
					
					      if (!this.includeDefaultValues) {
					        object = this._removeDefaultValues(object);
					      }
					
					      fabric.util.populateWithProperties(this, object, propertiesToInclude);
					
					      return object;
					    },
					
					    /**
					     * Returns (dataless) object representation of an instance
					     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output
					     * @return {Object} Object representation of an instance
					     */
					    toDatalessObject: function(propertiesToInclude) {
					      // will be overwritten by subclasses
					      return this.toObject(propertiesToInclude);
					    },
					
					    /**
					     * @private
					     * @param {Object} object
					     */
					    _removeDefaultValues: function(object) {
					      var prototype = fabric.util.getKlass(object.type).prototype,
					          stateProperties = prototype.stateProperties;
					
					      stateProperties.forEach(function(prop) {
					        if (object[prop] === prototype[prop]) {
					          delete object[prop];
					        }
					      });
					
					      return object;
					    },
					
					    /**
					     * Returns a string representation of an instance
					     * @return {String}
					     */
					    toString: function() {
					      return '#<fabric.' + capitalize(this.type) + '>';
					    },
					
					    /**
					     * Basic getter
					     * @param {String} property Property name
					     * @return {Any} value of a property
					     */
					    get: function(property) {
					      return this[property];
					    },
					
					    /**
					     * @private
					     */
					    _setObject: function(obj) {
					      for (var prop in obj) {
					        this._set(prop, obj[prop]);
					      }
					    },
					
					    /**
					     * Sets property to a given value. When changing position/dimension -related properties (left, top, scale, angle, etc.) `set` does not update position of object's borders/controls. If you need to update those, call `setCoords()`.
					     * @param {String|Object} key Property name or object (if object, iterate over the object properties)
					     * @param {Object|Function} value Property value (if function, the value is passed into it and its return value is used as a new one)
					     * @return {fabric.Object} thisArg
					     * @chainable
					     */
					    set: function(key, value) {
					      if (typeof key === 'object') {
					        this._setObject(key);
					      }
					      else {
					        if (typeof value === 'function' && key !== 'clipTo') {
					          this._set(key, value(this.get(key)));
					        }
					        else {
					          this._set(key, value);
					        }
					      }
					      return this;
					    },
					
					    /**
					     * @private
					     * @param {String} key
					     * @param {Any} value
					     * @return {fabric.Object} thisArg
					     */
					    _set: function(key, value) {
					      var shouldConstrainValue = (key === 'scaleX' || key === 'scaleY');
					
					      if (shouldConstrainValue) {
					        value = this._constrainScale(value);
					      }
					      if (key === 'scaleX' && value < 0) {
					        this.flipX = !this.flipX;
					        value *= -1;
					      }
					      else if (key === 'scaleY' && value < 0) {
					        this.flipY = !this.flipY;
					        value *= -1;
					      }
					      else if (key === 'width' || key === 'height') {
					        this.minScaleLimit = toFixed(Math.min(0.1, 1/Math.max(this.width, this.height)), 2);
					      }
					      else if (key === 'shadow' && value && !(value instanceof fabric.Shadow)) {
					        value = new fabric.Shadow(value);
					      }
					
					      this[key] = value;
					
					      return this;
					    },
					
					    /**
					     * Toggles specified property from `true` to `false` or from `false` to `true`
					     * @param {String} property Property to toggle
					     * @return {fabric.Object} thisArg
					     * @chainable
					     */
					    toggle: function(property) {
					      var value = this.get(property);
					      if (typeof value === 'boolean') {
					        this.set(property, !value);
					      }
					      return this;
					    },
					
					    /**
					     * Sets sourcePath of an object
					     * @param {String} value Value to set sourcePath to
					     * @return {fabric.Object} thisArg
					     * @chainable
					     */
					    setSourcePath: function(value) {
					      this.sourcePath = value;
					      return this;
					    },
					
					    /**
					     * Retrieves viewportTransform from Object's canvas if possible
					     * @method getViewportTransform
					     * @memberOf fabric.Object.prototype
					     * @return {Boolean} flipY value // TODO
					     */
					    getViewportTransform: function() {
					      if (this.canvas && this.canvas.viewportTransform) {
					        return this.canvas.viewportTransform;
					      }
					      return [1, 0, 0, 1, 0, 0];
					    },
					
					    /**
					     * Renders an object on a specified context
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     * @param {Boolean} [noTransform] When true, context is not transformed
					     */
					    render: function(ctx, noTransform) {
					      // do not render if width/height are zeros or object is not visible
					      if ((this.width === 0 && this.height === 0) || !this.visible) {
					        return;
					      }
					
					      ctx.save();
					
					      //setup fill rule for current object
					      this._setupCompositeOperation(ctx);
					      if (!noTransform) {
					        this.transform(ctx);
					      }
					      this._setStrokeStyles(ctx);
					      this._setFillStyles(ctx);
					      if (this.transformMatrix) {
					        ctx.transform.apply(ctx, this.transformMatrix);
					      }
					      this._setOpacity(ctx);
					      this._setShadow(ctx);
					      this.clipTo && fabric.util.clipContext(this, ctx);
					      this._render(ctx, noTransform);
					      this.clipTo && ctx.restore();
					      this._removeShadow(ctx);
					      this._restoreCompositeOperation(ctx);
					
					      ctx.restore();
					    },
					
					    /* @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     */
					    _setOpacity: function(ctx) {
					      if (this.group) {
					        this.group._setOpacity(ctx);
					      }
					      ctx.globalAlpha *= this.opacity;
					    },
					
					    _setStrokeStyles: function(ctx) {
					      if (this.stroke) {
					        ctx.lineWidth = this.strokeWidth;
					        ctx.lineCap = this.strokeLineCap;
					        ctx.lineJoin = this.strokeLineJoin;
					        ctx.miterLimit = this.strokeMiterLimit;
					        ctx.strokeStyle = this.stroke.toLive
					          ? this.stroke.toLive(ctx, this)
					          : this.stroke;
					      }
					    },
					
					    _setFillStyles: function(ctx) {
					      if (this.fill) {
					        ctx.fillStyle = this.fill.toLive
					          ? this.fill.toLive(ctx, this)
					          : this.fill;
					      }
					    },
					
					    /**
					     * Renders controls and borders for the object
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     * @param {Boolean} [noTransform] When true, context is not transformed
					     */
					    _renderControls: function(ctx, noTransform) {
					      if (!this.active || noTransform) {
					        return;
					      }
					      var vpt = this.getViewportTransform();
					      ctx.save();
					      var center;
					      if (this.group) {
					        center = fabric.util.transformPoint(this.group.getCenterPoint(), vpt);
					        ctx.translate(center.x, center.y);
					        ctx.rotate(degreesToRadians(this.group.angle));
					      }
					      center = fabric.util.transformPoint(this.getCenterPoint(), vpt, null != this.group);
					      if (this.group) {
					        center.x *= this.group.scaleX;
					        center.y *= this.group.scaleY;
					      }
					      ctx.translate(center.x, center.y);
					      ctx.rotate(degreesToRadians(this.angle));
					      this.drawBorders(ctx);
					      this.drawControls(ctx);
					      ctx.restore();
					    },
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     */
					    _setShadow: function(ctx) {
					      if (!this.shadow) {
					        return;
					      }
					
					      var multX = (this.canvas && this.canvas.viewportTransform[0]) || 1,
					          multY = (this.canvas && this.canvas.viewportTransform[3]) || 1;
					
					      ctx.shadowColor = this.shadow.color;
					      ctx.shadowBlur = this.shadow.blur * (multX + multY) * (this.scaleX + this.scaleY) / 4;
					      ctx.shadowOffsetX = this.shadow.offsetX * multX * this.scaleX;
					      ctx.shadowOffsetY = this.shadow.offsetY * multY * this.scaleY;
					    },
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     */
					    _removeShadow: function(ctx) {
					      if (!this.shadow) {
					        return;
					      }
					
					      ctx.shadowColor = '';
					      ctx.shadowBlur = ctx.shadowOffsetX = ctx.shadowOffsetY = 0;
					    },
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     */
					    _renderFill: function(ctx) {
					      if (!this.fill) {
					        return;
					      }
					
					      ctx.save();
					      if (this.fill.gradientTransform) {
					        var g = this.fill.gradientTransform;
					        ctx.transform.apply(ctx, g);
					      }
					      if (this.fill.toLive) {
					        ctx.translate(
					          -this.width / 2 + this.fill.offsetX || 0,
					          -this.height / 2 + this.fill.offsetY || 0);
					      }
					      if (this.fillRule === 'evenodd') {
					        ctx.fill('evenodd');
					      }
					      else {
					        ctx.fill();
					      }
					      ctx.restore();
					      if (this.shadow && !this.shadow.affectStroke) {
					        this._removeShadow(ctx);
					      }
					    },
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     */
					    _renderStroke: function(ctx) {
					      if (!this.stroke || this.strokeWidth === 0) {
					        return;
					      }
					
					      ctx.save();
					      if (this.strokeDashArray) {
					        // Spec requires the concatenation of two copies the dash list when the number of elements is odd
					        if (1 & this.strokeDashArray.length) {
					          this.strokeDashArray.push.apply(this.strokeDashArray, this.strokeDashArray);
					        }
					        if (supportsLineDash) {
					          ctx.setLineDash(this.strokeDashArray);
					          this._stroke && this._stroke(ctx);
					        }
					        else {
					          this._renderDashedStroke && this._renderDashedStroke(ctx);
					        }
					        ctx.stroke();
					      }
					      else {
					        if (this.stroke.gradientTransform) {
					          var g = this.stroke.gradientTransform;
					          ctx.transform.apply(ctx, g);
					        }
					        this._stroke ? this._stroke(ctx) : ctx.stroke();
					      }
					      this._removeShadow(ctx);
					      ctx.restore();
					    },
					
					    /**
					     * Clones an instance
					     * @param {Function} callback Callback is invoked with a clone as a first argument
					     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output
					     * @return {fabric.Object} clone of an instance
					     */
					    clone: function(callback, propertiesToInclude) {
					      if (this.constructor.fromObject) {
					        return this.constructor.fromObject(this.toObject(propertiesToInclude), callback);
					      }
					      return new fabric.Object(this.toObject(propertiesToInclude));
					    },
					
					    /**
					     * Creates an instance of fabric.Image out of an object
					     * @param {Function} callback callback, invoked with an instance as a first argument
					     * @return {fabric.Object} thisArg
					     */
					    cloneAsImage: function(callback) {
					      var dataUrl = this.toDataURL();
					      fabric.util.loadImage(dataUrl, function(img) {
					        if (callback) {
					          callback(new fabric.Image(img));
					        }
					      });
					      return this;
					    },
					
					    /**
					     * Converts an object into a data-url-like string
					     * @param {Object} options Options object
					     * @param {String} [options.format=png] The format of the output image. Either "jpeg" or "png"
					     * @param {Number} [options.quality=1] Quality level (0..1). Only used for jpeg.
					     * @param {Number} [options.multiplier=1] Multiplier to scale by
					     * @param {Number} [options.left] Cropping left offset. Introduced in v1.2.14
					     * @param {Number} [options.top] Cropping top offset. Introduced in v1.2.14
					     * @param {Number} [options.width] Cropping width. Introduced in v1.2.14
					     * @param {Number} [options.height] Cropping height. Introduced in v1.2.14
					     * @return {String} Returns a data: URL containing a representation of the object in the format specified by options.format
					     */
					    toDataURL: function(options) {
					      options || (options = { });
					
					      var el = fabric.util.createCanvasElement(),
					          boundingRect = this.getBoundingRect();
					
					      el.width = boundingRect.width;
					      el.height = boundingRect.height;
					
					      fabric.util.wrapElement(el, 'div');
					      var canvas = new fabric.StaticCanvas(el);
					
					      // to avoid common confusion https://github.com/kangax/fabric.js/issues/806
					      if (options.format === 'jpg') {
					        options.format = 'jpeg';
					      }
					
					      if (options.format === 'jpeg') {
					        canvas.backgroundColor = '#fff';
					      }
					
					      var origParams = {
					        active: this.get('active'),
					        left: this.getLeft(),
					        top: this.getTop()
					      };
					
					      this.set('active', false);
					      this.setPositionByOrigin(new fabric.Point(el.width / 2, el.height / 2), 'center', 'center');
					
					      var originalCanvas = this.canvas;
					      canvas.add(this);
					      var data = canvas.toDataURL(options);
					
					      this.set(origParams).setCoords();
					      this.canvas = originalCanvas;
					
					      canvas.dispose();
					      canvas = null;
					
					      return data;
					    },
					
					    /**
					     * Returns true if specified type is identical to the type of an instance
					     * @param {String} type Type to check against
					     * @return {Boolean}
					     */
					    isType: function(type) {
					      return this.type === type;
					    },
					
					    /**
					     * Returns complexity of an instance
					     * @return {Number} complexity of this instance
					     */
					    complexity: function() {
					      return 0;
					    },
					
					    /**
					     * Returns a JSON representation of an instance
					     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output
					     * @return {Object} JSON
					     */
					    toJSON: function(propertiesToInclude) {
					      // delegate, not alias
					      return this.toObject(propertiesToInclude);
					    },
					
					    /**
					     * Sets gradient (fill or stroke) of an object
					     * <b>Backwards incompatibility note:</b> This method was named "setGradientFill" until v1.1.0
					     * @param {String} property Property name 'stroke' or 'fill'
					     * @param {Object} [options] Options object
					     * @param {String} [options.type] Type of gradient 'radial' or 'linear'
					     * @param {Number} [options.x1=0] x-coordinate of start point
					     * @param {Number} [options.y1=0] y-coordinate of start point
					     * @param {Number} [options.x2=0] x-coordinate of end point
					     * @param {Number} [options.y2=0] y-coordinate of end point
					     * @param {Number} [options.r1=0] Radius of start point (only for radial gradients)
					     * @param {Number} [options.r2=0] Radius of end point (only for radial gradients)
					     * @param {Object} [options.colorStops] Color stops object eg. {0: 'ff0000', 1: '000000'}
					     * @return {fabric.Object} thisArg
					     * @chainable
					     * @see {@link http://jsfiddle.net/fabricjs/58y8b/|jsFiddle demo}
					     * @example <caption>Set linear gradient</caption>
					     * object.setGradient('fill', {
					     *   type: 'linear',
					     *   x1: -object.width / 2,
					     *   y1: 0,
					     *   x2: object.width / 2,
					     *   y2: 0,
					     *   colorStops: {
					     *     0: 'red',
					     *     0.5: '#005555',
					     *     1: 'rgba(0,0,255,0.5)'
					     *   }
					     * });
					     * canvas.renderAll();
					     * @example <caption>Set radial gradient</caption>
					     * object.setGradient('fill', {
					     *   type: 'radial',
					     *   x1: 0,
					     *   y1: 0,
					     *   x2: 0,
					     *   y2: 0,
					     *   r1: object.width / 2,
					     *   r2: 10,
					     *   colorStops: {
					     *     0: 'red',
					     *     0.5: '#005555',
					     *     1: 'rgba(0,0,255,0.5)'
					     *   }
					     * });
					     * canvas.renderAll();
					     */
					    setGradient: function(property, options) {
					      options || (options = { });
					
					      var gradient = { colorStops: [] };
					
					      gradient.type = options.type || (options.r1 || options.r2 ? 'radial' : 'linear');
					      gradient.coords = {
					        x1: options.x1,
					        y1: options.y1,
					        x2: options.x2,
					        y2: options.y2
					      };
					
					      if (options.r1 || options.r2) {
					        gradient.coords.r1 = options.r1;
					        gradient.coords.r2 = options.r2;
					      }
					
					      for (var position in options.colorStops) {
					        var color = new fabric.Color(options.colorStops[position]);
					        gradient.colorStops.push({
					          offset: position,
					          color: color.toRgb(),
					          opacity: color.getAlpha()
					        });
					      }
					
					      return this.set(property, fabric.Gradient.forObject(this, gradient));
					    },
					
					    /**
					     * Sets pattern fill of an object
					     * @param {Object} options Options object
					     * @param {(String|HTMLImageElement)} options.source Pattern source
					     * @param {String} [options.repeat=repeat] Repeat property of a pattern (one of repeat, repeat-x, repeat-y or no-repeat)
					     * @param {Number} [options.offsetX=0] Pattern horizontal offset from object's left/top corner
					     * @param {Number} [options.offsetY=0] Pattern vertical offset from object's left/top corner
					     * @return {fabric.Object} thisArg
					     * @chainable
					     * @see {@link http://jsfiddle.net/fabricjs/QT3pa/|jsFiddle demo}
					     * @example <caption>Set pattern</caption>
					     * fabric.util.loadImage('http://fabricjs.com/assets/escheresque_ste.png', function(img) {
					     *   object.setPatternFill({
					     *     source: img,
					     *     repeat: 'repeat'
					     *   });
					     *   canvas.renderAll();
					     * });
					     */
					    setPatternFill: function(options) {
					      return this.set('fill', new fabric.Pattern(options));
					    },
					
					    /**
					     * Sets {@link fabric.Object#shadow|shadow} of an object
					     * @param {Object|String} [options] Options object or string (e.g. "2px 2px 10px rgba(0,0,0,0.2)")
					     * @param {String} [options.color=rgb(0,0,0)] Shadow color
					     * @param {Number} [options.blur=0] Shadow blur
					     * @param {Number} [options.offsetX=0] Shadow horizontal offset
					     * @param {Number} [options.offsetY=0] Shadow vertical offset
					     * @return {fabric.Object} thisArg
					     * @chainable
					     * @see {@link http://jsfiddle.net/fabricjs/7gvJG/|jsFiddle demo}
					     * @example <caption>Set shadow with string notation</caption>
					     * object.setShadow('2px 2px 10px rgba(0,0,0,0.2)');
					     * canvas.renderAll();
					     * @example <caption>Set shadow with object notation</caption>
					     * object.setShadow({
					     *   color: 'red',
					     *   blur: 10,
					     *   offsetX: 20,
					     *   offsetY: 20
					     * });
					     * canvas.renderAll();
					     */
					    setShadow: function(options) {
					      return this.set('shadow', options ? new fabric.Shadow(options) : null);
					    },
					
					    /**
					     * Sets "color" of an instance (alias of `set('fill', &hellip;)`)
					     * @param {String} color Color value
					     * @return {fabric.Object} thisArg
					     * @chainable
					     */
					    setColor: function(color) {
					      this.set('fill', color);
					      return this;
					    },
					
					    /**
					     * Sets "angle" of an instance
					     * @param {Number} angle Angle value (in degrees)
					     * @return {fabric.Object} thisArg
					     * @chainable
					     */
					    setAngle: function(angle) {
					      var shouldCenterOrigin = (this.originX !== 'center' || this.originY !== 'center') && this.centeredRotation;
					
					      if (shouldCenterOrigin) {
					        this._setOriginToCenter();
					      }
					
					      this.set('angle', angle);
					
					      if (shouldCenterOrigin) {
					        this._resetOrigin();
					      }
					
					      return this;
					    },
					
					    /**
					     * Centers object horizontally on canvas to which it was added last.
					     * You might need to call `setCoords` on an object after centering, to update controls area.
					     * @return {fabric.Object} thisArg
					     * @chainable
					     */
					    centerH: function () {
					      this.canvas.centerObjectH(this);
					      return this;
					    },
					
					    /**
					     * Centers object vertically on canvas to which it was added last.
					     * You might need to call `setCoords` on an object after centering, to update controls area.
					     * @return {fabric.Object} thisArg
					     * @chainable
					     */
					    centerV: function () {
					      this.canvas.centerObjectV(this);
					      return this;
					    },
					
					    /**
					     * Centers object vertically and horizontally on canvas to which is was added last
					     * You might need to call `setCoords` on an object after centering, to update controls area.
					     * @return {fabric.Object} thisArg
					     * @chainable
					     */
					    center: function () {
					      this.canvas.centerObject(this);
					      return this;
					    },
					
					    /**
					     * Removes object from canvas to which it was added last
					     * @return {fabric.Object} thisArg
					     * @chainable
					     */
					    remove: function() {
					      this.canvas.remove(this);
					      return this;
					    },
					
					    /**
					     * Returns coordinates of a pointer relative to an object
					     * @param {Event} e Event to operate upon
					     * @param {Object} [pointer] Pointer to operate upon (instead of event)
					     * @return {Object} Coordinates of a pointer (x, y)
					     */
					    getLocalPointer: function(e, pointer) {
					      pointer = pointer || this.canvas.getPointer(e);
					      var objectLeftTop = this.translateToOriginPoint(this.getCenterPoint(), 'left', 'top');
					      return {
					        x: pointer.x - objectLeftTop.x,
					        y: pointer.y - objectLeftTop.y
					      };
					    },
					
					    /**
					     * Sets canvas globalCompositeOperation for specific object
					     * custom composition operation for the particular object can be specifed using globalCompositeOperation property
					     * @param {CanvasRenderingContext2D} ctx Rendering canvas context
					     */
					    _setupCompositeOperation: function (ctx) {
					      if (this.globalCompositeOperation) {
					        this._prevGlobalCompositeOperation = ctx.globalCompositeOperation;
					        ctx.globalCompositeOperation = this.globalCompositeOperation;
					      }
					    },
					
					    /**
					     * Restores previously saved canvas globalCompositeOperation after obeject rendering
					     * @param {CanvasRenderingContext2D} ctx Rendering canvas context
					     */
					    _restoreCompositeOperation: function (ctx) {
					      if (this.globalCompositeOperation && this._prevGlobalCompositeOperation) {
					        ctx.globalCompositeOperation = this._prevGlobalCompositeOperation;
					      }
					    }
					  });
					
					  fabric.util.createAccessors(fabric.Object);
					
					  /**
					   * Alias for {@link fabric.Object.prototype.setAngle}
					   * @alias rotate -> setAngle
					   * @memberof fabric.Object
					   */
					  fabric.Object.prototype.rotate = fabric.Object.prototype.setAngle;
					
					  extend(fabric.Object.prototype, fabric.Observable);
					
					  /**
					   * Defines the number of fraction digits to use when serializing object values.
					   * You can use it to increase/decrease precision of such values like left, top, scaleX, scaleY, etc.
					   * @static
					   * @memberof fabric.Object
					   * @constant
					   * @type Number
					   */
					  fabric.Object.NUM_FRACTION_DIGITS = 2;
					
					  /**
					   * Unique id used internally when creating SVG elements
					   * @static
					   * @memberof fabric.Object
					   * @type Number
					   */
					  fabric.Object.__uid = 0;
					
					})(typeof exports !== 'undefined' ? exports : this);
					(function() {
					
					  var degreesToRadians = fabric.util.degreesToRadians;
					
					  fabric.util.object.extend(fabric.Object.prototype, /** @lends fabric.Object.prototype */ {
					
					    /**
					     * Translates the coordinates from origin to center coordinates (based on the object's dimensions)
					     * @param {fabric.Point} point The point which corresponds to the originX and originY params
					     * @param {String} originX Horizontal origin: 'left', 'center' or 'right'
					     * @param {String} originY Vertical origin: 'top', 'center' or 'bottom'
					     * @return {fabric.Point}
					     */
					    translateToCenterPoint: function(point, originX, originY) {
					      var cx = point.x,
					          cy = point.y,
					          strokeWidth = this.stroke ? this.strokeWidth : 0;
					
					      if (originX === 'left') {
					        cx = point.x + (this.getWidth() + strokeWidth * this.scaleX) / 2;
					      }
					      else if (originX === 'right') {
					        cx = point.x - (this.getWidth() + strokeWidth * this.scaleX) / 2;
					      }
					
					      if (originY === 'top') {
					        cy = point.y + (this.getHeight() + strokeWidth * this.scaleY) / 2;
					      }
					      else if (originY === 'bottom') {
					        cy = point.y - (this.getHeight() + strokeWidth * this.scaleY) / 2;
					      }
					
					      // Apply the reverse rotation to the point (it's already scaled properly)
					      return fabric.util.rotatePoint(new fabric.Point(cx, cy), point, degreesToRadians(this.angle));
					    },
					
					    /**
					     * Translates the coordinates from center to origin coordinates (based on the object's dimensions)
					     * @param {fabric.Point} center The point which corresponds to center of the object
					     * @param {String} originX Horizontal origin: 'left', 'center' or 'right'
					     * @param {String} originY Vertical origin: 'top', 'center' or 'bottom'
					     * @return {fabric.Point}
					     */
					    translateToOriginPoint: function(center, originX, originY) {
					      var x = center.x,
					          y = center.y,
					          strokeWidth = this.stroke ? this.strokeWidth : 0;
					
					      // Get the point coordinates
					      if (originX === 'left') {
					        x = center.x - (this.getWidth() + strokeWidth * this.scaleX) / 2;
					      }
					      else if (originX === 'right') {
					        x = center.x + (this.getWidth() + strokeWidth * this.scaleX) / 2;
					      }
					      if (originY === 'top') {
					        y = center.y - (this.getHeight() + strokeWidth * this.scaleY) / 2;
					      }
					      else if (originY === 'bottom') {
					        y = center.y + (this.getHeight() + strokeWidth * this.scaleY) / 2;
					      }
					
					      // Apply the rotation to the point (it's already scaled properly)
					      return fabric.util.rotatePoint(new fabric.Point(x, y), center, degreesToRadians(this.angle));
					    },
					
					    /**
					     * Returns the real center coordinates of the object
					     * @return {fabric.Point}
					     */
					    getCenterPoint: function() {
					      var leftTop = new fabric.Point(this.left, this.top);
					      return this.translateToCenterPoint(leftTop, this.originX, this.originY);
					    },
					
					    /**
					     * Returns the coordinates of the object based on center coordinates
					     * @param {fabric.Point} point The point which corresponds to the originX and originY params
					     * @return {fabric.Point}
					     */
					    // getOriginPoint: function(center) {
					    //   return this.translateToOriginPoint(center, this.originX, this.originY);
					    // },
					
					    /**
					     * Returns the coordinates of the object as if it has a different origin
					     * @param {String} originX Horizontal origin: 'left', 'center' or 'right'
					     * @param {String} originY Vertical origin: 'top', 'center' or 'bottom'
					     * @return {fabric.Point}
					     */
					    getPointByOrigin: function(originX, originY) {
					      var center = this.getCenterPoint();
					      return this.translateToOriginPoint(center, originX, originY);
					    },
					
					    /**
					     * Returns the point in local coordinates
					     * @param {fabric.Point} point The point relative to the global coordinate system
					     * @param {String} originX Horizontal origin: 'left', 'center' or 'right'
					     * @param {String} originY Vertical origin: 'top', 'center' or 'bottom'
					     * @return {fabric.Point}
					     */
					    toLocalPoint: function(point, originX, originY) {
					      var center = this.getCenterPoint(),
					          strokeWidth = this.stroke ? this.strokeWidth : 0,
					          x, y;
					
					      if (originX && originY) {
					        if (originX === 'left') {
					          x = center.x - (this.getWidth() + strokeWidth * this.scaleX) / 2;
					        }
					        else if (originX === 'right') {
					          x = center.x + (this.getWidth() + strokeWidth * this.scaleX) / 2;
					        }
					        else {
					          x = center.x;
					        }
					
					        if (originY === 'top') {
					          y = center.y - (this.getHeight() + strokeWidth * this.scaleY) / 2;
					        }
					        else if (originY === 'bottom') {
					          y = center.y + (this.getHeight() + strokeWidth * this.scaleY) / 2;
					        }
					        else {
					          y = center.y;
					        }
					      }
					      else {
					        x = this.left;
					        y = this.top;
					      }
					
					      return fabric.util.rotatePoint(new fabric.Point(point.x, point.y), center, -degreesToRadians(this.angle))
					        .subtractEquals(new fabric.Point(x, y));
					    },
					
					    /**
					     * Returns the point in global coordinates
					     * @param {fabric.Point} The point relative to the local coordinate system
					     * @return {fabric.Point}
					     */
					    // toGlobalPoint: function(point) {
					    //   return fabric.util.rotatePoint(point, this.getCenterPoint(), degreesToRadians(this.angle)).addEquals(new fabric.Point(this.left, this.top));
					    // },
					
					    /**
					     * Sets the position of the object taking into consideration the object's origin
					     * @param {fabric.Point} pos The new position of the object
					     * @param {String} originX Horizontal origin: 'left', 'center' or 'right'
					     * @param {String} originY Vertical origin: 'top', 'center' or 'bottom'
					     * @return {void}
					     */
					    setPositionByOrigin: function(pos, originX, originY) {
					      var center = this.translateToCenterPoint(pos, originX, originY),
					          position = this.translateToOriginPoint(center, this.originX, this.originY);
					
					      this.set('left', position.x);
					      this.set('top', position.y);
					    },
					
					    /**
					     * @param {String} to One of 'left', 'center', 'right'
					     */
					    adjustPosition: function(to) {
					      var angle = degreesToRadians(this.angle),
					          hypotHalf = this.getWidth() / 2,
					          xHalf = Math.cos(angle) * hypotHalf,
					          yHalf = Math.sin(angle) * hypotHalf,
					          hypotFull = this.getWidth(),
					          xFull = Math.cos(angle) * hypotFull,
					          yFull = Math.sin(angle) * hypotFull;
					
					      if (this.originX === 'center' && to === 'left' ||
					          this.originX === 'right' && to === 'center') {
					        // move half left
					        this.left -= xHalf;
					        this.top -= yHalf;
					      }
					      else if (this.originX === 'left' && to === 'center' ||
					               this.originX === 'center' && to === 'right') {
					        // move half right
					        this.left += xHalf;
					        this.top += yHalf;
					      }
					      else if (this.originX === 'left' && to === 'right') {
					        // move full right
					        this.left += xFull;
					        this.top += yFull;
					      }
					      else if (this.originX === 'right' && to === 'left') {
					        // move full left
					        this.left -= xFull;
					        this.top -= yFull;
					      }
					
					      this.setCoords();
					      this.originX = to;
					    },
					
					    /**
					     * Sets the origin/position of the object to it's center point
					     * @private
					     * @return {void}
					     */
					    _setOriginToCenter: function() {
					      this._originalOriginX = this.originX;
					      this._originalOriginY = this.originY;
					
					      var center = this.getCenterPoint();
					
					      this.originX = 'center';
					      this.originY = 'center';
					
					      this.left = center.x;
					      this.top = center.y;
					    },
					
					    /**
					     * Resets the origin/position of the object to it's original origin
					     * @private
					     * @return {void}
					     */
					    _resetOrigin: function() {
					      var originPoint = this.translateToOriginPoint(
					        this.getCenterPoint(),
					        this._originalOriginX,
					        this._originalOriginY);
					
					      this.originX = this._originalOriginX;
					      this.originY = this._originalOriginY;
					
					      this.left = originPoint.x;
					      this.top = originPoint.y;
					
					      this._originalOriginX = null;
					      this._originalOriginY = null;
					    },
					
					    /**
					     * @private
					     */
					    _getLeftTopCoords: function() {
					      return this.translateToOriginPoint(this.getCenterPoint(), 'left', 'center');
					    }
					  });
					
					})();
					(function() {
					
					  var degreesToRadians = fabric.util.degreesToRadians;
					
					  fabric.util.object.extend(fabric.Object.prototype, /** @lends fabric.Object.prototype */ {
					
					    /**
					     * Object containing coordinates of object's controls
					     * @type Object
					     * @default
					     */
					    oCoords: null,
					
					    /**
					     * Checks if object intersects with an area formed by 2 points
					     * @param {Object} pointTL top-left point of area
					     * @param {Object} pointBR bottom-right point of area
					     * @return {Boolean} true if object intersects with an area formed by 2 points
					     */
					    intersectsWithRect: function(pointTL, pointBR) {
					      var oCoords = this.oCoords,
					          tl = new fabric.Point(oCoords.tl.x, oCoords.tl.y),
					          tr = new fabric.Point(oCoords.tr.x, oCoords.tr.y),
					          bl = new fabric.Point(oCoords.bl.x, oCoords.bl.y),
					          br = new fabric.Point(oCoords.br.x, oCoords.br.y),
					          intersection = fabric.Intersection.intersectPolygonRectangle(
					            [tl, tr, br, bl],
					            pointTL,
					            pointBR
					          );
					      return intersection.status === 'Intersection';
					    },
					
					    /**
					     * Checks if object intersects with another object
					     * @param {Object} other Object to test
					     * @return {Boolean} true if object intersects with another object
					     */
					    intersectsWithObject: function(other) {
					      // extracts coords
					      function getCoords(oCoords) {
					        return {
					          tl: new fabric.Point(oCoords.tl.x, oCoords.tl.y),
					          tr: new fabric.Point(oCoords.tr.x, oCoords.tr.y),
					          bl: new fabric.Point(oCoords.bl.x, oCoords.bl.y),
					          br: new fabric.Point(oCoords.br.x, oCoords.br.y)
					        };
					      }
					      var thisCoords = getCoords(this.oCoords),
					          otherCoords = getCoords(other.oCoords),
					          intersection = fabric.Intersection.intersectPolygonPolygon(
					            [thisCoords.tl, thisCoords.tr, thisCoords.br, thisCoords.bl],
					            [otherCoords.tl, otherCoords.tr, otherCoords.br, otherCoords.bl]
					          );
					
					      return intersection.status === 'Intersection';
					    },
					
					    /**
					     * Checks if object is fully contained within area of another object
					     * @param {Object} other Object to test
					     * @return {Boolean} true if object is fully contained within area of another object
					     */
					    isContainedWithinObject: function(other) {
					      var boundingRect = other.getBoundingRect(),
					          point1 = new fabric.Point(boundingRect.left, boundingRect.top),
					          point2 = new fabric.Point(boundingRect.left + boundingRect.width, boundingRect.top + boundingRect.height);
					
					      return this.isContainedWithinRect(point1, point2);
					    },
					
					    /**
					     * Checks if object is fully contained within area formed by 2 points
					     * @param {Object} pointTL top-left point of area
					     * @param {Object} pointBR bottom-right point of area
					     * @return {Boolean} true if object is fully contained within area formed by 2 points
					     */
					    isContainedWithinRect: function(pointTL, pointBR) {
					      var boundingRect = this.getBoundingRect();
					
					      return (
					        boundingRect.left >= pointTL.x &&
					        boundingRect.left + boundingRect.width <= pointBR.x &&
					        boundingRect.top >= pointTL.y &&
					        boundingRect.top + boundingRect.height <= pointBR.y
					      );
					    },
					
					    /**
					     * Checks if point is inside the object
					     * @param {fabric.Point} point Point to check against
					     * @return {Boolean} true if point is inside the object
					     */
					    containsPoint: function(point) {
					      var lines = this._getImageLines(this.oCoords),
					          xPoints = this._findCrossPoints(point, lines);
					
					      // if xPoints is odd then point is inside the object
					      return (xPoints !== 0 && xPoints % 2 === 1);
					    },
					
					    /**
					     * Method that returns an object with the object edges in it, given the coordinates of the corners
					     * @private
					     * @param {Object} oCoords Coordinates of the object corners
					     */
					    _getImageLines: function(oCoords) {
					      return {
					        topline: {
					          o: oCoords.tl,
					          d: oCoords.tr
					        },
					        rightline: {
					          o: oCoords.tr,
					          d: oCoords.br
					        },
					        bottomline: {
					          o: oCoords.br,
					          d: oCoords.bl
					        },
					        leftline: {
					          o: oCoords.bl,
					          d: oCoords.tl
					        }
					      };
					    },
					
					    /**
					     * Helper method to determine how many cross points are between the 4 object edges
					     * and the horizontal line determined by a point on canvas
					     * @private
					     * @param {fabric.Point} point Point to check
					     * @param {Object} oCoords Coordinates of the object being evaluated
					     */
					    _findCrossPoints: function(point, oCoords) {
					      var b1, b2, a1, a2, xi, yi,
					          xcount = 0,
					          iLine;
					
					      for (var lineKey in oCoords) {
					        iLine = oCoords[lineKey];
					        // optimisation 1: line below point. no cross
					        if ((iLine.o.y < point.y) && (iLine.d.y < point.y)) {
					          continue;
					        }
					        // optimisation 2: line above point. no cross
					        if ((iLine.o.y >= point.y) && (iLine.d.y >= point.y)) {
					          continue;
					        }
					        // optimisation 3: vertical line case
					        if ((iLine.o.x === iLine.d.x) && (iLine.o.x >= point.x)) {
					          xi = iLine.o.x;
					          yi = point.y;
					        }
					        // calculate the intersection point
					        else {
					          b1 = 0;
					          b2 = (iLine.d.y - iLine.o.y) / (iLine.d.x - iLine.o.x);
					          a1 = point.y - b1 * point.x;
					          a2 = iLine.o.y - b2 * iLine.o.x;
					
					          xi = - (a1 - a2) / (b1 - b2);
					          yi = a1 + b1 * xi;
					        }
					        // dont count xi < point.x cases
					        if (xi >= point.x) {
					          xcount += 1;
					        }
					        // optimisation 4: specific for square images
					        if (xcount === 2) {
					          break;
					        }
					      }
					      return xcount;
					    },
					
					    /**
					     * Returns width of an object's bounding rectangle
					     * @deprecated since 1.0.4
					     * @return {Number} width value
					     */
					    getBoundingRectWidth: function() {
					      return this.getBoundingRect().width;
					    },
					
					    /**
					     * Returns height of an object's bounding rectangle
					     * @deprecated since 1.0.4
					     * @return {Number} height value
					     */
					    getBoundingRectHeight: function() {
					      return this.getBoundingRect().height;
					    },
					
					    /**
					     * Returns coordinates of object's bounding rectangle (left, top, width, height)
					     * @return {Object} Object with left, top, width, height properties
					     */
					    getBoundingRect: function() {
					      this.oCoords || this.setCoords();
					
					      var xCoords = [this.oCoords.tl.x, this.oCoords.tr.x, this.oCoords.br.x, this.oCoords.bl.x],
					          minX = fabric.util.array.min(xCoords),
					          maxX = fabric.util.array.max(xCoords),
					          width = Math.abs(minX - maxX),
					
					          yCoords = [this.oCoords.tl.y, this.oCoords.tr.y, this.oCoords.br.y, this.oCoords.bl.y],
					          minY = fabric.util.array.min(yCoords),
					          maxY = fabric.util.array.max(yCoords),
					          height = Math.abs(minY - maxY);
					
					      return {
					        left: minX,
					        top: minY,
					        width: width,
					        height: height
					      };
					    },
					
					    /**
					     * Returns width of an object
					     * @return {Number} width value
					     */
					    getWidth: function() {
					      return this.width * this.scaleX;
					    },
					
					    /**
					     * Returns height of an object
					     * @return {Number} height value
					     */
					    getHeight: function() {
					      return this.height * this.scaleY;
					    },
					
					    /**
					     * Makes sure the scale is valid and modifies it if necessary
					     * @private
					     * @param {Number} value
					     * @return {Number}
					     */
					    _constrainScale: function(value) {
					      if (Math.abs(value) < this.minScaleLimit) {
					        if (value < 0) {
					          return -this.minScaleLimit;
					        }
					        else {
					          return this.minScaleLimit;
					        }
					      }
					      return value;
					    },
					
					    /**
					     * Scales an object (equally by x and y)
					     * @param {Number} value Scale factor
					     * @return {fabric.Object} thisArg
					     * @chainable
					     */
					    scale: function(value) {
					      value = this._constrainScale(value);
					
					      if (value < 0) {
					        this.flipX = !this.flipX;
					        this.flipY = !this.flipY;
					        value *= -1;
					      }
					
					      this.scaleX = value;
					      this.scaleY = value;
					      this.setCoords();
					      return this;
					    },
					
					    /**
					     * Scales an object to a given width, with respect to bounding box (scaling by x/y equally)
					     * @param {Number} value New width value
					     * @return {fabric.Object} thisArg
					     * @chainable
					     */
					    scaleToWidth: function(value) {
					      // adjust to bounding rect factor so that rotated shapes would fit as well
					      var boundingRectFactor = this.getBoundingRectWidth() / this.getWidth();
					      return this.scale(value / this.width / boundingRectFactor);
					    },
					
					    /**
					     * Scales an object to a given height, with respect to bounding box (scaling by x/y equally)
					     * @param {Number} value New height value
					     * @return {fabric.Object} thisArg
					     * @chainable
					     */
					    scaleToHeight: function(value) {
					      // adjust to bounding rect factor so that rotated shapes would fit as well
					      var boundingRectFactor = this.getBoundingRectHeight() / this.getHeight();
					      return this.scale(value / this.height / boundingRectFactor);
					    },
					
					    /**
					     * Sets corner position coordinates based on current angle, width and height
					     * See https://github.com/kangax/fabric.js/wiki/When-to-call-setCoords
					     * @return {fabric.Object} thisArg
					     * @chainable
					     */
					    setCoords: function() {
					      var theta = degreesToRadians(this.angle),
					          vpt = this.getViewportTransform(),
					          f = function (p) {
					            return fabric.util.transformPoint(p, vpt);
					          },
					          p = this._calculateCurrentDimensions(false),
					          currentWidth = p.x, currentHeight = p.y;
					
					      // If width is negative, make postive. Fixes path selection issue
					      if (currentWidth < 0) {
					        currentWidth = Math.abs(currentWidth);
					      }
					
					      var _hypotenuse = Math.sqrt(
					            Math.pow(currentWidth / 2, 2) +
					            Math.pow(currentHeight / 2, 2)),
					
					          _angle = Math.atan(
					            isFinite(currentHeight / currentWidth)
					              ? currentHeight / currentWidth
					              : 0),
					
					          // offset added for rotate and scale actions
					          offsetX = Math.cos(_angle + theta) * _hypotenuse,
					          offsetY = Math.sin(_angle + theta) * _hypotenuse,
					          sinTh = Math.sin(theta),
					          cosTh = Math.cos(theta),
					          coords = this.getCenterPoint(),
					          wh = new fabric.Point(currentWidth, currentHeight),
					          _tl =   new fabric.Point(coords.x - offsetX, coords.y - offsetY),
					          _tr =   new fabric.Point(_tl.x + (wh.x * cosTh),   _tl.y + (wh.x * sinTh)),
					          bl =  f(new fabric.Point(_tl.x - (wh.y * sinTh),   _tl.y + (wh.y * cosTh))),
					          br  = f(new fabric.Point(_tr.x - (wh.y * sinTh),   _tr.y + (wh.y * cosTh))),
					          tl  = f(_tl),
					          tr  = f(_tr),
					          ml  = new fabric.Point((tl.x + bl.x)/2, (tl.y + bl.y)/2),
					          mt  = new fabric.Point((tr.x + tl.x)/2, (tr.y + tl.y)/2),
					          mr  = new fabric.Point((br.x + tr.x)/2, (br.y + tr.y)/2),
					          mb  = new fabric.Point((br.x + bl.x)/2, (br.y + bl.y)/2),
					          mtr = new fabric.Point(mt.x + sinTh * this.rotatingPointOffset, mt.y - cosTh * this.rotatingPointOffset);
					      // debugging
					
					      /* setTimeout(function() {
					         canvas.contextTop.fillStyle = 'green';
					         canvas.contextTop.fillRect(mb.x, mb.y, 3, 3);
					         canvas.contextTop.fillRect(bl.x, bl.y, 3, 3);
					         canvas.contextTop.fillRect(br.x, br.y, 3, 3);
					         canvas.contextTop.fillRect(tl.x, tl.y, 3, 3);
					         canvas.contextTop.fillRect(tr.x, tr.y, 3, 3);
					         canvas.contextTop.fillRect(ml.x, ml.y, 3, 3);
					         canvas.contextTop.fillRect(mr.x, mr.y, 3, 3);
					         canvas.contextTop.fillRect(mt.x, mt.y, 3, 3);
					         canvas.contextTop.fillRect(mtr.x, mtr.y, 3, 3);
					       }, 50); */
					
					      this.oCoords = {
					        // corners
					        tl: tl, tr: tr, br: br, bl: bl,
					        // middle
					        ml: ml, mt: mt, mr: mr, mb: mb,
					        // rotating point
					        mtr: mtr
					      };
					
					      // set coordinates of the draggable boxes in the corners used to scale/rotate the image
					      this._setCornerCoords && this._setCornerCoords();
					
					      return this;
					    }
					  });
					})();
					fabric.util.object.extend(fabric.Object.prototype, /** @lends fabric.Object.prototype */ {
					
					  /**
					   * Moves an object to the bottom of the stack of drawn objects
					   * @return {fabric.Object} thisArg
					   * @chainable
					   */
					  sendToBack: function() {
					    if (this.group) {
					      fabric.StaticCanvas.prototype.sendToBack.call(this.group, this);
					    }
					    else {
					      this.canvas.sendToBack(this);
					    }
					    return this;
					  },
					
					  /**
					   * Moves an object to the top of the stack of drawn objects
					   * @return {fabric.Object} thisArg
					   * @chainable
					   */
					  bringToFront: function() {
					    if (this.group) {
					      fabric.StaticCanvas.prototype.bringToFront.call(this.group, this);
					    }
					    else {
					      this.canvas.bringToFront(this);
					    }
					    return this;
					  },
					
					  /**
					   * Moves an object down in stack of drawn objects
					   * @param {Boolean} [intersecting] If `true`, send object behind next lower intersecting object
					   * @return {fabric.Object} thisArg
					   * @chainable
					   */
					  sendBackwards: function(intersecting) {
					    if (this.group) {
					      fabric.StaticCanvas.prototype.sendBackwards.call(this.group, this, intersecting);
					    }
					    else {
					      this.canvas.sendBackwards(this, intersecting);
					    }
					    return this;
					  },
					
					  /**
					   * Moves an object up in stack of drawn objects
					   * @param {Boolean} [intersecting] If `true`, send object in front of next upper intersecting object
					   * @return {fabric.Object} thisArg
					   * @chainable
					   */
					  bringForward: function(intersecting) {
					    if (this.group) {
					      fabric.StaticCanvas.prototype.bringForward.call(this.group, this, intersecting);
					    }
					    else {
					      this.canvas.bringForward(this, intersecting);
					    }
					    return this;
					  },
					
					  /**
					   * Moves an object to specified level in stack of drawn objects
					   * @param {Number} index New position of object
					   * @return {fabric.Object} thisArg
					   * @chainable
					   */
					  moveTo: function(index) {
					    if (this.group) {
					      fabric.StaticCanvas.prototype.moveTo.call(this.group, this, index);
					    }
					    else {
					      this.canvas.moveTo(this, index);
					    }
					    return this;
					  }
					});
					/* _TO_SVG_START_ */
					fabric.util.object.extend(fabric.Object.prototype, /** @lends fabric.Object.prototype */ {
					
					  /**
					   * Returns styles-string for svg-export
					   * @return {String}
					   */
					  getSvgStyles: function() {
					
					    var fill = this.fill
					          ? (this.fill.toLive ? 'url(#SVGID_' + this.fill.id + ')' : this.fill)
					          : 'none',
					        fillRule = this.fillRule,
					        stroke = this.stroke
					          ? (this.stroke.toLive ? 'url(#SVGID_' + this.stroke.id + ')' : this.stroke)
					          : 'none',
					
					        strokeWidth = this.strokeWidth ? this.strokeWidth : '0',
					        strokeDashArray = this.strokeDashArray ? this.strokeDashArray.join(' ') : '',
					        strokeLineCap = this.strokeLineCap ? this.strokeLineCap : 'butt',
					        strokeLineJoin = this.strokeLineJoin ? this.strokeLineJoin : 'miter',
					        strokeMiterLimit = this.strokeMiterLimit ? this.strokeMiterLimit : '4',
					        opacity = typeof this.opacity !== 'undefined' ? this.opacity : '1',
					
					        visibility = this.visible ? '' : ' visibility: hidden;',
					        filter = this.shadow ? 'filter: url(#SVGID_' + this.shadow.id + ');' : '';
					
					    return [
					      'stroke: ', stroke, '; ',
					      'stroke-width: ', strokeWidth, '; ',
					      'stroke-dasharray: ', strokeDashArray, '; ',
					      'stroke-linecap: ', strokeLineCap, '; ',
					      'stroke-linejoin: ', strokeLineJoin, '; ',
					      'stroke-miterlimit: ', strokeMiterLimit, '; ',
					      'fill: ', fill, '; ',
					      'fill-rule: ', fillRule, '; ',
					      'opacity: ', opacity, ';',
					      filter,
					      visibility
					    ].join('');
					  },
					
					  /**
					   * Returns transform-string for svg-export
					   * @return {String}
					   */
					  getSvgTransform: function() {
					    if (this.group && this.group.type === 'path-group') {
					      return '';
					    }
					    var toFixed = fabric.util.toFixed,
					        angle = this.getAngle(),
					        vpt = !this.canvas || this.canvas.svgViewportTransformation ? this.getViewportTransform() : [1, 0, 0, 1, 0, 0],
					        center = fabric.util.transformPoint(this.getCenterPoint(), vpt),
					
					        NUM_FRACTION_DIGITS = fabric.Object.NUM_FRACTION_DIGITS,
					
					        translatePart = this.type === 'path-group' ? '' : 'translate(' +
					                          toFixed(center.x, NUM_FRACTION_DIGITS) +
					                          ' ' +
					                          toFixed(center.y, NUM_FRACTION_DIGITS) +
					                        ')',
					
					        anglePart = angle !== 0
					          ? (' rotate(' + toFixed(angle, NUM_FRACTION_DIGITS) + ')')
					          : '',
					
					        scalePart = (this.scaleX === 1 && this.scaleY === 1 && vpt[0] === 1 && vpt[3] === 1)
					          ? '' :
					          (' scale(' +
					            toFixed(this.scaleX * vpt[0], NUM_FRACTION_DIGITS) +
					            ' ' +
					            toFixed(this.scaleY * vpt[3], NUM_FRACTION_DIGITS) +
					          ')'),
					
					        addTranslateX = this.type === 'path-group' ? this.width * vpt[0] : 0,
					
					        flipXPart = this.flipX ? ' matrix(-1 0 0 1 ' + addTranslateX + ' 0) ' : '',
					
					        addTranslateY = this.type === 'path-group' ? this.height * vpt[3] : 0,
					
					        flipYPart = this.flipY ? ' matrix(1 0 0 -1 0 ' + addTranslateY + ')' : '';
					
					    return [
					      translatePart, anglePart, scalePart, flipXPart, flipYPart
					    ].join('');
					  },
					
					  /**
					   * Returns transform-string for svg-export from the transform matrix of single elements
					   * @return {String}
					   */
					  getSvgTransformMatrix: function() {
					    return this.transformMatrix ? ' matrix(' + this.transformMatrix.join(' ') + ') ' : '';
					  },
					
					  /**
					   * @private
					   */
					  _createBaseSVGMarkup: function() {
					    var markup = [ ];
					
					    if (this.fill && this.fill.toLive) {
					      markup.push(this.fill.toSVG(this, false));
					    }
					    if (this.stroke && this.stroke.toLive) {
					      markup.push(this.stroke.toSVG(this, false));
					    }
					    if (this.shadow) {
					      markup.push(this.shadow.toSVG(this));
					    }
					    return markup;
					  }
					});
					/* _TO_SVG_END_ */
					/*
					  Depends on `stateProperties`
					*/
					fabric.util.object.extend(fabric.Object.prototype, /** @lends fabric.Object.prototype */ {
					
					  /**
					   * Returns true if object state (one of its state properties) was changed
					   * @return {Boolean} true if instance' state has changed since `{@link fabric.Object#saveState}` was called
					   */
					  hasStateChanged: function() {
					    return this.stateProperties.some(function(prop) {
					      return this.get(prop) !== this.originalState[prop];
					    }, this);
					  },
					
					  /**
					   * Saves state of an object
					   * @param {Object} [options] Object with additional `stateProperties` array to include when saving state
					   * @return {fabric.Object} thisArg
					   */
					  saveState: function(options) {
					    this.stateProperties.forEach(function(prop) {
					      this.originalState[prop] = this.get(prop);
					    }, this);
					
					    if (options && options.stateProperties) {
					      options.stateProperties.forEach(function(prop) {
					        this.originalState[prop] = this.get(prop);
					      }, this);
					    }
					
					    return this;
					  },
					
					  /**
					   * Setups state of an object
					   * @return {fabric.Object} thisArg
					   */
					  setupState: function() {
					    this.originalState = { };
					    this.saveState();
					
					    return this;
					  }
					});
					(function() {
					
					  var degreesToRadians = fabric.util.degreesToRadians,
					      //jscs:disable requireCamelCaseOrUpperCaseIdentifiers
					      isVML = function() { return typeof G_vmlCanvasManager !== 'undefined'; };
					  //jscs:enable requireCamelCaseOrUpperCaseIdentifiers
					
					  fabric.util.object.extend(fabric.Object.prototype, /** @lends fabric.Object.prototype */ {
					
					    /**
					     * The object interactivity controls.
					     * @private
					     */
					    _controlsVisibility: null,
					
					    /**
					     * Determines which corner has been clicked
					     * @private
					     * @param {Object} pointer The pointer indicating the mouse position
					     * @return {String|Boolean} corner code (tl, tr, bl, br, etc.), or false if nothing is found
					     */
					    _findTargetCorner: function(pointer) {
					      if (!this.hasControls || !this.active) {
					        return false;
					      }
					
					      var ex = pointer.x,
					          ey = pointer.y,
					          xPoints,
					          lines;
					
					      for (var i in this.oCoords) {
					
					        if (!this.isControlVisible(i)) {
					          continue;
					        }
					
					        if (i === 'mtr' && !this.hasRotatingPoint) {
					          continue;
					        }
					
					        if (this.get('lockUniScaling') &&
					           (i === 'mt' || i === 'mr' || i === 'mb' || i === 'ml')) {
					          continue;
					        }
					
					        lines = this._getImageLines(this.oCoords[i].corner);
					
					        // debugging
					
					        // canvas.contextTop.fillRect(lines.bottomline.d.x, lines.bottomline.d.y, 2, 2);
					        // canvas.contextTop.fillRect(lines.bottomline.o.x, lines.bottomline.o.y, 2, 2);
					
					        // canvas.contextTop.fillRect(lines.leftline.d.x, lines.leftline.d.y, 2, 2);
					        // canvas.contextTop.fillRect(lines.leftline.o.x, lines.leftline.o.y, 2, 2);
					
					        // canvas.contextTop.fillRect(lines.topline.d.x, lines.topline.d.y, 2, 2);
					        // canvas.contextTop.fillRect(lines.topline.o.x, lines.topline.o.y, 2, 2);
					
					        // canvas.contextTop.fillRect(lines.rightline.d.x, lines.rightline.d.y, 2, 2);
					        // canvas.contextTop.fillRect(lines.rightline.o.x, lines.rightline.o.y, 2, 2);
					
					        xPoints = this._findCrossPoints({ x: ex, y: ey }, lines);
					        if (xPoints !== 0 && xPoints % 2 === 1) {
					          this.__corner = i;
					          return i;
					        }
					      }
					      return false;
					    },
					
					    /**
					     * Sets the coordinates of the draggable boxes in the corners of
					     * the image used to scale/rotate it.
					     * @private
					     */
					    _setCornerCoords: function() {
					      var coords = this.oCoords,
					          newTheta = degreesToRadians(45 - this.angle),
					          cornerHypotenuse = Math.sqrt(2 * Math.pow(this.cornerSize, 2)) / 2,
					          cosHalfOffset = cornerHypotenuse * Math.cos(newTheta),
					          sinHalfOffset = cornerHypotenuse * Math.sin(newTheta),
					          x, y;
					
					      for (var point in coords) {
					        x = coords[point].x;
					        y = coords[point].y;
					        coords[point].corner = {
					          tl: {
					            x: x - sinHalfOffset,
					            y: y - cosHalfOffset
					          },
					          tr: {
					            x: x + cosHalfOffset,
					            y: y - sinHalfOffset
					          },
					          bl: {
					            x: x - cosHalfOffset,
					            y: y + sinHalfOffset
					          },
					          br: {
					            x: x + sinHalfOffset,
					            y: y + cosHalfOffset
					          }
					        };
					      }
					    },
					
					    _calculateCurrentDimensions: function(shouldTransform)  {
					      var vpt = this.getViewportTransform(),
					          strokeWidth = this.strokeWidth,
					          w = this.width,
					          h = this.height,
					          capped = this.strokeLineCap === 'round' || this.strokeLineCap === 'square',
					          vLine = this.type === 'line' && this.width === 0,
					          hLine = this.type === 'line' && this.height === 0,
					          sLine = vLine || hLine,
					          strokeW = (capped && hLine) || !sLine,
					          strokeH = (capped && vLine) || !sLine;
					
					      if (vLine) {
					        w = strokeWidth;
					      }
					      else if (hLine) {
					        h = strokeWidth;
					      }
					      if (strokeW) {
					        w += (w < 0 ? -strokeWidth : strokeWidth);
					      }
					      if (strokeH) {
					        h += (h < 0 ? -strokeWidth : strokeWidth);
					      }
					
					      w = w * this.scaleX + 2 * this.padding;
					      h = h * this.scaleY + 2 * this.padding;
					
					      if (shouldTransform) {
					        return fabric.util.transformPoint(new fabric.Point(w, h), vpt, true);
					      }
					      return { x: w, y: h };
					    },
					
					    /**
					     * Draws borders of an object's bounding box.
					     * Requires public properties: width, height
					     * Requires public options: padding, borderColor
					     * @param {CanvasRenderingContext2D} ctx Context to draw on
					     * @return {fabric.Object} thisArg
					     * @chainable
					     */
					    drawBorders: function(ctx) {
					      if (!this.hasBorders) {
					        return this;
					      }
					
					      ctx.save();
					
					      ctx.globalAlpha = this.isMoving ? this.borderOpacityWhenMoving : 1;
					      ctx.strokeStyle = this.borderColor;
					      ctx.lineWidth = 1 / this.borderScaleFactor;
					
					      var wh = this._calculateCurrentDimensions(true),
					          width = wh.x,
					          height = wh.y;
					      if (this.group) {
					        width = width * this.group.scaleX;
					        height = height * this.group.scaleY;
					      }
					
					      ctx.strokeRect(
					        ~~(-(width / 2)) - 0.5, // offset needed to make lines look sharper
					        ~~(-(height / 2)) - 0.5,
					        ~~(width) + 1, // double offset needed to make lines look sharper
					        ~~(height) + 1
					      );
					
					      if (this.hasRotatingPoint && this.isControlVisible('mtr') && !this.get('lockRotation') && this.hasControls) {
					
					        var rotateHeight = -height / 2;
					
					        ctx.beginPath();
					        ctx.moveTo(0, rotateHeight);
					        ctx.lineTo(0, rotateHeight - this.rotatingPointOffset);
					        ctx.closePath();
					        ctx.stroke();
					      }
					
					      ctx.restore();
					      return this;
					    },
					
					    /**
					     * Draws corners of an object's bounding box.
					     * Requires public properties: width, height
					     * Requires public options: cornerSize, padding
					     * @param {CanvasRenderingContext2D} ctx Context to draw on
					     * @return {fabric.Object} thisArg
					     * @chainable
					     */
					    drawControls: function(ctx) {
					      if (!this.hasControls) {
					        return this;
					      }
					
					      var wh = this._calculateCurrentDimensions(true),
					          width = wh.x,
					          height = wh.y,
					          left = -(width / 2),
					          top = -(height / 2),
					          scaleOffset = this.cornerSize / 2,
					          methodName = this.transparentCorners ? 'strokeRect' : 'fillRect';
					
					      ctx.save();
					
					      ctx.lineWidth = 1;
					
					      ctx.globalAlpha = this.isMoving ? this.borderOpacityWhenMoving : 1;
					      ctx.strokeStyle = ctx.fillStyle = this.cornerColor;
					
					      // top-left
					      this._drawControl('tl', ctx, methodName,
					        left - scaleOffset,
					        top - scaleOffset);
					
					      // top-right
					      this._drawControl('tr', ctx, methodName,
					        left + width - scaleOffset,
					        top - scaleOffset);
					
					      // bottom-left
					      this._drawControl('bl', ctx, methodName,
					        left - scaleOffset,
					        top + height - scaleOffset);
					
					      // bottom-right
					      this._drawControl('br', ctx, methodName,
					        left + width - scaleOffset,
					        top + height - scaleOffset);
					
					      if (!this.get('lockUniScaling')) {
					
					        // middle-top
					        this._drawControl('mt', ctx, methodName,
					          left + width/2 - scaleOffset,
					          top - scaleOffset);
					
					        // middle-bottom
					        this._drawControl('mb', ctx, methodName,
					          left + width/2 - scaleOffset,
					          top + height - scaleOffset);
					
					        // middle-right
					        this._drawControl('mr', ctx, methodName,
					          left + width - scaleOffset,
					          top + height/2 - scaleOffset);
					
					        // middle-left
					        this._drawControl('ml', ctx, methodName,
					          left - scaleOffset,
					          top + height/2 - scaleOffset);
					      }
					
					      // middle-top-rotate
					      if (this.hasRotatingPoint) {
					        this._drawControl('mtr', ctx, methodName,
					          left + width/2 - scaleOffset,
					          top - this.rotatingPointOffset - scaleOffset);
					      }
					
					      ctx.restore();
					
					      return this;
					    },
					
					    /**
					     * @private
					     */
					    _drawControl: function(control, ctx, methodName, left, top) {
					      if (!this.isControlVisible(control)) {
					        return;
					      }
					      var size = this.cornerSize;
					      isVML() || this.transparentCorners || ctx.clearRect(left, top, size, size);
					      ctx[methodName](left, top, size, size);
					    },
					
					    /**
					     * Returns true if the specified control is visible, false otherwise.
					     * @param {String} controlName The name of the control. Possible values are 'tl', 'tr', 'br', 'bl', 'ml', 'mt', 'mr', 'mb', 'mtr'.
					     * @returns {Boolean} true if the specified control is visible, false otherwise
					     */
					    isControlVisible: function(controlName) {
					      return this._getControlsVisibility()[controlName];
					    },
					
					    /**
					     * Sets the visibility of the specified control.
					     * @param {String} controlName The name of the control. Possible values are 'tl', 'tr', 'br', 'bl', 'ml', 'mt', 'mr', 'mb', 'mtr'.
					     * @param {Boolean} visible true to set the specified control visible, false otherwise
					     * @return {fabric.Object} thisArg
					     * @chainable
					     */
					    setControlVisible: function(controlName, visible) {
					      this._getControlsVisibility()[controlName] = visible;
					      return this;
					    },
					
					    /**
					     * Sets the visibility state of object controls.
					     * @param {Object} [options] Options object
					     * @param {Boolean} [options.bl] true to enable the bottom-left control, false to disable it
					     * @param {Boolean} [options.br] true to enable the bottom-right control, false to disable it
					     * @param {Boolean} [options.mb] true to enable the middle-bottom control, false to disable it
					     * @param {Boolean} [options.ml] true to enable the middle-left control, false to disable it
					     * @param {Boolean} [options.mr] true to enable the middle-right control, false to disable it
					     * @param {Boolean} [options.mt] true to enable the middle-top control, false to disable it
					     * @param {Boolean} [options.tl] true to enable the top-left control, false to disable it
					     * @param {Boolean} [options.tr] true to enable the top-right control, false to disable it
					     * @param {Boolean} [options.mtr] true to enable the middle-top-rotate control, false to disable it
					     * @return {fabric.Object} thisArg
					     * @chainable
					     */
					    setControlsVisibility: function(options) {
					      options || (options = { });
					
					      for (var p in options) {
					        this.setControlVisible(p, options[p]);
					      }
					      return this;
					    },
					
					    /**
					     * Returns the instance of the control visibility set for this object.
					     * @private
					     * @returns {Object}
					     */
					    _getControlsVisibility: function() {
					      if (!this._controlsVisibility) {
					        this._controlsVisibility = {
					          tl: true,
					          tr: true,
					          br: true,
					          bl: true,
					          ml: true,
					          mt: true,
					          mr: true,
					          mb: true,
					          mtr: true
					        };
					      }
					      return this._controlsVisibility;
					    }
					  });
					})();
					(function(global) {
					
					  'use strict';
					
					  var fabric = global.fabric || (global.fabric = { }),
					      extend = fabric.util.object.extend,
					      coordProps = { x1: 1, x2: 1, y1: 1, y2: 1 },
					      supportsLineDash = fabric.StaticCanvas.supports('setLineDash');
					
					  if (fabric.Line) {
					    fabric.warn('fabric.Line is already defined');
					    return;
					  }
					
					  /**
					   * Line class
					   * @class fabric.Line
					   * @extends fabric.Object
					   * @see {@link fabric.Line#initialize} for constructor definition
					   */
					  fabric.Line = fabric.util.createClass(fabric.Object, /** @lends fabric.Line.prototype */ {
					
					    /**
					     * Type of an object
					     * @type String
					     * @default
					     */
					    type: 'line',
					
					    /**
					     * x value or first line edge
					     * @type Number
					     * @default
					     */
					    x1: 0,
					
					    /**
					     * y value or first line edge
					     * @type Number
					     * @default
					     */
					    y1: 0,
					
					    /**
					     * x value or second line edge
					     * @type Number
					     * @default
					     */
					    x2: 0,
					
					    /**
					     * y value or second line edge
					     * @type Number
					     * @default
					     */
					    y2: 0,
					
					    /**
					     * Constructor
					     * @param {Array} [points] Array of points
					     * @param {Object} [options] Options object
					     * @return {fabric.Line} thisArg
					     */
					    initialize: function(points, options) {
					      options = options || { };
					
					      if (!points) {
					        points = [0, 0, 0, 0];
					      }
					
					      this.callSuper('initialize', options);
					
					      this.set('x1', points[0]);
					      this.set('y1', points[1]);
					      this.set('x2', points[2]);
					      this.set('y2', points[3]);
					
					      this._setWidthHeight(options);
					    },
					
					    /**
					     * @private
					     * @param {Object} [options] Options
					     */
					    _setWidthHeight: function(options) {
					      options || (options = { });
					
					      this.width = Math.abs(this.x2 - this.x1);
					      this.height = Math.abs(this.y2 - this.y1);
					
					      this.left = 'left' in options
					        ? options.left
					        : this._getLeftToOriginX();
					
					      this.top = 'top' in options
					        ? options.top
					        : this._getTopToOriginY();
					    },
					
					    /**
					     * @private
					     * @param {String} key
					     * @param {Any} value
					     */
					    _set: function(key, value) {
					      this.callSuper('_set', key, value);
					      if (typeof coordProps[key] !== 'undefined') {
					        this._setWidthHeight();
					      }
					      return this;
					    },
					
					    /**
					     * @private
					     * @return {Number} leftToOriginX Distance from left edge of canvas to originX of Line.
					     */
					    _getLeftToOriginX: makeEdgeToOriginGetter(
					      { // property names
					        origin: 'originX',
					        axis1: 'x1',
					        axis2: 'x2',
					        dimension: 'width'
					      },
					      { // possible values of origin
					        nearest: 'left',
					        center: 'center',
					        farthest: 'right'
					      }
					    ),
					
					    /**
					     * @private
					     * @return {Number} topToOriginY Distance from top edge of canvas to originY of Line.
					     */
					    _getTopToOriginY: makeEdgeToOriginGetter(
					      { // property names
					        origin: 'originY',
					        axis1: 'y1',
					        axis2: 'y2',
					        dimension: 'height'
					      },
					      { // possible values of origin
					        nearest: 'top',
					        center: 'center',
					        farthest: 'bottom'
					      }
					    ),
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     */
					    _render: function(ctx, noTransform) {
					      ctx.beginPath();
					
					      if (noTransform) {
					        //  Line coords are distances from left-top of canvas to origin of line.
					        //  To render line in a path-group, we need to translate them to
					        //  distances from center of path-group to center of line.
					        var cp = this.getCenterPoint();
					        ctx.translate(
					          cp.x - this.strokeWidth / 2,
					          cp.y - this.strokeWidth / 2
					        );
					      }
					
					      if (!this.strokeDashArray || this.strokeDashArray && supportsLineDash) {
					        // move from center (of virtual box) to its left/top corner
					        // we can't assume x1, y1 is top left and x2, y2 is bottom right
					        var p = this.calcLinePoints();
					        ctx.moveTo(p.x1, p.y1);
					        ctx.lineTo(p.x2, p.y2);
					      }
					
					      ctx.lineWidth = this.strokeWidth;
					
					      // TODO: test this
					      // make sure setting "fill" changes color of a line
					      // (by copying fillStyle to strokeStyle, since line is stroked, not filled)
					      var origStrokeStyle = ctx.strokeStyle;
					      ctx.strokeStyle = this.stroke || ctx.fillStyle;
					      this.stroke && this._renderStroke(ctx);
					      ctx.strokeStyle = origStrokeStyle;
					    },
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     */
					    _renderDashedStroke: function(ctx) {
					      var p = this.calcLinePoints();
					
					      ctx.beginPath();
					      fabric.util.drawDashedLine(ctx, p.x1, p.y1, p.x2, p.y2, this.strokeDashArray);
					      ctx.closePath();
					    },
					
					    /**
					     * Returns object representation of an instance
					     * @methd toObject
					     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output
					     * @return {Object} object representation of an instance
					     */
					    toObject: function(propertiesToInclude) {
					      return extend(this.callSuper('toObject', propertiesToInclude), this.calcLinePoints());
					    },
					
					    /**
					     * Recalculates line points given width and height
					     * @private
					     */
					    calcLinePoints: function() {
					      var xMult = this.x1 <= this.x2 ? -1 : 1,
					          yMult = this.y1 <= this.y2 ? -1 : 1,
					          x1 = (xMult * this.width * 0.5),
					          y1 = (yMult * this.height * 0.5),
					          x2 = (xMult * this.width * -0.5),
					          y2 = (yMult * this.height * -0.5);
					
					      return {
					        x1: x1,
					        x2: x2,
					        y1: y1,
					        y2: y2
					      };
					    },
					
					    /* _TO_SVG_START_ */
					    /**
					     * Returns SVG representation of an instance
					     * @param {Function} [reviver] Method for further parsing of svg representation.
					     * @return {String} svg representation of an instance
					     */
					    toSVG: function(reviver) {
					      var markup = this._createBaseSVGMarkup(),
					          p = { x1: this.x1, x2: this.x2, y1: this.y1, y2: this.y2 };
					
					      if (!(this.group && this.group.type === 'path-group')) {
					        p = this.calcLinePoints();
					      }
					      markup.push(
					        '<line ',
					          'x1="', p.x1,
					          '" y1="', p.y1,
					          '" x2="', p.x2,
					          '" y2="', p.y2,
					          '" style="', this.getSvgStyles(),
					          '" transform="', this.getSvgTransform(),
					          this.getSvgTransformMatrix(),
					        '"/>\n'
					      );
					
					      return reviver ? reviver(markup.join('')) : markup.join('');
					    },
					    /* _TO_SVG_END_ */
					
					    /**
					     * Returns complexity of an instance
					     * @return {Number} complexity
					     */
					    complexity: function() {
					      return 1;
					    }
					  });
					
					  /* _FROM_SVG_START_ */
					  /**
					   * List of attribute names to account for when parsing SVG element (used by {@link fabric.Line.fromElement})
					   * @static
					   * @memberOf fabric.Line
					   * @see http://www.w3.org/TR/SVG/shapes.html#LineElement
					   */
					  fabric.Line.ATTRIBUTE_NAMES = fabric.SHARED_ATTRIBUTES.concat('x1 y1 x2 y2'.split(' '));
					
					  /**
					   * Returns fabric.Line instance from an SVG element
					   * @static
					   * @memberOf fabric.Line
					   * @param {SVGElement} element Element to parse
					   * @param {Object} [options] Options object
					   * @return {fabric.Line} instance of fabric.Line
					   */
					  fabric.Line.fromElement = function(element, options) {
					    var parsedAttributes = fabric.parseAttributes(element, fabric.Line.ATTRIBUTE_NAMES),
					        points = [
					          parsedAttributes.x1 || 0,
					          parsedAttributes.y1 || 0,
					          parsedAttributes.x2 || 0,
					          parsedAttributes.y2 || 0
					        ];
					    return new fabric.Line(points, extend(parsedAttributes, options));
					  };
					  /* _FROM_SVG_END_ */
					
					  /**
					   * Returns fabric.Line instance from an object representation
					   * @static
					   * @memberOf fabric.Line
					   * @param {Object} object Object to create an instance from
					   * @return {fabric.Line} instance of fabric.Line
					   */
					  fabric.Line.fromObject = function(object) {
					    var points = [object.x1, object.y1, object.x2, object.y2];
					    return new fabric.Line(points, object);
					  };
					
					  /**
					   * Produces a function that calculates distance from canvas edge to Line origin.
					   */
					  function makeEdgeToOriginGetter(propertyNames, originValues) {
					    var origin = propertyNames.origin,
					        axis1 = propertyNames.axis1,
					        axis2 = propertyNames.axis2,
					        dimension = propertyNames.dimension,
					        nearest = originValues.nearest,
					        center = originValues.center,
					        farthest = originValues.farthest;
					
					    return function() {
					      switch (this.get(origin)) {
					      case nearest:
					        return Math.min(this.get(axis1), this.get(axis2));
					      case center:
					        return Math.min(this.get(axis1), this.get(axis2)) + (0.5 * this.get(dimension));
					      case farthest:
					        return Math.max(this.get(axis1), this.get(axis2));
					      }
					    };
					
					  }
					
					})(typeof exports !== 'undefined' ? exports : this);
					(function(global) {
					
					  'use strict';
					
					  var fabric = global.fabric || (global.fabric = { }),
					      pi = Math.PI,
					      extend = fabric.util.object.extend;
					
					  if (fabric.Circle) {
					    fabric.warn('fabric.Circle is already defined.');
					    return;
					  }
					
					  /**
					   * Circle class
					   * @class fabric.Circle
					   * @extends fabric.Object
					   * @see {@link fabric.Circle#initialize} for constructor definition
					   */
					  fabric.Circle = fabric.util.createClass(fabric.Object, /** @lends fabric.Circle.prototype */ {
					
					    /**
					     * Type of an object
					     * @type String
					     * @default
					     */
					    type: 'circle',
					
					    /**
					     * Radius of this circle
					     * @type Number
					     * @default
					     */
					    radius: 0,
					
					    /**
					     * Start angle of the circle, moving clockwise
					     * @type Number
					     * @default 0
					     */
					    startAngle: 0,
					
					    /**
					     * End angle of the circle
					     * @type Number
					     * @default 2Pi
					     */
					    endAngle: pi * 2,
					
					    /**
					     * Constructor
					     * @param {Object} [options] Options object
					     * @return {fabric.Circle} thisArg
					     */
					    initialize: function(options) {
					      options = options || { };
					
					      this.callSuper('initialize', options);
					      this.set('radius', options.radius || 0);
					      this.startAngle = options.startAngle || this.startAngle;
					      this.endAngle = options.endAngle || this.endAngle;
					    },
					
					    /**
					     * @private
					     * @param {String} key
					     * @param {Any} value
					     * @return {fabric.Circle} thisArg
					     */
					    _set: function(key, value) {
					      this.callSuper('_set', key, value);
					
					      if (key === 'radius') {
					        this.setRadius(value);
					      }
					
					      return this;
					    },
					
					    /**
					     * Returns object representation of an instance
					     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output
					     * @return {Object} object representation of an instance
					     */
					    toObject: function(propertiesToInclude) {
					      return extend(this.callSuper('toObject', propertiesToInclude), {
					        radius: this.get('radius'),
					        startAngle: this.startAngle,
					        endAngle: this.endAngle
					      });
					    },
					
					    /* _TO_SVG_START_ */
					    /**
					     * Returns svg representation of an instance
					     * @param {Function} [reviver] Method for further parsing of svg representation.
					     * @return {String} svg representation of an instance
					     */
					    toSVG: function(reviver) {
					      var markup = this._createBaseSVGMarkup(), x = 0, y = 0,
					      angle = (this.endAngle - this.startAngle) % ( 2 * pi);
					
					      if (angle === 0) {
					        if (this.group && this.group.type === 'path-group') {
					          x = this.left + this.radius;
					          y = this.top + this.radius;
					        }
					        markup.push(
					          '<circle ',
					            'cx="' + x + '" cy="' + y + '" ',
					            'r="', this.radius,
					            '" style="', this.getSvgStyles(),
					            '" transform="', this.getSvgTransform(),
					            ' ', this.getSvgTransformMatrix(),
					          '"/>\n'
					        );
					      }
					      else {
					        var startX = Math.cos(this.startAngle) * this.radius,
					            startY = Math.sin(this.startAngle) * this.radius,
					            endX = Math.cos(this.endAngle) * this.radius,
					            endY = Math.sin(this.endAngle) * this.radius,
					            largeFlag = angle > pi ? '1' : '0';
					
					        markup.push(
					          '<path d="M ' + startX + ' ' + startY,
					          ' A ' + this.radius + ' ' + this.radius,
					          ' 0 ', + largeFlag + ' 1', ' ' + endX + ' ' + endY,
					          '" style="', this.getSvgStyles(),
					          '" transform="', this.getSvgTransform(),
					          ' ', this.getSvgTransformMatrix(),
					          '"/>\n'
					        );
					      }
					
					      return reviver ? reviver(markup.join('')) : markup.join('');
					    },
					    /* _TO_SVG_END_ */
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx context to render on
					     * @param {Boolean} [noTransform] When true, context is not transformed
					     */
					    _render: function(ctx, noTransform) {
					      ctx.beginPath();
					      ctx.arc(noTransform ? this.left + this.radius : 0,
					              noTransform ? this.top + this.radius : 0,
					              this.radius,
					              this.startAngle,
					              this.endAngle, false);
					      this._renderFill(ctx);
					      this._renderStroke(ctx);
					    },
					
					    /**
					     * Returns horizontal radius of an object (according to how an object is scaled)
					     * @return {Number}
					     */
					    getRadiusX: function() {
					      return this.get('radius') * this.get('scaleX');
					    },
					
					    /**
					     * Returns vertical radius of an object (according to how an object is scaled)
					     * @return {Number}
					     */
					    getRadiusY: function() {
					      return this.get('radius') * this.get('scaleY');
					    },
					
					    /**
					     * Sets radius of an object (and updates width accordingly)
					     * @return {Number}
					     */
					    setRadius: function(value) {
					      this.radius = value;
					      this.set('width', value * 2).set('height', value * 2);
					    },
					
					    /**
					     * Returns complexity of an instance
					     * @return {Number} complexity of this instance
					     */
					    complexity: function() {
					      return 1;
					    }
					  });
					
					  /* _FROM_SVG_START_ */
					  /**
					   * List of attribute names to account for when parsing SVG element (used by {@link fabric.Circle.fromElement})
					   * @static
					   * @memberOf fabric.Circle
					   * @see: http://www.w3.org/TR/SVG/shapes.html#CircleElement
					   */
					  fabric.Circle.ATTRIBUTE_NAMES = fabric.SHARED_ATTRIBUTES.concat('cx cy r'.split(' '));
					
					  /**
					   * Returns {@link fabric.Circle} instance from an SVG element
					   * @static
					   * @memberOf fabric.Circle
					   * @param {SVGElement} element Element to parse
					   * @param {Object} [options] Options object
					   * @throws {Error} If value of `r` attribute is missing or invalid
					   * @return {fabric.Circle} Instance of fabric.Circle
					   */
					  fabric.Circle.fromElement = function(element, options) {
					    options || (options = { });
					
					    var parsedAttributes = fabric.parseAttributes(element, fabric.Circle.ATTRIBUTE_NAMES);
					
					    if (!isValidRadius(parsedAttributes)) {
					      throw new Error('value of `r` attribute is required and can not be negative');
					    }
					
					    parsedAttributes.left = parsedAttributes.left || 0;
					    parsedAttributes.top = parsedAttributes.top || 0;
					
					    var obj = new fabric.Circle(extend(parsedAttributes, options));
					
					    obj.left -= obj.radius;
					    obj.top -= obj.radius;
					    return obj;
					  };
					
					  /**
					   * @private
					   */
					  function isValidRadius(attributes) {
					    return (('radius' in attributes) && (attributes.radius >= 0));
					  }
					  /* _FROM_SVG_END_ */
					
					  /**
					   * Returns {@link fabric.Circle} instance from an object representation
					   * @static
					   * @memberOf fabric.Circle
					   * @param {Object} object Object to create an instance from
					   * @return {Object} Instance of fabric.Circle
					   */
					  fabric.Circle.fromObject = function(object) {
					    return new fabric.Circle(object);
					  };
					
					})(typeof exports !== 'undefined' ? exports : this);
					(function(global) {
					
					  'use strict';
					
					  var fabric = global.fabric || (global.fabric = { });
					
					  if (fabric.Triangle) {
					    fabric.warn('fabric.Triangle is already defined');
					    return;
					  }
					
					  /**
					   * Triangle class
					   * @class fabric.Triangle
					   * @extends fabric.Object
					   * @return {fabric.Triangle} thisArg
					   * @see {@link fabric.Triangle#initialize} for constructor definition
					   */
					  fabric.Triangle = fabric.util.createClass(fabric.Object, /** @lends fabric.Triangle.prototype */ {
					
					    /**
					     * Type of an object
					     * @type String
					     * @default
					     */
					    type: 'triangle',
					
					    /**
					     * Constructor
					     * @param {Object} [options] Options object
					     * @return {Object} thisArg
					     */
					    initialize: function(options) {
					      options = options || { };
					
					      this.callSuper('initialize', options);
					
					      this.set('width', options.width || 100)
					          .set('height', options.height || 100);
					    },
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     */
					    _render: function(ctx) {
					      var widthBy2 = this.width / 2,
					          heightBy2 = this.height / 2;
					
					      ctx.beginPath();
					      ctx.moveTo(-widthBy2, heightBy2);
					      ctx.lineTo(0, -heightBy2);
					      ctx.lineTo(widthBy2, heightBy2);
					      ctx.closePath();
					
					      this._renderFill(ctx);
					      this._renderStroke(ctx);
					    },
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     */
					    _renderDashedStroke: function(ctx) {
					      var widthBy2 = this.width / 2,
					          heightBy2 = this.height / 2;
					
					      ctx.beginPath();
					      fabric.util.drawDashedLine(ctx, -widthBy2, heightBy2, 0, -heightBy2, this.strokeDashArray);
					      fabric.util.drawDashedLine(ctx, 0, -heightBy2, widthBy2, heightBy2, this.strokeDashArray);
					      fabric.util.drawDashedLine(ctx, widthBy2, heightBy2, -widthBy2, heightBy2, this.strokeDashArray);
					      ctx.closePath();
					    },
					
					    /* _TO_SVG_START_ */
					    /**
					     * Returns SVG representation of an instance
					     * @param {Function} [reviver] Method for further parsing of svg representation.
					     * @return {String} svg representation of an instance
					     */
					    toSVG: function(reviver) {
					      var markup = this._createBaseSVGMarkup(),
					          widthBy2 = this.width / 2,
					          heightBy2 = this.height / 2,
					          points = [
					            -widthBy2 + ' ' + heightBy2,
					            '0 ' + -heightBy2,
					            widthBy2 + ' ' + heightBy2
					          ]
					          .join(',');
					
					      markup.push(
					        '<polygon ',
					          'points="', points,
					          '" style="', this.getSvgStyles(),
					          '" transform="', this.getSvgTransform(),
					        '"/>'
					      );
					
					      return reviver ? reviver(markup.join('')) : markup.join('');
					    },
					    /* _TO_SVG_END_ */
					
					    /**
					     * Returns complexity of an instance
					     * @return {Number} complexity of this instance
					     */
					    complexity: function() {
					      return 1;
					    }
					  });
					
					  /**
					   * Returns fabric.Triangle instance from an object representation
					   * @static
					   * @memberOf fabric.Triangle
					   * @param {Object} object Object to create an instance from
					   * @return {Object} instance of Canvas.Triangle
					   */
					  fabric.Triangle.fromObject = function(object) {
					    return new fabric.Triangle(object);
					  };
					
					})(typeof exports !== 'undefined' ? exports : this);
					(function(global) {
					
					  'use strict';
					
					  var fabric = global.fabric || (global.fabric = { }),
					      piBy2   = Math.PI * 2,
					      extend = fabric.util.object.extend;
					
					  if (fabric.Ellipse) {
					    fabric.warn('fabric.Ellipse is already defined.');
					    return;
					  }
					
					  /**
					   * Ellipse class
					   * @class fabric.Ellipse
					   * @extends fabric.Object
					   * @return {fabric.Ellipse} thisArg
					   * @see {@link fabric.Ellipse#initialize} for constructor definition
					   */
					  fabric.Ellipse = fabric.util.createClass(fabric.Object, /** @lends fabric.Ellipse.prototype */ {
					
					    /**
					     * Type of an object
					     * @type String
					     * @default
					     */
					    type: 'ellipse',
					
					    /**
					     * Horizontal radius
					     * @type Number
					     * @default
					     */
					    rx:   0,
					
					    /**
					     * Vertical radius
					     * @type Number
					     * @default
					     */
					    ry:   0,
					
					    /**
					     * Constructor
					     * @param {Object} [options] Options object
					     * @return {fabric.Ellipse} thisArg
					     */
					    initialize: function(options) {
					      options = options || { };
					
					      this.callSuper('initialize', options);
					
					      this.set('rx', options.rx || 0);
					      this.set('ry', options.ry || 0);
					    },
					
					    /**
					     * @private
					     * @param {String} key
					     * @param {Any} value
					     * @return {fabric.Ellipse} thisArg
					     */
					    _set: function(key, value) {
					      this.callSuper('_set', key, value);
					      switch (key) {
					
					        case 'rx':
					          this.rx = value;
					          this.set('width', value * 2);
					          break;
					
					        case 'ry':
					          this.ry = value;
					          this.set('height', value * 2);
					          break;
					
					      }
					      return this;
					    },
					
					    /**
					     * Returns horizontal radius of an object (according to how an object is scaled)
					     * @return {Number}
					     */
					    getRx: function() {
					      return this.get('rx') * this.get('scaleX');
					    },
					
					    /**
					     * Returns Vertical radius of an object (according to how an object is scaled)
					     * @return {Number}
					     */
					    getRy: function() {
					      return this.get('ry') * this.get('scaleY');
					    },
					
					    /**
					     * Returns object representation of an instance
					     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output
					     * @return {Object} object representation of an instance
					     */
					    toObject: function(propertiesToInclude) {
					      return extend(this.callSuper('toObject', propertiesToInclude), {
					        rx: this.get('rx'),
					        ry: this.get('ry')
					      });
					    },
					
					    /* _TO_SVG_START_ */
					    /**
					     * Returns svg representation of an instance
					     * @param {Function} [reviver] Method for further parsing of svg representation.
					     * @return {String} svg representation of an instance
					     */
					    toSVG: function(reviver) {
					      var markup = this._createBaseSVGMarkup(), x = 0, y = 0;
					      if (this.group && this.group.type === 'path-group') {
					        x = this.left + this.rx;
					        y = this.top + this.ry;
					      }
					      markup.push(
					        '<ellipse ',
					          'cx="', x, '" cy="', y, '" ',
					          'rx="', this.rx,
					          '" ry="', this.ry,
					          '" style="', this.getSvgStyles(),
					          '" transform="', this.getSvgTransform(),
					          this.getSvgTransformMatrix(),
					        '"/>\n'
					      );
					
					      return reviver ? reviver(markup.join('')) : markup.join('');
					    },
					    /* _TO_SVG_END_ */
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx context to render on
					     * @param {Boolean} [noTransform] When true, context is not transformed
					     */
					    _render: function(ctx, noTransform) {
					      ctx.beginPath();
					      ctx.save();
					      ctx.transform(1, 0, 0, this.ry/this.rx, 0, 0);
					      ctx.arc(
					        noTransform ? this.left + this.rx : 0,
					        noTransform ? (this.top + this.ry) * this.rx/this.ry : 0,
					        this.rx,
					        0,
					        piBy2,
					        false);
					      ctx.restore();
					      this._renderFill(ctx);
					      this._renderStroke(ctx);
					    },
					
					    /**
					     * Returns complexity of an instance
					     * @return {Number} complexity
					     */
					    complexity: function() {
					      return 1;
					    }
					  });
					
					  /* _FROM_SVG_START_ */
					  /**
					   * List of attribute names to account for when parsing SVG element (used by {@link fabric.Ellipse.fromElement})
					   * @static
					   * @memberOf fabric.Ellipse
					   * @see http://www.w3.org/TR/SVG/shapes.html#EllipseElement
					   */
					  fabric.Ellipse.ATTRIBUTE_NAMES = fabric.SHARED_ATTRIBUTES.concat('cx cy rx ry'.split(' '));
					
					  /**
					   * Returns {@link fabric.Ellipse} instance from an SVG element
					   * @static
					   * @memberOf fabric.Ellipse
					   * @param {SVGElement} element Element to parse
					   * @param {Object} [options] Options object
					   * @return {fabric.Ellipse}
					   */
					  fabric.Ellipse.fromElement = function(element, options) {
					    options || (options = { });
					
					    var parsedAttributes = fabric.parseAttributes(element, fabric.Ellipse.ATTRIBUTE_NAMES);
					
					    parsedAttributes.left = parsedAttributes.left || 0;
					    parsedAttributes.top = parsedAttributes.top || 0;
					
					    var ellipse = new fabric.Ellipse(extend(parsedAttributes, options));
					
					    ellipse.top -= ellipse.ry;
					    ellipse.left -= ellipse.rx;
					    return ellipse;
					  };
					  /* _FROM_SVG_END_ */
					
					  /**
					   * Returns {@link fabric.Ellipse} instance from an object representation
					   * @static
					   * @memberOf fabric.Ellipse
					   * @param {Object} object Object to create an instance from
					   * @return {fabric.Ellipse}
					   */
					  fabric.Ellipse.fromObject = function(object) {
					    return new fabric.Ellipse(object);
					  };
					
					})(typeof exports !== 'undefined' ? exports : this);
					(function(global) {
					
					  'use strict';
					
					  var fabric = global.fabric || (global.fabric = { }),
					      extend = fabric.util.object.extend;
					
					  if (fabric.Rect) {
					    console.warn('fabric.Rect is already defined');
					    return;
					  }
					
					  var stateProperties = fabric.Object.prototype.stateProperties.concat();
					  stateProperties.push('rx', 'ry', 'x', 'y');
					
					  /**
					   * Rectangle class
					   * @class fabric.Rect
					   * @extends fabric.Object
					   * @return {fabric.Rect} thisArg
					   * @see {@link fabric.Rect#initialize} for constructor definition
					   */
					  fabric.Rect = fabric.util.createClass(fabric.Object, /** @lends fabric.Rect.prototype */ {
					
					    /**
					     * List of properties to consider when checking if state of an object is changed ({@link fabric.Object#hasStateChanged})
					     * as well as for history (undo/redo) purposes
					     * @type Array
					     */
					    stateProperties: stateProperties,
					
					    /**
					     * Type of an object
					     * @type String
					     * @default
					     */
					    type: 'rect',
					
					    /**
					     * Horizontal border radius
					     * @type Number
					     * @default
					     */
					    rx:   0,
					
					    /**
					     * Vertical border radius
					     * @type Number
					     * @default
					     */
					    ry:   0,
					
					    /**
					     * Used to specify dash pattern for stroke on this object
					     * @type Array
					     */
					    strokeDashArray: null,
					
					    /**
					     * Constructor
					     * @param {Object} [options] Options object
					     * @return {Object} thisArg
					     */
					    initialize: function(options) {
					      options = options || { };
					
					      this.callSuper('initialize', options);
					      this._initRxRy();
					
					    },
					
					    /**
					     * Initializes rx/ry attributes
					     * @private
					     */
					    _initRxRy: function() {
					      if (this.rx && !this.ry) {
					        this.ry = this.rx;
					      }
					      else if (this.ry && !this.rx) {
					        this.rx = this.ry;
					      }
					    },
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     */
					    _render: function(ctx, noTransform) {
					
					      // optimize 1x1 case (used in spray brush)
					      if (this.width === 1 && this.height === 1) {
					        ctx.fillRect(0, 0, 1, 1);
					        return;
					      }
					
					      var rx = this.rx ? Math.min(this.rx, this.width / 2) : 0,
					          ry = this.ry ? Math.min(this.ry, this.height / 2) : 0,
					          w = this.width,
					          h = this.height,
					          x = noTransform ? this.left : -this.width / 2,
					          y = noTransform ? this.top : -this.height / 2,
					          isRounded = rx !== 0 || ry !== 0,
					          k = 1 - 0.5522847498 /* "magic number" for bezier approximations of arcs (http://itc.ktu.lt/itc354/Riskus354.pdf) */;
					
					      ctx.beginPath();
					
					      ctx.moveTo(x + rx, y);
					
					      ctx.lineTo(x + w - rx, y);
					      isRounded && ctx.bezierCurveTo(x + w - k * rx, y, x + w, y + k * ry, x + w, y + ry);
					
					      ctx.lineTo(x + w, y + h - ry);
					      isRounded && ctx.bezierCurveTo(x + w, y + h - k * ry, x + w - k * rx, y + h, x + w - rx, y + h);
					
					      ctx.lineTo(x + rx, y + h);
					      isRounded && ctx.bezierCurveTo(x + k * rx, y + h, x, y + h - k * ry, x, y + h - ry);
					
					      ctx.lineTo(x, y + ry);
					      isRounded && ctx.bezierCurveTo(x, y + k * ry, x + k * rx, y, x + rx, y);
					
					      ctx.closePath();
					
					      this._renderFill(ctx);
					      this._renderStroke(ctx);
					    },
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     */
					    _renderDashedStroke: function(ctx) {
					      var x = -this.width / 2,
					          y = -this.height / 2,
					          w = this.width,
					          h = this.height;
					
					      ctx.beginPath();
					      fabric.util.drawDashedLine(ctx, x, y, x + w, y, this.strokeDashArray);
					      fabric.util.drawDashedLine(ctx, x + w, y, x + w, y + h, this.strokeDashArray);
					      fabric.util.drawDashedLine(ctx, x + w, y + h, x, y + h, this.strokeDashArray);
					      fabric.util.drawDashedLine(ctx, x, y + h, x, y, this.strokeDashArray);
					      ctx.closePath();
					    },
					
					    /**
					     * Returns object representation of an instance
					     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output
					     * @return {Object} object representation of an instance
					     */
					    toObject: function(propertiesToInclude) {
					      var object = extend(this.callSuper('toObject', propertiesToInclude), {
					        rx: this.get('rx') || 0,
					        ry: this.get('ry') || 0
					      });
					      if (!this.includeDefaultValues) {
					        this._removeDefaultValues(object);
					      }
					      return object;
					    },
					
					    /* _TO_SVG_START_ */
					    /**
					     * Returns svg representation of an instance
					     * @param {Function} [reviver] Method for further parsing of svg representation.
					     * @return {String} svg representation of an instance
					     */
					    toSVG: function(reviver) {
					      var markup = this._createBaseSVGMarkup(), x = this.left, y = this.top;
					      if (!(this.group && this.group.type === 'path-group')) {
					        x = -this.width / 2;
					        y = -this.height / 2;
					      }
					      markup.push(
					        '<rect ',
					          'x="', x, '" y="', y,
					          '" rx="', this.get('rx'), '" ry="', this.get('ry'),
					          '" width="', this.width, '" height="', this.height,
					          '" style="', this.getSvgStyles(),
					          '" transform="', this.getSvgTransform(),
					          this.getSvgTransformMatrix(),
					        '"/>\n');
					
					      return reviver ? reviver(markup.join('')) : markup.join('');
					    },
					    /* _TO_SVG_END_ */
					
					    /**
					     * Returns complexity of an instance
					     * @return {Number} complexity
					     */
					    complexity: function() {
					      return 1;
					    }
					  });
					
					  /* _FROM_SVG_START_ */
					  /**
					   * List of attribute names to account for when parsing SVG element (used by `fabric.Rect.fromElement`)
					   * @static
					   * @memberOf fabric.Rect
					   * @see: http://www.w3.org/TR/SVG/shapes.html#RectElement
					   */
					  fabric.Rect.ATTRIBUTE_NAMES = fabric.SHARED_ATTRIBUTES.concat('x y rx ry width height'.split(' '));
					
					  /**
					   * Returns {@link fabric.Rect} instance from an SVG element
					   * @static
					   * @memberOf fabric.Rect
					   * @param {SVGElement} element Element to parse
					   * @param {Object} [options] Options object
					   * @return {fabric.Rect} Instance of fabric.Rect
					   */
					  fabric.Rect.fromElement = function(element, options) {
					    if (!element) {
					      return null;
					    }
					    options = options || { };
					
					    var parsedAttributes = fabric.parseAttributes(element, fabric.Rect.ATTRIBUTE_NAMES);
					
					    parsedAttributes.left = parsedAttributes.left || 0;
					    parsedAttributes.top  = parsedAttributes.top  || 0;
					    var rect = new fabric.Rect(extend((options ? fabric.util.object.clone(options) : { }), parsedAttributes));
					    rect.visible = rect.width > 0 && rect.height > 0;
					    return rect;
					  };
					  /* _FROM_SVG_END_ */
					
					  /**
					   * Returns {@link fabric.Rect} instance from an object representation
					   * @static
					   * @memberOf fabric.Rect
					   * @param {Object} object Object to create an instance from
					   * @return {Object} instance of fabric.Rect
					   */
					  fabric.Rect.fromObject = function(object) {
					    return new fabric.Rect(object);
					  };
					
					})(typeof exports !== 'undefined' ? exports : this);
					(function(global) {
					
					  'use strict';
					
					  var fabric = global.fabric || (global.fabric = { });
					
					  if (fabric.Polyline) {
					    fabric.warn('fabric.Polyline is already defined');
					    return;
					  }
					
					  /**
					   * Polyline class
					   * @class fabric.Polyline
					   * @extends fabric.Object
					   * @see {@link fabric.Polyline#initialize} for constructor definition
					   */
					  fabric.Polyline = fabric.util.createClass(fabric.Object, /** @lends fabric.Polyline.prototype */ {
					
					    /**
					     * Type of an object
					     * @type String
					     * @default
					     */
					    type: 'polyline',
					
					    /**
					     * Points array
					     * @type Array
					     * @default
					     */
					    points: null,
					
					    /**
					     * Minimum X from points values, necessary to offset points
					     * @type Number
					     * @default
					     */
					    minX: 0,
					
					    /**
					     * Minimum Y from points values, necessary to offset points
					     * @type Number
					     * @default
					     */
					    minY: 0,
					
					    /**
					     * Constructor
					     * @param {Array} points Array of points (where each point is an object with x and y)
					     * @param {Object} [options] Options object
					     * @param {Boolean} [skipOffset] Whether points offsetting should be skipped
					     * @return {fabric.Polyline} thisArg
					     * @example
					     * var poly = new fabric.Polyline([
					     *     { x: 10, y: 10 },
					     *     { x: 50, y: 30 },
					     *     { x: 40, y: 70 },
					     *     { x: 60, y: 50 },
					     *     { x: 100, y: 150 },
					     *     { x: 40, y: 100 }
					     *   ], {
					     *   stroke: 'red',
					     *   left: 100,
					     *   top: 100
					     * });
					     */
					    initialize: function(points, options) {
					      return fabric.Polygon.prototype.initialize.call(this, points, options);
					    },
					
					    /**
					     * @private
					     */
					    _calcDimensions: function() {
					      return fabric.Polygon.prototype._calcDimensions.call(this);
					    },
					
					    /**
					     * @private
					     */
					    _applyPointOffset: function() {
					      return fabric.Polygon.prototype._applyPointOffset.call(this);
					    },
					
					    /**
					     * Returns object representation of an instance
					     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output
					     * @return {Object} Object representation of an instance
					     */
					    toObject: function(propertiesToInclude) {
					      return fabric.Polygon.prototype.toObject.call(this, propertiesToInclude);
					    },
					
					    /* _TO_SVG_START_ */
					    /**
					     * Returns SVG representation of an instance
					     * @param {Function} [reviver] Method for further parsing of svg representation.
					     * @return {String} svg representation of an instance
					     */
					    toSVG: function(reviver) {
					      return fabric.Polygon.prototype.toSVG.call(this, reviver);
					    },
					    /* _TO_SVG_END_ */
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     */
					    _render: function(ctx) {
					      if (!fabric.Polygon.prototype.commonRender.call(this, ctx)) {
					        return;
					      }
					      this._renderFill(ctx);
					      this._renderStroke(ctx);
					    },
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     */
					    _renderDashedStroke: function(ctx) {
					      var p1, p2;
					
					      ctx.beginPath();
					      for (var i = 0, len = this.points.length; i < len; i++) {
					        p1 = this.points[i];
					        p2 = this.points[i + 1] || p1;
					        fabric.util.drawDashedLine(ctx, p1.x, p1.y, p2.x, p2.y, this.strokeDashArray);
					      }
					    },
					
					    /**
					     * Returns complexity of an instance
					     * @return {Number} complexity of this instance
					     */
					    complexity: function() {
					      return this.get('points').length;
					    }
					  });
					
					  /* _FROM_SVG_START_ */
					  /**
					   * List of attribute names to account for when parsing SVG element (used by {@link fabric.Polyline.fromElement})
					   * @static
					   * @memberOf fabric.Polyline
					   * @see: http://www.w3.org/TR/SVG/shapes.html#PolylineElement
					   */
					  fabric.Polyline.ATTRIBUTE_NAMES = fabric.SHARED_ATTRIBUTES.concat();
					
					  /**
					   * Returns fabric.Polyline instance from an SVG element
					   * @static
					   * @memberOf fabric.Polyline
					   * @param {SVGElement} element Element to parse
					   * @param {Object} [options] Options object
					   * @return {fabric.Polyline} Instance of fabric.Polyline
					   */
					  fabric.Polyline.fromElement = function(element, options) {
					    if (!element) {
					      return null;
					    }
					    options || (options = { });
					
					    var points = fabric.parsePointsAttribute(element.getAttribute('points')),
					        parsedAttributes = fabric.parseAttributes(element, fabric.Polyline.ATTRIBUTE_NAMES);
					
					    return new fabric.Polyline(points, fabric.util.object.extend(parsedAttributes, options));
					  };
					  /* _FROM_SVG_END_ */
					
					  /**
					   * Returns fabric.Polyline instance from an object representation
					   * @static
					   * @memberOf fabric.Polyline
					   * @param {Object} object Object to create an instance from
					   * @return {fabric.Polyline} Instance of fabric.Polyline
					   */
					  fabric.Polyline.fromObject = function(object) {
					    var points = object.points;
					    return new fabric.Polyline(points, object, true);
					  };
					
					})(typeof exports !== 'undefined' ? exports : this);
					(function(global) {
					
					  'use strict';
					
					  var fabric = global.fabric || (global.fabric = { }),
					      extend = fabric.util.object.extend,
					      min = fabric.util.array.min,
					      max = fabric.util.array.max,
					      toFixed = fabric.util.toFixed;
					
					  if (fabric.Polygon) {
					    fabric.warn('fabric.Polygon is already defined');
					    return;
					  }
					
					  /**
					   * Polygon class
					   * @class fabric.Polygon
					   * @extends fabric.Object
					   * @see {@link fabric.Polygon#initialize} for constructor definition
					   */
					  fabric.Polygon = fabric.util.createClass(fabric.Object, /** @lends fabric.Polygon.prototype */ {
					
					    /**
					     * Type of an object
					     * @type String
					     * @default
					     */
					    type: 'polygon',
					
					    /**
					     * Points array
					     * @type Array
					     * @default
					     */
					    points: null,
					
					    /**
					     * Minimum X from points values, necessary to offset points
					     * @type Number
					     * @default
					     */
					    minX: 0,
					
					    /**
					     * Minimum Y from points values, necessary to offset points
					     * @type Number
					     * @default
					     */
					    minY: 0,
					
					    /**
					     * Constructor
					     * @param {Array} points Array of points
					     * @param {Object} [options] Options object
					     * @return {fabric.Polygon} thisArg
					     */
					    initialize: function(points, options) {
					      options = options || { };
					      this.points = points || [ ];
					      this.callSuper('initialize', options);
					      this._calcDimensions();
					      if (!('top' in options)) {
					        this.top = this.minY;
					      }
					      if (!('left' in options)) {
					        this.left = this.minX;
					      }
					    },
					
					    /**
					     * @private
					     */
					    _calcDimensions: function() {
					
					      var points = this.points,
					          minX = min(points, 'x'),
					          minY = min(points, 'y'),
					          maxX = max(points, 'x'),
					          maxY = max(points, 'y');
					
					      this.width = (maxX - minX) || 0;
					      this.height = (maxY - minY) || 0;
					
					      this.minX = minX || 0,
					      this.minY = minY || 0;
					    },
					
					    /**
					     * @private
					     */
					    _applyPointOffset: function() {
					      // change points to offset polygon into a bounding box
					      // executed one time
					      this.points.forEach(function(p) {
					        p.x -= (this.minX + this.width / 2);
					        p.y -= (this.minY + this.height / 2);
					      }, this);
					    },
					
					    /**
					     * Returns object representation of an instance
					     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output
					     * @return {Object} Object representation of an instance
					     */
					    toObject: function(propertiesToInclude) {
					      return extend(this.callSuper('toObject', propertiesToInclude), {
					        points: this.points.concat()
					      });
					    },
					
					    /* _TO_SVG_START_ */
					    /**
					     * Returns svg representation of an instance
					     * @param {Function} [reviver] Method for further parsing of svg representation.
					     * @return {String} svg representation of an instance
					     */
					    toSVG: function(reviver) {
					      var points = [],
					          markup = this._createBaseSVGMarkup();
					
					      for (var i = 0, len = this.points.length; i < len; i++) {
					        points.push(toFixed(this.points[i].x, 2), ',', toFixed(this.points[i].y, 2), ' ');
					      }
					
					      markup.push(
					        '<', this.type, ' ',
					          'points="', points.join(''),
					          '" style="', this.getSvgStyles(),
					          '" transform="', this.getSvgTransform(),
					          ' ', this.getSvgTransformMatrix(),
					        '"/>\n'
					      );
					
					      return reviver ? reviver(markup.join('')) : markup.join('');
					    },
					    /* _TO_SVG_END_ */
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     */
					    _render: function(ctx) {
					      if (!this.commonRender(ctx)) {
					        return;
					      }
					      this._renderFill(ctx);
					      if (this.stroke || this.strokeDashArray) {
					        ctx.closePath();
					        this._renderStroke(ctx);
					      }
					    },
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     */
					    commonRender: function(ctx) {
					      var point, len = this.points.length;
					
					      if (!len || isNaN(this.points[len - 1].y)) {
					        // do not draw if no points or odd points
					        // NaN comes from parseFloat of a empty string in parser
					        return false;
					      }
					
					      ctx.beginPath();
					
					      if (this._applyPointOffset) {
					        if (!(this.group && this.group.type === 'path-group')) {
					          this._applyPointOffset();
					        }
					        this._applyPointOffset = null;
					      }
					
					      ctx.moveTo(this.points[0].x, this.points[0].y);
					      for (var i = 0; i < len; i++) {
					        point = this.points[i];
					        ctx.lineTo(point.x, point.y);
					      }
					      return true;
					    },
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     */
					    _renderDashedStroke: function(ctx) {
					      fabric.Polyline.prototype._renderDashedStroke.call(this, ctx);
					      ctx.closePath();
					    },
					
					    /**
					     * Returns complexity of an instance
					     * @return {Number} complexity of this instance
					     */
					    complexity: function() {
					      return this.points.length;
					    }
					  });
					
					  /* _FROM_SVG_START_ */
					  /**
					   * List of attribute names to account for when parsing SVG element (used by `fabric.Polygon.fromElement`)
					   * @static
					   * @memberOf fabric.Polygon
					   * @see: http://www.w3.org/TR/SVG/shapes.html#PolygonElement
					   */
					  fabric.Polygon.ATTRIBUTE_NAMES = fabric.SHARED_ATTRIBUTES.concat();
					
					  /**
					   * Returns {@link fabric.Polygon} instance from an SVG element
					   * @static
					   * @memberOf fabric.Polygon
					   * @param {SVGElement} element Element to parse
					   * @param {Object} [options] Options object
					   * @return {fabric.Polygon} Instance of fabric.Polygon
					   */
					  fabric.Polygon.fromElement = function(element, options) {
					    if (!element) {
					      return null;
					    }
					
					    options || (options = { });
					
					    var points = fabric.parsePointsAttribute(element.getAttribute('points')),
					        parsedAttributes = fabric.parseAttributes(element, fabric.Polygon.ATTRIBUTE_NAMES);
					
					    return new fabric.Polygon(points, extend(parsedAttributes, options));
					  };
					  /* _FROM_SVG_END_ */
					
					  /**
					   * Returns fabric.Polygon instance from an object representation
					   * @static
					   * @memberOf fabric.Polygon
					   * @param {Object} object Object to create an instance from
					   * @return {fabric.Polygon} Instance of fabric.Polygon
					   */
					  fabric.Polygon.fromObject = function(object) {
					    return new fabric.Polygon(object.points, object, true);
					  };
					
					})(typeof exports !== 'undefined' ? exports : this);
					(function(global) {
					
					  'use strict';
					
					  var fabric = global.fabric || (global.fabric = { }),
					      min = fabric.util.array.min,
					      max = fabric.util.array.max,
					      extend = fabric.util.object.extend,
					      _toString = Object.prototype.toString,
					      drawArc = fabric.util.drawArc,
					      commandLengths = {
					        m: 2,
					        l: 2,
					        h: 1,
					        v: 1,
					        c: 6,
					        s: 4,
					        q: 4,
					        t: 2,
					        a: 7
					      },
					      repeatedCommands = {
					        m: 'l',
					        M: 'L'
					      };
					
					  if (fabric.Path) {
					    fabric.warn('fabric.Path is already defined');
					    return;
					  }
					
					  /**
					   * Path class
					   * @class fabric.Path
					   * @extends fabric.Object
					   * @tutorial {@link http://fabricjs.com/fabric-intro-part-1/#path_and_pathgroup}
					   * @see {@link fabric.Path#initialize} for constructor definition
					   */
					  fabric.Path = fabric.util.createClass(fabric.Object, /** @lends fabric.Path.prototype */ {
					
					    /**
					     * Type of an object
					     * @type String
					     * @default
					     */
					    type: 'path',
					
					    /**
					     * Array of path points
					     * @type Array
					     * @default
					     */
					    path: null,
					
					    /**
					     * Minimum X from points values, necessary to offset points
					     * @type Number
					     * @default
					     */
					    minX: 0,
					
					    /**
					     * Minimum Y from points values, necessary to offset points
					     * @type Number
					     * @default
					     */
					    minY: 0,
					
					    /**
					     * Constructor
					     * @param {Array|String} path Path data (sequence of coordinates and corresponding "command" tokens)
					     * @param {Object} [options] Options object
					     * @return {fabric.Path} thisArg
					     */
					    initialize: function(path, options) {
					      options = options || { };
					
					      this.setOptions(options);
					
					      if (!path) {
					        throw new Error('`path` argument is required');
					      }
					
					      var fromArray = _toString.call(path) === '[object Array]';
					
					      this.path = fromArray
					        ? path
					        // one of commands (m,M,l,L,q,Q,c,C,etc.) followed by non-command characters (i.e. command values)
					        : path.match && path.match(/[mzlhvcsqta][^mzlhvcsqta]*/gi);
					
					      if (!this.path) {
					        return;
					      }
					
					      if (!fromArray) {
					        this.path = this._parsePath();
					      }
					
					      this._setPositionDimensions();
					
					      if (options.sourcePath) {
					        this.setSourcePath(options.sourcePath);
					      }
					    },
					
					    /**
					     * @private
					     */
					    _setPositionDimensions: function() {
					      var calcDim = this._parseDimensions();
					
					      this.minX = calcDim.left;
					      this.minY = calcDim.top;
					      this.width = calcDim.width;
					      this.height = calcDim.height;
					
					      calcDim.left += this.originX === 'center'
					        ? this.width / 2
					        : this.originX === 'right'
					          ? this.width
					          : 0;
					
					      calcDim.top += this.originY === 'center'
					        ? this.height / 2
					        : this.originY === 'bottom'
					          ? this.height
					          : 0;
					
					      this.top = this.top || calcDim.top;
					      this.left = this.left || calcDim.left;
					
					      this.pathOffset = this.pathOffset || {
					        x: this.minX + this.width / 2,
					        y: this.minY + this.height / 2
					      };
					    },
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx context to render path on
					     */
					    _render: function(ctx) {
					      var current, // current instruction
					          previous = null,
					          subpathStartX = 0,
					          subpathStartY = 0,
					          x = 0, // current x
					          y = 0, // current y
					          controlX = 0, // current control point x
					          controlY = 0, // current control point y
					          tempX,
					          tempY,
					          l = -this.pathOffset.x,
					          t = -this.pathOffset.y;
					
					      if (this.group && this.group.type === 'path-group') {
					        l = 0;
					        t = 0;
					      }
					
					      ctx.beginPath();
					
					      for (var i = 0, len = this.path.length; i < len; ++i) {
					
					        current = this.path[i];
					
					        switch (current[0]) { // first letter
					
					          case 'l': // lineto, relative
					            x += current[1];
					            y += current[2];
					            ctx.lineTo(x + l, y + t);
					            break;
					
					          case 'L': // lineto, absolute
					            x = current[1];
					            y = current[2];
					            ctx.lineTo(x + l, y + t);
					            break;
					
					          case 'h': // horizontal lineto, relative
					            x += current[1];
					            ctx.lineTo(x + l, y + t);
					            break;
					
					          case 'H': // horizontal lineto, absolute
					            x = current[1];
					            ctx.lineTo(x + l, y + t);
					            break;
					
					          case 'v': // vertical lineto, relative
					            y += current[1];
					            ctx.lineTo(x + l, y + t);
					            break;
					
					          case 'V': // verical lineto, absolute
					            y = current[1];
					            ctx.lineTo(x + l, y + t);
					            break;
					
					          case 'm': // moveTo, relative
					            x += current[1];
					            y += current[2];
					            subpathStartX = x;
					            subpathStartY = y;
					            ctx.moveTo(x + l, y + t);
					            break;
					
					          case 'M': // moveTo, absolute
					            x = current[1];
					            y = current[2];
					            subpathStartX = x;
					            subpathStartY = y;
					            ctx.moveTo(x + l, y + t);
					            break;
					
					          case 'c': // bezierCurveTo, relative
					            tempX = x + current[5];
					            tempY = y + current[6];
					            controlX = x + current[3];
					            controlY = y + current[4];
					            ctx.bezierCurveTo(
					              x + current[1] + l, // x1
					              y + current[2] + t, // y1
					              controlX + l, // x2
					              controlY + t, // y2
					              tempX + l,
					              tempY + t
					            );
					            x = tempX;
					            y = tempY;
					            break;
					
					          case 'C': // bezierCurveTo, absolute
					            x = current[5];
					            y = current[6];
					            controlX = current[3];
					            controlY = current[4];
					            ctx.bezierCurveTo(
					              current[1] + l,
					              current[2] + t,
					              controlX + l,
					              controlY + t,
					              x + l,
					              y + t
					            );
					            break;
					
					          case 's': // shorthand cubic bezierCurveTo, relative
					
					            // transform to absolute x,y
					            tempX = x + current[3];
					            tempY = y + current[4];
					
					            if (previous[0].match(/[CcSs]/) === null) {
					              // If there is no previous command or if the previous command was not a C, c, S, or s,
					              // the control point is coincident with the current point
					              controlX = x;
					              controlY = y;
					            }
					            else {
					              // calculate reflection of previous control points
					              controlX = 2 * x - controlX;
					              controlY = 2 * y - controlY;
					            }
					
					            ctx.bezierCurveTo(
					              controlX + l,
					              controlY + t,
					              x + current[1] + l,
					              y + current[2] + t,
					              tempX + l,
					              tempY + t
					            );
					            // set control point to 2nd one of this command
					            // "... the first control point is assumed to be
					            // the reflection of the second control point on
					            // the previous command relative to the current point."
					            controlX = x + current[1];
					            controlY = y + current[2];
					
					            x = tempX;
					            y = tempY;
					            break;
					
					          case 'S': // shorthand cubic bezierCurveTo, absolute
					            tempX = current[3];
					            tempY = current[4];
					            if (previous[0].match(/[CcSs]/) === null) {
					              // If there is no previous command or if the previous command was not a C, c, S, or s,
					              // the control point is coincident with the current point
					              controlX = x;
					              controlY = y;
					            }
					            else {
					              // calculate reflection of previous control points
					              controlX = 2 * x - controlX;
					              controlY = 2 * y - controlY;
					            }
					            ctx.bezierCurveTo(
					              controlX + l,
					              controlY + t,
					              current[1] + l,
					              current[2] + t,
					              tempX + l,
					              tempY + t
					            );
					            x = tempX;
					            y = tempY;
					
					            // set control point to 2nd one of this command
					            // "... the first control point is assumed to be
					            // the reflection of the second control point on
					            // the previous command relative to the current point."
					            controlX = current[1];
					            controlY = current[2];
					
					            break;
					
					          case 'q': // quadraticCurveTo, relative
					            // transform to absolute x,y
					            tempX = x + current[3];
					            tempY = y + current[4];
					
					            controlX = x + current[1];
					            controlY = y + current[2];
					
					            ctx.quadraticCurveTo(
					              controlX + l,
					              controlY + t,
					              tempX + l,
					              tempY + t
					            );
					            x = tempX;
					            y = tempY;
					            break;
					
					          case 'Q': // quadraticCurveTo, absolute
					            tempX = current[3];
					            tempY = current[4];
					
					            ctx.quadraticCurveTo(
					              current[1] + l,
					              current[2] + t,
					              tempX + l,
					              tempY + t
					            );
					            x = tempX;
					            y = tempY;
					            controlX = current[1];
					            controlY = current[2];
					            break;
					
					          case 't': // shorthand quadraticCurveTo, relative
					
					            // transform to absolute x,y
					            tempX = x + current[1];
					            tempY = y + current[2];
					
					            if (previous[0].match(/[QqTt]/) === null) {
					              // If there is no previous command or if the previous command was not a Q, q, T or t,
					              // assume the control point is coincident with the current point
					              controlX = x;
					              controlY = y;
					            }
					            else {
					              // calculate reflection of previous control point
					              controlX = 2 * x - controlX;
					              controlY = 2 * y - controlY;
					            }
					
					            ctx.quadraticCurveTo(
					              controlX + l,
					              controlY + t,
					              tempX + l,
					              tempY + t
					            );
					            x = tempX;
					            y = tempY;
					
					            break;
					
					          case 'T':
					            tempX = current[1];
					            tempY = current[2];
					
					            if (previous[0].match(/[QqTt]/) === null) {
					              // If there is no previous command or if the previous command was not a Q, q, T or t,
					              // assume the control point is coincident with the current point
					              controlX = x;
					              controlY = y;
					            }
					            else {
					              // calculate reflection of previous control point
					              controlX = 2 * x - controlX;
					              controlY = 2 * y - controlY;
					            }
					            ctx.quadraticCurveTo(
					              controlX + l,
					              controlY + t,
					              tempX + l,
					              tempY + t
					            );
					            x = tempX;
					            y = tempY;
					            break;
					
					          case 'a':
					            // TODO: optimize this
					            drawArc(ctx, x + l, y + t, [
					              current[1],
					              current[2],
					              current[3],
					              current[4],
					              current[5],
					              current[6] + x + l,
					              current[7] + y + t
					            ]);
					            x += current[6];
					            y += current[7];
					            break;
					
					          case 'A':
					            // TODO: optimize this
					            drawArc(ctx, x + l, y + t, [
					              current[1],
					              current[2],
					              current[3],
					              current[4],
					              current[5],
					              current[6] + l,
					              current[7] + t
					            ]);
					            x = current[6];
					            y = current[7];
					            break;
					
					          case 'z':
					          case 'Z':
					            x = subpathStartX;
					            y = subpathStartY;
					            ctx.closePath();
					            break;
					        }
					        previous = current;
					      }
					      this._renderFill(ctx);
					      this._renderStroke(ctx);
					    },
					
					    /**
					     * Returns string representation of an instance
					     * @return {String} string representation of an instance
					     */
					    toString: function() {
					      return '#<fabric.Path (' + this.complexity() +
					        '): { "top": ' + this.top + ', "left": ' + this.left + ' }>';
					    },
					
					    /**
					     * Returns object representation of an instance
					     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output
					     * @return {Object} object representation of an instance
					     */
					    toObject: function(propertiesToInclude) {
					      var o = extend(this.callSuper('toObject', propertiesToInclude), {
					        path: this.path.map(function(item) { return item.slice() }),
					        pathOffset: this.pathOffset
					      });
					      if (this.sourcePath) {
					        o.sourcePath = this.sourcePath;
					      }
					      if (this.transformMatrix) {
					        o.transformMatrix = this.transformMatrix;
					      }
					      return o;
					    },
					
					    /**
					     * Returns dataless object representation of an instance
					     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output
					     * @return {Object} object representation of an instance
					     */
					    toDatalessObject: function(propertiesToInclude) {
					      var o = this.toObject(propertiesToInclude);
					      if (this.sourcePath) {
					        o.path = this.sourcePath;
					      }
					      delete o.sourcePath;
					      return o;
					    },
					
					    /* _TO_SVG_START_ */
					    /**
					     * Returns svg representation of an instance
					     * @param {Function} [reviver] Method for further parsing of svg representation.
					     * @return {String} svg representation of an instance
					     */
					    toSVG: function(reviver) {
					      var chunks = [],
					          markup = this._createBaseSVGMarkup(), addTransform = '';
					
					      for (var i = 0, len = this.path.length; i < len; i++) {
					        chunks.push(this.path[i].join(' '));
					      }
					      var path = chunks.join(' ');
					      if (!(this.group && this.group.type === 'path-group')) {
					        addTransform = ' translate(' + (-this.pathOffset.x) + ', ' + (-this.pathOffset.y) + ') ';
					      }
					      markup.push(
					        //jscs:disable validateIndentation
					        '<path ',
					          'd="', path,
					          '" style="', this.getSvgStyles(),
					          '" transform="', this.getSvgTransform(), addTransform,
					          this.getSvgTransformMatrix(), '" stroke-linecap="round" ',
					        '/>\n'
					        //jscs:enable validateIndentation
					      );
					
					      return reviver ? reviver(markup.join('')) : markup.join('');
					    },
					    /* _TO_SVG_END_ */
					
					    /**
					     * Returns number representation of an instance complexity
					     * @return {Number} complexity of this instance
					     */
					    complexity: function() {
					      return this.path.length;
					    },
					
					    /**
					     * @private
					     */
					    _parsePath: function() {
					      var result = [ ],
					          coords = [ ],
					          currentPath,
					          parsed,
					          re = /([-+]?((\d+\.\d+)|((\d+)|(\.\d+)))(?:e[-+]?\d+)?)/ig,
					          match,
					          coordsStr;
					
					      for (var i = 0, coordsParsed, len = this.path.length; i < len; i++) {
					        currentPath = this.path[i];
					
					        coordsStr = currentPath.slice(1).trim();
					        coords.length = 0;
					
					        while ((match = re.exec(coordsStr))) {
					          coords.push(match[0]);
					        }
					
					        coordsParsed = [ currentPath.charAt(0) ];
					
					        for (var j = 0, jlen = coords.length; j < jlen; j++) {
					          parsed = parseFloat(coords[j]);
					          if (!isNaN(parsed)) {
					            coordsParsed.push(parsed);
					          }
					        }
					
					        var command = coordsParsed[0],
					            commandLength = commandLengths[command.toLowerCase()],
					            repeatedCommand = repeatedCommands[command] || command;
					
					        if (coordsParsed.length - 1 > commandLength) {
					          for (var k = 1, klen = coordsParsed.length; k < klen; k += commandLength) {
					            result.push([ command ].concat(coordsParsed.slice(k, k + commandLength)));
					            command = repeatedCommand;
					          }
					        }
					        else {
					          result.push(coordsParsed);
					        }
					      }
					
					      return result;
					    },
					
					    /**
					     * @private
					     */
					    _parseDimensions: function() {
					
					      var aX = [],
					          aY = [],
					          current, // current instruction
					          previous = null,
					          subpathStartX = 0,
					          subpathStartY = 0,
					          x = 0, // current x
					          y = 0, // current y
					          controlX = 0, // current control point x
					          controlY = 0, // current control point y
					          tempX,
					          tempY,
					          bounds;
					
					      for (var i = 0, len = this.path.length; i < len; ++i) {
					
					        current = this.path[i];
					
					        switch (current[0]) { // first letter
					
					          case 'l': // lineto, relative
					            x += current[1];
					            y += current[2];
					            bounds = [ ];
					            break;
					
					          case 'L': // lineto, absolute
					            x = current[1];
					            y = current[2];
					            bounds = [ ];
					            break;
					
					          case 'h': // horizontal lineto, relative
					            x += current[1];
					            bounds = [ ];
					            break;
					
					          case 'H': // horizontal lineto, absolute
					            x = current[1];
					            bounds = [ ];
					            break;
					
					          case 'v': // vertical lineto, relative
					            y += current[1];
					            bounds = [ ];
					            break;
					
					          case 'V': // verical lineto, absolute
					            y = current[1];
					            bounds = [ ];
					            break;
					
					          case 'm': // moveTo, relative
					            x += current[1];
					            y += current[2];
					            subpathStartX = x;
					            subpathStartY = y;
					            bounds = [ ];
					            break;
					
					          case 'M': // moveTo, absolute
					            x = current[1];
					            y = current[2];
					            subpathStartX = x;
					            subpathStartY = y;
					            bounds = [ ];
					            break;
					
					          case 'c': // bezierCurveTo, relative
					            tempX = x + current[5];
					            tempY = y + current[6];
					            controlX = x + current[3];
					            controlY = y + current[4];
					            bounds = fabric.util.getBoundsOfCurve(x, y,
					              x + current[1], // x1
					              y + current[2], // y1
					              controlX, // x2
					              controlY, // y2
					              tempX,
					              tempY
					            );
					            x = tempX;
					            y = tempY;
					            break;
					
					          case 'C': // bezierCurveTo, absolute
					            x = current[5];
					            y = current[6];
					            controlX = current[3];
					            controlY = current[4];
					            bounds = fabric.util.getBoundsOfCurve(x, y,
					              current[1],
					              current[2],
					              controlX,
					              controlY,
					              x,
					              y
					            );
					            break;
					
					          case 's': // shorthand cubic bezierCurveTo, relative
					
					            // transform to absolute x,y
					            tempX = x + current[3];
					            tempY = y + current[4];
					
					            if (previous[0].match(/[CcSs]/) === null) {
					              // If there is no previous command or if the previous command was not a C, c, S, or s,
					              // the control point is coincident with the current point
					              controlX = x;
					              controlY = y;
					            }
					            else {
					              // calculate reflection of previous control points
					              controlX = 2 * x - controlX;
					              controlY = 2 * y - controlY;
					            }
					
					            bounds = fabric.util.getBoundsOfCurve(x, y,
					              controlX,
					              controlY,
					              x + current[1],
					              y + current[2],
					              tempX,
					              tempY
					            );
					            // set control point to 2nd one of this command
					            // "... the first control point is assumed to be
					            // the reflection of the second control point on
					            // the previous command relative to the current point."
					            controlX = x + current[1];
					            controlY = y + current[2];
					            x = tempX;
					            y = tempY;
					            break;
					
					          case 'S': // shorthand cubic bezierCurveTo, absolute
					            tempX = current[3];
					            tempY = current[4];
					            if (previous[0].match(/[CcSs]/) === null) {
					              // If there is no previous command or if the previous command was not a C, c, S, or s,
					              // the control point is coincident with the current point
					              controlX = x;
					              controlY = y;
					            }
					            else {
					              // calculate reflection of previous control points
					              controlX = 2 * x - controlX;
					              controlY = 2 * y - controlY;
					            }
					            bounds = fabric.util.getBoundsOfCurve(x, y,
					              controlX,
					              controlY,
					              current[1],
					              current[2],
					              tempX,
					              tempY
					            );
					            x = tempX;
					            y = tempY;
					            // set control point to 2nd one of this command
					            // "... the first control point is assumed to be
					            // the reflection of the second control point on
					            // the previous command relative to the current point."
					            controlX = current[1];
					            controlY = current[2];
					            break;
					
					          case 'q': // quadraticCurveTo, relative
					            // transform to absolute x,y
					            tempX = x + current[3];
					            tempY = y + current[4];
					            controlX = x + current[1];
					            controlY = y + current[2];
					            bounds = fabric.util.getBoundsOfCurve(x, y,
					              controlX,
					              controlY,
					              controlX,
					              controlY,
					              tempX,
					              tempY
					            );
					            x = tempX;
					            y = tempY;
					            break;
					
					          case 'Q': // quadraticCurveTo, absolute
					            controlX = current[1];
					            controlY = current[2];
					            bounds = fabric.util.getBoundsOfCurve(x, y,
					              controlX,
					              controlY,
					              controlX,
					              controlY,
					              current[3],
					              current[4]
					            );
					            x = current[3];
					            y = current[4];
					            break;
					
					          case 't': // shorthand quadraticCurveTo, relative
					            // transform to absolute x,y
					            tempX = x + current[1];
					            tempY = y + current[2];
					            if (previous[0].match(/[QqTt]/) === null) {
					              // If there is no previous command or if the previous command was not a Q, q, T or t,
					              // assume the control point is coincident with the current point
					              controlX = x;
					              controlY = y;
					            }
					            else {
					              // calculate reflection of previous control point
					              controlX = 2 * x - controlX;
					              controlY = 2 * y - controlY;
					            }
					
					            bounds = fabric.util.getBoundsOfCurve(x, y,
					              controlX,
					              controlY,
					              controlX,
					              controlY,
					              tempX,
					              tempY
					            );
					            x = tempX;
					            y = tempY;
					
					            break;
					
					          case 'T':
					            tempX = current[1];
					            tempY = current[2];
					
					            if (previous[0].match(/[QqTt]/) === null) {
					              // If there is no previous command or if the previous command was not a Q, q, T or t,
					              // assume the control point is coincident with the current point
					              controlX = x;
					              controlY = y;
					            }
					            else {
					              // calculate reflection of previous control point
					              controlX = 2 * x - controlX;
					              controlY = 2 * y - controlY;
					            }
					            bounds = fabric.util.getBoundsOfCurve(x, y,
					              controlX,
					              controlY,
					              controlX,
					              controlY,
					              tempX,
					              tempY
					            );
					            x = tempX;
					            y = tempY;
					            break;
					
					          case 'a':
					            // TODO: optimize this
					            bounds = fabric.util.getBoundsOfArc(x, y,
					              current[1],
					              current[2],
					              current[3],
					              current[4],
					              current[5],
					              current[6] + x,
					              current[7] + y
					            );
					            x += current[6];
					            y += current[7];
					            break;
					
					          case 'A':
					            // TODO: optimize this
					            bounds = fabric.util.getBoundsOfArc(x, y,
					              current[1],
					              current[2],
					              current[3],
					              current[4],
					              current[5],
					              current[6],
					              current[7]
					            );
					            x = current[6];
					            y = current[7];
					            break;
					
					          case 'z':
					          case 'Z':
					            x = subpathStartX;
					            y = subpathStartY;
					            break;
					        }
					        previous = current;
					        bounds.forEach(function (point) {
					          aX.push(point.x);
					          aY.push(point.y);
					        });
					        aX.push(x);
					        aY.push(y);
					      }
					
					      var minX = min(aX),
					          minY = min(aY),
					          maxX = max(aX),
					          maxY = max(aY),
					          deltaX = maxX - minX,
					          deltaY = maxY - minY,
					
					          o = {
					            left: minX,
					            top: minY,
					            width: deltaX,
					            height: deltaY
					          };
					
					      return o;
					    }
					  });
					
					  /**
					   * Creates an instance of fabric.Path from an object
					   * @static
					   * @memberOf fabric.Path
					   * @param {Object} object
					   * @param {Function} callback Callback to invoke when an fabric.Path instance is created
					   */
					  fabric.Path.fromObject = function(object, callback) {
					    if (typeof object.path === 'string') {
					      fabric.loadSVGFromURL(object.path, function (elements) {
					        var path = elements[0],
					            pathUrl = object.path;
					
					        delete object.path;
					
					        fabric.util.object.extend(path, object);
					        path.setSourcePath(pathUrl);
					
					        callback(path);
					      });
					    }
					    else {
					      callback(new fabric.Path(object.path, object));
					    }
					  };
					
					  /* _FROM_SVG_START_ */
					  /**
					   * List of attribute names to account for when parsing SVG element (used by `fabric.Path.fromElement`)
					   * @static
					   * @memberOf fabric.Path
					   * @see http://www.w3.org/TR/SVG/paths.html#PathElement
					   */
					  fabric.Path.ATTRIBUTE_NAMES = fabric.SHARED_ATTRIBUTES.concat(['d']);
					
					  /**
					   * Creates an instance of fabric.Path from an SVG <path> element
					   * @static
					   * @memberOf fabric.Path
					   * @param {SVGElement} element to parse
					   * @param {Function} callback Callback to invoke when an fabric.Path instance is created
					   * @param {Object} [options] Options object
					   */
					  fabric.Path.fromElement = function(element, callback, options) {
					    var parsedAttributes = fabric.parseAttributes(element, fabric.Path.ATTRIBUTE_NAMES);
					    callback && callback(new fabric.Path(parsedAttributes.d, extend(parsedAttributes, options)));
					  };
					  /* _FROM_SVG_END_ */
					
					  /**
					   * Indicates that instances of this type are async
					   * @static
					   * @memberOf fabric.Path
					   * @type Boolean
					   * @default
					   */
					  fabric.Path.async = true;
					
					})(typeof exports !== 'undefined' ? exports : this);
					(function(global) {
					
					  'use strict';
					
					  var fabric = global.fabric || (global.fabric = { }),
					      extend = fabric.util.object.extend,
					      invoke = fabric.util.array.invoke,
					      parentToObject = fabric.Object.prototype.toObject;
					
					  if (fabric.PathGroup) {
					    fabric.warn('fabric.PathGroup is already defined');
					    return;
					  }
					
					  /**
					   * Path group class
					   * @class fabric.PathGroup
					   * @extends fabric.Path
					   * @tutorial {@link http://fabricjs.com/fabric-intro-part-1/#path_and_pathgroup}
					   * @see {@link fabric.PathGroup#initialize} for constructor definition
					   */
					  fabric.PathGroup = fabric.util.createClass(fabric.Path, /** @lends fabric.PathGroup.prototype */ {
					
					    /**
					     * Type of an object
					     * @type String
					     * @default
					     */
					    type: 'path-group',
					
					    /**
					     * Fill value
					     * @type String
					     * @default
					     */
					    fill: '',
					
					    /**
					     * Constructor
					     * @param {Array} paths
					     * @param {Object} [options] Options object
					     * @return {fabric.PathGroup} thisArg
					     */
					    initialize: function(paths, options) {
					
					      options = options || { };
					      this.paths = paths || [ ];
					
					      for (var i = this.paths.length; i--;) {
					        this.paths[i].group = this;
					      }
					
					      if (options.toBeParsed) {
					        this.parseDimensionsFromPaths(options);
					        delete options.toBeParsed;
					      }
					      this.setOptions(options);
					      this.setCoords();
					
					      if (options.sourcePath) {
					        this.setSourcePath(options.sourcePath);
					      }
					    },
					
					    /**
					     * Calculate width and height based on paths contained
					     */
					    parseDimensionsFromPaths: function(options) {
					      var points, p, xC = [ ], yC = [ ], path, height, width,
					          m = this.transformMatrix;
					      for (var j = this.paths.length; j--;) {
					        path = this.paths[j];
					        height = path.height + path.strokeWidth;
					        width = path.width + path.strokeWidth;
					        points = [
					          { x: path.left, y: path.top },
					          { x: path.left + width, y: path.top },
					          { x: path.left, y: path.top + height },
					          { x: path.left + width, y: path.top + height }
					        ];
					        for (var i = 0; i < points.length; i++) {
					          p = points[i];
					          if (m) {
					            p = fabric.util.transformPoint(p, m, false);
					          }
					          xC.push(p.x);
					          yC.push(p.y);
					        }
					      }
					      options.width = Math.max.apply(null, xC);
					      options.height = Math.max.apply(null, yC);
					    },
					
					    /**
					     * Renders this group on a specified context
					     * @param {CanvasRenderingContext2D} ctx Context to render this instance on
					     */
					    render: function(ctx) {
					      // do not render if object is not visible
					      if (!this.visible) {
					        return;
					      }
					
					      ctx.save();
					
					      if (this.transformMatrix) {
					        ctx.transform.apply(ctx, this.transformMatrix);
					      }
					      this.transform(ctx);
					
					      this._setShadow(ctx);
					      this.clipTo && fabric.util.clipContext(this, ctx);
					      ctx.translate(-this.width/2, -this.height/2);
					      for (var i = 0, l = this.paths.length; i < l; ++i) {
					        this.paths[i].render(ctx, true);
					      }
					      this.clipTo && ctx.restore();
					      this._removeShadow(ctx);
					      ctx.restore();
					    },
					
					    /**
					     * Sets certain property to a certain value
					     * @param {String} prop
					     * @param {Any} value
					     * @return {fabric.PathGroup} thisArg
					     */
					    _set: function(prop, value) {
					
					      if (prop === 'fill' && value && this.isSameColor()) {
					        var i = this.paths.length;
					        while (i--) {
					          this.paths[i]._set(prop, value);
					        }
					      }
					
					      return this.callSuper('_set', prop, value);
					    },
					
					    /**
					     * Returns object representation of this path group
					     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output
					     * @return {Object} object representation of an instance
					     */
					    toObject: function(propertiesToInclude) {
					      var o = extend(parentToObject.call(this, propertiesToInclude), {
					        paths: invoke(this.getObjects(), 'toObject', propertiesToInclude)
					      });
					      if (this.sourcePath) {
					        o.sourcePath = this.sourcePath;
					      }
					      return o;
					    },
					
					    /**
					     * Returns dataless object representation of this path group
					     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output
					     * @return {Object} dataless object representation of an instance
					     */
					    toDatalessObject: function(propertiesToInclude) {
					      var o = this.toObject(propertiesToInclude);
					      if (this.sourcePath) {
					        o.paths = this.sourcePath;
					      }
					      return o;
					    },
					
					    /* _TO_SVG_START_ */
					    /**
					     * Returns svg representation of an instance
					     * @param {Function} [reviver] Method for further parsing of svg representation.
					     * @return {String} svg representation of an instance
					     */
					    toSVG: function(reviver) {
					      var objects = this.getObjects(),
					          p = this.getPointByOrigin('left', 'top'),
					          translatePart = 'translate(' + p.x + ' ' + p.y + ')',
					          markup = [
					            //jscs:disable validateIndentation
					            '<g ',
					              'style="', this.getSvgStyles(), '" ',
					              'transform="', this.getSvgTransformMatrix(), translatePart, this.getSvgTransform(), '" ',
					            '>\n'
					            //jscs:enable validateIndentation
					          ];
					
					      for (var i = 0, len = objects.length; i < len; i++) {
					        markup.push(objects[i].toSVG(reviver));
					      }
					      markup.push('</g>\n');
					
					      return reviver ? reviver(markup.join('')) : markup.join('');
					    },
					    /* _TO_SVG_END_ */
					
					    /**
					     * Returns a string representation of this path group
					     * @return {String} string representation of an object
					     */
					    toString: function() {
					      return '#<fabric.PathGroup (' + this.complexity() +
					        '): { top: ' + this.top + ', left: ' + this.left + ' }>';
					    },
					
					    /**
					     * Returns true if all paths in this group are of same color
					     * @return {Boolean} true if all paths are of the same color (`fill`)
					     */
					    isSameColor: function() {
					      var firstPathFill = (this.getObjects()[0].get('fill') || '').toLowerCase();
					      return this.getObjects().every(function(path) {
					        return (path.get('fill') || '').toLowerCase() === firstPathFill;
					      });
					    },
					
					    /**
					     * Returns number representation of object's complexity
					     * @return {Number} complexity
					     */
					    complexity: function() {
					      return this.paths.reduce(function(total, path) {
					        return total + ((path && path.complexity) ? path.complexity() : 0);
					      }, 0);
					    },
					
					    /**
					     * Returns all paths in this path group
					     * @return {Array} array of path objects included in this path group
					     */
					    getObjects: function() {
					      return this.paths;
					    }
					  });
					
					  /**
					   * Creates fabric.PathGroup instance from an object representation
					   * @static
					   * @memberOf fabric.PathGroup
					   * @param {Object} object Object to create an instance from
					   * @param {Function} callback Callback to invoke when an fabric.PathGroup instance is created
					   */
					  fabric.PathGroup.fromObject = function(object, callback) {
					    if (typeof object.paths === 'string') {
					      fabric.loadSVGFromURL(object.paths, function (elements) {
					
					        var pathUrl = object.paths;
					        delete object.paths;
					
					        var pathGroup = fabric.util.groupSVGElements(elements, object, pathUrl);
					
					        callback(pathGroup);
					      });
					    }
					    else {
					      fabric.util.enlivenObjects(object.paths, function(enlivenedObjects) {
					        delete object.paths;
					        callback(new fabric.PathGroup(enlivenedObjects, object));
					      });
					    }
					  };
					
					  /**
					   * Indicates that instances of this type are async
					   * @static
					   * @memberOf fabric.PathGroup
					   * @type Boolean
					   * @default
					   */
					  fabric.PathGroup.async = true;
					
					})(typeof exports !== 'undefined' ? exports : this);
					(function(global) {
					
					  'use strict';
					
					  var fabric = global.fabric || (global.fabric = { }),
					      extend = fabric.util.object.extend,
					      min = fabric.util.array.min,
					      max = fabric.util.array.max,
					      invoke = fabric.util.array.invoke;
					
					  if (fabric.Group) {
					    return;
					  }
					
					  // lock-related properties, for use in fabric.Group#get
					  // to enable locking behavior on group
					  // when one of its objects has lock-related properties set
					  var _lockProperties = {
					    lockMovementX:  true,
					    lockMovementY:  true,
					    lockRotation:   true,
					    lockScalingX:   true,
					    lockScalingY:   true,
					    lockUniScaling: true
					  };
					
					  /**
					   * Group class
					   * @class fabric.Group
					   * @extends fabric.Object
					   * @mixes fabric.Collection
					   * @tutorial {@link http://fabricjs.com/fabric-intro-part-3/#groups}
					   * @see {@link fabric.Group#initialize} for constructor definition
					   */
					  fabric.Group = fabric.util.createClass(fabric.Object, fabric.Collection, /** @lends fabric.Group.prototype */ {
					
					    /**
					     * Type of an object
					     * @type String
					     * @default
					     */
					    type: 'group',
					
					    /**
					     * Constructor
					     * @param {Object} objects Group objects
					     * @param {Object} [options] Options object
					     * @return {Object} thisArg
					     */
					    initialize: function(objects, options) {
					      options = options || { };
					
					      this._objects = objects || [];
					      for (var i = this._objects.length; i--; ) {
					        this._objects[i].group = this;
					      }
					
					      this.originalState = { };
					      this.callSuper('initialize');
					
					      if (options.originX) {
					        this.originX = options.originX;
					      }
					
					      if (options.originY) {
					        this.originY = options.originY;
					      }
					
					      this._calcBounds();
					      this._updateObjectsCoords();
					
					      this.callSuper('initialize', options);
					
					      this.setCoords();
					      this.saveCoords();
					    },
					
					    /**
					     * @private
					     */
					    _updateObjectsCoords: function() {
					      this.forEachObject(this._updateObjectCoords, this);
					    },
					
					    /**
					     * @private
					     */
					    _updateObjectCoords: function(object) {
					      var objectLeft = object.getLeft(),
					          objectTop = object.getTop(),
					          center = this.getCenterPoint();
					
					      object.set({
					        originalLeft: objectLeft,
					        originalTop: objectTop,
					        left: objectLeft - center.x,
					        top: objectTop - center.y
					      });
					
					      object.setCoords();
					
					      // do not display corners of objects enclosed in a group
					      object.__origHasControls = object.hasControls;
					      object.hasControls = false;
					    },
					
					    /**
					     * Returns string represenation of a group
					     * @return {String}
					     */
					    toString: function() {
					      return '#<fabric.Group: (' + this.complexity() + ')>';
					    },
					
					    /**
					     * Adds an object to a group; Then recalculates group's dimension, position.
					     * @param {Object} object
					     * @return {fabric.Group} thisArg
					     * @chainable
					     */
					    addWithUpdate: function(object) {
					      this._restoreObjectsState();
					      if (object) {
					        this._objects.push(object);
					        object.group = this;
					      }
					      // since _restoreObjectsState set objects inactive
					      this.forEachObject(this._setObjectActive, this);
					      this._calcBounds();
					      this._updateObjectsCoords();
					      return this;
					    },
					
					    /**
					     * @private
					     */
					    _setObjectActive: function(object) {
					      object.set('active', true);
					      object.group = this;
					    },
					
					    /**
					     * Removes an object from a group; Then recalculates group's dimension, position.
					     * @param {Object} object
					     * @return {fabric.Group} thisArg
					     * @chainable
					     */
					    removeWithUpdate: function(object) {
					      this._moveFlippedObject(object);
					      this._restoreObjectsState();
					
					      // since _restoreObjectsState set objects inactive
					      this.forEachObject(this._setObjectActive, this);
					
					      this.remove(object);
					      this._calcBounds();
					      this._updateObjectsCoords();
					
					      return this;
					    },
					
					    /**
					     * @private
					     */
					    _onObjectAdded: function(object) {
					      object.group = this;
					    },
					
					    /**
					     * @private
					     */
					    _onObjectRemoved: function(object) {
					      delete object.group;
					      object.set('active', false);
					    },
					
					    /**
					     * Properties that are delegated to group objects when reading/writing
					     * @param {Object} delegatedProperties
					     */
					    delegatedProperties: {
					      fill:             true,
					      opacity:          true,
					      fontFamily:       true,
					      fontWeight:       true,
					      fontSize:         true,
					      fontStyle:        true,
					      lineHeight:       true,
					      textDecoration:   true,
					      textAlign:        true,
					      backgroundColor:  true
					    },
					
					    /**
					     * @private
					     */
					    _set: function(key, value) {
					      if (key in this.delegatedProperties) {
					        var i = this._objects.length;
					        while (i--) {
					          this._objects[i].set(key, value);
					        }
					      }
					      this.callSuper('_set', key, value);
					    },
					
					    /**
					     * Returns object representation of an instance
					     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output
					     * @return {Object} object representation of an instance
					     */
					    toObject: function(propertiesToInclude) {
					      return extend(this.callSuper('toObject', propertiesToInclude), {
					        objects: invoke(this._objects, 'toObject', propertiesToInclude)
					      });
					    },
					
					    /**
					     * Renders instance on a given context
					     * @param {CanvasRenderingContext2D} ctx context to render instance on
					     */
					    render: function(ctx) {
					      // do not render if object is not visible
					      if (!this.visible) {
					        return;
					      }
					
					      ctx.save();
					      this.clipTo && fabric.util.clipContext(this, ctx);
					      this.transform(ctx);
					      // the array is now sorted in order of highest first, so start from end
					      for (var i = 0, len = this._objects.length; i < len; i++) {
					        this._renderObject(this._objects[i], ctx);
					      }
					
					      this.clipTo && ctx.restore();
					
					      ctx.restore();
					    },
					
					    /**
					     * Renders controls and borders for the object
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     * @param {Boolean} [noTransform] When true, context is not transformed
					     */
					    _renderControls: function(ctx, noTransform) {
					      this.callSuper('_renderControls', ctx, noTransform);
					      for (var i = 0, len = this._objects.length; i < len; i++) {
					        this._objects[i]._renderControls(ctx);
					      }
					    },
					
					    /**
					     * @private
					     */
					    _renderObject: function(object, ctx) {
					      var originalHasRotatingPoint = object.hasRotatingPoint;
					
					      // do not render if object is not visible
					      if (!object.visible) {
					        return;
					      }
					
					      object.hasRotatingPoint = false;
					
					      object.render(ctx);
					
					      object.hasRotatingPoint = originalHasRotatingPoint;
					    },
					
					    /**
					     * Retores original state of each of group objects (original state is that which was before group was created).
					     * @private
					     * @return {fabric.Group} thisArg
					     * @chainable
					     */
					    _restoreObjectsState: function() {
					      this._objects.forEach(this._restoreObjectState, this);
					      return this;
					    },
					
					    /**
					     * Realises the transform from this group onto the supplied object
					     * i.e. it tells you what would happen if the supplied object was in
					     * the group, and then the group was destroyed. It mutates the supplied
					     * object.
					     * @param {fabric.Object} object
					     * @return {fabric.Object} transformedObject
					    */
					    realizeTransform: function(object) {
					      this._moveFlippedObject(object);
					      this._setObjectPosition(object);
					      return object;
					    },
					    /**
					     * Moves a flipped object to the position where it's displayed
					     * @private
					     * @param {fabric.Object} object
					     * @return {fabric.Group} thisArg
					     */
					    _moveFlippedObject: function(object) {
					      var oldOriginX = object.get('originX'),
					          oldOriginY = object.get('originY'),
					          center = object.getCenterPoint();
					
					      object.set({
					        originX: 'center',
					        originY: 'center',
					        left: center.x,
					        top: center.y
					      });
					
					      this._toggleFlipping(object);
					
					      var newOrigin = object.getPointByOrigin(oldOriginX, oldOriginY);
					
					      object.set({
					        originX: oldOriginX,
					        originY: oldOriginY,
					        left: newOrigin.x,
					        top: newOrigin.y
					      });
					
					      return this;
					    },
					
					    /**
					     * @private
					     */
					    _toggleFlipping: function(object) {
					      if (this.flipX) {
					        object.toggle('flipX');
					        object.set('left', -object.get('left'));
					        object.setAngle(-object.getAngle());
					      }
					      if (this.flipY) {
					        object.toggle('flipY');
					        object.set('top', -object.get('top'));
					        object.setAngle(-object.getAngle());
					      }
					    },
					
					    /**
					     * Restores original state of a specified object in group
					     * @private
					     * @param {fabric.Object} object
					     * @return {fabric.Group} thisArg
					     */
					    _restoreObjectState: function(object) {
					      this._setObjectPosition(object);
					
					      object.setCoords();
					      object.hasControls = object.__origHasControls;
					      delete object.__origHasControls;
					      object.set('active', false);
					      object.setCoords();
					      delete object.group;
					
					      return this;
					    },
					
					    /**
					     * @private
					     */
					    _setObjectPosition: function(object) {
					      var center = this.getCenterPoint(),
					          rotated = this._getRotatedLeftTop(object);
					
					      object.set({
					        angle: object.getAngle() + this.getAngle(),
					        left: center.x + rotated.left,
					        top: center.y + rotated.top,
					        scaleX: object.get('scaleX') * this.get('scaleX'),
					        scaleY: object.get('scaleY') * this.get('scaleY')
					      });
					    },
					
					    /**
					     * @private
					     */
					    _getRotatedLeftTop: function(object) {
					      var groupAngle = this.getAngle() * (Math.PI / 180);
					      return {
					        left: (-Math.sin(groupAngle) * object.getTop() * this.get('scaleY') +
					                Math.cos(groupAngle) * object.getLeft() * this.get('scaleX')),
					
					        top:  (Math.cos(groupAngle) * object.getTop() * this.get('scaleY') +
					               Math.sin(groupAngle) * object.getLeft() * this.get('scaleX'))
					      };
					    },
					
					    /**
					     * Destroys a group (restoring state of its objects)
					     * @return {fabric.Group} thisArg
					     * @chainable
					     */
					    destroy: function() {
					      this._objects.forEach(this._moveFlippedObject, this);
					      return this._restoreObjectsState();
					    },
					
					    /**
					     * Saves coordinates of this instance (to be used together with `hasMoved`)
					     * @saveCoords
					     * @return {fabric.Group} thisArg
					     * @chainable
					     */
					    saveCoords: function() {
					      this._originalLeft = this.get('left');
					      this._originalTop = this.get('top');
					      return this;
					    },
					
					    /**
					     * Checks whether this group was moved (since `saveCoords` was called last)
					     * @return {Boolean} true if an object was moved (since fabric.Group#saveCoords was called)
					     */
					    hasMoved: function() {
					      return this._originalLeft !== this.get('left') ||
					             this._originalTop !== this.get('top');
					    },
					
					    /**
					     * Sets coordinates of all group objects
					     * @return {fabric.Group} thisArg
					     * @chainable
					     */
					    setObjectsCoords: function() {
					      this.forEachObject(function(object) {
					        object.setCoords();
					      });
					      return this;
					    },
					
					    /**
					     * @private
					     */
					    _calcBounds: function(onlyWidthHeight) {
					      var aX = [],
					          aY = [],
					          o, prop,
					          props = ['tr', 'br', 'bl', 'tl'];
					
					      for (var i = 0, len = this._objects.length; i < len; ++i) {
					        o = this._objects[i];
					        o.setCoords();
					        for (var j = 0; j < props.length; j++) {
					          prop = props[j];
					          aX.push(o.oCoords[prop].x);
					          aY.push(o.oCoords[prop].y);
					        }
					      }
					
					      this.set(this._getBounds(aX, aY, onlyWidthHeight));
					    },
					
					    /**
					     * @private
					     */
					    _getBounds: function(aX, aY, onlyWidthHeight) {
					      var ivt = fabric.util.invertTransform(this.getViewportTransform()),
					          minXY = fabric.util.transformPoint(new fabric.Point(min(aX), min(aY)), ivt),
					          maxXY = fabric.util.transformPoint(new fabric.Point(max(aX), max(aY)), ivt),
					          obj = {
					            width: (maxXY.x - minXY.x) || 0,
					            height: (maxXY.y - minXY.y) || 0
					          };
					
					      if (!onlyWidthHeight) {
					        obj.left = minXY.x || 0;
					        obj.top = minXY.y || 0;
					        if (this.originX === 'center') {
					          obj.left += obj.width / 2;
					        }
					        if (this.originX === 'right') {
					          obj.left += obj.width;
					        }
					        if (this.originY === 'center') {
					          obj.top += obj.height / 2;
					        }
					        if (this.originY === 'bottom') {
					          obj.top += obj.height;
					        }
					      }
					      return obj;
					    },
					
					    /* _TO_SVG_START_ */
					    /**
					     * Returns svg representation of an instance
					     * @param {Function} [reviver] Method for further parsing of svg representation.
					     * @return {String} svg representation of an instance
					     */
					    toSVG: function(reviver) {
					      var markup = [
					        //jscs:disable validateIndentation
					        '<g ',
					          'transform="', this.getSvgTransform(),
					        '">\n'
					        //jscs:enable validateIndentation
					      ];
					
					      for (var i = 0, len = this._objects.length; i < len; i++) {
					        markup.push(this._objects[i].toSVG(reviver));
					      }
					
					      markup.push('</g>\n');
					
					      return reviver ? reviver(markup.join('')) : markup.join('');
					    },
					    /* _TO_SVG_END_ */
					
					    /**
					     * Returns requested property
					     * @param {String} prop Property to get
					     * @return {Any}
					     */
					    get: function(prop) {
					      if (prop in _lockProperties) {
					        if (this[prop]) {
					          return this[prop];
					        }
					        else {
					          for (var i = 0, len = this._objects.length; i < len; i++) {
					            if (this._objects[i][prop]) {
					              return true;
					            }
					          }
					          return false;
					        }
					      }
					      else {
					        if (prop in this.delegatedProperties) {
					          return this._objects[0] && this._objects[0].get(prop);
					        }
					        return this[prop];
					      }
					    }
					  });
					
					  /**
					   * Returns {@link fabric.Group} instance from an object representation
					   * @static
					   * @memberOf fabric.Group
					   * @param {Object} object Object to create a group from
					   * @param {Function} [callback] Callback to invoke when an group instance is created
					   * @return {fabric.Group} An instance of fabric.Group
					   */
					  fabric.Group.fromObject = function(object, callback) {
					    fabric.util.enlivenObjects(object.objects, function(enlivenedObjects) {
					      delete object.objects;
					      callback && callback(new fabric.Group(enlivenedObjects, object));
					    });
					  };
					
					  /**
					   * Indicates that instances of this type are async
					   * @static
					   * @memberOf fabric.Group
					   * @type Boolean
					   * @default
					   */
					  fabric.Group.async = true;
					
					})(typeof exports !== 'undefined' ? exports : this);
					(function(global) {
					
					  'use strict';
					
					  var extend = fabric.util.object.extend;
					
					  if (!global.fabric) {
					    global.fabric = { };
					  }
					
					  if (global.fabric.Image) {
					    fabric.warn('fabric.Image is already defined.');
					    return;
					  }
					
					  /**
					   * Image class
					   * @class fabric.Image
					   * @extends fabric.Object
					   * @tutorial {@link http://fabricjs.com/fabric-intro-part-1/#images}
					   * @see {@link fabric.Image#initialize} for constructor definition
					   */
					  fabric.Image = fabric.util.createClass(fabric.Object, /** @lends fabric.Image.prototype */ {
					
					    /**
					     * Type of an object
					     * @type String
					     * @default
					     */
					    type: 'image',
					
					    /**
					     * crossOrigin value (one of "", "anonymous", "allow-credentials")
					     * @see https://developer.mozilla.org/en-US/docs/HTML/CORS_settings_attributes
					     * @type String
					     * @default
					     */
					    crossOrigin: '',
					
					    /**
					     * AlignX value, part of preserveAspectRatio (one of "none", "mid", "min", "max")
					     * @see http://www.w3.org/TR/SVG/coords.html#PreserveAspectRatioAttribute
					     * This parameter defines how the picture is aligned to its viewport when image element width differs from image width.
					     * @type String
					     * @default
					     */
					    alignX: 'none',
					
					    /**
					     * AlignY value, part of preserveAspectRatio (one of "none", "mid", "min", "max")
					     * @see http://www.w3.org/TR/SVG/coords.html#PreserveAspectRatioAttribute
					     * This parameter defines how the picture is aligned to its viewport when image element height differs from image height.
					     * @type String
					     * @default
					     */
					    alignY: 'none',
					
					    /**
					     * meetOrSlice value, part of preserveAspectRatio  (one of "meet", "slice").
					     * if meet the image is always fully visibile, if slice the viewport is always filled with image.
					     * @see http://www.w3.org/TR/SVG/coords.html#PreserveAspectRatioAttribute
					     * @type String
					     * @default
					     */
					    meetOrSlice: 'meet',
					
					    /**
					     * private
					     * contains last value of scaleX to detect
					     * if the Image got resized after the last Render
					     * @type Number
					     */
					    _lastScaleX: 1,
					
					    /**
					     * private
					     * contains last value of scaleY to detect
					     * if the Image got resized after the last Render
					     * @type Number
					     */
					    _lastScaleY: 1,
					
					    /**
					     * Constructor
					     * @param {HTMLImageElement | String} element Image element
					     * @param {Object} [options] Options object
					     * @return {fabric.Image} thisArg
					     */
					    initialize: function(element, options) {
					      options || (options = { });
					
					      this.filters = [ ];
					      this.resizeFilters = [ ];
					      this.callSuper('initialize', options);
					
					      this._initElement(element, options);
					      this._initConfig(options);
					
					      if (options.filters) {
					        this.filters = options.filters;
					        this.applyFilters();
					      }
					    },
					
					    /**
					     * Returns image element which this instance if based on
					     * @return {HTMLImageElement} Image element
					     */
					    getElement: function() {
					      return this._element;
					    },
					
					    /**
					     * Sets image element for this instance to a specified one.
					     * If filters defined they are applied to new image.
					     * You might need to call `canvas.renderAll` and `object.setCoords` after replacing, to render new image and update controls area.
					     * @param {HTMLImageElement} element
					     * @param {Function} [callback] Callback is invoked when all filters have been applied and new image is generated
					     * @param {Object} [options] Options object
					     * @return {fabric.Image} thisArg
					     * @chainable
					     */
					    setElement: function(element, callback, options) {
					      this._element = element;
					      this._originalElement = element;
					      this._initConfig(options);
					
					      if (this.filters.length !== 0) {
					        this.applyFilters(callback);
					      }
					      else if (callback) {
					        callback();
					      }
					
					      return this;
					    },
					
					    /**
					     * Sets crossOrigin value (on an instance and corresponding image element)
					     * @return {fabric.Image} thisArg
					     * @chainable
					     */
					    setCrossOrigin: function(value) {
					      this.crossOrigin = value;
					      this._element.crossOrigin = value;
					
					      return this;
					    },
					
					    /**
					     * Returns original size of an image
					     * @return {Object} Object with "width" and "height" properties
					     */
					    getOriginalSize: function() {
					      var element = this.getElement();
					      return {
					        width: element.width,
					        height: element.height
					      };
					    },
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     */
					    _stroke: function(ctx) {
					      ctx.save();
					      this._setStrokeStyles(ctx);
					      ctx.beginPath();
					      ctx.strokeRect(-this.width / 2, -this.height / 2, this.width, this.height);
					      ctx.closePath();
					      ctx.restore();
					    },
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     */
					    _renderDashedStroke: function(ctx) {
					      var x = -this.width / 2,
					          y = -this.height / 2,
					          w = this.width,
					          h = this.height;
					
					      ctx.save();
					      this._setStrokeStyles(ctx);
					
					      ctx.beginPath();
					      fabric.util.drawDashedLine(ctx, x, y, x + w, y, this.strokeDashArray);
					      fabric.util.drawDashedLine(ctx, x + w, y, x + w, y + h, this.strokeDashArray);
					      fabric.util.drawDashedLine(ctx, x + w, y + h, x, y + h, this.strokeDashArray);
					      fabric.util.drawDashedLine(ctx, x, y + h, x, y, this.strokeDashArray);
					      ctx.closePath();
					      ctx.restore();
					    },
					
					    /**
					     * Returns object representation of an instance
					     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output
					     * @return {Object} Object representation of an instance
					     */
					    toObject: function(propertiesToInclude) {
					      return extend(this.callSuper('toObject', propertiesToInclude), {
					        src: this._originalElement.src || this._originalElement._src,
					        filters: this.filters.map(function(filterObj) {
					          return filterObj && filterObj.toObject();
					        }),
					        crossOrigin: this.crossOrigin,
					        alignX: this.alignX,
					        alignY: this.alignY,
					        meetOrSlice: this.meetOrSlice
					      });
					    },
					
					    /* _TO_SVG_START_ */
					    /**
					     * Returns SVG representation of an instance
					     * @param {Function} [reviver] Method for further parsing of svg representation.
					     * @return {String} svg representation of an instance
					     */
					    toSVG: function(reviver) {
					      var markup = [], x = -this.width / 2, y = -this.height / 2,
					          preserveAspectRatio = 'none';
					      if (this.group && this.group.type === 'path-group') {
					        x = this.left;
					        y = this.top;
					      }
					      if (this.alignX !== 'none' && this.alignY !== 'none') {
					        preserveAspectRatio = 'x' + this.alignX + 'Y' + this.alignY + ' ' + this.meetOrSlice;
					      }
					      markup.push(
					        '<g transform="', this.getSvgTransform(), this.getSvgTransformMatrix(), '">\n',
					          '<image xlink:href="', this.getSvgSrc(),
					            '" x="', x, '" y="', y,
					            '" style="', this.getSvgStyles(),
					            // we're essentially moving origin of transformation from top/left corner to the center of the shape
					            // by wrapping it in container <g> element with actual transformation, then offsetting object to the top/left
					            // so that object's center aligns with container's left/top
					            '" width="', this.width,
					            '" height="', this.height,
					            '" preserveAspectRatio="', preserveAspectRatio, '"',
					          '></image>\n'
					      );
					
					      if (this.stroke || this.strokeDashArray) {
					        var origFill = this.fill;
					        this.fill = null;
					        markup.push(
					          '<rect ',
					            'x="', x, '" y="', y,
					            '" width="', this.width, '" height="', this.height,
					            '" style="', this.getSvgStyles(),
					          '"/>\n'
					        );
					        this.fill = origFill;
					      }
					
					      markup.push('</g>\n');
					
					      return reviver ? reviver(markup.join('')) : markup.join('');
					    },
					    /* _TO_SVG_END_ */
					
					    /**
					     * Returns source of an image
					     * @return {String} Source of an image
					     */
					    getSrc: function() {
					      if (this.getElement()) {
					        return this.getElement().src || this.getElement()._src;
					      }
					    },
					
					    /**
					     * Sets source of an image
					     * @param {String} src Source string (URL)
					     * @param {Function} [callback] Callback is invoked when image has been loaded (and all filters have been applied)
					     * @param {Object} [options] Options object
					     * @return {fabric.Image} thisArg
					     * @chainable
					     */
					    setSrc: function(src, callback, options) {
					      fabric.util.loadImage(src, function(img) {
					        return this.setElement(img, callback, options);
					      }, this, options && options.crossOrigin);
					    },
					
					    /**
					     * Returns string representation of an instance
					     * @return {String} String representation of an instance
					     */
					    toString: function() {
					      return '#<fabric.Image: { src: "' + this.getSrc() + '" }>';
					    },
					
					    /**
					     * Returns a clone of an instance
					     * @param {Function} callback Callback is invoked with a clone as a first argument
					     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output
					     */
					    clone: function(callback, propertiesToInclude) {
					      this.constructor.fromObject(this.toObject(propertiesToInclude), callback);
					    },
					
					    /**
					     * Applies filters assigned to this image (from "filters" array)
					     * @method applyFilters
					     * @param {Function} callback Callback is invoked when all filters have been applied and new image is generated
					     * @return {fabric.Image} thisArg
					     * @chainable
					     */
					    applyFilters: function(callback, filters, imgElement, forResizing) {
					
					      filters = filters || this.filters;
					      imgElement = imgElement || this._originalElement;
					
					      if (!imgElement) {
					        return;
					      }
					
					      var imgEl = imgElement,
					          canvasEl = fabric.util.createCanvasElement(),
					          replacement = fabric.util.createImage(),
					          _this = this;
					
					      canvasEl.width = imgEl.width;
					      canvasEl.height = imgEl.height;
					      canvasEl.getContext('2d').drawImage(imgEl, 0, 0, imgEl.width, imgEl.height);
					
					      if (filters.length === 0) {
					        this._element = imgElement;
					        callback && callback();
					        return canvasEl;
					      }
					      filters.forEach(function(filter) {
					        filter && filter.applyTo(canvasEl, filter.scaleX || _this.scaleX, filter.scaleY || _this.scaleY);
					        if (!forResizing && filter && filter.type === 'Resize') {
					          _this.width *= filter.scaleX;
					          _this.height *= filter.scaleY;
					        }
					      });
					
					      /** @ignore */
					      replacement.width = canvasEl.width;
					      replacement.height = canvasEl.height;
					
					      if (fabric.isLikelyNode) {
					        replacement.src = canvasEl.toBuffer(undefined, fabric.Image.pngCompression);
					        // onload doesn't fire in some node versions, so we invoke callback manually
					        _this._element = replacement;
					        !forResizing && (_this._filteredEl = replacement);
					        callback && callback();
					      }
					      else {
					        replacement.onload = function() {
					          _this._element = replacement;
					          !forResizing && (_this._filteredEl = replacement);
					          callback && callback();
					          replacement.onload = canvasEl = imgEl = null;
					        };
					        replacement.src = canvasEl.toDataURL('image/png');
					      }
					      return canvasEl;
					    },
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     */
					    _render: function(ctx, noTransform) {
					      var x, y, imageMargins = this._findMargins(), elementToDraw;
					
					      x = (noTransform ? this.left : -this.width / 2);
					      y = (noTransform ? this.top : -this.height / 2);
					
					      if (this.meetOrSlice === 'slice') {
					        ctx.beginPath();
					        ctx.rect(x, y, this.width, this.height);
					        ctx.clip();
					      }
					
					      if (this.isMoving === false && this.resizeFilters.length && this._needsResize()) {
					        this._lastScaleX = this.scaleX;
					        this._lastScaleY = this.scaleY;
					        elementToDraw = this.applyFilters(null, this.resizeFilters, this._filteredEl || this._originalElement, true);
					      }
					      else {
					        elementToDraw = this._element;
					      }
					      elementToDraw && ctx.drawImage(elementToDraw,
					                                     x + imageMargins.marginX,
					                                     y + imageMargins.marginY,
					                                     imageMargins.width,
					                                     imageMargins.height
					                                    );
					
					      this._renderStroke(ctx);
					    },
					    /**
					     * @private, needed to check if image needs resize
					     */
					    _needsResize: function() {
					      return (this.scaleX !== this._lastScaleX || this.scaleY !== this._lastScaleY);
					    },
					
					    /**
					     * @private
					     */
					    _findMargins: function() {
					      var width = this.width, height = this.height, scales,
					          scale, marginX = 0, marginY = 0;
					
					      if (this.alignX !== 'none' || this.alignY !== 'none') {
					        scales = [this.width / this._element.width, this.height / this._element.height];
					        scale = this.meetOrSlice === 'meet'
					                ? Math.min.apply(null, scales) : Math.max.apply(null, scales);
					        width = this._element.width * scale;
					        height = this._element.height * scale;
					        if (this.alignX === 'Mid') {
					          marginX = (this.width - width) / 2;
					        }
					        if (this.alignX === 'Max') {
					          marginX = this.width - width;
					        }
					        if (this.alignY === 'Mid') {
					          marginY = (this.height - height) / 2;
					        }
					        if (this.alignY === 'Max') {
					          marginY = this.height - height;
					        }
					      }
					      return {
					        width:  width,
					        height: height,
					        marginX: marginX,
					        marginY: marginY
					      };
					    },
					
					    /**
					     * @private
					     */
					    _resetWidthHeight: function() {
					      var element = this.getElement();
					
					      this.set('width', element.width);
					      this.set('height', element.height);
					    },
					
					    /**
					     * The Image class's initialization method. This method is automatically
					     * called by the constructor.
					     * @private
					     * @param {HTMLImageElement|String} element The element representing the image
					     */
					    _initElement: function(element) {
					      this.setElement(fabric.util.getById(element));
					      fabric.util.addClass(this.getElement(), fabric.Image.CSS_CANVAS);
					    },
					
					    /**
					     * @private
					     * @param {Object} [options] Options object
					     */
					    _initConfig: function(options) {
					      options || (options = { });
					      this.setOptions(options);
					      this._setWidthHeight(options);
					      if (this._element && this.crossOrigin) {
					        this._element.crossOrigin = this.crossOrigin;
					      }
					    },
					
					    /**
					     * @private
					     * @param {Object} object Object with filters property
					     * @param {Function} callback Callback to invoke when all fabric.Image.filters instances are created
					     */
					    _initFilters: function(object, callback) {
					      if (object.filters && object.filters.length) {
					        fabric.util.enlivenObjects(object.filters, function(enlivenedObjects) {
					          callback && callback(enlivenedObjects);
					        }, 'fabric.Image.filters');
					      }
					      else {
					        callback && callback();
					      }
					    },
					
					    /**
					     * @private
					     * @param {Object} [options] Object with width/height properties
					     */
					    _setWidthHeight: function(options) {
					      this.width = 'width' in options
					        ? options.width
					        : (this.getElement()
					            ? this.getElement().width || 0
					            : 0);
					
					      this.height = 'height' in options
					        ? options.height
					        : (this.getElement()
					            ? this.getElement().height || 0
					            : 0);
					    },
					
					    /**
					     * Returns complexity of an instance
					     * @return {Number} complexity of this instance
					     */
					    complexity: function() {
					      return 1;
					    }
					  });
					
					  /**
					   * Default CSS class name for canvas
					   * @static
					   * @type String
					   * @default
					   */
					  fabric.Image.CSS_CANVAS = 'canvas-img';
					
					  /**
					   * Alias for getSrc
					   * @static
					   */
					  fabric.Image.prototype.getSvgSrc = fabric.Image.prototype.getSrc;
					
					  /**
					   * Creates an instance of fabric.Image from its object representation
					   * @static
					   * @param {Object} object Object to create an instance from
					   * @param {Function} [callback] Callback to invoke when an image instance is created
					   */
					  fabric.Image.fromObject = function(object, callback) {
					    fabric.util.loadImage(object.src, function(img) {
					      fabric.Image.prototype._initFilters.call(object, object, function(filters) {
					        object.filters = filters || [ ];
					        var instance = new fabric.Image(img, object);
					        callback && callback(instance);
					      });
					    }, null, object.crossOrigin);
					  };
					
					  /**
					   * Creates an instance of fabric.Image from an URL string
					   * @static
					   * @param {String} url URL to create an image from
					   * @param {Function} [callback] Callback to invoke when image is created (newly created image is passed as a first argument)
					   * @param {Object} [imgOptions] Options object
					   */
					  fabric.Image.fromURL = function(url, callback, imgOptions) {
					    fabric.util.loadImage(url, function(img) {
					      callback && callback(new fabric.Image(img, imgOptions));
					    }, null, imgOptions && imgOptions.crossOrigin);
					  };
					
					  /* _FROM_SVG_START_ */
					  /**
					   * List of attribute names to account for when parsing SVG element (used by {@link fabric.Image.fromElement})
					   * @static
					   * @see {@link http://www.w3.org/TR/SVG/struct.html#ImageElement}
					   */
					  fabric.Image.ATTRIBUTE_NAMES =
					    fabric.SHARED_ATTRIBUTES.concat('x y width height preserveAspectRatio xlink:href'.split(' '));
					
					  /**
					   * Returns {@link fabric.Image} instance from an SVG element
					   * @static
					   * @param {SVGElement} element Element to parse
					   * @param {Function} callback Callback to execute when fabric.Image object is created
					   * @param {Object} [options] Options object
					   * @return {fabric.Image} Instance of fabric.Image
					   */
					  fabric.Image.fromElement = function(element, callback, options) {
					    var parsedAttributes = fabric.parseAttributes(element, fabric.Image.ATTRIBUTE_NAMES),
					        align = 'xMidYMid', meetOrSlice = 'meet', alignX, alignY, aspectRatioAttrs;
					
					    if (parsedAttributes.preserveAspectRatio) {
					      aspectRatioAttrs = parsedAttributes.preserveAspectRatio.split(' ');
					    }
					
					    if (aspectRatioAttrs && aspectRatioAttrs.length) {
					      meetOrSlice = aspectRatioAttrs.pop();
					      if (meetOrSlice !== 'meet' && meetOrSlice !== 'slice') {
					        align = meetOrSlice;
					        meetOrSlice = 'meet';
					      }
					      else if (aspectRatioAttrs.length) {
					        align = aspectRatioAttrs.pop();
					      }
					    }
					    //divide align in alignX and alignY
					    alignX = align !== 'none' ? align.slice(1, 4) : 'none';
					    alignY = align !== 'none' ? align.slice(5, 8) : 'none';
					    parsedAttributes.alignX = alignX;
					    parsedAttributes.alignY = alignY;
					    parsedAttributes.meetOrSlice = meetOrSlice;
					    fabric.Image.fromURL(parsedAttributes['xlink:href'], callback,
					      extend((options ? fabric.util.object.clone(options) : { }), parsedAttributes));
					  };
					  /* _FROM_SVG_END_ */
					
					  /**
					   * Indicates that instances of this type are async
					   * @static
					   * @type Boolean
					   * @default
					   */
					  fabric.Image.async = true;
					
					  /**
					   * Indicates compression level used when generating PNG under Node (in applyFilters). Any of 0-9
					   * @static
					   * @type Number
					   * @default
					   */
					  fabric.Image.pngCompression = 1;
					
					})(typeof exports !== 'undefined' ? exports : this);
					(function(global) {
					
					  'use strict';
					
					  var fabric = global.fabric || (global.fabric = { }),
					      extend = fabric.util.object.extend,
					      clone = fabric.util.object.clone,
					      toFixed = fabric.util.toFixed,
					      supportsLineDash = fabric.StaticCanvas.supports('setLineDash');
					
					  if (fabric.Text) {
					    fabric.warn('fabric.Text is already defined');
					    return;
					  }
					
					  var stateProperties = fabric.Object.prototype.stateProperties.concat();
					  stateProperties.push(
					    'fontFamily',
					    'fontWeight',
					    'fontSize',
					    'text',
					    'textDecoration',
					    'textAlign',
					    'fontStyle',
					    'lineHeight',
					    'textBackgroundColor'
					  );
					
					  /**
					   * Text class
					   * @class fabric.Text
					   * @extends fabric.Object
					   * @return {fabric.Text} thisArg
					   * @tutorial {@link http://fabricjs.com/fabric-intro-part-2/#text}
					   * @see {@link fabric.Text#initialize} for constructor definition
					   */
					  fabric.Text = fabric.util.createClass(fabric.Object, /** @lends fabric.Text.prototype */ {
					
					    /**
					     * Properties which when set cause object to change dimensions
					     * @type Object
					     * @private
					     */
					    _dimensionAffectingProps: {
					      fontSize: true,
					      fontWeight: true,
					      fontFamily: true,
					      fontStyle: true,
					      lineHeight: true,
					      stroke: true,
					      strokeWidth: true,
					      text: true,
					      textAlign: true
					    },
					
					    /**
					     * @private
					     */
					    _reNewline: /\r?\n/,
					
					    /**
					     * Retrieves object's fontSize
					     * @method getFontSize
					     * @memberOf fabric.Text.prototype
					     * @return {String} Font size (in pixels)
					     */
					
					    /**
					     * Sets object's fontSize
					     * @method setFontSize
					     * @memberOf fabric.Text.prototype
					     * @param {Number} fontSize Font size (in pixels)
					     * @return {fabric.Text}
					     * @chainable
					     */
					
					    /**
					     * Retrieves object's fontWeight
					     * @method getFontWeight
					     * @memberOf fabric.Text.prototype
					     * @return {(String|Number)} Font weight
					     */
					
					    /**
					     * Sets object's fontWeight
					     * @method setFontWeight
					     * @memberOf fabric.Text.prototype
					     * @param {(Number|String)} fontWeight Font weight
					     * @return {fabric.Text}
					     * @chainable
					     */
					
					    /**
					     * Retrieves object's fontFamily
					     * @method getFontFamily
					     * @memberOf fabric.Text.prototype
					     * @return {String} Font family
					     */
					
					    /**
					     * Sets object's fontFamily
					     * @method setFontFamily
					     * @memberOf fabric.Text.prototype
					     * @param {String} fontFamily Font family
					     * @return {fabric.Text}
					     * @chainable
					     */
					
					    /**
					     * Retrieves object's text
					     * @method getText
					     * @memberOf fabric.Text.prototype
					     * @return {String} text
					     */
					
					    /**
					     * Sets object's text
					     * @method setText
					     * @memberOf fabric.Text.prototype
					     * @param {String} text Text
					     * @return {fabric.Text}
					     * @chainable
					     */
					
					    /**
					     * Retrieves object's textDecoration
					     * @method getTextDecoration
					     * @memberOf fabric.Text.prototype
					     * @return {String} Text decoration
					     */
					
					    /**
					     * Sets object's textDecoration
					     * @method setTextDecoration
					     * @memberOf fabric.Text.prototype
					     * @param {String} textDecoration Text decoration
					     * @return {fabric.Text}
					     * @chainable
					     */
					
					    /**
					     * Retrieves object's fontStyle
					     * @method getFontStyle
					     * @memberOf fabric.Text.prototype
					     * @return {String} Font style
					     */
					
					    /**
					     * Sets object's fontStyle
					     * @method setFontStyle
					     * @memberOf fabric.Text.prototype
					     * @param {String} fontStyle Font style
					     * @return {fabric.Text}
					     * @chainable
					     */
					
					    /**
					     * Retrieves object's lineHeight
					     * @method getLineHeight
					     * @memberOf fabric.Text.prototype
					     * @return {Number} Line height
					     */
					
					    /**
					     * Sets object's lineHeight
					     * @method setLineHeight
					     * @memberOf fabric.Text.prototype
					     * @param {Number} lineHeight Line height
					     * @return {fabric.Text}
					     * @chainable
					     */
					
					    /**
					     * Retrieves object's textAlign
					     * @method getTextAlign
					     * @memberOf fabric.Text.prototype
					     * @return {String} Text alignment
					     */
					
					    /**
					     * Sets object's textAlign
					     * @method setTextAlign
					     * @memberOf fabric.Text.prototype
					     * @param {String} textAlign Text alignment
					     * @return {fabric.Text}
					     * @chainable
					     */
					
					    /**
					     * Retrieves object's textBackgroundColor
					     * @method getTextBackgroundColor
					     * @memberOf fabric.Text.prototype
					     * @return {String} Text background color
					     */
					
					    /**
					     * Sets object's textBackgroundColor
					     * @method setTextBackgroundColor
					     * @memberOf fabric.Text.prototype
					     * @param {String} textBackgroundColor Text background color
					     * @return {fabric.Text}
					     * @chainable
					     */
					
					    /**
					     * Type of an object
					     * @type String
					     * @default
					     */
					    type:                 'text',
					
					    /**
					     * Font size (in pixels)
					     * @type Number
					     * @default
					     */
					    fontSize:             40,
					
					    /**
					     * Font weight (e.g. bold, normal, 400, 600, 800)
					     * @type {(Number|String)}
					     * @default
					     */
					    fontWeight:           'normal',
					
					    /**
					     * Font family
					     * @type String
					     * @default
					     */
					    fontFamily:           'Times New Roman',
					
					    /**
					     * Text decoration Possible values: "", "underline", "overline" or "line-through".
					     * @type String
					     * @default
					     */
					    textDecoration:       '',
					
					    /**
					     * Text alignment. Possible values: "left", "center", or "right".
					     * @type String
					     * @default
					     */
					    textAlign:            'left',
					
					    /**
					     * Font style . Possible values: "", "normal", "italic" or "oblique".
					     * @type String
					     * @default
					     */
					    fontStyle:            '',
					
					    /**
					     * Line height
					     * @type Number
					     * @default
					     */
					    lineHeight:           1.16,
					
					    /**
					     * Background color of text lines
					     * @type String
					     * @default
					     */
					    textBackgroundColor:  '',
					
					    /**
					     * List of properties to consider when checking if
					     * state of an object is changed ({@link fabric.Object#hasStateChanged})
					     * as well as for history (undo/redo) purposes
					     * @type Array
					     */
					    stateProperties:      stateProperties,
					
					    /**
					     * When defined, an object is rendered via stroke and this property specifies its color.
					     * <b>Backwards incompatibility note:</b> This property was named "strokeStyle" until v1.1.6
					     * @type String
					     * @default
					     */
					    stroke:               null,
					
					    /**
					     * Shadow object representing shadow of this shape.
					     * <b>Backwards incompatibility note:</b> This property was named "textShadow" (String) until v1.2.11
					     * @type fabric.Shadow
					     * @default
					     */
					    shadow:               null,
					
					    /**
					     * @private
					     */
					    _fontSizeFraction: 0.25,
					
					    /**
					     * Text Line proportion to font Size (in pixels)
					     * @type Number
					     * @default
					     */
					    _fontSizeMult:             1.13,
					
					    /**
					     * Constructor
					     * @param {String} text Text string
					     * @param {Object} [options] Options object
					     * @return {fabric.Text} thisArg
					     */
					    initialize: function(text, options) {
					      options = options || { };
					      this.text = text;
					      this.__skipDimension = true;
					      this.setOptions(options);
					      this.__skipDimension = false;
					      this._initDimensions();
					    },
					
					    /**
					     * Renders text object on offscreen canvas, so that it would get dimensions
					     * @private
					     */
					    _initDimensions: function(ctx) {
					      if (this.__skipDimension) {
					        return;
					      }
					      if (!ctx) {
					        ctx = fabric.util.createCanvasElement().getContext('2d');
					        this._setTextStyles(ctx);
					      }
					      this._textLines = this.text.split(this._reNewline);
					      this._clearCache();
					      var currentTextAlign = this.textAlign;
					      this.textAlign = 'left';
					      this.width = this._getTextWidth(ctx);
					      this.textAlign = currentTextAlign;
					      this.height = this._getTextHeight(ctx);
					    },
					
					    /**
					     * Returns string representation of an instance
					     * @return {String} String representation of text object
					     */
					    toString: function() {
					      return '#<fabric.Text (' + this.complexity() +
					        '): { "text": "' + this.text + '", "fontFamily": "' + this.fontFamily + '" }>';
					    },
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     */
					    _render: function(ctx) {
					
					      this.clipTo && fabric.util.clipContext(this, ctx);
					
					      this._renderTextBackground(ctx);
					      this._renderText(ctx);
					
					      this._renderTextDecoration(ctx);
					      this.clipTo && ctx.restore();
					    },
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     */
					    _renderText: function(ctx) {
					      ctx.save();
					      this._translateForTextAlign(ctx);
					      this._setOpacity(ctx);
					      this._setShadow(ctx);
					      this._setupCompositeOperation(ctx);
					      this._renderTextFill(ctx);
					      this._renderTextStroke(ctx);
					      this._restoreCompositeOperation(ctx);
					      this._removeShadow(ctx);
					      ctx.restore();
					    },
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     */
					    _translateForTextAlign: function(ctx) {
					      if (this.textAlign !== 'left' && this.textAlign !== 'justify') {
					        ctx.translate(this.textAlign === 'center' ? (this.width / 2) : this.width, 0);
					      }
					    },
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     */
					    _setTextStyles: function(ctx) {
					      ctx.textBaseline = 'alphabetic';
					      if (!this.skipTextAlign) {
					        ctx.textAlign = this.textAlign;
					      }
					      ctx.font = this._getFontDeclaration();
					    },
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     * @return {Number} Height of fabric.Text object
					     */
					    _getTextHeight: function() {
					      return this._textLines.length * this._getHeightOfLine();
					    },
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     * @return {Number} Maximum width of fabric.Text object
					     */
					    _getTextWidth: function(ctx) {
					      var maxWidth = this._getLineWidth(ctx, 0);
					
					      for (var i = 1, len = this._textLines.length; i < len; i++) {
					        var currentLineWidth = this._getLineWidth(ctx, i);
					        if (currentLineWidth > maxWidth) {
					          maxWidth = currentLineWidth;
					        }
					      }
					      return maxWidth;
					    },
					
					    /**
					     * @private
					     * @param {String} method Method name ("fillText" or "strokeText")
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     * @param {String} chars Chars to render
					     * @param {Number} left Left position of text
					     * @param {Number} top Top position of text
					     */
					    _renderChars: function(method, ctx, chars, left, top) {
					      ctx[method](chars, left, top);
					    },
					
					    /**
					     * @private
					     * @param {String} method Method name ("fillText" or "strokeText")
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     * @param {String} line Text to render
					     * @param {Number} left Left position of text
					     * @param {Number} top Top position of text
					     * @param {Number} lineIndex Index of a line in a text
					     */
					    _renderTextLine: function(method, ctx, line, left, top, lineIndex) {
					      // lift the line by quarter of fontSize
					      top -= this.fontSize * this._fontSizeFraction;
					
					      // short-circuit
					      if (this.textAlign !== 'justify') {
					        this._renderChars(method, ctx, line, left, top, lineIndex);
					        return;
					      }
					
					      var lineWidth = this._getLineWidth(ctx, lineIndex),
					          totalWidth = this.width;
					      if (totalWidth >= lineWidth) {
					        // stretch the line
					        var words = line.split(/\s+/),
					            wordsWidth = this._getWidthOfWords(ctx, line, lineIndex),
					            widthDiff = totalWidth - wordsWidth,
					            numSpaces = words.length - 1,
					            spaceWidth = widthDiff / numSpaces,
					            leftOffset = 0;
					
					        for (var i = 0, len = words.length; i < len; i++) {
					          this._renderChars(method, ctx, words[i], left + leftOffset, top, lineIndex);
					          leftOffset += ctx.measureText(words[i]).width + spaceWidth;
					        }
					      }
					      else {
					        this._renderChars(method, ctx, line, left, top, lineIndex);
					      }
					    },
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     * @param {Number} line
					     */
					    _getWidthOfWords: function (ctx, line) {
					      return ctx.measureText(line.replace(/\s+/g, '')).width;
					    },
					
					    /**
					     * @private
					     * @return {Number} Left offset
					     */
					    _getLeftOffset: function() {
					      return -this.width / 2;
					    },
					
					    /**
					     * @private
					     * @return {Number} Top offset
					     */
					    _getTopOffset: function() {
					      return -this.height / 2;
					    },
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     */
					    _renderTextFill: function(ctx) {
					      if (!this.fill && !this._skipFillStrokeCheck) {
					        return;
					      }
					
					      var lineHeights = 0;
					
					      for (var i = 0, len = this._textLines.length; i < len; i++) {
					        var heightOfLine = this._getHeightOfLine(ctx, i),
					            maxHeight = heightOfLine / this.lineHeight;
					
					        this._renderTextLine(
					          'fillText',
					          ctx,
					          this._textLines[i],
					          this._getLeftOffset(),
					          this._getTopOffset() + lineHeights + maxHeight,
					          i
					        );
					        lineHeights += heightOfLine;
					      }
					      if (this.shadow && !this.shadow.affectStroke) {
					        this._removeShadow(ctx);
					      }
					    },
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     */
					    _renderTextStroke: function(ctx) {
					      if ((!this.stroke || this.strokeWidth === 0) && !this._skipFillStrokeCheck) {
					        return;
					      }
					
					      var lineHeights = 0;
					
					      ctx.save();
					
					      if (this.strokeDashArray) {
					        // Spec requires the concatenation of two copies the dash list when the number of elements is odd
					        if (1 & this.strokeDashArray.length) {
					          this.strokeDashArray.push.apply(this.strokeDashArray, this.strokeDashArray);
					        }
					        supportsLineDash && ctx.setLineDash(this.strokeDashArray);
					      }
					
					      ctx.beginPath();
					      for (var i = 0, len = this._textLines.length; i < len; i++) {
					        var heightOfLine = this._getHeightOfLine(ctx, i),
					            maxHeight = heightOfLine / this.lineHeight;
					
					        this._renderTextLine(
					          'strokeText',
					          ctx,
					          this._textLines[i],
					          this._getLeftOffset(),
					          this._getTopOffset() + lineHeights + maxHeight,
					          i
					        );
					        lineHeights += heightOfLine;
					      }
					      ctx.closePath();
					      ctx.restore();
					    },
					
					    _getHeightOfLine: function() {
					      return this.fontSize * this._fontSizeMult * this.lineHeight;
					    },
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     * @param {Array} textLines Array of all text lines
					     */
					    _renderTextBackground: function(ctx) {
					      this._renderTextBoxBackground(ctx);
					      this._renderTextLinesBackground(ctx);
					    },
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     */
					    _renderTextBoxBackground: function(ctx) {
					      if (!this.backgroundColor) {
					        return;
					      }
					
					      ctx.save();
					      ctx.fillStyle = this.backgroundColor;
					
					      ctx.fillRect(
					        this._getLeftOffset(),
					        this._getTopOffset(),
					        this.width,
					        this.height
					      );
					
					      ctx.restore();
					    },
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     */
					    _renderTextLinesBackground: function(ctx) {
					      var lineTopOffset = 0, heightOfLine = this._getHeightOfLine();
					      if (!this.textBackgroundColor) {
					        return;
					      }
					
					      ctx.save();
					      ctx.fillStyle = this.textBackgroundColor;
					
					      for (var i = 0, len = this._textLines.length; i < len; i++) {
					
					        if (this._textLines[i] !== '') {
					
					          var lineWidth = this._getLineWidth(ctx, i),
					              lineLeftOffset = this._getLineLeftOffset(lineWidth);
					
					          ctx.fillRect(
					            this._getLeftOffset() + lineLeftOffset,
					            this._getTopOffset() + lineTopOffset,
					            lineWidth,
					            this.fontSize * this._fontSizeMult
					          );
					        }
					        lineTopOffset += heightOfLine;
					      }
					      ctx.restore();
					    },
					
					    /**
					     * @private
					     * @param {Number} lineWidth Width of text line
					     * @return {Number} Line left offset
					     */
					    _getLineLeftOffset: function(lineWidth) {
					      if (this.textAlign === 'center') {
					        return (this.width - lineWidth) / 2;
					      }
					      if (this.textAlign === 'right') {
					        return this.width - lineWidth;
					      }
					      return 0;
					    },
					
					    /**
					     * @private
					     */
					    _clearCache: function() {
					      this.__lineWidths = [ ];
					      this.__lineHeights = [ ];
					      this.__lineOffsets = [ ];
					    },
					
					    /**
					     * @private
					     */
					    _shouldClearCache: function() {
					      var shouldClear = false;
					      for (var prop in this._dimensionAffectingProps) {
					        if (this['__' + prop] !== this[prop]) {
					          this['__' + prop] = this[prop];
					          shouldClear = true;
					        }
					      }
					      return shouldClear;
					    },
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     * @return {Number} Line width
					     */
					    _getLineWidth: function(ctx, lineIndex) {
					      if (this.__lineWidths[lineIndex]) {
					        return this.__lineWidths[lineIndex];
					      }
					      this.__lineWidths[lineIndex] = ctx.measureText(this._textLines[lineIndex]).width;
					      return this.__lineWidths[lineIndex];
					    },
					
					    /**
					     * @private
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     */
					    _renderTextDecoration: function(ctx) {
					      if (!this.textDecoration) {
					        return;
					      }
					
					      var halfOfVerticalBox = this.height / 2,
					          _this = this, offsets = [];
					
					      /** @ignore */
					      function renderLinesAtOffset(offsets) {
					        var i, lineHeight = 0, len, j, oLen;
					        for (i = 0, len = _this._textLines.length; i < len; i++) {
					
					          var lineWidth = _this._getLineWidth(ctx, i),
					              lineLeftOffset = _this._getLineLeftOffset(lineWidth),
					              heightOfLine = _this._getHeightOfLine(ctx, i);
					
					          for (j = 0, oLen = offsets.length; j < oLen; j++) {
					            ctx.fillRect(
					              _this._getLeftOffset() + lineLeftOffset,
					              lineHeight + (_this._fontSizeMult - 1 + offsets[j] ) * _this.fontSize - halfOfVerticalBox,
					              lineWidth,
					              _this.fontSize / 15);
					          }
					          lineHeight += heightOfLine;
					        }
					      }
					
					      if (this.textDecoration.indexOf('underline') > -1) {
					        offsets.push(0.85); // 1 - 3/16
					      }
					      if (this.textDecoration.indexOf('line-through') > -1) {
					        offsets.push(0.43);
					      }
					      if (this.textDecoration.indexOf('overline') > -1) {
					        offsets.push(-0.12);
					      }
					
					      if (offsets.length > 0) {
					        renderLinesAtOffset(offsets);
					      }
					    },
					
					    /**
					     * @private
					     */
					    _getFontDeclaration: function() {
					      return [
					        // node-canvas needs "weight style", while browsers need "style weight"
					        (fabric.isLikelyNode ? this.fontWeight : this.fontStyle),
					        (fabric.isLikelyNode ? this.fontStyle : this.fontWeight),
					        this.fontSize + 'px',
					        (fabric.isLikelyNode ? ('"' + this.fontFamily + '"') : this.fontFamily)
					      ].join(' ');
					    },
					
					    /**
					     * Renders text instance on a specified context
					     * @param {CanvasRenderingContext2D} ctx Context to render on
					     */
					    render: function(ctx, noTransform) {
					      // do not render if object is not visible
					      if (!this.visible) {
					        return;
					      }
					
					      ctx.save();
					      this._setTextStyles(ctx);
					
					      if (this._shouldClearCache()) {
					        this._initDimensions(ctx);
					      }
					      if (!noTransform) {
					        this.transform(ctx);
					      }
					      this._setStrokeStyles(ctx);
					      this._setFillStyles(ctx);
					      if (this.transformMatrix) {
					        ctx.transform.apply(ctx, this.transformMatrix);
					      }
					      if (this.group && this.group.type === 'path-group') {
					        ctx.translate(this.left, this.top);
					      }
					      this._render(ctx);
					      ctx.restore();
					    },
					
					    /**
					     * Returns object representation of an instance
					     * @param {Array} [propertiesToInclude] Any properties that you might want to additionally include in the output
					     * @return {Object} Object representation of an instance
					     */
					    toObject: function(propertiesToInclude) {
					      var object = extend(this.callSuper('toObject', propertiesToInclude), {
					        text:                 this.text,
					        fontSize:             this.fontSize,
					        fontWeight:           this.fontWeight,
					        fontFamily:           this.fontFamily,
					        fontStyle:            this.fontStyle,
					        lineHeight:           this.lineHeight,
					        textDecoration:       this.textDecoration,
					        textAlign:            this.textAlign,
					        textBackgroundColor:  this.textBackgroundColor
					      });
					      if (!this.includeDefaultValues) {
					        this._removeDefaultValues(object);
					      }
					      return object;
					    },
					
					    /* _TO_SVG_START_ */
					    /**
					     * Returns SVG representation of an instance
					     * @param {Function} [reviver] Method for further parsing of svg representation.
					     * @return {String} svg representation of an instance
					     */
					    toSVG: function(reviver) {
					      var markup = this._createBaseSVGMarkup(),
					          offsets = this._getSVGLeftTopOffsets(this.ctx),
					          textAndBg = this._getSVGTextAndBg(offsets.textTop, offsets.textLeft);
					      this._wrapSVGTextAndBg(markup, textAndBg);
					
					      return reviver ? reviver(markup.join('')) : markup.join('');
					    },
					
					    /**
					     * @private
					     */
					    _getSVGLeftTopOffsets: function(ctx) {
					      var lineTop = this._getHeightOfLine(ctx, 0),
					          textLeft = -this.width / 2,
					          textTop = 0;
					
					      return {
					        textLeft: textLeft + (this.group && this.group.type === 'path-group' ? this.left : 0),
					        textTop: textTop + (this.group && this.group.type === 'path-group' ? -this.top : 0),
					        lineTop: lineTop
					      };
					    },
					
					    /**
					     * @private
					     */
					    _wrapSVGTextAndBg: function(markup, textAndBg) {
					      markup.push(
					        '\t<g transform="', this.getSvgTransform(), this.getSvgTransformMatrix(), '">\n',
					          textAndBg.textBgRects.join(''),
					          '\t\t<text ',
					            (this.fontFamily ? 'font-family="' + this.fontFamily.replace(/"/g, '\'') + '" ': ''),
					            (this.fontSize ? 'font-size="' + this.fontSize + '" ': ''),
					            (this.fontStyle ? 'font-style="' + this.fontStyle + '" ': ''),
					            (this.fontWeight ? 'font-weight="' + this.fontWeight + '" ': ''),
					            (this.textDecoration ? 'text-decoration="' + this.textDecoration + '" ': ''),
					            'style="', this.getSvgStyles(), '" >',
					            textAndBg.textSpans.join(''),
					          '</text>\n',
					        '\t</g>\n'
					      );
					    },
					
					    /**
					     * @private
					     * @param {Number} textTopOffset Text top offset
					     * @param {Number} textLeftOffset Text left offset
					     * @return {Object}
					     */
					    _getSVGTextAndBg: function(textTopOffset, textLeftOffset) {
					      var textSpans = [ ],
					          textBgRects = [ ],
					          height = 0;
					      // bounding-box background
					      this._setSVGBg(textBgRects);
					
					      // text and text-background
					      for (var i = 0, len = this._textLines.length; i < len; i++) {
					        if (this.textBackgroundColor) {
					          this._setSVGTextLineBg(textBgRects, i, textLeftOffset, textTopOffset, height);
					        }
					        this._setSVGTextLineText(i, textSpans, height, textLeftOffset, textTopOffset, textBgRects);
					        height += this._getHeightOfLine(this.ctx, i);
					      }
					
					      return {
					        textSpans: textSpans,
					        textBgRects: textBgRects
					      };
					    },
					
					    _setSVGTextLineText: function(i, textSpans, height, textLeftOffset, textTopOffset) {
					      var yPos = this.fontSize * (this._fontSizeMult - this._fontSizeFraction)
					        - textTopOffset + height - this.height / 2;
					      textSpans.push(
					        '<tspan x="',
					          toFixed(textLeftOffset + this._getLineLeftOffset(this.__lineWidths[i]), 4), '" ',
					          'y="',
					          toFixed(yPos, 4),
					          '" ',
					          // doing this on <tspan> elements since setting opacity
					          // on containing <text> one doesn't work in Illustrator
					          this._getFillAttributes(this.fill), '>',
					          fabric.util.string.escapeXml(this._textLines[i]),
					        '</tspan>'
					      );
					    },
					
					    _setSVGTextLineBg: function(textBgRects, i, textLeftOffset, textTopOffset, height) {
					      textBgRects.push(
					        '\t\t<rect ',
					          this._getFillAttributes(this.textBackgroundColor),
					          ' x="',
					          toFixed(textLeftOffset + this._getLineLeftOffset(this.__lineWidths[i]), 4),
					          '" y="',
					          toFixed(height - this.height / 2, 4),
					          '" width="',
					          toFixed(this.__lineWidths[i], 4),
					          '" height="',
					          toFixed(this._getHeightOfLine(this.ctx, i) / this.lineHeight, 4),
					        '"></rect>\n');
					    },
					
					    _setSVGBg: function(textBgRects) {
					      if (this.backgroundColor) {
					        textBgRects.push(
					          '\t\t<rect ',
					            this._getFillAttributes(this.backgroundColor),
					            ' x="',
					            toFixed(-this.width / 2, 4),
					            '" y="',
					            toFixed(-this.height / 2, 4),
					            '" width="',
					            toFixed(this.width, 4),
					            '" height="',
					            toFixed(this.height, 4),
					          '"></rect>\n');
					      }
					    },
					
					    /**
					     * Adobe Illustrator (at least CS5) is unable to render rgba()-based fill values
					     * we work around it by "moving" alpha channel into opacity attribute and setting fill's alpha to 1
					     *
					     * @private
					     * @param {Any} value
					     * @return {String}
					     */
					    _getFillAttributes: function(value) {
					      var fillColor = (value && typeof value === 'string') ? new fabric.Color(value) : '';
					      if (!fillColor || !fillColor.getSource() || fillColor.getAlpha() === 1) {
					        return 'fill="' + value + '"';
					      }
					      return 'opacity="' + fillColor.getAlpha() + '" fill="' + fillColor.setAlpha(1).toRgb() + '"';
					    },
					    /* _TO_SVG_END_ */
					
					    /**
					     * Sets specified property to a specified value
					     * @param {String} key
					     * @param {Any} value
					     * @return {fabric.Text} thisArg
					     * @chainable
					     */
					    _set: function(key, value) {
					      this.callSuper('_set', key, value);
					
					      if (key in this._dimensionAffectingProps) {
					        this._initDimensions();
					        this.setCoords();
					      }
					    },
					
					    /**
					     * Returns complexity of an instance
					     * @return {Number} complexity
					     */
					    complexity: function() {
					      return 1;
					    }
					  });
					
					  /* _FROM_SVG_START_ */
					  /**
					   * List of attribute names to account for when parsing SVG element (used by {@link fabric.Text.fromElement})
					   * @static
					   * @memberOf fabric.Text
					   * @see: http://www.w3.org/TR/SVG/text.html#TextElement
					   */
					  fabric.Text.ATTRIBUTE_NAMES = fabric.SHARED_ATTRIBUTES.concat(
					    'x y dx dy font-family font-style font-weight font-size text-decoration text-anchor'.split(' '));
					
					  /**
					   * Default SVG font size
					   * @static
					   * @memberOf fabric.Text
					   */
					  fabric.Text.DEFAULT_SVG_FONT_SIZE = 16;
					
					  /**
					   * Returns fabric.Text instance from an SVG element (<b>not yet implemented</b>)
					   * @static
					   * @memberOf fabric.Text
					   * @param {SVGElement} element Element to parse
					   * @param {Object} [options] Options object
					   * @return {fabric.Text} Instance of fabric.Text
					   */
					  fabric.Text.fromElement = function(element, options) {
					    if (!element) {
					      return null;
					    }
					
					    var parsedAttributes = fabric.parseAttributes(element, fabric.Text.ATTRIBUTE_NAMES);
					    options = fabric.util.object.extend((options ? fabric.util.object.clone(options) : { }), parsedAttributes);
					
					    options.top = options.top || 0;
					    options.left = options.left || 0;
					    if ('dx' in parsedAttributes) {
					      options.left += parsedAttributes.dx;
					    }
					    if ('dy' in parsedAttributes) {
					      options.top += parsedAttributes.dy;
					    }
					    if (!('fontSize' in options)) {
					      options.fontSize = fabric.Text.DEFAULT_SVG_FONT_SIZE;
					    }
					
					    if (!options.originX) {
					      options.originX = 'left';
					    }
					    var textContent = element.textContent.replace(/^\s+|\s+$|\n+/g, '').replace(/\s+/g, ' '),
					        text = new fabric.Text(textContent, options),
					        /*
					          Adjust positioning:
					            x/y attributes in SVG correspond to the bottom-left corner of text bounding box
					            top/left properties in Fabric correspond to center point of text bounding box
					        */
					        offX = 0;
					
					    if (text.originX === 'left') {
					      offX = text.getWidth() / 2;
					    }
					    if (text.originX === 'right') {
					      offX = -text.getWidth() / 2;
					    }
					    text.set({
					      left: text.getLeft() + offX,
					      top: text.getTop() - text.getHeight() / 2 + text.fontSize * (0.18 + text._fontSizeFraction) /* 0.3 is the old lineHeight */
					    });
					
					    return text;
					  };
					  /* _FROM_SVG_END_ */
					
					  /**
					   * Returns fabric.Text instance from an object representation
					   * @static
					   * @memberOf fabric.Text
					   * @param {Object} object Object to create an instance from
					   * @return {fabric.Text} Instance of fabric.Text
					   */
					  fabric.Text.fromObject = function(object) {
					    return new fabric.Text(object.text, clone(object));
					  };
					
					  fabric.util.createAccessors(fabric.Text);
					
					})(typeof exports !== 'undefined' ? exports : this);	// Puts fabric in exports and in global window
						delete window.fabric;
						return exports;
					}) () .fabric;
						
					__pragma__ ('<all>')
						__all__.fabric = fabric;
					__pragma__ ('</all>')
				}
			}
		}
	);
	(function () {
		var fabric = __init__ (__world__.com.fabricjs).fabric;
		var orthoWidth = 1000;
		var orthoHeight = 750;
		var fieldHeight = 650;
		var __left0__ = tuple ([13, 27, 32]);
		var enter = __left0__ [0];
		var esc = __left0__ [1];
		var space = __left0__ [2];
		window.onkeydown = (function __lambda__ (event) {
			return event.keyCode != space;});
		var Attribute = __class__ ('Attribute', [object], {
			get __init__ () {return __get__ (this, function (self, game) {
				self.game = game;
				self.game.attributes.append (self);
				self.install ();
				self.reset ();
			});},
			get reset () {return __get__ (this, function (self) {
				self.commit ();
			});},
			get predict () {return __get__ (this, function (self) {
				// pass;
			});},
			get interact () {return __get__ (this, function (self) {
				// pass;
			});},
			get commit () {return __get__ (this, function (self) {
				// pass;
			});}
		});
		var Sprite = __class__ ('Sprite', [Attribute], {
			get __init__ () {return __get__ (this, function (self, game, width, height) {
				self.width = width;
				self.height = height;
				Attribute.__init__ (self, game);
			});},
			get install () {return __get__ (this, function (self) {
				self.image = new fabric.Rect (dict ({'width': self.game.scaleX (self.width), 'height': self.game.scaleY (self.height), 'originX': 'center', 'originY': 'center', 'fill': 'white'}));
			});},
			get reset () {return __get__ (this, function (self, vX, vY, x, y) {
				if (typeof vX == 'undefined' || (vX != null && vX .__class__ == __kwargdict__)) {;
					var vX = 0;
				};
				if (typeof vY == 'undefined' || (vY != null && vY .__class__ == __kwargdict__)) {;
					var vY = 0;
				};
				if (typeof x == 'undefined' || (x != null && x .__class__ == __kwargdict__)) {;
					var x = 0;
				};
				if (typeof y == 'undefined' || (y != null && y .__class__ == __kwargdict__)) {;
					var y = 0;
				};
				if (arguments.length) {
					var __ilastarg0__ = arguments.length - 1;
					if (arguments [__ilastarg0__] && arguments [__ilastarg0__].__class__ == __kwargdict__) {
						var __allkwargs0__ = arguments [__ilastarg0__--];
						for (var __attrib0__ in __allkwargs0__) {
							switch (__attrib0__) {
								case 'self': var self = __allkwargs0__ [__attrib0__]; break;
								case 'vX': var vX = __allkwargs0__ [__attrib0__]; break;
								case 'vY': var vY = __allkwargs0__ [__attrib0__]; break;
								case 'x': var x = __allkwargs0__ [__attrib0__]; break;
								case 'y': var y = __allkwargs0__ [__attrib0__]; break;
							}
						}
					}
				}
				self.vX = vX;
				self.vY = vY;
				self.x = x;
				self.y = y;
				Attribute.reset (self);
			});},
			get predict () {return __get__ (this, function (self) {
				self.x += self.vX * self.game.deltaT;
				self.y += self.vY * self.game.deltaT;
			});},
			get commit () {return __get__ (this, function (self) {
				self.image.left = self.game.orthoX (self.x);
				self.image.top = self.game.orthoY (self.y);
			});},
			get draw () {return __get__ (this, function (self) {
				self.game.canvas.add (self.image);
			});}
		});
		var Paddle = __class__ ('Paddle', [Sprite], {
			get __init__ () {return __get__ (this, function (self, game, index) {
				self.index = index;
				Sprite.__init__ (self, game, self.width, self.height);
			});},
			get reset () {return __get__ (this, function (self) {
				Sprite.reset (self, __kwargdict__ ({x: (self.index ? Math.floor (orthoWidth / 2) - self.margin : Math.floor (-(orthoWidth) / 2) + self.margin), y: 0}));
			});},
			get predict () {return __get__ (this, function (self) {
				self.vY = 0;
				if (self.index) {
					if (self.game.keyCode == ord ('K')) {
						self.vY = self.speed;
					}
					else {
						if (self.game.keyCode == ord ('M')) {
							self.vY = -(self.speed);
						}
					}
				}
				else {
					if (self.game.keyCode == ord ('A')) {
						self.vY = self.speed;
					}
					else {
						if (self.game.keyCode == ord ('Z')) {
							self.vY = -(self.speed);
						}
					}
				}
				Sprite.predict (self);
			});},
			get interact () {return __get__ (this, function (self) {
				self.y = Math.max (Math.floor (self.height / 2) - Math.floor (fieldHeight / 2), Math.min (self.y, Math.floor (fieldHeight / 2) - Math.floor (self.height / 2)));
				if ((self.y - Math.floor (self.height / 2) < self.game.ball.y && self.game.ball.y < self.y + Math.floor (self.height / 2)) && (self.index == 0 && self.game.ball.x < self.x || self.index == 1 && self.game.ball.x > self.x)) {
					self.game.ball.x = self.x;
					self.game.ball.vX = -(self.game.ball.vX);
					self.game.ball.speedUp (self);
				}
			});}
		});
		Paddle.margin = 30;
		Paddle.width = 10;
		Paddle.height = 100;
		Paddle.speed = 400;
		var Ball = __class__ ('Ball', [Sprite], {
			get __init__ () {return __get__ (this, function (self, game) {
				Sprite.__init__ (self, game, self.side, self.side);
			});},
			get reset () {return __get__ (this, function (self) {
				var angle = self.game.serviceIndex * Math.PI + ((Math.random () > 0.5 ? 1 : -(1)) * Math.random ()) * Math.atan (fieldHeight / orthoWidth);
				Sprite.reset (self, __kwargdict__ ({vX: self.speed * Math.cos (angle), vY: self.speed * Math.sin (angle)}));
			});},
			get predict () {return __get__ (this, function (self) {
				Sprite.predict (self);
				if (self.x < Math.floor (-(orthoWidth) / 2)) {
					self.game.scored (1);
				}
				else {
					if (self.x > Math.floor (orthoWidth / 2)) {
						self.game.scored (0);
					}
				}
				if (self.y > Math.floor (fieldHeight / 2)) {
					self.y = Math.floor (fieldHeight / 2);
					self.vY = -(self.vY);
				}
				else {
					if (self.y < Math.floor (-(fieldHeight) / 2)) {
						self.y = Math.floor (-(fieldHeight) / 2);
						self.vY = -(self.vY);
					}
				}
			});},
			get speedUp () {return __get__ (this, function (self, bat) {
				var factor = 1 + 0.15 * Math.pow (1 - Math.abs (self.y - bat.y) / (Math.floor (bat.height / 2)), 2);
				if (Math.abs (self.vX) < 3 * self.speed) {
					self.vX *= factor;
					self.vY *= factor;
				}
			});}
		});
		Ball.side = 8;
		Ball.speed = 300;
		var Scoreboard = __class__ ('Scoreboard', [Attribute], {
			get install () {return __get__ (this, function (self) {
				self.playerLabels = function () {
					var __accu0__ = [];
					var __iter0__ = tuple ([tuple (['AZ keys:', -(7) / 16]), tuple (['KM keys:', 1 / 16])]);
					for (var __index0__ = 0; __index0__ < __iter0__.length; __index0__++) {
						var __left0__ = __iter0__ [__index0__];
						var py_name = __left0__ [0];
						var position = __left0__ [1];
						__accu0__.append (new fabric.Text ('Player {}'.format (py_name), dict ({'fill': 'white', 'fontFamily': 'arial', 'fontSize': '{}'.format (self.game.canvas.width / 30), 'left': self.game.orthoX (position * orthoWidth), 'top': self.game.orthoY (Math.floor (fieldHeight / 2) + self.nameShift)})));
					}
					return __accu0__;
				} ();
				self.hintLabel = new fabric.Text ('[spacebar] starts game, [enter] resets score', dict ({'fill': 'white', 'fontFamily': 'arial', 'fontSize': '{}'.format (self.game.canvas.width / 70), 'left': self.game.orthoX ((-(7) / 16) * orthoWidth), 'top': self.game.orthoY (Math.floor (fieldHeight / 2) + self.hintShift)}));
				self.image = new fabric.Line (list ([self.game.orthoX (Math.floor (-(orthoWidth) / 2)), self.game.orthoY (Math.floor (fieldHeight / 2)), self.game.orthoX (Math.floor (orthoWidth / 2)), self.game.orthoY (Math.floor (fieldHeight / 2))]), dict ({'stroke': 'white'}));
			});},
			get increment () {return __get__ (this, function (self, playerIndex) {
				self.scores [playerIndex]++;
			});},
			get reset () {return __get__ (this, function (self) {
				self.scores = list ([0, 0]);
				Attribute.reset (self);
			});},
			get commit () {return __get__ (this, function (self) {
				self.scoreLabels = function () {
					var __accu0__ = [];
					var __iter0__ = zip (self.scores, tuple ([-(2) / 16, 6 / 16]));
					for (var __index0__ = 0; __index0__ < __iter0__.length; __index0__++) {
						var __left0__ = __iter0__ [__index0__];
						var score = __left0__ [0];
						var position = __left0__ [1];
						__accu0__.append (new fabric.Text ('{}'.format (score), dict ({'fill': 'white', 'fontFamily': 'arial', 'fontSize': '{}'.format (self.game.canvas.width / 30), 'left': self.game.orthoX (position * orthoWidth), 'top': self.game.orthoY (Math.floor (fieldHeight / 2) + self.nameShift)})));
					}
					return __accu0__;
				} ();
			});},
			get draw () {return __get__ (this, function (self) {
				var __iter0__ = zip (self.playerLabels, self.scoreLabels);
				for (var __index0__ = 0; __index0__ < __iter0__.length; __index0__++) {
					var __left0__ = __iter0__ [__index0__];
					var playerLabel = __left0__ [0];
					var scoreLabel = __left0__ [1];
					self.game.canvas.add (playerLabel);
					self.game.canvas.add (scoreLabel);
					self.game.canvas.add (self.hintLabel);
				}
				self.game.canvas.add (self.image);
			});}
		});
		Scoreboard.nameShift = 75;
		Scoreboard.hintShift = 25;
		var Game = __class__ ('Game', [object], {
			get __init__ () {return __get__ (this, function (self) {
				self.serviceIndex = (Math.random () > 0.5 ? 1 : 0);
				self.pause = true;
				self.keyCode = null;
				self.textFrame = document.getElementById ('text_frame');
				self.canvasFrame = document.getElementById ('canvas_frame');
				self.buttonsFrame = document.getElementById ('buttons_frame');
				self.canvas = new fabric.Canvas ('canvas', dict ({'backgroundColor': 'black', 'originX': 'center', 'originY': 'center'}));
				self.canvas.onWindowDraw = self.draw;
				self.canvas.lineWidth = 2;
				self.canvas.clear ();
				self.attributes = list ([]);
				self.paddles = function () {
					var __accu0__ = [];
					for (var index = 0; index < 2; index++) {
						__accu0__.append (Paddle (self, index));
					}
					return __accu0__;
				} ();
				self.ball = Ball (self);
				self.scoreboard = Scoreboard (self);
				window.setInterval (self.update, 10);
				window.setInterval (self.draw, 20);
				window.addEventListener ('keydown', self.keydown);
				window.addEventListener ('keyup', self.keyup);
				self.buttons = list ([]);
				var __iter0__ = tuple (['A', 'Z', 'K', 'M', 'space', 'enter']);
				for (var __index0__ = 0; __index0__ < __iter0__.length; __index0__++) {
					var key = __iter0__ [__index0__];
					var button = document.getElementById (key);
					button.addEventListener ('mousedown', (function __lambda__ (aKey) {
						return (function __lambda__ () {
							return self.mouseOrTouch (aKey, true);});}) (key));
					button.addEventListener ('touchstart', (function __lambda__ (aKey) {
						return (function __lambda__ () {
							return self.mouseOrTouch (aKey, true);});}) (key));
					button.addEventListener ('mouseup', (function __lambda__ (aKey) {
						return (function __lambda__ () {
							return self.mouseOrTouch (aKey, false);});}) (key));
					button.addEventListener ('touchend', (function __lambda__ (aKey) {
						return (function __lambda__ () {
							return self.mouseOrTouch (aKey, false);});}) (key));
					button.style.cursor = 'pointer';
					button.style.userSelect = 'none';
					self.buttons.append (button);
				}
				self.time = +(new Date);
				window.onresize = self.resize;
				self.resize ();
			});},
			get install () {return __get__ (this, function (self) {
				var __iter0__ = self.attributes;
				for (var __index0__ = 0; __index0__ < __iter0__.length; __index0__++) {
					var attribute = __iter0__ [__index0__];
					attribute.install ();
				}
			});},
			get mouseOrTouch () {return __get__ (this, function (self, key, down) {
				if (down) {
					if (key == 'space') {
						self.keyCode = space;
					}
					else {
						if (key == 'enter') {
							self.keyCode = enter;
						}
						else {
							self.keyCode = ord (key);
						}
					}
				}
				else {
					self.keyCode = null;
				}
			});},
			get update () {return __get__ (this, function (self) {
				var oldTime = self.time;
				self.time = +(new Date);
				self.deltaT = (self.time - oldTime) / 1000.0;
				if (self.pause) {
					if (self.keyCode == space) {
						self.pause = false;
					}
					else {
						if (self.keyCode == enter) {
							self.scoreboard.reset ();
						}
					}
				}
				else {
					var __iter0__ = self.attributes;
					for (var __index0__ = 0; __index0__ < __iter0__.length; __index0__++) {
						var attribute = __iter0__ [__index0__];
						attribute.predict ();
					}
					var __iter0__ = self.attributes;
					for (var __index0__ = 0; __index0__ < __iter0__.length; __index0__++) {
						var attribute = __iter0__ [__index0__];
						attribute.interact ();
					}
					var __iter0__ = self.attributes;
					for (var __index0__ = 0; __index0__ < __iter0__.length; __index0__++) {
						var attribute = __iter0__ [__index0__];
						attribute.commit ();
					}
				}
			});},
			get scored () {return __get__ (this, function (self, playerIndex) {
				self.scoreboard.increment (playerIndex);
				self.serviceIndex = 1 - playerIndex;
				var __iter0__ = self.paddles;
				for (var __index0__ = 0; __index0__ < __iter0__.length; __index0__++) {
					var paddle = __iter0__ [__index0__];
					paddle.reset ();
				}
				self.ball.reset ();
				self.pause = true;
			});},
			get commit () {return __get__ (this, function (self) {
				var __iter0__ = self.attributes;
				for (var __index0__ = 0; __index0__ < __iter0__.length; __index0__++) {
					var attribute = __iter0__ [__index0__];
					attribute.commit ();
				}
			});},
			get draw () {return __get__ (this, function (self) {
				self.canvas.clear ();
				var __iter0__ = self.attributes;
				for (var __index0__ = 0; __index0__ < __iter0__.length; __index0__++) {
					var attribute = __iter0__ [__index0__];
					attribute.draw ();
				}
			});},
			get resize () {return __get__ (this, function (self) {
				self.pageWidth = window.innerWidth;
				self.pageHeight = window.innerHeight;
				self.textTop = 0;
				if (self.pageHeight > 1.2 * self.pageWidth) {
					self.canvasWidth = self.pageWidth;
					self.canvasTop = self.textTop + 300;
				}
				else {
					self.canvasWidth = 0.6 * self.pageWidth;
					self.canvasTop = self.textTop + 200;
				}
				self.canvasLeft = 0.5 * (self.pageWidth - self.canvasWidth);
				self.canvasHeight = 0.6 * self.canvasWidth;
				self.buttonsTop = (self.canvasTop + self.canvasHeight) + 50;
				self.buttonsWidth = 500;
				self.textFrame.style.top = self.textTop;
				self.textFrame.style.left = self.canvasLeft + 0.05 * self.canvasWidth;
				self.textFrame.style.width = 0.9 * self.canvasWidth;
				self.canvasFrame.style.top = self.canvasTop;
				self.canvasFrame.style.left = self.canvasLeft;
				self.canvas.setDimensions (dict ({'width': self.canvasWidth, 'height': self.canvasHeight}));
				self.buttonsFrame.style.top = self.buttonsTop;
				self.buttonsFrame.style.left = 0.5 * (self.pageWidth - self.buttonsWidth);
				self.buttonsFrame.style.width = self.canvasWidth;
				self.install ();
				self.commit ();
				self.draw ();
			});},
			get scaleX () {return __get__ (this, function (self, x) {
				return x * (self.canvas.width / orthoWidth);
			});},
			get scaleY () {return __get__ (this, function (self, y) {
				return y * (self.canvas.height / orthoHeight);
			});},
			get orthoX () {return __get__ (this, function (self, x) {
				return self.scaleX (x + Math.floor (orthoWidth / 2));
			});},
			get orthoY () {return __get__ (this, function (self, y) {
				return self.scaleY ((orthoHeight - Math.floor (fieldHeight / 2)) - y);
			});},
			get keydown () {return __get__ (this, function (self, event) {
				self.keyCode = event.keyCode;
			});},
			get keyup () {return __get__ (this, function (self, event) {
				self.keyCode = null;
			});}
		});
		var game = Game ();
		__pragma__ ('<use>' +
			'com.fabricjs' +
		'</use>')
		__pragma__ ('<all>')
			__all__.Attribute = Attribute;
			__all__.Ball = Ball;
			__all__.Game = Game;
			__all__.Paddle = Paddle;
			__all__.Scoreboard = Scoreboard;
			__all__.Sprite = Sprite;
			__all__.enter = enter;
			__all__.esc = esc;
			__all__.fieldHeight = fieldHeight;
			__all__.game = game;
			__all__.orthoHeight = orthoHeight;
			__all__.orthoWidth = orthoWidth;
			__all__.space = space;
		__pragma__ ('</all>')
	}) ();
	return __all__;
}
window ['pong'] = pong ();

//# sourceMappingURL=extra/sourcemap/pong.js.map
