# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ActiveDirectoryObject(Model):
    """The Active Directory Object that will be used for authenticating the token
    of a container registry.

    :param object_id: The user/group/application object ID for Active
     Directory Object that will be used for authenticating the token of a
     container registry.
    :type object_id: str
    :param tenant_id: The tenant ID of user/group/application object Active
     Directory Object that will be used for authenticating the token of a
     container registry.
    :type tenant_id: str
    """

    _attribute_map = {
        'object_id': {'key': 'objectId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(self, *, object_id: str=None, tenant_id: str=None, **kwargs) -> None:
        super(ActiveDirectoryObject, self).__init__(**kwargs)
        self.object_id = object_id
        self.tenant_id = tenant_id


class Actor(Model):
    """The agent that initiated the event. For most situations, this could be from
    the authorization context of the request.

    :param name: The subject or username associated with the request context
     that generated the event.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, **kwargs) -> None:
        super(Actor, self).__init__(**kwargs)
        self.name = name


class CallbackConfig(Model):
    """The configuration of service URI and custom headers for the webhook.

    All required parameters must be populated in order to send to Azure.

    :param service_uri: Required. The service URI for the webhook to post
     notifications.
    :type service_uri: str
    :param custom_headers: Custom headers that will be added to the webhook
     notifications.
    :type custom_headers: dict[str, str]
    """

    _validation = {
        'service_uri': {'required': True},
    }

    _attribute_map = {
        'service_uri': {'key': 'serviceUri', 'type': 'str'},
        'custom_headers': {'key': 'customHeaders', 'type': '{str}'},
    }

    def __init__(self, *, service_uri: str, custom_headers=None, **kwargs) -> None:
        super(CallbackConfig, self).__init__(**kwargs)
        self.service_uri = service_uri
        self.custom_headers = custom_headers


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class EventInfo(Model):
    """The basic information of an event.

    :param id: The event ID.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, **kwargs) -> None:
        super(EventInfo, self).__init__(**kwargs)
        self.id = id


class Event(EventInfo):
    """The event for a webhook.

    :param id: The event ID.
    :type id: str
    :param event_request_message: The event request message sent to the
     service URI.
    :type event_request_message:
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.EventRequestMessage
    :param event_response_message: The event response message received from
     the service URI.
    :type event_response_message:
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.EventResponseMessage
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'event_request_message': {'key': 'eventRequestMessage', 'type': 'EventRequestMessage'},
        'event_response_message': {'key': 'eventResponseMessage', 'type': 'EventResponseMessage'},
    }

    def __init__(self, *, id: str=None, event_request_message=None, event_response_message=None, **kwargs) -> None:
        super(Event, self).__init__(id=id, **kwargs)
        self.event_request_message = event_request_message
        self.event_response_message = event_response_message


class EventContent(Model):
    """The content of the event request message.

    :param id: The event ID.
    :type id: str
    :param timestamp: The time at which the event occurred.
    :type timestamp: datetime
    :param action: The action that encompasses the provided event.
    :type action: str
    :param target: The target of the event.
    :type target:
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.Target
    :param request: The request that generated the event.
    :type request:
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.Request
    :param actor: The agent that initiated the event. For most situations,
     this could be from the authorization context of the request.
    :type actor:
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.Actor
    :param source: The registry node that generated the event. Put
     differently, while the actor initiates the event, the source generates it.
    :type source:
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.Source
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'action': {'key': 'action', 'type': 'str'},
        'target': {'key': 'target', 'type': 'Target'},
        'request': {'key': 'request', 'type': 'Request'},
        'actor': {'key': 'actor', 'type': 'Actor'},
        'source': {'key': 'source', 'type': 'Source'},
    }

    def __init__(self, *, id: str=None, timestamp=None, action: str=None, target=None, request=None, actor=None, source=None, **kwargs) -> None:
        super(EventContent, self).__init__(**kwargs)
        self.id = id
        self.timestamp = timestamp
        self.action = action
        self.target = target
        self.request = request
        self.actor = actor
        self.source = source


class EventRequestMessage(Model):
    """The event request message sent to the service URI.

    :param content: The content of the event request message.
    :type content:
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.EventContent
    :param headers: The headers of the event request message.
    :type headers: dict[str, str]
    :param method: The HTTP method used to send the event request message.
    :type method: str
    :param request_uri: The URI used to send the event request message.
    :type request_uri: str
    :param version: The HTTP message version.
    :type version: str
    """

    _attribute_map = {
        'content': {'key': 'content', 'type': 'EventContent'},
        'headers': {'key': 'headers', 'type': '{str}'},
        'method': {'key': 'method', 'type': 'str'},
        'request_uri': {'key': 'requestUri', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(self, *, content=None, headers=None, method: str=None, request_uri: str=None, version: str=None, **kwargs) -> None:
        super(EventRequestMessage, self).__init__(**kwargs)
        self.content = content
        self.headers = headers
        self.method = method
        self.request_uri = request_uri
        self.version = version


class EventResponseMessage(Model):
    """The event response message received from the service URI.

    :param content: The content of the event response message.
    :type content: str
    :param headers: The headers of the event response message.
    :type headers: dict[str, str]
    :param reason_phrase: The reason phrase of the event response message.
    :type reason_phrase: str
    :param status_code: The status code of the event response message.
    :type status_code: str
    :param version: The HTTP message version.
    :type version: str
    """

    _attribute_map = {
        'content': {'key': 'content', 'type': 'str'},
        'headers': {'key': 'headers', 'type': '{str}'},
        'reason_phrase': {'key': 'reasonPhrase', 'type': 'str'},
        'status_code': {'key': 'statusCode', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(self, *, content: str=None, headers=None, reason_phrase: str=None, status_code: str=None, version: str=None, **kwargs) -> None:
        super(EventResponseMessage, self).__init__(**kwargs)
        self.content = content
        self.headers = headers
        self.reason_phrase = reason_phrase
        self.status_code = status_code
        self.version = version


class GenerateCredentialsParameters(Model):
    """The parameters used to generate credentials for a specified token or user
    of a container registry.

    :param token_id: The resource ID of the token for which credentials have
     to be generated.
    :type token_id: str
    :param expiry: The expiry date of the generated credentials after which
     the credentials become invalid.
    :type expiry: datetime
    :param name: Specifies name of the password which should be regenerated if
     any -- password1 or password2. Possible values include: 'password1',
     'password2'
    :type name: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.TokenPasswordName
    """

    _attribute_map = {
        'token_id': {'key': 'tokenId', 'type': 'str'},
        'expiry': {'key': 'expiry', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, token_id: str=None, expiry=None, name=None, **kwargs) -> None:
        super(GenerateCredentialsParameters, self).__init__(**kwargs)
        self.token_id = token_id
        self.expiry = expiry
        self.name = name


class GenerateCredentialsResult(Model):
    """The response from the GenerateCredentials operation.

    :param username: The username for a container registry.
    :type username: str
    :param passwords: The list of passwords for a container registry.
    :type passwords:
     list[~azure.mgmt.containerregistry.v2019_05_01_preview.models.TokenPassword]
    """

    _attribute_map = {
        'username': {'key': 'username', 'type': 'str'},
        'passwords': {'key': 'passwords', 'type': '[TokenPassword]'},
    }

    def __init__(self, *, username: str=None, passwords=None, **kwargs) -> None:
        super(GenerateCredentialsResult, self).__init__(**kwargs)
        self.username = username
        self.passwords = passwords


class ImportImageParameters(Model):
    """ImportImageParameters.

    All required parameters must be populated in order to send to Azure.

    :param source: Required. The source of the image.
    :type source:
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.ImportSource
    :param target_tags: List of strings of the form repo[:tag]. When tag is
     omitted the source will be used (or 'latest' if source tag is also
     omitted).
    :type target_tags: list[str]
    :param untagged_target_repositories: List of strings of repository names
     to do a manifest only copy. No tag will be created.
    :type untagged_target_repositories: list[str]
    :param mode: When Force, any existing target tags will be overwritten.
     When NoForce, any existing target tags will fail the operation before any
     copying begins. Possible values include: 'NoForce', 'Force'. Default
     value: "NoForce" .
    :type mode: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.ImportMode
    """

    _validation = {
        'source': {'required': True},
    }

    _attribute_map = {
        'source': {'key': 'source', 'type': 'ImportSource'},
        'target_tags': {'key': 'targetTags', 'type': '[str]'},
        'untagged_target_repositories': {'key': 'untaggedTargetRepositories', 'type': '[str]'},
        'mode': {'key': 'mode', 'type': 'str'},
    }

    def __init__(self, *, source, target_tags=None, untagged_target_repositories=None, mode="NoForce", **kwargs) -> None:
        super(ImportImageParameters, self).__init__(**kwargs)
        self.source = source
        self.target_tags = target_tags
        self.untagged_target_repositories = untagged_target_repositories
        self.mode = mode


class ImportSource(Model):
    """ImportSource.

    All required parameters must be populated in order to send to Azure.

    :param resource_id: The resource identifier of the source Azure Container
     Registry.
    :type resource_id: str
    :param registry_uri: The address of the source registry (e.g.
     'mcr.microsoft.com').
    :type registry_uri: str
    :param credentials: Credentials used when importing from a registry uri.
    :type credentials:
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.ImportSourceCredentials
    :param source_image: Required. Repository name of the source image.
     Specify an image by repository ('hello-world'). This will use the 'latest'
     tag.
     Specify an image by tag ('hello-world:latest').
     Specify an image by sha256-based manifest digest
     ('hello-world@sha256:abc123').
    :type source_image: str
    """

    _validation = {
        'source_image': {'required': True},
    }

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'registry_uri': {'key': 'registryUri', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'ImportSourceCredentials'},
        'source_image': {'key': 'sourceImage', 'type': 'str'},
    }

    def __init__(self, *, source_image: str, resource_id: str=None, registry_uri: str=None, credentials=None, **kwargs) -> None:
        super(ImportSource, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.registry_uri = registry_uri
        self.credentials = credentials
        self.source_image = source_image


class ImportSourceCredentials(Model):
    """ImportSourceCredentials.

    All required parameters must be populated in order to send to Azure.

    :param username: The username to authenticate with the source registry.
    :type username: str
    :param password: Required. The password used to authenticate with the
     source registry.
    :type password: str
    """

    _validation = {
        'password': {'required': True},
    }

    _attribute_map = {
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(self, *, password: str, username: str=None, **kwargs) -> None:
        super(ImportSourceCredentials, self).__init__(**kwargs)
        self.username = username
        self.password = password


class IPRule(Model):
    """IP rule with specific IP or IP range in CIDR format.

    All required parameters must be populated in order to send to Azure.

    :param action: The action of IP ACL rule. Possible values include:
     'Allow'. Default value: "Allow" .
    :type action: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.Action
    :param ip_address_or_range: Required. Specifies the IP or IP range in CIDR
     format. Only IPV4 address is allowed.
    :type ip_address_or_range: str
    """

    _validation = {
        'ip_address_or_range': {'required': True},
    }

    _attribute_map = {
        'action': {'key': 'action', 'type': 'str'},
        'ip_address_or_range': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, *, ip_address_or_range: str, action="Allow", **kwargs) -> None:
        super(IPRule, self).__init__(**kwargs)
        self.action = action
        self.ip_address_or_range = ip_address_or_range


class NetworkRuleSet(Model):
    """The network rule set for a container registry.

    All required parameters must be populated in order to send to Azure.

    :param default_action: Required. The default action of allow or deny when
     no other rules match. Possible values include: 'Allow', 'Deny'. Default
     value: "Allow" .
    :type default_action: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.DefaultAction
    :param virtual_network_rules: The virtual network rules.
    :type virtual_network_rules:
     list[~azure.mgmt.containerregistry.v2019_05_01_preview.models.VirtualNetworkRule]
    :param ip_rules: The IP ACL rules.
    :type ip_rules:
     list[~azure.mgmt.containerregistry.v2019_05_01_preview.models.IPRule]
    """

    _validation = {
        'default_action': {'required': True},
    }

    _attribute_map = {
        'default_action': {'key': 'defaultAction', 'type': 'str'},
        'virtual_network_rules': {'key': 'virtualNetworkRules', 'type': '[VirtualNetworkRule]'},
        'ip_rules': {'key': 'ipRules', 'type': '[IPRule]'},
    }

    def __init__(self, *, default_action="Allow", virtual_network_rules=None, ip_rules=None, **kwargs) -> None:
        super(NetworkRuleSet, self).__init__(**kwargs)
        self.default_action = default_action
        self.virtual_network_rules = virtual_network_rules
        self.ip_rules = ip_rules


class OperationDefinition(Model):
    """The definition of a container registry operation.

    :param origin: The origin information of the container registry operation.
    :type origin: str
    :param name: Operation name: {provider}/{resource}/{operation}.
    :type name: str
    :param display: The display information for the container registry
     operation.
    :type display:
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.OperationDisplayDefinition
    :param service_specification: The definition of Azure Monitoring service.
    :type service_specification:
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.OperationServiceSpecificationDefinition
    """

    _attribute_map = {
        'origin': {'key': 'origin', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplayDefinition'},
        'service_specification': {'key': 'properties.serviceSpecification', 'type': 'OperationServiceSpecificationDefinition'},
    }

    def __init__(self, *, origin: str=None, name: str=None, display=None, service_specification=None, **kwargs) -> None:
        super(OperationDefinition, self).__init__(**kwargs)
        self.origin = origin
        self.name = name
        self.display = display
        self.service_specification = service_specification


class OperationDisplayDefinition(Model):
    """The display information for a container registry operation.

    :param provider: The resource provider name: Microsoft.ContainerRegistry.
    :type provider: str
    :param resource: The resource on which the operation is performed.
    :type resource: str
    :param operation: The operation that users can perform.
    :type operation: str
    :param description: The description for the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, *, provider: str=None, resource: str=None, operation: str=None, description: str=None, **kwargs) -> None:
        super(OperationDisplayDefinition, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationMetricSpecificationDefinition(Model):
    """The definition of Azure Monitoring metric.

    :param name: Metric name.
    :type name: str
    :param display_name: Metric display name.
    :type display_name: str
    :param display_description: Metric description.
    :type display_description: str
    :param unit: Metric unit.
    :type unit: str
    :param aggregation_type: Metric aggregation type.
    :type aggregation_type: str
    :param internal_metric_name: Internal metric name.
    :type internal_metric_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'internal_metric_name': {'key': 'internalMetricName', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, display_name: str=None, display_description: str=None, unit: str=None, aggregation_type: str=None, internal_metric_name: str=None, **kwargs) -> None:
        super(OperationMetricSpecificationDefinition, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.aggregation_type = aggregation_type
        self.internal_metric_name = internal_metric_name


class OperationServiceSpecificationDefinition(Model):
    """The definition of Azure Monitoring metrics list.

    :param metric_specifications: A list of Azure Monitoring metrics
     definition.
    :type metric_specifications:
     list[~azure.mgmt.containerregistry.v2019_05_01_preview.models.OperationMetricSpecificationDefinition]
    """

    _attribute_map = {
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[OperationMetricSpecificationDefinition]'},
    }

    def __init__(self, *, metric_specifications=None, **kwargs) -> None:
        super(OperationServiceSpecificationDefinition, self).__init__(**kwargs)
        self.metric_specifications = metric_specifications


class ProxyResource(Model):
    """The resource model definition for a ARM proxy resource. It will have
    everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification
     of the resource.
    :vartype system_data:
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(self, **kwargs) -> None:
        super(ProxyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class QuarantinePolicy(Model):
    """An object that represents quarantine policy for a container registry.

    :param status: The value that indicates whether the policy is enabled or
     not. Possible values include: 'enabled', 'disabled'
    :type status: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.PolicyStatus
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(self, *, status=None, **kwargs) -> None:
        super(QuarantinePolicy, self).__init__(**kwargs)
        self.status = status


class RegenerateCredentialParameters(Model):
    """The parameters used to regenerate the login credential.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Specifies name of the password which should be
     regenerated -- password or password2. Possible values include: 'password',
     'password2'
    :type name: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.PasswordName
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'PasswordName'},
    }

    def __init__(self, *, name, **kwargs) -> None:
        super(RegenerateCredentialParameters, self).__init__(**kwargs)
        self.name = name


class Resource(Model):
    """An Azure resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: Required. The location of the resource. This cannot be
     changed after the resource is created.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, location: str, tags=None, **kwargs) -> None:
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class Registry(Resource):
    """An object that represents a container registry.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: Required. The location of the resource. This cannot be
     changed after the resource is created.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param sku: Required. The SKU of the container registry.
    :type sku: ~azure.mgmt.containerregistry.v2019_05_01_preview.models.Sku
    :ivar login_server: The URL that can be used to log into the container
     registry.
    :vartype login_server: str
    :ivar creation_date: The creation date of the container registry in
     ISO8601 format.
    :vartype creation_date: datetime
    :ivar provisioning_state: The provisioning state of the container registry
     at the time the operation was called. Possible values include: 'Creating',
     'Updating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.ProvisioningState
    :ivar status: The status of the container registry at the time the
     operation was called.
    :vartype status:
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.Status
    :param admin_user_enabled: The value that indicates whether the admin user
     is enabled. Default value: False .
    :type admin_user_enabled: bool
    :param storage_account: The properties of the storage account for the
     container registry. Only applicable to Classic SKU.
    :type storage_account:
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.StorageAccountProperties
    :param network_rule_set: The network rule set for a container registry.
    :type network_rule_set:
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.NetworkRuleSet
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'sku': {'required': True},
        'login_server': {'readonly': True},
        'creation_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'login_server': {'key': 'properties.loginServer', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'Status'},
        'admin_user_enabled': {'key': 'properties.adminUserEnabled', 'type': 'bool'},
        'storage_account': {'key': 'properties.storageAccount', 'type': 'StorageAccountProperties'},
        'network_rule_set': {'key': 'properties.networkRuleSet', 'type': 'NetworkRuleSet'},
    }

    def __init__(self, *, location: str, sku, tags=None, admin_user_enabled: bool=False, storage_account=None, network_rule_set=None, **kwargs) -> None:
        super(Registry, self).__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.login_server = None
        self.creation_date = None
        self.provisioning_state = None
        self.status = None
        self.admin_user_enabled = admin_user_enabled
        self.storage_account = storage_account
        self.network_rule_set = network_rule_set


class RegistryListCredentialsResult(Model):
    """The response from the ListCredentials operation.

    :param username: The username for a container registry.
    :type username: str
    :param passwords: The list of passwords for a container registry.
    :type passwords:
     list[~azure.mgmt.containerregistry.v2019_05_01_preview.models.RegistryPassword]
    """

    _attribute_map = {
        'username': {'key': 'username', 'type': 'str'},
        'passwords': {'key': 'passwords', 'type': '[RegistryPassword]'},
    }

    def __init__(self, *, username: str=None, passwords=None, **kwargs) -> None:
        super(RegistryListCredentialsResult, self).__init__(**kwargs)
        self.username = username
        self.passwords = passwords


class RegistryNameCheckRequest(Model):
    """A request to check whether a container registry name is available.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the container registry.
    :type name: str
    :ivar type: Required. The resource type of the container registry. This
     field must be set to 'Microsoft.ContainerRegistry/registries'. Default
     value: "Microsoft.ContainerRegistry/registries" .
    :vartype type: str
    """

    _validation = {
        'name': {'required': True, 'max_length': 50, 'min_length': 5, 'pattern': r'^[a-zA-Z0-9]*$'},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.ContainerRegistry/registries"

    def __init__(self, *, name: str, **kwargs) -> None:
        super(RegistryNameCheckRequest, self).__init__(**kwargs)
        self.name = name


class RegistryNameStatus(Model):
    """The result of a request to check the availability of a container registry
    name.

    :param name_available: The value that indicates whether the name is
     available.
    :type name_available: bool
    :param reason: If any, the reason that the name is not available.
    :type reason: str
    :param message: If any, the error message that provides more detail for
     the reason that the name is not available.
    :type message: str
    """

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, *, name_available: bool=None, reason: str=None, message: str=None, **kwargs) -> None:
        super(RegistryNameStatus, self).__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = message


class RegistryPassword(Model):
    """The login password for the container registry.

    :param name: The password name. Possible values include: 'password',
     'password2'
    :type name: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.PasswordName
    :param value: The password value.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'PasswordName'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, *, name=None, value: str=None, **kwargs) -> None:
        super(RegistryPassword, self).__init__(**kwargs)
        self.name = name
        self.value = value


class RegistryPolicies(Model):
    """An object that represents policies for a container registry.

    :param quarantine_policy: An object that represents quarantine policy for
     a container registry.
    :type quarantine_policy:
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.QuarantinePolicy
    :param trust_policy: An object that represents content trust policy for a
     container registry.
    :type trust_policy:
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.TrustPolicy
    """

    _attribute_map = {
        'quarantine_policy': {'key': 'quarantinePolicy', 'type': 'QuarantinePolicy'},
        'trust_policy': {'key': 'trustPolicy', 'type': 'TrustPolicy'},
    }

    def __init__(self, *, quarantine_policy=None, trust_policy=None, **kwargs) -> None:
        super(RegistryPolicies, self).__init__(**kwargs)
        self.quarantine_policy = quarantine_policy
        self.trust_policy = trust_policy


class RegistryUpdateParameters(Model):
    """The parameters for updating a container registry.

    :param tags: The tags for the container registry.
    :type tags: dict[str, str]
    :param sku: The SKU of the container registry.
    :type sku: ~azure.mgmt.containerregistry.v2019_05_01_preview.models.Sku
    :param admin_user_enabled: The value that indicates whether the admin user
     is enabled.
    :type admin_user_enabled: bool
    :param storage_account: The parameters of a storage account for the
     container registry. Only applicable to Classic SKU. If specified, the
     storage account must be in the same physical location as the container
     registry.
    :type storage_account:
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.StorageAccountProperties
    :param network_rule_set: The network rule set for a container registry.
    :type network_rule_set:
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.NetworkRuleSet
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'admin_user_enabled': {'key': 'properties.adminUserEnabled', 'type': 'bool'},
        'storage_account': {'key': 'properties.storageAccount', 'type': 'StorageAccountProperties'},
        'network_rule_set': {'key': 'properties.networkRuleSet', 'type': 'NetworkRuleSet'},
    }

    def __init__(self, *, tags=None, sku=None, admin_user_enabled: bool=None, storage_account=None, network_rule_set=None, **kwargs) -> None:
        super(RegistryUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.sku = sku
        self.admin_user_enabled = admin_user_enabled
        self.storage_account = storage_account
        self.network_rule_set = network_rule_set


class RegistryUsage(Model):
    """The quota usage for a container registry.

    :param name: The name of the usage.
    :type name: str
    :param limit: The limit of the usage.
    :type limit: long
    :param current_value: The current value of the usage.
    :type current_value: long
    :param unit: The unit of measurement. Possible values include: 'Count',
     'Bytes'
    :type unit: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.RegistryUsageUnit
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'limit': {'key': 'limit', 'type': 'long'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'unit': {'key': 'unit', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, limit: int=None, current_value: int=None, unit=None, **kwargs) -> None:
        super(RegistryUsage, self).__init__(**kwargs)
        self.name = name
        self.limit = limit
        self.current_value = current_value
        self.unit = unit


class RegistryUsageListResult(Model):
    """The result of a request to get container registry quota usages.

    :param value: The list of container registry quota usages.
    :type value:
     list[~azure.mgmt.containerregistry.v2019_05_01_preview.models.RegistryUsage]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RegistryUsage]'},
    }

    def __init__(self, *, value=None, **kwargs) -> None:
        super(RegistryUsageListResult, self).__init__(**kwargs)
        self.value = value


class Replication(Resource):
    """An object that represents a replication for a container registry.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: Required. The location of the resource. This cannot be
     changed after the resource is created.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :ivar provisioning_state: The provisioning state of the replication at the
     time the operation was called. Possible values include: 'Creating',
     'Updating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.ProvisioningState
    :ivar status: The status of the replication at the time the operation was
     called.
    :vartype status:
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.Status
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'Status'},
    }

    def __init__(self, *, location: str, tags=None, **kwargs) -> None:
        super(Replication, self).__init__(location=location, tags=tags, **kwargs)
        self.provisioning_state = None
        self.status = None


class ReplicationUpdateParameters(Model):
    """The parameters for updating a replication.

    :param tags: The tags for the replication.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, tags=None, **kwargs) -> None:
        super(ReplicationUpdateParameters, self).__init__(**kwargs)
        self.tags = tags


class Request(Model):
    """The request that generated the event.

    :param id: The ID of the request that initiated the event.
    :type id: str
    :param addr: The IP or hostname and possibly port of the client connection
     that initiated the event. This is the RemoteAddr from the standard http
     request.
    :type addr: str
    :param host: The externally accessible hostname of the registry instance,
     as specified by the http host header on incoming requests.
    :type host: str
    :param method: The request method that generated the event.
    :type method: str
    :param useragent: The user agent header of the request.
    :type useragent: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'addr': {'key': 'addr', 'type': 'str'},
        'host': {'key': 'host', 'type': 'str'},
        'method': {'key': 'method', 'type': 'str'},
        'useragent': {'key': 'useragent', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, addr: str=None, host: str=None, method: str=None, useragent: str=None, **kwargs) -> None:
        super(Request, self).__init__(**kwargs)
        self.id = id
        self.addr = addr
        self.host = host
        self.method = method
        self.useragent = useragent


class ScopeMap(ProxyResource):
    """An object that represents a scope map for a container registry.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification
     of the resource.
    :vartype system_data:
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.SystemData
    :param description: The user friendly description of the scope map.
    :type description: str
    :ivar scope_map_type: The type of the scope map. E.g. BuildIn scope map.
    :vartype scope_map_type: str
    :ivar creation_date: The creation date of scope map.
    :vartype creation_date: datetime
    :ivar provisioning_state: Provisioning state of the resource. Possible
     values include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed',
     'Canceled'
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.ProvisioningState
    :param actions: Required. The list of scoped permissions for registry
     artifacts.
     E.g. repositories/repository-name/content/read,
     repositories/repository-name/metadata/write
    :type actions: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'scope_map_type': {'readonly': True},
        'creation_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'actions': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'scope_map_type': {'key': 'properties.type', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'actions': {'key': 'properties.actions', 'type': '[str]'},
    }

    def __init__(self, *, actions, description: str=None, **kwargs) -> None:
        super(ScopeMap, self).__init__(**kwargs)
        self.description = description
        self.scope_map_type = None
        self.creation_date = None
        self.provisioning_state = None
        self.actions = actions


class ScopeMapUpdateParameters(Model):
    """The properties for updating the scope map.

    :param description: The user friendly description of the scope map.
    :type description: str
    :param actions: The list of scope permissions for registry artifacts.
     E.g. repositories/repository-name/pull,
     repositories/repository-name/delete
    :type actions: list[str]
    """

    _attribute_map = {
        'description': {'key': 'properties.description', 'type': 'str'},
        'actions': {'key': 'properties.actions', 'type': '[str]'},
    }

    def __init__(self, *, description: str=None, actions=None, **kwargs) -> None:
        super(ScopeMapUpdateParameters, self).__init__(**kwargs)
        self.description = description
        self.actions = actions


class Sku(Model):
    """The SKU of a container registry.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The SKU name of the container registry. Required
     for registry creation. Possible values include: 'Classic', 'Basic',
     'Standard', 'Premium'
    :type name: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.SkuName
    :ivar tier: The SKU tier based on the SKU name. Possible values include:
     'Classic', 'Basic', 'Standard', 'Premium'
    :vartype tier: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.SkuTier
    """

    _validation = {
        'name': {'required': True},
        'tier': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(self, *, name, **kwargs) -> None:
        super(Sku, self).__init__(**kwargs)
        self.name = name
        self.tier = None


class Source(Model):
    """The registry node that generated the event. Put differently, while the
    actor initiates the event, the source generates it.

    :param addr: The IP or hostname and the port of the registry node that
     generated the event. Generally, this will be resolved by os.Hostname()
     along with the running port.
    :type addr: str
    :param instance_id: The running instance of an application. Changes after
     each restart.
    :type instance_id: str
    """

    _attribute_map = {
        'addr': {'key': 'addr', 'type': 'str'},
        'instance_id': {'key': 'instanceID', 'type': 'str'},
    }

    def __init__(self, *, addr: str=None, instance_id: str=None, **kwargs) -> None:
        super(Source, self).__init__(**kwargs)
        self.addr = addr
        self.instance_id = instance_id


class Status(Model):
    """The status of an Azure resource at the time the operation was called.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar display_status: The short label for the status.
    :vartype display_status: str
    :ivar message: The detailed message for the status, including alerts and
     error messages.
    :vartype message: str
    :ivar timestamp: The timestamp when the status was changed to the current
     value.
    :vartype timestamp: datetime
    """

    _validation = {
        'display_status': {'readonly': True},
        'message': {'readonly': True},
        'timestamp': {'readonly': True},
    }

    _attribute_map = {
        'display_status': {'key': 'displayStatus', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs) -> None:
        super(Status, self).__init__(**kwargs)
        self.display_status = None
        self.message = None
        self.timestamp = None


class StorageAccountProperties(Model):
    """The properties of a storage account for a container registry. Only
    applicable to Classic SKU.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The resource ID of the storage account.
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, id: str, **kwargs) -> None:
        super(StorageAccountProperties, self).__init__(**kwargs)
        self.id = id


class SystemData(Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource.
     Possible values include: 'User', 'Application', 'ManagedIdentity', 'Key'
    :type created_by_type: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the
     resource. Possible values include: 'User', 'Application',
     'ManagedIdentity', 'Key'
    :type last_modified_by_type: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.LastModifiedByType
    :param last_modified_at: The timestamp of resource modification (UTC).
    :type last_modified_at: datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(self, *, created_by: str=None, created_by_type=None, created_at=None, last_modified_by: str=None, last_modified_by_type=None, last_modified_at=None, **kwargs) -> None:
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class Target(Model):
    """The target of the event.

    :param media_type: The MIME type of the referenced object.
    :type media_type: str
    :param size: The number of bytes of the content. Same as Length field.
    :type size: long
    :param digest: The digest of the content, as defined by the Registry V2
     HTTP API Specification.
    :type digest: str
    :param length: The number of bytes of the content. Same as Size field.
    :type length: long
    :param repository: The repository name.
    :type repository: str
    :param url: The direct URL to the content.
    :type url: str
    :param tag: The tag name.
    :type tag: str
    :param name: The name of the artifact.
    :type name: str
    :param version: The version of the artifact.
    :type version: str
    """

    _attribute_map = {
        'media_type': {'key': 'mediaType', 'type': 'str'},
        'size': {'key': 'size', 'type': 'long'},
        'digest': {'key': 'digest', 'type': 'str'},
        'length': {'key': 'length', 'type': 'long'},
        'repository': {'key': 'repository', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(self, *, media_type: str=None, size: int=None, digest: str=None, length: int=None, repository: str=None, url: str=None, tag: str=None, name: str=None, version: str=None, **kwargs) -> None:
        super(Target, self).__init__(**kwargs)
        self.media_type = media_type
        self.size = size
        self.digest = digest
        self.length = length
        self.repository = repository
        self.url = url
        self.tag = tag
        self.name = name
        self.version = version


class Token(ProxyResource):
    """An object that represents a token for a container registry.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification
     of the resource.
    :vartype system_data:
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.SystemData
    :ivar creation_date: The creation date of scope map.
    :vartype creation_date: datetime
    :ivar provisioning_state: Provisioning state of the resource. Possible
     values include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed',
     'Canceled'
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.ProvisioningState
    :param scope_map_id: The resource ID of the scope map to which the token
     will be associated with.
    :type scope_map_id: str
    :param credentials: The credentials that can be used for authenticating
     the token.
    :type credentials:
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.TokenCredentialsProperties
    :param status: The status of the token example enabled or disabled.
     Possible values include: 'enabled', 'disabled'
    :type status: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.TokenStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'creation_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'scope_map_id': {'key': 'properties.scopeMapId', 'type': 'str'},
        'credentials': {'key': 'properties.credentials', 'type': 'TokenCredentialsProperties'},
        'status': {'key': 'properties.status', 'type': 'str'},
    }

    def __init__(self, *, scope_map_id: str=None, credentials=None, status=None, **kwargs) -> None:
        super(Token, self).__init__(**kwargs)
        self.creation_date = None
        self.provisioning_state = None
        self.scope_map_id = scope_map_id
        self.credentials = credentials
        self.status = status


class TokenCertificate(Model):
    """The properties of a certificate used for authenticating a token.

    :param name: Possible values include: 'certificate1', 'certificate2'
    :type name: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.TokenCertificateName
    :param expiry: The expiry datetime of the certificate.
    :type expiry: datetime
    :param thumbprint: The thumbprint of the certificate.
    :type thumbprint: str
    :param encoded_pem_certificate: Base 64 encoded string of the public
     certificate1 in PEM format that will be used for authenticating the token.
    :type encoded_pem_certificate: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'expiry': {'key': 'expiry', 'type': 'iso-8601'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'encoded_pem_certificate': {'key': 'encodedPemCertificate', 'type': 'str'},
    }

    def __init__(self, *, name=None, expiry=None, thumbprint: str=None, encoded_pem_certificate: str=None, **kwargs) -> None:
        super(TokenCertificate, self).__init__(**kwargs)
        self.name = name
        self.expiry = expiry
        self.thumbprint = thumbprint
        self.encoded_pem_certificate = encoded_pem_certificate


class TokenCredentialsProperties(Model):
    """The properties of the credentials that can be used for authenticating the
    token.

    :param active_directory_object:
    :type active_directory_object:
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.ActiveDirectoryObject
    :param certificates:
    :type certificates:
     list[~azure.mgmt.containerregistry.v2019_05_01_preview.models.TokenCertificate]
    :param passwords:
    :type passwords:
     list[~azure.mgmt.containerregistry.v2019_05_01_preview.models.TokenPassword]
    """

    _attribute_map = {
        'active_directory_object': {'key': 'activeDirectoryObject', 'type': 'ActiveDirectoryObject'},
        'certificates': {'key': 'certificates', 'type': '[TokenCertificate]'},
        'passwords': {'key': 'passwords', 'type': '[TokenPassword]'},
    }

    def __init__(self, *, active_directory_object=None, certificates=None, passwords=None, **kwargs) -> None:
        super(TokenCredentialsProperties, self).__init__(**kwargs)
        self.active_directory_object = active_directory_object
        self.certificates = certificates
        self.passwords = passwords


class TokenPassword(Model):
    """The password that will be used for authenticating the token of a container
    registry.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param creation_time: The creation datetime of the password.
    :type creation_time: datetime
    :param expiry: The expiry datetime of the password.
    :type expiry: datetime
    :param name: The password name "password1" or "password2". Possible values
     include: 'password1', 'password2'
    :type name: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.TokenPasswordName
    :ivar value: The password value.
    :vartype value: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'expiry': {'key': 'expiry', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, *, creation_time=None, expiry=None, name=None, **kwargs) -> None:
        super(TokenPassword, self).__init__(**kwargs)
        self.creation_time = creation_time
        self.expiry = expiry
        self.name = name
        self.value = None


class TokenUpdateParameters(Model):
    """The parameters for updating a token.

    :param scope_map_id: The resource ID of the scope map to which the token
     will be associated with.
    :type scope_map_id: str
    :param status: The status of the token example enabled or disabled.
     Possible values include: 'enabled', 'disabled'
    :type status: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.TokenStatus
    :param credentials: The credentials that can be used for authenticating
     the token.
    :type credentials:
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.TokenCredentialsProperties
    """

    _attribute_map = {
        'scope_map_id': {'key': 'properties.scopeMapId', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'credentials': {'key': 'properties.credentials', 'type': 'TokenCredentialsProperties'},
    }

    def __init__(self, *, scope_map_id: str=None, status=None, credentials=None, **kwargs) -> None:
        super(TokenUpdateParameters, self).__init__(**kwargs)
        self.scope_map_id = scope_map_id
        self.status = status
        self.credentials = credentials


class TrustPolicy(Model):
    """An object that represents content trust policy for a container registry.

    :param type: The type of trust policy. Possible values include: 'Notary'
    :type type: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.TrustPolicyType
    :param status: The value that indicates whether the policy is enabled or
     not. Possible values include: 'enabled', 'disabled'
    :type status: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.PolicyStatus
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(self, *, type=None, status=None, **kwargs) -> None:
        super(TrustPolicy, self).__init__(**kwargs)
        self.type = type
        self.status = status


class VirtualNetworkRule(Model):
    """Virtual network rule.

    All required parameters must be populated in order to send to Azure.

    :param action: The action of virtual network rule. Possible values
     include: 'Allow'. Default value: "Allow" .
    :type action: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.Action
    :param virtual_network_resource_id: Required. Resource ID of a subnet, for
     example:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
    :type virtual_network_resource_id: str
    """

    _validation = {
        'virtual_network_resource_id': {'required': True},
    }

    _attribute_map = {
        'action': {'key': 'action', 'type': 'str'},
        'virtual_network_resource_id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, virtual_network_resource_id: str, action="Allow", **kwargs) -> None:
        super(VirtualNetworkRule, self).__init__(**kwargs)
        self.action = action
        self.virtual_network_resource_id = virtual_network_resource_id


class Webhook(Resource):
    """An object that represents a webhook for a container registry.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: Required. The location of the resource. This cannot be
     changed after the resource is created.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param status: The status of the webhook at the time the operation was
     called. Possible values include: 'enabled', 'disabled'
    :type status: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.WebhookStatus
    :param scope: The scope of repositories where the event can be triggered.
     For example, 'foo:*' means events for all tags under repository 'foo'.
     'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to
     'foo:latest'. Empty means all events.
    :type scope: str
    :param actions: Required. The list of actions that trigger the webhook to
     post notifications.
    :type actions: list[str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.WebhookAction]
    :ivar provisioning_state: The provisioning state of the webhook at the
     time the operation was called. Possible values include: 'Creating',
     'Updating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'actions': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'actions': {'key': 'properties.actions', 'type': '[str]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, *, location: str, actions, tags=None, status=None, scope: str=None, **kwargs) -> None:
        super(Webhook, self).__init__(location=location, tags=tags, **kwargs)
        self.status = status
        self.scope = scope
        self.actions = actions
        self.provisioning_state = None


class WebhookCreateParameters(Model):
    """The parameters for creating a webhook.

    All required parameters must be populated in order to send to Azure.

    :param tags: The tags for the webhook.
    :type tags: dict[str, str]
    :param location: Required. The location of the webhook. This cannot be
     changed after the resource is created.
    :type location: str
    :param service_uri: Required. The service URI for the webhook to post
     notifications.
    :type service_uri: str
    :param custom_headers: Custom headers that will be added to the webhook
     notifications.
    :type custom_headers: dict[str, str]
    :param status: The status of the webhook at the time the operation was
     called. Possible values include: 'enabled', 'disabled'
    :type status: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.WebhookStatus
    :param scope: The scope of repositories where the event can be triggered.
     For example, 'foo:*' means events for all tags under repository 'foo'.
     'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to
     'foo:latest'. Empty means all events.
    :type scope: str
    :param actions: Required. The list of actions that trigger the webhook to
     post notifications.
    :type actions: list[str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.WebhookAction]
    """

    _validation = {
        'location': {'required': True},
        'service_uri': {'required': True},
        'actions': {'required': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'service_uri': {'key': 'properties.serviceUri', 'type': 'str'},
        'custom_headers': {'key': 'properties.customHeaders', 'type': '{str}'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'actions': {'key': 'properties.actions', 'type': '[str]'},
    }

    def __init__(self, *, location: str, service_uri: str, actions, tags=None, custom_headers=None, status=None, scope: str=None, **kwargs) -> None:
        super(WebhookCreateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.location = location
        self.service_uri = service_uri
        self.custom_headers = custom_headers
        self.status = status
        self.scope = scope
        self.actions = actions


class WebhookUpdateParameters(Model):
    """The parameters for updating a webhook.

    :param tags: The tags for the webhook.
    :type tags: dict[str, str]
    :param service_uri: The service URI for the webhook to post notifications.
    :type service_uri: str
    :param custom_headers: Custom headers that will be added to the webhook
     notifications.
    :type custom_headers: dict[str, str]
    :param status: The status of the webhook at the time the operation was
     called. Possible values include: 'enabled', 'disabled'
    :type status: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.WebhookStatus
    :param scope: The scope of repositories where the event can be triggered.
     For example, 'foo:*' means events for all tags under repository 'foo'.
     'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to
     'foo:latest'. Empty means all events.
    :type scope: str
    :param actions: The list of actions that trigger the webhook to post
     notifications.
    :type actions: list[str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.WebhookAction]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'service_uri': {'key': 'properties.serviceUri', 'type': 'str'},
        'custom_headers': {'key': 'properties.customHeaders', 'type': '{str}'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'actions': {'key': 'properties.actions', 'type': '[str]'},
    }

    def __init__(self, *, tags=None, service_uri: str=None, custom_headers=None, status=None, scope: str=None, actions=None, **kwargs) -> None:
        super(WebhookUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.service_uri = service_uri
        self.custom_headers = custom_headers
        self.status = status
        self.scope = scope
        self.actions = actions
