/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.globalvariables;

import java.io.StringReader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;
import org.objectweb.proactive.utils.NamedThreadFactory;
import org.ow2.proactive.scheduler.common.job.JobVariable;
import org.ow2.proactive.scheduler.common.job.factories.globalvariables.Filter;
import org.ow2.proactive.scheduler.common.job.factories.globalvariables.GenericInformation;
import org.ow2.proactive.scheduler.common.job.factories.globalvariables.GlobalVariables;
import org.ow2.proactive.scheduler.common.job.factories.globalvariables.GlobalVariablesData;
import org.ow2.proactive.scheduler.common.util.Object2ByteConverter;
import org.ow2.proactive.scheduler.core.properties.PASchedulerProperties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class GlobalVariablesParser {
    public static final Logger logger = Logger.getLogger(GlobalVariablesParser.class);
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("GlobalVariablesParser", true));
    private static GlobalVariablesParser instance = null;
    private static String configurationPath = null;
    private List<Filter> loadedFilters = null;
    private String md5 = null;

    private GlobalVariablesParser() {
        if (configurationPath == null) {
            configurationPath = PASchedulerProperties.getAbsolutePath(PASchedulerProperties.GLOBAL_VARIABLES_CONFIGURATION.getValueAsString());
        }
    }

    public static synchronized void setConfigurationPath(String path) {
        configurationPath = path;
    }

    public static synchronized GlobalVariablesParser getInstance() {
        if (instance == null) {
            instance = new GlobalVariablesParser();
            instance.loadFilters();
            int refreshPeriod = PASchedulerProperties.GLOBAL_VARIABLES_REFRESH.getValueAsInt();
            GlobalVariablesParser.instance.scheduler.scheduleWithFixedDelay(() -> instance.loadFilters(), refreshPeriod, refreshPeriod, TimeUnit.MINUTES);
        }
        return instance;
    }

    public void reloadFilters() {
        instance.loadFilters();
    }

    public synchronized List<Filter> getLoadedFilters() {
        return this.loadedFilters;
    }

    public synchronized GlobalVariablesData getVariablesFor(String jobContent) {
        GlobalVariablesData answer = new GlobalVariablesData();
        LinkedHashMap<String, JobVariable> configuredVariables = new LinkedHashMap<String, JobVariable>();
        LinkedHashMap<String, String> configuredGenericInfo = new LinkedHashMap<String, String>();
        answer.setVariables(configuredVariables);
        answer.setGenericInformation(configuredGenericInfo);
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)"Error when configuring DocumentBuilder", (Throwable)e);
            return answer;
        }
        try (StringReader reader = new StringReader(jobContent);){
            InputSource inputSource = new InputSource(reader);
            Document xmlDocument = builder.parse(inputSource);
            XPath xPath = XPathFactory.newInstance().newXPath();
            for (Filter filter : this.loadedFilters) {
                boolean allMatch = true;
                for (String xpathExpression : filter.getXpath()) {
                    boolean valid = false;
                    try {
                        NodeList nodeList = (NodeList)xPath.compile(xpathExpression).evaluate(xmlDocument, XPathConstants.NODESET);
                        valid = nodeList.getLength() > 0;
                    }
                    catch (XPathExpressionException e) {
                        valid = (Boolean)xPath.compile(xpathExpression).evaluate(xmlDocument, XPathConstants.BOOLEAN);
                    }
                    allMatch = allMatch && valid;
                }
                if (!allMatch) continue;
                for (JobVariable variable : filter.getVariables()) {
                    configuredVariables.put(variable.getName(), variable);
                }
                for (GenericInformation info : filter.getGenericInformation()) {
                    configuredGenericInfo.put(info.getName(), info.getValue());
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error analysing workflow global variables", (Throwable)e);
        }
        return answer;
    }

    private synchronized void loadFilters() {
        this.loadedFilters = this.loadFilters(configurationPath);
        try {
            this.md5 = DigestUtils.md5Hex((byte[])Object2ByteConverter.convertObject2Byte(this.loadedFilters));
        }
        catch (Exception e) {
            logger.error((Object)"Could not compute MD5 of loaded filter", (Throwable)e);
            this.md5 = "INVALID";
        }
    }

    private List<Filter> loadFilters(String filePath) {
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = docBuilder.parse(filePath);
            Element varElement = document.getDocumentElement();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{GlobalVariables.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            JAXBElement loader = unmarshaller.unmarshal((Node)varElement, GlobalVariables.class);
            GlobalVariables inputFromXml = (GlobalVariables)loader.getValue();
            return inputFromXml.getFilters();
        }
        catch (Exception e) {
            logger.error((Object)"Error when parsing global variables configuration", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public synchronized String getMD5() {
        return this.md5;
    }
}

