/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model.factory;

import java.util.List;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.Converter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.IdentityConverter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ModelSyntaxException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.BaseParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.ModelType;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.CatalogObjectValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.Validator;
import org.springframework.expression.ParseException;

public class CatalogObjectParserValidator
extends BaseParserValidator<String> {
    protected static final String CATALOG_BASIC_MODEL_REGEXP = CatalogObjectParserValidator.ignoreCaseRegexp("CATALOG_OBJECT");
    protected static final String CATALOG_COMPLETE_REGEXP = String.format("^%s(%s)?$", CATALOG_BASIC_MODEL_REGEXP, "\\(([^)]*)\\)");

    public CatalogObjectParserValidator(String model) throws ModelSyntaxException {
        super(model, ModelType.CATALOG_OBJECT, CATALOG_COMPLETE_REGEXP);
    }

    @Override
    protected Converter<String> createConverter(String model) throws ModelSyntaxException {
        return new IdentityConverter();
    }

    @Override
    protected Validator<String> createValidator(String model, Converter<String> converter) throws ModelSyntaxException {
        List<String> parametersGroup = CatalogObjectParserValidator.parseAndGetRegexGroups(model, CATALOG_COMPLETE_REGEXP);
        if (parametersGroup.size() == 0) {
            try {
                return new CatalogObjectValidator();
            }
            catch (ParseException e) {
                throw new ModelSyntaxException(e.getMessage(), e);
            }
        }
        String parametersGroupString = parametersGroup.get(0).trim();
        String parameters = parametersGroupString.substring(1, parametersGroupString.length() - 1);
        String[] splitParameters = parameters.split(",");
        String kind = "";
        String contentType = "";
        if (splitParameters.length == 1) {
            kind = splitParameters[0].trim();
        } else if (splitParameters.length == 2) {
            kind = splitParameters[0].trim();
            contentType = splitParameters[1].trim();
        } else {
            throw new ModelSyntaxException(String.format("Illegal parameters format for the model [%s], the model CATALOG_OBJECT can have at most two parameters: kind and content type, split by comma.", model));
        }
        try {
            return new CatalogObjectValidator(kind, contentType);
        }
        catch (ParseException e) {
            throw new ModelSyntaxException(e.getMessage(), e);
        }
    }
}

