# -*- coding: utf-8 -*-
"""
著作權所有 (C) 民國103年 意傳文化科技
開發者：薛丞宏
網址：http://意傳.台灣
語料來源：請看各資料庫內說明

本程式乃自由軟體，您必須遵照SocialCalc設計的通用公共授權（Common Public Attribution License, CPAL)來修改和重新發佈這一程式，詳情請參閱條文。授權大略如下，若有歧異，以授權原文為主：
	１．得使用、修改、複製並發佈此程式碼，且必須以通用公共授權發行；
	２．任何以程式碼衍生的執行檔或網路服務，必須公開該程式碼；
	３．將此程式的原始碼當函式庫引用入商業軟體，且不需公開非關此函式庫的任何程式碼

此開放原始碼、共享軟體或說明文件之使用或散佈不負擔保責任，並拒絕負擔因使用上述軟體或說明文件所致任何及一切賠償責任或損害。

臺灣言語工具緣起於本土文化推廣與傳承，非常歡迎各界用於商業軟體，但希望在使用之餘，能夠提供建議、錯誤回報或修補，回饋給這塊土地。

感謝您的使用與推廣～～勞力！承蒙！
"""
from 臺灣言語工具.基本元素.公用變數 import 本調符號
from 臺灣言語工具.解析整理.字物件篩仔 import 字物件篩仔
from 臺灣言語工具.解析整理.解析錯誤 import 解析錯誤
from 臺灣言語工具.基本元素.章 import 章

class 閩南語變調:
	篩仔 = 字物件篩仔()
	
	實詞變調規則 = {'1':'7', '2':'1', '3':'2', '5':'7', '7':'3', '0':'0', '6':'3'}  # 6聲愛查
	def 變調(self, 物件):
		if isinstance(物件, 章):
			for 句物件 in 物件.內底句:
				self.變調(句物件)
			return
		字陣列 = self.篩仔.篩出字物件(物件)
		尾本調 = []
		有出現上尾字無 = False
		頂一个是本調記號 = False
		頂一个是斷詞點 = False
		for 字物件 in 字陣列[::-1]:
			if len(字物件.音) == 3:
				if not 有出現上尾字無 or\
						頂一个是本調記號 or\
						(頂一个是斷詞點 and 字物件.型 not in ['我', '你', '伊', '咱', '阮', '恁', '𪜶', ]):
					尾本調.append(False)
					有出現上尾字無 = True
				else:
					尾本調.append(True)
			else:
				尾本調.append(False)
			頂一个是本調記號 = False
			頂一个是斷詞點 = False
			if 字物件.型 == 本調符號:  # and 字物件.音==self.本調記號:
				頂一个是本調記號 = True
			if 字物件.型 in ['的', '是']:  # and 字物件.音==self.本調記號:
				頂一个是斷詞點 = True
		for 字物件, 愛變調無 in zip(字陣列, 尾本調[::-1]):
			if 愛變調無:
				字物件.音 = self.實詞變調(*字物件.音)
		return

	def 實詞變調(self, 聲, 韻, 調):
		if 韻.endswith('ʔ') or 韻.endswith('h'):
			if 調 == '4':
				調 = '2'
			elif 調 == '8':
				調 = '3'
			else:
				raise 解析錯誤('喉塞尾調錯誤！！{0}'.format((聲, 韻, 調)))
			韻 = 韻[:-1]
		elif 韻.endswith('p') or 韻.endswith('t') or 韻.endswith('k'):
			if 調 == '4':
				調 = '8'
			elif 調 == '8':
				調 = '10'
			else:
				raise 解析錯誤('入尾調錯誤！！{0}'.format((聲, 韻, 調)))
		else:
			if 調 in self.實詞變調規則:
				調 = self.實詞變調規則[調]
			else:
				raise 解析錯誤('非入調錯誤！！{0}'.format((聲, 韻, 調)))
		return (聲, 韻, 調)
