/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model.validator;

import java.io.Serializable;
import org.ow2.proactive.core.properties.PropertyDecrypter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.ModelValidatorContext;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ValidationException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.Validator;

public class EncryptionValidator
implements Validator<String> {
    @Override
    public String validate(String parameterValue, ModelValidatorContext context) throws ValidationException {
        if (parameterValue != null && parameterValue.startsWith("ENC(")) {
            try {
                PropertyDecrypter.decryptData((String)parameterValue);
            }
            catch (Exception e) {
                throw new ValidationException("Cannot decrypt value: " + parameterValue, e);
            }
        }
        if (parameterValue != null) {
            String encryptedValue;
            try {
                encryptedValue = PropertyDecrypter.encryptData((String)parameterValue);
            }
            catch (Exception e) {
                throw new ValidationException("Cannot encrypt value: " + parameterValue, e);
            }
            if (context.getSpELVariables() != null && context.getSpELVariables().getVariables() != null && context.getVariableName() != null) {
                context.getSpELVariables().getVariables().put(context.getVariableName(), (Serializable)((Object)encryptedValue));
            }
            return encryptedValue;
        }
        return parameterValue;
    }
}

