/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive_grid_cloud_portal.smartproxy;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import org.ow2.proactive.scheduler.common.exception.NotConnectedException;
import org.ow2.proactive.scheduler.common.exception.PermissionException;
import org.ow2.proactive.scheduler.rest.ds.IDataSpaceClient;
import org.ow2.proactive.scheduler.rest.ds.RemoteSource;
import org.ow2.proactive.scheduler.smartproxy.common.AwaitedJob;
import org.ow2.proactive.scheduler.smartproxy.common.AwaitedTask;
import org.ow2.proactive.scheduler.smartproxy.common.JobTracker;
import org.ow2.proactive_grid_cloud_portal.common.FileType;

public class RestJobTrackerImpl
extends JobTracker {
    private IDataSpaceClient restDataSpaceClient;

    public void setRestDataSpaceClient(IDataSpaceClient restDataSpaceClient) {
        this.restDataSpaceClient = restDataSpaceClient;
    }

    public void removeAwaitedJob(String id) {
        Path tmp;
        AwaitedJob aj = this.jobDatabase.getAwaitedJob(id);
        if (aj == null) {
            logger.warn((Object)("Job " + id + " not in the awaited list"));
            return;
        }
        logger.debug((Object)("Removing knowledge of job " + id));
        String pullUrl = aj.getPullURL();
        String pushUrl = aj.getPushURL();
        Path remotePullFolder = null;
        Path remotePushFolder = null;
        try {
            remotePullFolder = Paths.get(new URI(pullUrl));
            remotePushFolder = Paths.get(new URI(pushUrl));
        }
        catch (Exception e) {
            logger.error((Object)("Could not remove data for job " + id), (Throwable)e);
            return;
        }
        if (aj.isIsolateTaskOutputs() && (tmp = remotePullFolder.getParent()) != null) {
            remotePullFolder = tmp;
        }
        HashSet<Path> foldersToDelete = new HashSet<Path>();
        foldersToDelete.add(remotePullFolder.getParent());
        if (!remotePullFolder.getParent().equals(remotePushFolder.getParent())) {
            foldersToDelete.add(remotePushFolder.getParent());
        }
        RemoteSource remoteSource = new RemoteSource(IDataSpaceClient.Dataspace.USER);
        remoteSource.setType(FileType.FOLDER);
        for (Path path : foldersToDelete) {
            String location = path.toUri().toString();
            try {
                if (logger.isTraceEnabled()) continue;
                logger.debug((Object)("Deleting directory " + location));
                remoteSource.setPath(location);
                this.restDataSpaceClient.delete((IDataSpaceClient.IRemoteSource)remoteSource);
            }
            catch (NotConnectedException | PermissionException e) {
                logger.warn((Object)("Could not delete temporary files at location " + location + " ."), e);
            }
        }
        this.jobDatabase.removeAwaitedJob(id);
        try {
            this.jobDatabase.commit();
        }
        catch (IOException e) {
            logger.error((Object)("Could not save status file after removing job " + id), (Throwable)e);
        }
    }

    public void removeAwaitedTask(String id, String taskName) {
        AwaitedJob awaitedJob = this.jobDatabase.getAwaitedJob(id);
        if (awaitedJob == null) {
            logger.warn((Object)("Job " + id + " not in the awaited list"));
            return;
        }
        AwaitedTask awaitedTask = awaitedJob.getAwaitedTask(taskName);
        if (awaitedTask == null) {
            logger.warn((Object)("Task " + taskName + " from Job " + id + " not in the awaited list"));
            return;
        }
        logger.debug((Object)("Removing knowledge of task " + taskName + " from job " + id));
        if (awaitedJob.isIsolateTaskOutputs() && awaitedTask.getTaskId() != null) {
            String pullUrl = awaitedJob.getPullURL();
            pullUrl = pullUrl.replace("TASKID", "TASKID/" + awaitedTask.getTaskId());
            try {
                RemoteSource remoteSource = new RemoteSource(IDataSpaceClient.Dataspace.USER, pullUrl + "/");
                remoteSource.setType(FileType.FOLDER);
                this.restDataSpaceClient.delete((IDataSpaceClient.IRemoteSource)remoteSource);
            }
            catch (Throwable t) {
                logger.warn((Object)("Could not remove data for task " + taskName + " of job " + id), t);
            }
        }
        awaitedJob.removeAwaitedTask(taskName);
        if (awaitedJob.getAwaitedTasks().isEmpty()) {
            this.removeAwaitedJob(id);
            return;
        }
        this.jobDatabase.putAwaitedJob(id, awaitedJob);
        try {
            this.jobDatabase.commit();
        }
        catch (IOException e) {
            logger.error((Object)("Could not save status file after removing task Task " + taskName + " from Job" + id), (Throwable)e);
        }
    }
}

