# -*- coding: utf-8 -*-
import re
import ast

from setuptools import setup, find_packages


_version_re = re.compile(r'__version__\s+=\s+(.*)')
with open('mygeotab/__init__.py', 'rb') as f:
    version = str(ast.literal_eval(_version_re.search(
        f.read().decode('utf-8')).group(1)))

setup(
    name='mygeotab',
    author='Aaron Toth',
    version=version,
    url='https://github.com/aaront/mygeotab',
    description='An unofficial Python client for the MyGeotab API',
    long_description=open('README.rst').read(),
    install_requires=[
        'requests>=2.6',
        'click>=3.3',
        'pytz>=2014.7'
    ],
    extras_require={
        'ipy': ['ipython']
    },
    test_suite="tests",
    include_package_data=True,
    packages=find_packages(),
    package_data={'': ['LICENSE']},
    package_dir={'mygeotab': 'mygeotab'},
    license='Apache 2.0',
    entry_points='''
        [console_scripts]
        myg=mygeotab.cli:main
    ''',
    classifiers=(
        'Development Status :: 3 - Alpha',
        'Intended Audience :: Developers',
        'Natural Language :: English',
        'License :: OSI Approved :: Apache Software License',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.3',
        'Programming Language :: Python :: 3.4',
        'Topic :: Software Development :: Libraries'
    ),
)